diff -pruN 11.1.0-1/AUTHORS 11.2.0-1/AUTHORS
--- 11.1.0-1/AUTHORS	2025-03-03 12:42:22.000000000 +0000
+++ 11.2.0-1/AUTHORS	2025-04-01 10:03:43.000000000 +0000
@@ -91,6 +91,7 @@ The individual contributors are
    Serge E. Hallyn <serge.hallyn@canonical.com>
    Sergei Turchanov <turchanov@farpost.com>
    Stefan Berger <stefanb@us.ibm.com>
+   SuhailAhmedVelorum <suhailahmedvelorum@gmail.com>
    Taizo ITO <taizo.ito@hde.co.jp>
    Taku Izumi <izumi.taku@jp.fujitsu.com>
    Tomoki Sekiyama <tomoki.sekiyama@hds.com>
diff -pruN 11.1.0-1/ChangeLog 11.2.0-1/ChangeLog
--- 11.1.0-1/ChangeLog	2025-03-03 12:42:22.000000000 +0000
+++ 11.2.0-1/ChangeLog	2025-04-01 10:03:43.000000000 +0000
@@ -1,3 +1,45 @@
+ 2025- 3- 26 SuhailAhmedVelorum <suhailahmedvelorum@gmail.com>
+    
+    Fixed minor typo in libvirt-override.py::openAuth TODO item
+    
+    
+ 2025- 3- 25 Michal Privoznik <mprivozn@redhat.com>
+    
+    Add support for domain NIC MAC address change event
+    
+    
+ 2025- 3- 21 Michal Privoznik <mprivozn@redhat.com>
+    
+    override: domain: Implement override for virDomainSetThrottleGroup()
+    The bindings generator can't generate proper bindings for
+    virDomainSetThrottleGroup() (because of typed parameters in the
+    arguments) so implement it manually.
+    
+    
+    
+ 2025- 3- 21 Michal Privoznik <mprivozn@redhat.com>
+    
+    override: domain: Implement override for virDomainGetAutostartOnce()
+    The bindings generator can't generate proper bindings for
+    virDomainGetAutostartOnce() (because of int* in the arguments) so
+    implement it manually.
+    
+    
+    
+ 2025- 3- 21 Michal Privoznik <mprivozn@redhat.com>
+    
+    Modernize typed parameter fetching in libvirt_virDomainSetBlockIoTune()
+    Instead of fetching supported tunables and passing only those to
+    the API (effectively ignoring unsupported ones), pass all
+    tunables or error out on unsupported ones.
+    
+    
+    
+ 2025- 3- 3 Jiri Denemark <jdenemar@redhat.com>
+    
+    Post-release version bump to 11.2.0
+    
+    
  2025- 2- 17 Pavel Hrdina <phrdina@redhat.com>
     
     ci: refresh with 'lcitool manifest'
diff -pruN 11.1.0-1/PKG-INFO 11.2.0-1/PKG-INFO
--- 11.1.0-1/PKG-INFO	2025-03-03 12:42:22.981913300 +0000
+++ 11.2.0-1/PKG-INFO	2025-04-01 10:03:43.700204100 +0000
@@ -1,6 +1,6 @@
 Metadata-Version: 2.1
 Name: libvirt-python
-Version: 11.1.0
+Version: 11.2.0
 Summary: The libvirt virtualization API python binding
 Home-page: http://www.libvirt.org
 Maintainer: Libvirt Maintainers
diff -pruN 11.1.0-1/VERSION 11.2.0-1/VERSION
--- 11.1.0-1/VERSION	2025-03-03 12:42:21.000000000 +0000
+++ 11.2.0-1/VERSION	2025-04-01 10:03:42.000000000 +0000
@@ -1 +1 @@
-11.1.0
+11.2.0
diff -pruN 11.1.0-1/debian/changelog 11.2.0-1/debian/changelog
--- 11.1.0-1/debian/changelog	2025-03-07 06:23:38.000000000 +0000
+++ 11.2.0-1/debian/changelog	2025-04-05 05:09:17.000000000 +0000
@@ -1,3 +1,9 @@
+libvirt-python (11.2.0-1) unstable; urgency=medium
+
+  * New upstream version 11.2.0
+
+ -- Pino Toscano <pino@debian.org>  Sat, 05 Apr 2025 07:09:17 +0200
+
 libvirt-python (11.1.0-1) unstable; urgency=medium
 
   * New upstream version 11.1.0
diff -pruN 11.1.0-1/examples/event-test.py 11.2.0-1/examples/event-test.py
--- 11.1.0-1/examples/event-test.py	2024-04-25 07:15:15.000000000 +0000
+++ 11.2.0-1/examples/event-test.py	2025-04-01 10:03:42.000000000 +0000
@@ -648,6 +648,10 @@ def myDomainEventMemoryDeviceSizeChangeC
     print("myDomainEventMemoryDeviceSizeChangeCallback: Domain %s(%s) memory device size change alias %s size %d" % (
         dom.name(), dom.ID(), alias, size))
 
+def myDomainEventNICMACChangeCallback(conn: libvirt.virConnect, dom: libvirt.virDomain, alias: str, oldMAC: str, newMAC: str, opaque: _T) -> None:
+    print("myDomainEventNICMACChangeCallback: Domain %s(%s) NIC MAC change alias %s old MAC: %s new MAC: %s" % (
+        dom.name(), dom.ID(), alias, oldMAC, newMAC))
+
 
 ##########################################################################
 # Network events
@@ -806,6 +810,7 @@ def main() -> None:
         vc.domainEventRegisterAny(None, libvirt.VIR_DOMAIN_EVENT_ID_BLOCK_THRESHOLD, myDomainEventBlockThresholdCallback, None),
         vc.domainEventRegisterAny(None, libvirt.VIR_DOMAIN_EVENT_ID_MEMORY_FAILURE, myDomainEventMemoryFailureCallback, None),
         vc.domainEventRegisterAny(None, libvirt.VIR_DOMAIN_EVENT_ID_MEMORY_DEVICE_SIZE_CHANGE, myDomainEventMemoryDeviceSizeChangeCallback, None),
+        vc.domainEventRegisterAny(None, libvirt.VIR_DOMAIN_EVENT_ID_NIC_MAC_CHANGE, myDomainEventNICMACChangeCallback, None),
     ]
 
     netcallbacks = [
diff -pruN 11.1.0-1/generator.py 11.2.0-1/generator.py
--- 11.1.0-1/generator.py	2024-05-13 13:29:56.000000000 +0000
+++ 11.2.0-1/generator.py	2025-04-01 10:03:42.000000000 +0000
@@ -440,6 +440,8 @@ skip_impl = {
     'virNodeDeviceGetAutostart',
     'virDomainSaveParams',
     'virDomainRestoreParams',
+    'virDomainGetAutostartOnce',
+    'virDomainSetThrottleGroup',
 
     'virDomainLxcOpenNamespace',
 
diff -pruN 11.1.0-1/libvirt-override-api.xml 11.2.0-1/libvirt-override-api.xml
--- 11.1.0-1/libvirt-override-api.xml	2024-04-25 07:15:15.000000000 +0000
+++ 11.2.0-1/libvirt-override-api.xml	2025-04-01 10:03:42.000000000 +0000
@@ -866,5 +866,18 @@
       <arg name='params' type='virTypedParameterPtr' info='pointer to save parameter objects'/>
       <arg name='flags'  type='int' info='an OR&apos;ed set of virDomainSaveRestoreFlags'/>
     </function>
+    <function name='virDomainGetAutostartOnce' file='python'>
+      <info>Provides a boolean value indicating whether the domain is configured to be automatically started the next time the host machine boots only.</info>
+      <return type='int' info='the autostart flag, or None in case of error'/>
+      <arg name='domain' type='virDomainPtr' info='a network object'/>
+    </function>
+    <function name='virDomainSetThrottleGroup' file='python'>
+      <info>Add throttlegroup or change all of the throttlegroup options within specific domain.</info>
+      <return type='int' info='0 in case of success and -1 in case of failure'/>
+      <arg name='domain' type='virDomainPtr' info='pointer to domain object'/>
+      <arg name='group' type='const char *' info='throttle group name'/>
+      <arg name='params' type='virTypedParameterPtr' info='pointer to blkio parameter objects'/>
+      <arg name='flags'  type='int' info='an OR&apos;ed set of virDomainModificationImpact'/>
+    </function>
   </symbols>
 </api>
diff -pruN 11.1.0-1/libvirt-override-virConnect.py 11.2.0-1/libvirt-override-virConnect.py
--- 11.1.0-1/libvirt-override-virConnect.py	2024-04-25 07:15:15.000000000 +0000
+++ 11.2.0-1/libvirt-override-virConnect.py	2025-04-01 10:03:42.000000000 +0000
@@ -279,6 +279,15 @@
         cb(self, virDomain(self, _obj=dom), alias, size, opaque)
         return 0
 
+    def _dispatchDomainEventNICMACChangeCallback(self, dom: 'virDomain', alias: str, oldMAC: str, newMAC: str, cbData: Dict[str, Any]) -> int:
+        """Dispatches event to python user domain NIC MAC change event callbacks
+        """
+        cb = cbData["cb"]
+        opaque = cbData["opaque"]
+
+        cb(self, virDomain(self, _obj=dom), alias, oldMAC, newMAC, opaque)
+        return 0
+
     def domainEventDeregisterAny(self, callbackID: int) -> None:
         """Removes a Domain Event Callback. De-registering for a
            domain callback will disable delivery of this event type """
diff -pruN 11.1.0-1/libvirt-override.c 11.2.0-1/libvirt-override.c
--- 11.1.0-1/libvirt-override.c	2024-05-13 13:29:56.000000000 +0000
+++ 11.2.0-1/libvirt-override.c	2025-04-01 10:03:42.000000000 +0000
@@ -5040,78 +5040,74 @@ libvirt_virDomainGetBlockJobInfo(PyObjec
     return NULL;
 }
 
+static virPyTypedParamsHint virPyDomainSetBlockIoTuneParams[] = {
+    { VIR_DOMAIN_BLOCK_IOTUNE_TOTAL_BYTES_SEC, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_READ_BYTES_SEC, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_WRITE_BYTES_SEC, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_TOTAL_IOPS_SEC, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_READ_IOPS_SEC, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_WRITE_IOPS_SEC, VIR_TYPED_PARAM_ULLONG },
+#if LIBVIR_CHECK_VERSION(1, 2, 11)
+    { VIR_DOMAIN_BLOCK_IOTUNE_TOTAL_BYTES_SEC_MAX, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_READ_BYTES_SEC_MAX, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_WRITE_BYTES_SEC_MAX, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_TOTAL_IOPS_SEC_MAX, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_READ_IOPS_SEC_MAX, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_WRITE_IOPS_SEC_MAX, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_SIZE_IOPS_SEC, VIR_TYPED_PARAM_ULLONG },
+#endif /* LIBVIR_CHECK_VERSION(1, 2, 11)  */
+#if LIBVIR_CHECK_VERSION(2, 4, 0)
+    { VIR_DOMAIN_BLOCK_IOTUNE_TOTAL_BYTES_SEC_MAX_LENGTH, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_READ_BYTES_SEC_MAX_LENGTH, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_WRITE_BYTES_SEC_MAX_LENGTH, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_TOTAL_IOPS_SEC_MAX_LENGTH, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_READ_IOPS_SEC_MAX_LENGTH, VIR_TYPED_PARAM_ULLONG },
+    { VIR_DOMAIN_BLOCK_IOTUNE_WRITE_IOPS_SEC_MAX_LENGTH, VIR_TYPED_PARAM_ULLONG },
+#endif /* LIBVIR_CHECK_VERSION(2, 4, 0)  */
+#if LIBVIR_CHECK_VERSION(3, 0, 0)
+    { VIR_DOMAIN_BLOCK_IOTUNE_GROUP_NAME, VIR_TYPED_PARAM_STRING },
+#endif /* LIBVIR_CHECK_VERSION(3, 0, 0) */
+};
+
+
 static PyObject *
 libvirt_virDomainSetBlockIoTune(PyObject *self ATTRIBUTE_UNUSED,
                                 PyObject *args)
 {
     virDomainPtr domain;
-    PyObject *pyobj_domain, *info;
-    PyObject *ret = NULL;
-    int i_retval;
+    PyObject *pyobj_domain = NULL;
+    PyObject *pyobj_dict = NULL;
+    virTypedParameterPtr params = NULL;
     int nparams = 0;
-    Py_ssize_t size = 0;
+    int c_retval;
     const char *disk;
     unsigned int flags;
-    virTypedParameterPtr params = NULL, new_params = NULL;
 
     if (!PyArg_ParseTuple(args, (char *)"OzOI:virDomainSetBlockIoTune",
-                          &pyobj_domain, &disk, &info, &flags))
-        return NULL;
-    domain = (virDomainPtr) PyvirDomain_Get(pyobj_domain);
-
-    if ((size = PyDict_Size(info)) < 0)
+                          &pyobj_domain, &disk, &pyobj_dict, &flags))
         return NULL;
 
-    if (size == 0) {
-        PyErr_Format(PyExc_LookupError,
+    if (PyDict_Check(pyobj_dict)) {
+        if (virPyDictToTypedParams(pyobj_dict, &params, &nparams,
+                                   virPyDomainSetBlockIoTuneParams,
+                                   VIR_N_ELEMENTS(virPyDomainSetBlockIoTuneParams)) < 0) {
+            return NULL;
+        }
+    } else {
+        PyErr_Format(PyExc_TypeError,
                      "Need non-empty dictionary to set attributes");
         return NULL;
     }
+    domain = (virDomainPtr) PyvirDomain_Get(pyobj_domain);
 
-    LIBVIRT_BEGIN_ALLOW_THREADS;
-    i_retval = virDomainGetBlockIoTune(domain, disk, NULL, &nparams, flags);
-    LIBVIRT_END_ALLOW_THREADS;
-
-    if (i_retval < 0)
-        return VIR_PY_INT_FAIL;
-
-    if (nparams == 0) {
-        PyErr_Format(PyExc_LookupError,
-                     "Domain has no settable attributes");
-        return NULL;
-    }
-
-    if (VIR_ALLOC_N(params, nparams) < 0)
-        return PyErr_NoMemory();
-
-    LIBVIRT_BEGIN_ALLOW_THREADS;
-    i_retval = virDomainGetBlockIoTune(domain, disk, params, &nparams, flags);
-    LIBVIRT_END_ALLOW_THREADS;
-
-    if (i_retval < 0) {
-        ret = VIR_PY_INT_FAIL;
-        goto cleanup;
-    }
-
-    new_params = setPyVirTypedParameter(info, params, nparams);
-    if (!new_params)
-        goto cleanup;
 
     LIBVIRT_BEGIN_ALLOW_THREADS;
-    i_retval = virDomainSetBlockIoTune(domain, disk, new_params, size, flags);
+    c_retval = virDomainSetBlockIoTune(domain, disk, params, nparams, flags);
     LIBVIRT_END_ALLOW_THREADS;
 
-    if (i_retval < 0) {
-        ret = VIR_PY_INT_FAIL;
-        goto cleanup;
-    }
-
-    ret = VIR_PY_INT_SUCCESS;
-
- cleanup:
     virTypedParamsFree(params, nparams);
-    virTypedParamsFree(new_params, size);
-    return ret;
+
+    return libvirt_intWrap(c_retval);
 }
 
 static PyObject *
@@ -7399,6 +7395,62 @@ libvirt_virConnectDomainEventMemoryDevic
 #endif /* VIR_DOMAIN_EVENT_ID_MEMORY_DEVICE_SIZE_CHANGE */
 
 
+#ifdef VIR_DOMAIN_EVENT_ID_NIC_MAC_CHANGE
+static int
+libvirt_virConnectDomainEventNICMACChangeCallback(virConnectPtr conn ATTRIBUTE_UNUSED,
+                                                  virDomainPtr dom,
+                                                  const char *alias,
+                                                  const char *oldMAC,
+                                                  const char *newMAC,
+                                                  void *opaque)
+{
+    PyObject *pyobj_cbData = (PyObject*)opaque;
+    PyObject *pyobj_dom;
+    PyObject *pyobj_ret = NULL;
+    PyObject *pyobj_conn;
+    PyObject *dictKey;
+    int ret = -1;
+
+    LIBVIRT_ENSURE_THREAD_STATE;
+
+    if (!(dictKey = libvirt_constcharPtrWrap("conn")))
+        goto cleanup;
+    pyobj_conn = PyDict_GetItem(pyobj_cbData, dictKey);
+    Py_DECREF(dictKey);
+
+    /* Create a python instance of this virDomainPtr */
+    virDomainRef(dom);
+    if (!(pyobj_dom = libvirt_virDomainPtrWrap(dom))) {
+        virDomainFree(dom);
+        goto cleanup;
+    }
+    Py_INCREF(pyobj_cbData);
+
+    /* Call the Callback Dispatcher */
+    pyobj_ret = PyObject_CallMethod(pyobj_conn,
+                                    (char*)"_dispatchDomainEventNICMACChangeCallback",
+                                    (char*)"OsssO",
+                                    pyobj_dom, alias, oldMAC, newMAC,
+                                    pyobj_cbData);
+
+    Py_DECREF(pyobj_cbData);
+    Py_DECREF(pyobj_dom);
+
+ cleanup:
+    if (!pyobj_ret) {
+        DEBUG("%s - ret:%p\n", __FUNCTION__, pyobj_ret);
+        PyErr_Print();
+    } else {
+        Py_DECREF(pyobj_ret);
+        ret = 0;
+    }
+
+    LIBVIRT_RELEASE_THREAD_STATE;
+    return ret;
+}
+#endif /* VIR_DOMAIN_EVENT_ID_NIC_MAC_CHANGE */
+
+
 static PyObject *
 libvirt_virConnectDomainEventRegisterAny(PyObject *self ATTRIBUTE_UNUSED,
                                          PyObject *args)
@@ -7534,6 +7586,11 @@ libvirt_virConnectDomainEventRegisterAny
         cb = VIR_DOMAIN_EVENT_CALLBACK(libvirt_virConnectDomainEventMemoryDeviceSizeChangeCallback);
         break;
 #endif /* VIR_DOMAIN_EVENT_ID_MEMORY_DEVICE_SIZE_CHANGE */
+#ifdef VIR_DOMAIN_EVENT_ID_NIC_MAC_CHANGE
+    case VIR_DOMAIN_EVENT_ID_NIC_MAC_CHANGE:
+        cb = VIR_DOMAIN_EVENT_CALLBACK(libvirt_virConnectDomainEventNICMACChangeCallback);
+        break;
+#endif /* VIR_DOMAIN_EVENT_ID_NIC_MAC_CHANGE */
     case VIR_DOMAIN_EVENT_ID_LAST:
         break;
     }
@@ -10917,6 +10974,72 @@ libvirt_virDomainFDAssociate(PyObject *s
 #endif /* LIBVIR_CHECK_VERSION(9, 0, 0) */
 
 
+#if LIBVIR_CHECK_VERSION(11, 2, 0)
+static PyObject *
+libvirt_virDomainGetAutostartOnce(PyObject *self ATTRIBUTE_UNUSED,
+                                  PyObject *args)
+{
+    int c_retval, autostart;
+    virDomainPtr domain;
+    PyObject *pyobj_domain;
+
+    if (!PyArg_ParseTuple(args, (char *)"O:virDomainGetAutostartOnce",
+                          &pyobj_domain))
+        return NULL;
+
+    domain = (virDomainPtr) PyvirDomain_Get(pyobj_domain);
+
+    LIBVIRT_BEGIN_ALLOW_THREADS;
+    c_retval = virDomainGetAutostartOnce(domain, &autostart);
+    LIBVIRT_END_ALLOW_THREADS;
+
+    if (c_retval < 0)
+        return VIR_PY_INT_FAIL;
+
+    return libvirt_intWrap(autostart);
+}
+
+static PyObject *
+libvirt_virDomainSetThrottleGroup(PyObject *self ATTRIBUTE_UNUSED,
+                                  PyObject *args)
+{
+    virDomainPtr domain;
+    PyObject *pyobj_domain;
+    const char *group = NULL;
+    PyObject *pyobj_dict = NULL;
+    virTypedParameterPtr params = NULL;
+    int nparams = 0;
+    unsigned int flags = 0;
+    int c_retval;
+
+    if (!PyArg_ParseTuple(args, (char *)"OsO|I:virDomainSetThrottleGroup",
+                          &pyobj_domain, &group, &pyobj_dict, &flags))
+        return NULL;
+
+    domain = (virDomainPtr) PyvirDomain_Get(pyobj_domain);
+
+    if (PyDict_Check(pyobj_dict)) {
+        if (virPyDictToTypedParams(pyobj_dict, &params, &nparams,
+                                   virPyDomainSetBlockIoTuneParams,
+                                   VIR_N_ELEMENTS(virPyDomainSetBlockIoTuneParams)) < 0) {
+            return NULL;
+        }
+    } else {
+        PyErr_Format(PyExc_TypeError, "Restore params must be a dictionary");
+        return NULL;
+    }
+
+
+    LIBVIRT_BEGIN_ALLOW_THREADS;
+    c_retval = virDomainSetThrottleGroup(domain, group, params, nparams, flags);
+    LIBVIRT_END_ALLOW_THREADS;
+
+    virTypedParamsFree(params, nparams);
+
+    return libvirt_intWrap(c_retval);
+}
+#endif /* LIBVIR_CHECK_VERSION(11, 2, 0) */
+
 
 /************************************************************************
  *									*
@@ -11202,6 +11325,10 @@ static PyMethodDef libvirtMethods[] = {
 #if LIBVIR_CHECK_VERSION(9, 0, 0)
     {(char *) "virDomainFDAssociate", libvirt_virDomainFDAssociate, METH_VARARGS, NULL},
 #endif /* LIBVIR_CHECK_VERSION(9, 0, 0) */
+#if LIBVIR_CHECK_VERSION(11, 2, 0)
+    {(char *) "virDomainGetAutostartOnce", libvirt_virDomainGetAutostartOnce, METH_VARARGS, NULL},
+    {(char *) "virDomainSetThrottleGroup", libvirt_virDomainSetThrottleGroup, METH_VARARGS, NULL},
+#endif /* LIBVIR_CHECK_VERSION(11, 2, 0) */
     {NULL, NULL, 0, NULL}
 };
 
diff -pruN 11.1.0-1/libvirt-override.py 11.2.0-1/libvirt-override.py
--- 11.1.0-1/libvirt-override.py	2024-04-25 07:15:15.000000000 +0000
+++ 11.2.0-1/libvirt-override.py	2025-04-01 10:03:42.000000000 +0000
@@ -91,7 +91,7 @@ def registerErrorHandler(f: Callable[[_T
 
 
 def openAuth(uri: str, auth: List, flags: int = 0) -> 'virConnect':
-    # TODO: The C code rquires a List and there is not *Mutable*Tuple for a better description such as
+    # TODO: The C code requires a List and there is not *Mutable*Tuple for a better description such as
     # auth: Tuple[List[int], Callable[[List[MutableTuple[int, str, str, str, Any]], _T], int], _T]
     """
     This function should be called first to get a connection to the
diff -pruN 11.1.0-1/libvirt-python.spec 11.2.0-1/libvirt-python.spec
--- 11.1.0-1/libvirt-python.spec	2025-03-03 12:42:22.000000000 +0000
+++ 11.2.0-1/libvirt-python.spec	2025-04-01 10:03:43.000000000 +0000
@@ -14,7 +14,7 @@
 
 Summary: The libvirt virtualization API python3 binding
 Name: libvirt-python
-Version: 11.1.0
+Version: 11.2.0
 Release: 1%{?dist}
 Source0: https://libvirt.org/sources/python/%{name}-%{version}.tar.gz
 Url: https://libvirt.org
