diff -pruN 1:2.33-1/CHANGES 1:2.35-1/CHANGES
--- 1:2.33-1/CHANGES	2024-09-17 19:29:46.000000000 +0000
+++ 1:2.35-1/CHANGES	2024-12-20 09:20:07.000000000 +0000
@@ -1,3 +1,11 @@
+2.35 2024-12-20
+- be more careful with datatypes (https://github.com/PDLPorters/pdl/issues/511)
+
+2.34 2024-11-25
+- minimum Perl 5.10.1
+- add PGPLOT::set_debugging
+- move PDL::Graphics::State to this distro
+
 2.33 2024-09-17
 - fix ramp and rgb LUTs (and neg to be compatible) to always increase values (#16) - thanks @d-lamb
 
diff -pruN 1:2.33-1/MANIFEST 1:2.35-1/MANIFEST
--- 1:2.33-1/MANIFEST	2024-09-17 19:30:37.000000000 +0000
+++ 1:2.35-1/MANIFEST	2024-12-20 09:20:52.000000000 +0000
@@ -69,6 +69,7 @@ lib/PDL/Graphics/LUT/tables/standard.fit
 lib/PDL/Graphics/PGPLOT.pm
 lib/PDL/Graphics/PGPLOT/Window.pm
 lib/PDL/Graphics/PGPLOTOptions.pm
+lib/PDL/Graphics/State.pm
 lib/PGPLOT.pm
 LICENSE
 Makefile.PL
diff -pruN 1:2.33-1/META.json 1:2.35-1/META.json
--- 1:2.33-1/META.json	2024-09-17 19:30:37.000000000 +0000
+++ 1:2.35-1/META.json	2024-12-20 09:20:52.000000000 +0000
@@ -40,7 +40,9 @@
          "recommends" : {
             "PDL" : "2.089"
          },
-         "requires" : {}
+         "requires" : {
+            "perl" : "5.010001"
+         }
       },
       "test" : {
          "requires" : {
@@ -59,7 +61,7 @@
          "web" : "https://github.com/PDLPorters/perl5-PGPLOT"
       }
    },
-   "version" : "2.33",
+   "version" : "2.35",
    "x_IRC" : "irc://irc.perl.org/#pdl",
    "x_serialization_backend" : "JSON::PP version 4.04"
 }
diff -pruN 1:2.33-1/META.yml 1:2.35-1/META.yml
--- 1:2.33-1/META.yml	2024-09-17 19:30:37.000000000 +0000
+++ 1:2.35-1/META.yml	2024-12-20 09:20:52.000000000 +0000
@@ -21,10 +21,11 @@ no_index:
     - inc
 recommends:
   PDL: '2.089'
-requires: {}
+requires:
+  perl: '5.010001'
 resources:
   bugtracker: https://github.com/PDLPorters/perl5-PGPLOT/issues
   repository: git://github.com/PDLPorters/perl5-PGPLOT.git
-version: '2.33'
+version: '2.35'
 x_IRC: irc://irc.perl.org/#pdl
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
diff -pruN 1:2.33-1/Makefile.PL 1:2.35-1/Makefile.PL
--- 1:2.33-1/Makefile.PL	2024-08-18 17:31:21.000000000 +0000
+++ 1:2.35-1/Makefile.PL	2024-10-07 01:23:40.000000000 +0000
@@ -259,6 +259,7 @@ for my $opt_dep (sort keys %min_version)
 
 WriteMakefile(
     'NAME'	=> 'PGPLOT',
+    MIN_PERL_VERSION => '5.010001',
     'CONFIGURE_REQUIRES' => { 'ExtUtils::F77' => 1.13, 'Devel::CheckLib' => '1.14' },
     'TEST_REQUIRES' => { 'Test::More' => '0.88' },
     PREREQ_PM => { @prereq },
diff -pruN 1:2.33-1/PGPLOT.xs 1:2.35-1/PGPLOT.xs
--- 1:2.33-1/PGPLOT.xs	2024-03-24 18:38:00.000000000 +0000
+++ 1:2.35-1/PGPLOT.xs	2024-10-07 01:35:02.000000000 +0000
@@ -27,6 +27,13 @@ static char strbuff[256];
 static char strbuff2[256];
 #define SIZEOF(X) sizeof(strbuff)
 
+static IV pgplot_debugging=0;
+
+#define DEBUG_PRINT(c) do { \
+    if (pgplot_debugging < 1) break; \
+    fprintf(stderr, "PGPLOT::" #c "\n"); \
+  } while (0)
+
 void MAIN__ () {
    /* Cheat to define MAIN__ symbol */
    croak("This should never happen");
@@ -56,6 +63,15 @@ PGPLOT_function_handle myPGPLOT_handle;
 
 MODULE = PGPLOT     PACKAGE = PGPLOT
 
+IV
+set_debugging(i)
+  IV i;
+CODE:
+  RETVAL = pgplot_debugging;
+  pgplot_debugging = i;
+OUTPUT:
+  RETVAL
+
 void
 pgarro(x1,y1,x2,y2)
   float	x1
@@ -63,6 +79,7 @@ pgarro(x1,y1,x2,y2)
   float	x2
   float	y2
   CODE:
+    DEBUG_PRINT(pgarro);
     cpgarro(x1,y1,x2,y2);
 
 
@@ -70,6 +87,7 @@ void
 pgask(flag)
   Logical	flag
   CODE:
+    DEBUG_PRINT(pgask);
     cpgask(flag);
 
 void
@@ -89,6 +107,7 @@ pgaxis(opt,x1,y1,x2,y2,v1,v2,step,nsub,d
   float	disp
   float	orient
   CODE:
+    DEBUG_PRINT(pgaxis);
     cpgaxis(opt,x1,y1,x2,y2,v1,v2,step,nsub,dmajl,dmajr,fmin,disp,orient);
 
 
@@ -103,6 +122,7 @@ pgband(mode,posn,xref,yref,x,y,ch)
   float	y = NO_INIT
   char	ch = NO_INIT
   CODE:
+    DEBUG_PRINT(pgband);
     RETVAL = cpgband(mode,posn,xref,yref,&x,&y,&ch);
   OUTPUT:
   x
@@ -114,6 +134,7 @@ pgband(mode,posn,xref,yref,x,y,ch)
 void
 pgbbuf()
   CODE:
+    DEBUG_PRINT(pgbbuf);
     cpgbbuf();
 
 
@@ -124,6 +145,7 @@ pgbeg(unit,file,nxsub,nysub)
   int	nxsub
   int	nysub
   CODE:
+    DEBUG_PRINT(pgbeg);
     RETVAL = cpgbeg(unit,file,nxsub,nysub);
   OUTPUT:
   RETVAL
@@ -136,6 +158,7 @@ pgbegin(unit,file,nxsub,nysub)
   int	nxsub
   int	nysub
   CODE:
+    DEBUG_PRINT(pgbegin);
     RETVAL = cpgbeg(unit,file,nxsub,nysub);
   OUTPUT:
   RETVAL
@@ -148,6 +171,7 @@ pgbin(nbin,x,data,center)
   float *	data
   Logical	center
   CODE:
+    DEBUG_PRINT(pgbin);
     cpgbin(nbin,x,data,center);
 
 
@@ -160,6 +184,7 @@ pgbox(xopt,xtick,nxsub,yopt,ytick,nysub)
   float	ytick
   int	nysub
   CODE:
+    DEBUG_PRINT(pgbox);
     cpgbox(xopt,xtick,nxsub,yopt,ytick,nysub);
 
 
@@ -169,12 +194,14 @@ pgcirc(xcent,ycent,radius)
   float	ycent
   float	radius
   CODE:
+    DEBUG_PRINT(pgcirc);
     cpgcirc(xcent,ycent,radius);
 
 
 void
 pgclos()
   CODE:
+    DEBUG_PRINT(pgclos);
     cpgclos();
 
 void
@@ -191,6 +218,7 @@ pgconb(a,idim,jdim,i1,i2,j1,j2,c,nc,tr,b
   float *	tr
   float	blank
   CODE:
+    DEBUG_PRINT(pgconb);
     cpgconb(a,idim,jdim,i1,i2,j1,j2,c,nc,tr,blank);
 
 
@@ -207,6 +235,7 @@ pgconf(a,idim,jdim,i1,i2,j1,j2,c1,c2,tr)
   float	c2
   float *	tr
   CODE:
+    DEBUG_PRINT(pgconf);
     cpgconf(a,idim,jdim,i1,i2,j1,j2,c1,c2,tr);
 
 void
@@ -224,6 +253,7 @@ pgconl(a,idim,jdim,i1,i2,j1,j2,c,tr,labe
   int	intval
   int	minint
   CODE:
+    DEBUG_PRINT(pgconl);
     cpgconl(a,idim,jdim,i1,i2,j1,j2,c,tr,label,intval,minint);
 
 
@@ -240,6 +270,7 @@ pgcons(a,idim,jdim,i1,i2,j1,j2,c,nc,tr)
   int	nc
   float *	tr
   CODE:
+    DEBUG_PRINT(pgcons);
     cpgcons(a,idim,jdim,i1,i2,j1,j2,c,nc,tr);
 
 
@@ -256,6 +287,7 @@ pgcont(a,idim,jdim,i1,i2,j1,j2,c,nc,tr)
   int	nc
   float *	tr
   CODE:
+    DEBUG_PRINT(pgcont);
     cpgcont(a,idim,jdim,i1,i2,j1,j2,c,nc,tr);
 
 
@@ -272,6 +304,7 @@ pgconx(a,idim,jdim,i1,i2,j1,j2,c,nc,plot
   int	nc
   SV*	plot
   CODE:
+    DEBUG_PRINT(pgconx);
     pgfunname[0] = plot;
     cpgconx(a,idim,jdim,i1,i2,j1,j2,c,nc,pgfunplot);
 
@@ -286,6 +319,7 @@ pgctab(l,r,g,b,nc,contra,bright)
   float	contra
   float	bright
   CODE:
+    DEBUG_PRINT(pgctab);
     cpgctab(l,r,g,b,nc,contra,bright);
 
 
@@ -295,6 +329,7 @@ pgcurs(x,y,ch)
   float	y = NO_INIT
   char	ch = NO_INIT
   CODE:
+    DEBUG_PRINT(pgcurs);
     RETVAL = cpgcurs(&x,&y,&ch);
   OUTPUT:
   x
@@ -309,6 +344,7 @@ pgcurse(x,y,ch)
   float	y = NO_INIT
   char	ch = NO_INIT
   CODE:
+    DEBUG_PRINT(pgcurse);
     RETVAL = cpgcurs(&x,&y,&ch);
   OUTPUT:
   x
@@ -322,18 +358,21 @@ pgdraw(x,y)
   float	x
   float	y
   CODE:
+    DEBUG_PRINT(pgdraw);
     cpgdraw(x,y);
 
 
 void
 pgebuf()
   CODE:
+    DEBUG_PRINT(pgebuf);
     cpgebuf();
 
 
 void
 pgend()
   CODE:
+    DEBUG_PRINT(pgend);
     cpgend();
 
 
@@ -346,12 +385,14 @@ pgenv(xmin,xmax,ymin,ymax,just,axis)
   int	just
   int	axis
   CODE:
+    DEBUG_PRINT(pgenv);
     cpgenv(xmin,xmax,ymin,ymax,just,axis);
 
 
 void
 pgeras()
   CODE:
+    DEBUG_PRINT(pgeras);
     cpgeras();
 
 void
@@ -363,6 +404,7 @@ pgerrb(dir,n,x,y,e,t)
   float *	e
   float	t
   CODE:
+    DEBUG_PRINT(pgerrb);
     cpgerrb(dir,n,x,y,e,t);
 
 void
@@ -373,6 +415,7 @@ pgerr1(dir,x,y,e,t)
   float	e
   float	t
   CODE:
+    DEBUG_PRINT(pgerr1);
     cpgerr1(dir,x,y,e,t);
 
 
@@ -384,6 +427,7 @@ pgerrx(n,x1,x2,y,t)
   float *	y
   float	t
   CODE:
+    DEBUG_PRINT(pgerrx);
     cpgerrx(n,x1,x2,y,t);
 
 
@@ -395,12 +439,14 @@ pgerry(n,x,y1,y2,t)
   float *	y2
   float	t
   CODE:
+    DEBUG_PRINT(pgerry);
     cpgerry(n,x,y1,y2,t);
 
 
 void
 pgetxt()
   CODE:
+    DEBUG_PRINT(pgetxt);
     cpgetxt();
 
 
@@ -413,6 +459,7 @@ pgfunt(fx,fy,n,tmin,tmax,pgflag)
   float	tmax
   int	pgflag
   CODE:
+    DEBUG_PRINT(pgfunt);
     pgfunname[0] = fx;
     pgfunname[1] = fy;
     cpgfunt(pgfun1,pgfun2,n,tmin,tmax,pgflag);
@@ -426,6 +473,7 @@ pgfunx(fy,n,xmin,xmax,pgflag)
   float	xmax
   int	pgflag
   CODE:
+    DEBUG_PRINT(pgfunx);
     pgfunname[0] = fy;
     cpgfunx(pgfun1,n,xmin,xmax,pgflag);
 
@@ -438,6 +486,7 @@ pgfuny(fx,n,ymin,ymax,pgflag)
   float	ymax
   int	pgflag
   CODE:
+    DEBUG_PRINT(pgfuny);
     pgfunname[0] = fx;
     cpgfuny(pgfun1,n,ymin,ymax,pgflag);
 
@@ -455,6 +504,7 @@ pggray(a,idim,jdim,i1,i2,j1,j2,fg,bg,tr)
   float	bg
   float *	tr
   CODE:
+    DEBUG_PRINT(pggray);
     cpggray(a,idim,jdim,i1,i2,j1,j2,fg,bg,tr);
 
 
@@ -473,6 +523,7 @@ pghi2d(data,nxv,nyv,ix1,ix2,iy1,iy2,x,io
   Logical	center
   float *	ylims
   CODE:
+    DEBUG_PRINT(pghi2d);
     cpghi2d(data,nxv,nyv,ix1,ix2,iy1,iy2,x,ioff,bias,center,ylims);
 
 
@@ -485,12 +536,14 @@ pghist(n,data,datmin,datmax,nbin,pgflag)
   int	nbin
   int	pgflag
   CODE:
+    DEBUG_PRINT(pghist);
     cpghist(n,data,datmin,datmax,nbin,pgflag);
 
 
 void
 pgiden()
   CODE:
+    DEBUG_PRINT(pgiden);
     cpgiden();
 
 
@@ -507,6 +560,7 @@ pgimag(a,idim,jdim,i1,i2,j1,j2,a1,a2,tr)
   float	a2
   float *	tr
   CODE:
+    DEBUG_PRINT(pgimag);
     cpgimag(a,idim,jdim,i1,i2,j1,j2,a1,a2,tr);
 
 
@@ -516,6 +570,7 @@ pglab(xlbl,ylbl,toplbl)
   char *	ylbl
   char *	toplbl
   CODE:
+    DEBUG_PRINT(pglab);
     cpglab(xlbl,ylbl,toplbl);
 
 
@@ -525,6 +580,7 @@ pglabel(xlbl,ylbl,toplbl)
   char *	ylbl
   char *	toplbl
   CODE:
+    DEBUG_PRINT(pglabel);
     cpglab(xlbl,ylbl,toplbl);
 
 
@@ -535,6 +591,7 @@ pglcur(maxpt,npt,x,y)
   float *	x = NO_INIT
   float *	y = NO_INIT
   CODE:
+    DEBUG_PRINT(pglcur);
     coerce1D( (SV*)ST(2), maxpt );  /* Make sure arrays are big enough */
     coerce1D( (SV*)ST(3), maxpt );
     x = (float *) pack1D( (SV*)ST(2), 'f' );  /* Pack arrays */
@@ -549,6 +606,7 @@ pglcur(maxpt,npt,x,y)
 void
 pgldev()
   CODE:
+    DEBUG_PRINT(pgldev);
     cpgldev();
 
 
@@ -559,6 +617,7 @@ pglen(units,string,xl,yl)
   float	xl = NO_INIT
   float	yl = NO_INIT
   CODE:
+    DEBUG_PRINT(pglen);
     cpglen(units,string,&xl,&yl);
   OUTPUT:
   xl
@@ -571,6 +630,7 @@ pgline(n,xpts,ypts)
   float *	xpts
   float *	ypts
   CODE:
+    DEBUG_PRINT(pgline);
     cpgline(n,xpts,ypts);
 
 
@@ -579,6 +639,7 @@ pgmove(x,y)
   float	x
   float	y
   CODE:
+    DEBUG_PRINT(pgmove);
     cpgmove(x,y);
 
 
@@ -590,6 +651,7 @@ pgmtxt(side,disp,coord,fjust,text)
   float	fjust
   char *	text
   CODE:
+    DEBUG_PRINT(pgmtxt);
     cpgmtxt(side,disp,coord,fjust,text);
 
 
@@ -601,6 +663,7 @@ pgmtext(side,disp,coord,fjust,text)
   float	fjust
   char *	text
   CODE:
+    DEBUG_PRINT(pgmtext);
     cpgmtxt(side,disp,coord,fjust,text);
 
 
@@ -612,6 +675,7 @@ pgncur(maxpt,npt,x,y,symbol)
   float *	y = NO_INIT
   int	symbol
   CODE:
+    DEBUG_PRINT(pgncur);
     coerce1D( (SV*)ST(2), maxpt );  /* Make sure arrays are big enough */
     coerce1D( (SV*)ST(3), maxpt );
     x = (float *) pack1D( (SV*)ST(2), 'f' );  /* Pack arrays */
@@ -631,6 +695,7 @@ pgncurse(maxpt,npt,x,y,symbol)
   float *	y = NO_INIT
   int	symbol
   CODE:
+    DEBUG_PRINT(pgncurse);
     coerce1D( (SV*)ST(2), maxpt );  /* Make sure arrays are big enough */
     coerce1D( (SV*)ST(3), maxpt );
     x = (float *) pack1D( (SV*)ST(2), 'f' );  /* Pack arrays */
@@ -650,6 +715,7 @@ pgnumb(mm,pp,form,string,nc)
   char *	string = NO_INIT
   int	nc = NO_INIT
   CODE:
+    DEBUG_PRINT(pgnumb);
     string = strbuff;
            nc     = SIZEOF(string);
     cpgnumb(mm,pp,form,string,&nc);
@@ -666,6 +732,7 @@ pgolin(maxpt,npt,x,y,symbol)
   float *	y = NO_INIT
   int	symbol
   CODE:
+    DEBUG_PRINT(pgolin);
     coerce1D( (SV*)ST(2), maxpt );  /* Make sure arrays are big enough */
     coerce1D( (SV*)ST(3), maxpt );
     x = (float *) pack1D( (SV*)ST(2), 'f' );  /* Pack arrays */
@@ -681,6 +748,7 @@ int
 pgopen(device)
   char *	device
   CODE:
+    DEBUG_PRINT(pgopen);
     RETVAL = cpgopen(device);
   OUTPUT:
   RETVAL
@@ -688,12 +756,14 @@ pgopen(device)
 void
 pgpage()
   CODE:
+    DEBUG_PRINT(pgpage);
     cpgpage();
 
 
 void
 pgadvance()
   CODE:
+    DEBUG_PRINT(pgadvance);
     cpgpage();
 
 
@@ -702,6 +772,7 @@ pgpanl(ix,iy)
   int	ix
   int	iy
   CODE:
+    DEBUG_PRINT(pgpanl);
     cpgpanl(ix,iy);
 
 
@@ -710,6 +781,7 @@ pgpap(width,aspect)
   float	width
   float	aspect
   CODE:
+    DEBUG_PRINT(pgpap);
     cpgpap(width,aspect);
 
 
@@ -718,6 +790,7 @@ pgpaper(width,aspect)
   float	width
   float	aspect
   CODE:
+    DEBUG_PRINT(pgpaper);
     cpgpap(width,aspect);
 
 
@@ -735,6 +808,7 @@ pgpixl(ia,idim,jdim,i1,i2,j1,j2,x1,x2,y1
   float	y1
   float	y2
   CODE:
+    DEBUG_PRINT(pgpixl);
     cpgpixl(ia,idim,jdim,i1,i2,j1,j2,x1,x2,y1,y2);
 
 
@@ -746,6 +820,7 @@ pgpnts(n,x,y,symbol,ns)
   int *	symbol
   int	ns
   CODE:
+    DEBUG_PRINT(pgpnts);
     cpgpnts(n,x,y,symbol,ns);
 
 void
@@ -754,6 +829,7 @@ pgpoly(n,xpts,ypts)
   float *	xpts
   float *	ypts
   CODE:
+    DEBUG_PRINT(pgpoly);
     cpgpoly(n,xpts,ypts);
 
 
@@ -764,6 +840,7 @@ pgpt(n,xpts,ypts,symbol)
   float *	ypts
   int	symbol
   CODE:
+    DEBUG_PRINT(pgpt);
     cpgpt(n,xpts,ypts,symbol);
 
 void
@@ -772,6 +849,7 @@ pgpt1(xpt,ypt,symbol)
   float	ypt
   int	symbol
   CODE:
+    DEBUG_PRINT(pgpt1);
     cpgpt1(xpt,ypt,symbol);
 
 void
@@ -781,6 +859,7 @@ pgpoint(n,xpts,ypts,symbol)
   float *	ypts
   int	symbol
   CODE:
+    DEBUG_PRINT(pgpoint);
     cpgpt(n,xpts,ypts,symbol);
 
 
@@ -792,6 +871,7 @@ pgptxt(x,y,angle,fjust,text)
   float	fjust
   char *	text
   CODE:
+    DEBUG_PRINT(pgptxt);
     cpgptxt(x,y,angle,fjust,text);
 
 
@@ -803,6 +883,7 @@ pgptext(x,y,angle,fjust,text)
   float	fjust
   char *	text
   CODE:
+    DEBUG_PRINT(pgptext);
     cpgptxt(x,y,angle,fjust,text);
 
 
@@ -812,6 +893,7 @@ pgqah(fs,angle,vent)
   float	angle = NO_INIT
   float	vent = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqah);
     cpgqah(&fs,&angle,&vent);
   OUTPUT:
   fs
@@ -823,6 +905,7 @@ void
 pgqcf(font)
   int	font = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqcf);
     cpgqcf(&font);
   OUTPUT:
   font
@@ -832,6 +915,7 @@ void
 pgqch(size)
   float	size = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqch);
     cpgqch(&size);
   OUTPUT:
   size
@@ -841,6 +925,7 @@ void
 pgqci(ci)
   int	ci = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqci);
     cpgqci(&ci);
   OUTPUT:
   ci
@@ -851,6 +936,7 @@ pgqcir(icilo,icihi)
   int	icilo = NO_INIT
   int	icihi = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqcir);
     cpgqcir(&icilo,&icihi);
   OUTPUT:
   icilo
@@ -861,6 +947,7 @@ void
 pgqclp(state)
   int	state = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqclp);
     cpgqclp(&state);
   OUTPUT:
   state
@@ -870,6 +957,7 @@ pgqcol(ci1,ci2)
   int	ci1 = NO_INIT
   int	ci2 = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqcol);
     cpgqcol(&ci1,&ci2);
   OUTPUT:
   ci1
@@ -882,6 +970,7 @@ pgqcr(ci,cr,cg,cb)
   float	cg = NO_INIT
   float	cb = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqcr);
     cpgqcr(ci,&cr,&cg,&cb);
   OUTPUT:
   cr
@@ -895,6 +984,7 @@ pgqcs(units,xch,ych)
   float	xch = NO_INIT
   float	ych = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqcs);
     cpgqcs(units,&xch,&ych);
   OUTPUT:
   xch
@@ -909,6 +999,7 @@ pgqdt(n,type,tlen,descr,dlen,inter)
   int	dlen = NO_INIT
   int	inter = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqdt);
     type = strbuff;
     tlen = SIZEOF(type);
     descr = strbuff2;
@@ -925,6 +1016,7 @@ void
 pgqfs(fs)
   int	fs = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqfs);
     cpgqfs(&fs);
   OUTPUT:
   fs
@@ -936,6 +1028,7 @@ pgqhs(angle,sepn,phase)
   float	sepn = NO_INIT
   float	phase = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqhs);
     cpgqhs(&angle,&sepn,&phase);
   OUTPUT:
   angle
@@ -946,6 +1039,7 @@ void
 pgqid(id)
   int	id = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqid);
     cpgqid(&id);
   OUTPUT:
   id
@@ -956,6 +1050,7 @@ pgqinf(item,value,length)
   char *	value = NO_INIT
   int	length = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqinf);
     value = strbuff;
     length = SIZEOF(value);
     cpgqinf(item,value,&length);
@@ -968,6 +1063,7 @@ void
 pgqitf(itf)
   int	itf = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqitf);
     cpgqitf(&itf);
   OUTPUT:
   itf
@@ -977,6 +1073,7 @@ void
 pgqls(ls)
   int	ls = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqls);
     cpgqls(&ls);
   OUTPUT:
   ls
@@ -986,6 +1083,7 @@ void
 pgqlw(lw)
   int	lw = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqlw);
     cpgqlw(&lw);
   OUTPUT:
   lw
@@ -994,6 +1092,7 @@ void
 pgqndt(n)
   int	n = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqndt);
     cpgqndt(&n);
   OUTPUT:
   n
@@ -1003,6 +1102,7 @@ pgqpos(x,y)
   float	x = NO_INIT
   float	y = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqpos);
     cpgqpos(&x,&y);
   OUTPUT:
   x
@@ -1013,6 +1113,7 @@ void
 pgqtbg(tbci)
   int	tbci = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqtbg);
     cpgqtbg(&tbci);
   OUTPUT:
   tbci
@@ -1028,6 +1129,7 @@ pgqtxt(x,y,angle,fjust,text,xbox,ybox)
   float *	xbox = NO_INIT
   float *	ybox = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqtxt);
     xbox = get_mortalspace(4,'f');
     ybox = get_mortalspace(4,'f');
     cpgqtxt(x,y,angle,fjust,text,xbox,ybox);
@@ -1042,6 +1144,7 @@ pgqvp(units,x1,x2,y1,y2)
   float	y1 = NO_INIT
   float	y2 = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqvp);
     cpgqvp(units,&x1,&x2,&y1,&y2);
   OUTPUT:
   x1
@@ -1058,6 +1161,7 @@ pgqvsz(units,x1,x2,y1,y2)
   float	y1 = NO_INIT
   float	y2 = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqvsz);
     cpgqvsz(units,&x1,&x2,&y1,&y2);
   OUTPUT:
   x1
@@ -1073,6 +1177,7 @@ pgqwin(x1,x2,y1,y2)
   float	y1 = NO_INIT
   float	y2 = NO_INIT
   CODE:
+    DEBUG_PRINT(pgqwin);
     cpgqwin(&x1,&x2,&y1,&y2);
   OUTPUT:
   x1
@@ -1088,6 +1193,7 @@ pgrect(x1,x2,y1,y2)
   float	y1
   float	y2
   CODE:
+    DEBUG_PRINT(pgrect);
     cpgrect(x1,x2,y1,y2);
 
 
@@ -1096,6 +1202,7 @@ pgrnd(x,nsub)
   float	x
   int	nsub = NO_INIT
   CODE:
+    DEBUG_PRINT(pgrnd);
     RETVAL = cpgrnd(x,&nsub);
   OUTPUT:
   nsub
@@ -1109,6 +1216,7 @@ pgrnge(x1,x2,xlo,xhi)
   float	xlo = NO_INIT
   float	xhi = NO_INIT
   CODE:
+    DEBUG_PRINT(pgrnge);
     cpgrnge(x1,x2,&xlo,&xhi);
   OUTPUT:
   xlo
@@ -1121,18 +1229,21 @@ pgsah(fs,angle,vent)
   float	angle
   float	vent
   CODE:
+    DEBUG_PRINT(pgsah);
     cpgsah(fs,angle,vent);
 
 
 void
 pgsave()
   CODE:
+    DEBUG_PRINT(pgsave);
     cpgsave();
 
 
 void
 pgunsa()
   CODE:
+    DEBUG_PRINT(pgunsa);
     cpgunsa();
 
 
@@ -1140,6 +1251,7 @@ void
 pgscf(font)
   int	font
   CODE:
+    DEBUG_PRINT(pgscf);
     cpgscf(font);
 
 
@@ -1147,6 +1259,7 @@ void
 pgsch(size)
   float	size
   CODE:
+    DEBUG_PRINT(pgsch);
     cpgsch(size);
 
 
@@ -1154,6 +1267,7 @@ void
 pgsci(ci)
   int	ci
   CODE:
+    DEBUG_PRINT(pgsci);
     cpgsci(ci);
 
 
@@ -1162,12 +1276,14 @@ pgscir(icilo,icihi)
   int	icilo
   int	icihi
   CODE:
+    DEBUG_PRINT(pgscir);
     cpgscir(icilo,icihi);
 
 void
 pgsclp(state)
   int	state
   CODE:
+    DEBUG_PRINT(pgsclp);
     cpgsclp(state);
 
 void
@@ -1177,6 +1293,7 @@ pgscr(ci,cr,cg,cb)
   float	cg
   float	cb
   CODE:
+    DEBUG_PRINT(pgscr);
     cpgscr(ci,cr,cg,cb);
 
 void
@@ -1184,6 +1301,7 @@ pgscrl(dx,dy)
   float	dx
   float	dy
   CODE:
+    DEBUG_PRINT(pgscrl);
     cpgscrl(dx,dy);
 
 void
@@ -1192,6 +1310,7 @@ pgscrn(ci,name,ier)
   char *	name
   int	ier = NO_INIT
   CODE:
+    DEBUG_PRINT(pgscrn);
     cpgscrn(ci,name,&ier);
   OUTPUT:
   ier
@@ -1201,6 +1320,7 @@ void
 pgsfs(fs)
   int	fs
   CODE:
+    DEBUG_PRINT(pgsfs);
     cpgsfs(fs);
 
 
@@ -1211,6 +1331,7 @@ pgshls(ci,ch,cl,cs)
   float	cl
   float	cs
   CODE:
+    DEBUG_PRINT(pgshls);
     cpgshls(ci,ch,cl,cs);
 
 
@@ -1220,6 +1341,7 @@ pgshs(angle,sepn,phase)
   float	sepn
   float	phase
   CODE:
+    DEBUG_PRINT(pgshs);
     cpgshs(angle,sepn,phase);
 
 
@@ -1227,18 +1349,21 @@ void
 pgsitf(itf)
   int	itf
   CODE:
+    DEBUG_PRINT(pgsitf);
     cpgsitf(itf);
 
 void
 pgslct(id)
   int	id
   CODE:
+    DEBUG_PRINT(pgslct);
     cpgslct(id);
 
 void
 pgsls(ls)
   int	ls
   CODE:
+    DEBUG_PRINT(pgsls);
     cpgsls(ls);
 
 
@@ -1246,6 +1371,7 @@ void
 pgslw(lw)
   int	lw
   CODE:
+    DEBUG_PRINT(pgslw);
     cpgslw(lw);
 
 
@@ -1253,6 +1379,7 @@ void
 pgstbg(tbci)
   int	tbci
   CODE:
+    DEBUG_PRINT(pgstbg);
     cpgstbg(tbci);
 
 
@@ -1261,6 +1388,7 @@ pgsubp(nxsub,nysub)
   int	nxsub
   int	nysub
   CODE:
+    DEBUG_PRINT(pgsubp);
     cpgsubp(nxsub,nysub);
 
 
@@ -1271,6 +1399,7 @@ pgsvp(xleft,xright,ybot,ytop)
   float	ybot
   float	ytop
   CODE:
+    DEBUG_PRINT(pgsvp);
     cpgsvp(xleft,xright,ybot,ytop);
 
 
@@ -1281,6 +1410,7 @@ pgvport(xleft,xright,ybot,ytop)
   float	ybot
   float	ytop
   CODE:
+    DEBUG_PRINT(pgvport);
     cpgsvp(xleft,xright,ybot,ytop);
 
 
@@ -1291,6 +1421,7 @@ pgswin(x1,x2,y1,y2)
   float	y1
   float	y2
   CODE:
+    DEBUG_PRINT(pgswin);
     cpgswin(x1,x2,y1,y2);
 
 
@@ -1301,6 +1432,7 @@ pgwindow(x1,x2,y1,y2)
   float	y1
   float	y2
   CODE:
+    DEBUG_PRINT(pgwindow);
     cpgswin(x1,x2,y1,y2);
 
 
@@ -1313,6 +1445,7 @@ pgtbox(xopt,xtick,nxsub,yopt,ytick,nysub
   float	ytick
   int	nysub
   CODE:
+    DEBUG_PRINT(pgtbox);
     cpgtbox(xopt,xtick,nxsub,yopt,ytick,nysub);
 
 void
@@ -1328,6 +1461,7 @@ pgtick(x1,y1,x2,y2,v,tikl,tikr,disp,orie
   float	orient
   char *	str
   CODE:
+    DEBUG_PRINT(pgtick);
     cpgtick(x1,y1,x2,y2,v,tikl,tikr,disp,orient,str);
 
 void
@@ -1336,12 +1470,14 @@ pgtext(x,y,text)
   float	y
   char *	text
   CODE:
+    DEBUG_PRINT(pgtext);
     cpgtext(x,y,text);
 
 
 void
 pgupdt()
   CODE:
+    DEBUG_PRINT(pgupdt);
     cpgupdt();
 
 
@@ -1360,6 +1496,7 @@ pgvect(a,b,idim,jdim,i1,i2,j1,j2,c,nc,tr
   float *	tr
   float	blank
   CODE:
+    DEBUG_PRINT(pgvect);
     cpgvect(a,b,idim,jdim,i1,i2,j1,j2,c,nc,tr,blank);
 
 
@@ -1370,6 +1507,7 @@ pgvsiz(xleft,xright,ybot,ytop)
   float	ybot
   float	ytop
   CODE:
+    DEBUG_PRINT(pgvsiz);
     cpgvsiz(xleft,xright,ybot,ytop);
 
 
@@ -1380,18 +1518,21 @@ pgvsize(xleft,xright,ybot,ytop)
   float	ybot
   float	ytop
   CODE:
+    DEBUG_PRINT(pgvsize);
     cpgvsiz(xleft,xright,ybot,ytop);
 
 
 void
 pgvstd()
   CODE:
+    DEBUG_PRINT(pgvstd);
     cpgvstd();
 
 
 void
 pgvstand()
   CODE:
+    DEBUG_PRINT(pgvstand);
     cpgvstd();
 
 
@@ -1404,6 +1545,7 @@ pgwedg(side,disp,width,fg,bg,label)
   float	bg
   char *	label
   CODE:
+    DEBUG_PRINT(pgwedg);
     cpgwedg(side,disp,width,fg,bg,label);
 
 
@@ -1414,6 +1556,7 @@ pgwnad(x1,x2,y1,y2)
   float	y1
   float	y2
   CODE:
+    DEBUG_PRINT(pgwnad);
     cpgwnad(x1,x2,y1,y2);
 
 
@@ -1424,6 +1567,7 @@ pggapline(n,msgval,xpts,ypts)
   float_packed	xpts
   float_packed	ypts
   CODE:
+    DEBUG_PRINT(pggapline);
     { int i;
       int start = 0;
       while (xpts[start] == msgval) start++;  /* make sure we have a good starting point */
@@ -1450,6 +1594,7 @@ pgcolorpnts(n,x,y,z,sym)
   float_packed	z
   int   sym
   CODE:
+    DEBUG_PRINT(pgcolorpnts);
     {
       /* find range of color pallette */
       int icilo, icihi, i, cirange, ci;
@@ -1497,4 +1642,4 @@ BOOT:
        by other modules
    */
 
-   sv_setiv(perl_get_sv("PGPLOT::HANDLE",TRUE|GV_ADDMULTI), (IV) (void*) &myPGPLOT_handle);
+   sv_setiv(get_sv("PGPLOT::HANDLE",TRUE|GV_ADDMULTI), (IV) (void*) &myPGPLOT_handle);
diff -pruN 1:2.33-1/debian/changelog 1:2.35-1/debian/changelog
--- 1:2.33-1/debian/changelog	2024-09-21 17:13:40.000000000 +0000
+++ 1:2.35-1/debian/changelog	2025-02-25 21:09:27.000000000 +0000
@@ -1,3 +1,11 @@
+libpgplot-perl (1:2.35-1) unstable; urgency=medium
+
+  * Import upstream version 2.35.
+  * c23.patch: new: fix build failures with gcc-15. (Closes: #1097250)
+  * Declare compliance with Debian Policy 4.7.1.
+
+ -- Étienne Mollier <emollier@debian.org>  Tue, 25 Feb 2025 22:09:27 +0100
+
 libpgplot-perl (1:2.33-1) unstable; urgency=medium
 
   * Import upstream version 2.33.
diff -pruN 1:2.33-1/debian/control 1:2.35-1/debian/control
--- 1:2.33-1/debian/control	2024-09-21 17:13:40.000000000 +0000
+++ 1:2.35-1/debian/control	2025-02-25 21:09:27.000000000 +0000
@@ -15,7 +15,7 @@ Build-Depends: debhelper-compat (= 13),
                perl:native,
                xauth <!nocheck>,
                xvfb <!nocheck>
-Standards-Version: 4.7.0
+Standards-Version: 4.7.1
 Vcs-Browser: https://salsa.debian.org/perl-team/modules/packages/libpgplot-perl
 Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libpgplot-perl.git
 Homepage: https://metacpan.org/release/PGPLOT
diff -pruN 1:2.33-1/debian/patches/c23.patch 1:2.35-1/debian/patches/c23.patch
--- 1:2.33-1/debian/patches/c23.patch	1970-01-01 00:00:00.000000000 +0000
+++ 1:2.35-1/debian/patches/c23.patch	2025-02-25 21:09:27.000000000 +0000
@@ -0,0 +1,63 @@
+Description: Fix build failures with standard C 2023.
+ This patch adds missing function argument types in prototypes, and
+ casts a couple of indirect function calls, to ensure compatibility with
+ the standard C 2023, now selected by default by gcc 15 and later.
+Author: Étienne Mollier <emollier@debian.org>
+Bug-Debian: https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=1097250
+Forwarded: https://github.com/PDLPorters/perl5-PGPLOT/pull/18
+Last-Update: 2025-02-25
+---
+This patch header follows DEP-3: http://dep.debian.net/deps/dep3/
+--- libpgplot-perl.orig/pgfun.c
++++ libpgplot-perl/pgfun.c
+@@ -26,9 +26,9 @@
+ /* Prototypes */
+ 
+ static SV*  pgfunname[2];
+-float pgfun1();
+-float pgfun2();
+-void   pgfunplot();
++float pgfun1(float *x);
++float pgfun2(float *x);
++void   pgfunplot(int *visible,float *x, float *y, float *z);
+ void PGFUNX(float fy(), int *n, float *xmin, float *xmax, int *pgflag);
+ void PGFUNY(float fx(), int *n, float *ymin, float *ymax, int *pgflag);
+ void PGFUNT(float fx(), float fy(), int *n, float *tmin, float *tmax, int *pgflag);
+--- libpgplot-perl.orig/PGPLOT.xs
++++ libpgplot-perl/PGPLOT.xs
+@@ -306,7 +306,7 @@
+   CODE:
+     DEBUG_PRINT(pgconx);
+     pgfunname[0] = plot;
+-    cpgconx(a,idim,jdim,i1,i2,j1,j2,c,nc,pgfunplot);
++    cpgconx(a,idim,jdim,i1,i2,j1,j2,c,nc,(void(*)(void))pgfunplot);
+ 
+ 
+ void
+@@ -462,7 +462,7 @@
+     DEBUG_PRINT(pgfunt);
+     pgfunname[0] = fx;
+     pgfunname[1] = fy;
+-    cpgfunt(pgfun1,pgfun2,n,tmin,tmax,pgflag);
++    cpgfunt((float(*)(void))pgfun1,(float(*)(void))pgfun2,n,tmin,tmax,pgflag);
+ 
+ 
+ void
+@@ -475,7 +475,7 @@
+   CODE:
+     DEBUG_PRINT(pgfunx);
+     pgfunname[0] = fy;
+-    cpgfunx(pgfun1,n,xmin,xmax,pgflag);
++    cpgfunx((float(*)(void))pgfun1,n,xmin,xmax,pgflag);
+ 
+ 
+ void
+@@ -488,7 +488,7 @@
+   CODE:
+     DEBUG_PRINT(pgfuny);
+     pgfunname[0] = fx;
+-    cpgfuny(pgfun1,n,ymin,ymax,pgflag);
++    cpgfuny((float(*)(void))pgfun1,n,ymin,ymax,pgflag);
+ 
+ 
+ void
diff -pruN 1:2.33-1/debian/patches/series 1:2.35-1/debian/patches/series
--- 1:2.33-1/debian/patches/series	2024-09-21 17:13:40.000000000 +0000
+++ 1:2.35-1/debian/patches/series	2025-02-25 21:09:27.000000000 +0000
@@ -1,3 +1,4 @@
 useless_dependency.patch
 test-pgplot5-version.patch
 disable-interactive-tests.patch
+c23.patch
diff -pruN 1:2.33-1/lib/PDL/Graphics/PGPLOT/Window.pm 1:2.35-1/lib/PDL/Graphics/PGPLOT/Window.pm
--- 1:2.33-1/lib/PDL/Graphics/PGPLOT/Window.pm	2024-07-29 00:22:24.000000000 +0000
+++ 1:2.35-1/lib/PDL/Graphics/PGPLOT/Window.pm	2024-12-20 09:18:31.000000000 +0000
@@ -595,7 +595,7 @@ rabbits in O'Fib-o-nachy's farm (alterna
 monitoring processes or do something entirely different). Odd wants the
 user to be able to monitor both the birth rates and accumulated number
 of rabbits and the spatial distribution of the births. Since these are
-logically different they chooses to have two windows open:
+logically different they choose to have two windows open:
 
   $rate_win = PDL::Graphics::PGPLOT::Window->new(Device => '/xw',
               Aspect => 1, WindowWidth => 5, NXPanel => 2);
@@ -5166,7 +5166,7 @@ EOD
 	}
 	my($mask) = (isfinite $vals);
 	$mask &= ($vals != $missing) if(defined $missing);
-	$mask->slice("1:-1") &= (($pp->slice("0:-2") != 0) | ($pp->slice("1:-1") != 0));
+	$mask->slice("1:-1") &= long(($pp->slice("0:-2") != 0) | ($pp->slice("1:-1") != 0));
 	my($c,$d) = minmax(where($vals,$mask));
 	$min .= $c;
 	$max .= $d;
diff -pruN 1:2.33-1/lib/PDL/Graphics/State.pm 1:2.35-1/lib/PDL/Graphics/State.pm
--- 1:2.33-1/lib/PDL/Graphics/State.pm	1970-01-01 00:00:00.000000000 +0000
+++ 1:2.35-1/lib/PDL/Graphics/State.pm	2024-11-25 21:43:39.000000000 +0000
@@ -0,0 +1,140 @@
+=head1 NAME
+
+State - A package to keep track of plotting commands
+
+=head1 SYNOPSIS
+
+  use PDL::Graphics::State;
+
+=head1 DESCRIPTION
+
+This is a very simple, at present almost trivial, package to keep track
+of the current set of plotting commands.
+
+=head1 USAGE
+
+You create a new object by calling the C<new> operator
+
+  $state = PDL::Graphics::State->new();
+
+Then for each new command you call C<add> on this object so that for a
+call to C<line> of the form
+
+  line $x, $y, $opt;
+
+the call to C<add> would be like
+
+  $state->add(\&line, 'line', [$x, $y], $opt);
+
+which is stored internally as:
+
+  [\&line, 'line', [$x, $y], $opt]
+
+The state can later be extracted using C<get> which returns the state
+object which is an array of anonymous arrays like the one above where
+the first object is a reference to the function, the second an anomymous
+array of arguments to the function and finally an anonymous hash with
+options to the command.
+
+If you know the order in which you inserted commands they can be removed
+by calling C<remove> with the number in the stack. No further interaction
+is implemented except C<clear> which clears the stack and C<copy> which
+returns a "deep" copy of the state.
+
+=head1 AUTHOR
+
+Jarle Brinchmann (jarle@astro.ox.ac.uk) after some prodding by
+Karl Glazebrook.
+
+All rights reserved. There is no warranty. You are allowed
+to redistribute this software / documentation under certain
+conditions. For details, see the file COPYING in the PDL
+distribution. If this file is separated from the PDL distribution,
+the copyright notice should be included in the file.
+
+=cut
+
+package PDL::Graphics::State;
+use strict;
+use warnings;
+
+#
+# This is a very simple package to deal with the graphics state.
+#
+
+sub new {
+  my $type = shift;
+
+  my $self = {
+	      'Commands' => [],
+	     };
+
+  bless $self, ref($type) || $type;
+  return $self;
+}
+
+
+sub DESTROY {
+  my $self = shift;
+  $self->clear();
+}
+
+sub add {
+  my $self = shift;
+  # The command is a reference to the subroutine, the data is an
+  # anonymous array containing the data passed to the routine and
+  # opt is the options hash PASSED TO THE ROUTINE..
+  my ($command, $command_name, $data, $opt) = @_;
+
+  # Compact and not user-friendly storage.
+  push @{$self->{Commands}}, [$command, $command_name, $data, $opt];
+
+#  return $#{$self->{Commands}}+1;
+}
+
+
+sub remove {
+  my $self = shift;
+  my $num = shift;
+
+  # Remove entry #1
+  splice @{$self->{Commands}}, $num, 1;
+}
+
+sub get {
+  my $self = shift;
+  return @{$self->{Commands}};
+}
+
+sub info {
+  my $self = shift;
+  print "The state has ".($#{$self->{Commands}}+1)." commands in the stack\n";
+}
+
+sub show {
+  my $self = shift;
+  my $count=0;
+  foreach my $arg (@{$self->{Commands}}) {
+    print "$count - Func=$$arg[1]\n";
+    $count++;
+  }
+
+}
+
+sub clear {
+  my $self = shift;
+  # Do I need to do more?
+  $self->{Commands}=[];
+}
+
+
+sub copy {
+  my $self = shift;
+  my $new = PDL::Graphics::State->new();
+  foreach my $arg (@{$self->{Commands}}) {
+    $new->add(@$arg);
+  }
+  return $new;
+}
+
+1;
diff -pruN 1:2.33-1/lib/PGPLOT.pm 1:2.35-1/lib/PGPLOT.pm
--- 1:2.33-1/lib/PGPLOT.pm	2024-09-17 19:26:14.000000000 +0000
+++ 1:2.35-1/lib/PGPLOT.pm	2024-12-20 09:19:20.000000000 +0000
@@ -5,7 +5,7 @@ use warnings;
 use Exporter;
 use DynaLoader;
 
-our $VERSION="2.33";
+our $VERSION="2.35";
 
 our @ISA = qw(Exporter DynaLoader);
 our @EXPORT = qw( pgarro pgask pgaxis pgband pgbbuf pgbeg pgbegin pgbin pgbox
@@ -44,14 +44,14 @@ PGPLOT - allow subroutines in the PGPLOT
 
  use PGPLOT;
 
- pgbegin(0,"/xserve",1,1);  
- pgenv(1,10,1,10,0,0);        
- pglabel('X','Y','My plot');  
+ pgbegin(0,"/xserve",1,1);
+ pgenv(1,10,1,10,0,0);
+ pglabel('X','Y','My plot');
  pgpoint(7,[2..8],[2..8],17);
 
  # etc...
 
- pgend;           
+ pgend;
 
 =head1 DESCRIPTION
 
@@ -65,7 +65,7 @@ for the complete list of available funct
 its heart a Fortran library, so the documentation describes the
 Fortran interface.
 
-Also refer to the extensive set of test scripts (C<test*.p>) included
+Also refer to the extensive set of test scripts (F<t/t*.t>) included
 in the module distribution for examples of usage of all kinds of
 PGPLOT routines.
 
@@ -73,7 +73,7 @@ How the function calls map on to Perl ca
 
 =head2 Argument Mapping - Simple Numbers And Arrays
 
-This is more or less as you might expect - use Perl scalars 
+This is more or less as you might expect - use Perl scalars
 and Perl arrays in place of FORTRAN/C variables and arrays.
 
 Any FORTRAN REAL/INTEGER/CHARACTER* scalar variable maps to a
@@ -84,7 +84,7 @@ Thus you can say:
 
 To draw a line to point (42,$x):
 
- pgdraw(42,$x); 
+ pgdraw(42,$x);
 
 To plot 10 points with data in Perl arrays C<@x> and C<@y> with plot symbol
 no. 17. Note the Perl arrays are passed by reference:
@@ -117,14 +117,14 @@ from Perl:
 
 =item 1.
 
-Simply pass a reference to a 2D array, e.g: 
+Simply pass a reference to a 2D array, e.g:
 
   # Create 2D array
 
   $x=[];
-  for($i=0; $i<128; $i++) { 
+  for($i=0; $i<128; $i++) {
      for($j=0; $j<128; $j++) {
-       $$x[$i][$j] = sqrt($i*$j); 
+       $$x[$i][$j] = sqrt($i*$j);
      }
   }
   pggray( $x, 128, 128, ...);
@@ -134,9 +134,9 @@ Simply pass a reference to a 2D array, e
 Pass a reference to a 1D array:
 
   @x=();
-  for($i=0; $i<128; $i++) { 
+  for($i=0; $i<128; $i++) {
      for($j=0; $j<128; $j++) {
-       $x[$i][$j] = sqrt($i*$j); 
+       $x[$i][$j] = sqrt($i*$j);
      }
   }
   pggray( \@x, 128, 128, ...);
@@ -151,7 +151,7 @@ as long as the number of elements match.
 If your image data is packed in raw binary form into a character string
 you can simply pass the raw string. e.g.:
 
-   read(IMG, $img, 32768); 
+   read(IMG, $img, 32768);
    pggray($img, $xsize, $ysize, ...);
 
 Here the C<read()> function reads the binary data from a file and the
@@ -168,17 +168,17 @@ binary data.
 I<Please Note>: As PGPLOT is a Fortran library it expects its images to be
 be stored in row order. Thus a 1D list is interpreted as a sequence of
 rows end to end. Perl is similar to C in that 2D arrays are arrays of
-pointers thus images end up stored in column order. 
+pointers thus images end up stored in column order.
 
 Thus using perl multidimensional arrays the coordinate ($i,$j) should be
 stored in $img[$j][$i] for things to work as expected, e.g:
 
    $img = [];
-   for $j (0..$nx-1) for $i (0..$ny-1) { 
+   for $j (0..$nx-1) for $i (0..$ny-1) {
       $$img[$j][$i] = whatever();
    }}
    pggray($$img, $nx, $ny, ...);
-   
+
 Also PGPLOT displays coordinate (0,0) at the bottom left (this is
 natural as the subroutine library was written by an astronomer!).
 
@@ -232,6 +232,13 @@ See in particular L<PDL::Graphics::PGPLO
 Be VERY careful binary data is of the right size or your segments
 might get violated.
 
+=head1 DEBUGGING
+
+As of 2.34, there is a C<PGPLOT::set_debugging> function (not
+exported). It takes an integer argument, and returns the previous value.
+When any PGPLOT function is called, if that level is >= 1, the name of
+the function will be printed to standard error.
+
 =head1 HISTORY
 
 Originally developed in the olden days of Perl4 (when it was known
@@ -266,6 +273,93 @@ Source code is available at either of th
 
 =back
 
+=head2 Cygwin
+
+Build the pgplot library and install as above, but with these notes in mind.
+
+Edit drivers.list to enable the drivers you wish but
+uncommenting desired drivers by removing the leading ! on the
+line. Here are the ones used by a previous PDL maintainer:
+
+  $ grep -v '^!' drivers.list
+    LXDRIV 0 /LATEX     LaTeX picture environment
+    NUDRIV 0 /NULL      Null device (no output)                           Std F77
+    PPDRIV 1 /PPM       Portable Pixel Map file, landscape
+    PPDRIV 2 /VPPM      Portable PIxel Map file, portrait
+    PSDRIV 1 /PS        PostScript printers, monochrome, landscape        Std F77
+    PSDRIV 2 /VPS       Postscript printers, monochrome, portrait         Std F77
+    PSDRIV 3 /CPS       PostScript printers, color, landscape             Std F77
+    PSDRIV 4 /VCPS      PostScript printers, color, portrait              Std F77
+    TTDRIV 5 /XTERM     XTERM Tektronix terminal emulator                 Std F77
+    WDDRIV 1 /WD        X Window dump file, landscape
+    WDDRIV 2 /VWD       X Window dump file, portrait
+    XWDRIV 1 /XWINDOW   Workstations running X Window System              C
+    XWDRIV 2 /XSERVE    Persistent window on X Window System              C
+
+  $ vi sys_cygwin/g77_gcc.conf
+
+  # This diff command shows the lines that need changing
+  $ diff g77_gcc.conf*
+  12c12
+  <    XINCL="-I/usr/X11R6/include"
+  ---
+  >    XINCL="-I/usr/X11R6.4/include"
+  48c48
+  <    FFLAGD="-fno-backslash -I/usr/include"
+  ---
+  >    FFLAGD="-fno-backslash"
+  58c58
+  <    CFLAGC="-DPG_PPU -O2 -DNOMALLOCH -I. -I/usr/include"
+  ---
+  >    CFLAGC="-DPG_PPU -O2 -DNOMALLOCH -I."
+  75c75
+  <    LIBS="-L/usr/X11R6/lib -lX11 -lpng -lz"
+  ---
+  >    LIBS="-L/usr/X11R6.4/lib -lX11"
+
+  $ ~/pgplot/makemake ~/pgplot cygwin
+  $ make
+  $ make clean
+  $ make cpg
+  $ PGPLOT_DIR="/usr/local/pgplot/"; export PGPLOT_DIR
+
+Be sure to add C<PGPLOT_DIR> to your environment and add it to
+your PATH as well.
+
+NOTE: if problems occur, you may need to C<rebaseall> your libraries.
+
+=head1 PNG OUTPUT
+
+If PGPLOT does not write out PNG files, check these things.
+First, when compiling the pgplot libraries, make sure you uncomment the PNG
+entries in the F<drivers.list> file. Then when running 'make' you
+probably got an error like
+
+  C<make: *** No rule to make target `png.h', needed by `pndriv.o'.  Stop.>
+
+To fix this, find the line in the 'makefile' that starts with
+'pndriv.o:' (it's near the bottom). Change, for example, ./png.h to
+/usr/include/png.h, if that is where your header files are (you do
+have the libpng and libz devel packages, don't you?).  Do this for all
+four entries on that line, then go back and run C<make>.
+
+Second, if you already have the PGPLOT Perl module and PDL installed,
+you probably tried to write out a PNG file and got fatal error message
+like:
+
+  C<undefined symbol: png_create_write_struct>
+
+This is because the PGPLOT Perl module does not automatically link
+against the png and z libraries. So when you are installing the PGPLOT
+Perl module (version 2.19) from CPAN, don't do C<install PGPLOT>, but
+just do C<get PGPLOT>. Then exit from CPAN and manually install
+PGPLOT, calling the makefile thusly:
+
+  C<perl Makefile.PL EXLIB=png,z EXDIR=/usr/lib>
+
+assuming that there exist files such as /usr/lib/libpng.so.*,
+/usr/lib/libz.so.*. Then do the standard C<make;make test;make
+install;> sequence. Now you can write png files from PDL!
 
 =head1 AUTHORS
 
diff -pruN 1:2.33-1/pgfun.c 1:2.35-1/pgfun.c
--- 1:2.33-1/pgfun.c	2022-02-24 16:32:00.000000000 +0000
+++ 1:2.35-1/pgfun.c	2024-10-07 01:30:58.000000000 +0000
@@ -39,7 +39,7 @@ void PGCONX(float *a, int *idim, int *jd
 CPGPLOT prototypes missing in PGPLOT 5 - these handle passed
 functions. Mechanism used below only works with standard UNIX
 C/F77 passing. I have yet to find a system where this doesn't
-work but pacthes are welcome.
+work but patches are welcome.
 
 */
 
diff -pruN 1:2.33-1/t/t1.t 1:2.35-1/t/t1.t
--- 1:2.33-1/t/t1.t	2021-08-14 18:43:59.000000000 +0000
+++ 1:2.35-1/t/t1.t	2024-10-07 01:35:38.000000000 +0000
@@ -16,6 +16,7 @@ diag "Using device '$dev' - set env var
 
 $ENV{PGPLOT_XW_WIDTH}=0.3;
 
+#PGPLOT::set_debugging(1);
 PGPLOT::pgbegin(0,$dev,1,1);  # Open plot device
 
 PGPLOT::pgscf(2);             # Set character font
