diff -pruN 0.20-1/Changes 0.22-1/Changes
--- 0.20-1/Changes	2023-03-01 23:13:27.000000000 +0000
+++ 0.22-1/Changes	2025-01-07 18:53:57.000000000 +0000
@@ -1,17 +1,18 @@
 Revision history for Perl extension Perl-MinimumVersion-Fast
 
-0.20 2023-03-01T23:13:26Z
+0.22 2025-01-07T18:53:52Z
 
-    - Fix stdin support for perlver-fast
-      (Reported by Tux++)
+0.22 2025-01-07T06:49:00Z
 
-0.19 2020-04-15T05:27:20Z
+	- silence a warning (GitHub #23, Shoichi Kaji)
 
-    - Depends on Compiler::Lexer 0.23
+0.21 2025-01-07T06:49:00Z
+
+    - Remove notes about v5.6 now that we support that
 
 0.18 2015-07-22T00:33:00Z
 
-    - Support Perl 5.6
+    - Support reporting a minimum version of Perl 5.6
       (tokuhirom)
 
 0.17 2015-02-13T23:41:10Z
diff -pruN 0.20-1/META.json 0.22-1/META.json
--- 0.20-1/META.json	2023-03-01 23:13:27.000000000 +0000
+++ 0.22-1/META.json	2025-01-07 18:53:57.000000000 +0000
@@ -4,7 +4,7 @@
       "tokuhirom <tokuhirom@gmail.com>"
    ],
    "dynamic_config" : 0,
-   "generated_by" : "Minilla/v3.1.10",
+   "generated_by" : "Minilla/v3.1.25",
    "license" : [
       "perl_5"
    ],
@@ -55,7 +55,7 @@
    "provides" : {
       "Perl::MinimumVersion::Fast" : {
          "file" : "lib/Perl/MinimumVersion/Fast.pm",
-         "version" : "0.20"
+         "version" : "0.22"
       }
    },
    "release_status" : "stable",
@@ -65,18 +65,22 @@
       },
       "homepage" : "https://github.com/tokuhirom/Perl-MinimumVersion-Fast",
       "repository" : {
-         "url" : "git://github.com/tokuhirom/Perl-MinimumVersion-Fast.git",
+         "type" : "git",
+         "url" : "https://github.com/tokuhirom/Perl-MinimumVersion-Fast.git",
          "web" : "https://github.com/tokuhirom/Perl-MinimumVersion-Fast"
       }
    },
-   "version" : "0.20",
+   "version" : "0.22",
    "x_contributors" : [
       "Ahmad M. Zawawi <ahmad.zawawi@gmail.com>",
       "H.Merijn Brand - Tux <h.m.brand@xs4all.nl>",
+      "H.Merijn Brand - Tux <linux@tux.freedom.nl>",
       "Karen Etheridge <ether@cpan.org>",
       "Kenichi Ishigaki <ishigaki@cpan.org>",
-      "brian d foy <brian.d.foy@gmail.com>"
+      "Shoichi Kaji <skaji@cpan.org>",
+      "brian d foy <brian.d.foy@gmail.com>",
+      "brian d foy <briandfoy@pobox.com>"
    ],
-   "x_serialization_backend" : "JSON::PP version 4.02",
+   "x_serialization_backend" : "JSON::PP version 4.16",
    "x_static_install" : 1
 }
diff -pruN 0.20-1/META.yml 0.22-1/META.yml
--- 0.20-1/META.yml	2023-03-01 23:13:27.000000000 +0000
+++ 0.22-1/META.yml	2025-01-07 18:53:57.000000000 +0000
@@ -7,7 +7,7 @@ build_requires:
 configure_requires:
   Module::Build::Tiny: '0.035'
 dynamic_config: 0
-generated_by: 'Minilla/v3.1.10, CPAN::Meta::Converter version 2.150010'
+generated_by: 'Minilla/v3.1.25, CPAN::Meta::Converter version 2.150010'
 license: perl
 meta-spec:
   url: http://module-build.sourceforge.net/META-spec-v1.4.html
@@ -26,20 +26,23 @@ no_index:
 provides:
   Perl::MinimumVersion::Fast:
     file: lib/Perl/MinimumVersion/Fast.pm
-    version: '0.20'
+    version: '0.22'
 requires:
   Compiler::Lexer: '0.23'
   perl: '5.008005'
 resources:
   bugtracker: https://github.com/tokuhirom/Perl-MinimumVersion-Fast/issues
   homepage: https://github.com/tokuhirom/Perl-MinimumVersion-Fast
-  repository: git://github.com/tokuhirom/Perl-MinimumVersion-Fast.git
-version: '0.20'
+  repository: https://github.com/tokuhirom/Perl-MinimumVersion-Fast.git
+version: '0.22'
 x_contributors:
   - 'Ahmad M. Zawawi <ahmad.zawawi@gmail.com>'
   - 'H.Merijn Brand - Tux <h.m.brand@xs4all.nl>'
+  - 'H.Merijn Brand - Tux <linux@tux.freedom.nl>'
   - 'Karen Etheridge <ether@cpan.org>'
   - 'Kenichi Ishigaki <ishigaki@cpan.org>'
+  - 'Shoichi Kaji <skaji@cpan.org>'
   - 'brian d foy <brian.d.foy@gmail.com>'
+  - 'brian d foy <briandfoy@pobox.com>'
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
 x_static_install: 1
diff -pruN 0.20-1/README.md 0.22-1/README.md
--- 0.20-1/README.md	2023-03-01 23:13:27.000000000 +0000
+++ 0.22-1/README.md	2025-01-07 18:53:57.000000000 +0000
@@ -17,11 +17,6 @@ it can do this without having to actuall
 
 Perl::MinimumVersion::Fast is an alternative fast & lightweight implementation of Perl::MinimumVersion.
 
-This module supports only Perl 5.8.1+.
-If you want to support **Perl 5.6**, use [Perl::MinimumVersion](https://metacpan.org/pod/Perl%3A%3AMinimumVersion) instead.
-
-In 2013, you don't need to support Perl 5.6 in most of case.
-
 # METHODS
 
 - `my $p = Perl::MinimumVersion::Fast->new($filename);`
diff -pruN 0.20-1/debian/changelog 0.22-1/debian/changelog
--- 0.20-1/debian/changelog	2023-03-03 22:04:16.000000000 +0000
+++ 0.22-1/debian/changelog	2025-01-11 02:40:31.000000000 +0000
@@ -1,3 +1,11 @@
+libperl-minimumversion-fast-perl (0.22-1) unstable; urgency=medium
+
+  * Team upload.
+  * Import upstream version 0.22.
+  * Declare compliance with Debian Policy 4.7.0.
+
+ -- gregor herrmann <gregoa@debian.org>  Sat, 11 Jan 2025 03:40:31 +0100
+
 libperl-minimumversion-fast-perl (0.20-1) unstable; urgency=medium
 
   * Team upload.
diff -pruN 0.20-1/debian/control 0.22-1/debian/control
--- 0.20-1/debian/control	2023-03-03 22:04:16.000000000 +0000
+++ 0.22-1/debian/control	2025-01-11 02:40:31.000000000 +0000
@@ -9,7 +9,7 @@ Build-Depends: debhelper-compat (= 13),
                perl
 Build-Depends-Indep: libcompiler-lexer-perl <!nocheck>,
                      libtest-simple-perl <!nocheck>
-Standards-Version: 4.6.2
+Standards-Version: 4.7.0
 Vcs-Browser: https://salsa.debian.org/perl-team/modules/packages/libperl-minimumversion-fast-perl
 Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libperl-minimumversion-fast-perl.git
 Homepage: https://metacpan.org/release/Perl-MinimumVersion-Fast
diff -pruN 0.20-1/lib/Perl/MinimumVersion/Fast.pm 0.22-1/lib/Perl/MinimumVersion/Fast.pm
--- 0.20-1/lib/Perl/MinimumVersion/Fast.pm	2023-03-01 23:13:27.000000000 +0000
+++ 0.22-1/lib/Perl/MinimumVersion/Fast.pm	2025-01-07 18:53:57.000000000 +0000
@@ -8,7 +8,7 @@ use version ();
 use Compiler::Lexer 0.13;
 use List::Util qw(max);
 
-our $VERSION = "0.20";
+our $VERSION = "0.22";
 
 my $MIN_VERSION   = version->new('5.006');
 my $VERSION_5_020 = version->new('5.020');
@@ -28,7 +28,7 @@ sub new {
         $filename = $stuff;
         open my $fh, '<', $filename
             or die "Unknown file: $filename";
-        $src = do { local $/; <$fh> }; 
+        $src = do { local $/; <$fh> };
     } else {
         $filename = '-';
         $src = $$stuff;
@@ -210,7 +210,7 @@ sub _build_minimum_syntax_version {
 
 sub minimum_version {
     my $self = shift;
-    return $self->{minimum_explicit_version} > $self->{minimum_syntax_version}
+    return defined $self->{minimum_explicit_version} && ($self->{minimum_explicit_version} > $self->{minimum_syntax_version})
         ? $self->{minimum_explicit_version}
         : $self->{minimum_syntax_version};
 }
@@ -265,11 +265,6 @@ it can do this without having to actuall
 
 Perl::MinimumVersion::Fast is an alternative fast & lightweight implementation of Perl::MinimumVersion.
 
-This module supports only Perl 5.8.1+.
-If you want to support B<Perl 5.6>, use L<Perl::MinimumVersion> instead.
-
-In 2013, you don't need to support Perl 5.6 in most of case.
-
 =head1 METHODS
 
 =over 4
diff -pruN 0.20-1/script/perlver-fast 0.22-1/script/perlver-fast
--- 0.20-1/script/perlver-fast	2023-03-01 23:13:27.000000000 +0000
+++ 0.22-1/script/perlver-fast	2025-01-07 18:53:57.000000000 +0000
@@ -1,19 +1,36 @@
 #!/usr/bin/env perl
 use strict;
 use warnings;
+use Getopt::Long qw(:config bundling passthrough);
 use Perl::MinimumVersion::Fast;
 
+GetOptions(
+    "e:s" => \my $expr,
+    "v"   => \my $verbose,
+) or die "usage: $0 [file | -e expr]\n";
+
 if (@ARGV) {
-    for my $file (@ARGV) {
-        my $v = Perl::MinimumVersion::Fast->new($file);
-        printf "%s: %s\n", $file, $v->minimum_version;
-    }
-} else {
-    my $src = join("", <>);
-    my $v = Perl::MinimumVersion::Fast->new(\$src);
-    printf "STDIN: %s\n", $v->minimum_version;
+    report($_, $_) for @ARGV;
+}
+elsif ($expr) {
+    report("-e", \$expr);
+}
+else {
+    my $src = do { local $/; <> };
+    report("STDIN", \$src);
 }
 
+sub report {
+    my($in, $src) = @_;
+    my $v = Perl::MinimumVersion::Fast->new($src);
+    printf "%s: %s / %s\n", $in, $v->minimum_version, $v->minimum_syntax_version;
+    $verbose or return;
+    my @markers = $v->version_markers;
+    while (@markers) {
+        my($pv, $m) = splice @markers, 0, 2;
+        printf "%-10s %s\n", $pv, $_ for @$m;
+    }
+}
 __END__
 
 =head1 NAME
@@ -22,14 +39,28 @@ perlver-fast - Minimum perl version dete
 
 =head1 SYNOPSIS
 
+reports minimum version and minimum syntax version. Adding C<-c> tries to
+add detailed information.
+
 Analyze from file list
 
     $ perlver-fast lib/Acme/Kensiro.pm t/00.load.t
-    lib/Acme/Kensiro.pm: 5.008001
-    t/00.load.t: 5.006
+    lib/Acme/Kensiro.pm: 5.008001 / 5.006
+    t/00.load.t: 5.006 / 5.006
 
 Analyze from STDIN
 
     $ perlver-fast < lib/Acme/Kensiro.pm
-    STDIN: 5.008001
+    STDIN: 5.008001 / 5.006
+
+Analyze from expression
+
+    $ perlver-fast -e '$a //= 42'
+    -e: 5.010 / 5.010
+
+    $ perlver-fast -v -e '$a //= 42'
+    -e: 5.010 / 5.010
+    5.010      //= operator
 
+    $ perlver-fast -e 'use 5.24.1; $a //= 42'
+    -e: 5.24 / 5.010
