diff -pruN 2.031-1/CHANGES 2.032-1/CHANGES
--- 2.031-1/CHANGES	2024-10-28 03:30:18.000000000 +0000
+++ 2.032-1/CHANGES	2024-11-21 17:38:14.000000000 +0000
@@ -1,3 +1,6 @@
+2.032 2024-11-21
+- add filledcurves with above/below threshold and fillcolor (#105) - thanks @vikasnkumar
+
 2.031 2024-10-28
 - add default SIG{TERM,INT,QUIT,HUP} handler to close more gracefully
 - handle glx etc warnings from Gnuplot (https://github.com/PDLPorters/PDL-Graphics-Simple/issues/10) - thanks @eserte for report
diff -pruN 2.031-1/META.json 2.032-1/META.json
--- 2.031-1/META.json	2024-10-28 03:30:55.000000000 +0000
+++ 2.032-1/META.json	2024-11-21 17:39:09.000000000 +0000
@@ -65,6 +65,6 @@
          "url" : "git://github.com/PDLPorters/PDL-Graphics-Gnuplot.git"
       }
    },
-   "version" : "2.031",
+   "version" : "2.032",
    "x_serialization_backend" : "JSON::PP version 4.04"
 }
diff -pruN 2.031-1/META.yml 2.032-1/META.yml
--- 2.031-1/META.yml	2024-10-28 03:30:55.000000000 +0000
+++ 2.032-1/META.yml	2024-11-21 17:39:09.000000000 +0000
@@ -37,5 +37,5 @@ resources:
   bugtracker: http://github.com/PDLPorters/PDL-Graphics-Gnuplot/issues
   homepage: http://github.com/PDLPorters/PDL-Graphics-Gnuplot
   repository: git://github.com/PDLPorters/PDL-Graphics-Gnuplot.git
-version: '2.031'
+version: '2.032'
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
diff -pruN 2.031-1/debian/changelog 2.032-1/debian/changelog
--- 2.031-1/debian/changelog	2024-10-28 14:16:55.000000000 +0000
+++ 2.032-1/debian/changelog	2024-11-22 15:52:27.000000000 +0000
@@ -1,3 +1,10 @@
+libpdl-graphics-gnuplot-perl (2.032-1) unstable; urgency=medium
+
+  * Team upload.
+  * New upstream release.
+
+ -- Bas Couwenberg <sebastic@debian.org>  Fri, 22 Nov 2024 16:52:27 +0100
+
 libpdl-graphics-gnuplot-perl (2.031-1) unstable; urgency=medium
 
   * Team upload.
diff -pruN 2.031-1/examples/demo.pl 2.032-1/examples/demo.pl
--- 2.031-1/examples/demo.pl	2024-04-12 13:18:43.000000000 +0000
+++ 2.032-1/examples/demo.pl	2024-11-21 17:35:56.000000000 +0000
@@ -37,7 +37,6 @@ sub prompt {
 
 $w=gpwin(x11);
 
-
 $w->plot($x**2);
 prompt("A simple parabola");
 
@@ -85,6 +84,14 @@ $w->plot(cbmin => -600, cbmax => 600, ti
 	 $x, $x/2, (10-abs($x))/2);
 prompt("Variable pointsize");
 
+## filled curve
+$w->plot(
+    { with => 'filledcurves', fc => 'red', below => 'y=0' },
+    -$x, (-$x)**3,
+    { with => 'filledcurves', fillcolor => 'green', above => 'y=0' },
+    $x, ($x)**3
+);
+prompt("Area curve with filled colors");
 
 ################################
 # some 3d stuff
diff -pruN 2.031-1/lib/PDL/Graphics/Gnuplot.pm 2.032-1/lib/PDL/Graphics/Gnuplot.pm
--- 2.031-1/lib/PDL/Graphics/Gnuplot.pm	2024-10-28 03:30:01.000000000 +0000
+++ 2.032-1/lib/PDL/Graphics/Gnuplot.pm	2024-11-21 17:38:24.000000000 +0000
@@ -1709,6 +1709,31 @@ C<linespoints>).
 Selects a fractional size for point glyphs, relative to the default size
 on your terminal, for plots that render points as small glyphs.
 
+=item fillcolor (abbrev 'fc')
+
+Fills an area plot like C<filledcurves> with a color.
+It has the same format as C<linecolor>. This will fill the whole plot with
+the same color. To fill above a threshold or below a threshold, you need to
+use C<above> and C<below> options.
+
+An example to plot data in a single function call is below:
+
+    plot({ with => 'filledcurves', fillcolor => 'green', above => 'y=0' },
+        x, y,
+        { with => 'filledcurves', fillcolor => 'red', below => 'y=0' },
+        x, y);
+
+
+=item below
+
+This is used for C<filledcurves> to set a C<fillcolor> below a threshold.
+You can set the value like "y=0" if you want to color below the Y-axis value of 0.
+
+=item above
+
+This is used for C<filledcurves> to set a C<fillcolor> above a threshold.
+You can set the value like "y=0" if you want to color above the Y-axis value of 0.
+
 =item fillstyle (abbrev 'fs')
 
 Specify the way that filled regions should be colored, in plots that
@@ -2060,7 +2085,7 @@ our $echo_eating = 0;
 our $debug_echo = 0;                              # If set, mock up Losedows half-duplex pipes
 
 
-our $VERSION = '2.031';
+our $VERSION = '2.032';
 $VERSION = eval $VERSION;
 
 our $gp_version = undef;    # eventually gets the extracted gnuplot(1) version number.
@@ -3479,7 +3504,7 @@ EOF
     # The search over @$with will disappear with the deprecated compound-with form;
     # the real one is the second line that scans through curve options.
     my $ExtraColumns = grep /(palette|variable)/, @$with;
-    for my $k (qw/linecolor textcolor fillstyle pointsize linewidth/ ) {
+    for my $k (qw/linecolor textcolor fillstyle pointsize linewidth fillcolor/ ) {
       my $v = $chunk{options}{$k};
       next unless defined($v);
       my $s = ref $v eq 'ARRAY' ? join(" ",@$v) : $v;
@@ -5234,6 +5259,15 @@ our $cOptionsTable = {
     'linewidth'=> ['s', 'css',  undef, 12],
     'linecolor'=> ['l', 'ccolor',  undef, 13],
     'textcolor'=> ['l', 'ccolor',  undef, 14],
+    'below' => [ 'l', sub {
+        return "$_[0] $_[1][0]" if (defined $_[1] and defined $_[1][0]);
+        return "";
+    }, undef, 9.2],
+    'above' => [ 'l', sub {
+        return "$_[0] $_[1][0]" if (defined $_[1] and defined $_[1][0]);
+        return "";
+    }, undef, 9.3],
+    'fillcolor'=> ['l', 'ccolor', ['above', 'below'], 14.5],
     'pointtype'=> ['s', 'cs',  undef, 15],
     'pointsize'=> ['s', 'css',  undef, 16],
     'fillstyle'=> ['l', 'cl',  undef, 17],
@@ -5266,7 +5300,8 @@ our $cOptionsAbbrevs = _gen_abbrev_list(
 	lc => ["linecolor"],
 	pt => ["pointtype"],
 	ps => ["pointsize"],
-	fs => ["fillstyle"]
+	fs => ["fillstyle"],
+	fc => ["fillcolor"],
     };
     for my $k(%$officialAbbrevs){
 	$cOptionsAbbrevs->{$k} = $officialAbbrevs->{$k};
