diff -pruN 2.027-1/CHANGES 2.031-1/CHANGES
--- 2.027-1/CHANGES	2024-07-31 17:24:42.000000000 +0000
+++ 2.031-1/CHANGES	2024-10-28 03:30:18.000000000 +0000
@@ -1,3 +1,16 @@
+2.031 2024-10-28
+- add default SIG{TERM,INT,QUIT,HUP} handler to close more gracefully
+- handle glx etc warnings from Gnuplot (https://github.com/PDLPorters/PDL-Graphics-Simple/issues/10) - thanks @eserte for report
+
+2.030 2024-09-29
+- require PDL version that has raster2fits; previously didn't require one with t_raster2fits which test used
+
+2.029 2024-09-24
+- Gnuplot 6: handle all Qt warnings
+
+2.028 2024-09-18
+- Gnuplot 6: handle warnings about Qt plugins, fix read_mouse
+
 2.027 2024-07-31
 - add "resample" curve option for with=>'fits'
 - with=>'fits' error if no FITS header
diff -pruN 2.027-1/META.json 2.031-1/META.json
--- 2.027-1/META.json	2024-07-31 17:25:35.000000000 +0000
+++ 2.031-1/META.json	2024-10-28 03:30:55.000000000 +0000
@@ -39,7 +39,8 @@
             "IPC::Open3" : "0",
             "IPC::Run" : "0",
             "List::Util" : "0",
-            "PDL" : "0",
+            "PDL" : "2.093",
+            "PDL::Transform" : "0",
             "PDL::Transform::Color" : "0",
             "Safe::Isa" : "0",
             "Storable" : "0",
@@ -64,6 +65,6 @@
          "url" : "git://github.com/PDLPorters/PDL-Graphics-Gnuplot.git"
       }
    },
-   "version" : "2.027",
+   "version" : "2.031",
    "x_serialization_backend" : "JSON::PP version 4.04"
 }
diff -pruN 2.027-1/META.yml 2.031-1/META.yml
--- 2.027-1/META.yml	2024-07-31 17:25:35.000000000 +0000
+++ 2.031-1/META.yml	2024-10-28 03:30:55.000000000 +0000
@@ -26,7 +26,8 @@ requires:
   IPC::Open3: '0'
   IPC::Run: '0'
   List::Util: '0'
-  PDL: '0'
+  PDL: '2.093'
+  PDL::Transform: '0'
   PDL::Transform::Color: '0'
   Safe::Isa: '0'
   Storable: '0'
@@ -36,5 +37,5 @@ resources:
   bugtracker: http://github.com/PDLPorters/PDL-Graphics-Gnuplot/issues
   homepage: http://github.com/PDLPorters/PDL-Graphics-Gnuplot
   repository: git://github.com/PDLPorters/PDL-Graphics-Gnuplot.git
-version: '2.027'
+version: '2.031'
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
diff -pruN 2.027-1/Makefile.PL 2.031-1/Makefile.PL
--- 2.027-1/Makefile.PL	2024-04-20 12:32:38.000000000 +0000
+++ 2.031-1/Makefile.PL	2024-09-29 07:56:30.000000000 +0000
@@ -44,7 +44,8 @@ WriteMakefile(
     },
     PREREQ_PM => { 
 	    'Alien::Gnuplot'      => '1.031',
-	    'PDL'                 => 0,
+	    'PDL'                 => '2.093', # raster2fits
+	    'PDL::Transform'      => 0, # anticipating split
 	    'PDL::Transform::Color' => 0,
 	    'IPC::Run'            => 0,
 	    'List::Util'          => 0,
diff -pruN 2.027-1/README.pod 2.031-1/README.pod
--- 2.027-1/README.pod	2024-07-31 17:25:23.000000000 +0000
+++ 2.031-1/README.pod	2024-09-29 07:56:42.000000000 +0000
@@ -1879,7 +1879,7 @@ Many hardcopy output terminals (such as
 dump their plot to the file unless the file is explicitly closed with a
 change of output device or a call to C<reset>, C<restart>, or C<close>.
 This is because those devices support multipage output and also require
-and end-of-file marker to close the file.
+an end-of-file marker to close the file.
 
 =head1 Plotting examples
 
diff -pruN 2.027-1/debian/changelog 2.031-1/debian/changelog
--- 2.027-1/debian/changelog	2024-07-31 19:16:12.000000000 +0000
+++ 2.031-1/debian/changelog	2024-10-28 14:16:55.000000000 +0000
@@ -1,3 +1,32 @@
+libpdl-graphics-gnuplot-perl (2.031-1) unstable; urgency=medium
+
+  * Team upload.
+  * New upstream release.
+
+ -- Bas Couwenberg <sebastic@debian.org>  Mon, 28 Oct 2024 15:16:55 +0100
+
+libpdl-graphics-gnuplot-perl (2.030-1) unstable; urgency=medium
+
+  * Team upload.
+  * New upstream release.
+  * Require at least pdl 1:2.093.
+
+ -- Bas Couwenberg <sebastic@debian.org>  Tue, 01 Oct 2024 15:19:32 +0200
+
+libpdl-graphics-gnuplot-perl (2.029-1) unstable; urgency=medium
+
+  * Team upload.
+  * New upstream release.
+
+ -- Bas Couwenberg <sebastic@debian.org>  Wed, 25 Sep 2024 17:49:07 +0200
+
+libpdl-graphics-gnuplot-perl (2.028-1) unstable; urgency=medium
+
+  * Team upload.
+  * New upstream release.
+
+ -- Bas Couwenberg <sebastic@debian.org>  Thu, 19 Sep 2024 18:16:54 +0200
+
 libpdl-graphics-gnuplot-perl (2.027-1) unstable; urgency=medium
 
   * Team upload.
diff -pruN 2.027-1/debian/control 2.031-1/debian/control
--- 2.027-1/debian/control	2024-07-28 18:18:38.000000000 +0000
+++ 2.031-1/debian/control	2024-10-01 13:18:09.000000000 +0000
@@ -9,7 +9,7 @@ Build-Depends: debhelper-compat (= 13),
                libalien-gnuplot-perl,
                libipc-run-perl,
                libsafe-isa-perl,
-               pdl,
+               pdl (>= 1:2.093),
                perl,
                gnuplot-nox | gnuplot-x11 | gnuplot-qt
 Standards-Version: 4.7.0
diff -pruN 2.027-1/lib/PDL/Demos/Gnuplot.pm 2.031-1/lib/PDL/Demos/Gnuplot.pm
--- 2.027-1/lib/PDL/Demos/Gnuplot.pm	2024-07-29 18:14:42.000000000 +0000
+++ 2.031-1/lib/PDL/Demos/Gnuplot.pm	2024-09-27 20:11:25.000000000 +0000
@@ -1,5 +1,4 @@
 package PDL::Demos::Gnuplot;
-use PDL::Graphics::Gnuplot;
 use File::Spec;
 
 my $subst = "";
diff -pruN 2.027-1/lib/PDL/Graphics/Gnuplot.pm 2.031-1/lib/PDL/Graphics/Gnuplot.pm
--- 2.027-1/lib/PDL/Graphics/Gnuplot.pm	2024-07-31 17:24:23.000000000 +0000
+++ 2.031-1/lib/PDL/Graphics/Gnuplot.pm	2024-10-28 03:30:01.000000000 +0000
@@ -67,7 +67,6 @@
 # each option.  Since this mechanism is near at hand, we use it even
 # for routines (such as read_polygon) that could and would use
 # PDL::Options in other circumstances.
-#
 
 =encoding UTF-8
 
@@ -1942,7 +1941,7 @@ Many hardcopy output terminals (such as
 dump their plot to the file unless the file is explicitly closed with a
 change of output device or a call to C<reset>, C<restart>, or C<close>.
 This is because those devices support multipage output and also require
-and end-of-file marker to close the file.
+an end-of-file marker to close the file.
 
 =head1 Plotting examples
 
@@ -2061,7 +2060,7 @@ our $echo_eating = 0;
 our $debug_echo = 0;                              # If set, mock up Losedows half-duplex pipes
 
 
-our $VERSION = '2.027';
+our $VERSION = '2.031';
 $VERSION = eval $VERSION;
 
 our $gp_version = undef;    # eventually gets the extracted gnuplot(1) version number.
@@ -2076,6 +2075,8 @@ our @EXPORT_OK = qw(
 );
 our @EXPORT = qw(gpwin gplot greplot greset grestart);
 
+$SIG{TERM} = $SIG{INT} = $SIG{QUIT} = $SIG{HUP} = sub { die; };
+
 # when testing plots with binary i/o, this is the unit of test data
 my $testdataunit_binary = "........"; # 8 bytes - length of an IEEE double
 
@@ -2392,13 +2393,13 @@ FOO
 
 	    # Default the 'persist' option to 0, so that interactive windows behave nicely unless
 	    # asked to stay.
-	    if(exists($termTab->{$terminal}->{opt}->[0]->{persist})  and
+	    if (exists($termTab->{$terminal}{opt}[0]{persist}) and
 	       !defined($termOptions->{persist}) ) {
 		$termOptions->{persist} = 0;
 	    }
 
 	    # Default the 'dashed' option to 1.
-	    if(exists($termTab->{$terminal}->{opt}->[0]->{dashed})  and
+	    if (exists($termTab->{$terminal}{opt}[0]{dashed}) and
 	       !defined($termOptions->{dashed}) ) {
 		$termOptions->{dashed} = 1;
 	    }
@@ -2454,7 +2455,6 @@ sub DESTROY
   _killGnuplot($this);
 }
 
-
 =pod
 
 =head2 close
@@ -2585,7 +2585,7 @@ sub reset {
     if ($check_syntax) {
 	# Send multiple newlines to avoid bugs in certain gnuplots, which
 	# appear to lose a character after reset.
-	_printGnuplotPipe( $this, "syntax", "reset\n\n\n");
+	_printGnuplotPipe($this, "syntax", "reset\n\n\n");
 	$checkpointMessage = _checkpoint($this,"syntax");
     }
     _printGnuplotPipe($this, "main", "reset\n\n\n");
@@ -3058,12 +3058,14 @@ unset ylabel
 unset cblabel
 unset xrange
 unset yrange
+unset link x2
+unset link y2
+POS
+	$plotOptionsString .= <<'POS' if $gp_numversion >= 5.002;
 unset nonlinear x
 unset nonlinear y
 unset nonlinear x2
 unset nonlinear y2
-unset link x2
-unset link y2
 POS
     } else {
 	# In single-plot mode, just issue a reset.  Multiple newlines to work around a gnuplot problem.
@@ -3313,7 +3315,7 @@ sub _emit_ascii {
   return ["\$PGG_data_$chunk_i << e\n${chunk}e\n", {data => 1}]
     if !$MS_io_braindamage;
   my $pipe_stuff = !$this->{dumping} && $echo_eating;
-  ((map $pipe_stuff ? \$_ : $_, map ["$_\n", {data => 1 }], "\$PGG_data_$chunk_i <<e", split /\n/, $chunk), ["e\n", {data => 1 }]);
+  ((map $pipe_stuff ? \$_ : $_, map ["$_\n", {data => 1}], "\$PGG_data_$chunk_i <<e", split /\n/, $chunk), ["e\n", {data => 1 }]);
 }
 
 #####################
@@ -3704,7 +3706,7 @@ sub matchDims
           $data_dims[$i] = $ddims[$i];
         }
         elsif( ( $ddims[$i]>1) && ($ddims[$i] != $data_dims[$i] )) {
-          barf "plot(): mismatched arguments in tuple (position $i)\n";
+          barf "plot(): mismatched arguments in tuple; dims of data item $i=(@ddims), but data_dims=(@data_dims)";
         }
       }
     }
@@ -4039,8 +4041,8 @@ Added in 2.025.
 
  $w=gpwin();
  $w->multiplot(layout=>[2,1]);
- $w->plot({title=>"points},with=>'points',$a,$b);
- $w->plot({title=>"lines",with=>"lines",$a,$b);
+ $w->plot({title=>"points"},with=>'points',$a,$b);
+ $w->plot({title=>"lines"},with=>"lines",$a,$b);
  $w->end_multi();
 
 =for ref
@@ -4100,7 +4102,7 @@ sub multiplot_generate {
 	my $test_preamble = "set terminal dumb\nset output \" \"\n";
 	$PDL::Graphics::Gnuplot::last_testcmd = $test_preamble . $command;
 	$this->{last_testcmd} = $test_preamble . $command;
-	_printGnuplotPipe( $this, "syntax", $test_preamble . $command);
+	_printGnuplotPipe($this, "syntax", $test_preamble . $command);
 	my $checkpointMessage = _checkpoint($this, "syntax");
 	if ($checkpointMessage) {
 	    if($MS_io_braindamage) {
@@ -4169,7 +4171,7 @@ sub end_multi_generate {
   barf "end_multi: you can't, you're not in multiplot mode\n"
     unless $this->{options}{multiplot};
   if ($check_syntax) {
-    _printGnuplotPipe( $this, "syntax", "unset multiplot\n");
+    _printGnuplotPipe($this, "syntax", "unset multiplot\n");
     my $checkpointMessage = _checkpoint($this, "syntax");
     barf "Gnuplot error: unset multiplot failed on syntax check!\n$checkpointMessage"
       if $checkpointMessage;
@@ -4265,7 +4267,7 @@ EOC
 	$string = _checkpoint($this, "main", {notimeout=>1});
 
 	$string =~ m/Key: (\-?\d+)( +at xy:([^\s\,]+)\,([^\s\,]+)? button:(\d+)? shift:(\d+) alt:(\d+) ctrl:(\d+))?\s*$/
-	    || barf "read_mouse: string $string doesn't look right - doesn't match parse regexp.\n";
+	    || barf "read_mouse: string '$string' doesn't look right - doesn't match parse regexp.\n";
 
 	($ch,$x,$y,$b,$sft,$alt,$ctl) = map $_//"", ($1,$3,$4,$5,$6,$7,$8);
 
@@ -4284,8 +4286,8 @@ EOC
 	$string = _checkpoint($this, "main", {notimeout=>1});
 	$string =~ s/[\r\n]/ /sg;
 
-	$string =~ m/Key:(\-?\d+)( +at xy:([^\s\,]+)\,([^\s\,]+) shift:(\d+) alt:(\d+) ctrl:(\d+))?/
-	    || barf "read_mouse: string $string doesn't look right - doesn't match parse regexp.\n";
+	$string =~ m/Key:\s*(\-?\d+)( +at xy:\s*([^\s\,]+)\s*\,\s*([^\s\,]+) shift:\s*(\d+) alt:\s*(\d+) ctrl:\s*(\d+))?/
+	    || barf "read_mouse: string '$string' doesn't look right - doesn't match parse regexp.\n";
 
 	($ch,$x,$y,$sft,$alt,$ctl) = map $_ // "", ($1,$3,$4,$5,$6,$7);
 
@@ -7272,7 +7274,8 @@ sub _killGnuplot {
 	    $z = waitpid($goner,0);
 
 	} else {
-	    _printGnuplotPipe($this,$suffix,"set term qt 0 close\n") if $this->{terminal} eq 'qt';
+	    _printGnuplotPipe($this,$suffix,"unset multiplot\n") if $this->{options}{multiplot};
+	    _printGnuplotPipe($this,$suffix,"set term qt 0 close\n") if ($this->{terminal}//'') eq 'qt';
 	    _printGnuplotPipe($this,$suffix,"exit\n");
 
 	    # Give it 2 seconds to quit, then interrupt it again.
@@ -7302,10 +7305,8 @@ sub _killGnuplot {
 
 	    $z = waitpid($goner, 0);
 	    alarm(0);
-
 	}
 
-
 	unless($z == $goner) {
 	    # If for some reason it didn't die, fire and forget.
 	    kill 'KILL', $goner;
@@ -7470,6 +7471,7 @@ sub _printGnuplotPipe
 # are explicitly stripped out
 our $cp_serial = 0;
 
+my $graphics_re = qr/^(?:qt\.|XType:|MESA:|QSocketNotifier:|glx:|failed to load).*/m;
 sub _checkpoint {
     my $this   = shift;
     my $suffix = shift || "main";
@@ -7602,16 +7604,18 @@ EOM
     # that some warnings come with a line specifier and others don't.
 
   WARN: while( $fromerr =~ m/^(\s*(line \d+\:\s*)?[wW]arning\:.*)$/m or
+	       $fromerr =~ m/$graphics_re/ or
 	       $fromerr =~ m/^Populating font family aliases took/m     # CED - Quicktime on MacOS Catalina throws a warning marked as an error.  Stupid.
 	) {
-      if($2){
+      if ($2) {
 	  # it's a warning with a line specifier. Break off two more lines before it.
 	  last WARN unless($fromerr =~ s/^((gnu|multi)plot\>.*\n\s*\^\s*\n\s*(line \d+\:\s*)?[wW]arning\:.*(\n|$))//m);
 	  my $a = $1;
 	  $a =~ s/^\s*line \d+\:/Gnuplot:/m;
 	  carp $a if($printwarnings);
       } else {
-	  last WARN unless($fromerr =~ s/^(\s*(line \d+\:\s*)?[wW](arning\:.*(\n|$)))//m);
+	  $fromerr =~ s/$graphics_re//;
+	  last WARN unless $fromerr =~ s/^(\s*(line \d+\:\s*)?[wW](arning\:.*(\n|$)))//m;
 	  carp "Gnuplot w$3\n" if($printwarnings);
       }
 
diff -pruN 2.027-1/t/aa.t 2.031-1/t/aa.t
--- 2.027-1/t/aa.t	2024-04-12 13:18:43.000000000 +0000
+++ 2.031-1/t/aa.t	2024-09-27 07:30:24.000000000 +0000
@@ -27,7 +27,7 @@ for my $term (sort @valid_terms) {
     ok $suffix, 'have suffix';
 
     my (undef, $testoutput) = tempfile('pdl_graphics_gnuplot_test_aa_XXXXXXX',
-      SUFFIX => $suffix);
+      SUFFIX => $suffix, UNLINK => 1);
 
     my $x = zeroes(50)->xlinvals(0, 7);
     my $w = gpwin($term, output => $testoutput, aa => 2);
diff -pruN 2.027-1/t/plot.t 2.031-1/t/plot.t
--- 2.027-1/t/plot.t	2024-07-31 17:23:09.000000000 +0000
+++ 2.031-1/t/plot.t	2024-10-02 23:23:19.000000000 +0000
@@ -4,7 +4,7 @@ use Test::More;
 use PDL::Graphics::Gnuplot qw(plot gpwin);
 use File::Temp qw(tempfile);
 use PDL;
-use PDL::Transform::Cartography; # t_raster2fits
+use PDL::Transform::Cartography; # raster2fits
 
 ##########
 # Uncomment these to test error handling on Microsoft Windows, from within POSIX....
@@ -167,7 +167,7 @@ unlink($testoutput) or warn "\$!: $! for
   eval {$w->plot({with => 'fits', resample=>[100,100]},$r9)};
   is($@, '', "with 'fits', resample [100,100]");
   my $r9_rgb = pdl(0,$r9,$r9)->mv(-1,0); $r9_rgb->slice(0) .= 6; $r9_rgb *= 20;
-  eval {$w->plot({with => 'fits'}, t_raster2fits()->apply($r9_rgb))};
+  eval {$w->plot({with => 'fits'}, scalar raster2fits($r9_rgb, @PDL::Transform::Cartography::PLATE_CARREE))}; # scalar is because typo in 2.093 with "," instead of ";"
   is($@, '', "with 'fits', rgb");
 }
 
@@ -549,9 +549,11 @@ SKIP: {
 	skip "Skipping interactive tests - set env. variable GNUPLOT_INTERACTIVE to enable.",29;
     }
 
-    eval { $w = gpwin('wxt') };
-    eval { $w = gpwin('x11') } if $@;
-    is($@, '', "created a wxt or x11 plot object");
+    for (qw(qt wxt x11)) {
+      eval { $w = gpwin($_) };
+      last if !$@;
+    }
+    is($@, '', "created a plot object");
 
     isa_ok $PDL::Graphics::Gnuplot::termTab->{$w->{terminal}}, 'HASH', "Terminal is a known type";
 
