diff -pruN 0.146-1/Changes 0.148-1/Changes
--- 0.146-1/Changes	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/Changes	2025-03-17 11:18:52.675364886 +0000
@@ -1,5 +1,19 @@
 Revision history for Path-Tiny
 
+0.148     2025-03-17 07:18:28-04:00 America/New_York
+
+    [Bug fixes]
+    - Fixed problems with exceptions.
+
+    [Documentation]
+    - Cross-referenced slurp and lines.
+
+0.147     2025-03-10 22:11:06-04:00 America/New_York (TRIAL RELEASE)
+
+    [Changes]
+
+    - Invalid arguments when hash references are expected throw exceptions.
+
 0.146     2024-05-08 08:27:52-04:00 America/New_York
 
     - No changes from 0.145-TRIAL
@@ -328,7 +342,7 @@ Revision history for Path-Tiny
     - The 'absolute' method now always returns an absolute path, even if a
       user provided a relative path for the base path.  The old, odd
       behavior was documented, but people often don't read docs.  The new
-      behavior avoids suprises.
+      behavior avoids surprises.
 
     [Additions]
 
@@ -1072,7 +1086,7 @@ Revision history for Path-Tiny
 
     [CHANGED]
 
-    - slurp/spew/etc and openr/openw/etc now repect default layers
+    - slurp/spew/etc and openr/openw/etc now respect default layers
       set by -C or the open pragma
 
     - spew and append can now be given array references to output
diff -pruN 0.146-1/MANIFEST 0.148-1/MANIFEST
--- 0.146-1/MANIFEST	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/MANIFEST	2025-03-17 11:18:52.677076317 +0000
@@ -1,4 +1,4 @@
-# This file was automatically generated by Dist::Zilla::Plugin::Manifest v6.031.
+# This file was automatically generated by Dist::Zilla::Plugin::Manifest v6.032.
 CONTRIBUTING.mkdn
 Changes
 LICENSE
diff -pruN 0.146-1/META.json 0.148-1/META.json
--- 0.146-1/META.json	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/META.json	2025-03-17 11:18:52.677959116 +0000
@@ -4,7 +4,7 @@
       "David Golden <dagolden@cpan.org>"
    ],
    "dynamic_config" : 0,
-   "generated_by" : "Dist::Zilla version 6.031, CPAN::Meta::Converter version 2.150010",
+   "generated_by" : "Dist::Zilla version 6.032, CPAN::Meta::Converter version 2.150010",
    "license" : [
       "apache_2_0"
    ],
@@ -58,7 +58,7 @@
             "Test::Pod" : "1.41",
             "Test::Pod::Coverage" : "1.08",
             "Test::Portability::Files" : "0",
-            "Test::Spelling" : "0.12",
+            "Test::Spelling" : "0.17",
             "Test::Version" : "1"
          }
       },
@@ -113,11 +113,11 @@
    "provides" : {
       "Path::Tiny" : {
          "file" : "lib/Path/Tiny.pm",
-         "version" : "0.146"
+         "version" : "0.148"
       },
       "Path::Tiny::Error" : {
          "file" : "lib/Path/Tiny.pm",
-         "version" : "0.146"
+         "version" : "0.148"
       }
    },
    "release_status" : "stable",
@@ -132,7 +132,7 @@
          "web" : "https://github.com/dagolden/Path-Tiny"
       }
    },
-   "version" : "0.146",
+   "version" : "0.148",
    "x_authority" : "cpan:DAGOLDEN",
    "x_contributors" : [
       "Alex Efros <powerman@powerman.name>",
@@ -158,23 +158,27 @@
       "Mark Ellis <mark.ellis@cartridgesave.co.uk>",
       "Martin H. Sluka <fany@cpan.org>",
       "Martin Kjeldsen <mk@bluepipe.dk>",
+      "Martin Sluka <martin@sluka.de>",
       "Mary Ehlers <regina.verb.ae@gmail.com>",
       "Michael G. Schwern <mschwern@cpan.org>",
+      "NATARAJ (Nikolay Shaplov) <dhyan@nataraj.su>",
       "Nicolas R <nicolas@atoomic.org>",
       "Nicolas Rochelemagne <rochelemagne@cpanel.net>",
       "Nigel Gregoire <nigelgregoire@gmail.com>",
       "Philippe Bruhat (BooK) <book@cpan.org>",
       "regina-verbae <regina-verbae@users.noreply.github.com>",
+      "Ricardo Signes <rjbs@semiotic.systems>",
       "Roy Ivy III <rivy@cpan.org>",
       "Shlomi Fish <shlomif@shlomifish.org>",
       "Smylers <Smylers@stripey.com>",
       "Tatsuhiko Miyagawa <miyagawa@bulknews.net>",
       "Toby Inkster <tobyink@cpan.org>",
       "Yanick Champoux <yanick@babyl.dyndns.org>",
+      "yoshikazusawa <883514+yoshikazusawa@users.noreply.github.com>",
       "\uae40\ub3c4\ud615 - Keedi Kim <keedi@cpan.org>"
    ],
-   "x_generated_by_perl" : "v5.36.0",
-   "x_serialization_backend" : "Cpanel::JSON::XS version 4.29",
+   "x_generated_by_perl" : "v5.40.0",
+   "x_serialization_backend" : "Cpanel::JSON::XS version 4.39",
    "x_spdx_expression" : "Apache-2.0"
 }
 
diff -pruN 0.146-1/META.yml 0.148-1/META.yml
--- 0.146-1/META.yml	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/META.yml	2025-03-17 11:18:52.676764189 +0000
@@ -18,7 +18,7 @@ configure_requires:
   ExtUtils::MakeMaker: '6.17'
   perl: '5.008001'
 dynamic_config: 0
-generated_by: 'Dist::Zilla version 6.031, CPAN::Meta::Converter version 2.150010'
+generated_by: 'Dist::Zilla version 6.032, CPAN::Meta::Converter version 2.150010'
 license: apache
 meta-spec:
   url: http://module-build.sourceforge.net/META-spec-v1.4.html
@@ -36,10 +36,10 @@ no_index:
 provides:
   Path::Tiny:
     file: lib/Path/Tiny.pm
-    version: '0.146'
+    version: '0.148'
   Path::Tiny::Error:
     file: lib/Path/Tiny.pm
-    version: '0.146'
+    version: '0.148'
 recommends:
   Unicode::UTF8: '0.58'
 requires:
@@ -67,7 +67,7 @@ resources:
   bugtracker: https://github.com/dagolden/Path-Tiny/issues
   homepage: https://github.com/dagolden/Path-Tiny
   repository: https://github.com/dagolden/Path-Tiny.git
-version: '0.146'
+version: '0.148'
 x_authority: cpan:DAGOLDEN
 x_contributors:
   - 'Alex Efros <powerman@powerman.name>'
@@ -93,20 +93,24 @@ x_contributors:
   - 'Mark Ellis <mark.ellis@cartridgesave.co.uk>'
   - 'Martin H. Sluka <fany@cpan.org>'
   - 'Martin Kjeldsen <mk@bluepipe.dk>'
+  - 'Martin Sluka <martin@sluka.de>'
   - 'Mary Ehlers <regina.verb.ae@gmail.com>'
   - 'Michael G. Schwern <mschwern@cpan.org>'
+  - 'NATARAJ (Nikolay Shaplov) <dhyan@nataraj.su>'
   - 'Nicolas R <nicolas@atoomic.org>'
   - 'Nicolas Rochelemagne <rochelemagne@cpanel.net>'
   - 'Nigel Gregoire <nigelgregoire@gmail.com>'
   - 'Philippe Bruhat (BooK) <book@cpan.org>'
   - 'regina-verbae <regina-verbae@users.noreply.github.com>'
+  - 'Ricardo Signes <rjbs@semiotic.systems>'
   - 'Roy Ivy III <rivy@cpan.org>'
   - 'Shlomi Fish <shlomif@shlomifish.org>'
   - 'Smylers <Smylers@stripey.com>'
   - 'Tatsuhiko Miyagawa <miyagawa@bulknews.net>'
   - 'Toby Inkster <tobyink@cpan.org>'
   - 'Yanick Champoux <yanick@babyl.dyndns.org>'
+  - 'yoshikazusawa <883514+yoshikazusawa@users.noreply.github.com>'
   - '김도형 - Keedi Kim <keedi@cpan.org>'
-x_generated_by_perl: v5.36.0
-x_serialization_backend: 'YAML::Tiny version 1.73'
+x_generated_by_perl: v5.40.0
+x_serialization_backend: 'YAML::Tiny version 1.76'
 x_spdx_expression: Apache-2.0
diff -pruN 0.146-1/Makefile.PL 0.148-1/Makefile.PL
--- 0.146-1/Makefile.PL	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/Makefile.PL	2025-03-17 11:18:52.679606880 +0000
@@ -1,4 +1,4 @@
-# This file was automatically generated by Dist::Zilla::Plugin::MakeMaker v6.031.
+# This file was automatically generated by Dist::Zilla::Plugin::MakeMaker v6.032.
 use strict;
 use warnings;
 
@@ -49,7 +49,7 @@ my %WriteMakefileArgs = (
     "lib" => 0,
     "open" => 0
   },
-  "VERSION" => "0.146",
+  "VERSION" => "0.148",
   "test" => {
     "TESTS" => "t/*.t"
   }
diff -pruN 0.146-1/README 0.148-1/README
--- 0.146-1/README	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/README	2025-03-17 11:18:52.675119509 +0000
@@ -2,7 +2,7 @@ NAME
     Path::Tiny - File path utility
 
 VERSION
-    version 0.146
+    version 0.148
 
 SYNOPSIS
       use Path::Tiny;
@@ -66,7 +66,7 @@ DESCRIPTION
     the ":crlf" IO layer. Installing Unicode::UTF8 0.58 or later will speed
     up *_utf8 situations in many cases and is highly recommended.
     Alternatively, installing PerlIO::utf8_strict 0.003 or later will be
-    used in place of the default ":encoding(UTF-8)".
+    used in place of the default :encoding(UTF-8).
 
     This module depends heavily on PerlIO layers for correct operation and
     thus requires Perl 5.008001 or later.
@@ -88,14 +88,14 @@ CONSTRUCTORS
 
     DEPRECATED: If and only if the first character of the first argument to
     "path" is a tilde ('~'), then tilde replacement will be applied to the
-    first path segment. A single tilde will be replaced with "glob('~')" and
-    a tilde followed by a username will be replaced with output of
-    "glob('~username')". No other method does tilde expansion on its
+    first path segment. A single tilde will be replaced with glob('~') and a
+    tilde followed by a username will be replaced with output of
+    glob('~username'). No other method does tilde expansion on its
     arguments. See "Tilde expansion (deprecated)" for more.
 
     On Windows, if the path consists of a drive identifier without a path
     component ("C:" or "D:"), it will be expanded to the absolute path of
-    the current directory on that volume using "Cwd::getdcwd()".
+    the current directory on that volume using Cwd::getdcwd().
 
     If called with a single "Path::Tiny" argument, the original is returned
     unless the original is holding a temporary file or directory reference
@@ -137,7 +137,7 @@ CONSTRUCTORS
         $path = rootdir;             # optional export
 
     Gives you "File::Spec->rootdir" as a "Path::Tiny" object if you're too
-    picky for "path("/")".
+    picky for path("/").
 
     "rootdir" may be exported on request and used as a function instead of
     as a method.
@@ -245,7 +245,7 @@ METHODS
     and closed afterwards. An optional hash reference may be used to pass
     options. Valid options are:
 
-    *   "binmode": passed to "binmode()" on the handle used for writing.
+    *   "binmode": passed to binmode() on the handle used for writing.
 
     *   "truncate": truncates the file after locking and before appending
 
@@ -257,10 +257,9 @@ METHODS
     unbuffered, raw write.
 
     "append_utf8" is like "append" with an unbuffered "binmode"
-    ":unix:encoding(UTF-8)" (or ":unix:utf8_strict" with
-    PerlIO::utf8_strict). If Unicode::UTF8 0.58+ is installed, an
-    unbuffered, raw append will be done instead on the data encoded with
-    "Unicode::UTF8".
+    :unix:encoding(UTF-8) (or ":unix:utf8_strict" with PerlIO::utf8_strict).
+    If Unicode::UTF8 0.58+ is installed, an unbuffered, raw append will be
+    done instead on the data encoded with "Unicode::UTF8".
 
     Current API available since 0.060.
 
@@ -439,7 +438,7 @@ METHODS
     ":raw".
 
     "edit_lines_utf8" is like "edit_lines" with a buffered "binmode"
-    ":raw:encoding(UTF-8)" (or ":raw:utf8_strict" with PerlIO::utf8_strict).
+    :raw:encoding(UTF-8) (or ":raw:utf8_strict" with PerlIO::utf8_strict).
 
     Current API available since 0.077.
 
@@ -571,8 +570,8 @@ METHODS
 
     If a positive "count" is provided, that many lines will be returned from
     the start of the file. If a negative "count" is provided, the entire
-    file will be read, but only "abs(count)" will be kept and returned. If
-    "abs(count)" exceeds the number of lines in the file, all lines will be
+    file will be read, but only abs(count) will be kept and returned. If
+    abs(count) exceeds the number of lines in the file, all lines will be
     returned.
 
     If "chomp" is set, any end-of-line character sequences ("CR", "CRLF", or
@@ -586,13 +585,15 @@ METHODS
     "lines_raw" is like "lines" with a "binmode" of ":raw". We use ":raw"
     instead of ":unix" so PerlIO buffering can manage reading by line.
 
-    "lines_utf8" is like "lines" with a "binmode" of ":raw:encoding(UTF-8)"
+    "lines_utf8" is like "lines" with a "binmode" of :raw:encoding(UTF-8)
     (or ":raw:utf8_strict" with PerlIO::utf8_strict). If Unicode::UTF8 0.58+
     is installed, a raw, unbuffered UTF-8 slurp will be done and then the
     lines will be split. This is actually faster than relying on IO layers,
     though a bit memory intensive. If memory use is a concern, consider
     "openr_utf8" and iterating directly on the handle.
 
+    See also "slurp" if you want to load a file as a whole chunk.
+
     Current API available since 0.065.
 
   mkdir
@@ -607,12 +608,18 @@ METHODS
     similar to the Unix "mkdir -p" command. It will not error if applied to
     an existing directory.
 
+    Passing a defined argument *other* than a hash reference is an error,
+    and an exception will be thrown.
+
     Current API available since 0.125.
 
   mkpath (deprecated)
     Like calling "mkdir", but returns the list of directories created or an
     empty list if the directories already exist, just like "make_path".
 
+    Passing a defined argument *other* than a hash reference is an error,
+    and an exception will be thrown.
+
     Deprecated in 0.125.
 
   move
@@ -654,7 +661,7 @@ METHODS
     Returns a file handle opened in the specified mode. The "openr" style
     methods take a single "binmode" argument. All of the "open*" methods
     have "open*_raw" and "open*_utf8" equivalents that use buffered I/O
-    layers ":raw" and ":raw:encoding(UTF-8)" (or ":raw:utf8_strict" with
+    layers ":raw" and :raw:encoding(UTF-8) (or ":raw:utf8_strict" with
     PerlIO::utf8_strict).
 
     An optional hash reference may be used to pass options. The only option
@@ -777,6 +784,9 @@ METHODS
 
     Current API available since 0.013.
 
+    Passing a defined argument *other* than a hash reference is an error,
+    and an exception will be thrown.
+
   sibling
         $foo = path("/tmp/foo.txt");
         $sib = $foo->sibling("bar.txt");        # /tmp/bar.txt
@@ -822,17 +832,16 @@ METHODS
 
     Reads file contents into a scalar. Takes an optional hash reference
     which may be used to pass options. The only available option is
-    "binmode", which is passed to "binmode()" on the handle used for
-    reading.
+    "binmode", which is passed to binmode() on the handle used for reading.
 
     "slurp_raw" is like "slurp" with a "binmode" of ":unix" for a fast,
     unbuffered, raw read.
 
-    "slurp_utf8" is like "slurp" with a "binmode" of ":unix:encoding(UTF-8)"
+    "slurp_utf8" is like "slurp" with a "binmode" of :unix:encoding(UTF-8)
     (or ":unix:utf8_strict" with PerlIO::utf8_strict). If Unicode::UTF8
     0.58+ is installed, a unbuffered, raw slurp will be done instead and the
     result decoded with "Unicode::UTF8". This is just as strict and is
-    roughly an order of magnitude faster than using ":encoding(UTF-8)".
+    roughly an order of magnitude faster than using :encoding(UTF-8).
 
     Note: "slurp" and friends lock the filehandle before slurping. If you
     plan to slurp from a file created with File::Temp, be sure to close
@@ -841,6 +850,8 @@ METHODS
         my $tempfile = File::Temp->new(EXLOCK => 0);
         my $guts = path($tempfile)->slurp;
 
+    See also "lines" if you want to slurp a file into a line array.
+
     Current API available since 0.004.
 
   spew, spew_raw, spew_utf8
@@ -853,16 +864,15 @@ METHODS
     Writes data to a file atomically. The file is written to a temporary
     file in the same directory, then renamed over the original. An optional
     hash reference may be used to pass options. The only option is
-    "binmode", which is passed to "binmode()" on the handle used for
-    writing.
+    "binmode", which is passed to binmode() on the handle used for writing.
 
     "spew_raw" is like "spew" with a "binmode" of ":unix" for a fast,
     unbuffered, raw write.
 
-    "spew_utf8" is like "spew" with a "binmode" of ":unix:encoding(UTF-8)"
-    (or ":unix:utf8_strict" with PerlIO::utf8_strict). If Unicode::UTF8
-    0.58+ is installed, a raw, unbuffered spew will be done instead on the
-    data encoded with "Unicode::UTF8".
+    "spew_utf8" is like "spew" with a "binmode" of :unix:encoding(UTF-8) (or
+    ":unix:utf8_strict" with PerlIO::utf8_strict). If Unicode::UTF8 0.58+ is
+    installed, a raw, unbuffered spew will be done instead on the data
+    encoded with "Unicode::UTF8".
 
     NOTE: because the file is written to a temporary file and then renamed,
     the new file will wind up with permissions based on your current umask.
@@ -1005,14 +1015,14 @@ EXCEPTION HANDLING
     A "Path::Tiny::Error" object will be a hash reference with the following
     fields:
 
-    *   "op" — a description of the operation, usually function call and any
+    *   "op" â a description of the operation, usually function call and any
         extra info
 
-    *   "file" — the file or directory relating to the error
+    *   "file" â the file or directory relating to the error
 
-    *   "err" — hold $! at the time the error was thrown
+    *   "err" â hold $! at the time the error was thrown
 
-    *   "msg" — a string combining the above data and a Carp-like short
+    *   "msg" â a string combining the above data and a Carp-like short
         stack trace
 
     Exception objects will stringify as the "msg" field.
@@ -1042,8 +1052,8 @@ CAVEATS
 
         path( "~/foo.txt" )->copy( path( "~/bar.txt" ) );
 
-    If you need a literal leading tilde, use "path("./~whatever")" so that
-    the argument to "path" doesn't start with a tilde, but the path still
+    If you need a literal leading tilde, use path("./~whatever") so that the
+    argument to "path" doesn't start with a tilde, but the path still
     resolves to the current directory.
 
     Behaviour of tilde expansion with a username for non-existent users
@@ -1079,22 +1089,22 @@ CAVEATS
     permission, no lock will be used.
 
   utf8 vs UTF-8
-    All the *_utf8 methods by default use ":encoding(UTF-8)" -- either as
-    ":unix:encoding(UTF-8)" (unbuffered, for whole file operations) or
-    ":raw:encoding(UTF-8)" (buffered, for line-by-line operations). These
-    are strict against the Unicode spec and disallows illegal Unicode
-    codepoints or UTF-8 sequences.
+    All the *_utf8 methods by default use :encoding(UTF-8) -- either as
+    :unix:encoding(UTF-8) (unbuffered, for whole file operations) or
+    :raw:encoding(UTF-8) (buffered, for line-by-line operations). These are
+    strict against the Unicode spec and disallows illegal Unicode codepoints
+    or UTF-8 sequences.
 
-    Unfortunately, ":encoding(UTF-8)" is very, very slow. If you install
+    Unfortunately, :encoding(UTF-8) is very, very slow. If you install
     Unicode::UTF8 0.58 or later, that module will be used by some *_utf8
     methods to encode or decode data after a raw, binary input/output
     operation, which is much faster. Alternatively, if you install
-    PerlIO::utf8_strict, that will be used instead of ":encoding(UTF-8)" and
+    PerlIO::utf8_strict, that will be used instead of :encoding(UTF-8) and
     is also very fast.
 
     If you need the performance and can accept the security risk,
     "slurp({binmode => ":unix:utf8"})" will be faster than
-    ":unix:encoding(UTF-8)" (but not as fast as "Unicode::UTF8").
+    :unix:encoding(UTF-8) (but not as fast as "Unicode::UTF8").
 
     Note that the *_utf8 methods read in raw mode. There is no CRLF
     translation on Windows. If you must have CRLF translation, use the
@@ -1205,10 +1215,14 @@ CONTRIBUTORS
 
     *   Martin Kjeldsen <mk@bluepipe.dk>
 
+    *   Martin Sluka <martin@sluka.de>
+
     *   Mary Ehlers <regina.verb.ae@gmail.com>
 
     *   Michael G. Schwern <mschwern@cpan.org>
 
+    *   NATARAJ (Nikolay Shaplov) <dhyan@nataraj.su>
+
     *   Nicolas R <nicolas@atoomic.org>
 
     *   Nicolas Rochelemagne <rochelemagne@cpanel.net>
@@ -1219,6 +1233,8 @@ CONTRIBUTORS
 
     *   regina-verbae <regina-verbae@users.noreply.github.com>
 
+    *   Ricardo Signes <rjbs@semiotic.systems>
+
     *   Roy Ivy III <rivy@cpan.org>
 
     *   Shlomi Fish <shlomif@shlomifish.org>
@@ -1231,7 +1247,9 @@ CONTRIBUTORS
 
     *   Yanick Champoux <yanick@babyl.dyndns.org>
 
-    *   김도형 - Keedi Kim <keedi@cpan.org>
+    *   yoshikazusawa <883514+yoshikazusawa@users.noreply.github.com>
+
+    *   ê¹ëí - Keedi Kim <keedi@cpan.org>
 
 COPYRIGHT AND LICENSE
     This software is Copyright (c) 2014 by David Golden.
diff -pruN 0.146-1/cpanfile 0.148-1/cpanfile
--- 0.146-1/cpanfile	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/cpanfile	2025-03-17 11:18:52.676923316 +0000
@@ -1,4 +1,4 @@
-# This file is generated by Dist::Zilla::Plugin::CPANFile v6.031
+# This file is generated by Dist::Zilla::Plugin::CPANFile v6.032
 # Do not edit this file directly. To change prereqs, edit the `dist.ini` file.
 
 requires "Carp" => "0";
@@ -74,6 +74,6 @@ on 'develop' => sub {
   requires "Test::Pod" => "1.41";
   requires "Test::Pod::Coverage" => "1.08";
   requires "Test::Portability::Files" => "0";
-  requires "Test::Spelling" => "0.12";
+  requires "Test::Spelling" => "0.17";
   requires "Test::Version" => "1";
 };
diff -pruN 0.146-1/debian/changelog 0.148-1/debian/changelog
--- 0.146-1/debian/changelog	2024-07-02 13:23:48.000000000 +0000
+++ 0.148-1/debian/changelog	2025-03-29 22:01:25.000000000 +0000
@@ -1,3 +1,11 @@
+libpath-tiny-perl (0.148-1) unstable; urgency=medium
+
+  * Team upload.
+  * Import upstream version 0.148.
+  * Declare compliance with Debian Policy 4.7.2.
+
+ -- gregor herrmann <gregoa@debian.org>  Sat, 29 Mar 2025 23:01:25 +0100
+
 libpath-tiny-perl (0.146-1) unstable; urgency=medium
 
   [ upstream ]
diff -pruN 0.146-1/debian/control 0.148-1/debian/control
--- 0.146-1/debian/control	2024-07-02 13:23:25.000000000 +0000
+++ 0.148-1/debian/control	2025-03-29 22:01:25.000000000 +0000
@@ -11,7 +11,7 @@ Build-Depends:
 Maintainer: Debian Perl Group <pkg-perl-maintainers@lists.alioth.debian.org>
 Uploaders:
  Jonas Smedegaard <dr@jones.dk>,
-Standards-Version: 4.7.0
+Standards-Version: 4.7.2
 Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libpath-tiny-perl.git
 Vcs-Browser: https://salsa.debian.org/perl-team/modules/packages/libpath-tiny-perl
 Homepage: https://metacpan.org/module/Path::Tiny
diff -pruN 0.146-1/lib/Path/Tiny.pm 0.148-1/lib/Path/Tiny.pm
--- 0.146-1/lib/Path/Tiny.pm	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/lib/Path/Tiny.pm	2025-03-17 11:18:52.681822398 +0000
@@ -5,7 +5,7 @@ use warnings;
 package Path::Tiny;
 # ABSTRACT: File path utility
 
-our $VERSION = '0.146';
+our $VERSION = '0.148';
 
 # Dependencies
 use Config;
@@ -508,7 +508,7 @@ sub _resolve_symlinks {
     return $new;
 }
 
-sub _replacment_path {
+sub _replacement_path {
     my ($self) = @_;
 
     my $unique_suffix = $$ . int( rand( 2**31 ) );
@@ -619,7 +619,7 @@ sub append {
     $binmode = ( ( caller(0) )[10] || {} )->{'open>'} unless defined $binmode;
     my $mode = $args->{truncate} ? ">" : ">>";
     my $fh = $self->filehandle( { locked => 1 }, $mode, $binmode );
-    print( {$fh} map { ref eq 'ARRAY' ? @$_ : $_ } @data ) or self->_throw('print');
+    print( {$fh} map { ref eq 'ARRAY' ? @$_ : $_ } @data ) or $self->_throw('print');
     close $fh or $self->_throw('close');
 }
 
@@ -1022,7 +1022,7 @@ sub edit_lines {
     # writing needs to follow the link and create the tempfile in the same
     # dir for later atomic rename
     my $resolved_path = $self->_resolve_symlinks;
-    my $temp          = $resolved_path->_replacment_path;
+    my $temp          = $resolved_path->_replacement_path;
 
     my $temp_fh = $temp->filehandle( { exclusive => 1, locked => 1 }, ">", $binmode );
     my $in_fh = $self->filehandle( { locked => 1 }, '<', $binmode );
@@ -1031,7 +1031,7 @@ sub edit_lines {
     while (! eof($in_fh) ) {
         defined( $_ = readline($in_fh) ) or $self->_throw('readline');
         $cb->();
-        $temp_fh->print($_) or self->_throw('print', $temp);
+        $temp_fh->print($_) or $self->_throw('print', $temp);
     }
 
     close $temp_fh or $self->_throw( 'close', $temp );
@@ -1385,6 +1385,8 @@ sub iterator {
 #pod IO layers, though a bit memory intensive.  If memory use is a
 #pod concern, consider C<openr_utf8> and iterating directly on the handle.
 #pod
+#pod See also L</slurp> if you want to load a file as a whole chunk.
+#pod
 #pod Current API available since 0.065.
 #pod
 #pod =cut
@@ -1484,14 +1486,23 @@ sub lines_utf8 {
 #pod similar to the Unix C<mkdir -p> command.  It will not error if applied to an
 #pod existing directory.
 #pod
+#pod Passing a defined argument I<other> than a hash reference is an error, and an
+#pod exception will be thrown.
+#pod
 #pod Current API available since 0.125.
 #pod
 #pod =cut
 
 sub mkdir {
-    my ( $self, $args ) = @_;
-    $args = {} unless ref $args eq 'HASH';
+    my ( $self, $args, @rest ) = @_;
+
+    $args = {} unless defined $args;
+    if (@rest || (defined $args && ref $args ne 'HASH')) {
+        $self->_throw('mkdir', undef, "method argument was given, but was not a hash reference");
+    }
+
     my $err;
+
     $args->{error} = \$err unless defined $args->{error};
     require File::Path;
     my @dirs;
@@ -1514,13 +1525,21 @@ sub mkdir {
 #pod Like calling C<mkdir>, but returns the list of directories created or an empty list if
 #pod the directories already exist, just like C<make_path>.
 #pod
+#pod Passing a defined argument I<other> than a hash reference is an error, and an
+#pod exception will be thrown.
+#pod
 #pod Deprecated in 0.125.
 #pod
 #pod =cut
 
 sub mkpath {
-    my ( $self, $args ) = @_;
-    $args = {} unless ref $args eq 'HASH';
+    my ( $self, $args, @rest ) = @_;
+
+    $args = {} unless defined $args;
+    if (@rest || (defined $args && ref $args ne 'HASH')) {
+        $self->_throw('mkdir', undef, "method argument was given, but was not a hash reference");
+    }
+
     my $err;
     $args->{error} = \$err unless defined $args->{error};
     require File::Path;
@@ -1920,12 +1939,21 @@ sub remove {
 #pod
 #pod Current API available since 0.013.
 #pod
+#pod Passing a defined argument I<other> than a hash reference is an error, and an
+#pod exception will be thrown.
+#pod
 #pod =cut
 
 sub remove_tree {
-    my ( $self, $args ) = @_;
+    my ( $self, $args, @rest ) = @_;
+
+    $args = {} unless defined $args;
+    if (@rest || (defined $args && ref $args ne 'HASH')) {
+        $self->_throw('mkdir', undef, "method argument was given, but was not a hash reference");
+    }
+
     return 0 if !-e $self->[PATH] && !-l $self->[PATH];
-    $args = {} unless ref $args eq 'HASH';
+
     my $err;
     $args->{error} = \$err unless defined $args->{error};
     $args->{safe}  = 1     unless defined $args->{safe};
@@ -2054,6 +2082,8 @@ sub _human_size {
 #pod     my $tempfile = File::Temp->new(EXLOCK => 0);
 #pod     my $guts = path($tempfile)->slurp;
 #pod
+#pod See also L</lines> if you want to slurp a file into a line array.
+#pod
 #pod Current API available since 0.004.
 #pod
 #pod =cut
@@ -2138,7 +2168,7 @@ sub spew {
     # writing needs to follow the link and create the tempfile in the same
     # dir for later atomic rename
     my $resolved_path = $self->_resolve_symlinks;
-    my $temp          = $resolved_path->_replacment_path;
+    my $temp          = $resolved_path->_replacement_path;
 
     my $fh;
     my $ok = eval { $fh = $temp->filehandle( { exclusive => 1, locked => 1 }, ">", $binmode ); 1 };
@@ -2148,7 +2178,7 @@ sub spew {
             : "error opening temp file for atomic write: $@";
         $self->_throw('spew', $self->[PATH], $msg);
     }
-    print( {$fh} map { ref eq 'ARRAY' ? @$_ : $_ } @data) or self->_throw('print', $temp->[PATH]);
+    print( {$fh} map { ref eq 'ARRAY' ? @$_ : $_ } @data) or $self->_throw('print', $temp->[PATH]);
     close $fh or $self->_throw( 'close', $temp->[PATH] );
 
     return $temp->move($resolved_path);
@@ -2445,7 +2475,7 @@ Path::Tiny - File path utility
 
 =head1 VERSION
 
-version 0.146
+version 0.148
 
 =head1 SYNOPSIS
 
@@ -3069,6 +3099,8 @@ lines will be split.  This is actually f
 IO layers, though a bit memory intensive.  If memory use is a
 concern, consider C<openr_utf8> and iterating directly on the handle.
 
+See also L</slurp> if you want to load a file as a whole chunk.
+
 Current API available since 0.065.
 
 =head2 mkdir
@@ -3084,6 +3116,9 @@ B<NOTE>: unlike Perl's builtin C<mkdir>,
 similar to the Unix C<mkdir -p> command.  It will not error if applied to an
 existing directory.
 
+Passing a defined argument I<other> than a hash reference is an error, and an
+exception will be thrown.
+
 Current API available since 0.125.
 
 =head2 mkpath (deprecated)
@@ -3091,6 +3126,9 @@ Current API available since 0.125.
 Like calling C<mkdir>, but returns the list of directories created or an empty list if
 the directories already exist, just like C<make_path>.
 
+Passing a defined argument I<other> than a hash reference is an error, and an
+exception will be thrown.
+
 Deprecated in 0.125.
 
 =head2 move
@@ -3275,6 +3313,9 @@ C<rmdir> function instead.
 
 Current API available since 0.013.
 
+Passing a defined argument I<other> than a hash reference is an error, and an
+exception will be thrown.
+
 =head2 sibling
 
     $foo = path("/tmp/foo.txt");
@@ -3349,6 +3390,8 @@ close other handles or open without lock
     my $tempfile = File::Temp->new(EXLOCK => 0);
     my $guts = path($tempfile)->slurp;
 
+See also L</lines> if you want to slurp a file into a line array.
+
 Current API available since 0.004.
 
 =head2 spew, spew_raw, spew_utf8
@@ -3722,7 +3765,7 @@ David Golden <dagolden@cpan.org>
 
 =head1 CONTRIBUTORS
 
-=for stopwords Alex Efros Aristotle Pagaltzis Chris Williams Dan Book Dave Rolsky David Steinbrunner Doug Bell Elvin Aslanov Flavio Poletti Gabor Szabo Gabriel Andrade George Hartzell Geraud Continsouzas Goro Fuji Graham Knop Ollis Ian Sillitoe James Hunt John Karr Karen Etheridge Mark Ellis Martin H. Sluka Kjeldsen Mary Ehlers Michael G. Schwern Nicolas R Rochelemagne Nigel Gregoire Philippe Bruhat (BooK) regina-verbae Roy Ivy III Shlomi Fish Smylers Tatsuhiko Miyagawa Toby Inkster Yanick Champoux 김도형 - Keedi Kim
+=for stopwords Alex Efros Aristotle Pagaltzis Chris Williams Dan Book Dave Rolsky David Steinbrunner Doug Bell Elvin Aslanov Flavio Poletti Gabor Szabo Gabriel Andrade George Hartzell Geraud Continsouzas Goro Fuji Graham Knop Ollis Ian Sillitoe James Hunt John Karr Karen Etheridge Mark Ellis Martin H. Sluka Kjeldsen Mary Ehlers Michael G. Schwern NATARAJ (Nikolay Shaplov) Nicolas R Rochelemagne Nigel Gregoire Philippe Bruhat (BooK) regina-verbae Ricardo Signes Roy Ivy III Shlomi Fish Smylers Tatsuhiko Miyagawa Toby Inkster Yanick Champoux yoshikazusawa 김도형 - Keedi Kim
 
 =over 4
 
@@ -3820,6 +3863,10 @@ Martin Kjeldsen <mk@bluepipe.dk>
 
 =item *
 
+Martin Sluka <martin@sluka.de>
+
+=item *
+
 Mary Ehlers <regina.verb.ae@gmail.com>
 
 =item *
@@ -3828,6 +3875,10 @@ Michael G. Schwern <mschwern@cpan.org>
 
 =item *
 
+NATARAJ (Nikolay Shaplov) <dhyan@nataraj.su>
+
+=item *
+
 Nicolas R <nicolas@atoomic.org>
 
 =item *
@@ -3848,6 +3899,10 @@ regina-verbae <regina-verbae@users.norep
 
 =item *
 
+Ricardo Signes <rjbs@semiotic.systems>
+
+=item *
+
 Roy Ivy III <rivy@cpan.org>
 
 =item *
@@ -3872,6 +3927,10 @@ Yanick Champoux <yanick@babyl.dyndns.org
 
 =item *
 
+yoshikazusawa <883514+yoshikazusawa@users.noreply.github.com>
+
+=item *
+
 김도형 - Keedi Kim <keedi@cpan.org>
 
 =back
diff -pruN 0.146-1/t/00-report-prereqs.dd 0.148-1/t/00-report-prereqs.dd
--- 0.146-1/t/00-report-prereqs.dd	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/t/00-report-prereqs.dd	2025-03-17 11:18:52.684212502 +0000
@@ -31,7 +31,7 @@ do { my $x = {
                                       'Test::Pod' => '1.41',
                                       'Test::Pod::Coverage' => '1.08',
                                       'Test::Portability::Files' => '0',
-                                      'Test::Spelling' => '0.12',
+                                      'Test::Spelling' => '0.17',
                                       'Test::Version' => '1'
                                     }
                     },
diff -pruN 0.146-1/t/filesystem.t 0.148-1/t/filesystem.t
--- 0.146-1/t/filesystem.t	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/t/filesystem.t	2025-03-17 11:18:52.681202602 +0000
@@ -468,6 +468,20 @@ SKIP: {
       'spewing follows the link and replace the destination instead';
 }
 
+{
+    my $newtmp = Path::Tiny->tempdir;
+    my $to_delete = $newtmp->child('to-delete')->mkdir;
+
+    my $error = exception { $newtmp->remove_tree('to-delete'); };
+    like(
+      $error,
+      qr/method argument was given, but was not a hash reference/,
+      "passing a weird argument to ->remove_tree throws",
+    );
+
+    ok -d $newtmp, "we did not remove path after bad call to remove_tree";
+}
+
 # We don't have subsume so comment these out.  Keep in case we
 # implement it later
 
diff -pruN 0.146-1/t/mkdir.t 0.148-1/t/mkdir.t
--- 0.146-1/t/mkdir.t	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/t/mkdir.t	2025-03-17 11:18:52.677616822 +0000
@@ -28,6 +28,22 @@ if ( $^O ne 'MSWin32' ) {
     ok( -d $path2, "target directory created" );
 }
 
+{
+    for my $weird_args (
+        ["bogus"],  # a string, somebody thought it's the child name
+        [mode=>1],  # programmer forgot to wrap pairs in {...}
+        [{}, 1 ],   # valid {} but extra argument; oops!
+        [[]],       # weird mistake, but better to die than ignore
+    ) {
+        my $error = exception { $path->mkdir(@$weird_args) };
+        like(
+          $error,
+          qr/method argument was given, but was not a hash reference/,
+          "passing a weird argument to ->mkdir throws (@$weird_args)",
+        );
+    }
+}
+
 done_testing;
 #
 # This file is part of Path-Tiny
diff -pruN 0.146-1/t/mkpath.t 0.148-1/t/mkpath.t
--- 0.146-1/t/mkpath.t	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/t/mkpath.t	2025-03-17 11:18:52.678280327 +0000
@@ -27,6 +27,22 @@ if ( $^O ne 'MSWin32' ) {
     ok( -d $path2, "target directory created" );
 }
 
+{
+    for my $weird_args (
+        ["bogus"],  # a string, somebody thought it's the child name
+        [mode=>1],  # programmer forgot to wrap pairs in {...}
+        [{}, 1 ],   # valid {} but extra argument; oops!
+        [[]],       # weird mistake, but better to die than ignore
+    ) {
+        my $error = exception { $path->mkpath(@$weird_args) };
+        like(
+          $error,
+          qr/method argument was given, but was not a hash reference/,
+          "passing a weird argument to ->mkpath throws (@$weird_args)",
+        );
+    }
+}
+
 done_testing;
 #
 # This file is part of Path-Tiny
diff -pruN 0.146-1/xt/author/critic.t 0.148-1/xt/author/critic.t
--- 0.146-1/xt/author/critic.t	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/xt/author/critic.t	2025-03-17 11:18:52.683262786 +0000
@@ -3,5 +3,7 @@
 use strict;
 use warnings;
 
-use Test::Perl::Critic (-profile => "perlcritic.rc") x!! -e "perlcritic.rc";
+use Test::Perl::Critic %{+{
+  "-profile" => "perlcritic.rc",
+}};
 all_critic_ok();
diff -pruN 0.146-1/xt/author/pod-spell.t 0.148-1/xt/author/pod-spell.t
--- 0.146-1/xt/author/pod-spell.t	2024-05-08 12:28:10.000000000 +0000
+++ 0.148-1/xt/author/pod-spell.t	2025-03-17 11:18:52.683740165 +0000
@@ -2,14 +2,15 @@ use strict;
 use warnings;
 use Test::More;
 
-# generated by Dist::Zilla::Plugin::Test::PodSpelling 2.007005
-use Test::Spelling 0.12;
+# generated by Dist::Zilla::Plugin::Test::PodSpelling 2.007006
+use Test::Spelling 0.17;
 use Pod::Wordlist;
 
 
 add_stopwords(<DATA>);
 all_pod_files_spelling_ok( qw( bin lib ) );
 __DATA__
+883514
 AIX
 Alex
 Andrade
@@ -67,20 +68,25 @@ Mary
 MiB
 Michael
 Miyagawa
+NATARAJ
 NFS
 Nicolas
 Nigel
+Nikolay
 Ollis
 Pagaltzis
 Path
 Philippe
 Poletti
+Ricardo
 Rochelemagne
 Rolsky
 Roy
 SHA
 Schwern
+Shaplov
 Shlomi
+Signes
 Sillitoe
 Sluka
 Smylers
@@ -101,6 +107,7 @@ chainable
 codepoints
 cwd
 dagolden
+dhyan
 dirname
 dsteinbrunner
 ether
@@ -122,6 +129,7 @@ lib
 lstat
 madcityzen
 mark
+martin
 miyagawa
 mk
 mkdir
@@ -140,6 +148,7 @@ powerman
 realpath
 regina
 rivy
+rjbs
 rochelemagne
 rwp
 shlomif
@@ -153,4 +162,5 @@ touchpath
 unlinked
 utf
 yanick
+yoshikazusawa
 김도형
