diff -pruN 0.21-1/.editorconfig 0.22-1/.editorconfig
--- 0.21-1/.editorconfig	1970-01-01 00:00:00.000000000 +0000
+++ 0.22-1/.editorconfig	2024-10-11 17:37:16.000000000 +0000
@@ -0,0 +1,4 @@
+root = true
+
+[*.{pm,pl,t}]
+indent_size = 3
diff -pruN 0.21-1/Build.PL 0.22-1/Build.PL
--- 0.21-1/Build.PL	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/Build.PL	2024-10-11 17:37:16.000000000 +0000
@@ -1,3 +1,4 @@
+use v5;
 use strict;
 use warnings;
 
@@ -13,8 +14,7 @@ my $build = Module::Build->new(
    },
    test_requires => {
       'File::Temp' => 0,
-      'Test::Fatal' => 0,
-      'Test::More' => '0.88', # done_testing
+      'Test2::V0' => 0,
    },
    configure_requires => {
       'Module::Build' => '0.4004', # test_requires
diff -pruN 0.21-1/Changes 0.22-1/Changes
--- 0.21-1/Changes	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/Changes	2024-10-11 17:37:16.000000000 +0000
@@ -1,5 +1,15 @@
 Revision history for Parser-MGC
 
+0.22    2024-10-11
+        [CHANGES]
+         * Added `->warn` and `->warn_from`
+         * Pass additional arguments to `->maybe` method through to invoked
+           code
+         * Swap unit tests from `Test::More` to `Test2::V0`; avoids need for
+           `Test::Fatal`
+         * General module style updates/refresh to code style, documentation,
+           etc..
+
 0.21    2022-02-23
         [CHANGES]
          * Add stall-detection to list-repeating methods, in order to detect
diff -pruN 0.21-1/LICENSE 0.22-1/LICENSE
--- 0.21-1/LICENSE	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/LICENSE	2024-10-11 17:37:16.000000000 +0000
@@ -1,4 +1,4 @@
-This software is copyright (c) 2022 by Paul Evans <leonerd@leonerd.org.uk>.
+This software is copyright (c) 2024 by Paul Evans <leonerd@leonerd.org.uk>.
 
 This is free software; you can redistribute it and/or modify it under
 the same terms as the Perl 5 programming language system itself.
@@ -12,7 +12,7 @@ b) the "Artistic License"
 
 --- The GNU General Public License, Version 1, February 1989 ---
 
-This software is Copyright (c) 2022 by Paul Evans <leonerd@leonerd.org.uk>.
+This software is Copyright (c) 2024 by Paul Evans <leonerd@leonerd.org.uk>.
 
 This is free software, licensed under:
 
@@ -270,110 +270,143 @@ necessary.  Here a sample; alter the nam
 That's all there is to it!
 
 
---- The Artistic License 1.0 ---
+--- The Perl Artistic License 1.0 ---
 
-This software is Copyright (c) 2022 by Paul Evans <leonerd@leonerd.org.uk>.
+This software is Copyright (c) 2024 by Paul Evans <leonerd@leonerd.org.uk>.
 
 This is free software, licensed under:
 
-  The Artistic License 1.0
+  The Perl Artistic License 1.0
 
-The Artistic License
 
-Preamble
 
-The intent of this document is to state the conditions under which a Package
-may be copied, such that the Copyright Holder maintains some semblance of
-artistic control over the development of the package, while giving the users of
-the package the right to use and distribute the Package in a more-or-less
-customary fashion, plus the right to make reasonable modifications.
+
+
+                         The "Artistic License"
+
+                                Preamble
+
+The intent of this document is to state the conditions under which a
+Package may be copied, such that the Copyright Holder maintains some
+semblance of artistic control over the development of the package,
+while giving the users of the package the right to use and distribute
+the Package in a more-or-less customary fashion, plus the right to make
+reasonable modifications.
 
 Definitions:
 
-  - "Package" refers to the collection of files distributed by the Copyright
-    Holder, and derivatives of that collection of files created through
-    textual modification.
-  - "Standard Version" refers to such a Package if it has not been modified,
-    or has been modified in accordance with the wishes of the Copyright
-    Holder.
-  - "Copyright Holder" is whoever is named in the copyright or copyrights for
-    the package.
-  - "You" is you, if you're thinking about copying or distributing this Package.
-  - "Reasonable copying fee" is whatever you can justify on the basis of media
-    cost, duplication charges, time of people involved, and so on. (You will
-    not be required to justify it to the Copyright Holder, but only to the
-    computing community at large as a market that must bear the fee.)
-  - "Freely Available" means that no fee is charged for the item itself, though
-    there may be fees involved in handling the item. It also means that
-    recipients of the item may redistribute it under the same conditions they
-    received it.
+        "Package" refers to the collection of files distributed by the
+        Copyright Holder, and derivatives of that collection of files
+        created through textual modification.
+
+        "Standard Version" refers to such a Package if it has not been
+        modified, or has been modified in accordance with the wishes
+        of the Copyright Holder as specified below.
+
+        "Copyright Holder" is whoever is named in the copyright or
+        copyrights for the package.
+
+        "You" is you, if you're thinking about copying or distributing
+        this Package.
+
+        "Reasonable copying fee" is whatever you can justify on the
+        basis of media cost, duplication charges, time of people involved,
+        and so on.  (You will not be required to justify it to the
+        Copyright Holder, but only to the computing community at large
+        as a market that must bear the fee.)
+
+        "Freely Available" means that no fee is charged for the item
+        itself, though there may be fees involved in handling the item.
+        It also means that recipients of the item may redistribute it
+        under the same conditions they received it.
 
 1. You may make and give away verbatim copies of the source form of the
 Standard Version of this Package without restriction, provided that you
 duplicate all of the original copyright notices and associated disclaimers.
 
-2. You may apply bug fixes, portability fixes and other modifications derived
-from the Public Domain or from the Copyright Holder. A Package modified in such
-a way shall still be considered the Standard Version.
-
-3. You may otherwise modify your copy of this Package in any way, provided that
-you insert a prominent notice in each changed file stating how and when you
-changed that file, and provided that you do at least ONE of the following:
-
-  a) place your modifications in the Public Domain or otherwise make them
-     Freely Available, such as by posting said modifications to Usenet or an
-     equivalent medium, or placing the modifications on a major archive site
-     such as ftp.uu.net, or by allowing the Copyright Holder to include your
-     modifications in the Standard Version of the Package.
-
-  b) use the modified Package only within your corporation or organization.
-
-  c) rename any non-standard executables so the names do not conflict with
-     standard executables, which must also be provided, and provide a separate
-     manual page for each non-standard executable that clearly documents how it
-     differs from the Standard Version.
-
-  d) make other distribution arrangements with the Copyright Holder.
-
-4. You may distribute the programs of this Package in object code or executable
-form, provided that you do at least ONE of the following:
-
-  a) distribute a Standard Version of the executables and library files,
-     together with instructions (in the manual page or equivalent) on where to
-     get the Standard Version.
-
-  b) accompany the distribution with the machine-readable source of the Package
-     with your modifications.
-
-  c) accompany any non-standard executables with their corresponding Standard
-     Version executables, giving the non-standard executables non-standard
-     names, and clearly documenting the differences in manual pages (or
-     equivalent), together with instructions on where to get the Standard
-     Version.
+2. You may apply bug fixes, portability fixes and other modifications
+derived from the Public Domain or from the Copyright Holder.  A Package
+modified in such a way shall still be considered the Standard Version.
 
-  d) make other distribution arrangements with the Copyright Holder.
+3. You may otherwise modify your copy of this Package in any way, provided
+that you insert a prominent notice in each changed file stating how and
+when you changed that file, and provided that you do at least ONE of the
+following:
 
-5. You may charge a reasonable copying fee for any distribution of this
-Package.  You may charge any fee you choose for support of this Package. You
-may not charge a fee for this Package itself. However, you may distribute this
-Package in aggregate with other (possibly commercial) programs as part of a
-larger (possibly commercial) software distribution provided that you do not
-advertise this Package as a product of your own.
-
-6. The scripts and library files supplied as input to or produced as output
-from the programs of this Package do not automatically fall under the copyright
-of this Package, but belong to whomever generated them, and may be sold
-commercially, and may be aggregated with this Package.
+    a) place your modifications in the Public Domain or otherwise make them
+    Freely Available, such as by posting said modifications to Usenet or
+    an equivalent medium, or placing the modifications on a major archive
+    site such as uunet.uu.net, or by allowing the Copyright Holder to include
+    your modifications in the Standard Version of the Package.
+
+    b) use the modified Package only within your corporation or organization.
+
+    c) rename any non-standard executables so the names do not conflict
+    with standard executables, which must also be provided, and provide
+    a separate manual page for each non-standard executable that clearly
+    documents how it differs from the Standard Version.
 
-7. C or perl subroutines supplied by you and linked into this Package shall not
-be considered part of this Package.
+    d) make other distribution arrangements with the Copyright Holder.
+
+4. You may distribute the programs of this Package in object code or
+executable form, provided that you do at least ONE of the following:
+
+    a) distribute a Standard Version of the executables and library files,
+    together with instructions (in the manual page or equivalent) on where
+    to get the Standard Version.
+
+    b) accompany the distribution with the machine-readable source of
+    the Package with your modifications.
+
+    c) give non-standard executables non-standard names, and clearly
+    document the differences in manual pages (or equivalent), together
+    with instructions on where to get the Standard Version.
+
+    d) make other distribution arrangements with the Copyright Holder.
+
+5. You may charge a reasonable copying fee for any distribution of this
+Package.  You may charge any fee you choose for support of this
+Package.  You may not charge a fee for this Package itself.  However,
+you may distribute this Package in aggregate with other (possibly
+commercial) programs as part of a larger (possibly commercial) software
+distribution provided that you do not advertise this Package as a
+product of your own.  You may embed this Package's interpreter within
+an executable of yours (by linking); this shall be construed as a mere
+form of aggregation, provided that the complete Standard Version of the
+interpreter is so embedded.
+
+6. The scripts and library files supplied as input to or produced as
+output from the programs of this Package do not automatically fall
+under the copyright of this Package, but belong to whoever generated
+them, and may be sold commercially, and may be aggregated with this
+Package.  If such scripts or library files are aggregated with this
+Package via the so-called "undump" or "unexec" methods of producing a
+binary executable image, then distribution of such an image shall
+neither be construed as a distribution of this Package nor shall it
+fall under the restrictions of Paragraphs 3 and 4, provided that you do
+not represent such an executable image as a Standard Version of this
+Package.
+
+7. C subroutines (or comparably compiled subroutines in other
+languages) supplied by you and linked into this Package in order to
+emulate subroutines and variables of the language defined by this
+Package shall not be considered part of this Package, but are the
+equivalent of input as in Paragraph 6, provided these subroutines do
+not change the language in any way that would cause it to fail the
+regression tests for the language.
+
+8. Aggregation of this Package with a commercial distribution is always
+permitted provided that the use of this Package is embedded; that is,
+when no overt attempt is made to make this Package's interfaces visible
+to the end user of the commercial distribution.  Such use shall not be
+construed as a distribution of this Package.
 
-8. The name of the Copyright Holder may not be used to endorse or promote
+9. The name of the Copyright Holder may not be used to endorse or promote
 products derived from this software without specific prior written permission.
 
-9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
-WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
-MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
+10. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
+IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
+WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 
-The End
+                                The End
 
diff -pruN 0.21-1/MANIFEST 0.22-1/MANIFEST
--- 0.21-1/MANIFEST	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/MANIFEST	2024-10-11 17:37:16.000000000 +0000
@@ -1,3 +1,4 @@
+.editorconfig
 Build.PL
 Changes
 examples/eval-expr.pl
diff -pruN 0.21-1/META.json 0.22-1/META.json
--- 0.21-1/META.json	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/META.json	2024-10-11 17:37:16.000000000 +0000
@@ -4,7 +4,7 @@
       "Paul Evans <leonerd@leonerd.org.uk>"
    ],
    "dynamic_config" : 1,
-   "generated_by" : "Module::Build version 0.4231",
+   "generated_by" : "Module::Build version 0.4234",
    "license" : [
       "perl_5"
    ],
@@ -29,18 +29,18 @@
       "test" : {
          "requires" : {
             "File::Temp" : "0",
-            "Test::Fatal" : "0",
-            "Test::More" : "0.88"
+            "Test2::V0" : "0"
          }
       }
    },
    "provides" : {
       "Parser::MGC" : {
          "file" : "lib/Parser/MGC.pm",
-         "version" : "0.21"
+         "version" : "0.22"
       },
       "Parser::MGC::Examples::EvaluateExpression" : {
-         "file" : "lib/Parser/MGC/Examples/EvaluateExpression.pm"
+         "file" : "lib/Parser/MGC/Examples/EvaluateExpression.pm",
+         "version" : "0.22"
       }
    },
    "release_status" : "stable",
@@ -49,6 +49,6 @@
          "http://dev.perl.org/licenses/"
       ]
    },
-   "version" : "0.21",
-   "x_serialization_backend" : "JSON::PP version 4.06"
+   "version" : "0.22",
+   "x_serialization_backend" : "JSON::PP version 4.16"
 }
diff -pruN 0.21-1/META.yml 0.22-1/META.yml
--- 0.21-1/META.yml	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/META.yml	2024-10-11 17:37:16.000000000 +0000
@@ -4,12 +4,11 @@ author:
   - 'Paul Evans <leonerd@leonerd.org.uk>'
 build_requires:
   File::Temp: '0'
-  Test::Fatal: '0'
-  Test::More: '0.88'
+  Test2::V0: '0'
 configure_requires:
   Module::Build: '0.4004'
 dynamic_config: 1
-generated_by: 'Module::Build version 0.4231, CPAN::Meta::Converter version 2.150010'
+generated_by: 'Module::Build version 0.4234, CPAN::Meta::Converter version 2.150010'
 license: perl
 meta-spec:
   url: http://module-build.sourceforge.net/META-spec-v1.4.html
@@ -18,14 +17,15 @@ name: Parser-MGC
 provides:
   Parser::MGC:
     file: lib/Parser/MGC.pm
-    version: '0.21'
+    version: '0.22'
   Parser::MGC::Examples::EvaluateExpression:
     file: lib/Parser/MGC/Examples/EvaluateExpression.pm
+    version: '0.22'
 requires:
   Feature::Compat::Try: '0'
   Scalar::Util: '0'
   perl: '5.014'
 resources:
   license: http://dev.perl.org/licenses/
-version: '0.21'
+version: '0.22'
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
diff -pruN 0.21-1/README 0.22-1/README
--- 0.21-1/README	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/README	2024-10-11 17:37:16.000000000 +0000
@@ -78,7 +78,7 @@ CONSTRUCTOR
 
  new
 
-       $parser = Parser::MGC->new( %args )
+       $parser = Parser::MGC->new( %args );
 
     Returns a new instance of a Parser::MGC object. This must be called on
     a subclass that provides method of the name provided as toplevel, by
@@ -152,7 +152,7 @@ SUBCLASSING METHODS
 
  on_parse_start
 
-       $parser->on_parse_start
+       $parser->on_parse_start;
 
     Since version 0.21.
 
@@ -161,7 +161,7 @@ SUBCLASSING METHODS
 
  on_parse_end
 
-       $result = $parser->on_parse_end( $result )
+       $result = $parser->on_parse_end( $result );
 
     Since version 0.21.
 
@@ -174,14 +174,14 @@ METHODS
 
  from_string
 
-       $result = $parser->from_string( $str )
+       $result = $parser->from_string( $str );
 
     Parse the given literal string and return the result from the toplevel
     method.
 
  from_file
 
-       $result = $parser->from_file( $file, %opts )
+       $result = $parser->from_file( $file, %opts );
 
     Parse the given file, which may be a pathname in a string, or an opened
     IO handle, and return the result from the toplevel method.
@@ -193,11 +193,11 @@ METHODS
       If set, applies the given binmode to the filehandle before reading.
       Typically this can be used to set the encoding of the file.
 
-         $parser->from_file( $file, binmode => ":encoding(UTF-8)" )
+         $parser->from_file( $file, binmode => ":encoding(UTF-8)" );
 
  filename
 
-       $filename = $parser->filename
+       $filename = $parser->filename;
 
     Since version 0.20.
 
@@ -206,7 +206,7 @@ METHODS
 
  from_reader
 
-       $result = $parser->from_reader( \&reader )
+       $result = $parser->from_reader( \&reader );
 
     Since version 0.05.
 
@@ -215,7 +215,7 @@ METHODS
     parse, being passed the $parser object. The function should return
     undef when it has no more string to return.
 
-       $reader->( $parser )
+       $reader->( $parser );
 
     Note that because it is not generally possible to detect exactly when
     more input may be required due to failed regexp parsing, the reader
@@ -229,7 +229,7 @@ METHODS
 
  pos
 
-       $pos = $parser->pos
+       $pos = $parser->pos;
 
     Since version 0.09.
 
@@ -238,7 +238,7 @@ METHODS
 
  take
 
-       $str = $parser->take( $len )
+       $str = $parser->take( $len );
 
     Since version 0.16.
 
@@ -251,7 +251,7 @@ METHODS
 
  where
 
-       ( $lineno, $col, $text ) = $parser->where
+       ( $lineno, $col, $text ) = $parser->where;
 
     Returns the current parse position, as a line and column number, and
     the entire current line of text. The first line is numbered 1, and the
@@ -261,9 +261,9 @@ METHODS
 
  fail_from
 
-       $parser->fail( $message )
+       $parser->fail( $message );
     
-       $parser->fail_from( $pos, $message )
+       $parser->fail_from( $pos, $message );
 
     fail_from since version 0.09.
 
@@ -280,9 +280,9 @@ METHODS
 
  die_from
 
-       $parser->die( $message )
+       $parser->die( $message );
     
-       $parser->die_from( $pos, $message )
+       $parser->die_from( $pos, $message );
 
     Since version 0.20.
 
@@ -298,15 +298,30 @@ METHODS
     input was correctly recognised at a grammar level, but is requesting
     something that cannot be fulfilled semantically.
 
+ warn
+
+ warn_from
+
+       $parser->warn( $message );
+    
+       $parser->warn_from( $pos, $message );
+
+    Since version 0.22.
+
+    Issues a warning as normal for the warn core Perl function, appending
+    information to the message string giving the current line and column
+    position and the line of input the parser was working on, as it does in
+    the "fail" method.
+
  at_eos
 
-       $eos = $parser->at_eos
+       $eos = $parser->at_eos;
 
     Returns true if the input string is at the end of the string.
 
  scope_level
 
-       $level = $parser->scope_level
+       $level = $parser->scope_level;
 
     Since version 0.05.
 
@@ -314,7 +329,7 @@ METHODS
 
  include_string
 
-       $result = $parser->include_string( $str, %opts )
+       $result = $parser->include_string( $str, %opts );
 
     Since version 0.21.
 
@@ -366,12 +381,17 @@ STRUCTURE-FORMING METHODS
 
  maybe
 
-       $ret = $parser->maybe( $code )
+       $ret = $parser->maybe( $code );
 
     Attempts to execute the given $code in scalar context, and returns what
     it returned, accepting that it might fail. $code may either be a CODE
     reference or a method name given as a string.
 
+       $ret = $parser->maybe( $code, @args );
+
+    Since version 0.22 this method passes any additional arguments into the
+    invoked code. This is especially useful if the $code is a method name.
+
     If the code fails (either by calling fail itself, or by propagating a
     failure from another method it invoked) before it has invoked commit,
     then none of the input string will be consumed; the current parsing
@@ -397,7 +417,7 @@ STRUCTURE-FORMING METHODS
 
  scope_of
 
-       $ret = $parser->scope_of( $start, $code, $stop )
+       $ret = $parser->scope_of( $start, $code, $stop );
 
     Expects to find the $start pattern, then attempts to execute the given
     $code, then expects to find the $stop pattern. Returns whatever the
@@ -434,7 +454,7 @@ STRUCTURE-FORMING METHODS
 
  committed_scope_of
 
-       $ret = $parser->committed_scope_of( $start, $code, $stop )
+       $ret = $parser->committed_scope_of( $start, $code, $stop );
 
     Since version 0.16.
 
@@ -445,7 +465,7 @@ STRUCTURE-FORMING METHODS
 
  list_of
 
-       $ret = $parser->list_of( $sep, $code )
+       $ret = $parser->list_of( $sep, $code );
 
     Expects to find a list of instances of something parsed by $code,
     separated by the $sep pattern. Returns an ARRAY ref containing a list
@@ -478,7 +498,7 @@ STRUCTURE-FORMING METHODS
 
  sequence_of
 
-       $ret = $parser->sequence_of( $code )
+       $ret = $parser->sequence_of( $code );
 
     A shortcut for calling list_of with an empty string as separator;
     expects to find at least one instance of something parsed by $code,
@@ -498,7 +518,7 @@ STRUCTURE-FORMING METHODS
 
  any_of
 
-       $ret = $parser->any_of( @codes )
+       $ret = $parser->any_of( @codes );
 
     Since version 0.06.
 
@@ -549,7 +569,7 @@ STRUCTURE-FORMING METHODS
 
  commit
 
-       $parser->commit
+       $parser->commit;
 
     Calling this method will cancel the backtracking behaviour of the
     innermost maybe, list_of, sequence_of, or any_of structure forming
@@ -562,19 +582,19 @@ STRUCTURE-FORMING METHODS
     been determined, ensuring that any further failures are raised as real
     exceptions, rather than by attempting other alternatives.
 
-     sub parse_statement
-     {
-        my $self = shift;
-    
-        $self->any_of(
-           ...
-           sub {
-              $self->scope_of( "{",
-                 sub { $self->commit; $self->parse_statements; },
-              "}" ),
-           },
-        );
-     }
+       sub parse_statement
+       {
+          my $self = shift;
+    
+          $self->any_of(
+             ...
+             sub {
+                $self->scope_of( "{",
+                   sub { $self->commit; $self->parse_statements; },
+                "}" ),
+             },
+          );
+       }
 
     Though in this common pattern, "committed_scope_of" may be used
     instead.
@@ -586,11 +606,11 @@ TOKEN PARSING METHODS
 
  expect
 
-       $str = $parser->expect( $literal )
+       $str = $parser->expect( $literal );
     
-       $str = $parser->expect( qr/pattern/ )
+       $str = $parser->expect( qr/pattern/ );
     
-       @groups = $parser->expect( qr/pattern/ )
+       @groups = $parser->expect( qr/pattern/ );
 
     Expects to find a literal string or regexp pattern match, and consumes
     it. In scalar context, this method returns the string that was
@@ -605,9 +625,9 @@ TOKEN PARSING METHODS
 
  maybe_expect
 
-       $str = $parser->maybe_expect( ... )
+       $str = $parser->maybe_expect( ... );
     
-       @groups = $parser->maybe_expect( ... )
+       @groups = $parser->maybe_expect( ... );
 
     Since version 0.10.
 
@@ -617,9 +637,9 @@ TOKEN PARSING METHODS
 
  substring_before
 
-       $str = $parser->substring_before( $literal )
+       $str = $parser->substring_before( $literal );
     
-       $str = $parser->substring_before( qr/pattern/ )
+       $str = $parser->substring_before( qr/pattern/ );
 
     Since version 0.06.
 
@@ -652,9 +672,9 @@ TOKEN PARSING METHODS
 
  nonempty_substring_before
 
-       $str = $parser->nonempty_substring_before( $literal )
+       $str = $parser->nonempty_substring_before( $literal );
     
-       $str = $parser->nonempty_substring_before( qr/pattern/ )
+       $str = $parser->nonempty_substring_before( qr/pattern/ );
 
     Since version 0.20.
 
@@ -691,7 +711,7 @@ TOKEN PARSING METHODS
 
  generic_token
 
-       $val = $parser->generic_token( $name, $re, $convert )
+       $val = $parser->generic_token( $name, $re, $convert );
 
     Since version 0.08.
 
@@ -719,7 +739,7 @@ TOKEN PARSING METHODS
 
  token_int
 
-       $int = $parser->token_int
+       $int = $parser->token_int;
 
     Expects to find an integer in decimal, octal or hexadecimal notation,
     and consumes it. Negative integers, preceeded by -, are also
@@ -727,7 +747,7 @@ TOKEN PARSING METHODS
 
  token_float
 
-       $float = $parser->token_float
+       $float = $parser->token_float;
 
     Since version 0.04.
 
@@ -738,7 +758,7 @@ TOKEN PARSING METHODS
 
  token_number
 
-       $number = $parser->token_number
+       $number = $parser->token_number;
 
     Since version 0.09.
 
@@ -746,7 +766,7 @@ TOKEN PARSING METHODS
 
  token_string
 
-       $str = $parser->token_string
+       $str = $parser->token_string;
 
     Expects to find a quoted string, and consumes it. The string should be
     quoted using " or ' quote marks.
@@ -771,13 +791,13 @@ TOKEN PARSING METHODS
 
  token_ident
 
-       $ident = $parser->token_ident
+       $ident = $parser->token_ident;
 
     Expects to find an identifier, and consumes it.
 
  token_kw
 
-       $keyword = $parser->token_kw( @keywords )
+       $keyword = $parser->token_kw( @keywords );
 
     Expects to find a keyword, and consumes it. A keyword is defined as an
     identifier which is exactly one of the literal values passed in.
diff -pruN 0.21-1/debian/changelog 0.22-1/debian/changelog
--- 0.21-1/debian/changelog	2022-03-14 09:34:32.000000000 +0000
+++ 0.22-1/debian/changelog	2024-11-21 20:52:18.000000000 +0000
@@ -1,3 +1,17 @@
+libparser-mgc-perl (0.22-1) unstable; urgency=medium
+
+  * Team upload.
+  * Import upstream version 0.22.
+  * Declare compliance with Debian Policy 4.7.0.
+  * d/copyright: refresh upstream copyright year.
+  * 2001_avoid_Feature-Compat-Try.patch: declare forwarding not-needed.
+    A note left in d/patches/README suggests the patch is not relevant
+    upstream outside Debian context.
+  * 1001_whatis_entry.patch: new: whatis entry for Parser::MGC::Tutorial.
+  * 1002_typos.patch: new: fix typos caught by lintian.
+
+ -- Étienne Mollier <emollier@debian.org>  Thu, 21 Nov 2024 21:52:18 +0100
+
 libparser-mgc-perl (0.21-1) unstable; urgency=medium
 
   [ Upstream ]
diff -pruN 0.21-1/debian/control 0.22-1/debian/control
--- 0.21-1/debian/control	2022-03-14 09:32:44.000000000 +0000
+++ 0.22-1/debian/control	2024-11-21 20:52:18.000000000 +0000
@@ -1,27 +1,25 @@
 Source: libparser-mgc-perl
-Section: perl
-Priority: optional
-Build-Depends:
- debhelper-compat (= 13),
- perl,
- libmodule-build-perl,
- libsyntax-keyword-try-perl <!nocheck>,
- libtest-fatal-perl <!nocheck>,
 Maintainer: Debian Perl Group <pkg-perl-maintainers@lists.alioth.debian.org>
 Uploaders: Jonas Smedegaard <dr@jones.dk>
-Standards-Version: 4.6.0
-Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libparser-mgc-perl.git
+Section: perl
+Testsuite: autopkgtest-pkg-perl
+Priority: optional
+Build-Depends: debhelper-compat (= 13),
+               libmodule-build-perl,
+               libsyntax-keyword-try-perl <!nocheck>,
+               libtest-fatal-perl <!nocheck>,
+               perl
+Standards-Version: 4.7.0
 Vcs-Browser: https://salsa.debian.org/perl-team/modules/packages/libparser-mgc-perl
+Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libparser-mgc-perl.git
 Homepage: https://metacpan.org/release/Parser-MGC
-Testsuite: autopkgtest-pkg-perl
 Rules-Requires-Root: no
 
 Package: libparser-mgc-perl
 Architecture: all
-Depends:
- libsyntax-keyword-try-perl,
- ${misc:Depends},
- ${perl:Depends}
+Depends: ${misc:Depends},
+         ${perl:Depends},
+         libsyntax-keyword-try-perl
 Description: builder for simple recursive-descent parsers
  Parser::MGC provides a low-level framework
  for building recursive-descent parsers
diff -pruN 0.21-1/debian/copyright 0.22-1/debian/copyright
--- 0.21-1/debian/copyright	2022-03-14 09:21:02.000000000 +0000
+++ 0.22-1/debian/copyright	2024-11-21 20:52:18.000000000 +0000
@@ -6,7 +6,7 @@ Source: https://metacpan.org/release/Par
 
 Files: *
 Copyright:
-  2010-2022  Paul Evans <leonerd@leonerd.org.uk>
+  2010-2024  Paul Evans <leonerd@leonerd.org.uk>
 License-Grant:
  You may distribute under the terms
  of either the GNU General Public License
diff -pruN 0.21-1/debian/copyright_hints 0.22-1/debian/copyright_hints
--- 0.21-1/debian/copyright_hints	2022-03-14 09:33:06.000000000 +0000
+++ 0.22-1/debian/copyright_hints	2024-11-21 20:52:18.000000000 +0000
@@ -83,4 +83,3 @@ Files: lib/Parser/MGC.pm
 Copyright: Paul Evans, 2010-2022 -- leonerd@leonerd.org.uk
 License: GPL
  FIXME
-
diff -pruN 0.21-1/debian/patches/1001_whatis_entry.patch 0.22-1/debian/patches/1001_whatis_entry.patch
--- 0.21-1/debian/patches/1001_whatis_entry.patch	1970-01-01 00:00:00.000000000 +0000
+++ 0.22-1/debian/patches/1001_whatis_entry.patch	2024-11-21 20:52:18.000000000 +0000
@@ -0,0 +1,16 @@
+Description: whatis entry for Parser::MGC::Tutorial
+Author: Étienne Mollier <emollier@debian.org>
+Bug: https://rt.cpan.org/Public/Bug/Display.html?id=157369
+Last-Update: 2024-11-21
+---
+This patch header follows DEP-3: http://dep.debian.net/deps/dep3/
+--- libparser-mgc-perl.orig/lib/Parser/MGC/Tutorial.pod
++++ libparser-mgc-perl/lib/Parser/MGC/Tutorial.pod
+@@ -1,6 +1,6 @@
+ =head1 NAME
+ 
+-Parser::MGC::Tutorial
++Parser::MGC::Tutorial - tutorial to build simple recursive-descent parsers
+ 
+ =head1 INTRODUCTION
+ 
diff -pruN 0.21-1/debian/patches/1002_typos.patch 0.22-1/debian/patches/1002_typos.patch
--- 0.21-1/debian/patches/1002_typos.patch	1970-01-01 00:00:00.000000000 +0000
+++ 0.22-1/debian/patches/1002_typos.patch	2024-11-21 20:52:18.000000000 +0000
@@ -0,0 +1,28 @@
+Description: fix typos caught by lintian.
+Author: Étienne Mollier <emollier@debian.org>
+Bug: https://rt.cpan.org/Public/Bug/Display.html?id=157370
+Last-Update: 2024-11-21
+---
+This patch header follows DEP-3: http://dep.debian.net/deps/dep3/
+--- libparser-mgc-perl.orig/lib/Parser/MGC.pm
++++ libparser-mgc-perl/lib/Parser/MGC.pm
+@@ -1365,7 +1365,7 @@
+    $int = $parser->token_int;
+ 
+ Expects to find an integer in decimal, octal or hexadecimal notation, and
+-consumes it. Negative integers, preceeded by C<->, are also recognised.
++consumes it. Negative integers, preceded by C<->, are also recognised.
+ 
+ =cut
+ 
+--- libparser-mgc-perl.orig/lib/Parser/MGC/Tutorial.pod
++++ libparser-mgc-perl/lib/Parser/MGC/Tutorial.pod
+@@ -284,7 +284,7 @@
+     $self->scope_of( "{", sub { $self->parse_expression_list }, "}" );
+  }
+ 
+-During execution of the inner call to C<parse_expression_list>, any occurence
++During execution of the inner call to C<parse_expression_list>, any occurrence
+ in the stream of the C<}> marker will appear to be the end of the stream,
+ causing the inner call to stop at hopefully the right place (barring other
+ syntax errors), and terminating correctly.
diff -pruN 0.21-1/debian/patches/2001_avoid_Feature-Compat-Try.patch 0.22-1/debian/patches/2001_avoid_Feature-Compat-Try.patch
--- 0.21-1/debian/patches/2001_avoid_Feature-Compat-Try.patch	2022-03-14 09:33:48.000000000 +0000
+++ 0.22-1/debian/patches/2001_avoid_Feature-Compat-Try.patch	2024-11-21 20:52:18.000000000 +0000
@@ -1,6 +1,7 @@
 Description: avoid perl module Feature::Compat::Try
 Author: Jonas Smedegaard <dr@jones.dk>
 Last-Update: 2021-09-02
+Forwarded: not-needed
 ---
 This patch header follows DEP-3: http://dep.debian.net/deps/dep3/
 --- a/lib/Parser/MGC.pm
diff -pruN 0.21-1/debian/patches/series 0.22-1/debian/patches/series
--- 0.21-1/debian/patches/series	2022-03-14 09:32:04.000000000 +0000
+++ 0.22-1/debian/patches/series	2024-11-21 20:52:18.000000000 +0000
@@ -1 +1,3 @@
 2001_avoid_Feature-Compat-Try.patch
+1001_whatis_entry.patch
+1002_typos.patch
diff -pruN 0.21-1/examples/eval-expr.pl 0.22-1/examples/eval-expr.pl
--- 0.21-1/examples/eval-expr.pl	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/examples/eval-expr.pl	2024-10-11 17:37:16.000000000 +0000
@@ -1,6 +1,6 @@
 #!/usr/bin/perl
 
-use strict;
+use v5.14;
 use warnings;
 
 package ExprParser;
diff -pruN 0.21-1/examples/parse-bencode.pl 0.22-1/examples/parse-bencode.pl
--- 0.21-1/examples/parse-bencode.pl	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/examples/parse-bencode.pl	2024-10-11 17:37:16.000000000 +0000
@@ -1,6 +1,6 @@
 #!/usr/bin/perl
 
-use strict;
+use v5.14;
 use warnings;
 
 package BencodeParser;
diff -pruN 0.21-1/examples/parse-dict.pl 0.22-1/examples/parse-dict.pl
--- 0.21-1/examples/parse-dict.pl	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/examples/parse-dict.pl	2024-10-11 17:37:16.000000000 +0000
@@ -1,6 +1,6 @@
 #!/usr/bin/perl
 
-use strict;
+use v5.14;
 use warnings;
 
 package DictParser;
diff -pruN 0.21-1/examples/parse-jsonlike.pl 0.22-1/examples/parse-jsonlike.pl
--- 0.21-1/examples/parse-jsonlike.pl	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/examples/parse-jsonlike.pl	2024-10-11 17:37:16.000000000 +0000
@@ -1,6 +1,6 @@
 #!/usr/bin/perl
 
-use strict;
+use v5.14;
 use warnings;
 
 # DO NOT RELY ON THIS AS A REAL JSON PARSER
diff -pruN 0.21-1/examples/parse-pod.pl 0.22-1/examples/parse-pod.pl
--- 0.21-1/examples/parse-pod.pl	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/examples/parse-pod.pl	2024-10-11 17:37:16.000000000 +0000
@@ -1,6 +1,6 @@
 #!/usr/bin/perl
 
-use strict;
+use v5.14;
 use warnings;
 
 package PodParser;
diff -pruN 0.21-1/examples/parse-xml.pl 0.22-1/examples/parse-xml.pl
--- 0.21-1/examples/parse-xml.pl	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/examples/parse-xml.pl	2024-10-11 17:37:16.000000000 +0000
@@ -1,6 +1,6 @@
 #!/usr/bin/perl
 
-use strict;
+use v5.14;
 use warnings;
 
 # DO NOT RELY ON THIS AS A REAL XML PARSER!
diff -pruN 0.21-1/examples/synopsis.pl 0.22-1/examples/synopsis.pl
--- 0.21-1/examples/synopsis.pl	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/examples/synopsis.pl	2024-10-11 17:37:16.000000000 +0000
@@ -1,4 +1,6 @@
-use strict;
+#!/usr/bin/perl
+
+use v5.14;
 use warnings;
 
 package LispParser;
diff -pruN 0.21-1/lib/Parser/MGC/Examples/EvaluateExpression.pm 0.22-1/lib/Parser/MGC/Examples/EvaluateExpression.pm
--- 0.21-1/lib/Parser/MGC/Examples/EvaluateExpression.pm	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/lib/Parser/MGC/Examples/EvaluateExpression.pm	2024-10-11 17:37:16.000000000 +0000
@@ -1,4 +1,4 @@
-package Parser::MGC::Examples::EvaluateExpression;
+package Parser::MGC::Examples::EvaluateExpression 0.22;
 
 =head1 NAME
 
@@ -18,6 +18,8 @@ handle the two different precedence leve
 
 =head2 Boilerplate
 
+=for highlighter language=perl
+
 We start off by declaring a package and subclassing L<Parser::MGC>.
 
    package ExprParser;
@@ -73,6 +75,8 @@ total value is returned to the caller.
 
 This function recognises input matching the following EBNF grammar:
 
+=for highlighter
+
    EXPR = TERM { ( '+' | '-' ) TERM };
 
 =cut
@@ -91,6 +95,8 @@ factor it expects to find after those. T
 
 =pod
 
+=for highlighter language=perl
+
    sub parse_term
    {
       my $self = shift;
@@ -140,6 +146,8 @@ numerical value.
 
 =pod
 
+=for highlighter language=perl
+
    sub parse_factor
    {
       my $self = shift;
@@ -156,6 +164,8 @@ numerical value.
 
 This function recognises input matching the following EBNF grammar:
 
+=for highlighter
+
    FACTOR = '(' EXPR ')'
           | integer
 
@@ -412,3 +422,9 @@ the (real) end of input, so returns the
 
  INPUT:    (15 - 2) * 3
  OUTPUT:   39
+
+=head1 AUTHOR
+
+Paul Evans <leonerd@leonerd.org.uk>
+
+=cut
diff -pruN 0.21-1/lib/Parser/MGC.pm 0.22-1/lib/Parser/MGC.pm
--- 0.21-1/lib/Parser/MGC.pm	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/lib/Parser/MGC.pm	2024-10-11 17:37:16.000000000 +0000
@@ -1,9 +1,9 @@
 #  You may distribute under the terms of either the GNU General Public License
 #  or the Artistic License (the same terms as Perl itself)
 #
-#  (C) Paul Evans, 2010-2022 -- leonerd@leonerd.org.uk
+#  (C) Paul Evans, 2010-2024 -- leonerd@leonerd.org.uk
 
-package Parser::MGC 0.21;
+package Parser::MGC 0.22;
 
 use v5.14;
 use warnings;
@@ -19,6 +19,8 @@ C<Parser::MGC> - build simple recursive-
 
 =head1 SYNOPSIS
 
+=for highlighter language=perl
+
    package My::Grammar::Parser;
    use base qw( Parser::MGC );
 
@@ -95,7 +97,7 @@ attempt will be aborted by the L</die> m
 
 =head2 new
 
-   $parser = Parser::MGC->new( %args )
+   $parser = Parser::MGC->new( %args );
 
 Returns a new instance of a C<Parser::MGC> object. This must be called on a
 subclass that provides method of the name provided as C<toplevel>, by default
@@ -230,7 +232,7 @@ their parsing.
 
 =head2 on_parse_start
 
-   $parser->on_parse_start
+   $parser->on_parse_start;
 
 I<Since version 0.21.>
 
@@ -239,7 +241,7 @@ operation, just before invoking the topl
 
 =head2 on_parse_end
 
-   $result = $parser->on_parse_end( $result )
+   $result = $parser->on_parse_end( $result );
 
 I<Since version 0.21.>
 
@@ -256,7 +258,7 @@ method itself.
 
 =head2 from_string
 
-   $result = $parser->from_string( $str )
+   $result = $parser->from_string( $str );
 
 Parse the given literal string and return the result from the toplevel method.
 
@@ -290,7 +292,7 @@ sub from_string
 
 =head2 from_file
 
-   $result = $parser->from_file( $file, %opts )
+   $result = $parser->from_file( $file, %opts );
 
 Parse the given file, which may be a pathname in a string, or an opened IO
 handle, and return the result from the toplevel method.
@@ -304,7 +306,7 @@ The following options are recognised:
 If set, applies the given binmode to the filehandle before reading. Typically
 this can be used to set the encoding of the file.
 
-   $parser->from_file( $file, binmode => ":encoding(UTF-8)" )
+   $parser->from_file( $file, binmode => ":encoding(UTF-8)" );
 
 =back
 
@@ -334,7 +336,7 @@ sub from_file
 
 =head2 filename
 
-   $filename = $parser->filename
+   $filename = $parser->filename;
 
 I<Since version 0.20.>
 
@@ -351,7 +353,7 @@ sub filename
 
 =head2 from_reader
 
-   $result = $parser->from_reader( \&reader )
+   $result = $parser->from_reader( \&reader );
 
 I<Since version 0.05.>
 
@@ -360,7 +362,7 @@ called in scalar context to generate por
 the C<$parser> object. The function should return C<undef> when it has no more
 string to return.
 
-   $reader->( $parser )
+   $reader->( $parser );
 
 Note that because it is not generally possible to detect exactly when more
 input may be required due to failed regexp parsing, the reader function is
@@ -393,7 +395,7 @@ sub from_reader
 
 =head2 pos
 
-   $pos = $parser->pos
+   $pos = $parser->pos;
 
 I<Since version 0.09.>
 
@@ -410,7 +412,7 @@ sub pos
 
 =head2 take
 
-   $str = $parser->take( $len )
+   $str = $parser->take( $len );
 
 I<Since version 0.16.>
 
@@ -436,7 +438,7 @@ sub take
 
 =head2 where
 
-   ( $lineno, $col, $text ) = $parser->where
+   ( $lineno, $col, $text ) = $parser->where;
 
 Returns the current parse position, as a line and column number, and
 the entire current line of text. The first line is numbered 1, and the first
@@ -472,9 +474,9 @@ sub where
 
 =head2 fail_from
 
-   $parser->fail( $message )
+   $parser->fail( $message );
 
-   $parser->fail_from( $pos, $message )
+   $parser->fail_from( $pos, $message );
 
 I<C<fail_from> since version 0.09.>
 
@@ -515,9 +517,9 @@ sub fail_from
 
 =head2 die_from
 
-   $parser->die( $message )
+   $parser->die( $message );
 
-   $parser->die_from( $pos, $message )
+   $parser->die_from( $pos, $message );
 
 I<Since version 0.20.>
 
@@ -551,9 +553,42 @@ sub die_from
    die Parser::MGC::Failure->new( $message, $self, $pos )->STRING;
 }
 
+=head2 warn
+
+=head2 warn_from
+
+   $parser->warn( $message );
+
+   $parser->warn_from( $pos, $message );
+
+I<Since version 0.22.>
+
+Issues a warning as normal for the C<warn> core Perl function, appending
+information to the message string giving the current line and column position
+and the line of input the parser was working on, as it does in the L</fail>
+method.
+
+=cut
+
+sub warn :method
+{
+   my $self = shift;
+   my ( $message ) = @_;
+   $self->warn_from( $self->pos, $message );
+}
+
+sub warn_from
+{
+   my $self = shift;
+   my ( $pos, $message ) = @_;
+   # Convenient just to use the ->STRING method of a Failure object but don't
+   # throw it directly
+   warn Parser::MGC::Failure->new( $message, $self, $pos )->STRING;
+}
+
 =head2 at_eos
 
-   $eos = $parser->at_eos
+   $eos = $parser->at_eos;
 
 Returns true if the input string is at the end of the string.
 
@@ -586,7 +621,7 @@ sub at_eos
 
 =head2 scope_level
 
-   $level = $parser->scope_level
+   $level = $parser->scope_level;
 
 I<Since version 0.05.>
 
@@ -602,7 +637,7 @@ sub scope_level
 
 =head2 include_string
 
-   $result = $parser->include_string( $str, %opts )
+   $result = $parser->include_string( $str, %opts );
 
 I<Since version 0.21.>
 
@@ -678,12 +713,17 @@ as
 
 =head2 maybe
 
-   $ret = $parser->maybe( $code )
+   $ret = $parser->maybe( $code );
 
 Attempts to execute the given C<$code> in scalar context, and returns what it
 returned, accepting that it might fail. C<$code> may either be a CODE
 reference or a method name given as a string.
 
+   $ret = $parser->maybe( $code, @args );
+
+I<Since version 0.22> this method passes any additional arguments into the
+invoked code. This is especially useful if the C<$code> is a method name.
+
 If the code fails (either by calling C<fail> itself, or by propagating a
 failure from another method it invoked) before it has invoked C<commit>, then
 none of the input string will be consumed; the current parsing position will
@@ -712,7 +752,7 @@ This may be considered to be similar to
 sub maybe
 {
    my $self = shift;
-   my ( $code ) = @_;
+   my ( $code, @args ) = @_;
 
    my $pos = pos $self->{str};
 
@@ -720,7 +760,7 @@ sub maybe
    local $self->{committer} = sub { $committed++ };
 
    try {
-      return $self->$code;
+      return $self->$code( @args );
    }
    catch ( $e ) {
       pos($self->{str}) = $pos;
@@ -732,7 +772,7 @@ sub maybe
 
 =head2 scope_of
 
-   $ret = $parser->scope_of( $start, $code, $stop )
+   $ret = $parser->scope_of( $start, $code, $stop );
 
 Expects to find the C<$start> pattern, then attempts to execute the given
 C<$code>, then expects to find the C<$stop> pattern. Returns whatever the
@@ -798,7 +838,7 @@ sub _scope_of
 
 =head2 committed_scope_of
 
-   $ret = $parser->committed_scope_of( $start, $code, $stop )
+   $ret = $parser->committed_scope_of( $start, $code, $stop );
 
 I<Since version 0.16.>
 
@@ -817,7 +857,7 @@ sub committed_scope_of
 
 =head2 list_of
 
-   $ret = $parser->list_of( $sep, $code )
+   $ret = $parser->list_of( $sep, $code );
 
 Expects to find a list of instances of something parsed by C<$code>,
 separated by the C<$sep> pattern. Returns an ARRAY ref containing a list of
@@ -895,7 +935,7 @@ sub list_of
 
 =head2 sequence_of
 
-   $ret = $parser->sequence_of( $code )
+   $ret = $parser->sequence_of( $code );
 
 A shortcut for calling C<list_of> with an empty string as separator; expects
 to find at least one instance of something parsed by C<$code>, separated only
@@ -925,7 +965,7 @@ sub sequence_of
 
 =head2 any_of
 
-   $ret = $parser->any_of( @codes )
+   $ret = $parser->any_of( @codes );
 
 I<Since version 0.06.>
 
@@ -960,8 +1000,12 @@ choices will be attempted.
 
 If none of the choices match then a simple failure message is printed:
 
+=for highlighter
+
    Found nothing parseable
 
+=for highlighter language=perl
+
 As this is unlikely to be helpful to users, a better message can be provided
 by the final choice instead. Don't forget to C<commit> before printing the
 failure message, or it won't count.
@@ -1006,7 +1050,7 @@ sub one_of {
 
 =head2 commit
 
-   $parser->commit
+   $parser->commit;
 
 Calling this method will cancel the backtracking behaviour of the innermost
 C<maybe>, C<list_of>, C<sequence_of>, or C<any_of> structure forming method.
@@ -1018,19 +1062,19 @@ Typically this will be called once the g
 determined, ensuring that any further failures are raised as real exceptions,
 rather than by attempting other alternatives.
 
- sub parse_statement
- {
-    my $self = shift;
-
-    $self->any_of(
-       ...
-       sub {
-          $self->scope_of( "{",
-             sub { $self->commit; $self->parse_statements; },
-          "}" ),
-       },
-    );
- }
+   sub parse_statement
+   {
+      my $self = shift;
+
+      $self->any_of(
+         ...
+         sub {
+            $self->scope_of( "{",
+               sub { $self->commit; $self->parse_statements; },
+            "}" ),
+         },
+      );
+   }
 
 Though in this common pattern, L</committed_scope_of> may be used instead.
 
@@ -1083,11 +1127,11 @@ sub skip_ws
 
 =head2 expect
 
-   $str = $parser->expect( $literal )
+   $str = $parser->expect( $literal );
 
-   $str = $parser->expect( qr/pattern/ )
+   $str = $parser->expect( qr/pattern/ );
 
-   @groups = $parser->expect( qr/pattern/ )
+   @groups = $parser->expect( qr/pattern/ );
 
 Expects to find a literal string or regexp pattern match, and consumes it.
 In scalar context, this method returns the string that was captured. In list
@@ -1102,9 +1146,9 @@ with zero-width.
 
 =head2 maybe_expect
 
-   $str = $parser->maybe_expect( ... )
+   $str = $parser->maybe_expect( ... );
 
-   @groups = $parser->maybe_expect( ... )
+   @groups = $parser->maybe_expect( ... );
 
 I<Since version 0.10.>
 
@@ -1149,9 +1193,9 @@ sub expect
 
 =head2 substring_before
 
-   $str = $parser->substring_before( $literal )
+   $str = $parser->substring_before( $literal );
 
-   $str = $parser->substring_before( qr/pattern/ )
+   $str = $parser->substring_before( qr/pattern/ );
 
 I<Since version 0.06.>
 
@@ -1181,9 +1225,9 @@ strings, or similar cases where whitespa
 
 =head2 nonempty_substring_before
 
-   $str = $parser->nonempty_substring_before( $literal )
+   $str = $parser->nonempty_substring_before( $literal );
 
-   $str = $parser->nonempty_substring_before( qr/pattern/ )
+   $str = $parser->nonempty_substring_before( qr/pattern/ );
 
 I<Since version 0.20.>
 
@@ -1261,7 +1305,7 @@ sub nonempty_substring_before
 
 =head2 generic_token
 
-   $val = $parser->generic_token( $name, $re, $convert )
+   $val = $parser->generic_token( $name, $re, $convert );
 
 I<Since version 0.08.>
 
@@ -1318,7 +1362,7 @@ sub _token_generic
 
 =head2 token_int
 
-   $int = $parser->token_int
+   $int = $parser->token_int;
 
 Expects to find an integer in decimal, octal or hexadecimal notation, and
 consumes it. Negative integers, preceeded by C<->, are also recognised.
@@ -1346,7 +1390,7 @@ sub token_int
 
 =head2 token_float
 
-   $float = $parser->token_float
+   $float = $parser->token_float;
 
 I<Since version 0.04.>
 
@@ -1370,7 +1414,7 @@ sub token_float
 
 =head2 token_number
 
-   $number = $parser->token_number
+   $number = $parser->token_number;
 
 I<Since version 0.09.>
 
@@ -1386,7 +1430,7 @@ sub token_number
 
 =head2 token_string
 
-   $str = $parser->token_string
+   $str = $parser->token_string;
 
 Expects to find a quoted string, and consumes it. The string should be quoted
 using C<"> or C<'> quote marks.
@@ -1394,6 +1438,8 @@ using C<"> or C<'> quote marks.
 The content of the quoted string can contain character escapes similar to
 those accepted by C or Perl. Specifically, the following forms are recognised:
 
+=for highlighter
+
    \a               Bell ("alert")
    \b               Backspace
    \e               Escape
@@ -1404,6 +1450,8 @@ those accepted by C or Perl. Specificall
    \0, \012         Octal character
    \x34, \x{5678}   Hexadecimal character
 
+=for highlighter language=perl
+
 C's C<\v> for vertical tab is not supported as it is rarely used in practice
 and it collides with Perl's C<\v> regexp escape. Perl's C<\c> for forming other
 control characters is also not supported.
@@ -1459,7 +1507,7 @@ sub token_string
 
 =head2 token_ident
 
-   $ident = $parser->token_ident
+   $ident = $parser->token_ident;
 
 Expects to find an identifier, and consumes it.
 
@@ -1477,7 +1525,7 @@ sub token_ident
 
 =head2 token_kw
 
-   $keyword = $parser->token_kw( @keywords )
+   $keyword = $parser->token_kw( @keywords );
 
 Expects to find a keyword, and consumes it. A keyword is defined as an
 identifier which is exactly one of the literal values passed in.
@@ -1574,6 +1622,8 @@ namely, rejecting duplicate keys.
 
 =head1 TODO
 
+=for highlighter
+
 =over 4
 
 =item *
diff -pruN 0.21-1/t/00use.t 0.22-1/t/00use.t
--- 0.21-1/t/00use.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/00use.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,9 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
-use_ok( "Parser::MGC" );
+require Parser::MGC;
 
+pass( 'Modules loaded' );
 done_testing;
diff -pruN 0.21-1/t/01base.t 0.22-1/t/01base.t
--- 0.21-1/t/01base.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/01base.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 my $STARTED;
 my $ENDED;
@@ -34,14 +34,13 @@ package TestParser {
 
 my $parser = TestParser->new;
 
-isa_ok( $parser, "TestParser", '$parser' );
-isa_ok( $parser, "Parser::MGC", '$parser' );
+isa_ok( $parser, [ "TestParser", "Parser::MGC" ], '$parser' );
 
 # ->from_string
 {
    my $tokens = $parser->from_string( "1 2 3" );
 
-   is_deeply( $tokens, [ 1, 2, 3 ], '->from_string' );
+   is( $tokens, [ 1, 2, 3 ], '->from_string' );
 
    ok( $STARTED, '->on_parse_start was invoked' );
    is( $ENDED, $tokens, '->on_parse_end was invoked on result' );
@@ -51,7 +50,7 @@ isa_ok( $parser, "Parser::MGC", '$parser
 {
    my $tokens = $parser->from_file( \*DATA );
 
-   is_deeply( $tokens, [ 4, 5, 6 ], '->from_file(\*DATA)' );
+   is( $tokens, [ 4, 5, 6 ], '->from_file(\*DATA)' );
 }
 
 done_testing;
diff -pruN 0.21-1/t/02expect.t 0.22-1/t/02expect.t
--- 0.21-1/t/02expect.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/02expect.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -41,15 +40,15 @@ package TestParser {
 
 my $parser = TestParser->new( toplevel => "parse_hello" );
 
-is_deeply( $parser->from_string( "hello world" ),
+is( $parser->from_string( "hello world" ),
    [ "hello", "world" ],
    '"hello world"' );
 
-is_deeply( $parser->from_string( "  hello world  " ),
+is( $parser->from_string( "  hello world  " ),
    [ "hello", "world" ],
    '"  hello world  "' );
 
-is( exception { $parser->from_string( "goodbye world" ) },
+is( dies { $parser->from_string( "goodbye world" ) },
    qq[Expected (?^u:hello) on line 1 at:\n] . 
    qq[goodbye world\n] . 
    qq[^\n],
@@ -66,13 +65,13 @@ is( $parser->from_string( "Bar" ), "Bar"
 
 $parser = TestParser->new( toplevel => "parse_numrange" );
 
-is_deeply( $parser->from_string( "123-456" ), [ 123, 456 ], "Number range parser complete" );
+is( $parser->from_string( "123-456" ), [ 123, 456 ], "Number range parser complete" );
 
 {
    my $warnings = "";
    local $SIG{__WARN__} = sub { $warnings .= join "", @_ };
 
-   is_deeply( $parser->from_string( "789" ), [ 789, undef ],   "Number range parser lacking max" );
+   is( $parser->from_string( "789" ), [ 789, undef ],   "Number range parser lacking max" );
    is( $warnings, "", "Number range lacking max yields no warnings" );
 }
 
diff -pruN 0.21-1/t/03reader.t 0.22-1/t/03reader.t
--- 0.21-1/t/03reader.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/03reader.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -27,7 +27,7 @@ my @strings = (
    "tokens"
 );
 
-is_deeply( $parser->from_reader( sub { return shift @strings } ),
+is( $parser->from_reader( sub { return shift @strings } ),
    [qw( here is a list of some more tokens )],
    'tokens from reader' );
 
diff -pruN 0.21-1/t/04where.t 0.22-1/t/04where.t
--- 0.21-1/t/04where.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/04where.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,11 +3,14 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 my @positions;
 my @wheres;
 
+my $diemsg;
+my $warnmsg;
+
 package TestParser {
    use base qw( Parser::MGC );
 
@@ -18,7 +21,7 @@ package TestParser {
       main::is( $self->pos,
          $positions[0],
          '->pos before parsing' );
-      main::is_deeply( [ $self->where ],
+      main::is( [ $self->where ],
          $wheres[0],
          '->where before parsing' );
 
@@ -26,7 +29,7 @@ package TestParser {
       main::is( $self->pos,
          $positions[1],
          '->pos during parsing' );
-      main::is_deeply( [ $self->where ],
+      main::is( [ $self->where ],
          $wheres[1],
          '->where during parsing' );
 
@@ -34,10 +37,13 @@ package TestParser {
       main::is( $self->pos,
          $positions[2],
          '->pos after parsing' );
-      main::is_deeply( [ $self->where ],
+      main::is( [ $self->where ],
          $wheres[2],
          '->where after parsing' );
 
+      $self->die( $diemsg ) if $diemsg;
+      $self->warn( $warnmsg ) if $warnmsg;
+
       return 1;
    }
 }
@@ -58,4 +64,18 @@ $parser->from_string( "hello world" );
    [ 2, 5, "world" ], );
 $parser->from_string( "hello\nworld" );
 
+{
+   $diemsg = "stop here";
+   like( dies { $parser->from_string( "hello\nworld" ) },
+      qr/^stop here on line 2 at:\nworld\n/, 'Exception from ->die failure' );
+   undef $diemsg;
+}
+
+{
+   $warnmsg = "note here";
+   is( warnings { $parser->from_string( "hello\nworld" ) },
+      [ match(qr/^note here on line 2 at:\nworld\n/) ],
+      'Warning from ->warn' );
+}
+
 done_testing;
diff -pruN 0.21-1/t/05comment.t 0.22-1/t/05comment.t
--- 0.21-1/t/05comment.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/05comment.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -24,7 +23,7 @@ my $parser = TestParser->new;
 
 ok( $parser->from_string( "hello world" ), '"hello world"' );
 ok( $parser->from_string( "hello\nworld" ), '"hello\nworld"' );
-ok( exception { $parser->from_string( "hello\n# Comment\nworld" ) }, '"hello world" with comment fails' );
+ok( dies { $parser->from_string( "hello\n# Comment\nworld" ) }, '"hello world" with comment fails' );
 
 $parser = TestParser->new(
    patterns => { comment => qr/#.*\n/ },
diff -pruN 0.21-1/t/06take.t 0.22-1/t/06take.t
--- 0.21-1/t/06take.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/06take.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -19,7 +19,7 @@ package TestParser {
 
 my $parser = TestParser->new;
 
-is_deeply( $parser->from_string( "Hello There" ),
+is( $parser->from_string( "Hello There" ),
    [ "Hello", " Ther", "e" ],
    '"Hello There"' );
 
diff -pruN 0.21-1/t/07generic_token.t 0.22-1/t/07generic_token.t
--- 0.21-1/t/07generic_token.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/07generic_token.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 my $re;
 my $convert;
@@ -24,7 +23,7 @@ my $parser = TestParser->new;
 
 $re = qr/[A-Z]+/;
 is( $parser->from_string( "HELLO" ), "HELLO", 'Simple RE' );
-ok( exception { $parser->from_string( "hello" ) }, 'Simple RE fails' );
+ok( dies { $parser->from_string( "hello" ) }, 'Simple RE fails' );
 
 $re = qr/[A-Z]+/i;
 is( $parser->from_string( "Hello" ), "Hello", 'RE with flags' );
diff -pruN 0.21-1/t/08substring.t 0.22-1/t/08substring.t
--- 0.21-1/t/08substring.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/08substring.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -23,11 +22,11 @@ package TestParser {
 my $parser = TestParser->new;
 
 {
-   is_deeply( $parser->from_string( "Hello, world!" ),
+   is( $parser->from_string( "Hello, world!" ),
       [ "Hello, world", "!" ],
       '"Hello, world!"' );
 
-   is_deeply( $parser->from_string( "!" ),
+   is( $parser->from_string( "!" ),
       [ "", "!" ],
       '"!"' );
 }
@@ -35,7 +34,7 @@ my $parser = TestParser->new;
 {
    local $TestParser::Nonempty = 1;
 
-   is( exception { $parser->from_string( "!" ) },
+   is( dies { $parser->from_string( "!" ) },
       qq[Expected to find a non-empty substring before \(\?^u:\\!\) on line 1 at:\n] .
       qq[!\n] .
       qq[^\n],
diff -pruN 0.21-1/t/10token_int.t 0.22-1/t/10token_int.t
--- 0.21-1/t/10token_int.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/10token_int.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -23,11 +22,11 @@ is( $parser->from_string( "123" ), 123,
 is( $parser->from_string( "0" ),     0, 'Zero' );
 is( $parser->from_string( "0x20" ), 32, 'Hexadecimal integer' );
 is( $parser->from_string( "010" ),   8, 'Octal integer' );
-ok( exception { $parser->from_string( "0o20" ) }, '0o prefix fails' );
+ok( dies { $parser->from_string( "0o20" ) }, '0o prefix fails' );
 
 is( $parser->from_string( "-4" ), -4, 'Negative decimal' );
 
-ok( exception { $parser->from_string( "hello" ) }, '"hello" fails' );
+ok( dies { $parser->from_string( "hello" ) }, '"hello" fails' );
 
 $parser = TestParser->new( accept_0o_oct => 1 );
 is( $parser->from_string( "0o20" ), 16, 'Octal integer with 0o prefix' );
diff -pruN 0.21-1/t/11token_float.t 0.22-1/t/11token_float.t
--- 0.21-1/t/11token_float.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/11token_float.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
diff -pruN 0.21-1/t/12token_number.t 0.22-1/t/12token_number.t
--- 0.21-1/t/12token_number.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/12token_number.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -35,6 +34,6 @@ approx( $parser->from_string( "12." ),
 approx( $parser->from_string( ".34" ),     0.34, 'Leading DP' );
 approx( $parser->from_string( "8.9" ),     8.9,  'Infix DP' );
 
-ok( exception { $parser->from_string( "hello" ) }, '"hello" fails' );
+ok( dies { $parser->from_string( "hello" ) }, '"hello" fails' );
 
 done_testing;
diff -pruN 0.21-1/t/13token_string.t 0.22-1/t/13token_string.t
--- 0.21-1/t/13token_string.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/13token_string.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -56,12 +55,12 @@ $parser = TestParser->new(
 );
 
 is( $parser->from_string( q["double"] ), "double", 'Double quoted string still passes' );
-ok( exception { $parser->from_string( q['single'] ) }, 'Single quoted string now fails' );
+ok( dies { $parser->from_string( q['single'] ) }, 'Single quoted string now fails' );
 
 $parser = StringPairParser->new;
 
-is_deeply( $parser->from_string( q["foo" "bar"] ),
-           [ "foo", "bar" ],
-           'String-matching pattern is non-greedy' );
+is( $parser->from_string( q["foo" "bar"] ),
+   [ "foo", "bar" ],
+   'String-matching pattern is non-greedy' );
 
 done_testing;
diff -pruN 0.21-1/t/14token_ident.t 0.22-1/t/14token_ident.t
--- 0.21-1/t/14token_ident.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/14token_ident.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -23,13 +22,13 @@ is( $parser->from_string( "foo" ), "foo"
 
 is( $parser->from_string( "x" ), "x", 'Single-letter identifier' );
 
-is( exception { $parser->from_string( "123" ) },
+is( dies { $parser->from_string( "123" ) },
    qq[Expected ident on line 1 at:\n] .
    qq[123\n] .
    qq[^\n],
    'Exception from "123" failure' );
 
-ok( exception { $parser->from_string( "some-ident" ) }, '"some-ident" fails on default identifier' );
+ok( dies { $parser->from_string( "some-ident" ) }, '"some-ident" fails on default identifier' );
 
 $parser = TestParser->new(
    patterns => { ident => qr/[[:alpha:]_][\w-]+/ },
diff -pruN 0.21-1/t/15token_kw.t 0.22-1/t/15token_kw.t
--- 0.21-1/t/15token_kw.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/15token_kw.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -21,7 +20,7 @@ my $parser = TestParser->new;
 
 is( $parser->from_string( "foo" ), "foo", 'Keyword' );
 
-is( exception { $parser->from_string( "splot" ) },
+is( dies { $parser->from_string( "splot" ) },
    qq[Expected any of foo, bar on line 1 at:\n] .
    qq[splot\n] .
    qq[^\n],
diff -pruN 0.21-1/t/20maybe.t 0.22-1/t/20maybe.t
--- 0.21-1/t/20maybe.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/20maybe.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 my $diemsg;
 
@@ -38,7 +37,7 @@ is( $parser->from_string( "hello" ), "he
 is( $parser->from_string( "123" ), 123, '"123"' );
 
 $diemsg = "Now have to fail";
-is( exception { $parser->from_string( "456" ) },
+is( dies { $parser->from_string( "456" ) },
    qq[Now have to fail on line 1 at:\n] .
    qq[456\n] .
    qq[^\n],
diff -pruN 0.21-1/t/21scope_of.t 0.22-1/t/21scope_of.t
--- 0.21-1/t/21scope_of.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/21scope_of.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -54,8 +53,8 @@ my $parser = TestParser->new;
 
 is( $parser->from_string( "(123)" ), 123, '"(123)"' );
 
-ok( exception { $parser->from_string( "(abc)" ) }, '"(abc)"' );
-ok( exception { $parser->from_string( "456" ) }, '"456"' );
+ok( dies { $parser->from_string( "(abc)" ) }, '"(abc)"' );
+ok( dies { $parser->from_string( "456" ) }, '"456"' );
 
 is( TestParser2->new->from_string( "(67)" ), 67, '"(67)" as method name' );
 
@@ -64,6 +63,6 @@ $parser = DynamicDelimParser->new;
 is( $parser->from_string( "(45)" ), 45, '"(45)"' );
 is( $parser->from_string( "[45]" ), 45, '"[45]"' );
 
-ok( exception { $parser->from_string( "(45]" ) }, '"(45]" fails' );
+ok( dies { $parser->from_string( "(45]" ) }, '"(45]" fails' );
 
 done_testing;
diff -pruN 0.21-1/t/22list_of.t 0.22-1/t/22list_of.t
--- 0.21-1/t/22list_of.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/22list_of.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -49,16 +49,16 @@ package TestParser3 {
 
 my $parser = TestParser->new;
 
-is_deeply( $parser->from_string( "123" ), [ 123 ], '"123"' );
-is_deeply( $parser->from_string( "4,5,6" ), [ 4, 5, 6 ], '"4,5,6"' );
-is_deeply( $parser->from_string( "7, 8" ), [ 7, 8 ], '"7, 8"' );
+is( $parser->from_string( "123" ), [ 123 ], '"123"' );
+is( $parser->from_string( "4,5,6" ), [ 4, 5, 6 ], '"4,5,6"' );
+is( $parser->from_string( "7, 8" ), [ 7, 8 ], '"7, 8"' );
 
 # Trailing delimiter
-is_deeply( $parser->from_string( "10,11,12," ), [ 10, 11, 12 ], '"10,11,12,"' );
+is( $parser->from_string( "10,11,12," ), [ 10, 11, 12 ], '"10,11,12,"' );
 
-is_deeply( TestParser2->new->from_string( "13,14" ), [ 13, 14 ], '"13,14" as method name' );
+is( TestParser2->new->from_string( "13,14" ), [ 13, 14 ], '"13,14" as method name' );
 
 # List-context
-is_deeply( TestParser3->new->from_string( "20:25" ), [qw[ ( 20 ) ( 25 ) ]], '20:25 in list context' );
+is( TestParser3->new->from_string( "20:25" ), [qw[ ( 20 ) ( 25 ) ]], '20:25 in list context' );
 
 done_testing;
diff -pruN 0.21-1/t/23sequence_of.t 0.22-1/t/23sequence_of.t
--- 0.21-1/t/23sequence_of.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/23sequence_of.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -38,20 +38,20 @@ package IntThenStringParser {
 
 my $parser = TestParser->new;
 
-is_deeply( $parser->from_string( "123" ), [ 123 ], '"123"' );
-is_deeply( $parser->from_string( "4 5 6" ), [ 4, 5, 6 ], '"4 5 6"' );
+is( $parser->from_string( "123" ), [ 123 ], '"123"' );
+is( $parser->from_string( "4 5 6" ), [ 4, 5, 6 ], '"4 5 6"' );
 
-is_deeply( $parser->from_string( "" ), [], '""' );
+is( $parser->from_string( "" ), [], '""' );
 
 $parser = IntThenStringParser->new;
 
-is_deeply( $parser->from_string( "10 20 'ab' 'cd'" ),
-           [ [ 10, 20 ], [ 'ab', 'cd' ] ], q("10 20 'ab' 'cd'") );
+is( $parser->from_string( "10 20 'ab' 'cd'" ),
+   [ [ 10, 20 ], [ 'ab', 'cd' ] ], q("10 20 'ab' 'cd'") );
 
-is_deeply( $parser->from_string( "10 20" ),
-           [ [ 10, 20 ], [] ], q("10 20") );
+is( $parser->from_string( "10 20" ),
+   [ [ 10, 20 ], [] ], q("10 20") );
 
-is_deeply( $parser->from_string( "'ab' 'cd'" ),
-           [ [], [ 'ab', 'cd' ] ], q("'ab' 'cd'") );
+is( $parser->from_string( "'ab' 'cd'" ),
+   [ [], [ 'ab', 'cd' ] ], q("'ab' 'cd'") );
 
 done_testing;
diff -pruN 0.21-1/t/24any_of.t 0.22-1/t/24any_of.t
--- 0.21-1/t/24any_of.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/24any_of.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -37,15 +36,15 @@ package TestParser2 {
 
 my $parser = TestParser->new;
 
-is_deeply( $parser->from_string( "123" ), [ int => 123 ], '"123"' );
-is_deeply( $parser->from_string( q["hi"] ), [ str => "hi" ], '"hi"' );
-is_deeply( $parser->from_string( "foobar" ), [ ident => "foobar" ], '"foobar"' );
+is( $parser->from_string( "123" ), [ int => 123 ], '"123"' );
+is( $parser->from_string( q["hi"] ), [ str => "hi" ], '"hi"' );
+is( $parser->from_string( "foobar" ), [ ident => "foobar" ], '"foobar"' );
 
-is( exception { $parser->from_string( "@" ) }, "Here I fail\n",
+is( dies { $parser->from_string( "@" ) }, "Here I fail\n",
    'Exception from "@" failure' );
 
-ok( exception { $parser->from_string( "+" ) }, '"+" fails' );
+ok( dies { $parser->from_string( "+" ) }, '"+" fails' );
 
-is_deeply( TestParser2->new->from_string( "456" ), [ int => 456 ], '"456" as method name' );
+is( TestParser2->new->from_string( "456" ), [ int => 456 ], '"456" as method name' );
 
 done_testing;
diff -pruN 0.21-1/t/30commit.t 0.22-1/t/30commit.t
--- 0.21-1/t/30commit.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/30commit.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -50,7 +49,7 @@ my $parser = TestParser->new;
 is( $parser->from_string( "123" ), 123, '"123"' );
 is( $parser->from_string( '("hi")' ), "hi", '("hi")' );
 
-is( exception { $parser->from_string( "(456)" ) },
+is( dies { $parser->from_string( "(456)" ) },
    qq[Expected string delimiter on line 1 at:\n].
    qq[(456)\n].
    qq[ ^\n],
@@ -58,11 +57,11 @@ is( exception { $parser->from_string( "(
 
 $parser = IntStringPairsParser->new;
 
-is_deeply( $parser->from_string( "1 'one' 2 'two'" ),
-           [ [ 1, "one" ], [ 2, "two" ] ],
-           "1 'one' 2 'two'" );
+is( $parser->from_string( "1 'one' 2 'two'" ),
+   [ [ 1, "one" ], [ 2, "two" ] ],
+   "1 'one' 2 'two'" );
 
-is( exception { $parser->from_string( "1 'one' 2" ) },
+is( dies { $parser->from_string( "1 'one' 2" ) },
    qq[Expected string on line 1 at:\n].
    qq[1 'one' 2\n].
    qq[         ^\n],
diff -pruN 0.21-1/t/31scope_level.t 0.22-1/t/31scope_level.t
--- 0.21-1/t/31scope_level.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/31scope_level.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -25,8 +25,8 @@ package TestParser {
 
 my $parser = TestParser->new;
 
-is_deeply( $parser->from_string( "a" ), [ "a/0" ], 'a' );
-is_deeply( $parser->from_string( "(b)" ), [ [ "b/1" ] ], '(b)' );
-is_deeply( $parser->from_string( "c (d) e" ), [ "c/0", [ "d/1" ], "e/0" ], 'c (d) e' );
+is( $parser->from_string( "a" ), [ "a/0" ], 'a' );
+is( $parser->from_string( "(b)" ), [ [ "b/1" ] ], '(b)' );
+is( $parser->from_string( "c (d) e" ), [ "c/0", [ "d/1" ], "e/0" ], 'c (d) e' );
 
 done_testing;
diff -pruN 0.21-1/t/32committed_scope_of.t 0.22-1/t/32committed_scope_of.t
--- 0.21-1/t/32committed_scope_of.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/32committed_scope_of.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 my $fallback;
 
@@ -32,7 +31,7 @@ my $parser = TestParser->new;
 
 is( $parser->from_string( "(123)" ), 123, '"(123)"' );
 
-ok( exception { $parser->from_string( "(abc)" ) }, '"(abc)"' );
+ok( dies { $parser->from_string( "(abc)" ) }, '"(abc)"' );
 ok( !$fallback, '"(abc) does not invoke fallback case' );
 
 done_testing;
diff -pruN 0.21-1/t/33exception.t 0.22-1/t/33exception.t
--- 0.21-1/t/33exception.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/33exception.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 use File::Temp qw( tempfile );
 
@@ -21,20 +20,19 @@ package TestParser {
 
 my $parser = TestParser->new;
 
-isa_ok( $parser, "TestParser", '$parser' );
-isa_ok( $parser, "Parser::MGC", '$parser' );
+isa_ok( $parser, [ "TestParser", "Parser::MGC" ], '$parser' );
 
 my $value = $parser->from_string( "\t123" );
 
 is( $value, 123, '->from_string' );
 
-is( exception { $parser->from_string( "\t123." ) },
+is( dies { $parser->from_string( "\t123." ) },
    qq[Expected end of input on line 1 at:\n].
    qq[\t123.\n].
    qq[\t   ^\n],
    'Exception from trailing input on string' );
 
-is( exception { $parser->from_file( \*DATA ) },
+is( dies { $parser->from_file( \*DATA ) },
    qq[Expected end of input on line 1 at:\n].
    qq[ 123.\n].
    qq[    ^\n],
@@ -46,7 +44,7 @@ END { defined $filename and unlink $file
 print $fh " 123.\n";
 close $fh;
 
-is( exception { $parser->from_file( $filename ) },
+is( dies { $parser->from_file( $filename ) },
    qq[Expected end of input in $filename on line 1 at:\n].
    qq[ 123.\n].
    qq[    ^\n],
diff -pruN 0.21-1/t/34stall.t 0.22-1/t/34stall.t
--- 0.21-1/t/34stall.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/34stall.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 package TestParser {
    use base qw( Parser::MGC );
@@ -22,10 +21,10 @@ package TestParser {
 
 my $parser = TestParser->new;
 
-is_deeply( $parser->from_string( "12 34 56" ), [ 12, 34, 56 ],
+is( $parser->from_string( "12 34 56" ), [ 12, 34, 56 ],
    'Correct output from non-stall' );
 
-is( exception { $parser->from_string( "abc def" ) },
+is( dies { $parser->from_string( "abc def" ) },
    qq[TestParser failed to make progress on line 1 at:\n] .
    qq[abc def\n] .
    qq[^\n],
diff -pruN 0.21-1/t/40include_string.t 0.22-1/t/40include_string.t
--- 0.21-1/t/40include_string.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/40include_string.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,8 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
-use Test::Fatal;
+use Test2::V0;
 
 my %vars = (
    ONE => 1,
@@ -47,7 +46,7 @@ my $parser = TestParser->new;
 # ->where position reporting
 {
    is( $parser->from_string( q(Position $HERE) ), "Position X", 'Result of $HERE test' );
-   is_deeply( $where, [ 1, 1, "X" ], 'Position during $HERE' );
+   is( $where, [ 1, 1, "X" ], 'Position during $HERE' );
 }
 
 done_testing;
diff -pruN 0.21-1/t/90ex_bencode.t 0.22-1/t/90ex_bencode.t
--- 0.21-1/t/90ex_bencode.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/90ex_bencode.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 use lib ".";
 require "examples/parse-bencode.pl";
@@ -14,7 +14,7 @@ sub test
 {
    my ( $str, $expect, $name ) = @_;
 
-   is_deeply( $parser->from_string( $str ), $expect, $name );
+   is( $parser->from_string( $str ), $expect, $name );
 }
 
 test q[i10e],
diff -pruN 0.21-1/t/90ex_dict.t 0.22-1/t/90ex_dict.t
--- 0.21-1/t/90ex_dict.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/90ex_dict.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 use lib ".";
 require "examples/parse-dict.pl";
@@ -14,7 +14,7 @@ sub test
 {
    my ( $str, $expect, $name ) = @_;
 
-   is_deeply( $parser->from_string( $str ), $expect, $name );
+   is( $parser->from_string( $str ), $expect, $name );
 }
 
 test q[123],
diff -pruN 0.21-1/t/90ex_expr.t 0.22-1/t/90ex_expr.t
--- 0.21-1/t/90ex_expr.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/90ex_expr.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 use lib ".";
 require "examples/eval-expr.pl";
diff -pruN 0.21-1/t/90ex_jsonlike.t 0.22-1/t/90ex_jsonlike.t
--- 0.21-1/t/90ex_jsonlike.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/90ex_jsonlike.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 use lib ".";
 require "examples/parse-jsonlike.pl";
@@ -14,7 +14,7 @@ sub test
 {
    my ( $str, $expect, $name ) = @_;
 
-   is_deeply( $parser->from_string( $str ), $expect, $name );
+   is( $parser->from_string( $str ), $expect, $name );
 }
 
 test q[123],
diff -pruN 0.21-1/t/90ex_pod.t 0.22-1/t/90ex_pod.t
--- 0.21-1/t/90ex_pod.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/90ex_pod.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 use lib ".";
 require "examples/parse-pod.pl";
@@ -14,7 +14,7 @@ sub test
 {
    my ( $str, $expect, $name ) = @_;
 
-   is_deeply( $parser->from_string( $str ), $expect, $name );
+   is( $parser->from_string( $str ), $expect, $name );
 }
 
 test "Plain text",
diff -pruN 0.21-1/t/90ex_synopsis.t 0.22-1/t/90ex_synopsis.t
--- 0.21-1/t/90ex_synopsis.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/90ex_synopsis.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 use lib ".";
 require "examples/synopsis.pl";
@@ -14,7 +14,7 @@ sub test
 {
    my ( $str, $expect ) = @_;
 
-   is_deeply( $parser->from_string( $str ), [ $expect ], qq("$str") );
+   is( $parser->from_string( $str ), [ $expect ], qq("$str") );
 }
 
 test "123", 123;
diff -pruN 0.21-1/t/90ex_xml.t 0.22-1/t/90ex_xml.t
--- 0.21-1/t/90ex_xml.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/90ex_xml.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More tests => 5;
+use Test2::V0;
 
 use lib ".";
 require "examples/parse-xml.pl";
@@ -17,7 +17,7 @@ sub test
 {
    my ( $str, $expect, $name ) = @_;
 
-   is_deeply( $parser->from_string( $str ), $expect, $name );
+   is( $parser->from_string( $str ), $expect, $name );
 }
 
 test q[<xml>Hello world</xml>],
diff -pruN 0.21-1/t/99pod.t 0.22-1/t/99pod.t
--- 0.21-1/t/99pod.t	2022-02-23 17:38:31.000000000 +0000
+++ 0.22-1/t/99pod.t	2024-10-11 17:37:16.000000000 +0000
@@ -3,7 +3,7 @@
 use v5.14;
 use warnings;
 
-use Test::More;
+use Test2::V0;
 
 eval "use Test::Pod 1.00";
 plan skip_all => "Test::Pod 1.00 required for testing POD" if $@;
