diff -pruN 0.09-1/Build.PL 1.01-1/Build.PL
--- 0.09-1/Build.PL	2020-11-22 05:35:12.000000000 +0000
+++ 1.01-1/Build.PL	2024-10-15 22:09:24.000000000 +0000
@@ -1,4 +1,4 @@
-# This Build.PL for Mojo-JWT was generated by mbtiny 0.028.
+# This Build.PL for Mojo-JWT was generated by mbtiny 0.042.
 use 5.010;
 use Module::Build::Tiny 0;
 Build_PL();
diff -pruN 0.09-1/Changes 1.01-1/Changes
--- 0.09-1/Changes	2020-11-22 05:35:12.000000000 +0000
+++ 1.01-1/Changes	2024-10-15 22:09:24.000000000 +0000
@@ -1,5 +1,12 @@
 Revision history for Perl module Mojo::JWT
 
+1.01 2024-10-15
+  - Fix non-portable test
+
+1.00 2024-10-15
+  - Use CryptX (libtomcrypt) for all cryptographic functions
+  - Crypt::OpenSSL input is still accepted but converted in-use
+
 0.09 2020-11-22
   - Allow passing in a JWKSet which can be used for decoding/verifying tokens (ccakes)
 
diff -pruN 0.09-1/LICENSE 1.01-1/LICENSE
--- 0.09-1/LICENSE	2020-11-22 05:35:12.000000000 +0000
+++ 1.01-1/LICENSE	2024-10-15 22:09:24.000000000 +0000
@@ -1,4 +1,4 @@
-This software is copyright (c) 2020 by Joel Berger, <joel.a.berger@gmail.com>.
+This software is copyright (c) 2024 by Joel Berger, <joel.a.berger@gmail.com>.
 
 This is free software; you can redistribute it and/or modify it under
 the same terms as the Perl 5 programming language system itself.
@@ -12,7 +12,7 @@ b) the "Artistic License"
 
 --- The GNU General Public License, Version 1, February 1989 ---
 
-This software is Copyright (c) 2020 by Joel Berger, <joel.a.berger@gmail.com>.
+This software is Copyright (c) 2024 by Joel Berger, <joel.a.berger@gmail.com>.
 
 This is free software, licensed under:
 
@@ -270,110 +270,143 @@ necessary.  Here a sample; alter the nam
 That's all there is to it!
 
 
---- The Artistic License 1.0 ---
+--- The Perl Artistic License 1.0 ---
 
-This software is Copyright (c) 2020 by Joel Berger, <joel.a.berger@gmail.com>.
+This software is Copyright (c) 2024 by Joel Berger, <joel.a.berger@gmail.com>.
 
 This is free software, licensed under:
 
-  The Artistic License 1.0
+  The Perl Artistic License 1.0
 
-The Artistic License
 
-Preamble
 
-The intent of this document is to state the conditions under which a Package
-may be copied, such that the Copyright Holder maintains some semblance of
-artistic control over the development of the package, while giving the users of
-the package the right to use and distribute the Package in a more-or-less
-customary fashion, plus the right to make reasonable modifications.
+
+
+                         The "Artistic License"
+
+                                Preamble
+
+The intent of this document is to state the conditions under which a
+Package may be copied, such that the Copyright Holder maintains some
+semblance of artistic control over the development of the package,
+while giving the users of the package the right to use and distribute
+the Package in a more-or-less customary fashion, plus the right to make
+reasonable modifications.
 
 Definitions:
 
-  - "Package" refers to the collection of files distributed by the Copyright
-    Holder, and derivatives of that collection of files created through
-    textual modification. 
-  - "Standard Version" refers to such a Package if it has not been modified,
-    or has been modified in accordance with the wishes of the Copyright
-    Holder. 
-  - "Copyright Holder" is whoever is named in the copyright or copyrights for
-    the package. 
-  - "You" is you, if you're thinking about copying or distributing this Package.
-  - "Reasonable copying fee" is whatever you can justify on the basis of media
-    cost, duplication charges, time of people involved, and so on. (You will
-    not be required to justify it to the Copyright Holder, but only to the
-    computing community at large as a market that must bear the fee.) 
-  - "Freely Available" means that no fee is charged for the item itself, though
-    there may be fees involved in handling the item. It also means that
-    recipients of the item may redistribute it under the same conditions they
-    received it. 
+        "Package" refers to the collection of files distributed by the
+        Copyright Holder, and derivatives of that collection of files
+        created through textual modification.
+
+        "Standard Version" refers to such a Package if it has not been
+        modified, or has been modified in accordance with the wishes
+        of the Copyright Holder as specified below.
+
+        "Copyright Holder" is whoever is named in the copyright or
+        copyrights for the package.
+
+        "You" is you, if you're thinking about copying or distributing
+        this Package.
+
+        "Reasonable copying fee" is whatever you can justify on the
+        basis of media cost, duplication charges, time of people involved,
+        and so on.  (You will not be required to justify it to the
+        Copyright Holder, but only to the computing community at large
+        as a market that must bear the fee.)
+
+        "Freely Available" means that no fee is charged for the item
+        itself, though there may be fees involved in handling the item.
+        It also means that recipients of the item may redistribute it
+        under the same conditions they received it.
 
 1. You may make and give away verbatim copies of the source form of the
 Standard Version of this Package without restriction, provided that you
 duplicate all of the original copyright notices and associated disclaimers.
 
-2. You may apply bug fixes, portability fixes and other modifications derived
-from the Public Domain or from the Copyright Holder. A Package modified in such
-a way shall still be considered the Standard Version.
-
-3. You may otherwise modify your copy of this Package in any way, provided that
-you insert a prominent notice in each changed file stating how and when you
-changed that file, and provided that you do at least ONE of the following:
-
-  a) place your modifications in the Public Domain or otherwise make them
-     Freely Available, such as by posting said modifications to Usenet or an
-     equivalent medium, or placing the modifications on a major archive site
-     such as ftp.uu.net, or by allowing the Copyright Holder to include your
-     modifications in the Standard Version of the Package.
-
-  b) use the modified Package only within your corporation or organization.
-
-  c) rename any non-standard executables so the names do not conflict with
-     standard executables, which must also be provided, and provide a separate
-     manual page for each non-standard executable that clearly documents how it
-     differs from the Standard Version.
-
-  d) make other distribution arrangements with the Copyright Holder.
-
-4. You may distribute the programs of this Package in object code or executable
-form, provided that you do at least ONE of the following:
-
-  a) distribute a Standard Version of the executables and library files,
-     together with instructions (in the manual page or equivalent) on where to
-     get the Standard Version.
-
-  b) accompany the distribution with the machine-readable source of the Package
-     with your modifications.
-
-  c) accompany any non-standard executables with their corresponding Standard
-     Version executables, giving the non-standard executables non-standard
-     names, and clearly documenting the differences in manual pages (or
-     equivalent), together with instructions on where to get the Standard
-     Version.
+2. You may apply bug fixes, portability fixes and other modifications
+derived from the Public Domain or from the Copyright Holder.  A Package
+modified in such a way shall still be considered the Standard Version.
 
-  d) make other distribution arrangements with the Copyright Holder.
+3. You may otherwise modify your copy of this Package in any way, provided
+that you insert a prominent notice in each changed file stating how and
+when you changed that file, and provided that you do at least ONE of the
+following:
 
-5. You may charge a reasonable copying fee for any distribution of this
-Package.  You may charge any fee you choose for support of this Package. You
-may not charge a fee for this Package itself. However, you may distribute this
-Package in aggregate with other (possibly commercial) programs as part of a
-larger (possibly commercial) software distribution provided that you do not
-advertise this Package as a product of your own.
-
-6. The scripts and library files supplied as input to or produced as output
-from the programs of this Package do not automatically fall under the copyright
-of this Package, but belong to whomever generated them, and may be sold
-commercially, and may be aggregated with this Package.
+    a) place your modifications in the Public Domain or otherwise make them
+    Freely Available, such as by posting said modifications to Usenet or
+    an equivalent medium, or placing the modifications on a major archive
+    site such as uunet.uu.net, or by allowing the Copyright Holder to include
+    your modifications in the Standard Version of the Package.
+
+    b) use the modified Package only within your corporation or organization.
+
+    c) rename any non-standard executables so the names do not conflict
+    with standard executables, which must also be provided, and provide
+    a separate manual page for each non-standard executable that clearly
+    documents how it differs from the Standard Version.
 
-7. C or perl subroutines supplied by you and linked into this Package shall not
-be considered part of this Package.
+    d) make other distribution arrangements with the Copyright Holder.
+
+4. You may distribute the programs of this Package in object code or
+executable form, provided that you do at least ONE of the following:
+
+    a) distribute a Standard Version of the executables and library files,
+    together with instructions (in the manual page or equivalent) on where
+    to get the Standard Version.
+
+    b) accompany the distribution with the machine-readable source of
+    the Package with your modifications.
+
+    c) give non-standard executables non-standard names, and clearly
+    document the differences in manual pages (or equivalent), together
+    with instructions on where to get the Standard Version.
+
+    d) make other distribution arrangements with the Copyright Holder.
+
+5. You may charge a reasonable copying fee for any distribution of this
+Package.  You may charge any fee you choose for support of this
+Package.  You may not charge a fee for this Package itself.  However,
+you may distribute this Package in aggregate with other (possibly
+commercial) programs as part of a larger (possibly commercial) software
+distribution provided that you do not advertise this Package as a
+product of your own.  You may embed this Package's interpreter within
+an executable of yours (by linking); this shall be construed as a mere
+form of aggregation, provided that the complete Standard Version of the
+interpreter is so embedded.
+
+6. The scripts and library files supplied as input to or produced as
+output from the programs of this Package do not automatically fall
+under the copyright of this Package, but belong to whoever generated
+them, and may be sold commercially, and may be aggregated with this
+Package.  If such scripts or library files are aggregated with this
+Package via the so-called "undump" or "unexec" methods of producing a
+binary executable image, then distribution of such an image shall
+neither be construed as a distribution of this Package nor shall it
+fall under the restrictions of Paragraphs 3 and 4, provided that you do
+not represent such an executable image as a Standard Version of this
+Package.
+
+7. C subroutines (or comparably compiled subroutines in other
+languages) supplied by you and linked into this Package in order to
+emulate subroutines and variables of the language defined by this
+Package shall not be considered part of this Package, but are the
+equivalent of input as in Paragraph 6, provided these subroutines do
+not change the language in any way that would cause it to fail the
+regression tests for the language.
+
+8. Aggregation of this Package with a commercial distribution is always
+permitted provided that the use of this Package is embedded; that is,
+when no overt attempt is made to make this Package's interfaces visible
+to the end user of the commercial distribution.  Such use shall not be
+construed as a distribution of this Package.
 
-8. The name of the Copyright Holder may not be used to endorse or promote
+9. The name of the Copyright Holder may not be used to endorse or promote
 products derived from this software without specific prior written permission.
 
-9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
-WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
-MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
+10. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
+IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
+WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 
-The End
+                                The End
 
diff -pruN 0.09-1/META.json 1.01-1/META.json
--- 0.09-1/META.json	2020-11-22 05:35:12.000000000 +0000
+++ 1.01-1/META.json	2024-10-15 22:09:24.000000000 +0000
@@ -4,7 +4,7 @@
       "Joel Berger, <joel.a.berger@gmail.com>"
    ],
    "dynamic_config" : 0,
-   "generated_by" : "App::ModuleBuildTiny version 0.028",
+   "generated_by" : "App::ModuleBuildTiny version 0.042",
    "license" : [
       "perl_5"
    ],
@@ -26,13 +26,8 @@
          }
       },
       "runtime" : {
-         "recommends" : {
-            "Crypt::OpenSSL::Bignum" : "0",
-            "Crypt::OpenSSL::RSA" : "0"
-         },
          "requires" : {
-            "Digest::SHA" : "0",
-            "MIME::Base64" : "3.11",
+            "CryptX" : "0.029",
             "Mojolicious" : "5.00",
             "perl" : "5.010"
          }
@@ -41,7 +36,7 @@
    "provides" : {
       "Mojo::JWT" : {
          "file" : "lib/Mojo/JWT.pm",
-         "version" : "0.09"
+         "version" : "1.01"
       }
    },
    "release_status" : "stable",
@@ -56,7 +51,7 @@
          "url" : "http://github.com/jberger/Mojo-JWT"
       }
    },
-   "version" : "0.09",
-   "x_serialization_backend" : "JSON::PP version 2.97001",
+   "version" : "1.01",
+   "x_serialization_backend" : "JSON::PP version 4.07",
    "x_spdx_expression" : "Artistic-1.0-Perl OR GPL-1.0-or-later"
 }
diff -pruN 0.09-1/META.yml 1.01-1/META.yml
--- 0.09-1/META.yml	2020-11-22 05:35:12.000000000 +0000
+++ 1.01-1/META.yml	2024-10-15 22:09:24.000000000 +0000
@@ -6,7 +6,7 @@ build_requires: {}
 configure_requires:
   Module::Build::Tiny: '0'
 dynamic_config: 0
-generated_by: 'App::ModuleBuildTiny version 0.028, CPAN::Meta::Converter version 2.150010'
+generated_by: 'App::ModuleBuildTiny version 0.042, CPAN::Meta::Converter version 2.150010'
 license: perl
 meta-spec:
   url: http://module-build.sourceforge.net/META-spec-v1.4.html
@@ -15,19 +15,15 @@ name: Mojo-JWT
 provides:
   Mojo::JWT:
     file: lib/Mojo/JWT.pm
-    version: '0.09'
-recommends:
-  Crypt::OpenSSL::Bignum: '0'
-  Crypt::OpenSSL::RSA: '0'
+    version: '1.01'
 requires:
-  Digest::SHA: '0'
-  MIME::Base64: '3.11'
+  CryptX: '0.029'
   Mojolicious: '5.00'
   perl: '5.010'
 resources:
   bugtracker: http://github.com/jberger/Mojo-JWT/issues
   license: http://dev.perl.org/licenses/
   repository: http://github.com/jberger/Mojo-JWT
-version: '0.09'
+version: '1.01'
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
 x_spdx_expression: 'Artistic-1.0-Perl OR GPL-1.0-or-later'
diff -pruN 0.09-1/README 1.01-1/README
--- 0.09-1/README	2020-11-22 05:35:12.000000000 +0000
+++ 1.01-1/README	2024-10-15 22:09:24.000000000 +0000
@@ -71,12 +71,17 @@ ATTRIBUTES
  public
 
     The public key to be used in decoding an asymmetrically signed JWT (eg.
-    RSA).
+    RSA). This can be any public key in a string format accepted by
+    Crypt::PK::RSA or a Crypt::PK::RSA object (if used a
+    Crypt::OpenSSL::RSA object will be converted).
 
  secret
 
     The symmetric secret (eg. HMAC) or else the private key used in
-    encoding an asymmetrically signed JWT (eg. RSA).
+    encoding an asymmetrically signed JWT (eg. RSA). Symmetric secrets
+    should be a string. A private key can be in a string format accepted by
+    Crypt::PK::RSA or a Crypt::PK::RSA object (if used a
+    Crypt::OpenSSL::RSA object will be converted).
 
  set_iat
 
diff -pruN 0.09-1/cpanfile 1.01-1/cpanfile
--- 0.09-1/cpanfile	2020-11-22 05:35:12.000000000 +0000
+++ 1.01-1/cpanfile	2024-10-15 22:09:24.000000000 +0000
@@ -1,11 +1,7 @@
 requires 'Mojolicious', '5.00';
-requires 'Digest::SHA';
-requires 'MIME::Base64', '3.11';
+requires 'CryptX', '0.029';
 requires 'perl', '5.010';
 
-recommends 'Crypt::OpenSSL::Bignum';
-recommends 'Crypt::OpenSSL::RSA';
-
 configure_requires 'Module::Build::Tiny';
 
 author_requires 'App::ModuleBuildTiny';
diff -pruN 0.09-1/debian/changelog 1.01-1/debian/changelog
--- 0.09-1/debian/changelog	2020-11-23 20:13:53.000000000 +0000
+++ 1.01-1/debian/changelog	2024-11-09 01:30:20.000000000 +0000
@@ -1,3 +1,17 @@
+libmojo-jwt-perl (1.01-1) unstable; urgency=medium
+
+  * Team upload.
+
+  [ Debian Janitor ]
+  * Update standards version to 4.6.0, no changes needed.
+
+  [ gregor herrmann ]
+  * Import upstream version 1.01.
+  * Update test and runtime dependencies.
+  * Declare compliance with Debian Policy 4.7.0.
+
+ -- gregor herrmann <gregoa@debian.org>  Sat, 09 Nov 2024 02:30:20 +0100
+
 libmojo-jwt-perl (0.09-1) unstable; urgency=medium
 
   * Team upload.
diff -pruN 0.09-1/debian/control 1.01-1/debian/control
--- 0.09-1/debian/control	2020-11-23 20:13:53.000000000 +0000
+++ 1.01-1/debian/control	2024-11-09 01:30:20.000000000 +0000
@@ -7,10 +7,9 @@ Priority: optional
 Build-Depends: debhelper-compat (= 13),
                libmodule-build-tiny-perl,
                perl
-Build-Depends-Indep: libcrypt-openssl-bignum-perl <!nocheck>,
-                     libcrypt-openssl-rsa-perl <!nocheck>,
+Build-Depends-Indep: libcryptx-perl <!nocheck>,
                      libmojolicious-perl <!nocheck>
-Standards-Version: 4.5.1
+Standards-Version: 4.7.0
 Vcs-Browser: https://salsa.debian.org/perl-team/modules/packages/libmojo-jwt-perl
 Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libmojo-jwt-perl.git
 Homepage: https://metacpan.org/release/Mojo-JWT
@@ -20,9 +19,8 @@ Package: libmojo-jwt-perl
 Architecture: all
 Depends: ${misc:Depends},
          ${perl:Depends},
-         libcrypt-openssl-rsa-perl,
+         libcryptx-perl,
          libmojolicious-perl
-Recommends: libcrypt-openssl-bignum-perl
 Description: JSON Web Token the Mojo way
  JSON Web Token is described in https://tools.ietf.org/html/rfc7519. Mojo::JWT
  implements that standard with an API that should feel familiar to Mojolicious
diff -pruN 0.09-1/lib/Mojo/JWT.pm 1.01-1/lib/Mojo/JWT.pm
--- 0.09-1/lib/Mojo/JWT.pm	2020-11-22 05:35:12.000000000 +0000
+++ 1.01-1/lib/Mojo/JWT.pm	2024-10-15 22:09:24.000000000 +0000
@@ -2,17 +2,19 @@ package Mojo::JWT;
 
 use Mojo::Base -base;
 
-our $VERSION = '0.09';
+our $VERSION = '1.01';
 $VERSION = eval $VERSION;
 
-use Scalar::Util qw/blessed/;
-use List::Util qw/first/;
-use Mojo::JSON qw/encode_json decode_json/;
-use MIME::Base64 qw/encode_base64url decode_base64url/;
+use Scalar::Util ();
+use List::Util ();
+use Mojo::JSON ();
 
-use Carp;
+use CryptX;
+use Crypt::Misc ();
 
-my $isa = sub { blessed $_[0] && $_[0]->isa($_[1]) };
+use Carp ();
+
+my $isa = sub { Scalar::Util::blessed $_[0] && $_[0]->isa($_[1]) };
 
 has header => sub { {} };
 has algorithm => 'HS256';
@@ -45,14 +47,14 @@ sub decode {
   delete $self->{$_} for qw/claims expires not_before header/;
 
   my ($hstring, $cstring, $signature) = split /\./, $token;
-  my $header = decode_json decode_base64url($hstring);
-  my $claims = decode_json decode_base64url($cstring);
-  $signature = decode_base64url $signature;
+  my $header = Mojo::JSON::decode_json Crypt::Misc::decode_b64u($hstring);
+  my $claims = Mojo::JSON::decode_json Crypt::Misc::decode_b64u($cstring);
+  $signature = Crypt::Misc::decode_b64u $signature;
 
   # typ header is only recommended and is ignored
   # https://tools.ietf.org/html/rfc7519#section-5.1
   delete $header->{typ};
-  croak 'Required header field "alg" not specified'
+  Carp::croak 'Required header field "alg" not specified'
     unless my $algo = $self->algorithm(delete $header->{alg})->algorithm;
   $self->header($header);
 
@@ -63,26 +65,26 @@ sub decode {
   # check signature
   my $payload = "$hstring.$cstring";
   if ($algo eq 'none') {
-    croak 'Algorithm "none" is prohibited'
+    Carp::croak 'Algorithm "none" is prohibited'
       unless $self->allow_none;
   } elsif ($algo =~ $re_rs) {
-    croak 'Failed RS validation'
+    Carp::croak 'Failed RS validation'
       unless $self->verify_rsa($1, $payload, $signature);
   } elsif ($algo =~ $re_hs) {
-    croak 'Failed HS validation'
+    Carp::croak 'Failed HS validation'
       unless $signature eq $self->sign_hmac($1, $payload);
   } else {
-    croak 'Unsupported signing algorithm';
+    Carp::croak 'Unsupported signing algorithm';
   }
 
   # check timing
   my $now = $self->now;
   if (defined(my $exp = $claims->{exp})) {
-    croak 'JWT has expired' if $now > $exp;
+    Carp::croak 'JWT has expired' if $now > $exp;
     $self->expires($exp);
   }
   if (defined(my $nbf = $claims->{nbf})) {
-    croak 'JWT is not yet valid' if $now < $nbf;
+    Carp::croak 'JWT is not yet valid' if $now < $nbf;
     $self->not_before($nbf);
   }
 
@@ -94,19 +96,15 @@ sub _try_jwks {
   return unless @{$self->jwks} && $header->{kid};
 
   # Check we have the JWK for this JWT
-  my $jwk = first { exists $header->{kid} && $_->{kid} eq $header->{kid} } @{$self->jwks};
+  my $jwk = List::Util::first { exists $header->{kid} && $_->{kid} eq $header->{kid} } @{$self->jwks};
   return unless $jwk;
 
-  if ($algo =~ /^RS/) {
-    require Crypt::OpenSSL::Bignum;
-    my $n = Crypt::OpenSSL::Bignum->new_from_bin(decode_base64url $jwk->{n});
-    my $e = Crypt::OpenSSL::Bignum->new_from_bin(decode_base64url $jwk->{e});
-
-    require Crypt::OpenSSL::RSA;
-    my $pubkey = Crypt::OpenSSL::RSA->new_key_from_parameters($n, $e);
+  if ($algo =~ $re_rs) {
+    require Crypt::PK::RSA;
+    my $pubkey = Crypt::PK::RSA->new($jwk);
     $self->public($pubkey);
-  } elsif ($algo =~ /^HS/) {
-    $self->secret( decode_base64url $jwk->{k} )
+  } elsif ($algo =~ $re_hs) {
+    $self->secret( Crypt::Misc::decode_b64u $jwk->{k} )
   }
 }
 
@@ -120,8 +118,8 @@ sub encode {
   if (defined(my $nbf = $self->not_before)) { $claims->{nbf} = $nbf }
 
   my $header  = { %{ $self->header }, typ => 'JWT', alg => $self->algorithm };
-  my $hstring = encode_base64url encode_json($header);
-  my $cstring = encode_base64url encode_json($claims);
+  my $hstring = Crypt::Misc::encode_b64u Mojo::JSON::encode_json($header);
+  my $cstring = Crypt::Misc::encode_b64u Mojo::JSON::encode_json($claims);
   my $payload = "$hstring.$cstring";
   my $signature;
   my $algo = $self->algorithm;
@@ -132,41 +130,48 @@ sub encode {
   } elsif ($algo =~ $re_hs) {
     $signature = $self->sign_hmac($1, $payload);
   } else {
-    croak 'Unknown algorithm';
+    Carp::croak 'Unknown algorithm';
   }
 
-  return $self->{token} = "$payload." . encode_base64url $signature;
+  return $self->{token} = "$payload." . Crypt::Misc::encode_b64u $signature;
 }
 
 sub now { time }
 
 sub sign_hmac {
   my ($self, $size, $payload) = @_;
-  croak 'symmetric secret not specified' unless my $secret = $self->secret;
-  require Digest::SHA;
-  my $f = Digest::SHA->can("hmac_sha$size") || croak 'Unsupported HS signing algorithm';
-  return $f->($payload, $secret);
+  Carp::croak 'symmetric secret not specified' unless my $secret = $self->secret;
+  Carp::croak 'Unsupported HS signing algorithm' unless $size == 256 || $size == 384 || $size == 512;
+  require Crypt::Mac::HMAC;
+  return Crypt::Mac::HMAC::hmac("SHA$size", $secret, $payload);
 }
 
 sub sign_rsa {
   my ($self, $size, $payload) = @_;
-  require Crypt::OpenSSL::RSA;
-  my $crypt = Crypt::OpenSSL::RSA->new_private_key($self->secret || croak 'private key (secret) not specified');
-  my $method = $crypt->can("use_sha${size}_hash") || croak 'Unsupported RS signing algorithm';
-  $crypt->$method;
-  return $crypt->sign($payload);
+  Carp::croak 'Unsupported RS signing algorithm' unless $size == 256 || $size == 384 || $size == 512;
+  Carp::croak 'secret key not specified' unless my $secret = $self->secret;
+  my $crypt = _inflate_rsa_key($secret);
+  return $crypt->sign_message($payload, "SHA$size", 'v1.5');
 }
 
 sub token { shift->{token} }
 
 sub verify_rsa {
   my ($self, $size, $payload, $signature) = @_;
-  require Crypt::OpenSSL::RSA;
-  croak 'public key not specified' unless my $public = $self->public;
-  my $crypt = $public->$isa('Crypt::OpenSSL::RSA') ? $public : Crypt::OpenSSL::RSA->new_public_key($public);
-  my $method = $crypt->can("use_sha${size}_hash") || croak 'Unsupported RS verification algorithm';
-  $crypt->$method;
-  return $crypt->verify($payload, $signature);
+  Carp::croak 'Unsupported RS verification algorithm' unless $size == 256 || $size == 384 || $size == 512;
+  Carp::croak 'public key not specified' unless my $public = $self->public;
+  my $crypt = _inflate_rsa_key($public);
+  return $crypt->verify_message($signature, $payload, "SHA$size", 'v1.5');
+}
+
+sub _inflate_rsa_key {
+  my ($key) = @_;
+  require Crypt::PK::RSA;
+  return $key if $key->$isa('Crypt::PK::RSA');
+  if ($key->$isa('Crypt::OpenSSL::RSA')) {
+    $key = $key->is_private ? $key->get_private_key_string : $key->get_public_key_string;
+  }
+  return Crypt::PK::RSA->new(\$key);
 }
 
 1;
@@ -228,10 +233,13 @@ This value (if set and not undefined) wi
 =head2 public
 
 The public key to be used in decoding an asymmetrically signed JWT (eg. RSA).
+This can be any public key in a string format accepted by L<Crypt::PK::RSA> or a L<Crypt::PK::RSA> object (if used a L<Crypt::OpenSSL::RSA> object will be converted).
 
 =head2 secret
 
 The symmetric secret (eg. HMAC) or else the private key used in encoding an asymmetrically signed JWT (eg. RSA).
+Symmetric secrets should be a string.
+A private key can be in a string format accepted by L<Crypt::PK::RSA> or a L<Crypt::PK::RSA> object (if used a L<Crypt::OpenSSL::RSA> object will be converted).
 
 =head2 set_iat
 
diff -pruN 0.09-1/t/basic.t 1.01-1/t/basic.t
--- 0.09-1/t/basic.t	2020-11-22 05:35:12.000000000 +0000
+++ 1.01-1/t/basic.t	2024-10-15 22:09:24.000000000 +0000
@@ -6,8 +6,7 @@ use Test::More;
 use Mojo::JSON qw/decode_json/;
 use Mojo::JWT;
 
-my $has_rsa = eval { require Crypt::OpenSSL::RSA; 1 };
-my $has_bignum = eval { require Crypt::OpenSSL::Bignum; 1 };
+use Crypt::PK::RSA;
 
 {
     my $name = 'encodes and decodes JWTs';
@@ -41,13 +40,33 @@ my $has_bignum = eval { require Crypt::O
     is_deeply $decoded_payload, $payload, $name;
 }
 
+{
+    my $name = 'encodes and decodes JWTs for RSA signatures (from strings)';
+    my $rsa = Crypt::PK::RSA->new();
+    $rsa->generate_key();
+    my $payload = {foo => 'bar'};
+    my $jwt = Mojo::JWT->new(claims => $payload, secret => $rsa->export_key_pem('private'), algorithm => 'RS512')->encode;
+    my $decoded_payload = Mojo::JWT->new(public => $rsa->export_key_pem('public'))->decode($jwt);
+    is_deeply $decoded_payload, $payload, $name;
+}
+
+{
+    my $name = 'encodes and decodes JWTs for RSA signatures (from objects)';
+    my $rsa = Crypt::PK::RSA->new();
+    $rsa->generate_key();
+    my $payload = {foo => 'bar'};
+    my $jwt = Mojo::JWT->new(claims => $payload, secret => $rsa, algorithm => 'RS512')->encode;
+    my $decoded_payload = Mojo::JWT->new(public => $rsa)->decode($jwt);
+    is_deeply $decoded_payload, $payload, $name;
+}
+
 SKIP: {
-    skip 'requires Crypt::OpenSSL::RSA', 1 unless $has_rsa;
-    my $name = 'encodes and decodes JWTs for RSA signaturese';
+    skip 'requires Crypt::OpenSSL::RSA', 1 unless eval { require Crypt::OpenSSL::RSA; 1 };
+    my $name = 'encodes and decodes JWTs for RSA signatures (from Crypt::OpenSSL::RSA objects)';
     my $rsa = Crypt::OpenSSL::RSA->generate_key(1024);
     my $payload = {foo => 'bar'};
-    my $jwt = Mojo::JWT->new(claims => $payload, secret => $rsa->get_private_key_string, algorithm => 'RS512')->encode;
-    my $decoded_payload = Mojo::JWT->new(public => $rsa->get_public_key_string)->decode($jwt);
+    my $jwt = Mojo::JWT->new(claims => $payload, secret => $rsa, algorithm => 'RS512')->encode;
+    my $decoded_payload = Mojo::JWT->new(public => $rsa)->decode($jwt);
     is_deeply $decoded_payload, $payload, $name;
 }
 
@@ -84,15 +103,14 @@ SKIP: {
     like $@, qr/^symmetric secret not specified/, $name;
 }
 
-SKIP: {
-    skip 'requires Crypt::OpenSSL::RSA', 1 unless $has_rsa;
+{
     my $name = 'raises exception with wrong rsa key';
-    my $right_rsa = Crypt::OpenSSL::RSA->generate_key(1024);
-    my $bad_rsa = Crypt::OpenSSL::RSA->generate_key(1024);
+    my $right_rsa = Crypt::PK::RSA->new; $right_rsa->generate_key();
+    my $bad_rsa = Crypt::PK::RSA->new; $bad_rsa->generate_key();
     my $payload = {foo => 'bar'};
-    my $jwt = Mojo::JWT->new(claims => $payload, secret => $right_rsa->get_private_key_string, algorithm => 'RS256')->encode;
+    my $jwt = Mojo::JWT->new(claims => $payload, secret => $right_rsa->export_key_pem('private'), algorithm => 'RS256')->encode;
     eval {
-        Mojo::JWT->new(public => $bad_rsa->get_public_key_string)->decode($jwt);
+        Mojo::JWT->new(public => $bad_rsa->export_key_pem('public'))->decode($jwt);
     };
     like $@, qr/^Failed RS validation/, $name;
 }
@@ -138,8 +156,7 @@ SKIP: {
     is_deeply $jwt->header, $expected_header, $name;
 }
 
-SKIP: {
-    skip 'requires Crypt::OpenSSL::Bignum', 1 unless $has_bignum;
+{
     my $name = 'decodes JWT with jwks';
     my $jwk = '{"kty":"RSA","e":"AQAB","kid":"test","n":"nzyis1ZjfNB0bBgKFMSvvkTtwlvBsaJq7S5wA-kzeVOVpVWwkWdVha4s38XM_pa_yr47av7-z3VTmvDRyAHcaT92whREFpLv9cj5lTeJSibyr_Mrm_YtjCZVWgaOYIhwrXwKLqPr_11inWsAkfIytvHWTxZYEcXLgAXFuUuaS3uF9gEiNQwzGTU1v0FqkqTBr4B8nW3HCN47XUu0t8Y0e-lf4s4OxQawWD79J9_5d3Ry0vbV3Am1FtGJiJvOwRsIfVChDpYStTcHTCMqtvWbV6L11BWkpzGXSW4Hv43qa-GSYOD2QU68Mb59oSk2OB-BtOLpJofmbGEGgvmwyCI9Mw"}';
     my $payload = 'eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6InRlc3QifQ.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.fkLIy_Zvkt7wS6YhOqcaPkyqHK0hMwd1qBNoysXpWlt2fsArf-_ZwmDP8Qao23XPpY1lHrRRuXCpf_Fyyv8eBDYFTtopqkoXeaFPK2ERjCiK6dvOGeLwY5hXu-itTpueqdpeM2GTPS6Eu_JAtYe-wyztnS14BbCZrUCXJCOyuP4Kp78Hw0LfsiXwRb0OsHmefK7BrWJCptPTShVSu2UP0wPL5wBR0MEJIdp7fMcyqSVxmzYeaVxw_prTy655CmhanciawRgqx4ccTIRsfKR_s3SiatsPUeWqGfW2NsVgpzVRGUuOgBOOav6Bk7etb3U3wxAURyAW-9RZV6fsOpShbA';
@@ -150,8 +167,7 @@ SKIP: {
     is_deeply $jwt->claims, $expected_claims, $name;
 }
 
-SKIP: {
-    skip 'requires Crypt::OpenSSL::Bignum', 1 unless $has_bignum;
+{
     my $name = 'decodes JWT with jwkset object';
     my $jwk = '{"kty":"RSA","e":"AQAB","kid":"test","n":"nzyis1ZjfNB0bBgKFMSvvkTtwlvBsaJq7S5wA-kzeVOVpVWwkWdVha4s38XM_pa_yr47av7-z3VTmvDRyAHcaT92whREFpLv9cj5lTeJSibyr_Mrm_YtjCZVWgaOYIhwrXwKLqPr_11inWsAkfIytvHWTxZYEcXLgAXFuUuaS3uF9gEiNQwzGTU1v0FqkqTBr4B8nW3HCN47XUu0t8Y0e-lf4s4OxQawWD79J9_5d3Ry0vbV3Am1FtGJiJvOwRsIfVChDpYStTcHTCMqtvWbV6L11BWkpzGXSW4Hv43qa-GSYOD2QU68Mb59oSk2OB-BtOLpJofmbGEGgvmwyCI9Mw"}';
     my $payload = 'eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6InRlc3QifQ.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.fkLIy_Zvkt7wS6YhOqcaPkyqHK0hMwd1qBNoysXpWlt2fsArf-_ZwmDP8Qao23XPpY1lHrRRuXCpf_Fyyv8eBDYFTtopqkoXeaFPK2ERjCiK6dvOGeLwY5hXu-itTpueqdpeM2GTPS6Eu_JAtYe-wyztnS14BbCZrUCXJCOyuP4Kp78Hw0LfsiXwRb0OsHmefK7BrWJCptPTShVSu2UP0wPL5wBR0MEJIdp7fMcyqSVxmzYeaVxw_prTy655CmhanciawRgqx4ccTIRsfKR_s3SiatsPUeWqGfW2NsVgpzVRGUuOgBOOav6Bk7etb3U3wxAURyAW-9RZV6fsOpShbA';
@@ -162,8 +178,7 @@ SKIP: {
     is_deeply $jwt->claims, $expected_claims, $name;
 }
 
-SKIP: {
-    skip 'requires Crypt::OpenSSL::Bignum', 1 unless $has_bignum;
+{
     my $name = 'decodes JWT with jwkset array';
     my $jwk = '{"kty":"RSA","e":"AQAB","kid":"test","n":"nzyis1ZjfNB0bBgKFMSvvkTtwlvBsaJq7S5wA-kzeVOVpVWwkWdVha4s38XM_pa_yr47av7-z3VTmvDRyAHcaT92whREFpLv9cj5lTeJSibyr_Mrm_YtjCZVWgaOYIhwrXwKLqPr_11inWsAkfIytvHWTxZYEcXLgAXFuUuaS3uF9gEiNQwzGTU1v0FqkqTBr4B8nW3HCN47XUu0t8Y0e-lf4s4OxQawWD79J9_5d3Ry0vbV3Am1FtGJiJvOwRsIfVChDpYStTcHTCMqtvWbV6L11BWkpzGXSW4Hv43qa-GSYOD2QU68Mb59oSk2OB-BtOLpJofmbGEGgvmwyCI9Mw"}';
     my $payload = 'eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6InRlc3QifQ.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.fkLIy_Zvkt7wS6YhOqcaPkyqHK0hMwd1qBNoysXpWlt2fsArf-_ZwmDP8Qao23XPpY1lHrRRuXCpf_Fyyv8eBDYFTtopqkoXeaFPK2ERjCiK6dvOGeLwY5hXu-itTpueqdpeM2GTPS6Eu_JAtYe-wyztnS14BbCZrUCXJCOyuP4Kp78Hw0LfsiXwRb0OsHmefK7BrWJCptPTShVSu2UP0wPL5wBR0MEJIdp7fMcyqSVxmzYeaVxw_prTy655CmhanciawRgqx4ccTIRsfKR_s3SiatsPUeWqGfW2NsVgpzVRGUuOgBOOav6Bk7etb3U3wxAURyAW-9RZV6fsOpShbA';
@@ -174,8 +189,7 @@ SKIP: {
     is_deeply $jwt->claims, $expected_claims, $name;
 }
 
-SKIP: {
-    skip 'requires Crypt::OpenSSL::Bignum', 1 unless $has_bignum;
+{
     my $name = 'should not decode JWT with missing kid if trying against jwks';
     my $jwk = '{"kty":"RSA","e":"AQAB","kid":"test","n":"nzyis1ZjfNB0bBgKFMSvvkTtwlvBsaJq7S5wA-kzeVOVpVWwkWdVha4s38XM_pa_yr47av7-z3VTmvDRyAHcaT92whREFpLv9cj5lTeJSibyr_Mrm_YtjCZVWgaOYIhwrXwKLqPr_11inWsAkfIytvHWTxZYEcXLgAXFuUuaS3uF9gEiNQwzGTU1v0FqkqTBr4B8nW3HCN47XUu0t8Y0e-lf4s4OxQawWD79J9_5d3Ry0vbV3Am1FtGJiJvOwRsIfVChDpYStTcHTCMqtvWbV6L11BWkpzGXSW4Hv43qa-GSYOD2QU68Mb59oSk2OB-BtOLpJofmbGEGgvmwyCI9Mw"}';
     my $payload = 'eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.POstGetfAytaZS82wHcjoTyoqhMyxXiWdR7Nn7A29DNSl0EiXLdwJ6xC6AfgZWF1bOsS_TuYI3OG85AmiExREkrS6tDfTQ2B3WXlrr-wp5AokiRbz3_oB4OxG-W9KcEEbDRcZc0nH3L7LzYptiy1PtAylQGxHTWZXtGz4ht0bAecBgmpdgXMguEIcoqPJ1n3pIWk_dUZegpqx0Lka21H6XxUTxiy8OcaarA8zdnPUnV6AmNP3ecFawIFYdvJB_cm-GvpCSbr8G8y_Mllj8f4x9nBH8pQux89_6gUY618iYv7tuPWBFfEbLxtF2pZS6YC1aSfLQxeNe8djT9YjpvRZA';
@@ -187,8 +201,7 @@ SKIP: {
     like $@, qr/^public key not specified/, $name;
 }
 
-SKIP: {
-    skip 'requires Crypt::OpenSSL::Bignum', 1 unless $has_bignum;
+{
     my $name = 'should not decode JWT without JWK';
     my $jwk = '{"kty":"RSA","e":"AQAB","kid":"test-other","n":"nzyis1ZjfNB0bBgKFMSvvkTtwlvBsaJq7S5wA-kzeVOVpVWwkWdVha4s38XM_pa_yr47av7-z3VTmvDRyAHcaT92whREFpLv9cj5lTeJSibyr_Mrm_YtjCZVWgaOYIhwrXwKLqPr_11inWsAkfIytvHWTxZYEcXLgAXFuUuaS3uF9gEiNQwzGTU1v0FqkqTBr4B8nW3HCN47XUu0t8Y0e-lf4s4OxQawWD79J9_5d3Ry0vbV3Am1FtGJiJvOwRsIfVChDpYStTcHTCMqtvWbV6L11BWkpzGXSW4Hv43qa-GSYOD2QU68Mb59oSk2OB-BtOLpJofmbGEGgvmwyCI9Mw"}';
     my $payload = 'eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCIsImtpZCI6InRlc3QifQ.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.fkLIy_Zvkt7wS6YhOqcaPkyqHK0hMwd1qBNoysXpWlt2fsArf-_ZwmDP8Qao23XPpY1lHrRRuXCpf_Fyyv8eBDYFTtopqkoXeaFPK2ERjCiK6dvOGeLwY5hXu-itTpueqdpeM2GTPS6Eu_JAtYe-wyztnS14BbCZrUCXJCOyuP4Kp78Hw0LfsiXwRb0OsHmefK7BrWJCptPTShVSu2UP0wPL5wBR0MEJIdp7fMcyqSVxmzYeaVxw_prTy655CmhanciawRgqx4ccTIRsfKR_s3SiatsPUeWqGfW2NsVgpzVRGUuOgBOOav6Bk7etb3U3wxAURyAW-9RZV6fsOpShbA';
