diff -pruN 0.69-2/Build.PL 0.70-1/Build.PL
--- 0.69-2/Build.PL	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/Build.PL	2024-12-20 18:00:04.000000000 +0000
@@ -28,7 +28,7 @@ my $build = Module::Build->new(
       'Future' => '0.50',
       'perl' => '5.016', # PL_keyword_plugin, pad_new(), CvDYNFILE, many tests fail on 5.14
       'XS::Parse::Keyword' => '0.13',
-      'XS::Parse::Sublike' => '0.24',
+      'XS::Parse::Sublike' => '0.31',
    },
    test_requires => {
       'Test::Future::Deferred' => 0,
@@ -37,7 +37,7 @@ my $build = Module::Build->new(
    configure_requires => {
       'Module::Build' => '0.4004', # test_requires
       'XS::Parse::Keyword::Builder' => '0.13',
-      'XS::Parse::Sublike::Builder' => '0.24',
+      'XS::Parse::Sublike::Builder' => '0.31',
    },
    share_dir => {
       module => { 'Future::AsyncAwait' => [ 'share' ] },
diff -pruN 0.69-2/Changes 0.70-1/Changes
--- 0.69-2/Changes	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/Changes	2024-12-20 18:00:04.000000000 +0000
@@ -1,5 +1,11 @@
 Revision history for Future-AsyncAwait
 
+0.70    2024-12-20
+        [CHANGES]
+         * Allow `async sub` declarations that put named functions into other
+           packages
+         * Update to latest copies of shared t/80*.t cross-module test files
+
 0.69    2024-09-18
         [CHANGES]
          * Support asynchonous lexical subs declared with `my async sub`
diff -pruN 0.69-2/MANIFEST 0.70-1/MANIFEST
--- 0.69-2/MANIFEST	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/MANIFEST	2024-12-20 18:00:04.000000000 +0000
@@ -66,6 +66,7 @@ t/80await+defer.t
 t/80await+dynamically.t
 t/80await+matchcase.t
 t/80await+SKT.t
+t/80extended+async.t
 t/81async-method+dynamically.t
 t/81memory-growth.t
 t/82devel-mat-dumper-helper.t
diff -pruN 0.69-2/META.json 0.70-1/META.json
--- 0.69-2/META.json	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/META.json	2024-12-20 18:00:04.000000000 +0000
@@ -23,7 +23,7 @@
          "requires" : {
             "Module::Build" : "0.4004",
             "XS::Parse::Keyword::Builder" : "0.13",
-            "XS::Parse::Sublike::Builder" : "0.24"
+            "XS::Parse::Sublike::Builder" : "0.31"
          }
       },
       "runtime" : {
@@ -31,7 +31,7 @@
             "File::ShareDir" : "1.00",
             "Future" : "0.50",
             "XS::Parse::Keyword" : "0.13",
-            "XS::Parse::Sublike" : "0.24",
+            "XS::Parse::Sublike" : "0.31",
             "perl" : "5.016"
          }
       },
@@ -45,19 +45,19 @@
    "provides" : {
       "Future::AsyncAwait" : {
          "file" : "lib/Future/AsyncAwait.pm",
-         "version" : "0.69"
+         "version" : "0.70"
       },
       "Future::AsyncAwait::Awaitable" : {
          "file" : "lib/Future/AsyncAwait/Awaitable.pm",
-         "version" : "0.69"
+         "version" : "0.70"
       },
       "Future::AsyncAwait::ExtensionBuilder" : {
          "file" : "lib/Future/AsyncAwait/ExtensionBuilder.pm",
-         "version" : "0.69"
+         "version" : "0.70"
       },
       "Test::Future::AsyncAwait::Awaitable" : {
          "file" : "lib/Test/Future/AsyncAwait/Awaitable.pm",
-         "version" : "0.69"
+         "version" : "0.70"
       }
    },
    "release_status" : "stable",
@@ -67,6 +67,6 @@
       ],
       "x_IRC" : "irc://irc.perl.org/#io-async"
    },
-   "version" : "0.69",
+   "version" : "0.70",
    "x_serialization_backend" : "JSON::PP version 4.16"
 }
diff -pruN 0.69-2/META.yml 0.70-1/META.yml
--- 0.69-2/META.yml	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/META.yml	2024-12-20 18:00:04.000000000 +0000
@@ -9,7 +9,7 @@ build_requires:
 configure_requires:
   Module::Build: '0.4004'
   XS::Parse::Keyword::Builder: '0.13'
-  XS::Parse::Sublike::Builder: '0.24'
+  XS::Parse::Sublike::Builder: '0.31'
 dynamic_config: 1
 generated_by: 'Module::Build version 0.4234, CPAN::Meta::Converter version 2.150010'
 license: perl
@@ -20,24 +20,24 @@ name: Future-AsyncAwait
 provides:
   Future::AsyncAwait:
     file: lib/Future/AsyncAwait.pm
-    version: '0.69'
+    version: '0.70'
   Future::AsyncAwait::Awaitable:
     file: lib/Future/AsyncAwait/Awaitable.pm
-    version: '0.69'
+    version: '0.70'
   Future::AsyncAwait::ExtensionBuilder:
     file: lib/Future/AsyncAwait/ExtensionBuilder.pm
-    version: '0.69'
+    version: '0.70'
   Test::Future::AsyncAwait::Awaitable:
     file: lib/Test/Future/AsyncAwait/Awaitable.pm
-    version: '0.69'
+    version: '0.70'
 requires:
   File::ShareDir: '1.00'
   Future: '0.50'
   XS::Parse::Keyword: '0.13'
-  XS::Parse::Sublike: '0.24'
+  XS::Parse::Sublike: '0.31'
   perl: '5.016'
 resources:
   IRC: irc://irc.perl.org/#io-async
   license: http://dev.perl.org/licenses/
-version: '0.69'
+version: '0.70'
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
diff -pruN 0.69-2/README 0.70-1/README
--- 0.69-2/README	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/README	2024-12-20 18:00:04.000000000 +0000
@@ -90,6 +90,11 @@ DESCRIPTION
     
        my $f = lexfunc(@args);
 
+    Since version 0.70 this module supports using the async keyword to
+    declare named subs in other packages.
+
+       async sub Some::Other::Package::myfunc { ... }
+
  await
 
     The await keyword forms an expression which takes a Future instance as
diff -pruN 0.69-2/debian/changelog 0.70-1/debian/changelog
--- 0.69-2/debian/changelog	2024-09-22 16:08:28.000000000 +0000
+++ 0.70-1/debian/changelog	2025-01-06 02:45:38.000000000 +0000
@@ -1,3 +1,11 @@
+libfuture-asyncawait-perl (0.70-1) unstable; urgency=medium
+
+  * Import upstream version 0.70.
+  * Bump versioned (build) dpendency on libxs-parse-sublike-perl.
+  * Update years of packaging copyright.
+
+ -- gregor herrmann <gregoa@debian.org>  Mon, 06 Jan 2025 03:45:38 +0100
+
 libfuture-asyncawait-perl (0.69-2) unstable; urgency=medium
 
   * Bump versioned build and runtime dependency on
diff -pruN 0.69-2/debian/control 0.70-1/debian/control
--- 0.69-2/debian/control	2024-09-22 16:08:28.000000000 +0000
+++ 0.70-1/debian/control	2025-01-06 02:45:38.000000000 +0000
@@ -22,7 +22,7 @@ Build-Depends: debhelper-compat (= 13),
                librole-tiny-perl <!nocheck>,
                libtest2-suite-perl (>= 0.000148) <!nocheck>,
                libxs-parse-keyword-perl,
-               libxs-parse-sublike-perl (>= 0.24),
+               libxs-parse-sublike-perl (>= 0.31),
                perl-xs-dev,
                perl:native
 Standards-Version: 4.7.0
@@ -40,7 +40,7 @@ Depends: ${misc:Depends},
          libfuture-perl (>= 0.50),
          libtest2-suite-perl (>= 0.000148),
          libxs-parse-keyword-perl,
-         libxs-parse-sublike-perl (>= 0.24)
+         libxs-parse-sublike-perl (>= 0.31)
 Description: deferred subroutine syntax for futures
  Future::AsyncAwait provides syntax for deferring and resuming subroutines
  while waiting for Futures to complete. This syntax aims to make code that
diff -pruN 0.69-2/debian/copyright 0.70-1/debian/copyright
--- 0.69-2/debian/copyright	2024-09-22 16:08:28.000000000 +0000
+++ 0.70-1/debian/copyright	2025-01-06 02:45:38.000000000 +0000
@@ -15,7 +15,7 @@ Comment: from hax/README:
  MAUKE/Function-Parameters
 
 Files: debian/*
-Copyright: 2018-2024, gregor herrmann <gregoa@debian.org>
+Copyright: 2018-2025, gregor herrmann <gregoa@debian.org>
 License: Artistic or GPL-1+
 
 License: Artistic
diff -pruN 0.69-2/lib/Future/AsyncAwait/Awaitable.pm 0.70-1/lib/Future/AsyncAwait/Awaitable.pm
--- 0.69-2/lib/Future/AsyncAwait/Awaitable.pm	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/lib/Future/AsyncAwait/Awaitable.pm	2024-12-20 18:00:05.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2019-2024 -- leonerd@leonerd.org.uk
 
-package Future::AsyncAwait::Awaitable 0.69;
+package Future::AsyncAwait::Awaitable 0.70;
 
 use v5.14;
 use warnings;
diff -pruN 0.69-2/lib/Future/AsyncAwait/ExtensionBuilder.pm 0.70-1/lib/Future/AsyncAwait/ExtensionBuilder.pm
--- 0.69-2/lib/Future/AsyncAwait/ExtensionBuilder.pm	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/lib/Future/AsyncAwait/ExtensionBuilder.pm	2024-12-20 18:00:05.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2022-2024 -- leonerd@leonerd.org.uk
 
-package Future::AsyncAwait::ExtensionBuilder 0.69;
+package Future::AsyncAwait::ExtensionBuilder 0.70;
 
 use v5.14;
 use warnings;
diff -pruN 0.69-2/lib/Future/AsyncAwait.pm 0.70-1/lib/Future/AsyncAwait.pm
--- 0.69-2/lib/Future/AsyncAwait.pm	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/lib/Future/AsyncAwait.pm	2024-12-20 18:00:05.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2016-2024 -- leonerd@leonerd.org.uk
 
-package Future::AsyncAwait 0.69;
+package Future::AsyncAwait 0.70;
 
 use v5.14;
 use warnings;
@@ -106,6 +106,11 @@ Note that the C<my> keyword has to come
 
    my $f = lexfunc(@args);
 
+I<Since version 0.70> this module supports using the C<async> keyword to
+declare named subs in other packages.
+
+   async sub Some::Other::Package::myfunc { ... }
+
 =head2 C<await>
 
 The C<await> keyword forms an expression which takes a C<Future> instance as
diff -pruN 0.69-2/lib/Future/AsyncAwait.xs 0.70-1/lib/Future/AsyncAwait.xs
--- 0.69-2/lib/Future/AsyncAwait.xs	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/lib/Future/AsyncAwait.xs	2024-12-20 18:00:05.000000000 +0000
@@ -2361,7 +2361,7 @@ static void parse_post_newcv(pTHX_ struc
 static struct XSParseSublikeHooks hooks_async = {
   .ver            = XSPARSESUBLIKE_ABI_VERSION,
   .permit_hintkey = "Future::AsyncAwait/async",
-  .flags = XS_PARSE_SUBLIKE_FLAG_PREFIX|XS_PARSE_SUBLIKE_FLAG_BODY_OPTIONAL,
+  .flags = XS_PARSE_SUBLIKE_FLAG_PREFIX|XS_PARSE_SUBLIKE_FLAG_BODY_OPTIONAL|XS_PARSE_SUBLIKE_FLAG_ALLOW_PKGNAME,
 
   .post_blockstart = parse_post_blockstart,
   .pre_blockend    = parse_pre_blockend,
@@ -2505,7 +2505,7 @@ BOOT:
   Perl_custom_op_register(aTHX_ &pp_pushcancel, &xop_pushcancel);
 
   boot_xs_parse_keyword(0.13);
-  boot_xs_parse_sublike(0.24);
+  boot_xs_parse_sublike(0.31);
 
   register_xs_parse_sublike("async", &hooks_async, NULL);
 
diff -pruN 0.69-2/lib/Test/Future/AsyncAwait/Awaitable.pm 0.70-1/lib/Test/Future/AsyncAwait/Awaitable.pm
--- 0.69-2/lib/Test/Future/AsyncAwait/Awaitable.pm	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/lib/Test/Future/AsyncAwait/Awaitable.pm	2024-12-20 18:00:05.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2020-2024 -- leonerd@leonerd.org.uk
 
-package Test::Future::AsyncAwait::Awaitable 0.69;
+package Test::Future::AsyncAwait::Awaitable 0.70;
 
 use v5.14;
 use warnings;
diff -pruN 0.69-2/t/01async-immediate.t 0.70-1/t/01async-immediate.t
--- 0.69-2/t/01async-immediate.t	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/t/01async-immediate.t	2024-12-20 18:00:05.000000000 +0000
@@ -81,6 +81,17 @@ use Future::AsyncAwait;
    isa_ok( shift @ret, [ "Future" ], 'Single result was a Future' );
 }
 
+# async sub can be declared in another package
+{
+   async sub Some::Other::Package::asub { return 123; }
+
+   ok( defined Some::Other::Package->can( "asub" ),
+      'async sub can be declared in another package' );
+
+   is( Some::Other::Package::asub->get, 123,
+      'async sub in another package runs OK' );
+}
+
 # unimport
 {
    no Future::AsyncAwait;
diff -pruN 0.69-2/t/80async-method.t 0.70-1/t/80async-method.t
--- 0.69-2/t/80async-method.t	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/t/80async-method.t	2024-12-20 18:00:05.000000000 +0000
@@ -1,35 +1,26 @@
 #!/usr/bin/perl
 
-use v5.14;
+use v5.18;
 use warnings;
 
 use Test2::V0 0.000148; # is_refcount
 
-BEGIN {
-   plan skip_all => "Future >= 0.49 is not available"
-      unless eval { require Future;
-                    Future->VERSION( '0.49' ) };
-   plan skip_all => "Future::AsyncAwait >= 0.45 is not available"
-      unless eval { require Future::AsyncAwait;
-                    Future::AsyncAwait->VERSION( '0.45' ) };
-   plan skip_all => "Object::Pad >= 0.800 is not available"
-      unless eval { require Object::Pad;
-                    Object::Pad->VERSION( '0.800' ) };
+use Test2::Require::Module 'Future' => '0.49';
+use Test2::Require::Module 'Future::AsyncAwait' => '0.45';
+use Test2::Require::Module 'Object::Pad' => '0.800';
 
+BEGIN {
    # If Future::XS is installed, then check it's at least 0.08; earlier
    # versions will crash
    if( eval { require Future::XS } ) {
       plan skip_all => "Future::XS is installed but it is older than 0.08"
          unless eval { Future::AsyncAwait->VERSION( '0.08' ); };
    }
-
-   Future::AsyncAwait->import;
-   Object::Pad->import;
-
-   diag( "Future::AsyncAwait $Future::AsyncAwait::VERSION, " .
-         "Object::Pad $Object::Pad::VERSION" );
 }
 
+use Future::AsyncAwait;
+use Object::Pad;
+
 # async method
 {
    class Thunker {
@@ -80,7 +71,7 @@ BEGIN {
    my $waitf;
 
    role Role { async method m { await $waitf = Future->new } }
-   class Class :does(Role) {}
+   class Class { apply Role; }
 
    my $obj = Class->new;
 
diff -pruN 0.69-2/t/80extended+async.t 0.70-1/t/80extended+async.t
--- 0.69-2/t/80extended+async.t	1970-01-01 00:00:00.000000000 +0000
+++ 0.70-1/t/80extended+async.t	2024-12-20 18:00:05.000000000 +0000
@@ -0,0 +1,36 @@
+#!/usr/bin/perl
+
+use v5.14;
+use warnings;
+
+use Test2::V0;
+BEGIN { $] >= 5.026000 or plan skip_all => "No parse_subsignature()"; }
+
+use Test2::Require::Module 'Future::AsyncAwait' => '0.66';
+use Test2::Require::Module 'Sublike::Extended' => '0.29';
+
+use feature 'signatures';
+no warnings 'experimental';
+
+use Future::AsyncAwait;
+use Sublike::Extended;
+
+# async extended sub
+{
+   async extended sub f1 (:$x, :$y) { return "x=$x y=$y" }
+
+   is( await f1( x => "first", y => "second" ), "x=first y=second",
+      'async extended sub' );
+}
+
+# async sub + S:E 0.29
+{
+   use Sublike::Extended 'sub';
+
+   async sub f2 (:$x, :$y) { return "x=$x y=$y" }
+
+   is( await f2( x => "third", y => "fourth" ), "x=third y=fourth",
+      'async sub with extended keyword' );
+}
+
+done_testing;
diff -pruN 0.69-2/t/81async-method+dynamically.t 0.70-1/t/81async-method+dynamically.t
--- 0.69-2/t/81async-method+dynamically.t	2024-09-18 15:46:59.000000000 +0000
+++ 0.70-1/t/81async-method+dynamically.t	2024-12-20 18:00:05.000000000 +0000
@@ -1,31 +1,18 @@
 #!/usr/bin/perl
 
-use v5.14;
+use v5.18;
 use warnings;
 
 use Test2::V0;
 
-BEGIN {
-   plan skip_all => "Future is not available"
-      unless eval { require Future };
-   plan skip_all => "Future::AsyncAwait >= 0.40 is not available"
-      unless eval { require Future::AsyncAwait;
-                    Future::AsyncAwait->VERSION( '0.40' ) };
-   plan skip_all => "Object::Pad >= 0.800 is not available"
-      unless eval { require Object::Pad;
-                    Object::Pad->VERSION( '0.800' ) };
-   plan skip_all => "Syntax::Keyword::Dynamically >= 0.04 is not available"
-      unless eval { require Syntax::Keyword::Dynamically;
-                    Syntax::Keyword::Dynamically->VERSION( '0.04' ) };
-
-   Future::AsyncAwait->import;
-   Object::Pad->import;
-   Syntax::Keyword::Dynamically->import;
-
-   diag( "Future::AsyncAwait $Future::AsyncAwait::VERSION, " .
-         "Object::Pad $Object::Pad::VERSION, " .
-         "Syntax::Keyword::Dynamically $Syntax::Keyword::Dynamically::VERSION" );
-}
+use Test2::Require::Module 'Future' => '0.49';
+use Test2::Require::Module 'Future::AsyncAwait' => '0.40';
+use Test2::Require::Module 'Object::Pad' => '0.800';
+use Test2::Require::Module 'Syntax::Keyword::Dynamically';
+
+use Future::AsyncAwait;
+use Object::Pad;
+use Syntax::Keyword::Dynamically;
 
 # dynamically inside an async method
 {
