diff -pruN 0.022-1/Changes 0.026-1/Changes
--- 0.022-1/Changes	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/Changes	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,21 @@
 Revision history for ExtUtils-Builder-Compiler
 
+0.026     2025-03-28 12:37:34+01:00 Europe/Brussels
+          - Add definition file to MSVC linker arguments
+
+0.025     2025-03-16 23:03:34+01:00 Europe/Brussels
+          - Add missing abs2rel import for module_for_xs delegate
+
+0.024     2025-03-14 16:57:33+01:00 Europe/Brussels
+          - Pass module name to prelink for loadable object
+
+0.023     2025-03-13 16:34:20+01:00 Europe/Brussels
+          - Restore module_for_xs delegate
+          - Make module work on static perls
+          - Allow for multiple profiles in compilation
+          - Fix libpath argument in MSVC linker
+          - Ignore manifest files on MSVC for now
+
 0.022     2024-09-13 14:11:23+02:00 Europe/Brussels
           - Fix quiet argument of try_compile_run
 
diff -pruN 0.022-1/META.json 0.026-1/META.json
--- 0.022-1/META.json	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/META.json	2025-03-28 11:37:38.000000000 +0000
@@ -29,11 +29,12 @@
          "requires" : {
             "Carp" : "0",
             "DynaLoader" : "0",
+            "ExtUtils::Builder" : "0.013",
             "ExtUtils::Builder::Action::Command" : "0",
-            "ExtUtils::Builder::Action::Function" : "0",
             "ExtUtils::Builder::Node" : "0",
-            "ExtUtils::Builder::Planner" : "0.009",
+            "ExtUtils::Builder::Planner" : "0.007",
             "ExtUtils::Builder::Planner::Extension" : "0",
+            "ExtUtils::Builder::Util" : "0",
             "ExtUtils::Config" : "0.007",
             "ExtUtils::Helpers" : "0.027",
             "File::Basename" : "0",
@@ -41,7 +42,7 @@
             "File::Temp" : "0",
             "Perl::OSType" : "0",
             "parent" : "0",
-            "perl" : "5.006",
+            "perl" : "5.010",
             "sort" : "0",
             "strict" : "0",
             "warnings" : "0"
@@ -49,7 +50,7 @@
       },
       "test" : {
          "requires" : {
-            "ExtUtils::Builder::Planner" : "0.009",
+            "ExtUtils::Builder::Planner" : "0.007",
             "IPC::Open2" : "0",
             "Test::More" : "0.89"
          }
@@ -58,91 +59,91 @@
    "provides" : {
       "ExtUtils::Builder::ArgumentCollector" : {
          "file" : "lib/ExtUtils/Builder/ArgumentCollector.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::AutoDetect::C" : {
          "file" : "lib/ExtUtils/Builder/AutoDetect/C.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::AutoDetect::Cpp" : {
          "file" : "lib/ExtUtils/Builder/AutoDetect/Cpp.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Binary" : {
          "file" : "lib/ExtUtils/Builder/Binary.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Compiler" : {
          "file" : "lib/ExtUtils/Builder/Compiler.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Compiler::MSVC" : {
          "file" : "lib/ExtUtils/Builder/Compiler/MSVC.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Compiler::Unixy" : {
          "file" : "lib/ExtUtils/Builder/Compiler/Unixy.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Compiler::VMS" : {
          "file" : "lib/ExtUtils/Builder/Compiler/VMS.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Conf" : {
          "file" : "lib/ExtUtils/Builder/Conf.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Linker" : {
          "file" : "lib/ExtUtils/Builder/Linker.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Linker::Ar" : {
          "file" : "lib/ExtUtils/Builder/Linker/Ar.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Linker::COFF" : {
          "file" : "lib/ExtUtils/Builder/Linker/COFF.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Linker::ELF::Any" : {
          "file" : "lib/ExtUtils/Builder/Linker/ELF/Any.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Linker::ELF::GCC" : {
          "file" : "lib/ExtUtils/Builder/Linker/ELF/GCC.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Linker::Mach::GCC" : {
          "file" : "lib/ExtUtils/Builder/Linker/Mach/GCC.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Linker::PE::GCC" : {
          "file" : "lib/ExtUtils/Builder/Linker/PE/GCC.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Linker::PE::MSVC" : {
          "file" : "lib/ExtUtils/Builder/Linker/PE/MSVC.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Linker::Unixy" : {
          "file" : "lib/ExtUtils/Builder/Linker/Unixy.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Linker::XCOFF" : {
          "file" : "lib/ExtUtils/Builder/Linker/XCOFF.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::MultiLingual" : {
          "file" : "lib/ExtUtils/Builder/MultiLingual.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::ParseXS" : {
          "file" : "lib/ExtUtils/Builder/ParseXS.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       },
       "ExtUtils::Builder::Profile::Perl" : {
          "file" : "lib/ExtUtils/Builder/Profile/Perl.pm",
-         "version" : "0.022"
+         "version" : "0.026"
       }
    },
    "release_status" : "stable",
@@ -156,9 +157,9 @@
          "web" : "https://github.com/Leont/extutils-builder-compiler"
       }
    },
-   "version" : "0.022",
-   "x_generated_by_perl" : "v5.38.0",
-   "x_serialization_backend" : "Cpanel::JSON::XS version 4.36",
+   "version" : "0.026",
+   "x_generated_by_perl" : "v5.40.0",
+   "x_serialization_backend" : "Cpanel::JSON::XS version 4.39",
    "x_spdx_expression" : "Artistic-1.0-Perl OR GPL-1.0-or-later"
 }
 
diff -pruN 0.022-1/META.yml 0.026-1/META.yml
--- 0.022-1/META.yml	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/META.yml	2025-03-28 11:37:38.000000000 +0000
@@ -3,7 +3,7 @@ abstract: 'An interface around different
 author:
   - 'Leon Timmermans <fawaka@gmail.com>'
 build_requires:
-  ExtUtils::Builder::Planner: '0.009'
+  ExtUtils::Builder::Planner: '0.007'
   IPC::Open2: '0'
   Test::More: '0.89'
 configure_requires:
@@ -18,78 +18,79 @@ name: ExtUtils-Builder-Compiler
 provides:
   ExtUtils::Builder::ArgumentCollector:
     file: lib/ExtUtils/Builder/ArgumentCollector.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::AutoDetect::C:
     file: lib/ExtUtils/Builder/AutoDetect/C.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::AutoDetect::Cpp:
     file: lib/ExtUtils/Builder/AutoDetect/Cpp.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Binary:
     file: lib/ExtUtils/Builder/Binary.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Compiler:
     file: lib/ExtUtils/Builder/Compiler.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Compiler::MSVC:
     file: lib/ExtUtils/Builder/Compiler/MSVC.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Compiler::Unixy:
     file: lib/ExtUtils/Builder/Compiler/Unixy.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Compiler::VMS:
     file: lib/ExtUtils/Builder/Compiler/VMS.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Conf:
     file: lib/ExtUtils/Builder/Conf.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Linker:
     file: lib/ExtUtils/Builder/Linker.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Linker::Ar:
     file: lib/ExtUtils/Builder/Linker/Ar.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Linker::COFF:
     file: lib/ExtUtils/Builder/Linker/COFF.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Linker::ELF::Any:
     file: lib/ExtUtils/Builder/Linker/ELF/Any.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Linker::ELF::GCC:
     file: lib/ExtUtils/Builder/Linker/ELF/GCC.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Linker::Mach::GCC:
     file: lib/ExtUtils/Builder/Linker/Mach/GCC.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Linker::PE::GCC:
     file: lib/ExtUtils/Builder/Linker/PE/GCC.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Linker::PE::MSVC:
     file: lib/ExtUtils/Builder/Linker/PE/MSVC.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Linker::Unixy:
     file: lib/ExtUtils/Builder/Linker/Unixy.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Linker::XCOFF:
     file: lib/ExtUtils/Builder/Linker/XCOFF.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::MultiLingual:
     file: lib/ExtUtils/Builder/MultiLingual.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::ParseXS:
     file: lib/ExtUtils/Builder/ParseXS.pm
-    version: '0.022'
+    version: '0.026'
   ExtUtils::Builder::Profile::Perl:
     file: lib/ExtUtils/Builder/Profile/Perl.pm
-    version: '0.022'
+    version: '0.026'
 requires:
   Carp: '0'
   DynaLoader: '0'
+  ExtUtils::Builder: '0.013'
   ExtUtils::Builder::Action::Command: '0'
-  ExtUtils::Builder::Action::Function: '0'
   ExtUtils::Builder::Node: '0'
-  ExtUtils::Builder::Planner: '0.009'
+  ExtUtils::Builder::Planner: '0.007'
   ExtUtils::Builder::Planner::Extension: '0'
+  ExtUtils::Builder::Util: '0'
   ExtUtils::Config: '0.007'
   ExtUtils::Helpers: '0.027'
   File::Basename: '0'
@@ -97,14 +98,14 @@ requires:
   File::Temp: '0'
   Perl::OSType: '0'
   parent: '0'
-  perl: '5.006'
+  perl: '5.010'
   sort: '0'
   strict: '0'
   warnings: '0'
 resources:
   bugtracker: https://github.com/Leont/extutils-builder-compiler/issues
   repository: git://github.com/Leont/extutils-builder-compiler.git
-version: '0.022'
-x_generated_by_perl: v5.38.0
-x_serialization_backend: 'YAML::Tiny version 1.74'
+version: '0.026'
+x_generated_by_perl: v5.40.0
+x_serialization_backend: 'YAML::Tiny version 1.76'
 x_spdx_expression: 'Artistic-1.0-Perl OR GPL-1.0-or-later'
diff -pruN 0.022-1/Makefile.PL 0.026-1/Makefile.PL
--- 0.022-1/Makefile.PL	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/Makefile.PL	2025-03-28 11:37:38.000000000 +0000
@@ -2,7 +2,7 @@
 use strict;
 use warnings;
 
-use 5.006;
+use 5.010;
 
 use ExtUtils::MakeMaker;
 
@@ -14,16 +14,17 @@ my %WriteMakefileArgs = (
   },
   "DISTNAME" => "ExtUtils-Builder-Compiler",
   "LICENSE" => "perl",
-  "MIN_PERL_VERSION" => "5.006",
+  "MIN_PERL_VERSION" => "5.010",
   "NAME" => "ExtUtils::Builder::Compiler",
   "PREREQ_PM" => {
     "Carp" => 0,
     "DynaLoader" => 0,
+    "ExtUtils::Builder" => "0.013",
     "ExtUtils::Builder::Action::Command" => 0,
-    "ExtUtils::Builder::Action::Function" => 0,
     "ExtUtils::Builder::Node" => 0,
-    "ExtUtils::Builder::Planner" => "0.009",
+    "ExtUtils::Builder::Planner" => "0.007",
     "ExtUtils::Builder::Planner::Extension" => 0,
+    "ExtUtils::Builder::Util" => 0,
     "ExtUtils::Config" => "0.007",
     "ExtUtils::Helpers" => "0.027",
     "File::Basename" => 0,
@@ -36,11 +37,11 @@ my %WriteMakefileArgs = (
     "warnings" => 0
   },
   "TEST_REQUIRES" => {
-    "ExtUtils::Builder::Planner" => "0.009",
+    "ExtUtils::Builder::Planner" => "0.007",
     "IPC::Open2" => 0,
     "Test::More" => "0.89"
   },
-  "VERSION" => "0.022",
+  "VERSION" => "0.026",
   "test" => {
     "TESTS" => "t/*.t"
   }
@@ -50,11 +51,12 @@ my %WriteMakefileArgs = (
 my %FallbackPrereqs = (
   "Carp" => 0,
   "DynaLoader" => 0,
+  "ExtUtils::Builder" => "0.013",
   "ExtUtils::Builder::Action::Command" => 0,
-  "ExtUtils::Builder::Action::Function" => 0,
   "ExtUtils::Builder::Node" => 0,
-  "ExtUtils::Builder::Planner" => "0.009",
+  "ExtUtils::Builder::Planner" => "0.007",
   "ExtUtils::Builder::Planner::Extension" => 0,
+  "ExtUtils::Builder::Util" => 0,
   "ExtUtils::Config" => "0.007",
   "ExtUtils::Helpers" => "0.027",
   "File::Basename" => 0,
diff -pruN 0.022-1/README 0.026-1/README
--- 0.022-1/README	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/README	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 This archive contains the distribution ExtUtils-Builder-Compiler,
-version 0.022:
+version 0.026:
 
   An interface around different compilers.
 
diff -pruN 0.022-1/debian/changelog 0.026-1/debian/changelog
--- 0.022-1/debian/changelog	2024-09-16 17:09:00.000000000 +0000
+++ 0.026-1/debian/changelog	2025-03-29 21:30:48.000000000 +0000
@@ -1,3 +1,12 @@
+libextutils-builder-compiler-perl (0.026-1) unstable; urgency=medium
+
+  * Import upstream version 0.026.
+  * Update years of packaging copyright.
+  * Declare compliance with Debian Policy 4.7.2.
+  * Drop unneeded version constraints from (build) dependencies.
+
+ -- gregor herrmann <gregoa@debian.org>  Sat, 29 Mar 2025 22:30:48 +0100
+
 libextutils-builder-compiler-perl (0.022-1) unstable; urgency=medium
 
   * Import upstream version 0.022.
diff -pruN 0.022-1/debian/control 0.026-1/debian/control
--- 0.022-1/debian/control	2024-09-16 17:09:00.000000000 +0000
+++ 0.026-1/debian/control	2025-03-29 21:30:48.000000000 +0000
@@ -5,12 +5,12 @@ Section: perl
 Testsuite: autopkgtest-pkg-perl
 Priority: optional
 Build-Depends: debhelper-compat (= 13)
-Build-Depends-Indep: libextutils-builder-perl (>= 0.009) <!nocheck>,
+Build-Depends-Indep: libextutils-builder-perl <!nocheck>,
                      libextutils-config-perl <!nocheck>,
                      libextutils-helpers-perl (>= 0.027) <!nocheck>,
                      libtest-simple-perl <!nocheck>,
                      perl
-Standards-Version: 4.7.0
+Standards-Version: 4.7.2
 Vcs-Browser: https://salsa.debian.org/perl-team/modules/packages/libextutils-builder-compiler-perl
 Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libextutils-builder-compiler-perl.git
 Homepage: https://metacpan.org/release/ExtUtils-Builder-Compiler
@@ -20,7 +20,7 @@ Package: libextutils-builder-compiler-pe
 Architecture: all
 Depends: ${misc:Depends},
          ${perl:Depends},
-         libextutils-builder-perl (>= 0.009),
+         libextutils-builder-perl,
          libextutils-config-perl,
          libextutils-helpers-perl (>= 0.027)
 Description: interface around different compilers for ExtUtils:Builder
diff -pruN 0.022-1/debian/copyright 0.026-1/debian/copyright
--- 0.022-1/debian/copyright	2024-09-16 17:09:00.000000000 +0000
+++ 0.026-1/debian/copyright	2025-03-29 21:30:48.000000000 +0000
@@ -8,7 +8,7 @@ Copyright: 2012, Leon Timmermans <fawaka
 License: Artistic or GPL-1+
 
 Files: debian/*
-Copyright: 2024, gregor herrmann <gregoa@debian.org>
+Copyright: 2024-2025, gregor herrmann <gregoa@debian.org>
 License: Artistic or GPL-1+
 
 License: Artistic
diff -pruN 0.022-1/dist.ini 0.026-1/dist.ini
--- 0.022-1/dist.ini	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/dist.ini	2025-03-28 11:37:38.000000000 +0000
@@ -5,7 +5,7 @@ copyright_holder = Leon Timmermans
 copyright_year   = 2012
 
 [Prereqs]
-perl = 5.006
+perl = 5.010
 
 [Git::GatherDir]
 [PruneCruft]
@@ -23,11 +23,17 @@ perl = 5.006
 
 [MakeMaker]
 
+[FileFinder::Filter / WeaverFiles]
+finder = :InstallModules
+skip  = Linker/
+skip = MultiLingual
+
 [PodSyntaxTests]
 ; [PodCoverageTests]
 
 [InstallGuide]
 [PodWeaver]
+finder = WeaverFiles
 [PkgVersion]
 [NextRelease]
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/ArgumentCollector.pm 0.026-1/lib/ExtUtils/Builder/ArgumentCollector.pm
--- 0.022-1/lib/ExtUtils/Builder/ArgumentCollector.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/ArgumentCollector.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,11 +1,11 @@
 package ExtUtils::Builder::ArgumentCollector;
-$ExtUtils::Builder::ArgumentCollector::VERSION = '0.022';
+$ExtUtils::Builder::ArgumentCollector::VERSION = '0.026';
 use strict;
 use warnings;
 
 sub _init {
 	my ($self, %args) = @_;
-	$self->{arguments} = $args{arguments} || [];
+	$self->{arguments} = $args{arguments} // [];
 	return;
 }
 
@@ -18,7 +18,7 @@ sub add_argument {
 
 sub new_argument {
 	my ($self, %args) = @_;
-	return [ $args{ranking} || 50, $args{value} ];
+	return [ $args{ranking} // 50, $args{value} ];
 }
 
 sub collect_arguments {
@@ -50,7 +50,7 @@ ExtUtils::Builder::ArgumentCollector - H
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 DESCRIPTION
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/AutoDetect/C.pm 0.026-1/lib/ExtUtils/Builder/AutoDetect/C.pm
--- 0.022-1/lib/ExtUtils/Builder/AutoDetect/C.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/AutoDetect/C.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::AutoDetect::C;
-$ExtUtils::Builder::AutoDetect::C::VERSION = '0.022';
+$ExtUtils::Builder::AutoDetect::C::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -53,16 +53,23 @@ sub require_module {
 
 sub add_compiler {
 	my ($self, $planner, %opts) = @_;
-	my $as = $opts{as} || 'compile';
+	my $as = $opts{as} // 'compile';
 	return $planner->add_delegate($as, sub {
 		my ($planner, $from, $to, %extra) = @_;
 		my %args = (%opts, %extra);
 		my $compiler = $self->_make_command($self->_get_compiler(\%args));
-		if (my $profile = $args{profile}) {
-			$profile =~ s/ \A @ /ExtUtils::Builder::Profile::/xms;
-			require_module($profile);
-			$profile->process_compiler($compiler, \%args);
+
+		$args{profiles} = [ delete $args{profile} ] if $args{profile} and not $args{profiles};
+		if (my $profiles = $args{profiles}) {
+			for my $profile (@$profiles) {
+				if (not ref($profile)) {
+					$profile =~ s/ \A @ /ExtUtils::Builder::Profile::/xms;
+					require_module($profile);
+				}
+				$profile->process_compiler($compiler, \%args);
+			}
 		}
+
 		if (my $include_dirs = $args{include_dirs}) {
 			$compiler->add_include_dirs($include_dirs);
 		}
@@ -72,6 +79,7 @@ sub add_compiler {
 		if (my $extra = $args{extra_args}) {
 			$compiler->add_argument(value => $extra);
 		}
+
 		my $node = $compiler->compile($from, $to, %args);
 		$planner->add_node($node);
 	});
@@ -95,13 +103,14 @@ sub _get_linker {
 	my %args = _filter_args($opts, qw/type export language/);
 	my $cc = $opts->{config}->get('cc');
 	my $ld = $opts->{config}->get('ld');
+	my $eff_ld = $args{type} eq 'executable' ? $cc : $ld;
 	my ($module, $link, %opts) =
 		$args{type} eq 'static-library' ? ('Ar', $opts->{config}->get('ar')) :
-		$os eq 'darwin' ? ('Mach::GCC', $ld) :
+		$os eq 'darwin' ? ('Mach::GCC', $eff_ld) :
 		_is_gcc($opts->{config}, $ld, $opts) ?
-		$os eq 'MSWin32' ? ('PE::GCC', $cc) : ('ELF::GCC', $ld) :
+		$os eq 'MSWin32' ? ('PE::GCC', $cc) : ('ELF::GCC', $eff_ld) :
 		$os eq 'aix' ? ('XCOFF', $cc) :
-		is_os_type('Unix', $os) ? ('ELF', $ld, $self->_unix_flags($opts)) :
+		is_os_type('Unix', $os) ? ('ELF', $eff_ld, $self->_unix_flags($opts)) :
 		$os eq 'MSWin32' ? ('PE::MSVC', $ld) :
 		croak 'Linking is not supported yet on your platform';
 	return ("Linker::$module", ld => $link, %opts, %args);
@@ -109,16 +118,25 @@ sub _get_linker {
 
 sub add_linker {
 	my ($self, $planner, %opts) = @_;
-	my $as = $opts{as} || 'link';
+	my $as = $opts{as} // 'link';
 	return $planner->add_delegate($as, sub {
 		my ($planner, $from, $to, %extra) = @_;
 		my %args = (%opts, %extra);
 		my $linker = $self->_make_command($self->_get_linker(\%args));
-		if (my $profile = $args{profile}) {
-			$profile =~ s/ \A @ /ExtUtils::Builder::Profile::/xms;
-			require_module($profile);
-			$profile->process_linker($linker, \%args);
+
+		$args{profiles} = [ delete $args{profile} ] if $args{profile} and not $args{profiles};
+		if (my $profiles = $args{profiles}) {
+			for my $profile (@$profiles) {
+				if (ref($profile)) {
+
+				} else {
+					$profile =~ s/ \A @ /ExtUtils::Builder::Profile::/xms;
+					require_module($profile);
+					$profile->process_linker($linker, \%args);
+				}
+			}
 		}
+
 		if (my $library_dirs = $args{library_dirs}) {
 			$linker->add_library_dirs($library_dirs);
 		}
@@ -128,6 +146,7 @@ sub add_linker {
 		if (my $extra_args = $args{extra_args}) {
 			$linker->add_argument(ranking => 85, value => [ @{$extra_args} ]);
 		}
+
 		my $node = $linker->link($from, $to, %args);
 		$planner->add_node($node);
 	});
@@ -136,8 +155,8 @@ sub add_linker {
 sub add_methods {
 	my ($class, $planner, %opts) = @_;
 
-	$opts{config} ||= $planner->can('config') ? $planner->config : ExtUtils::Config->new;
-	$opts{type} ||= 'executable';
+	$opts{config} //= $planner->can('config') ? $planner->config : ExtUtils::Config->new;
+	$opts{type} //= 'executable';
 
 	my $as_compiler = delete $opts{as_compiler};
 	$class->add_compiler($planner, %opts, as => $as_compiler);
@@ -193,14 +212,14 @@ ExtUtils::Builder::AutoDetect::C - compi
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 SYNOPSIS
 
  my $planner = ExtUtils::Builder::Planner->new;
  $planner->load_module('ExtUtils::Builder::AutoDetect::C', '0.001',
-	profile => '@Perl',
-	type    => 'loadable-object',
+	profiles => ['@Perl'],
+	type     => 'loadable-object',
  );
  $planner->compile('foo.c', 'foo.o', include_dirs => ['.']);
  $planner->link([ 'foo.o' ], 'foo.so', libraries => ['foo']);
@@ -287,9 +306,9 @@ A loadable extension. On most platforms
 
 A Perl configuration to take hints from, must be an C<ExtUtils::Config> compatible object.
 
-=item profile
+=item profiles
 
-A profile to be used when compiling and linking. One profile comes with this distribution: C<'@Perl'>, which sets up the appropriate things to compile/link with C<libperl>.
+A list of profile that can be used when compiling and linking. One profile comes with this distribution: C<'@Perl'>, which sets up the appropriate things to compile/link with C<libperl>.
 
 =item include_dirs
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/AutoDetect/Cpp.pm 0.026-1/lib/ExtUtils/Builder/AutoDetect/Cpp.pm
--- 0.022-1/lib/ExtUtils/Builder/AutoDetect/Cpp.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/AutoDetect/Cpp.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::AutoDetect::Cpp;
-$ExtUtils::Builder::AutoDetect::Cpp::VERSION = '0.022';
+$ExtUtils::Builder::AutoDetect::Cpp::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -7,14 +7,14 @@ use parent 'ExtUtils::Builder::AutoDetec
 
 sub _get_compiler {
 	my ($self, $opts) = @_;
-	my $os = $opts->{osname} || $^O;
+	my $os = $opts->{osname} // $^O;
 	my $cc = $self->_get_opt($opts, 'cc');
 	return $self->_is_gcc($cc, $opts) ? $self->SUPER::_get_compiler({ cc => 'g++', %{$opts} }) : is_os_type('Windows', $os) ? $self->SUPER::_get_compiler({ language => 'C++', %{$opts} }) : Carp::croak('Your platform is not supported yet');
 }
 
 sub _get_linker {
 	my ($self, $opts) = @_;
-	my $os = $opts->{osname} || $^O;
+	my $os = $opts->{osname} // $^O;
 	my $cc = $self->_get_opt($opts, 'cc');
 	return $self->_is_gcc($cc, $opts) ? $self->SUPER::_get_linker({ cc => 'g++', %{$opts} }) : is_os_type('Windows', $os) ? $self->SUPER::_get_linker({ language => 'C++', %{$opts} }) : Carp::croak('Your platform is not supported yet');
 	return;
@@ -34,7 +34,7 @@ ExtUtils::Builder::AutoDetect::Cpp
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 AUTHOR
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/Binary.pm 0.026-1/lib/ExtUtils/Builder/Binary.pm
--- 0.022-1/lib/ExtUtils/Builder/Binary.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Binary.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Binary;
-$ExtUtils::Builder::Binary::VERSION = '0.022';
+$ExtUtils::Builder::Binary::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -36,7 +36,7 @@ ExtUtils::Builder::Binary - Helper role
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 AUTHOR
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/Compiler/MSVC.pm 0.026-1/lib/ExtUtils/Builder/Compiler/MSVC.pm
--- 0.022-1/lib/ExtUtils/Builder/Compiler/MSVC.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Compiler/MSVC.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Compiler::MSVC;
-$ExtUtils::Builder::Compiler::MSVC::VERSION = '0.022';
+$ExtUtils::Builder::Compiler::MSVC::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -7,7 +7,7 @@ use parent qw/ExtUtils::Builder::Compile
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{cc} ||= ['cl'];
+	$args{cc} //= ['cl'];
 	$self->ExtUtils::Builder::Compiler::_init(%args);
 	$self->ExtUtils::Builder::MultiLingual::_init(%args);
 	return;
@@ -44,7 +44,7 @@ ExtUtils::Builder::Compiler::MSVC - Clas
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 AUTHOR
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/Compiler/Unixy.pm 0.026-1/lib/ExtUtils/Builder/Compiler/Unixy.pm
--- 0.022-1/lib/ExtUtils/Builder/Compiler/Unixy.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Compiler/Unixy.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Compiler::Unixy;
-$ExtUtils::Builder::Compiler::Unixy::VERSION = '0.022';
+$ExtUtils::Builder::Compiler::Unixy::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -7,10 +7,10 @@ use parent 'ExtUtils::Builder::Compiler'
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{cc} ||= ['cc'];
+	$args{cc} //= ['cc'];
 	$self->SUPER::_init(%args);
 	$self->{cccdlflags} = $args{cccdlflags};
-	$self->{pic} = $args{pic} || ($self->type eq 'shared-library' || $self->type eq 'loadable-object') && @{ $self->{cccdlflags} };
+	$self->{pic} = $args{pic} // ($self->type eq 'shared-library' || $self->type eq 'loadable-object') && @{ $self->{cccdlflags} };
 	return;
 }
 
@@ -44,7 +44,7 @@ ExtUtils::Builder::Compiler::Unixy - Cla
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 AUTHOR
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/Compiler/VMS.pm 0.026-1/lib/ExtUtils/Builder/Compiler/VMS.pm
--- 0.022-1/lib/ExtUtils/Builder/Compiler/VMS.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Compiler/VMS.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Compiler::VMS;
-$ExtUtils::Builder::Compiler::VMS::VERSION = '0.022';
+$ExtUtils::Builder::Compiler::VMS::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -9,7 +9,7 @@ use Carp ();
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{cc} ||= ['CC/DECC'];
+	$args{cc} //= ['CC/DECC'];
 	$self->SUPER::_init(%args);
 	return;
 }
@@ -63,7 +63,7 @@ ExtUtils::Builder::Compiler::VMS - Class
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 AUTHOR
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/Compiler.pm 0.026-1/lib/ExtUtils/Builder/Compiler.pm
--- 0.022-1/lib/ExtUtils/Builder/Compiler.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Compiler.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,9 +1,9 @@
 package ExtUtils::Builder::Compiler;
-$ExtUtils::Builder::Compiler::VERSION = '0.022';
+$ExtUtils::Builder::Compiler::VERSION = '0.026';
 use strict;
 use warnings;
 
-use ExtUtils::Builder::Action::Command;
+use ExtUtils::Builder::Util qw/command function/;
 use ExtUtils::Builder::Node;
 
 use parent qw/ExtUtils::Builder::ArgumentCollector ExtUtils::Builder::Binary/;
@@ -67,7 +67,7 @@ sub compile {
 	my @actions ;
 	if ($opts{mkdir}) {
 		my $dirname = File::Basename::dirname($to);
-		push @actions, ExtUtils::Builder::Action::Function->new(
+		push @actions, function(
 			module    => 'File::Path',
 			function  => 'make_path',
 			exports   => 'explicit',
@@ -76,8 +76,8 @@ sub compile {
 		);
 	}
 	my @argv = $self->arguments($from, $to, %opts);
-	push @actions, ExtUtils::Builder::Action::Command->new(command => [ $self->cc, @argv ]);
-	my $deps = [ $from, @{ $opts{dependencies} || [] } ];
+	push @actions, command($self->cc, @argv);
+	my $deps = [ $from, @{ $opts{dependencies} // [] } ];
 	return ExtUtils::Builder::Node->new(target => $to, dependencies => $deps, actions => \@actions);
 }
 
@@ -97,7 +97,7 @@ ExtUtils::Builder::Compiler - An interfa
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 DESCRIPTION
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/Conf.pm 0.026-1/lib/ExtUtils/Builder/Conf.pm
--- 0.022-1/lib/ExtUtils/Builder/Conf.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Conf.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Conf;
-$ExtUtils::Builder::Conf::VERSION = '0.022';
+$ExtUtils::Builder::Conf::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -23,7 +23,7 @@ sub add_methods {
 	for my $name (qw/include_dirs library_dirs libraries extra_compiler_flags extra_linker_flags/) {
 		$planner->add_delegate($name, sub {
 			my $self = shift;
-			return @{ $self->{$name} || [] };
+			return @{ $self->{$name} // [] };
 		});
 		$planner->add_delegate("push_$name", sub {
 			my ($self, @args) = @_;
@@ -38,7 +38,7 @@ sub add_methods {
 
 	$planner->add_delegate(defines => sub {
 		my $self = shift;
-		return %{ $self->{defines} || {} };
+		return %{ $self->{defines} // {} };
 	});
 
 	$planner->add_delegate(write_defines => sub {
@@ -74,8 +74,8 @@ sub add_methods {
 		my $inner = $self->new_planner;
 		$inner->load_module('ExtUtils::Builder::AutoDetect::C', 0.015);
 
-		my @include_dirs         = (@{ $args{include_dirs} || [] }, @{ $self->{include_dirs} || [] });
-		my @extra_compiler_flags = (@{ $args{extra_compiler_flags} || [] }, @{ $self->{extra_compiler_flags} || [] });
+		my @include_dirs         = (@{ $args{include_dirs} // [] }, @{ $self->{include_dirs} // [] });
+		my @extra_compiler_flags = (@{ $args{extra_compiler_flags} // [] }, @{ $self->{extra_compiler_flags} // [] });
 
 		my %compile_args = (
 			extra_args   => \@extra_compiler_flags,
@@ -86,9 +86,9 @@ sub add_methods {
 		my $o_file = $inner->obj_file($basename, $dir);
 		$inner->compile($c_file, $o_file, %compile_args);
 
-		my @libraries          = (@{ $args{libraries} || [] },          @{ $self->{libraries} || [] });
-		my @library_dirs       = (@{ $args{library_dirs} || [] },       @{ $self->{library_dirs} || [] });
-		my @extra_linker_flags = (@{ $args{extra_linker_flags} || [] }, @{ $self->{extra_linker_flags} || [] });
+		my @libraries          = (@{ $args{libraries} // [] },          @{ $self->{libraries} // [] });
+		my @library_dirs       = (@{ $args{library_dirs} // [] },       @{ $self->{library_dirs} // [] });
+		my @extra_linker_flags = (@{ $args{extra_linker_flags} // [] }, @{ $self->{extra_linker_flags} // [] });
 
 		my %link_args = (
 			libraries    => \@libraries,
@@ -223,7 +223,7 @@ ExtUtils::Builder::Conf - Configure-time
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 SYNOPSIS
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/Linker/Ar.pm 0.026-1/lib/ExtUtils/Builder/Linker/Ar.pm
--- 0.022-1/lib/ExtUtils/Builder/Linker/Ar.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Linker/Ar.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Linker::Ar;
-$ExtUtils::Builder::Linker::Ar::VERSION = '0.022';
+$ExtUtils::Builder::Linker::Ar::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -9,10 +9,10 @@ use parent 'ExtUtils::Builder::Linker';
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{ld} ||= ['ar'];
-	$args{export} ||= 'all';
+	$args{ld} //= ['ar'];
+	$args{export} //= 'all';
 	$self->SUPER::_init(%args);
-	$self->{static_args} = $args{static_args} || ['cr'];
+	$self->{static_args} = $args{static_args} // ['cr'];
 	return;
 }
 
@@ -32,30 +32,3 @@ sub linker_flags {
 }
 
 1;
-
-__END__
-
-=pod
-
-=encoding UTF-8
-
-=head1 NAME
-
-ExtUtils::Builder::Linker::Ar
-
-=head1 VERSION
-
-version 0.022
-
-=head1 AUTHOR
-
-Leon Timmermans <fawaka@gmail.com>
-
-=head1 COPYRIGHT AND LICENSE
-
-This software is copyright (c) 2012 by Leon Timmermans.
-
-This is free software; you can redistribute it and/or modify it under
-the same terms as the Perl 5 programming language system itself.
-
-=cut
diff -pruN 0.022-1/lib/ExtUtils/Builder/Linker/COFF.pm 0.026-1/lib/ExtUtils/Builder/Linker/COFF.pm
--- 0.022-1/lib/ExtUtils/Builder/Linker/COFF.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Linker/COFF.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Linker::COFF;
-$ExtUtils::Builder::Linker::COFF::VERSION = '0.022';
+$ExtUtils::Builder::Linker::COFF::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -14,7 +14,7 @@ my %export_for = (
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{export} ||= $export_for{ $args{type} };
+	$args{export} //= $export_for{ $args{type} };
 	$self->{autoimport} = defined $args{autoimport} ? $args{autoimport} : 1;
 	$self->SUPER::_init(%args);
 	return;
@@ -26,30 +26,3 @@ sub autoimport {
 }
 
 1;
-
-__END__
-
-=pod
-
-=encoding UTF-8
-
-=head1 NAME
-
-ExtUtils::Builder::Linker::COFF
-
-=head1 VERSION
-
-version 0.022
-
-=head1 AUTHOR
-
-Leon Timmermans <fawaka@gmail.com>
-
-=head1 COPYRIGHT AND LICENSE
-
-This software is copyright (c) 2012 by Leon Timmermans.
-
-This is free software; you can redistribute it and/or modify it under
-the same terms as the Perl 5 programming language system itself.
-
-=cut
diff -pruN 0.022-1/lib/ExtUtils/Builder/Linker/ELF/Any.pm 0.026-1/lib/ExtUtils/Builder/Linker/ELF/Any.pm
--- 0.022-1/lib/ExtUtils/Builder/Linker/ELF/Any.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Linker/ELF/Any.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Linker::ELF::Any;
-$ExtUtils::Builder::Linker::ELF::Any::VERSION = '0.022';
+$ExtUtils::Builder::Linker::ELF::Any::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -7,8 +7,8 @@ use parent 'ExtUtils::Builder::Linker::U
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{ld} ||= ['cc'];
-	$args{export} ||= $args{type} eq 'executable' ? 'none' : 'all';
+	$args{ld} //= ['cc'];
+	$args{export} //= $args{type} eq 'executable' ? 'none' : 'all';
 	$self->SUPER::_init(%args);
 	$self->{ccdlflags} = defined $args{ccdlflags} ? $args{ccdlflags} : Carp::croak('');
 	$self->{lddlflags} = defined $args{lddlflags} ? $args{lddlflags} : Carp::croak('');
@@ -33,30 +33,3 @@ sub linker_flags {
 }
 
 1;
-
-__END__
-
-=pod
-
-=encoding UTF-8
-
-=head1 NAME
-
-ExtUtils::Builder::Linker::ELF::Any
-
-=head1 VERSION
-
-version 0.022
-
-=head1 AUTHOR
-
-Leon Timmermans <fawaka@gmail.com>
-
-=head1 COPYRIGHT AND LICENSE
-
-This software is copyright (c) 2012 by Leon Timmermans.
-
-This is free software; you can redistribute it and/or modify it under
-the same terms as the Perl 5 programming language system itself.
-
-=cut
diff -pruN 0.022-1/lib/ExtUtils/Builder/Linker/ELF/GCC.pm 0.026-1/lib/ExtUtils/Builder/Linker/ELF/GCC.pm
--- 0.022-1/lib/ExtUtils/Builder/Linker/ELF/GCC.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Linker/ELF/GCC.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Linker::ELF::GCC;
-$ExtUtils::Builder::Linker::ELF::GCC::VERSION = '0.022';
+$ExtUtils::Builder::Linker::ELF::GCC::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -7,9 +7,9 @@ use parent 'ExtUtils::Builder::Linker::E
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{ld} ||= 'gcc';
-	$args{ccdlflags} ||= ['-Wl,-E'];
-	$args{lddlflags} ||= ['-shared'];
+	$args{ld} //= 'gcc';
+	$args{ccdlflags} //= ['-Wl,-E'];
+	$args{lddlflags} //= ['-shared'];
 	$self->SUPER::_init(%args);
 	return;
 }
@@ -22,29 +22,4 @@ sub add_runtime_path {
 
 1;
 
-__END__
 
-=pod
-
-=encoding UTF-8
-
-=head1 NAME
-
-ExtUtils::Builder::Linker::ELF::GCC
-
-=head1 VERSION
-
-version 0.022
-
-=head1 AUTHOR
-
-Leon Timmermans <fawaka@gmail.com>
-
-=head1 COPYRIGHT AND LICENSE
-
-This software is copyright (c) 2012 by Leon Timmermans.
-
-This is free software; you can redistribute it and/or modify it under
-the same terms as the Perl 5 programming language system itself.
-
-=cut
diff -pruN 0.022-1/lib/ExtUtils/Builder/Linker/Mach/GCC.pm 0.026-1/lib/ExtUtils/Builder/Linker/Mach/GCC.pm
--- 0.022-1/lib/ExtUtils/Builder/Linker/Mach/GCC.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Linker/Mach/GCC.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Linker::Mach::GCC;
-$ExtUtils::Builder::Linker::Mach::GCC::VERSION = '0.022';
+$ExtUtils::Builder::Linker::Mach::GCC::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -7,8 +7,8 @@ use parent 'ExtUtils::Builder::Linker::U
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{ld} ||= [qw/env MACOSX_DEPLOYMENT_TARGET=10.3 cc/];
-	$args{export} ||= 'all';
+	$args{ld} //= [qw/env MACOSX_DEPLOYMENT_TARGET=10.3 cc/];
+	$args{export} //= 'all';
 	$self->SUPER::_init(%args);
 	return;
 }
@@ -32,30 +32,3 @@ sub add_runtime_path {
 }
 
 1;
-
-__END__
-
-=pod
-
-=encoding UTF-8
-
-=head1 NAME
-
-ExtUtils::Builder::Linker::Mach::GCC
-
-=head1 VERSION
-
-version 0.022
-
-=head1 AUTHOR
-
-Leon Timmermans <fawaka@gmail.com>
-
-=head1 COPYRIGHT AND LICENSE
-
-This software is copyright (c) 2012 by Leon Timmermans.
-
-This is free software; you can redistribute it and/or modify it under
-the same terms as the Perl 5 programming language system itself.
-
-=cut
diff -pruN 0.022-1/lib/ExtUtils/Builder/Linker/PE/GCC.pm 0.026-1/lib/ExtUtils/Builder/Linker/PE/GCC.pm
--- 0.022-1/lib/ExtUtils/Builder/Linker/PE/GCC.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Linker/PE/GCC.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Linker::PE::GCC;
-$ExtUtils::Builder::Linker::PE::GCC::VERSION = '0.022';
+$ExtUtils::Builder::Linker::PE::GCC::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -9,8 +9,8 @@ use File::Basename ();
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{ld} ||= ['gcc'];
-	$args{export} ||= 'all';
+	$args{ld} //= ['gcc'];
+	$args{export} //= 'all';
 	$self->ExtUtils::Builder::Linker::Unixy::_init(%args);
 	$self->ExtUtils::Builder::Linker::COFF::_init(%args);
 	return;
@@ -32,37 +32,10 @@ sub linker_flags {
 		push @ret, $self->new_argument(ranking => 85, value => ['-Wl,--export-all-symbols']);
 	}
 	elsif ($self->export eq 'some') {
-		my $export_file = $opts{export_file} || ($opts{basename} || File::Basename::basename($to)) . '.def';
+		my $export_file = $opts{export_file} // ($opts{basename} // File::Basename::basename($to)) . '.def';
 		push @ret, $self->new_argument(ranking => 20, value => [$export_file]);
 	}
 	return @ret;
 }
 
 1;
-
-__END__
-
-=pod
-
-=encoding UTF-8
-
-=head1 NAME
-
-ExtUtils::Builder::Linker::PE::GCC
-
-=head1 VERSION
-
-version 0.022
-
-=head1 AUTHOR
-
-Leon Timmermans <fawaka@gmail.com>
-
-=head1 COPYRIGHT AND LICENSE
-
-This software is copyright (c) 2012 by Leon Timmermans.
-
-This is free software; you can redistribute it and/or modify it under
-the same terms as the Perl 5 programming language system itself.
-
-=cut
diff -pruN 0.022-1/lib/ExtUtils/Builder/Linker/PE/MSVC.pm 0.026-1/lib/ExtUtils/Builder/Linker/PE/MSVC.pm
--- 0.022-1/lib/ExtUtils/Builder/Linker/PE/MSVC.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Linker/PE/MSVC.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Linker::PE::MSVC;
-$ExtUtils::Builder::Linker::PE::MSVC::VERSION = '0.022';
+$ExtUtils::Builder::Linker::PE::MSVC::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -9,7 +9,7 @@ use parent qw/ExtUtils::Builder::Linker:
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{ld} ||= ['link'];
+	$args{ld} //= ['link'];
 	$self->ExtUtils::Builder::Linker::COFF::_init(%args);
 	return;
 }
@@ -19,47 +19,14 @@ sub linker_flags {
 	my @ret;
 	push @ret, $self->new_argument(ranking =>  5, value => ['/nologo']);
 	push @ret, $self->new_argument(ranking => 10, value => ['/dll']) if $self->type eq 'shared-library' or $self->type eq 'loadable-object';
-	push @ret, map { $self->new_argument(ranking => $_->{ranking}, value => [ "/libpath:-L$_->{value}" ]) } @{ $self->{library_dirs} };
+	push @ret, map { $self->new_argument(ranking => $_->{ranking}, value => [ "/libpath:$_->{value}" ]) } @{ $self->{library_dirs} };
 	push @ret, map { $self->new_argument(ranking => $_->{ranking}, value => [ "$_->{value}.lib" ]) } @{ $self->{libraries} };
 	push @ret, $self->new_argument(ranking => 50, value => [ @{$from} ]);
+	push @ret, $self->new_argument(ranking => 60, value => [ "/def:$opts{dl_file}" ]) if $opts{exports} eq 'some' && defined $opts{dl_file};
 	push @ret, $self->new_argument(ranking => 80, value => ["/OUT:$to"]);
 	# map_file, implib, def_file?…
 	return @ret;
 }
 
-sub post_action {
-	my ($self, $from, $to, %opts) = @_;
-	my @ret = $self->SUPER::post_action(%opts);
-	my $manifest = $opts{manifest} || "$to.manifest";
-	push @ret, ExtUtils::Builder::Action::Command->new(command => [ 'if', 'exist', $manifest, 'mt', '-nologo', '-manifest', $manifest, "-outputresource:$to;2" ]);
-	return @ret;
-}
-
 1;
 
-__END__
-
-=pod
-
-=encoding UTF-8
-
-=head1 NAME
-
-ExtUtils::Builder::Linker::PE::MSVC
-
-=head1 VERSION
-
-version 0.022
-
-=head1 AUTHOR
-
-Leon Timmermans <fawaka@gmail.com>
-
-=head1 COPYRIGHT AND LICENSE
-
-This software is copyright (c) 2012 by Leon Timmermans.
-
-This is free software; you can redistribute it and/or modify it under
-the same terms as the Perl 5 programming language system itself.
-
-=cut
diff -pruN 0.022-1/lib/ExtUtils/Builder/Linker/Unixy.pm 0.026-1/lib/ExtUtils/Builder/Linker/Unixy.pm
--- 0.022-1/lib/ExtUtils/Builder/Linker/Unixy.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Linker/Unixy.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Linker::Unixy;
-$ExtUtils::Builder::Linker::Unixy::VERSION = '0.022';
+$ExtUtils::Builder::Linker::Unixy::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -16,29 +16,3 @@ sub linker_flags {
 
 1;
 
-__END__
-
-=pod
-
-=encoding UTF-8
-
-=head1 NAME
-
-ExtUtils::Builder::Linker::Unixy
-
-=head1 VERSION
-
-version 0.022
-
-=head1 AUTHOR
-
-Leon Timmermans <fawaka@gmail.com>
-
-=head1 COPYRIGHT AND LICENSE
-
-This software is copyright (c) 2012 by Leon Timmermans.
-
-This is free software; you can redistribute it and/or modify it under
-the same terms as the Perl 5 programming language system itself.
-
-=cut
diff -pruN 0.022-1/lib/ExtUtils/Builder/Linker/XCOFF.pm 0.026-1/lib/ExtUtils/Builder/Linker/XCOFF.pm
--- 0.022-1/lib/ExtUtils/Builder/Linker/XCOFF.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Linker/XCOFF.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Linker::XCOFF;
-$ExtUtils::Builder::Linker::XCOFF::VERSION = '0.022';
+$ExtUtils::Builder::Linker::XCOFF::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -9,7 +9,7 @@ use File::Basename ();
 
 sub _init {
 	my ($self, %args) = @_;
-	$args{ld} ||= ['ld'];
+	$args{ld} //= ['ld'];
 	$self->ExtUtils::Builder::Linker::Unixy::_init(%args);
 	$self->ExtUtils::Builder::Linker::COFF::_init(%args);
 	return;
@@ -23,7 +23,7 @@ sub linker_flags {
 	my $type = $self->type;
 	if ($type eq 'shared-library' or $type eq 'loadable-object') {
 		if ($self->export eq 'some') {
-			my $basename = $opts{basename} || File::Basename::basename($to);
+			my $basename = $opts{basename} // File::Basename::basename($to);
 			push @ret, $self->new_arguments(ranking => 20, value => ["-bE:$basename.exp"]);
 		}
 		elsif ($self->export eq 'all') {
@@ -34,30 +34,3 @@ sub linker_flags {
 }
 
 1;
-
-__END__
-
-=pod
-
-=encoding UTF-8
-
-=head1 NAME
-
-ExtUtils::Builder::Linker::XCOFF
-
-=head1 VERSION
-
-version 0.022
-
-=head1 AUTHOR
-
-Leon Timmermans <fawaka@gmail.com>
-
-=head1 COPYRIGHT AND LICENSE
-
-This software is copyright (c) 2012 by Leon Timmermans.
-
-This is free software; you can redistribute it and/or modify it under
-the same terms as the Perl 5 programming language system itself.
-
-=cut
diff -pruN 0.022-1/lib/ExtUtils/Builder/Linker.pm 0.026-1/lib/ExtUtils/Builder/Linker.pm
--- 0.022-1/lib/ExtUtils/Builder/Linker.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Linker.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,13 +1,12 @@
 package ExtUtils::Builder::Linker;
-$ExtUtils::Builder::Linker::VERSION = '0.022';
+$ExtUtils::Builder::Linker::VERSION = '0.026';
 use strict;
 use warnings;
 
 use parent qw/ExtUtils::Builder::ArgumentCollector ExtUtils::Builder::Binary/;
 
-use ExtUtils::Builder::Action::Command;
-use ExtUtils::Builder::Action::Function;
 use ExtUtils::Builder::Node;
+use ExtUtils::Builder::Util qw/command function/;
 
 use Carp ();
 use File::Basename 'dirname';
@@ -95,7 +94,7 @@ sub pre_action  {
 	my @result;
 	if ($self->export eq 'some') {
 		my %args = map { $key_for{$_} => $opts{$_} } grep { exists $key_for{$_} } keys %opts;
-		push @result, ExtUtils::Builder::Action::Function->new(
+		push @result, function(
 			module    => 'ExtUtils::Mksymlists',
 			function  => 'Mksymlists',
 			message   => join(' ', 'prelink', $to, %args),
@@ -105,7 +104,7 @@ sub pre_action  {
 	}
 	if ($opts{mkdir}) {
 		my $dirname = File::Basename::dirname($to);
-		push @result, ExtUtils::Builder::Action::Function->new(
+		push @result, function(
 			module    => 'File::Path',
 			function  => 'make_path',
 			exports   => 'explicit',
@@ -122,9 +121,9 @@ sub link {
 	@args = $self->$_(@args) for @{ $self->{option_filters} };
 	my ($from, $to, %opts) = @args;
 	my @argv    = $self->arguments(@args);
-	my $main    = ExtUtils::Builder::Action::Command->new(command => [ $self->ld, @argv ]);
+	my $main    = command($self->ld, @argv);
 	my @actions = ($self->pre_action(@args), $main, $self->post_action(@args));
-	my $deps    = [ @{$from}, @{ $opts{dependencies} || [] } ];
+	my $deps    = [ @{$from}, @{ $opts{dependencies} // [] } ];
 	return ExtUtils::Builder::Node->new(target => $to, dependencies => $deps, actions => \@actions);
 }
 
@@ -142,7 +141,7 @@ ExtUtils::Builder::Linker
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 METHODS
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/MultiLingual.pm 0.026-1/lib/ExtUtils/Builder/MultiLingual.pm
--- 0.022-1/lib/ExtUtils/Builder/MultiLingual.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/MultiLingual.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::MultiLingual;
-$ExtUtils::Builder::MultiLingual::VERSION = '0.022';
+$ExtUtils::Builder::MultiLingual::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -17,30 +17,3 @@ sub language {
 }
 
 1;
-
-__END__
-
-=pod
-
-=encoding UTF-8
-
-=head1 NAME
-
-ExtUtils::Builder::MultiLingual
-
-=head1 VERSION
-
-version 0.022
-
-=head1 AUTHOR
-
-Leon Timmermans <fawaka@gmail.com>
-
-=head1 COPYRIGHT AND LICENSE
-
-This software is copyright (c) 2012 by Leon Timmermans.
-
-This is free software; you can redistribute it and/or modify it under
-the same terms as the Perl 5 programming language system itself.
-
-=cut
diff -pruN 0.022-1/lib/ExtUtils/Builder/ParseXS.pm 0.026-1/lib/ExtUtils/Builder/ParseXS.pm
--- 0.022-1/lib/ExtUtils/Builder/ParseXS.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/ParseXS.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,17 +1,19 @@
 package ExtUtils::Builder::ParseXS;
-$ExtUtils::Builder::ParseXS::VERSION = '0.022';
+$ExtUtils::Builder::ParseXS::VERSION = '0.026';
 use strict;
 use warnings;
 
 use parent 'ExtUtils::Builder::Planner::Extension';
 
 use File::Basename qw/basename dirname/;
-use File::Spec::Functions qw/curdir catfile catdir splitdir/;
+use File::Spec::Functions qw/abs2rel curdir catfile catdir splitdir/;
+
+use ExtUtils::Builder::Util 'function';
 
 sub add_methods {
 	my ($self, $planner, %options) = @_;
 
-	my $config = $options{config} || ($planner->can('config') ? $planner->config : ExtUtils::Config->new);
+	my $config = $options{config} // ($planner->can('config') ? $planner->config : ExtUtils::Config->new);
 
 	$planner->add_delegate('parse_xs', sub {
 		my (undef, $source, $destination, %options) = @_;
@@ -19,7 +21,7 @@ sub add_methods {
 		my @actions;
 		if ($options{mkdir}) {
 			my $dirname = dirname($destination);
-			push @actions, ExtUtils::Builder::Action::Function->new(
+			push @actions, function(
 				module    => 'File::Path',
 				function  => 'make_path',
 				arguments => [ $dirname ],
@@ -35,15 +37,15 @@ sub add_methods {
 		);
 		$args{$_} = $options{$_} for grep { defined $options{$_} } qw/typemap hiertype versioncheck linenumbers optimize prototypes/;
 
-		push @actions, ExtUtils::Builder::Action::Function->new(
+		push @actions, function(
 			module    => 'ExtUtils::ParseXS',
 			function  => 'process_file',
 			arguments => [ %args ],
 			message   => "parse-xs $source",
 		);
 
-		my @dependencies = @{ $options{dependencies} || [] };
-		$args{typemap} ||= 'typemap' if -f 'typemap';
+		my @dependencies = @{ $options{dependencies} // [] };
+		$args{typemap} //= 'typemap' if -f 'typemap';
 		push @dependencies, $args{typemap} if $args{typemap};
 
 		$planner->create_node(
@@ -55,11 +57,18 @@ sub add_methods {
 
 	$planner->add_delegate('c_file_for_xs', sub {
 		my (undef, $source, $outdir) = @_;
-		$outdir ||= dirname($source);
+		$outdir //= dirname($source);
 		my $file_base = basename($source, '.xs');
 		return catfile($outdir, "$file_base.c");
 	});
 
+	$planner->add_delegate('module_for_xs', sub {
+		my (undef, $source, $relative) = @_;
+		my @parts = splitdir(dirname(abs2rel($source, $relative)));
+		push @parts, basename($source, '.xs');
+		return join '::', @parts;
+	});
+
 	require DynaLoader;
 	my $mod2fname = defined &DynaLoader::mod2fname ? \&DynaLoader::mod2fname : sub { return $_[0][-1] };
 
@@ -90,7 +99,7 @@ ExtUtils::Builder::ParseXS - Essential f
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 SYNOPSIS
 
diff -pruN 0.022-1/lib/ExtUtils/Builder/Profile/Perl.pm 0.026-1/lib/ExtUtils/Builder/Profile/Perl.pm
--- 0.022-1/lib/ExtUtils/Builder/Profile/Perl.pm	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/lib/ExtUtils/Builder/Profile/Perl.pm	2025-03-28 11:37:38.000000000 +0000
@@ -1,5 +1,5 @@
 package ExtUtils::Builder::Profile::Perl;
-$ExtUtils::Builder::Profile::Perl::VERSION = '0.022';
+$ExtUtils::Builder::Profile::Perl::VERSION = '0.026';
 use strict;
 use warnings;
 
@@ -8,12 +8,12 @@ use File::Spec::Functions qw/catdir/;
 
 sub _get_var {
 	my ($config, $opts, $key) = @_;
-	return delete $opts->{$key} || $config->get($key);
+	return delete $opts->{$key} // $config->get($key);
 }
 
 sub _split_var {
 	my ($config, $opts, $key) = @_;
-	return delete $opts->{$key} || [ split_like_shell($config->get($key)) ];
+	return delete $opts->{$key} // [ split_like_shell($config->get($key)) ];
 }
 
 sub process_compiler {
@@ -44,7 +44,11 @@ sub process_linker {
 	if ($linker->export eq 'some') {
 		$linker->add_option_filter(sub {
 			my ($self, $from, $to, %opts) = @_;
-			$opts{dl_name} ||= $opts{module_name} if $opts{module_name};
+			$opts{dl_name} //= $opts{module_name} if $opts{module_name};
+			$opts{dl_file} //= do {
+				(my $short = $opts{dl_name}) =~ s/.*:://;
+				catdir(dirname($from), "$short.def");
+			};
 			return ($from, $to, %opts);
 		});
 	}
@@ -59,7 +63,7 @@ sub process_linker {
 		$linker->add_argument(ranking => 80, value => _split_var($config, $opts, 'perllibs'));
 	}
 	if ($linker->type eq 'executable') {
-		my $rpath = $opts->{rpath} || [ split_like_shell($config->get('ccdlflags') =~ $rpath_regex) ];
+		my $rpath = $opts->{rpath} // [ split_like_shell($config->get('ccdlflags') =~ $rpath_regex) ];
 		$linker->add_argument(ranking => 40, value => $rpath) if @{$rpath};
 	}
 	return;
@@ -81,7 +85,7 @@ ExtUtils::Builder::Profile::Perl - A pro
 
 =head1 VERSION
 
-version 0.022
+version 0.026
 
 =head1 SYNOPSIS
 
diff -pruN 0.022-1/prereqs.yml 0.026-1/prereqs.yml
--- 0.022-1/prereqs.yml	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/prereqs.yml	2025-03-28 11:37:38.000000000 +0000
@@ -1,3 +1,3 @@
 runtime:
   requires:
-    ExtUtils::Builder::Planner: 0.009
+    ExtUtils::Builder: 0.013
diff -pruN 0.022-1/t/40-autodetect-loadable-object.t 0.026-1/t/40-autodetect-loadable-object.t
--- 0.022-1/t/40-autodetect-loadable-object.t	2024-09-13 12:11:26.000000000 +0000
+++ 0.026-1/t/40-autodetect-loadable-object.t	2025-03-28 11:37:38.000000000 +0000
@@ -6,6 +6,7 @@ use warnings;
 use Test::More 0.89;
 
 use Config;
+plan(skip_all => 'No dynamic linking') if not $Config{usedl};
 use ExtUtils::Builder::Planner 0.007;
 use File::Basename qw/basename dirname/;
 use File::Spec::Functions qw/catfile/;
@@ -62,7 +63,7 @@ my $object_file = catfile(dirname($sourc
 $planner->compile($source_file, $object_file);
 
 my $lib_file = catfile(dirname($source_file), basename($object_file, $Config{obj_ext}) . ".$Config{dlext}");
-$planner->link([$object_file], $lib_file);
+$planner->link([$object_file], $lib_file, dl_name => 'compilet');
 
 my $plan = $planner->materialize;
 ok $plan;
@@ -78,8 +79,8 @@ ok($libref, 'libref is defined');
 my $symref = DynaLoader::dl_find_symbol($libref, "boot_compilet");
 ok($symref, 'symref is defined');
 
-my $compilet = DynaLoader::dl_install_xsub("compilet", $symref, $source_file);
-is(eval { compilet(); 1 }, 1, 'compilet lives');
+my $boot_compilet = DynaLoader::dl_install_xsub("boot_compilet", $symref, $source_file);
+is(eval { boot_compilet(); 1 }, 1, 'compilet lives');
 
 is(eval { exported() }, 42, 'exported returns 42');
 
