diff -pruN 1.14-2/Changes 1.15-1/Changes
--- 1.14-2/Changes	2024-05-16 07:40:04.000000000 +0000
+++ 1.15-1/Changes	2025-01-11 07:53:43.000000000 +0000
@@ -1,5 +1,8 @@
 Revision history for Excel-ValueReader-XLSX
 
+1.15 11.01.2025
+  - fix bug in table() with 'ref' param (Ephraim Stevens++)
+
 1.14 16.05.2023
   - better error message for invalid table name
 
diff -pruN 1.14-2/META.json 1.15-1/META.json
--- 1.14-2/META.json	2024-05-16 07:44:25.000000000 +0000
+++ 1.15-1/META.json	2025-01-11 07:57:09.000000000 +0000
@@ -48,19 +48,19 @@
    "provides" : {
       "Excel::ValueReader::XLSX" : {
          "file" : "lib/Excel/ValueReader/XLSX.pm",
-         "version" : "1.14"
+         "version" : "1.15"
       },
       "Excel::ValueReader::XLSX::Backend" : {
          "file" : "lib/Excel/ValueReader/XLSX/Backend.pm",
-         "version" : "1.13"
+         "version" : "1.15"
       },
       "Excel::ValueReader::XLSX::Backend::LibXML" : {
          "file" : "lib/Excel/ValueReader/XLSX/Backend/LibXML.pm",
-         "version" : "1.13"
+         "version" : "1.15"
       },
       "Excel::ValueReader::XLSX::Backend::Regex" : {
          "file" : "lib/Excel/ValueReader/XLSX/Backend/Regex.pm",
-         "version" : "1.13"
+         "version" : "1.15"
       }
    },
    "release_status" : "stable",
@@ -72,6 +72,6 @@
          "url" : "https://github.com/damil/Excel-ValueReader-XLSX"
       }
    },
-   "version" : "1.14",
+   "version" : "1.15",
    "x_serialization_backend" : "JSON::PP version 4.16"
 }
diff -pruN 1.14-2/META.yml 1.15-1/META.yml
--- 1.14-2/META.yml	2024-05-16 07:44:25.000000000 +0000
+++ 1.15-1/META.yml	2025-01-11 07:57:09.000000000 +0000
@@ -20,16 +20,16 @@ name: Excel-ValueReader-XLSX
 provides:
   Excel::ValueReader::XLSX:
     file: lib/Excel/ValueReader/XLSX.pm
-    version: '1.14'
+    version: '1.15'
   Excel::ValueReader::XLSX::Backend:
     file: lib/Excel/ValueReader/XLSX/Backend.pm
-    version: '1.13'
+    version: '1.15'
   Excel::ValueReader::XLSX::Backend::LibXML:
     file: lib/Excel/ValueReader/XLSX/Backend/LibXML.pm
-    version: '1.13'
+    version: '1.15'
   Excel::ValueReader::XLSX::Backend::Regex:
     file: lib/Excel/ValueReader/XLSX/Backend/Regex.pm
-    version: '1.13'
+    version: '1.15'
 recommends:
   XML::LibXML::Reader: '0'
 requires:
@@ -45,5 +45,5 @@ requires:
 resources:
   license: http://dev.perl.org/licenses/
   repository: https://github.com/damil/Excel-ValueReader-XLSX
-version: '1.14'
+version: '1.15'
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
diff -pruN 1.14-2/debian/changelog 1.15-1/debian/changelog
--- 1.14-2/debian/changelog	2024-05-21 08:49:54.000000000 +0000
+++ 1.15-1/debian/changelog	2025-02-01 00:32:20.000000000 +0000
@@ -1,3 +1,10 @@
+libexcel-valuereader-xlsx-perl (1.15-1) unstable; urgency=medium
+
+  * Import upstream version 1.15.
+  * Update years of packaging copyright.
+
+ -- gregor herrmann <gregoa@debian.org>  Sat, 01 Feb 2025 01:32:20 +0100
+
 libexcel-valuereader-xlsx-perl (1.14-2) unstable; urgency=medium
 
   * No-change source-only re-upload.
diff -pruN 1.14-2/debian/copyright 1.15-1/debian/copyright
--- 1.14-2/debian/copyright	2024-05-21 08:49:54.000000000 +0000
+++ 1.15-1/debian/copyright	2025-02-01 00:32:20.000000000 +0000
@@ -8,7 +8,7 @@ Copyright: 2020-2023, Laurent Dami <dami
 License: Artistic or GPL-1+
 
 Files: debian/*
-Copyright: 2024, gregor herrmann <gregoa@debian.org>
+Copyright: 2024-2025, gregor herrmann <gregoa@debian.org>
 License: Artistic or GPL-1+
 
 License: Artistic
diff -pruN 1.14-2/lib/Excel/ValueReader/XLSX/Backend/LibXML.pm 1.15-1/lib/Excel/ValueReader/XLSX/Backend/LibXML.pm
--- 1.14-2/lib/Excel/ValueReader/XLSX/Backend/LibXML.pm	2023-11-06 21:46:45.000000000 +0000
+++ 1.15-1/lib/Excel/ValueReader/XLSX/Backend/LibXML.pm	2025-01-11 07:55:35.000000000 +0000
@@ -7,7 +7,7 @@ use XML::LibXML::Reader qw/XML_READER_TY
 
 extends 'Excel::ValueReader::XLSX::Backend';
 
-our $VERSION = '1.13';
+our $VERSION = '1.15';
 
 #======================================================================
 # LAZY ATTRIBUTE CONSTRUCTORS
diff -pruN 1.14-2/lib/Excel/ValueReader/XLSX/Backend/Regex.pm 1.15-1/lib/Excel/ValueReader/XLSX/Backend/Regex.pm
--- 1.14-2/lib/Excel/ValueReader/XLSX/Backend/Regex.pm	2023-11-06 21:46:56.000000000 +0000
+++ 1.15-1/lib/Excel/ValueReader/XLSX/Backend/Regex.pm	2025-01-11 07:55:46.000000000 +0000
@@ -7,7 +7,7 @@ use Carp         qw/croak/;
 
 extends 'Excel::ValueReader::XLSX::Backend';
 
-our $VERSION = '1.13';
+our $VERSION = '1.15';
 
 #======================================================================
 # LAZY ATTRIBUTE CONSTRUCTORS
diff -pruN 1.14-2/lib/Excel/ValueReader/XLSX/Backend.pm 1.15-1/lib/Excel/ValueReader/XLSX/Backend.pm
--- 1.14-2/lib/Excel/ValueReader/XLSX/Backend.pm	2023-11-06 21:46:32.000000000 +0000
+++ 1.15-1/lib/Excel/ValueReader/XLSX/Backend.pm	2025-01-11 07:55:23.000000000 +0000
@@ -6,7 +6,7 @@ use Archive::Zip 1.61     qw(AZ_OK);
 use Carp                  qw/croak/;
 use Scalar::Util          qw/openhandle/;
 
-our $VERSION = '1.13';
+our $VERSION = '1.15';
 
 #======================================================================
 # ATTRIBUTES
diff -pruN 1.14-2/lib/Excel/ValueReader/XLSX.pm 1.15-1/lib/Excel/ValueReader/XLSX.pm
--- 1.14-2/lib/Excel/ValueReader/XLSX.pm	2024-05-16 07:43:57.000000000 +0000
+++ 1.15-1/lib/Excel/ValueReader/XLSX.pm	2025-01-11 07:55:08.000000000 +0000
@@ -7,7 +7,7 @@ use Date::Calc            qw/Add_Delta_D
 use POSIX                 qw/strftime modf/;
 use Carp                  qw/croak/;
 
-our $VERSION = '1.14';
+our $VERSION = '1.15';
 
 #======================================================================
 # ATTRIBUTES
@@ -255,7 +255,7 @@ sub _subrange {
 
   # restrict to the column range
   my @col_nums = map {$self->A1_to_num($_) - 1} ($col1, $col2);
-  if ($col_nums[0] > 1){
+  if ($col_nums[0] > 0){
     my @col_range = ($col_nums[0] .. $col_nums[1]);
     $values = [map { [ @$_[@col_range] ]} @$values];
   }
@@ -645,6 +645,10 @@ Ulibuck signaled bugs several minor bugs
 
 H.Merijn Brand suggested additions to the API and several improvements to the code source.
 
+=item *
+
+Ephraim Stevens signaled a bug in the table() method with 'ref' param.
+
 =back
 
 
diff -pruN 1.14-2/t/valuereader.t 1.15-1/t/valuereader.t
--- 1.14-2/t/valuereader.t	2023-11-06 21:38:45.000000000 +0000
+++ 1.15-1/t/valuereader.t	2025-01-11 07:51:00.000000000 +0000
@@ -177,6 +177,13 @@ my @expected_tab_cols_with_entities = (
 );
 
 
+my @expected_tab_by_ref = (
+  {Name => 'amp', Char => '&'},
+  {Name => 'gt',  Char => '>'},
+  {Name => 'lt',  Char => '<'},
+ );
+
+
 my @expected_without_r = (
   [qw/One      two      three/],
   [qw/four     five     six  /],
@@ -255,6 +262,9 @@ sub run_tests {
   my $tab_cols_with_entities = $reader->table('Cols_with_entities');
   is_deeply($tab_cols_with_entities, \@expected_tab_cols_with_entities, "tab_cols_with_entities, using $context");
 
+  my $tab_by_ref = $reader->table(sheet => "Entities", ref => "B1:C4");
+  is_deeply($tab_by_ref, \@expected_tab_by_ref, "tab_by_ref");
+
   # check a pivot table
   my $tab_entities = $reader->values('Tab_entities');
   is_deeply($tab_entities, \@expected_tab_entities, "tab_entities using $context");
