diff -pruN 1.9.19-1/CHANGES.md 1.9.20-1/CHANGES.md
--- 1.9.19-1/CHANGES.md	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/CHANGES.md	2024-12-09 16:25:48.000000000 +0000
@@ -1,3 +1,10 @@
+# Changes in HTMLDOC v1.9.20
+
+- Fixed a regression that caused spaces to disappear between some words
+  (Issue #533)
+- Fixed resolution of relative links within a document (Issue #534)
+
+
 # Changes in HTMLDOC v1.9.19
 
 - Security: Fixed an issue with the `file_basename` implementation (Issue #532)
diff -pruN 1.9.19-1/configure 1.9.20-1/configure
--- 1.9.19-1/configure	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/configure	2024-12-09 16:25:48.000000000 +0000
@@ -1,6 +1,6 @@
 #! /bin/sh
 # Guess values for system-dependent variables and create Makefiles.
-# Generated by GNU Autoconf 2.71 for HTMLDOC 1.9.19.
+# Generated by GNU Autoconf 2.71 for HTMLDOC 1.9.20.
 #
 # Report bugs to <https://github.com/michaelrsweet/htmldoc/issues>.
 #
@@ -610,8 +610,8 @@ MAKEFLAGS=
 # Identity of this package.
 PACKAGE_NAME='HTMLDOC'
 PACKAGE_TARNAME='htmldoc'
-PACKAGE_VERSION='1.9.19'
-PACKAGE_STRING='HTMLDOC 1.9.19'
+PACKAGE_VERSION='1.9.20'
+PACKAGE_STRING='HTMLDOC 1.9.20'
 PACKAGE_BUGREPORT='https://github.com/michaelrsweet/htmldoc/issues'
 PACKAGE_URL='https://www.msweet.org/htmldoc'
 
@@ -1293,7 +1293,7 @@ if test "$ac_init_help" = "long"; then
   # Omit some internal or obsolete options to make the list less imposing.
   # This message is too long to be a string in the A/UX 3.1 sh.
   cat <<_ACEOF
-\`configure' configures HTMLDOC 1.9.19 to adapt to many kinds of systems.
+\`configure' configures HTMLDOC 1.9.20 to adapt to many kinds of systems.
 
 Usage: $0 [OPTION]... [VAR=VALUE]...
 
@@ -1359,7 +1359,7 @@ fi
 
 if test -n "$ac_init_help"; then
   case $ac_init_help in
-     short | recursive ) echo "Configuration of HTMLDOC 1.9.19:";;
+     short | recursive ) echo "Configuration of HTMLDOC 1.9.20:";;
    esac
   cat <<\_ACEOF
 
@@ -1458,7 +1458,7 @@ fi
 test -n "$ac_init_help" && exit $ac_status
 if $ac_init_version; then
   cat <<\_ACEOF
-HTMLDOC configure 1.9.19
+HTMLDOC configure 1.9.20
 generated by GNU Autoconf 2.71
 
 Copyright (C) 2021 Free Software Foundation, Inc.
@@ -1753,7 +1753,7 @@ cat >config.log <<_ACEOF
 This file contains any messages produced by compilers while
 running configure, to aid debugging if configure makes a mistake.
 
-It was created by HTMLDOC $as_me 1.9.19, which was
+It was created by HTMLDOC $as_me 1.9.20, which was
 generated by GNU Autoconf 2.71.  Invocation command line was
 
   $ $0$ac_configure_args_raw
@@ -2728,7 +2728,7 @@ ac_config_headers="$ac_config_headers co
 
 
 
-SVERSION="1.9.19"
+SVERSION="1.9.20"
 
 printf "%s\n" "#define SVERSION \"$SVERSION\"" >>confdefs.h
 
@@ -6148,7 +6148,7 @@ cat >>$CONFIG_STATUS <<\_ACEOF || ac_wri
 # report actual input values of CONFIG_FILES etc. instead of their
 # values after options handling.
 ac_log="
-This file was extended by HTMLDOC $as_me 1.9.19, which was
+This file was extended by HTMLDOC $as_me 1.9.20, which was
 generated by GNU Autoconf 2.71.  Invocation command line was
 
   CONFIG_FILES    = $CONFIG_FILES
@@ -6213,7 +6213,7 @@ ac_cs_config_escaped=`printf "%s\n" "$ac
 cat >>$CONFIG_STATUS <<_ACEOF || ac_write_fail=1
 ac_cs_config='$ac_cs_config_escaped'
 ac_cs_version="\\
-HTMLDOC config.status 1.9.19
+HTMLDOC config.status 1.9.20
 configured by $0, generated by GNU Autoconf 2.71,
   with options \\"\$ac_cs_config\\"
 
diff -pruN 1.9.19-1/configure.ac 1.9.20-1/configure.ac
--- 1.9.19-1/configure.ac	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/configure.ac	2024-12-09 16:25:48.000000000 +0000
@@ -21,7 +21,7 @@ dnl We need at least autoconf 2.69 for t
 AC_PREREQ([2.69])
 
 
-AC_INIT([HTMLDOC], [1.9.19], [https://github.com/michaelrsweet/htmldoc/issues], [htmldoc], [https://www.msweet.org/htmldoc])
+AC_INIT([HTMLDOC], [1.9.20], [https://github.com/michaelrsweet/htmldoc/issues], [htmldoc], [https://www.msweet.org/htmldoc])
 AC_CONFIG_HEADERS([config.h])
 
 
diff -pruN 1.9.19-1/debian/changelog 1.9.20-1/debian/changelog
--- 1.9.19-1/debian/changelog	2024-11-29 05:30:36.000000000 +0000
+++ 1.9.20-1/debian/changelog	2024-12-09 21:15:58.000000000 +0000
@@ -1,3 +1,10 @@
+htmldoc (1.9.20-1) unstable; urgency=medium
+
+  * New upstream release.
+  * Rebase patches.
+
+ -- Håvard F. Aasen <havard.f.aasen@pfft.no>  Mon, 09 Dec 2024 22:15:58 +0100
+
 htmldoc (1.9.19-1) unstable; urgency=medium
 
   * New upstream release.
diff -pruN 1.9.19-1/debian/patches/build_documentation.patch 1.9.20-1/debian/patches/build_documentation.patch
--- 1.9.19-1/debian/patches/build_documentation.patch	2024-11-29 05:30:36.000000000 +0000
+++ 1.9.20-1/debian/patches/build_documentation.patch	2024-12-09 21:15:58.000000000 +0000
@@ -11,7 +11,7 @@ Last-Update: 2022-06-08
  1 file changed, 1 insertion(+), 1 deletion(-)
 
 diff --git a/doc/Makefile b/doc/Makefile
-index b332dec..e9e9096 100644
+index 839c8a9..4ec0e02 100644
 --- a/doc/Makefile
 +++ b/doc/Makefile
 @@ -28,7 +28,7 @@ SOURCES	=	1-intro.html \
diff -pruN 1.9.19-1/debian/patches/enforce-utf8-doc.patch 1.9.20-1/debian/patches/enforce-utf8-doc.patch
--- 1.9.19-1/debian/patches/enforce-utf8-doc.patch	2024-11-29 05:30:36.000000000 +0000
+++ 1.9.20-1/debian/patches/enforce-utf8-doc.patch	2024-12-09 21:15:58.000000000 +0000
@@ -10,7 +10,7 @@ Last-Update: 2024-11-29
  1 file changed, 1 insertion(+), 1 deletion(-)
 
 diff --git a/doc/1-intro.html b/doc/1-intro.html
-index 314841f..9ee9ea8 100644
+index ff390fd..d3bf274 100644
 --- a/doc/1-intro.html
 +++ b/doc/1-intro.html
 @@ -1,7 +1,7 @@
@@ -19,6 +19,6 @@ index 314841f..9ee9ea8 100644
  	<meta name="author" content="Michael R Sweet">
 -	<meta name="copyright" content="Copyright &copy; 1997-2024, All Rights Reserved.">
 +	<meta name="copyright" content="Copyright (C) 1997-2024, All Rights Reserved.">
- 	<meta name="docversion" content="htmldoc-1.9.19">
+ 	<meta name="docversion" content="htmldoc-1.9.20">
  	<meta name="keywords" content="Software">
  	<title>HTMLDOC Users Manual</title>
diff -pruN 1.9.19-1/desktop/htmldoc.plist.in 1.9.20-1/desktop/htmldoc.plist.in
--- 1.9.19-1/desktop/htmldoc.plist.in	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/desktop/htmldoc.plist.in	2024-12-09 16:25:48.000000000 +0000
@@ -17,7 +17,7 @@
 	<string>English</string>
 
 	<key>NSHumanReadableCopyright</key>
-	<string>Copyright 1997-2019 by Michael R Sweet</string>
+	<string>Copyright 1997-2024 by Michael R Sweet</string>
 
 	<key>CFAppleHelpAnchor</key>
 	<string>help</string>
@@ -38,7 +38,7 @@
 	<string>@SVERSION@</string>
 
 	<key>CFBundleGetInfoString</key>
-	<string>@SVERSION@, Copyright Michael R Sweet 1997-2019</string>
+	<string>@SVERSION@, Copyright Michael R Sweet 1997-2024</string>
 
 	<key>CFBundleDocumentTypes</key>
 	<array>
diff -pruN 1.9.19-1/doc/1-intro.html 1.9.20-1/doc/1-intro.html
--- 1.9.19-1/doc/1-intro.html	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/doc/1-intro.html	2024-12-09 16:25:48.000000000 +0000
@@ -2,7 +2,7 @@
 <head>
 	<meta name="author" content="Michael R Sweet">
 	<meta name="copyright" content="Copyright &copy; 1997-2024, All Rights Reserved.">
-	<meta name="docversion" content="htmldoc-1.9.19">
+	<meta name="docversion" content="htmldoc-1.9.20">
 	<meta name="keywords" content="Software">
 	<title>HTMLDOC Users Manual</title>
 </head>
diff -pruN 1.9.19-1/doc/Makefile 1.9.20-1/doc/Makefile
--- 1.9.19-1/doc/Makefile	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/doc/Makefile	2024-12-09 16:25:48.000000000 +0000
@@ -1,7 +1,7 @@
 #
 # Makefile for HTMLDOC documentation files.
 #
-# Copyright © 2011-2018 by Michael R Sweet.
+# Copyright © 2011-2024 by Michael R Sweet.
 # Copyright © 1997-2010 by Easy Software Products.
 #
 # This program is free software.  Distribution and use rights are outlined in
@@ -80,7 +80,7 @@ htmldoc.d:	$(SOURCES) ../htmldoc/htmldoc
 		$(RM) -r htmldoc.d; \
 	fi
 	$(MKDIR) htmldoc.d
-	$(VALGRIND) $(HTMLDOC) --batch htmldoc.book -t htmlsep -d htmldoc.d
+	$(VALGRIND) $(HTMLDOC) --batch htmldoc.book --strict -t htmlsep -d htmldoc.d
 
 
 #
@@ -89,7 +89,7 @@ htmldoc.d:	$(SOURCES) ../htmldoc/htmldoc
 
 htmldoc.epub:	$(SOURCES) ../htmldoc/htmldoc$(EXEEXT)
 	echo Formatting htmldoc.epub...
-	$(VALGRIND) $(HTMLDOC) --batch htmldoc.book --titleimage htmldoc-cover.png -f htmldoc.epub
+	$(VALGRIND) $(HTMLDOC) --batch htmldoc.book --strict --titleimage htmldoc-cover.png -f htmldoc.epub
 
 
 #
@@ -98,7 +98,7 @@ htmldoc.epub:	$(SOURCES) ../htmldoc/html
 
 htmldoc.html:	$(SOURCES) ../htmldoc/htmldoc$(EXEEXT)
 	echo Formatting htmldoc.html...
-	$(VALGRIND) $(HTMLDOC) --batch htmldoc.book -f htmldoc.html
+	$(VALGRIND) $(HTMLDOC) --batch htmldoc.book --strict -f htmldoc.html
 
 
 #
@@ -107,7 +107,7 @@ htmldoc.html:	$(SOURCES) ../htmldoc/html
 
 htmldoc.pdf:	$(SOURCES) ../htmldoc/htmldoc$(EXEEXT)
 	echo Formatting htmldoc.pdf...
-	$(VALGRIND) $(HTMLDOC) --batch htmldoc.book -f htmldoc.pdf
+	$(VALGRIND) $(HTMLDOC) --batch htmldoc.book --strict -f htmldoc.pdf
 
 
 #
@@ -116,4 +116,4 @@ htmldoc.pdf:	$(SOURCES) ../htmldoc/htmld
 
 htmldoc.ps:	$(SOURCES) ../htmldoc/htmldoc$(EXEEXT)
 	echo Formatting htmldoc.ps...
-	$(VALGRIND) $(HTMLDOC) --batch htmldoc.book -f htmldoc.ps
+	$(VALGRIND) $(HTMLDOC) --batch htmldoc.book --strict -f htmldoc.ps
diff -pruN 1.9.19-1/htmldoc/htmllib.cxx 1.9.20-1/htmldoc/htmllib.cxx
--- 1.9.19-1/htmldoc/htmllib.cxx	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/htmldoc/htmllib.cxx	2024-12-09 16:25:48.000000000 +0000
@@ -3584,22 +3584,28 @@ htmlFixLinks(tree_t *doc,		// I - Top no
       progress_error(HD_ERROR_NONE, "DEBUG: Updating links in document.");
   }
 
+  DEBUG_printf(("htmlFixLinks: base=\"%s\"\n", (char *)base));
+
   while (tree)
   {
     if (tree->markup == MARKUP_A && base && base[0] &&
         (href = htmlGetVariable(tree, (uchar *)"HREF")) != NULL)
     {
       // Check if the link needs to be localized...
-      if (href[0] != '#' && file_method((char *)href) == NULL &&
-          file_method((char *)base) != NULL &&
-	  htmlFindFile(doc, (uchar *)file_basename((char *)href)) == NULL)
+      DEBUG_printf(("htmlFixLinks: href=\"%s\", file_method(href)=\"%s\", file_method(base)=\"%s\"\\n", (char *)href, file_method((char *)href), file_method((char *)base)));
+
+      if (href[0] != '#' && file_method((char *)href) == NULL)
       {
         // Yes, localize it...
+        DEBUG_puts("htmlFixLinks: Localizing");
+
 	if (href[0] == '/')
 	{
 	  // Absolute URL, just copy scheme, server, etc.
 	  char *ptr;			// Pointer into URL...
 
+          DEBUG_puts("htmlFixLinks: Absolute");
+
 	  strlcpy(full_href, (char *)base, sizeof(full_href));
 
           if (href[1] == '/')
@@ -3608,8 +3614,7 @@ htmlFixLinks(tree_t *doc,		// I - Top no
 	    if ((ptr = strstr(full_href, "//")) != NULL)
 	      *ptr ='\0';
 	  }
-	  else if ((ptr = strstr(full_href, "//")) != NULL  &&
-	           (ptr = strchr(ptr + 2, '/')) != NULL)
+	  else if ((ptr = strstr(full_href, "//")) != NULL && (ptr = strchr(ptr + 2, '/')) != NULL)
 	    *ptr ='\0';
 
 	  strlcat(full_href, (char *)href, sizeof(full_href));
@@ -3618,12 +3623,40 @@ htmlFixLinks(tree_t *doc,		// I - Top no
 	{
 	  // Relative URL of the form "./foo/bar", append href sans
 	  // "./" to base to form full href...
+          DEBUG_puts("htmlFixLinks: Current directory");
+
 	  snprintf(full_href, sizeof(full_href), "%s/%s", base, href + 2);
 	}
+	else if (!strncmp((char *)href, "../", 3))
+	{
+	  // Relative URL of the form "../foo/bar", append href sans
+	  // "../" to parent to form full href...
+	  char parent[1024], *pptr;	// Parent directory
+
+	  strlcpy(parent, (char *)base, sizeof(parent));
+          while (!strncmp((char *)href, "../", 3))
+          {
+            href += 3;
+
+	    if ((pptr = strrchr(parent, '/')) != NULL)
+	      pptr[1] = '\0';
+	    else
+	      parent[0] = '\0';
+	  }
+
+          DEBUG_printf(("htmlFixLinks: Subdirectory, parent=\"%s\"\n", parent));
+
+	  snprintf(full_href, sizeof(full_href), "%s%s", parent, href);
+	}
 	else
 	{
 	  // Relative URL, append href to base to form full href...
-	  snprintf(full_href, sizeof(full_href), "%s/%s", base, href);
+          DEBUG_puts("htmlFixLinks: Relative");
+
+          if (strcmp((char *)base, "."))
+	    snprintf(full_href, sizeof(full_href), "%s/%s", (char *)base, (char *)href);
+	  else
+	    strlcpy(full_href, (char *)href, sizeof(full_href));
 	}
 
         if (show_debug)
diff -pruN 1.9.19-1/htmldoc/ps-pdf.cxx 1.9.20-1/htmldoc/ps-pdf.cxx
--- 1.9.19-1/htmldoc/ps-pdf.cxx	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/htmldoc/ps-pdf.cxx	2024-12-09 16:25:48.000000000 +0000
@@ -3425,6 +3425,7 @@ pdf_write_links(FILE *out)		/* I - Outpu
 	   /*
             * Local link...
             */
+
             if (link->page < (int)num_pages)
             {
 	      float x1, y1, x2, y2;
@@ -4126,23 +4127,37 @@ parse_doc(tree_t *t,		/* I - Tree to par
     }
     else if (t->markup == MARKUP_FILE)
     {
-     /*
-      * Add a file link...
-      */
+      // Add file links, stripping any trailing HTTP GET parameters...
+      uchar	newname[256],	// New filename
+		*sep;		// "?" separator in links
+      int	linkpage;	// Link page
 
-      uchar	newname[256],	/* New filename */
-		*sep;		/* "?" separator in links */
+      // Figure out what page the file will actually start on...
+      linkpage = *page;
 
+      if ((chapter > 0 && OutputType == OUTPUT_BOOK) ||
+          ((linkpage > 0 || *y < *top) && OutputType == OUTPUT_WEBPAGES))
+      {
+        if (*y < *top)
+          linkpage ++;
+
+        if (PageDuplex && (linkpage & 1))
+          linkpage ++;
+      }
+
+      // Base filename link...
+      strlcpy((char *)newname, (char *)htmlGetVariable(t, (uchar *)"_HD_FILENAME"), sizeof(newname));
+      if ((sep = (uchar *)strchr((char *)newname, '?')) != NULL)
+        *sep = '\0';
 
-      // Strip any trailing HTTP GET data stuff...
-      strlcpy((char *)newname, (char *)htmlGetVariable(t, (uchar *)"_HD_FILENAME"),
-              sizeof(newname));
+      add_link(NULL, newname, linkpage, (int)*top);
 
+      // Relative filename link...
+      strlcpy((char *)newname, (char *)htmlGetVariable(t, (uchar *)"_HD_URL"), sizeof(newname));
       if ((sep = (uchar *)strchr((char *)newname, '?')) != NULL)
         *sep = '\0';
 
-      // Add the link
-      add_link(NULL, newname, *page, (int)*y);
+      add_link(NULL, newname, linkpage, (int)*top);
     }
 
     if (chapter == 0 && !title_page)
@@ -4811,8 +4826,7 @@ parse_paragraph(tree_t *t,	/* I - Tree t
 		*border;
   float		rgb[3];
   uchar		line[10240],
-		*lineptr,
-		*dataptr;
+		*lineptr;
   tree_t	*linetype;
   float		linex,
 		linewidth;
@@ -5204,12 +5218,9 @@ parse_paragraph(tree_t *t,	/* I - Tree t
     if (temp != NULL && temp->markup == MARKUP_NONE && temp->data[0] == ' ' && temp->data[1])
     {
       // Drop leading space...
-      for (dataptr = temp->data; *dataptr; dataptr ++)
-        *dataptr = dataptr[1];
-      *dataptr = '\0';
+      temp->data ++;
 
-      temp_width = _htmlWidths[temp->typeface][temp->style][' '] * _htmlSizes[temp->size] * 0.001f;
-      temp->width -= temp_width;
+      temp->width -= _htmlWidths[temp->typeface][temp->style][' '] * _htmlSizes[temp->size] * 0.001f;
       num_chars --;
     }
 
diff -pruN 1.9.19-1/snap/snapcraft.yaml 1.9.20-1/snap/snapcraft.yaml
--- 1.9.19-1/snap/snapcraft.yaml	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/snap/snapcraft.yaml	2024-12-09 16:25:48.000000000 +0000
@@ -1,6 +1,6 @@
 name: htmldoc
 base: core22
-version: "1.9.19"
+version: "1.9.20"
 summary: HTML and Markdown conversion utility
 description: |
   HTMLDOC is a program that reads HTML and Markdown source files or web pages
diff -pruN 1.9.19-1/vcnet/config.h 1.9.20-1/vcnet/config.h
--- 1.9.19-1/vcnet/config.h	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/vcnet/config.h	2024-12-09 16:25:48.000000000 +0000
@@ -93,7 +93,7 @@ typedef __int64 ssize_t;
  * What is the version number for this software?
  */
 
-#define SVERSION	"1.9.19"
+#define SVERSION	"1.9.20"
 
 
 /*
diff -pruN 1.9.19-1/vcnet/ghtmldoc.vcxproj 1.9.20-1/vcnet/ghtmldoc.vcxproj
--- 1.9.19-1/vcnet/ghtmldoc.vcxproj	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/vcnet/ghtmldoc.vcxproj	2024-12-09 16:25:48.000000000 +0000
@@ -1,6 +1,6 @@
 ﻿<?xml version="1.0" encoding="utf-8"?>
 <Project DefaultTargets="Build" ToolsVersion="15.0" xmlns="http://schemas.microsoft.com/developer/msbuild/2003">
-  <Import Project="packages\libcups2_native.2.4.3.4\build\native\libcups2_native.props" Condition="Exists('packages\libcups2_native.2.4.3.4\build\native\libcups2_native.props')" />
+  <Import Project="packages\libcups2_native.2.4.11.1\build\native\libcups2_native.props" Condition="Exists('packages\libcups2_native.2.4.11.1\build\native\libcups2_native.props')" />
   <ItemGroup Label="ProjectConfigurations">
     <ProjectConfiguration Include="Debug|x64">
       <Configuration>Debug</Configuration>
@@ -78,7 +78,7 @@
       <Culture>0x0409</Culture>
     </ResourceCompile>
     <Link>
-      <AdditionalDependencies>packages\libcups2_native.2.4.3.4\build\native\lib\x64\Release\libcups2.lib;packages\fltk_native.1.3.7\build\native\lib\x64\Debug\fltkd.lib;packages\fltk_native.1.3.7\build\native\lib\x64\Debug\fltkimagesd.lib;packages\libpng_native.1.6.30\build\native\lib\x64\Release\libpng16.lib;packages\libjpeg-turbo-v142.2.0.4.3\build\native\lib\x64\v142\Release\jpeg.lib;packages\zlib_native.1.2.11\build\native\lib\x64\Release\zlib.lib;comctl32.lib;ws2_32.lib;%(AdditionalDependencies)</AdditionalDependencies>
+      <AdditionalDependencies>packages\libcups2_native.2.4.11.1\build\native\lib\x64\Release\libcups2.lib;packages\fltk_native.1.3.7\build\native\lib\x64\Debug\fltkd.lib;packages\fltk_native.1.3.7\build\native\lib\x64\Debug\fltkimagesd.lib;packages\libpng_native.1.6.30\build\native\lib\x64\Release\libpng16.lib;packages\libjpeg-turbo-v142.2.0.4.3\build\native\lib\x64\v142\Release\jpeg.lib;packages\zlib_native.1.2.11\build\native\lib\x64\Release\zlib.lib;comctl32.lib;ws2_32.lib;%(AdditionalDependencies)</AdditionalDependencies>
       <OutputFile>$(OutDir)ghtmldocd.exe</OutputFile>
       <SuppressStartupBanner>true</SuppressStartupBanner>
       <IgnoreSpecificDefaultLibraries>libcmtd.lib;%(IgnoreSpecificDefaultLibraries)</IgnoreSpecificDefaultLibraries>
@@ -117,7 +117,7 @@
       <Culture>0x0409</Culture>
     </ResourceCompile>
     <Link>
-      <AdditionalDependencies>packages\libcups2_native.2.4.3.4\build\native\lib\x64\Release\libcups2.lib;packages\fltk_native.1.3.7\build\native\lib\x64\Release\fltk.lib;packages\fltk_native.1.3.7\build\native\lib\x64\Release\fltkimages.lib;packages\libpng_native.1.6.30\build\native\lib\x64\Release\libpng16.lib;packages\libjpeg-turbo-v142.2.0.4.3\build\native\lib\x64\v142\Release\jpeg.lib;packages\zlib_native.1.2.11\build\native\lib\x64\Release\zlib.lib;comctl32.lib;ws2_32.lib;%(AdditionalDependencies)</AdditionalDependencies>
+      <AdditionalDependencies>packages\libcups2_native.2.4.11.1\build\native\lib\x64\Release\libcups2.lib;packages\fltk_native.1.3.7\build\native\lib\x64\Release\fltk.lib;packages\fltk_native.1.3.7\build\native\lib\x64\Release\fltkimages.lib;packages\libpng_native.1.6.30\build\native\lib\x64\Release\libpng16.lib;packages\libjpeg-turbo-v142.2.0.4.3\build\native\lib\x64\v142\Release\jpeg.lib;packages\zlib_native.1.2.11\build\native\lib\x64\Release\zlib.lib;comctl32.lib;ws2_32.lib;%(AdditionalDependencies)</AdditionalDependencies>
       <OutputFile>$(OutDir)ghtmldoc.exe</OutputFile>
       <SuppressStartupBanner>true</SuppressStartupBanner>
       <IgnoreSpecificDefaultLibraries>libcmt.lib;%(IgnoreSpecificDefaultLibraries)</IgnoreSpecificDefaultLibraries>
diff -pruN 1.9.19-1/vcnet/htmldoc-installer.aip 1.9.20-1/vcnet/htmldoc-installer.aip
--- 1.9.19-1/vcnet/htmldoc-installer.aip	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/vcnet/htmldoc-installer.aip	2024-12-09 16:25:48.000000000 +0000
@@ -1,8 +1,5 @@
 <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
-<DOCUMENT Type="Advanced Installer" CreateVersion="15.3" version="21.0.1" PreviousModules="simple" Modules="professional" RootPath="." Language="en" Id="{8101414C-E32A-4865-B7D9-ABB4FFFB336F}">
-  <COMPONENT cid="caphyon.advinst.msicomp.ProjectOptionsComponent">
-    <ROW Name="HiddenItems" Value="ActSyncAppComponent;CPLAppletComponent;AppXAppDetailsComponent;FixupComponent;AppXCapabilitiesComponent;AppXDependenciesComponent;AppXProductDetailsComponent;AppXVisualAssetsComponent;AppXAppDeclarationsComponent;AppXUriRulesComponent;MsiXDiffComponent;MsixManifestEditorComponent"/>
-  </COMPONENT>
+<DOCUMENT Type="Advanced Installer" CreateVersion="15.3" version="21.8.2" PreviousModules="simple" Modules="professional" RootPath="." Language="en" Id="{8101414C-E32A-4865-B7D9-ABB4FFFB336F}">
   <COMPONENT cid="caphyon.advinst.msicomp.MsiPropsComponent">
     <ROW Property="AI_BITMAP_DISPLAY_MODE" Value="0"/>
     <ROW Property="AI_PROPPATH_DIR_PERBUILD_ghtmldoc.exe" Value="x64\Release\ghtmldoc"/>
@@ -16,10 +13,10 @@
     <ROW Property="ARPPRODUCTICON" Value="htmldoc.exe" Type="8"/>
     <ROW Property="ARPURLINFOABOUT" Value="https://www.msweet.org/htmldoc"/>
     <ROW Property="Manufacturer" Value="Michael R Sweet"/>
-    <ROW Property="ProductCode" Value="1033:{20C49885-ABD0-4F20-B13A-3ED4D0888BF8} " Type="16"/>
+    <ROW Property="ProductCode" Value="1033:{5D847F4E-C86E-4EEC-8E84-E13E00C48891} " Type="16"/>
     <ROW Property="ProductLanguage" Value="1033"/>
     <ROW Property="ProductName" Value="HTMLDOC"/>
-    <ROW Property="ProductVersion" Value="1.9.18.0" Options="32"/>
+    <ROW Property="ProductVersion" Value="1.9.20.0" Options="32"/>
     <ROW Property="REBOOT" MultiBuildValue="DefaultBuild:ReallySuppress"/>
     <ROW Property="SecureCustomProperties" Value="OLDPRODUCTS;AI_NEWERPRODUCTFOUND"/>
     <ROW Property="UpgradeCode" Value="{4016A37E-404B-4785-B768-D4FF161DE6E9}"/>
@@ -32,8 +29,10 @@
     <ROW Property="WindowsTypeNT50Display" MultiBuildValue="DefaultBuild:Windows 2000" ValueLocId="-"/>
     <ROW Property="WindowsTypeNT5X" MultiBuildValue="DefaultBuild:Windows XP/2003" ValueLocId="-"/>
     <ROW Property="WindowsTypeNT5XDisplay" MultiBuildValue="DefaultBuild:Windows XP/2003" ValueLocId="-"/>
-    <ROW Property="WindowsTypeNT64" MultiBuildValue="DefaultBuild:Windows Vista x64, Windows Server 2008 x64, Windows 7 x64, Windows Server 2008 R2 x64, Windows 8 x64, Windows 8.1 x64" ValueLocId="-"/>
-    <ROW Property="WindowsTypeNT64Display" MultiBuildValue="DefaultBuild:Windows Vista x64, Windows Server 2008 x64, Windows 7 x64, Windows Server 2008 R2 x64, Windows 8 x64, Windows 8.1 x64" ValueLocId="-"/>
+    <ROW Property="WindowsTypeNT60" MultiBuildValue="DefaultBuild:Windows Vista/Server 2008" ValueLocId="-"/>
+    <ROW Property="WindowsTypeNT60Display" MultiBuildValue="DefaultBuild:Windows Vista/Server 2008" ValueLocId="-"/>
+    <ROW Property="WindowsTypeNT64" MultiBuildValue="DefaultBuild:Windows 7 x64, Windows Server 2008 R2 x64, Windows 8 x64, Windows 8.1 x64" ValueLocId="-"/>
+    <ROW Property="WindowsTypeNT64Display" MultiBuildValue="DefaultBuild:Windows 7 x64, Windows Server 2008 R2 x64, Windows 8 x64, Windows 8.1 x64" ValueLocId="-"/>
     <ROW Property="WindowsTypeNTDisplay" MultiBuildValue="DefaultBuild:32-bit Windows versions" ValueLocId="-"/>
   </COMPONENT>
   <COMPONENT cid="caphyon.advinst.msicomp.MsiDirsComponent">
@@ -167,6 +166,10 @@
   <COMPONENT cid="caphyon.advinst.msicomp.BootstrOptComponent">
     <ROW BootstrOptKey="GlobalOptions" DownloadFolder="[AppDataFolder][|Manufacturer]\[|ProductName]\prerequisites" Options="2"/>
   </COMPONENT>
+  <COMPONENT cid="caphyon.advinst.msicomp.BootstrapperUISequenceComponent">
+    <ROW Action="AI_BACKUP_AI_SETUPEXEPATH" Sequence="249"/>
+    <ROW Action="AI_RESTORE_AI_SETUPEXEPATH" Condition="AI_SETUPEXEPATH_ORIGINAL" Sequence="251"/>
+  </COMPONENT>
   <COMPONENT cid="caphyon.advinst.msicomp.BuildComponent">
     <ROW BuildKey="DefaultBuild" BuildName="DefaultBuild" BuildOrder="1" BuildType="0" PackageFileName="htmldoc-VERSION-windows" Languages="en" InstallationType="4" UseLargeSchema="true" MsiPackageType="x64"/>
   </COMPONENT>
@@ -192,8 +195,14 @@
     <ROW Fragment="VerifyRepairDlg.aip" Path="&lt;AI_THEMES&gt;classic\fragments\VerifyRepairDlg.aip"/>
     <ROW Fragment="WelcomeDlg.aip" Path="&lt;AI_THEMES&gt;classic\fragments\WelcomeDlg.aip"/>
   </COMPONENT>
+  <COMPONENT cid="caphyon.advinst.msicomp.MsiActionTextComponent">
+    <ROW Action="AI_DeleteLzma" Description="Deleting files extracted from archive" DescriptionLocId="ActionText.Description.AI_DeleteLzma" TemplateLocId="-"/>
+    <ROW Action="AI_DeleteRLzma" Description="Deleting files extracted from archive" DescriptionLocId="ActionText.Description.AI_DeleteLzma" TemplateLocId="-"/>
+    <ROW Action="AI_ExtractLzma" Description="Extracting files from archive" DescriptionLocId="ActionText.Description.AI_ExtractLzma" TemplateLocId="-"/>
+  </COMPONENT>
   <COMPONENT cid="caphyon.advinst.msicomp.MsiBinaryComponent">
     <ROW Name="aicustact.dll" SourcePath="&lt;AI_CUSTACTS&gt;aicustact.dll"/>
+    <ROW Name="lzmaextractor.dll" SourcePath="&lt;AI_CUSTACTS&gt;lzmaextractor.dll"/>
   </COMPONENT>
   <COMPONENT cid="caphyon.advinst.msicomp.MsiControlEventComponent">
     <ROW Dialog_="WelcomeDlg" Control_="Next" Event="NewDialog" Argument="FolderDlg" Condition="AI_INSTALL" Ordering="1"/>
@@ -224,12 +233,21 @@
     <ROW Directory_="APPDIR" Component_="APPDIR" ManualDelete="true"/>
   </COMPONENT>
   <COMPONENT cid="caphyon.advinst.msicomp.MsiCustActComponent">
+    <ROW Action="AI_BACKUP_AI_SETUPEXEPATH" Type="51" Source="AI_SETUPEXEPATH_ORIGINAL" Target="[AI_SETUPEXEPATH]"/>
     <ROW Action="AI_DOWNGRADE" Type="19" Target="4010"/>
+    <ROW Action="AI_DeleteCadLzma" Type="51" Source="AI_DeleteLzma" Target="[AI_SETUPEXEPATH]"/>
+    <ROW Action="AI_DeleteLzma" Type="1025" Source="lzmaextractor.dll" Target="DeleteLZMAFiles"/>
+    <ROW Action="AI_DeleteRCadLzma" Type="51" Source="AI_DeleteRLzma" Target="[AI_SETUPEXEPATH]"/>
+    <ROW Action="AI_DeleteRLzma" Type="1281" Source="lzmaextractor.dll" Target="DeleteLZMAFiles"/>
     <ROW Action="AI_DpiContentScale" Type="1" Source="aicustact.dll" Target="DpiContentScale"/>
     <ROW Action="AI_EnableDebugLog" Type="321" Source="aicustact.dll" Target="EnableDebugLog"/>
+    <ROW Action="AI_ExtractCadLzma" Type="51" Source="AI_ExtractLzma" Target="[AI_SETUPEXEPATH]"/>
+    <ROW Action="AI_ExtractLzma" Type="1025" Source="lzmaextractor.dll" Target="ExtractLZMAFiles"/>
+    <ROW Action="AI_FindExeLzma" Type="1" Source="lzmaextractor.dll" Target="FindEXE"/>
     <ROW Action="AI_InstallModeCheck" Type="1" Source="aicustact.dll" Target="UpdateInstallMode" WithoutSeq="true"/>
     <ROW Action="AI_PREPARE_UPGRADE" Type="65" Source="aicustact.dll" Target="PrepareUpgrade"/>
     <ROW Action="AI_PRESERVE_INSTALL_TYPE" Type="65" Source="aicustact.dll" Target="PreserveInstallType"/>
+    <ROW Action="AI_RESTORE_AI_SETUPEXEPATH" Type="51" Source="AI_SETUPEXEPATH" Target="[AI_SETUPEXEPATH_ORIGINAL]"/>
     <ROW Action="AI_RESTORE_LOCATION" Type="65" Source="aicustact.dll" Target="RestoreLocation"/>
     <ROW Action="AI_ResolveKnownFolders" Type="1" Source="aicustact.dll" Target="AI_ResolveKnownFolders"/>
     <ROW Action="AI_SHOW_LOG" Type="65" Source="aicustact.dll" Target="LaunchLogFile" WithoutSeq="true"/>
@@ -272,6 +290,15 @@
     <ROW Action="AI_PREPARE_UPGRADE" Condition="AI_UPGRADE=&quot;No&quot; AND (Not Installed)" Sequence="1399"/>
     <ROW Action="AI_ResolveKnownFolders" Sequence="52"/>
     <ROW Action="AI_EnableDebugLog" Sequence="51"/>
+    <ROW Action="AI_BACKUP_AI_SETUPEXEPATH" Sequence="99" Builds="DefaultBuild"/>
+    <ROW Action="AI_RESTORE_AI_SETUPEXEPATH" Condition="AI_SETUPEXEPATH_ORIGINAL" Sequence="101" Builds="DefaultBuild"/>
+    <ROW Action="AI_DeleteCadLzma" Condition="SETUPEXEDIR=&quot;&quot; AND Installed AND (REMOVE&lt;&gt;&quot;ALL&quot;) AND (AI_INSTALL_MODE&lt;&gt;&quot;Remove&quot;) AND (NOT PATCH)" Sequence="199" Builds="DefaultBuild"/>
+    <ROW Action="AI_DeleteRCadLzma" Condition="SETUPEXEDIR=&quot;&quot; AND Installed AND (REMOVE&lt;&gt;&quot;ALL&quot;) AND (AI_INSTALL_MODE&lt;&gt;&quot;Remove&quot;) AND (NOT PATCH)" Sequence="198" Builds="DefaultBuild"/>
+    <ROW Action="AI_ExtractCadLzma" Condition="SETUPEXEDIR=&quot;&quot; AND Installed AND (REMOVE&lt;&gt;&quot;ALL&quot;) AND (AI_INSTALL_MODE&lt;&gt;&quot;Remove&quot;) AND (NOT PATCH)" Sequence="197" Builds="DefaultBuild"/>
+    <ROW Action="AI_FindExeLzma" Condition="SETUPEXEDIR=&quot;&quot; AND Installed AND (REMOVE&lt;&gt;&quot;ALL&quot;) AND (AI_INSTALL_MODE&lt;&gt;&quot;Remove&quot;) AND (NOT PATCH)" Sequence="196" Builds="DefaultBuild"/>
+    <ROW Action="AI_ExtractLzma" Condition="SETUPEXEDIR=&quot;&quot; AND Installed AND (REMOVE&lt;&gt;&quot;ALL&quot;) AND (AI_INSTALL_MODE&lt;&gt;&quot;Remove&quot;) AND (NOT PATCH)" Sequence="1549" Builds="DefaultBuild"/>
+    <ROW Action="AI_DeleteRLzma" Condition="SETUPEXEDIR=&quot;&quot; AND Installed AND (REMOVE&lt;&gt;&quot;ALL&quot;) AND (AI_INSTALL_MODE&lt;&gt;&quot;Remove&quot;) AND (NOT PATCH)" Sequence="1548" Builds="DefaultBuild"/>
+    <ROW Action="AI_DeleteLzma" Condition="SETUPEXEDIR=&quot;&quot; AND Installed AND (REMOVE&lt;&gt;&quot;ALL&quot;) AND (AI_INSTALL_MODE&lt;&gt;&quot;Remove&quot;) AND (NOT PATCH)" Sequence="6599" Builds="DefaultBuild"/>
   </COMPONENT>
   <COMPONENT cid="caphyon.advinst.msicomp.MsiInstallUISequenceComponent">
     <ROW Action="AI_RESTORE_LOCATION" Condition="APPDIR=&quot;&quot;" Sequence="749"/>
@@ -279,13 +306,16 @@
     <ROW Action="AI_DpiContentScale" Sequence="52"/>
     <ROW Action="AI_EnableDebugLog" Sequence="51"/>
     <ROW Action="AI_PRESERVE_INSTALL_TYPE" Sequence="199"/>
+    <ROW Action="AI_BACKUP_AI_SETUPEXEPATH" Sequence="99"/>
+    <ROW Action="AI_RESTORE_AI_SETUPEXEPATH" Condition="AI_SETUPEXEPATH_ORIGINAL" Sequence="101"/>
   </COMPONENT>
   <COMPONENT cid="caphyon.advinst.msicomp.MsiLaunchConditionsComponent">
-    <ROW Condition="( Version9X OR ( NOT VersionNT64 ) OR ( VersionNT64 AND ((VersionNT64 &lt;&gt; 600) OR (MsiNTProductType &lt;&gt; 1)) AND ((VersionNT64 &lt;&gt; 600) OR (MsiNTProductType = 1)) AND ((VersionNT64 &lt;&gt; 601) OR (MsiNTProductType &lt;&gt; 1)) AND ((VersionNT64 &lt;&gt; 601) OR (MsiNTProductType = 1)) AND ((VersionNT64 &lt;&gt; 602) OR (MsiNTProductType &lt;&gt; 1)) AND ((VersionNT64 &lt;&gt; 603) OR (MsiNTProductType &lt;&gt; 1)) ) )" Description="[ProductName] cannot be installed on the following Windows versions: [WindowsTypeNT64Display]." DescriptionLocId="AI.LaunchCondition.NoSpecificNT64" IsPredefined="true" Builds="DefaultBuild"/>
+    <ROW Condition="( Version9X OR ( NOT VersionNT64 ) OR ( VersionNT64 AND ((VersionNT64 &lt;&gt; 601) OR (MsiNTProductType &lt;&gt; 1)) AND ((VersionNT64 &lt;&gt; 601) OR (MsiNTProductType = 1)) AND ((VersionNT64 &lt;&gt; 602) OR (MsiNTProductType &lt;&gt; 1)) AND ((VersionNT64 &lt;&gt; 603) OR (MsiNTProductType &lt;&gt; 1)) ) )" Description="[ProductName] cannot be installed on the following Windows versions: [WindowsTypeNT64Display]." DescriptionLocId="AI.LaunchCondition.NoSpecificNT64" IsPredefined="true" Builds="DefaultBuild"/>
     <ROW Condition="( Version9X OR VersionNT64 )" Description="[ProductName] cannot be installed on [WindowsTypeNTDisplay]." DescriptionLocId="AI.LaunchCondition.NoNT" IsPredefined="true" Builds="DefaultBuild"/>
     <ROW Condition="((VersionNT &lt;&gt; 501) AND (VersionNT &lt;&gt; 502))" Description="[ProductName] cannot be installed on [WindowsTypeNT5XDisplay]." DescriptionLocId="AI.LaunchCondition.NoNT5X" IsPredefined="true" Builds="DefaultBuild"/>
     <ROW Condition="(VersionNT &lt;&gt; 400)" Description="[ProductName] cannot be installed on [WindowsTypeNT40Display]." DescriptionLocId="AI.LaunchCondition.NoNT40" IsPredefined="true" Builds="DefaultBuild"/>
     <ROW Condition="(VersionNT &lt;&gt; 500)" Description="[ProductName] cannot be installed on [WindowsTypeNT50Display]." DescriptionLocId="AI.LaunchCondition.NoNT50" IsPredefined="true" Builds="DefaultBuild"/>
+    <ROW Condition="(VersionNT &lt;&gt; 600)" Description="[ProductName] cannot be installed on [WindowsTypeNT60Display]." DescriptionLocId="AI.LaunchCondition.NoNT60" IsPredefined="true" Builds="DefaultBuild"/>
     <ROW Condition="VersionNT" Description="[ProductName] cannot be installed on [WindowsType9XDisplay]." DescriptionLocId="AI.LaunchCondition.No9X" IsPredefined="true" Builds="DefaultBuild"/>
   </COMPONENT>
   <COMPONENT cid="caphyon.advinst.msicomp.MsiMergeModsComponent">
diff -pruN 1.9.19-1/vcnet/htmldoc.vcxproj 1.9.20-1/vcnet/htmldoc.vcxproj
--- 1.9.19-1/vcnet/htmldoc.vcxproj	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/vcnet/htmldoc.vcxproj	2024-12-09 16:25:48.000000000 +0000
@@ -1,6 +1,6 @@
 ﻿<?xml version="1.0" encoding="utf-8"?>
 <Project DefaultTargets="Build" ToolsVersion="15.0" xmlns="http://schemas.microsoft.com/developer/msbuild/2003">
-  <Import Project="packages\libcups2_native.2.4.3.4\build\native\libcups2_native.props" Condition="Exists('packages\libcups2_native.2.4.3.4\build\native\libcups2_native.props')" />
+  <Import Project="packages\libcups2_native.2.4.11.1\build\native\libcups2_native.props" Condition="Exists('packages\libcups2_native.2.4.11.1\build\native\libcups2_native.props')" />
   <Import Project="packages\libjpeg-turbo-v142.2.0.4.3\build\native\libjpeg-turbo-v142.props" Condition="Exists('packages\libjpeg-turbo-v142.2.0.4.3\build\native\libjpeg-turbo-v142.props')" />
   <ItemGroup Label="ProjectConfigurations">
     <ProjectConfiguration Include="Debug|x64">
@@ -70,7 +70,7 @@
       <Culture>0x0409</Culture>
     </ResourceCompile>
     <Link>
-      <AdditionalDependencies>packages\libcups2_native.2.4.3.4\build\native\lib\x64\Release\libcups2.lib;packages\libpng_native.1.6.30\build\native\lib\x64\Release\libpng16.lib;packages\libjpeg-turbo-v142.2.0.4.3\build\native\lib\x64\v142\Release\jpeg.lib;packages\zlib_native.1.2.11\build\native\lib\x64\Release\zlib.lib;comctl32.lib;ws2_32.lib;%(AdditionalDependencies)</AdditionalDependencies>
+      <AdditionalDependencies>packages\libcups2_native.2.4.11.1\build\native\lib\x64\Release\libcups2.lib;packages\libpng_native.1.6.30\build\native\lib\x64\Release\libpng16.lib;packages\libjpeg-turbo-v142.2.0.4.3\build\native\lib\x64\v142\Release\jpeg.lib;packages\zlib_native.1.2.11\build\native\lib\x64\Release\zlib.lib;comctl32.lib;ws2_32.lib;%(AdditionalDependencies)</AdditionalDependencies>
       <OutputFile>$(OutDir)htmldoc.exe</OutputFile>
       <SuppressStartupBanner>true</SuppressStartupBanner>
       <IgnoreSpecificDefaultLibraries>libcmt.lib;%(IgnoreSpecificDefaultLibraries)</IgnoreSpecificDefaultLibraries>
@@ -112,7 +112,7 @@
       <Culture>0x0409</Culture>
     </ResourceCompile>
     <Link>
-      <AdditionalDependencies>packages\libcups2_native.2.4.3.4\build\native\lib\x64\Release\libcups2.lib;packages\libpng_native.1.6.30\build\native\lib\x64\Release\libpng16.lib;packages\libjpeg-turbo-v142.2.0.4.3\build\native\lib\x64\v142\Release\jpeg.lib;packages\zlib_native.1.2.11\build\native\lib\x64\Release\zlib.lib;comctl32.lib;ws2_32.lib;%(AdditionalDependencies)</AdditionalDependencies>
+      <AdditionalDependencies>packages\libcups2_native.2.4.11.1\build\native\lib\x64\Release\libcups2.lib;packages\libpng_native.1.6.30\build\native\lib\x64\Release\libpng16.lib;packages\libjpeg-turbo-v142.2.0.4.3\build\native\lib\x64\v142\Release\jpeg.lib;packages\zlib_native.1.2.11\build\native\lib\x64\Release\zlib.lib;comctl32.lib;ws2_32.lib;%(AdditionalDependencies)</AdditionalDependencies>
       <OutputFile>$(OutDir)htmldocd.exe</OutputFile>
       <SuppressStartupBanner>true</SuppressStartupBanner>
       <IgnoreSpecificDefaultLibraries>libcmtd.lib;%(IgnoreSpecificDefaultLibraries)</IgnoreSpecificDefaultLibraries>
diff -pruN 1.9.19-1/vcnet/make-manual.bat 1.9.20-1/vcnet/make-manual.bat
--- 1.9.19-1/vcnet/make-manual.bat	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/vcnet/make-manual.bat	2024-12-09 16:25:48.000000000 +0000
@@ -5,7 +5,7 @@
 ::    .\make-manual.bat x64\{Debug,Release} {htmldoc.exe,htmldocd.exe}
 ::
 
-copy packages\libcups2_native.redist.2.4.3.4\build\native\bin\x64\Release\*.dll x64\%1
+copy packages\libcups2_native.redist.2.4.11.1\build\native\bin\x64\Release\*.dll x64\%1
 copy packages\libjpeg-turbo-v142.2.0.4.3\build\native\bin\x64\v142\Release\*.dll x64\%1
 copy packages\libpng_native.redist.1.6.30\build\native\bin\x64\Release\*.dll x64\%1
 copy packages\libressl_native.redist.3.7.3\build\native\bin\x64\Release\*.dll x64\%1
diff -pruN 1.9.19-1/vcnet/packages.config 1.9.20-1/vcnet/packages.config
--- 1.9.19-1/vcnet/packages.config	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/vcnet/packages.config	2024-12-09 16:25:48.000000000 +0000
@@ -1,8 +1,8 @@
 ﻿<?xml version="1.0" encoding="utf-8"?>
 <packages>
   <package id="fltk_native" version="1.3.7" targetFramework="native" />
-  <package id="libcups2_native" version="2.4.3.4" targetFramework="native" />
-  <package id="libcups2_native.redist" version="2.4.3.4" targetFramework="native" />
+  <package id="libcups2_native" version="2.4.11.1" targetFramework="native" />
+  <package id="libcups2_native.redist" version="2.4.11.1" targetFramework="native" />
   <package id="libjpeg-turbo-v142" version="2.0.4.3" targetFramework="native" />
   <package id="libpng_native" version="1.6.30" targetFramework="native" />
   <package id="libpng_native.redist" version="1.6.30" targetFramework="native" />
diff -pruN 1.9.19-1/xcode/config.h 1.9.20-1/xcode/config.h
--- 1.9.19-1/xcode/config.h	2024-11-21 20:23:51.000000000 +0000
+++ 1.9.20-1/xcode/config.h	2024-12-09 16:25:48.000000000 +0000
@@ -12,7 +12,7 @@
  * What is the version number for this software?
  */
 
-#define SVERSION "1.9.19"
+#define SVERSION "1.9.20"
 
 
 /*
