diff -pruN 1.0.4-3/Language/Haskell/Lexer.hs 1.0.4.1-1/Language/Haskell/Lexer.hs
--- 1.0.4-3/Language/Haskell/Lexer.hs	2001-09-09 01:46:40.000000000 +0000
+++ 1.0.4.1-1/Language/Haskell/Lexer.hs	2001-09-09 01:46:40.000000000 +0000
@@ -171,8 +171,10 @@ isSymbol c = c `elem` ":!#%&*./?@\\-" ||
 
 matchChar :: Char -> String -> Lex a ()
 matchChar c msg = do
-        s <- getInput
-        if null s || head s /= c then fail msg else discard 1
+  s <- getInput
+  case s of
+    c':_ | c == c' -> discard 1
+    _ -> fail msg
 
 -- The top-level lexer.
 -- We need to know whether we are at the beginning of the line to decide
diff -pruN 1.0.4-3/changelog.md 1.0.4.1-1/changelog.md
--- 1.0.4-3/changelog.md	2001-09-09 01:46:40.000000000 +0000
+++ 1.0.4.1-1/changelog.md	2001-09-09 01:46:40.000000000 +0000
@@ -1,3 +1,17 @@
+## 1.0.4.1
+
+_Andreas Abel, 2024-09-22_
+
+  - Replace use of `head` to pacify `-Wx-partial`.
+  - Remove upper bound on `happy`.
+  - Tested with GHC 8.0 - 9.10.1.
+
+## 1.0.4 Revision 1
+
+_Andreas Abel, 2022-05-25_
+
+  - Support GHC 9.4, allow base-4.17 and higher.
+
 ## 1.0.4
 
 _Andreas Abel, 2022-02-07_
diff -pruN 1.0.4-3/debian/changelog 1.0.4.1-1/debian/changelog
--- 1.0.4-3/debian/changelog	2024-09-17 10:32:59.000000000 +0000
+++ 1.0.4.1-1/debian/changelog	2024-10-19 15:36:10.000000000 +0000
@@ -1,3 +1,9 @@
+haskell-haskell-src (1.0.4.1-1) unstable; urgency=medium
+
+  * New upstream release
+
+ -- Ilias Tsitsimpis <iliastsi@debian.org>  Sat, 19 Oct 2024 18:36:10 +0300
+
 haskell-haskell-src (1.0.4-3) unstable; urgency=medium
 
   * Declare compliance with Debian policy 4.7.0
diff -pruN 1.0.4-3/debian/patches/newer-deps 1.0.4.1-1/debian/patches/newer-deps
--- 1.0.4-3/debian/patches/newer-deps	2023-10-10 19:05:07.000000000 +0000
+++ 1.0.4.1-1/debian/patches/newer-deps	1970-01-01 00:00:00.000000000 +0000
@@ -1,44 +0,0 @@
-Index: b/haskell-src.cabal
-===================================================================
---- a/haskell-src.cabal
-+++ b/haskell-src.cabal
-@@ -2,6 +2,7 @@ cabal-version:  >=1.10
- name:           haskell-src
- -- don't forget to update the changelog.md!
- version:        1.0.4
-+x-revision:     1
- build-type:     Simple
- 
- license:        BSD3
-@@ -20,7 +21,8 @@ description:
-     <http://www.haskell.org/onlinereport/ Haskell 98> code.
- 
- tested-with:
--  GHC == 9.2.1
-+  GHC == 9.4.1
-+  GHC == 9.2.2
-   GHC == 9.0.2
-   GHC == 8.10.7
-   GHC == 8.8.4
-@@ -50,13 +52,16 @@ library
-         Language.Haskell.Syntax,
-         Language.Haskell.ParseUtils
- 
--  build-depends: base    >= 4.3 && < 4.17
--               , syb     >= 0.1 && < 0.8
--               , pretty  >= 1.0.1.2 && < 1.2
--               , array   >= 0.3 && < 0.6
-+  build-depends:   base       >= 4.3     && < 5
-+                     -- no confirmed upper bound on base yet
-+                 , syb        >= 0.1     && < 0.8
-+                 , pretty     >= 1.0.1.2 && < 1.2
-+                 , array      >= 0.3     && < 0.6
- 
-   if !impl(ghc >= 8.0)
--    build-depends: semigroups == 0.18.*, fail == 4.9.*
-+    build-depends: fail       == 4.9.*
-+                 , semigroups == 0.18.*
-+                     -- semigroups >= 0.19 does not build with ghc < 8
-   else
-     ghc-options: -Wcompat -Wnoncanonical-monad-instances
- 
diff -pruN 1.0.4-3/debian/patches/series 1.0.4.1-1/debian/patches/series
--- 1.0.4-3/debian/patches/series	2023-10-10 19:05:07.000000000 +0000
+++ 1.0.4.1-1/debian/patches/series	1970-01-01 00:00:00.000000000 +0000
@@ -1 +0,0 @@
-newer-deps
diff -pruN 1.0.4-3/haskell-src.cabal 1.0.4.1-1/haskell-src.cabal
--- 1.0.4-3/haskell-src.cabal	2001-09-09 01:46:40.000000000 +0000
+++ 1.0.4.1-1/haskell-src.cabal	2001-09-09 01:46:40.000000000 +0000
@@ -1,7 +1,7 @@
 cabal-version:  >=1.10
 name:           haskell-src
 -- don't forget to update the changelog.md!
-version:        1.0.4
+version:        1.0.4.1
 build-type:     Simple
 
 license:        BSD3
@@ -20,7 +20,11 @@ description:
     <http://www.haskell.org/onlinereport/ Haskell 98> code.
 
 tested-with:
-  GHC == 9.2.1
+  GHC == 9.10.1
+  GHC == 9.8.2
+  GHC == 9.6.6
+  GHC == 9.4.8
+  GHC == 9.2.8
   GHC == 9.0.2
   GHC == 8.10.7
   GHC == 8.8.4
@@ -28,12 +32,6 @@ tested-with:
   GHC == 8.4.4
   GHC == 8.2.2
   GHC == 8.0.2
-  GHC == 7.10.3
-  GHC == 7.8.4
-  GHC == 7.6.3
-  GHC == 7.4.2
-  GHC == 7.2.2
-  GHC == 7.0.4
 
 extra-source-files: changelog.md
 
@@ -50,17 +48,20 @@ library
         Language.Haskell.Syntax,
         Language.Haskell.ParseUtils
 
-  build-depends: base    >= 4.3 && < 4.17
-               , syb     >= 0.1 && < 0.8
-               , pretty  >= 1.0.1.2 && < 1.2
-               , array   >= 0.3 && < 0.6
+  build-depends:   base       >= 4.3     && < 5
+                     -- no confirmed upper bound on base yet
+                 , syb        >= 0.1     && < 0.8
+                 , pretty     >= 1.0.1.2 && < 1.2
+                 , array      >= 0.3     && < 0.6
 
   if !impl(ghc >= 8.0)
-    build-depends: semigroups == 0.18.*, fail == 4.9.*
+    build-depends: fail       == 4.9.*
+                 , semigroups == 0.18.*
+                     -- semigroups >= 0.19 does not build with ghc < 8
   else
     ghc-options: -Wcompat -Wnoncanonical-monad-instances
 
-  build-tools: happy >= 1.19 && < 1.22
+  build-tools: happy >= 1.19
 
   default-language: Haskell98
 
