diff -pruN 0.7.1.1-8/Data/Default.hs 0.7.1.2-1/Data/Default.hs
--- 0.7.1.1-8/Data/Default.hs	2016-06-25 23:01:25.000000000 +0000
+++ 0.7.1.2-1/Data/Default.hs	2001-09-09 01:46:40.000000000 +0000
@@ -1,38 +1,47 @@
 {-
 
-Copyright (c) 2013 Lukas Mai
+Copyright (c) 2013, Lukas Mai
 
 All rights reserved.
 
-Redistribution and use in source and binary forms, with or without modification,
-are permitted provided that the following conditions are met:
+Redistribution and use in source and binary forms, with or without
+modification, are permitted provided that the following conditions are met:
 
-* Redistributions of source code must retain the above copyright notice, this
-  list of conditions and the following disclaimer.
-* Redistributions in binary form must reproduce the above copyright notice,
-  this list of conditions and the following disclaimer in the documentation
-  and/or other materials provided with the distribution.
-* Neither the name of the author nor the names of his contributors
-  may be used to endorse or promote products derived from this software
-  without specific prior written permission.
-
-THIS SOFTWARE IS PROVIDED BY LUKAS MAI AND CONTRIBUTORS "AS IS" AND ANY
-EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
-WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
-DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
-DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
-(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
-LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
-ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
-(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
-SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
+    * Redistributions of source code must retain the above copyright
+      notice, this list of conditions and the following disclaimer.
+
+    * Redistributions in binary form must reproduce the above
+      copyright notice, this list of conditions and the following
+      disclaimer in the documentation and/or other materials provided
+      with the distribution.
+
+    * Neither the name of Lukas Mai nor the names of other
+      contributors may be used to endorse or promote products derived
+      from this software without specific prior written permission.
+
+THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
+"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
+LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
+A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
+OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
+SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
+LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
+DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
+THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
+(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
+OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 -}
 
+{-|
+Module      : Data.Default
+Description : Defines a class for types with a default value.
+
+This module defines a class for types with a default value. Instances are
+provided for '()', 'Data.Set.Set', 'Data.Map.Map', 'Int', 'Integer',
+'Float', 'Double', and many others (see below).
+-}
 module Data.Default (
--- | This module defines a class for types with a default value. Instances are
--- provided for '()', 'Data.Set.Set', 'Data.Map.Map', 'Int', 'Integer',
--- 'Float', 'Double', and many others (see below).
     Default(..)
 ) where
 
diff -pruN 0.7.1.1-8/LICENSE 0.7.1.2-1/LICENSE
--- 0.7.1.1-8/LICENSE	2016-06-25 23:01:25.000000000 +0000
+++ 0.7.1.2-1/LICENSE	2001-09-09 01:46:40.000000000 +0000
@@ -1,26 +1,30 @@
-Copyright (c) 2013 Lukas Mai
+Copyright (c) 2013, Lukas Mai
 
 All rights reserved.
 
-Redistribution and use in source and binary forms, with or without modification,
-are permitted provided that the following conditions are met:
+Redistribution and use in source and binary forms, with or without
+modification, are permitted provided that the following conditions are met:
 
-* Redistributions of source code must retain the above copyright notice, this
-  list of conditions and the following disclaimer.
-* Redistributions in binary form must reproduce the above copyright notice,
-  this list of conditions and the following disclaimer in the documentation
-  and/or other materials provided with the distribution.
-* Neither the name of the author nor the names of his contributors
-  may be used to endorse or promote products derived from this software
-  without specific prior written permission.
-
-THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
-ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
-WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
-DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
-FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
-DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
-SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
-CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
-OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
+    * Redistributions of source code must retain the above copyright
+      notice, this list of conditions and the following disclaimer.
+
+    * Redistributions in binary form must reproduce the above
+      copyright notice, this list of conditions and the following
+      disclaimer in the documentation and/or other materials provided
+      with the distribution.
+
+    * Neither the name of Lukas Mai nor the names of other
+      contributors may be used to endorse or promote products derived
+      from this software without specific prior written permission.
+
+THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
+"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
+LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
+A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
+OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
+SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
+LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
+DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
+THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
+(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
diff -pruN 0.7.1.1-8/data-default.cabal 0.7.1.2-1/data-default.cabal
--- 0.7.1.1-8/data-default.cabal	2016-06-25 23:01:25.000000000 +0000
+++ 0.7.1.2-1/data-default.cabal	2001-09-09 01:46:40.000000000 +0000
@@ -1,21 +1,30 @@
-Name:            data-default
-Version:         0.7.1.1
-Cabal-Version:   >= 1.6
-Category:        Data
-Synopsis:        A class for types with a default value
-Build-Type:      Simple
-License:         BSD3
-License-File:    LICENSE
-Author:          Lukas Mai
-Maintainer:      <l.mai@web.de>
+cabal-version:   3.0
+name:            data-default
+version:         0.7.1.2
+category:        Data
+synopsis:        A class for types with a default value
+build-type:      Simple
+license:         BSD-3-Clause
+license-file:    LICENSE
+copyright:       (c) 2013 Lukas Mai
+author:          Lukas Mai
+maintainer:      <lukasmai.403+hackage@gmail.com>
 
 source-repository head
-  type: git
-  location: https://github.com/mauke/data-default
+    type: git
+    location: https://github.com/mauke/data-default
 
-Library
-  Build-Depends:     base >=2 && <5, data-default-class >=0.1.2.0,
-                     data-default-instances-containers,
-                     data-default-instances-dlist,
-                     data-default-instances-old-locale
-  Exposed-Modules:   Data.Default
+library
+    build-depends:     base >=2 && <5, data-default-class ^>=0.1.2.0,
+                       data-default-instances-containers,
+                       data-default-instances-dlist,
+                       data-default-instances-old-locale
+    exposed-modules:   Data.Default
+    default-language:  Haskell98
+
+test-suite test
+    type:              exitcode-stdio-1.0
+    main-is:           basics.hs
+    build-depends:     base >=2 && <5, containers, data-default, mtl, old-locale
+    hs-source-dirs:    t
+    default-language:  Haskell98
diff -pruN 0.7.1.1-8/debian/changelog 0.7.1.2-1/debian/changelog
--- 0.7.1.1-8/debian/changelog	2024-09-21 09:48:59.000000000 +0000
+++ 0.7.1.2-1/debian/changelog	2024-10-19 15:24:23.000000000 +0000
@@ -1,3 +1,9 @@
+haskell-data-default (0.7.1.2-1) unstable; urgency=medium
+
+  * New upstream release
+
+ -- Ilias Tsitsimpis <iliastsi@debian.org>  Sat, 19 Oct 2024 18:24:23 +0300
+
 haskell-data-default (0.7.1.1-8) unstable; urgency=medium
 
   * Declare compliance with Debian policy 4.7.0
diff -pruN 0.7.1.1-8/debian/control 0.7.1.2-1/debian/control
--- 0.7.1.1-8/debian/control	2024-09-14 15:41:14.000000000 +0000
+++ 0.7.1.2-1/debian/control	2024-10-19 15:24:23.000000000 +0000
@@ -10,6 +10,7 @@ Build-Depends: debhelper (>= 10),
  ghc (>= 9.4),
  ghc-prof,
  libghc-data-default-class-dev (>= 0.1.2.0),
+ libghc-data-default-class-dev (<< 0.2),
  libghc-data-default-class-prof,
  libghc-data-default-instances-containers-dev,
  libghc-data-default-instances-containers-prof,
diff -pruN 0.7.1.1-8/t/basics.hs 0.7.1.2-1/t/basics.hs
--- 0.7.1.1-8/t/basics.hs	1970-01-01 00:00:00.000000000 +0000
+++ 0.7.1.2-1/t/basics.hs	2001-09-09 01:46:40.000000000 +0000
@@ -0,0 +1,98 @@
+{-# LANGUAGE GeneralizedNewtypeDeriving #-}
+
+import Data.Default
+import Data.Int
+import Data.Word
+import Data.Monoid
+import Data.Complex
+import System.Locale
+import qualified Data.Sequence as Seq
+import qualified Data.Map as M
+import qualified Data.Set as S
+import qualified Data.IntMap as IM
+import qualified Data.IntSet as IS
+import Data.Tree (Tree(..))
+
+import Control.Monad (when)
+import Control.Monad.Reader
+import Data.IORef
+import System.Exit (exitFailure)
+import System.IO
+
+newtype Test a = Test{ unTest :: ReaderT (IORef Int) IO a }
+    deriving (Functor, Applicative, Monad, MonadIO, MonadReader (IORef Int))
+
+runTest :: (MonadIO m) => Test a -> m a
+runTest t = liftIO $ do
+    hSetBuffering stdout LineBuffering
+    r <- newIORef 1
+    runReaderT (unTest t) r
+
+instance (Default a) => Default (Test a) where
+    def = return def
+
+withRef :: (IORef Int -> IO a) -> Test a
+withRef f = do
+    r <- ask
+    liftIO (f r)
+
+planTests :: Int -> Test ()
+planTests n = liftIO $ do
+    putStrLn $ "1.." ++ show n
+
+ok :: Bool -> String -> Test ()
+ok b s = withRef $ \r -> do
+    c <- atomicModifyIORef r ((,) =<< succ)
+    putStrLn $ (if b then "" else "not ") ++ "ok " ++ show c ++ " - " ++ s
+    when (not b)
+        exitFailure
+
+is {-, isNot-} :: (Show a, Eq a) => a -> a -> Test ()
+is    x y = ok (x == y) (show x ++ " == " ++ show y)
+-- isNot x y = ok (x /= y) (show x ++ " /= " ++ show y)
+
+-- diag :: String -> Test ()
+-- diag s = liftIO $ do
+--     putStrLn $ "# " ++ s
+
+main :: IO ()
+main = runTest $ do
+    planTests 37
+    sequence_ [def, liftIO def, return ()]
+    is (def (length :: [a] -> Int)) (0 :: Int)
+    is def ()
+    is def (Nothing :: Maybe (Int, Ordering, [Float]))
+    is def ""
+    is def (S.empty :: S.Set ())
+    is def (M.empty :: M.Map () ())
+    is def IS.empty
+    is def (IM.empty :: IM.IntMap ())
+    is def (Seq.empty :: Seq.Seq ())
+    is def (Node (0 :: Complex Float) [])
+    is def EQ
+    is def (Any False)
+    is def (All True)
+    is def (Last Nothing :: Last ())
+    is def (First Nothing :: First ())
+    is def (Sum (0 :: Integer))
+    is def (Product (1 :: Rational))
+    is def (0 :: Int)
+    is def (0 :: Integer)
+    is def (0 :: Float)
+    is def (0 :: Double)
+    is def (0 :: Rational)
+    is def (0 :: Complex Double)
+    is def (0 :: Int8)
+    is def (0 :: Int16)
+    is def (0 :: Int32)
+    is def (0 :: Int64)
+    is def (0 :: Word)
+    is def (0 :: Word8)
+    is def (0 :: Word16)
+    is def (0 :: Word32)
+    is def (0 :: Word64)
+    is def ((def, def) :: ((), Maybe ((), ())))
+    is def ((def, def, def) :: ((), Maybe ((), ()), [Ordering]))
+    is def ((def, def, def, def) :: ((), Maybe ((), ()), [Ordering], Float))
+    is def ((def, def, def, def, def, def, def) :: ((), (), (), (), (), (), ()))
+    is def defaultTimeLocale
