diff -pruN 0.16.3+ds-2/.github/workflows/cifuzz.yaml 0.18.7-1/.github/workflows/cifuzz.yaml
--- 0.16.3+ds-2/.github/workflows/cifuzz.yaml	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/.github/workflows/cifuzz.yaml	2025-02-08 20:53:35.000000000 +0000
@@ -19,7 +19,7 @@ jobs:
         dry-run: false
         language: c++
     - name: Upload Crash
-      uses: actions/upload-artifact@v1
+      uses: actions/upload-artifact@v4
       if: failure() && steps.build.outcome == 'success'
       with:
         name: artifacts
diff -pruN 0.16.3+ds-2/.github/workflows/test.yaml 0.18.7-1/.github/workflows/test.yaml
--- 0.16.3+ds-2/.github/workflows/test.yaml	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/.github/workflows/test.yaml	2025-02-08 20:53:35.000000000 +0000
@@ -8,10 +8,10 @@ jobs:
     steps:
       - name: checkout
         uses: actions/checkout@v4
-      - name: install brotli
-        run: sudo apt-get update && sudo apt-get install -y libbrotli-dev
+      - name: install libraries
+        run: sudo apt-get update && sudo apt-get install -y libbrotli-dev libcurl4-openssl-dev
       - name: build and run tests
-        run: cd test && make -j4
+        run: cd test && make
       - name: run fuzz test target
         run: cd test && make fuzz_test
 
@@ -21,23 +21,45 @@ jobs:
       - name: checkout
         uses: actions/checkout@v4
       - name: build and run tests
-        run: |
-          cd test && make -j2
+        run: cd test && make
+      - name: run fuzz test target
+        run: cd test && make fuzz_test
 
   windows:
     runs-on: windows-latest
     steps:
-    - name: prepare git for checkout on windows
+    - name: Prepare Git for Checkout on Windows
       run: |
         git config --global core.autocrlf false
         git config --global core.eol lf
-    - name: checkout
+    - name: Checkout
       uses: actions/checkout@v4
-    - name: setup msbuild on windows
+    - name: Export GitHub Actions cache environment variables
+      uses: actions/github-script@v7
+      with:
+        script: |
+          core.exportVariable('ACTIONS_CACHE_URL', process.env.ACTIONS_CACHE_URL || '');
+          core.exportVariable('ACTIONS_RUNTIME_TOKEN', process.env.ACTIONS_RUNTIME_TOKEN || '');
+    - name: Setup msbuild on windows
       uses: microsoft/setup-msbuild@v2
-    - name: make-windows
+    - name: Install libraries
       run: |
-        cd test
-        msbuild.exe test.sln /verbosity:minimal /t:Build "/p:Configuration=Release;Platform=x64"
-        x64\Release\test.exe
+        vcpkg install gtest curl zlib brotli
+        choco install openssl
+
+    - name: Configure CMake with SSL
+      run: cmake -B build -S . -DCMAKE_BUILD_TYPE=Release -DCMAKE_TOOLCHAIN_FILE=${{ env.VCPKG_ROOT }}/scripts/buildsystems/vcpkg.cmake -DHTTPLIB_TEST=ON -DHTTPLIB_REQUIRE_OPENSSL=ON -DHTTPLIB_REQUIRE_ZLIB=ON -DHTTPLIB_REQUIRE_BROTLI=ON
+    - name: Build with with SSL
+      run: cmake --build build --config Release
+    - name: Run tests with SSL
+      run: ctest --output-on-failure --test-dir build -C Release
 
+    - name: Configure CMake without SSL
+      run: cmake -B build-no-ssl -S . -DCMAKE_BUILD_TYPE=Release -DCMAKE_TOOLCHAIN_FILE=${{ env.VCPKG_ROOT }}/scripts/buildsystems/vcpkg.cmake -DHTTPLIB_TEST=ON -DHTTPLIB_REQUIRE_OPENSSL=ON -DHTTPLIB_REQUIRE_ZLIB=ON -DHTTPLIB_REQUIRE_BROTLI=ON
+    - name: Build without SSL
+      run: cmake --build build-no-ssl --config Release
+    - name: Run tests without SSL
+      run: ctest --output-on-failure --test-dir build-no-ssl -C Release
+    env:
+      VCPKG_ROOT: "C:/vcpkg"
+      VCPKG_BINARY_SOURCES: "clear;x-gha,readwrite"
diff -pruN 0.16.3+ds-2/.gitignore 0.18.7-1/.gitignore
--- 0.16.3+ds-2/.gitignore	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/.gitignore	2025-02-08 20:53:35.000000000 +0000
@@ -9,6 +9,8 @@ example/benchmark
 example/redirect
 example/sse*
 example/upload
+example/one_time_request
+example/server_and_client
 example/*.pem
 test/httplib.cc
 test/httplib.h
@@ -21,6 +23,8 @@ test/test.xcodeproj/*/xcuser*
 test/*.o
 test/*.pem
 test/*.srl
+work/
+benchmark/server*
 
 *.swp
 
@@ -34,6 +38,7 @@ Release
 *.db
 ipch
 *.dSYM
+*.pyc
 .*
 !/.gitattributes
 !/.travis.yml
diff -pruN 0.16.3+ds-2/CMakeLists.txt 0.18.7-1/CMakeLists.txt
--- 0.16.3+ds-2/CMakeLists.txt	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/CMakeLists.txt	2025-02-08 20:53:35.000000000 +0000
@@ -299,6 +299,8 @@ if(HTTPLIB_INSTALL)
 	# ex: /usr/share/doc/httplib/README.md and /usr/share/licenses/httplib/LICENSE
 	install(FILES "README.md" DESTINATION "${CMAKE_INSTALL_DOCDIR}")
 	install(FILES "LICENSE" DESTINATION "${CMAKE_INSTALL_DATADIR}/licenses/${PROJECT_NAME}")
+
+	include(CPack)
 endif()
 
 if(HTTPLIB_TEST)
diff -pruN 0.16.3+ds-2/Dockerfile 0.18.7-1/Dockerfile
--- 0.16.3+ds-2/Dockerfile	1970-01-01 00:00:00.000000000 +0000
+++ 0.18.7-1/Dockerfile	2025-02-08 20:53:35.000000000 +0000
@@ -0,0 +1,11 @@
+FROM yhirose4dockerhub/ubuntu-builder AS builder
+WORKDIR /build
+COPY httplib.h .
+COPY docker/main.cc .
+RUN g++ -std=c++23 -static -o server -O2 -I. -DCPPHTTPLIB_USE_POLL main.cc && strip server
+
+FROM scratch
+COPY --from=builder /build/server /server
+COPY docker/html/index.html /html/index.html
+EXPOSE 80
+CMD ["/server"]
diff -pruN 0.16.3+ds-2/README.md 0.18.7-1/README.md
--- 0.16.3+ds-2/README.md	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/README.md	2025-02-08 20:53:35.000000000 +0000
@@ -39,10 +39,10 @@ svr.listen("0.0.0.0", 8080);
 #include "path/to/httplib.h"
 
 // HTTP
-httplib::Client cli("http://cpp-httplib-server.yhirose.repl.co");
+httplib::Client cli("http://yhirose.github.io");
 
 // HTTPS
-httplib::Client cli("https://cpp-httplib-server.yhirose.repl.co");
+httplib::Client cli("https://yhirose.github.io");
 
 auto res = cli.Get("/hi");
 res->status;
@@ -77,6 +77,9 @@ cli.set_ca_cert_path("./ca-bundle.crt");
 
 // Disable cert verification
 cli.enable_server_certificate_verification(false);
+
+// Disable host verification
+cli.enable_server_hostname_verification(false);
 ```
 
 > [!NOTE]
@@ -122,6 +125,21 @@ int main(void)
     res.set_content(req.body, "text/plain");
   });
 
+  // If the handler takes time to finish, you can also poll the connection state
+  svr.Get("/task", [&](const Request& req, Response& res) {
+    const char * result = nullptr;
+    process.run(); // for example, starting an external process
+    while (result == nullptr) {
+      sleep(1);
+      if (req.is_connection_closed()) {
+        process.kill(); // kill the process
+        return;
+      }
+      result = process.stdout(); // != nullptr if the process finishes
+    }
+    res.set_content(result, "text/plain");
+  });
+
   svr.Get("/stop", [&](const Request& req, Response& res) {
     svr.stop();
   });
@@ -384,6 +402,18 @@ svr.Get("/chunked", [&](const Request& r
 });
 ```
 
+### Send file content
+
+```cpp
+svr.Get("/content", [&](const Request &req, Response &res) {
+  res.set_file_content("./path/to/conent.html");
+});
+
+svr.Get("/content", [&](const Request &req, Response &res) {
+  res.set_file_content("./path/to/conent", "text/html");
+});
+```
+
 ### 'Expect: 100-continue' handler
 
 By default, the server sends a `100 Continue` response for an `Expect: 100-continue` header.
@@ -542,18 +572,18 @@ enum Error {
 
 ```c++
 httplib::Headers headers = {
-  { "Accept-Encoding", "gzip, deflate" }
+  { "Hello", "World!" }
 };
 auto res = cli.Get("/hi", headers);
 ```
 or
 ```c++
-auto res = cli.Get("/hi", {{"Accept-Encoding", "gzip, deflate"}});
+auto res = cli.Get("/hi", {{"Hello", "World!"}});
 ```
 or
 ```c++
 cli.set_default_headers({
-  { "Accept-Encoding", "gzip, deflate" }
+  { "Hello", "World!" }
 });
 auto res = cli.Get("/hi");
 ```
@@ -808,6 +838,21 @@ The server can apply compression to the
 Brotli compression is available with `CPPHTTPLIB_BROTLI_SUPPORT`. Necessary libraries should be linked.
 Please see https://github.com/google/brotli for more detail.
 
+### Default `Accept-Encoding` value
+
+The default `Acdcept-Encoding` value contains all possible compression types. So, the following two examples are same.
+
+```c++
+res = cli.Get("/resource/foo");
+res = cli.Get("/resource/foo", {{"Accept-Encoding", "gzip, deflate, br"}});
+```
+
+If we don't want a response without compression, we have to set `Accept-Encoding` to an empty string. This behavior is similar to curl.
+
+```c++
+res = cli.Get("/resource/foo", {{"Accept-Encoding", ""}});
+```
+
 ### Compress request body on client
 
 ```c++
@@ -819,8 +864,9 @@ res = cli.Post("/resource/foo", "...", "
 
 ```c++
 cli.set_decompress(false);
-res = cli.Get("/resource/foo", {{"Accept-Encoding", "gzip, deflate, br"}});
+res = cli.Get("/resource/foo");
 res->body; // Compressed data
+
 ```
 
 Use `poll` instead of `select`
@@ -828,6 +874,23 @@ Use `poll` instead of `select`
 
 `select` system call is used as default since it's more widely supported. If you want to let cpp-httplib use `poll` instead, you can do so with `CPPHTTPLIB_USE_POLL`.
 
+Unix Domain Socket Support
+--------------------------
+
+Unix Domain Socket support is available on Linux and macOS.
+
+```c++
+// Server
+httplib::Server svr("./my-socket.sock");
+svr.set_address_family(AF_UNIX).listen("./my-socket.sock", 80);
+
+// Client
+httplib::Client cli("./my-socket.sock");
+cli.set_address_family(AF_UNIX);
+```
+
+"my-socket.sock" can be a relative path or an absolute path. You application must have the appropriate permissions for the path. You can also use an abstract socket address on Linux. To use an abstract socket address, prepend a null byte ('\x00') to the path.
+
 
 Split httplib.h into .h and .cc
 -------------------------------
@@ -848,6 +911,32 @@ $ ./split.py
 Wrote out/httplib.h and out/httplib.cc
 ```
 
+Dockerfile for Static HTTP Server
+---------------------------------
+
+Dockerfile for static HTTP server is available. Port number of this HTTP server is 80, and it serves static files from `/html` directory in the container.
+
+```bash
+> docker build -t cpp-httplib-server .
+...
+
+> docker run --rm -it -p 8080:80 -v ./docker/html:/html cpp-httplib-server
+Serving HTTP on 0.0.0.0 port 80 ...
+192.168.65.1 - - [31/Aug/2024:21:33:56 +0000] "GET / HTTP/1.1" 200 599 "-" "curl/8.7.1"
+192.168.65.1 - - [31/Aug/2024:21:34:26 +0000] "GET / HTTP/1.1" 200 599 "-" "Mozilla/5.0 ..."
+192.168.65.1 - - [31/Aug/2024:21:34:26 +0000] "GET /favicon.ico HTTP/1.1" 404 152 "-" "Mozilla/5.0 ..."
+```
+
+From Docker Hub
+
+```bash
+> docker run --rm -it -p 8080:80 -v ./docker/html:/html yhirose4dockerhub/cpp-httplib-server
+Serving HTTP on 0.0.0.0 port 80 ...
+192.168.65.1 - - [31/Aug/2024:21:33:56 +0000] "GET / HTTP/1.1" 200 599 "-" "curl/8.7.1"
+192.168.65.1 - - [31/Aug/2024:21:34:26 +0000] "GET / HTTP/1.1" 200 599 "-" "Mozilla/5.0 ..."
+192.168.65.1 - - [31/Aug/2024:21:34:26 +0000] "GET /favicon.ico HTTP/1.1" 404 152 "-" "Mozilla/5.0 ..."
+```
+
 NOTE
 ----
 
@@ -879,7 +968,7 @@ Include `httplib.h` before `Windows.h` o
 License
 -------
 
-MIT license (© 2024 Yuji Hirose)
+MIT license (© 2025 Yuji Hirose)
 
 Special Thanks To
 -----------------
diff -pruN 0.16.3+ds-2/debian/changelog 0.18.7-1/debian/changelog
--- 0.16.3+ds-2/debian/changelog	2024-09-17 14:33:49.000000000 +0000
+++ 0.18.7-1/debian/changelog	2025-03-11 17:18:06.000000000 +0000
@@ -1,3 +1,21 @@
+cpp-httplib (0.18.7-1) unstable; urgency=medium
+
+  * Update to new upstream version 0.18.7.
+  * Upload to unstable
+  * d/control: use my @debian.org email address
+  * d/rules: copy missing meson test files
+
+ -- Andrea Pappacoda <tachi@debian.org>  Tue, 11 Mar 2025 18:18:06 +0100
+
+cpp-httplib (0.18.0+ds-1) experimental; urgency=medium
+
+  * Update to new upstream version 0.18.0+ds.
+  * d/control: libcpp-httplib0.16 -> libcpp-httplib0.18
+  * d/control: apply X-Style: black
+  * d/control: add build dependency on libcurl-dev
+
+ -- Andrea Pappacoda <andrea@pappacoda.it>  Tue, 17 Sep 2024 17:33:26 +0200
+
 cpp-httplib (0.16.3+ds-2) unstable; urgency=medium
 
   * d/patches: bump minimum Meson version to 0.62.0
diff -pruN 0.16.3+ds-2/debian/control 0.18.7-1/debian/control
--- 0.16.3+ds-2/debian/control	2024-09-17 14:33:49.000000000 +0000
+++ 0.18.7-1/debian/control	2025-03-11 17:18:06.000000000 +0000
@@ -1,29 +1,35 @@
 Source: cpp-httplib
 Section: libs
 Priority: optional
-Maintainer: Andrea Pappacoda <andrea@pappacoda.it>
-Build-Depends: debhelper-compat (= 13),
-               dpkg-build-api (= 1),
-               dpkg-dev (>= 1.22.5),
-               meson (>= 0.47.0)
-Build-Depends-Arch: libbrotli-dev,
-                    libgtest-dev <!nocheck>,
-                    libssl-dev (>= 3.0.0),
-                    openssl <!nocheck>,
-                    pkg-config,
-                    python3:any,
-                    zlib1g-dev
-Standards-Version: 4.7.0
+Maintainer: Andrea Pappacoda <tachi@debian.org>
+Build-Depends:
+ debhelper-compat (= 13),
+ dpkg-build-api (= 1),
+ dpkg-dev (>= 1.22.5),
+Build-Depends-Arch:
+ libbrotli-dev,
+ libcurl4-openssl-dev | libcurl-dev,
+ libgtest-dev <!nocheck>,
+ libssl-dev (>= 3.0.0),
+ meson (>= 0.62.0),
+ openssl <!nocheck>,
+ pkg-config,
+ python3:any,
+ zlib1g-dev,
+Standards-Version: 4.7.2
 Homepage: https://github.com/yhirose/cpp-httplib
 Vcs-Git: https://salsa.debian.org/debian/cpp-httplib.git
 Vcs-Browser: https://salsa.debian.org/debian/cpp-httplib
+X-Style: black
 
-Package: libcpp-httplib0.16
+Package: libcpp-httplib0.18
 Architecture: any
 Multi-Arch: same
-Pre-Depends: ${misc:Pre-Depends}
-Depends: ${misc:Depends},
-         ${shlibs:Depends}
+Pre-Depends:
+ ${misc:Pre-Depends},
+Depends:
+ ${misc:Depends},
+ ${shlibs:Depends},
 Description: C++ HTTP/HTTPS server and client library
  cpp-httplib is a C++11 cross platform HTTP/HTTPS library, with a focus on
  ease of use. This is a multi-threaded 'blocking' HTTP library. If you are
@@ -33,12 +39,14 @@ Package: libcpp-httplib-dev
 Section: libdevel
 Architecture: any
 Multi-Arch: same
-Pre-Depends: ${misc:Pre-Depends}
-Depends: libbrotli-dev,
-         libcpp-httplib0.16 (= ${binary:Version}),
-         libssl-dev,
-         zlib1g-dev,
-         ${misc:Depends}
+Pre-Depends:
+ ${misc:Pre-Depends},
+Depends:
+ libbrotli-dev,
+ libcpp-httplib0.18 (= ${binary:Version}),
+ libssl-dev,
+ zlib1g-dev,
+ ${misc:Depends},
 Description: C++ HTTP/HTTPS server and client library - development files
  cpp-httplib is a C++11 cross platform HTTP/HTTPS library, with a focus on
  ease of use. This is a multi-threaded 'blocking' HTTP library. If you are
diff -pruN 0.16.3+ds-2/debian/copyright 0.18.7-1/debian/copyright
--- 0.16.3+ds-2/debian/copyright	2024-09-17 14:33:49.000000000 +0000
+++ 0.18.7-1/debian/copyright	2025-03-11 17:18:06.000000000 +0000
@@ -4,9 +4,11 @@ Upstream-Contact: Yuji Hirose <yuji.hiro
 Source: https://github.com/yhirose/cpp-httplib.git
 License: Expat
 Copyright: 2012 Yuji Hirose <yuji.hirose.bug@gmail.com>
-Files-Excluded: test/gtest
+Files-Excluded: benchmark
+                test/gtest
                 test/fuzzing
-Comment: Bundled GoogleTest library
+Comment: Contains large bundled files
+         Bundled GoogleTest library
          Contains files with different licenses, unused
 
 Files: *
diff -pruN 0.16.3+ds-2/debian/gbp.conf 0.18.7-1/debian/gbp.conf
--- 0.16.3+ds-2/debian/gbp.conf	2024-09-17 14:33:49.000000000 +0000
+++ 0.18.7-1/debian/gbp.conf	2025-03-11 17:18:06.000000000 +0000
@@ -9,6 +9,7 @@ sign-tags = True
 
 [import-orig]
 merge = False
+postimport = git debrebase new-upstream $GBP_UPSTREAM_VERSION
 
 [create-remote-repo]
 remote-url-pattern = git@salsa.debian.org:tachi/%(pkg)s.git
diff -pruN 0.16.3+ds-2/debian/libcpp-httplib0.16.install 0.18.7-1/debian/libcpp-httplib0.16.install
--- 0.16.3+ds-2/debian/libcpp-httplib0.16.install	2024-09-17 14:33:49.000000000 +0000
+++ 0.18.7-1/debian/libcpp-httplib0.16.install	1970-01-01 00:00:00.000000000 +0000
@@ -1 +0,0 @@
-usr/lib/*/libcpp-httplib.so.0.16*
diff -pruN 0.16.3+ds-2/debian/libcpp-httplib0.18.install 0.18.7-1/debian/libcpp-httplib0.18.install
--- 0.16.3+ds-2/debian/libcpp-httplib0.18.install	1970-01-01 00:00:00.000000000 +0000
+++ 0.18.7-1/debian/libcpp-httplib0.18.install	2025-03-11 17:18:06.000000000 +0000
@@ -0,0 +1 @@
+usr/lib/*/libcpp-httplib.so.0.18*
diff -pruN 0.16.3+ds-2/debian/patches/0001-build-meson-bump-minimum-version-to-0.62.0.patch 0.18.7-1/debian/patches/0001-build-meson-bump-minimum-version-to-0.62.0.patch
--- 0.16.3+ds-2/debian/patches/0001-build-meson-bump-minimum-version-to-0.62.0.patch	2024-09-17 14:33:49.000000000 +0000
+++ 0.18.7-1/debian/patches/0001-build-meson-bump-minimum-version-to-0.62.0.patch	1970-01-01 00:00:00.000000000 +0000
@@ -1,69 +0,0 @@
-From: Andrea Pappacoda <andrea@pappacoda.it>
-Date: Tue, 17 Sep 2024 15:07:28 +0200
-Subject: build(meson): bump minimum version to 0.62.0
-
-This allows making some minor cleanups
-
-Bug: https://github.com/yhirose/cpp-httplib/issues/1798
-Bug-Debian: https://bugs.debian.org/1069357
-Forwarded: https://github.com/yhirose/cpp-httplib/pull/1940
-Last-Update: 2024-09-17
----
- meson.build      | 10 ++++------
- test/meson.build |  6 +++---
- 2 files changed, 7 insertions(+), 9 deletions(-)
-
-diff --git a/meson.build b/meson.build
-index e82ae84..9fa1919 100644
---- a/meson.build
-+++ b/meson.build
-@@ -13,7 +13,7 @@ project(
-     'b_lto=true',
-     'warning_level=3'
-   ],
--  meson_version: '>=0.47.0'
-+  meson_version: '>=0.62.0'
- )
- 
- # Check just in case downstream decides to edit the source
-@@ -98,20 +98,18 @@ if get_option('cpp-httplib_compile')
-   )
- else
-   install_headers('httplib.h')
--  cpp_httplib_dep = declare_dependency(compile_args: args, dependencies: deps, include_directories: include_directories('.'))
-+  cpp_httplib_dep = declare_dependency(compile_args: args, dependencies: deps, include_directories: '.')
- 
-   import('pkgconfig').generate(
-     name: 'cpp-httplib',
-     description: 'A C++ HTTP/HTTPS server and client library',
--    install_dir: join_paths(get_option('datadir'), 'pkgconfig'),
-+    install_dir: get_option('datadir')/'pkgconfig',
-     url: 'https://github.com/yhirose/cpp-httplib',
-     version: version
-   )
- endif
- 
--if meson.version().version_compare('>=0.54.0')
--  meson.override_dependency('cpp-httplib', cpp_httplib_dep)
--endif
-+meson.override_dependency('cpp-httplib', cpp_httplib_dep)
- 
- if get_option('cpp-httplib_test')
-   subdir('test')
-diff --git a/test/meson.build b/test/meson.build
-index 52fb825..7fb0471 100644
---- a/test/meson.build
-+++ b/test/meson.build
-@@ -102,9 +102,9 @@ client_encrypted_cert_pem = custom_target(
- # Copy test files to the build directory
- configure_file(input: 'ca-bundle.crt', output: 'ca-bundle.crt', copy: true)
- configure_file(input: 'image.jpg',     output: 'image.jpg',     copy: true)
--subdir(join_paths('www', 'dir'))
--subdir(join_paths('www2', 'dir'))
--subdir(join_paths('www3', 'dir'))
-+subdir('www' /'dir')
-+subdir('www2'/'dir')
-+subdir('www3'/'dir')
- 
- # GoogleTest 1.13.0 requires C++14
- test_options = []
diff -pruN 0.16.3+ds-2/debian/patches/0002-test-meson-fix-SSLClientServerTest.-tests-with-OpenS.patch 0.18.7-1/debian/patches/0002-test-meson-fix-SSLClientServerTest.-tests-with-OpenS.patch
--- 0.16.3+ds-2/debian/patches/0002-test-meson-fix-SSLClientServerTest.-tests-with-OpenS.patch	2024-09-17 14:33:49.000000000 +0000
+++ 0.18.7-1/debian/patches/0002-test-meson-fix-SSLClientServerTest.-tests-with-OpenS.patch	1970-01-01 00:00:00.000000000 +0000
@@ -1,66 +0,0 @@
-From: Andrea Pappacoda <andrea@pappacoda.it>
-Date: Tue, 17 Sep 2024 15:08:21 +0200
-Subject: test(meson): fix SSLClientServerTest.* tests with OpenSSL 3.2.0
-
-Since OpenSSL commit
-<https://github.com/openssl/openssl/commit/342e3652c791bdb06e08abcc169b4456c83ccd00>,
-the default X.509 certificate format generated with the `openssl req`
-command has been changed to X.509 v3 from X.509 v1.
-
-For some reason, this change breaks cpp-httplib's SSLClientServerTest.*
-tests.
-
-To fix the test failures, this patch passes the '-x509v1' flag instead
-of '-x509' when OpenSSL 3.2.0 or newer is detected. To detect the
-version of a command line utility, Meson 0.62.0 or later is required.
-
-Fixes <https://github.com/yhirose/cpp-httplib/issues/1798>, but only for
-the Meson build system.
-
-Bug: https://github.com/yhirose/cpp-httplib/issues/1798
-Bug-Debian: https://bugs.debian.org/1069357
-Forwarded: https://github.com/yhirose/cpp-httplib/pull/1940
-Last-Update: 2024-09-17
----
- test/meson.build | 7 ++++---
- 1 file changed, 4 insertions(+), 3 deletions(-)
-
-diff --git a/test/meson.build b/test/meson.build
-index 7fb0471..9a91a49 100644
---- a/test/meson.build
-+++ b/test/meson.build
-@@ -5,6 +5,7 @@
- gtest_dep = dependency('gtest', main: true)
- openssl = find_program('openssl')
- test_conf = files('test.conf')
-+req_x509_flag = openssl.version().version_compare('>=3.2.0') ? '-x509v1' : '-x509'
- 
- key_pem = custom_target(
-   'key_pem',
-@@ -30,7 +31,7 @@ cert2_pem = custom_target(
-   'cert2_pem',
-   input: key_pem,
-   output: 'cert2.pem',
--  command: [openssl, 'req', '-x509', '-config', test_conf, '-key', '@INPUT@', '-sha256', '-days', '3650', '-nodes', '-out', '@OUTPUT@', '-extensions', 'SAN']
-+  command: [openssl, 'req', req_x509_flag, '-config', test_conf, '-key', '@INPUT@', '-sha256', '-days', '3650', '-nodes', '-out', '@OUTPUT@', '-extensions', 'SAN']
- )
- 
- key_encrypted_pem = custom_target(
-@@ -43,7 +44,7 @@ cert_encrypted_pem = custom_target(
-   'cert_encrypted_pem',
-   input: key_encrypted_pem,
-   output: 'cert_encrypted.pem',
--  command: [openssl, 'req', '-x509', '-config', test_conf, '-key', '@INPUT@', '-sha256', '-days', '3650', '-nodes', '-out', '@OUTPUT@', '-extensions', 'SAN']
-+  command: [openssl, 'req', req_x509_flag, '-config', test_conf, '-key', '@INPUT@', '-sha256', '-days', '3650', '-nodes', '-out', '@OUTPUT@', '-extensions', 'SAN']
- )
- 
- rootca_key_pem = custom_target(
-@@ -56,7 +57,7 @@ rootca_cert_pem = custom_target(
-   'rootca_cert_pem',
-   input: rootca_key_pem,
-   output: 'rootCA.cert.pem',
--  command: [openssl, 'req', '-x509', '-new', '-batch', '-config', files('test.rootCA.conf'), '-key', '@INPUT@', '-days', '1024', '-out', '@OUTPUT@']
-+  command: [openssl, 'req', req_x509_flag, '-new', '-batch', '-config', files('test.rootCA.conf'), '-key', '@INPUT@', '-days', '1024', '-out', '@OUTPUT@']
- )
- 
- client_key_pem = custom_target(
diff -pruN 0.16.3+ds-2/debian/patches/series 0.18.7-1/debian/patches/series
--- 0.16.3+ds-2/debian/patches/series	2024-09-17 14:33:49.000000000 +0000
+++ 0.18.7-1/debian/patches/series	1970-01-01 00:00:00.000000000 +0000
@@ -1,2 +0,0 @@
-0001-build-meson-bump-minimum-version-to-0.62.0.patch
-0002-test-meson-fix-SSLClientServerTest.-tests-with-OpenS.patch
diff -pruN 0.16.3+ds-2/debian/rules 0.18.7-1/debian/rules
--- 0.16.3+ds-2/debian/rules	2024-09-17 14:33:49.000000000 +0000
+++ 0.18.7-1/debian/rules	2025-03-11 17:18:06.000000000 +0000
@@ -4,7 +4,7 @@ export DEB_BUILD_MAINT_OPTIONS = hardeni
 export DEB_CPPFLAGS_MAINT_APPEND = -DCPPHTTPLIB_USE_POLL
 
 %:
-	dh $@ --buildsystem=meson
+	dh $@ --buildsystem=meson --builddir=_build
 
 ifeq (,$(filter nocheck,$(DEB_BUILD_OPTIONS)))
   test := true
@@ -38,6 +38,9 @@ override_dh_auto_configure:
 		-Dcpp-httplib_compile=true \
 		-Dcpp-httplib_test=$(test)
 
+execute_before_dh_auto_test:
+	cp -R test/www/日本語Dir/ _build/test/www/
+
 override_dh_auto_test:
 	dh_auto_test -- \
 		--timeout-multiplier=3 \
diff -pruN 0.16.3+ds-2/debian/tests/control 0.18.7-1/debian/tests/control
--- 0.16.3+ds-2/debian/tests/control	2024-09-17 14:33:49.000000000 +0000
+++ 0.18.7-1/debian/tests/control	2025-03-11 17:18:06.000000000 +0000
@@ -1,2 +1,6 @@
-Tests: pkgconfig
-Depends: @, g++ | c++-compiler, pkg-config
+Tests:
+ pkgconfig,
+Depends:
+ g++ | c++-compiler,
+ pkg-config,
+ @,
diff -pruN 0.16.3+ds-2/docker/html/index.html 0.18.7-1/docker/html/index.html
--- 0.16.3+ds-2/docker/html/index.html	1970-01-01 00:00:00.000000000 +0000
+++ 0.18.7-1/docker/html/index.html	2025-02-08 20:53:35.000000000 +0000
@@ -0,0 +1,21 @@
+<!DOCTYPE html>
+<html>
+<head>
+<title>Welcome to cpp-httplib!</title>
+<style>
+html { color-scheme: light dark; }
+body { width: 35em; margin: 0 auto;
+font-family: Tahoma, Verdana, Arial, sans-serif; }
+</style>
+</head>
+<body>
+<h1>Welcome to cpp-httplib!</h1>
+<p>If you see this page, the cpp-httplib web server is successfully installed and
+working. Further configuration is required.</p>
+
+<p>For online documentation and support please refer to
+<a href="https://github.com/yhirose/cpp-httplib">github.com/yhirose/cpp-httplib</a>.<br/>
+
+<p><em>Thank you for using cpp-httplib.</em></p>
+</body>
+</html>
diff -pruN 0.16.3+ds-2/docker/main.cc 0.18.7-1/docker/main.cc
--- 0.16.3+ds-2/docker/main.cc	1970-01-01 00:00:00.000000000 +0000
+++ 0.18.7-1/docker/main.cc	2025-02-08 20:53:35.000000000 +0000
@@ -0,0 +1,81 @@
+//
+//  main.cc
+//
+//  Copyright (c) 2025 Yuji Hirose. All rights reserved.
+//  MIT License
+//
+
+#include <chrono>
+#include <ctime>
+#include <format>
+#include <iomanip>
+#include <iostream>
+#include <sstream>
+
+#include <httplib.h>
+
+constexpr auto error_html = R"(<html>
+<head><title>{} {}</title></head>
+<body>
+<center><h1>404 Not Found</h1></center>
+<hr><center>cpp-httplib/{}</center>
+</body>
+</html>
+)";
+
+void sigint_handler(int s) { exit(1); }
+
+std::string time_local() {
+  auto p = std::chrono::system_clock::now();
+  auto t = std::chrono::system_clock::to_time_t(p);
+
+  std::stringstream ss;
+  ss << std::put_time(std::localtime(&t), "%d/%b/%Y:%H:%M:%S %z");
+  return ss.str();
+}
+
+std::string log(auto &req, auto &res) {
+  auto remote_user = "-"; // TODO:
+  auto request = std::format("{} {} {}", req.method, req.path, req.version);
+  auto body_bytes_sent = res.get_header_value("Content-Length");
+  auto http_referer = "-"; // TODO:
+  auto http_user_agent = req.get_header_value("User-Agent", "-");
+
+  // NOTE: From NGINX defualt access log format
+  // log_format combined '$remote_addr - $remote_user [$time_local] '
+  //                     '"$request" $status $body_bytes_sent '
+  //                     '"$http_referer" "$http_user_agent"';
+  return std::format(R"({} - {} [{}] "{}" {} {} "{}" "{}")", req.remote_addr,
+                     remote_user, time_local(), request, res.status,
+                     body_bytes_sent, http_referer, http_user_agent);
+}
+
+int main(int argc, const char **argv) {
+  signal(SIGINT, sigint_handler);
+
+  auto base_dir = "./html";
+  auto host = "0.0.0.0";
+  auto port = 80;
+
+  httplib::Server svr;
+
+  svr.set_error_handler([](auto & /*req*/, auto &res) {
+    auto body =
+        std::format(error_html, res.status, httplib::status_message(res.status),
+                    CPPHTTPLIB_VERSION);
+
+    res.set_content(body, "text/html");
+  });
+
+  svr.set_logger(
+      [](auto &req, auto &res) { std::cout << log(req, res) << std::endl; });
+
+  svr.set_mount_point("/", base_dir);
+
+  std::cout << std::format("Serving HTTP on {0} port {1} ...", host, port)
+            << std::endl;
+
+  auto ret = svr.listen(host, port);
+
+  return ret ? 0 : 1;
+}
diff -pruN 0.16.3+ds-2/docker-compose.yml 0.18.7-1/docker-compose.yml
--- 0.16.3+ds-2/docker-compose.yml	1970-01-01 00:00:00.000000000 +0000
+++ 0.18.7-1/docker-compose.yml	2025-02-08 20:53:35.000000000 +0000
@@ -0,0 +1,7 @@
+services:
+  http:
+    build: .
+    ports:
+      - "8080:80"
+    volumes:
+      - ./docker/html:/html
diff -pruN 0.16.3+ds-2/example/Makefile 0.18.7-1/example/Makefile
--- 0.16.3+ds-2/example/Makefile	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/example/Makefile	2025-02-08 20:53:35.000000000 +0000
@@ -18,7 +18,7 @@ ZLIB_SUPPORT = -DCPPHTTPLIB_ZLIB_SUPPORT
 BROTLI_DIR = $(PREFIX)/opt/brotli
 BROTLI_SUPPORT = -DCPPHTTPLIB_BROTLI_SUPPORT -I$(BROTLI_DIR)/include -L$(BROTLI_DIR)/lib -lbrotlicommon -lbrotlienc -lbrotlidec
 
-all: server client hello simplecli simplesvr upload redirect ssesvr ssecli benchmark issue
+all: server client hello simplecli simplesvr upload redirect ssesvr ssecli benchmark one_time_request server_and_client
 
 server : server.cc ../httplib.h Makefile
 	$(CXX) -o server $(CXXFLAGS) server.cc $(OPENSSL_SUPPORT) $(ZLIB_SUPPORT) $(BROTLI_SUPPORT)
@@ -53,9 +53,12 @@ benchmark : benchmark.cc ../httplib.h Ma
 one_time_request : one_time_request.cc ../httplib.h Makefile
 	$(CXX) -o one_time_request $(CXXFLAGS) one_time_request.cc $(OPENSSL_SUPPORT) $(ZLIB_SUPPORT) $(BROTLI_SUPPORT)
 
+server_and_client : server_and_client.cc ../httplib.h Makefile
+	$(CXX) -o server_and_client $(CXXFLAGS) server_and_client.cc $(OPENSSL_SUPPORT) $(ZLIB_SUPPORT) $(BROTLI_SUPPORT)
+
 pem:
 	openssl genrsa 2048 > key.pem
 	openssl req -new -key key.pem | openssl x509 -days 3650 -req -signkey key.pem > cert.pem
 
 clean:
-	rm server client hello simplecli simplesvr upload redirect ssesvr ssecli benchmark one_time_request *.pem
+	rm server client hello simplecli simplesvr upload redirect ssesvr ssecli benchmark one_time_request server_and_client *.pem
diff -pruN 0.16.3+ds-2/example/client.vcxproj 0.18.7-1/example/client.vcxproj
--- 0.16.3+ds-2/example/client.vcxproj	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/example/client.vcxproj	2025-02-08 20:53:35.000000000 +0000
@@ -22,34 +22,34 @@
     <ProjectGuid>{6DB1FC63-B153-4279-92B7-D8A11AF285D6}</ProjectGuid>
     <Keyword>Win32Proj</Keyword>
     <RootNamespace>client</RootNamespace>
-    <WindowsTargetPlatformVersion>10.0.15063.0</WindowsTargetPlatformVersion>
+    <WindowsTargetPlatformVersion>10.0</WindowsTargetPlatformVersion>
   </PropertyGroup>
   <Import Project="$(VCTargetsPath)\Microsoft.Cpp.Default.props" />
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Debug|Win32'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>true</UseDebugLibraries>
     <CharacterSet>Unicode</CharacterSet>
-    <PlatformToolset>v141</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
   </PropertyGroup>
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Debug|x64'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>true</UseDebugLibraries>
     <CharacterSet>Unicode</CharacterSet>
-    <PlatformToolset>v141</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
   </PropertyGroup>
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Release|Win32'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>false</UseDebugLibraries>
     <WholeProgramOptimization>true</WholeProgramOptimization>
     <CharacterSet>Unicode</CharacterSet>
-    <PlatformToolset>v141</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
   </PropertyGroup>
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Release|x64'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>false</UseDebugLibraries>
     <WholeProgramOptimization>true</WholeProgramOptimization>
     <CharacterSet>Unicode</CharacterSet>
-    <PlatformToolset>v141</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
   </PropertyGroup>
   <Import Project="$(VCTargetsPath)\Microsoft.Cpp.props" />
   <ImportGroup Label="ExtensionSettings">
diff -pruN 0.16.3+ds-2/example/server.vcxproj 0.18.7-1/example/server.vcxproj
--- 0.16.3+ds-2/example/server.vcxproj	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/example/server.vcxproj	2025-02-08 20:53:35.000000000 +0000
@@ -18,38 +18,41 @@
       <Platform>x64</Platform>
     </ProjectConfiguration>
   </ItemGroup>
+  <ItemGroup>
+    <ClCompile Include="simplesvr.cc" />
+  </ItemGroup>
   <PropertyGroup Label="Globals">
     <ProjectGuid>{864CD288-050A-4C8B-9BEF-3048BD876C5B}</ProjectGuid>
     <Keyword>Win32Proj</Keyword>
     <RootNamespace>sample</RootNamespace>
-    <WindowsTargetPlatformVersion>10.0.15063.0</WindowsTargetPlatformVersion>
+    <WindowsTargetPlatformVersion>10.0</WindowsTargetPlatformVersion>
   </PropertyGroup>
   <Import Project="$(VCTargetsPath)\Microsoft.Cpp.Default.props" />
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Debug|Win32'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>true</UseDebugLibraries>
     <CharacterSet>Unicode</CharacterSet>
-    <PlatformToolset>v141</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
   </PropertyGroup>
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Debug|x64'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>true</UseDebugLibraries>
     <CharacterSet>Unicode</CharacterSet>
-    <PlatformToolset>v141</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
   </PropertyGroup>
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Release|Win32'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>false</UseDebugLibraries>
     <WholeProgramOptimization>true</WholeProgramOptimization>
     <CharacterSet>Unicode</CharacterSet>
-    <PlatformToolset>v141</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
   </PropertyGroup>
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Release|x64'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>false</UseDebugLibraries>
     <WholeProgramOptimization>true</WholeProgramOptimization>
     <CharacterSet>Unicode</CharacterSet>
-    <PlatformToolset>v141</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
   </PropertyGroup>
   <Import Project="$(VCTargetsPath)\Microsoft.Cpp.props" />
   <ImportGroup Label="ExtensionSettings">
@@ -151,9 +154,6 @@
       <AdditionalDependencies>Ws2_32.lib;%(AdditionalDependencies)</AdditionalDependencies>
     </Link>
   </ItemDefinitionGroup>
-  <ItemGroup>
-    <ClCompile Include="server.cc" />
-  </ItemGroup>
   <Import Project="$(VCTargetsPath)\Microsoft.Cpp.targets" />
   <ImportGroup Label="ExtensionTargets">
   </ImportGroup>
diff -pruN 0.16.3+ds-2/example/server_and_client.cc 0.18.7-1/example/server_and_client.cc
--- 0.16.3+ds-2/example/server_and_client.cc	1970-01-01 00:00:00.000000000 +0000
+++ 0.18.7-1/example/server_and_client.cc	2025-02-08 20:53:35.000000000 +0000
@@ -0,0 +1,90 @@
+//
+//  server_and_client.cc
+//
+//  Copyright (c) 2025 Yuji Hirose. All rights reserved.
+//  MIT License
+//
+
+#include <httplib.h>
+#include <iostream>
+#include <string>
+
+using namespace httplib;
+
+std::string dump_headers(const Headers &headers) {
+  std::string s;
+  char buf[BUFSIZ];
+
+  for (auto it = headers.begin(); it != headers.end(); ++it) {
+    const auto &x = *it;
+    snprintf(buf, sizeof(buf), "%s: %s\n", x.first.c_str(), x.second.c_str());
+    s += buf;
+  }
+
+  return s;
+}
+
+void logger(const Request &req, const Response &res) {
+  std::string s;
+  char buf[BUFSIZ];
+
+  s += "================================\n";
+
+  snprintf(buf, sizeof(buf), "%s %s %s", req.method.c_str(),
+           req.version.c_str(), req.path.c_str());
+  s += buf;
+
+  std::string query;
+  for (auto it = req.params.begin(); it != req.params.end(); ++it) {
+    const auto &x = *it;
+    snprintf(buf, sizeof(buf), "%c%s=%s",
+             (it == req.params.begin()) ? '?' : '&', x.first.c_str(),
+             x.second.c_str());
+    query += buf;
+  }
+  snprintf(buf, sizeof(buf), "%s\n", query.c_str());
+  s += buf;
+
+  s += dump_headers(req.headers);
+
+  s += "--------------------------------\n";
+
+  snprintf(buf, sizeof(buf), "%d %s\n", res.status, res.version.c_str());
+  s += buf;
+  s += dump_headers(res.headers);
+  s += "\n";
+
+  if (!res.body.empty()) { s += res.body; }
+
+  s += "\n";
+
+  std::cout << s;
+}
+
+int main(void) {
+  // Server
+  Server svr;
+  svr.set_logger(logger);
+
+  svr.Post("/post", [&](const Request & /*req*/, Response &res) {
+    res.set_content("POST", "text/plain");
+  });
+
+  auto th = std::thread([&]() { svr.listen("localhost", 8080); });
+
+  auto se = detail::scope_exit([&] {
+    svr.stop();
+    th.join();
+  });
+
+  svr.wait_until_ready();
+
+  // Client
+  Client cli{"localhost", 8080};
+
+  std::string body = R"({"hello": "world"})";
+
+  auto res = cli.Post("/post", body, "application/json");
+  std::cout << "--------------------------------" << std::endl;
+  std::cout << to_string(res.error()) << std::endl;
+}
diff -pruN 0.16.3+ds-2/httplib.h 0.18.7-1/httplib.h
--- 0.16.3+ds-2/httplib.h	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/httplib.h	2025-02-08 20:53:35.000000000 +0000
@@ -1,14 +1,14 @@
 //
 //  httplib.h
 //
-//  Copyright (c) 2024 Yuji Hirose. All rights reserved.
+//  Copyright (c) 2025 Yuji Hirose. All rights reserved.
 //  MIT License
 //
 
 #ifndef CPPHTTPLIB_HTTPLIB_H
 #define CPPHTTPLIB_HTTPLIB_H
 
-#define CPPHTTPLIB_VERSION "0.16.3"
+#define CPPHTTPLIB_VERSION "0.18.7"
 
 /*
  * Configuration
@@ -18,8 +18,12 @@
 #define CPPHTTPLIB_KEEPALIVE_TIMEOUT_SECOND 5
 #endif
 
+#ifndef CPPHTTPLIB_KEEPALIVE_TIMEOUT_CHECK_INTERVAL_USECOND
+#define CPPHTTPLIB_KEEPALIVE_TIMEOUT_CHECK_INTERVAL_USECOND 10000
+#endif
+
 #ifndef CPPHTTPLIB_KEEPALIVE_MAX_COUNT
-#define CPPHTTPLIB_KEEPALIVE_MAX_COUNT 5
+#define CPPHTTPLIB_KEEPALIVE_MAX_COUNT 100
 #endif
 
 #ifndef CPPHTTPLIB_CONNECTION_TIMEOUT_SECOND
@@ -30,20 +34,36 @@
 #define CPPHTTPLIB_CONNECTION_TIMEOUT_USECOND 0
 #endif
 
-#ifndef CPPHTTPLIB_READ_TIMEOUT_SECOND
-#define CPPHTTPLIB_READ_TIMEOUT_SECOND 5
+#ifndef CPPHTTPLIB_SERVER_READ_TIMEOUT_SECOND
+#define CPPHTTPLIB_SERVER_READ_TIMEOUT_SECOND 5
+#endif
+
+#ifndef CPPHTTPLIB_SERVER_READ_TIMEOUT_USECOND
+#define CPPHTTPLIB_SERVER_READ_TIMEOUT_USECOND 0
+#endif
+
+#ifndef CPPHTTPLIB_SERVER_WRITE_TIMEOUT_SECOND
+#define CPPHTTPLIB_SERVER_WRITE_TIMEOUT_SECOND 5
+#endif
+
+#ifndef CPPHTTPLIB_SERVER_WRITE_TIMEOUT_USECOND
+#define CPPHTTPLIB_SERVER_WRITE_TIMEOUT_USECOND 0
+#endif
+
+#ifndef CPPHTTPLIB_CLIENT_READ_TIMEOUT_SECOND
+#define CPPHTTPLIB_CLIENT_READ_TIMEOUT_SECOND 300
 #endif
 
-#ifndef CPPHTTPLIB_READ_TIMEOUT_USECOND
-#define CPPHTTPLIB_READ_TIMEOUT_USECOND 0
+#ifndef CPPHTTPLIB_CLIENT_READ_TIMEOUT_USECOND
+#define CPPHTTPLIB_CLIENT_READ_TIMEOUT_USECOND 0
 #endif
 
-#ifndef CPPHTTPLIB_WRITE_TIMEOUT_SECOND
-#define CPPHTTPLIB_WRITE_TIMEOUT_SECOND 5
+#ifndef CPPHTTPLIB_CLIENT_WRITE_TIMEOUT_SECOND
+#define CPPHTTPLIB_CLIENT_WRITE_TIMEOUT_SECOND 5
 #endif
 
-#ifndef CPPHTTPLIB_WRITE_TIMEOUT_USECOND
-#define CPPHTTPLIB_WRITE_TIMEOUT_USECOND 0
+#ifndef CPPHTTPLIB_CLIENT_WRITE_TIMEOUT_USECOND
+#define CPPHTTPLIB_CLIENT_WRITE_TIMEOUT_USECOND 0
 #endif
 
 #ifndef CPPHTTPLIB_IDLE_INTERVAL_SECOND
@@ -90,6 +110,10 @@
 #define CPPHTTPLIB_TCP_NODELAY false
 #endif
 
+#ifndef CPPHTTPLIB_IPV6_V6ONLY
+#define CPPHTTPLIB_IPV6_V6ONLY false
+#endif
+
 #ifndef CPPHTTPLIB_RECV_BUFSIZ
 #define CPPHTTPLIB_RECV_BUFSIZ size_t(16384u)
 #endif
@@ -194,7 +218,9 @@ using socket_t = SOCKET;
 #include <csignal>
 #include <pthread.h>
 #include <sys/mman.h>
+#ifndef __VMS
 #include <sys/select.h>
+#endif
 #include <sys/socket.h>
 #include <sys/un.h>
 #include <unistd.h>
@@ -269,7 +295,7 @@ using socket_t = int;
 #include <iostream>
 #include <sstream>
 
-#if defined(OPENSSL_IS_BORINGSSL)
+#if defined(OPENSSL_IS_BORINGSSL) || defined(LIBRESSL_VERSION_NUMBER)
 #if OPENSSL_VERSION_NUMBER < 0x1010107f
 #error Please use OpenSSL or a current version of BoringSSL
 #endif
@@ -317,16 +343,63 @@ make_unique(std::size_t n) {
   return std::unique_ptr<T>(new RT[n]);
 }
 
-struct ci {
-  bool operator()(const std::string &s1, const std::string &s2) const {
-    return std::lexicographical_compare(s1.begin(), s1.end(), s2.begin(),
-                                        s2.end(),
-                                        [](unsigned char c1, unsigned char c2) {
-                                          return ::tolower(c1) < ::tolower(c2);
-                                        });
+namespace case_ignore {
+
+inline unsigned char to_lower(int c) {
+  const static unsigned char table[256] = {
+      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,
+      15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
+      30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,
+      45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
+      60,  61,  62,  63,  64,  97,  98,  99,  100, 101, 102, 103, 104, 105, 106,
+      107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
+      122, 91,  92,  93,  94,  95,  96,  97,  98,  99,  100, 101, 102, 103, 104,
+      105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
+      120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
+      135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
+      150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
+      165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
+      180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 224, 225, 226,
+      227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241,
+      242, 243, 244, 245, 246, 215, 248, 249, 250, 251, 252, 253, 254, 223, 224,
+      225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
+      240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
+      255,
+  };
+  return table[(unsigned char)(char)c];
+}
+
+inline bool equal(const std::string &a, const std::string &b) {
+  return a.size() == b.size() &&
+         std::equal(a.begin(), a.end(), b.begin(), [](char ca, char cb) {
+           return to_lower(ca) == to_lower(cb);
+         });
+}
+
+struct equal_to {
+  bool operator()(const std::string &a, const std::string &b) const {
+    return equal(a, b);
+  }
+};
+
+struct hash {
+  size_t operator()(const std::string &key) const {
+    return hash_core(key.data(), key.size(), 0);
+  }
+
+  size_t hash_core(const char *s, size_t l, size_t h) const {
+    return (l == 0) ? h
+                    : hash_core(s + 1, l - 1,
+                                // Unsets the 6 high bits of h, therefore no
+                                // overflow happens
+                                (((std::numeric_limits<size_t>::max)() >> 6) &
+                                 h * 33) ^
+                                    static_cast<unsigned char>(to_lower(*s)));
   }
 };
 
+} // namespace case_ignore
+
 // This is based on
 // "http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2014/n4189".
 
@@ -432,7 +505,9 @@ enum StatusCode {
   NetworkAuthenticationRequired_511 = 511,
 };
 
-using Headers = std::multimap<std::string, std::string, detail::ci>;
+using Headers =
+    std::unordered_multimap<std::string, std::string, detail::case_ignore::hash,
+                            detail::case_ignore::equal_to>;
 
 using Params = std::multimap<std::string, std::string>;
 using Match = std::smatch;
@@ -539,6 +614,7 @@ using Ranges = std::vector<Range>;
 struct Request {
   std::string method;
   std::string path;
+  Params params;
   Headers headers;
   std::string body;
 
@@ -550,11 +626,11 @@ struct Request {
   // for server
   std::string version;
   std::string target;
-  Params params;
   MultipartFormDataMap files;
   Ranges ranges;
   Match matches;
   std::unordered_map<std::string, std::string> path_params;
+  std::function<bool()> is_connection_closed = []() { return true; };
 
   // for client
   ResponseHandler response_handler;
@@ -565,8 +641,10 @@ struct Request {
 #endif
 
   bool has_header(const std::string &key) const;
-  std::string get_header_value(const std::string &key, size_t id = 0) const;
-  uint64_t get_header_value_u64(const std::string &key, size_t id = 0) const;
+  std::string get_header_value(const std::string &key, const char *def = "",
+                               size_t id = 0) const;
+  uint64_t get_header_value_u64(const std::string &key, uint64_t def = 0,
+                                size_t id = 0) const;
   size_t get_header_value_count(const std::string &key) const;
   void set_header(const std::string &key, const std::string &val);
 
@@ -597,8 +675,10 @@ struct Response {
   std::string location; // Redirect location
 
   bool has_header(const std::string &key) const;
-  std::string get_header_value(const std::string &key, size_t id = 0) const;
-  uint64_t get_header_value_u64(const std::string &key, size_t id = 0) const;
+  std::string get_header_value(const std::string &key, const char *def = "",
+                               size_t id = 0) const;
+  uint64_t get_header_value_u64(const std::string &key, uint64_t def = 0,
+                                size_t id = 0) const;
   size_t get_header_value_count(const std::string &key) const;
   void set_header(const std::string &key, const std::string &val);
 
@@ -619,6 +699,10 @@ struct Response {
       const std::string &content_type, ContentProviderWithoutLength provider,
       ContentProviderResourceReleaser resource_releaser = nullptr);
 
+  void set_file_content(const std::string &path,
+                        const std::string &content_type);
+  void set_file_content(const std::string &path);
+
   Response() = default;
   Response(const Response &) = default;
   Response &operator=(const Response &) = default;
@@ -636,6 +720,8 @@ struct Response {
   ContentProviderResourceReleaser content_provider_resource_releaser_;
   bool is_chunked_content_provider_ = false;
   bool content_provider_success_ = false;
+  std::string file_content_path_;
+  std::string file_content_content_type_;
 };
 
 class Stream {
@@ -651,8 +737,6 @@ public:
   virtual void get_local_ip_and_port(std::string &ip, int &port) const = 0;
   virtual socket_t socket() const = 0;
 
-  template <typename... Args>
-  ssize_t write_format(const char *fmt, const Args &...args);
   ssize_t write(const char *ptr);
   ssize_t write(const std::string &s);
 };
@@ -732,7 +816,8 @@ private:
         fn();
       }
 
-#if defined(CPPHTTPLIB_OPENSSL_SUPPORT) && !defined(OPENSSL_IS_BORINGSSL)
+#if defined(CPPHTTPLIB_OPENSSL_SUPPORT) && !defined(OPENSSL_IS_BORINGSSL) &&   \
+    !defined(LIBRESSL_VERSION_NUMBER)
       OPENSSL_thread_stop();
 #endif
     }
@@ -796,7 +881,6 @@ public:
   bool match(Request &request) const override;
 
 private:
-  static constexpr char marker = ':';
   // Treat segment separators as the end of path parameter capture
   // Does not need to handle query parameters as they are parsed before path
   // matching
@@ -896,6 +980,7 @@ public:
 
   Server &set_address_family(int family);
   Server &set_tcp_nodelay(bool on);
+  Server &set_ipv6_v6only(bool on);
   Server &set_socket_options(SocketOptions socket_options);
 
   Server &set_default_headers(Headers headers);
@@ -928,21 +1013,24 @@ public:
   bool is_running() const;
   void wait_until_ready() const;
   void stop();
+  void decommission();
 
   std::function<TaskQueue *(void)> new_task_queue;
 
 protected:
-  bool process_request(Stream &strm, bool close_connection,
+  bool process_request(Stream &strm, const std::string &remote_addr,
+                       int remote_port, const std::string &local_addr,
+                       int local_port, bool close_connection,
                        bool &connection_closed,
                        const std::function<void(Request &)> &setup_request);
 
   std::atomic<socket_t> svr_sock_{INVALID_SOCKET};
   size_t keep_alive_max_count_ = CPPHTTPLIB_KEEPALIVE_MAX_COUNT;
   time_t keep_alive_timeout_sec_ = CPPHTTPLIB_KEEPALIVE_TIMEOUT_SECOND;
-  time_t read_timeout_sec_ = CPPHTTPLIB_READ_TIMEOUT_SECOND;
-  time_t read_timeout_usec_ = CPPHTTPLIB_READ_TIMEOUT_USECOND;
-  time_t write_timeout_sec_ = CPPHTTPLIB_WRITE_TIMEOUT_SECOND;
-  time_t write_timeout_usec_ = CPPHTTPLIB_WRITE_TIMEOUT_USECOND;
+  time_t read_timeout_sec_ = CPPHTTPLIB_SERVER_READ_TIMEOUT_SECOND;
+  time_t read_timeout_usec_ = CPPHTTPLIB_SERVER_READ_TIMEOUT_USECOND;
+  time_t write_timeout_sec_ = CPPHTTPLIB_SERVER_WRITE_TIMEOUT_SECOND;
+  time_t write_timeout_usec_ = CPPHTTPLIB_SERVER_WRITE_TIMEOUT_USECOND;
   time_t idle_interval_sec_ = CPPHTTPLIB_IDLE_INTERVAL_SECOND;
   time_t idle_interval_usec_ = CPPHTTPLIB_IDLE_INTERVAL_USECOND;
   size_t payload_max_length_ = CPPHTTPLIB_PAYLOAD_MAX_LENGTH;
@@ -1002,7 +1090,7 @@ private:
   virtual bool process_and_close_socket(socket_t sock);
 
   std::atomic<bool> is_running_{false};
-  std::atomic<bool> done_{false};
+  std::atomic<bool> is_decommisioned{false};
 
   struct MountPointEntry {
     std::string mount_point;
@@ -1035,6 +1123,7 @@ private:
 
   int address_family_ = AF_UNSPEC;
   bool tcp_nodelay_ = CPPHTTPLIB_TCP_NODELAY;
+  bool ipv6_v6only_ = CPPHTTPLIB_IPV6_V6ONLY;
   SocketOptions socket_options_ = default_socket_options;
 
   Headers default_headers_;
@@ -1054,6 +1143,7 @@ enum class Error {
   SSLConnection,
   SSLLoadingCerts,
   SSLServerVerification,
+  SSLServerHostnameVerification,
   UnsupportedMultipartBoundaryChars,
   Compression,
   ConnectionTimeout,
@@ -1091,9 +1181,10 @@ public:
   // Request Headers
   bool has_request_header(const std::string &key) const;
   std::string get_request_header_value(const std::string &key,
+                                       const char *def = "",
                                        size_t id = 0) const;
   uint64_t get_request_header_value_u64(const std::string &key,
-                                        size_t id = 0) const;
+                                        uint64_t def = 0, size_t id = 0) const;
   size_t get_request_header_value_count(const std::string &key) const;
 
 private:
@@ -1316,6 +1407,7 @@ public:
 
   void set_address_family(int family);
   void set_tcp_nodelay(bool on);
+  void set_ipv6_v6only(bool on);
   void set_socket_options(SocketOptions socket_options);
 
   void set_connection_timeout(time_t sec, time_t usec = 0);
@@ -1367,6 +1459,8 @@ public:
 
 #ifdef CPPHTTPLIB_OPENSSL_SUPPORT
   void enable_server_certificate_verification(bool enabled);
+  void enable_server_hostname_verification(bool enabled);
+  void set_server_certificate_verifier(std::function<bool(SSL *ssl)> verifier);
 #endif
 
   void set_logger(Logger logger);
@@ -1433,10 +1527,10 @@ protected:
 
   time_t connection_timeout_sec_ = CPPHTTPLIB_CONNECTION_TIMEOUT_SECOND;
   time_t connection_timeout_usec_ = CPPHTTPLIB_CONNECTION_TIMEOUT_USECOND;
-  time_t read_timeout_sec_ = CPPHTTPLIB_READ_TIMEOUT_SECOND;
-  time_t read_timeout_usec_ = CPPHTTPLIB_READ_TIMEOUT_USECOND;
-  time_t write_timeout_sec_ = CPPHTTPLIB_WRITE_TIMEOUT_SECOND;
-  time_t write_timeout_usec_ = CPPHTTPLIB_WRITE_TIMEOUT_USECOND;
+  time_t read_timeout_sec_ = CPPHTTPLIB_CLIENT_READ_TIMEOUT_SECOND;
+  time_t read_timeout_usec_ = CPPHTTPLIB_CLIENT_READ_TIMEOUT_USECOND;
+  time_t write_timeout_sec_ = CPPHTTPLIB_CLIENT_WRITE_TIMEOUT_SECOND;
+  time_t write_timeout_usec_ = CPPHTTPLIB_CLIENT_WRITE_TIMEOUT_USECOND;
 
   std::string basic_auth_username_;
   std::string basic_auth_password_;
@@ -1453,6 +1547,7 @@ protected:
 
   int address_family_ = AF_UNSPEC;
   bool tcp_nodelay_ = CPPHTTPLIB_TCP_NODELAY;
+  bool ipv6_v6only_ = CPPHTTPLIB_IPV6_V6ONLY;
   SocketOptions socket_options_ = nullptr;
 
   bool compress_ = false;
@@ -1480,6 +1575,8 @@ protected:
 
 #ifdef CPPHTTPLIB_OPENSSL_SUPPORT
   bool server_certificate_verification_ = true;
+  bool server_hostname_verification_ = true;
+  std::function<bool(SSL *ssl)> server_certificate_verifier_;
 #endif
 
   Logger logger_;
@@ -1488,6 +1585,9 @@ private:
   bool send_(Request &req, Response &res, Error &error);
   Result send_(Request &&req);
 
+#ifdef CPPHTTPLIB_OPENSSL_SUPPORT
+  bool is_ssl_peer_could_be_closed(SSL *ssl) const;
+#endif
   socket_t create_client_socket(Error &error) const;
   bool read_response_line(Stream &strm, const Request &req,
                           Response &res) const;
@@ -1785,6 +1885,8 @@ public:
 
 #ifdef CPPHTTPLIB_OPENSSL_SUPPORT
   void enable_server_certificate_verification(bool enabled);
+  void enable_server_hostname_verification(bool enabled);
+  void set_server_certificate_verifier(std::function<bool(SSL *ssl)> verifier);
 #endif
 
   void set_logger(Logger logger);
@@ -1913,68 +2015,58 @@ inline void duration_to_sec_and_usec(con
   callback(static_cast<time_t>(sec), static_cast<time_t>(usec));
 }
 
+inline bool is_numeric(const std::string &str) {
+  return !str.empty() && std::all_of(str.begin(), str.end(), ::isdigit);
+}
+
 inline uint64_t get_header_value_u64(const Headers &headers,
-                                     const std::string &key, size_t id,
-                                     uint64_t def) {
+                                     const std::string &key, uint64_t def,
+                                     size_t id, bool &is_invalid_value) {
+  is_invalid_value = false;
   auto rng = headers.equal_range(key);
   auto it = rng.first;
   std::advance(it, static_cast<ssize_t>(id));
   if (it != rng.second) {
-    return std::strtoull(it->second.data(), nullptr, 10);
+    if (is_numeric(it->second)) {
+      return std::strtoull(it->second.data(), nullptr, 10);
+    } else {
+      is_invalid_value = true;
+    }
   }
   return def;
 }
 
+inline uint64_t get_header_value_u64(const Headers &headers,
+                                     const std::string &key, uint64_t def,
+                                     size_t id) {
+  bool dummy = false;
+  return get_header_value_u64(headers, key, def, id, dummy);
+}
+
 } // namespace detail
 
 inline uint64_t Request::get_header_value_u64(const std::string &key,
-                                              size_t id) const {
-  return detail::get_header_value_u64(headers, key, id, 0);
+                                              uint64_t def, size_t id) const {
+  return detail::get_header_value_u64(headers, key, def, id);
 }
 
 inline uint64_t Response::get_header_value_u64(const std::string &key,
-                                               size_t id) const {
-  return detail::get_header_value_u64(headers, key, id, 0);
-}
-
-template <typename... Args>
-inline ssize_t Stream::write_format(const char *fmt, const Args &...args) {
-  const auto bufsiz = 2048;
-  std::array<char, bufsiz> buf{};
-
-  auto sn = snprintf(buf.data(), buf.size() - 1, fmt, args...);
-  if (sn <= 0) { return sn; }
-
-  auto n = static_cast<size_t>(sn);
-
-  if (n >= buf.size() - 1) {
-    std::vector<char> glowable_buf(buf.size());
-
-    while (n >= glowable_buf.size() - 1) {
-      glowable_buf.resize(glowable_buf.size() * 2);
-      n = static_cast<size_t>(
-          snprintf(&glowable_buf[0], glowable_buf.size() - 1, fmt, args...));
-    }
-    return write(&glowable_buf[0], n);
-  } else {
-    return write(buf.data(), n);
-  }
+                                               uint64_t def, size_t id) const {
+  return detail::get_header_value_u64(headers, key, def, id);
 }
 
 inline void default_socket_options(socket_t sock) {
-  int yes = 1;
+  int opt = 1;
 #ifdef _WIN32
   setsockopt(sock, SOL_SOCKET, SO_REUSEADDR,
-             reinterpret_cast<const char *>(&yes), sizeof(yes));
-  setsockopt(sock, SOL_SOCKET, SO_EXCLUSIVEADDRUSE,
-             reinterpret_cast<const char *>(&yes), sizeof(yes));
+             reinterpret_cast<const char *>(&opt), sizeof(opt));
 #else
 #ifdef SO_REUSEPORT
   setsockopt(sock, SOL_SOCKET, SO_REUSEPORT,
-             reinterpret_cast<const void *>(&yes), sizeof(yes));
+             reinterpret_cast<const void *>(&opt), sizeof(opt));
 #else
   setsockopt(sock, SOL_SOCKET, SO_REUSEADDR,
-             reinterpret_cast<const void *>(&yes), sizeof(yes));
+             reinterpret_cast<const void *>(&opt), sizeof(opt));
 #endif
 #endif
 }
@@ -2100,6 +2192,8 @@ inline std::string to_string(const Error
   case Error::SSLConnection: return "SSL connection failed";
   case Error::SSLLoadingCerts: return "SSL certificate loading failed";
   case Error::SSLServerVerification: return "SSL server verification failed";
+  case Error::SSLServerHostnameVerification:
+    return "SSL server hostname verification failed";
   case Error::UnsupportedMultipartBoundaryChars:
     return "Unsupported HTTP multipart boundary characters";
   case Error::Compression: return "Compression failed";
@@ -2119,8 +2213,9 @@ inline std::ostream &operator<<(std::ost
 }
 
 inline uint64_t Result::get_request_header_value_u64(const std::string &key,
+                                                     uint64_t def,
                                                      size_t id) const {
-  return detail::get_header_value_u64(request_headers_, key, id, 0);
+  return detail::get_header_value_u64(request_headers_, key, def, id);
 }
 
 template <class Rep, class Period>
@@ -2183,6 +2278,36 @@ make_basic_authentication_header(const s
 
 namespace detail {
 
+#if defined(_WIN32)
+inline std::wstring u8string_to_wstring(const char *s) {
+  std::wstring ws;
+  auto len = static_cast<int>(strlen(s));
+  auto wlen = ::MultiByteToWideChar(CP_UTF8, 0, s, len, nullptr, 0);
+  if (wlen > 0) {
+    ws.resize(wlen);
+    wlen = ::MultiByteToWideChar(
+        CP_UTF8, 0, s, len,
+        const_cast<LPWSTR>(reinterpret_cast<LPCWSTR>(ws.data())), wlen);
+    if (wlen != static_cast<int>(ws.size())) { ws.clear(); }
+  }
+  return ws;
+}
+#endif
+
+struct FileStat {
+  FileStat(const std::string &path);
+  bool is_file() const;
+  bool is_dir() const;
+
+private:
+#if defined(_WIN32)
+  struct _stat st_;
+#else
+  struct stat st_;
+#endif
+  int ret_ = -1;
+};
+
 std::string encode_query_param(const std::string &value);
 
 std::string decode_url(const std::string &s, bool convert_plus_to_space);
@@ -2212,15 +2337,18 @@ bool process_client_socket(socket_t sock
                            time_t write_timeout_usec,
                            std::function<bool(Stream &)> callback);
 
-socket_t create_client_socket(
-    const std::string &host, const std::string &ip, int port,
-    int address_family, bool tcp_nodelay, SocketOptions socket_options,
-    time_t connection_timeout_sec, time_t connection_timeout_usec,
-    time_t read_timeout_sec, time_t read_timeout_usec, time_t write_timeout_sec,
-    time_t write_timeout_usec, const std::string &intf, Error &error);
+socket_t create_client_socket(const std::string &host, const std::string &ip,
+                              int port, int address_family, bool tcp_nodelay,
+                              bool ipv6_v6only, SocketOptions socket_options,
+                              time_t connection_timeout_sec,
+                              time_t connection_timeout_usec,
+                              time_t read_timeout_sec, time_t read_timeout_usec,
+                              time_t write_timeout_sec,
+                              time_t write_timeout_usec,
+                              const std::string &intf, Error &error);
 
 const char *get_header_value(const Headers &headers, const std::string &key,
-                             size_t id = 0, const char *def = nullptr);
+                             const char *def, size_t id);
 
 std::string params_to_query_str(const Params &params);
 
@@ -2385,15 +2513,70 @@ public:
 
 private:
 #if defined(_WIN32)
-  HANDLE hFile_;
-  HANDLE hMapping_;
+  HANDLE hFile_ = NULL;
+  HANDLE hMapping_ = NULL;
 #else
-  int fd_;
+  int fd_ = -1;
 #endif
-  size_t size_;
-  void *addr_;
+  size_t size_ = 0;
+  void *addr_ = nullptr;
+  bool is_open_empty_file = false;
 };
 
+// NOTE: https://www.rfc-editor.org/rfc/rfc9110#section-5
+namespace fields {
+
+inline bool is_token_char(char c) {
+  return std::isalnum(c) || c == '!' || c == '#' || c == '$' || c == '%' ||
+         c == '&' || c == '\'' || c == '*' || c == '+' || c == '-' ||
+         c == '.' || c == '^' || c == '_' || c == '`' || c == '|' || c == '~';
+}
+
+inline bool is_token(const std::string &s) {
+  if (s.empty()) { return false; }
+  for (auto c : s) {
+    if (!is_token_char(c)) { return false; }
+  }
+  return true;
+}
+
+inline bool is_field_name(const std::string &s) { return is_token(s); }
+
+inline bool is_vchar(char c) { return c >= 33 && c <= 126; }
+
+inline bool is_obs_text(char c) { return 128 <= static_cast<unsigned char>(c); }
+
+inline bool is_field_vchar(char c) { return is_vchar(c) || is_obs_text(c); }
+
+inline bool is_field_content(const std::string &s) {
+  if (s.empty()) { return true; }
+
+  if (s.size() == 1) {
+    return is_field_vchar(s[0]);
+  } else if (s.size() == 2) {
+    return is_field_vchar(s[0]) && is_field_vchar(s[1]);
+  } else {
+    size_t i = 0;
+
+    if (!is_field_vchar(s[i])) { return false; }
+    i++;
+
+    while (i < s.size() - 1) {
+      auto c = s[i++];
+      if (c == ' ' || c == '\t' || is_field_vchar(c)) {
+      } else {
+        return false;
+      }
+    }
+
+    return is_field_vchar(s[i]);
+  }
+}
+
+inline bool is_field_value(const std::string &s) { return is_field_content(s); }
+
+} // namespace fields
+
 } // namespace detail
 
 // ----------------------------------------------------------------------------
@@ -2507,20 +2690,6 @@ inline std::string base64_encode(const s
   return out;
 }
 
-inline bool is_file(const std::string &path) {
-#ifdef _WIN32
-  return _access_s(path.c_str(), 0) == 0;
-#else
-  struct stat st;
-  return stat(path.c_str(), &st) >= 0 && S_ISREG(st.st_mode);
-#endif
-}
-
-inline bool is_dir(const std::string &path) {
-  struct stat st;
-  return stat(path.c_str(), &st) >= 0 && S_ISDIR(st.st_mode);
-}
-
 inline bool is_valid_path(const std::string &path) {
   size_t level = 0;
   size_t i = 0;
@@ -2563,6 +2732,21 @@ inline bool is_valid_path(const std::str
   return true;
 }
 
+inline FileStat::FileStat(const std::string &path) {
+#if defined(_WIN32)
+  auto wpath = u8string_to_wstring(path.c_str());
+  ret_ = _wstat(wpath.c_str(), &st_);
+#else
+  ret_ = stat(path.c_str(), &st_);
+#endif
+}
+inline bool FileStat::is_file() const {
+  return ret_ >= 0 && S_ISREG(st_.st_mode);
+}
+inline bool FileStat::is_dir() const {
+  return ret_ >= 0 && S_ISDIR(st_.st_mode);
+}
+
 inline std::string encode_query_param(const std::string &value) {
   std::ostringstream escaped;
   escaped.fill('0');
@@ -2772,6 +2956,10 @@ inline bool stream_line_reader::getline(
   fixed_buffer_used_size_ = 0;
   glowable_buffer_.clear();
 
+#ifndef CPPHTTPLIB_ALLOW_LF_AS_LINE_TERMINATOR
+  char prev_byte = 0;
+#endif
+
   for (size_t i = 0;; i++) {
     char byte;
     auto n = strm_.read(&byte, 1);
@@ -2788,7 +2976,12 @@ inline bool stream_line_reader::getline(
 
     append(byte);
 
+#ifdef CPPHTTPLIB_ALLOW_LF_AS_LINE_TERMINATOR
     if (byte == '\n') { break; }
+#else
+    if (prev_byte == '\r' && byte == '\n') { break; }
+    prev_byte = byte;
+#endif
   }
 
   return true;
@@ -2807,16 +3000,7 @@ inline void stream_line_reader::append(c
   }
 }
 
-inline mmap::mmap(const char *path)
-#if defined(_WIN32)
-    : hFile_(NULL), hMapping_(NULL)
-#else
-    : fd_(-1)
-#endif
-      ,
-      size_(0), addr_(nullptr) {
-  open(path);
-}
+inline mmap::mmap(const char *path) { open(path); }
 
 inline mmap::~mmap() { close(); }
 
@@ -2824,14 +3008,10 @@ inline bool mmap::open(const char *path)
   close();
 
 #if defined(_WIN32)
-  std::wstring wpath;
-  for (size_t i = 0; i < strlen(path); i++) {
-    wpath += path[i];
-  }
+  auto wpath = u8string_to_wstring(path);
+  if (wpath.empty()) { return false; }
 
-#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP | WINAPI_PARTITION_SYSTEM |   \
-                            WINAPI_PARTITION_GAMES) &&                         \
-    (_WIN32_WINNT >= _WIN32_WINNT_WIN8)
+#if _WIN32_WINNT >= _WIN32_WINNT_WIN8
   hFile_ = ::CreateFile2(wpath.c_str(), GENERIC_READ, FILE_SHARE_READ,
                          OPEN_EXISTING, NULL);
 #else
@@ -2841,39 +3021,47 @@ inline bool mmap::open(const char *path)
 
   if (hFile_ == INVALID_HANDLE_VALUE) { return false; }
 
-#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP | WINAPI_PARTITION_SYSTEM |   \
-                            WINAPI_PARTITION_GAMES)
   LARGE_INTEGER size{};
   if (!::GetFileSizeEx(hFile_, &size)) { return false; }
+  // If the following line doesn't compile due to QuadPart, update Windows SDK.
+  // See:
+  // https://github.com/yhirose/cpp-httplib/issues/1903#issuecomment-2316520721
+  if (static_cast<ULONGLONG>(size.QuadPart) >
+      (std::numeric_limits<decltype(size_)>::max)()) {
+    // `size_t` might be 32-bits, on 32-bits Windows.
+    return false;
+  }
   size_ = static_cast<size_t>(size.QuadPart);
-#else
-  DWORD sizeHigh;
-  DWORD sizeLow;
-  sizeLow = ::GetFileSize(hFile_, &sizeHigh);
-  if (sizeLow == INVALID_FILE_SIZE) { return false; }
-  size_ = (static_cast<size_t>(sizeHigh) << (sizeof(DWORD) * 8)) | sizeLow;
-#endif
 
-#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP | WINAPI_PARTITION_SYSTEM) && \
-    (_WIN32_WINNT >= _WIN32_WINNT_WIN8)
+#if _WIN32_WINNT >= _WIN32_WINNT_WIN8
   hMapping_ =
       ::CreateFileMappingFromApp(hFile_, NULL, PAGE_READONLY, size_, NULL);
 #else
-  hMapping_ = ::CreateFileMappingW(hFile_, NULL, PAGE_READONLY, size.HighPart,
-                                   size.LowPart, NULL);
+  hMapping_ = ::CreateFileMappingW(hFile_, NULL, PAGE_READONLY, 0, 0, NULL);
 #endif
 
+  // Special treatment for an empty file...
+  if (hMapping_ == NULL && size_ == 0) {
+    close();
+    is_open_empty_file = true;
+    return true;
+  }
+
   if (hMapping_ == NULL) {
     close();
     return false;
   }
 
-#if WINAPI_FAMILY_PARTITION(WINAPI_PARTITION_APP | WINAPI_PARTITION_SYSTEM) && \
-    (_WIN32_WINNT >= _WIN32_WINNT_WIN8)
+#if _WIN32_WINNT >= _WIN32_WINNT_WIN8
   addr_ = ::MapViewOfFileFromApp(hMapping_, FILE_MAP_READ, 0, 0);
 #else
   addr_ = ::MapViewOfFile(hMapping_, FILE_MAP_READ, 0, 0, 0);
 #endif
+
+  if (addr_ == nullptr) {
+    close();
+    return false;
+  }
 #else
   fd_ = ::open(path, O_RDONLY);
   if (fd_ == -1) { return false; }
@@ -2886,22 +3074,26 @@ inline bool mmap::open(const char *path)
   size_ = static_cast<size_t>(sb.st_size);
 
   addr_ = ::mmap(NULL, size_, PROT_READ, MAP_PRIVATE, fd_, 0);
-#endif
 
-  if (addr_ == nullptr) {
+  // Special treatment for an empty file...
+  if (addr_ == MAP_FAILED && size_ == 0) {
     close();
+    is_open_empty_file = true;
     return false;
   }
+#endif
 
   return true;
 }
 
-inline bool mmap::is_open() const { return addr_ != nullptr; }
+inline bool mmap::is_open() const {
+  return is_open_empty_file ? true : addr_ != nullptr;
+}
 
 inline size_t mmap::size() const { return size_; }
 
 inline const char *mmap::data() const {
-  return static_cast<const char *>(addr_);
+  return is_open_empty_file ? "" : static_cast<const char *>(addr_);
 }
 
 inline void mmap::close() {
@@ -2920,6 +3112,8 @@ inline void mmap::close() {
     ::CloseHandle(hFile_);
     hFile_ = INVALID_HANDLE_VALUE;
   }
+
+  is_open_empty_file = false;
 #else
   if (addr_ != nullptr) {
     munmap(addr_, size_);
@@ -2945,7 +3139,10 @@ template <typename T> inline ssize_t han
   ssize_t res = 0;
   while (true) {
     res = fn();
-    if (res < 0 && errno == EINTR) { continue; }
+    if (res < 0 && errno == EINTR) {
+      std::this_thread::sleep_for(std::chrono::microseconds{1});
+      continue;
+    }
     break;
   }
   return res;
@@ -3154,23 +3351,37 @@ private:
 };
 #endif
 
-inline bool keep_alive(socket_t sock, time_t keep_alive_timeout_sec) {
+inline bool keep_alive(const std::atomic<socket_t> &svr_sock, socket_t sock,
+                       time_t keep_alive_timeout_sec) {
   using namespace std::chrono;
-  auto start = steady_clock::now();
+
+  const auto interval_usec =
+      CPPHTTPLIB_KEEPALIVE_TIMEOUT_CHECK_INTERVAL_USECOND;
+
+  // Avoid expensive `steady_clock::now()` call for the first time
+  if (select_read(sock, 0, interval_usec) > 0) { return true; }
+
+  const auto start = steady_clock::now() - microseconds{interval_usec};
+  const auto timeout = seconds{keep_alive_timeout_sec};
+
   while (true) {
-    auto val = select_read(sock, 0, 10000);
+    if (svr_sock == INVALID_SOCKET) {
+      break; // Server socket is closed
+    }
+
+    auto val = select_read(sock, 0, interval_usec);
     if (val < 0) {
-      return false;
+      break; // Ssocket error
     } else if (val == 0) {
-      auto current = steady_clock::now();
-      auto duration = duration_cast<milliseconds>(current - start);
-      auto timeout = keep_alive_timeout_sec * 1000;
-      if (duration.count() > timeout) { return false; }
-      std::this_thread::sleep_for(std::chrono::milliseconds(1));
+      if (steady_clock::now() - start > timeout) {
+        break; // Timeout
+      }
     } else {
-      return true;
+      return true; // Ready for read
     }
   }
+
+  return false;
 }
 
 template <typename T>
@@ -3181,8 +3392,7 @@ process_server_socket_core(const std::at
   assert(keep_alive_max_count > 0);
   auto ret = false;
   auto count = keep_alive_max_count;
-  while (svr_sock != INVALID_SOCKET && count > 0 &&
-         keep_alive(sock, keep_alive_timeout_sec)) {
+  while (count > 0 && keep_alive(svr_sock, sock, keep_alive_timeout_sec)) {
     auto close_connection = count == 1;
     auto connection_closed = false;
     ret = callback(close_connection, connection_closed);
@@ -3226,10 +3436,29 @@ inline int shutdown_socket(socket_t sock
 #endif
 }
 
+inline std::string escape_abstract_namespace_unix_domain(const std::string &s) {
+  if (s.size() > 1 && s[0] == '\0') {
+    auto ret = s;
+    ret[0] = '@';
+    return ret;
+  }
+  return s;
+}
+
+inline std::string
+unescape_abstract_namespace_unix_domain(const std::string &s) {
+  if (s.size() > 1 && s[0] == '@') {
+    auto ret = s;
+    ret[0] = '\0';
+    return ret;
+  }
+  return s;
+}
+
 template <typename BindOrConnect>
 socket_t create_socket(const std::string &host, const std::string &ip, int port,
                        int address_family, int socket_flags, bool tcp_nodelay,
-                       SocketOptions socket_options,
+                       bool ipv6_v6only, SocketOptions socket_options,
                        BindOrConnect bind_or_connect) {
   // Get address info
   const char *node = nullptr;
@@ -3238,7 +3467,7 @@ socket_t create_socket(const std::string
 
   memset(&hints, 0, sizeof(struct addrinfo));
   hints.ai_socktype = SOCK_STREAM;
-  hints.ai_protocol = 0;
+  hints.ai_protocol = IPPROTO_IP;
 
   if (!ip.empty()) {
     node = ip.c_str();
@@ -3266,7 +3495,9 @@ socket_t create_socket(const std::string
     if (sock != INVALID_SOCKET) {
       sockaddr_un addr{};
       addr.sun_family = AF_UNIX;
-      std::copy(host.begin(), host.end(), addr.sun_path);
+
+      auto unescaped_host = unescape_abstract_namespace_unix_domain(host);
+      std::copy(unescaped_host.begin(), unescaped_host.end(), addr.sun_path);
 
       hints.ai_addr = reinterpret_cast<sockaddr *>(&addr);
       hints.ai_addrlen = static_cast<socklen_t>(
@@ -3296,6 +3527,7 @@ socket_t create_socket(const std::string
 #endif
     return INVALID_SOCKET;
   }
+  auto se = detail::scope_exit([&] { freeaddrinfo(result); });
 
   for (auto rp = result; rp; rp = rp->ai_next) {
     // Create a socket
@@ -3340,42 +3572,38 @@ socket_t create_socket(const std::string
 #endif
 
     if (tcp_nodelay) {
-      auto yes = 1;
+      auto opt = 1;
 #ifdef _WIN32
       setsockopt(sock, IPPROTO_TCP, TCP_NODELAY,
-                 reinterpret_cast<const char *>(&yes), sizeof(yes));
+                 reinterpret_cast<const char *>(&opt), sizeof(opt));
 #else
       setsockopt(sock, IPPROTO_TCP, TCP_NODELAY,
-                 reinterpret_cast<const void *>(&yes), sizeof(yes));
+                 reinterpret_cast<const void *>(&opt), sizeof(opt));
 #endif
     }
 
-    if (socket_options) { socket_options(sock); }
-
     if (rp->ai_family == AF_INET6) {
-      auto no = 0;
+      auto opt = ipv6_v6only ? 1 : 0;
 #ifdef _WIN32
       setsockopt(sock, IPPROTO_IPV6, IPV6_V6ONLY,
-                 reinterpret_cast<const char *>(&no), sizeof(no));
+                 reinterpret_cast<const char *>(&opt), sizeof(opt));
 #else
       setsockopt(sock, IPPROTO_IPV6, IPV6_V6ONLY,
-                 reinterpret_cast<const void *>(&no), sizeof(no));
+                 reinterpret_cast<const void *>(&opt), sizeof(opt));
 #endif
     }
 
+    if (socket_options) { socket_options(sock); }
+
     // bind or connect
     auto quit = false;
-    if (bind_or_connect(sock, *rp, quit)) {
-      freeaddrinfo(result);
-      return sock;
-    }
+    if (bind_or_connect(sock, *rp, quit)) { return sock; }
 
     close_socket(sock);
 
     if (quit) { break; }
   }
 
-  freeaddrinfo(result);
   return INVALID_SOCKET;
 }
 
@@ -3408,6 +3636,7 @@ inline bool bind_ip_address(socket_t soc
   hints.ai_protocol = 0;
 
   if (getaddrinfo(host.c_str(), "0", &hints, &result)) { return false; }
+  auto se = detail::scope_exit([&] { freeaddrinfo(result); });
 
   auto ret = false;
   for (auto rp = result; rp; rp = rp->ai_next) {
@@ -3418,7 +3647,6 @@ inline bool bind_ip_address(socket_t soc
     }
   }
 
-  freeaddrinfo(result);
   return ret;
 }
 
@@ -3430,6 +3658,8 @@ inline bool bind_ip_address(socket_t soc
 inline std::string if2ip(int address_family, const std::string &ifn) {
   struct ifaddrs *ifap;
   getifaddrs(&ifap);
+  auto se = detail::scope_exit([&] { freeifaddrs(ifap); });
+
   std::string addr_candidate;
   for (auto ifa = ifap; ifa; ifa = ifa->ifa_next) {
     if (ifa->ifa_addr && ifn == ifa->ifa_name &&
@@ -3439,7 +3669,6 @@ inline std::string if2ip(int address_fam
         auto sa = reinterpret_cast<struct sockaddr_in *>(ifa->ifa_addr);
         char buf[INET_ADDRSTRLEN];
         if (inet_ntop(AF_INET, &sa->sin_addr, buf, INET_ADDRSTRLEN)) {
-          freeifaddrs(ifap);
           return std::string(buf, INET_ADDRSTRLEN);
         }
       } else if (ifa->ifa_addr->sa_family == AF_INET6) {
@@ -3452,7 +3681,6 @@ inline std::string if2ip(int address_fam
             if (s6_addr_head == 0xfc || s6_addr_head == 0xfd) {
               addr_candidate = std::string(buf, INET6_ADDRSTRLEN);
             } else {
-              freeifaddrs(ifap);
               return std::string(buf, INET6_ADDRSTRLEN);
             }
           }
@@ -3460,19 +3688,20 @@ inline std::string if2ip(int address_fam
       }
     }
   }
-  freeifaddrs(ifap);
   return addr_candidate;
 }
 #endif
 
 inline socket_t create_client_socket(
     const std::string &host, const std::string &ip, int port,
-    int address_family, bool tcp_nodelay, SocketOptions socket_options,
-    time_t connection_timeout_sec, time_t connection_timeout_usec,
-    time_t read_timeout_sec, time_t read_timeout_usec, time_t write_timeout_sec,
+    int address_family, bool tcp_nodelay, bool ipv6_v6only,
+    SocketOptions socket_options, time_t connection_timeout_sec,
+    time_t connection_timeout_usec, time_t read_timeout_sec,
+    time_t read_timeout_usec, time_t write_timeout_sec,
     time_t write_timeout_usec, const std::string &intf, Error &error) {
   auto sock = create_socket(
-      host, ip, port, address_family, 0, tcp_nodelay, std::move(socket_options),
+      host, ip, port, address_family, 0, tcp_nodelay, ipv6_v6only,
+      std::move(socket_options),
       [&](socket_t sock2, struct addrinfo &ai, bool &quit) -> bool {
         if (!intf.empty()) {
 #ifdef USE_IF2IP
@@ -3625,7 +3854,7 @@ inline unsigned int str2tag(const std::s
 
 namespace udl {
 
-inline constexpr unsigned int operator"" _t(const char *s, size_t l) {
+inline constexpr unsigned int operator""_t(const char *s, size_t l) {
   return str2tag_core(s, l, 0);
 }
 
@@ -3710,8 +3939,9 @@ inline bool can_compress_content_type(co
   case "application/protobuf"_t:
   case "application/xhtml+xml"_t: return true;
 
-  default:
-    return !content_type.rfind("text/", 0) && tag != "text/event-stream"_t;
+  case "text/event-stream"_t: return false;
+
+  default: return !content_type.rfind("text/", 0);
   }
 }
 
@@ -3948,8 +4178,8 @@ inline bool has_header(const Headers &he
 }
 
 inline const char *get_header_value(const Headers &headers,
-                                    const std::string &key, size_t id,
-                                    const char *def) {
+                                    const std::string &key, const char *def,
+                                    size_t id) {
   auto rng = headers.equal_range(key);
   auto it = rng.first;
   std::advance(it, static_cast<ssize_t>(id));
@@ -3957,14 +4187,6 @@ inline const char *get_header_value(cons
   return def;
 }
 
-inline bool compare_case_ignore(const std::string &a, const std::string &b) {
-  if (a.size() != b.size()) { return false; }
-  for (size_t i = 0; i < b.size(); i++) {
-    if (::tolower(a[i]) != ::tolower(b[i])) { return false; }
-  }
-  return true;
-}
-
 template <typename T>
 inline bool parse_header(const char *beg, const char *end, T fn) {
   // Skip trailing spaces and tabs.
@@ -3987,15 +4209,26 @@ inline bool parse_header(const char *beg
     p++;
   }
 
-  if (p < end) {
+  if (p <= end) {
     auto key_len = key_end - beg;
     if (!key_len) { return false; }
 
     auto key = std::string(beg, key_end);
-    auto val = compare_case_ignore(key, "Location")
-                   ? std::string(p, end)
-                   : decode_url(std::string(p, end), false);
-    fn(key, val);
+    // auto val = (case_ignore::equal(key, "Location") ||
+    //             case_ignore::equal(key, "Referer"))
+    //                ? std::string(p, end)
+    //                : decode_url(std::string(p, end), false);
+    auto val = std::string(p, end);
+
+    if (!detail::fields::is_field_value(val)) { return false; }
+
+    if (case_ignore::equal(key, "Location") ||
+        case_ignore::equal(key, "Referer")) {
+      fn(key, val);
+    } else {
+      fn(key, decode_url(val, false));
+    }
+
     return true;
   }
 
@@ -4015,27 +4248,27 @@ inline bool read_headers(Stream &strm, H
     if (line_reader.end_with_crlf()) {
       // Blank line indicates end of headers.
       if (line_reader.size() == 2) { break; }
-#ifdef CPPHTTPLIB_ALLOW_LF_AS_LINE_TERMINATOR
     } else {
+#ifdef CPPHTTPLIB_ALLOW_LF_AS_LINE_TERMINATOR
       // Blank line indicates end of headers.
       if (line_reader.size() == 1) { break; }
       line_terminator_len = 1;
-    }
 #else
-    } else {
       continue; // Skip invalid line.
-    }
 #endif
+    }
 
     if (line_reader.size() > CPPHTTPLIB_HEADER_MAX_LENGTH) { return false; }
 
     // Exclude line terminator
     auto end = line_reader.ptr() + line_reader.size() - line_terminator_len;
 
-    parse_header(line_reader.ptr(), end,
-                 [&](const std::string &key, const std::string &val) {
-                   headers.emplace(key, val);
-                 });
+    if (!parse_header(line_reader.ptr(), end,
+                      [&](const std::string &key, const std::string &val) {
+                        headers.emplace(key, val);
+                      })) {
+      return false;
+    }
   }
 
   return true;
@@ -4123,8 +4356,19 @@ inline bool read_content_chunked(Stream
 
   assert(chunk_len == 0);
 
-  // Trailer
-  if (!line_reader.getline()) { return false; }
+  // NOTE: In RFC 9112, '7.1 Chunked Transfer Coding' mentiones "The chunked
+  // transfer coding is complete when a chunk with a chunk-size of zero is
+  // received, possibly followed by a trailer section, and finally terminated by
+  // an empty line". https://www.rfc-editor.org/rfc/rfc9112.html#section-7.1
+  //
+  // In '7.1.3. Decoding Chunked', however, the pseudo-code in the section
+  // does't care for the existence of the final CRLF. In other words, it seems
+  // to be ok whether the final CRLF exists or not in the chunked data.
+  // https://www.rfc-editor.org/rfc/rfc9112.html#section-7.1.3
+  //
+  // According to the reference code in RFC 9112, cpp-htpplib now allows
+  // chuncked transfer coding data without the final CRLF.
+  if (!line_reader.getline()) { return true; }
 
   while (strcmp(line_reader.ptr(), "\r\n") != 0) {
     if (line_reader.size() > CPPHTTPLIB_HEADER_MAX_LENGTH) { return false; }
@@ -4145,8 +4389,8 @@ inline bool read_content_chunked(Stream
 }
 
 inline bool is_chunked_transfer_encoding(const Headers &headers) {
-  return compare_case_ignore(
-      get_header_value(headers, "Transfer-Encoding", 0, ""), "chunked");
+  return case_ignore::equal(
+      get_header_value(headers, "Transfer-Encoding", "", 0), "chunked");
 }
 
 template <typename T, typename U>
@@ -4212,8 +4456,14 @@ bool read_content(Stream &strm, T &x, si
         } else if (!has_header(x.headers, "Content-Length")) {
           ret = read_content_without_length(strm, out);
         } else {
-          auto len = get_header_value_u64(x.headers, "Content-Length", 0, 0);
-          if (len > payload_max_length) {
+          auto is_invalid_value = false;
+          auto len = get_header_value_u64(
+              x.headers, "Content-Length",
+              (std::numeric_limits<uint64_t>::max)(), 0, is_invalid_value);
+
+          if (is_invalid_value) {
+            ret = false;
+          } else if (len > payload_max_length) {
             exceed_payload_max_length = true;
             skip_content_with_length(strm, len);
             ret = false;
@@ -4228,13 +4478,36 @@ bool read_content(Stream &strm, T &x, si
         }
         return ret;
       });
-} // namespace detail
+}
+
+inline ssize_t write_request_line(Stream &strm, const std::string &method,
+                                  const std::string &path) {
+  std::string s = method;
+  s += " ";
+  s += path;
+  s += " HTTP/1.1\r\n";
+  return strm.write(s.data(), s.size());
+}
+
+inline ssize_t write_response_line(Stream &strm, int status) {
+  std::string s = "HTTP/1.1 ";
+  s += std::to_string(status);
+  s += " ";
+  s += httplib::status_message(status);
+  s += "\r\n";
+  return strm.write(s.data(), s.size());
+}
 
 inline ssize_t write_headers(Stream &strm, const Headers &headers) {
   ssize_t write_len = 0;
   for (const auto &x : headers) {
-    auto len =
-        strm.write_format("%s: %s\r\n", x.first.c_str(), x.second.c_str());
+    std::string s;
+    s = x.first;
+    s += ": ";
+    s += x.second;
+    s += "\r\n";
+
+    auto len = strm.write(s.data(), s.size());
     if (len < 0) { return len; }
     write_len += len;
   }
@@ -4761,7 +5034,9 @@ private:
                               const std::string &b) const {
     if (a.size() < b.size()) { return false; }
     for (size_t i = 0; i < b.size(); i++) {
-      if (::tolower(a[i]) != ::tolower(b[i])) { return false; }
+      if (case_ignore::to_lower(a[i]) != case_ignore::to_lower(b[i])) {
+        return false;
+      }
     }
     return true;
   }
@@ -4844,16 +5119,6 @@ private:
   size_t buf_epos_ = 0;
 };
 
-inline std::string to_lower(const char *beg, const char *end) {
-  std::string out;
-  auto it = beg;
-  while (it != end) {
-    out += static_cast<char>(::tolower(*it));
-    it++;
-  }
-  return out;
-}
-
 inline std::string random_string(size_t length) {
   static const char data[] =
       "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
@@ -4967,7 +5232,18 @@ inline bool range_error(Request &req, Re
         last_pos = contant_len - 1;
       }
 
-      if (last_pos == -1) { last_pos = contant_len - 1; }
+      // NOTE: RFC-9110 '14.1.2. Byte Ranges':
+      // A client can limit the number of bytes requested without knowing the
+      // size of the selected representation. If the last-pos value is absent,
+      // or if the value is greater than or equal to the current length of the
+      // representation data, the byte range is interpreted as the remainder of
+      // the representation (i.e., the server replaces the value of last-pos
+      // with a value that is one less than the current length of the selected
+      // representation).
+      // https://www.rfc-editor.org/rfc/rfc9110.html#section-14.1.2-6
+      if (last_pos == -1 || last_pos >= contant_len) {
+        last_pos = contant_len - 1;
+      }
 
       // Range must be within content length
       if (!(0 <= first_pos && first_pos <= last_pos &&
@@ -5105,10 +5381,14 @@ write_multipart_ranges_data(Stream &strm
 
 inline bool expect_content(const Request &req) {
   if (req.method == "POST" || req.method == "PUT" || req.method == "PATCH" ||
-      req.method == "PRI" || req.method == "DELETE") {
+      req.method == "DELETE") {
     return true;
   }
-  // TODO: check if Content-Length is set
+  if (req.has_header("Content-Length") &&
+      req.get_header_value_u64("Content-Length") > 0) {
+    return true;
+  }
+  if (is_chunked_transfer_encoding(req.headers)) { return true; }
   return false;
 }
 
@@ -5428,6 +5708,7 @@ inline void hosted_at(const std::string
 #endif
     return;
   }
+  auto se = detail::scope_exit([&] { freeaddrinfo(result); });
 
   for (auto rp = result; rp; rp = rp->ai_next) {
     const auto &addr =
@@ -5439,8 +5720,6 @@ inline void hosted_at(const std::string
       addrs.push_back(ip);
     }
   }
-
-  freeaddrinfo(result);
 }
 
 inline std::string append_query_params(const std::string &path,
@@ -5489,8 +5768,8 @@ inline bool Request::has_header(const st
 }
 
 inline std::string Request::get_header_value(const std::string &key,
-                                             size_t id) const {
-  return detail::get_header_value(headers, key, id, "");
+                                             const char *def, size_t id) const {
+  return detail::get_header_value(headers, key, def, id);
 }
 
 inline size_t Request::get_header_value_count(const std::string &key) const {
@@ -5500,7 +5779,8 @@ inline size_t Request::get_header_value_
 
 inline void Request::set_header(const std::string &key,
                                 const std::string &val) {
-  if (!detail::has_crlf(key) && !detail::has_crlf(val)) {
+  if (detail::fields::is_field_name(key) &&
+      detail::fields::is_field_value(val)) {
     headers.emplace(key, val);
   }
 }
@@ -5554,8 +5834,9 @@ inline bool Response::has_header(const s
 }
 
 inline std::string Response::get_header_value(const std::string &key,
+                                              const char *def,
                                               size_t id) const {
-  return detail::get_header_value(headers, key, id, "");
+  return detail::get_header_value(headers, key, def, id);
 }
 
 inline size_t Response::get_header_value_count(const std::string &key) const {
@@ -5565,13 +5846,14 @@ inline size_t Response::get_header_value
 
 inline void Response::set_header(const std::string &key,
                                  const std::string &val) {
-  if (!detail::has_crlf(key) && !detail::has_crlf(val)) {
+  if (detail::fields::is_field_name(key) &&
+      detail::fields::is_field_value(val)) {
     headers.emplace(key, val);
   }
 }
 
 inline void Response::set_redirect(const std::string &url, int stat) {
-  if (!detail::has_crlf(url)) {
+  if (detail::fields::is_field_value(url)) {
     set_header("Location", url);
     if (300 <= stat && stat < 400) {
       this->status = stat;
@@ -5634,14 +5916,25 @@ inline void Response::set_chunked_conten
   is_chunked_content_provider_ = true;
 }
 
+inline void Response::set_file_content(const std::string &path,
+                                       const std::string &content_type) {
+  file_content_path_ = path;
+  file_content_content_type_ = content_type;
+}
+
+inline void Response::set_file_content(const std::string &path) {
+  file_content_path_ = path;
+}
+
 // Result implementation
 inline bool Result::has_request_header(const std::string &key) const {
   return request_headers_.find(key) != request_headers_.end();
 }
 
 inline std::string Result::get_request_header_value(const std::string &key,
+                                                    const char *def,
                                                     size_t id) const {
-  return detail::get_header_value(request_headers_, key, id, "");
+  return detail::get_header_value(request_headers_, key, def, id);
 }
 
 inline size_t
@@ -5782,6 +6075,8 @@ inline socket_t BufferStream::socket() c
 inline const std::string &BufferStream::get_buffer() const { return buffer; }
 
 inline PathParamsMatcher::PathParamsMatcher(const std::string &pattern) {
+  static constexpr char marker[] = "/:";
+
   // One past the last ending position of a path param substring
   std::size_t last_param_end = 0;
 
@@ -5794,13 +6089,14 @@ inline PathParamsMatcher::PathParamsMatc
 #endif
 
   while (true) {
-    const auto marker_pos = pattern.find(marker, last_param_end);
+    const auto marker_pos = pattern.find(
+        marker, last_param_end == 0 ? last_param_end : last_param_end - 1);
     if (marker_pos == std::string::npos) { break; }
 
     static_fragments_.push_back(
-        pattern.substr(last_param_end, marker_pos - last_param_end));
+        pattern.substr(last_param_end, marker_pos - last_param_end + 1));
 
-    const auto param_name_start = marker_pos + 1;
+    const auto param_name_start = marker_pos + 2;
 
     auto sep_pos = pattern.find(separator, param_name_start);
     if (sep_pos == std::string::npos) { sep_pos = pattern.length(); }
@@ -5862,7 +6158,7 @@ inline bool PathParamsMatcher::match(Req
     request.path_params.emplace(
         param_name, request.path.substr(starting_pos, sep_pos - starting_pos));
 
-    // Mark everythin up to '/' as matched
+    // Mark everything up to '/' as matched
     starting_pos = sep_pos + 1;
   }
   // Returns false if the path is longer than the pattern
@@ -5961,7 +6257,8 @@ inline bool Server::set_base_dir(const s
 
 inline bool Server::set_mount_point(const std::string &mount_point,
                                     const std::string &dir, Headers headers) {
-  if (detail::is_dir(dir)) {
+  detail::FileStat stat(dir);
+  if (stat.is_dir()) {
     std::string mnt = !mount_point.empty() ? mount_point : "/";
     if (!mnt.empty() && mnt[0] == '/') {
       base_dirs_.push_back({mnt, dir, std::move(headers)});
@@ -6049,6 +6346,11 @@ inline Server &Server::set_tcp_nodelay(b
   return *this;
 }
 
+inline Server &Server::set_ipv6_v6only(bool on) {
+  ipv6_v6only_ = on;
+  return *this;
+}
+
 inline Server &Server::set_socket_options(SocketOptions socket_options) {
   socket_options_ = std::move(socket_options);
   return *this;
@@ -6100,27 +6402,27 @@ inline Server &Server::set_payload_max_l
 
 inline bool Server::bind_to_port(const std::string &host, int port,
                                  int socket_flags) {
-  return bind_internal(host, port, socket_flags) >= 0;
+  auto ret = bind_internal(host, port, socket_flags);
+  if (ret == -1) { is_decommisioned = true; }
+  return ret >= 0;
 }
 inline int Server::bind_to_any_port(const std::string &host, int socket_flags) {
-  return bind_internal(host, 0, socket_flags);
+  auto ret = bind_internal(host, 0, socket_flags);
+  if (ret == -1) { is_decommisioned = true; }
+  return ret;
 }
 
-inline bool Server::listen_after_bind() {
-  auto se = detail::scope_exit([&]() { done_ = true; });
-  return listen_internal();
-}
+inline bool Server::listen_after_bind() { return listen_internal(); }
 
 inline bool Server::listen(const std::string &host, int port,
                            int socket_flags) {
-  auto se = detail::scope_exit([&]() { done_ = true; });
   return bind_to_port(host, port, socket_flags) && listen_internal();
 }
 
 inline bool Server::is_running() const { return is_running_; }
 
 inline void Server::wait_until_ready() const {
-  while (!is_running() && !done_) {
+  while (!is_running_ && !is_decommisioned) {
     std::this_thread::sleep_for(std::chrono::milliseconds{1});
   }
 }
@@ -6132,8 +6434,11 @@ inline void Server::stop() {
     detail::shutdown_socket(sock);
     detail::close_socket(sock);
   }
+  is_decommisioned = false;
 }
 
+inline void Server::decommission() { is_decommisioned = true; }
+
 inline bool Server::parse_request_line(const char *s, Request &req) const {
   auto len = strlen(s);
   if (len < 2 || s[len - 2] != '\r' || s[len - 1] != '\n') { return false; }
@@ -6217,23 +6522,24 @@ inline bool Server::write_response_core(
   if (close_connection || req.get_header_value("Connection") == "close") {
     res.set_header("Connection", "close");
   } else {
-    std::stringstream ss;
-    ss << "timeout=" << keep_alive_timeout_sec_
-       << ", max=" << keep_alive_max_count_;
-    res.set_header("Keep-Alive", ss.str());
+    std::string s = "timeout=";
+    s += std::to_string(keep_alive_timeout_sec_);
+    s += ", max=";
+    s += std::to_string(keep_alive_max_count_);
+    res.set_header("Keep-Alive", s);
   }
 
-  if (!res.has_header("Content-Type") &&
-      (!res.body.empty() || res.content_length_ > 0 || res.content_provider_)) {
+  if ((!res.body.empty() || res.content_length_ > 0 || res.content_provider_) &&
+      !res.has_header("Content-Type")) {
     res.set_header("Content-Type", "text/plain");
   }
 
-  if (!res.has_header("Content-Length") && res.body.empty() &&
-      !res.content_length_ && !res.content_provider_) {
+  if (res.body.empty() && !res.content_length_ && !res.content_provider_ &&
+      !res.has_header("Content-Length")) {
     res.set_header("Content-Length", "0");
   }
 
-  if (!res.has_header("Accept-Ranges") && req.method == "HEAD") {
+  if (req.method == "HEAD" && !res.has_header("Accept-Ranges")) {
     res.set_header("Accept-Ranges", "bytes");
   }
 
@@ -6242,12 +6548,7 @@ inline bool Server::write_response_core(
   // Response line and headers
   {
     detail::BufferStream bstrm;
-
-    if (!bstrm.write_format("HTTP/1.1 %d %s\r\n", res.status,
-                            status_message(res.status))) {
-      return false;
-    }
-
+    if (!detail::write_response_line(bstrm, res.status)) { return false; }
     if (!header_writer_(bstrm, res.headers)) { return false; }
 
     // Flush buffer
@@ -6441,7 +6742,14 @@ inline bool Server::handle_file_request(
         auto path = entry.base_dir + sub_path;
         if (path.back() == '/') { path += "index.html"; }
 
-        if (detail::is_file(path)) {
+        detail::FileStat stat(path);
+
+        if (stat.is_dir()) {
+          res.set_redirect(sub_path + "/", StatusCode::MovedPermanently_301);
+          return true;
+        }
+
+        if (stat.is_file()) {
           for (const auto &kv : entry.headers) {
             res.set_header(kv.first, kv.second);
           }
@@ -6476,7 +6784,7 @@ Server::create_server_socket(const std::
                              SocketOptions socket_options) const {
   return detail::create_socket(
       host, std::string(), port, address_family_, socket_flags, tcp_nodelay_,
-      std::move(socket_options),
+      ipv6_v6only_, std::move(socket_options),
       [](socket_t sock, struct addrinfo &ai, bool & /*quit*/) -> bool {
         if (::bind(sock, ai.ai_addr, static_cast<socklen_t>(ai.ai_addrlen))) {
           return false;
@@ -6488,6 +6796,8 @@ Server::create_server_socket(const std::
 
 inline int Server::bind_internal(const std::string &host, int port,
                                  int socket_flags) {
+  if (is_decommisioned) { return -1; }
+
   if (!is_valid()) { return -1; }
 
   svr_sock_ = create_server_socket(host, port, socket_flags, socket_options_);
@@ -6513,6 +6823,8 @@ inline int Server::bind_internal(const s
 }
 
 inline bool Server::listen_internal() {
+  if (is_decommisioned) { return false; }
+
   auto ret = true;
   is_running_ = true;
   auto se = detail::scope_exit([&]() { is_running_ = false; });
@@ -6548,7 +6860,7 @@ inline bool Server::listen_internal() {
         if (errno == EMFILE) {
           // The per-process limit of open file descriptors has been reached.
           // Try to accept new connections after a short sleep.
-          std::this_thread::sleep_for(std::chrono::milliseconds(1));
+          std::this_thread::sleep_for(std::chrono::microseconds{1});
           continue;
         } else if (errno == EINTR || errno == EAGAIN) {
           continue;
@@ -6602,6 +6914,7 @@ inline bool Server::listen_internal() {
     task_queue->shutdown();
   }
 
+  is_decommisioned = !ret;
   return ret;
 }
 
@@ -6817,7 +7130,9 @@ inline bool Server::dispatch_request_for
 }
 
 inline bool
-Server::process_request(Stream &strm, bool close_connection,
+Server::process_request(Stream &strm, const std::string &remote_addr,
+                        int remote_port, const std::string &local_addr,
+                        int local_port, bool close_connection,
                         bool &connection_closed,
                         const std::function<void(Request &)> &setup_request) {
   std::array<char, 2048> buf{};
@@ -6871,11 +7186,13 @@ Server::process_request(Stream &strm, bo
     connection_closed = true;
   }
 
-  strm.get_remote_ip_and_port(req.remote_addr, req.remote_port);
+  req.remote_addr = remote_addr;
+  req.remote_port = remote_port;
   req.set_header("REMOTE_ADDR", req.remote_addr);
   req.set_header("REMOTE_PORT", std::to_string(req.remote_port));
 
-  strm.get_local_ip_and_port(req.local_addr, req.local_port);
+  req.local_addr = local_addr;
+  req.local_port = local_port;
   req.set_header("LOCAL_ADDR", req.local_addr);
   req.set_header("LOCAL_PORT", std::to_string(req.local_port));
 
@@ -6897,13 +7214,20 @@ Server::process_request(Stream &strm, bo
     switch (status) {
     case StatusCode::Continue_100:
     case StatusCode::ExpectationFailed_417:
-      strm.write_format("HTTP/1.1 %d %s\r\n\r\n", status,
-                        status_message(status));
+      detail::write_response_line(strm, status);
+      strm.write("\r\n");
       break;
-    default: return write_response(strm, close_connection, req, res);
+    default:
+      connection_closed = true;
+      return write_response(strm, true, req, res);
     }
   }
 
+  // Setup `is_connection_closed` method
+  req.is_connection_closed = [&]() {
+    return !detail::is_socket_alive(strm.socket());
+  };
+
   // Routing
   auto routed = false;
 #ifdef CPPHTTPLIB_NO_EXCEPTIONS
@@ -6946,6 +7270,32 @@ Server::process_request(Stream &strm, bo
                                       : StatusCode::PartialContent_206;
     }
 
+    // Serve file content by using a content provider
+    if (!res.file_content_path_.empty()) {
+      const auto &path = res.file_content_path_;
+      auto mm = std::make_shared<detail::mmap>(path.c_str());
+      if (!mm->is_open()) {
+        res.body.clear();
+        res.content_length_ = 0;
+        res.content_provider_ = nullptr;
+        res.status = StatusCode::NotFound_404;
+        return write_response(strm, close_connection, req, res);
+      }
+
+      auto content_type = res.file_content_content_type_;
+      if (content_type.empty()) {
+        content_type = detail::find_content_type(
+            path, file_extension_and_mimetype_map_, default_file_mimetype_);
+      }
+
+      res.set_content_provider(
+          mm->size(), content_type,
+          [mm](size_t offset, size_t length, DataSink &sink) -> bool {
+            sink.write(mm->data() + offset, length);
+            return true;
+          });
+    }
+
     if (detail::range_error(req, res)) {
       res.body.clear();
       res.content_length_ = 0;
@@ -6965,12 +7315,21 @@ Server::process_request(Stream &strm, bo
 inline bool Server::is_valid() const { return true; }
 
 inline bool Server::process_and_close_socket(socket_t sock) {
+  std::string remote_addr;
+  int remote_port = 0;
+  detail::get_remote_ip_and_port(sock, remote_addr, remote_port);
+
+  std::string local_addr;
+  int local_port = 0;
+  detail::get_local_ip_and_port(sock, local_addr, local_port);
+
   auto ret = detail::process_server_socket(
       svr_sock_, sock, keep_alive_max_count_, keep_alive_timeout_sec_,
       read_timeout_sec_, read_timeout_usec_, write_timeout_sec_,
       write_timeout_usec_,
-      [this](Stream &strm, bool close_connection, bool &connection_closed) {
-        return process_request(strm, close_connection, connection_closed,
+      [&](Stream &strm, bool close_connection, bool &connection_closed) {
+        return process_request(strm, remote_addr, remote_port, local_addr,
+                               local_port, close_connection, connection_closed,
                                nullptr);
       });
 
@@ -6989,8 +7348,8 @@ inline ClientImpl::ClientImpl(const std:
 inline ClientImpl::ClientImpl(const std::string &host, int port,
                               const std::string &client_cert_path,
                               const std::string &client_key_path)
-    : host_(host), port_(port),
-      host_and_port_(adjust_host_string(host) + ":" + std::to_string(port)),
+    : host_(detail::escape_abstract_namespace_unix_domain(host)), port_(port),
+      host_and_port_(adjust_host_string(host_) + ":" + std::to_string(port)),
       client_cert_path_(client_cert_path), client_key_path_(client_key_path) {}
 
 inline ClientImpl::~ClientImpl() {
@@ -7021,6 +7380,7 @@ inline void ClientImpl::copy_settings(co
   url_encode_ = rhs.url_encode_;
   address_family_ = rhs.address_family_;
   tcp_nodelay_ = rhs.tcp_nodelay_;
+  ipv6_v6only_ = rhs.ipv6_v6only_;
   socket_options_ = rhs.socket_options_;
   compress_ = rhs.compress_;
   decompress_ = rhs.decompress_;
@@ -7041,6 +7401,8 @@ inline void ClientImpl::copy_settings(co
 #endif
 #ifdef CPPHTTPLIB_OPENSSL_SUPPORT
   server_certificate_verification_ = rhs.server_certificate_verification_;
+  server_hostname_verification_ = rhs.server_hostname_verification_;
+  server_certificate_verifier_ = rhs.server_certificate_verifier_;
 #endif
   logger_ = rhs.logger_;
 }
@@ -7049,9 +7411,9 @@ inline socket_t ClientImpl::create_clien
   if (!proxy_host_.empty() && proxy_port_ != -1) {
     return detail::create_client_socket(
         proxy_host_, std::string(), proxy_port_, address_family_, tcp_nodelay_,
-        socket_options_, connection_timeout_sec_, connection_timeout_usec_,
-        read_timeout_sec_, read_timeout_usec_, write_timeout_sec_,
-        write_timeout_usec_, interface_, error);
+        ipv6_v6only_, socket_options_, connection_timeout_sec_,
+        connection_timeout_usec_, read_timeout_sec_, read_timeout_usec_,
+        write_timeout_sec_, write_timeout_usec_, interface_, error);
   }
 
   // Check is custom IP specified for host_
@@ -7060,10 +7422,10 @@ inline socket_t ClientImpl::create_clien
   if (it != addr_map_.end()) { ip = it->second; }
 
   return detail::create_client_socket(
-      host_, ip, port_, address_family_, tcp_nodelay_, socket_options_,
-      connection_timeout_sec_, connection_timeout_usec_, read_timeout_sec_,
-      read_timeout_usec_, write_timeout_sec_, write_timeout_usec_, interface_,
-      error);
+      host_, ip, port_, address_family_, tcp_nodelay_, ipv6_v6only_,
+      socket_options_, connection_timeout_sec_, connection_timeout_usec_,
+      read_timeout_sec_, read_timeout_usec_, write_timeout_sec_,
+      write_timeout_usec_, interface_, error);
 }
 
 inline bool ClientImpl::create_and_connect_socket(Socket &socket,
@@ -7152,6 +7514,18 @@ inline bool ClientImpl::send(Request &re
   return ret;
 }
 
+#ifdef CPPHTTPLIB_OPENSSL_SUPPORT
+inline bool ClientImpl::is_ssl_peer_could_be_closed(SSL *ssl) const {
+  detail::set_nonblocking(socket_.sock, true);
+  auto se = detail::scope_exit(
+      [&]() { detail::set_nonblocking(socket_.sock, false); });
+
+  char buf[1];
+  return !SSL_peek(ssl, buf, 1) &&
+         SSL_get_error(ssl, 0) == SSL_ERROR_ZERO_RETURN;
+}
+#endif
+
 inline bool ClientImpl::send_(Request &req, Response &res, Error &error) {
   {
     std::lock_guard<std::mutex> guard(socket_mutex_);
@@ -7163,6 +7537,13 @@ inline bool ClientImpl::send_(Request &r
     auto is_alive = false;
     if (socket_.is_open()) {
       is_alive = detail::is_socket_alive(socket_.sock);
+
+#ifdef CPPHTTPLIB_OPENSSL_SUPPORT
+      if (is_alive && is_ssl()) {
+        if (is_ssl_peer_could_be_closed(socket_.ssl)) { is_alive = false; }
+      }
+#endif
+
       if (!is_alive) {
         // Attempt to avoid sigpipe by shutting down nongracefully if it seems
         // like the other side has already closed the connection Also, there
@@ -7439,12 +7820,26 @@ inline bool ClientImpl::write_request(St
 
   if (!req.has_header("Accept")) { req.set_header("Accept", "*/*"); }
 
+  if (!req.content_receiver) {
+    if (!req.has_header("Accept-Encoding")) {
+      std::string accept_encoding;
+#ifdef CPPHTTPLIB_BROTLI_SUPPORT
+      accept_encoding = "br";
+#endif
+#ifdef CPPHTTPLIB_ZLIB_SUPPORT
+      if (!accept_encoding.empty()) { accept_encoding += ", "; }
+      accept_encoding += "gzip, deflate";
+#endif
+      req.set_header("Accept-Encoding", accept_encoding);
+    }
+
 #ifndef CPPHTTPLIB_NO_DEFAULT_USER_AGENT
-  if (!req.has_header("User-Agent")) {
-    auto agent = std::string("cpp-httplib/") + CPPHTTPLIB_VERSION;
-    req.set_header("User-Agent", agent);
-  }
+    if (!req.has_header("User-Agent")) {
+      auto agent = std::string("cpp-httplib/") + CPPHTTPLIB_VERSION;
+      req.set_header("User-Agent", agent);
+    }
 #endif
+  };
 
   if (req.body.empty()) {
     if (req.content_provider_) {
@@ -7504,8 +7899,14 @@ inline bool ClientImpl::write_request(St
   {
     detail::BufferStream bstrm;
 
-    const auto &path = url_encode_ ? detail::encode_url(req.path) : req.path;
-    bstrm.write_format("%s %s HTTP/1.1\r\n", req.method.c_str(), path.c_str());
+    const auto &path_with_query =
+        req.params.empty() ? req.path
+                           : append_query_params(req.path, req.params);
+
+    const auto &path =
+        url_encode_ ? detail::encode_url(path_with_query) : path_with_query;
+
+    detail::write_request_line(bstrm, req.method, path);
 
     header_writer_(bstrm, req.headers);
 
@@ -7645,9 +8046,7 @@ inline bool ClientImpl::process_request(
   if (is_ssl()) {
     auto is_proxy_enabled = !proxy_host_.empty() && proxy_port_ != -1;
     if (!is_proxy_enabled) {
-      char buf[1];
-      if (SSL_peek(socket_.ssl, buf, 1) == 0 &&
-          SSL_get_error(socket_.ssl, 0) == SSL_ERROR_ZERO_RETURN) {
+      if (is_ssl_peer_could_be_closed(socket_.ssl)) {
         error = Error::SSLPeerCouldBeClosed_;
         return false;
       }
@@ -7665,7 +8064,9 @@ inline bool ClientImpl::process_request(
   // Body
   if ((res.status != StatusCode::NoContent_204) && req.method != "HEAD" &&
       req.method != "CONNECT") {
-    auto redirect = 300 < res.status && res.status < 400 && follow_location_;
+    auto redirect = 300 < res.status && res.status < 400 &&
+                    res.status != StatusCode::NotModified_304 &&
+                    follow_location_;
 
     if (req.response_handler && !redirect) {
       if (!req.response_handler(res)) {
@@ -7686,9 +8087,7 @@ inline bool ClientImpl::process_request(
             : static_cast<ContentReceiverWithProgress>(
                   [&](const char *buf, size_t n, uint64_t /*off*/,
                       uint64_t /*len*/) {
-                    if (res.body.size() + n > res.body.max_size()) {
-                      return false;
-                    }
+                    assert(res.body.size() + n <= res.body.max_size());
                     res.body.append(buf, n);
                     return true;
                   });
@@ -7700,12 +8099,25 @@ inline bool ClientImpl::process_request(
       return ret;
     };
 
-    int dummy_status;
-    if (!detail::read_content(strm, res, (std::numeric_limits<size_t>::max)(),
-                              dummy_status, std::move(progress), std::move(out),
-                              decompress_)) {
-      if (error != Error::Canceled) { error = Error::Read; }
-      return false;
+    if (res.has_header("Content-Length")) {
+      if (!req.content_receiver) {
+        auto len = res.get_header_value_u64("Content-Length");
+        if (len > res.body.max_size()) {
+          error = Error::Read;
+          return false;
+        }
+        res.body.reserve(static_cast<size_t>(len));
+      }
+    }
+
+    if (res.status != StatusCode::NotModified_304) {
+      int dummy_status;
+      if (!detail::read_content(strm, res, (std::numeric_limits<size_t>::max)(),
+                                dummy_status, std::move(progress),
+                                std::move(out), decompress_)) {
+        if (error != Error::Canceled) { error = Error::Read; }
+        return false;
+      }
     }
   }
 
@@ -8459,6 +8871,8 @@ inline void ClientImpl::set_address_fami
 
 inline void ClientImpl::set_tcp_nodelay(bool on) { tcp_nodelay_ = on; }
 
+inline void ClientImpl::set_ipv6_v6only(bool on) { ipv6_v6only_ = on; }
+
 inline void ClientImpl::set_socket_options(SocketOptions socket_options) {
   socket_options_ = std::move(socket_options);
 }
@@ -8508,13 +8922,11 @@ inline void ClientImpl::set_ca_cert_stor
 inline X509_STORE *ClientImpl::create_ca_cert_store(const char *ca_cert,
                                                     std::size_t size) const {
   auto mem = BIO_new_mem_buf(ca_cert, static_cast<int>(size));
+  auto se = detail::scope_exit([&] { BIO_free_all(mem); });
   if (!mem) { return nullptr; }
 
   auto inf = PEM_X509_INFO_read_bio(mem, nullptr, nullptr, nullptr);
-  if (!inf) {
-    BIO_free_all(mem);
-    return nullptr;
-  }
+  if (!inf) { return nullptr; }
 
   auto cts = X509_STORE_new();
   if (cts) {
@@ -8528,13 +8940,21 @@ inline X509_STORE *ClientImpl::create_ca
   }
 
   sk_X509_INFO_pop_free(inf, X509_INFO_free);
-  BIO_free_all(mem);
   return cts;
 }
 
 inline void ClientImpl::enable_server_certificate_verification(bool enabled) {
   server_certificate_verification_ = enabled;
 }
+
+inline void ClientImpl::enable_server_hostname_verification(bool enabled) {
+  server_hostname_verification_ = enabled;
+}
+
+inline void ClientImpl::set_server_certificate_verifier(
+    std::function<bool(SSL *ssl)> verifier) {
+  server_certificate_verifier_ = verifier;
+}
 #endif
 
 inline void ClientImpl::set_logger(Logger logger) {
@@ -8586,6 +9006,7 @@ inline void ssl_delete(std::mutex &ctx_m
   // best-efforts.
   if (shutdown_gracefully) {
 #ifdef _WIN32
+    (void)(sock);
     SSL_shutdown(ssl);
 #else
     timeval tv;
@@ -8596,7 +9017,7 @@ inline void ssl_delete(std::mutex &ctx_m
 
     auto ret = SSL_shutdown(ssl);
     while (ret == 0) {
-      std::this_thread::sleep_for(std::chrono::milliseconds(100));
+      std::this_thread::sleep_for(std::chrono::milliseconds{100});
       ret = SSL_shutdown(ssl);
     }
 #endif
@@ -8703,7 +9124,7 @@ inline ssize_t SSLSocketStream::read(cha
         if (SSL_pending(ssl_) > 0) {
           return SSL_read(ssl_, ptr, static_cast<int>(size));
         } else if (is_readable()) {
-          std::this_thread::sleep_for(std::chrono::milliseconds(1));
+          std::this_thread::sleep_for(std::chrono::microseconds{10});
           ret = SSL_read(ssl_, ptr, static_cast<int>(size));
           if (ret >= 0) { return ret; }
           err = SSL_get_error(ssl_, ret);
@@ -8734,7 +9155,7 @@ inline ssize_t SSLSocketStream::write(co
       while (--n >= 0 && err == SSL_ERROR_WANT_WRITE) {
 #endif
         if (is_writable()) {
-          std::this_thread::sleep_for(std::chrono::milliseconds(1));
+          std::this_thread::sleep_for(std::chrono::microseconds{10});
           ret = SSL_write(ssl_, ptr, static_cast<int>(handle_size));
           if (ret >= 0) { return ret; }
           err = SSL_get_error(ssl_, ret);
@@ -8786,7 +9207,8 @@ inline SSLServer::SSLServer(const char *
 
     if (SSL_CTX_use_certificate_chain_file(ctx_, cert_path) != 1 ||
         SSL_CTX_use_PrivateKey_file(ctx_, private_key_path, SSL_FILETYPE_PEM) !=
-            1) {
+            1 ||
+        SSL_CTX_check_private_key(ctx_) != 1) {
       SSL_CTX_free(ctx_);
       ctx_ = nullptr;
     } else if (client_ca_cert_file_path || client_ca_cert_dir_path) {
@@ -8866,13 +9288,22 @@ inline bool SSLServer::process_and_close
 
   auto ret = false;
   if (ssl) {
+    std::string remote_addr;
+    int remote_port = 0;
+    detail::get_remote_ip_and_port(sock, remote_addr, remote_port);
+
+    std::string local_addr;
+    int local_port = 0;
+    detail::get_local_ip_and_port(sock, local_addr, local_port);
+
     ret = detail::process_server_socket_ssl(
         svr_sock_, ssl, sock, keep_alive_max_count_, keep_alive_timeout_sec_,
         read_timeout_sec_, read_timeout_usec_, write_timeout_sec_,
         write_timeout_usec_,
-        [this, ssl](Stream &strm, bool close_connection,
-                    bool &connection_closed) {
-          return process_request(strm, close_connection, connection_closed,
+        [&](Stream &strm, bool close_connection, bool &connection_closed) {
+          return process_request(strm, remote_addr, remote_port, local_addr,
+                                 local_port, close_connection,
+                                 connection_closed,
                                  [&](Request &req) { req.ssl = ssl; });
         });
 
@@ -8901,6 +9332,8 @@ inline SSLClient::SSLClient(const std::s
     : ClientImpl(host, port, client_cert_path, client_key_path) {
   ctx_ = SSL_CTX_new(TLS_client_method());
 
+  SSL_CTX_set_min_proto_version(ctx_, TLS1_2_VERSION);
+
   detail::split(&host_[0], &host_[host_.size()], '.',
                 [&](const char *b, const char *e) {
                   host_components_.emplace_back(b, e);
@@ -9108,26 +9541,34 @@ inline bool SSLClient::initialize_ssl(So
         }
 
         if (server_certificate_verification_) {
-          verify_result_ = SSL_get_verify_result(ssl2);
+          if (server_certificate_verifier_) {
+            if (!server_certificate_verifier_(ssl2)) {
+              error = Error::SSLServerVerification;
+              return false;
+            }
+          } else {
+            verify_result_ = SSL_get_verify_result(ssl2);
 
-          if (verify_result_ != X509_V_OK) {
-            error = Error::SSLServerVerification;
-            return false;
-          }
+            if (verify_result_ != X509_V_OK) {
+              error = Error::SSLServerVerification;
+              return false;
+            }
 
-          auto server_cert = SSL_get1_peer_certificate(ssl2);
+            auto server_cert = SSL_get1_peer_certificate(ssl2);
+            auto se = detail::scope_exit([&] { X509_free(server_cert); });
 
-          if (server_cert == nullptr) {
-            error = Error::SSLServerVerification;
-            return false;
-          }
+            if (server_cert == nullptr) {
+              error = Error::SSLServerVerification;
+              return false;
+            }
 
-          if (!verify_host(server_cert)) {
-            X509_free(server_cert);
-            error = Error::SSLServerVerification;
-            return false;
+            if (server_hostname_verification_) {
+              if (!verify_host(server_cert)) {
+                error = Error::SSLServerHostnameVerification;
+                return false;
+              }
+            }
           }
-          X509_free(server_cert);
         }
 
         return true;
@@ -9215,8 +9656,8 @@ SSLClient::verify_host_with_subject_alt_
 
   auto type = GEN_DNS;
 
-  struct in6_addr addr6 {};
-  struct in_addr addr {};
+  struct in6_addr addr6{};
+  struct in_addr addr{};
   size_t addr_len = 0;
 
 #ifndef __MINGW32__
@@ -9858,6 +10299,15 @@ inline void Client::set_proxy_digest_aut
 inline void Client::enable_server_certificate_verification(bool enabled) {
   cli_->enable_server_certificate_verification(enabled);
 }
+
+inline void Client::enable_server_hostname_verification(bool enabled) {
+  cli_->enable_server_hostname_verification(enabled);
+}
+
+inline void Client::set_server_certificate_verifier(
+    std::function<bool(SSL *ssl)> verifier) {
+  cli_->set_server_certificate_verifier(verifier);
+}
 #endif
 
 inline void Client::set_logger(Logger logger) {
diff -pruN 0.16.3+ds-2/meson.build 0.18.7-1/meson.build
--- 0.16.3+ds-2/meson.build	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/meson.build	2025-02-08 20:53:35.000000000 +0000
@@ -13,7 +13,7 @@ project(
     'b_lto=true',
     'warning_level=3'
   ],
-  meson_version: '>=0.47.0'
+  meson_version: '>=0.62.0'
 )
 
 # Check just in case downstream decides to edit the source
@@ -98,20 +98,18 @@ if get_option('cpp-httplib_compile')
   )
 else
   install_headers('httplib.h')
-  cpp_httplib_dep = declare_dependency(compile_args: args, dependencies: deps, include_directories: include_directories('.'))
+  cpp_httplib_dep = declare_dependency(compile_args: args, dependencies: deps, include_directories: '.')
 
   import('pkgconfig').generate(
     name: 'cpp-httplib',
     description: 'A C++ HTTP/HTTPS server and client library',
-    install_dir: join_paths(get_option('datadir'), 'pkgconfig'),
+    install_dir: get_option('datadir')/'pkgconfig',
     url: 'https://github.com/yhirose/cpp-httplib',
     version: version
   )
 endif
 
-if meson.version().version_compare('>=0.54.0')
-  meson.override_dependency('cpp-httplib', cpp_httplib_dep)
-endif
+meson.override_dependency('cpp-httplib', cpp_httplib_dep)
 
 if get_option('cpp-httplib_test')
   subdir('test')
diff -pruN 0.16.3+ds-2/test/CMakeLists.txt 0.18.7-1/test/CMakeLists.txt
--- 0.16.3+ds-2/test/CMakeLists.txt	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/test/CMakeLists.txt	2025-02-08 20:53:35.000000000 +0000
@@ -24,9 +24,11 @@ else()
     FetchContent_MakeAvailable(gtest)
 endif()
 
+find_package(CURL REQUIRED)
+
 add_executable(httplib-test test.cc)
 target_compile_options(httplib-test PRIVATE "$<$<CXX_COMPILER_ID:MSVC>:/utf-8;/bigobj>")
-target_link_libraries(httplib-test PRIVATE httplib GTest::gtest_main)
+target_link_libraries(httplib-test PRIVATE httplib GTest::gtest_main CURL::libcurl)
 gtest_discover_tests(httplib-test)
 
 file(
@@ -35,6 +37,11 @@ file(
 )
 
 if(HTTPLIB_IS_USING_OPENSSL)
+    if (OPENSSL_VERSION VERSION_LESS "3.2.0")
+      set(OPENSSL_X509_FLAG "-x509")
+    else()
+      set(OPENSSL_X509_FLAG "-x509v1")
+    endif()
     find_program(OPENSSL_COMMAND
         NAMES openssl
         PATHS ${OPENSSL_INCLUDE_DIR}/../bin
@@ -54,7 +61,7 @@ if(HTTPLIB_IS_USING_OPENSSL)
         COMMAND_ERROR_IS_FATAL ANY
     )
     execute_process(
-        COMMAND ${OPENSSL_COMMAND} req -x509 -new -config ${CMAKE_CURRENT_LIST_DIR}/test.conf -key key.pem -sha256 -days 3650 -nodes -out cert2.pem -extensions SAN
+        COMMAND ${OPENSSL_COMMAND} req ${OPENSSL_X509_FLAG} -new -config ${CMAKE_CURRENT_LIST_DIR}/test.conf -key key.pem -sha256 -days 3650 -nodes -out cert2.pem -extensions SAN
         WORKING_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR}
         COMMAND_ERROR_IS_FATAL ANY
     )
@@ -65,7 +72,7 @@ if(HTTPLIB_IS_USING_OPENSSL)
         COMMAND_ERROR_IS_FATAL ANY
     )
     execute_process(
-        COMMAND ${OPENSSL_COMMAND} req -x509 -new -batch -config ${CMAKE_CURRENT_LIST_DIR}/test.rootCA.conf -key rootCA.key.pem -days 1024
+        COMMAND ${OPENSSL_COMMAND} req ${OPENSSL_X509_FLAG} -new -batch -config ${CMAKE_CURRENT_LIST_DIR}/test.rootCA.conf -key rootCA.key.pem -days 1024
         OUTPUT_FILE rootCA.cert.pem
         WORKING_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR}
         COMMAND_ERROR_IS_FATAL ANY
diff -pruN 0.16.3+ds-2/test/Makefile 0.18.7-1/test/Makefile
--- 0.16.3+ds-2/test/Makefile	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/test/Makefile	2025-02-08 20:53:35.000000000 +0000
@@ -18,7 +18,7 @@ ZLIB_SUPPORT = -DCPPHTTPLIB_ZLIB_SUPPORT
 BROTLI_DIR = $(PREFIX)/opt/brotli
 BROTLI_SUPPORT = -DCPPHTTPLIB_BROTLI_SUPPORT -I$(BROTLI_DIR)/include -L$(BROTLI_DIR)/lib -lbrotlicommon -lbrotlienc -lbrotlidec
 
-TEST_ARGS = gtest/gtest-all.cc gtest/gtest_main.cc $(OPENSSL_SUPPORT) $(ZLIB_SUPPORT) $(BROTLI_SUPPORT) -pthread
+TEST_ARGS = gtest/gtest-all.cc gtest/gtest_main.cc $(OPENSSL_SUPPORT) $(ZLIB_SUPPORT) $(BROTLI_SUPPORT) -pthread -lcurl
 
 # By default, use standalone_fuzz_target_runner.
 # This runner does no fuzzing, but simply executes the inputs
@@ -63,18 +63,8 @@ httplib.cc : ../httplib.h
 	python3 ../split.py -o .
 
 cert.pem:
-	openssl genrsa 2048 > key.pem
-	openssl req -new -batch -config test.conf -key key.pem | openssl x509 -days 3650 -req -signkey key.pem > cert.pem
-	openssl req -x509 -config test.conf -key key.pem -sha256 -days 3650 -nodes -out cert2.pem -extensions SAN
-	openssl genrsa 2048 > rootCA.key.pem
-	openssl req -x509 -new -batch -config test.rootCA.conf -key rootCA.key.pem -days 1024 > rootCA.cert.pem
-	openssl genrsa 2048 > client.key.pem
-	openssl req -new -batch -config test.conf -key client.key.pem | openssl x509 -days 370 -req -CA rootCA.cert.pem -CAkey rootCA.key.pem -CAcreateserial > client.cert.pem
-	openssl genrsa -passout pass:test123! 2048 > key_encrypted.pem
-	openssl req -new -batch -config test.conf -key key_encrypted.pem | openssl x509 -days 3650 -req -signkey key_encrypted.pem > cert_encrypted.pem
-	openssl genrsa -aes256 -passout pass:test012! 2048 > client_encrypted.key.pem
-	openssl req -new -batch -config test.conf -key client_encrypted.key.pem -passin pass:test012! | openssl x509 -days 370 -req -CA rootCA.cert.pem -CAkey rootCA.key.pem -CAcreateserial > client_encrypted.cert.pem
-	#c_rehash .
+	./gen-certs.sh
 
 clean:
 	rm -f test test_split test_proxy server_fuzzer *.pem *.0 *.o *.1 *.srl httplib.h httplib.cc
+
diff -pruN 0.16.3+ds-2/test/gen-certs.sh 0.18.7-1/test/gen-certs.sh
--- 0.16.3+ds-2/test/gen-certs.sh	1970-01-01 00:00:00.000000000 +0000
+++ 0.18.7-1/test/gen-certs.sh	2025-02-08 20:53:35.000000000 +0000
@@ -0,0 +1,18 @@
+#!/usr/bin/env bash
+if [[ $(openssl version) =~ 3\.[2-9]\.[0-9]+ ]]; then
+	OPENSSL_X509_FLAG='-x509v1'
+else
+	OPENSSL_X509_FLAG='-x509'
+fi
+
+openssl genrsa 2048 > key.pem
+openssl req -new -batch -config test.conf -key key.pem | openssl x509 -days 3650 -req -signkey key.pem > cert.pem
+openssl req -x509 -config test.conf -key key.pem -sha256 -days 3650 -nodes -out cert2.pem -extensions SAN
+openssl genrsa 2048 > rootCA.key.pem
+openssl req $OPENSSL_X509_FLAG -new -batch -config test.rootCA.conf -key rootCA.key.pem -days 1024 > rootCA.cert.pem
+openssl genrsa 2048 > client.key.pem
+openssl req -new -batch -config test.conf -key client.key.pem | openssl x509 -days 370 -req -CA rootCA.cert.pem -CAkey rootCA.key.pem -CAcreateserial > client.cert.pem
+openssl genrsa -passout pass:test123! 2048 > key_encrypted.pem
+openssl req -new -batch -config test.conf -key key_encrypted.pem | openssl x509 -days 3650 -req -signkey key_encrypted.pem > cert_encrypted.pem
+openssl genrsa -aes256 -passout pass:test012! 2048 > client_encrypted.key.pem
+openssl req -new -batch -config test.conf -key client_encrypted.key.pem -passin pass:test012! | openssl x509 -days 370 -req -CA rootCA.cert.pem -CAkey rootCA.key.pem -CAcreateserial > client_encrypted.cert.pem
diff -pruN 0.16.3+ds-2/test/meson.build 0.18.7-1/test/meson.build
--- 0.16.3+ds-2/test/meson.build	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/test/meson.build	2025-02-08 20:53:35.000000000 +0000
@@ -3,8 +3,10 @@
 # SPDX-License-Identifier: MIT
 
 gtest_dep = dependency('gtest', main: true)
+libcurl_dep = dependency('libcurl')
 openssl = find_program('openssl')
 test_conf = files('test.conf')
+req_x509_flag = openssl.version().version_compare('>=3.2.0') ? '-x509v1' : '-x509'
 
 key_pem = custom_target(
   'key_pem',
@@ -30,7 +32,7 @@ cert2_pem = custom_target(
   'cert2_pem',
   input: key_pem,
   output: 'cert2.pem',
-  command: [openssl, 'req', '-x509', '-config', test_conf, '-key', '@INPUT@', '-sha256', '-days', '3650', '-nodes', '-out', '@OUTPUT@', '-extensions', 'SAN']
+  command: [openssl, 'req', req_x509_flag, '-config', test_conf, '-key', '@INPUT@', '-sha256', '-days', '3650', '-nodes', '-out', '@OUTPUT@', '-extensions', 'SAN']
 )
 
 key_encrypted_pem = custom_target(
@@ -43,7 +45,7 @@ cert_encrypted_pem = custom_target(
   'cert_encrypted_pem',
   input: key_encrypted_pem,
   output: 'cert_encrypted.pem',
-  command: [openssl, 'req', '-x509', '-config', test_conf, '-key', '@INPUT@', '-sha256', '-days', '3650', '-nodes', '-out', '@OUTPUT@', '-extensions', 'SAN']
+  command: [openssl, 'req', req_x509_flag, '-config', test_conf, '-key', '@INPUT@', '-sha256', '-days', '3650', '-nodes', '-out', '@OUTPUT@', '-extensions', 'SAN']
 )
 
 rootca_key_pem = custom_target(
@@ -56,7 +58,7 @@ rootca_cert_pem = custom_target(
   'rootca_cert_pem',
   input: rootca_key_pem,
   output: 'rootCA.cert.pem',
-  command: [openssl, 'req', '-x509', '-new', '-batch', '-config', files('test.rootCA.conf'), '-key', '@INPUT@', '-days', '1024', '-out', '@OUTPUT@']
+  command: [openssl, 'req', req_x509_flag, '-new', '-batch', '-config', files('test.rootCA.conf'), '-key', '@INPUT@', '-days', '1024', '-out', '@OUTPUT@']
 )
 
 client_key_pem = custom_target(
@@ -102,9 +104,9 @@ client_encrypted_cert_pem = custom_targe
 # Copy test files to the build directory
 configure_file(input: 'ca-bundle.crt', output: 'ca-bundle.crt', copy: true)
 configure_file(input: 'image.jpg',     output: 'image.jpg',     copy: true)
-subdir(join_paths('www', 'dir'))
-subdir(join_paths('www2', 'dir'))
-subdir(join_paths('www3', 'dir'))
+subdir('www')
+subdir('www2'/'dir')
+subdir('www3'/'dir')
 
 # GoogleTest 1.13.0 requires C++14
 test_options = []
@@ -119,7 +121,8 @@ test(
     'test.cc',
     dependencies: [
       cpp_httplib_dep,
-      gtest_dep
+      gtest_dep,
+      libcurl_dep
     ],
     override_options: test_options
   ),
diff -pruN 0.16.3+ds-2/test/test.cc 0.18.7-1/test/test.cc
--- 0.16.3+ds-2/test/test.cc	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/test/test.cc	2025-02-08 20:53:35.000000000 +0000
@@ -1,6 +1,10 @@
+﻿// NOTE: This file should be saved as UTF-8 w/ BOM
 #include <httplib.h>
 #include <signal.h>
 
+#ifndef _WIN32
+#include <curl/curl.h>
+#endif
 #include <gtest/gtest.h>
 
 #include <atomic>
@@ -12,6 +16,7 @@
 #include <stdexcept>
 #include <thread>
 #include <type_traits>
+#include <vector>
 
 #define SERVER_CERT_FILE "./cert.pem"
 #define SERVER_CERT2_FILE "./cert2.pem"
@@ -237,7 +242,7 @@ TEST(DecodeURLTest, PercentCharacter) {
       detail::decode_url(
           R"(descrip=Gastos%20%C3%A1%C3%A9%C3%AD%C3%B3%C3%BA%C3%B1%C3%91%206)",
           false),
-      R"(descrip=Gastos áéíóúñÑ 6)");
+      u8"descrip=Gastos áéíóúñÑ 6");
 }
 
 TEST(DecodeURLTest, PercentCharacterNUL) {
@@ -263,9 +268,9 @@ TEST(EncodeQueryParamTest, ParseReserved
 }
 
 TEST(EncodeQueryParamTest, TestUTF8Characters) {
-  string chineseCharacters = "中国語";
-  string russianCharacters = "дом";
-  string brazilianCharacters = "óculos";
+  string chineseCharacters = u8"中国語";
+  string russianCharacters = u8"дом";
+  string brazilianCharacters = u8"óculos";
 
   EXPECT_EQ(detail::encode_query_param(chineseCharacters),
             "%E4%B8%AD%E5%9B%BD%E8%AA%9E");
@@ -467,25 +472,25 @@ TEST(ParseMultipartBoundaryTest, ValueWi
 
 TEST(GetHeaderValueTest, DefaultValue) {
   Headers headers = {{"Dummy", "Dummy"}};
-  auto val = detail::get_header_value(headers, "Content-Type", 0, "text/plain");
+  auto val = detail::get_header_value(headers, "Content-Type", "text/plain", 0);
   EXPECT_STREQ("text/plain", val);
 }
 
 TEST(GetHeaderValueTest, DefaultValueInt) {
   Headers headers = {{"Dummy", "Dummy"}};
-  auto val = detail::get_header_value_u64(headers, "Content-Length", 0, 100);
+  auto val = detail::get_header_value_u64(headers, "Content-Length", 100, 0);
   EXPECT_EQ(100ull, val);
 }
 
 TEST(GetHeaderValueTest, RegularValue) {
   Headers headers = {{"Content-Type", "text/html"}, {"Dummy", "Dummy"}};
-  auto val = detail::get_header_value(headers, "Content-Type", 0, "text/plain");
+  auto val = detail::get_header_value(headers, "Content-Type", "text/plain", 0);
   EXPECT_STREQ("text/html", val);
 }
 
 TEST(GetHeaderValueTest, RegularValueWithDifferentCase) {
   Headers headers = {{"Content-Type", "text/html"}, {"Dummy", "Dummy"}};
-  auto val = detail::get_header_value(headers, "content-type", 0, "text/plain");
+  auto val = detail::get_header_value(headers, "content-type", "text/plain", 0);
   EXPECT_STREQ("text/html", val);
 }
 
@@ -506,6 +511,15 @@ TEST(GetHeaderValueTest, RegularValueInt
   EXPECT_EQ(100ull, val);
 }
 
+TEST(GetHeaderValueTest, RegularInvalidValueInt) {
+  Headers headers = {{"Content-Length", "x"}};
+  auto is_invalid_value = false;
+  auto val = detail::get_header_value_u64(headers, "Content-Length", 0, 0,
+                                          is_invalid_value);
+  EXPECT_EQ(0ull, val);
+  EXPECT_TRUE(is_invalid_value);
+}
+
 TEST(GetHeaderValueTest, Range) {
   {
     Headers headers = {make_range_header({{1, -1}})};
@@ -1849,6 +1863,32 @@ TEST(PathUrlEncodeTest, PathUrlEncode) {
   }
 }
 
+TEST(PathUrlEncodeTest, IncludePercentEncodingLF) {
+  Server svr;
+
+  svr.Get("/", [](const Request &req, Response &) {
+    EXPECT_EQ("\x0A", req.get_param_value("something"));
+  });
+
+  auto thread = std::thread([&]() { svr.listen(HOST, PORT); });
+  auto se = detail::scope_exit([&] {
+    svr.stop();
+    thread.join();
+    ASSERT_FALSE(svr.is_running());
+  });
+
+  svr.wait_until_ready();
+
+  {
+    Client cli(HOST, PORT);
+    cli.set_url_encode(false);
+
+    auto res = cli.Get("/?something=%0A");
+    ASSERT_TRUE(res);
+    EXPECT_EQ(StatusCode::OK_200, res->status);
+  }
+}
+
 TEST(BindServerTest, DISABLED_BindDualStack) {
   Server svr;
 
@@ -1999,7 +2039,7 @@ TEST(ErrorHandlerTest, ContentLength) {
   {
     Client cli(HOST, PORT);
 
-    auto res = cli.Get("/hi");
+    auto res = cli.Get("/hi", {{"Accept-Encoding", ""}});
     ASSERT_TRUE(res);
     EXPECT_EQ(StatusCode::OK_200, res->status);
     EXPECT_EQ("text/html", res->get_header_value("Content-Type"));
@@ -2009,7 +2049,46 @@ TEST(ErrorHandlerTest, ContentLength) {
 }
 
 #ifndef CPPHTTPLIB_NO_EXCEPTIONS
-TEST(ExceptionHandlerTest, ContentLength) {
+TEST(ExceptionTest, WithoutExceptionHandler) {
+  Server svr;
+
+  svr.Get("/exception", [&](const Request & /*req*/, Response & /*res*/) {
+    throw std::runtime_error("exception...");
+  });
+
+  svr.Get("/unknown", [&](const Request & /*req*/, Response & /*res*/) {
+    throw std::runtime_error("exception\r\n...");
+  });
+
+  auto listen_thread = std::thread([&svr]() { svr.listen("localhost", PORT); });
+  auto se = detail::scope_exit([&] {
+    svr.stop();
+    listen_thread.join();
+    ASSERT_FALSE(svr.is_running());
+  });
+
+  svr.wait_until_ready();
+
+  Client cli("localhost", PORT);
+
+  {
+    auto res = cli.Get("/exception");
+    ASSERT_TRUE(res);
+    EXPECT_EQ(StatusCode::InternalServerError_500, res->status);
+    ASSERT_TRUE(res->has_header("EXCEPTION_WHAT"));
+    EXPECT_EQ("exception...", res->get_header_value("EXCEPTION_WHAT"));
+  }
+
+  {
+    auto res = cli.Get("/unknown");
+    ASSERT_TRUE(res);
+    EXPECT_EQ(StatusCode::InternalServerError_500, res->status);
+    ASSERT_TRUE(res->has_header("EXCEPTION_WHAT"));
+    EXPECT_EQ("exception\\r\\n...", res->get_header_value("EXCEPTION_WHAT"));
+  }
+}
+
+TEST(ExceptionTest, WithExceptionHandler) {
   Server svr;
 
   svr.set_exception_handler([](const Request & /*req*/, Response &res,
@@ -2017,7 +2096,9 @@ TEST(ExceptionHandlerTest, ContentLength
     EXPECT_FALSE(ep == nullptr);
     try {
       std::rethrow_exception(ep);
-    } catch (std::exception &e) { EXPECT_EQ("abc", std::string(e.what())); }
+    } catch (std::exception &e) {
+      EXPECT_EQ("abc", std::string(e.what()));
+    } catch (...) {}
     res.status = StatusCode::InternalServerError_500;
     res.set_content("abcdefghijklmnopqrstuvwxyz",
                     "text/html"); // <= Content-Length still 13 at this point
@@ -2041,7 +2122,7 @@ TEST(ExceptionHandlerTest, ContentLength
     Client cli(HOST, PORT);
 
     for (size_t j = 0; j < 100; j++) {
-      auto res = cli.Get("/hi");
+      auto res = cli.Get("/hi", {{"Accept-Encoding", ""}});
       ASSERT_TRUE(res);
       EXPECT_EQ(StatusCode::InternalServerError_500, res->status);
       EXPECT_EQ("text/html", res->get_header_value("Content-Type"));
@@ -2052,7 +2133,7 @@ TEST(ExceptionHandlerTest, ContentLength
     cli.set_keep_alive(true);
 
     for (size_t j = 0; j < 100; j++) {
-      auto res = cli.Get("/hi");
+      auto res = cli.Get("/hi", {{"Accept-Encoding", ""}});
       ASSERT_TRUE(res);
       EXPECT_EQ(StatusCode::InternalServerError_500, res->status);
       EXPECT_EQ("text/html", res->get_header_value("Content-Type"));
@@ -2061,6 +2142,66 @@ TEST(ExceptionHandlerTest, ContentLength
     }
   }
 }
+
+TEST(ExceptionTest, AndErrorHandler) {
+  Server svr;
+
+  svr.set_error_handler([](const Request & /*req*/, Response &res) {
+    if (res.body.empty()) { res.set_content("NOT_FOUND", "text/html"); }
+  });
+
+  svr.set_exception_handler(
+      [](const Request & /*req*/, Response &res, std::exception_ptr ep) {
+        EXPECT_FALSE(ep == nullptr);
+        try {
+          std::rethrow_exception(ep);
+        } catch (std::exception &e) {
+          res.set_content(e.what(), "text/html");
+        } catch (...) {}
+        res.status = StatusCode::InternalServerError_500;
+      });
+
+  svr.Get("/exception", [](const Request & /*req*/, Response & /*res*/) {
+    throw std::runtime_error("EXCEPTION");
+  });
+
+  svr.Get("/error", [](const Request & /*req*/, Response &res) {
+    res.set_content("ERROR", "text/html");
+    res.status = StatusCode::InternalServerError_500;
+  });
+
+  auto thread = std::thread([&]() { svr.listen(HOST, PORT); });
+  auto se = detail::scope_exit([&] {
+    svr.stop();
+    thread.join();
+    ASSERT_FALSE(svr.is_running());
+  });
+
+  svr.wait_until_ready();
+
+  Client cli(HOST, PORT);
+
+  {
+    auto res = cli.Get("/exception");
+    ASSERT_TRUE(res);
+    EXPECT_EQ("text/html", res->get_header_value("Content-Type"));
+    EXPECT_EQ("EXCEPTION", res->body);
+  }
+
+  {
+    auto res = cli.Get("/error");
+    ASSERT_TRUE(res);
+    EXPECT_EQ(StatusCode::InternalServerError_500, res->status);
+    EXPECT_EQ("ERROR", res->body);
+  }
+
+  {
+    auto res = cli.Get("/invalid");
+    ASSERT_TRUE(res);
+    EXPECT_EQ(StatusCode::NotFound_404, res->status);
+    EXPECT_EQ("NOT_FOUND", res->body);
+  }
+}
 #endif
 
 TEST(NoContentTest, ContentLength) {
@@ -2296,6 +2437,18 @@ protected:
              [&](const Request & /*req*/, Response &res) {
                res.set_content("Hello World!", "text/plain");
              })
+        .Get("/file_content",
+             [&](const Request & /*req*/, Response &res) {
+               res.set_file_content("./www/dir/test.html");
+             })
+        .Get("/file_content_with_content_type",
+             [&](const Request & /*req*/, Response &res) {
+               res.set_file_content("./www/file", "text/plain");
+             })
+        .Get("/invalid_file_content",
+             [&](const Request & /*req*/, Response &res) {
+               res.set_file_content("./www/dir/invalid_file_path");
+             })
         .Get("/http_response_splitting",
              [&](const Request & /*req*/, Response &res) {
                res.set_header("a", "1\r\nSet-Cookie: a=1");
@@ -2824,6 +2977,11 @@ protected:
                res.status = 401;
                res.set_header("WWW-Authenticate", "Basic realm=123456");
              })
+        .Delete("/issue609",
+                [](const httplib::Request &, httplib::Response &res,
+                   const httplib::ContentReader &) {
+                  res.set_content("ok", "text/plain");
+                })
 #if defined(CPPHTTPLIB_ZLIB_SUPPORT) || defined(CPPHTTPLIB_BROTLI_SUPPORT)
         .Get("/compress",
              [&](const Request & /*req*/, Response &res) {
@@ -2900,6 +3058,49 @@ TEST_F(ServerTest, GetMethod200) {
   EXPECT_EQ("Hello World!", res->body);
 }
 
+TEST_F(ServerTest, GetEmptyFile) {
+  auto res = cli_.Get("/empty_file");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::OK_200, res->status);
+  EXPECT_EQ("application/octet-stream", res->get_header_value("Content-Type"));
+  EXPECT_EQ(0, std::stoi(res->get_header_value("Content-Length")));
+  EXPECT_EQ("", res->body);
+}
+
+TEST_F(ServerTest, GetFileContent) {
+  auto res = cli_.Get("/file_content");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::OK_200, res->status);
+  EXPECT_EQ("text/html", res->get_header_value("Content-Type"));
+  EXPECT_EQ(9, std::stoi(res->get_header_value("Content-Length")));
+  EXPECT_EQ("test.html", res->body);
+}
+
+TEST_F(ServerTest, GetFileContentWithRange) {
+  auto res = cli_.Get("/file_content", {{make_range_header({{1, 3}})}});
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::PartialContent_206, res->status);
+  EXPECT_EQ("text/html", res->get_header_value("Content-Type"));
+  EXPECT_EQ("bytes 1-3/9", res->get_header_value("Content-Range"));
+  EXPECT_EQ(3, std::stoi(res->get_header_value("Content-Length")));
+  EXPECT_EQ("est", res->body);
+}
+
+TEST_F(ServerTest, GetFileContentWithContentType) {
+  auto res = cli_.Get("/file_content_with_content_type");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::OK_200, res->status);
+  EXPECT_EQ("text/plain", res->get_header_value("Content-Type"));
+  EXPECT_EQ(5, std::stoi(res->get_header_value("Content-Length")));
+  EXPECT_EQ("file\n", res->body);
+}
+
+TEST_F(ServerTest, GetInvalidFileContent) {
+  auto res = cli_.Get("/invalid_file_content");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::NotFound_404, res->status);
+}
+
 TEST_F(ServerTest, GetMethod200withPercentEncoding) {
   auto res = cli_.Get("/%68%69"); // auto res = cli_.Get("/hi");
   ASSERT_TRUE(res);
@@ -3643,12 +3844,27 @@ TEST_F(ServerTest, GetStreamedWithRangeE
 TEST_F(ServerTest, GetRangeWithMaxLongLength) {
   auto res = cli_.Get(
       "/with-range",
-      {{"Range",
-        "bytes=0-" + std::to_string(std::numeric_limits<long>::max())}});
-  EXPECT_EQ(StatusCode::RangeNotSatisfiable_416, res->status);
-  EXPECT_EQ("0", res->get_header_value("Content-Length"));
-  EXPECT_EQ(false, res->has_header("Content-Range"));
-  EXPECT_EQ(0U, res->body.size());
+      {{"Range", "bytes=0-" + std::to_string(std::numeric_limits<long>::max())},
+       {"Accept-Encoding", ""}});
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::PartialContent_206, res->status);
+  EXPECT_EQ("7", res->get_header_value("Content-Length"));
+  EXPECT_EQ(true, res->has_header("Content-Range"));
+  EXPECT_EQ("bytes 0-6/7", res->get_header_value("Content-Range"));
+  EXPECT_EQ(std::string("abcdefg"), res->body);
+}
+
+TEST_F(ServerTest, GetRangeWithZeroToInfinite) {
+  auto res = cli_.Get("/with-range", {
+                                         {"Range", "bytes=0-"},
+                                         {"Accept-Encoding", ""},
+                                     });
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::PartialContent_206, res->status);
+  EXPECT_EQ("7", res->get_header_value("Content-Length"));
+  EXPECT_EQ(true, res->has_header("Content-Range"));
+  EXPECT_EQ("bytes 0-6/7", res->get_header_value("Content-Range"));
+  EXPECT_EQ(std::string("abcdefg"), res->body);
 }
 
 TEST_F(ServerTest, GetStreamedWithRangeMultipart) {
@@ -3738,7 +3954,10 @@ TEST_F(ServerTest, ClientStop) {
 }
 
 TEST_F(ServerTest, GetWithRange1) {
-  auto res = cli_.Get("/with-range", {{make_range_header({{3, 5}})}});
+  auto res = cli_.Get("/with-range", {
+                                         make_range_header({{3, 5}}),
+                                         {"Accept-Encoding", ""},
+                                     });
   ASSERT_TRUE(res);
   EXPECT_EQ(StatusCode::PartialContent_206, res->status);
   EXPECT_EQ("3", res->get_header_value("Content-Length"));
@@ -3748,7 +3967,10 @@ TEST_F(ServerTest, GetWithRange1) {
 }
 
 TEST_F(ServerTest, GetWithRange2) {
-  auto res = cli_.Get("/with-range", {{make_range_header({{1, -1}})}});
+  auto res = cli_.Get("/with-range", {
+                                         make_range_header({{1, -1}}),
+                                         {"Accept-Encoding", ""},
+                                     });
   ASSERT_TRUE(res);
   EXPECT_EQ(StatusCode::PartialContent_206, res->status);
   EXPECT_EQ("6", res->get_header_value("Content-Length"));
@@ -3758,7 +3980,10 @@ TEST_F(ServerTest, GetWithRange2) {
 }
 
 TEST_F(ServerTest, GetWithRange3) {
-  auto res = cli_.Get("/with-range", {{make_range_header({{0, 0}})}});
+  auto res = cli_.Get("/with-range", {
+                                         make_range_header({{0, 0}}),
+                                         {"Accept-Encoding", ""},
+                                     });
   ASSERT_TRUE(res);
   EXPECT_EQ(StatusCode::PartialContent_206, res->status);
   EXPECT_EQ("1", res->get_header_value("Content-Length"));
@@ -3768,7 +3993,10 @@ TEST_F(ServerTest, GetWithRange3) {
 }
 
 TEST_F(ServerTest, GetWithRange4) {
-  auto res = cli_.Get("/with-range", {{make_range_header({{-1, 2}})}});
+  auto res = cli_.Get("/with-range", {
+                                         make_range_header({{-1, 2}}),
+                                         {"Accept-Encoding", ""},
+                                     });
   ASSERT_TRUE(res);
   EXPECT_EQ(StatusCode::PartialContent_206, res->status);
   EXPECT_EQ("2", res->get_header_value("Content-Length"));
@@ -3825,6 +4053,13 @@ TEST_F(ServerTest, Issue1772) {
   EXPECT_EQ(StatusCode::Unauthorized_401, res->status);
 }
 
+TEST_F(ServerTest, Issue609) {
+  auto res = cli_.Delete("/issue609");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::OK_200, res->status);
+  EXPECT_EQ(std::string("ok"), res->body);
+}
+
 TEST_F(ServerTest, GetStreamedChunked) {
   auto res = cli_.Get("/streamed-chunked");
   ASSERT_TRUE(res);
@@ -4082,7 +4317,10 @@ TEST_F(ServerTest, PutLargeFileWithGzip2
   ASSERT_TRUE(res);
   EXPECT_EQ(StatusCode::OK_200, res->status);
   EXPECT_EQ(LARGE_DATA, res->body);
-  EXPECT_EQ(101942u, res.get_request_header_value_u64("Content-Length"));
+  // The compressed size should be less than a 10th of the original. May vary
+  // depending on the zlib library.
+  EXPECT_LT(res.get_request_header_value_u64("Content-Length"),
+            static_cast<uint64_t>(10 * 1024 * 1024));
   EXPECT_EQ("gzip", res.get_request_header_value("Content-Encoding"));
 }
 
@@ -4513,7 +4751,9 @@ TEST_F(ServerTest, Gzip) {
 }
 
 TEST_F(ServerTest, GzipWithoutAcceptEncoding) {
-  auto res = cli_.Get("/compress");
+  Headers headers;
+  headers.emplace("Accept-Encoding", "");
+  auto res = cli_.Get("/compress", headers);
 
   ASSERT_TRUE(res);
   EXPECT_TRUE(res->get_header_value("Content-Encoding").empty());
@@ -4562,12 +4802,16 @@ TEST_F(ServerTest, GzipWithoutDecompress
 }
 
 TEST_F(ServerTest, GzipWithContentReceiverWithoutAcceptEncoding) {
+  Headers headers;
+  headers.emplace("Accept-Encoding", "");
+
   std::string body;
-  auto res = cli_.Get("/compress", [&](const char *data, uint64_t data_length) {
-    EXPECT_EQ(100U, data_length);
-    body.append(data, data_length);
-    return true;
-  });
+  auto res = cli_.Get("/compress", headers,
+                      [&](const char *data, uint64_t data_length) {
+                        EXPECT_EQ(100U, data_length);
+                        body.append(data, data_length);
+                        return true;
+                      });
 
   ASSERT_TRUE(res);
   EXPECT_TRUE(res->get_header_value("Content-Encoding").empty());
@@ -4652,7 +4896,7 @@ static bool send_request(time_t read_tim
   auto error = Error::Success;
 
   auto client_sock = detail::create_client_socket(
-      HOST, "", PORT, AF_UNSPEC, false, nullptr,
+      HOST, "", PORT, AF_UNSPEC, false, false, nullptr,
       /*connection_timeout_sec=*/5, 0,
       /*read_timeout_sec=*/5, 0,
       /*write_timeout_sec=*/5, 0, std::string(), error);
@@ -4704,8 +4948,10 @@ TEST(ServerRequestParsingTest, TrimWhite
                           "Connection: close\r\n"
                           "\r\n";
 
-  ASSERT_TRUE(send_request(5, req));
-  EXPECT_EQ(header_value, "\v bar \x1B");
+  std::string res;
+  ASSERT_TRUE(send_request(5, req, &res));
+  EXPECT_EQ(header_value, "");
+  EXPECT_EQ("HTTP/1.1 400 Bad Request", res.substr(0, 24));
 }
 
 // Sends a raw request and verifies that there isn't a crash or exception.
@@ -4718,6 +4964,10 @@ static void test_raw_request(const std::
   svr.Put("/put_hi", [&](const Request & /*req*/, Response &res) {
     res.set_content("ok", "text/plain");
   });
+  svr.Get("/header_field_value_check",
+          [&](const Request & /*req*/, Response &res) {
+            res.set_content("ok", "text/plain");
+          });
 
   // Server read timeout must be longer than the client read timeout for the
   // bug to reproduce, probably to force the server to process a request
@@ -4851,6 +5101,31 @@ TEST(ServerRequestParsingTest, InvalidSp
   EXPECT_EQ("HTTP/1.1 400 Bad Request", out.substr(0, 24));
 }
 
+TEST(ServerRequestParsingTest, InvalidFieldValueContains_CR_LF_NUL) {
+  std::string out;
+  std::string request(
+      "GET /header_field_value_check HTTP/1.1\r\nTest: [\r\x00\n]\r\n\r\n", 55);
+  test_raw_request(request, &out);
+  EXPECT_EQ("HTTP/1.1 400 Bad Request", out.substr(0, 24));
+}
+
+TEST(ServerRequestParsingTest, InvalidFieldValueContains_LF) {
+  std::string out;
+  std::string request(
+      "GET /header_field_value_check HTTP/1.1\r\nTest: [\n\n\n]\r\n\r\n", 55);
+  test_raw_request(request, &out);
+  EXPECT_EQ("HTTP/1.1 400 Bad Request", out.substr(0, 24));
+}
+
+TEST(ServerRequestParsingTest, EmptyFieldValue) {
+  std::string out;
+
+  test_raw_request("GET /header_field_value_check HTTP/1.1\r\n"
+                   "Test: \r\n\r\n",
+                   &out);
+  EXPECT_EQ("HTTP/1.1 200 OK", out.substr(0, 15));
+}
+
 TEST(ServerStopTest, StopServerWithChunkedTransmission) {
   Server svr;
 
@@ -4926,6 +5201,52 @@ TEST(ServerStopTest, ListenFailure) {
   t.join();
 }
 
+TEST(ServerStopTest, Decommision) {
+  Server svr;
+
+  svr.Get("/hi", [&](const Request &, Response &res) { res.body = "hi..."; });
+
+  for (int i = 0; i < 4; i++) {
+    auto is_even = !(i % 2);
+
+    std::thread t{[&] {
+      try {
+        std::this_thread::sleep_for(std::chrono::milliseconds(100));
+
+        if (is_even) {
+          throw std::runtime_error("Some thing that happens to go wrong.");
+        }
+
+        svr.listen(HOST, PORT);
+      } catch (...) { svr.decommission(); }
+    }};
+
+    svr.wait_until_ready();
+
+    // Server is up
+    {
+      Client cli(HOST, PORT);
+      auto res = cli.Get("/hi");
+      if (is_even) {
+        EXPECT_FALSE(res);
+      } else {
+        EXPECT_TRUE(res);
+        EXPECT_EQ("hi...", res->body);
+      }
+    }
+
+    svr.stop();
+    t.join();
+
+    // Server is down...
+    {
+      Client cli(HOST, PORT);
+      auto res = cli.Get("/hi");
+      EXPECT_FALSE(res);
+    }
+  }
+}
+
 TEST(StreamingTest, NoContentLengthStreaming) {
   Server svr;
 
@@ -5007,17 +5328,45 @@ TEST(MountTest, Unmount) {
   EXPECT_EQ(StatusCode::NotFound_404, res->status);
 }
 
-#ifndef CPPHTTPLIB_NO_EXCEPTIONS
-TEST(ExceptionTest, ThrowExceptionInHandler) {
+TEST(MountTest, Redicect) {
   Server svr;
 
-  svr.Get("/exception", [&](const Request & /*req*/, Response & /*res*/) {
-    throw std::runtime_error("exception...");
+  auto listen_thread = std::thread([&svr]() { svr.listen("localhost", PORT); });
+  auto se = detail::scope_exit([&] {
+    svr.stop();
+    listen_thread.join();
+    ASSERT_FALSE(svr.is_running());
   });
 
-  svr.Get("/unknown", [&](const Request & /*req*/, Response & /*res*/) {
-    throw std::runtime_error("exception\r\n...");
-  });
+  svr.set_mount_point("/", "./www");
+  svr.wait_until_ready();
+
+  Client cli("localhost", PORT);
+
+  auto res = cli.Get("/dir/");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::OK_200, res->status);
+
+  res = cli.Get("/dir");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::MovedPermanently_301, res->status);
+
+  res = cli.Get("/file");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::OK_200, res->status);
+
+  res = cli.Get("/file/");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::NotFound_404, res->status);
+
+  cli.set_follow_location(true);
+  res = cli.Get("/dir");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::OK_200, res->status);
+}
+
+TEST(MountTest, MultibytesPathName) {
+  Server svr;
 
   auto listen_thread = std::thread([&svr]() { svr.listen("localhost", PORT); });
   auto se = detail::scope_exit([&] {
@@ -5026,27 +5375,16 @@ TEST(ExceptionTest, ThrowExceptionInHand
     ASSERT_FALSE(svr.is_running());
   });
 
+  svr.set_mount_point("/", "./www");
   svr.wait_until_ready();
 
   Client cli("localhost", PORT);
 
-  {
-    auto res = cli.Get("/exception");
-    ASSERT_TRUE(res);
-    EXPECT_EQ(StatusCode::InternalServerError_500, res->status);
-    ASSERT_TRUE(res->has_header("EXCEPTION_WHAT"));
-    EXPECT_EQ("exception...", res->get_header_value("EXCEPTION_WHAT"));
-  }
-
-  {
-    auto res = cli.Get("/unknown");
-    ASSERT_TRUE(res);
-    EXPECT_EQ(StatusCode::InternalServerError_500, res->status);
-    ASSERT_TRUE(res->has_header("EXCEPTION_WHAT"));
-    EXPECT_EQ("exception\\r\\n...", res->get_header_value("EXCEPTION_WHAT"));
-  }
+  auto res = cli.Get(u8"/日本語Dir/日本語File.txt");
+  ASSERT_TRUE(res);
+  EXPECT_EQ(StatusCode::OK_200, res->status);
+  EXPECT_EQ(u8"日本語コンテンツ", res->body);
 }
-#endif
 
 TEST(KeepAliveTest, ReadTimeout) {
   Server svr;
@@ -5114,6 +5452,41 @@ TEST(KeepAliveTest, Issue1041) {
   EXPECT_EQ(StatusCode::OK_200, result->status);
 }
 
+TEST(KeepAliveTest, Issue1959) {
+  Server svr;
+  svr.set_keep_alive_timeout(5);
+
+  svr.Get("/a", [&](const Request & /*req*/, Response &res) {
+    res.set_content("a", "text/plain");
+  });
+
+  auto listen_thread = std::thread([&svr]() { svr.listen("localhost", PORT); });
+  auto se = detail::scope_exit([&] {
+    if (!svr.is_running()) return;
+    svr.stop();
+    listen_thread.join();
+    ASSERT_FALSE(svr.is_running());
+  });
+
+  svr.wait_until_ready();
+
+  Client cli("localhost", PORT);
+  cli.set_keep_alive(true);
+
+  using namespace std::chrono;
+  auto start = steady_clock::now();
+
+  cli.Get("/a");
+
+  svr.stop();
+  listen_thread.join();
+
+  auto end = steady_clock::now();
+  auto elapsed = duration_cast<milliseconds>(end - start).count();
+
+  EXPECT_LT(elapsed, 5000);
+}
+
 #ifdef CPPHTTPLIB_OPENSSL_SUPPORT
 TEST(KeepAliveTest, SSLClientReconnection) {
   SSLServer svr(SERVER_CERT_FILE, SERVER_PRIVATE_KEY_FILE);
@@ -5308,6 +5681,7 @@ TEST(LongPollingTest, ClientCloseDetecti
           auto count = 10;
           while (count > 0 && sink.is_writable()) {
             this_thread::sleep_for(chrono::milliseconds(10));
+            count--;
           }
           EXPECT_FALSE(sink.is_writable()); // the socket is closed
           return true;
@@ -5827,6 +6201,18 @@ TEST(SSLClientTest, WildcardHostNameMatc
   ASSERT_EQ(StatusCode::OK_200, res->status);
 }
 
+TEST(SSLClientTest, Issue2004_Online) {
+  Client client("https://google.com");
+  client.set_follow_location(true);
+
+  auto res = client.Get("/");
+  ASSERT_TRUE(res);
+  ASSERT_EQ(StatusCode::OK_200, res->status);
+
+  auto body = res->body;
+  EXPECT_EQ(body.substr(0, 15), "<!doctype html>");
+}
+
 #if 0
 TEST(SSLClientTest, SetInterfaceWithINET6) {
   auto cli = std::make_shared<httplib::Client>("https://httpbin.org");
@@ -6238,6 +6624,40 @@ TEST(SendAPI, SimpleInterface_Online) {
   EXPECT_EQ(StatusCode::MovedPermanently_301, res->status);
 }
 
+TEST(SendAPI, WithParamsInRequest) {
+  Server svr;
+
+  svr.Get("/", [&](const Request &req, Response & /*res*/) {
+    EXPECT_TRUE(req.has_param("test"));
+    EXPECT_EQ("test_value", req.get_param_value("test"));
+  });
+
+  auto t = std::thread([&]() { svr.listen(HOST, PORT); });
+
+  auto se = detail::scope_exit([&] {
+    svr.stop();
+    t.join();
+    ASSERT_FALSE(svr.is_running());
+  });
+
+  svr.wait_until_ready();
+
+  Client cli(HOST, PORT);
+
+  {
+    Request req;
+    req.method = "GET";
+    req.path = "/";
+    req.params.emplace("test", "test_value");
+    auto res = cli.send(req);
+    ASSERT_TRUE(res);
+  }
+  {
+    auto res = cli.Get("/", {{"test", "test_value"}}, Headers{});
+    ASSERT_TRUE(res);
+  }
+}
+
 TEST(ClientImplMethods, GetSocketTest) {
   httplib::Server svr;
   svr.Get("/", [&](const httplib::Request & /*req*/, httplib::Response &res) {
@@ -7133,9 +7553,9 @@ TEST(MultipartFormDataTest, CloseDelimit
              "text2"
              "\r\n------------";
 
-  std::string resonse;
-  ASSERT_TRUE(send_request(1, req, &resonse));
-  ASSERT_EQ("200", resonse.substr(9, 3));
+  std::string response;
+  ASSERT_TRUE(send_request(1, req, &response));
+  ASSERT_EQ("200", response.substr(9, 3));
 }
 
 TEST(MultipartFormDataTest, ContentLength) {
@@ -7180,11 +7600,10 @@ TEST(MultipartFormDataTest, ContentLengt
              "text2"
              "\r\n------------\r\n";
 
-  std::string resonse;
-  ASSERT_TRUE(send_request(1, req, &resonse));
-  ASSERT_EQ("200", resonse.substr(9, 3));
+  std::string response;
+  ASSERT_TRUE(send_request(1, req, &response));
+  ASSERT_EQ("200", response.substr(9, 3));
 }
-
 #endif
 
 TEST(TaskQueueTest, IncreaseAtomicInteger) {
@@ -7501,6 +7920,18 @@ TEST(PathParamsTest, SequenceOfParams) {
   EXPECT_EQ(request.path_params, expected_params);
 }
 
+TEST(PathParamsTest, SemicolonInTheMiddleIsNotAParam) {
+  const auto pattern = "/prefix:suffix";
+  detail::PathParamsMatcher matcher(pattern);
+
+  Request request;
+  request.path = "/prefix:suffix";
+  ASSERT_TRUE(matcher.match(request));
+
+  const std::unordered_map<std::string, std::string> expected_params = {};
+  EXPECT_EQ(request.path_params, expected_params);
+}
+
 TEST(UniversalClientImplTest, Ipv6LiteralAddress) {
   // If ipv6 regex working, regex match codepath is taken.
   // else port will default to 80 in Client impl
@@ -7515,3 +7946,247 @@ TEST(UniversalClientImplTest, Ipv6Litera
              CLIENT_PRIVATE_KEY_FILE);
   EXPECT_EQ(cli.port(), port);
 }
+
+TEST(FileSystemTest, FileAndDirExistenceCheck) {
+  auto file_path = "./www/dir/index.html";
+  auto dir_path = "./www/dir";
+
+  detail::FileStat stat_file(file_path);
+  EXPECT_TRUE(stat_file.is_file());
+  EXPECT_FALSE(stat_file.is_dir());
+
+  detail::FileStat stat_dir(dir_path);
+  EXPECT_FALSE(stat_dir.is_file());
+  EXPECT_TRUE(stat_dir.is_dir());
+}
+
+TEST(DirtyDataRequestTest, HeadFieldValueContains_CR_LF_NUL) {
+  Server svr;
+
+  svr.Get("/test", [&](const Request & /*req*/, Response &res) {
+    EXPECT_EQ(res.status, 400);
+  });
+
+  auto thread = std::thread([&]() { svr.listen(HOST, PORT); });
+
+  auto se = detail::scope_exit([&] {
+    svr.stop();
+    thread.join();
+    ASSERT_FALSE(svr.is_running());
+  });
+
+  svr.wait_until_ready();
+
+  Client cli(HOST, PORT);
+  cli.Get("/test", {{"Test", "_\n\r_\n\r_"}});
+}
+
+TEST(InvalidHeaderCharsTest, is_field_name) {
+  EXPECT_TRUE(detail::fields::is_field_name("exampleToken"));
+  EXPECT_TRUE(detail::fields::is_field_name("token123"));
+  EXPECT_TRUE(detail::fields::is_field_name("!#$%&'*+-.^_`|~"));
+
+  EXPECT_FALSE(detail::fields::is_field_name("example token"));
+  EXPECT_FALSE(detail::fields::is_field_name(" example_token"));
+  EXPECT_FALSE(detail::fields::is_field_name("example_token "));
+  EXPECT_FALSE(detail::fields::is_field_name("token@123"));
+  EXPECT_FALSE(detail::fields::is_field_name(""));
+  EXPECT_FALSE(detail::fields::is_field_name("example\rtoken"));
+  EXPECT_FALSE(detail::fields::is_field_name("example\ntoken"));
+  EXPECT_FALSE(detail::fields::is_field_name(std::string("\0", 1)));
+  EXPECT_FALSE(detail::fields::is_field_name("example\ttoken"));
+}
+
+TEST(InvalidHeaderCharsTest, is_field_value) {
+  EXPECT_TRUE(detail::fields::is_field_value("exampleToken"));
+  EXPECT_TRUE(detail::fields::is_field_value("token123"));
+  EXPECT_TRUE(detail::fields::is_field_value("!#$%&'*+-.^_`|~"));
+
+  EXPECT_TRUE(detail::fields::is_field_value("example token"));
+  EXPECT_FALSE(detail::fields::is_field_value(" example_token"));
+  EXPECT_FALSE(detail::fields::is_field_value("example_token "));
+  EXPECT_TRUE(detail::fields::is_field_value("token@123"));
+  EXPECT_TRUE(detail::fields::is_field_value(""));
+  EXPECT_FALSE(detail::fields::is_field_value("example\rtoken"));
+  EXPECT_FALSE(detail::fields::is_field_value("example\ntoken"));
+  EXPECT_FALSE(detail::fields::is_field_value(std::string("\0", 1)));
+  EXPECT_TRUE(detail::fields::is_field_value("example\ttoken"));
+
+  EXPECT_TRUE(detail::fields::is_field_value("0"));
+}
+
+TEST(InvalidHeaderCharsTest, OnServer) {
+  Server svr;
+
+  svr.Get("/test_name", [&](const Request &req, Response &res) {
+    std::string header = "Not Set";
+    if (req.has_param("header")) { header = req.get_param_value("header"); }
+
+    res.set_header(header, "value");
+    res.set_content("Page Content Page Content", "text/plain");
+  });
+
+  svr.Get("/test_value", [&](const Request &req, Response &res) {
+    std::string header = "Not Set";
+    if (req.has_param("header")) { header = req.get_param_value("header"); }
+
+    res.set_header("X-Test", header);
+    res.set_content("Page Content Page Content", "text/plain");
+  });
+
+  auto thread = std::thread([&]() { svr.listen(HOST, PORT); });
+
+  auto se = detail::scope_exit([&] {
+    svr.stop();
+    thread.join();
+    ASSERT_FALSE(svr.is_running());
+  });
+
+  svr.wait_until_ready();
+
+  Client cli(HOST, PORT);
+  {
+    auto res = cli.Get(
+        R"(/test_name?header=Value%00%0d%0aHEADER_KEY%3aHEADER_VALUE%0d%0a%0d%0aBODY_BODY_BODY)");
+
+    ASSERT_TRUE(res);
+    EXPECT_EQ("Page Content Page Content", res->body);
+    EXPECT_FALSE(res->has_header("HEADER_KEY"));
+  }
+  {
+    auto res = cli.Get(
+        R"(/test_value?header=Value%00%0d%0aHEADER_KEY%3aHEADER_VALUE%0d%0a%0d%0aBODY_BODY_BODY)");
+
+    ASSERT_TRUE(res);
+    EXPECT_EQ("Page Content Page Content", res->body);
+    EXPECT_FALSE(res->has_header("HEADER_KEY"));
+  }
+}
+
+TEST(InvalidHeaderValueTest, InvalidContentLength) {
+  auto handled = false;
+
+  Server svr;
+  svr.Post("/test", [&](const Request &, Response &) { handled = true; });
+
+  thread t = thread([&] { svr.listen(HOST, PORT); });
+  auto se = detail::scope_exit([&] {
+    svr.stop();
+    t.join();
+    ASSERT_FALSE(svr.is_running());
+    ASSERT_FALSE(handled);
+  });
+
+  svr.wait_until_ready();
+
+  auto req = "POST /test HTTP/1.1\r\n"
+             "Content-Length: x\r\n"
+             "\r\n";
+
+  std::string response;
+  ASSERT_TRUE(send_request(1, req, &response));
+  ASSERT_EQ("HTTP/1.1 400 Bad Request",
+            response.substr(0, response.find("\r\n")));
+}
+
+#ifndef _WIN32
+TEST(Expect100ContinueTest, ServerClosesConnection) {
+  static constexpr char reject[] = "Unauthorized";
+  static constexpr char accept[] = "Upload accepted";
+  constexpr size_t total_size = 10 * 1024 * 1024 * 1024ULL;
+
+  Server svr;
+
+  svr.set_expect_100_continue_handler(
+      [](const Request & /*req*/, Response &res) {
+        res.status = StatusCode::Unauthorized_401;
+        res.set_content(reject, "text/plain");
+        return res.status;
+      });
+  svr.Post("/", [&](const Request & /*req*/, Response &res) {
+    res.set_content(accept, "text/plain");
+  });
+
+  auto thread = std::thread([&]() { svr.listen(HOST, PORT); });
+  auto se = detail::scope_exit([&] {
+    svr.stop();
+    thread.join();
+    ASSERT_FALSE(svr.is_running());
+  });
+
+  svr.wait_until_ready();
+
+  {
+    const auto curl = std::unique_ptr<CURL, decltype(&curl_easy_cleanup)>{
+        curl_easy_init(), &curl_easy_cleanup};
+    ASSERT_NE(curl, nullptr);
+
+    curl_easy_setopt(curl.get(), CURLOPT_URL, HOST);
+    curl_easy_setopt(curl.get(), CURLOPT_PORT, PORT);
+    curl_easy_setopt(curl.get(), CURLOPT_POST, 1L);
+    auto list = std::unique_ptr<curl_slist, decltype(&curl_slist_free_all)>{
+        curl_slist_append(nullptr, "Content-Type: application/octet-stream"),
+        &curl_slist_free_all};
+    ASSERT_NE(list, nullptr);
+    curl_easy_setopt(curl.get(), CURLOPT_HTTPHEADER, list.get());
+
+    struct read_data {
+      size_t read_size;
+      size_t total_size;
+    } data = {0, total_size};
+    using read_callback_t =
+        size_t (*)(char *ptr, size_t size, size_t nmemb, void *userdata);
+    read_callback_t read_callback = [](char *ptr, size_t size, size_t nmemb,
+                                       void *userdata) -> size_t {
+      read_data *data = (read_data *)userdata;
+
+      if (!userdata || data->read_size >= data->total_size) { return 0; }
+
+      std::fill_n(ptr, size * nmemb, 'A');
+      data->read_size += size * nmemb;
+      return size * nmemb;
+    };
+    curl_easy_setopt(curl.get(), CURLOPT_READDATA, data);
+    curl_easy_setopt(curl.get(), CURLOPT_READFUNCTION, read_callback);
+
+    std::vector<char> buffer;
+    curl_easy_setopt(curl.get(), CURLOPT_WRITEDATA, &buffer);
+    using write_callback_t =
+        size_t (*)(char *ptr, size_t size, size_t nmemb, void *userdata);
+    write_callback_t write_callback = [](char *ptr, size_t size, size_t nmemb,
+                                         void *userdata) -> size_t {
+      std::vector<char> *buffer = (std::vector<char> *)userdata;
+      buffer->reserve(buffer->size() + size * nmemb + 1);
+      buffer->insert(buffer->end(), (char *)ptr, (char *)ptr + size * nmemb);
+      return size * nmemb;
+    };
+    curl_easy_setopt(curl.get(), CURLOPT_WRITEFUNCTION, write_callback);
+
+    {
+      const auto res = curl_easy_perform(curl.get());
+      ASSERT_EQ(res, CURLE_OK);
+    }
+
+    {
+      auto response_code = long{};
+      const auto res =
+          curl_easy_getinfo(curl.get(), CURLINFO_RESPONSE_CODE, &response_code);
+      ASSERT_EQ(res, CURLE_OK);
+      ASSERT_EQ(response_code, StatusCode::Unauthorized_401);
+    }
+
+    {
+      auto dl = curl_off_t{};
+      const auto res =
+          curl_easy_getinfo(curl.get(), CURLINFO_SIZE_DOWNLOAD_T, &dl);
+      ASSERT_EQ(res, CURLE_OK);
+      ASSERT_EQ(dl, (curl_off_t)sizeof reject - 1);
+    }
+
+    {
+      buffer.push_back('\0');
+      ASSERT_STRCASEEQ(buffer.data(), reject);
+    }
+  }
+}
+#endif
diff -pruN 0.16.3+ds-2/test/test.vcxproj 0.18.7-1/test/test.vcxproj
--- 0.16.3+ds-2/test/test.vcxproj	2024-08-17 13:53:26.000000000 +0000
+++ 0.18.7-1/test/test.vcxproj	2025-02-08 20:53:35.000000000 +0000
@@ -28,26 +28,26 @@
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Debug|Win32'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>true</UseDebugLibraries>
-    <PlatformToolset>v142</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
     <CharacterSet>Unicode</CharacterSet>
   </PropertyGroup>
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Debug|x64'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>true</UseDebugLibraries>
-    <PlatformToolset>v142</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
     <CharacterSet>Unicode</CharacterSet>
   </PropertyGroup>
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Release|Win32'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>false</UseDebugLibraries>
-    <PlatformToolset>v142</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
     <WholeProgramOptimization>true</WholeProgramOptimization>
     <CharacterSet>Unicode</CharacterSet>
   </PropertyGroup>
   <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Release|x64'" Label="Configuration">
     <ConfigurationType>Application</ConfigurationType>
     <UseDebugLibraries>false</UseDebugLibraries>
-    <PlatformToolset>v142</PlatformToolset>
+    <PlatformToolset>v143</PlatformToolset>
     <WholeProgramOptimization>true</WholeProgramOptimization>
     <CharacterSet>Unicode</CharacterSet>
   </PropertyGroup>
@@ -177,4 +177,4 @@
   <Import Project="$(VCTargetsPath)\Microsoft.Cpp.targets" />
   <ImportGroup Label="ExtensionTargets">
   </ImportGroup>
-</Project>
+</Project>
\ No newline at end of file
diff -pruN 0.16.3+ds-2/test/www/file 0.18.7-1/test/www/file
--- 0.16.3+ds-2/test/www/file	1970-01-01 00:00:00.000000000 +0000
+++ 0.18.7-1/test/www/file	2025-02-08 20:53:35.000000000 +0000
@@ -0,0 +1 @@
+file
diff -pruN 0.16.3+ds-2/test/www/meson.build 0.18.7-1/test/www/meson.build
--- 0.16.3+ds-2/test/www/meson.build	1970-01-01 00:00:00.000000000 +0000
+++ 0.18.7-1/test/www/meson.build	2025-02-08 20:53:35.000000000 +0000
@@ -0,0 +1,7 @@
+# SPDX-FileCopyrightText: 2024 Andrea Pappacoda
+#
+# SPDX-License-Identifier: MIT
+
+configure_file(input: 'empty_file', output: 'empty_file', copy: true)
+configure_file(input: 'file',       output: 'file',       copy: true)
+subdir('dir')
diff -pruN "0.16.3+ds-2/test/www/\346\227\245\346\234\254\350\252\236Dir/\346\227\245\346\234\254\350\252\236File.txt" "0.18.7-1/test/www/\346\227\245\346\234\254\350\252\236Dir/\346\227\245\346\234\254\350\252\236File.txt"
--- "0.16.3+ds-2/test/www/\346\227\245\346\234\254\350\252\236Dir/\346\227\245\346\234\254\350\252\236File.txt"	1970-01-01 00:00:00.000000000 +0000
+++ "0.18.7-1/test/www/\346\227\245\346\234\254\350\252\236Dir/\346\227\245\346\234\254\350\252\236File.txt"	2025-02-08 20:53:35.000000000 +0000
@@ -0,0 +1 @@
+日本語コンテンツ
\ No newline at end of file
