diff -pruN 1.15.0-5/.editorconfig 1.16~rc0.1-1/.editorconfig
--- 1.15.0-5/.editorconfig	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.editorconfig	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,12 @@
+root = true
+
+[*.{py,pyi,c,cpp,h,rst,md,yml,yaml,json,test}]
+trim_trailing_whitespace = true
+insert_final_newline = true
+indent_style = space
+
+[*.{py,pyi,c,h,json,test}]
+indent_size = 4
+
+[*.{yml,yaml}]
+indent_size = 2
diff -pruN 1.15.0-5/.git-blame-ignore-revs 1.16~rc0.1-1/.git-blame-ignore-revs
--- 1.15.0-5/.git-blame-ignore-revs	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.git-blame-ignore-revs	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,12 @@
+# Adopt black and isort
+97c5ee99bc98dc475512e549b252b23a6e7e0997
+# Use builtin generics and PEP 604 for type annotations wherever possible (#13427)
+23ee1e7aff357e656e3102435ad0fe3b5074571e
+# Use variable annotations (#10723)
+f98f78216ba9d6ab68c8e69c19e9f3c7926c5efe
+# run pyupgrade (#12711)
+fc335cb16315964b923eb1927e3aad1516891c28
+# update black to 23.3.0 (#15059)
+4276308be01ea498d946a79554b4a10b1cf13ccb
+# Update black to 24.1.1 (#16847)
+8107e53158d83d30bb04d290ac10d8d3ccd344f8
diff -pruN 1.15.0-5/.gitattributes 1.16~rc0.1-1/.gitattributes
--- 1.15.0-5/.gitattributes	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.gitattributes	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,2 @@
+# We vendor typeshed from https://github.com/python/typeshed
+mypy/typeshed/** linguist-vendored
diff -pruN 1.15.0-5/.github/ISSUE_TEMPLATE/bug.md 1.16~rc0.1-1/.github/ISSUE_TEMPLATE/bug.md
--- 1.15.0-5/.github/ISSUE_TEMPLATE/bug.md	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/ISSUE_TEMPLATE/bug.md	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,53 @@
+---
+name: Bug Report
+about: Submit a bug report
+labels: "bug"
+---
+
+<!--
+If you're not sure whether what you're experiencing is a mypy bug, please see the "Question and Help" form instead.
+Please consider:
+
+- checking our common issues page: https://mypy.readthedocs.io/en/stable/common_issues.html
+- searching our issue tracker: https://github.com/python/mypy/issues to see if it's already been reported
+- asking on gitter chat: https://gitter.im/python/typing
+-->
+
+**Bug Report**
+
+<!--
+If you're reporting a problem with a specific library function, the typeshed tracker is better suited for this report: https://github.com/python/typeshed/issues
+
+If the project you encountered the issue in is open source, please provide a link to the project.
+-->
+
+(A clear and concise description of what the bug is.)
+
+**To Reproduce**
+
+```python
+# Ideally, a small sample program that demonstrates the problem.
+# Or even better, a reproducible playground link https://mypy-play.net/ (use the "Gist" button)
+```
+
+**Expected Behavior**
+
+<!--
+How did you expect mypy to behave? It’s fine if you’re not sure your understanding is correct.
+Write down what you thought would happen. If you expected no errors, delete this section.
+-->
+
+**Actual Behavior**
+
+<!-- What went wrong? Paste mypy's output. -->
+
+**Your Environment**
+
+<!-- Include as many relevant details about the environment you experienced the bug in -->
+
+- Mypy version used:
+- Mypy command-line flags:
+- Mypy configuration options from `mypy.ini` (and other config files):
+- Python version used:
+
+<!-- You can freely edit this text, please remove all the lines you believe are unnecessary. -->
diff -pruN 1.15.0-5/.github/ISSUE_TEMPLATE/config.yml 1.16~rc0.1-1/.github/ISSUE_TEMPLATE/config.yml
--- 1.15.0-5/.github/ISSUE_TEMPLATE/config.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/ISSUE_TEMPLATE/config.yml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,7 @@
+contact_links:
+  - about: "Please check the linked documentation page before filing new issues."
+    name: "Common issues and solutions"
+    url: "https://mypy.readthedocs.io/en/stable/common_issues.html"
+  - about: "Please ask and answer any questions on the python/typing Gitter."
+    name: "Questions or Chat"
+    url: "https://gitter.im/python/typing"
diff -pruN 1.15.0-5/.github/ISSUE_TEMPLATE/crash.md 1.16~rc0.1-1/.github/ISSUE_TEMPLATE/crash.md
--- 1.15.0-5/.github/ISSUE_TEMPLATE/crash.md	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/ISSUE_TEMPLATE/crash.md	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,41 @@
+---
+name: Crash Report
+about: Crash (traceback or "INTERNAL ERROR")
+labels: "crash"
+---
+
+<!--
+  Use this form only if mypy reports an "INTERNAL ERROR" and/or gives a traceback.
+  Please include the traceback and all other messages below (use `mypy --show-traceback`).
+-->
+
+**Crash Report**
+
+(Tell us what happened.)
+
+**Traceback**
+
+```
+(Insert traceback and other messages from mypy here -- use `--show-traceback`.)
+```
+
+**To Reproduce**
+
+(Write what you did to reproduce the crash.  Full source code is
+appreciated.  We also very much appreciate it if you try to narrow the
+source down to a small stand-alone example.)
+
+**Your Environment**
+
+<!-- Include as many relevant details about the environment you experienced the bug in -->
+
+- Mypy version used:
+- Mypy command-line flags:
+- Mypy configuration options from `mypy.ini` (and other config files):
+- Python version used:
+- Operating system and version:
+
+<!--
+You can freely edit this text, please remove all the lines
+you believe are unnecessary.
+-->
diff -pruN 1.15.0-5/.github/ISSUE_TEMPLATE/documentation.md 1.16~rc0.1-1/.github/ISSUE_TEMPLATE/documentation.md
--- 1.15.0-5/.github/ISSUE_TEMPLATE/documentation.md	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/ISSUE_TEMPLATE/documentation.md	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,9 @@
+---
+name: Documentation
+about: Report a problem with the documentation
+labels: "documentation"
+---
+
+**Documentation**
+
+(A clear and concise description of the issue.)
diff -pruN 1.15.0-5/.github/ISSUE_TEMPLATE/feature.md 1.16~rc0.1-1/.github/ISSUE_TEMPLATE/feature.md
--- 1.15.0-5/.github/ISSUE_TEMPLATE/feature.md	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/ISSUE_TEMPLATE/feature.md	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,13 @@
+---
+name: Feature
+about: Submit a proposal for a new mypy feature
+labels: "feature"
+---
+
+**Feature**
+
+<!-- Enter a clear and concise description of your feature proposal here. -->
+
+**Pitch**
+
+<!-- Please explain why this feature should be implemented and how it would be used. Add examples, if applicable. -->
diff -pruN 1.15.0-5/.github/PULL_REQUEST_TEMPLATE.md 1.16~rc0.1-1/.github/PULL_REQUEST_TEMPLATE.md
--- 1.15.0-5/.github/PULL_REQUEST_TEMPLATE.md	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/PULL_REQUEST_TEMPLATE.md	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,12 @@
+<!-- If this pull request fixes an issue, add "Fixes #NNN" with the issue number. -->
+
+(Explain how this PR changes mypy.)
+
+<!--
+Checklist:
+- Read the [Contributing Guidelines](https://github.com/python/mypy/blob/master/CONTRIBUTING.md)
+- Add tests for all changed behaviour.
+- If you can't add a test, please explain why and how you verified your changes work.
+- Make sure CI passes.
+- Please do not force push to the PR once it has been reviewed.
+-->
diff -pruN 1.15.0-5/.github/workflows/build_wheels.yml 1.16~rc0.1-1/.github/workflows/build_wheels.yml
--- 1.15.0-5/.github/workflows/build_wheels.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/workflows/build_wheels.yml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,25 @@
+name: Trigger wheel build
+
+on:
+  push:
+    branches: [main, master, 'release*']
+    tags: ['*']
+
+permissions:
+  contents: read
+
+jobs:
+  build-wheels:
+    if: github.repository == 'python/mypy'
+    runs-on: ubuntu-latest
+    steps:
+      - uses: actions/checkout@v4
+        with:
+          persist-credentials: false
+      - uses: actions/setup-python@v5
+        with:
+          python-version: '3.11'
+      - name: Trigger script
+        env:
+          WHEELS_PUSH_TOKEN: ${{ secrets.WHEELS_PUSH_TOKEN }}
+        run: ./misc/trigger_wheel_build.sh
diff -pruN 1.15.0-5/.github/workflows/docs.yml 1.16~rc0.1-1/.github/workflows/docs.yml
--- 1.15.0-5/.github/workflows/docs.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/workflows/docs.yml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,48 @@
+name: Check documentation build
+
+on:
+  workflow_dispatch:
+  push:
+    branches: [main, master, 'release*']
+    tags: ['*']
+  pull_request:
+    paths:
+    - 'docs/**'
+    # We now have a docs check that fails if any error codes don't have documentation,
+    # so it's important to do the docs build on all PRs touching mypy/errorcodes.py
+    # in case somebody's adding a new error code without any docs
+    - 'mypy/errorcodes.py'
+    - 'mypyc/doc/**'
+    - '**/*.rst'
+    - '**/*.md'
+    - CREDITS
+    - LICENSE
+
+permissions:
+  contents: read
+
+concurrency:
+  group: ${{ github.workflow }}-${{ github.head_ref || github.run_id }}
+  cancel-in-progress: true
+
+jobs:
+  docs:
+    runs-on: ubuntu-latest
+    timeout-minutes: 10
+    env:
+      TOXENV: docs
+      TOX_SKIP_MISSING_INTERPRETERS: False
+      VERIFY_MYPY_ERROR_CODES: 1
+    steps:
+      - uses: actions/checkout@v4
+        with:
+          persist-credentials: false
+      - uses: actions/setup-python@v5
+        with:
+          python-version: '3.12'
+      - name: Install tox
+        run: pip install tox==4.21.2
+      - name: Setup tox environment
+        run: tox run -e ${{ env.TOXENV }} --notest
+      - name: Test
+        run: tox run -e ${{ env.TOXENV }} --skip-pkg-install
diff -pruN 1.15.0-5/.github/workflows/mypy_primer.yml 1.16~rc0.1-1/.github/workflows/mypy_primer.yml
--- 1.15.0-5/.github/workflows/mypy_primer.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/workflows/mypy_primer.yml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,101 @@
+name: Run mypy_primer
+
+on:
+  # Only run on PR, since we diff against master
+  pull_request:
+    paths-ignore:
+    - 'docs/**'
+    - '**/*.rst'
+    - '**/*.md'
+    - 'misc/**'
+    - 'mypyc/**'
+    - 'mypy/stubtest.py'
+    - 'mypy/stubgen.py'
+    - 'mypy/stubgenc.py'
+    - 'mypy/test/**'
+    - 'test-data/**'
+
+permissions:
+  contents: read
+
+concurrency:
+  group: ${{ github.workflow }}-${{ github.head_ref || github.run_id }}
+  cancel-in-progress: true
+
+jobs:
+  mypy_primer:
+    name: Run mypy_primer
+    runs-on: ubuntu-latest
+    strategy:
+      matrix:
+        shard-index: [0, 1, 2, 3, 4]
+      fail-fast: false
+    timeout-minutes: 60
+    steps:
+      - uses: actions/checkout@v4
+        with:
+          path: mypy_to_test
+          fetch-depth: 0
+          persist-credentials: false
+      - uses: actions/setup-python@v5
+        with:
+          python-version: "3.13"
+      - name: Install dependencies
+        run: |
+          python -m pip install -U pip
+          pip install git+https://github.com/hauntsaninja/mypy_primer.git
+      - name: Run mypy_primer
+        shell: bash
+        run: |
+          cd mypy_to_test
+          echo "new commit"
+          git rev-list --format=%s --max-count=1 $GITHUB_SHA
+
+          MERGE_BASE=$(git merge-base $GITHUB_SHA origin/$GITHUB_BASE_REF)
+          git checkout -b base_commit $MERGE_BASE
+          echo "base commit"
+          git rev-list --format=%s --max-count=1 base_commit
+
+          echo ''
+          cd ..
+          # fail action if exit code isn't zero or one
+          (
+            mypy_primer \
+            --repo mypy_to_test \
+            --new $GITHUB_SHA --old base_commit \
+            --num-shards 5 --shard-index ${{ matrix.shard-index }} \
+            --debug \
+            --additional-flags="--debug-serialize" \
+            --output concise \
+            | tee diff_${{ matrix.shard-index }}.txt
+          ) || [ $? -eq 1 ]
+      - if: ${{ matrix.shard-index == 0 }}
+        name: Save PR number
+        run: |
+          echo ${{ github.event.pull_request.number }} | tee pr_number.txt
+      - name: Upload mypy_primer diff + PR number
+        uses: actions/upload-artifact@v4
+        if: ${{ matrix.shard-index == 0 }}
+        with:
+          name: mypy_primer_diffs-${{ matrix.shard-index }}
+          path: |
+            diff_${{ matrix.shard-index }}.txt
+            pr_number.txt
+      - name: Upload mypy_primer diff
+        uses: actions/upload-artifact@v4
+        if: ${{ matrix.shard-index != 0 }}
+        with:
+          name: mypy_primer_diffs-${{ matrix.shard-index }}
+          path: diff_${{ matrix.shard-index }}.txt
+
+  join_artifacts:
+    name: Join artifacts
+    runs-on: ubuntu-latest
+    needs: [mypy_primer]
+    steps:
+      - name: Merge artifacts
+        uses: actions/upload-artifact/merge@v4
+        with:
+          name: mypy_primer_diffs
+          pattern: mypy_primer_diffs-*
+          delete-merged: true
diff -pruN 1.15.0-5/.github/workflows/mypy_primer_comment.yml 1.16~rc0.1-1/.github/workflows/mypy_primer_comment.yml
--- 1.15.0-5/.github/workflows/mypy_primer_comment.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/workflows/mypy_primer_comment.yml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,99 @@
+name: Comment with mypy_primer diff
+
+on:  # zizmor: ignore[dangerous-triggers]
+  workflow_run:
+    workflows:
+      - Run mypy_primer
+    types:
+      - completed
+
+permissions: {}
+
+jobs:
+  comment:
+    name: Comment PR from mypy_primer
+    runs-on: ubuntu-latest
+    permissions:
+      contents: read
+      pull-requests: write
+    if: ${{ github.event.workflow_run.conclusion == 'success' }}
+    steps:
+      - name: Download diffs
+        uses: actions/github-script@v7
+        with:
+          script: |
+            const fs = require('fs');
+            const artifacts = await github.rest.actions.listWorkflowRunArtifacts({
+               owner: context.repo.owner,
+               repo: context.repo.repo,
+               run_id: ${{ github.event.workflow_run.id }},
+            });
+            const [matchArtifact] = artifacts.data.artifacts.filter((artifact) =>
+              artifact.name == "mypy_primer_diffs");
+
+            const download = await github.rest.actions.downloadArtifact({
+               owner: context.repo.owner,
+               repo: context.repo.repo,
+               artifact_id: matchArtifact.id,
+               archive_format: "zip",
+            });
+            fs.writeFileSync("diff.zip", Buffer.from(download.data));
+
+      - run: unzip diff.zip
+      - run: |
+          cat diff_*.txt | tee fulldiff.txt
+
+      - name: Post comment
+        id: post-comment
+        uses: actions/github-script@v7
+        with:
+          github-token: ${{ secrets.GITHUB_TOKEN }}
+          script: |
+            const MAX_CHARACTERS = 50000
+            const MAX_CHARACTERS_PER_PROJECT = MAX_CHARACTERS / 3
+
+            const fs = require('fs')
+            let data = fs.readFileSync('fulldiff.txt', { encoding: 'utf8' })
+
+            function truncateIfNeeded(original, maxLength) {
+              if (original.length <= maxLength) {
+                return original
+              }
+              let truncated = original.substring(0, maxLength)
+              // further, remove last line that might be truncated
+              truncated = truncated.substring(0, truncated.lastIndexOf('\n'))
+              let lines_truncated = original.split('\n').length - truncated.split('\n').length
+              return `${truncated}\n\n... (truncated ${lines_truncated} lines) ...`
+            }
+
+            const projects = data.split('\n\n')
+            // don't let one project dominate
+            data = projects.map(project => truncateIfNeeded(project, MAX_CHARACTERS_PER_PROJECT)).join('\n\n')
+            // posting comment fails if too long, so truncate
+            data = truncateIfNeeded(data, MAX_CHARACTERS)
+
+            console.log("Diff from mypy_primer:")
+            console.log(data)
+
+            let body
+            if (data.trim()) {
+              body = 'Diff from [mypy_primer](https://github.com/hauntsaninja/mypy_primer), showing the effect of this PR on open source code:\n```diff\n' + data + '```'
+            } else {
+              body = "According to [mypy_primer](https://github.com/hauntsaninja/mypy_primer), this change doesn't affect type check results on a corpus of open source code. ✅"
+            }
+            const prNumber = parseInt(fs.readFileSync("pr_number.txt", { encoding: "utf8" }))
+            await github.rest.issues.createComment({
+              issue_number: prNumber,
+              owner: context.repo.owner,
+              repo: context.repo.repo,
+              body
+            })
+            return prNumber
+
+      - name: Hide old comments
+        # v0.4.0
+        uses: kanga333/comment-hider@c12bb20b48aeb8fc098e35967de8d4f8018fffdf
+        with:
+          github_token: ${{ secrets.GITHUB_TOKEN }}
+          leave_visible: 1
+          issue_number: ${{ steps.post-comment.outputs.result }}
diff -pruN 1.15.0-5/.github/workflows/sync_typeshed.yml 1.16~rc0.1-1/.github/workflows/sync_typeshed.yml
--- 1.15.0-5/.github/workflows/sync_typeshed.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/workflows/sync_typeshed.yml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,36 @@
+name: Sync typeshed
+
+on:
+  workflow_dispatch:
+  schedule:
+    - cron: "0 0 1,15 * *"
+
+permissions: {}
+
+jobs:
+  sync_typeshed:
+    name: Sync typeshed
+    if: github.repository == 'python/mypy'
+    runs-on: ubuntu-latest
+    permissions:
+      contents: write
+      pull-requests: write
+    timeout-minutes: 10
+    steps:
+      - uses: actions/checkout@v4
+        with:
+          fetch-depth: 0
+          persist-credentials: true  # needed to `git push` the PR branch
+        # TODO: use whatever solution ends up working for
+        # https://github.com/python/typeshed/issues/8434
+      - uses: actions/setup-python@v5
+        with:
+          python-version: "3.10"
+      - name: git config
+        run: |
+          git config --global user.name mypybot
+          git config --global user.email '<>'
+      - name: Sync typeshed
+        run: |
+          python -m pip install requests==2.28.1
+          GITHUB_TOKEN=${{ secrets.GITHUB_TOKEN }} python misc/sync-typeshed.py --make-pr
diff -pruN 1.15.0-5/.github/workflows/test.yml 1.16~rc0.1-1/.github/workflows/test.yml
--- 1.15.0-5/.github/workflows/test.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/workflows/test.yml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,237 @@
+name: Tests
+
+on:
+  workflow_dispatch:
+  push:
+    branches: [main, master, 'release*']
+    tags: ['*']
+  pull_request:
+    paths-ignore:
+    - 'docs/**'
+    - 'mypyc/doc/**'
+    - '**/*.rst'
+    - '**/*.md'
+    - .gitignore
+    - CREDITS
+    - LICENSE
+
+permissions:
+  contents: read
+
+concurrency:
+  group: ${{ github.workflow }}-${{ github.head_ref || github.run_id }}
+  cancel-in-progress: true
+
+jobs:
+  main:
+    runs-on: ${{ matrix.os }}
+    strategy:
+      fail-fast: false
+      matrix:
+        include:
+        # Make sure to run mypyc compiled unit tests for both
+        # the oldest and newest supported Python versions
+        - name: Test suite with py39-ubuntu, mypyc-compiled
+          python: '3.9'
+          os: ubuntu-24.04-arm
+          toxenv: py
+          tox_extra_args: "-n 4"
+          test_mypyc: true
+        - name: Test suite with py39-windows-64
+          python: '3.9'
+          os: windows-latest
+          toxenv: py39
+          tox_extra_args: "-n 4"
+        - name: Test suite with py310-ubuntu
+          python: '3.10'
+          os: ubuntu-24.04-arm
+          toxenv: py
+          tox_extra_args: "-n 4"
+        - name: Test suite with py311-ubuntu, mypyc-compiled
+          python: '3.11'
+          os: ubuntu-24.04-arm
+          toxenv: py
+          tox_extra_args: "-n 4"
+          test_mypyc: true
+        - name: Test suite with py312-ubuntu, mypyc-compiled
+          python: '3.12'
+          os: ubuntu-24.04-arm
+          toxenv: py
+          tox_extra_args: "-n 4"
+          test_mypyc: true
+        - name: Test suite with py313-ubuntu, mypyc-compiled
+          python: '3.13'
+          os: ubuntu-24.04-arm
+          toxenv: py
+          tox_extra_args: "-n 4"
+          test_mypyc: true
+
+        # - name: Test suite with py314-dev-ubuntu
+        #   python: '3.14-dev'
+        #   os: ubuntu-24.04-arm
+        #   toxenv: py
+        #   tox_extra_args: "-n 4"
+        #   allow_failure: true
+        #   test_mypyc: true
+
+        - name: mypyc runtime tests with py39-macos
+          python: '3.9.21'
+          # TODO: macos-13 is the last one to support Python 3.9, change it to macos-latest when updating the Python version
+          os: macos-13
+          toxenv: py
+          tox_extra_args: "-n 3 mypyc/test/test_run.py mypyc/test/test_external.py"
+        # This is broken. See
+        # - https://github.com/python/mypy/issues/17819
+        # - https://github.com/python/mypy/pull/17822
+        # - name: mypyc runtime tests with py38-debug-build-ubuntu
+        #   python: '3.9.21'
+        #   os: ubuntu-latest
+        #   toxenv: py
+        #   tox_extra_args: "-n 4 mypyc/test/test_run.py mypyc/test/test_external.py"
+        #   debug_build: true
+
+        - name: Type check our own code (py39-ubuntu)
+          python: '3.9'
+          os: ubuntu-latest
+          toxenv: type
+        - name: Type check our own code (py39-windows-64)
+          python: '3.9'
+          os: windows-latest
+          toxenv: type
+
+          # We also run these checks with pre-commit in CI,
+          # but it's useful to run them with tox too,
+          # to ensure the tox env works as expected
+        - name: Formatting and code style with Black + ruff
+          python: '3.10'
+          os: ubuntu-latest
+          toxenv: lint
+
+    name: ${{ matrix.name }}
+    timeout-minutes: 60
+    env:
+      TOX_SKIP_MISSING_INTERPRETERS: False
+      # Rich (pip) -- Disable color for windows + pytest
+      FORCE_COLOR: ${{ !(startsWith(matrix.os, 'windows-') && startsWith(matrix.toxenv, 'py')) && 1 || 0 }}
+      # Tox
+      PY_COLORS: 1
+      # Mypy (see https://github.com/python/mypy/issues/7771)
+      TERM: xterm-color
+      MYPY_FORCE_COLOR: 1
+      MYPY_FORCE_TERMINAL_WIDTH: 200
+      # Pytest
+      PYTEST_ADDOPTS: --color=yes
+
+    steps:
+    - uses: actions/checkout@v4
+      with:
+        persist-credentials: false
+
+    - name: Debug build
+      if: ${{ matrix.debug_build }}
+      run: |
+        PYTHONVERSION=${{ matrix.python }}
+        PYTHONDIR=~/python-debug/python-$PYTHONVERSION
+        VENV=$PYTHONDIR/env
+        ./misc/build-debug-python.sh $PYTHONVERSION $PYTHONDIR $VENV
+        # TODO: does this do anything? env vars aren't passed to the next step right
+        source $VENV/bin/activate
+    - name: Latest dev build
+      if: ${{ endsWith(matrix.python, '-dev') }}
+      run: |
+          git clone --depth 1 https://github.com/python/cpython.git /tmp/cpython --branch $( echo ${{ matrix.python }} | sed 's/-dev//' )
+          cd /tmp/cpython
+          echo git rev-parse HEAD; git rev-parse HEAD
+          git show --no-patch
+          sudo apt-get update
+          sudo apt-get install -y --no-install-recommends \
+            build-essential gdb lcov libbz2-dev libffi-dev libgdbm-dev liblzma-dev libncurses5-dev \
+            libreadline6-dev libsqlite3-dev libssl-dev lzma lzma-dev tk-dev uuid-dev zlib1g-dev
+          ./configure --prefix=/opt/pythondev
+          make -j$(nproc)
+          sudo make install
+          sudo ln -s /opt/pythondev/bin/python3 /opt/pythondev/bin/python
+          sudo ln -s /opt/pythondev/bin/pip3 /opt/pythondev/bin/pip
+          echo "/opt/pythondev/bin" >> $GITHUB_PATH
+    - uses: actions/setup-python@v5
+      if: ${{ !(matrix.debug_build || endsWith(matrix.python, '-dev')) }}
+      with:
+        python-version: ${{ matrix.python }}
+
+    - name: Install tox
+      run: |
+        echo PATH; echo $PATH
+        echo which python; which python
+        echo which pip; which pip
+        echo python version; python -c 'import sys; print(sys.version)'
+        echo debug build; python -c 'import sysconfig; print(bool(sysconfig.get_config_var("Py_DEBUG")))'
+        echo os.cpu_count; python -c 'import os; print(os.cpu_count())'
+        echo os.sched_getaffinity; python -c 'import os; print(len(getattr(os, "sched_getaffinity", lambda *args: [])(0)))'
+        pip install setuptools==75.1.0 tox==4.21.2
+
+    - name: Compiled with mypyc
+      if: ${{ matrix.test_mypyc }}
+      run: |
+        pip install -r test-requirements.txt
+        CC=clang MYPYC_OPT_LEVEL=0 MYPY_USE_MYPYC=1 pip install -e .
+
+    - name: Setup tox environment
+      run: |
+        tox run -e ${{ matrix.toxenv }} --notest
+    - name: Test
+      run: tox run -e ${{ matrix.toxenv }} --skip-pkg-install -- ${{ matrix.tox_extra_args }}
+      continue-on-error: ${{ matrix.allow_failure == 'true' }}
+
+    - name: Mark as success (check failures manually)
+      if: ${{ matrix.allow_failure == 'true' }}
+      run: exit 0
+
+  python_32bits:
+    runs-on: ubuntu-latest
+    name: Test mypyc suite with 32-bit Python
+    timeout-minutes: 60
+    env:
+      TOX_SKIP_MISSING_INTERPRETERS: False
+      # Rich (pip)
+      FORCE_COLOR: 1
+      # Tox
+      PY_COLORS: 1
+      # Mypy (see https://github.com/python/mypy/issues/7771)
+      TERM: xterm-color
+      MYPY_FORCE_COLOR: 1
+      MYPY_FORCE_TERMINAL_WIDTH: 200
+      # Pytest
+      PYTEST_ADDOPTS: --color=yes
+      CXX: i686-linux-gnu-g++
+      CC: i686-linux-gnu-gcc
+    steps:
+      - uses: actions/checkout@v4
+        with:
+          persist-credentials: false
+      - name: Install 32-bit build dependencies
+        run: |
+          sudo dpkg --add-architecture i386 && \
+          sudo apt-get update && sudo apt-get install -y \
+            zlib1g-dev:i386 \
+            libgcc-s1:i386 \
+            g++-i686-linux-gnu \
+            gcc-i686-linux-gnu \
+            libffi-dev:i386 \
+            libssl-dev:i386 \
+            libbz2-dev:i386 \
+            libncurses-dev:i386 \
+            libreadline-dev:i386 \
+            libsqlite3-dev:i386 \
+            liblzma-dev:i386 \
+            uuid-dev:i386
+      - name: Compile, install, and activate 32-bit Python
+        uses: gabrielfalcao/pyenv-action@v13
+        with:
+          default: 3.11.1
+          command: python -c "import platform; print(f'{platform.architecture()=} {platform.machine()=}');"
+      - name: Install tox
+        run: pip install setuptools==75.1.0 tox==4.21.2
+      - name: Setup tox environment
+        run: tox run -e py --notest
+      - name: Test
+        run: tox run -e py --skip-pkg-install -- -n 4 mypyc/test/
diff -pruN 1.15.0-5/.github/workflows/test_stubgenc.yml 1.16~rc0.1-1/.github/workflows/test_stubgenc.yml
--- 1.15.0-5/.github/workflows/test_stubgenc.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.github/workflows/test_stubgenc.yml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,41 @@
+name: Test stubgenc on pybind11_fixtures
+
+on:
+  workflow_dispatch:
+  push:
+    branches: [main, master, 'release*']
+    tags: ['*']
+  pull_request:
+    paths:
+    - 'misc/test-stubgenc.sh'
+    - 'mypy/stubgenc.py'
+    - 'mypy/stubdoc.py'
+    - 'mypy/stubutil.py'
+    - 'test-data/stubgen/**'
+
+permissions:
+  contents: read
+
+concurrency:
+  group: ${{ github.workflow }}-${{ github.head_ref || github.run_id }}
+  cancel-in-progress: true
+
+jobs:
+  stubgenc:
+    # Check stub file generation for a small pybind11 project
+    # (full text match is required to pass)
+    runs-on: ubuntu-latest
+    timeout-minutes: 10
+    steps:
+
+    - uses: actions/checkout@v4
+      with:
+        persist-credentials: false
+
+    - name: Setup 🐍 3.9
+      uses: actions/setup-python@v5
+      with:
+        python-version: 3.9
+
+    - name: Test stubgenc
+      run: misc/test-stubgenc.sh
diff -pruN 1.15.0-5/.gitignore 1.16~rc0.1-1/.gitignore
--- 1.15.0-5/.gitignore	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.gitignore	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,62 @@
+build/
+__pycache__
+*.py[cod]
+*~
+/build
+/env*/
+docs/build/
+docs/source/_build
+mypyc/doc/_build
+*.iml
+/out/
+.venv*
+venv/
+.mypy_cache/
+.incremental_checker_cache.json
+.cache
+test-data/packages/.pip_lock
+dmypy.json
+.dmypy.json
+/.mypyc_test_output
+
+# Packages
+*.egg
+*.egg-info
+*.eggs
+
+# IDEs
+.idea
+.vscode
+
+# vim temporary files
+.*.sw?
+*.sw?
+
+# Operating Systems
+.DS_Store
+
+# Coverage Files
+htmlcov
+.coverage*
+
+# pytest cache
+.pytest_cache/
+
+# virtualenv
+.Python
+bin/
+lib/
+include/
+.python-version
+pyvenv.cfg
+
+.tox
+pip-wheel-metadata
+
+
+test_capi
+*.o
+*.a
+test_capi
+/mypyc/lib-rt/build/
+/mypyc/lib-rt/*.so
diff -pruN 1.15.0-5/.pre-commit-config.yaml 1.16~rc0.1-1/.pre-commit-config.yaml
--- 1.15.0-5/.pre-commit-config.yaml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.pre-commit-config.yaml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,64 @@
+exclude: '^(mypyc/external/)|(mypy/typeshed/)|misc/typeshed_patches'  # Exclude all vendored code from lints
+repos:
+  - repo: https://github.com/pre-commit/pre-commit-hooks
+    rev: v5.0.0
+    hooks:
+      - id: trailing-whitespace
+      - id: end-of-file-fixer
+  - repo: https://github.com/psf/black-pre-commit-mirror
+    rev: 25.1.0
+    hooks:
+      - id: black
+        exclude: '^(test-data/)'
+  - repo: https://github.com/astral-sh/ruff-pre-commit
+    rev: v0.11.4
+    hooks:
+      - id: ruff
+        args: [--exit-non-zero-on-fix]
+  - repo: https://github.com/python-jsonschema/check-jsonschema
+    rev: 0.32.1
+    hooks:
+      - id: check-github-workflows
+      - id: check-github-actions
+      - id: check-readthedocs
+  - repo: https://github.com/codespell-project/codespell
+    rev: v2.4.1
+    hooks:
+      - id: codespell
+        args:
+          - --ignore-words-list=HAX,ccompiler,ot,statics,whet,zar
+        exclude: ^(mypy/test/|mypy/typeshed/|mypyc/test-data/|test-data/).+$
+  - repo: https://github.com/rhysd/actionlint
+    rev: v1.7.7
+    hooks:
+      - id: actionlint
+        args: [
+          -ignore=property "debug_build" is not defined,
+          -ignore=property "allow_failure" is not defined,
+          -ignore=SC2(046|086),
+        ]
+        additional_dependencies:
+          # actionlint has a shellcheck integration which extracts shell scripts in `run:` steps from GitHub Actions
+          # and checks these with shellcheck. This is arguably its most useful feature,
+          # but the integration only works if shellcheck is installed
+          - "github.com/wasilibs/go-shellcheck/cmd/shellcheck@v0.10.0"
+  - repo: https://github.com/woodruffw/zizmor-pre-commit
+    rev: v1.5.2
+    hooks:
+      - id: zizmor
+  - repo: local
+    hooks:
+      - id: bad-pr-link
+        name: Bad PR link
+        description: Detect PR links text that don't match their URL
+        language: pygrep
+        entry: '\[(\d+)\]\(https://github.com/python/mypy/pull/(?!\1/?\))\d+/?\)'
+        files: CHANGELOG.md
+  # Should be the last one:
+  - repo: meta
+    hooks:
+      - id: check-hooks-apply
+      - id: check-useless-excludes
+
+ci:
+  autoupdate_schedule: quarterly
diff -pruN 1.15.0-5/.readthedocs.yaml 1.16~rc0.1-1/.readthedocs.yaml
--- 1.15.0-5/.readthedocs.yaml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/.readthedocs.yaml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,18 @@
+# Read the Docs configuration file
+# See https://docs.readthedocs.io/en/stable/config-file/v2.html for details
+
+version: 2
+
+build:
+  os: ubuntu-22.04
+  tools:
+    python: "3.11"
+
+sphinx:
+   configuration: docs/source/conf.py
+
+formats: [pdf, htmlzip, epub]
+
+python:
+   install:
+   - requirements: docs/requirements-docs.txt
diff -pruN 1.15.0-5/CHANGELOG.md 1.16~rc0.1-1/CHANGELOG.md
--- 1.15.0-5/CHANGELOG.md	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/CHANGELOG.md	2025-05-27 17:21:15.000000000 +0000
@@ -2,7 +2,48 @@
 
 ## Next Release
 
-...
+### Different Property Getter and Setter Types
+
+Mypy now supports using different types for property getter and setter.
+```python
+class A:
+    value: int
+
+    @property
+    def f(self) -> int:
+        return self.value
+    @f.setter
+    def f(self, x: str | int) -> None:
+        try:
+            self.value = int(x)
+        except ValueError:
+            raise Exception(f"'{x}' is not a valid value for 'f'")
+```
+
+Contributed by Ivan Levkivskyi (PR [18510](https://github.com/python/mypy/pull/18510))
+
+### Selectively Disable Deprecated Warnings
+
+It's now possible to selectively disable warnings generated from
+[`warnings.deprecated`](https://docs.python.org/3/library/warnings.html#warnings.deprecated)
+using the [`--deprecated-calls-exclude`](https://mypy.readthedocs.io/en/stable/command_line.html#cmdoption-mypy-deprecated-calls-exclude)
+option.
+
+```python
+# mypy --enable-error-code deprecated
+#      --deprecated-calls-exclude=foo.A
+import foo
+
+foo.A().func()  # OK, the deprecated warning is ignored
+
+# file foo.py
+from typing_extensions import deprecated
+class A:
+    @deprecated("Use A.func2 instead")
+    def func(self): pass
+```
+
+Contributed by Marc Mueller (PR [18641](https://github.com/python/mypy/pull/18641))
 
 ## Mypy 1.15
 
@@ -20,9 +61,11 @@ Mypy is up to 40% faster in some use cas
 of the garbage collector. Additionally, the release includes several micro-optimizations that may
 be impactful for large projects.
 
-Contributed by Jukka Lehtosalo (PR [18306](https://github.com/python/mypy/pull/18306),
-PR [18302](https://github.com/python/mypy/pull/18302, PR [18298](https://github.com/python/mypy/pull/18298,
-PR [18299](https://github.com/python/mypy/pull/18299).
+Contributed by Jukka Lehtosalo
+- PR [18306](https://github.com/python/mypy/pull/18306)
+- PR [18302](https://github.com/python/mypy/pull/18302)
+- PR [18298](https://github.com/python/mypy/pull/18298)
+- PR [18299](https://github.com/python/mypy/pull/18299)
 
 ### Mypyc Accelerated Mypy Wheels for ARM Linux
 
diff -pruN 1.15.0-5/CONTRIBUTING.md 1.16~rc0.1-1/CONTRIBUTING.md
--- 1.15.0-5/CONTRIBUTING.md	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/CONTRIBUTING.md	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,212 @@
+# Contributing to Mypy
+
+Welcome!  Mypy is a community project that aims to work for a wide
+range of Python users and Python codebases.  If you're trying mypy on
+your Python code, your experience and what you can contribute are
+important to the project's success.
+
+## Code of Conduct
+
+Everyone participating in the Mypy community, and in particular in our
+issue tracker, pull requests, and chat, is expected to treat
+other people with respect and more generally to follow the guidelines
+articulated in the [Python Community Code of Conduct](https://www.python.org/psf/codeofconduct/).
+
+## Getting started with development
+
+### Setup
+
+#### (1) Fork the mypy repository
+
+Within GitHub, navigate to <https://github.com/python/mypy> and fork the repository.
+
+#### (2) Clone the mypy repository and enter into it
+
+```bash
+git clone git@github.com:<your_username>/mypy.git
+cd mypy
+```
+
+#### (3) Create then activate a virtual environment
+
+```bash
+python3 -m venv venv
+source venv/bin/activate
+```
+
+```bash
+# For Windows use
+python -m venv venv
+. venv/Scripts/activate
+
+# For more details, see https://docs.python.org/3/library/venv.html#creating-virtual-environments
+```
+
+#### (4) Install the test requirements and the project
+
+```bash
+python -m pip install -r test-requirements.txt
+python -m pip install -e .
+hash -r  # This resets shell PATH cache, not necessary on Windows
+```
+
+> **Note**
+> You'll need Python 3.9 or higher to install all requirements listed in
+> test-requirements.txt
+
+### Running tests
+
+Running the full test suite can take a while, and usually isn't necessary when
+preparing a PR. Once you file a PR, the full test suite will run on GitHub.
+You'll then be able to see any test failures, and make any necessary changes to
+your PR.
+
+However, if you wish to do so, you can run the full test suite
+like this:
+
+```bash
+python runtests.py
+```
+
+Some useful commands for running specific tests include:
+
+```bash
+# Use mypy to check mypy's own code
+python runtests.py self
+# or equivalently:
+python -m mypy --config-file mypy_self_check.ini -p mypy
+
+# Run a single test from the test suite (uses pytest substring expression matching)
+python runtests.py test_name
+# or equivalently:
+pytest -n0 -k test_name
+
+# Run all test cases in the "test-data/unit/check-dataclasses.test" file
+python runtests.py check-dataclasses.test
+# or equivalently:
+pytest mypy/test/testcheck.py::TypeCheckSuite::check-dataclasses.test
+
+# Run the formatters and linters
+python runtests.py lint
+```
+
+For an in-depth guide on running and writing tests,
+see [the README in the test-data directory](test-data/unit/README.md).
+
+#### Using `tox`
+
+You can also use [`tox`](https://tox.wiki/en/latest/) to run tests and other commands.
+`tox` handles setting up test environments for you.
+
+```bash
+# Run tests
+tox run -e py
+
+# Run tests using some specific Python version
+tox run -e py311
+
+# Run a specific command
+tox run -e lint
+
+# Run a single test from the test suite
+tox run -e py -- -n0 -k 'test_name'
+
+# Run all test cases in the "test-data/unit/check-dataclasses.test" file using
+# Python 3.11 specifically
+tox run -e py311 -- mypy/test/testcheck.py::TypeCheckSuite::check-dataclasses.test
+
+# Set up a development environment with all the project libraries and run a command
+tox -e dev -- mypy --verbose test_case.py
+tox -e dev --override testenv:dev.allowlist_externals+=env -- env  # inspect the environment
+```
+
+If you don't already have `tox` installed, you can use a virtual environment as
+described above to install `tox` via `pip` (e.g., ``python -m pip install tox``).
+
+## First time contributors
+
+If you're looking for things to help with, browse our [issue tracker](https://github.com/python/mypy/issues)!
+
+In particular, look for:
+
+- [good first issues](https://github.com/python/mypy/labels/good-first-issue)
+- [good second issues](https://github.com/python/mypy/labels/good-second-issue)
+- [documentation issues](https://github.com/python/mypy/labels/documentation)
+
+You do not need to ask for permission to work on any of these issues.
+Just fix the issue yourself, [try to add a unit test](#running-tests) and
+[open a pull request](#submitting-changes).
+
+To get help fixing a specific issue, it's often best to comment on the issue
+itself. You're much more likely to get help if you provide details about what
+you've tried and where you've looked (maintainers tend to help those who help
+themselves). [gitter](https://gitter.im/python/typing) can also be a good place
+to ask for help.
+
+Interactive debuggers like `pdb` and `ipdb` are really useful for getting
+started with the mypy codebase. This is a
+[useful tutorial](https://realpython.com/python-debugging-pdb/).
+
+It's also extremely easy to get started contributing to our sister project
+[typeshed](https://github.com/python/typeshed/issues) that provides type stubs
+for libraries. This is a great way to become familiar with type syntax.
+
+## Submitting changes
+
+Even more excellent than a good bug report is a fix for a bug, or the
+implementation of a much-needed new feature. We'd love to have
+your contributions.
+
+We use the usual GitHub pull-request flow, which may be familiar to
+you if you've contributed to other projects on GitHub.  For the mechanics,
+see [our git and GitHub workflow help page](https://github.com/python/mypy/wiki/Using-Git-And-GitHub),
+or [GitHub's own documentation](https://help.github.com/articles/using-pull-requests/).
+
+Anyone interested in Mypy may review your code.  One of the Mypy core
+developers will merge your pull request when they think it's ready.
+
+If your change will be a significant amount of work
+to write, we highly recommend starting by opening an issue laying out
+what you want to do.  That lets a conversation happen early in case
+other contributors disagree with what you'd like to do or have ideas
+that will help you do it.
+
+The best pull requests are focused, clearly describe what they're for
+and why they're correct, and contain tests for whatever changes they
+make to the code's behavior.  As a bonus these are easiest for someone
+to review, which helps your pull request get merged quickly!  Standard
+advice about good pull requests for open-source projects applies; we
+have [our own writeup](https://github.com/python/mypy/wiki/Good-Pull-Request)
+of this advice.
+
+Also, do not squash your commits after you have submitted a pull request, as this
+erases context during review. We will squash commits when the pull request is merged.
+
+You may also find other pages in the
+[Mypy developer guide](https://github.com/python/mypy/wiki/Developer-Guides)
+helpful in developing your change.
+
+## Core developer guidelines
+
+Core developers should follow these rules when processing pull requests:
+
+- Always wait for tests to pass before merging PRs.
+- Use "[Squash and merge](https://github.com/blog/2141-squash-your-commits)"
+  to merge PRs.
+- Delete branches for merged PRs (by core devs pushing to the main repo).
+- Edit the final commit message before merging to conform to the following
+  style (we wish to have a clean `git log` output):
+  - When merging a multi-commit PR make sure that the commit message doesn't
+    contain the local history from the committer and the review history from
+    the PR. Edit the message to only describe the end state of the PR.
+  - Make sure there is a *single* newline at the end of the commit message.
+    This way there is a single empty line between commits in `git log`
+    output.
+  - Split lines as needed so that the maximum line length of the commit
+    message is under 80 characters, including the subject line.
+  - Capitalize the subject and each paragraph.
+  - Make sure that the subject of the commit message has no trailing dot.
+  - Use the imperative mood in the subject line (e.g. "Fix typo in README").
+  - If the PR fixes an issue, make sure something like "Fixes #xxx." occurs
+    in the body of the message (not in the subject).
+  - Use Markdown for formatting.
diff -pruN 1.15.0-5/CREDITS 1.16~rc0.1-1/CREDITS
--- 1.15.0-5/CREDITS	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/CREDITS	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,61 @@
+Credits
+-------
+
+For a full list of contributors you can mine the commit history:
+https://github.com/python/mypy/commits/master
+
+For lists of contributors per mypy release (including typeshed) see
+the release blog posts at https://mypy-lang.blogspot.com/.
+
+Dropbox core team:
+
+  Jukka Lehtosalo <jukka.lehtosalo@iki.fi>
+  Ivan Levkivskyi <levkivskyi@gmail.com>
+  Jared Hance
+
+Non-Dropbox core team members:
+
+  Emma Harper Smith <emma@python.org>
+  Guido van Rossum <guido@python.org>
+  Jelle Zijlstra <jelle.zijlstra@gmail.com>
+  Michael J. Sullivan <sully@msully.net>
+  Shantanu Jain
+  Xuanda Yang <th3charlie@gmail.com>
+  Jingchen Ye <97littleleaf11@gmail.com>
+  Nikita Sobolev <mail@sobolevn.me>
+
+Past Dropbox core team members:
+
+  David Fisher
+  Svyatoslav Ilinskiy
+  Greg Price
+  Naomi Seyfer
+  Michael Lee
+  Reid Barton
+
+Additional thanks to:
+
+  Alex Allain
+  Max Bolingbroke
+  Peter Calvert
+  Kannan Goundan
+  Kathy Gray
+  David J Greaves
+  Riitta Ikonen
+  Terho Ikonen
+  Stephen Kell
+  Łukasz Langa
+  Laura Lehtosalo
+  Peter Ludemann
+  Seppo Mattila
+  Robin Message
+  Alan Mycroft
+  Dominic Orchard
+  Pekka Rapinoja
+  Matt Robben
+  Satnam Singh
+  Juha Sorva
+  Clay Sweetser
+  Jorma Tarhio
+  Jussi Tuovila
+  Andrey Vlasovskikh
diff -pruN 1.15.0-5/MANIFEST.in 1.16~rc0.1-1/MANIFEST.in
--- 1.15.0-5/MANIFEST.in	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/MANIFEST.in	2025-05-27 17:21:15.000000000 +0000
@@ -42,7 +42,6 @@ graft test-data
 graft mypy/test
 include conftest.py
 include runtests.py
-include pytest.ini
 include tox.ini
 
 include LICENSE mypyc/README.md CHANGELOG.md
diff -pruN 1.15.0-5/PKG-INFO 1.16~rc0.1-1/PKG-INFO
--- 1.15.0-5/PKG-INFO	2025-02-05 00:53:52.798817000 +0000
+++ 1.16~rc0.1-1/PKG-INFO	1970-01-01 00:00:00.000000000 +0000
@@ -1,50 +0,0 @@
-Metadata-Version: 2.2
-Name: mypy
-Version: 1.15.0
-Summary: Optional static typing for Python
-Author-email: Jukka Lehtosalo <jukka.lehtosalo@iki.fi>
-License: MIT
-Project-URL: Homepage, https://www.mypy-lang.org/
-Project-URL: Documentation, https://mypy.readthedocs.io/en/stable/index.html
-Project-URL: Repository, https://github.com/python/mypy
-Project-URL: Changelog, https://github.com/python/mypy/blob/master/CHANGELOG.md
-Project-URL: Issues, https://github.com/python/mypy/issues
-Classifier: Development Status :: 5 - Production/Stable
-Classifier: Environment :: Console
-Classifier: Intended Audience :: Developers
-Classifier: License :: OSI Approved :: MIT License
-Classifier: Programming Language :: Python :: 3
-Classifier: Programming Language :: Python :: 3.9
-Classifier: Programming Language :: Python :: 3.10
-Classifier: Programming Language :: Python :: 3.11
-Classifier: Programming Language :: Python :: 3.12
-Classifier: Programming Language :: Python :: 3.13
-Classifier: Topic :: Software Development
-Classifier: Typing :: Typed
-Requires-Python: >=3.9
-Description-Content-Type: text/x-rst
-License-File: LICENSE
-Requires-Dist: typing_extensions>=4.6.0
-Requires-Dist: mypy_extensions>=1.0.0
-Requires-Dist: tomli>=1.1.0; python_version < "3.11"
-Provides-Extra: dmypy
-Requires-Dist: psutil>=4.0; extra == "dmypy"
-Provides-Extra: mypyc
-Requires-Dist: setuptools>=50; extra == "mypyc"
-Provides-Extra: python2
-Provides-Extra: reports
-Requires-Dist: lxml; extra == "reports"
-Provides-Extra: install-types
-Requires-Dist: pip; extra == "install-types"
-Provides-Extra: faster-cache
-Requires-Dist: orjson; extra == "faster-cache"
-
-Mypy -- Optional Static Typing for Python
-=========================================
-
-Add type annotations to your Python programs, and use mypy to type
-check them.  Mypy is essentially a Python linter on steroids, and it
-can catch many programming errors by analyzing your program, without
-actually having to run it.  Mypy has a powerful type system with
-features such as type inference, gradual typing, generics and union
-types.
diff -pruN 1.15.0-5/action.yml 1.16~rc0.1-1/action.yml
--- 1.15.0-5/action.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/action.yml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,83 @@
+name: "Mypy"
+description: "Optional Static Typing for Python."
+author: "Jukka Lehtosalo and contributors"
+inputs:
+  options:
+    description: >
+      Options passed to mypy. Use `mypy --help` to see available options.
+    required: false
+  paths:
+    description: >
+      Explicit paths to run mypy on. Defaults to the current directory.
+    required: false
+    default: "."
+  version:
+    description: >
+      Mypy version to use (PEP440) - e.g. "0.910"
+    required: false
+    default: ""
+  install_types:
+    description: >
+      Whether to automatically install missing library stub packages.
+      ('yes'|'no', default: 'yes')
+    default: "yes"
+  install_project_dependencies:
+    description: >
+      Whether to attempt to install project dependencies into mypy
+      environment. ('yes'|'no', default: 'yes')
+    default: "yes"
+branding:
+  color: "blue"
+  icon: "check-circle"
+runs:
+  using: composite
+  steps:
+    - name: mypy setup  # zizmor: ignore[template-injection]
+      shell: bash
+      run: |
+        echo ::group::Installing mypy...
+        export PIP_DISABLE_PIP_VERSION_CHECK=1
+
+        if [ "$RUNNER_OS" == "Windows" ]; then
+          HOST_PYTHON=python
+        else
+          HOST_PYTHON=python3
+        fi
+
+        venv_script="import os.path; import venv; import sys;
+        path = os.path.join(r'${{ github.action_path }}', '.mypy-venv');
+        venv.main([path]);
+        bin_subdir = 'Scripts' if sys.platform == 'win32' else 'bin';
+        print(os.path.join(path, bin_subdir, 'python'));
+        "
+
+        VENV_PYTHON=$(echo $venv_script | "$HOST_PYTHON")
+        mypy_spec="mypy"
+
+        if [ -n "${{ inputs.version }}" ]; then
+          mypy_spec+="==${{ inputs.version }}"
+        fi
+
+        if ! "$VENV_PYTHON" -m pip install "$mypy_spec"; then
+          echo "::error::Could not install mypy."
+          exit 1
+        fi
+        echo ::endgroup::
+
+        if [ "${{ inputs.install_project_dependencies }}" == "yes" ]; then
+          VENV=$("$VENV_PYTHON" -c 'import sys;print(sys.prefix)')
+          echo ::group::Installing project dependencies...
+          "$VENV_PYTHON" -m pip download --dest="$VENV"/deps .
+          "$VENV_PYTHON" -m pip install -U --find-links="$VENV"/deps "$VENV"/deps/*
+          echo ::endgroup::
+        fi
+
+        echo ::group::Running mypy...
+        mypy_opts=""
+        if [ "${{ inputs.install_types }}" == "yes" ]; then
+          mypy_opts+="--install-types --non-interactive"
+        fi
+
+        echo "mypy $mypy_opts ${{ inputs.options }} ${{ inputs.paths }}"
+        "$VENV_PYTHON" -m mypy $mypy_opts ${{ inputs.options }} ${{ inputs.paths }}
+        echo ::endgroup::
diff -pruN 1.15.0-5/debian/.gitignore 1.16~rc0.1-1/debian/.gitignore
--- 1.15.0-5/debian/.gitignore	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/.gitignore	1970-01-01 00:00:00.000000000 +0000
@@ -1 +0,0 @@
-/files
diff -pruN 1.15.0-5/debian/changelog 1.16~rc0.1-1/debian/changelog
--- 1.15.0-5/debian/changelog	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/changelog	2025-05-28 11:42:43.000000000 +0000
@@ -1,3 +1,14 @@
+mypy (1.16~rc0.1-1) experimental; urgency=medium
+
+  * New upstream snapshot: https://github.com/python/mypy/commit/
+    334469f999c5c777124a123062b4349614447e0d
+  * d/patches: drop 3 patches applied upstream: 0005-pythoncapi_compat-
+    don-t-define-Py_NULL-if-it-is-alre, gnu-hurd-getsockname, replace-
+    old-typing_extensions-imports
+  * d/control: new build requirement: python3-pathspec
+
+ -- Michael R. Crusoe <crusoe@debian.org>  Wed, 28 May 2025 13:42:43 +0200
+
 mypy (1.15.0-5) unstable; urgency=medium
 
   * Team upload.
diff -pruN 1.15.0-5/debian/control 1.16~rc0.1-1/debian/control
--- 1.15.0-5/debian/control	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/control	2025-05-28 11:03:00.000000000 +0000
@@ -14,6 +14,7 @@ Build-Depends: debhelper-compat (= 13),
                python3-all,
                python3-lxml (>= 4.9.1),
                python3-attr <!nocheck>,
+               python3-pathspec,
                python3-pytest (>= 8.1.0) <!nocheck>,
                python3-pytest-xdist <!nocheck>,
                python3-pytest-cov <!nocheck>,
diff -pruN 1.15.0-5/debian/patches/0005-pythoncapi_compat-don-t-define-Py_NULL-if-it-is-alre.patch 1.16~rc0.1-1/debian/patches/0005-pythoncapi_compat-don-t-define-Py_NULL-if-it-is-alre.patch
--- 1.15.0-5/debian/patches/0005-pythoncapi_compat-don-t-define-Py_NULL-if-it-is-alre.patch	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/patches/0005-pythoncapi_compat-don-t-define-Py_NULL-if-it-is-alre.patch	1970-01-01 00:00:00.000000000 +0000
@@ -1,30 +0,0 @@
-From: "Michael R. Crusoe" <crusoe@debian.org>
-Date: Mon, 17 Feb 2025 19:40:07 +0100
-Subject: pythoncapi_compat: don't define Py_NULL if it is already defined
-
-Forwarded: https://github.com/python/mypy/pull/18699
-
----
- mypyc/lib-rt/pythoncapi_compat.h | 2 ++
- 1 file changed, 2 insertions(+)
-
-diff --git a/mypyc/lib-rt/pythoncapi_compat.h b/mypyc/lib-rt/pythoncapi_compat.h
-index cee282d..c49af7a 100644
---- a/mypyc/lib-rt/pythoncapi_compat.h
-+++ b/mypyc/lib-rt/pythoncapi_compat.h
-@@ -33,6 +33,7 @@ extern "C" {
- #  define _Py_CAST(type, expr) ((type)(expr))
- #endif
- 
-+#ifndef _Py_NULL
- // Static inline functions should use _Py_NULL rather than using directly NULL
- // to prevent C++ compiler warnings. On C23 and newer and on C++11 and newer,
- // _Py_NULL is defined as nullptr.
-@@ -42,6 +43,7 @@ extern "C" {
- #else
- #  define _Py_NULL NULL
- #endif
-+#endif
- 
- // Cast argument to PyObject* type.
- #ifndef _PyObject_CAST
diff -pruN 1.15.0-5/debian/patches/gnu-hurd-getsockname 1.16~rc0.1-1/debian/patches/gnu-hurd-getsockname
--- 1.15.0-5/debian/patches/gnu-hurd-getsockname	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/patches/gnu-hurd-getsockname	1970-01-01 00:00:00.000000000 +0000
@@ -1,25 +0,0 @@
-From: Mattias Ellert <mattias.ellert@physics.uu.se>
-Date: Fri, 7 Feb 2025 15:44:22 +0100
-Subject: [PATCH] GNU/Hurd returns empty string from getsockname() for AF_UNIX
- sockets
-
-Build the socket name from directory name and name instead.
----
- mypy/ipc.py | 4 ++++
- 1 file changed, 4 insertions(+)
-
-diff --git a/mypy/ipc.py b/mypy/ipc.py
-index 991f9ac..b2046a4 100644
---- a/mypy/ipc.py
-+++ b/mypy/ipc.py
-@@ -303,6 +303,10 @@ class IPCServer(IPCBase):
-     def connection_name(self) -> str:
-         if sys.platform == "win32":
-             return self.name
-+        elif sys.platform == "gnu0":
-+            # GNU/Hurd returns empty string from getsockname()
-+            # for AF_UNIX sockets
-+            return os.path.join(self.sock_directory, self.name)
-         else:
-             name = self.sock.getsockname()
-             assert isinstance(name, str)
diff -pruN 1.15.0-5/debian/patches/hint-typeshed-package 1.16~rc0.1-1/debian/patches/hint-typeshed-package
--- 1.15.0-5/debian/patches/hint-typeshed-package	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/patches/hint-typeshed-package	2025-05-28 11:00:02.000000000 +0000
@@ -11,11 +11,9 @@ Forwarded: not-needed
  test-data/unit/fine-grained-modules.test | 4 ++--
  4 files changed, 7 insertions(+), 5 deletions(-)
 
-diff --git a/mypy/modulefinder.py b/mypy/modulefinder.py
-index 61dbb6c..8b9e5ff 100644
---- a/mypy/modulefinder.py
-+++ b/mypy/modulefinder.py
-@@ -102,7 +102,9 @@ class ModuleNotFoundReason(Enum):
+--- mypy.orig/mypy/modulefinder.py
++++ mypy/mypy/modulefinder.py
+@@ -105,7 +105,9 @@
              notes = [doc_link]
          elif self is ModuleNotFoundReason.APPROVED_STUBS_NOT_INSTALLED:
              msg = 'Library stubs not installed for "{module}"'
@@ -26,11 +24,9 @@ index 61dbb6c..8b9e5ff 100644
              if not daemon:
                  notes.append(
                      '(or run "mypy --install-types" to install all missing stub packages)'
-diff --git a/test-data/unit/check-errorcodes.test b/test-data/unit/check-errorcodes.test
-index 2940386..eec7649 100644
---- a/test-data/unit/check-errorcodes.test
-+++ b/test-data/unit/check-errorcodes.test
-@@ -523,7 +523,7 @@ if int() is str():  # E: Non-overlapping identity check (left operand type: "int
+--- mypy.orig/test-data/unit/check-errorcodes.test
++++ mypy/test-data/unit/check-errorcodes.test
+@@ -536,7 +536,7 @@
  
  [case testErrorCodeMissingModule]
  from defusedxml import xyz  # E: Library stubs not installed for "defusedxml"  [import-untyped] \
@@ -39,11 +35,9 @@ index 2940386..eec7649 100644
                              # N: (or run "mypy --install-types" to install all missing stub packages)
  from nonexistent import foobar  # E: Cannot find implementation or library stub for module named "nonexistent"  [import-not-found]
  import nonexistent2  # E: Cannot find implementation or library stub for module named "nonexistent2"  [import-not-found]
-diff --git a/test-data/unit/check-modules.test b/test-data/unit/check-modules.test
-index bee0984..e4e9f56 100644
---- a/test-data/unit/check-modules.test
-+++ b/test-data/unit/check-modules.test
-@@ -3130,7 +3130,7 @@ import google.non_existent  # E: Cannot find implementation or library stub for
+--- mypy.orig/test-data/unit/check-modules.test
++++ mypy/test-data/unit/check-modules.test
+@@ -3129,7 +3129,7 @@
  from google.non_existent import x
  
  import google.cloud.ndb  # E: Library stubs not installed for "google.cloud.ndb" \
@@ -52,11 +46,9 @@ index bee0984..e4e9f56 100644
                           # N: (or run "mypy --install-types" to install all missing stub packages) \
                           # N: See https://mypy.readthedocs.io/en/stable/running_mypy.html#missing-imports
  from google.cloud import ndb
-diff --git a/test-data/unit/fine-grained-modules.test b/test-data/unit/fine-grained-modules.test
-index f28dbaa..6273fbf 100644
---- a/test-data/unit/fine-grained-modules.test
-+++ b/test-data/unit/fine-grained-modules.test
-@@ -2199,12 +2199,12 @@ import requests
+--- mypy.orig/test-data/unit/fine-grained-modules.test
++++ mypy/test-data/unit/fine-grained-modules.test
+@@ -2199,12 +2199,12 @@
  import jack
  [out]
  a.py:1: error: Library stubs not installed for "requests"
diff -pruN 1.15.0-5/debian/patches/replace-old-typing_extensions-imports.patch 1.16~rc0.1-1/debian/patches/replace-old-typing_extensions-imports.patch
--- 1.15.0-5/debian/patches/replace-old-typing_extensions-imports.patch	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/patches/replace-old-typing_extensions-imports.patch	1970-01-01 00:00:00.000000000 +0000
@@ -1,107 +0,0 @@
-From: Marc Mueller <30130371+cdce8p@users.noreply.github.com>
-Date: Sun, 16 Feb 2025 23:39:46 +0100
-Subject: Replace old typing_extensions imports in tests
-
-Origin: upstream, https://github.com/python/mypy/pull/18691
-Bug-Debian: https://bugs.debian.org/1101856
-Last-Update: 2025-04-07
----
- mypy/test/teststubtest.py | 29 +++++++++++++++++++++--------
- 1 file changed, 21 insertions(+), 8 deletions(-)
-
-diff --git a/mypy/test/teststubtest.py b/mypy/test/teststubtest.py
-index f3199da..101b6f6 100644
---- a/mypy/test/teststubtest.py
-+++ b/mypy/test/teststubtest.py
-@@ -48,6 +48,11 @@ Callable: _SpecialForm = ...
- Generic: _SpecialForm = ...
- Protocol: _SpecialForm = ...
- Union: _SpecialForm = ...
-+ClassVar: _SpecialForm = ...
-+
-+Final = 0
-+Literal = 0
-+TypedDict = 0
- 
- class TypeVar:
-     def __init__(self, name, covariant: bool = ..., contravariant: bool = ...) -> None: ...
-@@ -71,6 +76,12 @@ class Match(Generic[AnyStr]): ...
- class Sequence(Iterable[_T_co]): ...
- class Tuple(Sequence[_T_co]): ...
- class NamedTuple(tuple[Any, ...]): ...
-+class _TypedDict(Mapping[str, object]):
-+    __required_keys__: ClassVar[frozenset[str]]
-+    __optional_keys__: ClassVar[frozenset[str]]
-+    __total__: ClassVar[bool]
-+    __readonly_keys__: ClassVar[frozenset[str]]
-+    __mutable_keys__: ClassVar[frozenset[str]]
- def overload(func: _T) -> _T: ...
- def type_check_only(func: _T) -> _T: ...
- def final(func: _T) -> _T: ...
-@@ -95,6 +106,8 @@ class tuple(Sequence[T_co], Generic[T_co]):
- 
- class dict(Mapping[KT, VT]): ...
- 
-+class frozenset(Generic[T]): ...
-+
- class function: pass
- class ellipsis: pass
- 
-@@ -1373,7 +1386,7 @@ class StubtestUnit(unittest.TestCase):
-         )
-         yield Case(
-             stub="""
--            from typing_extensions import Final, Literal
-+            from typing import Final, Literal
-             class BytesEnum(bytes, enum.Enum):
-                 a = b'foo'
-             FOO: Literal[BytesEnum.a]
-@@ -1915,7 +1928,7 @@ assert annotations
-     def test_good_literal(self) -> Iterator[Case]:
-         yield Case(
-             stub=r"""
--            from typing_extensions import Literal
-+            from typing import Literal
- 
-             import enum
-             class Color(enum.Enum):
-@@ -1947,7 +1960,7 @@ assert annotations
- 
-     @collect_cases
-     def test_bad_literal(self) -> Iterator[Case]:
--        yield Case("from typing_extensions import Literal", "", None)  # dummy case
-+        yield Case("from typing import Literal", "", None)  # dummy case
-         yield Case(
-             stub="INT_FLOAT_MISMATCH: Literal[1]",
-             runtime="INT_FLOAT_MISMATCH = 1.0",
-@@ -1998,7 +2011,7 @@ assert annotations
-         )
-         yield Case(
-             stub="""
--            from typing_extensions import TypedDict
-+            from typing import TypedDict
- 
-             class _Options(TypedDict):
-                 a: str
-@@ -2019,8 +2032,8 @@ assert annotations
-     @collect_cases
-     def test_runtime_typing_objects(self) -> Iterator[Case]:
-         yield Case(
--            stub="from typing_extensions import Protocol, TypedDict",
--            runtime="from typing_extensions import Protocol, TypedDict",
-+            stub="from typing import Protocol, TypedDict",
-+            runtime="from typing import Protocol, TypedDict",
-             error=None,
-         )
-         yield Case(
-@@ -2385,8 +2398,8 @@ assert annotations
-         )
-         # The same is true for NamedTuples and TypedDicts:
-         yield Case(
--            stub="from typing_extensions import NamedTuple, TypedDict",
--            runtime="from typing_extensions import NamedTuple, TypedDict",
-+            stub="from typing import NamedTuple, TypedDict",
-+            runtime="from typing import NamedTuple, TypedDict",
-             error=None,
-         )
-         yield Case(
diff -pruN 1.15.0-5/debian/patches/series 1.16~rc0.1-1/debian/patches/series
--- 1.15.0-5/debian/patches/series	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/patches/series	2025-05-28 11:00:02.000000000 +0000
@@ -1,6 +1,3 @@
 hint-typeshed-package
 verbose
 intersphinx
-gnu-hurd-getsockname
-0005-pythoncapi_compat-don-t-define-Py_NULL-if-it-is-alre.patch
-replace-old-typing_extensions-imports.patch
diff -pruN 1.15.0-5/debian/patches/verbose 1.16~rc0.1-1/debian/patches/verbose
--- 1.15.0-5/debian/patches/verbose	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/patches/verbose	2025-05-28 11:00:02.000000000 +0000
@@ -7,15 +7,13 @@ Forwarded: not-needed
  setup.py | 1 +
  1 file changed, 1 insertion(+)
 
-diff --git a/setup.py b/setup.py
-index e995068..4a41da6 100644
---- a/setup.py
-+++ b/setup.py
-@@ -152,6 +152,7 @@ if USE_MYPYC:
+--- mypy.orig/setup.py
++++ mypy/setup.py
+@@ -152,6 +152,7 @@
          # Use multi-file compilation mode on windows because without it
          # our Appveyor builds run out of memory sometimes.
          multi_file=sys.platform == "win32" or force_multifile,
 +        verbose=True,
      )
-     assert is_list_of_setuptools_extension(ext_modules), "Expected mypycify to use setuptools"
  
+ else:
diff -pruN 1.15.0-5/debian/rules 1.16~rc0.1-1/debian/rules
--- 1.15.0-5/debian/rules	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/rules	2025-05-28 11:42:43.000000000 +0000
@@ -2,7 +2,7 @@
 export DH_VERBOSE=1
 export PYBUILD_DESTDIR_python3=debian/python3-mypy
 export PYBUILD_NAME=mypy
-PY3VERS=$(shell py3versions -vr)
+PY3VERS=$(shell py3versions -vs)
 
 include /usr/share/dpkg/default.mk
 
diff -pruN 1.15.0-5/debian/tests/control 1.16~rc0.1-1/debian/tests/control
--- 1.15.0-5/debian/tests/control	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/tests/control	2025-05-28 11:42:43.000000000 +0000
@@ -2,6 +2,7 @@ Tests: run-unit-test
 Depends: gcc, g++,
          @,
          python3-dev,
+         python3-attr,
          python3-lxml,
          python3-pytest (>= 8.1.0),
          python3-pytest-xdist,
@@ -9,5 +10,6 @@ Depends: gcc, g++,
          python3-tomli,
          python3-orjson [!i386 !alpha !hppa !m68k !sh4 !x32],
          python3-typeshed (>= 0.0~git20221107.4f381af),
-         python3-virtualenv
+         python3-virtualenv,
+         python3-all-venv
 Restrictions: allow-stderr
diff -pruN 1.15.0-5/debian/tests/run-unit-test 1.16~rc0.1-1/debian/tests/run-unit-test
--- 1.15.0-5/debian/tests/run-unit-test	2025-04-07 17:08:15.000000000 +0000
+++ 1.16~rc0.1-1/debian/tests/run-unit-test	2025-05-28 11:42:43.000000000 +0000
@@ -23,9 +23,27 @@ rm -Rf mypy mypyc
 
 cp -r /usr/lib/python3/dist-packages/mypy ./
 cp -r /usr/lib/python3/dist-packages/mypyc ./
+cp ${START}/conftest.py ./
+cp -r ${START}/mypyc/test-data ./mypyc/
+cp -r ${START}/test-data ./
+
+export DEB_BUILD_MAINT_OPTIONS=hardening=+all
+export MYPYC_DEBUG_LEVEL=2
+export TEST_MYPYC=1
+
+set -e; for v in $(py3versions -vs) ; do
+python${v} -m pytest -n $(nproc) -v -o testpaths="mypy/test mypyc/test" -o python_files=test*.py -o python_classes= -o python_functions= -k "not (test_bad_eq_version_check or test_bad_ge_version_check or test_parse_invalid_case or test_parse_invalid_section or test_update_data or testDaemonStatusKillRestartRecheck or testErrorCodeMissingModule or testErrorFromGoogleCloud or testCustomTypeshedDirWithRelativePathDoesNotCrash or testLibraryStubsNotInstalled or testIgnoreImportIfNoPython3StubAvailable or testNoPython3StubAvailable or testAttrsClass_semanal or testRunAsyncMiscTypesInEnvironment)"
+done
+
+# testErrorCodeMissingModule: different error message on Debian
+# testErrorFromGoogleCloud: different error message on Debian
+# testCustomTypeshedDirWithRelativePathDoesNotCrash: ???
+# testLibraryStubsNotInstalled: different error message on Debian
+# testIgnoreImportIfNoPython3StubAvailable: package 'scribe' in not yet available in Debian
+# testNoPython3StubAvailable: different error message on Debian
+# testAttrsClass_semanal: ???
+# testRunAsyncMiscTypesInEnvironment: ???
 
-mypy_test_prefix=${start} pytest-3 -v --pyargs mypy -k "not (test_bad_eq_version_check or test_bad_ge_version_check or test_parse_invalid_case or test_parse_invalid_section or test_update_data or testDaemonStatusKillRestartRecheck)"
-mypy_test_prefix=${start} pytest-3 -v --pyargs mypyc
 
 rm -Rf mypy/typeshed
 /usr/bin/mypy --config-file ${START}/mypy_self_check.ini mypy
diff -pruN 1.15.0-5/docs/source/command_line.rst 1.16~rc0.1-1/docs/source/command_line.rst
--- 1.15.0-5/docs/source/command_line.rst	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/docs/source/command_line.rst	2025-05-27 17:21:15.000000000 +0000
@@ -81,6 +81,10 @@ for full details, see :ref:`running-mypy
     never recursively discover files with extensions other than ``.py`` or
     ``.pyi``.
 
+.. option:: --exclude-gitignore
+
+    This flag will add everything that matches ``.gitignore`` file(s) to :option:`--exclude`.
+
 
 Optional arguments
 ******************
@@ -556,6 +560,26 @@ potentially problematic or redundant in
     notes, causing mypy to eventually finish with a zero exit code. Features
     are considered deprecated when decorated with ``warnings.deprecated``.
 
+.. option:: --deprecated-calls-exclude
+
+    This flag allows to selectively disable :ref:`deprecated<code-deprecated>` warnings
+    for functions and methods defined in specific packages, modules, or classes.
+    Note that each exclude entry acts as a prefix. For example (assuming ``foo.A.func`` is deprecated):
+
+    .. code-block:: python
+
+        # mypy --enable-error-code deprecated
+        #      --deprecated-calls-exclude=foo.A
+        import foo
+
+        foo.A().func()  # OK, the deprecated warning is ignored
+
+        # file foo.py
+        from typing_extensions import deprecated
+        class A:
+            @deprecated("Use A.func2 instead")
+            def func(self): pass
+
 .. _miscellaneous-strictness-flags:
 
 Miscellaneous strictness flags
@@ -569,12 +593,58 @@ of the above sections.
     This flag causes mypy to suppress errors caused by not being able to fully
     infer the types of global and class variables.
 
-.. option:: --allow-redefinition
+.. option:: --allow-redefinition-new
 
     By default, mypy won't allow a variable to be redefined with an
-    unrelated type. This flag enables redefinition of a variable with an
+    unrelated type. This *experimental* flag enables the redefinition of
+    unannotated variables with an arbitrary type. You will also need to enable
+    :option:`--local-partial-types <mypy --local-partial-types>`.
+    Example:
+
+    .. code-block:: python
+
+        def maybe_convert(n: int, b: bool) -> int | str:
+            if b:
+                x = str(n)  # Assign "str"
+            else:
+                x = n       # Assign "int"
+            # Type of "x" is "int | str" here.
+            return x
+
+    Without the new flag, mypy only supports inferring optional types
+    (``X | None``) from multiple assignments. With this option enabled,
+    mypy can infer arbitrary union types.
+
+    This also enables an unannotated variable to have different types in different
+    code locations:
+
+    .. code-block:: python
+
+        if check():
+            for x in range(n):
+                # Type of "x" is "int" here.
+                ...
+        else:
+            for x in ['a', 'b']:
+                # Type of "x" is "str" here.
+                ...
+
+    Note: We are planning to turn this flag on by default in a future mypy
+    release, along with :option:`--local-partial-types <mypy --local-partial-types>`.
+    The feature is still experimental, and the semantics may still change.
+
+.. option:: --allow-redefinition
+
+    This is an older variant of
+    :option:`--allow-redefinition-new <mypy --allow-redefinition-new>`.
+    This flag enables redefinition of a variable with an
     arbitrary type *in some contexts*: only redefinitions within the
     same block and nesting depth as the original definition are allowed.
+
+    We have no plans to remove this flag, but we expect that
+    :option:`--allow-redefinition-new <mypy --allow-redefinition-new>`
+    will replace this flag for new use cases eventually.
+
     Example where this can be useful:
 
     .. code-block:: python
@@ -692,9 +762,8 @@ of the above sections.
 .. option:: --extra-checks
 
     This flag enables additional checks that are technically correct but may be
-    impractical in real code. In particular, it prohibits partial overlap in
-    ``TypedDict`` updates, and makes arguments prepended via ``Concatenate``
-    positional-only. For example:
+    impractical. In particular, it prohibits partial overlap in ``TypedDict`` updates,
+    and makes arguments prepended via ``Concatenate`` positional-only. For example:
 
     .. code-block:: python
 
@@ -717,10 +786,28 @@ of the above sections.
        bad: Bad = {"a": 0, "b": "no"}
        test(bad, bar)
 
+    In future more checks may be added to this flag if:
+
+    * The corresponding use cases are rare, thus not justifying a dedicated
+      strictness flag.
+
+    * The new check cannot be supported as an opt-in error code.
+
 .. option:: --strict
 
-    This flag mode enables all optional error checking flags.  You can see the
-    list of flags enabled by strict mode in the full :option:`mypy --help` output.
+    This flag mode enables a defined subset of optional error-checking flags.
+    This subset primarily includes checks for inadvertent type unsoundness (i.e
+    strict will catch type errors as long as intentional methods like type ignore
+    or casting were not used.)
+
+    Note: the :option:`--warn-unreachable` flag
+    is not automatically enabled by the strict flag.
+
+    The strict flag does not take precedence over other strict-related flags.
+    Directly specifying a flag of alternate behavior will override the
+    behavior of strict, regardless of the order in which they are passed.
+    You can see the list of flags enabled by strict mode in the full
+    :option:`mypy --help` output.
 
     Note: the exact list of flags enabled by running :option:`--strict` may change
     over time.
diff -pruN 1.15.0-5/docs/source/config_file.rst 1.16~rc0.1-1/docs/source/config_file.rst
--- 1.15.0-5/docs/source/config_file.rst	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/docs/source/config_file.rst	2025-05-27 17:21:15.000000000 +0000
@@ -288,6 +288,14 @@ section of the command line docs.
 
        See :ref:`using-a-pyproject-toml`.
 
+.. confval:: exclude_gitignore
+
+    :type: boolean
+    :default: False
+
+    This flag will add everything that matches ``.gitignore`` file(s) to :confval:`exclude`.
+    This option may only be set in the global section (``[mypy]``).
+
 .. confval:: namespace_packages
 
     :type: boolean
@@ -424,7 +432,7 @@ Platform configuration
 
     Specifies the Python version used to parse and check the target
     program.  The string should be in the format ``MAJOR.MINOR`` --
-    for example ``2.7``.  The default is the version of the Python
+    for example ``3.9``.  The default is the version of the Python
     interpreter used to run mypy.
 
     This option may only be set in the global section (``[mypy]``).
@@ -666,6 +674,16 @@ section of the command line docs.
     Shows a warning when encountering any code inferred to be unreachable or
     redundant after performing type analysis.
 
+.. confval:: deprecated_calls_exclude
+
+    :type: comma-separated list of strings
+
+    Selectively excludes functions and methods defined in specific packages,
+    modules, and classes from the :ref:`deprecated<code-deprecated>` error code.
+    This also applies to all submodules of packages (i.e. everything inside
+    a given prefix). Note, this option does not support per-file configuration,
+    the exclusions list is defined globally for all your code.
+
 
 Suppressing errors
 ******************
@@ -695,6 +713,44 @@ section of the command line docs.
     Causes mypy to suppress errors caused by not being able to fully
     infer the types of global and class variables.
 
+.. confval:: allow_redefinition_new
+
+    :type: boolean
+    :default: False
+
+    By default, mypy won't allow a variable to be redefined with an
+    unrelated type. This *experimental* flag enables the redefinition of
+    unannotated variables with an arbitrary type. You will also need to enable
+    :confval:`local_partial_types`.
+    Example:
+
+    .. code-block:: python
+
+        def maybe_convert(n: int, b: bool) -> int | str:
+            if b:
+                x = str(n)  # Assign "str"
+            else:
+                x = n       # Assign "int"
+            # Type of "x" is "int | str" here.
+            return x
+
+    This also enables an unannotated variable to have different types in different
+    code locations:
+
+    .. code-block:: python
+
+        if check():
+            for x in range(n):
+                # Type of "x" is "int" here.
+                ...
+        else:
+            for x in ['a', 'b']:
+                # Type of "x" is "str" here.
+                ...
+
+    Note: We are planning to turn this flag on by default in a future mypy
+    release, along with :confval:`local_partial_types`.
+
 .. confval:: allow_redefinition
 
     :type: boolean
@@ -728,6 +784,7 @@ section of the command line docs.
 
     Disallows inferring variable type for ``None`` from two assignments in different scopes.
     This is always implicitly enabled when using the :ref:`mypy daemon <mypy_daemon>`.
+    This will be enabled by default in a future mypy release.
 
 .. confval:: disable_error_code
 
@@ -748,7 +805,7 @@ section of the command line docs.
    :type: boolean
    :default: False
 
-   This flag enables additional checks that are technically correct but may be impractical in real code.
+   This flag enables additional checks that are technically correct but may be impractical.
    See :option:`mypy --extra-checks` for more info.
 
 .. confval:: implicit_reexport
@@ -771,13 +828,6 @@ section of the command line docs.
        from foo import bar
        __all__ = ['bar']
 
-.. confval:: strict_concatenate
-
-   :type: boolean
-   :default: False
-
-   Make arguments prepended via ``Concatenate`` be truly positional-only.
-
 .. confval:: strict_equality
 
    :type: boolean
@@ -1185,7 +1235,7 @@ of your repo (or append it to the end of
     # mypy global options:
 
     [tool.mypy]
-    python_version = "2.7"
+    python_version = "3.9"
     warn_return_any = true
     warn_unused_configs = true
     exclude = [
diff -pruN 1.15.0-5/docs/source/error_code_list2.rst 1.16~rc0.1-1/docs/source/error_code_list2.rst
--- 1.15.0-5/docs/source/error_code_list2.rst	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/docs/source/error_code_list2.rst	2025-05-27 17:21:15.000000000 +0000
@@ -243,6 +243,8 @@ locally.  Features are considered deprec
 specified in `PEP 702 <https://peps.python.org/pep-0702>`_.
 Use the :option:`--report-deprecated-as-note <mypy --report-deprecated-as-note>` option to
 turn all such errors into notes.
+Use :option:`--deprecated-calls-exclude <mypy --deprecated-calls-exclude>` to hide warnings
+for specific functions, classes and packages.
 
 .. note::
 
diff -pruN 1.15.0-5/docs/source/existing_code.rst 1.16~rc0.1-1/docs/source/existing_code.rst
--- 1.15.0-5/docs/source/existing_code.rst	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/docs/source/existing_code.rst	2025-05-27 17:21:15.000000000 +0000
@@ -199,9 +199,8 @@ The following config is equivalent to ``
    warn_redundant_casts = True
    warn_unused_ignores = True
 
-   # Getting these passing should be easy
+   # Getting this passing should be easy
    strict_equality = True
-   strict_concatenate = True
 
    # Strongly recommend enabling this one as soon as you can
    check_untyped_defs = True
@@ -223,6 +222,10 @@ The following config is equivalent to ``
    # This one can be tricky to get passing if you use a lot of untyped libraries
    warn_return_any = True
 
+   # This one is a catch-all flag for the rest of strict checks that are technically
+   # correct but may not be practical
+   extra_checks = True
+
 Note that you can also start with ``--strict`` and subtract, for instance:
 
 .. code-block:: text
diff -pruN 1.15.0-5/docs/source/generics.rst 1.16~rc0.1-1/docs/source/generics.rst
--- 1.15.0-5/docs/source/generics.rst	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/docs/source/generics.rst	2025-05-27 17:21:15.000000000 +0000
@@ -999,7 +999,7 @@ similarly supported via generics (Python
 
 .. code-block:: python
 
-    from colletions.abc import Callable
+    from collections.abc import Callable
     from typing import Any
 
     def route[F: Callable[..., Any]](url: str) -> Callable[[F], F]:
diff -pruN 1.15.0-5/docs/source/metaclasses.rst 1.16~rc0.1-1/docs/source/metaclasses.rst
--- 1.15.0-5/docs/source/metaclasses.rst	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/docs/source/metaclasses.rst	2025-05-27 17:21:15.000000000 +0000
@@ -34,12 +34,14 @@ Mypy supports the lookup of attributes i
 
 .. code-block:: python
 
-    from typing import ClassVar, Self
+    from typing import ClassVar, TypeVar
+
+    S = TypeVar("S")
 
     class M(type):
         count: ClassVar[int] = 0
 
-        def make(cls) -> Self:
+        def make(cls: type[S]) -> S:
             M.count += 1
             return cls()
 
@@ -55,9 +57,6 @@ Mypy supports the lookup of attributes i
     b: B = B.make()  # metaclasses are inherited
     print(B.count + " objects were created")  # Error: Unsupported operand types for + ("int" and "str")
 
-.. note::
-    In Python 3.10 and earlier, ``Self`` is available in ``typing_extensions``.
-
 .. _limitations:
 
 Gotchas and limitations of metaclass support
@@ -88,3 +87,6 @@ so it's better not to combine metaclasse
   such as ``class A(metaclass=f()): ...``
 * Mypy does not and cannot understand arbitrary metaclass code.
 * Mypy only recognizes subclasses of :py:class:`type` as potential metaclasses.
+* ``Self`` is not allowed as annotation in metaclasses as per `PEP 673`_.
+
+.. _PEP 673: https://peps.python.org/pep-0673/#valid-locations-for-self
diff -pruN 1.15.0-5/docs/source/more_types.rst 1.16~rc0.1-1/docs/source/more_types.rst
--- 1.15.0-5/docs/source/more_types.rst	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/docs/source/more_types.rst	2025-05-27 17:21:15.000000000 +0000
@@ -390,7 +390,7 @@ program:
 The ``summarize([])`` call matches both variants: an empty list could
 be either a ``list[int]`` or a ``list[str]``. In this case, mypy
 will break the tie by picking the first matching variant: ``output``
-will have an inferred type of ``float``. The implementor is responsible
+will have an inferred type of ``float``. The implementer is responsible
 for making sure ``summarize`` breaks ties in the same way at runtime.
 
 However, there are two exceptions to the "pick the first match" rule.
diff -pruN 1.15.0-5/docs/source/runtime_troubles.rst 1.16~rc0.1-1/docs/source/runtime_troubles.rst
--- 1.15.0-5/docs/source/runtime_troubles.rst	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/docs/source/runtime_troubles.rst	2025-05-27 17:21:15.000000000 +0000
@@ -8,10 +8,9 @@ version of Python considers legal code.
 and explains how to get your code running again. Generally speaking, we have
 three tools at our disposal:
 
-* Use of ``from __future__ import annotations`` (:pep:`563`)
-  (this behaviour may eventually be made the default in a future Python version)
 * Use of string literal types or type comments
 * Use of ``typing.TYPE_CHECKING``
+* Use of ``from __future__ import annotations`` (:pep:`563`)
 
 We provide a description of these before moving onto discussion of specific
 problems you may encounter.
@@ -274,7 +273,7 @@ libraries if types are generic only in s
 Using types defined in stubs but not at runtime
 -----------------------------------------------
 
-Sometimes stubs that you're using may define types you wish to re-use that do
+Sometimes stubs that you're using may define types you wish to reuse that do
 not exist at runtime. Importing these types naively will cause your code to fail
 at runtime with ``ImportError`` or ``ModuleNotFoundError``. Similar to previous
 sections, these can be dealt with by using :ref:`typing.TYPE_CHECKING
diff -pruN 1.15.0-5/docs/source/type_narrowing.rst 1.16~rc0.1-1/docs/source/type_narrowing.rst
--- 1.15.0-5/docs/source/type_narrowing.rst	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/docs/source/type_narrowing.rst	2025-05-27 17:21:15.000000000 +0000
@@ -8,6 +8,15 @@ techniques which are supported by mypy.
 
 Type narrowing is when you convince a type checker that a broader type is actually more specific, for instance, that an object of type ``Shape`` is actually of the narrower type ``Square``.
 
+The following type narrowing techniques are available:
+
+- :ref:`type-narrowing-expressions`
+- :ref:`casts`
+- :ref:`type-guards`
+- :ref:`typeis`
+
+
+.. _type-narrowing-expressions:
 
 Type narrowing expressions
 --------------------------
@@ -356,40 +365,6 @@ What happens here?
 
   The same will work with ``isinstance(x := a, float)`` as well.
 
-Limitations
------------
-
-Mypy's analysis is limited to individual symbols and it will not track
-relationships between symbols. For example, in the following code
-it's easy to deduce that if :code:`a` is None then :code:`b` must not be,
-therefore :code:`a or b` will always be an instance of :code:`C`,
-but Mypy will not be able to tell that:
-
-.. code-block:: python
-
-    class C:
-        pass
-
-    def f(a: C | None, b: C | None) -> C:
-        if a is not None or b is not None:
-            return a or b  # Incompatible return value type (got "C | None", expected "C")
-        return C()
-
-Tracking these sort of cross-variable conditions in a type checker would add significant complexity
-and performance overhead.
-
-You can use an ``assert`` to convince the type checker, override it with a :ref:`cast <casts>`
-or rewrite the function to be slightly more verbose:
-
-.. code-block:: python
-
-    def f(a: C | None, b: C | None) -> C:
-        if a is not None:
-            return a
-        elif b is not None:
-            return b
-        return C()
-
 
 .. _typeis:
 
@@ -555,3 +530,38 @@ You can use the assignment expression op
             reveal_type(x)  # Revealed type is 'float'
             # x is narrowed to float in this block
             print(x + 1.0)
+
+
+Limitations
+-----------
+
+Mypy's analysis is limited to individual symbols and it will not track
+relationships between symbols. For example, in the following code
+it's easy to deduce that if :code:`a` is None then :code:`b` must not be,
+therefore :code:`a or b` will always be an instance of :code:`C`,
+but Mypy will not be able to tell that:
+
+.. code-block:: python
+
+    class C:
+        pass
+
+    def f(a: C | None, b: C | None) -> C:
+        if a is not None or b is not None:
+            return a or b  # Incompatible return value type (got "C | None", expected "C")
+        return C()
+
+Tracking these sort of cross-variable conditions in a type checker would add significant complexity
+and performance overhead.
+
+You can use an ``assert`` to convince the type checker, override it with a :ref:`cast <casts>`
+or rewrite the function to be slightly more verbose:
+
+.. code-block:: python
+
+    def f(a: C | None, b: C | None) -> C:
+        if a is not None:
+            return a
+        elif b is not None:
+            return b
+        return C()
diff -pruN 1.15.0-5/misc/analyze_cache.py 1.16~rc0.1-1/misc/analyze_cache.py
--- 1.15.0-5/misc/analyze_cache.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/analyze_cache.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,204 @@
+#!/usr/bin/env python
+
+from __future__ import annotations
+
+import json
+import os
+import os.path
+from collections import Counter
+from collections.abc import Iterable
+from typing import Any, Final
+from typing_extensions import TypeAlias as _TypeAlias
+
+ROOT: Final = ".mypy_cache/3.5"
+
+JsonDict: _TypeAlias = dict[str, Any]
+
+
+class CacheData:
+    def __init__(
+        self,
+        filename: str,
+        data_json: JsonDict,
+        meta_json: JsonDict,
+        data_size: int,
+        meta_size: int,
+    ) -> None:
+        self.filename = filename
+        self.data = data_json
+        self.meta = meta_json
+        self.data_size = data_size
+        self.meta_size = meta_size
+
+    @property
+    def total_size(self) -> int:
+        return self.data_size + self.meta_size
+
+
+def extract_classes(chunks: Iterable[CacheData]) -> Iterable[JsonDict]:
+    def extract(chunks: Iterable[JsonDict]) -> Iterable[JsonDict]:
+        for chunk in chunks:
+            if isinstance(chunk, dict):
+                yield chunk
+                yield from extract(chunk.values())
+            elif isinstance(chunk, list):
+                yield from extract(chunk)
+
+    yield from extract([chunk.data for chunk in chunks])
+
+
+def load_json(data_path: str, meta_path: str) -> CacheData:
+    with open(data_path) as ds:
+        data_json = json.load(ds)
+
+    with open(meta_path) as ms:
+        meta_json = json.load(ms)
+
+    data_size = os.path.getsize(data_path)
+    meta_size = os.path.getsize(meta_path)
+
+    return CacheData(
+        data_path.replace(".data.json", ".*.json"), data_json, meta_json, data_size, meta_size
+    )
+
+
+def get_files(root: str) -> Iterable[CacheData]:
+    for dirpath, dirnames, filenames in os.walk(root):
+        for filename in filenames:
+            if filename.endswith(".data.json"):
+                meta_filename = filename.replace(".data.json", ".meta.json")
+                yield load_json(
+                    os.path.join(dirpath, filename), os.path.join(dirpath, meta_filename)
+                )
+
+
+def pluck(name: str, chunks: Iterable[JsonDict]) -> Iterable[JsonDict]:
+    return (chunk for chunk in chunks if chunk[".class"] == name)
+
+
+def report_counter(counter: Counter[str], amount: int | None = None) -> None:
+    for name, count in counter.most_common(amount):
+        print(f"    {count: <8} {name}")
+    print()
+
+
+def report_most_common(chunks: list[JsonDict], amount: int | None = None) -> None:
+    report_counter(Counter(str(chunk) for chunk in chunks), amount)
+
+
+def compress(chunk: JsonDict) -> JsonDict:
+    cache: dict[int, JsonDict] = {}
+    counter = 0
+
+    def helper(chunk: JsonDict) -> JsonDict:
+        nonlocal counter
+        if not isinstance(chunk, dict):
+            return chunk
+
+        if len(chunk) <= 2:
+            return chunk
+        id = hash(str(chunk))
+
+        if id in cache:
+            return cache[id]
+        else:
+            cache[id] = {".id": counter}
+            chunk[".cache_id"] = counter
+            counter += 1
+
+        for name in sorted(chunk.keys()):
+            value = chunk[name]
+            if isinstance(value, list):
+                chunk[name] = [helper(child) for child in value]
+            elif isinstance(value, dict):
+                chunk[name] = helper(value)
+
+        return chunk
+
+    out = helper(chunk)
+    return out
+
+
+def decompress(chunk: JsonDict) -> JsonDict:
+    cache: dict[int, JsonDict] = {}
+
+    def helper(chunk: JsonDict) -> JsonDict:
+        if not isinstance(chunk, dict):
+            return chunk
+        if ".id" in chunk:
+            return cache[chunk[".id"]]
+
+        counter = None
+        if ".cache_id" in chunk:
+            counter = chunk[".cache_id"]
+            del chunk[".cache_id"]
+
+        for name in sorted(chunk.keys()):
+            value = chunk[name]
+            if isinstance(value, list):
+                chunk[name] = [helper(child) for child in value]
+            elif isinstance(value, dict):
+                chunk[name] = helper(value)
+
+        if counter is not None:
+            cache[counter] = chunk
+
+        return chunk
+
+    return helper(chunk)
+
+
+def main() -> None:
+    json_chunks = list(get_files(ROOT))
+    class_chunks = list(extract_classes(json_chunks))
+
+    total_size = sum(chunk.total_size for chunk in json_chunks)
+    print(f"Total cache size: {total_size / (1024 * 1024):.3f} megabytes")
+    print()
+
+    class_name_counter = Counter(chunk[".class"] for chunk in class_chunks)
+    print("Most commonly used classes:")
+    report_counter(class_name_counter)
+
+    print("Most common literal chunks:")
+    report_most_common(class_chunks, 15)
+
+    build = None
+    for chunk in json_chunks:
+        if "build.*.json" in chunk.filename:
+            build = chunk
+            break
+    assert build is not None
+    original = json.dumps(build.data, sort_keys=True)
+    print(f"Size of build.data.json, in kilobytes: {len(original) / 1024:.3f}")
+
+    build.data = compress(build.data)
+    compressed = json.dumps(build.data, sort_keys=True)
+    print(f"Size of compressed build.data.json, in kilobytes: {len(compressed) / 1024:.3f}")
+
+    build.data = decompress(build.data)
+    decompressed = json.dumps(build.data, sort_keys=True)
+    print(f"Size of decompressed build.data.json, in kilobytes: {len(decompressed) / 1024:.3f}")
+
+    print("Lossless conversion back", original == decompressed)
+
+    """var_chunks = list(pluck("Var", class_chunks))
+    report_most_common(var_chunks, 20)
+    print()
+
+    #for var in var_chunks:
+    #    if var['fullname'] == 'self' and not (isinstance(var['type'], dict) and var['type']['.class'] == 'AnyType'):
+    #        print(var)
+    #argument_chunks = list(pluck("Argument", class_chunks))
+
+    symbol_table_node_chunks = list(pluck("SymbolTableNode", class_chunks))
+    report_most_common(symbol_table_node_chunks, 20)
+
+    print()
+    print("Most common")
+    report_most_common(class_chunks, 20)
+    print()"""
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/apply-cache-diff.py 1.16~rc0.1-1/misc/apply-cache-diff.py
--- 1.15.0-5/misc/apply-cache-diff.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/apply-cache-diff.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,59 @@
+#!/usr/bin/env python3
+"""Script for applying a cache diff.
+
+With some infrastructure, this can allow for distributing small cache diffs to users in
+many cases instead of full cache artifacts.
+"""
+
+from __future__ import annotations
+
+import argparse
+import os
+import sys
+
+sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
+
+from mypy.metastore import FilesystemMetadataStore, MetadataStore, SqliteMetadataStore
+from mypy.util import json_dumps, json_loads
+
+
+def make_cache(input_dir: str, sqlite: bool) -> MetadataStore:
+    if sqlite:
+        return SqliteMetadataStore(input_dir)
+    else:
+        return FilesystemMetadataStore(input_dir)
+
+
+def apply_diff(cache_dir: str, diff_file: str, sqlite: bool = False) -> None:
+    cache = make_cache(cache_dir, sqlite)
+    with open(diff_file, "rb") as f:
+        diff = json_loads(f.read())
+
+    old_deps = json_loads(cache.read("@deps.meta.json"))
+
+    for file, data in diff.items():
+        if data is None:
+            cache.remove(file)
+        else:
+            cache.write(file, data)
+            if file.endswith(".meta.json") and "@deps" not in file:
+                meta = json_loads(data)
+                old_deps["snapshot"][meta["id"]] = meta["hash"]
+
+    cache.write("@deps.meta.json", json_dumps(old_deps))
+
+    cache.commit()
+
+
+def main() -> None:
+    parser = argparse.ArgumentParser()
+    parser.add_argument("--sqlite", action="store_true", default=False, help="Use a sqlite cache")
+    parser.add_argument("cache_dir", help="Directory for the cache")
+    parser.add_argument("diff", help="Cache diff file")
+    args = parser.parse_args()
+
+    apply_diff(args.cache_dir, args.diff, args.sqlite)
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/build-debug-python.sh 1.16~rc0.1-1/misc/build-debug-python.sh
--- 1.15.0-5/misc/build-debug-python.sh	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/build-debug-python.sh	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,34 @@
+#!/bin/bash -eux
+
+# Build a debug build of python, install it, and create a venv for it
+# This is mainly intended for use in our github actions builds but it can work
+# locally. (Though it unfortunately uses brew on OS X to deal with openssl
+# nonsense.)
+# Usage: build-debug-python.sh <version> <install prefix> <venv location>
+#
+# Running it locally might look something like: mkdir -p ~/tmp/cpython-debug && cd ~/tmp/cpython-debug && ~/src/mypy/misc/build-debug-python.sh 3.6.6 ~/tmp/cpython-debug ~/src/mypy/env-debug
+
+VERSION=$1
+PREFIX=$2
+VENV=$3
+if [[ -f $PREFIX/bin/python3 ]]; then
+    exit
+fi
+
+CPPFLAGS=""
+LDFLAGS=""
+if [[ $(uname) == Darwin ]]; then
+    brew install openssl xz
+    CPPFLAGS="-I$(brew --prefix openssl)/include"
+    LDFLAGS="-L$(brew --prefix openssl)/lib"
+fi
+
+curl -O https://www.python.org/ftp/python/$VERSION/Python-$VERSION.tgz
+tar zxf Python-$VERSION.tgz
+cd Python-$VERSION
+CPPFLAGS="$CPPFLAGS" LDFLAGS="$LDFLAGS" ./configure CFLAGS="-DPy_DEBUG -DPy_TRACE_REFS -DPYMALLOC_DEBUG" --with-pydebug --prefix=$PREFIX --with-trace-refs
+make -j4
+make install
+$PREFIX/bin/python3 -m pip install virtualenv
+$PREFIX/bin/python3 -m virtualenv $VENV
+ln -s python3-config $PREFIX/bin/python-config
diff -pruN 1.15.0-5/misc/build_wheel.py 1.16~rc0.1-1/misc/build_wheel.py
--- 1.15.0-5/misc/build_wheel.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/build_wheel.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,12 @@
+"""
+The main GitHub workflow where wheels are built:
+https://github.com/mypyc/mypy_mypyc-wheels/blob/master/.github/workflows/build.yml
+
+The script that builds wheels:
+https://github.com/mypyc/mypy_mypyc-wheels/blob/master/build_wheel.py
+
+That script is a light wrapper around cibuildwheel. Now that cibuildwheel has native configuration
+and better support for local builds, we could probably replace the script.
+"""
+
+raise ImportError("This script has been moved back to https://github.com/mypyc/mypy_mypyc-wheels")
diff -pruN 1.15.0-5/misc/cherry-pick-typeshed.py 1.16~rc0.1-1/misc/cherry-pick-typeshed.py
--- 1.15.0-5/misc/cherry-pick-typeshed.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/cherry-pick-typeshed.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,70 @@
+"""Cherry-pick a commit from typeshed.
+
+Usage:
+
+  python3 misc/cherry-pick-typeshed.py --typeshed-dir dir hash
+"""
+
+from __future__ import annotations
+
+import argparse
+import os.path
+import re
+import subprocess
+import sys
+import tempfile
+
+
+def parse_commit_title(diff: str) -> str:
+    m = re.search("\n    ([^ ].*)", diff)
+    assert m is not None, "Could not parse diff"
+    return m.group(1)
+
+
+def main() -> None:
+    parser = argparse.ArgumentParser()
+    parser.add_argument(
+        "--typeshed-dir", help="location of typeshed", metavar="dir", required=True
+    )
+    parser.add_argument("commit", help="typeshed commit hash to cherry-pick")
+    args = parser.parse_args()
+    typeshed_dir = args.typeshed_dir
+    commit = args.commit
+
+    if not os.path.isdir(typeshed_dir):
+        sys.exit(f"error: {typeshed_dir} does not exist")
+    if not re.match("[0-9a-fA-F]+$", commit):
+        sys.exit(f"error: Invalid commit {commit!r}")
+
+    if not os.path.exists("mypy") or not os.path.exists("mypyc"):
+        sys.exit("error: This script must be run at the mypy repository root directory")
+
+    with tempfile.TemporaryDirectory() as d:
+        diff_file = os.path.join(d, "diff")
+        out = subprocess.run(
+            ["git", "show", commit], capture_output=True, text=True, check=True, cwd=typeshed_dir
+        )
+        with open(diff_file, "w") as f:
+            f.write(out.stdout)
+        subprocess.run(
+            [
+                "git",
+                "apply",
+                "--index",
+                "--directory=mypy/typeshed",
+                "--exclude=**/tests/**",
+                "--exclude=**/test_cases/**",
+                diff_file,
+            ],
+            check=True,
+        )
+
+        title = parse_commit_title(out.stdout)
+        subprocess.run(["git", "commit", "-m", f"Typeshed cherry-pick: {title}"], check=True)
+
+    print()
+    print(f"Cherry-picked commit {commit} from {typeshed_dir}")
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/clean-mypyc.sh 1.16~rc0.1-1/misc/clean-mypyc.sh
--- 1.15.0-5/misc/clean-mypyc.sh	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/clean-mypyc.sh	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,4 @@
+#!/bin/bash
+echo "Cleaning C/C++ build artifacts..."
+(cd mypyc/lib-rt; make clean)
+(cd mypyc/external/googletest/make; make clean)
diff -pruN 1.15.0-5/misc/convert-cache.py 1.16~rc0.1-1/misc/convert-cache.py
--- 1.15.0-5/misc/convert-cache.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/convert-cache.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,61 @@
+#!/usr/bin/env python3
+"""Script for converting between cache formats.
+
+We support a filesystem tree based cache and a sqlite based cache.
+See mypy/metastore.py for details.
+"""
+
+from __future__ import annotations
+
+import os
+import re
+import sys
+
+sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
+
+import argparse
+
+from mypy.metastore import FilesystemMetadataStore, MetadataStore, SqliteMetadataStore
+
+
+def main() -> None:
+    parser = argparse.ArgumentParser()
+    parser.add_argument(
+        "--to-sqlite",
+        action="store_true",
+        default=False,
+        help="Convert to a sqlite cache (default: convert from)",
+    )
+    parser.add_argument(
+        "--output_dir",
+        action="store",
+        default=None,
+        help="Output cache location (default: same as input)",
+    )
+    parser.add_argument("input_dir", help="Input directory for the cache")
+    args = parser.parse_args()
+
+    input_dir = args.input_dir
+    output_dir = args.output_dir or input_dir
+    assert os.path.isdir(output_dir), f"{output_dir} is not a directory"
+    if args.to_sqlite:
+        input: MetadataStore = FilesystemMetadataStore(input_dir)
+        output: MetadataStore = SqliteMetadataStore(output_dir)
+    else:
+        fnam = os.path.join(input_dir, "cache.db")
+        msg = f"{fnam} does not exist"
+        if not re.match(r"[0-9]+\.[0-9]+$", os.path.basename(input_dir)):
+            msg += f" (are you missing Python version at the end, e.g. {input_dir}/3.11)"
+        assert os.path.isfile(fnam), msg
+        input, output = SqliteMetadataStore(input_dir), FilesystemMetadataStore(output_dir)
+
+    for s in input.list_all():
+        if s.endswith(".json"):
+            assert output.write(
+                s, input.read(s), input.getmtime(s)
+            ), f"Failed to write cache file {s}!"
+    output.commit()
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/diff-cache.py 1.16~rc0.1-1/misc/diff-cache.py
--- 1.15.0-5/misc/diff-cache.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/diff-cache.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,144 @@
+#!/usr/bin/env python3
+"""Produce a diff between mypy caches.
+
+With some infrastructure, this can allow for distributing small cache diffs to users in
+many cases instead of full cache artifacts.
+"""
+
+from __future__ import annotations
+
+import argparse
+import os
+import sys
+from collections import defaultdict
+from typing import Any
+
+sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
+
+from mypy.metastore import FilesystemMetadataStore, MetadataStore, SqliteMetadataStore
+from mypy.util import json_dumps, json_loads
+
+
+def make_cache(input_dir: str, sqlite: bool) -> MetadataStore:
+    if sqlite:
+        return SqliteMetadataStore(input_dir)
+    else:
+        return FilesystemMetadataStore(input_dir)
+
+
+def merge_deps(all: dict[str, set[str]], new: dict[str, set[str]]) -> None:
+    for k, v in new.items():
+        all.setdefault(k, set()).update(v)
+
+
+def load(cache: MetadataStore, s: str) -> Any:
+    data = cache.read(s)
+    obj = json_loads(data)
+    if s.endswith(".meta.json"):
+        # For meta files, zero out the mtimes and sort the
+        # dependencies to avoid spurious conflicts
+        obj["mtime"] = 0
+        obj["data_mtime"] = 0
+        if "dependencies" in obj:
+            all_deps = obj["dependencies"] + obj["suppressed"]
+            num_deps = len(obj["dependencies"])
+            thing = list(zip(all_deps, obj["dep_prios"], obj["dep_lines"]))
+
+            def unzip(x: Any) -> Any:
+                return zip(*x) if x else ((), (), ())
+
+            obj["dependencies"], prios1, lines1 = unzip(sorted(thing[:num_deps]))
+            obj["suppressed"], prios2, lines2 = unzip(sorted(thing[num_deps:]))
+            obj["dep_prios"] = prios1 + prios2
+            obj["dep_lines"] = lines1 + lines2
+    if s.endswith(".deps.json"):
+        # For deps files, sort the deps to avoid spurious mismatches
+        for v in obj.values():
+            v.sort()
+    return obj
+
+
+def main() -> None:
+    parser = argparse.ArgumentParser()
+    parser.add_argument("--verbose", action="store_true", default=False, help="Increase verbosity")
+    parser.add_argument("--sqlite", action="store_true", default=False, help="Use a sqlite cache")
+    parser.add_argument("input_dir1", help="Input directory for the cache")
+    parser.add_argument("input_dir2", help="Input directory for the cache")
+    parser.add_argument("output", help="Output file")
+    args = parser.parse_args()
+
+    cache1 = make_cache(args.input_dir1, args.sqlite)
+    cache2 = make_cache(args.input_dir2, args.sqlite)
+
+    type_misses: dict[str, int] = defaultdict(int)
+    type_hits: dict[str, int] = defaultdict(int)
+
+    updates: dict[str, bytes | None] = {}
+
+    deps1: dict[str, set[str]] = {}
+    deps2: dict[str, set[str]] = {}
+
+    misses = hits = 0
+    cache1_all = list(cache1.list_all())
+    for s in cache1_all:
+        obj1 = load(cache1, s)
+        try:
+            obj2 = load(cache2, s)
+        except FileNotFoundError:
+            obj2 = None
+
+        typ = s.split(".")[-2]
+        if obj1 != obj2:
+            misses += 1
+            type_misses[typ] += 1
+
+            # Collect the dependencies instead of including them directly in the diff
+            # so we can produce a much smaller direct diff of them.
+            if ".deps." not in s:
+                if obj2 is not None:
+                    updates[s] = json_dumps(obj2)
+                else:
+                    updates[s] = None
+            elif obj2:
+                merge_deps(deps1, obj1)
+                merge_deps(deps2, obj2)
+        else:
+            hits += 1
+            type_hits[typ] += 1
+
+    cache1_all_set = set(cache1_all)
+    for s in cache2.list_all():
+        if s not in cache1_all_set:
+            updates[s] = cache2.read(s)
+
+    # Compute what deps have been added and merge them all into the
+    # @root deps file.
+    new_deps = {k: deps1.get(k, set()) - deps2.get(k, set()) for k in deps2}
+    new_deps = {k: v for k, v in new_deps.items() if v}
+    try:
+        root_deps = load(cache1, "@root.deps.json")
+    except FileNotFoundError:
+        root_deps = {}
+    merge_deps(new_deps, root_deps)
+
+    new_deps_json = {k: list(v) for k, v in new_deps.items() if v}
+    updates["@root.deps.json"] = json_dumps(new_deps_json)
+
+    # Drop updates to deps.meta.json for size reasons. The diff
+    # applier will manually fix it up.
+    updates.pop("./@deps.meta.json", None)
+    updates.pop("@deps.meta.json", None)
+
+    ###
+
+    print("Generated incremental cache:", hits, "hits,", misses, "misses")
+    if args.verbose:
+        print("hits", type_hits)
+        print("misses", type_misses)
+
+    with open(args.output, "wb") as f:
+        f.write(json_dumps(updates))
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/docker/Dockerfile 1.16~rc0.1-1/misc/docker/Dockerfile
--- 1.15.0-5/misc/docker/Dockerfile	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/docker/Dockerfile	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,12 @@
+FROM ubuntu:latest
+
+WORKDIR /mypy
+
+RUN apt-get update
+RUN apt-get install -y python3 python3-pip clang
+
+COPY mypy-requirements.txt .
+COPY test-requirements.txt .
+COPY build-requirements.txt .
+
+RUN pip3 install -r test-requirements.txt
diff -pruN 1.15.0-5/misc/docker/README.md 1.16~rc0.1-1/misc/docker/README.md
--- 1.15.0-5/misc/docker/README.md	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/docker/README.md	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,101 @@
+Running mypy and mypyc tests in a Docker container
+==================================================
+
+This directory contains scripts for running mypy and mypyc tests in a
+Linux Docker container. This allows running Linux tests on a different
+operating system that supports Docker, or running tests in an
+isolated, predictable environment on a Linux host operating system.
+
+Why use Docker?
+---------------
+
+Mypyc tests can be significantly faster in a Docker container than
+running natively on macOS.
+
+Also, if it's inconvenient to install the necessary dependencies on the
+host operating system, or there are issues getting some tests to pass
+on the host operating system, using a container can be an easy
+workaround.
+
+Prerequisites
+-------------
+
+First install Docker. On macOS, both Docker Desktop (proprietary, but
+with a free of charge subscription for some use cases) and Colima (MIT
+license) should work as runtimes.
+
+You may have to explicitly start the runtime first. Colima example
+(replace '8' with the number of CPU cores you have):
+
+```
+$ colima start -c 8
+
+```
+
+How to run tests
+----------------
+
+You need to build the container with all necessary dependencies before
+you can run tests:
+
+```
+$ python3 misc/docker/build.py
+```
+
+This creates a `mypy-test` Docker container that you can use to run
+tests.
+
+You may need to run the script as root:
+
+```
+$ sudo python3 misc/docker/build.py
+```
+
+If you have a stale container which isn't up-to-date, use `--no-cache`
+`--pull` to force rebuilding everything:
+
+```
+$ python3 misc/docker/build.py --no-cache --pull
+```
+
+Now you can run tests by using the `misc/docker/run.sh` script. Give
+it the pytest command line you want to run as arguments. For example,
+you can run mypyc tests like this:
+
+```
+$ misc/docker/run.sh pytest mypyc
+```
+
+You can also use `-k <filter>`, `-n0`, `-q`, etc.
+
+Again, you may need to run `run.sh` as root:
+
+```
+$ sudo misc/docker/run.sh pytest mypyc
+```
+
+You can also use `runtests.py` in the container. Example:
+
+```
+$ misc/docker/run.sh ./runtests.py self lint
+```
+
+Notes
+-----
+
+File system changes within the container are not visible to the host
+system. You can't use the container to format code using Black, for
+example.
+
+On a mac, you may want to give additional CPU to the VM used to run
+the container. The default allocation may be way too low (e.g. 2 CPU
+cores). For example, use the `-c` option when starting the VM if you
+use Colima:
+
+```
+$ colima start -c 8
+```
+
+Giving access to all available CPUs to the Linux VM tends to provide
+the best performance. This is not needed on a Linux host, since the
+container is not run in a VM.
diff -pruN 1.15.0-5/misc/docker/build.py 1.16~rc0.1-1/misc/docker/build.py
--- 1.15.0-5/misc/docker/build.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/docker/build.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,46 @@
+"""Build a "mypy-test" Linux Docker container for running mypy/mypyc tests.
+
+This allows running Linux tests under a non-Linux operating system. Mypyc
+tests can also run much faster under Linux that the host OS.
+
+NOTE: You may need to run this as root (using sudo).
+
+Run with "--no-cache" to force reinstallation of mypy dependencies.
+Run with "--pull" to force update of the Linux (Ubuntu) base image.
+
+After you've built the container, use "run.sh" to run tests. Example:
+
+  misc/docker/run.sh pytest mypyc/
+"""
+
+import argparse
+import os
+import subprocess
+import sys
+
+
+def main() -> None:
+    parser = argparse.ArgumentParser(
+        description="""Build a 'mypy-test' Docker container for running mypy/mypyc tests. You may
+                       need to run this as root (using sudo)."""
+    )
+    parser.add_argument("--no-cache", action="store_true", help="Force rebuilding")
+    parser.add_argument("--pull", action="store_true", help="Force pulling fresh Linux base image")
+    args = parser.parse_args()
+
+    dockerdir = os.path.dirname(os.path.abspath(__file__))
+    dockerfile = os.path.join(dockerdir, "Dockerfile")
+    rootdir = os.path.join(dockerdir, "..", "..")
+
+    cmdline = ["docker", "build", "-t", "mypy-test", "-f", dockerfile]
+    if args.no_cache:
+        cmdline.append("--no-cache")
+    if args.pull:
+        cmdline.append("--pull")
+    cmdline.append(rootdir)
+    result = subprocess.run(cmdline)
+    sys.exit(result.returncode)
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/docker/run-wrapper.sh 1.16~rc0.1-1/misc/docker/run-wrapper.sh
--- 1.15.0-5/misc/docker/run-wrapper.sh	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/docker/run-wrapper.sh	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,13 @@
+#!/bin/bash
+# Internal wrapper script used to run commands in a container
+
+# Copy all the files we need from the mypy repo directory shared with
+# the host to a local directory. Accessing files using a shared
+# directory on a mac can be *very* slow.
+echo "copying files to the container..."
+cp -R /repo/{mypy,mypyc,test-data,misc} .
+cp /repo/{pytest.ini,conftest.py,runtests.py,pyproject.toml,setup.cfg} .
+cp /repo/{mypy_self_check.ini,mypy_bootstrap.ini} .
+
+# Run the wrapped command
+"$@"
diff -pruN 1.15.0-5/misc/docker/run.sh 1.16~rc0.1-1/misc/docker/run.sh
--- 1.15.0-5/misc/docker/run.sh	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/docker/run.sh	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,15 @@
+#!/bin/bash
+# Run mypy or mypyc tests in a Docker container that was built using misc/docker/build.py.
+#
+# Usage: misc/docker/run.sh <command> <arg>...
+#
+# For example, run mypyc tests like this:
+#
+#   misc/docker/run.sh pytest mypyc
+#
+# NOTE: You may need to run this as root (using sudo).
+
+SCRIPT_DIR=$(cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd)
+MYPY_DIR="$SCRIPT_DIR/../.."
+
+docker run -ti --rm -v "$MYPY_DIR:/repo" mypy-test /repo/misc/docker/run-wrapper.sh "$@"
diff -pruN 1.15.0-5/misc/dump-ast.py 1.16~rc0.1-1/misc/dump-ast.py
--- 1.15.0-5/misc/dump-ast.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/dump-ast.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,48 @@
+#!/usr/bin/env python3
+"""
+Parse source files and print the abstract syntax trees.
+"""
+
+from __future__ import annotations
+
+import argparse
+import sys
+
+from mypy import defaults
+from mypy.errors import CompileError, Errors
+from mypy.options import Options
+from mypy.parse import parse
+
+
+def dump(fname: str, python_version: tuple[int, int], quiet: bool = False) -> None:
+    options = Options()
+    options.python_version = python_version
+    with open(fname, "rb") as f:
+        s = f.read()
+        tree = parse(s, fname, None, errors=Errors(options), options=options)
+        if not quiet:
+            print(tree)
+
+
+def main() -> None:
+    # Parse a file and dump the AST (or display errors).
+    parser = argparse.ArgumentParser(
+        description="Parse source files and print the abstract syntax tree (AST)."
+    )
+    parser.add_argument("--quiet", action="store_true", help="do not print AST")
+    parser.add_argument("FILE", nargs="*", help="files to parse")
+    args = parser.parse_args()
+
+    status = 0
+    for fname in args.FILE:
+        try:
+            dump(fname, defaults.PYTHON3_VERSION, args.quiet)
+        except CompileError as e:
+            for msg in e.messages:
+                sys.stderr.write("%s\n" % msg)
+            status = 1
+    sys.exit(status)
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/find_type.py 1.16~rc0.1-1/misc/find_type.py
--- 1.15.0-5/misc/find_type.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/find_type.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,99 @@
+#!/usr/bin/env python3
+# Usage: find_type.py FILENAME START_LINE START_COL END_LINE END_COL MYPY_AND_ARGS
+# Prints out the type of the expression in the given location if the mypy run
+# succeeds cleanly.  Otherwise, prints out the errors encountered.
+# Note: this only works on expressions, and not assignment targets.
+# Note: MYPY_AND_ARGS is should be the remainder of argv, not a single
+# spaces-included argument.
+# NOTE: Line numbers are 1-based; column numbers are 0-based.
+#
+#
+# Example vim usage:
+# function RevealType()
+#   " Set this to the command you use to run mypy on your project.  Include the mypy invocation.
+#   let mypycmd = 'python3 -m mypy mypy --incremental'
+#   let [startline, startcol] = getpos("'<")[1:2]
+#   let [endline, endcol] = getpos("'>")[1:2]
+#   " Convert to 0-based column offsets
+#   let startcol = startcol - 1
+#   " Change this line to point to the find_type.py script.
+#   execute '!python3 /path/to/mypy/misc/find_type.py % ' . startline . ' ' . startcol . ' ' . endline . ' ' . endcol . ' ' . mypycmd
+# endfunction
+# vnoremap <Leader>t :call RevealType()<CR>
+#
+# For an Emacs example, see misc/macs.el.
+
+from __future__ import annotations
+
+import os.path
+import re
+import subprocess
+import sys
+import tempfile
+
+REVEAL_TYPE_START = "reveal_type("
+REVEAL_TYPE_END = ")"
+
+
+def update_line(line: str, s: str, pos: int) -> str:
+    return line[:pos] + s + line[pos:]
+
+
+def run_mypy(mypy_and_args: list[str], filename: str, tmp_name: str) -> str:
+    proc = subprocess.run(
+        mypy_and_args + ["--shadow-file", filename, tmp_name], stdout=subprocess.PIPE
+    )
+    assert isinstance(
+        proc.stdout, bytes
+    )  # Guaranteed to be true because we called run with universal_newlines=False
+    return proc.stdout.decode(encoding="utf-8")
+
+
+def get_revealed_type(line: str, relevant_file: str, relevant_line: int) -> str | None:
+    m = re.match(r'(.+?):(\d+): note: Revealed type is "(.*)"$', line)
+    if m and int(m.group(2)) == relevant_line and os.path.samefile(relevant_file, m.group(1)):
+        return m.group(3)
+    else:
+        return None
+
+
+def process_output(output: str, filename: str, start_line: int) -> tuple[str | None, bool]:
+    error_found = False
+    for line in output.splitlines():
+        t = get_revealed_type(line, filename, start_line)
+        if t:
+            return t, error_found
+        elif "error:" in line:
+            error_found = True
+    return None, True  # finding no reveal_type is an error
+
+
+def main() -> None:
+    filename, start_line_str, start_col_str, end_line_str, end_col_str, *mypy_and_args = sys.argv[
+        1:
+    ]
+    start_line = int(start_line_str)
+    start_col = int(start_col_str)
+    end_line = int(end_line_str)
+    end_col = int(end_col_str)
+    with open(filename) as f:
+        lines = f.readlines()
+        lines[end_line - 1] = update_line(
+            lines[end_line - 1], REVEAL_TYPE_END, end_col
+        )  # insert after end_col
+        lines[start_line - 1] = update_line(lines[start_line - 1], REVEAL_TYPE_START, start_col)
+        with tempfile.NamedTemporaryFile(mode="w", prefix="mypy") as tmp_f:
+            tmp_f.writelines(lines)
+            tmp_f.flush()
+
+            output = run_mypy(mypy_and_args, filename, tmp_f.name)
+            revealed_type, error = process_output(output, filename, start_line)
+            if revealed_type:
+                print(revealed_type)
+            if error:
+                print(output)
+            exit(int(error))
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/gen_blog_post_html.py 1.16~rc0.1-1/misc/gen_blog_post_html.py
--- 1.15.0-5/misc/gen_blog_post_html.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/gen_blog_post_html.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,193 @@
+"""Converter from CHANGELOG.md (Markdown) to HTML suitable for a mypy blog post.
+
+How to use:
+
+1. Write release notes in CHANGELOG.md.
+2. Make sure the heading for the next release is of form `## Mypy X.Y`.
+2. Run `misc/gen_blog_post_html.py X.Y > target.html`.
+4. Manually inspect and tweak the result.
+
+Notes:
+
+* There are some fragile assumptions. Double check the output.
+"""
+
+import argparse
+import html
+import os
+import re
+import sys
+
+
+def format_lists(h: str) -> str:
+    a = h.splitlines()
+    r = []
+    i = 0
+    bullets = ("- ", "* ", " * ")
+    while i < len(a):
+        if a[i].startswith(bullets):
+            r.append("<p><ul>")
+            while i < len(a) and a[i].startswith(bullets):
+                r.append("<li>%s" % a[i][2:].lstrip())
+                i += 1
+            r.append("</ul>")
+        else:
+            r.append(a[i])
+            i += 1
+    return "\n".join(r)
+
+
+def format_code(h: str) -> str:
+    a = h.splitlines()
+    r = []
+    i = 0
+    while i < len(a):
+        if a[i].startswith("    ") or a[i].startswith("```"):
+            indent = a[i].startswith("    ")
+            language: str = ""
+            if not indent:
+                language = a[i][3:]
+                i += 1
+            if language:
+                r.append(f'<pre><code class="language-{language}">')
+            else:
+                r.append("<pre><code>")
+            while i < len(a) and (
+                (indent and a[i].startswith("    ")) or (not indent and not a[i].startswith("```"))
+            ):
+                # Undo &gt; and &lt;
+                line = a[i].replace("&gt;", ">").replace("&lt;", "<")
+                if indent:
+                    # Undo this extra level of indentation so it looks nice with
+                    # syntax highlighting CSS.
+                    line = line[4:]
+                r.append(html.escape(line))
+                i += 1
+            r.append("</code></pre>")
+            if not indent and a[i].startswith("```"):
+                i += 1
+        else:
+            r.append(a[i])
+            i += 1
+    formatted = "\n".join(r)
+    # remove empty first line for code blocks
+    return re.sub(r"<code([^\>]*)>\n", r"<code\1>", formatted)
+
+
+def convert(src: str) -> str:
+    h = src
+
+    # Replace < and >.
+    h = re.sub(r"<", "&lt;", h)
+    h = re.sub(r">", "&gt;", h)
+
+    # Title
+    h = re.sub(r"^## (Mypy [0-9.]+)", r"<h1>\1 Released</h1>", h, flags=re.MULTILINE)
+
+    # Subheadings
+    h = re.sub(r"\n### ([A-Z`].*)\n", r"\n<h2>\1</h2>\n", h)
+
+    # Sub-subheadings
+    h = re.sub(r"\n\*\*([A-Z_`].*)\*\*\n", r"\n<h3>\1</h3>\n", h)
+    h = re.sub(r"\n`\*\*([A-Z_`].*)\*\*\n", r"\n<h3>`\1</h3>\n", h)
+
+    # Translate `**`
+    h = re.sub(r"`\*\*`", "<tt>**</tt>", h)
+
+    # Paragraphs
+    h = re.sub(r"\n\n([A-Z])", r"\n\n<p>\1", h)
+
+    # Bullet lists
+    h = format_lists(h)
+
+    # Code blocks
+    h = format_code(h)
+
+    # Code fragments
+    h = re.sub(r"``([^`]+)``", r"<tt>\1</tt>", h)
+    h = re.sub(r"`([^`]+)`", r"<tt>\1</tt>", h)
+
+    # Remove **** noise
+    h = re.sub(r"\*\*\*\*", "", h)
+
+    # Bold text
+    h = re.sub(r"\*\*([A-Za-z].*?)\*\*", r" <b>\1</b>", h)
+
+    # Emphasized text
+    h = re.sub(r" \*([A-Za-z].*?)\*", r" <i>\1</i>", h)
+
+    # Remove redundant PR links to avoid double links (they will be generated below)
+    h = re.sub(r"\[(#[0-9]+)\]\(https://github.com/python/mypy/pull/[0-9]+/?\)", r"\1", h)
+
+    # Issue and PR links
+    h = re.sub(r"\((#[0-9]+)\) +\(([^)]+)\)", r"(\2, \1)", h)
+    h = re.sub(
+        r"fixes #([0-9]+)",
+        r'fixes issue <a href="https://github.com/python/mypy/issues/\1">\1</a>',
+        h,
+    )
+    # Note the leading space to avoid stomping on strings that contain #\d in the middle (such as
+    # links to PRs in other repos)
+    h = re.sub(r" #([0-9]+)", r' PR <a href="https://github.com/python/mypy/pull/\1">\1</a>', h)
+    h = re.sub(r"\) \(PR", ", PR", h)
+
+    # Markdown links
+    h = re.sub(r"\[([^]]*)\]\(([^)]*)\)", r'<a href="\2">\1</a>', h)
+
+    # Add random links in case they are missing
+    h = re.sub(
+        r"contributors to typeshed:",
+        'contributors to <a href="https://github.com/python/typeshed">typeshed</a>:',
+        h,
+    )
+
+    # Add top-level HTML tags and headers for syntax highlighting css/js.
+    # We're configuring hljs to highlight python and bash code. We can remove
+    # this configure call to make it try all the languages it supports.
+    h = f"""<html>
+<meta charset="utf-8" />
+<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/styles/a11y-light.min.css">
+<script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/highlight.min.js"></script>
+<script>hljs.configure({{languages:["python","bash"]}});hljs.highlightAll();</script>
+<body>
+{h}
+</body>
+</html>"""
+
+    return h
+
+
+def extract_version(src: str, version: str) -> str:
+    a = src.splitlines()
+    i = 0
+    heading = f"## Mypy {version}"
+    while i < len(a):
+        if a[i].strip() == heading:
+            break
+        i += 1
+    else:
+        raise RuntimeError(f"Can't find heading {heading!r}")
+    j = i + 1
+    while not a[j].startswith("## "):
+        j += 1
+    return "\n".join(a[i:j])
+
+
+def main() -> None:
+    parser = argparse.ArgumentParser(
+        description="Generate HTML release blog post based on CHANGELOG.md and write to stdout."
+    )
+    parser.add_argument("version", help="mypy version, in form X.Y or X.Y.Z")
+    args = parser.parse_args()
+    version: str = args.version
+    if not re.match(r"[0-9]+(\.[0-9]+)+$", version):
+        sys.exit(f"error: Version must be of form X.Y or X.Y.Z, not {version!r}")
+    changelog_path = os.path.join(os.path.dirname(__file__), os.path.pardir, "CHANGELOG.md")
+    src = open(changelog_path).read()
+    src = extract_version(src, version)
+    dst = convert(src)
+    sys.stdout.write(dst)
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/generate_changelog.py 1.16~rc0.1-1/misc/generate_changelog.py
--- 1.15.0-5/misc/generate_changelog.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/generate_changelog.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,201 @@
+"""Generate the changelog for a mypy release."""
+
+from __future__ import annotations
+
+import argparse
+import re
+import subprocess
+import sys
+from dataclasses import dataclass
+
+
+def find_all_release_branches() -> list[tuple[int, int]]:
+    result = subprocess.run(["git", "branch", "-r"], text=True, capture_output=True, check=True)
+    versions = []
+    for line in result.stdout.splitlines():
+        line = line.strip()
+        if m := re.match(r"origin/release-([0-9]+)\.([0-9]+)$", line):
+            major = int(m.group(1))
+            minor = int(m.group(2))
+            versions.append((major, minor))
+    return versions
+
+
+def git_merge_base(rev1: str, rev2: str) -> str:
+    result = subprocess.run(
+        ["git", "merge-base", rev1, rev2], text=True, capture_output=True, check=True
+    )
+    return result.stdout.strip()
+
+
+@dataclass
+class CommitInfo:
+    commit: str
+    author: str
+    title: str
+    pr_number: int | None
+
+
+def normalize_author(author: str) -> str:
+    # Some ad-hoc rules to get more consistent author names.
+    if author == "AlexWaygood":
+        return "Alex Waygood"
+    elif author == "jhance":
+        return "Jared Hance"
+    return author
+
+
+def git_commit_log(rev1: str, rev2: str) -> list[CommitInfo]:
+    result = subprocess.run(
+        ["git", "log", "--pretty=%H\t%an\t%s", f"{rev1}..{rev2}"],
+        text=True,
+        capture_output=True,
+        check=True,
+    )
+    commits = []
+    for line in result.stdout.splitlines():
+        commit, author, title = line.strip().split("\t", 2)
+        pr_number = None
+        if m := re.match(r".*\(#([0-9]+)\) *$", title):
+            pr_number = int(m.group(1))
+            title = re.sub(r" *\(#[0-9]+\) *$", "", title)
+
+        author = normalize_author(author)
+        entry = CommitInfo(commit, author, title, pr_number)
+        commits.append(entry)
+    return commits
+
+
+def filter_omitted_commits(commits: list[CommitInfo]) -> list[CommitInfo]:
+    result = []
+    for c in commits:
+        title = c.title
+        keep = True
+        if title.startswith("Sync typeshed"):
+            # Typeshed syncs aren't mentioned in release notes
+            keep = False
+        if title.startswith(
+            (
+                "Revert sum literal integer change",
+                "Remove use of LiteralString in builtins",
+                "Revert typeshed ctypes change",
+            )
+        ):
+            # These are generated by a typeshed sync.
+            keep = False
+        if re.search(r"(bump|update).*version.*\+dev", title.lower()):
+            # Version number updates aren't mentioned
+            keep = False
+        if "pre-commit autoupdate" in title:
+            keep = False
+        if title.startswith(("Update commit hashes", "Update hashes")):
+            # Internal tool change
+            keep = False
+        if keep:
+            result.append(c)
+    return result
+
+
+def normalize_title(title: str) -> str:
+    # We sometimes add a title prefix when cherry-picking commits to a
+    # release branch. Attempt to remove these prefixes so that we can
+    # match them to the corresponding master branch.
+    if m := re.match(r"\[release [0-9.]+\] *", title, flags=re.I):
+        title = title.replace(m.group(0), "")
+    return title
+
+
+def filter_out_commits_from_old_release_branch(
+    new_commits: list[CommitInfo], old_commits: list[CommitInfo]
+) -> list[CommitInfo]:
+    old_titles = {normalize_title(commit.title) for commit in old_commits}
+    result = []
+    for commit in new_commits:
+        drop = False
+        if normalize_title(commit.title) in old_titles:
+            drop = True
+        if normalize_title(f"{commit.title} (#{commit.pr_number})") in old_titles:
+            drop = True
+        if not drop:
+            result.append(commit)
+        else:
+            print(f'NOTE: Drop "{commit.title}", since it was in previous release branch')
+    return result
+
+
+def find_changes_between_releases(old_branch: str, new_branch: str) -> list[CommitInfo]:
+    merge_base = git_merge_base(old_branch, new_branch)
+    print(f"Merge base: {merge_base}")
+    new_commits = git_commit_log(merge_base, new_branch)
+    old_commits = git_commit_log(merge_base, old_branch)
+
+    # Filter out some commits that won't be mentioned in release notes.
+    new_commits = filter_omitted_commits(new_commits)
+
+    # Filter out commits cherry-picked to old branch.
+    new_commits = filter_out_commits_from_old_release_branch(new_commits, old_commits)
+
+    return new_commits
+
+
+def format_changelog_entry(c: CommitInfo) -> str:
+    """
+    s = f" * {c.commit[:9]} - {c.title}"
+    if c.pr_number:
+        s += f" (#{c.pr_number})"
+    s += f" ({c.author})"
+    """
+    title = c.title.removesuffix(".")
+    s = f" * {title} ({c.author}"
+    if c.pr_number:
+        s += f", PR [{c.pr_number}](https://github.com/python/mypy/pull/{c.pr_number})"
+    s += ")"
+
+    return s
+
+
+def main() -> None:
+    parser = argparse.ArgumentParser()
+    parser.add_argument("version", help="target mypy version (form X.Y)")
+    parser.add_argument("--local", action="store_true")
+    args = parser.parse_args()
+    version: str = args.version
+    local: bool = args.local
+
+    if not re.match(r"[0-9]+\.[0-9]+$", version):
+        sys.exit(f"error: Release must be of form X.Y (not {version!r})")
+    major, minor = (int(component) for component in version.split("."))
+
+    if not local:
+        print("Running 'git fetch' to fetch all release branches...")
+        subprocess.run(["git", "fetch"], check=True)
+
+    if minor > 0:
+        prev_major = major
+        prev_minor = minor - 1
+    else:
+        # For a x.0 release, the previous release is the most recent (x-1).y release.
+        all_releases = sorted(find_all_release_branches())
+        if (major, minor) not in all_releases:
+            sys.exit(f"error: Can't find release branch for {major}.{minor} at origin")
+        for i in reversed(range(len(all_releases))):
+            if all_releases[i][0] == major - 1:
+                prev_major, prev_minor = all_releases[i]
+                break
+        else:
+            sys.exit("error: Could not determine previous release")
+    print(f"Generating changelog for {major}.{minor}")
+    print(f"Previous release was     {prev_major}.{prev_minor}")
+
+    new_branch = f"origin/release-{major}.{minor}"
+    old_branch = f"origin/release-{prev_major}.{prev_minor}"
+
+    changes = find_changes_between_releases(old_branch, new_branch)
+
+    print()
+    for c in changes:
+        print(format_changelog_entry(c))
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/incremental_checker.py 1.16~rc0.1-1/misc/incremental_checker.py
--- 1.15.0-5/misc/incremental_checker.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/incremental_checker.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,507 @@
+#!/usr/bin/env python3
+"""
+This file compares the output and runtime of running normal vs incremental mode
+on the history of any arbitrary git repo as a way of performing a sanity check
+to make sure incremental mode is working correctly and efficiently.
+
+It does so by first running mypy without incremental mode on the specified range
+of commits to find the expected result, then rewinds back to the first commit and
+re-runs mypy on the commits with incremental mode enabled to make sure it returns
+the same results.
+
+This script will download and test the official mypy repo by default. Running:
+
+    python3 misc/incremental_checker.py last 30
+
+is equivalent to running
+
+    python3 misc/incremental_checker.py last 30 \\
+            --repo_url https://github.com/python/mypy.git \\
+            --file-path mypy
+
+You can chose to run this script against a specific commit id or against the
+last n commits.
+
+To run this script against the last 30 commits:
+
+    python3 misc/incremental_checker.py last 30
+
+To run this script starting from the commit id 2a432b:
+
+    python3 misc/incremental_checker.py commit 2a432b
+"""
+
+from __future__ import annotations
+
+import base64
+import json
+import os
+import random
+import re
+import shutil
+import subprocess
+import sys
+import textwrap
+import time
+from argparse import ArgumentParser, Namespace, RawDescriptionHelpFormatter
+from typing import Any, Final
+from typing_extensions import TypeAlias as _TypeAlias
+
+CACHE_PATH: Final = ".incremental_checker_cache.json"
+MYPY_REPO_URL: Final = "https://github.com/python/mypy.git"
+MYPY_TARGET_FILE: Final = "mypy"
+DAEMON_CMD: Final = ["python3", "-m", "mypy.dmypy"]
+
+JsonDict: _TypeAlias = dict[str, Any]
+
+
+def print_offset(text: str, indent_length: int = 4) -> None:
+    print()
+    print(textwrap.indent(text, " " * indent_length))
+    print()
+
+
+def delete_folder(folder_path: str) -> None:
+    if os.path.exists(folder_path):
+        shutil.rmtree(folder_path)
+
+
+def execute(command: list[str], fail_on_error: bool = True) -> tuple[str, str, int]:
+    proc = subprocess.Popen(
+        " ".join(command), stderr=subprocess.PIPE, stdout=subprocess.PIPE, shell=True
+    )
+    stdout_bytes, stderr_bytes = proc.communicate()
+    stdout, stderr = stdout_bytes.decode("utf-8"), stderr_bytes.decode("utf-8")
+    if fail_on_error and proc.returncode != 0:
+        print("EXECUTED COMMAND:", repr(command))
+        print("RETURN CODE:", proc.returncode)
+        print()
+        print("STDOUT:")
+        print_offset(stdout)
+        print("STDERR:")
+        print_offset(stderr)
+        raise RuntimeError("Unexpected error from external tool.")
+    return stdout, stderr, proc.returncode
+
+
+def ensure_environment_is_ready(mypy_path: str, temp_repo_path: str, mypy_cache_path: str) -> None:
+    os.chdir(mypy_path)
+    delete_folder(temp_repo_path)
+    delete_folder(mypy_cache_path)
+
+
+def initialize_repo(repo_url: str, temp_repo_path: str, branch: str) -> None:
+    print(f"Cloning repo {repo_url} to {temp_repo_path}")
+    execute(["git", "clone", repo_url, temp_repo_path])
+    if branch is not None:
+        print(f"Checking out branch {branch}")
+        execute(["git", "-C", temp_repo_path, "checkout", branch])
+
+
+def get_commits(repo_folder_path: str, commit_range: str) -> list[tuple[str, str]]:
+    raw_data, _stderr, _errcode = execute(
+        ["git", "-C", repo_folder_path, "log", "--reverse", "--oneline", commit_range]
+    )
+    output = []
+    for line in raw_data.strip().split("\n"):
+        commit_id, _, message = line.partition(" ")
+        output.append((commit_id, message))
+    return output
+
+
+def get_commits_starting_at(repo_folder_path: str, start_commit: str) -> list[tuple[str, str]]:
+    print(f"Fetching commits starting at {start_commit}")
+    return get_commits(repo_folder_path, f"{start_commit}^..HEAD")
+
+
+def get_nth_commit(repo_folder_path: str, n: int) -> tuple[str, str]:
+    print(f"Fetching last {n} commits (or all, if there are fewer commits than n)")
+    return get_commits(repo_folder_path, f"-{n}")[0]
+
+
+def run_mypy(
+    target_file_path: str | None,
+    mypy_cache_path: str,
+    mypy_script: str | None,
+    *,
+    incremental: bool = False,
+    daemon: bool = False,
+    verbose: bool = False,
+) -> tuple[float, str, dict[str, Any]]:
+    """Runs mypy against `target_file_path` and returns what mypy prints to stdout as a string.
+
+    If `incremental` is set to True, this function will use store and retrieve all caching data
+    inside `mypy_cache_path`. If `verbose` is set to True, this function will pass the "-v -v"
+    flags to mypy to make it output debugging information.
+
+    If `daemon` is True, we use daemon mode; the daemon must be started and stopped by the caller.
+    """
+    stats: dict[str, Any] = {}
+    if daemon:
+        command = DAEMON_CMD + ["check", "-v"]
+    else:
+        if mypy_script is None:
+            command = ["python3", "-m", "mypy"]
+        else:
+            command = [mypy_script]
+        command.extend(["--cache-dir", mypy_cache_path])
+        if incremental:
+            command.append("--incremental")
+        if verbose:
+            command.extend(["-v", "-v"])
+    if target_file_path is not None:
+        command.append(target_file_path)
+    start = time.time()
+    output, stderr, _ = execute(command, False)
+    if stderr != "":
+        output = stderr
+    else:
+        if daemon:
+            output, stats = filter_daemon_stats(output)
+    runtime = time.time() - start
+    return runtime, output, stats
+
+
+def filter_daemon_stats(output: str) -> tuple[str, dict[str, Any]]:
+    stats: dict[str, Any] = {}
+    lines = output.splitlines()
+    output_lines = []
+    for line in lines:
+        m = re.match(r"(\w+)\s+:\s+(.*)", line)
+        if m:
+            key, value = m.groups()
+            stats[key] = value
+        else:
+            output_lines.append(line)
+    if output_lines:
+        output_lines.append("\n")
+    return "\n".join(output_lines), stats
+
+
+def start_daemon(mypy_cache_path: str) -> None:
+    cmd = DAEMON_CMD + [
+        "restart",
+        "--log-file",
+        "./@incr-chk-logs",
+        "--",
+        "--cache-dir",
+        mypy_cache_path,
+    ]
+    execute(cmd)
+
+
+def stop_daemon() -> None:
+    execute(DAEMON_CMD + ["stop"])
+
+
+def load_cache(incremental_cache_path: str = CACHE_PATH) -> JsonDict:
+    if os.path.exists(incremental_cache_path):
+        with open(incremental_cache_path) as stream:
+            cache = json.load(stream)
+            assert isinstance(cache, dict)
+            return cache
+    else:
+        return {}
+
+
+def save_cache(cache: JsonDict, incremental_cache_path: str = CACHE_PATH) -> None:
+    with open(incremental_cache_path, "w") as stream:
+        json.dump(cache, stream, indent=2)
+
+
+def set_expected(
+    commits: list[tuple[str, str]],
+    cache: JsonDict,
+    temp_repo_path: str,
+    target_file_path: str | None,
+    mypy_cache_path: str,
+    mypy_script: str | None,
+) -> None:
+    """Populates the given `cache` with the expected results for all of the given `commits`.
+
+    This function runs mypy on the `target_file_path` inside the `temp_repo_path`, and stores
+    the result in the `cache`.
+
+    If `cache` already contains results for a particular commit, this function will
+    skip evaluating that commit and move on to the next."""
+    for commit_id, message in commits:
+        if commit_id in cache:
+            print(f'Skipping commit (already cached): {commit_id}: "{message}"')
+        else:
+            print(f'Caching expected output for commit {commit_id}: "{message}"')
+            execute(["git", "-C", temp_repo_path, "checkout", commit_id])
+            runtime, output, stats = run_mypy(
+                target_file_path, mypy_cache_path, mypy_script, incremental=False
+            )
+            cache[commit_id] = {"runtime": runtime, "output": output}
+            if output == "":
+                print(f"    Clean output ({runtime:.3f} sec)")
+            else:
+                print(f"    Output ({runtime:.3f} sec)")
+                print_offset(output, 8)
+    print()
+
+
+def test_incremental(
+    commits: list[tuple[str, str]],
+    cache: JsonDict,
+    temp_repo_path: str,
+    target_file_path: str | None,
+    mypy_cache_path: str,
+    *,
+    mypy_script: str | None = None,
+    daemon: bool = False,
+    exit_on_error: bool = False,
+) -> None:
+    """Runs incremental mode on all `commits` to verify the output matches the expected output.
+
+    This function runs mypy on the `target_file_path` inside the `temp_repo_path`. The
+    expected output must be stored inside of the given `cache`.
+    """
+    print("Note: first commit is evaluated twice to warm up cache")
+    commits = [commits[0]] + commits
+    overall_stats: dict[str, float] = {}
+    for commit_id, message in commits:
+        print(f'Now testing commit {commit_id}: "{message}"')
+        execute(["git", "-C", temp_repo_path, "checkout", commit_id])
+        runtime, output, stats = run_mypy(
+            target_file_path, mypy_cache_path, mypy_script, incremental=True, daemon=daemon
+        )
+        relevant_stats = combine_stats(overall_stats, stats)
+        expected_runtime: float = cache[commit_id]["runtime"]
+        expected_output: str = cache[commit_id]["output"]
+        if output != expected_output:
+            print("    Output does not match expected result!")
+            print(f"    Expected output ({expected_runtime:.3f} sec):")
+            print_offset(expected_output, 8)
+            print(f"    Actual output: ({runtime:.3f} sec):")
+            print_offset(output, 8)
+            if exit_on_error:
+                break
+        else:
+            print("    Output matches expected result!")
+            print(f"    Incremental: {runtime:.3f} sec")
+            print(f"    Original:    {expected_runtime:.3f} sec")
+            if relevant_stats:
+                print(f"    Stats:       {relevant_stats}")
+    if overall_stats:
+        print("Overall stats:", overall_stats)
+
+
+def combine_stats(overall_stats: dict[str, float], new_stats: dict[str, Any]) -> dict[str, float]:
+    INTERESTING_KEYS = ["build_time", "gc_time"]
+    # For now, we only support float keys
+    relevant_stats: dict[str, float] = {}
+    for key in INTERESTING_KEYS:
+        if key in new_stats:
+            value = float(new_stats[key])
+            relevant_stats[key] = value
+            overall_stats[key] = overall_stats.get(key, 0.0) + value
+    return relevant_stats
+
+
+def cleanup(temp_repo_path: str, mypy_cache_path: str) -> None:
+    delete_folder(temp_repo_path)
+    delete_folder(mypy_cache_path)
+
+
+def test_repo(
+    target_repo_url: str,
+    temp_repo_path: str,
+    target_file_path: str | None,
+    mypy_path: str,
+    incremental_cache_path: str,
+    mypy_cache_path: str,
+    range_type: str,
+    range_start: str,
+    branch: str,
+    params: Namespace,
+) -> None:
+    """Tests incremental mode against the repo specified in `target_repo_url`.
+
+    This algorithm runs in five main stages:
+
+    1.  Clones `target_repo_url` into the `temp_repo_path` folder locally,
+        checking out the specified `branch` if applicable.
+    2.  Examines the repo's history to get the list of all commits to
+        to test incremental mode on.
+    3.  Runs mypy WITHOUT incremental mode against the `target_file_path` (which is
+        assumed to be located inside the `temp_repo_path`), testing each commit
+        discovered in stage two.
+        -   If the results of running mypy WITHOUT incremental mode on a
+            particular commit are already cached inside the `incremental_cache_path`,
+            skip that commit to save time.
+        -   Cache the results after finishing.
+    4.  Rewind back to the first commit, and run mypy WITH incremental mode
+        against the `target_file_path` commit-by-commit, and compare to the expected
+        results found in stage 3.
+    5.  Delete all unnecessary temp files.
+    """
+    # Stage 1: Clone repo and get ready to being testing
+    ensure_environment_is_ready(mypy_path, temp_repo_path, mypy_cache_path)
+    initialize_repo(target_repo_url, temp_repo_path, branch)
+
+    # Stage 2: Get all commits we want to test
+    if range_type == "last":
+        start_commit = get_nth_commit(temp_repo_path, int(range_start))[0]
+    elif range_type == "commit":
+        start_commit = range_start
+    else:
+        raise RuntimeError(f"Invalid option: {range_type}")
+    commits = get_commits_starting_at(temp_repo_path, start_commit)
+    if params.limit:
+        commits = commits[: params.limit]
+    if params.sample:
+        seed = params.seed or base64.urlsafe_b64encode(os.urandom(15)).decode("ascii")
+        random.seed(seed)
+        commits = random.sample(commits, params.sample)
+        print("Sampled down to %d commits using random seed %s" % (len(commits), seed))
+
+    # Stage 3: Find and cache expected results for each commit (without incremental mode)
+    cache = load_cache(incremental_cache_path)
+    set_expected(
+        commits,
+        cache,
+        temp_repo_path,
+        target_file_path,
+        mypy_cache_path,
+        mypy_script=params.mypy_script,
+    )
+    save_cache(cache, incremental_cache_path)
+
+    # Stage 4: Rewind and re-run mypy (with incremental mode enabled)
+    if params.daemon:
+        print("Starting daemon")
+        start_daemon(mypy_cache_path)
+    test_incremental(
+        commits,
+        cache,
+        temp_repo_path,
+        target_file_path,
+        mypy_cache_path,
+        mypy_script=params.mypy_script,
+        daemon=params.daemon,
+        exit_on_error=params.exit_on_error,
+    )
+
+    # Stage 5: Remove temp files, stop daemon
+    if not params.keep_temporary_files:
+        cleanup(temp_repo_path, mypy_cache_path)
+    if params.daemon:
+        print("Stopping daemon")
+        stop_daemon()
+
+
+def main() -> None:
+    help_factory: Any = lambda prog: RawDescriptionHelpFormatter(prog=prog, max_help_position=32)
+    parser = ArgumentParser(
+        prog="incremental_checker", description=__doc__, formatter_class=help_factory
+    )
+
+    parser.add_argument(
+        "range_type",
+        metavar="START_TYPE",
+        choices=["last", "commit"],
+        help="must be one of 'last' or 'commit'",
+    )
+    parser.add_argument(
+        "range_start",
+        metavar="COMMIT_ID_OR_NUMBER",
+        help="the commit id to start from, or the number of commits to move back (see above)",
+    )
+    parser.add_argument(
+        "-r",
+        "--repo_url",
+        default=MYPY_REPO_URL,
+        metavar="URL",
+        help="the repo to clone and run tests on",
+    )
+    parser.add_argument(
+        "-f",
+        "--file-path",
+        default=MYPY_TARGET_FILE,
+        metavar="FILE",
+        help="the name of the file or directory to typecheck",
+    )
+    parser.add_argument(
+        "-x", "--exit-on-error", action="store_true", help="Exits as soon as an error occurs"
+    )
+    parser.add_argument(
+        "--keep-temporary-files", action="store_true", help="Keep temporary files on exit"
+    )
+    parser.add_argument(
+        "--cache-path",
+        default=CACHE_PATH,
+        metavar="DIR",
+        help="sets a custom location to store cache data",
+    )
+    parser.add_argument(
+        "--branch",
+        default=None,
+        metavar="NAME",
+        help="check out and test a custom branch uses the default if not specified",
+    )
+    parser.add_argument("--sample", type=int, help="use a random sample of size SAMPLE")
+    parser.add_argument("--seed", type=str, help="random seed")
+    parser.add_argument(
+        "--limit", type=int, help="maximum number of commits to use (default until end)"
+    )
+    parser.add_argument("--mypy-script", type=str, help="alternate mypy script to run")
+    parser.add_argument(
+        "--daemon",
+        action="store_true",
+        help="use mypy daemon instead of incremental (highly experimental)",
+    )
+
+    if len(sys.argv[1:]) == 0:
+        parser.print_help()
+        parser.exit()
+
+    params = parser.parse_args(sys.argv[1:])
+
+    # Make all paths absolute so we avoid having to worry about being in the right folder
+
+    # The path to this specific script (incremental_checker.py).
+    script_path = os.path.abspath(sys.argv[0])
+
+    # The path to the mypy repo.
+    mypy_path = os.path.abspath(os.path.dirname(os.path.dirname(script_path)))
+
+    # The folder the cloned repo will reside in.
+    temp_repo_path = os.path.abspath(os.path.join(mypy_path, "tmp_repo"))
+
+    # The particular file or package to typecheck inside the repo.
+    if params.file_path:
+        target_file_path = os.path.abspath(os.path.join(temp_repo_path, params.file_path))
+    else:
+        # Allow `-f ''` to clear target_file_path.
+        target_file_path = None
+
+    # The path to where the incremental checker cache data is stored.
+    incremental_cache_path = os.path.abspath(params.cache_path)
+
+    # The path to store the mypy incremental mode cache data
+    mypy_cache_path = os.path.abspath(os.path.join(mypy_path, "misc", ".mypy_cache"))
+
+    print(f"Assuming mypy is located at {mypy_path}")
+    print(f"Temp repo will be cloned at {temp_repo_path}")
+    print(f"Testing file/dir located at {target_file_path}")
+    print(f"Using cache data located at {incremental_cache_path}")
+    print()
+
+    test_repo(
+        params.repo_url,
+        temp_repo_path,
+        target_file_path,
+        mypy_path,
+        incremental_cache_path,
+        mypy_cache_path,
+        params.range_type,
+        params.range_start,
+        params.branch,
+        params,
+    )
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/macs.el 1.16~rc0.1-1/misc/macs.el
--- 1.15.0-5/misc/macs.el	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/macs.el	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,22 @@
+; Example Emacs integration; shows type of expression in region.
+
+(defun mypy-show-region ()
+  "Show type of variable at point."
+  (interactive)
+  (let ((here (region-beginning))
+        (there (region-end))
+        (filename (buffer-file-name)))
+    (let ((hereline (line-number-at-pos here))
+          (herecol (save-excursion (goto-char here) (current-column)))
+          (thereline (line-number-at-pos there))
+          (therecol (save-excursion (goto-char there) (current-column))))
+      (shell-command
+       (format "cd ~/src/mypy; python3 ./misc/find_type.py %s %s %s %s %s python3 -m mypy -i mypy"
+               filename hereline herecol thereline therecol)
+       )
+      )
+    )
+  )
+
+; I like to bind this to ^X-t.
+(global-set-key "\C-xt" 'mypy-show-region)
diff -pruN 1.15.0-5/misc/perf_checker.py 1.16~rc0.1-1/misc/perf_checker.py
--- 1.15.0-5/misc/perf_checker.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/perf_checker.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,95 @@
+#!/usr/bin/env python3
+
+from __future__ import annotations
+
+import os
+import shutil
+import statistics
+import subprocess
+import textwrap
+import time
+from typing import Callable
+
+
+class Command:
+    def __init__(self, setup: Callable[[], None], command: Callable[[], None]) -> None:
+        self.setup = setup
+        self.command = command
+
+
+def print_offset(text: str, indent_length: int = 4) -> None:
+    print()
+    print(textwrap.indent(text, " " * indent_length))
+    print()
+
+
+def delete_folder(folder_path: str) -> None:
+    if os.path.exists(folder_path):
+        shutil.rmtree(folder_path)
+
+
+def execute(command: list[str]) -> None:
+    proc = subprocess.Popen(
+        " ".join(command), stderr=subprocess.PIPE, stdout=subprocess.PIPE, shell=True
+    )
+    stdout_bytes, stderr_bytes = proc.communicate()
+    stdout, stderr = stdout_bytes.decode("utf-8"), stderr_bytes.decode("utf-8")
+    if proc.returncode != 0:
+        print("EXECUTED COMMAND:", repr(command))
+        print("RETURN CODE:", proc.returncode)
+        print()
+        print("STDOUT:")
+        print_offset(stdout)
+        print("STDERR:")
+        print_offset(stderr)
+        raise RuntimeError("Unexpected error from external tool.")
+
+
+def trial(num_trials: int, command: Command) -> list[float]:
+    trials = []
+    for i in range(num_trials):
+        command.setup()
+        start = time.time()
+        command.command()
+        delta = time.time() - start
+        trials.append(delta)
+    return trials
+
+
+def report(name: str, times: list[float]) -> None:
+    print(f"{name}:")
+    print(f"  Times: {times}")
+    print(f"  Mean:  {statistics.mean(times)}")
+    print(f"  Stdev: {statistics.stdev(times)}")
+    print()
+
+
+def main() -> None:
+    trials = 3
+
+    print("Testing baseline")
+    baseline = trial(
+        trials, Command(lambda: None, lambda: execute(["python3", "-m", "mypy", "mypy"]))
+    )
+    report("Baseline", baseline)
+
+    print("Testing cold cache")
+    cold_cache = trial(
+        trials,
+        Command(
+            lambda: delete_folder(".mypy_cache"),
+            lambda: execute(["python3", "-m", "mypy", "-i", "mypy"]),
+        ),
+    )
+    report("Cold cache", cold_cache)
+
+    print("Testing warm cache")
+    execute(["python3", "-m", "mypy", "-i", "mypy"])
+    warm_cache = trial(
+        trials, Command(lambda: None, lambda: execute(["python3", "-m", "mypy", "-i", "mypy"]))
+    )
+    report("Warm cache", warm_cache)
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/perf_compare.py 1.16~rc0.1-1/misc/perf_compare.py
--- 1.15.0-5/misc/perf_compare.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/perf_compare.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,249 @@
+"""Compare performance of mypyc-compiled mypy between one or more commits/branches.
+
+Simple usage:
+
+  python misc/perf_compare.py master my-branch ...
+
+What this does:
+
+ * Create a temp clone of the mypy repo for each target commit to measure
+ * Checkout a target commit in each of the clones
+ * Compile mypyc in each of the clones *in parallel*
+ * Create another temp clone of the first provided revision (or, with -r, a foreign repo) as the code to check
+ * Self check with each of the compiled mypys N times
+ * Report the average runtimes and relative performance
+ * Remove the temp clones
+"""
+
+from __future__ import annotations
+
+import argparse
+import glob
+import os
+import random
+import shutil
+import statistics
+import subprocess
+import sys
+import time
+from concurrent.futures import ThreadPoolExecutor, as_completed
+
+
+def heading(s: str) -> None:
+    print()
+    print(f"=== {s} ===")
+    print()
+
+
+def build_mypy(target_dir: str) -> None:
+    env = os.environ.copy()
+    env["CC"] = "clang"
+    env["MYPYC_OPT_LEVEL"] = "2"
+    env["PYTHONHASHSEED"] = "1"
+    cmd = [sys.executable, "setup.py", "--use-mypyc", "build_ext", "--inplace"]
+    subprocess.run(cmd, env=env, check=True, cwd=target_dir)
+
+
+def clone(target_dir: str, commit: str | None, repo_source: str | None = None) -> None:
+    source_name = repo_source or "mypy"
+    heading(f"Cloning {source_name} to {target_dir}")
+    if repo_source is None:
+        repo_source = os.getcwd()
+    if os.path.isdir(target_dir):
+        print(f"{target_dir} exists: deleting")
+        shutil.rmtree(target_dir)
+    subprocess.run(["git", "clone", repo_source, target_dir], check=True)
+    if commit:
+        subprocess.run(["git", "checkout", commit], check=True, cwd=target_dir)
+
+
+def edit_python_file(fnam: str) -> None:
+    with open(fnam) as f:
+        data = f.read()
+    data += "\n#"
+    with open(fnam, "w") as f:
+        f.write(data)
+
+
+def run_benchmark(
+    compiled_dir: str, check_dir: str, *, incremental: bool, code: str | None, foreign: bool | None
+) -> float:
+    cache_dir = os.path.join(compiled_dir, ".mypy_cache")
+    if os.path.isdir(cache_dir) and not incremental:
+        shutil.rmtree(cache_dir)
+    env = os.environ.copy()
+    env["PYTHONPATH"] = os.path.abspath(compiled_dir)
+    env["PYTHONHASHSEED"] = "1"
+    abschk = os.path.abspath(check_dir)
+    cmd = [sys.executable, "-m", "mypy"]
+    if code:
+        cmd += ["-c", code]
+    elif foreign:
+        pass
+    else:
+        cmd += ["--config-file", os.path.join(abschk, "mypy_self_check.ini")]
+        cmd += glob.glob(os.path.join(abschk, "mypy/*.py"))
+        cmd += glob.glob(os.path.join(abschk, "mypy/*/*.py"))
+        if incremental:
+            # Update a few files to force non-trivial incremental run
+            edit_python_file(os.path.join(abschk, "mypy/__main__.py"))
+            edit_python_file(os.path.join(abschk, "mypy/test/testcheck.py"))
+    t0 = time.time()
+    # Ignore errors, since some commits being measured may generate additional errors.
+    if foreign:
+        subprocess.run(cmd, cwd=check_dir, env=env)
+    else:
+        subprocess.run(cmd, cwd=compiled_dir, env=env)
+    return time.time() - t0
+
+
+def main() -> None:
+    whole_program_time_0 = time.time()
+    parser = argparse.ArgumentParser(
+        formatter_class=argparse.RawDescriptionHelpFormatter,
+        description=__doc__,
+        epilog="Remember: you usually want the first argument to this command to be 'master'.",
+    )
+    parser.add_argument(
+        "--incremental",
+        default=False,
+        action="store_true",
+        help="measure incremental run (fully cached)",
+    )
+    parser.add_argument(
+        "--dont-setup",
+        default=False,
+        action="store_true",
+        help="don't make the clones or compile mypy, just run the performance measurement benchmark "
+        + "(this will fail unless the clones already exist, such as from a previous run that was canceled before it deleted them)",
+    )
+    parser.add_argument(
+        "--num-runs",
+        metavar="N",
+        default=15,
+        type=int,
+        help="set number of measurements to perform (default=15)",
+    )
+    parser.add_argument(
+        "-j",
+        metavar="N",
+        default=8,
+        type=int,
+        help="set maximum number of parallel builds (default=8)",
+    )
+    parser.add_argument(
+        "-r",
+        metavar="FOREIGN_REPOSITORY",
+        default=None,
+        type=str,
+        help="measure time to typecheck the project at FOREIGN_REPOSITORY instead of mypy self-check; "
+        + "the provided value must be the URL or path of a git repo "
+        + "(note that this script will take no special steps to *install* the foreign repo, so you will probably get a lot of missing import errors)",
+    )
+    parser.add_argument(
+        "-c",
+        metavar="CODE",
+        default=None,
+        type=str,
+        help="measure time to type check Python code fragment instead of mypy self-check",
+    )
+    parser.add_argument(
+        "commit",
+        nargs="+",
+        help="git revision(s), e.g. branch name or commit id, to measure the performance of",
+    )
+    args = parser.parse_args()
+    incremental: bool = args.incremental
+    dont_setup: bool = args.dont_setup
+    commits = args.commit
+    num_runs: int = args.num_runs + 1
+    max_workers: int = args.j
+    code: str | None = args.c
+    foreign_repo: str | None = args.r
+
+    if not (os.path.isdir(".git") and os.path.isdir("mypyc")):
+        sys.exit("error: You must run this script from the mypy repo root")
+
+    target_dirs = []
+    for i, commit in enumerate(commits):
+        target_dir = f"mypy.{i}.tmpdir"
+        target_dirs.append(target_dir)
+        if not dont_setup:
+            clone(target_dir, commit)
+
+    if foreign_repo:
+        check_dir = "mypy.foreign.tmpdir"
+        if not dont_setup:
+            clone(check_dir, None, foreign_repo)
+    else:
+        check_dir = "mypy.self.tmpdir"
+        if not dont_setup:
+            clone(check_dir, commits[0])
+
+    if not dont_setup:
+        heading("Compiling mypy")
+        print("(This will take a while...)")
+
+        with ThreadPoolExecutor(max_workers=max_workers) as executor:
+            futures = [executor.submit(build_mypy, target_dir) for target_dir in target_dirs]
+            for future in as_completed(futures):
+                future.result()
+
+        print(f"Finished compiling mypy ({len(commits)} builds)")
+
+    heading("Performing measurements")
+
+    results: dict[str, list[float]] = {}
+    for n in range(num_runs):
+        if n == 0:
+            print("Warmup...")
+        else:
+            print(f"Run {n}/{num_runs - 1}...")
+        items = list(enumerate(commits))
+        random.shuffle(items)
+        for i, commit in items:
+            tt = run_benchmark(
+                target_dirs[i],
+                check_dir,
+                incremental=incremental,
+                code=code,
+                foreign=bool(foreign_repo),
+            )
+            # Don't record the first warm-up run
+            if n > 0:
+                print(f"{commit}: t={tt:.3f}s")
+                results.setdefault(commit, []).append(tt)
+
+    print()
+    heading("Results")
+    first = -1.0
+    for commit in commits:
+        tt = statistics.mean(results[commit])
+        # pstdev (instead of stdev) is used here primarily to accommodate the case where num_runs=1
+        s = statistics.pstdev(results[commit]) if len(results[commit]) > 1 else 0
+        if first < 0:
+            delta = "0.0%"
+            first = tt
+        else:
+            d = (tt / first) - 1
+            delta = f"{d:+.1%}"
+        print(f"{commit:<25} {tt:.3f}s ({delta}) | stdev {s:.3f}s ")
+
+    t = int(time.time() - whole_program_time_0)
+    total_time_taken_formatted = ", ".join(
+        f"{v} {n if v==1 else n+'s'}"
+        for v, n in ((t // 3600, "hour"), (t // 60 % 60, "minute"), (t % 60, "second"))
+        if v
+    )
+    print(
+        "Total time taken by the whole benchmarking program (including any setup):",
+        total_time_taken_formatted,
+    )
+
+    shutil.rmtree(check_dir)
+    for target_dir in target_dirs:
+        shutil.rmtree(target_dir)
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/sync-typeshed.py 1.16~rc0.1-1/misc/sync-typeshed.py
--- 1.15.0-5/misc/sync-typeshed.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/sync-typeshed.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,228 @@
+"""Sync stdlib stubs (and a few other files) from typeshed.
+
+Usage:
+
+  python3 misc/sync-typeshed.py [--commit hash] [--typeshed-dir dir]
+
+By default, sync to the latest typeshed commit.
+"""
+
+from __future__ import annotations
+
+import argparse
+import functools
+import glob
+import os
+import re
+import shutil
+import subprocess
+import sys
+import tempfile
+import textwrap
+from collections.abc import Mapping
+
+import requests
+
+
+def check_state() -> None:
+    if not os.path.isfile("pyproject.toml") or not os.path.isdir("mypy"):
+        sys.exit("error: The current working directory must be the mypy repository root")
+    out = subprocess.check_output(["git", "status", "-s", os.path.join("mypy", "typeshed")])
+    if out:
+        # If there are local changes under mypy/typeshed, they would be lost.
+        sys.exit('error: Output of "git status -s mypy/typeshed" must be empty')
+
+
+def update_typeshed(typeshed_dir: str, commit: str | None) -> str:
+    """Update contents of local typeshed copy.
+
+    We maintain our own separate mypy_extensions stubs, since it's
+    treated specially by mypy and we make assumptions about what's there.
+    We don't sync mypy_extensions stubs here -- this is done manually.
+
+    Return the normalized typeshed commit hash.
+    """
+    assert os.path.isdir(os.path.join(typeshed_dir, "stdlib"))
+    if commit:
+        subprocess.run(["git", "checkout", commit], check=True, cwd=typeshed_dir)
+    commit = git_head_commit(typeshed_dir)
+
+    stdlib_dir = os.path.join("mypy", "typeshed", "stdlib")
+    # Remove existing stubs.
+    shutil.rmtree(stdlib_dir)
+    # Copy new stdlib stubs.
+    shutil.copytree(
+        os.path.join(typeshed_dir, "stdlib"), stdlib_dir, ignore=shutil.ignore_patterns("@tests")
+    )
+    shutil.copy(os.path.join(typeshed_dir, "LICENSE"), os.path.join("mypy", "typeshed"))
+    return commit
+
+
+def git_head_commit(repo: str) -> str:
+    commit = subprocess.check_output(["git", "rev-parse", "HEAD"], cwd=repo).decode("ascii")
+    return commit.strip()
+
+
+@functools.cache
+def get_github_api_headers() -> Mapping[str, str]:
+    headers = {"Accept": "application/vnd.github.v3+json"}
+    secret = os.environ.get("GITHUB_TOKEN")
+    if secret is not None:
+        headers["Authorization"] = (
+            f"token {secret}" if secret.startswith("ghp") else f"Bearer {secret}"
+        )
+    return headers
+
+
+@functools.cache
+def get_origin_owner() -> str:
+    output = subprocess.check_output(["git", "remote", "get-url", "origin"], text=True).strip()
+    match = re.match(
+        r"(git@github.com:|https://github.com/)(?P<owner>[^/]+)/(?P<repo>[^/\s]+)", output
+    )
+    assert match is not None, f"Couldn't identify origin's owner: {output!r}"
+    assert (
+        match.group("repo").removesuffix(".git") == "mypy"
+    ), f'Unexpected repo: {match.group("repo")!r}'
+    return match.group("owner")
+
+
+def create_or_update_pull_request(*, title: str, body: str, branch_name: str) -> None:
+    fork_owner = get_origin_owner()
+
+    with requests.post(
+        "https://api.github.com/repos/python/mypy/pulls",
+        json={
+            "title": title,
+            "body": body,
+            "head": f"{fork_owner}:{branch_name}",
+            "base": "master",
+        },
+        headers=get_github_api_headers(),
+    ) as response:
+        resp_json = response.json()
+        if response.status_code == 422 and any(
+            "A pull request already exists" in e.get("message", "")
+            for e in resp_json.get("errors", [])
+        ):
+            # Find the existing PR
+            with requests.get(
+                "https://api.github.com/repos/python/mypy/pulls",
+                params={"state": "open", "head": f"{fork_owner}:{branch_name}", "base": "master"},
+                headers=get_github_api_headers(),
+            ) as response:
+                response.raise_for_status()
+                resp_json = response.json()
+                assert len(resp_json) >= 1
+                pr_number = resp_json[0]["number"]
+            # Update the PR's title and body
+            with requests.patch(
+                f"https://api.github.com/repos/python/mypy/pulls/{pr_number}",
+                json={"title": title, "body": body},
+                headers=get_github_api_headers(),
+            ) as response:
+                response.raise_for_status()
+            return
+        response.raise_for_status()
+
+
+def main() -> None:
+    parser = argparse.ArgumentParser()
+    parser.add_argument(
+        "--commit",
+        default=None,
+        help="Typeshed commit (default to latest main if using a repository clone)",
+    )
+    parser.add_argument(
+        "--typeshed-dir",
+        default=None,
+        help="Location of typeshed (default to a temporary repository clone)",
+    )
+    parser.add_argument(
+        "--make-pr",
+        action="store_true",
+        help="Whether to make a PR with the changes (default to no)",
+    )
+    args = parser.parse_args()
+
+    check_state()
+
+    if args.make_pr:
+        if os.environ.get("GITHUB_TOKEN") is None:
+            raise ValueError("GITHUB_TOKEN environment variable must be set")
+
+    with tempfile.TemporaryDirectory() as tmpdir:
+        # Stash patches before checking out a new branch
+        typeshed_patches = os.path.join("misc", "typeshed_patches")
+        tmp_patches = os.path.join(tmpdir, "typeshed_patches")
+        shutil.copytree(typeshed_patches, tmp_patches)
+
+        branch_name = "mypybot/sync-typeshed"
+        subprocess.run(["git", "checkout", "-B", branch_name, "origin/master"], check=True)
+
+        # Copy the stashed patches back
+        shutil.rmtree(typeshed_patches, ignore_errors=True)
+        shutil.copytree(tmp_patches, typeshed_patches)
+        if subprocess.run(["git", "diff", "--quiet", "--exit-code"], check=False).returncode != 0:
+            subprocess.run(["git", "commit", "-am", "Update typeshed patches"], check=True)
+
+        if not args.typeshed_dir:
+            tmp_typeshed = os.path.join(tmpdir, "typeshed")
+            os.makedirs(tmp_typeshed)
+            # Clone typeshed repo if no directory given.
+            print(f"Cloning typeshed in {tmp_typeshed}...")
+            subprocess.run(
+                ["git", "clone", "https://github.com/python/typeshed.git"],
+                check=True,
+                cwd=tmp_typeshed,
+            )
+            repo = os.path.join(tmp_typeshed, "typeshed")
+            commit = update_typeshed(repo, args.commit)
+        else:
+            commit = update_typeshed(args.typeshed_dir, args.commit)
+
+        assert commit
+
+        # Create a commit
+        message = textwrap.dedent(
+            f"""\
+            Sync typeshed
+
+            Source commit:
+            https://github.com/python/typeshed/commit/{commit}
+            """
+        )
+        subprocess.run(["git", "add", "--all", os.path.join("mypy", "typeshed")], check=True)
+        subprocess.run(["git", "commit", "-m", message], check=True)
+        print("Created typeshed sync commit.")
+
+        patches = sorted(glob.glob(os.path.join(typeshed_patches, "*.patch")))
+        for patch in patches:
+            cmd = ["git", "am", "--3way", patch]
+            try:
+                subprocess.run(cmd, check=True)
+            except subprocess.CalledProcessError as e:
+                raise RuntimeError(
+                    f"\n\nFailed to apply patch {patch}\n"
+                    "1. Resolve the conflict, `git add --update`, then run `git am --continue`\n"
+                    "2. Run `git format-patch -1 -o misc/typeshed_patches <new_commit_sha>` "
+                    "to update the patch file.\n"
+                    "3. Re-run sync-typeshed.py"
+                ) from e
+
+            print(f"Applied patch {patch}")
+
+    if args.make_pr:
+        subprocess.run(["git", "push", "--force", "origin", branch_name], check=True)
+        print("Pushed commit.")
+
+        warning = "Note that you will need to close and re-open the PR in order to trigger CI."
+
+        create_or_update_pull_request(
+            title="Sync typeshed", body=message + "\n" + warning, branch_name=branch_name
+        )
+        print("Created PR.")
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/test-stubgenc.sh 1.16~rc0.1-1/misc/test-stubgenc.sh
--- 1.15.0-5/misc/test-stubgenc.sh	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/test-stubgenc.sh	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,45 @@
+#!/bin/bash
+
+set -e
+set -x
+
+cd "$(dirname "$0")/.."
+
+# Install dependencies, demo project and mypy
+python -m pip install -r test-requirements.txt
+python -m pip install ./test-data/pybind11_fixtures
+python -m pip install .
+
+EXIT=0
+
+# performs the stubgenc test
+# first argument is the test result folder
+# everything else is passed to stubgen as its arguments
+function stubgenc_test() {
+    # Remove expected stubs and generate new inplace
+    STUBGEN_OUTPUT_FOLDER=./test-data/pybind11_fixtures/$1
+    rm -rf "${STUBGEN_OUTPUT_FOLDER:?}"
+
+    stubgen -o "$STUBGEN_OUTPUT_FOLDER" "${@:2}"
+
+    # Check if generated stubs can actually be type checked by mypy
+    if ! mypy "$STUBGEN_OUTPUT_FOLDER";
+    then
+        echo "Stubgen test failed, because generated stubs failed to type check."
+        EXIT=1
+    fi
+
+    # Compare generated stubs to expected ones
+    if ! git diff --exit-code "$STUBGEN_OUTPUT_FOLDER";
+    then
+        echo "Stubgen test failed, because generated stubs differ from expected outputs."
+        EXIT=1
+    fi
+}
+
+# create stubs without docstrings
+stubgenc_test expected_stubs_no_docs -p pybind11_fixtures
+# create stubs with docstrings
+stubgenc_test expected_stubs_with_docs -p pybind11_fixtures --include-docstrings
+
+exit $EXIT
diff -pruN 1.15.0-5/misc/trigger_wheel_build.sh 1.16~rc0.1-1/misc/trigger_wheel_build.sh
--- 1.15.0-5/misc/trigger_wheel_build.sh	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/trigger_wheel_build.sh	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,23 @@
+#!/bin/bash -eux
+
+# Trigger a build of mypyc compiled mypy wheels by updating the mypy
+# submodule in the git repo that drives those builds.
+
+# $WHEELS_PUSH_TOKEN is stored in GitHub Settings and is an API token
+# for the mypy-build-bot account.
+
+git config --global user.email "nobody"
+git config --global user.name "mypy wheels autopush"
+
+COMMIT=$(git rev-parse HEAD)
+pip install -r mypy-requirements.txt
+V=$(python3 -m mypy --version)
+V=$(echo "$V" | cut -d" " -f2)
+
+git clone --depth 1 https://${WHEELS_PUSH_TOKEN}@github.com/mypyc/mypy_mypyc-wheels.git build
+cd build
+echo $COMMIT > mypy_commit
+git commit -am "Build wheels for mypy $V"
+git tag v$V
+# Push a tag, but no need to push the change to master
+git push --tags
diff -pruN 1.15.0-5/misc/typeshed_patches/0001-Partially-revert-Clean-up-argparse-hacks.patch 1.16~rc0.1-1/misc/typeshed_patches/0001-Partially-revert-Clean-up-argparse-hacks.patch
--- 1.15.0-5/misc/typeshed_patches/0001-Partially-revert-Clean-up-argparse-hacks.patch	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/typeshed_patches/0001-Partially-revert-Clean-up-argparse-hacks.patch	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,45 @@
+From b5f2cc9633f9f6cd9326eee96a32efb3aff70701 Mon Sep 17 00:00:00 2001
+From: Marc Mueller <30130371+cdce8p@users.noreply.github.com>
+Date: Sat, 15 Feb 2025 20:11:06 +0100
+Subject: [PATCH] Partially revert Clean up argparse hacks
+
+---
+ mypy/typeshed/stdlib/argparse.pyi | 8 +++++---
+ 1 file changed, 5 insertions(+), 3 deletions(-)
+
+diff --git a/mypy/typeshed/stdlib/argparse.pyi b/mypy/typeshed/stdlib/argparse.pyi
+index 029bfeefe..9dbd8c308 100644
+--- a/mypy/typeshed/stdlib/argparse.pyi
++++ b/mypy/typeshed/stdlib/argparse.pyi
+@@ -2,7 +2,7 @@ import sys
+ from _typeshed import SupportsWrite, sentinel
+ from collections.abc import Callable, Generator, Iterable, Sequence
+ from re import Pattern
+-from typing import IO, Any, ClassVar, Final, Generic, NoReturn, Protocol, TypeVar, overload
++from typing import IO, Any, ClassVar, Final, Generic, NewType, NoReturn, Protocol, TypeVar, overload
+ from typing_extensions import Self, TypeAlias, deprecated
+ 
+ __all__ = [
+@@ -38,7 +38,9 @@ ONE_OR_MORE: Final = "+"
+ OPTIONAL: Final = "?"
+ PARSER: Final = "A..."
+ REMAINDER: Final = "..."
+-SUPPRESS: Final = "==SUPPRESS=="
++_SUPPRESS_T = NewType("_SUPPRESS_T", str)
++SUPPRESS: _SUPPRESS_T | str  # not using Literal because argparse sometimes compares SUPPRESS with is
++# the | str is there so that foo = argparse.SUPPRESS; foo = "test" checks out in mypy
+ ZERO_OR_MORE: Final = "*"
+ _UNRECOGNIZED_ARGS_ATTR: Final = "_unrecognized_args"  # undocumented
+ 
+@@ -81,7 +83,7 @@ class _ActionsContainer:
+         # more precisely, Literal["?", "*", "+", "...", "A...", "==SUPPRESS=="],
+         # but using this would make it hard to annotate callers that don't use a
+         # literal argument and for subclasses to override this method.
+-        nargs: int | str | None = None,
++        nargs: int | str | _SUPPRESS_T | None = None,
+         const: Any = ...,
+         default: Any = ...,
+         type: _ActionType = ...,
+-- 
+2.48.1
+
diff -pruN 1.15.0-5/misc/typeshed_patches/0001-Remove-use-of-LiteralString-in-builtins-13743.patch 1.16~rc0.1-1/misc/typeshed_patches/0001-Remove-use-of-LiteralString-in-builtins-13743.patch
--- 1.15.0-5/misc/typeshed_patches/0001-Remove-use-of-LiteralString-in-builtins-13743.patch	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/typeshed_patches/0001-Remove-use-of-LiteralString-in-builtins-13743.patch	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,197 @@
+From b4259edd94188f9e4cc77a22e768eea183a32053 Mon Sep 17 00:00:00 2001
+From: Shantanu <12621235+hauntsaninja@users.noreply.github.com>
+Date: Mon, 26 Sep 2022 12:55:07 -0700
+Subject: [PATCH] Remove use of LiteralString in builtins (#13743)
+
+---
+ mypy/typeshed/stdlib/builtins.pyi | 100 +-----------------------------
+ 1 file changed, 1 insertion(+), 99 deletions(-)
+
+diff --git a/mypy/typeshed/stdlib/builtins.pyi b/mypy/typeshed/stdlib/builtins.pyi
+index 63c53a5f6..d55042b56 100644
+--- a/mypy/typeshed/stdlib/builtins.pyi
++++ b/mypy/typeshed/stdlib/builtins.pyi
+@@ -63,7 +63,6 @@ from typing import (  # noqa: Y022
+ from typing_extensions import (  # noqa: Y023
+     Concatenate,
+     Literal,
+-    LiteralString,
+     ParamSpec,
+     Self,
+     TypeAlias,
+@@ -438,31 +437,16 @@ class str(Sequence[str]):
+     def __new__(cls, object: object = ...) -> Self: ...
+     @overload
+     def __new__(cls, object: ReadableBuffer, encoding: str = ..., errors: str = ...) -> Self: ...
+-    @overload
+-    def capitalize(self: LiteralString) -> LiteralString: ...
+-    @overload
+     def capitalize(self) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def casefold(self: LiteralString) -> LiteralString: ...
+-    @overload
+     def casefold(self) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def center(self: LiteralString, width: SupportsIndex, fillchar: LiteralString = " ", /) -> LiteralString: ...
+-    @overload
+     def center(self, width: SupportsIndex, fillchar: str = " ", /) -> str: ...  # type: ignore[misc]
+     def count(self, sub: str, start: SupportsIndex | None = ..., end: SupportsIndex | None = ..., /) -> int: ...
+     def encode(self, encoding: str = "utf-8", errors: str = "strict") -> bytes: ...
+     def endswith(
+         self, suffix: str | tuple[str, ...], start: SupportsIndex | None = ..., end: SupportsIndex | None = ..., /
+     ) -> bool: ...
+-    @overload
+-    def expandtabs(self: LiteralString, tabsize: SupportsIndex = 8) -> LiteralString: ...
+-    @overload
+     def expandtabs(self, tabsize: SupportsIndex = 8) -> str: ...  # type: ignore[misc]
+     def find(self, sub: str, start: SupportsIndex | None = ..., end: SupportsIndex | None = ..., /) -> int: ...
+-    @overload
+-    def format(self: LiteralString, *args: LiteralString, **kwargs: LiteralString) -> LiteralString: ...
+-    @overload
+     def format(self, *args: object, **kwargs: object) -> str: ...
+     def format_map(self, mapping: _FormatMapMapping, /) -> str: ...
+     def index(self, sub: str, start: SupportsIndex | None = ..., end: SupportsIndex | None = ..., /) -> int: ...
+@@ -478,99 +462,35 @@ class str(Sequence[str]):
+     def isspace(self) -> bool: ...
+     def istitle(self) -> bool: ...
+     def isupper(self) -> bool: ...
+-    @overload
+-    def join(self: LiteralString, iterable: Iterable[LiteralString], /) -> LiteralString: ...
+-    @overload
+     def join(self, iterable: Iterable[str], /) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def ljust(self: LiteralString, width: SupportsIndex, fillchar: LiteralString = " ", /) -> LiteralString: ...
+-    @overload
+     def ljust(self, width: SupportsIndex, fillchar: str = " ", /) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def lower(self: LiteralString) -> LiteralString: ...
+-    @overload
+     def lower(self) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def lstrip(self: LiteralString, chars: LiteralString | None = None, /) -> LiteralString: ...
+-    @overload
+     def lstrip(self, chars: str | None = None, /) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def partition(self: LiteralString, sep: LiteralString, /) -> tuple[LiteralString, LiteralString, LiteralString]: ...
+-    @overload
+     def partition(self, sep: str, /) -> tuple[str, str, str]: ...  # type: ignore[misc]
+     if sys.version_info >= (3, 13):
+-        @overload
+-        def replace(
+-            self: LiteralString, old: LiteralString, new: LiteralString, /, count: SupportsIndex = -1
+-        ) -> LiteralString: ...
+-        @overload
+         def replace(self, old: str, new: str, /, count: SupportsIndex = -1) -> str: ...  # type: ignore[misc]
+     else:
+-        @overload
+-        def replace(
+-            self: LiteralString, old: LiteralString, new: LiteralString, count: SupportsIndex = -1, /
+-        ) -> LiteralString: ...
+-        @overload
+         def replace(self, old: str, new: str, count: SupportsIndex = -1, /) -> str: ...  # type: ignore[misc]
+     if sys.version_info >= (3, 9):
+-        @overload
+-        def removeprefix(self: LiteralString, prefix: LiteralString, /) -> LiteralString: ...
+-        @overload
+         def removeprefix(self, prefix: str, /) -> str: ...  # type: ignore[misc]
+-        @overload
+-        def removesuffix(self: LiteralString, suffix: LiteralString, /) -> LiteralString: ...
+-        @overload
+         def removesuffix(self, suffix: str, /) -> str: ...  # type: ignore[misc]
+ 
+     def rfind(self, sub: str, start: SupportsIndex | None = ..., end: SupportsIndex | None = ..., /) -> int: ...
+     def rindex(self, sub: str, start: SupportsIndex | None = ..., end: SupportsIndex | None = ..., /) -> int: ...
+-    @overload
+-    def rjust(self: LiteralString, width: SupportsIndex, fillchar: LiteralString = " ", /) -> LiteralString: ...
+-    @overload
+     def rjust(self, width: SupportsIndex, fillchar: str = " ", /) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def rpartition(self: LiteralString, sep: LiteralString, /) -> tuple[LiteralString, LiteralString, LiteralString]: ...
+-    @overload
+     def rpartition(self, sep: str, /) -> tuple[str, str, str]: ...  # type: ignore[misc]
+-    @overload
+-    def rsplit(self: LiteralString, sep: LiteralString | None = None, maxsplit: SupportsIndex = -1) -> list[LiteralString]: ...
+-    @overload
+     def rsplit(self, sep: str | None = None, maxsplit: SupportsIndex = -1) -> list[str]: ...  # type: ignore[misc]
+-    @overload
+-    def rstrip(self: LiteralString, chars: LiteralString | None = None, /) -> LiteralString: ...
+-    @overload
+     def rstrip(self, chars: str | None = None, /) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def split(self: LiteralString, sep: LiteralString | None = None, maxsplit: SupportsIndex = -1) -> list[LiteralString]: ...
+-    @overload
+     def split(self, sep: str | None = None, maxsplit: SupportsIndex = -1) -> list[str]: ...  # type: ignore[misc]
+-    @overload
+-    def splitlines(self: LiteralString, keepends: bool = False) -> list[LiteralString]: ...
+-    @overload
+     def splitlines(self, keepends: bool = False) -> list[str]: ...  # type: ignore[misc]
+     def startswith(
+         self, prefix: str | tuple[str, ...], start: SupportsIndex | None = ..., end: SupportsIndex | None = ..., /
+     ) -> bool: ...
+-    @overload
+-    def strip(self: LiteralString, chars: LiteralString | None = None, /) -> LiteralString: ...
+-    @overload
+     def strip(self, chars: str | None = None, /) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def swapcase(self: LiteralString) -> LiteralString: ...
+-    @overload
+     def swapcase(self) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def title(self: LiteralString) -> LiteralString: ...
+-    @overload
+     def title(self) -> str: ...  # type: ignore[misc]
+     def translate(self, table: _TranslateTable, /) -> str: ...
+-    @overload
+-    def upper(self: LiteralString) -> LiteralString: ...
+-    @overload
+     def upper(self) -> str: ...  # type: ignore[misc]
+-    @overload
+-    def zfill(self: LiteralString, width: SupportsIndex, /) -> LiteralString: ...
+-    @overload
+     def zfill(self, width: SupportsIndex, /) -> str: ...  # type: ignore[misc]
+     @staticmethod
+     @overload
+@@ -581,39 +501,21 @@ class str(Sequence[str]):
+     @staticmethod
+     @overload
+     def maketrans(x: str, y: str, z: str, /) -> dict[int, int | None]: ...
+-    @overload
+-    def __add__(self: LiteralString, value: LiteralString, /) -> LiteralString: ...
+-    @overload
+     def __add__(self, value: str, /) -> str: ...  # type: ignore[misc]
+     # Incompatible with Sequence.__contains__
+     def __contains__(self, key: str, /) -> bool: ...  # type: ignore[override]
+     def __eq__(self, value: object, /) -> bool: ...
+     def __ge__(self, value: str, /) -> bool: ...
+-    @overload
+-    def __getitem__(self: LiteralString, key: SupportsIndex | slice, /) -> LiteralString: ...
+-    @overload
+-    def __getitem__(self, key: SupportsIndex | slice, /) -> str: ...  # type: ignore[misc]
++    def __getitem__(self, key: SupportsIndex | slice, /) -> str: ...
+     def __gt__(self, value: str, /) -> bool: ...
+     def __hash__(self) -> int: ...
+-    @overload
+-    def __iter__(self: LiteralString) -> Iterator[LiteralString]: ...
+-    @overload
+     def __iter__(self) -> Iterator[str]: ...  # type: ignore[misc]
+     def __le__(self, value: str, /) -> bool: ...
+     def __len__(self) -> int: ...
+     def __lt__(self, value: str, /) -> bool: ...
+-    @overload
+-    def __mod__(self: LiteralString, value: LiteralString | tuple[LiteralString, ...], /) -> LiteralString: ...
+-    @overload
+     def __mod__(self, value: Any, /) -> str: ...
+-    @overload
+-    def __mul__(self: LiteralString, value: SupportsIndex, /) -> LiteralString: ...
+-    @overload
+     def __mul__(self, value: SupportsIndex, /) -> str: ...  # type: ignore[misc]
+     def __ne__(self, value: object, /) -> bool: ...
+-    @overload
+-    def __rmul__(self: LiteralString, value: SupportsIndex, /) -> LiteralString: ...
+-    @overload
+     def __rmul__(self, value: SupportsIndex, /) -> str: ...  # type: ignore[misc]
+     def __getnewargs__(self) -> tuple[str]: ...
+ 
+-- 
+2.47.0
+
diff -pruN 1.15.0-5/misc/typeshed_patches/0001-Revert-Remove-redundant-inheritances-from-Iterator.patch 1.16~rc0.1-1/misc/typeshed_patches/0001-Revert-Remove-redundant-inheritances-from-Iterator.patch
--- 1.15.0-5/misc/typeshed_patches/0001-Revert-Remove-redundant-inheritances-from-Iterator.patch	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/typeshed_patches/0001-Revert-Remove-redundant-inheritances-from-Iterator.patch	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,324 @@
+From abc5225e3c69d7ae8f3388c87260fe496efaecac Mon Sep 17 00:00:00 2001
+From: Marc Mueller <30130371+cdce8p@users.noreply.github.com>
+Date: Sat, 21 Dec 2024 22:36:38 +0100
+Subject: [PATCH] Revert Remove redundant inheritances from Iterator in
+ builtins
+
+---
+ mypy/typeshed/stdlib/_asyncio.pyi             |  4 +-
+ mypy/typeshed/stdlib/builtins.pyi             | 10 ++---
+ mypy/typeshed/stdlib/csv.pyi                  |  4 +-
+ mypy/typeshed/stdlib/fileinput.pyi            |  6 +--
+ mypy/typeshed/stdlib/itertools.pyi            | 38 +++++++++----------
+ mypy/typeshed/stdlib/multiprocessing/pool.pyi |  4 +-
+ mypy/typeshed/stdlib/sqlite3/__init__.pyi     |  2 +-
+ 7 files changed, 34 insertions(+), 34 deletions(-)
+
+diff --git a/mypy/typeshed/stdlib/_asyncio.pyi b/mypy/typeshed/stdlib/_asyncio.pyi
+index 89cdff6cc..1397e579d 100644
+--- a/mypy/typeshed/stdlib/_asyncio.pyi
++++ b/mypy/typeshed/stdlib/_asyncio.pyi
+@@ -1,6 +1,6 @@
+ import sys
+ from asyncio.events import AbstractEventLoop
+-from collections.abc import Awaitable, Callable, Coroutine, Generator
++from collections.abc import Awaitable, Callable, Coroutine, Generator, Iterable
+ from contextvars import Context
+ from types import FrameType
+ from typing import Any, Literal, TextIO, TypeVar
+@@ -13,7 +13,7 @@ _T = TypeVar("_T")
+ _T_co = TypeVar("_T_co", covariant=True)
+ _TaskYieldType: TypeAlias = Future[object] | None
+
+-class Future(Awaitable[_T]):
++class Future(Awaitable[_T], Iterable[_T]):
+     _state: str
+     @property
+     def _exception(self) -> BaseException | None: ...
+diff --git a/mypy/typeshed/stdlib/builtins.pyi b/mypy/typeshed/stdlib/builtins.pyi
+index b75e34fc5..526406acc 100644
+--- a/mypy/typeshed/stdlib/builtins.pyi
++++ b/mypy/typeshed/stdlib/builtins.pyi
+@@ -1130,7 +1130,7 @@ class frozenset(AbstractSet[_T_co]):
+     if sys.version_info >= (3, 9):
+         def __class_getitem__(cls, item: Any, /) -> GenericAlias: ...
+
+-class enumerate(Generic[_T]):
++class enumerate(Iterator[tuple[int, _T]]):
+     def __new__(cls, iterable: Iterable[_T], start: int = 0) -> Self: ...
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> tuple[int, _T]: ...
+@@ -1324,7 +1324,7 @@ else:
+
+ exit: _sitebuiltins.Quitter
+
+-class filter(Generic[_T]):
++class filter(Iterator[_T]):
+     @overload
+     def __new__(cls, function: None, iterable: Iterable[_T | None], /) -> Self: ...
+     @overload
+@@ -1389,7 +1389,7 @@ license: _sitebuiltins._Printer
+
+ def locals() -> dict[str, Any]: ...
+
+-class map(Generic[_S]):
++class map(Iterator[_S]):
+     @overload
+     def __new__(cls, func: Callable[[_T1], _S], iterable: Iterable[_T1], /) -> Self: ...
+     @overload
+@@ -1632,7 +1632,7 @@ def pow(base: _SupportsSomeKindOfPow, exp: complex, mod: None = None) -> complex
+
+ quit: _sitebuiltins.Quitter
+
+-class reversed(Generic[_T]):
++class reversed(Iterator[_T]):
+     @overload
+     def __new__(cls, sequence: Reversible[_T], /) -> Iterator[_T]: ...  # type: ignore[misc]
+     @overload
+@@ -1693,7 +1693,7 @@ def vars(object: type, /) -> types.MappingProxyType[str, Any]: ...
+ @overload
+ def vars(object: Any = ..., /) -> dict[str, Any]: ...
+
+-class zip(Generic[_T_co]):
++class zip(Iterator[_T_co]):
+     if sys.version_info >= (3, 10):
+         @overload
+         def __new__(cls, *, strict: bool = ...) -> zip[Any]: ...
+diff --git a/mypy/typeshed/stdlib/csv.pyi b/mypy/typeshed/stdlib/csv.pyi
+index 4a82de638..ef93129d6 100644
+--- a/mypy/typeshed/stdlib/csv.pyi
++++ b/mypy/typeshed/stdlib/csv.pyi
+@@ -25,7 +25,7 @@ else:
+     from _csv import _reader as Reader, _writer as Writer
+
+ from _typeshed import SupportsWrite
+-from collections.abc import Collection, Iterable, Mapping, Sequence
++from collections.abc import Collection, Iterable, Iterator, Mapping, Sequence
+ from typing import Any, Generic, Literal, TypeVar, overload
+ from typing_extensions import Self
+
+@@ -75,7 +75,7 @@ class excel(Dialect): ...
+ class excel_tab(excel): ...
+ class unix_dialect(Dialect): ...
+
+-class DictReader(Generic[_T]):
++class DictReader(Iterator[dict[_T | Any, str | Any]], Generic[_T]):
+     fieldnames: Sequence[_T] | None
+     restkey: _T | None
+     restval: str | Any | None
+diff --git a/mypy/typeshed/stdlib/fileinput.pyi b/mypy/typeshed/stdlib/fileinput.pyi
+index bf6daad0a..1e6aa78e2 100644
+--- a/mypy/typeshed/stdlib/fileinput.pyi
++++ b/mypy/typeshed/stdlib/fileinput.pyi
+@@ -1,8 +1,8 @@
+ import sys
+ from _typeshed import AnyStr_co, StrOrBytesPath
+-from collections.abc import Callable, Iterable
++from collections.abc import Callable, Iterable, Iterator
+ from types import TracebackType
+-from typing import IO, Any, AnyStr, Generic, Literal, Protocol, overload
++from typing import IO, Any, AnyStr, Literal, Protocol, overload
+ from typing_extensions import Self, TypeAlias
+
+ if sys.version_info >= (3, 9):
+@@ -107,7 +107,7 @@ def fileno() -> int: ...
+ def isfirstline() -> bool: ...
+ def isstdin() -> bool: ...
+
+-class FileInput(Generic[AnyStr]):
++class FileInput(Iterator[AnyStr]):
+     if sys.version_info >= (3, 10):
+         # encoding and errors are added
+         @overload
+diff --git a/mypy/typeshed/stdlib/itertools.pyi b/mypy/typeshed/stdlib/itertools.pyi
+index 55b0814ac..675533d44 100644
+--- a/mypy/typeshed/stdlib/itertools.pyi
++++ b/mypy/typeshed/stdlib/itertools.pyi
+@@ -29,7 +29,7 @@ _Predicate: TypeAlias = Callable[[_T], object]
+
+ # Technically count can take anything that implements a number protocol and has an add method
+ # but we can't enforce the add method
+-class count(Generic[_N]):
++class count(Iterator[_N]):
+     @overload
+     def __new__(cls) -> count[int]: ...
+     @overload
+@@ -39,12 +39,12 @@ class count(Generic[_N]):
+     def __next__(self) -> _N: ...
+     def __iter__(self) -> Self: ...
+
+-class cycle(Generic[_T]):
++class cycle(Iterator[_T]):
+     def __new__(cls, iterable: Iterable[_T], /) -> Self: ...
+     def __next__(self) -> _T: ...
+     def __iter__(self) -> Self: ...
+
+-class repeat(Generic[_T]):
++class repeat(Iterator[_T]):
+     @overload
+     def __new__(cls, object: _T) -> Self: ...
+     @overload
+@@ -53,7 +53,7 @@ class repeat(Generic[_T]):
+     def __iter__(self) -> Self: ...
+     def __length_hint__(self) -> int: ...
+
+-class accumulate(Generic[_T]):
++class accumulate(Iterator[_T]):
+     @overload
+     def __new__(cls, iterable: Iterable[_T], func: None = None, *, initial: _T | None = ...) -> Self: ...
+     @overload
+@@ -61,7 +61,7 @@ class accumulate(Generic[_T]):
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T: ...
+
+-class chain(Generic[_T]):
++class chain(Iterator[_T]):
+     def __new__(cls, *iterables: Iterable[_T]) -> Self: ...
+     def __next__(self) -> _T: ...
+     def __iter__(self) -> Self: ...
+@@ -71,22 +71,22 @@ class chain(Generic[_T]):
+     if sys.version_info >= (3, 9):
+         def __class_getitem__(cls, item: Any, /) -> GenericAlias: ...
+
+-class compress(Generic[_T]):
++class compress(Iterator[_T]):
+     def __new__(cls, data: Iterable[_T], selectors: Iterable[Any]) -> Self: ...
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T: ...
+
+-class dropwhile(Generic[_T]):
++class dropwhile(Iterator[_T]):
+     def __new__(cls, predicate: _Predicate[_T], iterable: Iterable[_T], /) -> Self: ...
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T: ...
+
+-class filterfalse(Generic[_T]):
++class filterfalse(Iterator[_T]):
+     def __new__(cls, function: _Predicate[_T] | None, iterable: Iterable[_T], /) -> Self: ...
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T: ...
+
+-class groupby(Generic[_T_co, _S_co]):
++class groupby(Iterator[tuple[_T_co, Iterator[_S_co]]], Generic[_T_co, _S_co]):
+     @overload
+     def __new__(cls, iterable: Iterable[_T1], key: None = None) -> groupby[_T1, _T1]: ...
+     @overload
+@@ -94,7 +94,7 @@ class groupby(Generic[_T_co, _S_co]):
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> tuple[_T_co, Iterator[_S_co]]: ...
+
+-class islice(Generic[_T]):
++class islice(Iterator[_T]):
+     @overload
+     def __new__(cls, iterable: Iterable[_T], stop: int | None, /) -> Self: ...
+     @overload
+@@ -102,19 +102,19 @@ class islice(Generic[_T]):
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T: ...
+
+-class starmap(Generic[_T_co]):
++class starmap(Iterator[_T_co]):
+     def __new__(cls, function: Callable[..., _T], iterable: Iterable[Iterable[Any]], /) -> starmap[_T]: ...
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T_co: ...
+
+-class takewhile(Generic[_T]):
++class takewhile(Iterator[_T]):
+     def __new__(cls, predicate: _Predicate[_T], iterable: Iterable[_T], /) -> Self: ...
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T: ...
+
+ def tee(iterable: Iterable[_T], n: int = 2, /) -> tuple[Iterator[_T], ...]: ...
+
+-class zip_longest(Generic[_T_co]):
++class zip_longest(Iterator[_T_co]):
+     # one iterable (fillvalue doesn't matter)
+     @overload
+     def __new__(cls, iter1: Iterable[_T1], /, *, fillvalue: object = ...) -> zip_longest[tuple[_T1]]: ...
+@@ -192,7 +192,7 @@ class zip_longest(Generic[_T_co]):
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T_co: ...
+
+-class product(Generic[_T_co]):
++class product(Iterator[_T_co]):
+     @overload
+     def __new__(cls, iter1: Iterable[_T1], /) -> product[tuple[_T1]]: ...
+     @overload
+@@ -277,7 +277,7 @@ class product(Generic[_T_co]):
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T_co: ...
+
+-class permutations(Generic[_T_co]):
++class permutations(Iterator[_T_co]):
+     @overload
+     def __new__(cls, iterable: Iterable[_T], r: Literal[2]) -> permutations[tuple[_T, _T]]: ...
+     @overload
+@@ -291,7 +291,7 @@ class permutations(Generic[_T_co]):
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T_co: ...
+
+-class combinations(Generic[_T_co]):
++class combinations(Iterator[_T_co]):
+     @overload
+     def __new__(cls, iterable: Iterable[_T], r: Literal[2]) -> combinations[tuple[_T, _T]]: ...
+     @overload
+@@ -305,7 +305,7 @@ class combinations(Generic[_T_co]):
+     def __iter__(self) -> Self: ...
+     def __next__(self) -> _T_co: ...
+
+-class combinations_with_replacement(Generic[_T_co]):
++class combinations_with_replacement(Iterator[_T_co]):
+     @overload
+     def __new__(cls, iterable: Iterable[_T], r: Literal[2]) -> combinations_with_replacement[tuple[_T, _T]]: ...
+     @overload
+@@ -320,13 +320,13 @@ class combinations_with_replacement(Generic[_T_co]):
+     def __next__(self) -> _T_co: ...
+
+ if sys.version_info >= (3, 10):
+-    class pairwise(Generic[_T_co]):
++    class pairwise(Iterator[_T_co]):
+         def __new__(cls, iterable: Iterable[_T], /) -> pairwise[tuple[_T, _T]]: ...
+         def __iter__(self) -> Self: ...
+         def __next__(self) -> _T_co: ...
+
+ if sys.version_info >= (3, 12):
+-    class batched(Generic[_T_co]):
++    class batched(Iterator[tuple[_T_co, ...]], Generic[_T_co]):
+         if sys.version_info >= (3, 13):
+             def __new__(cls, iterable: Iterable[_T_co], n: int, *, strict: bool = False) -> Self: ...
+         else:
+diff --git a/mypy/typeshed/stdlib/multiprocessing/pool.pyi b/mypy/typeshed/stdlib/multiprocessing/pool.pyi
+index 2937d45e3..93197e5d4 100644
+--- a/mypy/typeshed/stdlib/multiprocessing/pool.pyi
++++ b/mypy/typeshed/stdlib/multiprocessing/pool.pyi
+@@ -1,5 +1,5 @@
+ import sys
+-from collections.abc import Callable, Iterable, Mapping
++from collections.abc import Callable, Iterable, Iterator, Mapping
+ from multiprocessing.context import DefaultContext, Process
+ from types import TracebackType
+ from typing import Any, Final, Generic, TypeVar
+@@ -37,7 +37,7 @@ class MapResult(ApplyResult[list[_T]]):
+         error_callback: Callable[[BaseException], object] | None,
+     ) -> None: ...
+
+-class IMapIterator(Generic[_T]):
++class IMapIterator(Iterator[_T]):
+     def __init__(self, pool: Pool) -> None: ...
+     def __iter__(self) -> Self: ...
+     def next(self, timeout: float | None = None) -> _T: ...
+diff --git a/mypy/typeshed/stdlib/sqlite3/__init__.pyi b/mypy/typeshed/stdlib/sqlite3/__init__.pyi
+index b83516b4d..724bc3166 100644
+--- a/mypy/typeshed/stdlib/sqlite3/__init__.pyi
++++ b/mypy/typeshed/stdlib/sqlite3/__init__.pyi
+@@ -397,7 +397,7 @@ class Connection:
+         self, type: type[BaseException] | None, value: BaseException | None, traceback: TracebackType | None, /
+     ) -> Literal[False]: ...
+
+-class Cursor:
++class Cursor(Iterator[Any]):
+     arraysize: int
+     @property
+     def connection(self) -> Connection: ...
+--
+2.47.1
diff -pruN 1.15.0-5/misc/typeshed_patches/0001-Revert-sum-literal-integer-change-13961.patch 1.16~rc0.1-1/misc/typeshed_patches/0001-Revert-sum-literal-integer-change-13961.patch
--- 1.15.0-5/misc/typeshed_patches/0001-Revert-sum-literal-integer-change-13961.patch	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/typeshed_patches/0001-Revert-sum-literal-integer-change-13961.patch	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,36 @@
+From 58c6a6ab863c1c38e95ccafaf13792ed9c00e499 Mon Sep 17 00:00:00 2001
+From: Shantanu <12621235+hauntsaninja@users.noreply.github.com>
+Date: Sat, 29 Oct 2022 12:47:21 -0700
+Subject: [PATCH] Revert sum literal integer change (#13961)
+
+This is allegedly causing large performance problems, see 13821
+
+typeshed/8231 had zero hits on mypy_primer, so it's not the worst thing
+to undo. Patching this in typeshed also feels weird, since there's a
+more general soundness issue. If a typevar has a bound or constraint, we
+might not want to solve it to a Literal.
+
+If we can confirm the performance regression or fix the unsoundness
+within mypy, I might pursue upstreaming this in typeshed.
+
+(Reminder: add this to the sync_typeshed script once merged)
+---
+ mypy/typeshed/stdlib/builtins.pyi | 2 +-
+ 1 file changed, 1 insertion(+), 1 deletion(-)
+
+diff --git a/mypy/typeshed/stdlib/builtins.pyi b/mypy/typeshed/stdlib/builtins.pyi
+index ea9f8c894..a6065cc67 100644
+--- a/mypy/typeshed/stdlib/builtins.pyi
++++ b/mypy/typeshed/stdlib/builtins.pyi
+@@ -1653,7 +1653,7 @@ _SupportsSumNoDefaultT = TypeVar("_SupportsSumNoDefaultT", bound=_SupportsSumWit
+ # without creating many false-positive errors (see #7578).
+ # Instead, we special-case the most common examples of this: bool and literal integers.
+ @overload
+-def sum(iterable: Iterable[bool | _LiteralInteger], /, start: int = 0) -> int: ...
++def sum(iterable: Iterable[bool], /, start: int = 0) -> int: ...
+ @overload
+ def sum(iterable: Iterable[_SupportsSumNoDefaultT], /) -> _SupportsSumNoDefaultT | Literal[0]: ...
+ @overload
+-- 
+2.46.0
+
diff -pruN 1.15.0-5/misc/typeshed_patches/0001-Revert-typeshed-ctypes-change.patch 1.16~rc0.1-1/misc/typeshed_patches/0001-Revert-typeshed-ctypes-change.patch
--- 1.15.0-5/misc/typeshed_patches/0001-Revert-typeshed-ctypes-change.patch	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/typeshed_patches/0001-Revert-typeshed-ctypes-change.patch	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,32 @@
+From 61a490091d7c941780919660dc4fdfa88ae6474a Mon Sep 17 00:00:00 2001
+From: AlexWaygood <alex.waygood@gmail.com>
+Date: Mon, 1 May 2023 20:34:55 +0100
+Subject: [PATCH] Revert typeshed ctypes change Since the plugin provides
+ superior type checking:
+ https://github.com/python/mypy/pull/13987#issuecomment-1310863427 A manual
+ cherry-pick of e437cdf.
+
+---
+ mypy/typeshed/stdlib/_ctypes.pyi | 6 +-----
+ 1 file changed, 1 insertion(+), 5 deletions(-)
+
+diff --git a/mypy/typeshed/stdlib/_ctypes.pyi b/mypy/typeshed/stdlib/_ctypes.pyi
+index 60bbc51d9..cf9cb81a4 100644
+--- a/mypy/typeshed/stdlib/_ctypes.pyi
++++ b/mypy/typeshed/stdlib/_ctypes.pyi
+@@ -169,11 +169,7 @@ class Array(_CData, Generic[_CT]):
+     def _type_(self) -> type[_CT]: ...
+     @_type_.setter
+     def _type_(self, value: type[_CT]) -> None: ...
+-    # Note: only available if _CT == c_char
+-    @property
+-    def raw(self) -> bytes: ...
+-    @raw.setter
+-    def raw(self, value: ReadableBuffer) -> None: ...
++    raw: bytes  # Note: only available if _CT == c_char
+     value: Any  # Note: bytes if _CT == c_char, str if _CT == c_wchar, unavailable otherwise
+     # TODO These methods cannot be annotated correctly at the moment.
+     # All of these "Any"s stand for the array's element type, but it's not possible to use _CT
+-- 
+2.39.3 (Apple Git-146)
+
diff -pruN 1.15.0-5/misc/update-stubinfo.py 1.16~rc0.1-1/misc/update-stubinfo.py
--- 1.15.0-5/misc/update-stubinfo.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/update-stubinfo.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,67 @@
+import argparse
+from pathlib import Path
+
+import tomli as tomllib
+
+
+def main() -> None:
+    parser = argparse.ArgumentParser()
+    parser.add_argument("--typeshed", type=Path, required=True)
+    args = parser.parse_args()
+
+    typeshed_p_to_d = {}
+    for stub in (args.typeshed / "stubs").iterdir():
+        if not stub.is_dir():
+            continue
+        try:
+            metadata = tomllib.loads((stub / "METADATA.toml").read_text())
+        except FileNotFoundError:
+            continue
+        d = metadata.get("stub_distribution", f"types-{stub.name}")
+        for p in stub.iterdir():
+            if not p.stem.isidentifier():
+                continue
+            if p.is_dir() and not any(f.suffix == ".pyi" for f in p.iterdir()):
+                # ignore namespace packages
+                continue
+            if p.is_file() and p.suffix != ".pyi":
+                continue
+            typeshed_p_to_d[p.stem] = d
+
+    import mypy.stubinfo
+
+    mypy_p = set(mypy.stubinfo.non_bundled_packages_flat) | set(
+        mypy.stubinfo.legacy_bundled_packages
+    )
+
+    for p in typeshed_p_to_d.keys() & mypy_p:
+        mypy_d = mypy.stubinfo.non_bundled_packages_flat.get(p)
+        mypy_d = mypy_d or mypy.stubinfo.legacy_bundled_packages.get(p)
+        if mypy_d != typeshed_p_to_d[p]:
+            raise ValueError(
+                f"stub_distribution mismatch for {p}: {mypy_d} != {typeshed_p_to_d[p]}"
+            )
+
+    print("=" * 40)
+    print("Add the following to non_bundled_packages_flat:")
+    print("=" * 40)
+    for p in sorted(typeshed_p_to_d.keys() - mypy_p):
+        if p in {
+            "pika",  # see comment in stubinfo.py
+            "distutils",  # don't recommend types-setuptools here
+        }:
+            continue
+        print(f'"{p}": "{typeshed_p_to_d[p]}",')
+    print()
+
+    print("=" * 40)
+    print("Consider removing the following packages no longer in typeshed:")
+    print("=" * 40)
+    for p in sorted(mypy_p - typeshed_p_to_d.keys()):
+        if p in {"lxml", "pandas"}:  # never in typeshed
+            continue
+        print(p)
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/misc/upload-pypi.py 1.16~rc0.1-1/misc/upload-pypi.py
--- 1.15.0-5/misc/upload-pypi.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/misc/upload-pypi.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,152 @@
+#!/usr/bin/env python3
+"""Upload mypy packages to PyPI.
+
+You must first tag the release, use `git push --tags` and wait for the wheel build in CI to complete.
+
+"""
+
+from __future__ import annotations
+
+import argparse
+import contextlib
+import json
+import re
+import shutil
+import subprocess
+import tarfile
+import tempfile
+import venv
+from collections.abc import Iterator
+from concurrent.futures import ThreadPoolExecutor
+from pathlib import Path
+from typing import Any
+from urllib.request import urlopen
+
+BASE = "https://api.github.com/repos"
+REPO = "mypyc/mypy_mypyc-wheels"
+
+
+def is_whl_or_tar(name: str) -> bool:
+    return name.endswith((".tar.gz", ".whl"))
+
+
+def item_ok_for_pypi(name: str) -> bool:
+    if not is_whl_or_tar(name):
+        return False
+
+    name = name.removesuffix(".tar.gz")
+    name = name.removesuffix(".whl")
+
+    if name.endswith("wasm32"):
+        return False
+
+    return True
+
+
+def get_release_for_tag(tag: str) -> dict[str, Any]:
+    with urlopen(f"{BASE}/{REPO}/releases/tags/{tag}") as f:
+        data = json.load(f)
+    assert isinstance(data, dict)
+    assert data["tag_name"] == tag
+    return data
+
+
+def download_asset(asset: dict[str, Any], dst: Path) -> Path:
+    name = asset["name"]
+    assert isinstance(name, str)
+    download_url = asset["browser_download_url"]
+    assert is_whl_or_tar(name)
+    with urlopen(download_url) as src_file:
+        with open(dst / name, "wb") as dst_file:
+            shutil.copyfileobj(src_file, dst_file)
+    return dst / name
+
+
+def download_all_release_assets(release: dict[str, Any], dst: Path) -> None:
+    print("Downloading assets...")
+    with ThreadPoolExecutor() as e:
+        for asset in e.map(lambda asset: download_asset(asset, dst), release["assets"]):
+            print(f"Downloaded {asset}")
+
+
+def check_sdist(dist: Path, version: str) -> None:
+    tarfiles = list(dist.glob("*.tar.gz"))
+    assert len(tarfiles) == 1
+    sdist = tarfiles[0]
+    assert version in sdist.name
+    with tarfile.open(sdist) as f:
+        version_py = f.extractfile(f"{sdist.name[:-len('.tar.gz')]}/mypy/version.py")
+        assert version_py is not None
+        version_py_contents = version_py.read().decode("utf-8")
+
+        # strip a git hash from our version, if necessary, since that's not present in version.py
+        match = re.match(r"(.*\+dev).*$", version)
+        hashless_version = match.group(1) if match else version
+
+        assert (
+            f'"{hashless_version}"' in version_py_contents
+        ), "Version does not match version.py in sdist"
+
+
+def spot_check_dist(dist: Path, version: str) -> None:
+    items = [item for item in dist.iterdir() if item_ok_for_pypi(item.name)]
+    assert len(items) > 10
+    assert all(version in item.name for item in items)
+    assert any(item.name.endswith("py3-none-any.whl") for item in items)
+
+
+@contextlib.contextmanager
+def tmp_twine() -> Iterator[Path]:
+    with tempfile.TemporaryDirectory() as tmp_dir:
+        tmp_venv_dir = Path(tmp_dir) / "venv"
+        venv.create(tmp_venv_dir, with_pip=True)
+        pip_exe = tmp_venv_dir / "bin" / "pip"
+        subprocess.check_call([pip_exe, "install", "twine"])
+        yield tmp_venv_dir / "bin" / "twine"
+
+
+def upload_dist(dist: Path, dry_run: bool = True) -> None:
+    with tmp_twine() as twine:
+        files = [item for item in dist.iterdir() if item_ok_for_pypi(item.name)]
+        cmd: list[Any] = [twine, "upload"]
+        cmd += files
+        if dry_run:
+            print("[dry run] " + " ".join(map(str, cmd)))
+        else:
+            print(" ".join(map(str, cmd)))
+            subprocess.check_call(cmd)
+
+
+def upload_to_pypi(version: str, dry_run: bool = True) -> None:
+    assert re.match(r"v?[1-9]\.[0-9]+\.[0-9](\+\S+)?$", version)
+    if "dev" in version:
+        assert dry_run, "Must use --dry-run with dev versions of mypy"
+    version = version.removeprefix("v")
+
+    target_dir = tempfile.mkdtemp()
+    dist = Path(target_dir) / "dist"
+    dist.mkdir()
+    print(f"Temporary target directory: {target_dir}")
+
+    release = get_release_for_tag(f"v{version}")
+    download_all_release_assets(release, dist)
+
+    spot_check_dist(dist, version)
+    check_sdist(dist, version)
+    upload_dist(dist, dry_run)
+    print("<< All done! >>")
+
+
+def main() -> None:
+    parser = argparse.ArgumentParser(description="PyPI mypy package uploader")
+    parser.add_argument(
+        "--dry-run", action="store_true", default=False, help="Don't actually upload packages"
+    )
+    parser.add_argument("version", help="mypy version to release")
+    args = parser.parse_args()
+
+    upload_to_pypi(args.version, args.dry_run)
+
+
+if __name__ == "__main__":
+    main()
diff -pruN 1.15.0-5/mypy/argmap.py 1.16~rc0.1-1/mypy/argmap.py
--- 1.15.0-5/mypy/argmap.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/argmap.py	2025-05-27 17:21:15.000000000 +0000
@@ -78,7 +78,7 @@ def map_actuals_to_formals(
         elif actual_kind.is_named():
             assert actual_names is not None, "Internal error: named kinds without names given"
             name = actual_names[ai]
-            if name in formal_names:
+            if name in formal_names and formal_kinds[formal_names.index(name)] != nodes.ARG_STAR:
                 formal_to_actual[formal_names.index(name)].append(ai)
             elif nodes.ARG_STAR2 in formal_kinds:
                 formal_to_actual[formal_kinds.index(nodes.ARG_STAR2)].append(ai)
@@ -220,7 +220,7 @@ class ArgTypeExpander:
                     self.tuple_index += 1
                 item = actual_type.items[self.tuple_index - 1]
                 if isinstance(item, UnpackType) and not allow_unpack:
-                    # An upack item that doesn't have special handling, use upper bound as above.
+                    # An unpack item that doesn't have special handling, use upper bound as above.
                     unpacked = get_proper_type(item.type)
                     if isinstance(unpacked, TypeVarTupleType):
                         fallback = get_proper_type(unpacked.upper_bound)
@@ -249,10 +249,8 @@ class ArgTypeExpander:
                     formal_name = (set(actual_type.items.keys()) - self.kwargs_used).pop()
                 self.kwargs_used.add(formal_name)
                 return actual_type.items[formal_name]
-            elif (
-                isinstance(actual_type, Instance)
-                and len(actual_type.args) > 1
-                and is_subtype(actual_type, self.context.mapping_type)
+            elif isinstance(actual_type, Instance) and is_subtype(
+                actual_type, self.context.mapping_type
             ):
                 # Only `Mapping` type can be unpacked with `**`.
                 # Other types will produce an error somewhere else.
diff -pruN 1.15.0-5/mypy/binder.py 1.16~rc0.1-1/mypy/binder.py
--- 1.15.0-5/mypy/binder.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/binder.py	2025-05-27 17:21:15.000000000 +0000
@@ -7,10 +7,11 @@ from typing import NamedTuple, Optional,
 from typing_extensions import TypeAlias as _TypeAlias
 
 from mypy.erasetype import remove_instance_last_known_values
-from mypy.join import join_simple
-from mypy.literals import Key, literal, literal_hash, subkeys
+from mypy.literals import Key, extract_var_from_literal_hash, literal, literal_hash, subkeys
 from mypy.nodes import Expression, IndexExpr, MemberExpr, NameExpr, RefExpr, TypeInfo, Var
+from mypy.options import Options
 from mypy.subtypes import is_same_type, is_subtype
+from mypy.typeops import make_simplified_union
 from mypy.types import (
     AnyType,
     Instance,
@@ -21,6 +22,7 @@ from mypy.types import (
     Type,
     TypeOfAny,
     TypeType,
+    TypeVarType,
     UnionType,
     UnpackType,
     find_unpack_in_list,
@@ -38,14 +40,25 @@ class CurrentType(NamedTuple):
 
 class Frame:
     """A Frame represents a specific point in the execution of a program.
+
     It carries information about the current types of expressions at
     that point, arising either from assignments to those expressions
-    or the result of isinstance checks. It also records whether it is
-    possible to reach that point at all.
+    or the result of isinstance checks and other type narrowing
+    operations. It also records whether it is possible to reach that
+    point at all.
+
+    We add a new frame wherenever there is a new scope or control flow
+    branching.
 
     This information is not copied into a new Frame when it is pushed
     onto the stack, so a given Frame only has information about types
     that were assigned in that frame.
+
+    Expressions are stored in dicts using 'literal hashes' as keys (type
+    "Key"). These are hashable values derived from expression AST nodes
+    (only those that can be narrowed). literal_hash(expr) is used to
+    calculate the hashes. Note that this isn't directly related to literal
+    types -- the concept predates literal types.
     """
 
     def __init__(self, id: int, conditional_frame: bool = False) -> None:
@@ -65,29 +78,29 @@ Assigns = defaultdict[Expression, list[t
 class ConditionalTypeBinder:
     """Keep track of conditional types of variables.
 
-    NB: Variables are tracked by literal expression, so it is possible
-    to confuse the binder; for example,
+    NB: Variables are tracked by literal hashes of expressions, so it is
+    possible to confuse the binder when there is aliasing. Example:
 
-    ```
-    class A:
-        a: Union[int, str] = None
-    x = A()
-    lst = [x]
-    reveal_type(x.a)      # Union[int, str]
-    x.a = 1
-    reveal_type(x.a)      # int
-    reveal_type(lst[0].a) # Union[int, str]
-    lst[0].a = 'a'
-    reveal_type(x.a)      # int
-    reveal_type(lst[0].a) # str
-    ```
+        class A:
+            a: int | str
+
+        x = A()
+        lst = [x]
+        reveal_type(x.a)      # int | str
+        x.a = 1
+        reveal_type(x.a)      # int
+        reveal_type(lst[0].a) # int | str
+        lst[0].a = 'a'
+        reveal_type(x.a)      # int
+        reveal_type(lst[0].a) # str
     """
 
     # Stored assignments for situations with tuple/list lvalue and rvalue of union type.
     # This maps an expression to a list of bound types for every item in the union type.
     type_assignments: Assigns | None = None
 
-    def __init__(self) -> None:
+    def __init__(self, options: Options) -> None:
+        # Each frame gets an increasing, distinct id.
         self.next_id = 1
 
         # The stack of frames currently used.  These map
@@ -115,10 +128,16 @@ class ConditionalTypeBinder:
         # Whether the last pop changed the newly top frame on exit
         self.last_pop_changed = False
 
+        # These are used to track control flow in try statements and loops.
         self.try_frames: set[int] = set()
         self.break_frames: list[int] = []
         self.continue_frames: list[int] = []
 
+        # If True, initial assignment to a simple variable (e.g. "x", but not "x.y")
+        # is added to the binder. This allows more precise narrowing and more
+        # flexible inference of variable types (--allow-redefinition-new).
+        self.bind_all = options.allow_redefinition_new
+
     def _get_id(self) -> int:
         self.next_id += 1
         return self.next_id
@@ -150,6 +169,10 @@ class ConditionalTypeBinder:
         return None
 
     def put(self, expr: Expression, typ: Type, *, from_assignment: bool = True) -> None:
+        """Directly set the narrowed type of expression (if it supports it).
+
+        This is used for isinstance() etc. Assignments should go through assign_type().
+        """
         if not isinstance(expr, (IndexExpr, MemberExpr, NameExpr)):
             return
         if not literal(expr):
@@ -210,12 +233,20 @@ class ConditionalTypeBinder:
         for key in keys:
             current_value = self._get(key)
             resulting_values = [f.types.get(key, current_value) for f in frames]
-            if any(x is None for x in resulting_values):
+            # Keys can be narrowed using two different semantics. The new semantics
+            # is enabled for plain variables when bind_all is true, and it allows
+            # variable types to be widened using subsequent assignments. This is
+            # tricky to support for instance attributes (primarily due to deferrals),
+            # so we don't use it for them.
+            old_semantics = not self.bind_all or extract_var_from_literal_hash(key) is None
+            if old_semantics and any(x is None for x in resulting_values):
                 # We didn't know anything about key before
                 # (current_value must be None), and we still don't
                 # know anything about key in at least one possible frame.
                 continue
 
+            resulting_values = [x for x in resulting_values if x is not None]
+
             if all_reachable and all(
                 x is not None and not x.from_assignment for x in resulting_values
             ):
@@ -237,9 +268,21 @@ class ConditionalTypeBinder:
                 ):
                     type = AnyType(TypeOfAny.from_another_any, source_any=declaration_type)
             else:
-                for other in resulting_values[1:]:
-                    assert other is not None
-                    type = join_simple(self.declarations[key], type, other.type)
+                possible_types = []
+                for t in resulting_values:
+                    assert t is not None
+                    possible_types.append(t.type)
+                if len(possible_types) == 1:
+                    # This is to avoid calling get_proper_type() unless needed, as this may
+                    # interfere with our (hacky) TypeGuard support.
+                    type = possible_types[0]
+                else:
+                    type = make_simplified_union(possible_types)
+                    # Legacy guard for corner case when the original type is TypeVarType.
+                    if isinstance(declaration_type, TypeVarType) and not is_subtype(
+                        type, declaration_type
+                    ):
+                        type = declaration_type
                     # Try simplifying resulting type for unions involving variadic tuples.
                     # Technically, everything is still valid without this step, but if we do
                     # not do this, this may create long unions after exiting an if check like:
@@ -250,7 +293,11 @@ class ConditionalTypeBinder:
                     # still equivalent to such type).
                     if isinstance(type, UnionType):
                         type = collapse_variadic_union(type)
-                    if isinstance(type, ProperType) and isinstance(type, UnionType):
+                    if (
+                        old_semantics
+                        and isinstance(type, ProperType)
+                        and isinstance(type, UnionType)
+                    ):
                         # Simplify away any extra Any's that were added to the declared
                         # type when popping a frame.
                         simplified = UnionType.make_union(
@@ -258,7 +305,7 @@ class ConditionalTypeBinder:
                         )
                         if simplified == self.declarations[key]:
                             type = simplified
-            if current_value is None or not is_same_type(type, current_value[0]):
+            if current_value is None or not is_same_type(type, current_value.type):
                 self._put(key, type, from_assignment=True)
                 changed = True
 
@@ -300,9 +347,14 @@ class ConditionalTypeBinder:
         yield self.type_assignments
         self.type_assignments = old_assignments
 
-    def assign_type(
-        self, expr: Expression, type: Type, declared_type: Type | None, restrict_any: bool = False
-    ) -> None:
+    def assign_type(self, expr: Expression, type: Type, declared_type: Type | None) -> None:
+        """Narrow type of expression through an assignment.
+
+        Do nothing if the expression doesn't support narrowing.
+
+        When not narrowing though an assignment (isinstance() etc.), use put()
+        directly. This omits some special-casing logic for assignments.
+        """
         # We should erase last known value in binder, because if we are using it,
         # it means that the target is not final, and therefore can't hold a literal.
         type = remove_instance_last_known_values(type)
@@ -333,41 +385,39 @@ class ConditionalTypeBinder:
 
         p_declared = get_proper_type(declared_type)
         p_type = get_proper_type(type)
-        enclosing_type = get_proper_type(self.most_recent_enclosing_type(expr, type))
-        if isinstance(enclosing_type, AnyType) and not restrict_any:
-            # If x is Any and y is int, after x = y we do not infer that x is int.
-            # This could be changed.
-            # Instead, since we narrowed type from Any in a recent frame (probably an
-            # isinstance check), but now it is reassigned, we broaden back
-            # to Any (which is the most recent enclosing type)
-            self.put(expr, enclosing_type)
-        # As a special case, when assigning Any to a variable with a
-        # declared Optional type that has been narrowed to None,
-        # replace all the Nones in the declared Union type with Any.
-        # This overrides the normal behavior of ignoring Any assignments to variables
-        # in order to prevent false positives.
-        # (See discussion in #3526)
-        elif (
-            isinstance(p_type, AnyType)
-            and isinstance(p_declared, UnionType)
-            and any(isinstance(get_proper_type(item), NoneType) for item in p_declared.items)
-            and isinstance(
-                get_proper_type(self.most_recent_enclosing_type(expr, NoneType())), NoneType
-            )
-        ):
-            # Replace any Nones in the union type with Any
-            new_items = [
-                type if isinstance(get_proper_type(item), NoneType) else item
-                for item in p_declared.items
-            ]
-            self.put(expr, UnionType(new_items))
-        elif isinstance(p_type, AnyType) and not (
-            isinstance(p_declared, UnionType)
-            and any(isinstance(get_proper_type(item), AnyType) for item in p_declared.items)
-        ):
-            # Assigning an Any value doesn't affect the type to avoid false negatives, unless
-            # there is an Any item in a declared union type.
-            self.put(expr, declared_type)
+        if isinstance(p_type, AnyType):
+            # Any type requires some special casing, for both historical reasons,
+            # and to optimise user experience without sacrificing correctness too much.
+            if isinstance(expr, RefExpr) and isinstance(expr.node, Var) and expr.node.is_inferred:
+                # First case: a local/global variable without explicit annotation,
+                # in this case we just assign Any (essentially following the SSA logic).
+                self.put(expr, type)
+            elif isinstance(p_declared, UnionType) and any(
+                isinstance(get_proper_type(item), NoneType) for item in p_declared.items
+            ):
+                # Second case: explicit optional type, in this case we optimize for a common
+                # pattern when an untyped value used as a fallback replacing None.
+                new_items = [
+                    type if isinstance(get_proper_type(item), NoneType) else item
+                    for item in p_declared.items
+                ]
+                self.put(expr, UnionType(new_items))
+            elif isinstance(p_declared, UnionType) and any(
+                isinstance(get_proper_type(item), AnyType) for item in p_declared.items
+            ):
+                # Third case: a union already containing Any (most likely from an un-imported
+                # name), in this case we allow assigning Any as well.
+                self.put(expr, type)
+            else:
+                # In all other cases we don't narrow to Any to minimize false negatives.
+                self.put(expr, declared_type)
+        elif isinstance(p_declared, AnyType):
+            # Mirroring the first case above, we don't narrow to a precise type if the variable
+            # has an explicit `Any` type annotation.
+            if isinstance(expr, RefExpr) and isinstance(expr.node, Var) and expr.node.is_inferred:
+                self.put(expr, type)
+            else:
+                self.put(expr, declared_type)
         else:
             self.put(expr, type)
 
@@ -389,19 +439,6 @@ class ConditionalTypeBinder:
         for dep in self.dependencies.get(key, set()):
             self._cleanse_key(dep)
 
-    def most_recent_enclosing_type(self, expr: BindableExpression, type: Type) -> Type | None:
-        type = get_proper_type(type)
-        if isinstance(type, AnyType):
-            return get_declaration(expr)
-        key = literal_hash(expr)
-        assert key is not None
-        enclosers = [get_declaration(expr)] + [
-            f.types[key].type
-            for f in self.frames
-            if key in f.types and is_subtype(type, f.types[key][0])
-        ]
-        return enclosers[-1]
-
     def allow_jump(self, index: int) -> None:
         # self.frames and self.options_on_return have different lengths
         # so make sure the index is positive
@@ -492,6 +529,11 @@ class ConditionalTypeBinder:
 
 
 def get_declaration(expr: BindableExpression) -> Type | None:
+    """Get the declared or inferred type of a RefExpr expression.
+
+    Return None if there is no type or the expression is not a RefExpr.
+    This can return None if the type hasn't been inferred yet.
+    """
     if isinstance(expr, RefExpr):
         if isinstance(expr.node, Var):
             type = expr.node.type
diff -pruN 1.15.0-5/mypy/build.py 1.16~rc0.1-1/mypy/build.py
--- 1.15.0-5/mypy/build.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/build.py	2025-05-27 17:21:15.000000000 +0000
@@ -1069,7 +1069,7 @@ def read_plugins_snapshot(manager: Build
     if snapshot is None:
         return None
     if not isinstance(snapshot, dict):
-        manager.log(f"Could not load plugins snapshot: cache is not a dict: {type(snapshot)}")
+        manager.log(f"Could not load plugins snapshot: cache is not a dict: {type(snapshot)}")  # type: ignore[unreachable]
         return None
     return snapshot
 
@@ -1285,7 +1285,7 @@ def find_cache_meta(id: str, path: str,
     if meta is None:
         return None
     if not isinstance(meta, dict):
-        manager.log(f"Could not load cache for {id}: meta cache is not a dict: {repr(meta)}")
+        manager.log(f"Could not load cache for {id}: meta cache is not a dict: {repr(meta)}")  # type: ignore[unreachable]
         return None
     m = cache_meta_from_dict(meta, data_json)
     t2 = time.time()
@@ -2240,8 +2240,10 @@ class State:
         # TODO: Do this while constructing the AST?
         self.tree.names = SymbolTable()
         if not self.tree.is_stub:
-            # Always perform some low-key variable renaming
-            self.tree.accept(LimitedVariableRenameVisitor())
+            if not self.options.allow_redefinition_new:
+                # Perform some low-key variable renaming when assignments can't
+                # widen inferred types
+                self.tree.accept(LimitedVariableRenameVisitor())
             if options.allow_redefinition:
                 # Perform more renaming across the AST to allow variable redefinitions
                 self.tree.accept(VariableRenameVisitor())
diff -pruN 1.15.0-5/mypy/checker.py 1.16~rc0.1-1/mypy/checker.py
--- 1.15.0-5/mypy/checker.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/checker.py	2025-05-27 17:21:15.000000000 +0000
@@ -7,24 +7,25 @@ from collections import defaultdict
 from collections.abc import Iterable, Iterator, Mapping, Sequence, Set as AbstractSet
 from contextlib import ExitStack, contextmanager
 from typing import Callable, Final, Generic, NamedTuple, Optional, TypeVar, Union, cast, overload
-from typing_extensions import TypeAlias as _TypeAlias
+from typing_extensions import TypeAlias as _TypeAlias, TypeGuard
 
 import mypy.checkexpr
 from mypy import errorcodes as codes, join, message_registry, nodes, operators
 from mypy.binder import ConditionalTypeBinder, Frame, get_declaration
+from mypy.checker_shared import CheckerScope, TypeCheckerSharedApi, TypeRange
 from mypy.checkmember import (
     MemberContext,
-    analyze_decorator_or_funcbase_access,
-    analyze_descriptor_access,
+    analyze_class_attribute_access,
+    analyze_instance_member_access,
     analyze_member_access,
-    type_object_type,
+    is_instance_var,
 )
 from mypy.checkpattern import PatternChecker
 from mypy.constraints import SUPERTYPE_OF
 from mypy.erasetype import erase_type, erase_typevars, remove_instance_last_known_values
 from mypy.errorcodes import TYPE_VAR, UNUSED_AWAITABLE, UNUSED_COROUTINE, ErrorCode
 from mypy.errors import Errors, ErrorWatcher, report_internal_error
-from mypy.expandtype import expand_self_type, expand_type, expand_type_by_instance
+from mypy.expandtype import expand_type
 from mypy.literals import Key, extract_var_from_literal_hash, literal, literal_hash
 from mypy.maptype import map_instance_to_supertype
 from mypy.meet import is_overlapping_erased_types, is_overlapping_types, meet_types
@@ -56,6 +57,7 @@ from mypy.nodes import (
     LITERAL_TYPE,
     MDEF,
     NOT_ABSTRACT,
+    SYMBOL_FUNCBASE_TYPES,
     AssertStmt,
     AssignmentExpr,
     AssignmentStmt,
@@ -77,6 +79,7 @@ from mypy.nodes import (
     FuncBase,
     FuncDef,
     FuncItem,
+    GlobalDecl,
     IfStmt,
     Import,
     ImportAll,
@@ -92,6 +95,7 @@ from mypy.nodes import (
     MypyFile,
     NameExpr,
     Node,
+    NonlocalDecl,
     OperatorAssignmentStmt,
     OpExpr,
     OverloadedFuncDef,
@@ -123,7 +127,7 @@ from mypy.nodes import (
 from mypy.operators import flip_ops, int_op_to_method, neg_ops
 from mypy.options import PRECISE_TUPLE_TYPES, Options
 from mypy.patterns import AsPattern, StarredPattern
-from mypy.plugin import CheckerPluginInterface, Plugin
+from mypy.plugin import Plugin
 from mypy.plugins import dataclasses as dataclasses_plugin
 from mypy.scope import Scope
 from mypy.semanal import is_trivial_body, refers_to_fullname, set_callable_name
@@ -158,13 +162,13 @@ from mypy.typeops import (
     is_literal_type_like,
     is_singleton_type,
     make_simplified_union,
-    map_type_from_supertype,
     true_only,
     try_expanding_sum_type_to_union,
     try_getting_int_literals_from_type,
     try_getting_str_literals,
     try_getting_str_literals_from_type,
     tuple_fallback,
+    type_object_type,
 )
 from mypy.types import (
     ANY_STRATEGY,
@@ -213,22 +217,22 @@ from mypy.visitor import NodeVisitor
 
 T = TypeVar("T")
 
-DEFAULT_LAST_PASS: Final = 1  # Pass numbers start at 0
+DEFAULT_LAST_PASS: Final = 2  # Pass numbers start at 0
 
 # Maximum length of fixed tuple types inferred when narrowing from variadic tuples.
 MAX_PRECISE_TUPLE_SIZE: Final = 8
 
-DeferredNodeType: _TypeAlias = Union[FuncDef, LambdaExpr, OverloadedFuncDef, Decorator]
+DeferredNodeType: _TypeAlias = Union[FuncDef, OverloadedFuncDef, Decorator]
 FineGrainedDeferredNodeType: _TypeAlias = Union[FuncDef, MypyFile, OverloadedFuncDef]
 
 
 # A node which is postponed to be processed during the next pass.
 # In normal mode one can defer functions and methods (also decorated and/or overloaded)
-# and lambda expressions. Nested functions can't be deferred -- only top-level functions
+# but not lambda expressions. Nested functions can't be deferred -- only top-level functions
 # and methods of classes not defined within a function can be deferred.
 class DeferredNode(NamedTuple):
     node: DeferredNodeType
-    # And its TypeInfo (for semantic analysis self type handling
+    # And its TypeInfo (for semantic analysis self type handling)
     active_typeinfo: TypeInfo | None
 
 
@@ -255,13 +259,6 @@ class FineGrainedDeferredNode(NamedTuple
 TypeMap: _TypeAlias = Optional[dict[Expression, Type]]
 
 
-# An object that represents either a precise type or a type with an upper bound;
-# it is important for correct type inference with isinstance.
-class TypeRange(NamedTuple):
-    item: Type
-    is_upper_bound: bool  # False => precise type
-
-
 # Keeps track of partial types in a single scope. In fine-grained incremental
 # mode partial types initially defined at the top level cannot be completed in
 # a function, and we use the 'is_function' attribute to enforce this.
@@ -271,7 +268,7 @@ class PartialTypeScope(NamedTuple):
     is_local: bool
 
 
-class TypeChecker(NodeVisitor[None], CheckerPluginInterface):
+class TypeChecker(NodeVisitor[None], TypeCheckerSharedApi):
     """Mypy type checker.
 
     Type check mypy source files that have been semantically analyzed.
@@ -298,7 +295,7 @@ class TypeChecker(NodeVisitor[None], Che
     # Helper for managing conditional types
     binder: ConditionalTypeBinder
     # Helper for type checking expressions
-    expr_checker: mypy.checkexpr.ExpressionChecker
+    _expr_checker: mypy.checkexpr.ExpressionChecker
 
     pattern_checker: PatternChecker
 
@@ -313,6 +310,9 @@ class TypeChecker(NodeVisitor[None], Che
     # Vars for which partial type errors are already reported
     # (to avoid logically duplicate errors with different error context).
     partial_reported: set[Var]
+    # Short names of Var nodes whose previous inferred type has been widened via assignment.
+    # NOTE: The names might not be unique, they are only for debugging purposes.
+    widened_vars: list[str]
     globals: SymbolTable
     modules: dict[str, MypyFile]
     # Nodes that couldn't be checked because some types weren't available. We'll run
@@ -373,7 +373,7 @@ class TypeChecker(NodeVisitor[None], Che
         self.plugin = plugin
         self.tscope = Scope()
         self.scope = CheckerScope(tree)
-        self.binder = ConditionalTypeBinder()
+        self.binder = ConditionalTypeBinder(options)
         self.globals = tree.names
         self.return_types = []
         self.dynamic_funcs = []
@@ -381,6 +381,7 @@ class TypeChecker(NodeVisitor[None], Che
         self.partial_reported = set()
         self.var_decl_frames = {}
         self.deferred_nodes = []
+        self.widened_vars = []
         self._type_maps = [{}]
         self.module_refs = set()
         self.pass_num = 0
@@ -409,14 +410,18 @@ class TypeChecker(NodeVisitor[None], Che
         self.allow_abstract_call = False
 
         # Child checker objects for specific AST node types
-        self.expr_checker = mypy.checkexpr.ExpressionChecker(
+        self._expr_checker = mypy.checkexpr.ExpressionChecker(
             self, self.msg, self.plugin, per_line_checking_time_ns
         )
         self.pattern_checker = PatternChecker(self, self.msg, self.plugin, options)
 
     @property
+    def expr_checker(self) -> mypy.checkexpr.ExpressionChecker:
+        return self._expr_checker
+
+    @property
     def type_context(self) -> list[Type | None]:
-        return self.expr_checker.type_context
+        return self._expr_checker.type_context
 
     def reset(self) -> None:
         """Cleanup stale state that might be left over from a typechecking run.
@@ -427,17 +432,15 @@ class TypeChecker(NodeVisitor[None], Che
         # TODO: verify this is still actually worth it over creating new checkers
         self.partial_reported.clear()
         self.module_refs.clear()
-        self.binder = ConditionalTypeBinder()
+        self.binder = ConditionalTypeBinder(self.options)
         self._type_maps[1:] = []
         self._type_maps[0].clear()
         self.temp_type_map = None
         self.expr_checker.reset()
-
-        assert self.inferred_attribute_types is None
-        assert self.partial_types == []
-        assert self.deferred_nodes == []
-        assert len(self.scope.stack) == 1
-        assert self.partial_types == []
+        self.deferred_nodes = []
+        self.partial_types = []
+        self.inferred_attribute_types = None
+        self.scope = CheckerScope(self.tree)
 
     def check_first_pass(self) -> None:
         """Type check the entire file, but defer functions with unresolved references.
@@ -520,15 +523,13 @@ class TypeChecker(NodeVisitor[None], Che
             return True
 
     def check_partial(self, node: DeferredNodeType | FineGrainedDeferredNodeType) -> None:
+        self.widened_vars = []
         if isinstance(node, MypyFile):
             self.check_top_level(node)
         else:
             self.recurse_into_functions = True
             with self.binder.top_frame_context():
-                if isinstance(node, LambdaExpr):
-                    self.expr_checker.accept(node)
-                else:
-                    self.accept(node)
+                self.accept(node)
 
     def check_top_level(self, node: MypyFile) -> None:
         """Check only the top-level of a module, skipping function definitions."""
@@ -555,13 +556,13 @@ class TypeChecker(NodeVisitor[None], Che
         self.deferred_nodes.append(DeferredNode(node, enclosing_class))
 
     def handle_cannot_determine_type(self, name: str, context: Context) -> None:
-        node = self.scope.top_non_lambda_function()
+        node = self.scope.top_level_function()
         if self.pass_num < self.last_pass and isinstance(node, FuncDef):
             # Don't report an error yet. Just defer. Note that we don't defer
             # lambdas because they are coupled to the surrounding function
             # through the binder and the inferred type of the lambda, so it
             # would get messy.
-            enclosing_class = self.scope.enclosing_class()
+            enclosing_class = self.scope.enclosing_class(node)
             self.defer_node(node, enclosing_class)
             # Set a marker so that we won't infer additional types in this
             # function. Any inferred types could be bogus, because there's at
@@ -583,15 +584,19 @@ class TypeChecker(NodeVisitor[None], Che
         else_body: Statement | None = None,
         *,
         exit_condition: Expression | None = None,
+        on_enter_body: Callable[[], None] | None = None,
     ) -> None:
         """Repeatedly type check a loop body until the frame doesn't change."""
 
         # The outer frame accumulates the results of all iterations:
         with self.binder.frame_context(can_skip=False, conditional_frame=True):
-
             # Check for potential decreases in the number of partial types so as not to stop the
             # iteration too early:
             partials_old = sum(len(pts.map) for pts in self.partial_types)
+            # Check if assignment widened the inferred type of a variable; in this case we
+            # need to iterate again (we only do one extra iteration, since this could go
+            # on without bound otherwise)
+            widened_old = len(self.widened_vars)
 
             # Disable error types that we cannot safely identify in intermediate iteration steps:
             warn_unreachable = self.options.warn_unreachable
@@ -599,13 +604,32 @@ class TypeChecker(NodeVisitor[None], Che
             self.options.warn_unreachable = False
             self.options.enabled_error_codes.discard(codes.REDUNDANT_EXPR)
 
+            iter = 1
             while True:
                 with self.binder.frame_context(can_skip=True, break_frame=2, continue_frame=1):
+                    if on_enter_body is not None:
+                        on_enter_body()
+
                     self.accept(body)
                 partials_new = sum(len(pts.map) for pts in self.partial_types)
-                if (partials_new == partials_old) and not self.binder.last_pop_changed:
+                widened_new = len(self.widened_vars)
+                # Perform multiple iterations if something changed that might affect
+                # inferred types. Also limit the number of iterations. The limits are
+                # somewhat arbitrary, but they were chosen to 1) avoid slowdown from
+                # multiple iterations in common cases and 2) support common, valid use
+                # cases. Limits are needed since otherwise we could infer infinitely
+                # complex types.
+                if (
+                    (partials_new == partials_old)
+                    and (not self.binder.last_pop_changed or iter > 3)
+                    and (widened_new == widened_old or iter > 1)
+                ):
                     break
                 partials_old = partials_new
+                widened_old = widened_new
+                iter += 1
+                if iter == 20:
+                    raise RuntimeError("Too many iterations when checking a loop")
 
             # If necessary, reset the modified options and make up for the postponed error checks:
             self.options.warn_unreachable = warn_unreachable
@@ -613,6 +637,9 @@ class TypeChecker(NodeVisitor[None], Che
                 self.options.enabled_error_codes.add(codes.REDUNDANT_EXPR)
             if warn_unreachable or warn_redundant:
                 with self.binder.frame_context(can_skip=True, break_frame=2, continue_frame=1):
+                    if on_enter_body is not None:
+                        on_enter_body()
+
                     self.accept(body)
 
             # If exit_condition is set, assume it must be False on exit from the loop:
@@ -647,10 +674,36 @@ class TypeChecker(NodeVisitor[None], Che
             # HACK: Infer the type of the property.
             assert isinstance(defn.items[0], Decorator)
             self.visit_decorator(defn.items[0])
-        for fdef in defn.items:
+            if defn.items[0].var.is_settable_property:
+                # TODO: here and elsewhere we assume setter immediately follows getter.
+                assert isinstance(defn.items[1], Decorator)
+                # Perform a reduced visit just to infer the actual setter type.
+                self.visit_decorator_inner(defn.items[1], skip_first_item=True)
+                setter_type = defn.items[1].var.type
+                # Check if the setter can accept two positional arguments.
+                any_type = AnyType(TypeOfAny.special_form)
+                fallback_setter_type = CallableType(
+                    arg_types=[any_type, any_type],
+                    arg_kinds=[ARG_POS, ARG_POS],
+                    arg_names=[None, None],
+                    ret_type=any_type,
+                    fallback=self.named_type("builtins.function"),
+                )
+                if setter_type and not is_subtype(setter_type, fallback_setter_type):
+                    self.fail("Invalid property setter signature", defn.items[1].func)
+                setter_type = self.extract_callable_type(setter_type, defn)
+                if not isinstance(setter_type, CallableType) or len(setter_type.arg_types) != 2:
+                    # TODO: keep precise type for callables with tricky but valid signatures.
+                    setter_type = fallback_setter_type
+                defn.items[0].var.setter_type = setter_type
+        for i, fdef in enumerate(defn.items):
             assert isinstance(fdef, Decorator)
             if defn.is_property:
-                self.check_func_item(fdef.func, name=fdef.func.name, allow_empty=True)
+                assert isinstance(defn.items[0], Decorator)
+                settable = defn.items[0].var.is_settable_property
+                # Do not visit the second time the items we checked above.
+                if (settable and i > 1) or (not settable and i > 0):
+                    self.check_func_item(fdef.func, name=fdef.func.name, allow_empty=True)
             else:
                 # Perform full check for real overloads to infer type of all decorated
                 # overload variants.
@@ -672,6 +725,22 @@ class TypeChecker(NodeVisitor[None], Che
                         item_types.append(item_type)
                 if item_types:
                     defn.type = Overloaded(item_types)
+        elif defn.type is None:
+            # We store the getter type as an overall overload type, as some
+            # code paths are getting property type this way.
+            assert isinstance(defn.items[0], Decorator)
+            var_type = self.extract_callable_type(defn.items[0].var.type, defn)
+            if not isinstance(var_type, CallableType):
+                # Construct a fallback type, invalid types should be already reported.
+                any_type = AnyType(TypeOfAny.special_form)
+                var_type = CallableType(
+                    arg_types=[any_type],
+                    arg_kinds=[ARG_POS],
+                    arg_names=[None],
+                    ret_type=any_type,
+                    fallback=self.named_type("builtins.function"),
+                )
+            defn.type = Overloaded([var_type])
         # Check override validity after we analyzed current definition.
         if defn.info:
             found_method_base_classes = self.check_method_override(defn)
@@ -679,6 +748,9 @@ class TypeChecker(NodeVisitor[None], Che
                 defn.is_explicit_override
                 and not found_method_base_classes
                 and found_method_base_classes is not None
+                # If the class has Any fallback, we can't be certain that a method
+                # is really missing - it might come from unfollowed import.
+                and not defn.info.fallback_to_any
             ):
                 self.msg.no_overridable_method(defn.name, defn)
             self.check_explicit_override_decorator(defn, found_method_base_classes, defn.impl)
@@ -687,50 +759,56 @@ class TypeChecker(NodeVisitor[None], Che
     def extract_callable_type(self, inner_type: Type | None, ctx: Context) -> CallableType | None:
         """Get type as seen by an overload item caller."""
         inner_type = get_proper_type(inner_type)
-        outer_type: CallableType | None = None
-        if inner_type is not None and not isinstance(inner_type, AnyType):
-            if isinstance(inner_type, TypeVarLikeType):
-                inner_type = get_proper_type(inner_type.upper_bound)
-            if isinstance(inner_type, TypeType):
-                inner_type = get_proper_type(
-                    self.expr_checker.analyze_type_type_callee(inner_type.item, ctx)
-                )
-
-            if isinstance(inner_type, CallableType):
-                outer_type = inner_type
-            elif isinstance(inner_type, Instance):
-                inner_call = get_proper_type(
-                    analyze_member_access(
-                        name="__call__",
-                        typ=inner_type,
-                        context=ctx,
-                        is_lvalue=False,
-                        is_super=False,
-                        is_operator=True,
-                        msg=self.msg,
-                        original_type=inner_type,
-                        chk=self,
-                    )
-                )
-                if isinstance(inner_call, CallableType):
-                    outer_type = inner_call
-            elif isinstance(inner_type, UnionType):
-                union_type = make_simplified_union(inner_type.items)
-                if isinstance(union_type, UnionType):
-                    items = []
-                    for item in union_type.items:
-                        callable_item = self.extract_callable_type(item, ctx)
-                        if callable_item is None:
-                            break
-                        items.append(callable_item)
-                    else:
-                        joined_type = get_proper_type(join.join_type_list(items))
-                        if isinstance(joined_type, CallableType):
-                            outer_type = joined_type
+        outer_type: FunctionLike | None = None
+        if inner_type is None or isinstance(inner_type, AnyType):
+            return None
+        if isinstance(inner_type, TypeVarLikeType):
+            inner_type = get_proper_type(inner_type.upper_bound)
+        if isinstance(inner_type, TypeType):
+            inner_type = get_proper_type(
+                self.expr_checker.analyze_type_type_callee(inner_type.item, ctx)
+            )
+
+        if isinstance(inner_type, FunctionLike):
+            outer_type = inner_type
+        elif isinstance(inner_type, Instance):
+            inner_call = get_proper_type(
+                analyze_member_access(
+                    name="__call__",
+                    typ=inner_type,
+                    context=ctx,
+                    is_lvalue=False,
+                    is_super=False,
+                    is_operator=True,
+                    original_type=inner_type,
+                    chk=self,
+                )
+            )
+            if isinstance(inner_call, FunctionLike):
+                outer_type = inner_call
+        elif isinstance(inner_type, UnionType):
+            union_type = make_simplified_union(inner_type.items)
+            if isinstance(union_type, UnionType):
+                items = []
+                for item in union_type.items:
+                    callable_item = self.extract_callable_type(item, ctx)
+                    if callable_item is None:
+                        break
+                    items.append(callable_item)
                 else:
-                    return self.extract_callable_type(union_type, ctx)
-            if outer_type is None:
-                self.msg.not_callable(inner_type, ctx)
+                    joined_type = get_proper_type(join.join_type_list(items))
+                    if isinstance(joined_type, FunctionLike):
+                        outer_type = joined_type
+            else:
+                return self.extract_callable_type(union_type, ctx)
+
+        if outer_type is None:
+            self.msg.not_callable(inner_type, ctx)
+            return None
+        if isinstance(outer_type, Overloaded):
+            return None
+
+        assert isinstance(outer_type, CallableType)
         return outer_type
 
     def check_overlapping_overloads(self, defn: OverloadedFuncDef) -> None:
@@ -1081,6 +1159,7 @@ class TypeChecker(NodeVisitor[None], Che
         """
         self.dynamic_funcs.append(defn.is_dynamic() and not type_override)
 
+        enclosing_node_deferred = self.current_node_deferred
         with self.enter_partial_types(is_function=True):
             typ = self.function_type(defn)
             if type_override:
@@ -1092,7 +1171,7 @@ class TypeChecker(NodeVisitor[None], Che
                 raise RuntimeError("Not supported")
 
         self.dynamic_funcs.pop()
-        self.current_node_deferred = False
+        self.current_node_deferred = enclosing_node_deferred
 
         if name == "__exit__":
             self.check__exit__return_type(defn)
@@ -1162,7 +1241,7 @@ class TypeChecker(NodeVisitor[None], Che
         original_typ = typ
         for item, typ in expanded:
             old_binder = self.binder
-            self.binder = ConditionalTypeBinder()
+            self.binder = ConditionalTypeBinder(self.options)
             with self.binder.top_frame_context():
                 defn.expanded.append(item)
 
@@ -1350,6 +1429,17 @@ class TypeChecker(NodeVisitor[None], Che
                                 new_frame = self.binder.push_frame()
                             new_frame.types[key] = narrowed_type
                             self.binder.declarations[key] = old_binder.declarations[key]
+
+                if self.options.allow_redefinition_new and not self.is_stub:
+                    # Add formal argument types to the binder.
+                    for arg in defn.arguments:
+                        # TODO: Add these directly using a fast path (possibly "put")
+                        v = arg.variable
+                        if v.type is not None:
+                            n = NameExpr(v.name)
+                            n.node = v
+                            self.binder.assign_type(n, v.type, v.type)
+
                 with self.scope.push_function(defn):
                     # We suppress reachability warnings for empty generator functions
                     # (return; yield) which have a "yield" that's unreachable by definition
@@ -1465,6 +1555,10 @@ class TypeChecker(NodeVisitor[None], Che
         Note that this doesn't do a full CFG analysis but uses a line number based
         heuristic that isn't correct in some (rare) cases.
         """
+        if v.is_final:
+            # Final vars are definitely never reassigned.
+            return False
+
         outers = self.tscope.outer_functions()
         if not outers:
             # Top-level function -- outer context is top level, and we can't reason about
@@ -2042,6 +2136,21 @@ class TypeChecker(NodeVisitor[None], Che
                         return None
         return found_base_method
 
+    def check_setter_type_override(self, defn: OverloadedFuncDef, base: TypeInfo) -> None:
+        """Check override of a setter type of a mutable attribute.
+
+        Currently, this should be only called when either base node or the current node
+        is a custom settable property (i.e. where setter type is different from getter type).
+        Note that this check is contravariant.
+        """
+        typ, _ = self.node_type_from_base(defn.name, defn.info, defn, setter_type=True)
+        original_type, _ = self.node_type_from_base(defn.name, base, defn, setter_type=True)
+        # The caller should handle deferrals.
+        assert typ is not None and original_type is not None
+
+        if not is_subtype(original_type, typ):
+            self.msg.incompatible_setter_override(defn.items[1], typ, original_type, base)
+
     def check_method_override_for_base_with_name(
         self, defn: FuncDef | OverloadedFuncDef | Decorator, name: str, base: TypeInfo
     ) -> bool:
@@ -2050,215 +2159,169 @@ class TypeChecker(NodeVisitor[None], Che
         Return True if the supertype node was not analysed yet, and `defn` was deferred.
         """
         base_attr = base.names.get(name)
-        if base_attr:
-            # The name of the method is defined in the base class.
+        if not base_attr:
+            return False
+        # The name of the method is defined in the base class.
 
-            # Point errors at the 'def' line (important for backward compatibility
-            # of type ignores).
-            if not isinstance(defn, Decorator):
-                context = defn
-            else:
-                context = defn.func
-
-            # Construct the type of the overriding method.
-            # TODO: this logic is much less complete than similar one in checkmember.py
-            if isinstance(defn, (FuncDef, OverloadedFuncDef)):
-                typ: Type = self.function_type(defn)
-                override_class_or_static = defn.is_class or defn.is_static
-                override_class = defn.is_class
-            else:
-                assert defn.var.is_ready
-                assert defn.var.type is not None
-                typ = defn.var.type
-                override_class_or_static = defn.func.is_class or defn.func.is_static
-                override_class = defn.func.is_class
-            typ = get_proper_type(typ)
-            if isinstance(typ, FunctionLike) and not is_static(context):
-                typ = bind_self(typ, self.scope.active_self_type(), is_classmethod=override_class)
-            # Map the overridden method type to subtype context so that
-            # it can be checked for compatibility.
-            original_type = get_proper_type(base_attr.type)
-            original_node = base_attr.node
-            # `original_type` can be partial if (e.g.) it is originally an
-            # instance variable from an `__init__` block that becomes deferred.
-            if original_type is None or isinstance(original_type, PartialType):
-                if self.pass_num < self.last_pass:
-                    # If there are passes left, defer this node until next pass,
-                    # otherwise try reconstructing the method type from available information.
+        # Point errors at the 'def' line (important for backward compatibility
+        # of type ignores).
+        if not isinstance(defn, Decorator):
+            context = defn
+        else:
+            context = defn.func
+
+        # Construct the type of the overriding method.
+        if isinstance(defn, (FuncDef, OverloadedFuncDef)):
+            override_class_or_static = defn.is_class or defn.is_static
+        else:
+            override_class_or_static = defn.func.is_class or defn.func.is_static
+        typ, _ = self.node_type_from_base(defn.name, defn.info, defn)
+        assert typ is not None
+
+        original_node = base_attr.node
+        # `original_type` can be partial if (e.g.) it is originally an
+        # instance variable from an `__init__` block that becomes deferred.
+        supertype_ready = True
+        original_type, _ = self.node_type_from_base(name, base, defn)
+        if original_type is None:
+            supertype_ready = False
+            if self.pass_num < self.last_pass:
+                # If there are passes left, defer this node until next pass,
+                # otherwise try reconstructing the method type from available information.
+                # For consistency, defer an enclosing top-level function (if any).
+                top_level = self.scope.top_level_function()
+                if isinstance(top_level, FuncDef):
+                    self.defer_node(top_level, self.scope.enclosing_class(top_level))
+                else:
+                    # Specify enclosing class explicitly, as we check type override before
+                    # entering e.g. decorators or overloads.
                     self.defer_node(defn, defn.info)
-                    return True
-                elif isinstance(original_node, (FuncDef, OverloadedFuncDef)):
-                    original_type = self.function_type(original_node)
-                elif isinstance(original_node, Decorator):
-                    original_type = self.function_type(original_node.func)
-                elif isinstance(original_node, Var):
-                    # Super type can define method as an attribute.
-                    # See https://github.com/python/mypy/issues/10134
-
-                    # We also check that sometimes `original_node.type` is None.
-                    # This is the case when we use something like `__hash__ = None`.
-                    if original_node.type is not None:
-                        original_type = get_proper_type(original_node.type)
-                    else:
-                        original_type = NoneType()
+                return True
+            elif isinstance(original_node, (FuncDef, OverloadedFuncDef)):
+                original_type = self.function_type(original_node)
+            elif isinstance(original_node, Decorator):
+                original_type = self.function_type(original_node.func)
+            elif isinstance(original_node, Var):
+                # Super type can define method as an attribute.
+                # See https://github.com/python/mypy/issues/10134
+
+                # We also check that sometimes `original_node.type` is None.
+                # This is the case when we use something like `__hash__ = None`.
+                if original_node.type is not None:
+                    original_type = get_proper_type(original_node.type)
                 else:
-                    # Will always fail to typecheck below, since we know the node is a method
                     original_type = NoneType()
-            if isinstance(original_node, (FuncDef, OverloadedFuncDef)):
-                original_class_or_static = original_node.is_class or original_node.is_static
-            elif isinstance(original_node, Decorator):
-                fdef = original_node.func
-                original_class_or_static = fdef.is_class or fdef.is_static
             else:
-                original_class_or_static = False  # a variable can't be class or static
+                # Will always fail to typecheck below, since we know the node is a method
+                original_type = NoneType()
 
-            if isinstance(original_type, FunctionLike):
-                original_type = self.bind_and_map_method(base_attr, original_type, defn.info, base)
-                if original_node and is_property(original_node):
-                    original_type = get_property_type(original_type)
-
-            if isinstance(original_node, Var):
-                expanded_type = map_type_from_supertype(original_type, defn.info, base)
-                expanded_type = expand_self_type(
-                    original_node, expanded_type, fill_typevars(defn.info)
-                )
-                original_type = get_proper_type(expanded_type)
-
-            if is_property(defn):
-                inner: FunctionLike | None
-                if isinstance(typ, FunctionLike):
-                    inner = typ
-                else:
-                    inner = self.extract_callable_type(typ, context)
-                if inner is not None:
-                    typ = inner
-                    typ = get_property_type(typ)
-                    if (
-                        isinstance(original_node, Var)
-                        and not original_node.is_final
-                        and (not original_node.is_property or original_node.is_settable_property)
-                        and isinstance(defn, Decorator)
-                    ):
-                        # We only give an error where no other similar errors will be given.
-                        if not isinstance(original_type, AnyType):
-                            self.msg.fail(
-                                "Cannot override writeable attribute with read-only property",
-                                # Give an error on function line to match old behaviour.
-                                defn.func,
-                                code=codes.OVERRIDE,
-                            )
+        always_allow_covariant = False
+        if is_settable_property(defn) and (
+            is_settable_property(original_node) or isinstance(original_node, Var)
+        ):
+            if is_custom_settable_property(defn) or (is_custom_settable_property(original_node)):
+                # Unlike with getter, where we try to construct some fallback type in case of
+                # deferral during last_pass, we can't make meaningful setter checks if the
+                # supertype is not known precisely.
+                if supertype_ready:
+                    always_allow_covariant = True
+                    self.check_setter_type_override(defn, base)
+
+        if isinstance(original_node, (FuncDef, OverloadedFuncDef)):
+            original_class_or_static = original_node.is_class or original_node.is_static
+        elif isinstance(original_node, Decorator):
+            fdef = original_node.func
+            original_class_or_static = fdef.is_class or fdef.is_static
+        else:
+            original_class_or_static = False  # a variable can't be class or static
 
-            if isinstance(original_type, AnyType) or isinstance(typ, AnyType):
-                pass
-            elif isinstance(original_type, FunctionLike) and isinstance(typ, FunctionLike):
-                # Check that the types are compatible.
-                ok = self.check_override(
-                    typ,
-                    original_type,
-                    defn.name,
-                    name,
-                    base.name,
-                    original_class_or_static,
-                    override_class_or_static,
-                    context,
+        typ = get_proper_type(typ)
+        original_type = get_proper_type(original_type)
+
+        if (
+            is_property(defn)
+            and isinstance(original_node, Var)
+            and not original_node.is_final
+            and (not original_node.is_property or original_node.is_settable_property)
+            and isinstance(defn, Decorator)
+        ):
+            # We only give an error where no other similar errors will be given.
+            if not isinstance(original_type, AnyType):
+                self.msg.fail(
+                    "Cannot override writeable attribute with read-only property",
+                    # Give an error on function line to match old behaviour.
+                    defn.func,
+                    code=codes.OVERRIDE,
                 )
-                # Check if this override is covariant.
-                if (
-                    ok
-                    and original_node
-                    and codes.MUTABLE_OVERRIDE in self.options.enabled_error_codes
-                    and self.is_writable_attribute(original_node)
-                    and not is_subtype(original_type, typ, ignore_pos_arg_names=True)
-                ):
-                    base_str, override_str = format_type_distinctly(
-                        original_type, typ, options=self.options
-                    )
-                    msg = message_registry.COVARIANT_OVERRIDE_OF_MUTABLE_ATTRIBUTE.with_additional_msg(
-                        f' (base class "{base.name}" defined the type as {base_str},'
-                        f" override has type {override_str})"
-                    )
-                    self.fail(msg, context)
-            elif isinstance(original_type, UnionType) and any(
-                is_subtype(typ, orig_typ, ignore_pos_arg_names=True)
-                for orig_typ in original_type.items
+
+        if isinstance(original_type, AnyType) or isinstance(typ, AnyType):
+            pass
+        elif isinstance(original_type, FunctionLike) and isinstance(typ, FunctionLike):
+            # Check that the types are compatible.
+            ok = self.check_override(
+                typ,
+                original_type,
+                defn.name,
+                name,
+                base.name,
+                original_class_or_static,
+                override_class_or_static,
+                context,
+            )
+            # Check if this override is covariant.
+            if (
+                ok
+                and original_node
+                and codes.MUTABLE_OVERRIDE in self.options.enabled_error_codes
+                and self.is_writable_attribute(original_node)
+                and not always_allow_covariant
+                and not is_subtype(original_type, typ, ignore_pos_arg_names=True)
             ):
-                # This method is a subtype of at least one union variant.
-                if (
-                    original_node
-                    and codes.MUTABLE_OVERRIDE in self.options.enabled_error_codes
-                    and self.is_writable_attribute(original_node)
-                ):
-                    # Covariant override of mutable attribute.
-                    base_str, override_str = format_type_distinctly(
-                        original_type, typ, options=self.options
-                    )
-                    msg = message_registry.COVARIANT_OVERRIDE_OF_MUTABLE_ATTRIBUTE.with_additional_msg(
-                        f' (base class "{base.name}" defined the type as {base_str},'
-                        f" override has type {override_str})"
-                    )
-                    self.fail(msg, context)
-            elif is_equivalent(original_type, typ):
-                # Assume invariance for a non-callable attribute here. Note
-                # that this doesn't affect read-only properties which can have
-                # covariant overrides.
-                pass
-            elif (
+                base_str, override_str = format_type_distinctly(
+                    original_type, typ, options=self.options
+                )
+                msg = message_registry.COVARIANT_OVERRIDE_OF_MUTABLE_ATTRIBUTE.with_additional_msg(
+                    f' (base class "{base.name}" defined the type as {base_str},'
+                    f" override has type {override_str})"
+                )
+                self.fail(msg, context)
+        elif isinstance(original_type, UnionType) and any(
+            is_subtype(typ, orig_typ, ignore_pos_arg_names=True)
+            for orig_typ in original_type.items
+        ):
+            # This method is a subtype of at least one union variant.
+            if (
                 original_node
-                and not self.is_writable_attribute(original_node)
-                and is_subtype(typ, original_type)
+                and codes.MUTABLE_OVERRIDE in self.options.enabled_error_codes
+                and self.is_writable_attribute(original_node)
+                and not always_allow_covariant
             ):
-                # If the attribute is read-only, allow covariance
-                pass
-            else:
-                self.msg.signature_incompatible_with_supertype(
-                    defn.name, name, base.name, context, original=original_type, override=typ
-                )
-        return False
-
-    def bind_and_map_method(
-        self, sym: SymbolTableNode, typ: FunctionLike, sub_info: TypeInfo, super_info: TypeInfo
-    ) -> FunctionLike:
-        """Bind self-type and map type variables for a method.
-
-        Arguments:
-            sym: a symbol that points to method definition
-            typ: method type on the definition
-            sub_info: class where the method is used
-            super_info: class where the method was defined
-        """
-        if isinstance(sym.node, (FuncDef, OverloadedFuncDef, Decorator)) and not is_static(
-            sym.node
+                # Covariant override of mutable attribute.
+                base_str, override_str = format_type_distinctly(
+                    original_type, typ, options=self.options
+                )
+                msg = message_registry.COVARIANT_OVERRIDE_OF_MUTABLE_ATTRIBUTE.with_additional_msg(
+                    f' (base class "{base.name}" defined the type as {base_str},'
+                    f" override has type {override_str})"
+                )
+                self.fail(msg, context)
+        elif is_equivalent(original_type, typ):
+            # Assume invariance for a non-callable attribute here. Note
+            # that this doesn't affect read-only properties which can have
+            # covariant overrides.
+            pass
+        elif (
+            original_node
+            and (not self.is_writable_attribute(original_node) or always_allow_covariant)
+            and is_subtype(typ, original_type)
         ):
-            if isinstance(sym.node, Decorator):
-                is_class_method = sym.node.func.is_class
-            else:
-                is_class_method = sym.node.is_class
-
-            mapped_typ = cast(FunctionLike, map_type_from_supertype(typ, sub_info, super_info))
-            active_self_type = fill_typevars(sub_info)
-            if isinstance(mapped_typ, Overloaded):
-                # If we have an overload, filter to overloads that match the self type.
-                # This avoids false positives for concrete subclasses of generic classes,
-                # see testSelfTypeOverrideCompatibility for an example.
-                filtered_items = []
-                for item in mapped_typ.items:
-                    if not item.arg_types:
-                        filtered_items.append(item)
-                    item_arg = item.arg_types[0]
-                    if isinstance(item_arg, TypeVarType):
-                        item_arg = item_arg.upper_bound
-                    if is_subtype(active_self_type, item_arg):
-                        filtered_items.append(item)
-                # If we don't have any filtered_items, maybe it's always a valid override
-                # of the superclass? However if you get to that point you're in murky type
-                # territory anyway, so we just preserve the type and have the behaviour match
-                # that of older versions of mypy.
-                if filtered_items:
-                    mapped_typ = Overloaded(filtered_items)
-
-            return bind_self(mapped_typ, active_self_type, is_class_method)
+            # If the attribute is read-only, allow covariance
+            pass
         else:
-            return cast(FunctionLike, map_type_from_supertype(typ, sub_info, super_info))
+            self.msg.signature_incompatible_with_supertype(
+                defn.name, name, base.name, context, original=original_type, override=typ
+            )
+        return False
 
     def get_op_other_domain(self, tp: FunctionLike) -> Type | None:
         if isinstance(tp, CallableType):
@@ -2472,7 +2535,7 @@ class TypeChecker(NodeVisitor[None], Che
                 self.fail(message_registry.CANNOT_INHERIT_FROM_FINAL.format(base.name), defn)
         with self.tscope.class_scope(defn.info), self.enter_partial_types(is_class=True):
             old_binder = self.binder
-            self.binder = ConditionalTypeBinder()
+            self.binder = ConditionalTypeBinder(self.options)
             with self.binder.top_frame_context():
                 with self.scope.push_class(defn.info):
                     self.accept(defn.defs)
@@ -2633,10 +2696,8 @@ class TypeChecker(NodeVisitor[None], Che
         self.check_enum_new(defn)
 
     def check_final_enum(self, defn: ClassDef, base: TypeInfo) -> None:
-        for sym in base.names.values():
-            if self.is_final_enum_value(sym):
-                self.fail(f'Cannot extend enum with existing members: "{base.name}"', defn)
-                break
+        if base.enum_members:
+            self.fail(f'Cannot extend enum with existing members: "{base.name}"', defn)
 
     def is_final_enum_value(self, sym: SymbolTableNode) -> bool:
         if isinstance(sym.node, (FuncBase, Decorator)):
@@ -2778,9 +2839,10 @@ class TypeChecker(NodeVisitor[None], Che
                     self.check_compatibility(name, base, base2, typ)
 
     def determine_type_of_member(self, sym: SymbolTableNode) -> Type | None:
+        # TODO: this duplicates both checkmember.py and analyze_ref_expr(), delete.
         if sym.type is not None:
             return sym.type
-        if isinstance(sym.node, FuncBase):
+        if isinstance(sym.node, SYMBOL_FUNCBASE_TYPES):
             return self.function_type(sym.node)
         if isinstance(sym.node, TypeInfo):
             if sym.node.typeddict_type:
@@ -2797,7 +2859,6 @@ class TypeChecker(NodeVisitor[None], Che
                 # Suppress any errors, they will be given when analyzing the corresponding node.
                 # Here we may have incorrect options and location context.
                 return self.expr_checker.alias_type_in_runtime_context(sym.node, ctx=sym.node)
-        # TODO: handle more node kinds here.
         return None
 
     def check_compatibility(
@@ -2828,49 +2889,47 @@ class TypeChecker(NodeVisitor[None], Che
             return
         first = base1.names[name]
         second = base2.names[name]
-        first_type = get_proper_type(self.determine_type_of_member(first))
-        second_type = get_proper_type(self.determine_type_of_member(second))
+        # Specify current_class explicitly as this function is called after leaving the class.
+        first_type, _ = self.node_type_from_base(name, base1, ctx, current_class=ctx)
+        second_type, _ = self.node_type_from_base(name, base2, ctx, current_class=ctx)
 
         # TODO: use more principled logic to decide is_subtype() vs is_equivalent().
         # We should rely on mutability of superclass node, not on types being Callable.
+        # (in particular handle settable properties with setter type different from getter).
 
-        # start with the special case that Instance can be a subtype of FunctionLike
-        call = None
-        if isinstance(first_type, Instance):
-            call = find_member("__call__", first_type, first_type, is_operator=True)
-        if call and isinstance(second_type, FunctionLike):
-            second_sig = self.bind_and_map_method(second, second_type, ctx, base2)
-            ok = is_subtype(call, second_sig, ignore_pos_arg_names=True)
-        elif isinstance(first_type, FunctionLike) and isinstance(second_type, FunctionLike):
-            if first_type.is_type_obj() and second_type.is_type_obj():
+        p_first_type = get_proper_type(first_type)
+        p_second_type = get_proper_type(second_type)
+        if isinstance(p_first_type, FunctionLike) and isinstance(p_second_type, FunctionLike):
+            if p_first_type.is_type_obj() and p_second_type.is_type_obj():
                 # For class objects only check the subtype relationship of the classes,
                 # since we allow incompatible overrides of '__init__'/'__new__'
                 ok = is_subtype(
-                    left=fill_typevars_with_any(first_type.type_object()),
-                    right=fill_typevars_with_any(second_type.type_object()),
+                    left=fill_typevars_with_any(p_first_type.type_object()),
+                    right=fill_typevars_with_any(p_second_type.type_object()),
                 )
             else:
-                # First bind/map method types when necessary.
-                first_sig = self.bind_and_map_method(first, first_type, ctx, base1)
-                second_sig = self.bind_and_map_method(second, second_type, ctx, base2)
-                ok = is_subtype(first_sig, second_sig, ignore_pos_arg_names=True)
+                assert first_type and second_type
+                ok = is_subtype(first_type, second_type, ignore_pos_arg_names=True)
         elif first_type and second_type:
-            if isinstance(first.node, Var):
-                first_type = get_proper_type(map_type_from_supertype(first_type, ctx, base1))
-                first_type = expand_self_type(first.node, first_type, fill_typevars(ctx))
-            if isinstance(second.node, Var):
-                second_type = get_proper_type(map_type_from_supertype(second_type, ctx, base2))
-                second_type = expand_self_type(second.node, second_type, fill_typevars(ctx))
-            ok = is_equivalent(first_type, second_type)
-            if not ok:
-                second_node = base2[name].node
+            if second.node is not None and not self.is_writable_attribute(second.node):
+                ok = is_subtype(first_type, second_type)
+            else:
+                ok = is_equivalent(first_type, second_type)
+            if ok:
                 if (
-                    isinstance(second_type, FunctionLike)
-                    and second_node is not None
-                    and is_property(second_node)
+                    first.node
+                    and second.node
+                    and self.is_writable_attribute(second.node)
+                    and is_property(first.node)
+                    and isinstance(first.node, Decorator)
+                    and not isinstance(p_second_type, AnyType)
                 ):
-                    second_type = get_property_type(second_type)
-                    ok = is_subtype(first_type, second_type)
+                    self.msg.fail(
+                        f'Cannot override writeable attribute "{name}" in base "{base2.name}"'
+                        f' with read-only property in base "{base1.name}"',
+                        ctx,
+                        code=codes.OVERRIDE,
+                    )
         else:
             if first_type is None:
                 self.msg.cannot_determine_type_in_base(name, base1.name, ctx)
@@ -3078,7 +3137,7 @@ class TypeChecker(NodeVisitor[None], Che
             )
         else:
             self.try_infer_partial_generic_type_from_assignment(lvalue, rvalue, "=")
-            lvalue_type, index_lvalue, inferred = self.check_lvalue(lvalue)
+            lvalue_type, index_lvalue, inferred = self.check_lvalue(lvalue, rvalue)
             # If we're assigning to __getattr__ or similar methods, check that the signature is
             # valid.
             if isinstance(lvalue, NameExpr) and lvalue.node:
@@ -3106,16 +3165,6 @@ class TypeChecker(NodeVisitor[None], Che
                     if active_class and dataclasses_plugin.is_processed_dataclass(active_class):
                         self.fail(message_registry.DATACLASS_POST_INIT_MUST_BE_A_FUNCTION, rvalue)
 
-            # Defer PartialType's super type checking.
-            if (
-                isinstance(lvalue, RefExpr)
-                and not (isinstance(lvalue_type, PartialType) and lvalue_type.type is None)
-                and not (isinstance(lvalue, NameExpr) and lvalue.name == "__match_args__")
-            ):
-                if self.check_compatibility_all_supers(lvalue, lvalue_type, rvalue):
-                    # We hit an error on this line; don't check for any others
-                    return
-
             if isinstance(lvalue, MemberExpr) and lvalue.name == "__match_args__":
                 self.fail(message_registry.CANNOT_MODIFY_MATCH_ARGS, lvalue)
 
@@ -3129,7 +3178,9 @@ class TypeChecker(NodeVisitor[None], Che
                         return
 
                     var = lvalue_type.var
-                    if is_valid_inferred_type(rvalue_type, is_lvalue_final=var.is_final):
+                    if is_valid_inferred_type(
+                        rvalue_type, self.options, is_lvalue_final=var.is_final
+                    ):
                         partial_types = self.find_partial_types(var)
                         if partial_types is not None:
                             if not self.current_node_deferred:
@@ -3145,12 +3196,6 @@ class TypeChecker(NodeVisitor[None], Che
                         # Try to infer a partial type. No need to check the return value, as
                         # an error will be reported elsewhere.
                         self.infer_partial_type(lvalue_type.var, lvalue, rvalue_type)
-                    # Handle None PartialType's super type checking here, after it's resolved.
-                    if isinstance(lvalue, RefExpr) and self.check_compatibility_all_supers(
-                        lvalue, lvalue_type, rvalue
-                    ):
-                        # We hit an error on this line; don't check for any others
-                        return
                 elif (
                     is_literal_none(rvalue)
                     and isinstance(lvalue, NameExpr)
@@ -3165,7 +3210,7 @@ class TypeChecker(NodeVisitor[None], Che
                 ):  # Ignore member access to modules
                     instance_type = self.expr_checker.accept(lvalue.expr)
                     rvalue_type, lvalue_type, infer_lvalue_type = self.check_member_assignment(
-                        instance_type, lvalue_type, rvalue, context=rvalue
+                        lvalue, instance_type, lvalue_type, rvalue, context=rvalue
                     )
                 else:
                     # Hacky special case for assigning a literal None
@@ -3175,7 +3220,8 @@ class TypeChecker(NodeVisitor[None], Che
                     # unpleasant, and a generalization of this would
                     # be an improvement!
                     if (
-                        is_literal_none(rvalue)
+                        not self.options.allow_redefinition_new
+                        and is_literal_none(rvalue)
                         and isinstance(lvalue, NameExpr)
                         and lvalue.kind == LDEF
                         and isinstance(lvalue.node, Var)
@@ -3195,7 +3241,12 @@ class TypeChecker(NodeVisitor[None], Che
                             lvalue_type = make_optional_type(lvalue_type)
                             self.set_inferred_type(lvalue.node, lvalue, lvalue_type)
 
-                    rvalue_type = self.check_simple_assignment(lvalue_type, rvalue, context=rvalue)
+                    rvalue_type, lvalue_type = self.check_simple_assignment(
+                        lvalue_type, rvalue, context=rvalue, inferred=inferred, lvalue=lvalue
+                    )
+                    # The above call may update inferred variable type. Prevent further
+                    # inference.
+                    inferred = None
 
                 # Special case: only non-abstract non-protocol classes can be assigned to
                 # variables with explicit type Type[A], where A is protocol or abstract.
@@ -3219,7 +3270,7 @@ class TypeChecker(NodeVisitor[None], Che
                 if rvalue_type and infer_lvalue_type and not isinstance(lvalue_type, PartialType):
                     # Don't use type binder for definitions of special forms, like named tuples.
                     if not (isinstance(lvalue, NameExpr) and lvalue.is_special_form):
-                        self.binder.assign_type(lvalue, rvalue_type, lvalue_type, False)
+                        self.binder.assign_type(lvalue, rvalue_type, lvalue_type)
                         if (
                             isinstance(lvalue, NameExpr)
                             and isinstance(lvalue.node, Var)
@@ -3228,12 +3279,15 @@ class TypeChecker(NodeVisitor[None], Che
                             and lvalue_type is not None
                         ):
                             lvalue.node.type = remove_instance_last_known_values(lvalue_type)
+                elif self.options.allow_redefinition_new and lvalue_type is not None:
+                    # TODO: Can we use put() here?
+                    self.binder.assign_type(lvalue, lvalue_type, lvalue_type)
 
             elif index_lvalue:
                 self.check_indexed_assignment(index_lvalue, rvalue, lvalue)
 
             if inferred:
-                type_context = self.get_variable_type_context(inferred)
+                type_context = self.get_variable_type_context(inferred, rvalue)
                 rvalue_type = self.expr_checker.accept(rvalue, type_context=type_context)
                 if not (
                     inferred.is_final
@@ -3243,15 +3297,34 @@ class TypeChecker(NodeVisitor[None], Che
                     rvalue_type = remove_instance_last_known_values(rvalue_type)
                 self.infer_variable_type(inferred, lvalue, rvalue_type, rvalue)
             self.check_assignment_to_slots(lvalue)
+            if isinstance(lvalue, RefExpr) and not (
+                isinstance(lvalue, NameExpr) and lvalue.name == "__match_args__"
+            ):
+                # We check override here at the end after storing the inferred type, since
+                # override check will try to access the current attribute via symbol tables
+                # (like a regular attribute access).
+                self.check_compatibility_all_supers(lvalue, rvalue)
 
     # (type, operator) tuples for augmented assignments supported with partial types
     partial_type_augmented_ops: Final = {("builtins.list", "+"), ("builtins.set", "|")}
 
-    def get_variable_type_context(self, inferred: Var) -> Type | None:
+    def get_variable_type_context(self, inferred: Var, rvalue: Expression) -> Type | None:
         type_contexts = []
         if inferred.info:
             for base in inferred.info.mro[1:]:
-                base_type, base_node = self.lvalue_type_from_base(inferred, base)
+                if inferred.name not in base.names:
+                    continue
+                # For inference within class body, get supertype attribute as it would look on
+                # a class object for lambdas overriding methods, etc.
+                base_node = base.names[inferred.name].node
+                base_type, _ = self.node_type_from_base(
+                    inferred.name,
+                    base,
+                    inferred,
+                    is_class=is_method(base_node)
+                    or isinstance(base_node, Var)
+                    and not is_instance_var(base_node),
+                )
                 if (
                     base_type
                     and not (isinstance(base_node, Var) and base_node.invalid_partial_type)
@@ -3309,22 +3382,30 @@ class TypeChecker(NodeVisitor[None], Che
             rvalue_type = self.expr_checker.accept(rvalue)
             rvalue_type = get_proper_type(rvalue_type)
             if isinstance(rvalue_type, Instance):
-                if rvalue_type.type == typ.type and is_valid_inferred_type(rvalue_type):
+                if rvalue_type.type == typ.type and is_valid_inferred_type(
+                    rvalue_type, self.options
+                ):
                     var.type = rvalue_type
                     del partial_types[var]
             elif isinstance(rvalue_type, AnyType):
                 var.type = fill_typevars_with_any(typ.type)
                 del partial_types[var]
 
-    def check_compatibility_all_supers(
-        self, lvalue: RefExpr, lvalue_type: Type | None, rvalue: Expression
-    ) -> bool:
+    def check_compatibility_all_supers(self, lvalue: RefExpr, rvalue: Expression) -> None:
         lvalue_node = lvalue.node
         # Check if we are a class variable with at least one base class
         if (
             isinstance(lvalue_node, Var)
-            and lvalue.kind in (MDEF, None)
-            and len(lvalue_node.info.bases) > 0  # None for Vars defined via self
+            # If we have explicit annotation, there is no point in checking the override
+            # for each assignment, so we check only for the first one.
+            # TODO: for some reason annotated attributes on self are stored as inferred vars.
+            and (
+                lvalue_node.line == lvalue.line
+                or lvalue_node.is_inferred
+                and not lvalue_node.explicit_self_type
+            )
+            and lvalue.kind in (MDEF, None)  # None for Vars defined via self
+            and len(lvalue_node.info.bases) > 0
         ):
             for base in lvalue_node.info.mro[1:]:
                 tnode = base.names.get(lvalue_node.name)
@@ -3340,6 +3421,21 @@ class TypeChecker(NodeVisitor[None], Che
             direct_bases = lvalue_node.info.direct_base_classes()
             last_immediate_base = direct_bases[-1] if direct_bases else None
 
+            # The historical behavior for inferred vars was to compare rvalue type against
+            # the type declared in a superclass. To preserve this behavior, we temporarily
+            # store the rvalue type on the variable.
+            actual_lvalue_type = None
+            if lvalue_node.is_inferred and not lvalue_node.explicit_self_type:
+                rvalue_type = self.expr_checker.accept(rvalue, lvalue_node.type)
+                actual_lvalue_type = lvalue_node.type
+                lvalue_node.type = rvalue_type
+            lvalue_type, _ = self.node_type_from_base(lvalue_node.name, lvalue_node.info, lvalue)
+            if lvalue_node.is_inferred and not lvalue_node.explicit_self_type:
+                lvalue_node.type = actual_lvalue_type
+
+            if not lvalue_type:
+                return
+
             for base in lvalue_node.info.mro[1:]:
                 # The type of "__slots__" and some other attributes usually doesn't need to
                 # be compatible with a base class. We'll still check the type of "__slots__"
@@ -3352,147 +3448,135 @@ class TypeChecker(NodeVisitor[None], Che
                 if is_private(lvalue_node.name):
                     continue
 
-                base_type, base_node = self.lvalue_type_from_base(lvalue_node, base)
+                base_type, base_node = self.node_type_from_base(lvalue_node.name, base, lvalue)
+                custom_setter = is_custom_settable_property(base_node)
                 if isinstance(base_type, PartialType):
                     base_type = None
 
                 if base_type:
                     assert base_node is not None
                     if not self.check_compatibility_super(
-                        lvalue, lvalue_type, rvalue, base, base_type, base_node
+                        lvalue_type,
+                        rvalue,
+                        base,
+                        base_type,
+                        base_node,
+                        always_allow_covariant=custom_setter,
                     ):
                         # Only show one error per variable; even if other
                         # base classes are also incompatible
-                        return True
+                        return
+                    if lvalue_type and custom_setter:
+                        base_type, _ = self.node_type_from_base(
+                            lvalue_node.name, base, lvalue, setter_type=True
+                        )
+                        # Setter type for a custom property must be ready if
+                        # the getter type is ready.
+                        assert base_type is not None
+                        if not is_subtype(base_type, lvalue_type):
+                            self.msg.incompatible_setter_override(
+                                lvalue, lvalue_type, base_type, base
+                            )
+                            return
                     if base is last_immediate_base:
                         # At this point, the attribute was found to be compatible with all
                         # immediate parents.
                         break
-        return False
 
     def check_compatibility_super(
         self,
-        lvalue: RefExpr,
-        lvalue_type: Type | None,
+        compare_type: Type,
         rvalue: Expression,
         base: TypeInfo,
         base_type: Type,
         base_node: Node,
+        always_allow_covariant: bool,
     ) -> bool:
-        lvalue_node = lvalue.node
-        assert isinstance(lvalue_node, Var)
-
-        # Do not check whether the rvalue is compatible if the
-        # lvalue had a type defined; this is handled by other
-        # parts, and all we have to worry about in that case is
-        # that lvalue is compatible with the base class.
-        compare_node = None
-        if lvalue_type:
-            compare_type = lvalue_type
-            compare_node = lvalue.node
-        else:
-            compare_type = self.expr_checker.accept(rvalue, base_type)
-            if isinstance(rvalue, NameExpr):
-                compare_node = rvalue.node
-                if isinstance(compare_node, Decorator):
-                    compare_node = compare_node.func
-
-        base_type = get_proper_type(base_type)
-        compare_type = get_proper_type(compare_type)
-        if compare_type:
-            if isinstance(base_type, CallableType) and isinstance(compare_type, CallableType):
-                base_static = is_node_static(base_node)
-                compare_static = is_node_static(compare_node)
-
-                # In case compare_static is unknown, also check
-                # if 'definition' is set. The most common case for
-                # this is with TempNode(), where we lose all
-                # information about the real rvalue node (but only get
-                # the rvalue type)
-                if compare_static is None and compare_type.definition:
-                    compare_static = is_node_static(compare_type.definition)
-
-                # Compare against False, as is_node_static can return None
-                if base_static is False and compare_static is False:
-                    # Class-level function objects and classmethods become bound
-                    # methods: the former to the instance, the latter to the
-                    # class
-                    base_type = bind_self(base_type, self.scope.active_self_type())
-                    compare_type = bind_self(compare_type, self.scope.active_self_type())
-
-                # If we are a static method, ensure to also tell the
-                # lvalue it now contains a static method
-                if base_static and compare_static:
-                    lvalue_node.is_staticmethod = True
-
+        # TODO: check __set__() type override for custom descriptors.
+        # TODO: for descriptors check also class object access override.
+        ok = self.check_subtype(
+            compare_type,
+            base_type,
+            rvalue,
+            message_registry.INCOMPATIBLE_TYPES_IN_ASSIGNMENT,
+            "expression has type",
+            f'base class "{base.name}" defined the type as',
+        )
+        if (
+            ok
+            and codes.MUTABLE_OVERRIDE in self.options.enabled_error_codes
+            and self.is_writable_attribute(base_node)
+            and not always_allow_covariant
+        ):
             ok = self.check_subtype(
-                compare_type,
                 base_type,
+                compare_type,
                 rvalue,
-                message_registry.INCOMPATIBLE_TYPES_IN_ASSIGNMENT,
-                "expression has type",
+                message_registry.COVARIANT_OVERRIDE_OF_MUTABLE_ATTRIBUTE,
                 f'base class "{base.name}" defined the type as',
+                "expression has type",
             )
-            if (
-                ok
-                and codes.MUTABLE_OVERRIDE in self.options.enabled_error_codes
-                and self.is_writable_attribute(base_node)
-            ):
-                ok = self.check_subtype(
-                    base_type,
-                    compare_type,
-                    rvalue,
-                    message_registry.COVARIANT_OVERRIDE_OF_MUTABLE_ATTRIBUTE,
-                    f'base class "{base.name}" defined the type as',
-                    "expression has type",
-                )
-            return ok
-        return True
+        return ok
 
-    def lvalue_type_from_base(
-        self, expr_node: Var, base: TypeInfo
-    ) -> tuple[Type | None, Node | None]:
-        """For a NameExpr that is part of a class, walk all base classes and try
-        to find the first class that defines a Type for the same name."""
-        expr_name = expr_node.name
-        base_var = base.names.get(expr_name)
-
-        if base_var:
-            base_node = base_var.node
-            base_type = base_var.type
-            if isinstance(base_node, Var) and base_type is not None:
-                base_type = expand_self_type(base_node, base_type, fill_typevars(expr_node.info))
-            if isinstance(base_node, Decorator):
-                base_node = base_node.func
-                base_type = base_node.type
-
-            if base_type:
-                if not has_no_typevars(base_type):
-                    self_type = self.scope.active_self_type()
-                    assert self_type is not None, "Internal error: base lookup outside class"
-                    if isinstance(self_type, TupleType):
-                        instance = tuple_fallback(self_type)
-                    else:
-                        instance = self_type
-                    itype = map_instance_to_supertype(instance, base)
-                    base_type = expand_type_by_instance(base_type, itype)
-
-                base_type = get_proper_type(base_type)
-                if isinstance(base_type, CallableType) and isinstance(base_node, FuncDef):
-                    # If we are a property, return the Type of the return
-                    # value, not the Callable
-                    if base_node.is_property:
-                        base_type = get_proper_type(base_type.ret_type)
-                if isinstance(base_type, FunctionLike) and isinstance(
-                    base_node, OverloadedFuncDef
-                ):
-                    # Same for properties with setter
-                    if base_node.is_property:
-                        base_type = base_type.items[0].ret_type
+    def node_type_from_base(
+        self,
+        name: str,
+        base: TypeInfo,
+        context: Context,
+        *,
+        setter_type: bool = False,
+        is_class: bool = False,
+        current_class: TypeInfo | None = None,
+    ) -> tuple[Type | None, SymbolNode | None]:
+        """Find a type for a name in base class.
+
+        Return the type found and the corresponding node defining the name or None
+        for both if the name is not defined in base or the node type is not known (yet).
+        The type returned is already properly mapped/bound to the subclass.
+        If setter_type is True, return setter types for settable properties (otherwise the
+        getter type is returned).
+        """
+        base_node = base.names.get(name)
 
-                return base_type, base_node
+        # TODO: defer current node if the superclass node is not ready.
+        if (
+            not base_node
+            or isinstance(base_node.node, (Var, Decorator))
+            and not base_node.type
+            or isinstance(base_node.type, PartialType)
+            and base_node.type.type is not None
+        ):
+            return None, None
 
-        return None, None
+        if current_class is None:
+            self_type = self.scope.current_self_type()
+        else:
+            self_type = fill_typevars(current_class)
+        assert self_type is not None, "Internal error: base lookup outside class"
+        if isinstance(self_type, TupleType):
+            instance = tuple_fallback(self_type)
+        else:
+            instance = self_type
+
+        mx = MemberContext(
+            is_lvalue=setter_type,
+            is_super=False,
+            is_operator=mypy.checkexpr.is_operator_method(name),
+            original_type=self_type,
+            context=context,
+            chk=self,
+            suppress_errors=True,
+        )
+        # TODO: we should not filter "cannot determine type" errors here.
+        with self.msg.filter_errors(filter_deprecated=True):
+            if is_class:
+                fallback = instance.type.metaclass_type or mx.named_type("builtins.type")
+                base_type = analyze_class_attribute_access(
+                    instance, name, mx, mcs_fallback=fallback, override_info=base
+                )
+            else:
+                base_type = analyze_instance_member_access(name, instance, mx, base)
+        return base_type, base_node.node
 
     def check_compatibility_classvar_super(
         self, node: Var, base: TypeInfo, base_node: Node | None
@@ -3924,7 +4008,7 @@ class TypeChecker(NodeVisitor[None], Che
             if isinstance(expr, StarExpr):
                 expr = expr.expr
 
-            # TODO: See todo in binder.py, ConditionalTypeBinder.assign_type
+            # TODO: See comment in binder.py, ConditionalTypeBinder.assign_type
             # It's unclear why the 'declared_type' param is sometimes 'None'
             clean_items: list[tuple[Type, Type]] = []
             for type, declared_type in items:
@@ -3936,7 +4020,6 @@ class TypeChecker(NodeVisitor[None], Che
                 expr,
                 make_simplified_union(list(types)),
                 make_simplified_union(list(declared_types)),
-                False,
             )
         for union, lv in zip(union_types, self.flatten_lvalues(lvalues)):
             # Properly store the inferred types.
@@ -4138,7 +4221,9 @@ class TypeChecker(NodeVisitor[None], Che
         else:
             self.msg.type_not_iterable(rvalue_type, context)
 
-    def check_lvalue(self, lvalue: Lvalue) -> tuple[Type | None, IndexExpr | None, Var | None]:
+    def check_lvalue(
+        self, lvalue: Lvalue, rvalue: Expression | None = None
+    ) -> tuple[Type | None, IndexExpr | None, Var | None]:
         lvalue_type = None
         index_lvalue = None
         inferred = None
@@ -4156,10 +4241,16 @@ class TypeChecker(NodeVisitor[None], Che
         elif isinstance(lvalue, IndexExpr):
             index_lvalue = lvalue
         elif isinstance(lvalue, MemberExpr):
-            lvalue_type = self.expr_checker.analyze_ordinary_member_access(lvalue, True)
+            lvalue_type = self.expr_checker.analyze_ordinary_member_access(lvalue, True, rvalue)
             self.store_type(lvalue, lvalue_type)
         elif isinstance(lvalue, NameExpr):
             lvalue_type = self.expr_checker.analyze_ref_expr(lvalue, lvalue=True)
+            if (
+                self.options.allow_redefinition_new
+                and isinstance(lvalue.node, Var)
+                and lvalue.node.is_inferred
+            ):
+                inferred = lvalue.node
             self.store_type(lvalue, lvalue_type)
         elif isinstance(lvalue, (TupleExpr, ListExpr)):
             types = [
@@ -4200,14 +4291,19 @@ class TypeChecker(NodeVisitor[None], Che
         if isinstance(init_type, DeletedType):
             self.msg.deleted_as_rvalue(init_type, context)
         elif (
-            not is_valid_inferred_type(init_type, is_lvalue_final=name.is_final)
+            not is_valid_inferred_type(
+                init_type,
+                self.options,
+                is_lvalue_final=name.is_final,
+                is_lvalue_member=isinstance(lvalue, MemberExpr),
+            )
             and not self.no_partial_types
         ):
             # We cannot use the type of the initialization expression for full type
             # inference (it's not specific enough), but we might be able to give
             # partial type which will be made more specific later. A partial type
             # gets generated in assignment like 'x = []' where item type is not known.
-            if not self.infer_partial_type(name, lvalue, init_type):
+            if name.name != "_" and not self.infer_partial_type(name, lvalue, init_type):
                 self.msg.need_annotation_for_var(name, context, self.options.python_version)
                 self.set_inference_error_fallback_type(name, lvalue, init_type)
         elif (
@@ -4227,10 +4323,16 @@ class TypeChecker(NodeVisitor[None], Che
             init_type = strip_type(init_type)
 
             self.set_inferred_type(name, lvalue, init_type)
+            if self.options.allow_redefinition_new:
+                self.binder.assign_type(lvalue, init_type, init_type)
 
     def infer_partial_type(self, name: Var, lvalue: Lvalue, init_type: Type) -> bool:
         init_type = get_proper_type(init_type)
-        if isinstance(init_type, NoneType):
+        if isinstance(init_type, NoneType) and (
+            isinstance(lvalue, MemberExpr) or not self.options.allow_redefinition_new
+        ):
+            # When using --allow-redefinition-new, None types aren't special
+            # when inferring simple variable types.
             partial_type = PartialType(None, name)
         elif isinstance(init_type, Instance):
             fullname = init_type.type.fullname
@@ -4300,6 +4402,7 @@ class TypeChecker(NodeVisitor[None], Che
         refers to the variable (lvalue). If var is None, do nothing.
         """
         if var and not self.current_node_deferred:
+            # TODO: should we also set 'is_ready = True' here?
             var.type = type
             var.is_inferred = True
             if var not in self.var_decl_frames:
@@ -4310,12 +4413,16 @@ class TypeChecker(NodeVisitor[None], Che
                 if lvalue.def_var is not None:
                     self.inferred_attribute_types[lvalue.def_var] = type
             self.store_type(lvalue, type)
+            p_type = get_proper_type(type)
+            if isinstance(p_type, CallableType) and is_node_static(p_type.definition):
+                # TODO: handle aliases to class methods (similarly).
+                var.is_staticmethod = True
 
     def set_inference_error_fallback_type(self, var: Var, lvalue: Lvalue, type: Type) -> None:
         """Store best known type for variable if type inference failed.
 
         If a program ignores error on type inference error, the variable should get some
-        inferred type so that if can used later on in the program. Example:
+        inferred type so that it can used later on in the program. Example:
 
           x = []  # type: ignore
           x.append(1)   # Should be ok!
@@ -4340,7 +4447,9 @@ class TypeChecker(NodeVisitor[None], Che
         if isinstance(rvalue, (IntExpr, StrExpr, BytesExpr, FloatExpr, RefExpr)):
             return True
         if isinstance(rvalue, CallExpr):
-            if isinstance(rvalue.callee, RefExpr) and isinstance(rvalue.callee.node, FuncBase):
+            if isinstance(rvalue.callee, RefExpr) and isinstance(
+                rvalue.callee.node, SYMBOL_FUNCBASE_TYPES
+            ):
                 typ = rvalue.callee.node.type
                 if isinstance(typ, CallableType):
                     return not typ.variables
@@ -4358,18 +4467,65 @@ class TypeChecker(NodeVisitor[None], Che
         rvalue_name: str = "expression",
         *,
         notes: list[str] | None = None,
-    ) -> Type:
+        lvalue: Expression | None = None,
+        inferred: Var | None = None,
+    ) -> tuple[Type, Type | None]:
         if self.is_stub and isinstance(rvalue, EllipsisExpr):
             # '...' is always a valid initializer in a stub.
-            return AnyType(TypeOfAny.special_form)
+            return AnyType(TypeOfAny.special_form), lvalue_type
         else:
             always_allow_any = lvalue_type is not None and not isinstance(
                 get_proper_type(lvalue_type), AnyType
             )
+            if inferred is None or is_typeddict_type_context(lvalue_type):
+                type_context = lvalue_type
+            else:
+                type_context = None
             rvalue_type = self.expr_checker.accept(
-                rvalue, lvalue_type, always_allow_any=always_allow_any
+                rvalue, type_context=type_context, always_allow_any=always_allow_any
             )
             if (
+                lvalue_type is not None
+                and type_context is None
+                and not is_valid_inferred_type(rvalue_type, self.options)
+            ):
+                # Inference in an empty type context didn't produce a valid type, so
+                # try using lvalue type as context instead.
+                rvalue_type = self.expr_checker.accept(
+                    rvalue, type_context=lvalue_type, always_allow_any=always_allow_any
+                )
+                if not is_valid_inferred_type(rvalue_type, self.options) and inferred is not None:
+                    self.msg.need_annotation_for_var(
+                        inferred, context, self.options.python_version
+                    )
+                    rvalue_type = rvalue_type.accept(SetNothingToAny())
+
+            if (
+                isinstance(lvalue, NameExpr)
+                and inferred is not None
+                and inferred.type is not None
+                and not inferred.is_final
+            ):
+                new_inferred = remove_instance_last_known_values(rvalue_type)
+                if not is_same_type(inferred.type, new_inferred):
+                    # Should we widen the inferred type or the lvalue? Variables defined
+                    # at module level or class bodies can't be widened in functions, or
+                    # in another module.
+                    if not self.refers_to_different_scope(lvalue):
+                        lvalue_type = make_simplified_union([inferred.type, new_inferred])
+                        if not is_same_type(lvalue_type, inferred.type) and not isinstance(
+                            inferred.type, PartialType
+                        ):
+                            # Widen the type to the union of original and new type.
+                            self.widened_vars.append(inferred.name)
+                            self.set_inferred_type(inferred, lvalue, lvalue_type)
+                            self.binder.put(lvalue, rvalue_type)
+                            # TODO: A bit hacky, maybe add a binder method that does put and
+                            #       updates declaration?
+                            lit = literal_hash(lvalue)
+                            if lit is not None:
+                                self.binder.declarations[lit] = lvalue_type
+            if (
                 isinstance(get_proper_type(lvalue_type), UnionType)
                 # Skip literal types, as they have special logic (for better errors).
                 and not is_literal_type_like(rvalue_type)
@@ -4388,7 +4544,7 @@ class TypeChecker(NodeVisitor[None], Che
                     not local_errors.has_new_errors()
                     # Skip Any type, since it is special cased in binder.
                     and not isinstance(get_proper_type(alt_rvalue_type), AnyType)
-                    and is_valid_inferred_type(alt_rvalue_type)
+                    and is_valid_inferred_type(alt_rvalue_type, self.options)
                     and is_proper_subtype(alt_rvalue_type, rvalue_type)
                 ):
                     rvalue_type = alt_rvalue_type
@@ -4408,10 +4564,27 @@ class TypeChecker(NodeVisitor[None], Che
                     f"{lvalue_name} has type",
                     notes=notes,
                 )
-            return rvalue_type
+            return rvalue_type, lvalue_type
+
+    def refers_to_different_scope(self, name: NameExpr) -> bool:
+        if name.kind == LDEF:
+            # TODO: Consider reference to outer function as a different scope?
+            return False
+        elif self.scope.top_level_function() is not None:
+            # A non-local reference from within a function must refer to a different scope
+            return True
+        elif name.kind == GDEF and name.fullname.rpartition(".")[0] != self.tree.fullname:
+            # Reference to global definition from another module
+            return True
+        return False
 
     def check_member_assignment(
-        self, instance_type: Type, attribute_type: Type, rvalue: Expression, context: Context
+        self,
+        lvalue: MemberExpr,
+        instance_type: Type,
+        attribute_type: Type,
+        rvalue: Expression,
+        context: Context,
     ) -> tuple[Type, Type, bool]:
         """Type member assignment.
 
@@ -4420,121 +4593,29 @@ class TypeChecker(NodeVisitor[None], Che
 
         Return the inferred rvalue_type, inferred lvalue_type, and whether to use the binder
         for this assignment.
-
-        Note: this method exists here and not in checkmember.py, because we need to take
-        care about interaction between binder and __set__().
         """
         instance_type = get_proper_type(instance_type)
-        attribute_type = get_proper_type(attribute_type)
         # Descriptors don't participate in class-attribute access
         if (isinstance(instance_type, FunctionLike) and instance_type.is_type_obj()) or isinstance(
             instance_type, TypeType
         ):
-            rvalue_type = self.check_simple_assignment(attribute_type, rvalue, context)
+            rvalue_type, _ = self.check_simple_assignment(attribute_type, rvalue, context)
             return rvalue_type, attribute_type, True
 
-        if not isinstance(attribute_type, Instance):
-            # TODO: support __set__() for union types.
-            rvalue_type = self.check_simple_assignment(attribute_type, rvalue, context)
-            return rvalue_type, attribute_type, True
-
-        mx = MemberContext(
-            is_lvalue=False,
-            is_super=False,
-            is_operator=False,
-            original_type=instance_type,
-            context=context,
-            self_type=None,
-            msg=self.msg,
-            chk=self,
-        )
-        get_type = analyze_descriptor_access(attribute_type, mx, assignment=True)
-        if not attribute_type.type.has_readable_member("__set__"):
-            # If there is no __set__, we type-check that the assigned value matches
-            # the return type of __get__. This doesn't match the python semantics,
-            # (which allow you to override the descriptor with any value), but preserves
-            # the type of accessing the attribute (even after the override).
-            rvalue_type = self.check_simple_assignment(get_type, rvalue, context)
-            return rvalue_type, get_type, True
-
-        dunder_set = attribute_type.type.get_method("__set__")
-        if dunder_set is None:
-            self.fail(
-                message_registry.DESCRIPTOR_SET_NOT_CALLABLE.format(
-                    attribute_type.str_with_options(self.options)
-                ),
-                context,
+        with self.msg.filter_errors(filter_deprecated=True):
+            get_lvalue_type = self.expr_checker.analyze_ordinary_member_access(
+                lvalue, is_lvalue=False
             )
-            return AnyType(TypeOfAny.from_error), get_type, False
-
-        bound_method = analyze_decorator_or_funcbase_access(
-            defn=dunder_set,
-            itype=attribute_type,
-            info=attribute_type.type,
-            self_type=attribute_type,
-            name="__set__",
-            mx=mx,
-        )
-        typ = map_instance_to_supertype(attribute_type, dunder_set.info)
-        dunder_set_type = expand_type_by_instance(bound_method, typ)
-
-        callable_name = self.expr_checker.method_fullname(attribute_type, "__set__")
-        dunder_set_type = self.expr_checker.transform_callee_type(
-            callable_name,
-            dunder_set_type,
-            [TempNode(instance_type, context=context), rvalue],
-            [nodes.ARG_POS, nodes.ARG_POS],
-            context,
-            object_type=attribute_type,
-        )
-
-        # For non-overloaded setters, the result should be type-checked like a regular assignment.
-        # Hence, we first only try to infer the type by using the rvalue as type context.
-        type_context = rvalue
-        with self.msg.filter_errors():
-            _, inferred_dunder_set_type = self.expr_checker.check_call(
-                dunder_set_type,
-                [TempNode(instance_type, context=context), type_context],
-                [nodes.ARG_POS, nodes.ARG_POS],
-                context,
-                object_type=attribute_type,
-                callable_name=callable_name,
-            )
-
-        # And now we in fact type check the call, to show errors related to wrong arguments
-        # count, etc., replacing the type context for non-overloaded setters only.
-        inferred_dunder_set_type = get_proper_type(inferred_dunder_set_type)
-        if isinstance(inferred_dunder_set_type, CallableType):
-            type_context = TempNode(AnyType(TypeOfAny.special_form), context=context)
-        self.expr_checker.check_call(
-            dunder_set_type,
-            [TempNode(instance_type, context=context), type_context],
-            [nodes.ARG_POS, nodes.ARG_POS],
-            context,
-            object_type=attribute_type,
-            callable_name=callable_name,
-        )
 
-        # Search for possible deprecations:
-        mx.chk.check_deprecated(dunder_set, mx.context)
-        mx.chk.warn_deprecated_overload_item(
-            dunder_set, mx.context, target=inferred_dunder_set_type, selftype=attribute_type
-        )
-
-        # In the following cases, a message already will have been recorded in check_call.
-        if (not isinstance(inferred_dunder_set_type, CallableType)) or (
-            len(inferred_dunder_set_type.arg_types) < 2
-        ):
-            return AnyType(TypeOfAny.from_error), get_type, False
-
-        set_type = inferred_dunder_set_type.arg_types[1]
         # Special case: if the rvalue_type is a subtype of both '__get__' and '__set__' types,
         # and '__get__' type is narrower than '__set__', then we invoke the binder to narrow type
         # by this assignment. Technically, this is not safe, but in practice this is
         # what a user expects.
-        rvalue_type = self.check_simple_assignment(set_type, rvalue, context)
-        infer = is_subtype(rvalue_type, get_type) and is_subtype(get_type, set_type)
-        return rvalue_type if infer else set_type, get_type, infer
+        rvalue_type, _ = self.check_simple_assignment(attribute_type, rvalue, context)
+        infer = is_subtype(rvalue_type, get_lvalue_type) and is_subtype(
+            get_lvalue_type, attribute_type
+        )
+        return rvalue_type if infer else attribute_type, attribute_type, infer
 
     def check_indexed_assignment(
         self, lvalue: IndexExpr, rvalue: Expression, context: Context
@@ -4562,6 +4643,19 @@ class TypeChecker(NodeVisitor[None], Che
         if isinstance(res_type, UninhabitedType) and not res_type.ambiguous:
             self.binder.unreachable()
 
+    def replace_partial_type(
+        self, var: Var, new_type: Type, partial_types: dict[Var, Context]
+    ) -> None:
+        """Replace the partial type of var with a non-partial type."""
+        var.type = new_type
+        del partial_types[var]
+        if self.options.allow_redefinition_new:
+            # When using --allow-redefinition-new, binder tracks all types of
+            # simple variables.
+            n = NameExpr(var.name)
+            n.node = var
+            self.binder.assign_type(n, new_type, new_type)
+
     def try_infer_partial_type_from_indexed_assignment(
         self, lvalue: IndexExpr, rvalue: Expression
     ) -> None:
@@ -4589,8 +4683,8 @@ class TypeChecker(NodeVisitor[None], Che
                     key_type = self.expr_checker.accept(lvalue.index)
                     value_type = self.expr_checker.accept(rvalue)
                     if (
-                        is_valid_inferred_type(key_type)
-                        and is_valid_inferred_type(value_type)
+                        is_valid_inferred_type(key_type, self.options)
+                        and is_valid_inferred_type(value_type, self.options)
                         and not self.current_node_deferred
                         and not (
                             typename == "collections.defaultdict"
@@ -4598,8 +4692,8 @@ class TypeChecker(NodeVisitor[None], Che
                             and not is_equivalent(value_type, var.type.value_type)
                         )
                     ):
-                        var.type = self.named_generic_type(typename, [key_type, value_type])
-                        del partial_types[var]
+                        new_type = self.named_generic_type(typename, [key_type, value_type])
+                        self.replace_partial_type(var, new_type, partial_types)
 
     def type_requires_usage(self, typ: Type) -> tuple[str, ErrorCode] | None:
         """Some types require usage in all cases. The classic example is
@@ -4636,7 +4730,7 @@ class TypeChecker(NodeVisitor[None], Che
         self.binder.unreachable()
 
     def check_return_stmt(self, s: ReturnStmt) -> None:
-        defn = self.scope.top_function()
+        defn = self.scope.current_function()
         if defn is not None:
             if defn.is_generator:
                 return_type = self.get_generator_return_type(
@@ -4648,7 +4742,7 @@ class TypeChecker(NodeVisitor[None], Che
                 return_type = self.return_types[-1]
             return_type = get_proper_type(return_type)
 
-            is_lambda = isinstance(self.scope.top_function(), LambdaExpr)
+            is_lambda = isinstance(defn, LambdaExpr)
             if isinstance(return_type, UninhabitedType):
                 # Avoid extra error messages for failed inference in lambdas
                 if not is_lambda and not return_type.ambiguous:
@@ -4923,8 +5017,13 @@ class TypeChecker(NodeVisitor[None], Che
                             # try/except block.
                             source = var.name
                             if isinstance(var.node, Var):
-                                var.node.type = DeletedType(source=source)
-                            self.binder.cleanse(var)
+                                new_type = DeletedType(source=source)
+                                var.node.type = new_type
+                                if self.options.allow_redefinition_new:
+                                    # TODO: Should we use put() here?
+                                    self.binder.assign_type(var, new_type, new_type)
+                            if not self.options.allow_redefinition_new:
+                                self.binder.cleanse(var)
             if s.else_body:
                 self.accept(s.else_body)
 
@@ -5010,8 +5109,14 @@ class TypeChecker(NodeVisitor[None], Che
             iterator_type, item_type = self.analyze_iterable_item_type(s.expr)
         s.inferred_item_type = item_type
         s.inferred_iterator_type = iterator_type
-        self.analyze_index_variables(s.index, item_type, s.index_type is None, s)
-        self.accept_loop(s.body, s.else_body)
+
+        self.accept_loop(
+            s.body,
+            s.else_body,
+            on_enter_body=lambda: self.analyze_index_variables(
+                s.index, item_type, s.index_type is None, s
+            ),
+        )
 
     def analyze_async_iterable_item_type(self, expr: Expression) -> tuple[Type, Type]:
         """Analyse async iterable expression and return iterator and iterator item types."""
@@ -5123,7 +5228,7 @@ class TypeChecker(NodeVisitor[None], Che
             for elt in flatten(s.expr):
                 if isinstance(elt, NameExpr):
                     self.binder.assign_type(
-                        elt, DeletedType(source=elt.name), get_declaration(elt), False
+                        elt, DeletedType(source=elt.name), get_declaration(elt)
                     )
 
     def visit_decorator(self, e: Decorator) -> None:
@@ -5135,7 +5240,9 @@ class TypeChecker(NodeVisitor[None], Che
                     return
         self.visit_decorator_inner(e)
 
-    def visit_decorator_inner(self, e: Decorator, allow_empty: bool = False) -> None:
+    def visit_decorator_inner(
+        self, e: Decorator, allow_empty: bool = False, skip_first_item: bool = False
+    ) -> None:
         if self.recurse_into_functions:
             with self.tscope.function_scope(e.func):
                 self.check_func_item(e.func, name=e.func.name, allow_empty=allow_empty)
@@ -5143,17 +5250,24 @@ class TypeChecker(NodeVisitor[None], Che
         # Process decorators from the inside out to determine decorated signature, which
         # may be different from the declared signature.
         sig: Type = self.function_type(e.func)
-        for d in reversed(e.decorators):
+        non_trivial_decorator = False
+        # For settable properties skip the first decorator (that is @foo.setter).
+        for d in reversed(e.decorators[1:] if skip_first_item else e.decorators):
+            if refers_to_fullname(d, "abc.abstractmethod"):
+                # This is a hack to avoid spurious errors because of incomplete type
+                # of @abstractmethod in the test fixtures.
+                continue
             if refers_to_fullname(d, OVERLOAD_NAMES):
                 if not allow_empty:
                     self.fail(message_registry.MULTIPLE_OVERLOADS_REQUIRED, e)
                 continue
+            non_trivial_decorator = True
             dec = self.expr_checker.accept(d)
             temp = self.temp_node(sig, context=d)
             fullname = None
             if isinstance(d, RefExpr):
                 fullname = d.fullname or None
-            # if this is a expression like @b.a where b is an object, get the type of b
+            # if this is an expression like @b.a where b is an object, get the type of b,
             # so we can pass it the method hook in the plugins
             object_type: Type | None = None
             if fullname is None and isinstance(d, MemberExpr) and self.has_type(d.expr):
@@ -5163,7 +5277,8 @@ class TypeChecker(NodeVisitor[None], Che
             sig, t2 = self.expr_checker.check_call(
                 dec, [temp], [nodes.ARG_POS], e, callable_name=fullname, object_type=object_type
             )
-        self.check_untyped_after_decorator(sig, e.func)
+        if non_trivial_decorator:
+            self.check_untyped_after_decorator(sig, e.func)
         sig = set_callable_name(sig, e.func)
         e.var.type = sig
         e.var.is_ready = True
@@ -5172,15 +5287,18 @@ class TypeChecker(NodeVisitor[None], Che
                 if len([k for k in sig.arg_kinds if k.is_required()]) > 1:
                     self.msg.fail("Too many arguments for property", e)
             self.check_incompatible_property_override(e)
-        # For overloaded functions we already checked override for overload as a whole.
-        if allow_empty:
+        # For overloaded functions/properties we already checked override for overload as a whole.
+        if allow_empty or skip_first_item:
             return
-        if e.func.info and not e.func.is_dynamic() and not e.is_overload:
+        if e.func.info and not e.is_overload:
             found_method_base_classes = self.check_method_override(e)
             if (
                 e.func.is_explicit_override
                 and not found_method_base_classes
                 and found_method_base_classes is not None
+                # If the class has Any fallback, we can't be certain that a method
+                # is really missing - it might come from unfollowed import.
+                and not e.func.info.fallback_to_any
             ):
                 self.msg.no_overridable_method(e.func.name, e.func)
             self.check_explicit_override_decorator(e.func, found_method_base_classes)
@@ -5200,6 +5318,7 @@ class TypeChecker(NodeVisitor[None], Che
             self.options.disallow_untyped_decorators
             and is_typed_callable(func.type)
             and is_untyped_decorator(dec_type)
+            and not self.current_node_deferred
         ):
             self.msg.typed_function_untyped_decorator(func.name, dec_expr)
 
@@ -5307,11 +5426,13 @@ class TypeChecker(NodeVisitor[None], Che
             # Create a dummy subject expression to handle cases where a match statement's subject
             # is not a literal value. This lets us correctly narrow types and check exhaustivity
             # This is hack!
-            id = s.subject.callee.fullname if isinstance(s.subject.callee, RefExpr) else ""
-            name = "dummy-match-" + id
-            v = Var(name)
-            named_subject = NameExpr(name)
-            named_subject.node = v
+            if s.subject_dummy is None:
+                id = s.subject.callee.fullname if isinstance(s.subject.callee, RefExpr) else ""
+                name = "dummy-match-" + id
+                v = Var(name)
+                s.subject_dummy = NameExpr(name)
+                s.subject_dummy.node = v
+            named_subject = s.subject_dummy
         else:
             named_subject = s.subject
 
@@ -5346,6 +5467,8 @@ class TypeChecker(NodeVisitor[None], Che
                         pattern_map, else_map = conditional_types_to_typemaps(
                             named_subject, pattern_type.type, pattern_type.rest_type
                         )
+                        pattern_map = self.propagate_up_typemap_info(pattern_map)
+                        else_map = self.propagate_up_typemap_info(else_map)
                         self.remove_capture_conflicts(pattern_type.captures, inferred_types)
                         self.push_type_map(pattern_map, from_assignment=False)
                         if pattern_map:
@@ -5501,13 +5624,9 @@ class TypeChecker(NodeVisitor[None], Che
         theoretical subclass of the instances the user may be trying to use
         the generated intersection can serve as a placeholder.
 
-        This function will create a fresh subclass every time you call it,
-        even if you pass in the exact same arguments. So this means calling
-        `self.intersect_intersection([inst_1, inst_2], ctx)` twice will result
-        in instances of two distinct subclasses of inst_1 and inst_2.
-
-        This is by design: we want each ad-hoc intersection to be unique since
-        they're supposed represent some other unknown subclass.
+        This function will create a fresh subclass the first time you call it.
+        So this means calling `self.intersect_intersection([inst_1, inst_2], ctx)`
+        twice will return the same subclass of inst_1 and inst_2.
 
         Returns None if creating the subclass is impossible (e.g. due to
         MRO errors or incompatible signatures). If we do successfully create
@@ -5540,20 +5659,19 @@ class TypeChecker(NodeVisitor[None], Che
             return base_classes_
 
         def _make_fake_typeinfo_and_full_name(
-            base_classes_: list[Instance], curr_module_: MypyFile
+            base_classes_: list[Instance], curr_module_: MypyFile, options: Options
         ) -> tuple[TypeInfo, str]:
-            names_list = pretty_seq([x.type.name for x in base_classes_], "and")
-            short_name = f"<subclass of {names_list}>"
-            full_name_ = gen_unique_name(short_name, curr_module_.names)
-            cdef, info_ = self.make_fake_typeinfo(
-                curr_module_.fullname, full_name_, short_name, base_classes_
-            )
-            return info_, full_name_
+            names = [format_type_bare(x, options=options, verbosity=2) for x in base_classes_]
+            name = f"<subclass of {pretty_seq(names, 'and')}>"
+            if (symbol := curr_module_.names.get(name)) is not None:
+                assert isinstance(symbol.node, TypeInfo)
+                return symbol.node, name
+            cdef, info_ = self.make_fake_typeinfo(curr_module_.fullname, name, name, base_classes_)
+            return info_, name
 
         base_classes = _get_base_classes(instances)
-        # We use the pretty_names_list for error messages but can't
-        # use it for the real name that goes into the symbol table
-        # because it can have dots in it.
+        # We use the pretty_names_list for error messages but for the real name that goes
+        # into the symbol table because it is not specific enough.
         pretty_names_list = pretty_seq(
             format_type_distinctly(*base_classes, options=self.options, bare=True), "and"
         )
@@ -5567,13 +5685,17 @@ class TypeChecker(NodeVisitor[None], Che
             return None
 
         try:
-            info, full_name = _make_fake_typeinfo_and_full_name(base_classes, curr_module)
+            info, full_name = _make_fake_typeinfo_and_full_name(
+                base_classes, curr_module, self.options
+            )
             with self.msg.filter_errors() as local_errors:
                 self.check_multiple_inheritance(info)
             if local_errors.has_new_errors():
                 # "class A(B, C)" unsafe, now check "class A(C, B)":
                 base_classes = _get_base_classes(instances[::-1])
-                info, full_name = _make_fake_typeinfo_and_full_name(base_classes, curr_module)
+                info, full_name = _make_fake_typeinfo_and_full_name(
+                    base_classes, curr_module, self.options
+                )
                 with self.msg.filter_errors() as local_errors:
                     self.check_multiple_inheritance(info)
             info.is_intersection = True
@@ -5914,6 +6036,8 @@ class TypeChecker(NodeVisitor[None], Che
 
         def combine_maps(list_maps: list[TypeMap]) -> TypeMap:
             """Combine all typemaps in list_maps into one typemap"""
+            if all(m is None for m in list_maps):
+                return None
             result_map = {}
             for d in list_maps:
                 if d is not None:
@@ -6036,15 +6160,31 @@ class TypeChecker(NodeVisitor[None], Che
                         # considered "always right" (i.e. even if the types are not overlapping).
                         # Also note that a care must be taken to unwrap this back at read places
                         # where we use this to narrow down declared type.
-                        if node.callee.type_guard is not None:
-                            return {expr: TypeGuardedType(node.callee.type_guard)}, {}
+                        with self.msg.filter_errors(), self.local_type_map():
+                            # `node.callee` can be an `overload`ed function,
+                            # we need to resolve the real `overload` case.
+                            _, real_func = self.expr_checker.check_call(
+                                get_proper_type(self.lookup_type(node.callee)),
+                                node.args,
+                                node.arg_kinds,
+                                node,
+                                node.arg_names,
+                            )
+                        real_func = get_proper_type(real_func)
+                        if not isinstance(real_func, CallableType) or not (
+                            real_func.type_guard or real_func.type_is
+                        ):
+                            return {}, {}
+
+                        if real_func.type_guard is not None:
+                            return {expr: TypeGuardedType(real_func.type_guard)}, {}
                         else:
-                            assert node.callee.type_is is not None
+                            assert real_func.type_is is not None
                             return conditional_types_to_typemaps(
                                 expr,
                                 *self.conditional_types_with_intersection(
                                     self.lookup_type(expr),
-                                    [TypeRange(node.callee.type_is, is_upper_bound=False)],
+                                    [TypeRange(real_func.type_is, is_upper_bound=False)],
                                     expr,
                                 ),
                             )
@@ -6401,7 +6541,6 @@ class TypeChecker(NodeVisitor[None], Che
                             is_lvalue=False,
                             is_super=False,
                             is_operator=False,
-                            msg=self.msg,
                             original_type=new_parent_type,
                             chk=self,
                             in_literal_context=False,
@@ -7699,7 +7838,6 @@ class TypeChecker(NodeVisitor[None], Che
                 is_lvalue=False,
                 is_super=False,
                 is_operator=False,
-                msg=self.msg,
                 original_type=typ,
                 chk=self,
                 # This is not a real attribute lookup so don't mess with deferring nodes.
@@ -7732,6 +7870,10 @@ class TypeChecker(NodeVisitor[None], Che
             isinstance(node, (FuncDef, OverloadedFuncDef, TypeInfo))
             and ((deprecated := node.deprecated) is not None)
             and not self.is_typeshed_stub
+            and not any(
+                node.fullname == p or node.fullname.startswith(f"{p}.")
+                for p in self.options.deprecated_calls_exclude
+            )
         ):
             warn = self.msg.note if self.options.report_deprecated_as_note else self.msg.fail
             warn(deprecated, context, code=codes.DEPRECATED)
@@ -7746,11 +7888,22 @@ class TypeChecker(NodeVisitor[None], Che
                 if isinstance(item, Decorator) and isinstance(
                     candidate := item.func.type, CallableType
                 ):
-                    if selftype is not None:
+                    if selftype is not None and not node.is_static:
                         candidate = bind_self(candidate, selftype)
                     if candidate == target:
                         self.warn_deprecated(item.func, context)
 
+    # leafs
+
+    def visit_pass_stmt(self, o: PassStmt, /) -> None:
+        return None
+
+    def visit_nonlocal_decl(self, o: NonlocalDecl, /) -> None:
+        return None
+
+    def visit_global_decl(self, o: GlobalDecl, /) -> None:
+        return None
+
 
 class CollectArgTypeVarTypes(TypeTraverserVisitor):
     """Collects the non-nested argument types in a set."""
@@ -8300,7 +8453,9 @@ def _find_inplace_method(inst: Instance,
     return None
 
 
-def is_valid_inferred_type(typ: Type, is_lvalue_final: bool = False) -> bool:
+def is_valid_inferred_type(
+    typ: Type, options: Options, is_lvalue_final: bool = False, is_lvalue_member: bool = False
+) -> bool:
     """Is an inferred type valid and needs no further refinement?
 
     Examples of invalid types include the None type (when we are not assigning
@@ -8319,7 +8474,7 @@ def is_valid_inferred_type(typ: Type, is
         # type could either be NoneType or an Optional type, depending on
         # the context. This resolution happens in leave_partial_types when
         # we pop a partial types scope.
-        return is_lvalue_final
+        return is_lvalue_final or (not is_lvalue_member and options.allow_redefinition_new)
     elif isinstance(proper_type, UninhabitedType):
         return False
     return not typ.accept(InvalidInferredTypes())
@@ -8349,7 +8504,6 @@ class InvalidInferredTypes(BoolTypeQuery
 
     def visit_tuple_type(self, t: TupleType, /) -> bool:
         # Exclude fallback to avoid bogus "need type annotation" errors
-        # TODO: Maybe erase plain tuples used as fallback in TupleType constructor?
         return self.query_types(t.items)
 
 
@@ -8379,67 +8533,6 @@ def is_node_static(node: Node | None) ->
     return None
 
 
-class CheckerScope:
-    # We keep two stacks combined, to maintain the relative order
-    stack: list[TypeInfo | FuncItem | MypyFile]
-
-    def __init__(self, module: MypyFile) -> None:
-        self.stack = [module]
-
-    def top_function(self) -> FuncItem | None:
-        for e in reversed(self.stack):
-            if isinstance(e, FuncItem):
-                return e
-        return None
-
-    def top_non_lambda_function(self) -> FuncItem | None:
-        for e in reversed(self.stack):
-            if isinstance(e, FuncItem) and not isinstance(e, LambdaExpr):
-                return e
-        return None
-
-    def active_class(self) -> TypeInfo | None:
-        if isinstance(self.stack[-1], TypeInfo):
-            return self.stack[-1]
-        return None
-
-    def enclosing_class(self) -> TypeInfo | None:
-        """Is there a class *directly* enclosing this function?"""
-        top = self.top_function()
-        assert top, "This method must be called from inside a function"
-        index = self.stack.index(top)
-        assert index, "CheckerScope stack must always start with a module"
-        enclosing = self.stack[index - 1]
-        if isinstance(enclosing, TypeInfo):
-            return enclosing
-        return None
-
-    def active_self_type(self) -> Instance | TupleType | None:
-        """An instance or tuple type representing the current class.
-
-        This returns None unless we are in class body or in a method.
-        In particular, inside a function nested in method this returns None.
-        """
-        info = self.active_class()
-        if not info and self.top_function():
-            info = self.enclosing_class()
-        if info:
-            return fill_typevars(info)
-        return None
-
-    @contextmanager
-    def push_function(self, item: FuncItem) -> Iterator[None]:
-        self.stack.append(item)
-        yield
-        self.stack.pop()
-
-    @contextmanager
-    def push_class(self, info: TypeInfo) -> Iterator[None]:
-        self.stack.append(info)
-        yield
-        self.stack.pop()
-
-
 TKey = TypeVar("TKey")
 TValue = TypeVar("TValue")
 
@@ -8691,6 +8784,37 @@ def is_property(defn: SymbolNode) -> boo
     return False
 
 
+def is_settable_property(defn: SymbolNode | None) -> TypeGuard[OverloadedFuncDef]:
+    if isinstance(defn, OverloadedFuncDef):
+        if defn.items and isinstance(defn.items[0], Decorator):
+            return defn.items[0].func.is_property
+    return False
+
+
+def is_custom_settable_property(defn: SymbolNode | None) -> bool:
+    """Check if a node is a settable property with a non-trivial setter type.
+
+    By non-trivial here we mean that it is known (i.e. definition was already type
+    checked), it is not Any, and it is different from the property getter type.
+    """
+    if defn is None:
+        return False
+    if not is_settable_property(defn):
+        return False
+    first_item = defn.items[0]
+    assert isinstance(first_item, Decorator)
+    if not first_item.var.is_settable_property:
+        return False
+    var = first_item.var
+    if var.type is None or var.setter_type is None or isinstance(var.type, PartialType):
+        # The caller should defer in case of partial types or not ready variables.
+        return False
+    setter_type = var.setter_type.arg_types[1]
+    if isinstance(get_proper_type(setter_type), AnyType):
+        return False
+    return not is_same_type(get_property_type(get_proper_type(var.type)), setter_type)
+
+
 def get_property_type(t: ProperType) -> ProperType:
     if isinstance(t, CallableType):
         return get_proper_type(t.ret_type)
@@ -8869,3 +8993,18 @@ def _ambiguous_enum_variants(types: list
         else:
             result.add("<other>")
     return result
+
+
+def is_typeddict_type_context(lvalue_type: Type | None) -> bool:
+    if lvalue_type is None:
+        return False
+    lvalue_proper = get_proper_type(lvalue_type)
+    return isinstance(lvalue_proper, TypedDictType)
+
+
+def is_method(node: SymbolNode | None) -> bool:
+    if isinstance(node, OverloadedFuncDef):
+        return not node.is_property
+    if isinstance(node, Decorator):
+        return not node.var.is_property
+    return isinstance(node, FuncDef)
diff -pruN 1.15.0-5/mypy/checker_shared.py 1.16~rc0.1-1/mypy/checker_shared.py
--- 1.15.0-5/mypy/checker_shared.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/mypy/checker_shared.py	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,349 @@
+"""Shared definitions used by different parts of type checker."""
+
+from __future__ import annotations
+
+from abc import abstractmethod
+from collections.abc import Iterator, Sequence
+from contextlib import contextmanager
+from typing import NamedTuple, overload
+
+from mypy_extensions import trait
+
+from mypy.errorcodes import ErrorCode
+from mypy.errors import ErrorWatcher
+from mypy.message_registry import ErrorMessage
+from mypy.nodes import (
+    ArgKind,
+    Context,
+    Expression,
+    FuncItem,
+    LambdaExpr,
+    MypyFile,
+    Node,
+    RefExpr,
+    TypeAlias,
+    TypeInfo,
+    Var,
+)
+from mypy.plugin import CheckerPluginInterface, Plugin
+from mypy.types import (
+    CallableType,
+    Instance,
+    LiteralValue,
+    Overloaded,
+    PartialType,
+    TupleType,
+    Type,
+    TypedDictType,
+    TypeType,
+)
+from mypy.typevars import fill_typevars
+
+
+# An object that represents either a precise type or a type with an upper bound;
+# it is important for correct type inference with isinstance.
+class TypeRange(NamedTuple):
+    item: Type
+    is_upper_bound: bool  # False => precise type
+
+
+@trait
+class ExpressionCheckerSharedApi:
+    @abstractmethod
+    def accept(
+        self,
+        node: Expression,
+        type_context: Type | None = None,
+        allow_none_return: bool = False,
+        always_allow_any: bool = False,
+        is_callee: bool = False,
+    ) -> Type:
+        raise NotImplementedError
+
+    @abstractmethod
+    def analyze_ref_expr(self, e: RefExpr, lvalue: bool = False) -> Type:
+        raise NotImplementedError
+
+    @abstractmethod
+    def module_type(self, node: MypyFile) -> Instance:
+        raise NotImplementedError
+
+    @abstractmethod
+    def check_call(
+        self,
+        callee: Type,
+        args: list[Expression],
+        arg_kinds: list[ArgKind],
+        context: Context,
+        arg_names: Sequence[str | None] | None = None,
+        callable_node: Expression | None = None,
+        callable_name: str | None = None,
+        object_type: Type | None = None,
+        original_type: Type | None = None,
+    ) -> tuple[Type, Type]:
+        raise NotImplementedError
+
+    @abstractmethod
+    def transform_callee_type(
+        self,
+        callable_name: str | None,
+        callee: Type,
+        args: list[Expression],
+        arg_kinds: list[ArgKind],
+        context: Context,
+        arg_names: Sequence[str | None] | None = None,
+        object_type: Type | None = None,
+    ) -> Type:
+        raise NotImplementedError
+
+    @abstractmethod
+    def method_fullname(self, object_type: Type, method_name: str) -> str | None:
+        raise NotImplementedError
+
+    @abstractmethod
+    def check_method_call_by_name(
+        self,
+        method: str,
+        base_type: Type,
+        args: list[Expression],
+        arg_kinds: list[ArgKind],
+        context: Context,
+        original_type: Type | None = None,
+    ) -> tuple[Type, Type]:
+        raise NotImplementedError
+
+    @abstractmethod
+    def alias_type_in_runtime_context(
+        self, alias: TypeAlias, *, ctx: Context, alias_definition: bool = False
+    ) -> Type:
+        raise NotImplementedError
+
+    @abstractmethod
+    def visit_typeddict_index_expr(
+        self, td_type: TypedDictType, index: Expression, setitem: bool = False
+    ) -> tuple[Type, set[str]]:
+        raise NotImplementedError
+
+    @abstractmethod
+    def typeddict_callable(self, info: TypeInfo) -> CallableType:
+        raise NotImplementedError
+
+    @abstractmethod
+    def infer_literal_expr_type(self, value: LiteralValue, fallback_name: str) -> Type:
+        raise NotImplementedError
+
+
+@trait
+class TypeCheckerSharedApi(CheckerPluginInterface):
+    plugin: Plugin
+    module_refs: set[str]
+    scope: CheckerScope
+    checking_missing_await: bool
+
+    @property
+    @abstractmethod
+    def expr_checker(self) -> ExpressionCheckerSharedApi:
+        raise NotImplementedError
+
+    @abstractmethod
+    def named_type(self, name: str) -> Instance:
+        raise NotImplementedError
+
+    @abstractmethod
+    def lookup_typeinfo(self, fullname: str) -> TypeInfo:
+        raise NotImplementedError
+
+    @abstractmethod
+    def lookup_type(self, node: Expression) -> Type:
+        raise NotImplementedError
+
+    @abstractmethod
+    def handle_cannot_determine_type(self, name: str, context: Context) -> None:
+        raise NotImplementedError
+
+    @abstractmethod
+    def handle_partial_var_type(
+        self, typ: PartialType, is_lvalue: bool, node: Var, context: Context
+    ) -> Type:
+        raise NotImplementedError
+
+    @overload
+    @abstractmethod
+    def check_subtype(
+        self,
+        subtype: Type,
+        supertype: Type,
+        context: Context,
+        msg: str,
+        subtype_label: str | None = None,
+        supertype_label: str | None = None,
+        *,
+        notes: list[str] | None = None,
+        code: ErrorCode | None = None,
+        outer_context: Context | None = None,
+    ) -> bool: ...
+
+    @overload
+    @abstractmethod
+    def check_subtype(
+        self,
+        subtype: Type,
+        supertype: Type,
+        context: Context,
+        msg: ErrorMessage,
+        subtype_label: str | None = None,
+        supertype_label: str | None = None,
+        *,
+        notes: list[str] | None = None,
+        outer_context: Context | None = None,
+    ) -> bool: ...
+
+    # Unfortunately, mypyc doesn't support abstract overloads yet.
+    @abstractmethod
+    def check_subtype(
+        self,
+        subtype: Type,
+        supertype: Type,
+        context: Context,
+        msg: str | ErrorMessage,
+        subtype_label: str | None = None,
+        supertype_label: str | None = None,
+        *,
+        notes: list[str] | None = None,
+        code: ErrorCode | None = None,
+        outer_context: Context | None = None,
+    ) -> bool:
+        raise NotImplementedError
+
+    @abstractmethod
+    def get_final_context(self) -> bool:
+        raise NotImplementedError
+
+    @overload
+    @abstractmethod
+    def conditional_types_with_intersection(
+        self,
+        expr_type: Type,
+        type_ranges: list[TypeRange] | None,
+        ctx: Context,
+        default: None = None,
+    ) -> tuple[Type | None, Type | None]: ...
+
+    @overload
+    @abstractmethod
+    def conditional_types_with_intersection(
+        self, expr_type: Type, type_ranges: list[TypeRange] | None, ctx: Context, default: Type
+    ) -> tuple[Type, Type]: ...
+
+    # Unfortunately, mypyc doesn't support abstract overloads yet.
+    @abstractmethod
+    def conditional_types_with_intersection(
+        self,
+        expr_type: Type,
+        type_ranges: list[TypeRange] | None,
+        ctx: Context,
+        default: Type | None = None,
+    ) -> tuple[Type | None, Type | None]:
+        raise NotImplementedError
+
+    @abstractmethod
+    def check_deprecated(self, node: Node | None, context: Context) -> None:
+        raise NotImplementedError
+
+    @abstractmethod
+    def warn_deprecated(self, node: Node | None, context: Context) -> None:
+        raise NotImplementedError
+
+    @abstractmethod
+    def warn_deprecated_overload_item(
+        self, node: Node | None, context: Context, *, target: Type, selftype: Type | None = None
+    ) -> None:
+        raise NotImplementedError
+
+    @abstractmethod
+    def type_is_iterable(self, type: Type) -> bool:
+        raise NotImplementedError
+
+    @abstractmethod
+    def iterable_item_type(
+        self, it: Instance | CallableType | TypeType | Overloaded, context: Context
+    ) -> Type:
+        raise NotImplementedError
+
+    @abstractmethod
+    @contextmanager
+    def checking_await_set(self) -> Iterator[None]:
+        raise NotImplementedError
+
+    @abstractmethod
+    def get_precise_awaitable_type(self, typ: Type, local_errors: ErrorWatcher) -> Type | None:
+        raise NotImplementedError
+
+
+class CheckerScope:
+    # We keep two stacks combined, to maintain the relative order
+    stack: list[TypeInfo | FuncItem | MypyFile]
+
+    def __init__(self, module: MypyFile) -> None:
+        self.stack = [module]
+
+    def current_function(self) -> FuncItem | None:
+        for e in reversed(self.stack):
+            if isinstance(e, FuncItem):
+                return e
+        return None
+
+    def top_level_function(self) -> FuncItem | None:
+        """Return top-level non-lambda function."""
+        for e in self.stack:
+            if isinstance(e, FuncItem) and not isinstance(e, LambdaExpr):
+                return e
+        return None
+
+    def active_class(self) -> TypeInfo | None:
+        if isinstance(self.stack[-1], TypeInfo):
+            return self.stack[-1]
+        return None
+
+    def enclosing_class(self, func: FuncItem | None = None) -> TypeInfo | None:
+        """Is there a class *directly* enclosing this function?"""
+        func = func or self.current_function()
+        assert func, "This method must be called from inside a function"
+        index = self.stack.index(func)
+        assert index, "CheckerScope stack must always start with a module"
+        enclosing = self.stack[index - 1]
+        if isinstance(enclosing, TypeInfo):
+            return enclosing
+        return None
+
+    def active_self_type(self) -> Instance | TupleType | None:
+        """An instance or tuple type representing the current class.
+
+        This returns None unless we are in class body or in a method.
+        In particular, inside a function nested in method this returns None.
+        """
+        info = self.active_class()
+        if not info and self.current_function():
+            info = self.enclosing_class()
+        if info:
+            return fill_typevars(info)
+        return None
+
+    def current_self_type(self) -> Instance | TupleType | None:
+        """Same as active_self_type() but handle functions nested in methods."""
+        for item in reversed(self.stack):
+            if isinstance(item, TypeInfo):
+                return fill_typevars(item)
+        return None
+
+    @contextmanager
+    def push_function(self, item: FuncItem) -> Iterator[None]:
+        self.stack.append(item)
+        yield
+        self.stack.pop()
+
+    @contextmanager
+    def push_class(self, info: TypeInfo) -> Iterator[None]:
+        self.stack.append(info)
+        yield
+        self.stack.pop()
diff -pruN 1.15.0-5/mypy/checkexpr.py 1.16~rc0.1-1/mypy/checkexpr.py
--- 1.15.0-5/mypy/checkexpr.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/checkexpr.py	2025-05-27 17:21:15.000000000 +0000
@@ -15,7 +15,8 @@ import mypy.checker
 import mypy.errorcodes as codes
 from mypy import applytype, erasetype, join, message_registry, nodes, operators, types
 from mypy.argmap import ArgTypeExpander, map_actuals_to_formals, map_formals_to_actuals
-from mypy.checkmember import analyze_member_access, freeze_all_type_vars, type_object_type
+from mypy.checker_shared import ExpressionCheckerSharedApi
+from mypy.checkmember import analyze_member_access
 from mypy.checkstrformat import StringFormatterChecker
 from mypy.erasetype import erase_type, remove_instance_last_known_values, replace_meta_vars
 from mypy.errors import ErrorWatcher, report_internal_error
@@ -133,6 +134,7 @@ from mypy.typeops import (
     erase_to_union_or_bound,
     false_only,
     fixup_partial_type,
+    freeze_all_type_vars,
     function_type,
     get_all_type_vars,
     get_type_vars,
@@ -143,6 +145,7 @@ from mypy.typeops import (
     try_expanding_sum_type_to_union,
     try_getting_str_literals,
     tuple_fallback,
+    type_object_type,
 )
 from mypy.types import (
     LITERAL_TYPE_NAMES,
@@ -294,7 +297,7 @@ USE_REVERSE_ALWAYS: Final = UseReverse.A
 USE_REVERSE_NEVER: Final = UseReverse.NEVER
 
 
-class ExpressionChecker(ExpressionVisitor[Type]):
+class ExpressionChecker(ExpressionVisitor[Type], ExpressionCheckerSharedApi):
     """Expression type checker.
 
     This class works closely together with checker.TypeChecker.
@@ -336,7 +339,7 @@ class ExpressionChecker(ExpressionVisito
         # TODO: refactor this to use a pattern similar to one in
         # multiassign_from_union, or maybe even combine the two?
         self.type_overrides: dict[Expression, Type] = {}
-        self.strfrm_checker = StringFormatterChecker(self, self.chk, self.msg)
+        self.strfrm_checker = StringFormatterChecker(self.chk, self.msg)
 
         self.resolved_type = {}
 
@@ -1125,8 +1128,7 @@ class ExpressionChecker(ExpressionVisito
             typ = self.try_infer_partial_value_type_from_call(e, callee.name, var)
             # Var may be deleted from partial_types in try_infer_partial_value_type_from_call
             if typ is not None and var in partial_types:
-                var.type = typ
-                del partial_types[var]
+                self.chk.replace_partial_type(var, typ, partial_types)
         elif isinstance(callee.expr, IndexExpr) and isinstance(callee.expr.base, RefExpr):
             # Call 'x[y].method(...)'; may infer type of 'x' if it's a partial defaultdict.
             if callee.expr.analyzed is not None:
@@ -1144,12 +1146,12 @@ class ExpressionChecker(ExpressionVisito
             if value_type is not None:
                 # Infer key type.
                 key_type = self.accept(index)
-                if mypy.checker.is_valid_inferred_type(key_type):
+                if mypy.checker.is_valid_inferred_type(key_type, self.chk.options):
                     # Store inferred partial type.
                     assert partial_type.type is not None
                     typename = partial_type.type.fullname
-                    var.type = self.chk.named_generic_type(typename, [key_type, value_type])
-                    del partial_types[var]
+                    new_type = self.chk.named_generic_type(typename, [key_type, value_type])
+                    self.chk.replace_partial_type(var, new_type, partial_types)
 
     def get_partial_var(self, ref: RefExpr) -> tuple[Var, dict[Var, Context]] | None:
         var = ref.node
@@ -1184,7 +1186,7 @@ class ExpressionChecker(ExpressionVisito
             and e.arg_kinds == [ARG_POS]
         ):
             item_type = self.accept(e.args[0])
-            if mypy.checker.is_valid_inferred_type(item_type):
+            if mypy.checker.is_valid_inferred_type(item_type, self.chk.options):
                 return self.chk.named_generic_type(typename, [item_type])
         elif (
             typename in self.container_args
@@ -1196,7 +1198,7 @@ class ExpressionChecker(ExpressionVisito
                 arg_typename = arg_type.type.fullname
                 if arg_typename in self.container_args[typename][methodname]:
                     if all(
-                        mypy.checker.is_valid_inferred_type(item_type)
+                        mypy.checker.is_valid_inferred_type(item_type, self.chk.options)
                         for item_type in arg_type.args
                     ):
                         return self.chk.named_generic_type(typename, list(arg_type.args))
@@ -1485,7 +1487,14 @@ class ExpressionChecker(ExpressionVisito
         )
         proper_callee = get_proper_type(callee_type)
         if isinstance(e.callee, (NameExpr, MemberExpr)):
-            self.chk.warn_deprecated_overload_item(e.callee.node, e, target=callee_type)
+            node = e.callee.node
+            if node is None and member is not None and isinstance(object_type, Instance):
+                if (symbol := object_type.type.get(member)) is not None:
+                    node = symbol.node
+            self.chk.check_deprecated(node, e)
+            self.chk.warn_deprecated_overload_item(
+                node, e, target=callee_type, selftype=object_type
+            )
         if isinstance(e.callee, RefExpr) and isinstance(proper_callee, CallableType):
             # Cache it for find_isinstance_check()
             if proper_callee.type_guard is not None:
@@ -1507,7 +1516,6 @@ class ExpressionChecker(ExpressionVisito
                     is_lvalue=False,
                     is_super=False,
                     is_operator=False,
-                    msg=self.msg,
                     original_type=object_type,
                     chk=self.chk,
                     in_literal_context=self.is_literal_context(),
@@ -1595,7 +1603,6 @@ class ExpressionChecker(ExpressionVisito
                 is_lvalue=False,
                 is_super=False,
                 is_operator=True,
-                msg=self.msg,
                 original_type=original_type or callee,
                 chk=self.chk,
                 in_literal_context=self.is_literal_context(),
@@ -2351,7 +2358,8 @@ class ExpressionChecker(ExpressionVisito
 
         # Check for too many or few values for formals.
         for i, kind in enumerate(callee.arg_kinds):
-            if kind.is_required() and not formal_to_actual[i] and not is_unexpected_arg_error:
+            mapped_args = formal_to_actual[i]
+            if kind.is_required() and not mapped_args and not is_unexpected_arg_error:
                 # No actual for a mandatory formal
                 if kind.is_positional():
                     self.msg.too_few_arguments(callee, context, actual_names)
@@ -2362,28 +2370,36 @@ class ExpressionChecker(ExpressionVisito
                     self.msg.missing_named_argument(callee, context, argname)
                 ok = False
             elif not kind.is_star() and is_duplicate_mapping(
-                formal_to_actual[i], actual_types, actual_kinds
+                mapped_args, actual_types, actual_kinds
             ):
                 if self.chk.in_checked_function() or isinstance(
-                    get_proper_type(actual_types[formal_to_actual[i][0]]), TupleType
+                    get_proper_type(actual_types[mapped_args[0]]), TupleType
                 ):
                     self.msg.duplicate_argument_value(callee, i, context)
                     ok = False
             elif (
                 kind.is_named()
-                and formal_to_actual[i]
-                and actual_kinds[formal_to_actual[i][0]] not in [nodes.ARG_NAMED, nodes.ARG_STAR2]
+                and mapped_args
+                and actual_kinds[mapped_args[0]] not in [nodes.ARG_NAMED, nodes.ARG_STAR2]
             ):
                 # Positional argument when expecting a keyword argument.
                 self.msg.too_many_positional_arguments(callee, context)
                 ok = False
-            elif (
-                callee.param_spec() is not None
-                and not formal_to_actual[i]
-                and callee.special_sig != "partial"
-            ):
-                self.msg.too_few_arguments(callee, context, actual_names)
-                ok = False
+            elif callee.param_spec() is not None:
+                if not mapped_args and callee.special_sig != "partial":
+                    self.msg.too_few_arguments(callee, context, actual_names)
+                    ok = False
+                elif len(mapped_args) > 1:
+                    paramspec_entries = sum(
+                        isinstance(get_proper_type(actual_types[k]), ParamSpecType)
+                        for k in mapped_args
+                    )
+                    if actual_kinds[mapped_args[0]] == nodes.ARG_STAR and paramspec_entries > 1:
+                        self.msg.fail("ParamSpec.args should only be passed once", context)
+                        ok = False
+                    if actual_kinds[mapped_args[0]] == nodes.ARG_STAR2 and paramspec_entries > 1:
+                        self.msg.fail("ParamSpec.kwargs should only be passed once", context)
+                        ok = False
         return ok
 
     def check_for_extra_actual_arguments(
@@ -2581,8 +2597,6 @@ class ExpressionChecker(ExpressionVisito
             for actual, actual_type, actual_kind, callee_arg_type, callee_arg_kind in zip(
                 actuals, actual_types, actual_kinds, callee_arg_types, callee_arg_kinds
             ):
-                if actual_type is None:
-                    continue  # Some kind of error was already reported.
                 # Check that a *arg is valid as varargs.
                 expanded_actual = mapper.expand_actual_type(
                     actual_type,
@@ -2906,16 +2920,37 @@ class ExpressionChecker(ExpressionVisito
             elif all_same_types([erase_type(typ) for typ in return_types]):
                 self.chk.store_types(type_maps[0])
                 return erase_type(return_types[0]), erase_type(inferred_types[0])
-            else:
-                return self.check_call(
-                    callee=AnyType(TypeOfAny.special_form),
-                    args=args,
-                    arg_kinds=arg_kinds,
-                    arg_names=arg_names,
-                    context=context,
-                    callable_name=callable_name,
-                    object_type=object_type,
-                )
+            return self.check_call(
+                callee=AnyType(TypeOfAny.special_form),
+                args=args,
+                arg_kinds=arg_kinds,
+                arg_names=arg_names,
+                context=context,
+                callable_name=callable_name,
+                object_type=object_type,
+            )
+        elif not all_same_type_narrowers(matches):
+            # This is an example of how overloads can be:
+            #
+            # @overload
+            # def is_int(obj: float) -> TypeGuard[float]: ...
+            # @overload
+            # def is_int(obj: int) -> TypeGuard[int]: ...
+            #
+            # x: Any
+            # if is_int(x):
+            #     reveal_type(x)  # N: int | float
+            #
+            # So, we need to check that special case.
+            return self.check_call(
+                callee=self.combine_function_signatures(cast("list[ProperType]", matches)),
+                args=args,
+                arg_kinds=arg_kinds,
+                arg_names=arg_names,
+                context=context,
+                callable_name=callable_name,
+                object_type=object_type,
+            )
         else:
             # Success! No ambiguity; return the first match.
             self.chk.store_types(type_maps[0])
@@ -3130,6 +3165,8 @@ class ExpressionChecker(ExpressionVisito
         new_args: list[list[Type]] = [[] for _ in range(len(callables[0].arg_types))]
         new_kinds = list(callables[0].arg_kinds)
         new_returns: list[Type] = []
+        new_type_guards: list[Type] = []
+        new_type_narrowers: list[Type] = []
 
         too_complex = False
         for target in callables:
@@ -3156,8 +3193,25 @@ class ExpressionChecker(ExpressionVisito
             for i, arg in enumerate(target.arg_types):
                 new_args[i].append(arg)
             new_returns.append(target.ret_type)
+            if target.type_guard:
+                new_type_guards.append(target.type_guard)
+            if target.type_is:
+                new_type_narrowers.append(target.type_is)
+
+        if new_type_guards and new_type_narrowers:
+            # They cannot be defined at the same time,
+            # declaring this function as too complex!
+            too_complex = True
+            union_type_guard = None
+            union_type_is = None
+        else:
+            union_type_guard = make_simplified_union(new_type_guards) if new_type_guards else None
+            union_type_is = (
+                make_simplified_union(new_type_narrowers) if new_type_narrowers else None
+            )
 
         union_return = make_simplified_union(new_returns)
+
         if too_complex:
             any = AnyType(TypeOfAny.special_form)
             return callables[0].copy_modified(
@@ -3167,6 +3221,8 @@ class ExpressionChecker(ExpressionVisito
                 ret_type=union_return,
                 variables=variables,
                 implicit=True,
+                type_guard=union_type_guard,
+                type_is=union_type_is,
             )
 
         final_args = []
@@ -3180,6 +3236,8 @@ class ExpressionChecker(ExpressionVisito
             ret_type=union_return,
             variables=variables,
             implicit=True,
+            type_guard=union_type_guard,
+            type_is=union_type_is,
         )
 
     def erased_signature_similarity(
@@ -3286,8 +3344,13 @@ class ExpressionChecker(ExpressionVisito
         self.chk.warn_deprecated(e.node, e)
         return narrowed
 
-    def analyze_ordinary_member_access(self, e: MemberExpr, is_lvalue: bool) -> Type:
-        """Analyse member expression or member lvalue."""
+    def analyze_ordinary_member_access(
+        self, e: MemberExpr, is_lvalue: bool, rvalue: Expression | None = None
+    ) -> Type:
+        """Analyse member expression or member lvalue.
+
+        An rvalue can be provided optionally to infer better setter type when is_lvalue is True.
+        """
         if e.kind is not None:
             # This is a reference to a module attribute.
             return self.analyze_ref_expr(e)
@@ -3313,12 +3376,12 @@ class ExpressionChecker(ExpressionVisito
                 is_lvalue=is_lvalue,
                 is_super=False,
                 is_operator=False,
-                msg=self.msg,
                 original_type=original_type,
                 chk=self.chk,
                 in_literal_context=self.is_literal_context(),
                 module_symbol_table=module_symbol_table,
                 is_self=is_self,
+                rvalue=rvalue,
             )
 
             return member_type
@@ -3337,7 +3400,6 @@ class ExpressionChecker(ExpressionVisito
             is_lvalue=False,
             is_super=False,
             is_operator=False,
-            msg=self.msg,
             original_type=base_type,
             chk=self.chk,
             in_literal_context=self.is_literal_context(),
@@ -3832,7 +3894,6 @@ class ExpressionChecker(ExpressionVisito
             is_lvalue=False,
             is_super=False,
             is_operator=True,
-            msg=self.msg,
             original_type=original_type,
             self_type=base_type,
             chk=self.chk,
@@ -3927,7 +3988,6 @@ class ExpressionChecker(ExpressionVisito
                     is_operator=True,
                     original_type=base_type,
                     context=context,
-                    msg=self.msg,
                     chk=self.chk,
                     in_literal_context=self.is_literal_context(),
                 )
@@ -4036,7 +4096,7 @@ class ExpressionChecker(ExpressionVisito
         results = []
         for name, method, obj, arg in variants:
             with self.msg.filter_errors(save_filtered_errors=True) as local_errors:
-                result = self.check_method_call(op_name, obj, method, [arg], [ARG_POS], context)
+                result = self.check_method_call(name, obj, method, [arg], [ARG_POS], context)
             if local_errors.has_new_errors():
                 errors.append(local_errors.filtered_errors())
                 results.append(result)
@@ -4636,8 +4696,8 @@ class ExpressionChecker(ExpressionVisito
         options = self.chk.options
         if (
             options.warn_redundant_casts
-            and not isinstance(get_proper_type(target_type), AnyType)
-            and source_type == target_type
+            and not is_same_type(target_type, AnyType(TypeOfAny.special_form))
+            and is_same_type(source_type, target_type)
         ):
             self.msg.redundant_cast(target_type, expr)
         if options.disallow_any_unimported and has_any_from_unimported_type(target_type):
@@ -5482,7 +5542,7 @@ class ExpressionChecker(ExpressionVisito
         if type_info in mro:
             index = mro.index(type_info)
         else:
-            method = self.chk.scope.top_function()
+            method = self.chk.scope.current_function()
             # Mypy explicitly allows supertype upper bounds (and no upper bound at all)
             # for annotating self-types. However, if such an annotation is used for
             # checking super() we will still get an error. So to be consistent, we also
@@ -5528,7 +5588,6 @@ class ExpressionChecker(ExpressionVisito
                     original_type=instance_type,
                     override_info=base,
                     context=e,
-                    msg=self.msg,
                     chk=self.chk,
                     in_literal_context=self.is_literal_context(),
                 )
@@ -5557,7 +5616,7 @@ class ExpressionChecker(ExpressionVisito
             type_type: ProperType = TypeType(current_type)
 
             # Use the type of the self argument, in case it was annotated
-            method = self.chk.scope.top_function()
+            method = self.chk.scope.current_function()
             assert method is not None
             if method.arguments:
                 instance_type: Type = method.arguments[0].variable.type or current_type
@@ -5746,6 +5805,14 @@ class ExpressionChecker(ExpressionVisito
                 _, sequence_type = self.chk.analyze_async_iterable_item_type(sequence)
             else:
                 _, sequence_type = self.chk.analyze_iterable_item_type(sequence)
+                if (
+                    isinstance(get_proper_type(sequence_type), UninhabitedType)
+                    and isinstance(index, NameExpr)
+                    and index.name == "_"
+                ):
+                    # To preserve backward compatibility, avoid inferring Never for "_"
+                    sequence_type = AnyType(TypeOfAny.special_form)
+
             self.chk.analyze_index_variables(index, sequence_type, True, e)
             for condition in conditions:
                 self.accept(condition)
@@ -5789,7 +5856,7 @@ class ExpressionChecker(ExpressionVisito
             else_map, e.else_expr, context=ctx, allow_none_return=allow_none_return
         )
 
-        if not mypy.checker.is_valid_inferred_type(if_type):
+        if not mypy.checker.is_valid_inferred_type(if_type, self.chk.options):
             # Analyze the right branch disregarding the left branch.
             else_type = full_context_else_type
             # we want to keep the narrowest value of else_type for union'ing the branches
@@ -6097,6 +6164,7 @@ class ExpressionChecker(ExpressionVisito
             generic_generator_type = self.chk.named_generic_type(
                 "typing.Generator", [any_type, any_type, any_type]
             )
+            generic_generator_type.set_line(e)
             iter_type, _ = self.check_method_call_by_name(
                 "__iter__", subexpr_type, [], [], context=generic_generator_type
             )
@@ -6229,7 +6297,13 @@ class ExpressionChecker(ExpressionVisito
                     known_type, restriction, prohibit_none_typevar_overlap=True
                 ):
                     return None
-                return narrow_declared_type(known_type, restriction)
+                narrowed = narrow_declared_type(known_type, restriction)
+                if isinstance(get_proper_type(narrowed), UninhabitedType):
+                    # If we hit this case, it means that we can't reliably mark the code as
+                    # unreachable, but the resulting type can't be expressed in type system.
+                    # Falling back to restriction is more intuitive in most cases.
+                    return restriction
+                return narrowed
         return known_type
 
     def has_abstract_type_part(self, caller_type: ProperType, callee_type: ProperType) -> bool:
@@ -6520,6 +6594,25 @@ def all_same_types(types: list[Type]) ->
     return all(is_same_type(t, types[0]) for t in types[1:])
 
 
+def all_same_type_narrowers(types: list[CallableType]) -> bool:
+    if len(types) <= 1:
+        return True
+
+    type_guards: list[Type] = []
+    type_narrowers: list[Type] = []
+
+    for typ in types:
+        if typ.type_guard:
+            type_guards.append(typ.type_guard)
+        if typ.type_is:
+            type_narrowers.append(typ.type_is)
+    if type_guards and type_narrowers:
+        # Some overloads declare `TypeGuard` and some declare `TypeIs`,
+        # we cannot handle this in a union.
+        return False
+    return all_same_types(type_guards) and all_same_types(type_narrowers)
+
+
 def merge_typevars_in_callables_by_name(
     callables: Sequence[CallableType],
 ) -> tuple[list[CallableType], list[TypeVarType]]:
diff -pruN 1.15.0-5/mypy/checkmember.py 1.16~rc0.1-1/mypy/checkmember.py
--- 1.15.0-5/mypy/checkmember.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/checkmember.py	2025-05-27 17:21:15.000000000 +0000
@@ -3,9 +3,10 @@
 from __future__ import annotations
 
 from collections.abc import Sequence
-from typing import TYPE_CHECKING, Callable, cast
+from typing import Callable, TypeVar, cast
 
-from mypy import meet, message_registry, subtypes
+from mypy import message_registry, state, subtypes
+from mypy.checker_shared import TypeCheckerSharedApi
 from mypy.erasetype import erase_typevars
 from mypy.expandtype import (
     expand_self_type,
@@ -22,13 +23,13 @@ from mypy.nodes import (
     SYMBOL_FUNCBASE_TYPES,
     Context,
     Decorator,
+    Expression,
     FuncBase,
     FuncDef,
     IndexExpr,
     MypyFile,
     NameExpr,
     OverloadedFuncDef,
-    SymbolNode,
     SymbolTable,
     TempNode,
     TypeAlias,
@@ -40,14 +41,15 @@ from mypy.nodes import (
 from mypy.plugin import AttributeContext
 from mypy.typeops import (
     bind_self,
-    class_callable,
     erase_to_bound,
+    freeze_all_type_vars,
     function_type,
+    get_all_type_vars,
     get_type_vars,
     make_simplified_union,
     supported_self_type,
     tuple_fallback,
-    type_object_type_from_function,
+    type_object_type,
 )
 from mypy.types import (
     AnyType,
@@ -72,12 +74,6 @@ from mypy.types import (
     UnionType,
     get_proper_type,
 )
-from mypy.typetraverser import TypeTraverserVisitor
-
-if TYPE_CHECKING:  # import for forward declaration only
-    import mypy.checker
-
-from mypy import state
 
 
 class MemberContext:
@@ -94,12 +90,13 @@ class MemberContext:
         is_operator: bool,
         original_type: Type,
         context: Context,
-        msg: MessageBuilder,
-        chk: mypy.checker.TypeChecker,
-        self_type: Type | None,
+        chk: TypeCheckerSharedApi,
+        self_type: Type | None = None,
         module_symbol_table: SymbolTable | None = None,
         no_deferral: bool = False,
         is_self: bool = False,
+        rvalue: Expression | None = None,
+        suppress_errors: bool = False,
     ) -> None:
         self.is_lvalue = is_lvalue
         self.is_super = is_super
@@ -107,11 +104,15 @@ class MemberContext:
         self.original_type = original_type
         self.self_type = self_type or original_type
         self.context = context  # Error context
-        self.msg = msg
         self.chk = chk
+        self.msg = chk.msg
         self.module_symbol_table = module_symbol_table
         self.no_deferral = no_deferral
         self.is_self = is_self
+        if rvalue is not None:
+            assert is_lvalue
+        self.rvalue = rvalue
+        self.suppress_errors = suppress_errors
 
     def named_type(self, name: str) -> Instance:
         return self.chk.named_type(name)
@@ -119,10 +120,13 @@ class MemberContext:
     def not_ready_callback(self, name: str, context: Context) -> None:
         self.chk.handle_cannot_determine_type(name, context)
 
+    def fail(self, msg: str) -> None:
+        if not self.suppress_errors:
+            self.msg.fail(msg, self.context)
+
     def copy_modified(
         self,
         *,
-        messages: MessageBuilder | None = None,
         self_type: Type | None = None,
         is_lvalue: bool | None = None,
         original_type: Type | None = None,
@@ -133,14 +137,13 @@ class MemberContext:
             is_operator=self.is_operator,
             original_type=self.original_type,
             context=self.context,
-            msg=self.msg,
             chk=self.chk,
             self_type=self.self_type,
             module_symbol_table=self.module_symbol_table,
             no_deferral=self.no_deferral,
+            rvalue=self.rvalue,
+            suppress_errors=self.suppress_errors,
         )
-        if messages is not None:
-            mx.msg = messages
         if self_type is not None:
             mx.self_type = self_type
         if is_lvalue is not None:
@@ -158,15 +161,16 @@ def analyze_member_access(
     is_lvalue: bool,
     is_super: bool,
     is_operator: bool,
-    msg: MessageBuilder,
     original_type: Type,
-    chk: mypy.checker.TypeChecker,
+    chk: TypeCheckerSharedApi,
     override_info: TypeInfo | None = None,
     in_literal_context: bool = False,
     self_type: Type | None = None,
     module_symbol_table: SymbolTable | None = None,
     no_deferral: bool = False,
     is_self: bool = False,
+    rvalue: Expression | None = None,
+    suppress_errors: bool = False,
 ) -> Type:
     """Return the type of attribute 'name' of 'typ'.
 
@@ -185,11 +189,19 @@ def analyze_member_access(
     of 'original_type'. 'original_type' is always preserved as the 'typ' type used in
     the initial, non-recursive call. The 'self_type' is a component of 'original_type'
     to which generic self should be bound (a narrower type that has a fallback to instance).
-    Currently this is used only for union types.
+    Currently, this is used only for union types.
 
-    'module_symbol_table' is passed to this function if 'typ' is actually a module
+    'module_symbol_table' is passed to this function if 'typ' is actually a module,
     and we want to keep track of the available attributes of the module (since they
     are not available via the type object directly)
+
+    'rvalue' can be provided optionally to infer better setter type when is_lvalue is True,
+    most notably this helps for descriptors with overloaded __set__() method.
+
+    'suppress_errors' will skip any logic that is only needed to generate error messages.
+    Note that this more of a performance optimization, one should not rely on this to not
+    show any messages, as some may be show e.g. by callbacks called here,
+    use msg.filter_errors(), if needed.
     """
     mx = MemberContext(
         is_lvalue=is_lvalue,
@@ -197,12 +209,13 @@ def analyze_member_access(
         is_operator=is_operator,
         original_type=original_type,
         context=context,
-        msg=msg,
         chk=chk,
         self_type=self_type,
         module_symbol_table=module_symbol_table,
         no_deferral=no_deferral,
         is_self=is_self,
+        rvalue=rvalue,
+        suppress_errors=suppress_errors,
     )
     result = _analyze_member_access(name, typ, mx, override_info)
     possible_literal = get_proper_type(result)
@@ -250,7 +263,8 @@ def _analyze_member_access(
             )
         return _analyze_member_access(name, typ.upper_bound, mx, override_info)
     elif isinstance(typ, DeletedType):
-        mx.msg.deleted_as_rvalue(typ, mx.context)
+        if not mx.suppress_errors:
+            mx.msg.deleted_as_rvalue(typ, mx.context)
         return AnyType(TypeOfAny.from_error)
     return report_missing_attribute(mx.original_type, typ, name, mx)
 
@@ -266,7 +280,9 @@ def may_be_awaitable_attribute(
         aw_type = mx.chk.get_precise_awaitable_type(typ, local_errors)
         if aw_type is None:
             return False
-        _ = _analyze_member_access(name, aw_type, mx, override_info)
+        _ = _analyze_member_access(
+            name, aw_type, mx.copy_modified(self_type=aw_type), override_info
+        )
         return not local_errors.has_new_errors()
 
 
@@ -277,6 +293,8 @@ def report_missing_attribute(
     mx: MemberContext,
     override_info: TypeInfo | None = None,
 ) -> Type:
+    if mx.suppress_errors:
+        return AnyType(TypeOfAny.from_error)
     error_code = mx.msg.has_no_attr(original_type, typ, name, mx.context, mx.module_symbol_table)
     if not mx.msg.prefer_simple_messages():
         if may_be_awaitable_attribute(name, typ, mx, override_info):
@@ -291,29 +309,32 @@ def report_missing_attribute(
 def analyze_instance_member_access(
     name: str, typ: Instance, mx: MemberContext, override_info: TypeInfo | None
 ) -> Type:
-    if name == "__init__" and not mx.is_super:
-        # Accessing __init__ in statically typed code would compromise
-        # type safety unless used via super().
-        mx.msg.fail(message_registry.CANNOT_ACCESS_INIT, mx.context)
-        return AnyType(TypeOfAny.from_error)
-
-    # The base object has an instance type.
-
     info = typ.type
     if override_info:
         info = override_info
 
+    method = info.get_method(name)
+
+    if name == "__init__" and not mx.is_super and not info.is_final:
+        if not method or not method.is_final:
+            # Accessing __init__ in statically typed code would compromise
+            # type safety unless used via super() or the method/class is final.
+            mx.fail(message_registry.CANNOT_ACCESS_INIT)
+            return AnyType(TypeOfAny.from_error)
+
+    # The base object has an instance type.
+
     if (
         state.find_occurrences
         and info.name == state.find_occurrences[0]
         and name == state.find_occurrences[1]
+        and not mx.suppress_errors
     ):
         mx.msg.note("Occurrence of '{}.{}'".format(*state.find_occurrences), mx.context)
 
     # Look up the member. First look up the method dictionary.
-    method = info.get_method(name)
     if method and not isinstance(method, Decorator):
-        if mx.is_super:
+        if mx.is_super and not mx.suppress_errors:
             validate_super_call(method, mx)
 
         if method.is_property:
@@ -322,9 +343,9 @@ def analyze_instance_member_access(
             assert isinstance(getter, Decorator)
             if mx.is_lvalue and (len(items := method.items) > 1):
                 mx.chk.warn_deprecated(items[1], mx.context)
-            return analyze_var(name, getter.var, typ, info, mx)
+            return analyze_var(name, getter.var, typ, mx)
 
-        if mx.is_lvalue:
+        if mx.is_lvalue and not mx.suppress_errors:
             mx.msg.cant_assign_to_method(mx.context)
         if not isinstance(method, OverloadedFuncDef):
             signature = function_type(method, mx.named_type("builtins.function"))
@@ -339,13 +360,13 @@ def analyze_instance_member_access(
             signature = method.type
         signature = freshen_all_functions_type_vars(signature)
         if not method.is_static:
-            # TODO: use proper treatment of special methods on unions instead
-            #       of this hack here and below (i.e. mx.self_type).
-            dispatched_type = meet.meet_types(mx.original_type, typ)
-            signature = check_self_arg(
-                signature, dispatched_type, method.is_class, mx.context, name, mx.msg
-            )
-            signature = bind_self(signature, mx.self_type, is_classmethod=method.is_class)
+            if isinstance(method, (FuncDef, OverloadedFuncDef)) and method.is_trivial_self:
+                signature = bind_self_fast(signature, mx.self_type)
+            else:
+                signature = check_self_arg(
+                    signature, mx.self_type, method.is_class, mx.context, name, mx.msg
+                )
+                signature = bind_self(signature, mx.self_type, is_classmethod=method.is_class)
         # TODO: should we skip these steps for static methods as well?
         # Since generic static methods should not be allowed.
         typ = map_instance_to_supertype(typ, method.info)
@@ -361,11 +382,13 @@ def validate_super_call(node: FuncBase,
     unsafe_super = False
     if isinstance(node, FuncDef) and node.is_trivial_body:
         unsafe_super = True
-        impl = node
     elif isinstance(node, OverloadedFuncDef):
         if node.impl:
             impl = node.impl if isinstance(node.impl, FuncDef) else node.impl.func
             unsafe_super = impl.is_trivial_body
+        elif not node.is_property and node.items:
+            assert isinstance(node.items[0], Decorator)
+            unsafe_super = node.items[0].func.is_trivial_body
     if unsafe_super:
         mx.msg.unsafe_super(node.name, node.info.name, mx.context)
 
@@ -496,15 +519,18 @@ def analyze_member_var_access(
     original_type is the type of E in the expression E.var
     """
     # It was not a method. Try looking up a variable.
-    v = lookup_member_var_or_accessor(info, name, mx.is_lvalue)
+    node = info.get(name)
+    v = node.node if node else None
 
     mx.chk.warn_deprecated(v, mx.context)
 
     vv = v
+    is_trivial_self = False
     if isinstance(vv, Decorator):
         # The associated Var node of a decorator contains the type.
         v = vv.var
-        if mx.is_super:
+        is_trivial_self = vv.func.is_trivial_self and not vv.decorators
+        if mx.is_super and not mx.suppress_errors:
             validate_super_call(vv.func, mx)
 
     if isinstance(vv, TypeInfo):
@@ -535,12 +561,14 @@ def analyze_member_var_access(
         if mx.is_lvalue and not mx.chk.get_final_context():
             check_final_member(name, info, mx.msg, mx.context)
 
-        return analyze_var(name, v, itype, info, mx, implicit=implicit)
+        return analyze_var(name, v, itype, mx, implicit=implicit, is_trivial_self=is_trivial_self)
     elif isinstance(v, FuncDef):
         assert False, "Did not expect a function"
     elif isinstance(v, MypyFile):
         mx.chk.module_refs.add(v.fullname)
         return mx.chk.expr_checker.module_type(v)
+    elif isinstance(v, TypeVarExpr):
+        return mx.chk.named_type("typing.TypeVar")
     elif (
         not v
         and name not in ["__getattr__", "__setattr__", "__getattribute__"]
@@ -559,12 +587,7 @@ def analyze_member_var_access(
                 # that the attribute exists
                 if method and method.info.fullname != "builtins.object":
                     bound_method = analyze_decorator_or_funcbase_access(
-                        defn=method,
-                        itype=itype,
-                        info=info,
-                        self_type=mx.self_type,
-                        name=method_name,
-                        mx=mx,
+                        defn=method, itype=itype, name=method_name, mx=mx
                     )
                     typ = map_instance_to_supertype(itype, method.info)
                     getattr_type = get_proper_type(expand_type_by_instance(bound_method, typ))
@@ -593,9 +616,7 @@ def analyze_member_var_access(
                 bound_type = analyze_decorator_or_funcbase_access(
                     defn=setattr_meth,
                     itype=itype,
-                    info=info,
-                    self_type=mx.self_type,
-                    name=name,
+                    name="__setattr__",
                     mx=mx.copy_modified(is_lvalue=False),
                 )
                 typ = map_instance_to_supertype(itype, setattr_meth.info)
@@ -612,7 +633,7 @@ def analyze_member_var_access(
         if not itype.extra_attrs.mod_name:
             return itype.extra_attrs.attrs[name]
 
-    if mx.is_super:
+    if mx.is_super and not mx.suppress_errors:
         mx.msg.undefined_in_superclass(name, mx.context)
         return AnyType(TypeOfAny.from_error)
     else:
@@ -639,9 +660,7 @@ def check_final_member(name: str, info:
             msg.cant_assign_to_final(name, attr_assign=True, ctx=ctx)
 
 
-def analyze_descriptor_access(
-    descriptor_type: Type, mx: MemberContext, *, assignment: bool = False
-) -> Type:
+def analyze_descriptor_access(descriptor_type: Type, mx: MemberContext) -> Type:
     """Type check descriptor access.
 
     Arguments:
@@ -649,7 +668,7 @@ def analyze_descriptor_access(
             (the type of ``f`` in ``a.f`` when ``f`` is a descriptor).
         mx: The current member access context.
     Return:
-        The return type of the appropriate ``__get__`` overload for the descriptor.
+        The return type of the appropriate ``__get__/__set__`` overload for the descriptor.
     """
     instance_type = get_proper_type(mx.self_type)
     orig_descriptor_type = descriptor_type
@@ -663,26 +682,35 @@ def analyze_descriptor_access(
     elif not isinstance(descriptor_type, Instance):
         return orig_descriptor_type
 
-    if not descriptor_type.type.has_readable_member("__get__"):
+    if not mx.is_lvalue and not descriptor_type.type.has_readable_member("__get__"):
+        return orig_descriptor_type
+
+    # We do this check first to accommodate for descriptors with only __set__ method.
+    # If there is no __set__, we type-check that the assigned value matches
+    # the return type of __get__. This doesn't match the python semantics,
+    # (which allow you to override the descriptor with any value), but preserves
+    # the type of accessing the attribute (even after the override).
+    if mx.is_lvalue and descriptor_type.type.has_readable_member("__set__"):
+        return analyze_descriptor_assign(descriptor_type, mx)
+
+    if mx.is_lvalue and not descriptor_type.type.has_readable_member("__get__"):
+        # This turned out to be not a descriptor after all.
         return orig_descriptor_type
 
     dunder_get = descriptor_type.type.get_method("__get__")
     if dunder_get is None:
-        mx.msg.fail(
+        mx.fail(
             message_registry.DESCRIPTOR_GET_NOT_CALLABLE.format(
                 descriptor_type.str_with_options(mx.msg.options)
-            ),
-            mx.context,
+            )
         )
         return AnyType(TypeOfAny.from_error)
 
     bound_method = analyze_decorator_or_funcbase_access(
         defn=dunder_get,
         itype=descriptor_type,
-        info=descriptor_type.type,
-        self_type=descriptor_type,
         name="__get__",
-        mx=mx,
+        mx=mx.copy_modified(self_type=descriptor_type),
     )
 
     typ = map_instance_to_supertype(descriptor_type, dunder_get.info)
@@ -722,11 +750,10 @@ def analyze_descriptor_access(
         callable_name=callable_name,
     )
 
-    if not assignment:
-        mx.chk.check_deprecated(dunder_get, mx.context)
-        mx.chk.warn_deprecated_overload_item(
-            dunder_get, mx.context, target=inferred_dunder_get_type, selftype=descriptor_type
-        )
+    mx.chk.check_deprecated(dunder_get, mx.context)
+    mx.chk.warn_deprecated_overload_item(
+        dunder_get, mx.context, target=inferred_dunder_get_type, selftype=descriptor_type
+    )
 
     inferred_dunder_get_type = get_proper_type(inferred_dunder_get_type)
     if isinstance(inferred_dunder_get_type, AnyType):
@@ -734,17 +761,88 @@ def analyze_descriptor_access(
         return inferred_dunder_get_type
 
     if not isinstance(inferred_dunder_get_type, CallableType):
-        mx.msg.fail(
+        mx.fail(
             message_registry.DESCRIPTOR_GET_NOT_CALLABLE.format(
                 descriptor_type.str_with_options(mx.msg.options)
-            ),
-            mx.context,
+            )
         )
         return AnyType(TypeOfAny.from_error)
 
     return inferred_dunder_get_type.ret_type
 
 
+def analyze_descriptor_assign(descriptor_type: Instance, mx: MemberContext) -> Type:
+    instance_type = get_proper_type(mx.self_type)
+    dunder_set = descriptor_type.type.get_method("__set__")
+    if dunder_set is None:
+        mx.fail(
+            message_registry.DESCRIPTOR_SET_NOT_CALLABLE.format(
+                descriptor_type.str_with_options(mx.msg.options)
+            ).value
+        )
+        return AnyType(TypeOfAny.from_error)
+
+    bound_method = analyze_decorator_or_funcbase_access(
+        defn=dunder_set,
+        itype=descriptor_type,
+        name="__set__",
+        mx=mx.copy_modified(is_lvalue=False, self_type=descriptor_type),
+    )
+    typ = map_instance_to_supertype(descriptor_type, dunder_set.info)
+    dunder_set_type = expand_type_by_instance(bound_method, typ)
+
+    callable_name = mx.chk.expr_checker.method_fullname(descriptor_type, "__set__")
+    rvalue = mx.rvalue or TempNode(AnyType(TypeOfAny.special_form), context=mx.context)
+    dunder_set_type = mx.chk.expr_checker.transform_callee_type(
+        callable_name,
+        dunder_set_type,
+        [TempNode(instance_type, context=mx.context), rvalue],
+        [ARG_POS, ARG_POS],
+        mx.context,
+        object_type=descriptor_type,
+    )
+
+    # For non-overloaded setters, the result should be type-checked like a regular assignment.
+    # Hence, we first only try to infer the type by using the rvalue as type context.
+    type_context = rvalue
+    with mx.msg.filter_errors():
+        _, inferred_dunder_set_type = mx.chk.expr_checker.check_call(
+            dunder_set_type,
+            [TempNode(instance_type, context=mx.context), type_context],
+            [ARG_POS, ARG_POS],
+            mx.context,
+            object_type=descriptor_type,
+            callable_name=callable_name,
+        )
+
+    # And now we in fact type check the call, to show errors related to wrong arguments
+    # count, etc., replacing the type context for non-overloaded setters only.
+    inferred_dunder_set_type = get_proper_type(inferred_dunder_set_type)
+    if isinstance(inferred_dunder_set_type, CallableType):
+        type_context = TempNode(AnyType(TypeOfAny.special_form), context=mx.context)
+    mx.chk.expr_checker.check_call(
+        dunder_set_type,
+        [TempNode(instance_type, context=mx.context), type_context],
+        [ARG_POS, ARG_POS],
+        mx.context,
+        object_type=descriptor_type,
+        callable_name=callable_name,
+    )
+
+    # Search for possible deprecations:
+    mx.chk.check_deprecated(dunder_set, mx.context)
+    mx.chk.warn_deprecated_overload_item(
+        dunder_set, mx.context, target=inferred_dunder_set_type, selftype=descriptor_type
+    )
+
+    # In the following cases, a message already will have been recorded in check_call.
+    if (not isinstance(inferred_dunder_set_type, CallableType)) or (
+        len(inferred_dunder_set_type.arg_types) < 2
+    ):
+        return AnyType(TypeOfAny.from_error)
+    return inferred_dunder_set_type.arg_types[1]
+
+
 def is_instance_var(var: Var) -> bool:
     """Return if var is an instance variable according to PEP 526."""
     return (
@@ -761,10 +859,10 @@ def analyze_var(
     name: str,
     var: Var,
     itype: Instance,
-    info: TypeInfo,
     mx: MemberContext,
     *,
     implicit: bool = False,
+    is_trivial_self: bool = False,
 ) -> Type:
     """Analyze access to an attribute via a Var node.
 
@@ -772,71 +870,58 @@ def analyze_var(
     itype is the instance type in which attribute should be looked up
     original_type is the type of E in the expression E.var
     if implicit is True, the original Var was created as an assignment to self
+    if is_trivial_self is True, we can use fast path for bind_self().
     """
     # Found a member variable.
     original_itype = itype
     itype = map_instance_to_supertype(itype, var.info)
-    typ = var.type
+    if var.is_settable_property and mx.is_lvalue:
+        typ: Type | None = var.setter_type
+        if typ is None and var.is_ready:
+            # Existing synthetic properties may not set setter type. Fall back to getter.
+            typ = var.type
+    else:
+        typ = var.type
     if typ:
         if isinstance(typ, PartialType):
             return mx.chk.handle_partial_var_type(typ, mx.is_lvalue, var, mx.context)
-        if mx.is_lvalue and var.is_property and not var.is_settable_property:
-            # TODO allow setting attributes in subclass (although it is probably an error)
-            mx.msg.read_only_property(name, itype.type, mx.context)
-        if mx.is_lvalue and var.is_classvar:
-            mx.msg.cant_assign_to_classvar(name, mx.context)
-        t = freshen_all_functions_type_vars(typ)
-        t = expand_self_type_if_needed(t, mx, var, original_itype)
-        t = expand_type_by_instance(t, itype)
-        freeze_all_type_vars(t)
-        result = t
-        typ = get_proper_type(typ)
+        if mx.is_lvalue and not mx.suppress_errors:
+            if var.is_property and not var.is_settable_property:
+                mx.msg.read_only_property(name, itype.type, mx.context)
+            if var.is_classvar:
+                mx.msg.cant_assign_to_classvar(name, mx.context)
+        # This is the most common case for variables, so start with this.
+        result = expand_without_binding(typ, var, itype, original_itype, mx)
 
+        # A non-None value indicates that we should actually bind self for this variable.
         call_type: ProperType | None = None
         if var.is_initialized_in_class and (not is_instance_var(var) or mx.is_operator):
+            typ = get_proper_type(typ)
             if isinstance(typ, FunctionLike) and not typ.is_type_obj():
                 call_type = typ
             elif var.is_property:
-                call_type = get_proper_type(_analyze_member_access("__call__", typ, mx))
+                deco_mx = mx.copy_modified(original_type=typ, self_type=typ, is_lvalue=False)
+                call_type = get_proper_type(_analyze_member_access("__call__", typ, deco_mx))
             else:
                 call_type = typ
 
+        # Bound variables with callable types are treated like methods
+        # (these are usually method aliases like __rmul__ = __mul__).
         if isinstance(call_type, FunctionLike) and not call_type.is_type_obj():
-            if mx.is_lvalue:
-                if var.is_property:
-                    if not var.is_settable_property:
-                        mx.msg.read_only_property(name, itype.type, mx.context)
-                else:
-                    mx.msg.cant_assign_to_method(mx.context)
+            if mx.is_lvalue and not var.is_property and not mx.suppress_errors:
+                mx.msg.cant_assign_to_method(mx.context)
 
-            if not var.is_staticmethod:
-                # Class-level function objects and classmethods become bound methods:
-                # the former to the instance, the latter to the class.
-                functype: FunctionLike = call_type
-                # Use meet to narrow original_type to the dispatched type.
-                # For example, assume
-                # * A.f: Callable[[A1], None] where A1 <: A (maybe A1 == A)
-                # * B.f: Callable[[B1], None] where B1 <: B (maybe B1 == B)
-                # * x: Union[A1, B1]
-                # In `x.f`, when checking `x` against A1 we assume x is compatible with A
-                # and similarly for B1 when checking against B
-                dispatched_type = meet.meet_types(mx.original_type, itype)
-                signature = freshen_all_functions_type_vars(functype)
-                bound = get_proper_type(expand_self_type(var, signature, mx.original_type))
-                assert isinstance(bound, FunctionLike)
-                signature = bound
-                signature = check_self_arg(
-                    signature, dispatched_type, var.is_classmethod, mx.context, name, mx.msg
-                )
-                signature = bind_self(signature, mx.self_type, var.is_classmethod)
-                expanded_signature = expand_type_by_instance(signature, itype)
-                freeze_all_type_vars(expanded_signature)
-                if var.is_property:
-                    # A property cannot have an overloaded type => the cast is fine.
-                    assert isinstance(expanded_signature, CallableType)
-                    result = expanded_signature.ret_type
+        # Bind the self type for each callable component (when needed).
+        if call_type and not var.is_staticmethod:
+            bound_items = []
+            for ct in call_type.items if isinstance(call_type, UnionType) else [call_type]:
+                p_ct = get_proper_type(ct)
+                if isinstance(p_ct, FunctionLike) and not p_ct.is_type_obj():
+                    item = expand_and_bind_callable(p_ct, var, itype, name, mx, is_trivial_self)
                 else:
-                    result = expanded_signature
+                    item = expand_without_binding(ct, var, itype, original_itype, mx)
+                bound_items.append(item)
+            result = UnionType.make_union(bound_items)
     else:
         if not var.is_ready and not mx.no_deferral:
             mx.not_ready_callback(var.name, mx.context)
@@ -844,7 +929,7 @@ def analyze_var(
         result = AnyType(TypeOfAny.special_form)
     fullname = f"{var.info.fullname}.{name}"
     hook = mx.chk.plugin.get_attribute_hook(fullname)
-    if result and not mx.is_lvalue and not implicit:
+    if result and not (implicit or var.info.is_protocol and is_instance_var(var)):
         result = analyze_descriptor_access(result, mx)
     if hook:
         result = hook(
@@ -855,6 +940,45 @@ def analyze_var(
     return result
 
 
+def expand_without_binding(
+    typ: Type, var: Var, itype: Instance, original_itype: Instance, mx: MemberContext
+) -> Type:
+    typ = freshen_all_functions_type_vars(typ)
+    typ = expand_self_type_if_needed(typ, mx, var, original_itype)
+    expanded = expand_type_by_instance(typ, itype)
+    freeze_all_type_vars(expanded)
+    return expanded
+
+
+def expand_and_bind_callable(
+    functype: FunctionLike,
+    var: Var,
+    itype: Instance,
+    name: str,
+    mx: MemberContext,
+    is_trivial_self: bool,
+) -> Type:
+    functype = freshen_all_functions_type_vars(functype)
+    typ = get_proper_type(expand_self_type(var, functype, mx.original_type))
+    assert isinstance(typ, FunctionLike)
+    if is_trivial_self:
+        typ = bind_self_fast(typ, mx.self_type)
+    else:
+        typ = check_self_arg(typ, mx.self_type, var.is_classmethod, mx.context, name, mx.msg)
+        typ = bind_self(typ, mx.self_type, var.is_classmethod)
+    expanded = expand_type_by_instance(typ, itype)
+    freeze_all_type_vars(expanded)
+    if not var.is_property:
+        return expanded
+    # TODO: a decorated property can result in Overloaded here.
+    assert isinstance(expanded, CallableType)
+    if var.is_settable_property and mx.is_lvalue and var.setter_type is not None:
+        # TODO: use check_call() to infer better type, same as for __set__().
+        return expanded.arg_types[0]
+    else:
+        return expanded.ret_type
+
+
 def expand_self_type_if_needed(
     t: Type, mx: MemberContext, var: Var, itype: Instance, is_class: bool = False
 ) -> Type:
@@ -899,27 +1023,6 @@ def expand_self_type_if_needed(
         return t
 
 
-def freeze_all_type_vars(member_type: Type) -> None:
-    member_type.accept(FreezeTypeVarsVisitor())
-
-
-class FreezeTypeVarsVisitor(TypeTraverserVisitor):
-    def visit_callable_type(self, t: CallableType) -> None:
-        for v in t.variables:
-            v.id.meta_level = 0
-        super().visit_callable_type(t)
-
-
-def lookup_member_var_or_accessor(info: TypeInfo, name: str, is_lvalue: bool) -> SymbolNode | None:
-    """Find the attribute/accessor node that refers to a member of a type."""
-    # TODO handle lvalues
-    node = info.get(name)
-    if node:
-        return node.node
-    else:
-        return None
-
-
 def check_self_arg(
     functype: FunctionLike,
     dispatched_arg_type: Type,
@@ -933,13 +1036,9 @@ def check_self_arg(
     For example if the method is defined as:
         class A:
             def f(self: S) -> T: ...
-    then for 'x.f' we check that meet(type(x), A) <: S. If the method is overloaded, we
-    select only overloads items that satisfy this requirement. If there are no matching
+    then for 'x.f' we check that type(x) <: S. If the method is overloaded, we select
+    only overloads items that satisfy this requirement. If there are no matching
     overloads, an error is generated.
-
-    Note: dispatched_arg_type uses a meet to select a relevant item in case if the
-    original type of 'x' is a union. This is done because several special methods
-    treat union types in ad-hoc manner, so we can't use MemberContext.self_type yet.
     """
     items = functype.items
     if not items:
@@ -959,7 +1058,16 @@ def check_self_arg(
             selfarg = get_proper_type(item.arg_types[0])
             # This level of erasure matches the one in checker.check_func_def(),
             # better keep these two checks consistent.
-            if subtypes.is_subtype(dispatched_arg_type, erase_typevars(erase_to_bound(selfarg))):
+            if subtypes.is_subtype(
+                dispatched_arg_type,
+                erase_typevars(erase_to_bound(selfarg)),
+                # This is to work around the fact that erased ParamSpec and TypeVarTuple
+                # callables are not always compatible with non-erased ones both ways.
+                always_covariant=any(
+                    not isinstance(tv, TypeVarType) for tv in get_all_type_vars(selfarg)
+                ),
+                ignore_pos_arg_names=True,
+            ):
                 new_items.append(item)
             elif isinstance(selfarg, ParamSpecType):
                 # TODO: This is not always right. What's the most reasonable thing to do here?
@@ -1029,22 +1137,20 @@ def analyze_class_attribute_access(
 
     is_decorated = isinstance(node.node, Decorator)
     is_method = is_decorated or isinstance(node.node, FuncBase)
-    if mx.is_lvalue:
+    if mx.is_lvalue and not mx.suppress_errors:
         if is_method:
             mx.msg.cant_assign_to_method(mx.context)
         if isinstance(node.node, TypeInfo):
-            mx.msg.fail(message_registry.CANNOT_ASSIGN_TO_TYPE, mx.context)
+            mx.fail(message_registry.CANNOT_ASSIGN_TO_TYPE)
 
     # Refuse class attribute access if slot defined
     if info.slots and name in info.slots:
-        mx.msg.fail(message_registry.CLASS_VAR_CONFLICTS_SLOTS.format(name), mx.context)
+        mx.fail(message_registry.CLASS_VAR_CONFLICTS_SLOTS.format(name))
 
     # If a final attribute was declared on `self` in `__init__`, then it
     # can't be accessed on the class object.
     if node.implicit and isinstance(node.node, Var) and node.node.is_final:
-        mx.msg.fail(
-            message_registry.CANNOT_ACCESS_FINAL_INSTANCE_ATTR.format(node.node.name), mx.context
-        )
+        mx.fail(message_registry.CANNOT_ACCESS_FINAL_INSTANCE_ATTR.format(node.node.name))
 
     # An assignment to final attribute on class object is also always an error,
     # independently of types.
@@ -1094,6 +1200,7 @@ def analyze_class_attribute_access(
             def_vars = set(node.node.info.defn.type_vars)
             if not node.node.is_classvar and node.node.info.self_type:
                 def_vars.add(node.node.info.self_type)
+            # TODO: should we include ParamSpec etc. here (i.e. use get_all_type_vars)?
             typ_vars = set(get_type_vars(t))
             if def_vars & typ_vars:
                 # Exception: access on Type[...], including first argument of class methods is OK.
@@ -1102,7 +1209,7 @@ def analyze_class_attribute_access(
                         message = message_registry.GENERIC_CLASS_VAR_ACCESS
                     else:
                         message = message_registry.GENERIC_INSTANCE_VAR_CLASS_ACCESS
-                    mx.msg.fail(message, mx.context)
+                    mx.fail(message)
             t = expand_self_type_if_needed(t, mx, node.node, itype, is_class=True)
             # Erase non-mapped variables, but keep mapped ones, even if there is an error.
             # In the above example this means that we infer following types:
@@ -1111,17 +1218,30 @@ def analyze_class_attribute_access(
             t = erase_typevars(expand_type_by_instance(t, isuper), {tv.id for tv in def_vars})
 
         is_classmethod = (is_decorated and cast(Decorator, node.node).func.is_class) or (
-            isinstance(node.node, FuncBase) and node.node.is_class
+            isinstance(node.node, SYMBOL_FUNCBASE_TYPES) and node.node.is_class
         )
         is_staticmethod = (is_decorated and cast(Decorator, node.node).func.is_static) or (
-            isinstance(node.node, FuncBase) and node.node.is_static
+            isinstance(node.node, SYMBOL_FUNCBASE_TYPES) and node.node.is_static
         )
         t = get_proper_type(t)
-        if isinstance(t, FunctionLike) and is_classmethod:
+        is_trivial_self = False
+        if isinstance(node.node, Decorator):
+            # Use fast path if there are trivial decorators like @classmethod or @property
+            is_trivial_self = node.node.func.is_trivial_self and not node.node.decorators
+        elif isinstance(node.node, (FuncDef, OverloadedFuncDef)):
+            is_trivial_self = node.node.is_trivial_self
+        if isinstance(t, FunctionLike) and is_classmethod and not is_trivial_self:
             t = check_self_arg(t, mx.self_type, False, mx.context, name, mx.msg)
         result = add_class_tvars(
-            t, isuper, is_classmethod, is_staticmethod, mx.self_type, original_vars=original_vars
+            t,
+            isuper,
+            is_classmethod,
+            is_staticmethod,
+            mx.self_type,
+            original_vars=original_vars,
+            is_trivial_self=is_trivial_self,
         )
+        # __set__ is not called on class objects.
         if not mx.is_lvalue:
             result = analyze_descriptor_access(result, mx)
 
@@ -1131,13 +1251,19 @@ def analyze_class_attribute_access(
         return AnyType(TypeOfAny.special_form)
 
     if isinstance(node.node, TypeVarExpr):
-        mx.msg.fail(
-            message_registry.CANNOT_USE_TYPEVAR_AS_EXPRESSION.format(info.name, name), mx.context
-        )
+        mx.fail(message_registry.CANNOT_USE_TYPEVAR_AS_EXPRESSION.format(info.name, name))
         return AnyType(TypeOfAny.from_error)
 
+    # TODO: some logic below duplicates analyze_ref_expr in checkexpr.py
     if isinstance(node.node, TypeInfo):
-        return type_object_type(node.node, mx.named_type)
+        if node.node.typeddict_type:
+            # We special-case TypedDict, because they don't define any constructor.
+            return mx.chk.expr_checker.typeddict_callable(node.node)
+        elif node.node.fullname == "types.NoneType":
+            # We special case NoneType, because its stub definition is not related to None.
+            return TypeType(NoneType())
+        else:
+            return type_object_type(node.node, mx.named_type)
 
     if isinstance(node.node, MypyFile):
         # Reference to a module object.
@@ -1156,13 +1282,13 @@ def analyze_class_attribute_access(
             mx.not_ready_callback(name, mx.context)
             return AnyType(TypeOfAny.from_error)
     else:
-        assert isinstance(node.node, FuncBase)
+        assert isinstance(node.node, SYMBOL_FUNCBASE_TYPES)
         typ = function_type(node.node, mx.named_type("builtins.function"))
         # Note: if we are accessing class method on class object, the cls argument is bound.
         # Annotated and/or explicit class methods go through other code paths above, for
         # unannotated implicit class methods we do this here.
         if node.node.is_class:
-            typ = bind_self(typ, is_classmethod=True)
+            typ = bind_self_fast(typ)
         return apply_class_attr_hook(mx, hook, typ)
 
 
@@ -1214,7 +1340,7 @@ def analyze_typeddict_access(
                 typ, mx.context.index, setitem=True
             )
             assigned_readonly_keys = typ.readonly_keys & key_names
-            if assigned_readonly_keys:
+            if assigned_readonly_keys and not mx.suppress_errors:
                 mx.msg.readonly_keys_mutated(assigned_readonly_keys, context=mx.context)
         else:
             # It can also be `a.__setitem__(...)` direct call.
@@ -1249,6 +1375,7 @@ def add_class_tvars(
     is_staticmethod: bool,
     original_type: Type,
     original_vars: Sequence[TypeVarLikeType] | None = None,
+    is_trivial_self: bool = False,
 ) -> Type:
     """Instantiate type variables during analyze_class_attribute_access,
     e.g T and Q in the following:
@@ -1269,6 +1396,7 @@ def add_class_tvars(
         original_type: The value of the type B in the expression B.foo() or the corresponding
             component in case of a union (this is used to bind the self-types)
         original_vars: Type variables of the class callable on which the method was accessed
+        is_trivial_self: if True, we can use fast path for bind_self().
     Returns:
         Expanded method type with added type variables (when needed).
     """
@@ -1290,7 +1418,10 @@ def add_class_tvars(
         tvars = original_vars if original_vars is not None else []
         t = freshen_all_functions_type_vars(t)
         if is_classmethod:
-            t = bind_self(t, original_type, is_classmethod=True)
+            if is_trivial_self:
+                t = bind_self_fast(t, original_type)
+            else:
+                t = bind_self(t, original_type, is_classmethod=True)
         if is_classmethod or is_staticmethod:
             assert isuper is not None
             t = expand_type_by_instance(t, isuper)
@@ -1318,84 +1449,8 @@ def add_class_tvars(
     return t
 
 
-def type_object_type(info: TypeInfo, named_type: Callable[[str], Instance]) -> ProperType:
-    """Return the type of a type object.
-
-    For a generic type G with type variables T and S the type is generally of form
-
-      Callable[..., G[T, S]]
-
-    where ... are argument types for the __init__/__new__ method (without the self
-    argument). Also, the fallback type will be 'type' instead of 'function'.
-    """
-
-    # We take the type from whichever of __init__ and __new__ is first
-    # in the MRO, preferring __init__ if there is a tie.
-    init_method = info.get("__init__")
-    new_method = info.get("__new__")
-    if not init_method or not is_valid_constructor(init_method.node):
-        # Must be an invalid class definition.
-        return AnyType(TypeOfAny.from_error)
-    # There *should* always be a __new__ method except the test stubs
-    # lack it, so just copy init_method in that situation
-    new_method = new_method or init_method
-    if not is_valid_constructor(new_method.node):
-        # Must be an invalid class definition.
-        return AnyType(TypeOfAny.from_error)
-
-    # The two is_valid_constructor() checks ensure this.
-    assert isinstance(new_method.node, (SYMBOL_FUNCBASE_TYPES, Decorator))
-    assert isinstance(init_method.node, (SYMBOL_FUNCBASE_TYPES, Decorator))
-
-    init_index = info.mro.index(init_method.node.info)
-    new_index = info.mro.index(new_method.node.info)
-
-    fallback = info.metaclass_type or named_type("builtins.type")
-    if init_index < new_index:
-        method: FuncBase | Decorator = init_method.node
-        is_new = False
-    elif init_index > new_index:
-        method = new_method.node
-        is_new = True
-    else:
-        if init_method.node.info.fullname == "builtins.object":
-            # Both are defined by object.  But if we've got a bogus
-            # base class, we can't know for sure, so check for that.
-            if info.fallback_to_any:
-                # Construct a universal callable as the prototype.
-                any_type = AnyType(TypeOfAny.special_form)
-                sig = CallableType(
-                    arg_types=[any_type, any_type],
-                    arg_kinds=[ARG_STAR, ARG_STAR2],
-                    arg_names=["_args", "_kwds"],
-                    ret_type=any_type,
-                    fallback=named_type("builtins.function"),
-                )
-                return class_callable(sig, info, fallback, None, is_new=False)
-
-        # Otherwise prefer __init__ in a tie. It isn't clear that this
-        # is the right thing, but __new__ caused problems with
-        # typeshed (#5647).
-        method = init_method.node
-        is_new = False
-    # Construct callable type based on signature of __init__. Adjust
-    # return type and insert type arguments.
-    if isinstance(method, FuncBase):
-        t = function_type(method, fallback)
-    else:
-        assert isinstance(method.type, ProperType)
-        assert isinstance(method.type, FunctionLike)  # is_valid_constructor() ensures this
-        t = method.type
-    return type_object_type_from_function(t, info, method.info, fallback, is_new)
-
-
 def analyze_decorator_or_funcbase_access(
-    defn: Decorator | FuncBase,
-    itype: Instance,
-    info: TypeInfo,
-    self_type: Type | None,
-    name: str,
-    mx: MemberContext,
+    defn: Decorator | FuncBase, itype: Instance, name: str, mx: MemberContext
 ) -> Type:
     """Analyzes the type behind method access.
 
@@ -1403,20 +1458,47 @@ def analyze_decorator_or_funcbase_access
     See: https://github.com/python/mypy/issues/10409
     """
     if isinstance(defn, Decorator):
-        return analyze_var(name, defn.var, itype, info, mx)
-    return bind_self(
-        function_type(defn, mx.chk.named_type("builtins.function")), original_type=self_type
-    )
+        return analyze_var(name, defn.var, itype, mx)
+    typ = function_type(defn, mx.chk.named_type("builtins.function"))
+    is_trivial_self = False
+    if isinstance(defn, Decorator):
+        # Use fast path if there are trivial decorators like @classmethod or @property
+        is_trivial_self = defn.func.is_trivial_self and not defn.decorators
+    elif isinstance(defn, (FuncDef, OverloadedFuncDef)):
+        is_trivial_self = defn.is_trivial_self
+    if is_trivial_self:
+        return bind_self_fast(typ, mx.self_type)
+    typ = check_self_arg(typ, mx.self_type, defn.is_class, mx.context, name, mx.msg)
+    return bind_self(typ, original_type=mx.self_type, is_classmethod=defn.is_class)
 
 
-def is_valid_constructor(n: SymbolNode | None) -> bool:
-    """Does this node represents a valid constructor method?
+F = TypeVar("F", bound=FunctionLike)
 
-    This includes normal functions, overloaded functions, and decorators
-    that return a callable type.
+
+def bind_self_fast(method: F, original_type: Type | None = None) -> F:
+    """Return a copy of `method`, with the type of its first parameter (usually
+    self or cls) bound to original_type.
+
+    This is a faster version of mypy.typeops.bind_self() that can be used for methods
+    with trivial self/cls annotations.
     """
-    if isinstance(n, FuncBase):
-        return True
-    if isinstance(n, Decorator):
-        return isinstance(get_proper_type(n.type), FunctionLike)
-    return False
+    if isinstance(method, Overloaded):
+        items = [bind_self_fast(c, original_type) for c in method.items]
+        return cast(F, Overloaded(items))
+    assert isinstance(method, CallableType)
+    if not method.arg_types:
+        # Invalid method, return something.
+        return cast(F, method)
+    if method.arg_kinds[0] in (ARG_STAR, ARG_STAR2):
+        # See typeops.py for details.
+        return cast(F, method)
+    original_type = get_proper_type(original_type)
+    if isinstance(original_type, CallableType) and original_type.is_type_obj():
+        original_type = TypeType.make_normalized(original_type.ret_type)
+    res = method.copy_modified(
+        arg_types=method.arg_types[1:],
+        arg_kinds=method.arg_kinds[1:],
+        arg_names=method.arg_names[1:],
+        bound_args=[original_type],
+    )
+    return cast(F, res)
diff -pruN 1.15.0-5/mypy/checkpattern.py 1.16~rc0.1-1/mypy/checkpattern.py
--- 1.15.0-5/mypy/checkpattern.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/checkpattern.py	2025-05-27 17:21:15.000000000 +0000
@@ -5,8 +5,8 @@ from __future__ import annotations
 from collections import defaultdict
 from typing import Final, NamedTuple
 
-import mypy.checker
 from mypy import message_registry
+from mypy.checker_shared import TypeCheckerSharedApi, TypeRange
 from mypy.checkmember import analyze_member_access
 from mypy.expandtype import expand_type_by_instance
 from mypy.join import join_types
@@ -54,7 +54,7 @@ from mypy.types import (
     get_proper_type,
     split_with_prefix_and_suffix,
 )
-from mypy.typevars import fill_typevars
+from mypy.typevars import fill_typevars, fill_typevars_with_any
 from mypy.visitor import PatternVisitor
 
 self_match_type_names: Final = [
@@ -91,7 +91,7 @@ class PatternChecker(PatternVisitor[Patt
     """
 
     # Some services are provided by a TypeChecker instance.
-    chk: mypy.checker.TypeChecker
+    chk: TypeCheckerSharedApi
     # This is shared with TypeChecker, but stored also here for convenience.
     msg: MessageBuilder
     # Currently unused
@@ -112,7 +112,7 @@ class PatternChecker(PatternVisitor[Patt
     options: Options
 
     def __init__(
-        self, chk: mypy.checker.TypeChecker, msg: MessageBuilder, plugin: Plugin, options: Options
+        self, chk: TypeCheckerSharedApi, msg: MessageBuilder, plugin: Plugin, options: Options
     ) -> None:
         self.chk = chk
         self.msg = msg
@@ -544,16 +544,7 @@ class PatternChecker(PatternVisitor[Patt
             self.msg.fail(message_registry.CLASS_PATTERN_GENERIC_TYPE_ALIAS, o)
             return self.early_non_match()
         if isinstance(type_info, TypeInfo):
-            any_type = AnyType(TypeOfAny.implementation_artifact)
-            args: list[Type] = []
-            for tv in type_info.defn.type_vars:
-                if isinstance(tv, TypeVarTupleType):
-                    args.append(
-                        UnpackType(self.chk.named_generic_type("builtins.tuple", [any_type]))
-                    )
-                else:
-                    args.append(any_type)
-            typ: Type = Instance(type_info, args)
+            typ: Type = fill_typevars_with_any(type_info)
         elif isinstance(type_info, TypeAlias):
             typ = type_info.target
         elif (
@@ -607,7 +598,6 @@ class PatternChecker(PatternVisitor[Patt
                         is_lvalue=False,
                         is_super=False,
                         is_operator=False,
-                        msg=self.msg,
                         original_type=typ,
                         chk=self.chk,
                     )
@@ -673,7 +663,6 @@ class PatternChecker(PatternVisitor[Patt
                         is_lvalue=False,
                         is_super=False,
                         is_operator=False,
-                        msg=self.msg,
                         original_type=new_type,
                         chk=self.chk,
                     )
@@ -703,6 +692,8 @@ class PatternChecker(PatternVisitor[Patt
 
     def should_self_match(self, typ: Type) -> bool:
         typ = get_proper_type(typ)
+        if isinstance(typ, TupleType):
+            typ = typ.partial_fallback
         if isinstance(typ, Instance) and typ.type.get("__match_args__") is not None:
             # Named tuples and other subtypes of builtins that define __match_args__
             # should not self match.
@@ -811,7 +802,7 @@ def get_var(expr: Expression) -> Var:
     return node
 
 
-def get_type_range(typ: Type) -> mypy.checker.TypeRange:
+def get_type_range(typ: Type) -> TypeRange:
     typ = get_proper_type(typ)
     if (
         isinstance(typ, Instance)
@@ -819,7 +810,7 @@ def get_type_range(typ: Type) -> mypy.ch
         and isinstance(typ.last_known_value.value, bool)
     ):
         typ = typ.last_known_value
-    return mypy.checker.TypeRange(typ, is_upper_bound=False)
+    return TypeRange(typ, is_upper_bound=False)
 
 
 def is_uninhabited(typ: Type) -> bool:
diff -pruN 1.15.0-5/mypy/checkstrformat.py 1.16~rc0.1-1/mypy/checkstrformat.py
--- 1.15.0-5/mypy/checkstrformat.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/checkstrformat.py	2025-05-27 17:21:15.000000000 +0000
@@ -14,11 +14,15 @@ from __future__ import annotations
 
 import re
 from re import Match, Pattern
-from typing import TYPE_CHECKING, Callable, Final, Union, cast
+from typing import Callable, Final, Union, cast
 from typing_extensions import TypeAlias as _TypeAlias
 
 import mypy.errorcodes as codes
+from mypy import message_registry
+from mypy.checker_shared import TypeCheckerSharedApi
 from mypy.errors import Errors
+from mypy.maptype import map_instance_to_supertype
+from mypy.messages import MessageBuilder
 from mypy.nodes import (
     ARG_NAMED,
     ARG_POS,
@@ -41,6 +45,9 @@ from mypy.nodes import (
     TempNode,
     TupleExpr,
 )
+from mypy.parse import parse
+from mypy.subtypes import is_subtype
+from mypy.typeops import custom_special_method
 from mypy.types import (
     AnyType,
     Instance,
@@ -57,18 +64,6 @@ from mypy.types import (
     get_proper_types,
 )
 
-if TYPE_CHECKING:
-    # break import cycle only needed for mypy
-    import mypy.checker
-    import mypy.checkexpr
-
-from mypy import message_registry
-from mypy.maptype import map_instance_to_supertype
-from mypy.messages import MessageBuilder
-from mypy.parse import parse
-from mypy.subtypes import is_subtype
-from mypy.typeops import custom_special_method
-
 FormatStringExpr: _TypeAlias = Union[StrExpr, BytesExpr]
 Checkers: _TypeAlias = tuple[Callable[[Expression], None], Callable[[Type], bool]]
 MatchMap: _TypeAlias = dict[tuple[int, int], Match[str]]  # span -> match
@@ -299,21 +294,13 @@ class StringFormatterChecker:
     """
 
     # Some services are provided by a TypeChecker instance.
-    chk: mypy.checker.TypeChecker
+    chk: TypeCheckerSharedApi
     # This is shared with TypeChecker, but stored also here for convenience.
     msg: MessageBuilder
-    # Some services are provided by a ExpressionChecker instance.
-    exprchk: mypy.checkexpr.ExpressionChecker
 
-    def __init__(
-        self,
-        exprchk: mypy.checkexpr.ExpressionChecker,
-        chk: mypy.checker.TypeChecker,
-        msg: MessageBuilder,
-    ) -> None:
+    def __init__(self, chk: TypeCheckerSharedApi, msg: MessageBuilder) -> None:
         """Construct an expression type checker."""
         self.chk = chk
-        self.exprchk = exprchk
         self.msg = msg
 
     def check_str_format_call(self, call: CallExpr, format_value: str) -> None:
@@ -618,7 +605,7 @@ class StringFormatterChecker:
         # TODO: fix column to point to actual start of the format specifier _within_ string.
         temp_ast.line = ctx.line
         temp_ast.column = ctx.column
-        self.exprchk.accept(temp_ast)
+        self.chk.expr_checker.accept(temp_ast)
         return temp_ast
 
     def validate_and_transform_accessors(
@@ -685,7 +672,7 @@ class StringFormatterChecker:
         """Check the types of the 'replacements' in a string interpolation
         expression: str % replacements.
         """
-        self.exprchk.accept(expr)
+        self.chk.expr_checker.accept(expr)
         specifiers = parse_conversion_specifiers(expr.value)
         has_mapping_keys = self.analyze_conversion_specifiers(specifiers, expr)
         if has_mapping_keys is None:
diff -pruN 1.15.0-5/mypy/config_parser.py 1.16~rc0.1-1/mypy/config_parser.py
--- 1.15.0-5/mypy/config_parser.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/config_parser.py	2025-05-27 17:21:15.000000000 +0000
@@ -55,8 +55,10 @@ def parse_version(v: str | float) -> tup
 def try_split(v: str | Sequence[str], split_regex: str = "[,]") -> list[str]:
     """Split and trim a str or list of str into a list of str"""
     if isinstance(v, str):
-        return [p.strip() for p in re.split(split_regex, v)]
-
+        items = [p.strip() for p in re.split(split_regex, v)]
+        if items and items[-1] == "":
+            items.pop(-1)
+        return items
     return [p.strip() for p in v]
 
 
@@ -126,7 +128,7 @@ def split_and_match_files(paths: str) ->
     Returns a list of file paths
     """
 
-    return split_and_match_files_list(paths.split(","))
+    return split_and_match_files_list(split_commas(paths))
 
 
 def check_follow_imports(choice: str) -> str:
@@ -647,6 +649,11 @@ def parse_mypy_comments(
         # method is to create a config parser.
         parser = configparser.RawConfigParser()
         options, parse_errors = mypy_comments_to_config_map(line, template)
+
+        if "python_version" in options:
+            errors.append((lineno, "python_version not supported in inline configuration"))
+            del options["python_version"]
+
         parser["dummy"] = options
         errors.extend((lineno, x) for x in parse_errors)
 
diff -pruN 1.15.0-5/mypy/constraints.py 1.16~rc0.1-1/mypy/constraints.py
--- 1.15.0-5/mypy/constraints.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/constraints.py	2025-05-27 17:21:15.000000000 +0000
@@ -53,6 +53,7 @@ from mypy.types import (
     UnionType,
     UnpackType,
     find_unpack_in_list,
+    flatten_nested_tuples,
     get_proper_type,
     has_recursive_types,
     has_type_vars,
@@ -127,12 +128,12 @@ def infer_constraints_for_callable(
     param_spec_arg_kinds = []
 
     incomplete_star_mapping = False
-    for i, actuals in enumerate(formal_to_actual):
+    for i, actuals in enumerate(formal_to_actual):  # TODO: isn't this `enumerate(arg_types)`?
         for actual in actuals:
-            if actual is None and callee.arg_kinds[i] in (ARG_STAR, ARG_STAR2):
+            if actual is None and callee.arg_kinds[i] in (ARG_STAR, ARG_STAR2):  # type: ignore[unreachable]
                 # We can't use arguments to infer ParamSpec constraint, if only some
                 # are present in the current inference pass.
-                incomplete_star_mapping = True
+                incomplete_star_mapping = True  # type: ignore[unreachable]
                 break
 
     for i, actuals in enumerate(formal_to_actual):
@@ -385,7 +386,7 @@ def _infer_constraints(
         res = []
         for a_item in actual.items:
             # `orig_template` has to be preserved intact in case it's recursive.
-            # If we unwraped ``type[...]`` previously, wrap the item back again,
+            # If we unwrapped ``type[...]`` previously, wrap the item back again,
             # as ``type[...]`` can't be removed from `orig_template`.
             if type_type_unwrapped:
                 a_item = TypeType.make_normalized(a_item)
@@ -511,7 +512,7 @@ def handle_recursive_union(template: Uni
     ) or infer_constraints(UnionType.make_union(type_var_items), actual, direction)
 
 
-def any_constraints(options: list[list[Constraint] | None], eager: bool) -> list[Constraint]:
+def any_constraints(options: list[list[Constraint] | None], *, eager: bool) -> list[Constraint]:
     """Deduce what we can from a collection of constraint lists.
 
     It's a given that at least one of the lists must be satisfied. A
@@ -545,12 +546,8 @@ def any_constraints(options: list[list[C
             for option in valid_options:
                 if option in trivial_options:
                     continue
-                if option is not None:
-                    merged_option: list[Constraint] | None = [merge_with_any(c) for c in option]
-                else:
-                    merged_option = None
-                merged_options.append(merged_option)
-            return any_constraints(list(merged_options), eager)
+                merged_options.append([merge_with_any(c) for c in option])
+            return any_constraints(list(merged_options), eager=eager)
 
     # If normal logic didn't work, try excluding trivially unsatisfiable constraint (due to
     # upper bounds) from each option, and comparing them again.
@@ -558,6 +555,14 @@ def any_constraints(options: list[list[C
     if filtered_options != options:
         return any_constraints(filtered_options, eager=eager)
 
+    # Try harder: if that didn't work, try to strip typevars that aren't meta vars.
+    # Note this is what we would always do, but unfortunately some callers may not
+    # set the meta var status correctly (for historical reasons), so we use this as
+    # a fallback only.
+    filtered_options = [exclude_non_meta_vars(o) for o in options]
+    if filtered_options != options:
+        return any_constraints(filtered_options, eager=eager)
+
     # Otherwise, there are either no valid options or multiple, inconsistent valid
     # options. Give up and deduce nothing.
     return []
@@ -572,6 +577,7 @@ def filter_satisfiable(option: list[Cons
     """
     if not option:
         return option
+
     satisfiable = []
     for c in option:
         if isinstance(c.origin_type_var, TypeVarType) and c.origin_type_var.values:
@@ -586,6 +592,15 @@ def filter_satisfiable(option: list[Cons
     return satisfiable
 
 
+def exclude_non_meta_vars(option: list[Constraint] | None) -> list[Constraint] | None:
+    # If we had an empty list, keep it intact
+    if not option:
+        return option
+    # However, if none of the options actually references meta vars, better remove
+    # this constraint entirely.
+    return [c for c in option if c.type_var.is_meta_var()] or None
+
+
 def is_same_constraints(x: list[Constraint], y: list[Constraint]) -> bool:
     for c1 in x:
         if not any(is_same_constraint(c1, c2) for c2 in y):
@@ -756,40 +771,40 @@ class ConstraintBuilderVisitor(TypeVisit
                         "__call__", template, actual, is_operator=True
                     )
                     assert call is not None
-                    if mypy.subtypes.is_subtype(actual, erase_typevars(call)):
-                        subres = infer_constraints(call, actual, self.direction)
-                        res.extend(subres)
+                    if (
+                        self.direction == SUPERTYPE_OF
+                        and mypy.subtypes.is_subtype(actual, erase_typevars(call))
+                        or self.direction == SUBTYPE_OF
+                        and mypy.subtypes.is_subtype(erase_typevars(call), actual)
+                    ):
+                        res.extend(infer_constraints(call, actual, self.direction))
                     template.type.inferring.pop()
         if isinstance(actual, CallableType) and actual.fallback is not None:
-            if actual.is_type_obj() and template.type.is_protocol:
+            if (
+                actual.is_type_obj()
+                and template.type.is_protocol
+                and self.direction == SUPERTYPE_OF
+            ):
                 ret_type = get_proper_type(actual.ret_type)
                 if isinstance(ret_type, TupleType):
                     ret_type = mypy.typeops.tuple_fallback(ret_type)
                 if isinstance(ret_type, Instance):
-                    if self.direction == SUBTYPE_OF:
-                        subtype = template
-                    else:
-                        subtype = ret_type
                     res.extend(
                         self.infer_constraints_from_protocol_members(
-                            ret_type, template, subtype, template, class_obj=True
+                            ret_type, template, ret_type, template, class_obj=True
                         )
                     )
             actual = actual.fallback
         if isinstance(actual, TypeType) and template.type.is_protocol:
-            if isinstance(actual.item, Instance):
-                if self.direction == SUBTYPE_OF:
-                    subtype = template
-                else:
-                    subtype = actual.item
-                res.extend(
-                    self.infer_constraints_from_protocol_members(
-                        actual.item, template, subtype, template, class_obj=True
-                    )
-                )
             if self.direction == SUPERTYPE_OF:
-                # Infer constraints for Type[T] via metaclass of T when it makes sense.
                 a_item = actual.item
+                if isinstance(a_item, Instance):
+                    res.extend(
+                        self.infer_constraints_from_protocol_members(
+                            a_item, template, a_item, template, class_obj=True
+                        )
+                    )
+                # Infer constraints for Type[T] via metaclass of T when it makes sense.
                 if isinstance(a_item, TypeVarType):
                     a_item = get_proper_type(a_item.upper_bound)
                 if isinstance(a_item, Instance) and a_item.type.metaclass_type:
@@ -1043,6 +1058,17 @@ class ConstraintBuilderVisitor(TypeVisit
                 return []  # See #11020
             # The above is safe since at this point we know that 'instance' is a subtype
             # of (erased) 'template', therefore it defines all protocol members
+            if class_obj:
+                # For class objects we must only infer constraints if possible, otherwise it
+                # can lead to confusion between class and instance, for example StrEnum is
+                # Iterable[str] for an instance, but Iterable[StrEnum] for a class object.
+                if not mypy.subtypes.is_subtype(
+                    inst, erase_typevars(temp), ignore_pos_arg_names=True
+                ):
+                    continue
+            # This exception matches the one in subtypes.py, see PR #14121 for context.
+            if member == "__call__" and instance.type.is_metaclass():
+                continue
             res.extend(infer_constraints(temp, inst, self.direction))
             if mypy.subtypes.IS_SETTABLE in mypy.subtypes.get_member_flags(member, protocol):
                 # Settable members are invariant, add opposite constraints
@@ -1055,11 +1081,11 @@ class ConstraintBuilderVisitor(TypeVisit
         # using e.g. callback protocols.
         # TODO: check that callables match? Ideally we should not infer constraints
         # callables that can never be subtypes of one another in given direction.
-        template = template.with_unpacked_kwargs()
+        template = template.with_unpacked_kwargs().with_normalized_var_args()
         extra_tvars = False
         if isinstance(self.actual, CallableType):
             res: list[Constraint] = []
-            cactual = self.actual.with_unpacked_kwargs()
+            cactual = self.actual.with_unpacked_kwargs().with_normalized_var_args()
             param_spec = template.param_spec()
 
             template_ret_type, cactual_ret_type = template.ret_type, cactual.ret_type
@@ -1340,7 +1366,9 @@ class ConstraintBuilderVisitor(TypeVisit
 
     def infer_against_any(self, types: Iterable[Type], any_type: AnyType) -> list[Constraint]:
         res: list[Constraint] = []
-        for t in types:
+        # Some items may be things like `*Tuple[*Ts, T]` for example from callable types with
+        # suffix after *arg, so flatten them.
+        for t in flatten_nested_tuples(types):
             if isinstance(t, UnpackType):
                 if isinstance(t.type, TypeVarTupleType):
                     res.append(Constraint(t.type, self.direction, any_type))
diff -pruN 1.15.0-5/mypy/defaults.py 1.16~rc0.1-1/mypy/defaults.py
--- 1.15.0-5/mypy/defaults.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/defaults.py	2025-05-27 17:21:15.000000000 +0000
@@ -17,9 +17,10 @@ CACHE_DIR: Final = ".mypy_cache"
 CONFIG_NAMES: Final = ["mypy.ini", ".mypy.ini"]
 SHARED_CONFIG_NAMES: Final = ["pyproject.toml", "setup.cfg"]
 
-USER_CONFIG_FILES: Final = ["~/.config/mypy/config", "~/.mypy.ini"]
+USER_CONFIG_FILES: list[str] = ["~/.config/mypy/config", "~/.mypy.ini"]
 if os.environ.get("XDG_CONFIG_HOME"):
     USER_CONFIG_FILES.insert(0, os.path.join(os.environ["XDG_CONFIG_HOME"], "mypy/config"))
+USER_CONFIG_FILES = [os.path.expanduser(f) for f in USER_CONFIG_FILES]
 
 # This must include all reporters defined in mypy.report. This is defined here
 # to make reporter names available without importing mypy.report -- this speeds
diff -pruN 1.15.0-5/mypy/dmypy/client.py 1.16~rc0.1-1/mypy/dmypy/client.py
--- 1.15.0-5/mypy/dmypy/client.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/dmypy/client.py	2025-05-27 17:21:15.000000000 +0000
@@ -20,6 +20,7 @@ from typing import Any, Callable, NoRetu
 from mypy.dmypy_os import alive, kill
 from mypy.dmypy_util import DEFAULT_STATUS_FILE, receive, send
 from mypy.ipc import IPCClient, IPCException
+from mypy.main import RECURSION_LIMIT
 from mypy.util import check_python_version, get_terminal_width, should_force_color
 from mypy.version import __version__
 
@@ -28,13 +29,16 @@ from mypy.version import __version__
 
 
 class AugmentedHelpFormatter(argparse.RawDescriptionHelpFormatter):
-    def __init__(self, prog: str) -> None:
-        super().__init__(prog=prog, max_help_position=30)
+    def __init__(self, prog: str, **kwargs: Any) -> None:
+        super().__init__(prog=prog, max_help_position=30, **kwargs)
 
 
 parser = argparse.ArgumentParser(
     prog="dmypy", description="Client for mypy daemon mode", fromfile_prefix_chars="@"
 )
+if sys.version_info >= (3, 14):
+    parser.color = True  # Set as init arg in 3.14
+
 parser.set_defaults(action=None)
 parser.add_argument(
     "--status-file", default=DEFAULT_STATUS_FILE, help="status file to retrieve daemon details"
@@ -268,6 +272,10 @@ class BadStatus(Exception):
 def main(argv: list[str]) -> None:
     """The code is top-down."""
     check_python_version("dmypy")
+
+    # set recursion limit consistent with mypy/main.py
+    sys.setrecursionlimit(RECURSION_LIMIT)
+
     args = parser.parse_args(argv)
     if not args.action:
         parser.print_usage()
diff -pruN 1.15.0-5/mypy/dmypy_server.py 1.16~rc0.1-1/mypy/dmypy_server.py
--- 1.15.0-5/mypy/dmypy_server.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/dmypy_server.py	2025-05-27 17:21:15.000000000 +0000
@@ -620,6 +620,9 @@ class Server:
         t1 = time.time()
         manager.log(f"fine-grained increment: find_changed: {t1 - t0:.3f}s")
 
+        # Track all modules encountered so far. New entries for all dependencies
+        # are added below by other module finding methods below. All dependencies
+        # in graph but not in `seen` are considered deleted at the end of this method.
         seen = {source.module for source in sources}
 
         # Find changed modules reachable from roots (or in roots) already in graph.
@@ -736,7 +739,9 @@ class Server:
         Args:
             roots: modules where to start search from
             graph: module graph to use for the search
-            seen: modules we've seen before that won't be visited (mutated here!!)
+            seen: modules we've seen before that won't be visited (mutated here!!).
+                  Needed to accumulate all modules encountered during update and remove
+                  everything that no longer exists.
             changed_paths: which paths have changed (stop search here and return any found)
 
         Return (encountered reachable changed modules,
@@ -756,7 +761,8 @@ class Server:
                 changed.append((nxt.module, nxt.path))
             elif nxt.module in graph:
                 state = graph[nxt.module]
-                for dep in state.dependencies:
+                ancestors = state.ancestors or []
+                for dep in state.dependencies + ancestors:
                     if dep not in seen:
                         seen.add(dep)
                         worklist.append(BuildSource(graph[dep].path, graph[dep].id, followed=True))
@@ -775,7 +781,9 @@ class Server:
         """Find suppressed modules that have been added (and not included in seen).
 
         Args:
-            seen: reachable modules we've seen before (mutated here!!)
+            seen: reachable modules we've seen before (mutated here!!).
+                  Needed to accumulate all modules encountered during update and remove
+                  everything that no longer exists.
 
         Return suppressed, added modules.
         """
diff -pruN 1.15.0-5/mypy/erasetype.py 1.16~rc0.1-1/mypy/erasetype.py
--- 1.15.0-5/mypy/erasetype.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/erasetype.py	2025-05-27 17:21:15.000000000 +0000
@@ -203,6 +203,14 @@ class TypeVarEraser(TypeTranslator):
                     return unpacked
         return result
 
+    def visit_callable_type(self, t: CallableType) -> Type:
+        result = super().visit_callable_type(t)
+        assert isinstance(result, ProperType) and isinstance(result, CallableType)
+        # Usually this is done in semanal_typeargs.py, but erasure can create
+        # a non-normal callable from normal one.
+        result.normalize_trivial_unpack()
+        return result
+
     def visit_type_var_tuple(self, t: TypeVarTupleType) -> Type:
         if self.erase_id(t.id):
             return t.tuple_fallback.copy_modified(args=[self.replacement])
diff -pruN 1.15.0-5/mypy/errors.py 1.16~rc0.1-1/mypy/errors.py
--- 1.15.0-5/mypy/errors.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/errors.py	2025-05-27 17:21:15.000000000 +0000
@@ -11,7 +11,6 @@ from typing_extensions import Literal, T
 from mypy import errorcodes as codes
 from mypy.error_formatter import ErrorFormatter
 from mypy.errorcodes import IMPORT, IMPORT_NOT_FOUND, IMPORT_UNTYPED, ErrorCode, mypy_error_codes
-from mypy.message_registry import ErrorMessage
 from mypy.options import Options
 from mypy.scope import Scope
 from mypy.util import DEFAULT_SOURCE_OFFSET, is_typeshed_file
@@ -39,7 +38,7 @@ HIDE_LINK_CODES: Final = {
     codes.OVERRIDE,
 }
 
-allowed_duplicates: Final = ["@overload", "Got:", "Expected:"]
+allowed_duplicates: Final = ["@overload", "Got:", "Expected:", "Expected setter type:"]
 
 BASE_RTD_URL: Final = "https://mypy.rtfd.io/en/stable/_refs.html#code"
 
@@ -172,10 +171,12 @@ class ErrorWatcher:
         *,
         filter_errors: bool | Callable[[str, ErrorInfo], bool] = False,
         save_filtered_errors: bool = False,
+        filter_deprecated: bool = False,
     ) -> None:
         self.errors = errors
         self._has_new_errors = False
         self._filter = filter_errors
+        self._filter_deprecated = filter_deprecated
         self._filtered: list[ErrorInfo] | None = [] if save_filtered_errors else None
 
     def __enter__(self) -> ErrorWatcher:
@@ -196,7 +197,8 @@ class ErrorWatcher:
         ErrorWatcher further down the stack and from being recorded by Errors
         """
         if info.code == codes.DEPRECATED:
-            return False
+            # Deprecated is not a type error, so it is handled on opt-in basis here.
+            return self._filter_deprecated
 
         self._has_new_errors = True
         if isinstance(self._filter, bool):
@@ -504,10 +506,13 @@ class Errors:
                 # line == end_line for most nodes, so we only loop once.
                 for scope_line in lines:
                     if self.is_ignored_error(scope_line, info, self.ignored_lines[file]):
+                        err_code = info.code or codes.MISC
+                        if not self.is_error_code_enabled(err_code):
+                            # Error code is disabled - don't mark the current
+                            # "type: ignore" comment as used.
+                            return
                         # Annotation requests us to ignore all errors on this line.
-                        self.used_ignored_lines[file][scope_line].append(
-                            (info.code or codes.MISC).code
-                        )
+                        self.used_ignored_lines[file][scope_line].append(err_code.code)
                         return
             if file in self.ignored_files:
                 return
@@ -1066,34 +1071,19 @@ class Errors:
                         (file, -1, -1, -1, -1, "note", f'In class "{e.type}":', e.allow_dups, None)
                     )
 
-            if isinstance(e.message, ErrorMessage):
-                result.append(
-                    (
-                        file,
-                        e.line,
-                        e.column,
-                        e.end_line,
-                        e.end_column,
-                        e.severity,
-                        e.message.value,
-                        e.allow_dups,
-                        e.code,
-                    )
-                )
-            else:
-                result.append(
-                    (
-                        file,
-                        e.line,
-                        e.column,
-                        e.end_line,
-                        e.end_column,
-                        e.severity,
-                        e.message,
-                        e.allow_dups,
-                        e.code,
-                    )
+            result.append(
+                (
+                    file,
+                    e.line,
+                    e.column,
+                    e.end_line,
+                    e.end_column,
+                    e.severity,
+                    e.message,
+                    e.allow_dups,
+                    e.code,
                 )
+            )
 
             prev_import_context = e.import_ctx
             prev_function_or_member = e.function_or_member
diff -pruN 1.15.0-5/mypy/expandtype.py 1.16~rc0.1-1/mypy/expandtype.py
--- 1.15.0-5/mypy/expandtype.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/expandtype.py	2025-05-27 17:21:15.000000000 +0000
@@ -226,6 +226,8 @@ class ExpandTypeVisitor(TrivialSynthetic
             if isinstance(arg, UnpackType):
                 unpacked = get_proper_type(arg.type)
                 if isinstance(unpacked, Instance):
+                    # TODO: this and similar asserts below may be unsafe because get_proper_type()
+                    # may be called during semantic analysis before all invalid types are removed.
                     assert unpacked.type.fullname == "builtins.tuple"
                     args = list(unpacked.args)
         return t.copy_modified(args=args)
@@ -333,10 +335,7 @@ class ExpandTypeVisitor(TrivialSynthetic
 
         var_arg_type = get_proper_type(var_arg.type)
         new_unpack: Type
-        if isinstance(var_arg_type, Instance):
-            # we have something like Unpack[Tuple[Any, ...]]
-            new_unpack = UnpackType(var_arg.type.accept(self))
-        elif isinstance(var_arg_type, TupleType):
+        if isinstance(var_arg_type, TupleType):
             # We have something like Unpack[Tuple[Unpack[Ts], X1, X2]]
             expanded_tuple = var_arg_type.accept(self)
             assert isinstance(expanded_tuple, ProperType) and isinstance(expanded_tuple, TupleType)
@@ -348,6 +347,11 @@ class ExpandTypeVisitor(TrivialSynthetic
             fallback = var_arg_type.tuple_fallback
             expanded_items = self.expand_unpack(var_arg)
             new_unpack = UnpackType(TupleType(expanded_items, fallback))
+        # Since get_proper_type() may be called in semanal.py before callable
+        # normalization happens, we need to also handle non-normal cases here.
+        elif isinstance(var_arg_type, Instance):
+            # we have something like Unpack[Tuple[Any, ...]]
+            new_unpack = UnpackType(var_arg.type.accept(self))
         else:
             # We have invalid type in Unpack. This can happen when expanding aliases
             # to Callable[[*Invalid], Ret]
diff -pruN 1.15.0-5/mypy/fastparse.py 1.16~rc0.1-1/mypy/fastparse.py
--- 1.15.0-5/mypy/fastparse.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/fastparse.py	2025-05-27 17:21:15.000000000 +0000
@@ -239,6 +239,29 @@ def parse(
             strip_function_bodies=strip_function_bodies,
             path=fnam,
         ).visit(ast)
+
+    except RecursionError as e:
+        # For very complex expressions it is possible to hit recursion limit
+        # before reaching a leaf node.
+        # Should reject at top level instead at bottom, since bottom would already
+        # be at the threshold of the recursion limit, and may fail again later.
+        # E.G. x1+x2+x3+...+xn -> BinOp(left=BinOp(left=BinOp(left=...
+        try:
+            # But to prove that is the cause of this particular recursion error,
+            # try to walk the tree using builtin visitor
+            ast3.NodeVisitor().visit(ast)
+        except RecursionError:
+            errors.report(
+                -1, -1, "Source expression too complex to parse", blocker=False, code=codes.MISC
+            )
+
+            tree = MypyFile([], [], False, {})
+
+        else:
+            # re-raise original recursion error if it *can* be unparsed,
+            # maybe this is some other issue that shouldn't be silenced/misdirected
+            raise e
+
     except SyntaxError as e:
         message = e.msg
         if feature_version > sys.version_info.minor and message.startswith("invalid syntax"):
@@ -381,7 +404,7 @@ class ASTConverter:
     def note(self, msg: str, line: int, column: int) -> None:
         self.errors.report(line, column, msg, severity="note", code=codes.SYNTAX)
 
-    def fail(self, msg: ErrorMessage, line: int, column: int, blocker: bool = True) -> None:
+    def fail(self, msg: ErrorMessage, line: int, column: int, blocker: bool) -> None:
         if blocker or not self.options.ignore_errors:
             # Make sure self.errors reflects any type ignores that we have parsed
             self.errors.set_file_ignored_lines(
@@ -406,6 +429,7 @@ class ASTConverter:
             method = "visit_" + node.__class__.__name__
             visitor = getattr(self, method)
             self.visitor_cache[typeobj] = visitor
+
         return visitor(node)
 
     def set_line(self, node: N, n: AstNode) -> N:
@@ -557,7 +581,7 @@ class ASTConverter:
         ast3.Is: "is",
         ast3.IsNot: "is not",
         ast3.In: "in",
-        ast3.NotIn: "not in",
+        ast3.NotIn: "not in",  # codespell:ignore notin
     }
 
     def from_comp_operator(self, op: ast3.cmpop) -> str:
@@ -921,7 +945,12 @@ class ASTConverter:
                 ):
                     if n.returns:
                         # PEP 484 disallows both type annotations and type comments
-                        self.fail(message_registry.DUPLICATE_TYPE_SIGNATURES, lineno, n.col_offset)
+                        self.fail(
+                            message_registry.DUPLICATE_TYPE_SIGNATURES,
+                            lineno,
+                            n.col_offset,
+                            blocker=False,
+                        )
                     arg_types = [
                         (
                             a.type_annotation
@@ -933,7 +962,12 @@ class ASTConverter:
                 else:
                     # PEP 484 disallows both type annotations and type comments
                     if n.returns or any(a.type_annotation is not None for a in args):
-                        self.fail(message_registry.DUPLICATE_TYPE_SIGNATURES, lineno, n.col_offset)
+                        self.fail(
+                            message_registry.DUPLICATE_TYPE_SIGNATURES,
+                            lineno,
+                            n.col_offset,
+                            blocker=False,
+                        )
                     translated_args: list[Type] = TypeConverter(
                         self.errors, line=lineno, override_column=n.col_offset
                     ).translate_expr_list(func_type_ast.argtypes)
@@ -948,7 +982,7 @@ class ASTConverter:
             except SyntaxError:
                 stripped_type = n.type_comment.split("#", 2)[0].strip()
                 err_msg = message_registry.TYPE_COMMENT_SYNTAX_ERROR_VALUE.format(stripped_type)
-                self.fail(err_msg, lineno, n.col_offset)
+                self.fail(err_msg, lineno, n.col_offset, blocker=False)
                 if n.type_comment and n.type_comment[0] not in ["(", "#"]:
                     self.note(
                         "Suggestion: wrap argument types in parentheses", lineno, n.col_offset
@@ -970,7 +1004,12 @@ class ASTConverter:
         func_type = None
         if any(arg_types) or return_type:
             if len(arg_types) != 1 and any(isinstance(t, EllipsisType) for t in arg_types):
-                self.fail(message_registry.ELLIPSIS_WITH_OTHER_TYPEARGS, lineno, n.col_offset)
+                self.fail(
+                    message_registry.ELLIPSIS_WITH_OTHER_TYPEARGS,
+                    lineno,
+                    n.col_offset,
+                    blocker=False,
+                )
             elif len(arg_types) > len(arg_kinds):
                 self.fail(
                     message_registry.TYPE_SIGNATURE_TOO_MANY_ARGS,
@@ -1097,7 +1136,12 @@ class ASTConverter:
             annotation = arg.annotation
             type_comment = arg.type_comment
             if annotation is not None and type_comment is not None:
-                self.fail(message_registry.DUPLICATE_TYPE_SIGNATURES, arg.lineno, arg.col_offset)
+                self.fail(
+                    message_registry.DUPLICATE_TYPE_SIGNATURES,
+                    arg.lineno,
+                    arg.col_offset,
+                    blocker=False,
+                )
             arg_type = None
             if annotation is not None:
                 arg_type = TypeConverter(self.errors, line=arg.lineno).visit(annotation)
@@ -1106,7 +1150,9 @@ class ASTConverter:
         if argument_elide_name(arg.arg):
             pos_only = True
 
-        argument = Argument(Var(arg.arg, arg_type), arg_type, self.visit(default), kind, pos_only)
+        var = Var(arg.arg, arg_type)
+        var.is_inferred = False
+        argument = Argument(var, arg_type, self.visit(default), kind, pos_only)
         argument.set_line(
             arg.lineno,
             arg.col_offset,
@@ -1116,7 +1162,7 @@ class ASTConverter:
         return argument
 
     def fail_arg(self, msg: str, arg: ast3.arg) -> None:
-        self.fail(ErrorMessage(msg), arg.lineno, arg.col_offset)
+        self.fail(ErrorMessage(msg), arg.lineno, arg.col_offset, blocker=True)
 
     # ClassDef(identifier name,
     #  expr* bases,
@@ -1162,18 +1208,21 @@ class ASTConverter:
                 message_registry.TYPE_VAR_YIELD_EXPRESSION_IN_BOUND,
                 type_param.lineno,
                 type_param.col_offset,
+                blocker=True,
             )
         if isinstance(incorrect_expr, ast3.NamedExpr):
             self.fail(
                 message_registry.TYPE_VAR_NAMED_EXPRESSION_IN_BOUND,
                 type_param.lineno,
                 type_param.col_offset,
+                blocker=True,
             )
         if isinstance(incorrect_expr, ast3.Await):
             self.fail(
                 message_registry.TYPE_VAR_AWAIT_EXPRESSION_IN_BOUND,
                 type_param.lineno,
                 type_param.col_offset,
+                blocker=True,
             )
 
     def translate_type_params(self, type_params: list[Any]) -> list[TypeParam]:
@@ -1788,11 +1837,26 @@ class ASTConverter:
         if incorrect_expr is None:
             return
         if isinstance(incorrect_expr, (ast3.Yield, ast3.YieldFrom)):
-            self.fail(message_registry.TYPE_ALIAS_WITH_YIELD_EXPRESSION, n.lineno, n.col_offset)
+            self.fail(
+                message_registry.TYPE_ALIAS_WITH_YIELD_EXPRESSION,
+                n.lineno,
+                n.col_offset,
+                blocker=True,
+            )
         if isinstance(incorrect_expr, ast3.NamedExpr):
-            self.fail(message_registry.TYPE_ALIAS_WITH_NAMED_EXPRESSION, n.lineno, n.col_offset)
+            self.fail(
+                message_registry.TYPE_ALIAS_WITH_NAMED_EXPRESSION,
+                n.lineno,
+                n.col_offset,
+                blocker=True,
+            )
         if isinstance(incorrect_expr, ast3.Await):
-            self.fail(message_registry.TYPE_ALIAS_WITH_AWAIT_EXPRESSION, n.lineno, n.col_offset)
+            self.fail(
+                message_registry.TYPE_ALIAS_WITH_AWAIT_EXPRESSION,
+                n.lineno,
+                n.col_offset,
+                blocker=True,
+            )
 
     # TypeAlias(identifier name, type_param* type_params, expr value)
     def visit_TypeAlias(self, n: ast_TypeAlias) -> TypeAliasStmt | AssignmentStmt:
@@ -2052,13 +2116,16 @@ class TypeConverter:
 
         value = self.visit(n.value)
         if isinstance(value, UnboundType) and not value.args:
-            return UnboundType(
+            result = UnboundType(
                 value.name,
                 params,
                 line=self.line,
                 column=value.column,
                 empty_tuple_index=empty_tuple_index,
             )
+            result.end_column = getattr(n, "end_col_offset", None)
+            result.end_line = getattr(n, "end_lineno", None)
+            return result
         else:
             return self.invalid_type(n)
 
@@ -2092,7 +2159,7 @@ class TypeConverter:
         before_dot = self.visit(n.value)
 
         if isinstance(before_dot, UnboundType) and not before_dot.args:
-            return UnboundType(f"{before_dot.name}.{n.attr}", line=self.line)
+            return UnboundType(f"{before_dot.name}.{n.attr}", line=self.line, column=n.col_offset)
         else:
             return self.invalid_type(n)
 
@@ -2164,7 +2231,7 @@ class FindAttributeAssign(TraverserVisit
 
 
 class FindYield(TraverserVisitor):
-    """Check if an AST contains yields or yield froms."""
+    """Check if an AST contains yields or yield froms."""  # codespell:ignore froms
 
     def __init__(self) -> None:
         self.found = False
diff -pruN 1.15.0-5/mypy/find_sources.py 1.16~rc0.1-1/mypy/find_sources.py
--- 1.15.0-5/mypy/find_sources.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/find_sources.py	2025-05-27 17:21:15.000000000 +0000
@@ -8,7 +8,13 @@ from collections.abc import Sequence
 from typing import Final
 
 from mypy.fscache import FileSystemCache
-from mypy.modulefinder import PYTHON_EXTENSIONS, BuildSource, matches_exclude, mypy_path
+from mypy.modulefinder import (
+    PYTHON_EXTENSIONS,
+    BuildSource,
+    matches_exclude,
+    matches_gitignore,
+    mypy_path,
+)
 from mypy.options import Options
 
 PY_EXTENSIONS: Final = tuple(PYTHON_EXTENSIONS)
@@ -94,6 +100,7 @@ class SourceFinder:
         self.explicit_package_bases = get_explicit_package_bases(options)
         self.namespace_packages = options.namespace_packages
         self.exclude = options.exclude
+        self.exclude_gitignore = options.exclude_gitignore
         self.verbosity = options.verbosity
 
     def is_explicit_package_base(self, path: str) -> bool:
@@ -113,6 +120,10 @@ class SourceFinder:
 
             if matches_exclude(subpath, self.exclude, self.fscache, self.verbosity >= 2):
                 continue
+            if self.exclude_gitignore and matches_gitignore(
+                subpath, self.fscache, self.verbosity >= 2
+            ):
+                continue
 
             if self.fscache.isdir(subpath):
                 sub_sources = self.find_sources_in_dir(subpath)
@@ -176,8 +187,7 @@ class SourceFinder:
             return "", dir
 
         parent, name = os.path.split(dir)
-        if name.endswith("-stubs"):
-            name = name[:-6]  # PEP-561 stub-only directory
+        name = name.removesuffix("-stubs")  # PEP-561 stub-only directory
 
         # recurse if there's an __init__.py
         init_file = self.get_init_file(dir)
diff -pruN 1.15.0-5/mypy/fixup.py 1.16~rc0.1-1/mypy/fixup.py
--- 1.15.0-5/mypy/fixup.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/fixup.py	2025-05-27 17:21:15.000000000 +0000
@@ -210,6 +210,8 @@ class NodeFixer(NodeVisitor[None]):
             v.info = self.current_info
         if v.type is not None:
             v.type.accept(self.type_fixer)
+        if v.setter_type is not None:
+            v.setter_type.accept(self.type_fixer)
 
     def visit_type_alias(self, a: TypeAlias) -> None:
         a.target.accept(self.type_fixer)
diff -pruN 1.15.0-5/mypy/inspections.py 1.16~rc0.1-1/mypy/inspections.py
--- 1.15.0-5/mypy/inspections.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/inspections.py	2025-05-27 17:21:15.000000000 +0000
@@ -564,7 +564,7 @@ class InspectionEngine:
     ) -> dict[str, object]:
         """Top-level logic to inspect expression(s) at a location.
 
-        This can be re-used by various simple inspections.
+        This can be reused by various simple inspections.
         """
         try:
             file, pos = parse_location(location)
diff -pruN 1.15.0-5/mypy/ipc.py 1.16~rc0.1-1/mypy/ipc.py
--- 1.15.0-5/mypy/ipc.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/ipc.py	2025-05-27 17:21:15.000000000 +0000
@@ -303,6 +303,10 @@ class IPCServer(IPCBase):
     def connection_name(self) -> str:
         if sys.platform == "win32":
             return self.name
+        elif sys.platform == "gnu0":
+            # GNU/Hurd returns empty string from getsockname()
+            # for AF_UNIX sockets
+            return os.path.join(self.sock_directory, self.name)
         else:
             name = self.sock.getsockname()
             assert isinstance(name, str)
diff -pruN 1.15.0-5/mypy/join.py 1.16~rc0.1-1/mypy/join.py
--- 1.15.0-5/mypy/join.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/join.py	2025-05-27 17:21:15.000000000 +0000
@@ -183,55 +183,6 @@ class InstanceJoiner:
         return best
 
 
-def join_simple(declaration: Type | None, s: Type, t: Type) -> ProperType:
-    """Return a simple least upper bound given the declared type.
-
-    This function should be only used by binder, and should not recurse.
-    For all other uses, use `join_types()`.
-    """
-    declaration = get_proper_type(declaration)
-    s = get_proper_type(s)
-    t = get_proper_type(t)
-
-    if (s.can_be_true, s.can_be_false) != (t.can_be_true, t.can_be_false):
-        # if types are restricted in different ways, use the more general versions
-        s = mypy.typeops.true_or_false(s)
-        t = mypy.typeops.true_or_false(t)
-
-    if isinstance(s, AnyType):
-        return s
-
-    if isinstance(s, ErasedType):
-        return t
-
-    if is_proper_subtype(s, t, ignore_promotions=True):
-        return t
-
-    if is_proper_subtype(t, s, ignore_promotions=True):
-        return s
-
-    if isinstance(declaration, UnionType):
-        return mypy.typeops.make_simplified_union([s, t])
-
-    if isinstance(s, NoneType) and not isinstance(t, NoneType):
-        s, t = t, s
-
-    if isinstance(s, UninhabitedType) and not isinstance(t, UninhabitedType):
-        s, t = t, s
-
-    # Meets/joins require callable type normalization.
-    s, t = normalize_callables(s, t)
-
-    if isinstance(s, UnionType) and not isinstance(t, UnionType):
-        s, t = t, s
-
-    value = t.accept(TypeJoinVisitor(s))
-    if declaration is None or is_subtype(value, declaration):
-        return value
-
-    return declaration
-
-
 def trivial_join(s: Type, t: Type) -> Type:
     """Return one of types (expanded) if it is a supertype of other, otherwise top type."""
     if is_subtype(s, t):
@@ -348,6 +299,9 @@ class TypeJoinVisitor(TypeVisitor[Proper
     def visit_type_var_tuple(self, t: TypeVarTupleType) -> ProperType:
         if self.s == t:
             return t
+        if isinstance(self.s, Instance) and is_subtype(t.upper_bound, self.s):
+            # TODO: should we do this more generally and for all TypeVarLikeTypes?
+            return self.s
         return self.default(self.s)
 
     def visit_unpack_type(self, t: UnpackType) -> UnpackType:
@@ -355,7 +309,8 @@ class TypeJoinVisitor(TypeVisitor[Proper
 
     def visit_parameters(self, t: Parameters) -> ProperType:
         if isinstance(self.s, Parameters):
-            if len(t.arg_types) != len(self.s.arg_types):
+            if not is_similar_params(t, self.s):
+                # TODO: it would be prudent to return [*object, **object] instead of Any.
                 return self.default(self.s)
             from mypy.meet import meet_types
 
@@ -398,6 +353,8 @@ class TypeJoinVisitor(TypeVisitor[Proper
             return join_types(t, self.s)
         elif isinstance(self.s, LiteralType):
             return join_types(t, self.s)
+        elif isinstance(self.s, TypeVarTupleType) and is_subtype(self.s.upper_bound, t):
+            return t
         else:
             return self.default(self.s)
 
@@ -499,7 +456,7 @@ class TypeJoinVisitor(TypeVisitor[Proper
                 return items
             return None
         if s_unpack_index is not None and t_unpack_index is not None:
-            # The most complex case: both tuples have an upack item.
+            # The most complex case: both tuples have an unpack item.
             s_unpack = s.items[s_unpack_index]
             assert isinstance(s_unpack, UnpackType)
             s_unpacked = get_proper_type(s_unpack.type)
@@ -610,6 +567,10 @@ class TypeJoinVisitor(TypeVisitor[Proper
             assert isinstance(fallback, Instance)
             items = self.join_tuples(self.s, t)
             if items is not None:
+                if len(items) == 1 and isinstance(item := items[0], UnpackType):
+                    if isinstance(unpacked := get_proper_type(item.type), Instance):
+                        # Avoid double-wrapping tuple[*tuple[X, ...]]
+                        return unpacked
                 return TupleType(items, fallback)
             else:
                 # TODO: should this be a default fallback behaviour like for meet?
@@ -724,6 +685,15 @@ def is_similar_callables(t: CallableType
     )
 
 
+def is_similar_params(t: Parameters, s: Parameters) -> bool:
+    # This matches the logic in is_similar_callables() above.
+    return (
+        len(t.arg_types) == len(s.arg_types)
+        and t.min_args == s.min_args
+        and (t.var_arg() is not None) == (s.var_arg() is not None)
+    )
+
+
 def update_callable_ids(c: CallableType, ids: list[TypeVarId]) -> CallableType:
     tv_map = {}
     tvs = []
diff -pruN 1.15.0-5/mypy/literals.py 1.16~rc0.1-1/mypy/literals.py
--- 1.15.0-5/mypy/literals.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/literals.py	2025-05-27 17:21:15.000000000 +0000
@@ -96,7 +96,27 @@ from mypy.visitor import ExpressionVisit
 #   of an index expression, or the operands of an operator expression).
 
 
+Key: _TypeAlias = tuple[Any, ...]
+
+
+def literal_hash(e: Expression) -> Key | None:
+    """Generate a hashable, (mostly) opaque key for expressions supported by the binder.
+
+    These allow using expressions as dictionary keys based on structural/value
+    matching (instead of based on expression identity).
+
+    Return None if the expression type is not supported (it cannot be narrowed).
+
+    See the comment above for more information.
+
+    NOTE: This is not directly related to literal types.
+    """
+    return e.accept(_hasher)
+
+
 def literal(e: Expression) -> int:
+    """Return the literal kind for an expression."""
+
     if isinstance(e, ComparisonExpr):
         return min(literal(o) for o in e.operands)
 
@@ -129,17 +149,10 @@ def literal(e: Expression) -> int:
     return LITERAL_NO
 
 
-Key: _TypeAlias = tuple[Any, ...]
-
-
 def subkeys(key: Key) -> Iterable[Key]:
     return [elt for elt in key if isinstance(elt, tuple)]
 
 
-def literal_hash(e: Expression) -> Key | None:
-    return e.accept(_hasher)
-
-
 def extract_var_from_literal_hash(key: Key) -> Var | None:
     """If key refers to a Var node, return it.
 
diff -pruN 1.15.0-5/mypy/lookup.py 1.16~rc0.1-1/mypy/lookup.py
--- 1.15.0-5/mypy/lookup.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/lookup.py	2025-05-27 17:21:15.000000000 +0000
@@ -22,9 +22,11 @@ def lookup_fully_qualified(
     This function should *not* be used to find a module. Those should be looked
     in the modules dictionary.
     """
-    head = name
+    # 1. Exclude the names of ad hoc instance intersections from step 2.
+    i = name.find("<subclass ")
+    head = name if i == -1 else name[:i]
     rest = []
-    # 1. Find a module tree in modules dictionary.
+    # 2. Find a module tree in modules dictionary.
     while True:
         if "." not in head:
             if raise_on_missing:
@@ -36,12 +38,14 @@ def lookup_fully_qualified(
         if mod is not None:
             break
     names = mod.names
-    # 2. Find the symbol in the module tree.
+    # 3. Find the symbol in the module tree.
     if not rest:
         # Looks like a module, don't use this to avoid confusions.
         if raise_on_missing:
             assert rest, f"Cannot find {name}, got a module symbol"
         return None
+    if i != -1:
+        rest[0] += name[i:]
     while True:
         key = rest.pop()
         if key not in names:
diff -pruN 1.15.0-5/mypy/main.py 1.16~rc0.1-1/mypy/main.py
--- 1.15.0-5/mypy/main.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/main.py	2025-05-27 17:21:15.000000000 +0000
@@ -42,6 +42,7 @@ if TYPE_CHECKING:
 
 orig_stat: Final = os.stat
 MEM_PROFILE: Final = False  # If True, dump memory profile
+RECURSION_LIMIT: Final = 2**14
 
 
 def stat_proxy(path: str) -> os.stat_result:
@@ -76,7 +77,7 @@ def main(
     util.check_python_version("mypy")
     t0 = time.time()
     # To log stat() calls: os.stat = stat_proxy
-    sys.setrecursionlimit(2**14)
+    sys.setrecursionlimit(RECURSION_LIMIT)
     if args is None:
         args = sys.argv[1:]
 
@@ -93,6 +94,13 @@ def main(
         stdout, stderr, options.hide_error_codes, hide_success=bool(options.output)
     )
 
+    if options.allow_redefinition_new and not options.local_partial_types:
+        fail(
+            "error: --local-partial-types must be enabled if using --allow-redefinition-new",
+            stderr,
+            options,
+        )
+
     if options.install_types and (stdout is not sys.stdout or stderr is not sys.stderr):
         # Since --install-types performs user input, we want regular stdout and stderr.
         fail("error: --install-types not supported in this mode of running mypy", stderr, options)
@@ -241,8 +249,8 @@ def show_messages(
 
 # Make the help output a little less jarring.
 class AugmentedHelpFormatter(argparse.RawDescriptionHelpFormatter):
-    def __init__(self, prog: str) -> None:
-        super().__init__(prog=prog, max_help_position=28)
+    def __init__(self, prog: str, **kwargs: Any) -> None:
+        super().__init__(prog=prog, max_help_position=28, **kwargs)
 
     def _fill_text(self, text: str, width: int, indent: str) -> str:
         if "\n" in text:
@@ -483,6 +491,8 @@ def process_options(
         stdout=stdout,
         stderr=stderr,
     )
+    if sys.version_info >= (3, 14):
+        parser.color = True  # Set as init arg in 3.14
 
     strict_flag_names: list[str] = []
     strict_flag_assignments: list[tuple[str, bool]] = []
@@ -525,8 +535,27 @@ def process_options(
     # their `dest` prefixed with `special-opts:`, which will cause them to be
     # parsed into the separate special_opts namespace object.
 
-    # Note: we have a style guide for formatting the mypy --help text. See
-    # https://github.com/python/mypy/wiki/Documentation-Conventions
+    # Our style guide for formatting the output of running `mypy --help`:
+    # Flags:
+    # 1.  The flag help text should start with a capital letter but never end with a period.
+    # 2.  Keep the flag help text brief -- ideally just a single sentence.
+    # 3.  All flags must be a part of a group, unless the flag is deprecated or suppressed.
+    # 4.  Avoid adding new flags to the "miscellaneous" groups -- instead add them to an
+    #     existing group or, if applicable, create a new group. Feel free to move existing
+    #     flags to a new group: just be sure to also update the documentation to match.
+    #
+    # Groups:
+    # 1.  The group title and description should start with a capital letter.
+    # 2.  The first sentence of a group description should be written in the bare infinitive.
+    #     Tip: try substituting the group title and description into the following sentence:
+    #     > {group_title}: these flags will {group_description}
+    #     Feel free to add subsequent sentences that add additional details.
+    # 3.  If you cannot think of a meaningful description for a new group, omit it entirely.
+    #     (E.g. see the "miscellaneous" sections).
+    # 4.  The group description should end with a period (unless the last line is a link). If you
+    #     do end the group description with a link, omit the 'http://' prefix. (Some links are too
+    #     long and will break up into multiple lines if we include that prefix, so for consistency
+    #     we omit the prefix on all links.)
 
     general_group = parser.add_argument_group(title="Optional arguments")
     general_group.add_argument(
@@ -826,6 +855,14 @@ def process_options(
         help="Report importing or using deprecated features as notes instead of errors",
         group=lint_group,
     )
+    lint_group.add_argument(
+        "--deprecated-calls-exclude",
+        metavar="MODULE",
+        action="append",
+        default=[],
+        help="Disable deprecated warnings for functions/methods coming"
+        " from specific package, module, or class",
+    )
 
     # Note: this group is intentionally added here even though we don't add
     # --strict to this group near the end.
@@ -848,7 +885,15 @@ def process_options(
         "--allow-redefinition",
         default=False,
         strict_flag=False,
-        help="Allow unconditional variable redefinition with a new type",
+        help="Allow restricted, unconditional variable redefinition with a new type",
+        group=strictness_group,
+    )
+
+    add_invertible_flag(
+        "--allow-redefinition-new",
+        default=False,
+        strict_flag=False,
+        help=argparse.SUPPRESS,  # This is still very experimental
         group=strictness_group,
     )
 
@@ -872,7 +917,7 @@ def process_options(
     add_invertible_flag(
         "--strict-bytes",
         default=False,
-        strict_flag=False,
+        strict_flag=True,
         help="Disable treating bytearray and memoryview as subtypes of bytes",
         group=strictness_group,
     )
@@ -1100,6 +1145,16 @@ def process_options(
                 dest=f"special-opts:{report_type}_report",
             )
 
+    # Undocumented mypyc feature: generate annotated HTML source file
+    report_group.add_argument(
+        "-a", dest="mypyc_annotation_file", type=str, default=None, help=argparse.SUPPRESS
+    )
+    # Hidden mypyc feature: do not write any C files (keep existing ones and assume they exist).
+    # This can be useful when debugging mypyc bugs.
+    report_group.add_argument(
+        "--skip-c-gen", dest="mypyc_skip_c_generation", action="store_true", help=argparse.SUPPRESS
+    )
+
     other_group = parser.add_argument_group(title="Miscellaneous")
     other_group.add_argument("--quickstart-file", help=argparse.SUPPRESS)
     other_group.add_argument("--junit-xml", help="Write junit.xml to the given file")
@@ -1244,6 +1299,15 @@ def process_options(
             "May be specified more than once, eg. --exclude a --exclude b"
         ),
     )
+    add_invertible_flag(
+        "--exclude-gitignore",
+        default=False,
+        help=(
+            "Use .gitignore file(s) to exclude files from checking "
+            "(in addition to any explicit --exclude if present)"
+        ),
+        group=code_group,
+    )
     code_group.add_argument(
         "-m",
         "--module",
@@ -1369,6 +1433,7 @@ def process_options(
         )
 
     validate_package_allow_list(options.untyped_calls_exclude)
+    validate_package_allow_list(options.deprecated_calls_exclude)
 
     options.process_error_codes(error_callback=parser.error)
     options.process_incomplete_features(error_callback=parser.error, warning_callback=print)
@@ -1405,9 +1470,7 @@ def process_options(
         process_cache_map(parser, special_opts, options)
 
     # Process --strict-bytes
-    if options.strict_bytes:
-        options.disable_bytearray_promotion = True
-        options.disable_memoryview_promotion = True
+    options.process_strict_bytes()
 
     # An explicitly specified cache_fine_grained implies local_partial_types
     # (because otherwise the cache is not compatible with dmypy)
diff -pruN 1.15.0-5/mypy/meet.py 1.16~rc0.1-1/mypy/meet.py
--- 1.15.0-5/mypy/meet.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/meet.py	2025-05-27 17:21:15.000000000 +0000
@@ -50,6 +50,7 @@ from mypy.types import (
     find_unpack_in_list,
     get_proper_type,
     get_proper_types,
+    is_named_instance,
     split_with_prefix_and_suffix,
 )
 
@@ -142,7 +143,12 @@ def narrow_declared_type(declared: Type,
             ]
         )
     if is_enum_overlapping_union(declared, narrowed):
-        return original_narrowed
+        # Quick check before reaching `is_overlapping_types`. If it's enum/literal overlap,
+        # avoid full expansion and make it faster.
+        assert isinstance(narrowed, UnionType)
+        return make_simplified_union(
+            [narrow_declared_type(declared, x) for x in narrowed.relevant_items()]
+        )
     elif not is_overlapping_types(declared, narrowed, prohibit_none_typevar_overlap=True):
         if state.strict_optional:
             return UninhabitedType()
@@ -552,7 +558,27 @@ def is_overlapping_types(
         else:
             return False
 
-        if len(left.args) == len(right.args):
+        if right.type.has_type_var_tuple_type:
+            # Similar to subtyping, we delegate the heavy lifting to the tuple overlap.
+            assert right.type.type_var_tuple_prefix is not None
+            assert right.type.type_var_tuple_suffix is not None
+            prefix = right.type.type_var_tuple_prefix
+            suffix = right.type.type_var_tuple_suffix
+            tvt = right.type.defn.type_vars[prefix]
+            assert isinstance(tvt, TypeVarTupleType)
+            fallback = tvt.tuple_fallback
+            left_prefix, left_middle, left_suffix = split_with_prefix_and_suffix(
+                left.args, prefix, suffix
+            )
+            right_prefix, right_middle, right_suffix = split_with_prefix_and_suffix(
+                right.args, prefix, suffix
+            )
+            left_args = left_prefix + (TupleType(list(left_middle), fallback),) + left_suffix
+            right_args = right_prefix + (TupleType(list(right_middle), fallback),) + right_suffix
+        else:
+            left_args = left.args
+            right_args = right.args
+        if len(left_args) == len(right_args):
             # Note: we don't really care about variance here, since the overlapping check
             # is symmetric and since we want to return 'True' even for partial overlaps.
             #
@@ -569,7 +595,7 @@ def is_overlapping_types(
             # to contain only instances of B at runtime.
             if all(
                 _is_overlapping_types(left_arg, right_arg)
-                for left_arg, right_arg in zip(left.args, right.args)
+                for left_arg, right_arg in zip(left_args, right_args)
             ):
                 return True
 
@@ -645,7 +671,16 @@ def are_tuples_overlapping(
 
     if len(left.items) != len(right.items):
         return False
-    return all(is_overlapping(l, r) for l, r in zip(left.items, right.items))
+    if not all(is_overlapping(l, r) for l, r in zip(left.items, right.items)):
+        return False
+
+    # Check that the tuples aren't from e.g. different NamedTuples.
+    if is_named_instance(right.partial_fallback, "builtins.tuple") or is_named_instance(
+        left.partial_fallback, "builtins.tuple"
+    ):
+        return True
+    else:
+        return is_overlapping(left.partial_fallback, right.partial_fallback)
 
 
 def expand_tuple_if_possible(tup: TupleType, target: int) -> TupleType:
diff -pruN 1.15.0-5/mypy/messages.py 1.16~rc0.1-1/mypy/messages.py
--- 1.15.0-5/mypy/messages.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/messages.py	2025-05-27 17:21:15.000000000 +0000
@@ -56,6 +56,7 @@ from mypy.options import Options
 from mypy.subtypes import (
     IS_CLASS_OR_STATIC,
     IS_CLASSVAR,
+    IS_EXPLICIT_SETTER,
     IS_SETTABLE,
     IS_VAR,
     find_member,
@@ -186,9 +187,13 @@ class MessageBuilder:
         *,
         filter_errors: bool | Callable[[str, ErrorInfo], bool] = True,
         save_filtered_errors: bool = False,
+        filter_deprecated: bool = False,
     ) -> ErrorWatcher:
         return ErrorWatcher(
-            self.errors, filter_errors=filter_errors, save_filtered_errors=save_filtered_errors
+            self.errors,
+            filter_errors=filter_errors,
+            save_filtered_errors=save_filtered_errors,
+            filter_deprecated=filter_deprecated,
         )
 
     def add_errors(self, errors: list[ErrorInfo]) -> None:
@@ -210,7 +215,7 @@ class MessageBuilder:
     def prefer_simple_messages(self) -> bool:
         """Should we generate simple/fast error messages?
 
-        If errors aren't shown to the user, we don't want to waste cyles producing
+        If errors aren't shown to the user, we don't want to waste cycles producing
         complex error messages.
         """
         return self.errors.prefer_simple_messages()
@@ -1164,6 +1169,20 @@ class MessageBuilder:
         note_template = 'Overload variants must be defined in the same order as they are in "{}"'
         self.note(note_template.format(supertype), context, code=codes.OVERRIDE)
 
+    def incompatible_setter_override(
+        self, defn: Context, typ: Type, original_type: Type, base: TypeInfo
+    ) -> None:
+        self.fail("Incompatible override of a setter type", defn, code=codes.OVERRIDE)
+        base_str, override_str = format_type_distinctly(original_type, typ, options=self.options)
+        self.note(
+            f' (base class "{base.name}" defined the type as {base_str},',
+            defn,
+            code=codes.OVERRIDE,
+        )
+        self.note(f" override has type {override_str})", defn, code=codes.OVERRIDE)
+        if is_subtype(typ, original_type):
+            self.note(" Setter types should behave contravariantly", defn, code=codes.OVERRIDE)
+
     def signature_incompatible_with_supertype(
         self,
         name: str,
@@ -1973,7 +1992,7 @@ class MessageBuilder:
             code=codes.EXIT_RETURN,
         )
         self.note(
-            'Use "typing_extensions.Literal[False]" as the return type or change it to "None"',
+            'Use "typing.Literal[False]" as the return type or change it to "None"',
             context,
             code=codes.EXIT_RETURN,
         )
@@ -2132,12 +2151,8 @@ class MessageBuilder:
         is_module = False
         skip = []
         if isinstance(subtype, TupleType):
-            if not isinstance(subtype.partial_fallback, Instance):
-                return
             subtype = subtype.partial_fallback
         elif isinstance(subtype, TypedDictType):
-            if not isinstance(subtype.fallback, Instance):
-                return
             subtype = subtype.fallback
         elif isinstance(subtype, TypeType):
             if not isinstance(subtype.item, Instance):
@@ -2201,22 +2216,34 @@ class MessageBuilder:
         ):
             type_name = format_type(subtype, self.options, module_names=True)
             self.note(f"Following member(s) of {type_name} have conflicts:", context, code=code)
-            for name, got, exp in conflict_types[:MAX_ITEMS]:
+            for name, got, exp, is_lvalue in conflict_types[:MAX_ITEMS]:
                 exp = get_proper_type(exp)
                 got = get_proper_type(got)
+                setter_suffix = " setter type" if is_lvalue else ""
                 if not isinstance(exp, (CallableType, Overloaded)) or not isinstance(
                     got, (CallableType, Overloaded)
                 ):
                     self.note(
-                        "{}: expected {}, got {}".format(
-                            name, *format_type_distinctly(exp, got, options=self.options)
+                        "{}: expected{} {}, got {}".format(
+                            name,
+                            setter_suffix,
+                            *format_type_distinctly(exp, got, options=self.options),
                         ),
                         context,
                         offset=OFFSET,
                         code=code,
                     )
+                    if is_lvalue and is_subtype(got, exp, options=self.options):
+                        self.note(
+                            "Setter types should behave contravariantly",
+                            context,
+                            offset=OFFSET,
+                            code=code,
+                        )
                 else:
-                    self.note("Expected:", context, offset=OFFSET, code=code)
+                    self.note(
+                        "Expected{}:".format(setter_suffix), context, offset=OFFSET, code=code
+                    )
                     if isinstance(exp, CallableType):
                         self.note(
                             pretty_callable(exp, self.options, skip_self=class_obj or is_module),
@@ -2412,7 +2439,7 @@ class MessageBuilder:
         error_cnt = 0
         notes: list[str] = []
         for i, (lhs_t, rhs_t) in enumerate(zip(lhs_types, rhs_types)):
-            if not is_subtype(lhs_t, rhs_t):
+            if not is_subtype(rhs_t, lhs_t):
                 if error_cnt < 3:
                     notes.append(
                         "Expression tuple item {} has type {}; {} expected; ".format(
@@ -2855,7 +2882,29 @@ def format_type_distinctly(*types: Type,
     quoting them (such as prepending * or **) should use this.
     """
     overlapping = find_type_overlaps(*types)
-    for verbosity in range(2):
+
+    def format_single(arg: Type) -> str:
+        return format_type_inner(arg, verbosity=0, options=options, fullnames=overlapping)
+
+    min_verbosity = 0
+    # Prevent emitting weird errors like:
+    # ... has incompatible type "Callable[[int], Child]"; expected "Callable[[int], Parent]"
+    if len(types) == 2:
+        left, right = types
+        left = get_proper_type(left)
+        right = get_proper_type(right)
+        # If the right type has named arguments, they may be the reason for incompatibility.
+        # This excludes cases when right is Callable[[Something], None] without named args,
+        # because that's usually the right thing to do.
+        if (
+            isinstance(left, CallableType)
+            and isinstance(right, CallableType)
+            and any(right.arg_names)
+            and is_subtype(left, right, ignore_pos_arg_names=True)
+        ):
+            min_verbosity = 1
+
+    for verbosity in range(min_verbosity, 2):
         strs = [
             format_type_inner(type, verbosity=verbosity, options=options, fullnames=overlapping)
             for type in types
@@ -3007,12 +3056,12 @@ def get_missing_protocol_members(left: I
 
 def get_conflict_protocol_types(
     left: Instance, right: Instance, class_obj: bool = False, options: Options | None = None
-) -> list[tuple[str, Type, Type]]:
+) -> list[tuple[str, Type, Type, bool]]:
     """Find members that are defined in 'left' but have incompatible types.
-    Return them as a list of ('member', 'got', 'expected').
+    Return them as a list of ('member', 'got', 'expected', 'is_lvalue').
     """
     assert right.type.is_protocol
-    conflicts: list[tuple[str, Type, Type]] = []
+    conflicts: list[tuple[str, Type, Type, bool]] = []
     for member in right.type.protocol_members:
         if member in ("__init__", "__new__"):
             continue
@@ -3022,10 +3071,29 @@ def get_conflict_protocol_types(
         if not subtype:
             continue
         is_compat = is_subtype(subtype, supertype, ignore_pos_arg_names=True, options=options)
-        if IS_SETTABLE in get_member_flags(member, right):
-            is_compat = is_compat and is_subtype(supertype, subtype, options=options)
         if not is_compat:
-            conflicts.append((member, subtype, supertype))
+            conflicts.append((member, subtype, supertype, False))
+        superflags = get_member_flags(member, right)
+        if IS_SETTABLE not in superflags:
+            continue
+        different_setter = False
+        if IS_EXPLICIT_SETTER in superflags:
+            set_supertype = find_member(member, right, left, is_lvalue=True)
+            if set_supertype and not is_same_type(set_supertype, supertype):
+                different_setter = True
+            supertype = set_supertype
+        if IS_EXPLICIT_SETTER in get_member_flags(member, left):
+            set_subtype = mypy.typeops.get_protocol_member(left, member, class_obj, is_lvalue=True)
+            if set_subtype and not is_same_type(set_subtype, subtype):
+                different_setter = True
+            subtype = set_subtype
+        if not is_compat and not different_setter:
+            # We already have this conflict listed, avoid duplicates.
+            continue
+        assert supertype is not None and subtype is not None
+        is_compat = is_subtype(supertype, subtype, options=options)
+        if not is_compat:
+            conflicts.append((member, subtype, supertype, different_setter))
     return conflicts
 
 
@@ -3198,7 +3266,7 @@ def append_invariance_notes(
         and expected_type.type.fullname == "builtins.list"
         and is_subtype(arg_type.args[0], expected_type.args[0])
     ):
-        invariant_type = "List"
+        invariant_type = "list"
         covariant_suggestion = 'Consider using "Sequence" instead, which is covariant'
     elif (
         arg_type.type.fullname == "builtins.dict"
@@ -3206,7 +3274,7 @@ def append_invariance_notes(
         and is_same_type(arg_type.args[0], expected_type.args[0])
         and is_subtype(arg_type.args[1], expected_type.args[1])
     ):
-        invariant_type = "Dict"
+        invariant_type = "dict"
         covariant_suggestion = (
             'Consider using "Mapping" instead, which is covariant in the value type'
         )
diff -pruN 1.15.0-5/mypy/modulefinder.py 1.16~rc0.1-1/mypy/modulefinder.py
--- 1.15.0-5/mypy/modulefinder.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/modulefinder.py	2025-05-27 17:21:15.000000000 +0000
@@ -16,6 +16,9 @@ from enum import Enum, unique
 from typing import Final, Optional, Union
 from typing_extensions import TypeAlias as _TypeAlias
 
+from pathspec import PathSpec
+from pathspec.patterns.gitwildmatch import GitWildMatchPatternError
+
 from mypy import pyinfo
 from mypy.errors import CompileError
 from mypy.fscache import FileSystemCache
@@ -317,13 +320,21 @@ class FindModuleCache:
                 use_typeshed = self._typeshed_has_version(id)
             elif top_level in self.stdlib_py_versions:
                 use_typeshed = self._typeshed_has_version(top_level)
-            self.results[id] = self._find_module(id, use_typeshed)
-            if (
-                not (fast_path or (self.options is not None and self.options.fast_module_lookup))
-                and self.results[id] is ModuleNotFoundReason.NOT_FOUND
-                and self._can_find_module_in_parent_dir(id)
-            ):
-                self.results[id] = ModuleNotFoundReason.WRONG_WORKING_DIRECTORY
+            result, should_cache = self._find_module(id, use_typeshed)
+            if should_cache:
+                if (
+                    not (
+                        fast_path or (self.options is not None and self.options.fast_module_lookup)
+                    )
+                    and result is ModuleNotFoundReason.NOT_FOUND
+                    and self._can_find_module_in_parent_dir(id)
+                ):
+                    self.results[id] = ModuleNotFoundReason.WRONG_WORKING_DIRECTORY
+                else:
+                    self.results[id] = result
+                return self.results[id]
+            else:
+                return result
         return self.results[id]
 
     def _typeshed_has_version(self, module: str) -> bool:
@@ -381,11 +392,16 @@ class FindModuleCache:
         while any(is_init_file(file) for file in os.listdir(working_dir)):
             working_dir = os.path.dirname(working_dir)
             parent_search.search_paths = SearchPaths((working_dir,), (), (), ())
-            if not isinstance(parent_search._find_module(id, False), ModuleNotFoundReason):
+            if not isinstance(parent_search._find_module(id, False)[0], ModuleNotFoundReason):
                 return True
         return False
 
-    def _find_module(self, id: str, use_typeshed: bool) -> ModuleSearchResult:
+    def _find_module(self, id: str, use_typeshed: bool) -> tuple[ModuleSearchResult, bool]:
+        """Try to find a module in all available sources.
+
+        Returns:
+            ``(result, can_be_cached)`` pair.
+        """
         fscache = self.fscache
 
         # Fast path for any modules in the current source set.
@@ -421,7 +437,7 @@ class FindModuleCache:
             else None
         )
         if p:
-            return p
+            return p, True
 
         # If we're looking for a module like 'foo.bar.baz', it's likely that most of the
         # many elements of lib_path don't even have a subdirectory 'foo/bar'.  Discover
@@ -441,6 +457,9 @@ class FindModuleCache:
             for component in (components[0], components[0] + "-stubs")
             for package_dir in self.find_lib_path_dirs(component, self.search_paths.package_path)
         }
+        # Caching FOUND_WITHOUT_TYPE_HINTS is not always safe. That causes issues with
+        # typed subpackages in namespace packages.
+        can_cache_any_result = True
         for pkg_dir in self.search_paths.package_path:
             if pkg_dir not in candidate_package_dirs:
                 continue
@@ -472,6 +491,7 @@ class FindModuleCache:
             if isinstance(non_stub_match, ModuleNotFoundReason):
                 if non_stub_match is ModuleNotFoundReason.FOUND_WITHOUT_TYPE_HINTS:
                     found_possible_third_party_missing_type_hints = True
+                    can_cache_any_result = False
             else:
                 third_party_inline_dirs.append(non_stub_match)
                 self._update_ns_ancestors(components, non_stub_match)
@@ -503,21 +523,24 @@ class FindModuleCache:
             dir_prefix = base_dir
             for _ in range(len(components) - 1):
                 dir_prefix = os.path.dirname(dir_prefix)
+
+            # Stubs-only packages always take precedence over py.typed packages
+            path_stubs = f"{base_path}-stubs{sepinit}.pyi"
+            if fscache.isfile_case(path_stubs, dir_prefix):
+                if verify and not verify_module(fscache, id, path_stubs, dir_prefix):
+                    near_misses.append((path_stubs, dir_prefix))
+                else:
+                    return path_stubs, True
+
             # Prefer package over module, i.e. baz/__init__.py* over baz.py*.
             for extension in PYTHON_EXTENSIONS:
                 path = base_path + sepinit + extension
-                path_stubs = base_path + "-stubs" + sepinit + extension
                 if fscache.isfile_case(path, dir_prefix):
                     has_init = True
                     if verify and not verify_module(fscache, id, path, dir_prefix):
                         near_misses.append((path, dir_prefix))
                         continue
-                    return path
-                elif fscache.isfile_case(path_stubs, dir_prefix):
-                    if verify and not verify_module(fscache, id, path_stubs, dir_prefix):
-                        near_misses.append((path_stubs, dir_prefix))
-                        continue
-                    return path_stubs
+                    return path, True
 
             # In namespace mode, register a potential namespace package
             if self.options and self.options.namespace_packages:
@@ -535,7 +558,7 @@ class FindModuleCache:
                     if verify and not verify_module(fscache, id, path, dir_prefix):
                         near_misses.append((path, dir_prefix))
                         continue
-                    return path
+                    return path, True
 
         # In namespace mode, re-check those entries that had 'verify'.
         # Assume search path entries xxx, yyy and zzz, and we're
@@ -564,7 +587,7 @@ class FindModuleCache:
                 for path, dir_prefix in near_misses
             ]
             index = levels.index(max(levels))
-            return near_misses[index][0]
+            return near_misses[index][0], True
 
         # Finally, we may be asked to produce an ancestor for an
         # installed package with a py.typed marker that is a
@@ -572,12 +595,12 @@ class FindModuleCache:
         # if we would otherwise return "not found".
         ancestor = self.ns_ancestors.get(id)
         if ancestor is not None:
-            return ancestor
+            return ancestor, True
 
         approved_dist_name = stub_distribution_name(id)
         if approved_dist_name:
             if len(components) == 1:
-                return ModuleNotFoundReason.APPROVED_STUBS_NOT_INSTALLED
+                return ModuleNotFoundReason.APPROVED_STUBS_NOT_INSTALLED, True
             # If we're a missing submodule of an already installed approved stubs, we don't want to
             # error with APPROVED_STUBS_NOT_INSTALLED, but rather want to return NOT_FOUND.
             for i in range(1, len(components)):
@@ -585,14 +608,14 @@ class FindModuleCache:
                 if stub_distribution_name(parent_id) == approved_dist_name:
                     break
             else:
-                return ModuleNotFoundReason.APPROVED_STUBS_NOT_INSTALLED
+                return ModuleNotFoundReason.APPROVED_STUBS_NOT_INSTALLED, True
             if self.find_module(parent_id) is ModuleNotFoundReason.APPROVED_STUBS_NOT_INSTALLED:
-                return ModuleNotFoundReason.APPROVED_STUBS_NOT_INSTALLED
-            return ModuleNotFoundReason.NOT_FOUND
+                return ModuleNotFoundReason.APPROVED_STUBS_NOT_INSTALLED, True
+            return ModuleNotFoundReason.NOT_FOUND, True
 
         if found_possible_third_party_missing_type_hints:
-            return ModuleNotFoundReason.FOUND_WITHOUT_TYPE_HINTS
-        return ModuleNotFoundReason.NOT_FOUND
+            return ModuleNotFoundReason.FOUND_WITHOUT_TYPE_HINTS, can_cache_any_result
+        return ModuleNotFoundReason.NOT_FOUND, True
 
     def find_modules_recursive(self, module: str) -> list[BuildSource]:
         module_path = self.find_module(module, fast_path=True)
@@ -625,6 +648,12 @@ class FindModuleCache:
                 subpath, self.options.exclude, self.fscache, self.options.verbosity >= 2
             ):
                 continue
+            if (
+                self.options
+                and self.options.exclude_gitignore
+                and matches_gitignore(subpath, self.fscache, self.options.verbosity >= 2)
+            ):
+                continue
 
             if self.fscache.isdir(subpath):
                 # Only recurse into packages
@@ -664,6 +693,42 @@ def matches_exclude(
     return False
 
 
+def matches_gitignore(subpath: str, fscache: FileSystemCache, verbose: bool) -> bool:
+    dir, _ = os.path.split(subpath)
+    for gi_path, gi_spec in find_gitignores(dir):
+        relative_path = os.path.relpath(subpath, gi_path)
+        if fscache.isdir(relative_path):
+            relative_path = relative_path + "/"
+        if gi_spec.match_file(relative_path):
+            if verbose:
+                print(
+                    f"TRACE: Excluding {relative_path} (matches .gitignore) in {gi_path}",
+                    file=sys.stderr,
+                )
+            return True
+    return False
+
+
+@functools.lru_cache
+def find_gitignores(dir: str) -> list[tuple[str, PathSpec]]:
+    parent_dir = os.path.dirname(dir)
+    if parent_dir == dir:
+        parent_gitignores = []
+    else:
+        parent_gitignores = find_gitignores(parent_dir)
+
+    gitignore = os.path.join(dir, ".gitignore")
+    if os.path.isfile(gitignore):
+        with open(gitignore) as f:
+            lines = f.readlines()
+        try:
+            return parent_gitignores + [(dir, PathSpec.from_lines("gitwildmatch", lines))]
+        except GitWildMatchPatternError:
+            print(f"error: could not parse {gitignore}", file=sys.stderr)
+            return parent_gitignores
+    return parent_gitignores
+
+
 def is_init_file(path: str) -> bool:
     return os.path.basename(path) in ("__init__.py", "__init__.pyi")
 
diff -pruN 1.15.0-5/mypy/nodes.py 1.16~rc0.1-1/mypy/nodes.py
--- 1.15.0-5/mypy/nodes.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/nodes.py	2025-05-27 17:21:15.000000000 +0000
@@ -14,7 +14,7 @@ from mypy_extensions import trait
 
 import mypy.strconv
 from mypy.options import Options
-from mypy.util import is_typeshed_file, short_type
+from mypy.util import is_sunder, is_typeshed_file, short_type
 from mypy.visitor import ExpressionVisitor, NodeVisitor, StatementVisitor
 
 if TYPE_CHECKING:
@@ -89,9 +89,14 @@ UNBOUND_IMPORTED: Final = 3
 REVEAL_TYPE: Final = 0
 REVEAL_LOCALS: Final = 1
 
-LITERAL_YES: Final = 2
-LITERAL_TYPE: Final = 1
-LITERAL_NO: Final = 0
+# Kinds of 'literal' expressions.
+#
+# Use the function mypy.literals.literal to calculate these.
+#
+# TODO: Can we make these less confusing?
+LITERAL_YES: Final = 2  # Value of expression known statically
+LITERAL_TYPE: Final = 1  # Type of expression can be narrowed (e.g. variable reference)
+LITERAL_NO: Final = 0  # None of the above
 
 node_kinds: Final = {LDEF: "Ldef", GDEF: "Gdef", MDEF: "Mdef", UNBOUND_IMPORTED: "UnboundImported"}
 inverse_node_kinds: Final = {_kind: _name for _name, _kind in node_kinds.items()}
@@ -171,15 +176,12 @@ class Node(Context):
     __slots__ = ()
 
     def __str__(self) -> str:
-        ans = self.accept(mypy.strconv.StrConv(options=Options()))
-        if ans is None:
-            return repr(self)
-        return ans
+        return self.accept(mypy.strconv.StrConv(options=Options()))
 
     def str_with_options(self, options: Options) -> str:
-        ans = self.accept(mypy.strconv.StrConv(options=options))
-        assert ans
-        return ans
+        a = self.accept(mypy.strconv.StrConv(options=options))
+        assert a
+        return a
 
     def accept(self, visitor: NodeVisitor[T]) -> T:
         raise RuntimeError("Not implemented", type(self))
@@ -548,7 +550,7 @@ class OverloadedFuncDef(FuncBase, Symbol
     Overloaded variants must be consecutive in the source file.
     """
 
-    __slots__ = ("items", "unanalyzed_items", "impl", "deprecated")
+    __slots__ = ("items", "unanalyzed_items", "impl", "deprecated", "_is_trivial_self")
 
     items: list[OverloadPart]
     unanalyzed_items: list[OverloadPart]
@@ -561,6 +563,7 @@ class OverloadedFuncDef(FuncBase, Symbol
         self.unanalyzed_items = items.copy()
         self.impl = None
         self.deprecated = None
+        self._is_trivial_self: bool | None = None
         if items:
             # TODO: figure out how to reliably set end position (we don't know the impl here).
             self.set_line(items[0].line, items[0].column)
@@ -574,6 +577,27 @@ class OverloadedFuncDef(FuncBase, Symbol
             assert self.impl is not None
             return self.impl.name
 
+    @property
+    def is_trivial_self(self) -> bool:
+        """Check we can use bind_self() fast path for this overload.
+
+        This will return False if at least one overload:
+          * Has an explicit self annotation, or Self in signature.
+          * Has a non-trivial decorator.
+        """
+        if self._is_trivial_self is not None:
+            return self._is_trivial_self
+        for item in self.items:
+            if isinstance(item, FuncDef):
+                if not item.is_trivial_self:
+                    self._is_trivial_self = False
+                    return False
+            elif item.decorators or not item.func.is_trivial_self:
+                self._is_trivial_self = False
+                return False
+        self._is_trivial_self = True
+        return True
+
     def accept(self, visitor: StatementVisitor[T]) -> T:
         return visitor.visit_overloaded_func_def(self)
 
@@ -745,6 +769,7 @@ FUNCDEF_FLAGS: Final = FUNCITEM_FLAGS +
     "is_decorated",
     "is_conditional",
     "is_trivial_body",
+    "is_trivial_self",
     "is_mypy_only",
 ]
 
@@ -769,6 +794,7 @@ class FuncDef(FuncItem, SymbolNode, Stat
         "abstract_status",
         "original_def",
         "is_trivial_body",
+        "is_trivial_self",
         "is_mypy_only",
         # Present only when a function is decorated with @typing.dataclass_transform or similar
         "dataclass_transform_spec",
@@ -802,6 +828,10 @@ class FuncDef(FuncItem, SymbolNode, Stat
         self.dataclass_transform_spec: DataclassTransformSpec | None = None
         self.docstring: str | None = None
         self.deprecated: str | None = None
+        # This is used to simplify bind_self() logic in trivial cases (which are
+        # the majority). In cases where self is not annotated and there are no Self
+        # in the signature we can simply drop the first argument.
+        self.is_trivial_self = False
 
     @property
     def name(self) -> str:
@@ -870,7 +900,9 @@ class FuncDef(FuncItem, SymbolNode, Stat
 
 # All types that are both SymbolNodes and FuncBases. See the FuncBase
 # docstring for the rationale.
-SYMBOL_FUNCBASE_TYPES = (OverloadedFuncDef, FuncDef)
+# See https://github.com/python/mypy/pull/13607#issuecomment-1236357236
+# TODO: we want to remove this at some point and just use `FuncBase` ideally.
+SYMBOL_FUNCBASE_TYPES: Final = (OverloadedFuncDef, FuncDef)
 
 
 class Decorator(SymbolNode, Statement):
@@ -977,6 +1009,7 @@ class Var(SymbolNode):
         "_fullname",
         "info",
         "type",
+        "setter_type",
         "final_value",
         "is_self",
         "is_cls",
@@ -1011,6 +1044,8 @@ class Var(SymbolNode):
         # TODO: Should be Optional[TypeInfo]
         self.info = VAR_NO_INFO
         self.type: mypy.types.Type | None = type  # Declared or inferred type, or None
+        # The setter type for settable properties.
+        self.setter_type: mypy.types.CallableType | None = None
         # Is this the first argument to an ordinary method (usually "self")?
         self.is_self = False
         # Is this the first argument to a classmethod (typically "cls")?
@@ -1065,6 +1100,10 @@ class Var(SymbolNode):
     def fullname(self) -> str:
         return self._fullname
 
+    def __repr__(self) -> str:
+        name = self.fullname or self.name
+        return f"<Var {name!r} at {hex(id(self))}>"
+
     def accept(self, visitor: NodeVisitor[T]) -> T:
         return visitor.visit_var(self)
 
@@ -1076,6 +1115,7 @@ class Var(SymbolNode):
             "name": self._name,
             "fullname": self._fullname,
             "type": None if self.type is None else self.type.serialize(),
+            "setter_type": None if self.setter_type is None else self.setter_type.serialize(),
             "flags": get_flags(self, VAR_FLAGS),
         }
         if self.final_value is not None:
@@ -1087,7 +1127,18 @@ class Var(SymbolNode):
         assert data[".class"] == "Var"
         name = data["name"]
         type = None if data["type"] is None else mypy.types.deserialize_type(data["type"])
+        setter_type = (
+            None
+            if data["setter_type"] is None
+            else mypy.types.deserialize_type(data["setter_type"])
+        )
         v = Var(name, type)
+        assert (
+            setter_type is None
+            or isinstance(setter_type, mypy.types.ProperType)
+            and isinstance(setter_type, mypy.types.CallableType)
+        )
+        v.setter_type = setter_type
         v.is_ready = False  # Override True default set in __init__
         v._fullname = data["fullname"]
         set_flags(v, data["flags"])
@@ -1615,11 +1666,12 @@ class WithStmt(Statement):
 
 
 class MatchStmt(Statement):
-    __slots__ = ("subject", "patterns", "guards", "bodies")
+    __slots__ = ("subject", "subject_dummy", "patterns", "guards", "bodies")
 
     __match_args__ = ("subject", "patterns", "guards", "bodies")
 
     subject: Expression
+    subject_dummy: NameExpr | None
     patterns: list[Pattern]
     guards: list[Expression | None]
     bodies: list[Block]
@@ -1634,6 +1686,7 @@ class MatchStmt(Statement):
         super().__init__()
         assert len(patterns) == len(guards) == len(bodies)
         self.subject = subject
+        self.subject_dummy = None
         self.patterns = patterns
         self.guards = guards
         self.bodies = bodies
@@ -2053,7 +2106,7 @@ class AssignmentExpr(Expression):
 
     __match_args__ = ("target", "value")
 
-    def __init__(self, target: Expression, value: Expression) -> None:
+    def __init__(self, target: NameExpr, value: Expression) -> None:
         super().__init__()
         self.target = target
         self.value = value
@@ -2552,6 +2605,11 @@ class TypeVarLikeExpr(SymbolNode, Expres
         return self._fullname
 
 
+# All types that are both SymbolNodes and Expressions.
+# Use when common children of them are needed.
+SYMBOL_NODE_EXPRESSION_TYPES: Final = (TypeVarLikeExpr,)
+
+
 class TypeVarExpr(TypeVarLikeExpr):
     """Type variable expression TypeVar(...).
 
@@ -3216,16 +3274,55 @@ class TypeInfo(SymbolNode):
 
     @property
     def enum_members(self) -> list[str]:
-        return [
-            name
-            for name, sym in self.names.items()
-            if (
-                isinstance(sym.node, Var)
-                and name not in EXCLUDED_ENUM_ATTRIBUTES
-                and not name.startswith("__")
-                and sym.node.has_explicit_value
-            )
-        ]
+        # TODO: cache the results?
+        members = []
+        for name, sym in self.names.items():
+            # Case 1:
+            #
+            # class MyEnum(Enum):
+            #     @member
+            #     def some(self): ...
+            if isinstance(sym.node, Decorator):
+                if any(
+                    dec.fullname == "enum.member"
+                    for dec in sym.node.decorators
+                    if isinstance(dec, RefExpr)
+                ):
+                    members.append(name)
+                    continue
+            # Case 2:
+            #
+            # class MyEnum(Enum):
+            #     x = 1
+            #
+            # Case 3:
+            #
+            # class MyEnum(Enum):
+            #     class Other: ...
+            elif isinstance(sym.node, (Var, TypeInfo)):
+                if (
+                    # TODO: properly support ignored names from `_ignore_`
+                    name in EXCLUDED_ENUM_ATTRIBUTES
+                    or is_sunder(name)
+                    or name.startswith("__")  # dunder and private
+                ):
+                    continue  # name is excluded
+
+                if isinstance(sym.node, Var):
+                    if not sym.node.has_explicit_value:
+                        continue  # unannotated value not a member
+
+                    typ = mypy.types.get_proper_type(sym.node.type)
+                    if isinstance(
+                        typ, mypy.types.FunctionLike
+                    ) or (  # explicit `@member` is required
+                        isinstance(typ, mypy.types.Instance)
+                        and typ.type.fullname == "enum.nonmember"
+                    ):
+                        continue  # name is not a member
+
+                members.append(name)
+        return members
 
     def __getitem__(self, name: str) -> SymbolTableNode:
         n = self.get(name)
@@ -3250,7 +3347,7 @@ class TypeInfo(SymbolNode):
         for cls in self.mro:
             if name in cls.names:
                 node = cls.names[name].node
-                if isinstance(node, FuncBase):
+                if isinstance(node, SYMBOL_FUNCBASE_TYPES):
                     return node
                 elif isinstance(node, Decorator):  # Two `if`s make `mypyc` happy
                     return node
@@ -4009,7 +4106,8 @@ class SymbolTable(dict[str, SymbolTableN
                 ):
                     a.append("  " + str(key) + " : " + str(value))
             else:
-                a.append("  <invalid item>")
+                # Used in debugging:
+                a.append("  <invalid item>")  # type: ignore[unreachable]
         a = sorted(a)
         a.insert(0, "SymbolTable(")
         a[-1] += ")"
diff -pruN 1.15.0-5/mypy/options.py 1.16~rc0.1-1/mypy/options.py
--- 1.15.0-5/mypy/options.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/options.py	2025-05-27 17:21:15.000000000 +0000
@@ -22,6 +22,7 @@ class BuildType:
 PER_MODULE_OPTIONS: Final = {
     # Please keep this list sorted
     "allow_redefinition",
+    "allow_redefinition_new",
     "allow_untyped_globals",
     "always_false",
     "always_true",
@@ -136,6 +137,7 @@ class Options:
         self.explicit_package_bases = False
         # File names, directory names or subpaths to avoid checking
         self.exclude: list[str] = []
+        self.exclude_gitignore: bool = False
 
         # disallow_any options
         self.disallow_any_generics = False
@@ -182,6 +184,10 @@ class Options:
         # Report importing or using deprecated features as errors instead of notes.
         self.report_deprecated_as_note = False
 
+        # Allow deprecated calls from function coming from modules/packages
+        # in this list (each item effectively acts as a prefix match)
+        self.deprecated_calls_exclude: list[str] = []
+
         # Warn about unused '# type: ignore' comments
         self.warn_unused_ignores = False
 
@@ -214,6 +220,10 @@ class Options:
         # and the same nesting level as the initialization
         self.allow_redefinition = False
 
+        # Allow flexible variable redefinition with an arbitrary type, in different
+        # blocks and and at different nesting levels
+        self.allow_redefinition_new = False
+
         # Prohibit equality, identity, and container checks for non-overlapping types.
         # This makes 1 == '1', 1 in ['1'], and 1 is '1' errors.
         self.strict_equality = False
@@ -396,6 +406,12 @@ class Options:
         # Sets custom output format
         self.output: str | None = None
 
+        # Output html file for mypyc -a
+        self.mypyc_annotation_file: str | None = None
+        # Skip writing C output files, but perform all other steps of a build (allows
+        # preserving manual tweaks to generated C file)
+        self.mypyc_skip_c_generation = False
+
     def use_lowercase_names(self) -> bool:
         if self.python_version >= (3, 9):
             return not self.force_uppercase_builtins
@@ -450,6 +466,16 @@ class Options:
             if feature in COMPLETE_FEATURES:
                 warning_callback(f"Warning: {feature} is already enabled by default")
 
+    def process_strict_bytes(self) -> None:
+        # Sync `--strict-bytes` and `--disable-{bytearray,memoryview}-promotion`
+        if self.strict_bytes:
+            # backwards compatibility
+            self.disable_bytearray_promotion = True
+            self.disable_memoryview_promotion = True
+        elif self.disable_bytearray_promotion and self.disable_memoryview_promotion:
+            # forwards compatibility
+            self.strict_bytes = True
+
     def apply_changes(self, changes: dict[str, object]) -> Options:
         # Note: effects of this method *must* be idempotent.
         new_options = Options()
diff -pruN 1.15.0-5/mypy/partially_defined.py 1.16~rc0.1-1/mypy/partially_defined.py
--- 1.15.0-5/mypy/partially_defined.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/partially_defined.py	2025-05-27 17:21:15.000000000 +0000
@@ -45,7 +45,7 @@ from mypy.options import Options
 from mypy.patterns import AsPattern, StarredPattern
 from mypy.reachability import ALWAYS_TRUE, infer_pattern_value
 from mypy.traverser import ExtendedTraverserVisitor
-from mypy.types import Type, UninhabitedType
+from mypy.types import Type, UninhabitedType, get_proper_type
 
 
 class BranchState:
@@ -507,7 +507,8 @@ class PossiblyUndefinedVariableVisitor(E
         self.tracker.skip_branch()
 
     def visit_expression_stmt(self, o: ExpressionStmt) -> None:
-        if isinstance(self.type_map.get(o.expr, None), (UninhabitedType, type(None))):
+        typ = self.type_map.get(o.expr)
+        if typ is None or isinstance(get_proper_type(typ), UninhabitedType):
             self.tracker.skip_branch()
         super().visit_expression_stmt(o)
 
diff -pruN 1.15.0-5/mypy/plugins/attrs.py 1.16~rc0.1-1/mypy/plugins/attrs.py
--- 1.15.0-5/mypy/plugins/attrs.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/plugins/attrs.py	2025-05-27 17:21:15.000000000 +0000
@@ -56,7 +56,12 @@ from mypy.plugins.common import (
 )
 from mypy.server.trigger import make_wildcard_trigger
 from mypy.state import state
-from mypy.typeops import get_type_vars, make_simplified_union, map_type_from_supertype
+from mypy.typeops import (
+    get_type_vars,
+    make_simplified_union,
+    map_type_from_supertype,
+    type_object_type,
+)
 from mypy.types import (
     AnyType,
     CallableType,
@@ -726,8 +731,6 @@ def _parse_converter(
         ):
             converter_type = converter_expr.node.type
         elif isinstance(converter_expr.node, TypeInfo):
-            from mypy.checkmember import type_object_type  # To avoid import cycle.
-
             converter_type = type_object_type(converter_expr.node, ctx.api.named_type)
     elif (
         isinstance(converter_expr, IndexExpr)
@@ -736,8 +739,6 @@ def _parse_converter(
         and isinstance(converter_expr.base.node, TypeInfo)
     ):
         # The converter is a generic type.
-        from mypy.checkmember import type_object_type  # To avoid import cycle.
-
         converter_type = type_object_type(converter_expr.base.node, ctx.api.named_type)
         if isinstance(converter_type, CallableType):
             converter_type = apply_generic_arguments(
diff -pruN 1.15.0-5/mypy/plugins/dataclasses.py 1.16~rc0.1-1/mypy/plugins/dataclasses.py
--- 1.15.0-5/mypy/plugins/dataclasses.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/plugins/dataclasses.py	2025-05-27 17:21:15.000000000 +0000
@@ -359,12 +359,12 @@ class DataclassTransformer:
 
         if decorator_arguments["frozen"]:
             if any(not parent["frozen"] for parent in parent_decorator_arguments):
-                self._api.fail("Cannot inherit frozen dataclass from a non-frozen one", info)
+                self._api.fail("Frozen dataclass cannot inherit from a non-frozen dataclass", info)
             self._propertize_callables(attributes, settable=False)
             self._freeze(attributes)
         else:
             if any(parent["frozen"] for parent in parent_decorator_arguments):
-                self._api.fail("Cannot inherit non-frozen dataclass from a frozen one", info)
+                self._api.fail("Non-frozen dataclass cannot inherit from a frozen dataclass", info)
             self._propertize_callables(attributes)
 
         if decorator_arguments["slots"]:
@@ -381,7 +381,9 @@ class DataclassTransformer:
         ):
             str_type = self._api.named_type("builtins.str")
             literals: list[Type] = [
-                LiteralType(attr.name, str_type) for attr in attributes if attr.is_in_init
+                LiteralType(attr.name, str_type)
+                for attr in attributes
+                if attr.is_in_init and not attr.kw_only
             ]
             match_args_type = TupleType(literals, self._api.named_type("builtins.tuple"))
             add_attribute_to_class(self._api, self._cls, "__match_args__", match_args_type)
@@ -768,6 +770,8 @@ class DataclassTransformer:
             if sym_node is not None:
                 var = sym_node.node
                 if isinstance(var, Var):
+                    if var.is_final:
+                        continue  # do not turn `Final` attrs to `@property`
                     var.is_property = True
             else:
                 var = attr.to_var(info)
@@ -963,6 +967,9 @@ def dataclass_tag_callback(ctx: ClassDef
 
 def dataclass_class_maker_callback(ctx: ClassDefContext) -> bool:
     """Hooks into the class typechecking process to add support for dataclasses."""
+    if any(i.is_named_tuple for i in ctx.cls.info.mro):
+        ctx.api.fail("A NamedTuple cannot be a dataclass", ctx=ctx.cls.info)
+        return True
     transformer = DataclassTransformer(
         ctx.cls, ctx.reason, _get_transform_spec(ctx.reason), ctx.api
     )
diff -pruN 1.15.0-5/mypy/plugins/default.py 1.16~rc0.1-1/mypy/plugins/default.py
--- 1.15.0-5/mypy/plugins/default.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/plugins/default.py	2025-05-27 17:21:15.000000000 +0000
@@ -554,7 +554,7 @@ def tuple_mul_callback(ctx: MethodContex
         value = arg_type.last_known_value.value
         if isinstance(value, int):
             return ctx.type.copy_modified(items=ctx.type.items * value)
-    elif isinstance(ctx.type, LiteralType):
+    elif isinstance(arg_type, LiteralType):
         value = arg_type.value
         if isinstance(value, int):
             return ctx.type.copy_modified(items=ctx.type.items * value)
diff -pruN 1.15.0-5/mypy/plugins/functools.py 1.16~rc0.1-1/mypy/plugins/functools.py
--- 1.15.0-5/mypy/plugins/functools.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/plugins/functools.py	2025-05-27 17:21:15.000000000 +0000
@@ -8,7 +8,16 @@ import mypy.checker
 import mypy.plugin
 import mypy.semanal
 from mypy.argmap import map_actuals_to_formals
-from mypy.nodes import ARG_POS, ARG_STAR2, ArgKind, Argument, CallExpr, FuncItem, NameExpr, Var
+from mypy.nodes import (
+    ARG_POS,
+    ARG_STAR2,
+    SYMBOL_FUNCBASE_TYPES,
+    ArgKind,
+    Argument,
+    CallExpr,
+    NameExpr,
+    Var,
+)
 from mypy.plugins.common import add_method_to_class
 from mypy.typeops import get_all_type_vars
 from mypy.types import (
@@ -108,7 +117,7 @@ def _analyze_class(ctx: mypy.plugin.Clas
         for name in _ORDERING_METHODS:
             if name in cls.names and name not in comparison_methods:
                 node = cls.names[name].node
-                if isinstance(node, FuncItem) and isinstance(node.type, CallableType):
+                if isinstance(node, SYMBOL_FUNCBASE_TYPES) and isinstance(node.type, CallableType):
                     comparison_methods[name] = _MethodInfo(node.is_static, node.type)
                     continue
 
@@ -267,7 +276,7 @@ def handle_partial_with_callee(ctx: mypy
     for i, actuals in enumerate(formal_to_actual):
         if len(bound.arg_types) == len(fn_type.arg_types):
             arg_type = bound.arg_types[i]
-            if not mypy.checker.is_valid_inferred_type(arg_type):
+            if not mypy.checker.is_valid_inferred_type(arg_type, ctx.api.options):
                 arg_type = fn_type.arg_types[i]  # bit of a hack
         else:
             # TODO: I assume that bound and fn_type have the same arguments. It appears this isn't
@@ -292,7 +301,7 @@ def handle_partial_with_callee(ctx: mypy
             partial_names.append(fn_type.arg_names[i])
 
     ret_type = bound.ret_type
-    if not mypy.checker.is_valid_inferred_type(ret_type):
+    if not mypy.checker.is_valid_inferred_type(ret_type, ctx.api.options):
         ret_type = fn_type.ret_type  # same kind of hack as above
 
     partially_applied = fn_type.copy_modified(
diff -pruN 1.15.0-5/mypy/reachability.py 1.16~rc0.1-1/mypy/reachability.py
--- 1.15.0-5/mypy/reachability.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/reachability.py	2025-05-27 17:21:15.000000000 +0000
@@ -221,7 +221,7 @@ def consider_sys_platform(expr: Expressi
     Return ALWAYS_TRUE, ALWAYS_FALSE, or TRUTH_VALUE_UNKNOWN.
     """
     # Cases supported:
-    # - sys.platform == 'posix'
+    # - sys.platform == 'linux'
     # - sys.platform != 'win32'
     # - sys.platform.startswith('win')
     if isinstance(expr, ComparisonExpr):
diff -pruN 1.15.0-5/mypy/renaming.py 1.16~rc0.1-1/mypy/renaming.py
--- 1.15.0-5/mypy/renaming.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/renaming.py	2025-05-27 17:21:15.000000000 +0000
@@ -152,7 +152,21 @@ class VariableRenameVisitor(TraverserVis
         # type checker which allows them to be always redefined, so no need to
         # do renaming here.
         with self.enter_try():
-            super().visit_try_stmt(stmt)
+            stmt.body.accept(self)
+
+        for var, tp, handler in zip(stmt.vars, stmt.types, stmt.handlers):
+            with self.enter_block():
+                # Handle except variable together with its body
+                if tp is not None:
+                    tp.accept(self)
+                if var is not None:
+                    self.handle_def(var)
+                for s in handler.body:
+                    s.accept(self)
+        if stmt.else_body is not None:
+            stmt.else_body.accept(self)
+        if stmt.finally_body is not None:
+            stmt.finally_body.accept(self)
 
     def visit_with_stmt(self, stmt: WithStmt) -> None:
         for expr in stmt.expr:
diff -pruN 1.15.0-5/mypy/semanal.py 1.16~rc0.1-1/mypy/semanal.py
--- 1.15.0-5/mypy/semanal.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/semanal.py	2025-05-27 17:21:15.000000000 +0000
@@ -86,6 +86,7 @@ from mypy.nodes import (
     REVEAL_LOCALS,
     REVEAL_TYPE,
     RUNTIME_PROTOCOL_DECOS,
+    SYMBOL_FUNCBASE_TYPES,
     TYPE_VAR_KIND,
     TYPE_VAR_TUPLE_KIND,
     VARIANCE_NOT_READY,
@@ -97,10 +98,12 @@ from mypy.nodes import (
     AwaitExpr,
     Block,
     BreakStmt,
+    BytesExpr,
     CallExpr,
     CastExpr,
     ClassDef,
     ComparisonExpr,
+    ComplexExpr,
     ConditionalExpr,
     Context,
     ContinueStmt,
@@ -114,6 +117,7 @@ from mypy.nodes import (
     Expression,
     ExpressionStmt,
     FakeExpression,
+    FloatExpr,
     ForStmt,
     FuncBase,
     FuncDef,
@@ -126,6 +130,7 @@ from mypy.nodes import (
     ImportBase,
     ImportFrom,
     IndexExpr,
+    IntExpr,
     LambdaExpr,
     ListComprehension,
     ListExpr,
@@ -193,6 +198,7 @@ from mypy.patterns import (
     MappingPattern,
     OrPattern,
     SequencePattern,
+    SingletonPattern,
     StarredPattern,
     ValuePattern,
 )
@@ -263,6 +269,7 @@ from mypy.types import (
     TYPE_CHECK_ONLY_NAMES,
     TYPE_VAR_LIKE_NAMES,
     TYPED_NAMEDTUPLE_NAMES,
+    UNPACK_TYPE_NAMES,
     AnyType,
     CallableType,
     FunctionLike,
@@ -651,6 +658,13 @@ class SemanticAnalyzer(
 
     def refresh_top_level(self, file_node: MypyFile) -> None:
         """Reanalyze a stale module top-level in fine-grained incremental mode."""
+        if self.options.allow_redefinition_new and not self.options.local_partial_types:
+            n = TempNode(AnyType(TypeOfAny.special_form))
+            n.line = 1
+            n.column = 0
+            n.end_line = 1
+            n.end_column = 0
+            self.fail("--local-partial-types must be enabled if using --allow-redefinition-new", n)
         self.recurse_into_functions = False
         self.add_implicit_module_attrs(file_node)
         for d in file_node.defs:
@@ -1071,6 +1085,7 @@ class SemanticAnalyzer(
                         assert self.type is not None and self.type.self_type is not None
                         leading_type: Type = self.type.self_type
                     else:
+                        func.is_trivial_self = True
                         leading_type = fill_typevars(info)
                     if func.is_class or func.name == "__new__":
                         leading_type = self.class_type(leading_type)
@@ -1239,15 +1254,18 @@ class SemanticAnalyzer(
         with self.overload_item_set(0):
             first_item.accept(self)
 
+        bare_setter_type = None
+        is_property = False
         if isinstance(first_item, Decorator) and first_item.func.is_property:
+            is_property = True
             # This is a property.
             first_item.func.is_overload = True
-            self.analyze_property_with_multi_part_definition(defn)
+            bare_setter_type = self.analyze_property_with_multi_part_definition(defn)
             typ = function_type(first_item.func, self.named_type("builtins.function"))
             assert isinstance(typ, CallableType)
             types = [typ]
         else:
-            # This is an a normal overload. Find the item signatures, the
+            # This is a normal overload. Find the item signatures, the
             # implementation (if outside a stub), and any missing @overload
             # decorators.
             types, impl, non_overload_indexes = self.analyze_overload_sigs_and_impl(defn)
@@ -1267,8 +1285,10 @@ class SemanticAnalyzer(
         if types and not any(
             # If some overload items are decorated with other decorators, then
             # the overload type will be determined during type checking.
-            isinstance(it, Decorator) and len(it.decorators) > 1
-            for it in defn.items
+            # Note: bare @property is removed in visit_decorator().
+            isinstance(it, Decorator)
+            and len(it.decorators) > (1 if i > 0 or not is_property else 0)
+            for i, it in enumerate(defn.items)
         ):
             # TODO: should we enforce decorated overloads consistency somehow?
             # Some existing code uses both styles:
@@ -1276,6 +1296,11 @@ class SemanticAnalyzer(
             #   * Put decorator everywhere, use "bare" types in overloads.
             defn.type = Overloaded(types)
             defn.type.line = defn.line
+            # In addition, we can set the getter/setter type for valid properties as some
+            # code paths may either use the above type, or var.type etc. of the first item.
+            if isinstance(first_item, Decorator) and bare_setter_type:
+                first_item.var.type = types[0]
+                first_item.var.setter_type = bare_setter_type
 
         if not defn.items:
             # It was not a real overload after all, but function redefinition. We've
@@ -1437,8 +1462,15 @@ class SemanticAnalyzer(
                         item.func.abstract_status = IS_ABSTRACT
                     else:
                         item.abstract_status = IS_ABSTRACT
+            elif all(
+                isinstance(item, Decorator) and item.func.abstract_status == IS_ABSTRACT
+                for item in defn.items
+            ):
+                # Since there is no implementation, it can't be called via super().
+                if defn.items:
+                    assert isinstance(defn.items[0], Decorator)
+                    defn.items[0].func.is_trivial_body = True
             else:
-                # TODO: also allow omitting an implementation for abstract methods in ABCs?
                 self.fail(
                     "An overloaded function outside a stub file must have an implementation",
                     defn,
@@ -1495,19 +1527,25 @@ class SemanticAnalyzer(
             defn.is_class = class_status[0]
             defn.is_static = static_status[0]
 
-    def analyze_property_with_multi_part_definition(self, defn: OverloadedFuncDef) -> None:
+    def analyze_property_with_multi_part_definition(
+        self, defn: OverloadedFuncDef
+    ) -> CallableType | None:
         """Analyze a property defined using multiple methods (e.g., using @x.setter).
 
         Assume that the first method (@property) has already been analyzed.
+        Return bare setter type (without any other decorators applied), this may be used
+        by the caller for performance optimizations.
         """
         defn.is_property = True
         items = defn.items
         first_item = defn.items[0]
         assert isinstance(first_item, Decorator)
         deleted_items = []
+        bare_setter_type = None
         for i, item in enumerate(items[1:]):
             if isinstance(item, Decorator):
-                if len(item.decorators) >= 1:
+                item.func.accept(self)
+                if item.decorators:
                     first_node = item.decorators[0]
                     if isinstance(first_node, MemberExpr):
                         if first_node.name == "setter":
@@ -1515,6 +1553,11 @@ class SemanticAnalyzer(
                             first_item.var.is_settable_property = True
                             # Get abstractness from the original definition.
                             item.func.abstract_status = first_item.func.abstract_status
+                            setter_func_type = function_type(
+                                item.func, self.named_type("builtins.function")
+                            )
+                            assert isinstance(setter_func_type, CallableType)
+                            bare_setter_type = setter_func_type
                         if first_node.name == "deleter":
                             item.func.abstract_status = first_item.func.abstract_status
                         for other_node in item.decorators[1:]:
@@ -1523,7 +1566,6 @@ class SemanticAnalyzer(
                         self.fail(
                             f"Only supported top decorator is @{first_item.func.name}.setter", item
                         )
-                item.func.accept(self)
             else:
                 self.fail(f'Unexpected definition for property "{first_item.func.name}"', item)
                 deleted_items.append(i + 1)
@@ -1537,6 +1579,7 @@ class SemanticAnalyzer(
                         item.func.deprecated = (
                             f"function {item.fullname} is deprecated: {deprecated}"
                         )
+        return bare_setter_type
 
     def add_function_to_symbol_table(self, func: FuncDef | OverloadedFuncDef) -> None:
         if self.is_class_scope():
@@ -2281,7 +2324,7 @@ class SemanticAnalyzer(
             return self.analyze_unbound_tvar_impl(t.type, is_unpacked=True)
         if isinstance(t, UnboundType):
             sym = self.lookup_qualified(t.name, t)
-            if sym and sym.fullname in ("typing.Unpack", "typing_extensions.Unpack"):
+            if sym and sym.fullname in UNPACK_TYPE_NAMES:
                 inner_t = t.args[0]
                 if isinstance(inner_t, UnboundType):
                     return self.analyze_unbound_tvar_impl(inner_t, is_unpacked=True)
@@ -3076,8 +3119,6 @@ class SemanticAnalyzer(
             for name, node in m.names.items():
                 fullname = i_id + "." + name
                 self.set_future_import_flags(fullname)
-                if node is None:
-                    continue
                 # if '__all__' exists, all nodes not included have had module_public set to
                 # False, and we can skip checking '_' because it's been explicitly included.
                 if node.module_public and (not name.startswith("_") or "__all__" in m.names):
@@ -3431,8 +3472,9 @@ class SemanticAnalyzer(
     def analyze_enum_assign(self, s: AssignmentStmt) -> bool:
         """Check if s defines an Enum."""
         if isinstance(s.rvalue, CallExpr) and isinstance(s.rvalue.analyzed, EnumCallExpr):
-            # Already analyzed enum -- nothing to do here.
-            return True
+            # This is an analyzed enum definition.
+            # It is valid iff it can be stored correctly, failures were already reported.
+            return self._is_single_name_assignment(s)
         return self.enum_call_analyzer.process_enum_call(s, self.is_func_scope())
 
     def analyze_namedtuple_assign(self, s: AssignmentStmt) -> bool:
@@ -3441,7 +3483,9 @@ class SemanticAnalyzer(
             if s.rvalue.analyzed.info.tuple_type and not has_placeholder(
                 s.rvalue.analyzed.info.tuple_type
             ):
-                return True  # This is a valid and analyzed named tuple definition, nothing to do here.
+                # This is an analyzed named tuple definition.
+                # It is valid iff it can be stored correctly, failures were already reported.
+                return self._is_single_name_assignment(s)
         if len(s.lvalues) != 1 or not isinstance(s.lvalues[0], (NameExpr, MemberExpr)):
             return False
         lvalue = s.lvalues[0]
@@ -3482,8 +3526,9 @@ class SemanticAnalyzer(
             if s.rvalue.analyzed.info.typeddict_type and not has_placeholder(
                 s.rvalue.analyzed.info.typeddict_type
             ):
-                # This is a valid and analyzed typed dict definition, nothing to do here.
-                return True
+                # This is an analyzed typed dict definition.
+                # It is valid iff it can be stored correctly, failures were already reported.
+                return self._is_single_name_assignment(s)
         if len(s.lvalues) != 1 or not isinstance(s.lvalues[0], (NameExpr, MemberExpr)):
             return False
         lvalue = s.lvalues[0]
@@ -3507,6 +3552,9 @@ class SemanticAnalyzer(
                 self.setup_alias_type_vars(defn)
             return True
 
+    def _is_single_name_assignment(self, s: AssignmentStmt) -> bool:
+        return len(s.lvalues) == 1 and isinstance(s.lvalues[0], NameExpr)
+
     def analyze_lvalues(self, s: AssignmentStmt) -> None:
         # We cannot use s.type, because analyze_simple_literal_type() will set it.
         explicit = s.unanalyzed_type is not None
@@ -3703,9 +3751,9 @@ class SemanticAnalyzer(
                     cur_node = self.type.names.get(lval.name, None)
                     if cur_node and isinstance(cur_node.node, Var) and cur_node.node.is_final:
                         assert self.function_stack
-                        top_function = self.function_stack[-1]
+                        current_function = self.function_stack[-1]
                         if (
-                            top_function.name == "__init__"
+                            current_function.name == "__init__"
                             and cur_node.node.final_unset_in_class
                             and not cur_node.node.final_set_in_init
                             and not (isinstance(s.rvalue, TempNode) and s.rvalue.no_rhs)
@@ -4166,7 +4214,7 @@ class SemanticAnalyzer(
                         base,
                         code=codes.TYPE_VAR,
                     )
-                    if sym and sym.fullname in ("typing.Unpack", "typing_extensions.Unpack"):
+                    if sym and sym.fullname in UNPACK_TYPE_NAMES:
                         self.note(
                             "Don't Unpack type variables in type_params", base, code=codes.TYPE_VAR
                         )
@@ -4188,7 +4236,16 @@ class SemanticAnalyzer(
     ) -> None:
         """Prohibit and fix recursive type aliases that are invalid/unsupported."""
         messages = []
-        if is_invalid_recursive_alias({current_node}, current_node.target):
+        if (
+            isinstance(current_node.target, TypeAliasType)
+            and current_node.target.alias is current_node
+        ):
+            # We want to have consistent error messages, but not calling name_not_defined(),
+            # since it will do a bunch of unrelated things we don't want here.
+            messages.append(
+                f'Cannot resolve name "{current_node.name}" (possible cyclic definition)'
+            )
+        elif is_invalid_recursive_alias({current_node}, current_node.target):
             target = (
                 "tuple" if isinstance(get_proper_type(current_node.target), TupleType) else "union"
             )
@@ -4321,8 +4378,10 @@ class SemanticAnalyzer(
                 else:
                     lvalue.fullname = lvalue.name
                 if self.is_func_scope():
-                    if unmangle(name) == "_":
+                    if unmangle(name) == "_" and not self.options.allow_redefinition_new:
                         # Special case for assignment to local named '_': always infer 'Any'.
+                        # This isn't needed with --allow-redefinition-new, since arbitrary
+                        # types can be assigned to '_' anyway.
                         typ = AnyType(TypeOfAny.special_form)
                         self.store_declared_types(lvalue, typ)
             if is_final and self.is_final_redefinition(kind, name):
@@ -5533,7 +5592,7 @@ class SemanticAnalyzer(
                 self.msg.unimported_type_becomes_any("Type alias target", res, s)
                 res = make_any_non_unimported(res)
             eager = self.is_func_scope()
-            if isinstance(res, ProperType) and isinstance(res, Instance) and not res.args:
+            if isinstance(res, ProperType) and isinstance(res, Instance):
                 fix_instance(res, self.fail, self.note, disallow_any=False, options=self.options)
             alias_node = TypeAlias(
                 res,
@@ -5704,7 +5763,7 @@ class SemanticAnalyzer(
             reveal_type_node = self.lookup("reveal_type", expr, suppress_errors=True)
             if (
                 reveal_type_node
-                and isinstance(reveal_type_node.node, FuncBase)
+                and isinstance(reveal_type_node.node, SYMBOL_FUNCBASE_TYPES)
                 and reveal_type_node.fullname in IMPORTED_REVEAL_TYPE_NAMES
             ):
                 reveal_imported = True
@@ -6027,6 +6086,8 @@ class SemanticAnalyzer(
                 return None
             types.append(analyzed)
 
+        if allow_unpack:
+            types = self.type_analyzer().check_unpacks_in_list(types)
         if has_param_spec and num_args == 1 and types:
             first_arg = get_proper_type(types[0])
             single_any = len(types) == 1 and isinstance(first_arg, AnyType)
@@ -6128,7 +6189,8 @@ class SemanticAnalyzer(
 
     def visit_lambda_expr(self, expr: LambdaExpr) -> None:
         self.analyze_arg_initializers(expr)
-        self.analyze_function_body(expr)
+        with self.inside_except_star_block_set(False, entering_loop=False):
+            self.analyze_function_body(expr)
 
     def visit_conditional_expr(self, expr: ConditionalExpr) -> None:
         expr.if_expr.accept(self)
@@ -6309,12 +6371,26 @@ class SemanticAnalyzer(
         if self.statement is None:
             # Assume it's fine -- don't have enough context to check
             return True
-        return (
+        if (
             node is None
             or self.is_textually_before_statement(node)
             or not self.is_defined_in_current_module(node.fullname)
-            or isinstance(node, (TypeInfo, TypeAlias))
-            or (isinstance(node, PlaceholderNode) and node.becomes_typeinfo)
+        ):
+            return True
+        if self.is_type_like(node):
+            # Allow forward references to classes/type aliases (see docstring), but
+            # a forward reference should never shadow an existing regular reference.
+            if node.name not in self.globals:
+                return True
+            global_node = self.globals[node.name]
+            if not self.is_textually_before_class(global_node.node):
+                return True
+            return not self.is_type_like(global_node.node)
+        return False
+
+    def is_type_like(self, node: SymbolNode | None) -> bool:
+        return isinstance(node, (TypeInfo, TypeAlias)) or (
+            isinstance(node, PlaceholderNode) and node.becomes_typeinfo
         )
 
     def is_textually_before_statement(self, node: SymbolNode) -> bool:
@@ -6336,6 +6412,13 @@ class SemanticAnalyzer(
         else:
             return line_diff > 0
 
+    def is_textually_before_class(self, node: SymbolNode | None) -> bool:
+        """Similar to above, but check if a node is defined before current class."""
+        assert self.type is not None
+        if node is None:
+            return False
+        return node.line < self.type.defn.line
+
     def is_overloaded_item(self, node: SymbolNode, statement: Statement) -> bool:
         """Check whether the function belongs to the overloaded variants"""
         if isinstance(node, OverloadedFuncDef) and isinstance(statement, FuncDef):
@@ -7218,7 +7301,15 @@ class SemanticAnalyzer(
             if code is None:
                 code = msg.code
             msg = msg.value
-        self.errors.report(ctx.line, ctx.column, msg, blocker=blocker, code=code)
+        self.errors.report(
+            ctx.line,
+            ctx.column,
+            msg,
+            blocker=blocker,
+            code=code,
+            end_line=ctx.end_line,
+            end_column=ctx.end_column,
+        )
 
     def note(self, msg: str, ctx: Context, code: ErrorCode | None = None) -> None:
         if not self.in_checked_function():
@@ -7521,6 +7612,34 @@ class SemanticAnalyzer(
             names.append(specifier.fullname)
         return tuple(names)
 
+    # leafs
+    def visit_int_expr(self, o: IntExpr, /) -> None:
+        return None
+
+    def visit_str_expr(self, o: StrExpr, /) -> None:
+        return None
+
+    def visit_bytes_expr(self, o: BytesExpr, /) -> None:
+        return None
+
+    def visit_float_expr(self, o: FloatExpr, /) -> None:
+        return None
+
+    def visit_complex_expr(self, o: ComplexExpr, /) -> None:
+        return None
+
+    def visit_ellipsis(self, o: EllipsisExpr, /) -> None:
+        return None
+
+    def visit_temp_node(self, o: TempNode, /) -> None:
+        return None
+
+    def visit_pass_stmt(self, o: PassStmt, /) -> None:
+        return None
+
+    def visit_singleton_pattern(self, o: SingletonPattern, /) -> None:
+        return None
+
 
 def replace_implicit_first_type(sig: FunctionLike, new: Type) -> FunctionLike:
     if isinstance(sig, CallableType):
diff -pruN 1.15.0-5/mypy/semanal_main.py 1.16~rc0.1-1/mypy/semanal_main.py
--- 1.15.0-5/mypy/semanal_main.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/semanal_main.py	2025-05-27 17:21:15.000000000 +0000
@@ -26,7 +26,9 @@ will be incomplete.
 
 from __future__ import annotations
 
+from collections.abc import Iterator
 from contextlib import nullcontext
+from itertools import groupby
 from typing import TYPE_CHECKING, Callable, Final, Optional, Union
 from typing_extensions import TypeAlias as _TypeAlias
 
@@ -179,7 +181,7 @@ def process_top_levels(graph: Graph, scc
 
     # Reverse order of the scc so the first modules in the original list will be
     # be processed first. This helps with performance.
-    scc = list(reversed(scc))
+    scc = list(reversed(scc))  # noqa: FURB187 intentional copy
 
     # Initialize ASTs and symbol tables.
     for id in scc:
@@ -232,26 +234,66 @@ def process_top_levels(graph: Graph, scc
         final_iteration = not any_progress
 
 
+def order_by_subclassing(targets: list[FullTargetInfo]) -> Iterator[FullTargetInfo]:
+    """Make sure that superclass methods are always processed before subclass methods.
+
+    This algorithm is not very optimal, but it is simple and should work well for lists
+    that are already almost correctly ordered.
+    """
+
+    # First, group the targets by their TypeInfo (since targets are sorted by line,
+    # we know that each TypeInfo will appear as group key only once).
+    grouped = [(k, list(g)) for k, g in groupby(targets, key=lambda x: x[3])]
+    remaining_infos = {info for info, _ in grouped if info is not None}
+
+    next_group = 0
+    while grouped:
+        if next_group >= len(grouped):
+            # This should never happen, if there is an MRO cycle, it should be reported
+            # and fixed during top-level processing.
+            raise ValueError("Cannot order method targets by MRO")
+        next_info, group = grouped[next_group]
+        if next_info is None:
+            # Trivial case, not methods but functions, process them straight away.
+            yield from group
+            grouped.pop(next_group)
+            continue
+        if any(parent in remaining_infos for parent in next_info.mro[1:]):
+            # We cannot process this method group yet, try a next one.
+            next_group += 1
+            continue
+        yield from group
+        grouped.pop(next_group)
+        remaining_infos.discard(next_info)
+        # Each time after processing a method group we should retry from start,
+        # since there may be some groups that are not blocked on parents anymore.
+        next_group = 0
+
+
 def process_functions(graph: Graph, scc: list[str], patches: Patches) -> None:
     # Process functions.
+    all_targets = []
     for module in scc:
         tree = graph[module].tree
         assert tree is not None
-        analyzer = graph[module].manager.semantic_analyzer
         # In principle, functions can be processed in arbitrary order,
         # but _methods_ must be processed in the order they are defined,
         # because some features (most notably partial types) depend on
         # order of definitions on self.
         #
         # There can be multiple generated methods per line. Use target
-        # name as the second sort key to get a repeatable sort order on
-        # Python 3.5, which doesn't preserve dictionary order.
+        # name as the second sort key to get a repeatable sort order.
         targets = sorted(get_all_leaf_targets(tree), key=lambda x: (x[1].line, x[0]))
-        for target, node, active_type in targets:
-            assert isinstance(node, (FuncDef, OverloadedFuncDef, Decorator))
-            process_top_level_function(
-                analyzer, graph[module], module, target, node, active_type, patches
-            )
+        all_targets.extend(
+            [(module, target, node, active_type) for target, node, active_type in targets]
+        )
+
+    for module, target, node, active_type in order_by_subclassing(all_targets):
+        analyzer = graph[module].manager.semantic_analyzer
+        assert isinstance(node, (FuncDef, OverloadedFuncDef, Decorator))
+        process_top_level_function(
+            analyzer, graph[module], module, target, node, active_type, patches
+        )
 
 
 def process_top_level_function(
@@ -308,6 +350,11 @@ TargetInfo: _TypeAlias = tuple[
     str, Union[MypyFile, FuncDef, OverloadedFuncDef, Decorator], Optional[TypeInfo]
 ]
 
+# Same as above but includes module as first item.
+FullTargetInfo: _TypeAlias = tuple[
+    str, str, Union[MypyFile, FuncDef, OverloadedFuncDef, Decorator], Optional[TypeInfo]
+]
+
 
 def get_all_leaf_targets(file: MypyFile) -> list[TargetInfo]:
     """Return all leaf targets in a symbol table (module-level and methods)."""
@@ -342,6 +389,7 @@ def semantic_analyze_target(
     analyzer.global_decls = [set()]
     analyzer.nonlocal_decls = [set()]
     analyzer.globals = tree.names
+    analyzer.imports = set()
     analyzer.progress = False
     with state.wrap_context(check_blockers=False):
         refresh_node = node
diff -pruN 1.15.0-5/mypy/semanal_namedtuple.py 1.16~rc0.1-1/mypy/semanal_namedtuple.py
--- 1.15.0-5/mypy/semanal_namedtuple.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/semanal_namedtuple.py	2025-05-27 17:21:15.000000000 +0000
@@ -198,7 +198,7 @@ class NamedTupleAnalyzer:
                         # Something is incomplete. We need to defer this named tuple.
                         return None
                     types.append(analyzed)
-                # ...despite possible minor failures that allow further analyzis.
+                # ...despite possible minor failures that allow further analysis.
                 if name.startswith("_"):
                     self.fail(
                         f"NamedTuple field name cannot start with an underscore: {name}", stmt
diff -pruN 1.15.0-5/mypy/semanal_newtype.py 1.16~rc0.1-1/mypy/semanal_newtype.py
--- 1.15.0-5/mypy/semanal_newtype.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/semanal_newtype.py	2025-05-27 17:21:15.000000000 +0000
@@ -174,7 +174,7 @@ class NewTypeAnalyzer:
     def check_newtype_args(
         self, name: str, call: CallExpr, context: Context
     ) -> tuple[Type | None, bool]:
-        """Ananlyze base type in NewType call.
+        """Analyze base type in NewType call.
 
         Return a tuple (type, should defer).
         """
diff -pruN 1.15.0-5/mypy/semanal_typeddict.py 1.16~rc0.1-1/mypy/semanal_typeddict.py
--- 1.15.0-5/mypy/semanal_typeddict.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/semanal_typeddict.py	2025-05-27 17:21:15.000000000 +0000
@@ -30,6 +30,7 @@ from mypy.nodes import (
     StrExpr,
     TempNode,
     TupleExpr,
+    TypeAlias,
     TypedDictExpr,
     TypeInfo,
 )
@@ -50,6 +51,7 @@ from mypy.types import (
     TypedDictType,
     TypeOfAny,
     TypeVarLikeType,
+    get_proper_type,
 )
 
 TPDICT_CLASS_ERROR: Final = (
@@ -137,23 +139,18 @@ class TypedDictAnalyzer:
                     typeddict_bases_set.add("TypedDict")
                 else:
                     self.fail('Duplicate base class "TypedDict"', defn)
-            elif isinstance(expr, RefExpr) and self.is_typeddict(expr):
-                assert expr.fullname
-                if expr.fullname not in typeddict_bases_set:
-                    typeddict_bases_set.add(expr.fullname)
+            elif (
+                isinstance(expr, RefExpr)
+                and self.is_typeddict(expr)
+                or isinstance(expr, IndexExpr)
+                and self.is_typeddict(expr.base)
+            ):
+                info = self._parse_typeddict_base(expr, defn)
+                if info.fullname not in typeddict_bases_set:
+                    typeddict_bases_set.add(info.fullname)
                     typeddict_bases.append(expr)
                 else:
-                    assert isinstance(expr.node, TypeInfo)
-                    self.fail(f'Duplicate base class "{expr.node.name}"', defn)
-            elif isinstance(expr, IndexExpr) and self.is_typeddict(expr.base):
-                assert isinstance(expr.base, RefExpr)
-                assert expr.base.fullname
-                if expr.base.fullname not in typeddict_bases_set:
-                    typeddict_bases_set.add(expr.base.fullname)
-                    typeddict_bases.append(expr)
-                else:
-                    assert isinstance(expr.base.node, TypeInfo)
-                    self.fail(f'Duplicate base class "{expr.base.node.name}"', defn)
+                    self.fail(f'Duplicate base class "{info.name}"', defn)
             else:
                 self.fail("All bases of a new TypedDict must be TypedDict types", defn)
 
@@ -190,22 +187,13 @@ class TypedDictAnalyzer:
         readonly_keys: set[str],
         ctx: Context,
     ) -> None:
+        info = self._parse_typeddict_base(base, ctx)
         base_args: list[Type] = []
-        if isinstance(base, RefExpr):
-            assert isinstance(base.node, TypeInfo)
-            info = base.node
-        elif isinstance(base, IndexExpr):
-            assert isinstance(base.base, RefExpr)
-            assert isinstance(base.base.node, TypeInfo)
-            info = base.base.node
+        if isinstance(base, IndexExpr):
             args = self.analyze_base_args(base, ctx)
             if args is None:
                 return
             base_args = args
-        else:
-            assert isinstance(base, CallExpr)
-            assert isinstance(base.analyzed, TypedDictExpr)
-            info = base.analyzed.info
 
         assert info.typeddict_type is not None
         base_typed_dict = info.typeddict_type
@@ -231,6 +219,26 @@ class TypedDictAnalyzer:
         required_keys.update(base_typed_dict.required_keys)
         readonly_keys.update(base_typed_dict.readonly_keys)
 
+    def _parse_typeddict_base(self, base: Expression, ctx: Context) -> TypeInfo:
+        if isinstance(base, RefExpr):
+            if isinstance(base.node, TypeInfo):
+                return base.node
+            elif isinstance(base.node, TypeAlias):
+                # Only old TypeAlias / plain assignment, PEP695 `type` stmt
+                # cannot be used as a base class
+                target = get_proper_type(base.node.target)
+                assert isinstance(target, TypedDictType)
+                return target.fallback.type
+            else:
+                assert False
+        elif isinstance(base, IndexExpr):
+            assert isinstance(base.base, RefExpr)
+            return self._parse_typeddict_base(base.base, ctx)
+        else:
+            assert isinstance(base, CallExpr)
+            assert isinstance(base.analyzed, TypedDictExpr)
+            return base.analyzed.info
+
     def analyze_base_args(self, base: IndexExpr, ctx: Context) -> list[Type] | None:
         """Analyze arguments of base type expressions as types.
 
@@ -527,7 +535,7 @@ class TypedDictAnalyzer:
                 return "", [], [], True, [], False
         dictexpr = args[1]
         tvar_defs = self.api.get_and_bind_all_tvars([t for k, t in dictexpr.items])
-        res = self.parse_typeddict_fields_with_types(dictexpr.items, call)
+        res = self.parse_typeddict_fields_with_types(dictexpr.items)
         if res is None:
             # One of the types is not ready, defer.
             return None
@@ -536,7 +544,7 @@ class TypedDictAnalyzer:
         return args[0].value, items, types, total, tvar_defs, ok
 
     def parse_typeddict_fields_with_types(
-        self, dict_items: list[tuple[Expression | None, Expression]], context: Context
+        self, dict_items: list[tuple[Expression | None, Expression]]
     ) -> tuple[list[str], list[Type], bool] | None:
         """Parse typed dict items passed as pairs (name expression, type expression).
 
@@ -609,10 +617,11 @@ class TypedDictAnalyzer:
     # Helpers
 
     def is_typeddict(self, expr: Expression) -> bool:
-        return (
-            isinstance(expr, RefExpr)
-            and isinstance(expr.node, TypeInfo)
+        return isinstance(expr, RefExpr) and (
+            isinstance(expr.node, TypeInfo)
             and expr.node.typeddict_type is not None
+            or isinstance(expr.node, TypeAlias)
+            and isinstance(get_proper_type(expr.node.target), TypedDictType)
         )
 
     def fail(self, msg: str, ctx: Context, *, code: ErrorCode | None = None) -> None:
diff -pruN 1.15.0-5/mypy/server/astdiff.py 1.16~rc0.1-1/mypy/server/astdiff.py
--- 1.15.0-5/mypy/server/astdiff.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/server/astdiff.py	2025-05-27 17:21:15.000000000 +0000
@@ -58,9 +58,9 @@ from typing_extensions import TypeAlias
 
 from mypy.expandtype import expand_type
 from mypy.nodes import (
+    SYMBOL_FUNCBASE_TYPES,
     UNBOUND_IMPORTED,
     Decorator,
-    FuncBase,
     FuncDef,
     FuncItem,
     MypyFile,
@@ -234,17 +234,22 @@ def snapshot_definition(node: SymbolNode
     The representation is nested tuples and dicts. Only externally
     visible attributes are included.
     """
-    if isinstance(node, FuncBase):
+    if isinstance(node, SYMBOL_FUNCBASE_TYPES):
         # TODO: info
         if node.type:
-            signature = snapshot_type(node.type)
+            signature: tuple[object, ...] = snapshot_type(node.type)
         else:
             signature = snapshot_untyped_signature(node)
         impl: FuncDef | None = None
         if isinstance(node, FuncDef):
             impl = node
-        elif isinstance(node, OverloadedFuncDef) and node.impl:
+        elif node.impl:
             impl = node.impl.func if isinstance(node.impl, Decorator) else node.impl
+        setter_type = None
+        if isinstance(node, OverloadedFuncDef) and node.items:
+            first_item = node.items[0]
+            if isinstance(first_item, Decorator) and first_item.func.is_property:
+                setter_type = snapshot_optional_type(first_item.var.setter_type)
         is_trivial_body = impl.is_trivial_body if impl else False
         dataclass_transform_spec = find_dataclass_transform_spec(node)
         return (
@@ -258,6 +263,7 @@ def snapshot_definition(node: SymbolNode
             is_trivial_body,
             dataclass_transform_spec.serialize() if dataclass_transform_spec is not None else None,
             node.deprecated if isinstance(node, FuncDef) else None,
+            setter_type,  # multi-part properties are stored as OverloadedFuncDef
         )
     elif isinstance(node, Var):
         return ("Var", common, snapshot_optional_type(node.type), node.is_final)
diff -pruN 1.15.0-5/mypy/server/astmerge.py 1.16~rc0.1-1/mypy/server/astmerge.py
--- 1.15.0-5/mypy/server/astmerge.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/server/astmerge.py	2025-05-27 17:21:15.000000000 +0000
@@ -51,6 +51,7 @@ from typing import TypeVar, cast
 
 from mypy.nodes import (
     MDEF,
+    SYMBOL_NODE_EXPRESSION_TYPES,
     AssertTypeExpr,
     AssignmentStmt,
     Block,
@@ -301,7 +302,7 @@ class NodeReplaceVisitor(TraverserVisito
 
     def visit_call_expr(self, node: CallExpr) -> None:
         super().visit_call_expr(node)
-        if isinstance(node.analyzed, SymbolNode):
+        if isinstance(node.analyzed, SYMBOL_NODE_EXPRESSION_TYPES):
             node.analyzed = self.fixup(node.analyzed)
 
     def visit_newtype_expr(self, node: NewTypeExpr) -> None:
@@ -330,6 +331,7 @@ class NodeReplaceVisitor(TraverserVisito
     def visit_var(self, node: Var) -> None:
         node.info = self.fixup(node.info)
         self.fixup_type(node.type)
+        self.fixup_type(node.setter_type)
         super().visit_var(node)
 
     def visit_type_alias(self, node: TypeAlias) -> None:
diff -pruN 1.15.0-5/mypy/server/deps.py 1.16~rc0.1-1/mypy/server/deps.py
--- 1.15.0-5/mypy/server/deps.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/server/deps.py	2025-05-27 17:21:15.000000000 +0000
@@ -87,6 +87,7 @@ from mypy.nodes import (
     GDEF,
     LDEF,
     MDEF,
+    SYMBOL_FUNCBASE_TYPES,
     AssertTypeExpr,
     AssignmentStmt,
     AwaitExpr,
@@ -501,7 +502,7 @@ class DependencyVisitor(TraverserVisitor
                 if isinstance(rvalue.callee.node, TypeInfo):
                     # use actual __init__ as a dependency source
                     init = rvalue.callee.node.get("__init__")
-                    if init and isinstance(init.node, FuncBase):
+                    if init and isinstance(init.node, SYMBOL_FUNCBASE_TYPES):
                         fname = init.node.fullname
                 else:
                     fname = rvalue.callee.fullname
diff -pruN 1.15.0-5/mypy/server/mergecheck.py 1.16~rc0.1-1/mypy/server/mergecheck.py
--- 1.15.0-5/mypy/server/mergecheck.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/server/mergecheck.py	2025-05-27 17:21:15.000000000 +0000
@@ -26,10 +26,11 @@ def check_consistency(o: object) -> None
             continue
 
         fn = sym.fullname
-        # Skip None names, since they are ambiguous.
+        # Skip None and empty names, since they are ambiguous.
         # TODO: Everything should have a proper full name?
-        if fn is None:
+        if not fn:
             continue
+
         # Skip stuff that should be expected to have duplicate names
         if isinstance(sym, (Var, Decorator)):
             continue
@@ -37,7 +38,7 @@ def check_consistency(o: object) -> None
             continue
 
         if fn not in m:
-            m[sym.fullname] = sym
+            m[fn] = sym
             continue
 
         # We have trouble and need to decide what to do about it.
diff -pruN 1.15.0-5/mypy/solve.py 1.16~rc0.1-1/mypy/solve.py
--- 1.15.0-5/mypy/solve.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/solve.py	2025-05-27 17:21:15.000000000 +0000
@@ -350,7 +350,7 @@ def choose_free(
 
     # For convenience with current type application machinery, we use a stable
     # choice that prefers the original type variables (not polymorphic ones) in SCC.
-    best = sorted(scc, key=lambda x: (x.id not in original_vars, x.id.raw_id))[0]
+    best = min(scc, key=lambda x: (x.id not in original_vars, x.id.raw_id))
     if isinstance(best, TypeVarType):
         return best.copy_modified(values=values, upper_bound=common_upper_bound)
     if is_trivial_bound(common_upper_bound_p, allow_tuple=True):
diff -pruN 1.15.0-5/mypy/stubdoc.py 1.16~rc0.1-1/mypy/stubdoc.py
--- 1.15.0-5/mypy/stubdoc.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/stubdoc.py	2025-05-27 17:21:15.000000000 +0000
@@ -21,7 +21,7 @@ import mypy.util
 Sig: _TypeAlias = tuple[str, str]
 
 
-_TYPE_RE: Final = re.compile(r"^[a-zA-Z_][\w\[\], .\"\']*(\.[a-zA-Z_][\w\[\], ]*)*$")
+_TYPE_RE: Final = re.compile(r"^[a-zA-Z_][\w\[\], .\"\'|]*(\.[a-zA-Z_][\w\[\], ]*)*$")
 _ARG_NAME_RE: Final = re.compile(r"\**[A-Za-z_][A-Za-z0-9_]*$")
 
 
@@ -175,6 +175,8 @@ class DocStringParser:
         self.ret_type = "Any"
         self.found = False
         self.args: list[ArgSig] = []
+        self.pos_only: int | None = None
+        self.keyword_only: int | None = None
         # Valid signatures found so far.
         self.signatures: list[FunctionSig] = []
 
@@ -252,15 +254,34 @@ class DocStringParser:
                 self.arg_type = self.accumulator
                 self.state.pop()
             elif self.state[-1] == STATE_ARGUMENT_LIST:
-                self.arg_name = self.accumulator
-                if not (
-                    token.string == ")" and self.accumulator.strip() == ""
-                ) and not _ARG_NAME_RE.match(self.arg_name):
-                    # Invalid argument name.
-                    self.reset()
-                    return
+                if self.accumulator == "*":
+                    if self.keyword_only is not None:
+                        # Error condition: cannot have * twice
+                        self.reset()
+                        return
+                    self.keyword_only = len(self.args)
+                    self.accumulator = ""
+                else:
+                    if self.accumulator.startswith("*"):
+                        self.keyword_only = len(self.args) + 1
+                    self.arg_name = self.accumulator
+                    if not (
+                        token.string == ")" and self.accumulator.strip() == ""
+                    ) and not _ARG_NAME_RE.match(self.arg_name):
+                        # Invalid argument name.
+                        self.reset()
+                        return
 
             if token.string == ")":
+                if (
+                    self.state[-1] == STATE_ARGUMENT_LIST
+                    and self.keyword_only is not None
+                    and self.keyword_only == len(self.args)
+                    and not self.arg_name
+                ):
+                    # Error condition: * must be followed by arguments
+                    self.reset()
+                    return
                 self.state.pop()
 
             # arg_name is empty when there are no args. e.g. func()
@@ -280,6 +301,22 @@ class DocStringParser:
             self.arg_type = None
             self.arg_default = None
             self.accumulator = ""
+        elif (
+            token.type == tokenize.OP
+            and token.string == "/"
+            and self.state[-1] == STATE_ARGUMENT_LIST
+        ):
+            if token.string == "/":
+                if self.pos_only is not None or self.keyword_only is not None or not self.args:
+                    # Error cases:
+                    # - / shows up more than once
+                    # - / shows up after *
+                    # - / shows up before any arguments
+                    self.reset()
+                    return
+                self.pos_only = len(self.args)
+                self.state.append(STATE_ARGUMENT_TYPE)
+                self.accumulator = ""
 
         elif token.type == tokenize.OP and token.string == "->" and self.state[-1] == STATE_INIT:
             self.accumulator = ""
diff -pruN 1.15.0-5/mypy/stubgen.py 1.16~rc0.1-1/mypy/stubgen.py
--- 1.15.0-5/mypy/stubgen.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/stubgen.py	2025-05-27 17:21:15.000000000 +0000
@@ -145,6 +145,7 @@ from mypy.types import (
     DATACLASS_TRANSFORM_NAMES,
     OVERLOAD_NAMES,
     TPDICT_NAMES,
+    TYPE_VAR_LIKE_NAMES,
     TYPED_NAMEDTUPLE_NAMES,
     AnyType,
     CallableType,
@@ -755,6 +756,9 @@ class ASTStubGenerator(BaseStubGenerator
             elif fullname in DATACLASS_TRANSFORM_NAMES:
                 p = AliasPrinter(self)
                 self._decorators.append(f"@{decorator.accept(p)}")
+            elif isinstance(decorator, (NameExpr, MemberExpr)):
+                p = AliasPrinter(self)
+                self._decorators.append(f"@{decorator.accept(p)}")
 
     def get_fullname(self, expr: Expression) -> str:
         """Return the expression's full name."""
@@ -916,13 +920,20 @@ class ASTStubGenerator(BaseStubGenerator
                     continue
             if (
                 isinstance(lvalue, NameExpr)
-                and not self.is_private_name(lvalue.name)
-                # it is never an alias with explicit annotation
-                and not o.unanalyzed_type
                 and self.is_alias_expression(o.rvalue)
+                and not self.is_private_name(lvalue.name)
             ):
-                self.process_typealias(lvalue, o.rvalue)
-                continue
+                is_explicit_type_alias = (
+                    o.unanalyzed_type and getattr(o.type, "name", None) == "TypeAlias"
+                )
+                if is_explicit_type_alias:
+                    self.process_typealias(lvalue, o.rvalue, is_explicit_type_alias=True)
+                    continue
+
+                if not o.unanalyzed_type:
+                    self.process_typealias(lvalue, o.rvalue)
+                    continue
+
             if isinstance(lvalue, (TupleExpr, ListExpr)):
                 items = lvalue.items
                 if isinstance(o.unanalyzed_type, TupleType):  # type: ignore[misc]
@@ -1087,14 +1098,7 @@ class ASTStubGenerator(BaseStubGenerator
         or module alias.
         """
         # Assignment of TypeVar(...)  and other typevar-likes are passed through
-        if isinstance(expr, CallExpr) and self.get_fullname(expr.callee) in (
-            "typing.TypeVar",
-            "typing_extensions.TypeVar",
-            "typing.ParamSpec",
-            "typing_extensions.ParamSpec",
-            "typing.TypeVarTuple",
-            "typing_extensions.TypeVarTuple",
-        ):
+        if isinstance(expr, CallExpr) and self.get_fullname(expr.callee) in TYPE_VAR_LIKE_NAMES:
             return True
         elif isinstance(expr, EllipsisExpr):
             return not top_level
@@ -1142,9 +1146,15 @@ class ASTStubGenerator(BaseStubGenerator
         else:
             return False
 
-    def process_typealias(self, lvalue: NameExpr, rvalue: Expression) -> None:
+    def process_typealias(
+        self, lvalue: NameExpr, rvalue: Expression, is_explicit_type_alias: bool = False
+    ) -> None:
         p = AliasPrinter(self)
-        self.add(f"{self._indent}{lvalue.name} = {rvalue.accept(p)}\n")
+        if is_explicit_type_alias:
+            self.import_tracker.require_name("TypeAlias")
+            self.add(f"{self._indent}{lvalue.name}: TypeAlias = {rvalue.accept(p)}\n")
+        else:
+            self.add(f"{self._indent}{lvalue.name} = {rvalue.accept(p)}\n")
         self.record_name(lvalue.name)
         self._vars[-1].append(lvalue.name)
 
@@ -1507,9 +1517,7 @@ def is_blacklisted_path(path: str) -> bo
 
 
 def normalize_path_separators(path: str) -> str:
-    if sys.platform == "win32":
-        return path.replace("\\", "/")
-    return path
+    return path.replace("\\", "/") if sys.platform == "win32" else path
 
 
 def collect_build_targets(
@@ -1843,6 +1851,8 @@ def parse_options(args: list[str]) -> Op
     parser = argparse.ArgumentParser(
         prog="stubgen", usage=HEADER, description=DESCRIPTION, fromfile_prefix_chars="@"
     )
+    if sys.version_info >= (3, 14):
+        parser.color = True  # Set as init arg in 3.14
 
     parser.add_argument(
         "--ignore-errors",
diff -pruN 1.15.0-5/mypy/stubgenc.py 1.16~rc0.1-1/mypy/stubgenc.py
--- 1.15.0-5/mypy/stubgenc.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/stubgenc.py	2025-05-27 17:21:15.000000000 +0000
@@ -6,6 +6,7 @@ The public interface is via the mypy.stu
 
 from __future__ import annotations
 
+import enum
 import glob
 import importlib
 import inspect
@@ -211,6 +212,9 @@ class CFunctionStub:
         pass
 
 
+_Missing = enum.Enum("_Missing", "VALUE")
+
+
 class InspectionStubGenerator(BaseStubGenerator):
     """Stub generator that does not parse code.
 
@@ -310,12 +314,12 @@ class InspectionStubGenerator(BaseStubGe
 
         # Add the arguments to the signature
         def add_args(
-            args: list[str], get_default_value: Callable[[int, str], object | None]
+            args: list[str], get_default_value: Callable[[int, str], object | _Missing]
         ) -> None:
             for i, arg in enumerate(args):
                 # Check if the argument has a default value
                 default_value = get_default_value(i, arg)
-                if default_value is not None:
+                if default_value is not _Missing.VALUE:
                     if arg in annotations:
                         argtype = annotations[arg]
                     else:
@@ -330,26 +334,26 @@ class InspectionStubGenerator(BaseStubGe
                 else:
                     arglist.append(ArgSig(arg, get_annotation(arg), default=False))
 
-        def get_pos_default(i: int, _arg: str) -> Any | None:
+        def get_pos_default(i: int, _arg: str) -> Any | _Missing:
             if defaults and i >= len(args) - len(defaults):
                 return defaults[i - (len(args) - len(defaults))]
             else:
-                return None
+                return _Missing.VALUE
 
         add_args(args, get_pos_default)
 
         # Add *args if present
         if varargs:
             arglist.append(ArgSig(f"*{varargs}", get_annotation(varargs)))
-        # if we have keyword only args, then wee need to add "*"
+        # if we have keyword only args, then we need to add "*"
         elif kwonlyargs:
             arglist.append(ArgSig("*"))
 
-        def get_kw_default(_i: int, arg: str) -> Any | None:
-            if kwonlydefaults:
-                return kwonlydefaults.get(arg)
+        def get_kw_default(_i: int, arg: str) -> Any | _Missing:
+            if kwonlydefaults and arg in kwonlydefaults:
+                return kwonlydefaults[arg]
             else:
-                return None
+                return _Missing.VALUE
 
         add_args(kwonlyargs, get_kw_default)
 
@@ -761,11 +765,15 @@ class InspectionStubGenerator(BaseStubGe
 
     def get_type_fullname(self, typ: type) -> str:
         """Given a type, return a string representation"""
-        if typ is Any:  # type: ignore[comparison-overlap]
+        if typ is Any:
             return "Any"
         typename = getattr(typ, "__qualname__", typ.__name__)
         module_name = self.get_obj_module(typ)
-        assert module_name is not None, typ
+        if module_name is None:
+            # This should not normally happen, but some types may resist our
+            # introspection attempts too hard. See
+            # https://github.com/python/mypy/issues/19031
+            return "_typeshed.Incomplete"
         if module_name != "builtins":
             typename = f"{module_name}.{typename}"
         return typename
diff -pruN 1.15.0-5/mypy/stubinfo.py 1.16~rc0.1-1/mypy/stubinfo.py
--- 1.15.0-5/mypy/stubinfo.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/stubinfo.py	2025-05-27 17:21:15.000000000 +0000
@@ -47,7 +47,6 @@ legacy_bundled_packages: dict[str, str]
     "mock": "types-mock",
     "OpenSSL": "types-pyOpenSSL",
     "paramiko": "types-paramiko",
-    "pkg_resources": "types-setuptools",
     "polib": "types-polib",
     "pycurl": "types-pycurl",
     "pymysql": "types-PyMySQL",
@@ -97,7 +96,7 @@ non_bundled_packages_flat: dict[str, str
     "commctrl": "types-pywin32",
     "commonmark": "types-commonmark",
     "consolemenu": "types-console-menu",
-    "corus": "types-corus",
+    "corus": "types-corus",  # codespell:ignore corus
     "cronlog": "types-python-crontab",
     "crontab": "types-python-crontab",
     "crontabs": "types-python-crontab",
@@ -291,6 +290,7 @@ non_bundled_packages_flat: dict[str, str
     # for additions here
     "pandas": "pandas-stubs",  # https://github.com/pandas-dev/pandas-stubs
     "lxml": "lxml-stubs",  # https://github.com/lxml/lxml-stubs
+    "scipy": "scipy-stubs",  # https://github.com/scipy/scipy-stubs
 }
 
 
diff -pruN 1.15.0-5/mypy/stubtest.py 1.16~rc0.1-1/mypy/stubtest.py
--- 1.15.0-5/mypy/stubtest.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/stubtest.py	2025-05-27 17:21:15.000000000 +0000
@@ -338,7 +338,8 @@ def verify_mypyfile(
         yield Error(object_path, "is not present at runtime", stub, runtime)
         return
     if not isinstance(runtime, types.ModuleType):
-        yield Error(object_path, "is not a module", stub, runtime)
+        # Can possibly happen:
+        yield Error(object_path, "is not a module", stub, runtime)  # type: ignore[unreachable]
         return
 
     runtime_all_as_set: set[str] | None
@@ -524,7 +525,8 @@ def verify_typeinfo(
         yield Error(object_path, "is not present at runtime", stub, runtime, stub_desc=repr(stub))
         return
     if not isinstance(runtime, type):
-        yield Error(object_path, "is not a type", stub, runtime, stub_desc=repr(stub))
+        # Yes, some runtime objects can be not types, no way to tell mypy about that.
+        yield Error(object_path, "is not a type", stub, runtime, stub_desc=repr(stub))  # type: ignore[unreachable]
         return
 
     yield from _verify_final(stub, runtime, object_path)
@@ -572,9 +574,23 @@ def verify_typeinfo(
 
         # If it came from the metaclass, consider the runtime_attr to be MISSING
         # for a more accurate message
-        if runtime_attr is not MISSING and type(runtime) is not runtime:
-            if getattr(runtime_attr, "__objclass__", None) is type(runtime):
-                runtime_attr = MISSING
+        if (
+            runtime_attr is not MISSING
+            and type(runtime) is not runtime
+            and getattr(runtime_attr, "__objclass__", None) is type(runtime)
+        ):
+            runtime_attr = MISSING
+
+        # __setattr__ and __delattr__ on object are a special case,
+        # so if we only have these methods inherited from there, pretend that
+        # we don't have them. See python/typeshed#7385.
+        if (
+            entry in ("__setattr__", "__delattr__")
+            and runtime_attr is not MISSING
+            and runtime is not object
+            and getattr(runtime_attr, "__objclass__", None) is object
+        ):
+            runtime_attr = MISSING
 
         # Do not error for an object missing from the stub
         # If the runtime object is a types.WrapperDescriptorType object
@@ -638,10 +654,10 @@ def _verify_arg_name(
     if is_dunder(function_name, exclude_special=True):
         return
 
-    def strip_prefix(s: str, prefix: str) -> str:
-        return s[len(prefix) :] if s.startswith(prefix) else s
-
-    if strip_prefix(stub_arg.variable.name, "__") == runtime_arg.name:
+    if (
+        stub_arg.variable.name == runtime_arg.name
+        or stub_arg.variable.name.removeprefix("__") == runtime_arg.name
+    ):
         return
 
     nonspecific_names = {"object", "args"}
@@ -842,7 +858,7 @@ class Signature(Generic[T]):
 
         all_args: dict[str, list[tuple[nodes.Argument, int]]] = {}
         for func in map(_resolve_funcitem_from_decorator, stub.items):
-            assert func is not None
+            assert func is not None, "Failed to resolve decorated overload"
             args = maybe_strip_cls(stub.name, func.arguments)
             for index, arg in enumerate(args):
                 # For positional-only args, we allow overloads to have different names for the same
@@ -932,6 +948,7 @@ def _verify_signature(
         if (
             runtime_arg.kind != inspect.Parameter.POSITIONAL_ONLY
             and (stub_arg.pos_only or stub_arg.variable.name.startswith("__"))
+            and not runtime_arg.name.startswith("__")
             and stub_arg.variable.name.strip("_") != "self"
             and not is_dunder(function_name, exclude_special=True)  # noisy for dunder methods
         ):
@@ -1090,9 +1107,11 @@ def verify_funcitem(
 
 
 @verify.register(Missing)
-def verify_none(
+def verify_missing(
     stub: Missing, runtime: MaybeMissing[Any], object_path: list[str]
 ) -> Iterator[Error]:
+    if runtime is MISSING:
+        return
     yield Error(object_path, "is not present in stub", stub, runtime)
 
 
@@ -1237,6 +1256,19 @@ def verify_paramspecexpr(
         return
 
 
+def _is_django_cached_property(runtime: Any) -> bool:  # pragma: no cover
+    # This is a special case for
+    # https://docs.djangoproject.com/en/5.2/ref/utils/#django.utils.functional.cached_property
+    # This is needed in `django-stubs` project:
+    # https://github.com/typeddjango/django-stubs
+    if type(runtime).__name__ != "cached_property":
+        return False
+    try:
+        return bool(runtime.func)
+    except Exception:
+        return False
+
+
 def _verify_readonly_property(stub: nodes.Decorator, runtime: Any) -> Iterator[str]:
     assert stub.func.is_property
     if isinstance(runtime, property):
@@ -1245,6 +1277,9 @@ def _verify_readonly_property(stub: node
     if isinstance(runtime, functools.cached_property):
         yield from _verify_final_method(stub.func, runtime.func, MISSING)
         return
+    if _is_django_cached_property(runtime):
+        yield from _verify_final_method(stub.func, runtime.func, MISSING)
+        return
     if inspect.isdatadescriptor(runtime):
         # It's enough like a property...
         return
@@ -1311,6 +1346,7 @@ def _resolve_funcitem_from_decorator(dec
         if (
             decorator.fullname in ("builtins.staticmethod", "abc.abstractmethod")
             or decorator.fullname in mypy.types.OVERLOAD_NAMES
+            or decorator.fullname in mypy.types.OVERRIDE_DECORATOR_NAMES
             or decorator.fullname in mypy.types.FINAL_DECORATOR_NAMES
         ):
             return func
@@ -1458,6 +1494,7 @@ IGNORED_MODULE_DUNDERS: Final = frozense
         "__loader__",
         "__spec__",
         "__annotations__",
+        "__annotate__",
         "__path__",  # mypy adds __path__ to packages, but C packages don't have it
         "__getattr__",  # resulting behaviour might be typed explicitly
         # Created by `warnings.warn`, does not make much sense to have in stubs:
@@ -1474,6 +1511,9 @@ IGNORABLE_CLASS_DUNDERS: Final = frozens
         # Special attributes
         "__dict__",
         "__annotations__",
+        "__annotate__",
+        "__annotations_cache__",
+        "__annotate_func__",
         "__text_signature__",
         "__weakref__",
         "__hash__",
@@ -1482,6 +1522,7 @@ IGNORABLE_CLASS_DUNDERS: Final = frozens
         "__vectorcalloffset__",  # undocumented implementation detail of the vectorcall protocol
         "__firstlineno__",
         "__static_attributes__",
+        "__classdictcell__",
         # isinstance/issubclass hooks that type-checkers don't usually care about
         "__instancecheck__",
         "__subclasshook__",
@@ -1500,6 +1541,7 @@ IGNORABLE_CLASS_DUNDERS: Final = frozens
         "__getinitargs__",
         "__reduce_ex__",
         "__reduce__",
+        "__slotnames__",  # Cached names of slots added by `copyreg` module.
         # ctypes weirdness
         "__ctype_be__",
         "__ctype_le__",
@@ -1532,8 +1574,15 @@ def is_probably_private(name: str) -> bo
 
 def is_probably_a_function(runtime: Any) -> bool:
     return (
-        isinstance(runtime, (types.FunctionType, types.BuiltinFunctionType))
-        or isinstance(runtime, (types.MethodType, types.BuiltinMethodType))
+        isinstance(
+            runtime,
+            (
+                types.FunctionType,
+                types.BuiltinFunctionType,
+                types.MethodType,
+                types.BuiltinMethodType,
+            ),
+        )
         or (inspect.ismethoddescriptor(runtime) and callable(runtime))
         or (isinstance(runtime, types.MethodWrapperType) and callable(runtime))
     )
@@ -1976,6 +2025,7 @@ def test_stubs(args: _Arguments, use_bui
     options.process_incomplete_features(
         error_callback=error_callback, warning_callback=warning_callback
     )
+    options.process_strict_bytes()
 
     try:
         modules = build_stubs(modules, options, find_submodules=not args.check_typeshed)
@@ -2056,6 +2106,8 @@ def parse_options(args: list[str]) -> _A
     parser = argparse.ArgumentParser(
         description="Compares stubs to objects introspected from the runtime."
     )
+    if sys.version_info >= (3, 14):
+        parser.color = True  # Set as init arg in 3.14
     parser.add_argument("modules", nargs="*", help="Modules to test")
     parser.add_argument(
         "--concise",
diff -pruN 1.15.0-5/mypy/subtypes.py 1.16~rc0.1-1/mypy/subtypes.py
--- 1.15.0-5/mypy/subtypes.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/subtypes.py	2025-05-27 17:21:15.000000000 +0000
@@ -1,6 +1,6 @@
 from __future__ import annotations
 
-from collections.abc import Iterator
+from collections.abc import Iterable, Iterator
 from contextlib import contextmanager
 from typing import Any, Callable, Final, TypeVar, cast
 from typing_extensions import TypeAlias as _TypeAlias
@@ -67,6 +67,7 @@ from mypy.types import (
     UnionType,
     UnpackType,
     find_unpack_in_list,
+    flatten_nested_unions,
     get_proper_type,
     is_named_instance,
     split_with_prefix_and_suffix,
@@ -80,6 +81,7 @@ IS_SETTABLE: Final = 1
 IS_CLASSVAR: Final = 2
 IS_CLASS_OR_STATIC: Final = 3
 IS_VAR: Final = 4
+IS_EXPLICIT_SETTER: Final = 5
 
 TypeParameterChecker: _TypeAlias = Callable[[Type, Type, int, bool, "SubtypeContext"], bool]
 
@@ -326,7 +328,9 @@ def _is_subtype(
             and isinstance(left, Instance)
             and (left.type.is_enum or left.type.fullname == "builtins.bool")
         ):
-            right = UnionType(mypy.typeops.try_contracting_literals_in_union(right.items))
+            right = UnionType(
+                mypy.typeops.try_contracting_literals_in_union(flatten_nested_unions(right.items))
+            )
             if proper_subtype:
                 is_subtype_of_item = any(
                     is_proper_subtype(orig_left, item, subtype_context=subtype_context)
@@ -413,6 +417,9 @@ class SubtypeVisitor(TypeVisitor[bool]):
             return is_proper_subtype(left, right, subtype_context=self.subtype_context)
         return is_subtype(left, right, subtype_context=self.subtype_context)
 
+    def _all_subtypes(self, lefts: Iterable[Type], rights: Iterable[Type]) -> bool:
+        return all(self._is_subtype(li, ri) for (li, ri) in zip(lefts, rights))
+
     # visit_x(left) means: is left (which is an instance of X) a subtype of right?
 
     def visit_unbound_type(self, left: UnboundType) -> bool:
@@ -473,21 +480,17 @@ class SubtypeVisitor(TypeVisitor[bool]):
                         return self._is_subtype(left, unpacked)
             if left.type.has_base(right.partial_fallback.type.fullname):
                 if not self.proper_subtype:
-                    # Special case to consider Foo[*tuple[Any, ...]] (i.e. bare Foo) a
-                    # subtype of Foo[<whatever>], when Foo is user defined variadic tuple type.
+                    # Special cases to consider:
+                    #   * Plain tuple[Any, ...] instance is a subtype of all tuple types.
+                    #   * Foo[*tuple[Any, ...]] (normalized) instance is a subtype of all
+                    #     tuples with fallback to Foo (e.g. for variadic NamedTuples).
                     mapped = map_instance_to_supertype(left, right.partial_fallback.type)
-                    for arg in map(get_proper_type, mapped.args):
-                        if isinstance(arg, UnpackType):
-                            unpacked = get_proper_type(arg.type)
-                            if not isinstance(unpacked, Instance):
-                                break
-                            assert unpacked.type.fullname == "builtins.tuple"
-                            if not isinstance(get_proper_type(unpacked.args[0]), AnyType):
-                                break
-                        elif not isinstance(arg, AnyType):
-                            break
-                    else:
-                        return True
+                    if is_erased_instance(mapped):
+                        if (
+                            mapped.type.fullname == "builtins.tuple"
+                            or mapped.type.has_type_var_tuple_type
+                        ):
+                            return True
             return False
         if isinstance(right, TypeVarTupleType):
             # tuple[Any, ...] is like Any in the world of tuples (see special case above).
@@ -555,19 +558,8 @@ class SubtypeVisitor(TypeVisitor[bool]):
                     right_args = (
                         right_prefix + (TupleType(list(right_middle), fallback),) + right_suffix
                     )
-                    if not self.proper_subtype and t.args:
-                        for arg in map(get_proper_type, t.args):
-                            if isinstance(arg, UnpackType):
-                                unpacked = get_proper_type(arg.type)
-                                if not isinstance(unpacked, Instance):
-                                    break
-                                assert unpacked.type.fullname == "builtins.tuple"
-                                if not isinstance(get_proper_type(unpacked.args[0]), AnyType):
-                                    break
-                            elif not isinstance(arg, AnyType):
-                                break
-                        else:
-                            return True
+                    if not self.proper_subtype and is_erased_instance(t):
+                        return True
                     if len(left_args) != len(right_args):
                         return False
                     type_params = zip(left_args, right_args, right.type.defn.type_vars)
@@ -855,11 +847,25 @@ class SubtypeVisitor(TypeVisitor[bool]):
                 # There are some items on the left that will never have a matching length
                 # on the right.
                 return False
+            left_prefix = left_unpack_index
+            left_suffix = len(left.items) - left_prefix - 1
             left_unpack = left.items[left_unpack_index]
             assert isinstance(left_unpack, UnpackType)
             left_unpacked = get_proper_type(left_unpack.type)
             if not isinstance(left_unpacked, Instance):
-                # *Ts unpacks can't be split.
+                # *Ts unpack can't be split, except if it is all mapped to Anys or objects.
+                if self.is_top_type(right_item):
+                    right_prefix_types, middle, right_suffix_types = split_with_prefix_and_suffix(
+                        tuple(right.items), left_prefix, left_suffix
+                    )
+                    if not all(
+                        self.is_top_type(ri) or isinstance(ri, UnpackType) for ri in middle
+                    ):
+                        return False
+                    # Also check the tails match as well.
+                    return self._all_subtypes(
+                        left.items[:left_prefix], right_prefix_types
+                    ) and self._all_subtypes(left.items[-left_suffix:], right_suffix_types)
                 return False
             assert left_unpacked.type.fullname == "builtins.tuple"
             left_item = left_unpacked.args[0]
@@ -870,8 +876,6 @@ class SubtypeVisitor(TypeVisitor[bool]):
             # and then check subtyping for all finite overlaps.
             if not self._is_subtype(left_item, right_item):
                 return False
-            left_prefix = left_unpack_index
-            left_suffix = len(left.items) - left_prefix - 1
             max_overlap = max(0, right_prefix - left_prefix, right_suffix - left_suffix)
             for overlap in range(max_overlap + 1):
                 repr_items = left.items[:left_prefix] + [left_item] * overlap
@@ -882,6 +886,11 @@ class SubtypeVisitor(TypeVisitor[bool]):
                     return False
             return True
 
+    def is_top_type(self, typ: Type) -> bool:
+        if not self.proper_subtype and isinstance(get_proper_type(typ), AnyType):
+            return True
+        return is_named_instance(typ, "builtins.object")
+
     def visit_typeddict_type(self, left: TypedDictType) -> bool:
         right = self.right
         if isinstance(right, Instance):
@@ -1082,6 +1091,11 @@ class SubtypeVisitor(TypeVisitor[bool]):
         right = self.right
         if isinstance(right, TypeType):
             return self._is_subtype(left.item, right.item)
+        if isinstance(right, Overloaded) and right.is_type_obj():
+            # Same as in other direction: if it's a constructor callable, all
+            # items should belong to the same class' constructor, so it's enough
+            # to check one of them.
+            return self._is_subtype(left, right.items[0])
         if isinstance(right, CallableType):
             if self.proper_subtype and not right.is_type_obj():
                 # We can't accept `Type[X]` as a *proper* subtype of Callable[P, X]
@@ -1172,7 +1186,7 @@ def is_protocol_implementation(
             ignore_names = member != "__call__"  # __call__ can be passed kwargs
             # The third argument below indicates to what self type is bound.
             # We always bind self to the subtype. (Similarly to nominal types).
-            supertype = get_proper_type(find_member(member, right, left))
+            supertype = find_member(member, right, left)
             assert supertype is not None
 
             subtype = mypy.typeops.get_protocol_member(left, member, class_obj)
@@ -1181,15 +1195,6 @@ def is_protocol_implementation(
             # print(member, 'of', right, 'has type', supertype)
             if not subtype:
                 return False
-            if isinstance(subtype, PartialType):
-                subtype = (
-                    NoneType()
-                    if subtype.type is None
-                    else Instance(
-                        subtype.type,
-                        [AnyType(TypeOfAny.unannotated)] * len(subtype.type.type_vars),
-                    )
-                )
             if not proper_subtype:
                 # Nominal check currently ignores arg names
                 # NOTE: If we ever change this, be sure to also change the call to
@@ -1201,15 +1206,28 @@ def is_protocol_implementation(
                 is_compat = is_proper_subtype(subtype, supertype)
             if not is_compat:
                 return False
-            if isinstance(subtype, NoneType) and isinstance(supertype, CallableType):
+            if isinstance(get_proper_type(subtype), NoneType) and isinstance(
+                get_proper_type(supertype), CallableType
+            ):
                 # We want __hash__ = None idiom to work even without --strict-optional
                 return False
             subflags = get_member_flags(member, left, class_obj=class_obj)
             superflags = get_member_flags(member, right)
             if IS_SETTABLE in superflags:
                 # Check opposite direction for settable attributes.
+                if IS_EXPLICIT_SETTER in superflags:
+                    supertype = find_member(member, right, left, is_lvalue=True)
+                if IS_EXPLICIT_SETTER in subflags:
+                    subtype = mypy.typeops.get_protocol_member(
+                        left, member, class_obj, is_lvalue=True
+                    )
+                # At this point we know attribute is present on subtype, otherwise we
+                # would return False above.
+                assert supertype is not None and subtype is not None
                 if not is_subtype(supertype, subtype, options=options):
                     return False
+            if IS_SETTABLE in superflags and IS_SETTABLE not in subflags:
+                return False
             if not class_obj:
                 if IS_SETTABLE not in superflags:
                     if IS_CLASSVAR in superflags and IS_CLASSVAR not in subflags:
@@ -1223,8 +1241,6 @@ def is_protocol_implementation(
                 if IS_CLASSVAR in superflags:
                     # This can be never matched by a class object.
                     return False
-            if IS_SETTABLE in superflags and IS_SETTABLE not in subflags:
-                return False
             # This rule is copied from nominal check in checker.py
             if IS_CLASS_OR_STATIC in superflags and IS_CLASS_OR_STATIC not in subflags:
                 return False
@@ -1243,7 +1259,13 @@ def is_protocol_implementation(
 
 
 def find_member(
-    name: str, itype: Instance, subtype: Type, is_operator: bool = False, class_obj: bool = False
+    name: str,
+    itype: Instance,
+    subtype: Type,
+    *,
+    is_operator: bool = False,
+    class_obj: bool = False,
+    is_lvalue: bool = False,
 ) -> Type | None:
     """Find the type of member by 'name' in 'itype's TypeInfo.
 
@@ -1261,7 +1283,10 @@ def find_member(
             assert isinstance(method, OverloadedFuncDef)
             dec = method.items[0]
             assert isinstance(dec, Decorator)
-            return find_node_type(dec.var, itype, subtype, class_obj=class_obj)
+            # Pass on is_lvalue flag as this may be a property with different setter type.
+            return find_node_type(
+                dec.var, itype, subtype, class_obj=class_obj, is_lvalue=is_lvalue
+            )
         return find_node_type(method, itype, subtype, class_obj=class_obj)
     else:
         # don't have such method, maybe variable or decorator?
@@ -1326,7 +1351,10 @@ def get_member_flags(name: str, itype: I
             dec = method.items[0]
             assert isinstance(dec, Decorator)
             if dec.var.is_settable_property or setattr_meth:
-                return {IS_VAR, IS_SETTABLE}
+                flags = {IS_VAR, IS_SETTABLE}
+                if dec.var.setter_type is not None:
+                    flags.add(IS_EXPLICIT_SETTER)
+                return flags
             else:
                 return {IS_VAR}
         return set()  # Just a regular method
@@ -1357,7 +1385,11 @@ def get_member_flags(name: str, itype: I
 
 
 def find_node_type(
-    node: Var | FuncBase, itype: Instance, subtype: Type, class_obj: bool = False
+    node: Var | FuncBase,
+    itype: Instance,
+    subtype: Type,
+    class_obj: bool = False,
+    is_lvalue: bool = False,
 ) -> Type:
     """Find type of a variable or method 'node' (maybe also a decorated method).
     Apply type arguments from 'itype', and bind 'self' to 'subtype'.
@@ -1369,7 +1401,13 @@ def find_node_type(
             node, fallback=Instance(itype.type.mro[-1], [])
         )
     else:
-        typ = node.type
+        # This part and the one below are simply copies of the logic from checkmember.py.
+        if node.is_settable_property and is_lvalue:
+            typ = node.setter_type
+            if typ is None and node.is_ready:
+                typ = node.type
+        else:
+            typ = node.type
         if typ is not None:
             typ = expand_self_type(node, typ, subtype)
     p_typ = get_proper_type(typ)
@@ -1393,7 +1431,15 @@ def find_node_type(
             )
         if node.is_property and not class_obj:
             assert isinstance(signature, CallableType)
-            typ = signature.ret_type
+            if (
+                isinstance(node, Var)
+                and node.is_settable_property
+                and is_lvalue
+                and node.setter_type is not None
+            ):
+                typ = signature.arg_types[0]
+            else:
+                typ = signature.ret_type
         else:
             typ = signature
     itype = map_instance_to_supertype(itype, node.info)
@@ -1620,17 +1666,18 @@ def are_parameters_compatible(
         return True
     trivial_suffix = is_trivial_suffix(right) and not is_proper_subtype
 
+    trivial_vararg_suffix = False
     if (
-        right.arg_kinds == [ARG_STAR]
-        and isinstance(get_proper_type(right.arg_types[0]), AnyType)
+        right.arg_kinds[-1:] == [ARG_STAR]
+        and isinstance(get_proper_type(right.arg_types[-1]), AnyType)
         and not is_proper_subtype
+        and all(k.is_positional(star=True) for k in left.arg_kinds)
     ):
         # Similar to how (*Any, **Any) is considered a supertype of all callables, we consider
         # (*Any) a supertype of all callables with positional arguments. This is needed in
         # particular because we often refuse to try type inference if actual type is not
         # a subtype of erased template type.
-        if all(k.is_positional() for k in left.arg_kinds) and ignore_pos_arg_names:
-            return True
+        trivial_vararg_suffix = True
 
     # Match up corresponding arguments and check them for compatibility. In
     # every pair (argL, argR) of corresponding arguments from L and R, argL must
@@ -1664,7 +1711,11 @@ def are_parameters_compatible(
             return not allow_partial_overlap and not trivial_suffix
         return not is_compat(right_arg.typ, left_arg.typ)
 
-    if _incompatible(left_star, right_star) or _incompatible(left_star2, right_star2):
+    if (
+        _incompatible(left_star, right_star)
+        and not trivial_vararg_suffix
+        or _incompatible(left_star2, right_star2)
+    ):
         return False
 
     # Phase 1b: Check non-star args: for every arg right can accept, left must
@@ -1686,11 +1737,16 @@ def are_parameters_compatible(
         ):
             return False
 
+    if trivial_suffix:
+        # For trivial right suffix we *only* check that every non-star right argument
+        # has a valid match on the left.
+        return True
+
     # Phase 1c: Check var args. Right has an infinite series of optional positional
     #           arguments. Get all further positional args of left, and make sure
     #           they're more general than the corresponding member in right.
-    # TODO: are we handling UnpackType correctly here?
-    if right_star is not None and not trivial_suffix:
+    # TODO: handle suffix in UnpackType (i.e. *args: *Tuple[Ts, X, Y]).
+    if right_star is not None and not trivial_vararg_suffix:
         # Synthesize an anonymous formal argument for the right
         right_by_position = right.try_synthesizing_arg_from_vararg(None)
         assert right_by_position is not None
@@ -1717,7 +1773,7 @@ def are_parameters_compatible(
     # Phase 1d: Check kw args. Right has an infinite series of optional named
     #           arguments. Get all further named args of left, and make sure
     #           they're more general than the corresponding member in right.
-    if right_star2 is not None and not trivial_suffix:
+    if right_star2 is not None:
         right_names = {name for name in right.arg_names if name is not None}
         left_only_names = set()
         for name, kind in zip(left.arg_names, left.arg_kinds):
@@ -2041,6 +2097,7 @@ def infer_variance(info: TypeInfo, i: in
                     # Special case to avoid false positives (and to pass conformance tests)
                     settable = False
 
+            # TODO: handle settable properties with setter type different from getter.
             typ = find_member(member, self_type, self_type)
             if typ:
                 # It's okay for a method in a generic class with a contravariant type
@@ -2112,3 +2169,20 @@ def erase_return_self_types(typ: Type, s
             ]
         )
     return typ
+
+
+def is_erased_instance(t: Instance) -> bool:
+    """Is this an instance where all args are Any types?"""
+    if not t.args:
+        return False
+    for arg in t.args:
+        if isinstance(arg, UnpackType):
+            unpacked = get_proper_type(arg.type)
+            if not isinstance(unpacked, Instance):
+                return False
+            assert unpacked.type.fullname == "builtins.tuple"
+            if not isinstance(get_proper_type(unpacked.args[0]), AnyType):
+                return False
+        elif not isinstance(get_proper_type(arg), AnyType):
+            return False
+    return True
diff -pruN 1.15.0-5/mypy/suggestions.py 1.16~rc0.1-1/mypy/suggestions.py
--- 1.15.0-5/mypy/suggestions.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/suggestions.py	2025-05-27 17:21:15.000000000 +0000
@@ -52,6 +52,7 @@ from mypy.nodes import (
     SymbolNode,
     SymbolTable,
     TypeInfo,
+    Var,
     reverse_builtin_aliases,
 )
 from mypy.options import Options
@@ -59,7 +60,7 @@ from mypy.plugin import FunctionContext,
 from mypy.server.update import FineGrainedBuildManager
 from mypy.state import state
 from mypy.traverser import TraverserVisitor
-from mypy.typeops import make_simplified_union
+from mypy.typeops import bind_self, make_simplified_union
 from mypy.types import (
     AnyType,
     CallableType,
@@ -454,7 +455,7 @@ class SuggestionEngine:
             pnode = parent.names.get(node.name)
             if pnode and isinstance(pnode.node, (FuncDef, Decorator)):
                 typ = get_proper_type(pnode.node.type)
-                # FIXME: Doesn't work right with generic tyeps
+                # FIXME: Doesn't work right with generic types
                 if isinstance(typ, CallableType) and len(typ.arg_types) == len(node.arguments):
                     # Return the first thing we find, since it probably doesn't make sense
                     # to grab things further up in the chain if an earlier parent has it.
@@ -638,15 +639,20 @@ class SuggestionEngine:
     def extract_from_decorator(self, node: Decorator) -> FuncDef | None:
         for dec in node.decorators:
             typ = None
-            if isinstance(dec, RefExpr) and isinstance(dec.node, FuncDef):
-                typ = dec.node.type
+            if isinstance(dec, RefExpr) and isinstance(dec.node, (Var, FuncDef)):
+                typ = get_proper_type(dec.node.type)
             elif (
                 isinstance(dec, CallExpr)
                 and isinstance(dec.callee, RefExpr)
-                and isinstance(dec.callee.node, FuncDef)
-                and isinstance(dec.callee.node.type, CallableType)
+                and isinstance(dec.callee.node, (Decorator, FuncDef, Var))
+                and isinstance((call_tp := get_proper_type(dec.callee.node.type)), CallableType)
             ):
-                typ = get_proper_type(dec.callee.node.type.ret_type)
+                typ = get_proper_type(call_tp.ret_type)
+
+            if isinstance(typ, Instance):
+                call_method = typ.type.get_method("__call__")
+                if isinstance(call_method, FuncDef) and isinstance(call_method.type, FunctionLike):
+                    typ = bind_self(call_method.type, None)
 
             if not isinstance(typ, FunctionLike):
                 return None
diff -pruN 1.15.0-5/mypy/test/data.py 1.16~rc0.1-1/mypy/test/data.py
--- 1.15.0-5/mypy/test/data.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/data.py	2025-05-27 17:21:15.000000000 +0000
@@ -246,7 +246,7 @@ class DataDrivenTestCase(pytest.Item):
     """Holds parsed data-driven test cases, and handles directory setup and teardown."""
 
     # Override parent member type
-    parent: DataSuiteCollector
+    parent: DataFileCollector
 
     input: list[str]
     output: list[str]  # Output for the first pass
@@ -277,7 +277,7 @@ class DataDrivenTestCase(pytest.Item):
 
     def __init__(
         self,
-        parent: DataSuiteCollector,
+        parent: DataFileCollector,
         suite: DataSuite,
         *,
         file: str,
@@ -291,6 +291,7 @@ class DataDrivenTestCase(pytest.Item):
         data: str,
         line: int,
     ) -> None:
+        assert isinstance(parent, DataFileCollector)
         super().__init__(name, parent)
         self.suite = suite
         self.file = file
diff -pruN 1.15.0-5/mypy/test/helpers.py 1.16~rc0.1-1/mypy/test/helpers.py
--- 1.15.0-5/mypy/test/helpers.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/helpers.py	2025-05-27 17:21:15.000000000 +0000
@@ -413,8 +413,7 @@ def check_test_output_files(
     testcase: DataDrivenTestCase, step: int, strip_prefix: str = ""
 ) -> None:
     for path, expected_content in testcase.output_files:
-        if path.startswith(strip_prefix):
-            path = path[len(strip_prefix) :]
+        path = path.removeprefix(strip_prefix)
         if not os.path.exists(path):
             raise AssertionError(
                 "Expected file {} was not produced by test case{}".format(
diff -pruN 1.15.0-5/mypy/test/testfinegrained.py 1.16~rc0.1-1/mypy/test/testfinegrained.py
--- 1.15.0-5/mypy/test/testfinegrained.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/testfinegrained.py	2025-05-27 17:21:15.000000000 +0000
@@ -75,7 +75,6 @@ class FineGrainedSuite(DataSuite):
     def run_case(self, testcase: DataDrivenTestCase) -> None:
         if self.should_skip(testcase):
             pytest.skip()
-            return
 
         main_src = "\n".join(testcase.input)
         main_path = os.path.join(test_temp_dir, "main")
diff -pruN 1.15.0-5/mypy/test/testinfer.py 1.16~rc0.1-1/mypy/test/testinfer.py
--- 1.15.0-5/mypy/test/testinfer.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/testinfer.py	2025-05-27 17:21:15.000000000 +0000
@@ -134,7 +134,7 @@ def expand_caller_kinds(
 
 
 def expand_callee_kinds(
-    kinds_and_names: list[ArgKind | tuple[ArgKind, str]]
+    kinds_and_names: list[ArgKind | tuple[ArgKind, str]],
 ) -> tuple[list[ArgKind], list[str | None]]:
     kinds = []
     names: list[str | None] = []
diff -pruN 1.15.0-5/mypy/test/testmerge.py 1.16~rc0.1-1/mypy/test/testmerge.py
--- 1.15.0-5/mypy/test/testmerge.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/testmerge.py	2025-05-27 17:21:15.000000000 +0000
@@ -13,7 +13,6 @@ from mypy.nodes import (
     UNBOUND_IMPORTED,
     Expression,
     MypyFile,
-    Node,
     SymbolTable,
     SymbolTableNode,
     TypeInfo,
@@ -172,10 +171,7 @@ class ASTMergeSuite(DataSuite):
             if node.kind == UNBOUND_IMPORTED:
                 return "UNBOUND_IMPORTED"
             return "None"
-        if isinstance(node.node, Node):
-            s = f"{str(type(node.node).__name__)}<{self.id_mapper.id(node.node)}>"
-        else:
-            s = f"? ({type(node.node)})"
+        s = f"{str(type(node.node).__name__)}<{self.id_mapper.id(node.node)}>"
         if (
             isinstance(node.node, Var)
             and node.node.type
diff -pruN 1.15.0-5/mypy/test/testmodulefinder.py 1.16~rc0.1-1/mypy/test/testmodulefinder.py
--- 1.15.0-5/mypy/test/testmodulefinder.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/testmodulefinder.py	2025-05-27 17:21:15.000000000 +0000
@@ -195,6 +195,9 @@ class ModuleFinderSitePackagesSuite(Suit
             ("pkg_typed.b", self.path("pkg_typed", "b", "__init__.py")),
             ("pkg_typed.b.c", self.path("pkg_typed", "b", "c.py")),
             ("pkg_typed.a.a_var", ModuleNotFoundReason.NOT_FOUND),
+            # Regular package with py.typed, bundled stubs, and external stubs-only package
+            ("pkg_typed_w_stubs", self.path("pkg_typed_w_stubs-stubs", "__init__.pyi")),
+            ("pkg_typed_w_stubs.spam", self.path("pkg_typed_w_stubs-stubs", "spam.pyi")),
             # Regular package without py.typed
             ("pkg_untyped", ModuleNotFoundReason.FOUND_WITHOUT_TYPE_HINTS),
             ("pkg_untyped.a", ModuleNotFoundReason.FOUND_WITHOUT_TYPE_HINTS),
@@ -250,6 +253,9 @@ class ModuleFinderSitePackagesSuite(Suit
             ("pkg_typed.b", self.path("pkg_typed", "b", "__init__.py")),
             ("pkg_typed.b.c", self.path("pkg_typed", "b", "c.py")),
             ("pkg_typed.a.a_var", ModuleNotFoundReason.NOT_FOUND),
+            # Regular package with py.typed, bundled stubs, and external stubs-only package
+            ("pkg_typed_w_stubs", self.path("pkg_typed_w_stubs-stubs", "__init__.pyi")),
+            ("pkg_typed_w_stubs.spam", self.path("pkg_typed_w_stubs-stubs", "spam.pyi")),
             # Regular package without py.typed
             ("pkg_untyped", ModuleNotFoundReason.FOUND_WITHOUT_TYPE_HINTS),
             ("pkg_untyped.a", ModuleNotFoundReason.FOUND_WITHOUT_TYPE_HINTS),
diff -pruN 1.15.0-5/mypy/test/testpep561.py 1.16~rc0.1-1/mypy/test/testpep561.py
--- 1.15.0-5/mypy/test/testpep561.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/testpep561.py	2025-05-27 17:21:15.000000000 +0000
@@ -145,8 +145,11 @@ def test_pep561(testcase: DataDrivenTest
                     output.append(line[len(test_temp_dir + os.sep) :].rstrip("\r\n"))
                 else:
                     # Normalize paths so that the output is the same on Windows and Linux/macOS.
-                    line = line.replace(test_temp_dir + os.sep, test_temp_dir + "/")
-                    output.append(line.rstrip("\r\n"))
+                    # Yes, this is naive: replace all slashes preceding first colon, if any.
+                    path, *rest = line.split(":", maxsplit=1)
+                    if rest:
+                        path = path.replace(os.sep, "/")
+                    output.append(":".join([path, *rest]).rstrip("\r\n"))
             iter_count = "" if i == 0 else f" on iteration {i + 1}"
             expected = testcase.output if i == 0 else testcase.output2.get(i + 1, [])
 
@@ -173,38 +176,3 @@ def parse_mypy_args(line: str) -> list[s
     if not m:
         return []  # No args; mypy will spit out an error.
     return m.group(1).split()
-
-
-def test_mypy_path_is_respected() -> None:
-    assert False
-    packages = "packages"
-    pkg_name = "a"
-    with tempfile.TemporaryDirectory() as temp_dir:
-        old_dir = os.getcwd()
-        os.chdir(temp_dir)
-        try:
-            # Create the pkg for files to go into
-            full_pkg_name = os.path.join(temp_dir, packages, pkg_name)
-            os.makedirs(full_pkg_name)
-
-            # Create the empty __init__ file to declare a package
-            pkg_init_name = os.path.join(temp_dir, packages, pkg_name, "__init__.py")
-            open(pkg_init_name, "w", encoding="utf8").close()
-
-            mypy_config_path = os.path.join(temp_dir, "mypy.ini")
-            with open(mypy_config_path, "w") as mypy_file:
-                mypy_file.write("[mypy]\n")
-                mypy_file.write(f"mypy_path = ./{packages}\n")
-
-            with virtualenv() as venv:
-                venv_dir, python_executable = venv
-
-                cmd_line_args = []
-                if python_executable != sys.executable:
-                    cmd_line_args.append(f"--python-executable={python_executable}")
-                cmd_line_args.extend(["--config-file", mypy_config_path, "--package", pkg_name])
-
-                out, err, returncode = mypy.api.run(cmd_line_args)
-                assert returncode == 0
-        finally:
-            os.chdir(old_dir)
diff -pruN 1.15.0-5/mypy/test/teststubgen.py 1.16~rc0.1-1/mypy/test/teststubgen.py
--- 1.15.0-5/mypy/test/teststubgen.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/teststubgen.py	2025-05-27 17:21:15.000000000 +0000
@@ -399,6 +399,164 @@ class StubgenUtilSuite(unittest.TestCase
             None,
         )
 
+    def test_infer_sig_from_docstring_args_kwargs(self) -> None:
+        assert_equal(
+            infer_sig_from_docstring("func(*args, **kwargs) -> int", "func"),
+            [
+                FunctionSig(
+                    name="func",
+                    args=[ArgSig(name="*args"), ArgSig(name="**kwargs")],
+                    ret_type="int",
+                )
+            ],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(*args) -> int", "func"),
+            [FunctionSig(name="func", args=[ArgSig(name="*args")], ret_type="int")],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(**kwargs) -> int", "func"),
+            [FunctionSig(name="func", args=[ArgSig(name="**kwargs")], ret_type="int")],
+        )
+
+    @pytest.mark.xfail(
+        raises=AssertionError, reason="Arg and kwarg signature validation not implemented yet"
+    )
+    def test_infer_sig_from_docstring_args_kwargs_errors(self) -> None:
+        # Double args
+        assert_equal(infer_sig_from_docstring("func(*args, *args2) -> int", "func"), [])
+
+        # Double kwargs
+        assert_equal(infer_sig_from_docstring("func(**kw, **kw2) -> int", "func"), [])
+
+        # args after kwargs
+        assert_equal(infer_sig_from_docstring("func(**kwargs, *args) -> int", "func"), [])
+
+    def test_infer_sig_from_docstring_positional_only_arguments(self) -> None:
+        assert_equal(
+            infer_sig_from_docstring("func(self, /) -> str", "func"),
+            [FunctionSig(name="func", args=[ArgSig(name="self")], ret_type="str")],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(self, x, /) -> str", "func"),
+            [
+                FunctionSig(
+                    name="func", args=[ArgSig(name="self"), ArgSig(name="x")], ret_type="str"
+                )
+            ],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(x, /, y) -> int", "func"),
+            [FunctionSig(name="func", args=[ArgSig(name="x"), ArgSig(name="y")], ret_type="int")],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(x, /, *args) -> str", "func"),
+            [
+                FunctionSig(
+                    name="func", args=[ArgSig(name="x"), ArgSig(name="*args")], ret_type="str"
+                )
+            ],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(x, /, *, kwonly, **kwargs) -> str", "func"),
+            [
+                FunctionSig(
+                    name="func",
+                    args=[ArgSig(name="x"), ArgSig(name="kwonly"), ArgSig(name="**kwargs")],
+                    ret_type="str",
+                )
+            ],
+        )
+
+    def test_infer_sig_from_docstring_keyword_only_arguments(self) -> None:
+        assert_equal(
+            infer_sig_from_docstring("func(*, x) -> str", "func"),
+            [FunctionSig(name="func", args=[ArgSig(name="x")], ret_type="str")],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(x, *, y) -> str", "func"),
+            [FunctionSig(name="func", args=[ArgSig(name="x"), ArgSig(name="y")], ret_type="str")],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(*, x, y) -> str", "func"),
+            [FunctionSig(name="func", args=[ArgSig(name="x"), ArgSig(name="y")], ret_type="str")],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(x, *, kwonly, **kwargs) -> str", "func"),
+            [
+                FunctionSig(
+                    name="func",
+                    args=[ArgSig(name="x"), ArgSig(name="kwonly"), ArgSig("**kwargs")],
+                    ret_type="str",
+                )
+            ],
+        )
+
+    def test_infer_sig_from_docstring_pos_only_and_keyword_only_arguments(self) -> None:
+        assert_equal(
+            infer_sig_from_docstring("func(x, /, *, y) -> str", "func"),
+            [FunctionSig(name="func", args=[ArgSig(name="x"), ArgSig(name="y")], ret_type="str")],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(x,  /, y,  *, z) -> str", "func"),
+            [
+                FunctionSig(
+                    name="func",
+                    args=[ArgSig(name="x"), ArgSig(name="y"), ArgSig(name="z")],
+                    ret_type="str",
+                )
+            ],
+        )
+
+        assert_equal(
+            infer_sig_from_docstring("func(x,  /, y,  *, z, **kwargs) -> str", "func"),
+            [
+                FunctionSig(
+                    name="func",
+                    args=[
+                        ArgSig(name="x"),
+                        ArgSig(name="y"),
+                        ArgSig(name="z"),
+                        ArgSig("**kwargs"),
+                    ],
+                    ret_type="str",
+                )
+            ],
+        )
+
+    def test_infer_sig_from_docstring_pos_only_and_keyword_only_arguments_errors(self) -> None:
+        # / as first argument
+        assert_equal(infer_sig_from_docstring("func(/, x) -> str", "func"), [])
+
+        # * as last argument
+        assert_equal(infer_sig_from_docstring("func(x, *) -> str", "func"), [])
+
+        # / after *
+        assert_equal(infer_sig_from_docstring("func(x, *, /,  y) -> str", "func"), [])
+
+        # Two /
+        assert_equal(infer_sig_from_docstring("func(x, /, /, *,  y) -> str", "func"), [])
+
+        assert_equal(infer_sig_from_docstring("func(x, /, y,  /, *,  z) -> str", "func"), [])
+
+        # Two *
+        assert_equal(infer_sig_from_docstring("func(x, /, *, *,  y) -> str", "func"), [])
+
+        assert_equal(infer_sig_from_docstring("func(x, /, *, y, *,  z) -> str", "func"), [])
+
+        # *args and * are not allowed
+        assert_equal(infer_sig_from_docstring("func(*args, *, kwonly) -> str", "func"), [])
+
     def test_infer_arg_sig_from_anon_docstring(self) -> None:
         assert_equal(
             infer_arg_sig_from_anon_docstring("(*args, **kwargs)"),
@@ -856,6 +1014,30 @@ class StubgencSuite(unittest.TestCase):
         assert_equal(gen.get_imports().splitlines(), ["from typing import ClassVar"])
         assert_equal(output, ["class C:", "    x: ClassVar[int] = ..."])
 
+    def test_generate_c_type_none_default(self) -> None:
+        class TestClass:
+            def test(self, arg0=1, arg1=None) -> None:  # type: ignore[no-untyped-def]
+                pass
+
+        output: list[str] = []
+        mod = ModuleType(TestClass.__module__, "")
+        gen = InspectionStubGenerator(mod.__name__, known_modules=[mod.__name__], module=mod)
+        gen.is_c_module = False
+        gen.generate_function_stub(
+            "test",
+            TestClass.test,
+            output=output,
+            class_info=ClassInfo(
+                self_var="self",
+                cls=TestClass,
+                name="TestClass",
+                docstring=getattr(TestClass, "__doc__", None),
+            ),
+        )
+        assert_equal(
+            output, ["def test(self, arg0: int = ..., arg1: Incomplete | None = ...) -> None: ..."]
+        )
+
     def test_non_c_generate_signature_with_kw_only_args(self) -> None:
         class TestClass:
             def test(
@@ -1405,6 +1587,9 @@ class IsValidTypeSuite(unittest.TestCase
         assert is_valid_type("Literal[True]")
         assert is_valid_type("Literal[Color.RED]")
         assert is_valid_type("Literal[None]")
+        assert is_valid_type("str | int")
+        assert is_valid_type("dict[str, int] | int")
+        assert is_valid_type("tuple[str, ...]")
         assert is_valid_type(
             'Literal[26, 0x1A, "hello world", b"hello world", u"hello world", True, Color.RED, None]'
         )
diff -pruN 1.15.0-5/mypy/test/teststubtest.py 1.16~rc0.1-1/mypy/test/teststubtest.py
--- 1.15.0-5/mypy/test/teststubtest.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/teststubtest.py	2025-05-27 17:21:15.000000000 +0000
@@ -48,6 +48,11 @@ Callable: _SpecialForm = ...
 Generic: _SpecialForm = ...
 Protocol: _SpecialForm = ...
 Union: _SpecialForm = ...
+ClassVar: _SpecialForm = ...
+
+Final = 0
+Literal = 0
+TypedDict = 0
 
 class TypeVar:
     def __init__(self, name, covariant: bool = ..., contravariant: bool = ...) -> None: ...
@@ -71,6 +76,12 @@ class Match(Generic[AnyStr]): ...
 class Sequence(Iterable[_T_co]): ...
 class Tuple(Sequence[_T_co]): ...
 class NamedTuple(tuple[Any, ...]): ...
+class _TypedDict(Mapping[str, object]):
+    __required_keys__: ClassVar[frozenset[str]]
+    __optional_keys__: ClassVar[frozenset[str]]
+    __total__: ClassVar[bool]
+    __readonly_keys__: ClassVar[frozenset[str]]
+    __mutable_keys__: ClassVar[frozenset[str]]
 def overload(func: _T) -> _T: ...
 def type_check_only(func: _T) -> _T: ...
 def final(func: _T) -> _T: ...
@@ -95,6 +106,8 @@ class tuple(Sequence[T_co], Generic[T_co
 
 class dict(Mapping[KT, VT]): ...
 
+class frozenset(Generic[T]): ...
+
 class function: pass
 class ellipsis: pass
 
@@ -326,6 +339,21 @@ class StubtestUnit(unittest.TestCase):
             """,
             error=None,
         )
+        yield Case(
+            stub="""def dunder_name(__x: int) -> None: ...""",
+            runtime="""def dunder_name(__x: int) -> None: ...""",
+            error=None,
+        )
+        yield Case(
+            stub="""def dunder_name_posonly(__x: int, /) -> None: ...""",
+            runtime="""def dunder_name_posonly(__x: int) -> None: ...""",
+            error=None,
+        )
+        yield Case(
+            stub="""def dunder_name_bad(x: int) -> None: ...""",
+            runtime="""def dunder_name_bad(__x: int) -> None: ...""",
+            error="dunder_name_bad",
+        )
 
     @collect_cases
     def test_arg_kind(self) -> Iterator[Case]:
@@ -1373,7 +1401,7 @@ class StubtestUnit(unittest.TestCase):
         )
         yield Case(
             stub="""
-            from typing_extensions import Final, Literal
+            from typing import Final, Literal
             class BytesEnum(bytes, enum.Enum):
                 a = b'foo'
             FOO: Literal[BytesEnum.a]
@@ -1483,6 +1511,24 @@ class StubtestUnit(unittest.TestCase):
             runtime="class ClassWithMetaclassOverride: ...",
             error="ClassWithMetaclassOverride.__call__",
         )
+        # Test that we ignore object.__setattr__ and object.__delattr__ inheritance
+        yield Case(
+            stub="""
+            from typing import Any
+            class FakeSetattrClass:
+                def __setattr__(self, name: str, value: Any, /) -> None: ...
+            """,
+            runtime="class FakeSetattrClass: ...",
+            error="FakeSetattrClass.__setattr__",
+        )
+        yield Case(
+            stub="""
+            class FakeDelattrClass:
+                def __delattr__(self, name: str, /) -> None: ...
+            """,
+            runtime="class FakeDelattrClass: ...",
+            error="FakeDelattrClass.__delattr__",
+        )
 
     @collect_cases
     def test_missing_no_runtime_all(self) -> Iterator[Case]:
@@ -1915,7 +1961,7 @@ assert annotations
     def test_good_literal(self) -> Iterator[Case]:
         yield Case(
             stub=r"""
-            from typing_extensions import Literal
+            from typing import Literal
 
             import enum
             class Color(enum.Enum):
@@ -1947,7 +1993,7 @@ assert annotations
 
     @collect_cases
     def test_bad_literal(self) -> Iterator[Case]:
-        yield Case("from typing_extensions import Literal", "", None)  # dummy case
+        yield Case("from typing import Literal", "", None)  # dummy case
         yield Case(
             stub="INT_FLOAT_MISMATCH: Literal[1]",
             runtime="INT_FLOAT_MISMATCH = 1.0",
@@ -1998,7 +2044,7 @@ assert annotations
         )
         yield Case(
             stub="""
-            from typing_extensions import TypedDict
+            from typing import TypedDict
 
             class _Options(TypedDict):
                 a: str
@@ -2019,8 +2065,8 @@ assert annotations
     @collect_cases
     def test_runtime_typing_objects(self) -> Iterator[Case]:
         yield Case(
-            stub="from typing_extensions import Protocol, TypedDict",
-            runtime="from typing_extensions import Protocol, TypedDict",
+            stub="from typing import Protocol, TypedDict",
+            runtime="from typing import Protocol, TypedDict",
             error=None,
         )
         yield Case(
@@ -2385,8 +2431,8 @@ assert annotations
         )
         # The same is true for NamedTuples and TypedDicts:
         yield Case(
-            stub="from typing_extensions import NamedTuple, TypedDict",
-            runtime="from typing_extensions import NamedTuple, TypedDict",
+            stub="from typing import NamedTuple, TypedDict",
+            runtime="from typing import NamedTuple, TypedDict",
             error=None,
         )
         yield Case(
diff -pruN 1.15.0-5/mypy/test/testsubtypes.py 1.16~rc0.1-1/mypy/test/testsubtypes.py
--- 1.15.0-5/mypy/test/testsubtypes.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/testsubtypes.py	2025-05-27 17:21:15.000000000 +0000
@@ -4,7 +4,7 @@ from mypy.nodes import CONTRAVARIANT, CO
 from mypy.subtypes import is_subtype
 from mypy.test.helpers import Suite
 from mypy.test.typefixture import InterfaceTypeFixture, TypeFixture
-from mypy.types import Instance, Type, UninhabitedType, UnpackType
+from mypy.types import Instance, TupleType, Type, UninhabitedType, UnpackType
 
 
 class SubtypingSuite(Suite):
@@ -274,6 +274,9 @@ class SubtypingSuite(Suite):
             Instance(self.fx.gvi, [UnpackType(Instance(self.fx.std_tuplei, [self.fx.a]))]),
         )
 
+    def test_fallback_not_subtype_of_tuple(self) -> None:
+        self.assert_not_subtype(self.fx.a, TupleType([self.fx.b], fallback=self.fx.a))
+
     # IDEA: Maybe add these test cases (they are tested pretty well in type
     #       checker tests already):
     #  * more interface subtyping test cases
diff -pruN 1.15.0-5/mypy/test/testtypes.py 1.16~rc0.1-1/mypy/test/testtypes.py
--- 1.15.0-5/mypy/test/testtypes.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/test/testtypes.py	2025-05-27 17:21:15.000000000 +0000
@@ -7,7 +7,7 @@ from unittest import TestCase, skipUnles
 
 from mypy.erasetype import erase_type, remove_instance_last_known_values
 from mypy.indirection import TypeIndirectionVisitor
-from mypy.join import join_simple, join_types
+from mypy.join import join_types
 from mypy.meet import meet_types, narrow_declared_type
 from mypy.nodes import (
     ARG_NAMED,
@@ -817,12 +817,12 @@ class JoinSuite(Suite):
             self.assert_join(t, self.fx.anyt, self.fx.anyt)
 
     def test_mixed_truth_restricted_type_simple(self) -> None:
-        # join_simple against differently restricted truthiness types drops restrictions.
+        # make_simplified_union against differently restricted truthiness types drops restrictions.
         true_a = true_only(self.fx.a)
         false_o = false_only(self.fx.o)
-        j = join_simple(self.fx.o, true_a, false_o)
-        assert j.can_be_true
-        assert j.can_be_false
+        u = make_simplified_union([true_a, false_o])
+        assert u.can_be_true
+        assert u.can_be_false
 
     def test_mixed_truth_restricted_type(self) -> None:
         # join_types against differently restricted truthiness types drops restrictions.
@@ -1021,7 +1021,7 @@ class JoinSuite(Suite):
         self.assert_join(
             self.tuple(self.fx.a, self.fx.a),
             self.tuple(UnpackType(Instance(self.fx.std_tuplei, [self.fx.a]))),
-            self.tuple(UnpackType(Instance(self.fx.std_tuplei, [self.fx.a]))),
+            Instance(self.fx.std_tuplei, [self.fx.a]),
         )
         self.assert_join(
             self.tuple(self.fx.a, self.fx.a),
@@ -1049,12 +1049,12 @@ class JoinSuite(Suite):
             self.tuple(
                 self.fx.a, UnpackType(Instance(self.fx.std_tuplei, [self.fx.a])), self.fx.a
             ),
-            self.tuple(UnpackType(Instance(self.fx.std_tuplei, [self.fx.a]))),
+            Instance(self.fx.std_tuplei, [self.fx.a]),
         )
         self.assert_join(
             self.tuple(UnpackType(Instance(self.fx.std_tuplei, [self.fx.a]))),
             self.tuple(UnpackType(Instance(self.fx.std_tuplei, [self.fx.a]))),
-            self.tuple(UnpackType(Instance(self.fx.std_tuplei, [self.fx.a]))),
+            Instance(self.fx.std_tuplei, [self.fx.a]),
         )
         self.assert_join(
             self.tuple(UnpackType(Instance(self.fx.std_tuplei, [self.fx.a])), self.fx.a),
@@ -1584,11 +1584,12 @@ def make_call(*items: tuple[str, str | N
 class TestExpandTypeLimitGetProperType(TestCase):
     # WARNING: do not increase this number unless absolutely necessary,
     # and you understand what you are doing.
-    ALLOWED_GET_PROPER_TYPES = 9
+    ALLOWED_GET_PROPER_TYPES = 7
 
     @skipUnless(mypy.expandtype.__file__.endswith(".py"), "Skip for compiled mypy")
     def test_count_get_proper_type(self) -> None:
         with open(mypy.expandtype.__file__) as f:
             code = f.read()
-        get_proper_type_count = len(re.findall("get_proper_type", code))
+        get_proper_type_count = len(re.findall(r"get_proper_type\(", code))
+        get_proper_type_count -= len(re.findall(r"get_proper_type\(\)", code))
         assert get_proper_type_count == self.ALLOWED_GET_PROPER_TYPES
diff -pruN 1.15.0-5/mypy/traverser.py 1.16~rc0.1-1/mypy/traverser.py
--- 1.15.0-5/mypy/traverser.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/traverser.py	2025-05-27 17:21:15.000000000 +0000
@@ -58,6 +58,7 @@ from mypy.nodes import (
     OverloadedFuncDef,
     ParamSpecExpr,
     PassStmt,
+    PromoteExpr,
     RaiseStmt,
     ReturnStmt,
     RevealExpr,
@@ -67,6 +68,7 @@ from mypy.nodes import (
     StarExpr,
     StrExpr,
     SuperExpr,
+    TempNode,
     TryStmt,
     TupleExpr,
     TypeAlias,
@@ -77,6 +79,7 @@ from mypy.nodes import (
     TypeVarExpr,
     TypeVarTupleExpr,
     UnaryExpr,
+    Var,
     WhileStmt,
     WithStmt,
     YieldExpr,
@@ -415,6 +418,85 @@ class TraverserVisitor(NodeVisitor[None]
         for a in o.assignments:
             a.accept(self)
 
+    # leaf nodes
+    def visit_name_expr(self, o: NameExpr, /) -> None:
+        return None
+
+    def visit_str_expr(self, o: StrExpr, /) -> None:
+        return None
+
+    def visit_int_expr(self, o: IntExpr, /) -> None:
+        return None
+
+    def visit_float_expr(self, o: FloatExpr, /) -> None:
+        return None
+
+    def visit_bytes_expr(self, o: BytesExpr, /) -> None:
+        return None
+
+    def visit_ellipsis(self, o: EllipsisExpr, /) -> None:
+        return None
+
+    def visit_var(self, o: Var, /) -> None:
+        return None
+
+    def visit_continue_stmt(self, o: ContinueStmt, /) -> None:
+        return None
+
+    def visit_pass_stmt(self, o: PassStmt, /) -> None:
+        return None
+
+    def visit_break_stmt(self, o: BreakStmt, /) -> None:
+        return None
+
+    def visit_temp_node(self, o: TempNode, /) -> None:
+        return None
+
+    def visit_nonlocal_decl(self, o: NonlocalDecl, /) -> None:
+        return None
+
+    def visit_global_decl(self, o: GlobalDecl, /) -> None:
+        return None
+
+    def visit_import_all(self, o: ImportAll, /) -> None:
+        return None
+
+    def visit_type_var_expr(self, o: TypeVarExpr, /) -> None:
+        return None
+
+    def visit_paramspec_expr(self, o: ParamSpecExpr, /) -> None:
+        return None
+
+    def visit_type_var_tuple_expr(self, o: TypeVarTupleExpr, /) -> None:
+        return None
+
+    def visit_type_alias_expr(self, o: TypeAliasExpr, /) -> None:
+        return None
+
+    def visit_type_alias(self, o: TypeAlias, /) -> None:
+        return None
+
+    def visit_namedtuple_expr(self, o: NamedTupleExpr, /) -> None:
+        return None
+
+    def visit_typeddict_expr(self, o: TypedDictExpr, /) -> None:
+        return None
+
+    def visit_newtype_expr(self, o: NewTypeExpr, /) -> None:
+        return None
+
+    def visit__promote_expr(self, o: PromoteExpr, /) -> None:
+        return None
+
+    def visit_complex_expr(self, o: ComplexExpr, /) -> None:
+        return None
+
+    def visit_enum_call_expr(self, o: EnumCallExpr, /) -> None:
+        return None
+
+    def visit_singleton_pattern(self, o: SingletonPattern, /) -> None:
+        return None
+
 
 class ExtendedTraverserVisitor(TraverserVisitor):
     """This is a more flexible traverser.
diff -pruN 1.15.0-5/mypy/treetransform.py 1.16~rc0.1-1/mypy/treetransform.py
--- 1.15.0-5/mypy/treetransform.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/treetransform.py	2025-05-27 17:21:15.000000000 +0000
@@ -559,7 +559,7 @@ class TransformVisitor(NodeVisitor[Node]
         return new
 
     def visit_assignment_expr(self, node: AssignmentExpr) -> AssignmentExpr:
-        return AssignmentExpr(self.expr(node.target), self.expr(node.value))
+        return AssignmentExpr(self.duplicate_name(node.target), self.expr(node.value))
 
     def visit_unary_expr(self, node: UnaryExpr) -> UnaryExpr:
         new = UnaryExpr(node.op, self.expr(node.expr))
diff -pruN 1.15.0-5/mypy/type_visitor.py 1.16~rc0.1-1/mypy/type_visitor.py
--- 1.15.0-5/mypy/type_visitor.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/type_visitor.py	2025-05-27 17:21:15.000000000 +0000
@@ -344,7 +344,7 @@ class TypeQuery(SyntheticTypeVisitor[T])
     common use cases involve a boolean query using `any` or `all`.
 
     Note: this visitor keeps an internal state (tracks type aliases to avoid
-    recursion), so it should *never* be re-used for querying different types,
+    recursion), so it should *never* be reused for querying different types,
     create a new visitor instance instead.
 
     # TODO: check that we don't have existing violations of this rule.
@@ -467,7 +467,7 @@ class BoolTypeQuery(SyntheticTypeVisitor
     be ANY_STRATEGY or ALL_STRATEGY.
 
     Note: This visitor keeps an internal state (tracks type aliases to avoid
-    recursion), so it should *never* be re-used for querying different types
+    recursion), so it should *never* be reused for querying different types
     unless you call reset() first.
     """
 
diff -pruN 1.15.0-5/mypy/typeanal.py 1.16~rc0.1-1/mypy/typeanal.py
--- 1.15.0-5/mypy/typeanal.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeanal.py	2025-05-27 17:21:15.000000000 +0000
@@ -62,10 +62,12 @@ from mypy.tvar_scope import TypeVarLikeS
 from mypy.types import (
     ANNOTATED_TYPE_NAMES,
     ANY_STRATEGY,
+    CONCATENATE_TYPE_NAMES,
     FINAL_TYPE_NAMES,
     LITERAL_TYPE_NAMES,
     NEVER_NAMES,
     TYPE_ALIAS_NAMES,
+    UNPACK_TYPE_NAMES,
     AnyType,
     BoolTypeQuery,
     CallableArgument,
@@ -525,7 +527,7 @@ class TypeAnalyser(SyntheticTypeVisitor[
             elif node.fullname in TYPE_ALIAS_NAMES:
                 return AnyType(TypeOfAny.special_form)
             # Concatenate is an operator, no need for a proper type
-            elif node.fullname in ("typing_extensions.Concatenate", "typing.Concatenate"):
+            elif node.fullname in CONCATENATE_TYPE_NAMES:
                 # We check the return type further up the stack for valid use locations
                 return self.apply_concatenate_operator(t)
             else:
@@ -614,7 +616,7 @@ class TypeAnalyser(SyntheticTypeVisitor[
         """
         if fullname == "builtins.None":
             return NoneType()
-        elif fullname == "typing.Any" or fullname == "builtins.Any":
+        elif fullname == "typing.Any":
             return AnyType(TypeOfAny.explicit, line=t.line, column=t.column)
         elif fullname in FINAL_TYPE_NAMES:
             if self.prohibit_special_class_field_types:
@@ -779,7 +781,7 @@ class TypeAnalyser(SyntheticTypeVisitor[
         ):
             # In most contexts, TypeGuard[...] acts as an alias for bool (ignoring its args)
             return self.named_type("builtins.bool")
-        elif fullname in ("typing.Unpack", "typing_extensions.Unpack"):
+        elif fullname in UNPACK_TYPE_NAMES:
             if len(t.args) != 1:
                 self.fail("Unpack[...] requires exactly one type argument", t)
                 return AnyType(TypeOfAny.from_error)
@@ -821,6 +823,10 @@ class TypeAnalyser(SyntheticTypeVisitor[
             (deprecated := info.deprecated)
             and not self.is_typeshed_stub
             and not (self.api.type and (self.api.type.fullname == info.fullname))
+            and not any(
+                info.fullname == p or info.fullname.startswith(f"{p}.")
+                for p in self.options.deprecated_calls_exclude
+            )
         ):
             for imp in self.cur_mod_node.imports:
                 if isinstance(imp, ImportFrom) and any(info.name == n[0] for n in imp.names):
@@ -862,6 +868,8 @@ class TypeAnalyser(SyntheticTypeVisitor[
             ctx.line,
             ctx.column,
         )
+        instance.end_line = ctx.end_line
+        instance.end_column = ctx.end_column
         if len(info.type_vars) == 1 and info.has_param_spec_type:
             instance.args = tuple(self.pack_paramspec_args(instance.args))
 
@@ -1501,7 +1509,7 @@ class TypeAnalyser(SyntheticTypeVisitor[
             return None
         if sym.node is None:
             return None
-        if sym.node.fullname not in ("typing_extensions.Concatenate", "typing.Concatenate"):
+        if sym.node.fullname not in CONCATENATE_TYPE_NAMES:
             return None
 
         tvar_def = self.anal_type(callable_args, allow_param_spec=True)
@@ -1650,7 +1658,7 @@ class TypeAnalyser(SyntheticTypeVisitor[
                         return None
             elif (
                 isinstance(arg, UnboundType)
-                and self.refers_to_full_names(arg, ("typing_extensions.Unpack", "typing.Unpack"))
+                and self.refers_to_full_names(arg, UNPACK_TYPE_NAMES)
                 or isinstance(arg, UnpackType)
             ):
                 if seen_unpack:
@@ -1998,7 +2006,7 @@ class TypeAnalyser(SyntheticTypeVisitor[
 
         if num_unpacks > 1:
             assert final_unpack is not None
-            self.fail("More than one Unpack in a type is not allowed", final_unpack)
+            self.fail("More than one Unpack in a type is not allowed", final_unpack.type)
         return new_items
 
     def tuple_type(self, items: list[Type], line: int, column: int) -> TupleType:
@@ -2204,6 +2212,8 @@ def instantiate_type_alias(
         tp = Instance(node.target.type, args)
         tp.line = ctx.line
         tp.column = ctx.column
+        tp.end_line = ctx.end_line
+        tp.end_column = ctx.end_column
         return tp
     if node.tvar_tuple_index is None:
         if any(isinstance(a, UnpackType) for a in args):
diff -pruN 1.15.0-5/mypy/typeops.py 1.16~rc0.1-1/mypy/typeops.py
--- 1.15.0-5/mypy/typeops.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeops.py	2025-05-27 17:21:15.000000000 +0000
@@ -9,7 +9,7 @@ from __future__ import annotations
 
 import itertools
 from collections.abc import Iterable, Sequence
-from typing import Any, TypeVar, cast
+from typing import Any, Callable, TypeVar, cast
 
 from mypy.copytype import copy_type
 from mypy.expandtype import expand_type, expand_type_by_instance
@@ -27,6 +27,7 @@ from mypy.nodes import (
     FuncItem,
     OverloadedFuncDef,
     StrExpr,
+    SymbolNode,
     TypeInfo,
     Var,
 )
@@ -63,6 +64,7 @@ from mypy.types import (
     get_proper_type,
     get_proper_types,
 )
+from mypy.typetraverser import TypeTraverserVisitor
 from mypy.typevars import fill_typevars
 
 
@@ -132,6 +134,90 @@ def get_self_type(func: CallableType, de
         return None
 
 
+def type_object_type(info: TypeInfo, named_type: Callable[[str], Instance]) -> ProperType:
+    """Return the type of a type object.
+
+    For a generic type G with type variables T and S the type is generally of form
+
+      Callable[..., G[T, S]]
+
+    where ... are argument types for the __init__/__new__ method (without the self
+    argument). Also, the fallback type will be 'type' instead of 'function'.
+    """
+
+    # We take the type from whichever of __init__ and __new__ is first
+    # in the MRO, preferring __init__ if there is a tie.
+    init_method = info.get("__init__")
+    new_method = info.get("__new__")
+    if not init_method or not is_valid_constructor(init_method.node):
+        # Must be an invalid class definition.
+        return AnyType(TypeOfAny.from_error)
+    # There *should* always be a __new__ method except the test stubs
+    # lack it, so just copy init_method in that situation
+    new_method = new_method or init_method
+    if not is_valid_constructor(new_method.node):
+        # Must be an invalid class definition.
+        return AnyType(TypeOfAny.from_error)
+
+    # The two is_valid_constructor() checks ensure this.
+    assert isinstance(new_method.node, (SYMBOL_FUNCBASE_TYPES, Decorator))
+    assert isinstance(init_method.node, (SYMBOL_FUNCBASE_TYPES, Decorator))
+
+    init_index = info.mro.index(init_method.node.info)
+    new_index = info.mro.index(new_method.node.info)
+
+    fallback = info.metaclass_type or named_type("builtins.type")
+    if init_index < new_index:
+        method: FuncBase | Decorator = init_method.node
+        is_new = False
+    elif init_index > new_index:
+        method = new_method.node
+        is_new = True
+    else:
+        if init_method.node.info.fullname == "builtins.object":
+            # Both are defined by object.  But if we've got a bogus
+            # base class, we can't know for sure, so check for that.
+            if info.fallback_to_any:
+                # Construct a universal callable as the prototype.
+                any_type = AnyType(TypeOfAny.special_form)
+                sig = CallableType(
+                    arg_types=[any_type, any_type],
+                    arg_kinds=[ARG_STAR, ARG_STAR2],
+                    arg_names=["_args", "_kwds"],
+                    ret_type=any_type,
+                    fallback=named_type("builtins.function"),
+                )
+                return class_callable(sig, info, fallback, None, is_new=False)
+
+        # Otherwise prefer __init__ in a tie. It isn't clear that this
+        # is the right thing, but __new__ caused problems with
+        # typeshed (#5647).
+        method = init_method.node
+        is_new = False
+    # Construct callable type based on signature of __init__. Adjust
+    # return type and insert type arguments.
+    if isinstance(method, FuncBase):
+        t = function_type(method, fallback)
+    else:
+        assert isinstance(method.type, ProperType)
+        assert isinstance(method.type, FunctionLike)  # is_valid_constructor() ensures this
+        t = method.type
+    return type_object_type_from_function(t, info, method.info, fallback, is_new)
+
+
+def is_valid_constructor(n: SymbolNode | None) -> bool:
+    """Does this node represents a valid constructor method?
+
+    This includes normal functions, overloaded functions, and decorators
+    that return a callable type.
+    """
+    if isinstance(n, SYMBOL_FUNCBASE_TYPES):
+        return True
+    if isinstance(n, Decorator):
+        return isinstance(get_proper_type(n.type), FunctionLike)
+    return False
+
+
 def type_object_type_from_function(
     signature: FunctionLike, info: TypeInfo, def_info: TypeInfo, fallback: Instance, is_new: bool
 ) -> FunctionLike:
@@ -955,7 +1041,7 @@ def try_expanding_sum_type_to_union(typ:
             FAILURE = 2
             UNKNOWN = 3
 
-    ...and if we call `try_expanding_enum_to_union(Union[Color, Status], 'module.Color')`,
+    ...and if we call `try_expanding_sum_type_to_union(Union[Color, Status], 'module.Color')`,
     this function will return Literal[Color.RED, Color.BLUE, Color.YELLOW, Status].
     """
     typ = get_proper_type(typ)
@@ -983,6 +1069,8 @@ def try_expanding_sum_type_to_union(typ:
 def try_contracting_literals_in_union(types: Sequence[Type]) -> list[ProperType]:
     """Contracts any literal types back into a sum type if possible.
 
+    Requires a flattened union and does not descend into children.
+
     Will replace the first instance of the literal with the sum type and
     remove all others.
 
@@ -1070,6 +1158,17 @@ class TypeVarExtractor(TypeQuery[list[Ty
         return [t] if self.include_all else []
 
 
+def freeze_all_type_vars(member_type: Type) -> None:
+    member_type.accept(FreezeTypeVarsVisitor())
+
+
+class FreezeTypeVarsVisitor(TypeTraverserVisitor):
+    def visit_callable_type(self, t: CallableType) -> None:
+        for v in t.variables:
+            v.id.meta_level = 0
+        super().visit_callable_type(t)
+
+
 def custom_special_method(typ: Type, name: str, check_all: bool = False) -> bool:
     """Does this type have a custom special method such as __format__() or __eq__()?
 
@@ -1147,10 +1246,11 @@ def fixup_partial_type(typ: Type) -> Typ
         return Instance(typ.type, [AnyType(TypeOfAny.unannotated)] * len(typ.type.type_vars))
 
 
-def get_protocol_member(left: Instance, member: str, class_obj: bool) -> ProperType | None:
+def get_protocol_member(
+    left: Instance, member: str, class_obj: bool, is_lvalue: bool = False
+) -> Type | None:
     if member == "__call__" and class_obj:
         # Special case: class objects always have __call__ that is just the constructor.
-        from mypy.checkmember import type_object_type
 
         def named_type(fullname: str) -> Instance:
             return Instance(left.type.mro[-1], [])
@@ -1164,4 +1264,13 @@ def get_protocol_member(left: Instance,
 
     from mypy.subtypes import find_member
 
-    return get_proper_type(find_member(member, left, left, class_obj=class_obj))
+    subtype = find_member(member, left, left, class_obj=class_obj, is_lvalue=is_lvalue)
+    if isinstance(subtype, PartialType):
+        subtype = (
+            NoneType()
+            if subtype.type is None
+            else Instance(
+                subtype.type, [AnyType(TypeOfAny.unannotated)] * len(subtype.type.type_vars)
+            )
+        )
+    return subtype
diff -pruN 1.15.0-5/mypy/types.py 1.16~rc0.1-1/mypy/types.py
--- 1.15.0-5/mypy/types.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/types.py	2025-05-27 17:21:15.000000000 +0000
@@ -130,6 +130,12 @@ LITERAL_TYPE_NAMES: Final = ("typing.Lit
 # Supported Annotated type names.
 ANNOTATED_TYPE_NAMES: Final = ("typing.Annotated", "typing_extensions.Annotated")
 
+# Supported Concatenate type names.
+CONCATENATE_TYPE_NAMES: Final = ("typing.Concatenate", "typing_extensions.Concatenate")
+
+# Supported Unpack type names.
+UNPACK_TYPE_NAMES: Final = ("typing.Unpack", "typing_extensions.Unpack")
+
 # Supported @deprecated type names
 DEPRECATED_TYPE_NAMES: Final = ("warnings.deprecated", "typing_extensions.deprecated")
 
@@ -2204,7 +2210,7 @@ class CallableType(FunctionLike):
                     new_unpack = nested_unpacked.args[0]
                 else:
                     if not isinstance(nested_unpacked, TypeVarTupleType):
-                        # We found a non-nomralized tuple type, this means this method
+                        # We found a non-normalized tuple type, this means this method
                         # is called during semantic analysis (e.g. from get_proper_type())
                         # there is no point in normalizing callables at this stage.
                         return self
@@ -3205,12 +3211,12 @@ def get_proper_types(types: list[Type] |
 
 @overload
 def get_proper_types(
-    types: list[Type | None] | tuple[Type | None, ...]
+    types: list[Type | None] | tuple[Type | None, ...],
 ) -> list[ProperType | None]: ...
 
 
 def get_proper_types(
-    types: list[Type] | list[Type | None] | tuple[Type | None, ...]
+    types: list[Type] | list[Type | None] | tuple[Type | None, ...],
 ) -> list[ProperType] | list[ProperType | None]:
     if isinstance(types, list):
         typelist = types
@@ -3314,12 +3320,7 @@ class TypeStrVisitor(SyntheticTypeVisito
         return s
 
     def visit_type_var(self, t: TypeVarType, /) -> str:
-        if t.name is None:
-            # Anonymous type variable type (only numeric id).
-            s = f"`{t.id}"
-        else:
-            # Named type variable type.
-            s = f"{t.name}`{t.id}"
+        s = f"{t.name}`{t.id}"
         if self.id_mapper and t.upper_bound:
             s += f"(upper_bound={t.upper_bound.accept(self)})"
         if t.has_default():
@@ -3331,12 +3332,7 @@ class TypeStrVisitor(SyntheticTypeVisito
         s = ""
         if t.prefix.arg_types:
             s += f"[{self.list_str(t.prefix.arg_types)}, **"
-        if t.name is None:
-            # Anonymous type variable type (only numeric id).
-            s += f"`{t.id}"
-        else:
-            # Named type variable type.
-            s += f"{t.name_with_suffix()}`{t.id}"
+        s += f"{t.name_with_suffix()}`{t.id}"
         if t.prefix.arg_types:
             s += "]"
         if t.has_default():
@@ -3373,12 +3369,7 @@ class TypeStrVisitor(SyntheticTypeVisito
         return f"[{s}]"
 
     def visit_type_var_tuple(self, t: TypeVarTupleType, /) -> str:
-        if t.name is None:
-            # Anonymous type variable type (only numeric id).
-            s = f"`{t.id}"
-        else:
-            # Named type variable type.
-            s = f"{t.name}`{t.id}"
+        s = f"{t.name}`{t.id}"
         if t.has_default():
             s += f" = {t.default.accept(self)}"
         return s
@@ -3735,7 +3726,7 @@ def find_unpack_in_list(items: Sequence[
     return unpack_index
 
 
-def flatten_nested_tuples(types: Sequence[Type]) -> list[Type]:
+def flatten_nested_tuples(types: Iterable[Type]) -> list[Type]:
     """Recursively flatten TupleTypes nested with Unpack.
 
     For example this will transform
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/_decimal.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/_decimal.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/_decimal.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/_decimal.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -27,14 +27,14 @@ _TrapType: TypeAlias = type[DecimalExcep
 __version__: Final[str]
 __libmpdec_version__: Final[str]
 
-ROUND_DOWN: Final[str]
-ROUND_HALF_UP: Final[str]
-ROUND_HALF_EVEN: Final[str]
-ROUND_CEILING: Final[str]
-ROUND_FLOOR: Final[str]
-ROUND_UP: Final[str]
-ROUND_HALF_DOWN: Final[str]
-ROUND_05UP: Final[str]
+ROUND_DOWN: Final = "ROUND_DOWN"
+ROUND_HALF_UP: Final = "ROUND_HALF_UP"
+ROUND_HALF_EVEN: Final = "ROUND_HALF_EVEN"
+ROUND_CEILING: Final = "ROUND_CEILING"
+ROUND_FLOOR: Final = "ROUND_FLOOR"
+ROUND_UP: Final = "ROUND_UP"
+ROUND_HALF_DOWN: Final = "ROUND_HALF_DOWN"
+ROUND_05UP: Final = "ROUND_05UP"
 HAVE_CONTEXTVAR: Final[bool]
 HAVE_THREADS: Final[bool]
 MAX_EMAX: Final[int]
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/_frozen_importlib_external.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/_frozen_importlib_external.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/_frozen_importlib_external.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/_frozen_importlib_external.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -26,8 +26,8 @@ else:
 
 MAGIC_NUMBER: bytes
 
-def cache_from_source(path: str, debug_override: bool | None = None, *, optimization: Any | None = None) -> str: ...
-def source_from_cache(path: str) -> str: ...
+def cache_from_source(path: StrPath, debug_override: bool | None = None, *, optimization: Any | None = None) -> str: ...
+def source_from_cache(path: StrPath) -> str: ...
 def decode_source(source_bytes: ReadableBuffer) -> str: ...
 def spec_from_file_location(
     name: str,
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/_hashlib.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/_hashlib.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/_hashlib.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/_hashlib.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -2,13 +2,26 @@ import sys
 from _typeshed import ReadableBuffer
 from collections.abc import Callable
 from types import ModuleType
-from typing import AnyStr, final, overload
+from typing import AnyStr, Protocol, final, overload, type_check_only
 from typing_extensions import Self, TypeAlias
 
-_DigestMod: TypeAlias = str | Callable[[], HASH] | ModuleType | None
+_DigestMod: TypeAlias = str | Callable[[], _HashObject] | ModuleType | None
 
 openssl_md_meth_names: frozenset[str]
 
+@type_check_only
+class _HashObject(Protocol):
+    @property
+    def digest_size(self) -> int: ...
+    @property
+    def block_size(self) -> int: ...
+    @property
+    def name(self) -> str: ...
+    def copy(self) -> Self: ...
+    def digest(self) -> bytes: ...
+    def hexdigest(self) -> str: ...
+    def update(self, obj: ReadableBuffer, /) -> None: ...
+
 class HASH:
     @property
     def digest_size(self) -> int: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/_socket.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/_socket.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/_socket.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/_socket.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -78,7 +78,7 @@ if sys.platform == "win32":
     SO_EXCLUSIVEADDRUSE: int
 if sys.platform != "win32":
     SO_REUSEPORT: int
-    if sys.platform != "darwin" or sys.version_info >= (3, 13):
+    if sys.platform != "darwin":
         SO_BINDTODEVICE: int
 
 if sys.platform != "win32" and sys.platform != "darwin":
@@ -812,12 +812,12 @@ def getaddrinfo(
     type: int = ...,
     proto: int = ...,
     flags: int = ...,
-) -> list[tuple[int, int, int, str, tuple[str, int] | tuple[str, int, int, int]]]: ...
+) -> list[tuple[int, int, int, str, tuple[str, int] | tuple[str, int, int, int] | tuple[int, bytes]]]: ...
 def gethostbyname(hostname: str, /) -> str: ...
 def gethostbyname_ex(hostname: str, /) -> tuple[str, list[str], list[str]]: ...
 def gethostname() -> str: ...
 def gethostbyaddr(ip_address: str, /) -> tuple[str, list[str], list[str]]: ...
-def getnameinfo(sockaddr: tuple[str, int] | tuple[str, int, int, int], flags: int, /) -> tuple[str, str]: ...
+def getnameinfo(sockaddr: tuple[str, int] | tuple[str, int, int, int] | tuple[int, bytes], flags: int, /) -> tuple[str, str]: ...
 def getprotobyname(protocolname: str, /) -> int: ...
 def getservbyname(servicename: str, protocolname: str = ..., /) -> int: ...
 def getservbyport(port: int, protocolname: str = ..., /) -> str: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/_typeshed/README.md 1.16~rc0.1-1/mypy/typeshed/stdlib/_typeshed/README.md
--- 1.15.0-5/mypy/typeshed/stdlib/_typeshed/README.md	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/_typeshed/README.md	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,34 @@
+# Utility types for typeshed
+
+This package and its submodules contains various common types used by
+typeshed. It can also be used by packages outside typeshed, but beware
+the API stability guarantees below.
+
+## Usage
+
+The `_typeshed` package and its types do not exist at runtime, but can be
+used freely in stubs (`.pyi`) files. To import the types from this package in
+implementation (`.py`) files, use the following construct:
+
+```python
+from typing import TYPE_CHECKING
+
+if TYPE_CHECKING:
+    from _typeshed import ...
+```
+
+Types can then be used in annotations by either quoting them or
+using:
+
+```python
+from __future__ import annotations
+```
+
+## API Stability
+
+You can use this package and its submodules outside of typeshed, but we
+guarantee only limited API stability. Items marked as "stable" will not be
+removed or changed in an incompatible way for at least one year.
+Before making such a change, the "stable" moniker will be removed
+and we will mark the type in question as deprecated. No guarantees
+are made about unmarked types.
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/_typeshed/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/_typeshed/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/_typeshed/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/_typeshed/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -3,6 +3,7 @@
 # See the README.md file in this directory for more information.
 
 import sys
+import typing_extensions
 from collections.abc import Awaitable, Callable, Iterable, Sequence, Set as AbstractSet, Sized
 from dataclasses import Field
 from os import PathLike
@@ -117,6 +118,12 @@ class SupportsSub(Protocol[_T_contra, _T
 class SupportsRSub(Protocol[_T_contra, _T_co]):
     def __rsub__(self, x: _T_contra, /) -> _T_co: ...
 
+class SupportsMul(Protocol[_T_contra, _T_co]):
+    def __mul__(self, x: _T_contra, /) -> _T_co: ...
+
+class SupportsRMul(Protocol[_T_contra, _T_co]):
+    def __rmul__(self, x: _T_contra, /) -> _T_co: ...
+
 class SupportsDivMod(Protocol[_T_contra, _T_co]):
     def __divmod__(self, other: _T_contra, /) -> _T_co: ...
 
@@ -151,11 +158,8 @@ class SupportsKeysAndGetItem(Protocol[_K
     def keys(self) -> Iterable[_KT]: ...
     def __getitem__(self, key: _KT, /) -> _VT_co: ...
 
-# This protocol is currently under discussion. Use SupportsContainsAndGetItem
-# instead, if you require the __contains__ method.
-# See https://github.com/python/typeshed/issues/11822.
+# stable
 class SupportsGetItem(Protocol[_KT_contra, _VT_co]):
-    def __contains__(self, x: Any, /) -> bool: ...
     def __getitem__(self, key: _KT_contra, /) -> _VT_co: ...
 
 # stable
@@ -325,9 +329,9 @@ class structseq(Generic[_T_co]):
     # The second parameter will accept a dict of any kind without raising an exception,
     # but only has any meaning if you supply it a dict where the keys are strings.
     # https://github.com/python/typeshed/pull/6560#discussion_r767149830
-    def __new__(cls: type[Self], sequence: Iterable[_T_co], dict: dict[str, Any] = ...) -> Self: ...
+    def __new__(cls, sequence: Iterable[_T_co], dict: dict[str, Any] = ...) -> typing_extensions.Self: ...
     if sys.version_info >= (3, 13):
-        def __replace__(self: Self, **kwargs: Any) -> Self: ...
+        def __replace__(self, **kwargs: Any) -> typing_extensions.Self: ...
 
 # Superset of typing.AnyStr that also includes LiteralString
 AnyOrLiteralStr = TypeVar("AnyOrLiteralStr", str, bytes, LiteralString)  # noqa: Y001
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/argparse.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/argparse.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/argparse.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/argparse.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -33,15 +33,6 @@ _ActionT = TypeVar("_ActionT", bound=Act
 _ArgumentParserT = TypeVar("_ArgumentParserT", bound=ArgumentParser)
 _N = TypeVar("_N")
 _ActionType: TypeAlias = Callable[[str], Any] | FileType | str
-# more precisely, Literal["store", "store_const", "store_true",
-# "store_false", "append", "append_const", "count", "help", "version",
-# "extend"], but using this would make it hard to annotate callers
-# that don't use a literal argument
-_ActionStr: TypeAlias = str
-# more precisely, Literal["?", "*", "+", "...", "A...",
-# "==SUPPRESS=="], but using this would make it hard to annotate
-# callers that don't use a literal argument
-_NArgsStr: TypeAlias = str
 
 ONE_OR_MORE: Final = "+"
 OPTIONAL: Final = "?"
@@ -51,7 +42,7 @@ _SUPPRESS_T = NewType("_SUPPRESS_T", str
 SUPPRESS: _SUPPRESS_T | str  # not using Literal because argparse sometimes compares SUPPRESS with is
 # the | str is there so that foo = argparse.SUPPRESS; foo = "test" checks out in mypy
 ZERO_OR_MORE: Final = "*"
-_UNRECOGNIZED_ARGS_ATTR: Final[str]  # undocumented
+_UNRECOGNIZED_ARGS_ATTR: Final = "_unrecognized_args"  # undocumented
 
 class ArgumentError(Exception):
     argument_name: str | None
@@ -86,8 +77,13 @@ class _ActionsContainer:
     def add_argument(
         self,
         *name_or_flags: str,
-        action: _ActionStr | type[Action] = ...,
-        nargs: int | _NArgsStr | _SUPPRESS_T | None = None,
+        # str covers predefined actions ("store_true", "count", etc.)
+        # and user registered actions via the `register` method.
+        action: str | type[Action] = ...,
+        # more precisely, Literal["?", "*", "+", "...", "A...", "==SUPPRESS=="],
+        # but using this would make it hard to annotate callers that don't use a
+        # literal argument and for subclasses to override this method.
+        nargs: int | str | _SUPPRESS_T | None = None,
         const: Any = ...,
         default: Any = ...,
         type: _ActionType = ...,
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/asyncio/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/asyncio/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,3 +1,5 @@
+# ruff: noqa: PLR5501 # This condition is so big, it's clearer to keep to platform condition in two blocks
+# Can't NOQA on a specific line: https://github.com/plinss/flake8-noqa/issues/22
 import sys
 from collections.abc import Awaitable, Coroutine, Generator
 from typing import Any, TypeVar
@@ -410,93 +412,6 @@ if sys.platform == "win32":
             "WindowsSelectorEventLoopPolicy",  # from windows_events
             "WindowsProactorEventLoopPolicy",  # from windows_events
         )
-    elif sys.version_info >= (3, 10):
-        __all__ = (
-            "BaseEventLoop",  # from base_events
-            "Server",  # from base_events
-            "coroutine",  # from coroutines
-            "iscoroutinefunction",  # from coroutines
-            "iscoroutine",  # from coroutines
-            "AbstractEventLoopPolicy",  # from events
-            "AbstractEventLoop",  # from events
-            "AbstractServer",  # from events
-            "Handle",  # from events
-            "TimerHandle",  # from events
-            "get_event_loop_policy",  # from events
-            "set_event_loop_policy",  # from events
-            "get_event_loop",  # from events
-            "set_event_loop",  # from events
-            "new_event_loop",  # from events
-            "get_child_watcher",  # from events
-            "set_child_watcher",  # from events
-            "_set_running_loop",  # from events
-            "get_running_loop",  # from events
-            "_get_running_loop",  # from events
-            "CancelledError",  # from exceptions
-            "InvalidStateError",  # from exceptions
-            "TimeoutError",  # from exceptions
-            "IncompleteReadError",  # from exceptions
-            "LimitOverrunError",  # from exceptions
-            "SendfileNotAvailableError",  # from exceptions
-            "Future",  # from futures
-            "wrap_future",  # from futures
-            "isfuture",  # from futures
-            "Lock",  # from locks
-            "Event",  # from locks
-            "Condition",  # from locks
-            "Semaphore",  # from locks
-            "BoundedSemaphore",  # from locks
-            "BaseProtocol",  # from protocols
-            "Protocol",  # from protocols
-            "DatagramProtocol",  # from protocols
-            "SubprocessProtocol",  # from protocols
-            "BufferedProtocol",  # from protocols
-            "run",  # from runners
-            "Queue",  # from queues
-            "PriorityQueue",  # from queues
-            "LifoQueue",  # from queues
-            "QueueFull",  # from queues
-            "QueueEmpty",  # from queues
-            "StreamReader",  # from streams
-            "StreamWriter",  # from streams
-            "StreamReaderProtocol",  # from streams
-            "open_connection",  # from streams
-            "start_server",  # from streams
-            "create_subprocess_exec",  # from subprocess
-            "create_subprocess_shell",  # from subprocess
-            "Task",  # from tasks
-            "create_task",  # from tasks
-            "FIRST_COMPLETED",  # from tasks
-            "FIRST_EXCEPTION",  # from tasks
-            "ALL_COMPLETED",  # from tasks
-            "wait",  # from tasks
-            "wait_for",  # from tasks
-            "as_completed",  # from tasks
-            "sleep",  # from tasks
-            "gather",  # from tasks
-            "shield",  # from tasks
-            "ensure_future",  # from tasks
-            "run_coroutine_threadsafe",  # from tasks
-            "current_task",  # from tasks
-            "all_tasks",  # from tasks
-            "_register_task",  # from tasks
-            "_unregister_task",  # from tasks
-            "_enter_task",  # from tasks
-            "_leave_task",  # from tasks
-            "to_thread",  # from threads
-            "BaseTransport",  # from transports
-            "ReadTransport",  # from transports
-            "WriteTransport",  # from transports
-            "Transport",  # from transports
-            "DatagramTransport",  # from transports
-            "SubprocessTransport",  # from transports
-            "SelectorEventLoop",  # from windows_events
-            "ProactorEventLoop",  # from windows_events
-            "IocpProactor",  # from windows_events
-            "DefaultEventLoopPolicy",  # from windows_events
-            "WindowsSelectorEventLoopPolicy",  # from windows_events
-            "WindowsProactorEventLoopPolicy",  # from windows_events
-        )
     elif sys.version_info >= (3, 9):
         __all__ = (
             "BaseEventLoop",  # from base_events
@@ -1047,97 +962,6 @@ else:
             "BaseTransport",  # from transports
             "ReadTransport",  # from transports
             "WriteTransport",  # from transports
-            "Transport",  # from transports
-            "DatagramTransport",  # from transports
-            "SubprocessTransport",  # from transports
-            "SelectorEventLoop",  # from unix_events
-            "AbstractChildWatcher",  # from unix_events
-            "SafeChildWatcher",  # from unix_events
-            "FastChildWatcher",  # from unix_events
-            "PidfdChildWatcher",  # from unix_events
-            "MultiLoopChildWatcher",  # from unix_events
-            "ThreadedChildWatcher",  # from unix_events
-            "DefaultEventLoopPolicy",  # from unix_events
-        )
-    elif sys.version_info >= (3, 10):
-        __all__ = (
-            "BaseEventLoop",  # from base_events
-            "Server",  # from base_events
-            "coroutine",  # from coroutines
-            "iscoroutinefunction",  # from coroutines
-            "iscoroutine",  # from coroutines
-            "AbstractEventLoopPolicy",  # from events
-            "AbstractEventLoop",  # from events
-            "AbstractServer",  # from events
-            "Handle",  # from events
-            "TimerHandle",  # from events
-            "get_event_loop_policy",  # from events
-            "set_event_loop_policy",  # from events
-            "get_event_loop",  # from events
-            "set_event_loop",  # from events
-            "new_event_loop",  # from events
-            "get_child_watcher",  # from events
-            "set_child_watcher",  # from events
-            "_set_running_loop",  # from events
-            "get_running_loop",  # from events
-            "_get_running_loop",  # from events
-            "CancelledError",  # from exceptions
-            "InvalidStateError",  # from exceptions
-            "TimeoutError",  # from exceptions
-            "IncompleteReadError",  # from exceptions
-            "LimitOverrunError",  # from exceptions
-            "SendfileNotAvailableError",  # from exceptions
-            "Future",  # from futures
-            "wrap_future",  # from futures
-            "isfuture",  # from futures
-            "Lock",  # from locks
-            "Event",  # from locks
-            "Condition",  # from locks
-            "Semaphore",  # from locks
-            "BoundedSemaphore",  # from locks
-            "BaseProtocol",  # from protocols
-            "Protocol",  # from protocols
-            "DatagramProtocol",  # from protocols
-            "SubprocessProtocol",  # from protocols
-            "BufferedProtocol",  # from protocols
-            "run",  # from runners
-            "Queue",  # from queues
-            "PriorityQueue",  # from queues
-            "LifoQueue",  # from queues
-            "QueueFull",  # from queues
-            "QueueEmpty",  # from queues
-            "StreamReader",  # from streams
-            "StreamWriter",  # from streams
-            "StreamReaderProtocol",  # from streams
-            "open_connection",  # from streams
-            "start_server",  # from streams
-            "open_unix_connection",  # from streams
-            "start_unix_server",  # from streams
-            "create_subprocess_exec",  # from subprocess
-            "create_subprocess_shell",  # from subprocess
-            "Task",  # from tasks
-            "create_task",  # from tasks
-            "FIRST_COMPLETED",  # from tasks
-            "FIRST_EXCEPTION",  # from tasks
-            "ALL_COMPLETED",  # from tasks
-            "wait",  # from tasks
-            "wait_for",  # from tasks
-            "as_completed",  # from tasks
-            "sleep",  # from tasks
-            "gather",  # from tasks
-            "shield",  # from tasks
-            "ensure_future",  # from tasks
-            "run_coroutine_threadsafe",  # from tasks
-            "current_task",  # from tasks
-            "all_tasks",  # from tasks
-            "_register_task",  # from tasks
-            "_unregister_task",  # from tasks
-            "_enter_task",  # from tasks
-            "_leave_task",  # from tasks
-            "to_thread",  # from threads
-            "BaseTransport",  # from transports
-            "ReadTransport",  # from transports
-            "WriteTransport",  # from transports
             "Transport",  # from transports
             "DatagramTransport",  # from transports
             "SubprocessTransport",  # from transports
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/asyncio/base_events.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/base_events.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/asyncio/base_events.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/base_events.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -8,6 +8,7 @@ from asyncio.protocols import BaseProtoc
 from asyncio.tasks import Task
 from asyncio.transports import BaseTransport, DatagramTransport, ReadTransport, SubprocessTransport, Transport, WriteTransport
 from collections.abc import Callable, Iterable, Sequence
+from concurrent.futures import Executor, ThreadPoolExecutor
 from contextvars import Context
 from socket import AddressFamily, SocketKind, _Address, _RetAddress, socket
 from typing import IO, Any, Literal, TypeVar, overload
@@ -96,8 +97,8 @@ class BaseEventLoop(AbstractEventLoop):
     def call_soon_threadsafe(
         self, callback: Callable[[Unpack[_Ts]], object], *args: Unpack[_Ts], context: Context | None = None
     ) -> Handle: ...
-    def run_in_executor(self, executor: Any, func: Callable[[Unpack[_Ts]], _T], *args: Unpack[_Ts]) -> Future[_T]: ...
-    def set_default_executor(self, executor: Any) -> None: ...
+    def run_in_executor(self, executor: Executor | None, func: Callable[[Unpack[_Ts]], _T], *args: Unpack[_Ts]) -> Future[_T]: ...
+    def set_default_executor(self, executor: ThreadPoolExecutor) -> None: ...  # type: ignore[override]
     # Network I/O methods returning Futures.
     async def getaddrinfo(
         self,
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/asyncio/events.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/events.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/asyncio/events.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/events.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -9,6 +9,7 @@ from _asyncio import (
 from _typeshed import FileDescriptorLike, ReadableBuffer, StrPath, Unused, WriteableBuffer
 from abc import ABCMeta, abstractmethod
 from collections.abc import Callable, Sequence
+from concurrent.futures import Executor
 from contextvars import Context
 from socket import AddressFamily, SocketKind, _Address, _RetAddress, socket
 from typing import IO, Any, Literal, Protocol, TypeVar, overload
@@ -188,9 +189,9 @@ class AbstractEventLoop:
         def call_soon_threadsafe(self, callback: Callable[[Unpack[_Ts]], object], *args: Unpack[_Ts]) -> Handle: ...
 
     @abstractmethod
-    def run_in_executor(self, executor: Any, func: Callable[[Unpack[_Ts]], _T], *args: Unpack[_Ts]) -> Future[_T]: ...
+    def run_in_executor(self, executor: Executor | None, func: Callable[[Unpack[_Ts]], _T], *args: Unpack[_Ts]) -> Future[_T]: ...
     @abstractmethod
-    def set_default_executor(self, executor: Any) -> None: ...
+    def set_default_executor(self, executor: Executor) -> None: ...
     # Network I/O methods returning Futures.
     @abstractmethod
     async def getaddrinfo(
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/asyncio/sslproto.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/sslproto.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/asyncio/sslproto.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/sslproto.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -76,7 +76,7 @@ class _SSLProtocolTransport(transports._
     def get_extra_info(self, name: str, default: Any | None = None) -> dict[str, Any]: ...
     @property
     def _protocol_paused(self) -> bool: ...
-    def write(self, data: bytes | bytearray | memoryview) -> None: ...
+    def write(self, data: bytes | bytearray | memoryview[Any]) -> None: ...  # any memoryview format or shape
     def can_write_eof(self) -> Literal[False]: ...
     if sys.version_info >= (3, 11):
         def get_write_buffer_limits(self) -> tuple[int, int]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/asyncio/tasks.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/tasks.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/asyncio/tasks.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/tasks.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -79,6 +79,7 @@ if sys.version_info >= (3, 12):
     _FutureLike: TypeAlias = Future[_T] | Awaitable[_T]
 else:
     _FutureLike: TypeAlias = Future[_T] | Generator[Any, None, _T] | Awaitable[_T]
+
 _TaskYieldType: TypeAlias = Future[object] | None
 
 FIRST_COMPLETED = concurrent.futures.FIRST_COMPLETED
@@ -347,7 +348,8 @@ else:
         *coros_or_futures: _FutureLike[_T], loop: AbstractEventLoop | None = None, return_exceptions: bool
     ) -> Future[list[_T | BaseException]]: ...
 
-def run_coroutine_threadsafe(coro: _FutureLike[_T], loop: AbstractEventLoop) -> concurrent.futures.Future[_T]: ...
+# unlike some asyncio apis, This does strict runtime checking of actually being a coroutine, not of any future-like.
+def run_coroutine_threadsafe(coro: Coroutine[Any, Any, _T], loop: AbstractEventLoop) -> concurrent.futures.Future[_T]: ...
 
 if sys.version_info >= (3, 10):
     def shield(arg: _FutureLike[_T]) -> Future[_T]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/asyncio/transports.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/transports.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/asyncio/transports.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/asyncio/transports.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -24,8 +24,10 @@ class WriteTransport(BaseTransport):
     def set_write_buffer_limits(self, high: int | None = None, low: int | None = None) -> None: ...
     def get_write_buffer_size(self) -> int: ...
     def get_write_buffer_limits(self) -> tuple[int, int]: ...
-    def write(self, data: bytes | bytearray | memoryview) -> None: ...
-    def writelines(self, list_of_data: Iterable[bytes | bytearray | memoryview]) -> None: ...
+    def write(self, data: bytes | bytearray | memoryview[Any]) -> None: ...  # any memoryview format or shape
+    def writelines(
+        self, list_of_data: Iterable[bytes | bytearray | memoryview[Any]]
+    ) -> None: ...  # any memoryview format or shape
     def write_eof(self) -> None: ...
     def can_write_eof(self) -> bool: ...
     def abort(self) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/bdb.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/bdb.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/bdb.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/bdb.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,6 +1,7 @@
 import sys
 from _typeshed import ExcInfo, TraceFunction, Unused
-from collections.abc import Callable, Iterable, Mapping
+from collections.abc import Callable, Iterable, Iterator, Mapping
+from contextlib import contextmanager
 from types import CodeType, FrameType, TracebackType
 from typing import IO, Any, Final, SupportsInt, TypeVar
 from typing_extensions import ParamSpec
@@ -30,6 +31,10 @@ class Bdb:
     def __init__(self, skip: Iterable[str] | None = None) -> None: ...
     def canonic(self, filename: str) -> str: ...
     def reset(self) -> None: ...
+    if sys.version_info >= (3, 12):
+        @contextmanager
+        def set_enterframe(self, frame: FrameType) -> Iterator[None]: ...
+
     def trace_dispatch(self, frame: FrameType, event: str, arg: Any) -> TraceFunction: ...
     def dispatch_line(self, frame: FrameType) -> TraceFunction: ...
     def dispatch_call(self, frame: FrameType, arg: None) -> TraceFunction: ...
@@ -73,7 +78,7 @@ class Bdb:
     def get_file_breaks(self, filename: str) -> list[Breakpoint]: ...
     def get_all_breaks(self) -> list[Breakpoint]: ...
     def get_stack(self, f: FrameType | None, t: TracebackType | None) -> tuple[list[tuple[FrameType, int]], int]: ...
-    def format_stack_entry(self, frame_lineno: int, lprefix: str = ": ") -> str: ...
+    def format_stack_entry(self, frame_lineno: tuple[FrameType, int], lprefix: str = ": ") -> str: ...
     def run(
         self, cmd: str | CodeType, globals: dict[str, Any] | None = None, locals: Mapping[str, Any] | None = None
     ) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/builtins.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/builtins.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/builtins.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/builtins.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,4 +1,3 @@
-# ruff: noqa: PYI036 # This is the module declaring BaseException
 import _ast
 import _sitebuiltins
 import _typeshed
@@ -10,7 +9,6 @@ from _typeshed import (
     ConvertibleToFloat,
     ConvertibleToInt,
     FileDescriptorOrPath,
-    MaybeNone,
     OpenBinaryMode,
     OpenBinaryModeReading,
     OpenBinaryModeUpdating,
@@ -89,14 +87,19 @@ _T2 = TypeVar("_T2")
 _T3 = TypeVar("_T3")
 _T4 = TypeVar("_T4")
 _T5 = TypeVar("_T5")
-_SupportsNextT = TypeVar("_SupportsNextT", bound=SupportsNext[Any], covariant=True)
-_SupportsAnextT = TypeVar("_SupportsAnextT", bound=SupportsAnext[Any], covariant=True)
+_SupportsNextT_co = TypeVar("_SupportsNextT_co", bound=SupportsNext[Any], covariant=True)
+_SupportsAnextT_co = TypeVar("_SupportsAnextT_co", bound=SupportsAnext[Any], covariant=True)
 _AwaitableT = TypeVar("_AwaitableT", bound=Awaitable[Any])
 _AwaitableT_co = TypeVar("_AwaitableT_co", bound=Awaitable[Any], covariant=True)
 _P = ParamSpec("_P")
-_StartT = TypeVar("_StartT", covariant=True, default=Any)
-_StopT = TypeVar("_StopT", covariant=True, default=Any)
-_StepT = TypeVar("_StepT", covariant=True, default=Any)
+
+# Type variables for slice
+_StartT_co = TypeVar("_StartT_co", covariant=True, default=Any)  # slice -> slice[Any, Any, Any]
+_StopT_co = TypeVar("_StopT_co", covariant=True, default=_StartT_co)  #  slice[A] -> slice[A, A, A]
+# NOTE: step could differ from start and stop, (e.g. datetime/timedelta)l
+#   the default (start|stop) is chosen to cater to the most common case of int/index slices.
+# FIXME: https://github.com/python/typing/issues/213 (replace step=start|stop with step=start&stop)
+_StepT_co = TypeVar("_StepT_co", covariant=True, default=_StartT_co | _StopT_co)  #  slice[A,B] -> slice[A, B, A|B]
 
 class object:
     __doc__: str | None
@@ -768,7 +771,11 @@ class memoryview(Sequence[_I]):
     def __new__(cls, obj: ReadableBuffer) -> Self: ...
     def __enter__(self) -> Self: ...
     def __exit__(
-        self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None, /
+        self,
+        exc_type: type[BaseException] | None,  # noqa: PYI036 # This is the module declaring BaseException
+        exc_val: BaseException | None,
+        exc_tb: TracebackType | None,
+        /,
     ) -> None: ...
     @overload
     def cast(self, format: Literal["c", "@c"], shape: list[int] | tuple[int, ...] = ...) -> memoryview[bytes]: ...
@@ -842,23 +849,35 @@ class bool(int):
     def __invert__(self) -> int: ...
 
 @final
-class slice(Generic[_StartT, _StopT, _StepT]):
+class slice(Generic[_StartT_co, _StopT_co, _StepT_co]):
     @property
-    def start(self) -> _StartT: ...
+    def start(self) -> _StartT_co: ...
     @property
-    def step(self) -> _StepT: ...
+    def step(self) -> _StepT_co: ...
     @property
-    def stop(self) -> _StopT: ...
+    def stop(self) -> _StopT_co: ...
+    # Note: __new__ overloads map `None` to `Any`, since users expect slice(x, None)
+    #  to be compatible with slice(None, x).
+    # generic slice --------------------------------------------------------------------
     @overload
-    def __new__(cls, stop: int | None, /) -> slice[int | MaybeNone, int | MaybeNone, int | MaybeNone]: ...
-    @overload
-    def __new__(
-        cls, start: int | None, stop: int | None, step: int | None = None, /
-    ) -> slice[int | MaybeNone, int | MaybeNone, int | MaybeNone]: ...
+    def __new__(cls, start: None, stop: None = None, step: None = None, /) -> slice[Any, Any, Any]: ...
+    # unary overloads ------------------------------------------------------------------
     @overload
     def __new__(cls, stop: _T2, /) -> slice[Any, _T2, Any]: ...
+    # binary overloads -----------------------------------------------------------------
+    @overload
+    def __new__(cls, start: _T1, stop: None, step: None = None, /) -> slice[_T1, Any, Any]: ...
+    @overload
+    def __new__(cls, start: None, stop: _T2, step: None = None, /) -> slice[Any, _T2, Any]: ...
+    @overload
+    def __new__(cls, start: _T1, stop: _T2, step: None = None, /) -> slice[_T1, _T2, Any]: ...
+    # ternary overloads ----------------------------------------------------------------
+    @overload
+    def __new__(cls, start: None, stop: None, step: _T3, /) -> slice[Any, Any, _T3]: ...
+    @overload
+    def __new__(cls, start: _T1, stop: None, step: _T3, /) -> slice[_T1, Any, _T3]: ...
     @overload
-    def __new__(cls, start: _T1, stop: _T2, /) -> slice[_T1, _T2, Any]: ...
+    def __new__(cls, start: None, stop: _T2, step: _T3, /) -> slice[Any, _T2, _T3]: ...
     @overload
     def __new__(cls, start: _T1, stop: _T2, step: _T3, /) -> slice[_T1, _T2, _T3]: ...
     def __eq__(self, value: object, /) -> bool: ...
@@ -1026,7 +1045,7 @@ class dict(MutableMapping[_KT, _VT]):
     def fromkeys(cls, iterable: Iterable[_T], value: _S, /) -> dict[_T, _S]: ...
     # Positional-only in dict, but not in MutableMapping
     @overload  # type: ignore[override]
-    def get(self, key: _KT, /) -> _VT | None: ...
+    def get(self, key: _KT, default: None = None, /) -> _VT | None: ...
     @overload
     def get(self, key: _KT, default: _VT, /) -> _VT: ...
     @overload
@@ -1197,7 +1216,7 @@ def ascii(obj: object, /) -> str: ...
 def bin(number: int | SupportsIndex, /) -> str: ...
 def breakpoint(*args: Any, **kws: Any) -> None: ...
 def callable(obj: object, /) -> TypeIs[Callable[..., object]]: ...
-def chr(i: int, /) -> str: ...
+def chr(i: int | SupportsIndex, /) -> str: ...
 
 # We define this here instead of using os.PathLike to avoid import cycle issues.
 # See https://github.com/python/typeshed/pull/991#issuecomment-288160993
@@ -1205,7 +1224,7 @@ class _PathLike(Protocol[AnyStr_co]):
     def __fspath__(self) -> AnyStr_co: ...
 
 if sys.version_info >= (3, 10):
-    def aiter(async_iterable: SupportsAiter[_SupportsAnextT], /) -> _SupportsAnextT: ...
+    def aiter(async_iterable: SupportsAiter[_SupportsAnextT_co], /) -> _SupportsAnextT_co: ...
 
     class _SupportsSynchronousAnext(Protocol[_AwaitableT_co]):
         def __anext__(self) -> _AwaitableT_co: ...
@@ -1367,7 +1386,7 @@ class _GetItemIterable(Protocol[_T_co]):
     def __getitem__(self, i: int, /) -> _T_co: ...
 
 @overload
-def iter(object: SupportsIter[_SupportsNextT], /) -> _SupportsNextT: ...
+def iter(object: SupportsIter[_SupportsNextT_co], /) -> _SupportsNextT_co: ...
 @overload
 def iter(object: _GetItemIterable[_T], /) -> Iterator[_T]: ...
 @overload
@@ -1574,17 +1593,17 @@ def print(
     *values: object, sep: str | None = " ", end: str | None = "\n", file: _SupportsWriteAndFlush[str] | None = None, flush: bool
 ) -> None: ...
 
-_E = TypeVar("_E", contravariant=True)
-_M = TypeVar("_M", contravariant=True)
+_E_contra = TypeVar("_E_contra", contravariant=True)
+_M_contra = TypeVar("_M_contra", contravariant=True)
 
-class _SupportsPow2(Protocol[_E, _T_co]):
-    def __pow__(self, other: _E, /) -> _T_co: ...
+class _SupportsPow2(Protocol[_E_contra, _T_co]):
+    def __pow__(self, other: _E_contra, /) -> _T_co: ...
 
-class _SupportsPow3NoneOnly(Protocol[_E, _T_co]):
-    def __pow__(self, other: _E, modulo: None = None, /) -> _T_co: ...
+class _SupportsPow3NoneOnly(Protocol[_E_contra, _T_co]):
+    def __pow__(self, other: _E_contra, modulo: None = None, /) -> _T_co: ...
 
-class _SupportsPow3(Protocol[_E, _M, _T_co]):
-    def __pow__(self, other: _E, modulo: _M, /) -> _T_co: ...
+class _SupportsPow3(Protocol[_E_contra, _M_contra, _T_co]):
+    def __pow__(self, other: _E_contra, modulo: _M_contra, /) -> _T_co: ...
 
 _SupportsSomeKindOfPow = (  # noqa: Y026  # TODO: Use TypeAlias once mypy bugs are fixed
     _SupportsPow2[Any, Any] | _SupportsPow3NoneOnly[Any, Any] | _SupportsPow3[Any, Any, Any]
@@ -1620,11 +1639,11 @@ def pow(base: float, exp: complex | _Sup
 @overload
 def pow(base: complex, exp: complex | _SupportsSomeKindOfPow, mod: None = None) -> complex: ...
 @overload
-def pow(base: _SupportsPow2[_E, _T_co], exp: _E, mod: None = None) -> _T_co: ...  # type: ignore[overload-overlap]
+def pow(base: _SupportsPow2[_E_contra, _T_co], exp: _E_contra, mod: None = None) -> _T_co: ...  # type: ignore[overload-overlap]
 @overload
-def pow(base: _SupportsPow3NoneOnly[_E, _T_co], exp: _E, mod: None = None) -> _T_co: ...  # type: ignore[overload-overlap]
+def pow(base: _SupportsPow3NoneOnly[_E_contra, _T_co], exp: _E_contra, mod: None = None) -> _T_co: ...  # type: ignore[overload-overlap]
 @overload
-def pow(base: _SupportsPow3[_E, _M, _T_co], exp: _E, mod: _M) -> _T_co: ...
+def pow(base: _SupportsPow3[_E_contra, _M_contra, _T_co], exp: _E_contra, mod: _M_contra) -> _T_co: ...
 @overload
 def pow(base: _SupportsSomeKindOfPow, exp: float, mod: None = None) -> Any: ...
 @overload
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/cmath.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/cmath.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/cmath.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/cmath.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,13 +1,13 @@
-from typing import SupportsComplex, SupportsFloat, SupportsIndex
+from typing import Final, SupportsComplex, SupportsFloat, SupportsIndex
 from typing_extensions import TypeAlias
 
-e: float
-pi: float
-inf: float
-infj: complex
-nan: float
-nanj: complex
-tau: float
+e: Final[float]
+pi: Final[float]
+inf: Final[float]
+infj: Final[complex]
+nan: Final[float]
+nanj: Final[complex]
+tau: Final[float]
 
 _C: TypeAlias = SupportsFloat | SupportsComplex | SupportsIndex | complex
 
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/codecs.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/codecs.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/codecs.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/codecs.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -3,8 +3,8 @@ from _codecs import *
 from _typeshed import ReadableBuffer
 from abc import abstractmethod
 from collections.abc import Callable, Generator, Iterable
-from typing import Any, BinaryIO, ClassVar, Final, Literal, Protocol, TextIO
-from typing_extensions import Self
+from typing import Any, BinaryIO, ClassVar, Final, Literal, Protocol, TextIO, overload
+from typing_extensions import Self, TypeAlias
 
 __all__ = [
     "register",
@@ -58,6 +58,21 @@ BOM32_LE: Final = b"\xff\xfe"
 BOM64_BE: Final = b"\x00\x00\xfe\xff"
 BOM64_LE: Final = b"\xff\xfe\x00\x00"
 
+_BufferedEncoding: TypeAlias = Literal[
+    "idna",
+    "raw-unicode-escape",
+    "unicode-escape",
+    "utf-16",
+    "utf-16-be",
+    "utf-16-le",
+    "utf-32",
+    "utf-32-be",
+    "utf-32-le",
+    "utf-7",
+    "utf-8",
+    "utf-8-sig",
+]
+
 class _WritableStream(Protocol):
     def write(self, data: bytes, /) -> object: ...
     def seek(self, offset: int, whence: int, /) -> object: ...
@@ -94,6 +109,9 @@ class _IncrementalEncoder(Protocol):
 class _IncrementalDecoder(Protocol):
     def __call__(self, errors: str = ...) -> IncrementalDecoder: ...
 
+class _BufferedIncrementalDecoder(Protocol):
+    def __call__(self, errors: str = ...) -> BufferedIncrementalDecoder: ...
+
 class CodecInfo(tuple[_Encoder, _Decoder, _StreamReader, _StreamWriter]):
     _is_text_encoding: bool
     @property
@@ -125,6 +143,9 @@ class CodecInfo(tuple[_Encoder, _Decoder
 def getencoder(encoding: str) -> _Encoder: ...
 def getdecoder(encoding: str) -> _Decoder: ...
 def getincrementalencoder(encoding: str) -> _IncrementalEncoder: ...
+@overload
+def getincrementaldecoder(encoding: _BufferedEncoding) -> _BufferedIncrementalDecoder: ...
+@overload
 def getincrementaldecoder(encoding: str) -> _IncrementalDecoder: ...
 def getreader(encoding: str) -> _StreamReader: ...
 def getwriter(encoding: str) -> _StreamWriter: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/compileall.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/compileall.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/compileall.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/compileall.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -25,7 +25,7 @@ if sys.version_info >= (3, 10):
         prependdir: StrPath | None = None,
         limit_sl_dest: StrPath | None = None,
         hardlink_dupes: bool = False,
-    ) -> int: ...
+    ) -> bool: ...
     def compile_file(
         fullname: StrPath,
         ddir: StrPath | None = None,
@@ -40,7 +40,7 @@ if sys.version_info >= (3, 10):
         prependdir: StrPath | None = None,
         limit_sl_dest: StrPath | None = None,
         hardlink_dupes: bool = False,
-    ) -> int: ...
+    ) -> bool: ...
 
 elif sys.version_info >= (3, 9):
     def compile_dir(
@@ -59,7 +59,7 @@ elif sys.version_info >= (3, 9):
         prependdir: StrPath | None = None,
         limit_sl_dest: StrPath | None = None,
         hardlink_dupes: bool = False,
-    ) -> int: ...
+    ) -> bool: ...
     def compile_file(
         fullname: StrPath,
         ddir: StrPath | None = None,
@@ -74,7 +74,7 @@ elif sys.version_info >= (3, 9):
         prependdir: StrPath | None = None,
         limit_sl_dest: StrPath | None = None,
         hardlink_dupes: bool = False,
-    ) -> int: ...
+    ) -> bool: ...
 
 else:
     def compile_dir(
@@ -88,7 +88,7 @@ else:
         optimize: int = -1,
         workers: int = 1,
         invalidation_mode: PycInvalidationMode | None = None,
-    ) -> int: ...
+    ) -> bool: ...
     def compile_file(
         fullname: StrPath,
         ddir: StrPath | None = None,
@@ -98,7 +98,7 @@ else:
         legacy: bool = False,
         optimize: int = -1,
         invalidation_mode: PycInvalidationMode | None = None,
-    ) -> int: ...
+    ) -> bool: ...
 
 def compile_path(
     skip_curdir: bool = ...,
@@ -108,4 +108,4 @@ def compile_path(
     legacy: bool = False,
     optimize: int = -1,
     invalidation_mode: PycInvalidationMode | None = None,
-) -> int: ...
+) -> bool: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/configparser.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/configparser.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/configparser.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/configparser.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -77,6 +77,19 @@ else:
         "MAX_INTERPOLATION_DEPTH",
     ]
 
+if sys.version_info >= (3, 13):
+    class _UNNAMED_SECTION: ...
+    UNNAMED_SECTION: _UNNAMED_SECTION
+
+    _SectionName: TypeAlias = str | _UNNAMED_SECTION
+    # A list of sections can only include an unnamed section if the parser was initialized with
+    # allow_unnamed_section=True. Any prevents users from having to use explicit
+    # type checks if allow_unnamed_section is False (the default).
+    _SectionNameList: TypeAlias = list[Any]
+else:
+    _SectionName: TypeAlias = str
+    _SectionNameList: TypeAlias = list[str]
+
 _Section: TypeAlias = Mapping[str, str]
 _Parser: TypeAlias = MutableMapping[str, _Section]
 _ConverterCallback: TypeAlias = Callable[[str], Any]
@@ -87,17 +100,17 @@ DEFAULTSECT: Final = "DEFAULT"
 MAX_INTERPOLATION_DEPTH: Final = 10
 
 class Interpolation:
-    def before_get(self, parser: _Parser, section: str, option: str, value: str, defaults: _Section) -> str: ...
-    def before_set(self, parser: _Parser, section: str, option: str, value: str) -> str: ...
-    def before_read(self, parser: _Parser, section: str, option: str, value: str) -> str: ...
-    def before_write(self, parser: _Parser, section: str, option: str, value: str) -> str: ...
+    def before_get(self, parser: _Parser, section: _SectionName, option: str, value: str, defaults: _Section) -> str: ...
+    def before_set(self, parser: _Parser, section: _SectionName, option: str, value: str) -> str: ...
+    def before_read(self, parser: _Parser, section: _SectionName, option: str, value: str) -> str: ...
+    def before_write(self, parser: _Parser, section: _SectionName, option: str, value: str) -> str: ...
 
 class BasicInterpolation(Interpolation): ...
 class ExtendedInterpolation(Interpolation): ...
 
 if sys.version_info < (3, 13):
     class LegacyInterpolation(Interpolation):
-        def before_get(self, parser: _Parser, section: str, option: str, value: str, vars: _Section) -> str: ...
+        def before_get(self, parser: _Parser, section: _SectionName, option: str, value: str, vars: _Section) -> str: ...
 
 class RawConfigParser(_Parser):
     _SECT_TMPL: ClassVar[str]  # undocumented
@@ -220,11 +233,11 @@ class RawConfigParser(_Parser):
     def __iter__(self) -> Iterator[str]: ...
     def __contains__(self, key: object) -> bool: ...
     def defaults(self) -> _Section: ...
-    def sections(self) -> list[str]: ...
-    def add_section(self, section: str) -> None: ...
-    def has_section(self, section: str) -> bool: ...
-    def options(self, section: str) -> list[str]: ...
-    def has_option(self, section: str, option: str) -> bool: ...
+    def sections(self) -> _SectionNameList: ...
+    def add_section(self, section: _SectionName) -> None: ...
+    def has_section(self, section: _SectionName) -> bool: ...
+    def options(self, section: _SectionName) -> list[str]: ...
+    def has_option(self, section: _SectionName, option: str) -> bool: ...
     def read(self, filenames: StrOrBytesPath | Iterable[StrOrBytesPath], encoding: str | None = None) -> list[str]: ...
     def read_file(self, f: Iterable[str], source: str | None = None) -> None: ...
     def read_string(self, string: str, source: str = "<string>") -> None: ...
@@ -234,26 +247,26 @@ class RawConfigParser(_Parser):
     # These get* methods are partially applied (with the same names) in
     # SectionProxy; the stubs should be kept updated together
     @overload
-    def getint(self, section: str, option: str, *, raw: bool = False, vars: _Section | None = None) -> int: ...
+    def getint(self, section: _SectionName, option: str, *, raw: bool = False, vars: _Section | None = None) -> int: ...
     @overload
     def getint(
-        self, section: str, option: str, *, raw: bool = False, vars: _Section | None = None, fallback: _T = ...
+        self, section: _SectionName, option: str, *, raw: bool = False, vars: _Section | None = None, fallback: _T = ...
     ) -> int | _T: ...
     @overload
-    def getfloat(self, section: str, option: str, *, raw: bool = False, vars: _Section | None = None) -> float: ...
+    def getfloat(self, section: _SectionName, option: str, *, raw: bool = False, vars: _Section | None = None) -> float: ...
     @overload
     def getfloat(
-        self, section: str, option: str, *, raw: bool = False, vars: _Section | None = None, fallback: _T = ...
+        self, section: _SectionName, option: str, *, raw: bool = False, vars: _Section | None = None, fallback: _T = ...
     ) -> float | _T: ...
     @overload
-    def getboolean(self, section: str, option: str, *, raw: bool = False, vars: _Section | None = None) -> bool: ...
+    def getboolean(self, section: _SectionName, option: str, *, raw: bool = False, vars: _Section | None = None) -> bool: ...
     @overload
     def getboolean(
-        self, section: str, option: str, *, raw: bool = False, vars: _Section | None = None, fallback: _T = ...
+        self, section: _SectionName, option: str, *, raw: bool = False, vars: _Section | None = None, fallback: _T = ...
     ) -> bool | _T: ...
     def _get_conv(
         self,
-        section: str,
+        section: _SectionName,
         option: str,
         conv: Callable[[str], _T],
         *,
@@ -263,19 +276,19 @@ class RawConfigParser(_Parser):
     ) -> _T: ...
     # This is incompatible with MutableMapping so we ignore the type
     @overload  # type: ignore[override]
-    def get(self, section: str, option: str, *, raw: bool = False, vars: _Section | None = None) -> str | MaybeNone: ...
+    def get(self, section: _SectionName, option: str, *, raw: bool = False, vars: _Section | None = None) -> str | MaybeNone: ...
     @overload
     def get(
-        self, section: str, option: str, *, raw: bool = False, vars: _Section | None = None, fallback: _T
+        self, section: _SectionName, option: str, *, raw: bool = False, vars: _Section | None = None, fallback: _T
     ) -> str | _T | MaybeNone: ...
     @overload
     def items(self, *, raw: bool = False, vars: _Section | None = None) -> ItemsView[str, SectionProxy]: ...
     @overload
-    def items(self, section: str, raw: bool = False, vars: _Section | None = None) -> list[tuple[str, str]]: ...
-    def set(self, section: str, option: str, value: str | None = None) -> None: ...
+    def items(self, section: _SectionName, raw: bool = False, vars: _Section | None = None) -> list[tuple[str, str]]: ...
+    def set(self, section: _SectionName, option: str, value: str | None = None) -> None: ...
     def write(self, fp: SupportsWrite[str], space_around_delimiters: bool = True) -> None: ...
-    def remove_option(self, section: str, option: str) -> bool: ...
-    def remove_section(self, section: str) -> bool: ...
+    def remove_option(self, section: _SectionName, option: str) -> bool: ...
+    def remove_section(self, section: _SectionName) -> bool: ...
     def optionxform(self, optionstr: str) -> str: ...
     @property
     def converters(self) -> ConverterMapping: ...
@@ -283,9 +296,11 @@ class RawConfigParser(_Parser):
 class ConfigParser(RawConfigParser):
     # This is incompatible with MutableMapping so we ignore the type
     @overload  # type: ignore[override]
-    def get(self, section: str, option: str, *, raw: bool = False, vars: _Section | None = None) -> str: ...
+    def get(self, section: _SectionName, option: str, *, raw: bool = False, vars: _Section | None = None) -> str: ...
     @overload
-    def get(self, section: str, option: str, *, raw: bool = False, vars: _Section | None = None, fallback: _T) -> str | _T: ...
+    def get(
+        self, section: _SectionName, option: str, *, raw: bool = False, vars: _Section | None = None, fallback: _T
+    ) -> str | _T: ...
 
 if sys.version_info < (3, 12):
     class SafeConfigParser(ConfigParser): ...  # deprecated alias
@@ -305,7 +320,14 @@ class SectionProxy(MutableMapping[str, s
     # This is incompatible with MutableMapping so we ignore the type
     @overload  # type: ignore[override]
     def get(
-        self, option: str, *, raw: bool = False, vars: _Section | None = None, _impl: Any | None = None, **kwargs: Any
+        self,
+        option: str,
+        fallback: None = None,
+        *,
+        raw: bool = False,
+        vars: _Section | None = None,
+        _impl: Any | None = None,
+        **kwargs: Any,  # passed to the underlying parser's get() method
     ) -> str | None: ...
     @overload
     def get(
@@ -316,7 +338,7 @@ class SectionProxy(MutableMapping[str, s
         raw: bool = False,
         vars: _Section | None = None,
         _impl: Any | None = None,
-        **kwargs: Any,
+        **kwargs: Any,  # passed to the underlying parser's get() method
     ) -> str | _T: ...
     # These are partially-applied version of the methods with the same names in
     # RawConfigParser; the stubs should be kept updated together
@@ -349,38 +371,38 @@ class Error(Exception):
     def __init__(self, msg: str = "") -> None: ...
 
 class NoSectionError(Error):
-    section: str
-    def __init__(self, section: str) -> None: ...
+    section: _SectionName
+    def __init__(self, section: _SectionName) -> None: ...
 
 class DuplicateSectionError(Error):
-    section: str
+    section: _SectionName
     source: str | None
     lineno: int | None
-    def __init__(self, section: str, source: str | None = None, lineno: int | None = None) -> None: ...
+    def __init__(self, section: _SectionName, source: str | None = None, lineno: int | None = None) -> None: ...
 
 class DuplicateOptionError(Error):
-    section: str
+    section: _SectionName
     option: str
     source: str | None
     lineno: int | None
-    def __init__(self, section: str, option: str, source: str | None = None, lineno: int | None = None) -> None: ...
+    def __init__(self, section: _SectionName, option: str, source: str | None = None, lineno: int | None = None) -> None: ...
 
 class NoOptionError(Error):
-    section: str
+    section: _SectionName
     option: str
-    def __init__(self, option: str, section: str) -> None: ...
+    def __init__(self, option: str, section: _SectionName) -> None: ...
 
 class InterpolationError(Error):
-    section: str
+    section: _SectionName
     option: str
-    def __init__(self, option: str, section: str, msg: str) -> None: ...
+    def __init__(self, option: str, section: _SectionName, msg: str) -> None: ...
 
 class InterpolationDepthError(InterpolationError):
-    def __init__(self, option: str, section: str, rawval: object) -> None: ...
+    def __init__(self, option: str, section: _SectionName, rawval: object) -> None: ...
 
 class InterpolationMissingOptionError(InterpolationError):
     reference: str
-    def __init__(self, option: str, section: str, rawval: object, reference: str) -> None: ...
+    def __init__(self, option: str, section: _SectionName, rawval: object, reference: str) -> None: ...
 
 class InterpolationSyntaxError(InterpolationError): ...
 
@@ -403,9 +425,6 @@ class MissingSectionHeaderError(ParsingE
     def __init__(self, filename: str, lineno: int, line: str) -> None: ...
 
 if sys.version_info >= (3, 13):
-    class _UNNAMED_SECTION: ...
-    UNNAMED_SECTION: _UNNAMED_SECTION
-
     class MultilineContinuationError(ParsingError):
         lineno: int
         line: str
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/contextlib.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/contextlib.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/contextlib.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/contextlib.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -33,7 +33,7 @@ _T_co = TypeVar("_T_co", covariant=True)
 _T_io = TypeVar("_T_io", bound=IO[str] | None)
 _ExitT_co = TypeVar("_ExitT_co", covariant=True, bound=bool | None, default=bool | None)
 _F = TypeVar("_F", bound=Callable[..., Any])
-_G = TypeVar("_G", bound=Generator[Any, Any, Any] | AsyncGenerator[Any, Any], covariant=True)
+_G_co = TypeVar("_G_co", bound=Generator[Any, Any, Any] | AsyncGenerator[Any, Any], covariant=True)
 _P = ParamSpec("_P")
 
 _SendT_contra = TypeVar("_SendT_contra", contravariant=True, default=None)
@@ -68,11 +68,11 @@ class ContextDecorator:
     def _recreate_cm(self) -> Self: ...
     def __call__(self, func: _F) -> _F: ...
 
-class _GeneratorContextManagerBase(Generic[_G]):
+class _GeneratorContextManagerBase(Generic[_G_co]):
     # Ideally this would use ParamSpec, but that requires (*args, **kwargs), which this isn't. see #6676
-    def __init__(self, func: Callable[..., _G], args: tuple[Any, ...], kwds: dict[str, Any]) -> None: ...
-    gen: _G
-    func: Callable[..., _G]
+    def __init__(self, func: Callable[..., _G_co], args: tuple[Any, ...], kwds: dict[str, Any]) -> None: ...
+    gen: _G_co
+    func: Callable[..., _G_co]
     args: tuple[Any, ...]
     kwds: dict[str, Any]
 
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/decimal.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/decimal.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/decimal.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/decimal.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -65,7 +65,7 @@ class Underflow(Inexact, Rounded, Subnor
 class FloatOperation(DecimalException, TypeError): ...
 
 class Decimal:
-    def __new__(cls, value: _DecimalNew = ..., context: Context | None = ...) -> Self: ...
+    def __new__(cls, value: _DecimalNew = "0", context: Context | None = None) -> Self: ...
     @classmethod
     def from_float(cls, f: float, /) -> Self: ...
     def __bool__(self) -> bool: ...
@@ -163,12 +163,12 @@ class Decimal:
     def __reduce__(self) -> tuple[type[Self], tuple[str]]: ...
     def __copy__(self) -> Self: ...
     def __deepcopy__(self, memo: Any, /) -> Self: ...
-    def __format__(self, specifier: str, context: Context | None = ..., /) -> str: ...
+    def __format__(self, specifier: str, context: Context | None = None, /) -> str: ...
 
 class Context:
     # TODO: Context doesn't allow you to delete *any* attributes from instances of the class at runtime,
     # even settable attributes like `prec` and `rounding`,
-    # but that's inexpressable in the stub.
+    # but that's inexpressible in the stub.
     # Type checkers either ignore it or misinterpret it
     # if you add a `def __delattr__(self, name: str, /) -> NoReturn` method to the stub
     prec: int
@@ -181,14 +181,14 @@ class Context:
     flags: dict[_TrapType, bool]
     def __init__(
         self,
-        prec: int | None = ...,
-        rounding: str | None = ...,
-        Emin: int | None = ...,
-        Emax: int | None = ...,
-        capitals: int | None = ...,
-        clamp: int | None = ...,
-        flags: None | dict[_TrapType, bool] | Container[_TrapType] = ...,
-        traps: None | dict[_TrapType, bool] | Container[_TrapType] = ...,
+        prec: int | None = None,
+        rounding: str | None = None,
+        Emin: int | None = None,
+        Emax: int | None = None,
+        capitals: int | None = None,
+        clamp: int | None = None,
+        flags: dict[_TrapType, bool] | Container[_TrapType] | None = None,
+        traps: dict[_TrapType, bool] | Container[_TrapType] | None = None,
     ) -> None: ...
     def __reduce__(self) -> tuple[type[Self], tuple[Any, ...]]: ...
     def clear_flags(self) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/distutils/cmd.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/distutils/cmd.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/distutils/cmd.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/distutils/cmd.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -30,7 +30,7 @@ _CommandT = TypeVar("_CommandT", bound=C
 _Ts = TypeVarTuple("_Ts")
 
 class Command:
-    dry_run: Literal[0, 1]  # Exposed from __getattr_. Same as Distribution.dry_run
+    dry_run: bool | Literal[0, 1]  # Exposed from __getattr_. Same as Distribution.dry_run
     distribution: Distribution
     # Any to work around variance issues
     sub_commands: ClassVar[list[tuple[str, Callable[[Any], bool] | None]]]
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/distutils/dist.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/distutils/dist.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/distutils/dist.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/distutils/dist.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -88,9 +88,9 @@ class Distribution:
     display_options: ClassVar[_OptionsList]
     display_option_names: ClassVar[list[str]]
     negative_opt: ClassVar[dict[str, str]]
-    verbose: Literal[0, 1]
-    dry_run: Literal[0, 1]
-    help: Literal[0, 1]
+    verbose: bool | Literal[0, 1]
+    dry_run: bool | Literal[0, 1]
+    help: bool | Literal[0, 1]
     command_packages: list[str] | None
     script_name: str | None
     script_args: list[str] | None
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/distutils/fancy_getopt.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/distutils/fancy_getopt.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/distutils/fancy_getopt.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/distutils/fancy_getopt.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,10 +1,10 @@
 from collections.abc import Iterable, Mapping
+from getopt import _SliceableT, _StrSequenceT_co
 from re import Pattern
 from typing import Any, Final, overload
 from typing_extensions import TypeAlias
 
 _Option: TypeAlias = tuple[str, str | None, str]
-_GR: TypeAlias = tuple[list[str], OptionDummy]
 
 longopt_pat: Final = r"[a-zA-Z](?:[a-zA-Z0-9-]*)"
 longopt_re: Final[Pattern[str]]
@@ -15,15 +15,25 @@ class FancyGetopt:
     def __init__(self, option_table: list[_Option] | None = None) -> None: ...
     # TODO kinda wrong, `getopt(object=object())` is invalid
     @overload
-    def getopt(self, args: list[str] | None = None) -> _GR: ...
+    def getopt(
+        self, args: _SliceableT[_StrSequenceT_co] | None = None, object: None = None
+    ) -> tuple[_StrSequenceT_co, OptionDummy]: ...
     @overload
-    def getopt(self, args: list[str] | None, object: Any) -> list[str]: ...
+    def getopt(
+        self, args: _SliceableT[_StrSequenceT_co] | None, object: Any
+    ) -> _StrSequenceT_co: ...  # object is an arbitrary non-slotted object
     def get_option_order(self) -> list[tuple[str, str]]: ...
     def generate_help(self, header: str | None = None) -> list[str]: ...
 
+# Same note as FancyGetopt.getopt
+@overload
 def fancy_getopt(
-    options: list[_Option], negative_opt: Mapping[_Option, _Option], object: Any, args: list[str] | None
-) -> list[str] | _GR: ...
+    options: list[_Option], negative_opt: Mapping[_Option, _Option], object: None, args: _SliceableT[_StrSequenceT_co] | None
+) -> tuple[_StrSequenceT_co, OptionDummy]: ...
+@overload
+def fancy_getopt(
+    options: list[_Option], negative_opt: Mapping[_Option, _Option], object: Any, args: _SliceableT[_StrSequenceT_co] | None
+) -> _StrSequenceT_co: ...
 
 WS_TRANS: Final[dict[int, str]]
 
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/email/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/email/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/email/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/email/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,7 +1,7 @@
 from collections.abc import Callable
 from email.message import Message
-from email.policy import Policy
-from typing import IO
+from email.policy import Policy, _MessageT
+from typing import IO, overload
 from typing_extensions import TypeAlias
 
 # At runtime, listing submodules in __all__ without them being imported is
@@ -31,7 +31,29 @@ __all__ = [  # noqa: F822  # Undefined n
 _ParamType: TypeAlias = str | tuple[str | None, str | None, str]  # noqa: Y047
 _ParamsType: TypeAlias = str | None | tuple[str, str | None, str]  # noqa: Y047
 
-def message_from_string(s: str, _class: Callable[[], Message] = ..., *, policy: Policy = ...) -> Message: ...
-def message_from_bytes(s: bytes | bytearray, _class: Callable[[], Message] = ..., *, policy: Policy = ...) -> Message: ...
-def message_from_file(fp: IO[str], _class: Callable[[], Message] = ..., *, policy: Policy = ...) -> Message: ...
-def message_from_binary_file(fp: IO[bytes], _class: Callable[[], Message] = ..., *, policy: Policy = ...) -> Message: ...
+@overload
+def message_from_string(s: str) -> Message: ...
+@overload
+def message_from_string(s: str, _class: Callable[[], _MessageT]) -> _MessageT: ...
+@overload
+def message_from_string(s: str, _class: Callable[[], _MessageT] = ..., *, policy: Policy[_MessageT]) -> _MessageT: ...
+@overload
+def message_from_bytes(s: bytes | bytearray) -> Message: ...
+@overload
+def message_from_bytes(s: bytes | bytearray, _class: Callable[[], _MessageT]) -> _MessageT: ...
+@overload
+def message_from_bytes(
+    s: bytes | bytearray, _class: Callable[[], _MessageT] = ..., *, policy: Policy[_MessageT]
+) -> _MessageT: ...
+@overload
+def message_from_file(fp: IO[str]) -> Message: ...
+@overload
+def message_from_file(fp: IO[str], _class: Callable[[], _MessageT]) -> _MessageT: ...
+@overload
+def message_from_file(fp: IO[str], _class: Callable[[], _MessageT] = ..., *, policy: Policy[_MessageT]) -> _MessageT: ...
+@overload
+def message_from_binary_file(fp: IO[bytes]) -> Message: ...
+@overload
+def message_from_binary_file(fp: IO[bytes], _class: Callable[[], _MessageT]) -> _MessageT: ...
+@overload
+def message_from_binary_file(fp: IO[bytes], _class: Callable[[], _MessageT] = ..., *, policy: Policy[_MessageT]) -> _MessageT: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/email/_header_value_parser.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/email/_header_value_parser.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/email/_header_value_parser.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/email/_header_value_parser.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,3 +1,4 @@
+import sys
 from collections.abc import Iterable, Iterator
 from email.errors import HeaderParseError, MessageDefect
 from email.policy import Policy
@@ -21,6 +22,9 @@ NLSET: Final[set[str]]
 # Added in Python 3.8.20, 3.9.20, 3.10.15, 3.11.10, 3.12.5
 SPECIALSNL: Final[set[str]]
 
+if sys.version_info >= (3, 12):
+    def make_quoted_pairs(value: Any) -> str: ...
+
 def quote_string(value: Any) -> str: ...
 
 rfc2047_matcher: Pattern[str]
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/email/mime/message.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/email/mime/message.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/email/mime/message.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/email/mime/message.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,8 +1,7 @@
-from email.message import Message
 from email.mime.nonmultipart import MIMENonMultipart
-from email.policy import Policy
+from email.policy import Policy, _MessageT
 
 __all__ = ["MIMEMessage"]
 
 class MIMEMessage(MIMENonMultipart):
-    def __init__(self, _msg: Message, _subtype: str = "rfc822", *, policy: Policy | None = None) -> None: ...
+    def __init__(self, _msg: _MessageT, _subtype: str = "rfc822", *, policy: Policy[_MessageT] | None = None) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/email/mime/multipart.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/email/mime/multipart.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/email/mime/multipart.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/email/mime/multipart.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,8 +1,7 @@
 from collections.abc import Sequence
 from email import _ParamsType
-from email.message import Message
 from email.mime.base import MIMEBase
-from email.policy import Policy
+from email.policy import Policy, _MessageT
 
 __all__ = ["MIMEMultipart"]
 
@@ -11,8 +10,8 @@ class MIMEMultipart(MIMEBase):
         self,
         _subtype: str = "mixed",
         boundary: str | None = None,
-        _subparts: Sequence[Message] | None = None,
+        _subparts: Sequence[_MessageT] | None = None,
         *,
-        policy: Policy | None = None,
+        policy: Policy[_MessageT] | None = None,
         **_params: _ParamsType,
     ) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/enum.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/enum.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/enum.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/enum.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -64,7 +64,11 @@ if sys.version_info >= (3, 11):
         def __init__(self, value: _EnumMemberT) -> None: ...
 
 class _EnumDict(dict[str, Any]):
-    def __init__(self) -> None: ...
+    if sys.version_info >= (3, 13):
+        def __init__(self, cls_name: str | None = None) -> None: ...
+    else:
+        def __init__(self) -> None: ...
+
     def __setitem__(self, key: str, value: Any) -> None: ...
     if sys.version_info >= (3, 11):
         # See comment above `typing.MutableMapping.update`
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/functools.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/functools.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/functools.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/functools.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,7 +1,7 @@
 import sys
 import types
 from _typeshed import SupportsAllComparisons, SupportsItems
-from collections.abc import Callable, Hashable, Iterable, Sequence, Sized
+from collections.abc import Callable, Hashable, Iterable, Sized
 from typing import Any, Generic, Literal, NamedTuple, TypedDict, TypeVar, final, overload
 from typing_extensions import ParamSpec, Self, TypeAlias
 
@@ -97,26 +97,26 @@ if sys.version_info >= (3, 12):
     def update_wrapper(
         wrapper: Callable[_PWrapper, _RWrapper],
         wrapped: Callable[_PWrapped, _RWrapped],
-        assigned: Sequence[str] = ("__module__", "__name__", "__qualname__", "__doc__", "__annotations__", "__type_params__"),
-        updated: Sequence[str] = ("__dict__",),
+        assigned: Iterable[str] = ("__module__", "__name__", "__qualname__", "__doc__", "__annotations__", "__type_params__"),
+        updated: Iterable[str] = ("__dict__",),
     ) -> _Wrapped[_PWrapped, _RWrapped, _PWrapper, _RWrapper]: ...
     def wraps(
         wrapped: Callable[_PWrapped, _RWrapped],
-        assigned: Sequence[str] = ("__module__", "__name__", "__qualname__", "__doc__", "__annotations__", "__type_params__"),
-        updated: Sequence[str] = ("__dict__",),
+        assigned: Iterable[str] = ("__module__", "__name__", "__qualname__", "__doc__", "__annotations__", "__type_params__"),
+        updated: Iterable[str] = ("__dict__",),
     ) -> _Wrapper[_PWrapped, _RWrapped]: ...
 
 else:
     def update_wrapper(
         wrapper: Callable[_PWrapper, _RWrapper],
         wrapped: Callable[_PWrapped, _RWrapped],
-        assigned: Sequence[str] = ("__module__", "__name__", "__qualname__", "__doc__", "__annotations__"),
-        updated: Sequence[str] = ("__dict__",),
+        assigned: Iterable[str] = ("__module__", "__name__", "__qualname__", "__doc__", "__annotations__"),
+        updated: Iterable[str] = ("__dict__",),
     ) -> _Wrapped[_PWrapped, _RWrapped, _PWrapper, _RWrapper]: ...
     def wraps(
         wrapped: Callable[_PWrapped, _RWrapped],
-        assigned: Sequence[str] = ("__module__", "__name__", "__qualname__", "__doc__", "__annotations__"),
-        updated: Sequence[str] = ("__dict__",),
+        assigned: Iterable[str] = ("__module__", "__name__", "__qualname__", "__doc__", "__annotations__"),
+        updated: Iterable[str] = ("__dict__",),
     ) -> _Wrapper[_PWrapped, _RWrapped]: ...
 
 def total_ordering(cls: type[_T]) -> type[_T]: ...
@@ -151,20 +151,25 @@ class partialmethod(Generic[_T]):
     if sys.version_info >= (3, 9):
         def __class_getitem__(cls, item: Any, /) -> GenericAlias: ...
 
+if sys.version_info >= (3, 11):
+    _RegType: TypeAlias = type[Any] | types.UnionType
+else:
+    _RegType: TypeAlias = type[Any]
+
 class _SingleDispatchCallable(Generic[_T]):
     registry: types.MappingProxyType[Any, Callable[..., _T]]
     def dispatch(self, cls: Any) -> Callable[..., _T]: ...
     # @fun.register(complex)
     # def _(arg, verbose=False): ...
     @overload
-    def register(self, cls: type[Any], func: None = None) -> Callable[[Callable[..., _T]], Callable[..., _T]]: ...
+    def register(self, cls: _RegType, func: None = None) -> Callable[[Callable[..., _T]], Callable[..., _T]]: ...
     # @fun.register
     # def _(arg: int, verbose=False):
     @overload
     def register(self, cls: Callable[..., _T], func: None = None) -> Callable[..., _T]: ...
     # fun.register(int, lambda x: x)
     @overload
-    def register(self, cls: type[Any], func: Callable[..., _T]) -> Callable[..., _T]: ...
+    def register(self, cls: _RegType, func: Callable[..., _T]) -> Callable[..., _T]: ...
     def _clear_cache(self) -> None: ...
     def __call__(self, /, *args: Any, **kwargs: Any) -> _T: ...
 
@@ -177,11 +182,11 @@ class singledispatchmethod(Generic[_T]):
     @property
     def __isabstractmethod__(self) -> bool: ...
     @overload
-    def register(self, cls: type[Any], method: None = None) -> Callable[[Callable[..., _T]], Callable[..., _T]]: ...
+    def register(self, cls: _RegType, method: None = None) -> Callable[[Callable[..., _T]], Callable[..., _T]]: ...
     @overload
     def register(self, cls: Callable[..., _T], method: None = None) -> Callable[..., _T]: ...
     @overload
-    def register(self, cls: type[Any], method: Callable[..., _T]) -> Callable[..., _T]: ...
+    def register(self, cls: _RegType, method: Callable[..., _T]) -> Callable[..., _T]: ...
     def __get__(self, obj: _S, cls: type[_S] | None = None) -> Callable[..., _T]: ...
 
 class cached_property(Generic[_T_co]):
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/getopt.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/getopt.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/getopt.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/getopt.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,10 +1,22 @@
-from collections.abc import Iterable
+from collections.abc import Iterable, Sequence
+from typing import Protocol, TypeVar, overload, type_check_only
+
+_StrSequenceT_co = TypeVar("_StrSequenceT_co", covariant=True, bound=Sequence[str])
+
+@type_check_only
+class _SliceableT(Protocol[_StrSequenceT_co]):
+    @overload
+    def __getitem__(self, key: int, /) -> str: ...
+    @overload
+    def __getitem__(self, key: slice, /) -> _StrSequenceT_co: ...
 
 __all__ = ["GetoptError", "error", "getopt", "gnu_getopt"]
 
-def getopt(args: list[str], shortopts: str, longopts: Iterable[str] | str = []) -> tuple[list[tuple[str, str]], list[str]]: ...
+def getopt(
+    args: _SliceableT[_StrSequenceT_co], shortopts: str, longopts: Iterable[str] | str = []
+) -> tuple[list[tuple[str, str]], _StrSequenceT_co]: ...
 def gnu_getopt(
-    args: list[str], shortopts: str, longopts: Iterable[str] | str = []
+    args: Sequence[str], shortopts: str, longopts: Iterable[str] | str = []
 ) -> tuple[list[tuple[str, str]], list[str]]: ...
 
 class GetoptError(Exception):
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/hashlib.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/hashlib.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/hashlib.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/hashlib.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -2,6 +2,7 @@ import sys
 from _blake2 import blake2b as blake2b, blake2s as blake2s
 from _hashlib import (
     HASH,
+    _HashObject,
     openssl_md5 as md5,
     openssl_sha1 as sha1,
     openssl_sha224 as sha224,
@@ -97,7 +98,7 @@ if sys.version_info >= (3, 11):
         def readable(self) -> bool: ...
 
     def file_digest(
-        fileobj: _BytesIOLike | _FileDigestFileObj, digest: str | Callable[[], HASH], /, *, _bufsize: int = 262144
+        fileobj: _BytesIOLike | _FileDigestFileObj, digest: str | Callable[[], _HashObject], /, *, _bufsize: int = 262144
     ) -> HASH: ...
 
 # Legacy typing-only alias
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/heapq.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/heapq.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/heapq.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/heapq.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,6 +1,6 @@
 from _heapq import *
 from _typeshed import SupportsRichComparison
-from collections.abc import Callable, Iterable
+from collections.abc import Callable, Generator, Iterable
 from typing import Any, Final, TypeVar
 
 __all__ = ["heappush", "heappop", "heapify", "heapreplace", "merge", "nlargest", "nsmallest", "heappushpop"]
@@ -11,7 +11,7 @@ __about__: Final[str]
 
 def merge(
     *iterables: Iterable[_S], key: Callable[[_S], SupportsRichComparison] | None = None, reverse: bool = False
-) -> Iterable[_S]: ...
+) -> Generator[_S]: ...
 def nlargest(n: int, iterable: Iterable[_S], key: Callable[[_S], SupportsRichComparison] | None = None) -> list[_S]: ...
 def nsmallest(n: int, iterable: Iterable[_S], key: Callable[[_S], SupportsRichComparison] | None = None) -> list[_S]: ...
 def _heapify_max(heap: list[Any], /) -> None: ...  # undocumented
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/hmac.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/hmac.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/hmac.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/hmac.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,12 +1,12 @@
 import sys
-from _hashlib import HASH as _HashlibHash
+from _hashlib import _HashObject
 from _typeshed import ReadableBuffer, SizedBuffer
 from collections.abc import Callable
 from types import ModuleType
 from typing import AnyStr, overload
 from typing_extensions import TypeAlias
 
-_DigestMod: TypeAlias = str | Callable[[], _HashlibHash] | ModuleType
+_DigestMod: TypeAlias = str | Callable[[], _HashObject] | ModuleType
 
 trans_5C: bytes
 trans_36: bytes
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/http/server.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/http/server.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/http/server.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/http/server.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -6,6 +6,7 @@ import sys
 from _typeshed import StrPath, SupportsRead, SupportsWrite
 from collections.abc import Mapping, Sequence
 from typing import Any, AnyStr, BinaryIO, ClassVar
+from typing_extensions import deprecated
 
 __all__ = ["HTTPServer", "ThreadingHTTPServer", "BaseHTTPRequestHandler", "SimpleHTTPRequestHandler", "CGIHTTPRequestHandler"]
 
@@ -61,7 +62,7 @@ class SimpleHTTPRequestHandler(BaseHTTPR
         client_address: _socket._RetAddress,
         server: socketserver.BaseServer,
         *,
-        directory: str | None = None,
+        directory: StrPath | None = None,
     ) -> None: ...
     def do_GET(self) -> None: ...
     def do_HEAD(self) -> None: ...
@@ -72,7 +73,7 @@ class SimpleHTTPRequestHandler(BaseHTTPR
     def guess_type(self, path: StrPath) -> str: ...  # undocumented
 
 def executable(path: StrPath) -> bool: ...  # undocumented
-
+@deprecated("Deprecated in Python 3.13; removal scheduled for Python 3.15")
 class CGIHTTPRequestHandler(SimpleHTTPRequestHandler):
     cgi_directories: list[str]
     have_fork: bool  # undocumented
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/importlib/metadata/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/importlib/metadata/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/importlib/metadata/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/importlib/metadata/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -139,7 +139,7 @@ if sys.version_info >= (3, 10) and sys.v
     class Deprecated(Generic[_KT, _VT]):
         def __getitem__(self, name: _KT) -> _VT: ...
         @overload
-        def get(self, name: _KT) -> _VT | None: ...
+        def get(self, name: _KT, default: None = None) -> _VT | None: ...
         @overload
         def get(self, name: _KT, default: _T) -> _VT | _T: ...
         def __iter__(self) -> Iterator[_KT]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/importlib/readers.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/importlib/readers.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/importlib/readers.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/importlib/readers.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -5,16 +5,20 @@
 import pathlib
 import sys
 import zipfile
-from _typeshed import Incomplete, StrPath
+from _typeshed import StrPath
 from collections.abc import Iterable, Iterator
 from io import BufferedReader
 from typing import Literal, NoReturn, TypeVar
 from typing_extensions import Never
 
+if sys.version_info >= (3, 10):
+    from importlib._bootstrap_external import FileLoader
+    from zipimport import zipimporter
+
 if sys.version_info >= (3, 11):
-    import importlib.resources.abc as abc
+    from importlib.resources import abc
 else:
-    import importlib.abc as abc
+    from importlib import abc
 
 if sys.version_info >= (3, 10):
     if sys.version_info >= (3, 11):
@@ -27,14 +31,14 @@ if sys.version_info >= (3, 10):
 
     class FileReader(abc.TraversableResources):
         path: pathlib.Path
-        def __init__(self, loader) -> None: ...
+        def __init__(self, loader: FileLoader) -> None: ...
         def resource_path(self, resource: StrPath) -> str: ...
         def files(self) -> pathlib.Path: ...
 
     class ZipReader(abc.TraversableResources):
         prefix: str
-        archive: Incomplete
-        def __init__(self, loader, module: str) -> None: ...
+        archive: str
+        def __init__(self, loader: zipimporter, module: str) -> None: ...
         def open_resource(self, resource: str) -> BufferedReader: ...
         def is_resource(self, path: StrPath) -> bool: ...
         def files(self) -> zipfile.Path: ...
@@ -63,6 +67,6 @@ if sys.version_info >= (3, 10):
 
     class NamespaceReader(abc.TraversableResources):
         path: MultiplexedPath
-        def __init__(self, namespace_path) -> None: ...
+        def __init__(self, namespace_path: Iterable[str]) -> None: ...
         def resource_path(self, resource: str) -> str: ...
         def files(self) -> MultiplexedPath: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/importlib/resources/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/importlib/resources/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/importlib/resources/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/importlib/resources/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -4,7 +4,7 @@ from collections.abc import Iterator
 from contextlib import AbstractContextManager
 from pathlib import Path
 from types import ModuleType
-from typing import Any, BinaryIO, TextIO
+from typing import Any, BinaryIO, Literal, TextIO
 from typing_extensions import TypeAlias
 
 if sys.version_info >= (3, 11):
@@ -51,14 +51,14 @@ else:
     def open_text(package: Package, resource: Resource, encoding: str = "utf-8", errors: str = "strict") -> TextIO: ...
     def read_binary(package: Package, resource: Resource) -> bytes: ...
     def read_text(package: Package, resource: Resource, encoding: str = "utf-8", errors: str = "strict") -> str: ...
-    def path(package: Package, resource: Resource) -> AbstractContextManager[Path]: ...
+    def path(package: Package, resource: Resource) -> AbstractContextManager[Path, Literal[False]]: ...
     def is_resource(package: Package, name: str) -> bool: ...
     def contents(package: Package) -> Iterator[str]: ...
 
 if sys.version_info >= (3, 11):
     from importlib.resources._common import as_file as as_file
 elif sys.version_info >= (3, 9):
-    def as_file(path: Traversable) -> AbstractContextManager[Path]: ...
+    def as_file(path: Traversable) -> AbstractContextManager[Path, Literal[False]]: ...
 
 if sys.version_info >= (3, 11):
     from importlib.resources._common import files as files
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/importlib/resources/_common.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/importlib/resources/_common.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/importlib/resources/_common.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/importlib/resources/_common.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -7,7 +7,7 @@ if sys.version_info >= (3, 11):
     from contextlib import AbstractContextManager
     from importlib.abc import ResourceReader, Traversable
     from pathlib import Path
-    from typing import overload
+    from typing import Literal, overload
     from typing_extensions import TypeAlias, deprecated
 
     Package: TypeAlias = str | types.ModuleType
@@ -16,7 +16,7 @@ if sys.version_info >= (3, 11):
         Anchor: TypeAlias = Package
 
         def package_to_anchor(
-            func: Callable[[Anchor | None], Traversable]
+            func: Callable[[Anchor | None], Traversable],
         ) -> Callable[[Anchor | None, Anchor | None], Traversable]: ...
         @overload
         def files(anchor: Anchor | None = None) -> Traversable: ...
@@ -39,4 +39,4 @@ if sys.version_info >= (3, 11):
         def get_package(package: Package) -> types.ModuleType: ...
 
     def from_package(package: types.ModuleType) -> Traversable: ...
-    def as_file(path: Traversable) -> AbstractContextManager[Path]: ...
+    def as_file(path: Traversable) -> AbstractContextManager[Path, Literal[False]]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/importlib/resources/_functional.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/importlib/resources/_functional.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/importlib/resources/_functional.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/importlib/resources/_functional.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -8,7 +8,7 @@ if sys.version_info >= (3, 13):
     from importlib.resources._common import Anchor
     from io import TextIOWrapper
     from pathlib import Path
-    from typing import BinaryIO, overload
+    from typing import BinaryIO, Literal, overload
     from typing_extensions import Unpack
 
     def open_binary(anchor: Anchor, *path_names: StrPath) -> BinaryIO: ...
@@ -25,6 +25,6 @@ if sys.version_info >= (3, 13):
     ) -> str: ...
     @overload
     def read_text(anchor: Anchor, *path_names: StrPath, encoding: str | None, errors: str | None = "strict") -> str: ...
-    def path(anchor: Anchor, *path_names: StrPath) -> AbstractContextManager[Path]: ...
+    def path(anchor: Anchor, *path_names: StrPath) -> AbstractContextManager[Path, Literal[False]]: ...
     def is_resource(anchor: Anchor, *path_names: StrPath) -> bool: ...
     def contents(anchor: Anchor, *path_names: StrPath) -> Iterator[str]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/inspect.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/inspect.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/inspect.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/inspect.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -143,8 +143,8 @@ if sys.version_info >= (3, 11):
 _P = ParamSpec("_P")
 _T = TypeVar("_T")
 _F = TypeVar("_F", bound=Callable[..., Any])
-_T_cont = TypeVar("_T_cont", contravariant=True)
-_V_cont = TypeVar("_V_cont", contravariant=True)
+_T_contra = TypeVar("_T_contra", contravariant=True)
+_V_contra = TypeVar("_V_contra", contravariant=True)
 
 #
 # Types and members
@@ -228,11 +228,11 @@ def isasyncgenfunction(obj: Callable[_P,
 @overload
 def isasyncgenfunction(obj: object) -> TypeGuard[Callable[..., AsyncGeneratorType[Any, Any]]]: ...
 
-class _SupportsSet(Protocol[_T_cont, _V_cont]):
-    def __set__(self, instance: _T_cont, value: _V_cont, /) -> None: ...
+class _SupportsSet(Protocol[_T_contra, _V_contra]):
+    def __set__(self, instance: _T_contra, value: _V_contra, /) -> None: ...
 
-class _SupportsDelete(Protocol[_T_cont]):
-    def __delete__(self, instance: _T_cont, /) -> None: ...
+class _SupportsDelete(Protocol[_T_contra]):
+    def __delete__(self, instance: _T_contra, /) -> None: ...
 
 def isasyncgen(object: object) -> TypeIs[AsyncGeneratorType[Any, Any]]: ...
 def istraceback(object: object) -> TypeIs[TracebackType]: ...
@@ -345,12 +345,12 @@ class Signature:
 
 if sys.version_info >= (3, 10):
     def get_annotations(
-        obj: Callable[..., object] | type[Any] | ModuleType,
+        obj: Callable[..., object] | type[object] | ModuleType,  # any callable, class, or module
         *,
-        globals: Mapping[str, Any] | None = None,
-        locals: Mapping[str, Any] | None = None,
+        globals: Mapping[str, Any] | None = None,  # value types depend on the key
+        locals: Mapping[str, Any] | None = None,  # value types depend on the key
         eval_str: bool = False,
-    ) -> dict[str, Any]: ...
+    ) -> dict[str, Any]: ...  # values are type expressions
 
 # The name is the same as the enum's name in CPython
 class _ParameterKind(enum.IntEnum):
@@ -370,7 +370,7 @@ if sys.version_info >= (3, 12):
     AGEN_CLOSED: Final = "AGEN_CLOSED"
 
     def getasyncgenstate(
-        agen: AsyncGenerator[Any, Any]
+        agen: AsyncGenerator[Any, Any],
     ) -> Literal["AGEN_CREATED", "AGEN_RUNNING", "AGEN_SUSPENDED", "AGEN_CLOSED"]: ...
     def getasyncgenlocals(agen: AsyncGeneratorType[Any, Any]) -> dict[str, Any]: ...
 
@@ -590,7 +590,7 @@ GEN_SUSPENDED: Final = "GEN_SUSPENDED"
 GEN_CLOSED: Final = "GEN_CLOSED"
 
 def getgeneratorstate(
-    generator: Generator[Any, Any, Any]
+    generator: Generator[Any, Any, Any],
 ) -> Literal["GEN_CREATED", "GEN_RUNNING", "GEN_SUSPENDED", "GEN_CLOSED"]: ...
 
 CORO_CREATED: Final = "CORO_CREATED"
@@ -599,7 +599,7 @@ CORO_SUSPENDED: Final = "CORO_SUSPENDED"
 CORO_CLOSED: Final = "CORO_CLOSED"
 
 def getcoroutinestate(
-    coroutine: Coroutine[Any, Any, Any]
+    coroutine: Coroutine[Any, Any, Any],
 ) -> Literal["CORO_CREATED", "CORO_RUNNING", "CORO_SUSPENDED", "CORO_CLOSED"]: ...
 def getgeneratorlocals(generator: Generator[Any, Any, Any]) -> dict[str, Any]: ...
 def getcoroutinelocals(coroutine: Coroutine[Any, Any, Any]) -> dict[str, Any]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/ipaddress.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/ipaddress.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/ipaddress.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/ipaddress.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -18,7 +18,7 @@ def ip_network(
     address: _RawIPAddress | _RawNetworkPart | tuple[_RawIPAddress] | tuple[_RawIPAddress, int], strict: bool = True
 ) -> IPv4Network | IPv6Network: ...
 def ip_interface(
-    address: _RawIPAddress | _RawNetworkPart | tuple[_RawIPAddress] | tuple[_RawIPAddress, int]
+    address: _RawIPAddress | _RawNetworkPart | tuple[_RawIPAddress] | tuple[_RawIPAddress, int],
 ) -> IPv4Interface | IPv6Interface: ...
 
 class _IPAddressBase:
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/json/encoder.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/json/encoder.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/json/encoder.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/json/encoder.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -2,11 +2,11 @@ from collections.abc import Callable, It
 from re import Pattern
 from typing import Any, Final
 
-ESCAPE: Final[Pattern[str]]
-ESCAPE_ASCII: Final[Pattern[str]]
-HAS_UTF8: Final[Pattern[bytes]]
-ESCAPE_DCT: Final[dict[str, str]]
-INFINITY: Final[float]
+ESCAPE: Final[Pattern[str]]  # undocumented
+ESCAPE_ASCII: Final[Pattern[str]]  # undocumented
+HAS_UTF8: Final[Pattern[bytes]]  # undocumented
+ESCAPE_DCT: Final[dict[str, str]]  # undocumented
+INFINITY: Final[float]  # undocumented
 
 def py_encode_basestring(s: str) -> str: ...  # undocumented
 def py_encode_basestring_ascii(s: str) -> str: ...  # undocumented
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/json/scanner.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/json/scanner.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/json/scanner.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/json/scanner.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,3 +1,7 @@
 from _json import make_scanner as make_scanner
+from re import Pattern
+from typing import Final
 
 __all__ = ["make_scanner"]
+
+NUMBER_RE: Final[Pattern[str]]  # undocumented
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/logging/config.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/logging/config.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/logging/config.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/logging/config.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -4,7 +4,7 @@ from collections.abc import Callable, Ha
 from configparser import RawConfigParser
 from re import Pattern
 from threading import Thread
-from typing import IO, Any, Final, Literal, SupportsIndex, TypedDict, overload
+from typing import IO, Any, Final, Literal, SupportsIndex, TypedDict, overload, type_check_only
 from typing_extensions import Required, TypeAlias
 
 from . import Filter, Filterer, Formatter, Handler, Logger, _FilterType, _FormatStyle, _Level
@@ -14,17 +14,20 @@ RESET_ERROR: Final[int]  # undocumented
 IDENTIFIER: Final[Pattern[str]]  # undocumented
 
 if sys.version_info >= (3, 11):
+    @type_check_only
     class _RootLoggerConfiguration(TypedDict, total=False):
         level: _Level
         filters: Sequence[str | _FilterType]
         handlers: Sequence[str]
 
 else:
+    @type_check_only
     class _RootLoggerConfiguration(TypedDict, total=False):
         level: _Level
         filters: Sequence[str]
         handlers: Sequence[str]
 
+@type_check_only
 class _LoggerConfiguration(_RootLoggerConfiguration, TypedDict, total=False):
     propagate: bool
 
@@ -32,6 +35,7 @@ _FormatterConfigurationTypedDict = Typed
     "_FormatterConfigurationTypedDict", {"class": str, "format": str, "datefmt": str, "style": _FormatStyle}, total=False
 )
 
+@type_check_only
 class _FilterConfigurationTypedDict(TypedDict):
     name: str
 
@@ -43,6 +47,7 @@ _FilterConfiguration: TypeAlias = _Filte
 # Handler config can have additional keys even when not providing a custom factory so we just use `dict`.
 _HandlerConfiguration: TypeAlias = dict[str, Any]
 
+@type_check_only
 class _DictConfigArgs(TypedDict, total=False):
     version: Required[Literal[1]]
     formatters: dict[str, _FormatterConfiguration]
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/math.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/math.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/math.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/math.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,6 +1,7 @@
 import sys
+from _typeshed import SupportsMul, SupportsRMul
 from collections.abc import Iterable
-from typing import Protocol, SupportsFloat, SupportsIndex, TypeVar, overload
+from typing import Any, Final, Literal, Protocol, SupportsFloat, SupportsIndex, TypeVar, overload
 from typing_extensions import TypeAlias
 
 _T = TypeVar("_T")
@@ -8,11 +9,11 @@ _T_co = TypeVar("_T_co", covariant=True)
 
 _SupportsFloatOrIndex: TypeAlias = SupportsFloat | SupportsIndex
 
-e: float
-pi: float
-inf: float
-nan: float
-tau: float
+e: Final[float]
+pi: Final[float]
+inf: Final[float]
+nan: Final[float]
+tau: Final[float]
 
 def acos(x: _SupportsFloatOrIndex, /) -> float: ...
 def acosh(x: _SupportsFloatOrIndex, /) -> float: ...
@@ -99,10 +100,29 @@ elif sys.version_info >= (3, 9):
 
 def perm(n: SupportsIndex, k: SupportsIndex | None = None, /) -> int: ...
 def pow(x: _SupportsFloatOrIndex, y: _SupportsFloatOrIndex, /) -> float: ...
+
+_PositiveInteger: TypeAlias = Literal[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25]
+_NegativeInteger: TypeAlias = Literal[-1, -2, -3, -4, -5, -6, -7, -8, -9, -10, -11, -12, -13, -14, -15, -16, -17, -18, -19, -20]
+_LiteralInteger = _PositiveInteger | _NegativeInteger | Literal[0]  # noqa: Y026  # TODO: Use TypeAlias once mypy bugs are fixed
+
+_MultiplicableT1 = TypeVar("_MultiplicableT1", bound=SupportsMul[Any, Any])
+_MultiplicableT2 = TypeVar("_MultiplicableT2", bound=SupportsMul[Any, Any])
+
+class _SupportsProdWithNoDefaultGiven(SupportsMul[Any, Any], SupportsRMul[int, Any], Protocol): ...
+
+_SupportsProdNoDefaultT = TypeVar("_SupportsProdNoDefaultT", bound=_SupportsProdWithNoDefaultGiven)
+
+# This stub is based on the type stub for `builtins.sum`.
+# Like `builtins.sum`, it cannot be precisely represented in a type stub
+# without introducing many false positives.
+# For more details on its limitations and false positives, see #13572.
+# Instead, just like `builtins.sum`, we explicitly handle several useful cases.
+@overload
+def prod(iterable: Iterable[bool | _LiteralInteger], /, *, start: int = 1) -> int: ...  # type: ignore[overload-overlap]
 @overload
-def prod(iterable: Iterable[SupportsIndex], /, *, start: SupportsIndex = 1) -> int: ...  # type: ignore[overload-overlap]
+def prod(iterable: Iterable[_SupportsProdNoDefaultT], /) -> _SupportsProdNoDefaultT | Literal[1]: ...
 @overload
-def prod(iterable: Iterable[_SupportsFloatOrIndex], /, *, start: _SupportsFloatOrIndex = 1) -> float: ...
+def prod(iterable: Iterable[_MultiplicableT1], /, *, start: _MultiplicableT2) -> _MultiplicableT1 | _MultiplicableT2: ...
 def radians(x: _SupportsFloatOrIndex, /) -> float: ...
 def remainder(x: _SupportsFloatOrIndex, y: _SupportsFloatOrIndex, /) -> float: ...
 def sin(x: _SupportsFloatOrIndex, /) -> float: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/multiprocessing/connection.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/multiprocessing/connection.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/multiprocessing/connection.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/multiprocessing/connection.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -12,10 +12,10 @@ __all__ = ["Client", "Listener", "Pipe",
 _Address: TypeAlias = str | tuple[str, int]
 
 # Defaulting to Any to avoid forcing generics on a lot of pre-existing code
-_SendT = TypeVar("_SendT", contravariant=True, default=Any)
-_RecvT = TypeVar("_RecvT", covariant=True, default=Any)
+_SendT_contra = TypeVar("_SendT_contra", contravariant=True, default=Any)
+_RecvT_co = TypeVar("_RecvT_co", covariant=True, default=Any)
 
-class _ConnectionBase(Generic[_SendT, _RecvT]):
+class _ConnectionBase(Generic[_SendT_contra, _RecvT_co]):
     def __init__(self, handle: SupportsIndex, readable: bool = True, writable: bool = True) -> None: ...
     @property
     def closed(self) -> bool: ...  # undocumented
@@ -26,10 +26,10 @@ class _ConnectionBase(Generic[_SendT, _R
     def fileno(self) -> int: ...
     def close(self) -> None: ...
     def send_bytes(self, buf: ReadableBuffer, offset: int = 0, size: int | None = None) -> None: ...
-    def send(self, obj: _SendT) -> None: ...
+    def send(self, obj: _SendT_contra) -> None: ...
     def recv_bytes(self, maxlength: int | None = None) -> bytes: ...
     def recv_bytes_into(self, buf: Any, offset: int = 0) -> int: ...
-    def recv(self) -> _RecvT: ...
+    def recv(self) -> _RecvT_co: ...
     def poll(self, timeout: float | None = 0.0) -> bool: ...
     def __enter__(self) -> Self: ...
     def __exit__(
@@ -37,10 +37,10 @@ class _ConnectionBase(Generic[_SendT, _R
     ) -> None: ...
     def __del__(self) -> None: ...
 
-class Connection(_ConnectionBase[_SendT, _RecvT]): ...
+class Connection(_ConnectionBase[_SendT_contra, _RecvT_co]): ...
 
 if sys.platform == "win32":
-    class PipeConnection(_ConnectionBase[_SendT, _RecvT]): ...
+    class PipeConnection(_ConnectionBase[_SendT_contra, _RecvT_co]): ...
 
 class Listener:
     def __init__(
@@ -66,8 +66,8 @@ else:
 
 def answer_challenge(connection: Connection[Any, Any], authkey: bytes) -> None: ...
 def wait(
-    object_list: Iterable[Connection[_SendT, _RecvT] | socket.socket | int], timeout: float | None = None
-) -> list[Connection[_SendT, _RecvT] | socket.socket | int]: ...
+    object_list: Iterable[Connection[_SendT_contra, _RecvT_co] | socket.socket | int], timeout: float | None = None
+) -> list[Connection[_SendT_contra, _RecvT_co] | socket.socket | int]: ...
 def Client(address: _Address, family: str | None = None, authkey: bytes | None = None) -> Connection[Any, Any]: ...
 
 # N.B. Keep this in sync with multiprocessing.context.BaseContext.Pipe.
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/optparse.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/optparse.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/optparse.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/optparse.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,8 +1,8 @@
 import builtins
-from _typeshed import Incomplete, MaybeNone
+from _typeshed import MaybeNone, SupportsWrite
 from abc import abstractmethod
 from collections.abc import Callable, Iterable, Mapping, Sequence
-from typing import IO, Any, AnyStr, ClassVar, Literal, NoReturn, overload
+from typing import Any, ClassVar, Final, Literal, NoReturn, overload
 from typing_extensions import Self
 
 __all__ = [
@@ -24,10 +24,10 @@ __all__ = [
     "BadOptionError",
     "check_choice",
 ]
-
-NO_DEFAULT: tuple[str, ...]
-SUPPRESS_HELP: str
-SUPPRESS_USAGE: str
+# pytype is not happy with `NO_DEFAULT: Final = ("NO", "DEFAULT")`
+NO_DEFAULT: Final[tuple[Literal["NO"], Literal["DEFAULT"]]]
+SUPPRESS_HELP: Final = "SUPPRESSHELP"
+SUPPRESS_USAGE: Final = "SUPPRESSUSAGE"
 
 # Can return complex, float, or int depending on the option's type
 def check_builtin(option: Option, opt: str, value: str) -> complex: ...
@@ -274,13 +274,13 @@ class OptionParser(OptionContainer):
     def _add_version_option(self) -> None: ...
     def _create_option_list(self) -> None: ...
     def _get_all_options(self) -> list[Option]: ...
-    def _get_args(self, args: Iterable[Incomplete]) -> list[Incomplete]: ...
+    def _get_args(self, args: list[str] | None) -> list[str]: ...
     def _init_parsing_state(self) -> None: ...
     def _match_long_opt(self, opt: str) -> str: ...
-    def _populate_option_list(self, option_list: Iterable[Option], add_help: bool = True) -> None: ...
-    def _process_args(self, largs: list[Incomplete], rargs: list[Incomplete], values: Values) -> None: ...
-    def _process_long_opt(self, rargs: list[Incomplete], values) -> None: ...
-    def _process_short_opts(self, rargs: list[Incomplete], values) -> None: ...
+    def _populate_option_list(self, option_list: Iterable[Option] | None, add_help: bool = True) -> None: ...
+    def _process_args(self, largs: list[str], rargs: list[str], values: Values) -> None: ...
+    def _process_long_opt(self, rargs: list[str], values: Values) -> None: ...
+    def _process_short_opts(self, rargs: list[str], values: Values) -> None: ...
     @overload
     def add_option_group(self, opt_group: OptionGroup, /) -> OptionGroup: ...
     @overload
@@ -299,14 +299,11 @@ class OptionParser(OptionContainer):
     def get_prog_name(self) -> str: ...
     def get_usage(self) -> str: ...
     def get_version(self) -> str: ...
-    @overload
-    def parse_args(self, args: None = None, values: Values | None = None) -> tuple[Values, list[str]]: ...
-    @overload
-    def parse_args(self, args: Sequence[AnyStr], values: Values | None = None) -> tuple[Values, list[AnyStr]]: ...
-    def print_usage(self, file: IO[str] | None = None) -> None: ...
-    def print_help(self, file: IO[str] | None = None) -> None: ...
-    def print_version(self, file: IO[str] | None = None) -> None: ...
-    def set_default(self, dest, value) -> None: ...
-    def set_defaults(self, **kwargs) -> None: ...
-    def set_process_default_values(self, process) -> None: ...
-    def set_usage(self, usage: str) -> None: ...
+    def parse_args(self, args: list[str] | None = None, values: Values | None = None) -> tuple[Values, list[str]]: ...
+    def print_usage(self, file: SupportsWrite[str] | None = None) -> None: ...
+    def print_help(self, file: SupportsWrite[str] | None = None) -> None: ...
+    def print_version(self, file: SupportsWrite[str] | None = None) -> None: ...
+    def set_default(self, dest: str, value: Any) -> None: ...  # default value can be "any" type
+    def set_defaults(self, **kwargs: Any) -> None: ...  # default values can be "any" type
+    def set_process_default_values(self, process: bool) -> None: ...
+    def set_usage(self, usage: str | None) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/os/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/os/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/os/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/os/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -240,6 +240,7 @@ if sys.platform == "linux" and sys.versi
         "CLONE_VM",
         "setns",
         "unshare",
+        "PIDFD_NONBLOCK",
     ]
 if sys.platform == "linux" and sys.version_info >= (3, 10):
     __all__ += [
@@ -1603,6 +1604,9 @@ if sys.version_info >= (3, 9):
     if sys.platform == "linux":
         def pidfd_open(pid: int, flags: int = ...) -> int: ...
 
+if sys.version_info >= (3, 12) and sys.platform == "linux":
+    PIDFD_NONBLOCK: Final = 2048
+
 if sys.version_info >= (3, 12) and sys.platform == "win32":
     def listdrives() -> list[str]: ...
     def listmounts(volume: str) -> list[str]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/pathlib.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/pathlib.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/pathlib.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/pathlib.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -16,7 +16,7 @@ from io import BufferedRandom, BufferedR
 from os import PathLike, stat_result
 from types import TracebackType
 from typing import IO, Any, BinaryIO, ClassVar, Literal, overload
-from typing_extensions import Self, deprecated
+from typing_extensions import Never, Self, deprecated
 
 if sys.version_info >= (3, 9):
     from types import GenericAlias
@@ -129,12 +129,10 @@ class Path(PurePath):
         def read_text(self, encoding: str | None = None, errors: str | None = None) -> str: ...
 
     if sys.version_info >= (3, 13):
-        def glob(
-            self, pattern: str, *, case_sensitive: bool | None = None, recurse_symlinks: bool = False
-        ) -> Generator[Self, None, None]: ...
+        def glob(self, pattern: str, *, case_sensitive: bool | None = None, recurse_symlinks: bool = False) -> Iterator[Self]: ...
         def rglob(
             self, pattern: str, *, case_sensitive: bool | None = None, recurse_symlinks: bool = False
-        ) -> Generator[Self, None, None]: ...
+        ) -> Iterator[Self]: ...
     elif sys.version_info >= (3, 12):
         def glob(self, pattern: str, *, case_sensitive: bool | None = None) -> Generator[Self, None, None]: ...
         def rglob(self, pattern: str, *, case_sensitive: bool | None = None) -> Generator[Self, None, None]: ...
@@ -228,9 +226,13 @@ class Path(PurePath):
     def open(
         self, mode: str, buffering: int = -1, encoding: str | None = None, errors: str | None = None, newline: str | None = None
     ) -> IO[Any]: ...
-    if sys.platform != "win32":
-        # These methods do "exist" on Windows, but they always raise NotImplementedError,
-        # so it's safer to pretend they don't exist
+
+    # These methods do "exist" on Windows on <3.13, but they always raise NotImplementedError.
+    if sys.platform == "win32":
+        if sys.version_info < (3, 13):
+            def owner(self: Never) -> str: ...  # type: ignore[misc]
+            def group(self: Never) -> str: ...  # type: ignore[misc]
+    else:
         if sys.version_info >= (3, 13):
             def owner(self, *, follow_symlinks: bool = True) -> str: ...
             def group(self, *, follow_symlinks: bool = True) -> str: ...
@@ -240,7 +242,9 @@ class Path(PurePath):
 
     # This method does "exist" on Windows on <3.12, but always raises NotImplementedError
     # On py312+, it works properly on Windows, as with all other platforms
-    if sys.platform != "win32" or sys.version_info >= (3, 12):
+    if sys.platform == "win32" and sys.version_info < (3, 12):
+        def is_mount(self: Never) -> bool: ...  # type: ignore[misc]
+    else:
         def is_mount(self) -> bool: ...
 
     if sys.version_info >= (3, 9):
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/pkgutil.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/pkgutil.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/pkgutil.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/pkgutil.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,5 +1,5 @@
 import sys
-from _typeshed import SupportsRead
+from _typeshed import StrOrBytesPath, SupportsRead
 from _typeshed.importlib import LoaderProtocol, MetaPathFinderProtocol, PathEntryFinderProtocol
 from collections.abc import Callable, Iterable, Iterator
 from typing import IO, Any, NamedTuple, TypeVar
@@ -31,21 +31,21 @@ def extend_path(path: _PathT, name: str)
 
 if sys.version_info < (3, 12):
     class ImpImporter:
-        def __init__(self, path: str | None = None) -> None: ...
+        def __init__(self, path: StrOrBytesPath | None = None) -> None: ...
 
     class ImpLoader:
-        def __init__(self, fullname: str, file: IO[str], filename: str, etc: tuple[str, str, int]) -> None: ...
+        def __init__(self, fullname: str, file: IO[str], filename: StrOrBytesPath, etc: tuple[str, str, int]) -> None: ...
 
 @deprecated("Use importlib.util.find_spec() instead. Will be removed in Python 3.14.")
 def find_loader(fullname: str) -> LoaderProtocol | None: ...
-def get_importer(path_item: str) -> PathEntryFinderProtocol | None: ...
+def get_importer(path_item: StrOrBytesPath) -> PathEntryFinderProtocol | None: ...
 @deprecated("Use importlib.util.find_spec() instead. Will be removed in Python 3.14.")
 def get_loader(module_or_name: str) -> LoaderProtocol | None: ...
 def iter_importers(fullname: str = "") -> Iterator[MetaPathFinderProtocol | PathEntryFinderProtocol]: ...
-def iter_modules(path: Iterable[str] | None = None, prefix: str = "") -> Iterator[ModuleInfo]: ...
+def iter_modules(path: Iterable[StrOrBytesPath] | None = None, prefix: str = "") -> Iterator[ModuleInfo]: ...
 def read_code(stream: SupportsRead[bytes]) -> Any: ...  # undocumented
 def walk_packages(
-    path: Iterable[str] | None = None, prefix: str = "", onerror: Callable[[str], object] | None = None
+    path: Iterable[StrOrBytesPath] | None = None, prefix: str = "", onerror: Callable[[str], object] | None = None
 ) -> Iterator[ModuleInfo]: ...
 def get_data(package: str, resource: str) -> bytes | None: ...
 
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/posix.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/posix.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/posix.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/posix.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -379,6 +379,7 @@ if sys.platform != "win32":
                 CLONE_SYSVSEM as CLONE_SYSVSEM,
                 CLONE_THREAD as CLONE_THREAD,
                 CLONE_VM as CLONE_VM,
+                PIDFD_NONBLOCK as PIDFD_NONBLOCK,
                 setns as setns,
                 unshare as unshare,
             )
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/re.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/re.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/re.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/re.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -4,7 +4,7 @@ import sre_constants
 import sys
 from _typeshed import MaybeNone, ReadableBuffer
 from collections.abc import Callable, Iterator, Mapping
-from typing import Any, AnyStr, Generic, Literal, TypeVar, final, overload
+from typing import Any, AnyStr, Final, Generic, Literal, TypeVar, final, overload
 from typing_extensions import TypeAlias
 
 if sys.version_info >= (3, 9):
@@ -224,25 +224,27 @@ class RegexFlag(enum.IntFlag):
     if sys.version_info >= (3, 11):
         NOFLAG = 0
 
-A = RegexFlag.A
-ASCII = RegexFlag.ASCII
-DEBUG = RegexFlag.DEBUG
-I = RegexFlag.I
-IGNORECASE = RegexFlag.IGNORECASE
-L = RegexFlag.L
-LOCALE = RegexFlag.LOCALE
-M = RegexFlag.M
-MULTILINE = RegexFlag.MULTILINE
-S = RegexFlag.S
-DOTALL = RegexFlag.DOTALL
-X = RegexFlag.X
-VERBOSE = RegexFlag.VERBOSE
-U = RegexFlag.U
-UNICODE = RegexFlag.UNICODE
+A: Final = RegexFlag.A
+ASCII: Final = RegexFlag.ASCII
+DEBUG: Final = RegexFlag.DEBUG
+I: Final = RegexFlag.I
+IGNORECASE: Final = RegexFlag.IGNORECASE
+L: Final = RegexFlag.L
+LOCALE: Final = RegexFlag.LOCALE
+M: Final = RegexFlag.M
+MULTILINE: Final = RegexFlag.MULTILINE
+S: Final = RegexFlag.S
+DOTALL: Final = RegexFlag.DOTALL
+X: Final = RegexFlag.X
+VERBOSE: Final = RegexFlag.VERBOSE
+U: Final = RegexFlag.U
+UNICODE: Final = RegexFlag.UNICODE
 if sys.version_info < (3, 13):
-    T = RegexFlag.T
-    TEMPLATE = RegexFlag.TEMPLATE
+    T: Final = RegexFlag.T
+    TEMPLATE: Final = RegexFlag.TEMPLATE
 if sys.version_info >= (3, 11):
+    # pytype chokes on `NOFLAG: Final = RegexFlag.NOFLAG` with `LiteralValueError`
+    # mypy chokes on `NOFLAG: Final[Literal[RegexFlag.NOFLAG]]` with `Literal[...] is invalid`
     NOFLAG = RegexFlag.NOFLAG
 _FlagsType: TypeAlias = int | RegexFlag
 
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/shutil.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/shutil.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/shutil.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/shutil.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -3,7 +3,7 @@ import sys
 from _typeshed import BytesPath, ExcInfo, FileDescriptorOrPath, StrOrBytesPath, StrPath, SupportsRead, SupportsWrite
 from collections.abc import Callable, Iterable, Sequence
 from tarfile import _TarfileFilter
-from typing import Any, AnyStr, NamedTuple, Protocol, TypeVar, overload
+from typing import Any, AnyStr, NamedTuple, NoReturn, Protocol, TypeVar, overload
 from typing_extensions import TypeAlias, deprecated
 
 __all__ = [
@@ -36,7 +36,6 @@ __all__ = [
 ]
 
 _StrOrBytesPathT = TypeVar("_StrOrBytesPathT", bound=StrOrBytesPath)
-_StrPathT = TypeVar("_StrPathT", bound=StrPath)
 # Return value of some functions that may either return a path-like object that was passed in or
 # a string
 _PathReturn: TypeAlias = Any
@@ -83,7 +82,7 @@ class _RmtreeType(Protocol):
             self,
             path: StrOrBytesPath,
             ignore_errors: bool,
-            onerror: _OnErrorCallback,
+            onerror: _OnErrorCallback | None,
             *,
             onexc: None = None,
             dir_fd: int | None = None,
@@ -95,7 +94,7 @@ class _RmtreeType(Protocol):
             path: StrOrBytesPath,
             ignore_errors: bool = False,
             *,
-            onerror: _OnErrorCallback,
+            onerror: _OnErrorCallback | None,
             onexc: None = None,
             dir_fd: int | None = None,
         ) -> None: ...
@@ -185,8 +184,13 @@ else:
     @overload
     def chown(path: FileDescriptorOrPath, user: str | int, group: str | int) -> None: ...
 
+if sys.platform == "win32" and sys.version_info < (3, 12):
+    @overload
+    @deprecated("On Windows before Python 3.12, using a PathLike as `cmd` would always fail or return `None`.")
+    def which(cmd: os.PathLike[str], mode: int = 1, path: StrPath | None = None) -> NoReturn: ...
+
 @overload
-def which(cmd: _StrPathT, mode: int = 1, path: StrPath | None = None) -> str | _StrPathT | None: ...
+def which(cmd: StrPath, mode: int = 1, path: StrPath | None = None) -> str | None: ...
 @overload
 def which(cmd: bytes, mode: int = 1, path: StrPath | None = None) -> bytes | None: ...
 def make_archive(
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/socket.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/socket.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/socket.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/socket.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -515,7 +515,7 @@ if sys.platform != "win32":
             "IPV6_RTHDRDSTOPTS",
         ]
 
-    if sys.platform != "darwin" or sys.version_info >= (3, 13):
+    if sys.platform != "darwin":
         from _socket import SO_BINDTODEVICE as SO_BINDTODEVICE
 
         __all__ += ["SO_BINDTODEVICE"]
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/socketserver.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/socketserver.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/socketserver.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/socketserver.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -38,29 +38,22 @@ _AfInetAddress: TypeAlias = tuple[str |
 
 # This can possibly be generic at some point:
 class BaseServer:
-    address_family: int
     server_address: _Address
-    socket: _socket
-    allow_reuse_address: bool
-    request_queue_size: int
-    socket_type: int
     timeout: float | None
     RequestHandlerClass: Callable[[Any, _RetAddress, Self], BaseRequestHandler]
     def __init__(
         self, server_address: _Address, RequestHandlerClass: Callable[[Any, _RetAddress, Self], BaseRequestHandler]
     ) -> None: ...
-    def fileno(self) -> int: ...
     def handle_request(self) -> None: ...
     def serve_forever(self, poll_interval: float = 0.5) -> None: ...
     def shutdown(self) -> None: ...
     def server_close(self) -> None: ...
     def finish_request(self, request: _RequestType, client_address: _RetAddress) -> None: ...
-    def get_request(self) -> tuple[Any, Any]: ...
+    def get_request(self) -> tuple[Any, Any]: ...  # Not implemented here, but expected to exist on subclasses
     def handle_error(self, request: _RequestType, client_address: _RetAddress) -> None: ...
     def handle_timeout(self) -> None: ...
     def process_request(self, request: _RequestType, client_address: _RetAddress) -> None: ...
     def server_activate(self) -> None: ...
-    def server_bind(self) -> None: ...
     def verify_request(self, request: _RequestType, client_address: _RetAddress) -> bool: ...
     def __enter__(self) -> Self: ...
     def __exit__(
@@ -71,6 +64,11 @@ class BaseServer:
     def close_request(self, request: _RequestType) -> None: ...  # undocumented
 
 class TCPServer(BaseServer):
+    address_family: int
+    socket: _socket
+    allow_reuse_address: bool
+    request_queue_size: int
+    socket_type: int
     if sys.version_info >= (3, 11):
         allow_reuse_port: bool
     server_address: _AfInetAddress
@@ -80,7 +78,9 @@ class TCPServer(BaseServer):
         RequestHandlerClass: Callable[[Any, _RetAddress, Self], BaseRequestHandler],
         bind_and_activate: bool = True,
     ) -> None: ...
+    def fileno(self) -> int: ...
     def get_request(self) -> tuple[_socket, _RetAddress]: ...
+    def server_bind(self) -> None: ...
 
 class UDPServer(TCPServer):
     max_packet_size: ClassVar[int]
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/sre_constants.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/sre_constants.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/sre_constants.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/sre_constants.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,17 +1,17 @@
 import sys
 from re import error as error
-from typing import Any
+from typing import Final
 from typing_extensions import Self
 
-MAXGROUPS: int
+MAXGROUPS: Final[int]
 
-MAGIC: int
+MAGIC: Final[int]
 
 class _NamedIntConstant(int):
-    name: Any
+    name: str
     def __new__(cls, value: int, name: str) -> Self: ...
 
-MAXREPEAT: _NamedIntConstant
+MAXREPEAT: Final[_NamedIntConstant]
 OPCODES: list[_NamedIntConstant]
 ATCODES: list[_NamedIntConstant]
 CHCODES: list[_NamedIntConstant]
@@ -23,102 +23,104 @@ AT_LOCALE: dict[_NamedIntConstant, _Name
 AT_UNICODE: dict[_NamedIntConstant, _NamedIntConstant]
 CH_LOCALE: dict[_NamedIntConstant, _NamedIntConstant]
 CH_UNICODE: dict[_NamedIntConstant, _NamedIntConstant]
+# flags
 if sys.version_info < (3, 13):
-    SRE_FLAG_TEMPLATE: int
-SRE_FLAG_IGNORECASE: int
-SRE_FLAG_LOCALE: int
-SRE_FLAG_MULTILINE: int
-SRE_FLAG_DOTALL: int
-SRE_FLAG_UNICODE: int
-SRE_FLAG_VERBOSE: int
-SRE_FLAG_DEBUG: int
-SRE_FLAG_ASCII: int
-SRE_INFO_PREFIX: int
-SRE_INFO_LITERAL: int
-SRE_INFO_CHARSET: int
+    SRE_FLAG_TEMPLATE: Final = 1
+SRE_FLAG_IGNORECASE: Final = 2
+SRE_FLAG_LOCALE: Final = 4
+SRE_FLAG_MULTILINE: Final = 8
+SRE_FLAG_DOTALL: Final = 16
+SRE_FLAG_UNICODE: Final = 32
+SRE_FLAG_VERBOSE: Final = 64
+SRE_FLAG_DEBUG: Final = 128
+SRE_FLAG_ASCII: Final = 256
+# flags for INFO primitive
+SRE_INFO_PREFIX: Final = 1
+SRE_INFO_LITERAL: Final = 2
+SRE_INFO_CHARSET: Final = 4
 
 # Stubgen above; manually defined constants below (dynamic at runtime)
 
 # from OPCODES
-FAILURE: _NamedIntConstant
-SUCCESS: _NamedIntConstant
-ANY: _NamedIntConstant
-ANY_ALL: _NamedIntConstant
-ASSERT: _NamedIntConstant
-ASSERT_NOT: _NamedIntConstant
-AT: _NamedIntConstant
-BRANCH: _NamedIntConstant
+FAILURE: Final[_NamedIntConstant]
+SUCCESS: Final[_NamedIntConstant]
+ANY: Final[_NamedIntConstant]
+ANY_ALL: Final[_NamedIntConstant]
+ASSERT: Final[_NamedIntConstant]
+ASSERT_NOT: Final[_NamedIntConstant]
+AT: Final[_NamedIntConstant]
+BRANCH: Final[_NamedIntConstant]
 if sys.version_info < (3, 11):
-    CALL: _NamedIntConstant
-CATEGORY: _NamedIntConstant
-CHARSET: _NamedIntConstant
-BIGCHARSET: _NamedIntConstant
-GROUPREF: _NamedIntConstant
-GROUPREF_EXISTS: _NamedIntConstant
-GROUPREF_IGNORE: _NamedIntConstant
-IN: _NamedIntConstant
-IN_IGNORE: _NamedIntConstant
-INFO: _NamedIntConstant
-JUMP: _NamedIntConstant
-LITERAL: _NamedIntConstant
-LITERAL_IGNORE: _NamedIntConstant
-MARK: _NamedIntConstant
-MAX_UNTIL: _NamedIntConstant
-MIN_UNTIL: _NamedIntConstant
-NOT_LITERAL: _NamedIntConstant
-NOT_LITERAL_IGNORE: _NamedIntConstant
-NEGATE: _NamedIntConstant
-RANGE: _NamedIntConstant
-REPEAT: _NamedIntConstant
-REPEAT_ONE: _NamedIntConstant
-SUBPATTERN: _NamedIntConstant
-MIN_REPEAT_ONE: _NamedIntConstant
+    CALL: Final[_NamedIntConstant]
+CATEGORY: Final[_NamedIntConstant]
+CHARSET: Final[_NamedIntConstant]
+BIGCHARSET: Final[_NamedIntConstant]
+GROUPREF: Final[_NamedIntConstant]
+GROUPREF_EXISTS: Final[_NamedIntConstant]
+GROUPREF_IGNORE: Final[_NamedIntConstant]
+IN: Final[_NamedIntConstant]
+IN_IGNORE: Final[_NamedIntConstant]
+INFO: Final[_NamedIntConstant]
+JUMP: Final[_NamedIntConstant]
+LITERAL: Final[_NamedIntConstant]
+LITERAL_IGNORE: Final[_NamedIntConstant]
+MARK: Final[_NamedIntConstant]
+MAX_UNTIL: Final[_NamedIntConstant]
+MIN_UNTIL: Final[_NamedIntConstant]
+NOT_LITERAL: Final[_NamedIntConstant]
+NOT_LITERAL_IGNORE: Final[_NamedIntConstant]
+NEGATE: Final[_NamedIntConstant]
+RANGE: Final[_NamedIntConstant]
+REPEAT: Final[_NamedIntConstant]
+REPEAT_ONE: Final[_NamedIntConstant]
+SUBPATTERN: Final[_NamedIntConstant]
+MIN_REPEAT_ONE: Final[_NamedIntConstant]
 if sys.version_info >= (3, 11):
-    ATOMIC_GROUP: _NamedIntConstant
-    POSSESSIVE_REPEAT: _NamedIntConstant
-    POSSESSIVE_REPEAT_ONE: _NamedIntConstant
-RANGE_UNI_IGNORE: _NamedIntConstant
-GROUPREF_LOC_IGNORE: _NamedIntConstant
-GROUPREF_UNI_IGNORE: _NamedIntConstant
-IN_LOC_IGNORE: _NamedIntConstant
-IN_UNI_IGNORE: _NamedIntConstant
-LITERAL_LOC_IGNORE: _NamedIntConstant
-LITERAL_UNI_IGNORE: _NamedIntConstant
-NOT_LITERAL_LOC_IGNORE: _NamedIntConstant
-NOT_LITERAL_UNI_IGNORE: _NamedIntConstant
-MIN_REPEAT: _NamedIntConstant
-MAX_REPEAT: _NamedIntConstant
+    ATOMIC_GROUP: Final[_NamedIntConstant]
+    POSSESSIVE_REPEAT: Final[_NamedIntConstant]
+    POSSESSIVE_REPEAT_ONE: Final[_NamedIntConstant]
+RANGE_UNI_IGNORE: Final[_NamedIntConstant]
+GROUPREF_LOC_IGNORE: Final[_NamedIntConstant]
+GROUPREF_UNI_IGNORE: Final[_NamedIntConstant]
+IN_LOC_IGNORE: Final[_NamedIntConstant]
+IN_UNI_IGNORE: Final[_NamedIntConstant]
+LITERAL_LOC_IGNORE: Final[_NamedIntConstant]
+LITERAL_UNI_IGNORE: Final[_NamedIntConstant]
+NOT_LITERAL_LOC_IGNORE: Final[_NamedIntConstant]
+NOT_LITERAL_UNI_IGNORE: Final[_NamedIntConstant]
+MIN_REPEAT: Final[_NamedIntConstant]
+MAX_REPEAT: Final[_NamedIntConstant]
 
 # from ATCODES
-AT_BEGINNING: _NamedIntConstant
-AT_BEGINNING_LINE: _NamedIntConstant
-AT_BEGINNING_STRING: _NamedIntConstant
-AT_BOUNDARY: _NamedIntConstant
-AT_NON_BOUNDARY: _NamedIntConstant
-AT_END: _NamedIntConstant
-AT_END_LINE: _NamedIntConstant
-AT_END_STRING: _NamedIntConstant
-AT_LOC_BOUNDARY: _NamedIntConstant
-AT_LOC_NON_BOUNDARY: _NamedIntConstant
-AT_UNI_BOUNDARY: _NamedIntConstant
-AT_UNI_NON_BOUNDARY: _NamedIntConstant
+AT_BEGINNING: Final[_NamedIntConstant]
+AT_BEGINNING_LINE: Final[_NamedIntConstant]
+AT_BEGINNING_STRING: Final[_NamedIntConstant]
+AT_BOUNDARY: Final[_NamedIntConstant]
+AT_NON_BOUNDARY: Final[_NamedIntConstant]
+AT_END: Final[_NamedIntConstant]
+AT_END_LINE: Final[_NamedIntConstant]
+AT_END_STRING: Final[_NamedIntConstant]
+AT_LOC_BOUNDARY: Final[_NamedIntConstant]
+AT_LOC_NON_BOUNDARY: Final[_NamedIntConstant]
+AT_UNI_BOUNDARY: Final[_NamedIntConstant]
+AT_UNI_NON_BOUNDARY: Final[_NamedIntConstant]
 
 # from CHCODES
-CATEGORY_DIGIT: _NamedIntConstant
-CATEGORY_NOT_DIGIT: _NamedIntConstant
-CATEGORY_SPACE: _NamedIntConstant
-CATEGORY_NOT_SPACE: _NamedIntConstant
-CATEGORY_WORD: _NamedIntConstant
-CATEGORY_NOT_WORD: _NamedIntConstant
-CATEGORY_LINEBREAK: _NamedIntConstant
-CATEGORY_NOT_LINEBREAK: _NamedIntConstant
-CATEGORY_LOC_WORD: _NamedIntConstant
-CATEGORY_LOC_NOT_WORD: _NamedIntConstant
-CATEGORY_UNI_DIGIT: _NamedIntConstant
-CATEGORY_UNI_NOT_DIGIT: _NamedIntConstant
-CATEGORY_UNI_SPACE: _NamedIntConstant
-CATEGORY_UNI_NOT_SPACE: _NamedIntConstant
-CATEGORY_UNI_WORD: _NamedIntConstant
-CATEGORY_UNI_NOT_WORD: _NamedIntConstant
-CATEGORY_UNI_LINEBREAK: _NamedIntConstant
-CATEGORY_UNI_NOT_LINEBREAK: _NamedIntConstant
+CATEGORY_DIGIT: Final[_NamedIntConstant]
+CATEGORY_NOT_DIGIT: Final[_NamedIntConstant]
+CATEGORY_SPACE: Final[_NamedIntConstant]
+CATEGORY_NOT_SPACE: Final[_NamedIntConstant]
+CATEGORY_WORD: Final[_NamedIntConstant]
+CATEGORY_NOT_WORD: Final[_NamedIntConstant]
+CATEGORY_LINEBREAK: Final[_NamedIntConstant]
+CATEGORY_NOT_LINEBREAK: Final[_NamedIntConstant]
+CATEGORY_LOC_WORD: Final[_NamedIntConstant]
+CATEGORY_LOC_NOT_WORD: Final[_NamedIntConstant]
+CATEGORY_UNI_DIGIT: Final[_NamedIntConstant]
+CATEGORY_UNI_NOT_DIGIT: Final[_NamedIntConstant]
+CATEGORY_UNI_SPACE: Final[_NamedIntConstant]
+CATEGORY_UNI_NOT_SPACE: Final[_NamedIntConstant]
+CATEGORY_UNI_WORD: Final[_NamedIntConstant]
+CATEGORY_UNI_NOT_WORD: Final[_NamedIntConstant]
+CATEGORY_UNI_LINEBREAK: Final[_NamedIntConstant]
+CATEGORY_UNI_NOT_LINEBREAK: Final[_NamedIntConstant]
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/statistics.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/statistics.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/statistics.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/statistics.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -3,7 +3,7 @@ from _typeshed import SupportsRichCompar
 from collections.abc import Callable, Hashable, Iterable, Sequence
 from decimal import Decimal
 from fractions import Fraction
-from typing import Any, Literal, NamedTuple, SupportsFloat, TypeVar
+from typing import Literal, NamedTuple, SupportsFloat, SupportsIndex, TypeVar
 from typing_extensions import Self, TypeAlias
 
 __all__ = [
@@ -38,6 +38,9 @@ _NumberT = TypeVar("_NumberT", float, De
 # Used in mode, multimode
 _HashableT = TypeVar("_HashableT", bound=Hashable)
 
+# Used in NormalDist.samples and kde_random
+_Seed: TypeAlias = int | float | str | bytes | bytearray  # noqa: Y041
+
 class StatisticsError(ValueError): ...
 
 if sys.version_info >= (3, 11):
@@ -89,7 +92,7 @@ class NormalDist:
     def variance(self) -> float: ...
     @classmethod
     def from_samples(cls, data: Iterable[SupportsFloat]) -> Self: ...
-    def samples(self, n: int, *, seed: Any | None = None) -> list[float]: ...
+    def samples(self, n: SupportsIndex, *, seed: _Seed | None = None) -> list[float]: ...
     def pdf(self, x: float) -> float: ...
     def cdf(self, x: float) -> float: ...
     def inv_cdf(self, p: float) -> float: ...
@@ -98,15 +101,15 @@ class NormalDist:
     if sys.version_info >= (3, 9):
         def zscore(self, x: float) -> float: ...
 
-    def __eq__(self, x2: object) -> bool: ...
-    def __add__(self, x2: float | NormalDist) -> NormalDist: ...
-    def __sub__(self, x2: float | NormalDist) -> NormalDist: ...
-    def __mul__(self, x2: float) -> NormalDist: ...
-    def __truediv__(self, x2: float) -> NormalDist: ...
-    def __pos__(self) -> NormalDist: ...
-    def __neg__(self) -> NormalDist: ...
+    def __eq__(x1, x2: object) -> bool: ...
+    def __add__(x1, x2: float | NormalDist) -> NormalDist: ...
+    def __sub__(x1, x2: float | NormalDist) -> NormalDist: ...
+    def __mul__(x1, x2: float) -> NormalDist: ...
+    def __truediv__(x1, x2: float) -> NormalDist: ...
+    def __pos__(x1) -> NormalDist: ...
+    def __neg__(x1) -> NormalDist: ...
     __radd__ = __add__
-    def __rsub__(self, x2: float | NormalDist) -> NormalDist: ...
+    def __rsub__(x1, x2: float | NormalDist) -> NormalDist: ...
     __rmul__ = __mul__
     def __hash__(self) -> int: ...
 
@@ -153,9 +156,5 @@ if sys.version_info >= (3, 13):
         data: Sequence[float], h: float, kernel: _Kernel = "normal", *, cumulative: bool = False
     ) -> Callable[[float], float]: ...
     def kde_random(
-        data: Sequence[float],
-        h: float,
-        kernel: _Kernel = "normal",
-        *,
-        seed: int | float | str | bytes | bytearray | None = None,  # noqa: Y041
+        data: Sequence[float], h: float, kernel: _Kernel = "normal", *, seed: _Seed | None = None
     ) -> Callable[[], float]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/sys/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/sys/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/sys/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/sys/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -396,6 +396,7 @@ def intern(string: str, /) -> str: ...
 
 if sys.version_info >= (3, 13):
     def _is_gil_enabled() -> bool: ...
+    def _clear_internal_caches() -> None: ...
 
 def is_finalizing() -> bool: ...
 def breakpointhook(*args: Any, **kwargs: Any) -> Any: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/tarfile.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/tarfile.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/tarfile.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/tarfile.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -103,166 +103,6 @@ PAX_NAME_FIELDS: set[str]
 
 ENCODING: str
 
-@overload
-def open(
-    name: StrOrBytesPath | None = None,
-    mode: Literal["r", "r:*", "r:", "r:gz", "r:bz2", "r:xz"] = "r",
-    fileobj: IO[bytes] | None = None,
-    bufsize: int = 10240,
-    *,
-    format: int | None = ...,
-    tarinfo: type[TarInfo] | None = ...,
-    dereference: bool | None = ...,
-    ignore_zeros: bool | None = ...,
-    encoding: str | None = ...,
-    errors: str = ...,
-    pax_headers: Mapping[str, str] | None = ...,
-    debug: int | None = ...,
-    errorlevel: int | None = ...,
-) -> TarFile: ...
-@overload
-def open(
-    name: StrOrBytesPath | None,
-    mode: Literal["x", "x:", "a", "a:", "w", "w:", "w:tar"],
-    fileobj: _Fileobj | None = None,
-    bufsize: int = 10240,
-    *,
-    format: int | None = ...,
-    tarinfo: type[TarInfo] | None = ...,
-    dereference: bool | None = ...,
-    ignore_zeros: bool | None = ...,
-    encoding: str | None = ...,
-    errors: str = ...,
-    pax_headers: Mapping[str, str] | None = ...,
-    debug: int | None = ...,
-    errorlevel: int | None = ...,
-) -> TarFile: ...
-@overload
-def open(
-    name: StrOrBytesPath | None = None,
-    *,
-    mode: Literal["x", "x:", "a", "a:", "w", "w:", "w:tar"],
-    fileobj: _Fileobj | None = None,
-    bufsize: int = 10240,
-    format: int | None = ...,
-    tarinfo: type[TarInfo] | None = ...,
-    dereference: bool | None = ...,
-    ignore_zeros: bool | None = ...,
-    encoding: str | None = ...,
-    errors: str = ...,
-    pax_headers: Mapping[str, str] | None = ...,
-    debug: int | None = ...,
-    errorlevel: int | None = ...,
-) -> TarFile: ...
-@overload
-def open(
-    name: StrOrBytesPath | None,
-    mode: Literal["x:gz", "x:bz2", "w:gz", "w:bz2"],
-    fileobj: _Fileobj | None = None,
-    bufsize: int = 10240,
-    *,
-    format: int | None = ...,
-    tarinfo: type[TarInfo] | None = ...,
-    dereference: bool | None = ...,
-    ignore_zeros: bool | None = ...,
-    encoding: str | None = ...,
-    errors: str = ...,
-    pax_headers: Mapping[str, str] | None = ...,
-    debug: int | None = ...,
-    errorlevel: int | None = ...,
-    compresslevel: int = 9,
-) -> TarFile: ...
-@overload
-def open(
-    name: StrOrBytesPath | None = None,
-    *,
-    mode: Literal["x:gz", "x:bz2", "w:gz", "w:bz2"],
-    fileobj: _Fileobj | None = None,
-    bufsize: int = 10240,
-    format: int | None = ...,
-    tarinfo: type[TarInfo] | None = ...,
-    dereference: bool | None = ...,
-    ignore_zeros: bool | None = ...,
-    encoding: str | None = ...,
-    errors: str = ...,
-    pax_headers: Mapping[str, str] | None = ...,
-    debug: int | None = ...,
-    errorlevel: int | None = ...,
-    compresslevel: int = 9,
-) -> TarFile: ...
-@overload
-def open(
-    name: StrOrBytesPath | None,
-    mode: Literal["x:xz", "w:xz"],
-    fileobj: _Fileobj | None = None,
-    bufsize: int = 10240,
-    *,
-    format: int | None = ...,
-    tarinfo: type[TarInfo] | None = ...,
-    dereference: bool | None = ...,
-    ignore_zeros: bool | None = ...,
-    encoding: str | None = ...,
-    errors: str = ...,
-    pax_headers: Mapping[str, str] | None = ...,
-    debug: int | None = ...,
-    errorlevel: int | None = ...,
-    preset: Literal[0, 1, 2, 3, 4, 5, 6, 7, 8, 9] | None = ...,
-) -> TarFile: ...
-@overload
-def open(
-    name: StrOrBytesPath | None = None,
-    *,
-    mode: Literal["x:xz", "w:xz"],
-    fileobj: _Fileobj | None = None,
-    bufsize: int = 10240,
-    format: int | None = ...,
-    tarinfo: type[TarInfo] | None = ...,
-    dereference: bool | None = ...,
-    ignore_zeros: bool | None = ...,
-    encoding: str | None = ...,
-    errors: str = ...,
-    pax_headers: Mapping[str, str] | None = ...,
-    debug: int | None = ...,
-    errorlevel: int | None = ...,
-    preset: Literal[0, 1, 2, 3, 4, 5, 6, 7, 8, 9] | None = ...,
-) -> TarFile: ...
-@overload
-def open(
-    name: StrOrBytesPath | ReadableBuffer | None = None,
-    *,
-    mode: Literal["r|*", "r|", "r|gz", "r|bz2", "r|xz"],
-    fileobj: IO[bytes] | None = None,
-    bufsize: int = 10240,
-    format: int | None = ...,
-    tarinfo: type[TarInfo] | None = ...,
-    dereference: bool | None = ...,
-    ignore_zeros: bool | None = ...,
-    encoding: str | None = ...,
-    errors: str = ...,
-    pax_headers: Mapping[str, str] | None = ...,
-    debug: int | None = ...,
-    errorlevel: int | None = ...,
-    preset: int | None = ...,
-) -> TarFile: ...
-@overload
-def open(
-    name: StrOrBytesPath | WriteableBuffer | None = None,
-    *,
-    mode: Literal["w|", "w|gz", "w|bz2", "w|xz"],
-    fileobj: IO[bytes] | None = None,
-    bufsize: int = 10240,
-    format: int | None = ...,
-    tarinfo: type[TarInfo] | None = ...,
-    dereference: bool | None = ...,
-    ignore_zeros: bool | None = ...,
-    encoding: str | None = ...,
-    errors: str = ...,
-    pax_headers: Mapping[str, str] | None = ...,
-    debug: int | None = ...,
-    errorlevel: int | None = ...,
-    preset: int | None = ...,
-) -> TarFile: ...
-
 class ExFileObject(io.BufferedReader):
     def __init__(self, tarfile: TarFile, tarinfo: TarInfo) -> None: ...
 
@@ -325,14 +165,152 @@ class TarFile:
         self, type: type[BaseException] | None, value: BaseException | None, traceback: TracebackType | None
     ) -> None: ...
     def __iter__(self) -> Iterator[TarInfo]: ...
+    @overload
+    @classmethod
+    def open(
+        cls,
+        name: StrOrBytesPath | None = None,
+        mode: Literal["r", "r:*", "r:", "r:gz", "r:bz2", "r:xz"] = "r",
+        fileobj: _Fileobj | None = None,
+        bufsize: int = 10240,
+        *,
+        format: int | None = ...,
+        tarinfo: type[TarInfo] | None = ...,
+        dereference: bool | None = ...,
+        ignore_zeros: bool | None = ...,
+        encoding: str | None = ...,
+        errors: str = ...,
+        pax_headers: Mapping[str, str] | None = ...,
+        debug: int | None = ...,
+        errorlevel: int | None = ...,
+    ) -> Self: ...
+    @overload
+    @classmethod
+    def open(
+        cls,
+        name: StrOrBytesPath | None,
+        mode: Literal["x", "x:", "a", "a:", "w", "w:", "w:tar"],
+        fileobj: _Fileobj | None = None,
+        bufsize: int = 10240,
+        *,
+        format: int | None = ...,
+        tarinfo: type[TarInfo] | None = ...,
+        dereference: bool | None = ...,
+        ignore_zeros: bool | None = ...,
+        encoding: str | None = ...,
+        errors: str = ...,
+        pax_headers: Mapping[str, str] | None = ...,
+        debug: int | None = ...,
+        errorlevel: int | None = ...,
+    ) -> Self: ...
+    @overload
+    @classmethod
+    def open(
+        cls,
+        name: StrOrBytesPath | None = None,
+        *,
+        mode: Literal["x", "x:", "a", "a:", "w", "w:", "w:tar"],
+        fileobj: _Fileobj | None = None,
+        bufsize: int = 10240,
+        format: int | None = ...,
+        tarinfo: type[TarInfo] | None = ...,
+        dereference: bool | None = ...,
+        ignore_zeros: bool | None = ...,
+        encoding: str | None = ...,
+        errors: str = ...,
+        pax_headers: Mapping[str, str] | None = ...,
+        debug: int | None = ...,
+        errorlevel: int | None = ...,
+    ) -> Self: ...
+    @overload
+    @classmethod
+    def open(
+        cls,
+        name: StrOrBytesPath | None,
+        mode: Literal["x:gz", "x:bz2", "w:gz", "w:bz2"],
+        fileobj: _Fileobj | None = None,
+        bufsize: int = 10240,
+        *,
+        format: int | None = ...,
+        tarinfo: type[TarInfo] | None = ...,
+        dereference: bool | None = ...,
+        ignore_zeros: bool | None = ...,
+        encoding: str | None = ...,
+        errors: str = ...,
+        pax_headers: Mapping[str, str] | None = ...,
+        debug: int | None = ...,
+        errorlevel: int | None = ...,
+        compresslevel: int = 9,
+    ) -> Self: ...
+    @overload
+    @classmethod
+    def open(
+        cls,
+        name: StrOrBytesPath | None = None,
+        *,
+        mode: Literal["x:gz", "x:bz2", "w:gz", "w:bz2"],
+        fileobj: _Fileobj | None = None,
+        bufsize: int = 10240,
+        format: int | None = ...,
+        tarinfo: type[TarInfo] | None = ...,
+        dereference: bool | None = ...,
+        ignore_zeros: bool | None = ...,
+        encoding: str | None = ...,
+        errors: str = ...,
+        pax_headers: Mapping[str, str] | None = ...,
+        debug: int | None = ...,
+        errorlevel: int | None = ...,
+        compresslevel: int = 9,
+    ) -> Self: ...
+    @overload
+    @classmethod
+    def open(
+        cls,
+        name: StrOrBytesPath | None,
+        mode: Literal["x:xz", "w:xz"],
+        fileobj: _Fileobj | None = None,
+        bufsize: int = 10240,
+        *,
+        format: int | None = ...,
+        tarinfo: type[TarInfo] | None = ...,
+        dereference: bool | None = ...,
+        ignore_zeros: bool | None = ...,
+        encoding: str | None = ...,
+        errors: str = ...,
+        pax_headers: Mapping[str, str] | None = ...,
+        debug: int | None = ...,
+        errorlevel: int | None = ...,
+        preset: Literal[0, 1, 2, 3, 4, 5, 6, 7, 8, 9] | None = ...,
+    ) -> Self: ...
+    @overload
     @classmethod
     def open(
         cls,
         name: StrOrBytesPath | None = None,
-        mode: str = "r",
-        fileobj: IO[bytes] | None = None,  # depends on mode
+        *,
+        mode: Literal["x:xz", "w:xz"],
+        fileobj: _Fileobj | None = None,
         bufsize: int = 10240,
+        format: int | None = ...,
+        tarinfo: type[TarInfo] | None = ...,
+        dereference: bool | None = ...,
+        ignore_zeros: bool | None = ...,
+        encoding: str | None = ...,
+        errors: str = ...,
+        pax_headers: Mapping[str, str] | None = ...,
+        debug: int | None = ...,
+        errorlevel: int | None = ...,
+        preset: Literal[0, 1, 2, 3, 4, 5, 6, 7, 8, 9] | None = ...,
+    ) -> Self: ...
+    @overload
+    @classmethod
+    def open(
+        cls,
+        name: StrOrBytesPath | ReadableBuffer | None = None,
         *,
+        mode: Literal["r|*", "r|", "r|gz", "r|bz2", "r|xz"],
+        fileobj: _Fileobj | None = None,
+        bufsize: int = 10240,
         format: int | None = ...,
         tarinfo: type[TarInfo] | None = ...,
         dereference: bool | None = ...,
@@ -343,6 +321,45 @@ class TarFile:
         debug: int | None = ...,
         errorlevel: int | None = ...,
     ) -> Self: ...
+    @overload
+    @classmethod
+    def open(
+        cls,
+        name: StrOrBytesPath | WriteableBuffer | None = None,
+        *,
+        mode: Literal["w|", "w|xz"],
+        fileobj: _Fileobj | None = None,
+        bufsize: int = 10240,
+        format: int | None = ...,
+        tarinfo: type[TarInfo] | None = ...,
+        dereference: bool | None = ...,
+        ignore_zeros: bool | None = ...,
+        encoding: str | None = ...,
+        errors: str = ...,
+        pax_headers: Mapping[str, str] | None = ...,
+        debug: int | None = ...,
+        errorlevel: int | None = ...,
+    ) -> Self: ...
+    @overload
+    @classmethod
+    def open(
+        cls,
+        name: StrOrBytesPath | WriteableBuffer | None = None,
+        *,
+        mode: Literal["w|gz", "w|bz2"],
+        fileobj: _Fileobj | None = None,
+        bufsize: int = 10240,
+        format: int | None = ...,
+        tarinfo: type[TarInfo] | None = ...,
+        dereference: bool | None = ...,
+        ignore_zeros: bool | None = ...,
+        encoding: str | None = ...,
+        errors: str = ...,
+        pax_headers: Mapping[str, str] | None = ...,
+        debug: int | None = ...,
+        errorlevel: int | None = ...,
+        compresslevel: int = 9,
+    ) -> Self: ...
     @classmethod
     def taropen(
         cls,
@@ -501,6 +518,8 @@ class TarFile:
     ) -> TarInfo: ...
     def close(self) -> None: ...
 
+open = TarFile.open
+
 if sys.version_info >= (3, 9):
     def is_tarfile(name: StrOrBytesPath | IO[bytes]) -> bool: ...
 
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/tempfile.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/tempfile.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/tempfile.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/tempfile.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -387,7 +387,7 @@ class SpooledTemporaryFile(IO[AnyStr], _
     def write(self: SpooledTemporaryFile[bytes], s: ReadableBuffer) -> int: ...
     @overload
     def write(self, s: AnyStr) -> int: ...
-    @overload
+    @overload  #  type: ignore[override]
     def writelines(self: SpooledTemporaryFile[str], iterable: Iterable[str]) -> None: ...
     @overload
     def writelines(self: SpooledTemporaryFile[bytes], iterable: Iterable[ReadableBuffer]) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/tkinter/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/tkinter/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/tkinter/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/tkinter/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -265,7 +265,7 @@ else:
         GraphicsExpose = "13"
         Gravity = "24"
         KeyPress = "2"
-        Key = "2"
+        Key = KeyPress
         KeyRelease = "3"
         Keymap = "11"
         Leave = "8"
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/tkinter/ttk.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/tkinter/ttk.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/tkinter/ttk.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/tkinter/ttk.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -562,7 +562,7 @@ class Notebook(Widget):
         compound: tkinter._Compound = ...,
         underline: int = ...,
     ) -> None: ...
-    def forget(self, tab_id) -> None: ...
+    def forget(self, tab_id) -> None: ...  # type: ignore[override]
     def hide(self, tab_id) -> None: ...
     def identify(self, x: int, y: int) -> str: ...
     def index(self, tab_id): ...
@@ -1100,7 +1100,7 @@ class Treeview(Widget, tkinter.XView, tk
         open: bool = ...,
         tags: str | list[str] | tuple[str, ...] = ...,
     ) -> None: ...
-    def move(self, item: str | int, parent: str, index: int) -> None: ...
+    def move(self, item: str | int, parent: str, index: int | Literal["end"]) -> None: ...
     reattach = move
     def next(self, item: str | int) -> str: ...  # returning empty string means last item
     def parent(self, item: str | int) -> str: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/tokenize.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/tokenize.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/tokenize.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/tokenize.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -125,14 +125,16 @@ class Untokenizer:
     prev_col: int
     encoding: str | None
     def add_whitespace(self, start: _Position) -> None: ...
+    if sys.version_info >= (3, 13):
+        def add_backslash_continuation(self, start: _Position) -> None: ...
+
     def untokenize(self, iterable: Iterable[_Token]) -> str: ...
     def compat(self, token: Sequence[int | str], iterable: Iterable[_Token]) -> None: ...
     if sys.version_info >= (3, 12):
         def escape_brackets(self, token: str) -> str: ...
 
-# the docstring says "returns bytes" but is incorrect --
-# if the ENCODING token is missing, it skips the encode
-def untokenize(iterable: Iterable[_Token]) -> Any: ...
+# Returns str, unless the ENCODING token is present, in which case it returns bytes.
+def untokenize(iterable: Iterable[_Token]) -> str | Any: ...
 def detect_encoding(readline: Callable[[], bytes | bytearray]) -> tuple[str, Sequence[bytes]]: ...
 def tokenize(readline: Callable[[], bytes | bytearray]) -> Generator[TokenInfo, None, None]: ...
 def generate_tokens(readline: Callable[[], str]) -> Generator[TokenInfo, None, None]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/types.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/types.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/types.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/types.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -18,7 +18,7 @@ from importlib.machinery import ModuleSp
 
 # pytype crashes if types.MappingProxyType inherits from collections.abc.Mapping instead of typing.Mapping
 from typing import Any, ClassVar, Literal, Mapping, TypeVar, final, overload  # noqa: Y022
-from typing_extensions import ParamSpec, Self, TypeVarTuple, deprecated
+from typing_extensions import ParamSpec, Self, TypeAliasType, TypeVarTuple, deprecated
 
 __all__ = [
     "FunctionType",
@@ -615,8 +615,27 @@ def prepare_class(
 if sys.version_info >= (3, 12):
     def get_original_bases(cls: type, /) -> tuple[Any, ...]: ...
 
-# Actually a different type, but `property` is special and we want that too.
-DynamicClassAttribute = property
+# Does not actually inherit from property, but saying it does makes sure that
+# pyright handles this class correctly.
+class DynamicClassAttribute(property):
+    fget: Callable[[Any], Any] | None
+    fset: Callable[[Any, Any], object] | None  # type: ignore[assignment]
+    fdel: Callable[[Any], object] | None  # type: ignore[assignment]
+    overwrite_doc: bool
+    __isabstractmethod__: bool
+    def __init__(
+        self,
+        fget: Callable[[Any], Any] | None = None,
+        fset: Callable[[Any, Any], object] | None = None,
+        fdel: Callable[[Any], object] | None = None,
+        doc: str | None = None,
+    ) -> None: ...
+    def __get__(self, instance: Any, ownerclass: type | None = None) -> Any: ...
+    def __set__(self, instance: Any, value: Any) -> None: ...
+    def __delete__(self, instance: Any) -> None: ...
+    def getter(self, fget: Callable[[Any], Any]) -> DynamicClassAttribute: ...
+    def setter(self, fset: Callable[[Any, Any], object]) -> DynamicClassAttribute: ...
+    def deleter(self, fdel: Callable[[Any], object]) -> DynamicClassAttribute: ...
 
 _Fn = TypeVar("_Fn", bound=Callable[..., object])
 _R = TypeVar("_R")
@@ -631,7 +650,7 @@ def coroutine(func: _Fn) -> _Fn: ...
 if sys.version_info >= (3, 9):
     class GenericAlias:
         @property
-        def __origin__(self) -> type: ...
+        def __origin__(self) -> type | TypeAliasType: ...
         @property
         def __args__(self) -> tuple[Any, ...]: ...
         @property
@@ -640,6 +659,7 @@ if sys.version_info >= (3, 9):
         def __getitem__(self, typeargs: Any, /) -> GenericAlias: ...
         def __eq__(self, value: object, /) -> bool: ...
         def __hash__(self) -> int: ...
+        def __mro_entries__(self, bases: Iterable[object], /) -> tuple[type, ...]: ...
         if sys.version_info >= (3, 11):
             @property
             def __unpacked__(self) -> bool: ...
@@ -667,6 +687,8 @@ if sys.version_info >= (3, 10):
     class UnionType:
         @property
         def __args__(self) -> tuple[Any, ...]: ...
+        @property
+        def __parameters__(self) -> tuple[Any, ...]: ...
         def __or__(self, value: Any, /) -> UnionType: ...
         def __ror__(self, value: Any, /) -> UnionType: ...
         def __eq__(self, value: object, /) -> bool: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/typing.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/typing.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/typing.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/typing.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -130,8 +130,7 @@ if sys.version_info >= (3, 12):
 if sys.version_info >= (3, 13):
     __all__ += ["get_protocol_members", "is_protocol", "NoDefault", "TypeIs", "ReadOnly"]
 
-Any = object()
-
+class Any: ...
 class _Final: ...
 
 def final(f: _T) -> _T: ...
@@ -510,15 +509,15 @@ class Awaitable(Protocol[_T_co]):
     def __await__(self) -> Generator[Any, Any, _T_co]: ...
 
 # Non-default variations to accommodate couroutines, and `AwaitableGenerator` having a 4th type parameter.
-_SendT_contra_nd = TypeVar("_SendT_contra_nd", contravariant=True)
-_ReturnT_co_nd = TypeVar("_ReturnT_co_nd", covariant=True)
+_SendT_nd_contra = TypeVar("_SendT_nd_contra", contravariant=True)
+_ReturnT_nd_co = TypeVar("_ReturnT_nd_co", covariant=True)
 
-class Coroutine(Awaitable[_ReturnT_co_nd], Generic[_YieldT_co, _SendT_contra_nd, _ReturnT_co_nd]):
+class Coroutine(Awaitable[_ReturnT_nd_co], Generic[_YieldT_co, _SendT_nd_contra, _ReturnT_nd_co]):
     __name__: str
     __qualname__: str
 
     @abstractmethod
-    def send(self, value: _SendT_contra_nd, /) -> _YieldT_co: ...
+    def send(self, value: _SendT_nd_contra, /) -> _YieldT_co: ...
     @overload
     @abstractmethod
     def throw(
@@ -534,9 +533,9 @@ class Coroutine(Awaitable[_ReturnT_co_nd
 # The parameters correspond to Generator, but the 4th is the original type.
 @type_check_only
 class AwaitableGenerator(
-    Awaitable[_ReturnT_co_nd],
-    Generator[_YieldT_co, _SendT_contra_nd, _ReturnT_co_nd],
-    Generic[_YieldT_co, _SendT_contra_nd, _ReturnT_co_nd, _S],
+    Awaitable[_ReturnT_nd_co],
+    Generator[_YieldT_co, _SendT_nd_contra, _ReturnT_nd_co],
+    Generic[_YieldT_co, _SendT_nd_contra, _ReturnT_nd_co, _S],
     metaclass=ABCMeta,
 ): ...
 
@@ -950,6 +949,9 @@ class _TypedDict(Mapping[str, object], m
     # so we only add it to the stub on 3.12+
     if sys.version_info >= (3, 12):
         __orig_bases__: ClassVar[tuple[Any, ...]]
+    if sys.version_info >= (3, 13):
+        __readonly_keys__: ClassVar[frozenset[str]]
+        __mutable_keys__: ClassVar[frozenset[str]]
 
     def copy(self) -> typing_extensions.Self: ...
     # Using Never so that only calls using mypy plugin hook that specialize the signature
@@ -957,7 +959,7 @@ class _TypedDict(Mapping[str, object], m
     def setdefault(self, k: _Never, default: object) -> object: ...
     # Mypy plugin hook for 'pop' expects that 'default' has a type variable type.
     def pop(self, k: _Never, default: _T = ...) -> object: ...  # pyright: ignore[reportInvalidTypeVarUse]
-    def update(self: _T, m: _T, /) -> None: ...
+    def update(self, m: typing_extensions.Self, /) -> None: ...
     def __delitem__(self, k: _Never) -> None: ...
     def items(self) -> dict_items[str, object]: ...
     def keys(self) -> dict_keys[str, object]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/typing_extensions.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/typing_extensions.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/typing_extensions.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/typing_extensions.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,11 +1,11 @@
-# Since this module defines "Self" it is not recognized by Ruff as typing_extensions.Self
-# ruff: noqa: PYI034
 import abc
+import enum
 import sys
 import typing
 from _collections_abc import dict_items, dict_keys, dict_values
-from _typeshed import IdentityFunction
+from _typeshed import IdentityFunction, Incomplete, Unused
 from contextlib import AbstractAsyncContextManager as AsyncContextManager, AbstractContextManager as ContextManager
+from types import ModuleType
 from typing import (  # noqa: Y022,Y037,Y038,Y039
     IO as IO,
     TYPE_CHECKING as TYPE_CHECKING,
@@ -70,9 +70,10 @@ if sys.version_info >= (3, 10):
 if sys.version_info >= (3, 9):
     from types import GenericAlias
 
+# Please keep order the same as at runtime.
 __all__ = [
+    # Super-special typing primitives.
     "Any",
-    "Buffer",
     "ClassVar",
     "Concatenate",
     "Final",
@@ -85,14 +86,16 @@ __all__ = [
     "TypeVar",
     "TypeVarTuple",
     "Unpack",
+    # ABCs (from collections.abc).
     "Awaitable",
     "AsyncIterator",
     "AsyncIterable",
     "Coroutine",
     "AsyncGenerator",
     "AsyncContextManager",
-    "CapsuleType",
+    "Buffer",
     "ChainMap",
+    # Concrete collection types.
     "ContextManager",
     "Counter",
     "Deque",
@@ -100,20 +103,34 @@ __all__ = [
     "NamedTuple",
     "OrderedDict",
     "TypedDict",
-    "SupportsIndex",
+    # Structural checks, a.k.a. protocols.
     "SupportsAbs",
-    "SupportsRound",
     "SupportsBytes",
     "SupportsComplex",
     "SupportsFloat",
+    "SupportsIndex",
     "SupportsInt",
+    "SupportsRound",
+    # One-off things.
     "Annotated",
     "assert_never",
     "assert_type",
+    "clear_overloads",
     "dataclass_transform",
     "deprecated",
+    "Doc",
+    "evaluate_forward_ref",
+    "get_overloads",
     "final",
+    "Format",
+    "get_annotations",
+    "get_args",
+    "get_origin",
+    "get_original_bases",
+    "get_protocol_members",
+    "get_type_hints",
     "IntVar",
+    "is_protocol",
     "is_typeddict",
     "Literal",
     "NewType",
@@ -126,18 +143,18 @@ __all__ = [
     "Text",
     "TypeAlias",
     "TypeAliasType",
+    "TypeForm",
     "TypeGuard",
+    "TypeIs",
     "TYPE_CHECKING",
     "Never",
     "NoReturn",
+    "ReadOnly",
     "Required",
     "NotRequired",
-    "clear_overloads",
-    "get_args",
-    "get_origin",
-    "get_original_bases",
-    "get_overloads",
-    "get_type_hints",
+    "NoDefault",
+    "NoExtraItems",
+    # Pure aliases, have always been in typing
     "AbstractSet",
     "AnyStr",
     "BinaryIO",
@@ -145,7 +162,6 @@ __all__ = [
     "Collection",
     "Container",
     "Dict",
-    "Doc",
     "ForwardRef",
     "FrozenSet",
     "Generator",
@@ -163,7 +179,6 @@ __all__ = [
     "MutableMapping",
     "MutableSequence",
     "MutableSet",
-    "NoDefault",
     "Optional",
     "Pattern",
     "Reversible",
@@ -175,12 +190,10 @@ __all__ = [
     "Union",
     "ValuesView",
     "cast",
-    "get_protocol_members",
-    "is_protocol",
     "no_type_check",
     "no_type_check_decorator",
-    "ReadOnly",
-    "TypeIs",
+    # Added dynamically
+    "CapsuleType",
 ]
 
 _T = typing.TypeVar("_T")
@@ -236,7 +249,7 @@ class _TypedDict(Mapping[str, object], m
     def setdefault(self, k: Never, default: object) -> object: ...
     # Mypy plugin hook for 'pop' expects that 'default' has a type variable type.
     def pop(self, k: Never, default: _T = ...) -> object: ...  # pyright: ignore[reportInvalidTypeVarUse]
-    def update(self: _T, m: _T, /) -> None: ...
+    def update(self, m: Self, /) -> None: ...
     def items(self) -> dict_items[str, object]: ...
     def keys(self) -> dict_keys[str, object]: ...
     def values(self) -> dict_values[str, object]: ...
@@ -251,6 +264,7 @@ class _TypedDict(Mapping[str, object], m
         @overload
         def __ror__(self, value: dict[str, Any], /) -> dict[str, object]: ...
         # supposedly incompatible definitions of `__ior__` and `__or__`:
+        # Since this module defines "Self" it is not recognized by Ruff as typing_extensions.Self
         def __ior__(self, value: Self, /) -> Self: ...  # type: ignore[misc]
 
 OrderedDict = _Alias()
@@ -383,33 +397,11 @@ if sys.version_info >= (3, 12):
         SupportsIndex as SupportsIndex,
         SupportsInt as SupportsInt,
         SupportsRound as SupportsRound,
-        TypeAliasType as TypeAliasType,
         override as override,
     )
 else:
     def override(arg: _F, /) -> _F: ...
     def get_original_bases(cls: type, /) -> tuple[Any, ...]: ...
-    @final
-    class TypeAliasType:
-        def __init__(
-            self, name: str, value: Any, *, type_params: tuple[TypeVar | ParamSpec | TypeVarTuple, ...] = ()
-        ) -> None: ...
-        @property
-        def __value__(self) -> Any: ...
-        @property
-        def __type_params__(self) -> tuple[TypeVar | ParamSpec | TypeVarTuple, ...]: ...
-        @property
-        def __parameters__(self) -> tuple[Any, ...]: ...
-        @property
-        def __name__(self) -> str: ...
-        # It's writable on types, but not on instances of TypeAliasType.
-        @property
-        def __module__(self) -> str | None: ...  # type: ignore[override]
-        # Returns typing._GenericAlias, which isn't stubbed.
-        def __getitem__(self, parameters: Any) -> Any: ...
-        if sys.version_info >= (3, 10):
-            def __or__(self, right: Any) -> _SpecialForm: ...
-            def __ror__(self, left: Any) -> _SpecialForm: ...
 
     # mypy and pyright object to this being both ABC and Protocol.
     # At runtime it inherits from ABC and is not a Protocol, but it is on the
@@ -570,8 +562,71 @@ else:
     ReadOnly: _SpecialForm
     TypeIs: _SpecialForm
 
+# TypeAliasType was added in Python 3.12, but had significant changes in 3.14.
+if sys.version_info >= (3, 14):
+    from typing import TypeAliasType as TypeAliasType
+else:
+    @final
+    class TypeAliasType:
+        def __init__(
+            self, name: str, value: Any, *, type_params: tuple[TypeVar | ParamSpec | TypeVarTuple, ...] = ()
+        ) -> None: ...  # value is a type expression
+        @property
+        def __value__(self) -> Any: ...  # a type expression
+        @property
+        def __type_params__(self) -> tuple[TypeVar | ParamSpec | TypeVarTuple, ...]: ...
+        @property
+        # `__parameters__` can include special forms if a `TypeVarTuple` was
+        # passed as a `type_params` element to the constructor method.
+        def __parameters__(self) -> tuple[TypeVar | ParamSpec | Any, ...]: ...
+        @property
+        def __name__(self) -> str: ...
+        # It's writable on types, but not on instances of TypeAliasType.
+        @property
+        def __module__(self) -> str | None: ...  # type: ignore[override]
+        # Returns typing._GenericAlias, which isn't stubbed.
+        def __getitem__(self, parameters: Incomplete | tuple[Incomplete, ...]) -> Any: ...
+        def __init_subclass__(cls, *args: Unused, **kwargs: Unused) -> NoReturn: ...
+        if sys.version_info >= (3, 10):
+            def __or__(self, right: Any) -> _SpecialForm: ...
+            def __ror__(self, left: Any) -> _SpecialForm: ...
+
+# PEP 727
 class Doc:
     documentation: str
     def __init__(self, documentation: str, /) -> None: ...
     def __hash__(self) -> int: ...
     def __eq__(self, other: object) -> bool: ...
+
+# PEP 728
+class _NoExtraItemsType: ...
+
+NoExtraItems: _NoExtraItemsType
+
+# PEP 747
+TypeForm: _SpecialForm
+
+class Format(enum.IntEnum):
+    VALUE = 1
+    FORWARDREF = 2
+    STRING = 3
+
+# PEP 649/749
+def get_annotations(
+    obj: Callable[..., object] | type[object] | ModuleType,  # any callable, class, or module
+    *,
+    globals: Mapping[str, Any] | None = None,  # value types depend on the key
+    locals: Mapping[str, Any] | None = None,  # value types depend on the key
+    eval_str: bool = False,
+    format: Format = Format.VALUE,  # noqa: Y011
+) -> dict[str, Any]: ...  # values are type expressions
+def evaluate_forward_ref(
+    forward_ref: ForwardRef,
+    *,
+    owner: Callable[..., object] | type[object] | ModuleType | None = None,  # any callable, class, or module
+    globals: Mapping[str, Any] | None = None,  # value types depend on the key
+    locals: Mapping[str, Any] | None = None,  # value types depend on the key
+    type_params: Iterable[TypeVar | ParamSpec | TypeVarTuple] | None = None,
+    format: Format = Format.VALUE,  # noqa: Y011
+    _recursive_guard: Container[str] = ...,
+) -> Any: ...  # str if format is Format.STRING, otherwise a type expression
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/unittest/case.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/unittest/case.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/unittest/case.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/unittest/case.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -20,7 +20,7 @@ from typing import (
     TypeVar,
     overload,
 )
-from typing_extensions import ParamSpec, Self, TypeAlias
+from typing_extensions import Never, ParamSpec, Self, TypeAlias
 from warnings import WarningMessage
 
 if sys.version_info >= (3, 9):
@@ -323,6 +323,10 @@ class TestCase:
             self, subset: Mapping[Any, Any], dictionary: Mapping[Any, Any], msg: object = None
         ) -> None: ...
 
+    if sys.version_info >= (3, 10):
+        # Runtime has *args, **kwargs, but will error if any are supplied
+        def __init_subclass__(cls, *args: Never, **kwargs: Never) -> None: ...
+
 class FunctionTestCase(TestCase):
     def __init__(
         self,
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/warnings.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/warnings.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/warnings.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/warnings.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -3,8 +3,8 @@ import sys
 from _warnings import warn as warn, warn_explicit as warn_explicit
 from collections.abc import Sequence
 from types import ModuleType, TracebackType
-from typing import Any, Generic, Literal, TextIO, TypeVar, overload
-from typing_extensions import LiteralString, TypeAlias
+from typing import Any, Generic, Literal, TextIO, overload
+from typing_extensions import LiteralString, TypeAlias, TypeVar
 
 __all__ = [
     "warn",
@@ -21,7 +21,8 @@ if sys.version_info >= (3, 13):
     __all__ += ["deprecated"]
 
 _T = TypeVar("_T")
-_W = TypeVar("_W", bound=list[WarningMessage] | None)
+_W_co = TypeVar("_W_co", bound=list[WarningMessage] | None, default=list[WarningMessage] | None, covariant=True)
+
 if sys.version_info >= (3, 14):
     _ActionKind: TypeAlias = Literal["default", "error", "ignore", "always", "module", "once"]
 else:
@@ -66,7 +67,7 @@ class WarningMessage:
         source: Any | None = None,
     ) -> None: ...
 
-class catch_warnings(Generic[_W]):
+class catch_warnings(Generic[_W_co]):
     if sys.version_info >= (3, 11):
         @overload
         def __init__(
@@ -92,7 +93,7 @@ class catch_warnings(Generic[_W]):
         ) -> None: ...
         @overload
         def __init__(
-            self: catch_warnings[list[WarningMessage] | None],
+            self,
             *,
             record: bool,
             module: ModuleType | None = None,
@@ -109,11 +110,9 @@ class catch_warnings(Generic[_W]):
             self: catch_warnings[list[WarningMessage]], *, record: Literal[True], module: ModuleType | None = None
         ) -> None: ...
         @overload
-        def __init__(
-            self: catch_warnings[list[WarningMessage] | None], *, record: bool, module: ModuleType | None = None
-        ) -> None: ...
+        def __init__(self, *, record: bool, module: ModuleType | None = None) -> None: ...
 
-    def __enter__(self) -> _W: ...
+    def __enter__(self) -> _W_co: ...
     def __exit__(
         self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None
     ) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/dom/NodeFilter.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/NodeFilter.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/dom/NodeFilter.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/NodeFilter.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,7 +1,10 @@
+from typing import Literal
+from xml.dom.minidom import Node
+
 class NodeFilter:
-    FILTER_ACCEPT: int
-    FILTER_REJECT: int
-    FILTER_SKIP: int
+    FILTER_ACCEPT: Literal[1]
+    FILTER_REJECT: Literal[2]
+    FILTER_SKIP: Literal[3]
 
     SHOW_ALL: int
     SHOW_ELEMENT: int
@@ -16,4 +19,4 @@ class NodeFilter:
     SHOW_DOCUMENT_TYPE: int
     SHOW_DOCUMENT_FRAGMENT: int
     SHOW_NOTATION: int
-    def acceptNode(self, node) -> int: ...
+    def acceptNode(self, node: Node) -> int: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/dom/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/dom/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,69 +1,100 @@
-from typing import Any, Final
+from typing import Any, Final, Literal
 
 from .domreg import getDOMImplementation as getDOMImplementation, registerDOMImplementation as registerDOMImplementation
 
 class Node:
-    ELEMENT_NODE: int
-    ATTRIBUTE_NODE: int
-    TEXT_NODE: int
-    CDATA_SECTION_NODE: int
-    ENTITY_REFERENCE_NODE: int
-    ENTITY_NODE: int
-    PROCESSING_INSTRUCTION_NODE: int
-    COMMENT_NODE: int
-    DOCUMENT_NODE: int
-    DOCUMENT_TYPE_NODE: int
-    DOCUMENT_FRAGMENT_NODE: int
-    NOTATION_NODE: int
+    ELEMENT_NODE: Literal[1]
+    ATTRIBUTE_NODE: Literal[2]
+    TEXT_NODE: Literal[3]
+    CDATA_SECTION_NODE: Literal[4]
+    ENTITY_REFERENCE_NODE: Literal[5]
+    ENTITY_NODE: Literal[6]
+    PROCESSING_INSTRUCTION_NODE: Literal[7]
+    COMMENT_NODE: Literal[8]
+    DOCUMENT_NODE: Literal[9]
+    DOCUMENT_TYPE_NODE: Literal[10]
+    DOCUMENT_FRAGMENT_NODE: Literal[11]
+    NOTATION_NODE: Literal[12]
 
 # ExceptionCode
-INDEX_SIZE_ERR: Final[int]
-DOMSTRING_SIZE_ERR: Final[int]
-HIERARCHY_REQUEST_ERR: Final[int]
-WRONG_DOCUMENT_ERR: Final[int]
-INVALID_CHARACTER_ERR: Final[int]
-NO_DATA_ALLOWED_ERR: Final[int]
-NO_MODIFICATION_ALLOWED_ERR: Final[int]
-NOT_FOUND_ERR: Final[int]
-NOT_SUPPORTED_ERR: Final[int]
-INUSE_ATTRIBUTE_ERR: Final[int]
-INVALID_STATE_ERR: Final[int]
-SYNTAX_ERR: Final[int]
-INVALID_MODIFICATION_ERR: Final[int]
-NAMESPACE_ERR: Final[int]
-INVALID_ACCESS_ERR: Final[int]
-VALIDATION_ERR: Final[int]
+INDEX_SIZE_ERR: Final = 1
+DOMSTRING_SIZE_ERR: Final = 2
+HIERARCHY_REQUEST_ERR: Final = 3
+WRONG_DOCUMENT_ERR: Final = 4
+INVALID_CHARACTER_ERR: Final = 5
+NO_DATA_ALLOWED_ERR: Final = 6
+NO_MODIFICATION_ALLOWED_ERR: Final = 7
+NOT_FOUND_ERR: Final = 8
+NOT_SUPPORTED_ERR: Final = 9
+INUSE_ATTRIBUTE_ERR: Final = 10
+INVALID_STATE_ERR: Final = 11
+SYNTAX_ERR: Final = 12
+INVALID_MODIFICATION_ERR: Final = 13
+NAMESPACE_ERR: Final = 14
+INVALID_ACCESS_ERR: Final = 15
+VALIDATION_ERR: Final = 16
 
 class DOMException(Exception):
     code: int
     def __init__(self, *args: Any, **kw: Any) -> None: ...
     def _get_code(self) -> int: ...
 
-class IndexSizeErr(DOMException): ...
-class DomstringSizeErr(DOMException): ...
-class HierarchyRequestErr(DOMException): ...
-class WrongDocumentErr(DOMException): ...
-class InvalidCharacterErr(DOMException): ...
-class NoDataAllowedErr(DOMException): ...
-class NoModificationAllowedErr(DOMException): ...
-class NotFoundErr(DOMException): ...
-class NotSupportedErr(DOMException): ...
-class InuseAttributeErr(DOMException): ...
-class InvalidStateErr(DOMException): ...
-class SyntaxErr(DOMException): ...
-class InvalidModificationErr(DOMException): ...
-class NamespaceErr(DOMException): ...
-class InvalidAccessErr(DOMException): ...
-class ValidationErr(DOMException): ...
+class IndexSizeErr(DOMException):
+    code: Literal[1]
+
+class DomstringSizeErr(DOMException):
+    code: Literal[2]
+
+class HierarchyRequestErr(DOMException):
+    code: Literal[3]
+
+class WrongDocumentErr(DOMException):
+    code: Literal[4]
+
+class InvalidCharacterErr(DOMException):
+    code: Literal[5]
+
+class NoDataAllowedErr(DOMException):
+    code: Literal[6]
+
+class NoModificationAllowedErr(DOMException):
+    code: Literal[7]
+
+class NotFoundErr(DOMException):
+    code: Literal[8]
+
+class NotSupportedErr(DOMException):
+    code: Literal[9]
+
+class InuseAttributeErr(DOMException):
+    code: Literal[10]
+
+class InvalidStateErr(DOMException):
+    code: Literal[11]
+
+class SyntaxErr(DOMException):
+    code: Literal[12]
+
+class InvalidModificationErr(DOMException):
+    code: Literal[13]
+
+class NamespaceErr(DOMException):
+    code: Literal[14]
+
+class InvalidAccessErr(DOMException):
+    code: Literal[15]
+
+class ValidationErr(DOMException):
+    code: Literal[16]
 
 class UserDataHandler:
-    NODE_CLONED: int
-    NODE_IMPORTED: int
-    NODE_DELETED: int
-    NODE_RENAMED: int
-
-XML_NAMESPACE: Final[str]
-XMLNS_NAMESPACE: Final[str]
-XHTML_NAMESPACE: Final[str]
+    NODE_CLONED: Literal[1]
+    NODE_IMPORTED: Literal[2]
+    NODE_DELETED: Literal[3]
+    NODE_RENAMED: Literal[4]
+
+XML_NAMESPACE: Final = "http://www.w3.org/XML/1998/namespace"
+XMLNS_NAMESPACE: Final = "http://www.w3.org/2000/xmlns/"
+XHTML_NAMESPACE: Final = "http://www.w3.org/1999/xhtml"
 EMPTY_NAMESPACE: Final[None]
 EMPTY_PREFIX: Final[None]
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/dom/expatbuilder.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/expatbuilder.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/dom/expatbuilder.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/expatbuilder.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,7 +1,11 @@
-from _typeshed import Incomplete, ReadableBuffer, SupportsRead
+from _typeshed import ReadableBuffer, SupportsRead
 from typing import Any, NoReturn
-from xml.dom.minidom import Document, DOMImplementation, Node, TypeInfo
+from typing_extensions import TypeAlias
+from xml.dom.minidom import Document, DocumentFragment, DOMImplementation, Element, Node, TypeInfo
 from xml.dom.xmlbuilder import DOMBuilderFilter, Options
+from xml.parsers.expat import XMLParserType
+
+_Model: TypeAlias = tuple[int, int, str | None, tuple[Any, ...]]  # same as in pyexpat
 
 TEXT_NODE = Node.TEXT_NODE
 CDATA_SECTION_NODE = Node.CDATA_SECTION_NODE
@@ -10,45 +14,56 @@ FILTER_ACCEPT = DOMBuilderFilter.FILTER_
 FILTER_REJECT = DOMBuilderFilter.FILTER_REJECT
 FILTER_SKIP = DOMBuilderFilter.FILTER_SKIP
 FILTER_INTERRUPT = DOMBuilderFilter.FILTER_INTERRUPT
-theDOMImplementation: DOMImplementation | None
+theDOMImplementation: DOMImplementation
 
 class ElementInfo:
-    tagName: Incomplete
-    def __init__(self, tagName, model: Incomplete | None = None) -> None: ...
-    def getAttributeType(self, aname) -> TypeInfo: ...
-    def getAttributeTypeNS(self, namespaceURI, localName) -> TypeInfo: ...
+    tagName: str
+    def __init__(self, tagName: str, model: _Model | None = None) -> None: ...
+    def getAttributeType(self, aname: str) -> TypeInfo: ...
+    def getAttributeTypeNS(self, namespaceURI: str | None, localName: str) -> TypeInfo: ...
     def isElementContent(self) -> bool: ...
     def isEmpty(self) -> bool: ...
-    def isId(self, aname) -> bool: ...
-    def isIdNS(self, euri, ename, auri, aname) -> bool: ...
+    def isId(self, aname: str) -> bool: ...
+    def isIdNS(self, euri: str, ename: str, auri: str, aname: str) -> bool: ...
 
 class ExpatBuilder:
     document: Document  # Created in self.reset()
-    curNode: Incomplete  # Created in self.reset()
+    curNode: DocumentFragment | Element | Document  # Created in self.reset()
     def __init__(self, options: Options | None = None) -> None: ...
-    def createParser(self): ...
-    def getParser(self): ...
+    def createParser(self) -> XMLParserType: ...
+    def getParser(self) -> XMLParserType: ...
     def reset(self) -> None: ...
-    def install(self, parser) -> None: ...
+    def install(self, parser: XMLParserType) -> None: ...
     def parseFile(self, file: SupportsRead[ReadableBuffer | str]) -> Document: ...
     def parseString(self, string: str | ReadableBuffer) -> Document: ...
-    def start_doctype_decl_handler(self, doctypeName, systemId, publicId, has_internal_subset) -> None: ...
+    def start_doctype_decl_handler(
+        self, doctypeName: str, systemId: str | None, publicId: str | None, has_internal_subset: bool
+    ) -> None: ...
     def end_doctype_decl_handler(self) -> None: ...
-    def pi_handler(self, target, data) -> None: ...
-    def character_data_handler_cdata(self, data) -> None: ...
-    def character_data_handler(self, data) -> None: ...
+    def pi_handler(self, target: str, data: str) -> None: ...
+    def character_data_handler_cdata(self, data: str) -> None: ...
+    def character_data_handler(self, data: str) -> None: ...
     def start_cdata_section_handler(self) -> None: ...
     def end_cdata_section_handler(self) -> None: ...
-    def entity_decl_handler(self, entityName, is_parameter_entity, value, base, systemId, publicId, notationName) -> None: ...
-    def notation_decl_handler(self, notationName, base, systemId, publicId) -> None: ...
-    def comment_handler(self, data) -> None: ...
-    def external_entity_ref_handler(self, context, base, systemId, publicId) -> int: ...
-    def first_element_handler(self, name, attributes) -> None: ...
-    def start_element_handler(self, name, attributes) -> None: ...
-    def end_element_handler(self, name) -> None: ...
-    def element_decl_handler(self, name, model) -> None: ...
-    def attlist_decl_handler(self, elem, name, type, default, required) -> None: ...
-    def xml_decl_handler(self, version, encoding, standalone) -> None: ...
+    def entity_decl_handler(
+        self,
+        entityName: str,
+        is_parameter_entity: bool,
+        value: str | None,
+        base: str | None,
+        systemId: str,
+        publicId: str | None,
+        notationName: str | None,
+    ) -> None: ...
+    def notation_decl_handler(self, notationName: str, base: str | None, systemId: str, publicId: str | None) -> None: ...
+    def comment_handler(self, data: str) -> None: ...
+    def external_entity_ref_handler(self, context: str, base: str | None, systemId: str | None, publicId: str | None) -> int: ...
+    def first_element_handler(self, name: str, attributes: list[str]) -> None: ...
+    def start_element_handler(self, name: str, attributes: list[str]) -> None: ...
+    def end_element_handler(self, name: str) -> None: ...
+    def element_decl_handler(self, name: str, model: _Model) -> None: ...
+    def attlist_decl_handler(self, elem: str, name: str, type: str, default: str | None, required: bool) -> None: ...
+    def xml_decl_handler(self, version: str, encoding: str | None, standalone: int) -> None: ...
 
 class FilterVisibilityController:
     filter: DOMBuilderFilter
@@ -57,7 +72,7 @@ class FilterVisibilityController:
     def acceptNode(self, node: Node) -> int: ...
 
 class FilterCrutch:
-    def __init__(self, builder) -> None: ...
+    def __init__(self, builder: ExpatBuilder) -> None: ...
 
 class Rejecter(FilterCrutch):
     def start_element_handler(self, *args: Any) -> None: ...
@@ -68,33 +83,39 @@ class Skipper(FilterCrutch):
     def end_element_handler(self, *args: Any) -> None: ...
 
 class FragmentBuilder(ExpatBuilder):
-    fragment: Incomplete | None
-    originalDocument: Incomplete
-    context: Incomplete
-    def __init__(self, context, options: Options | None = None) -> None: ...
+    fragment: DocumentFragment | None
+    originalDocument: Document
+    context: Node
+    def __init__(self, context: Node, options: Options | None = None) -> None: ...
+    def reset(self) -> None: ...
+    def parseFile(self, file: SupportsRead[ReadableBuffer | str]) -> DocumentFragment: ...  # type: ignore[override]
+    def parseString(self, string: ReadableBuffer | str) -> DocumentFragment: ...  # type: ignore[override]
+    def external_entity_ref_handler(self, context: str, base: str | None, systemId: str | None, publicId: str | None) -> int: ...
 
 class Namespaces:
-    def createParser(self): ...
-    def install(self, parser) -> None: ...
-    def start_namespace_decl_handler(self, prefix, uri) -> None: ...
-    def start_element_handler(self, name, attributes) -> None: ...
-    def end_element_handler(self, name) -> None: ...
+    def createParser(self) -> XMLParserType: ...
+    def install(self, parser: XMLParserType) -> None: ...
+    def start_namespace_decl_handler(self, prefix: str | None, uri: str) -> None: ...
+    def start_element_handler(self, name: str, attributes: list[str]) -> None: ...
+    def end_element_handler(self, name: str) -> None: ...  # only exists if __debug__
 
 class ExpatBuilderNS(Namespaces, ExpatBuilder): ...
 class FragmentBuilderNS(Namespaces, FragmentBuilder): ...
 class ParseEscape(Exception): ...
 
 class InternalSubsetExtractor(ExpatBuilder):
-    subset: Any | None
-    def getSubset(self) -> Any | None: ...
+    subset: str | list[str] | None = None
+    def getSubset(self) -> str: ...
     def parseFile(self, file: SupportsRead[ReadableBuffer | str]) -> None: ...  # type: ignore[override]
     def parseString(self, string: str | ReadableBuffer) -> None: ...  # type: ignore[override]
-    def start_doctype_decl_handler(self, name, publicId, systemId, has_internal_subset) -> None: ...  # type: ignore[override]
+    def start_doctype_decl_handler(  # type: ignore[override]
+        self, name: str, publicId: str | None, systemId: str | None, has_internal_subset: bool
+    ) -> None: ...
     def end_doctype_decl_handler(self) -> NoReturn: ...
-    def start_element_handler(self, name, attrs) -> NoReturn: ...
+    def start_element_handler(self, name: str, attrs: list[str]) -> NoReturn: ...
 
-def parse(file: str | SupportsRead[ReadableBuffer | str], namespaces: bool = True): ...
-def parseString(string: str | ReadableBuffer, namespaces: bool = True): ...
-def parseFragment(file, context, namespaces: bool = True): ...
-def parseFragmentString(string: str, context, namespaces: bool = True): ...
+def parse(file: str | SupportsRead[ReadableBuffer | str], namespaces: bool = True) -> Document: ...
+def parseString(string: str | ReadableBuffer, namespaces: bool = True) -> Document: ...
+def parseFragment(file: str | SupportsRead[ReadableBuffer | str], context: Node, namespaces: bool = True) -> DocumentFragment: ...
+def parseFragmentString(string: str | ReadableBuffer, context: Node, namespaces: bool = True) -> DocumentFragment: ...
 def makeBuilder(options: Options) -> ExpatBuilderNS | ExpatBuilder: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/dom/minidom.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/minidom.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/dom/minidom.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/minidom.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,33 +1,92 @@
 import sys
 import xml.dom
+from _collections_abc import dict_keys, dict_values
 from _typeshed import Incomplete, ReadableBuffer, SupportsRead, SupportsWrite
-from typing import ClassVar, Literal, NoReturn, TypeVar, overload
-from typing_extensions import Self
-from xml.dom.minicompat import NodeList
+from collections.abc import Iterable, Sequence
+from types import TracebackType
+from typing import Any, ClassVar, Generic, Literal, NoReturn, Protocol, TypeVar, overload
+from typing_extensions import Self, TypeAlias
+from xml.dom.minicompat import EmptyNodeList, NodeList
 from xml.dom.xmlbuilder import DocumentLS, DOMImplementationLS
 from xml.sax.xmlreader import XMLReader
 
+_NSName: TypeAlias = tuple[str | None, str]
+
+# Entity can also have children, but it's not implemented the same way as the
+# others, so is deliberately omitted here.
+_NodesWithChildren: TypeAlias = DocumentFragment | Attr | Element | Document
+_NodesThatAreChildren: TypeAlias = CDATASection | Comment | DocumentType | Element | Notation | ProcessingInstruction | Text
+
+_AttrChildren: TypeAlias = Text  # Also EntityReference, but we don't implement it
+_ElementChildren: TypeAlias = Element | ProcessingInstruction | Comment | Text | CDATASection
+_EntityChildren: TypeAlias = Text  # I think; documentation is a little unclear
+_DocumentFragmentChildren: TypeAlias = Element | Text | CDATASection | ProcessingInstruction | Comment | Notation
+_DocumentChildren: TypeAlias = Comment | DocumentType | Element | ProcessingInstruction
+
 _N = TypeVar("_N", bound=Node)
+_ChildNodeVar = TypeVar("_ChildNodeVar", bound=_NodesThatAreChildren)
+_ChildNodePlusFragmentVar = TypeVar("_ChildNodePlusFragmentVar", bound=_NodesThatAreChildren | DocumentFragment)
+_DocumentChildrenVar = TypeVar("_DocumentChildrenVar", bound=_DocumentChildren)
+_ImportableNodeVar = TypeVar(
+    "_ImportableNodeVar",
+    bound=DocumentFragment
+    | Attr
+    | Element
+    | ProcessingInstruction
+    | CharacterData
+    | Text
+    | Comment
+    | CDATASection
+    | Entity
+    | Notation,
+)
+
+class _DOMErrorHandler(Protocol):
+    def handleError(self, error: Exception) -> bool: ...
+
+class _UserDataHandler(Protocol):
+    def handle(self, operation: int, key: str, data: Any, src: Node, dst: Node) -> None: ...
 
 def parse(
     file: str | SupportsRead[ReadableBuffer | str], parser: XMLReader | None = None, bufsize: int | None = None
 ) -> Document: ...
 def parseString(string: str | ReadableBuffer, parser: XMLReader | None = None) -> Document: ...
-def getDOMImplementation(features=None) -> DOMImplementation | None: ...
+@overload
+def getDOMImplementation(features: None = None) -> DOMImplementation: ...
+@overload
+def getDOMImplementation(features: str | Iterable[tuple[str, str | None]]) -> DOMImplementation | None: ...
 
 class Node(xml.dom.Node):
-    namespaceURI: str | None
-    parentNode: Incomplete
-    ownerDocument: Incomplete
-    nextSibling: Incomplete
-    previousSibling: Incomplete
-    prefix: Incomplete
+    parentNode: _NodesWithChildren | Entity | None
+    ownerDocument: Document | None
+    nextSibling: _NodesThatAreChildren | None
+    previousSibling: _NodesThatAreChildren | None
+    namespaceURI: str | None  # non-null only for Element and Attr
+    prefix: str | None  # non-null only for NS Element and Attr
+
+    # These aren't defined on Node, but they exist on all Node subclasses
+    # and various methods of Node require them to exist.
+    childNodes: (
+        NodeList[_DocumentFragmentChildren]
+        | NodeList[_AttrChildren]
+        | NodeList[_ElementChildren]
+        | NodeList[_DocumentChildren]
+        | NodeList[_EntityChildren]
+        | EmptyNodeList
+    )
+    nodeType: ClassVar[Literal[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]]
+    nodeName: str | None  # only possibly None on DocumentType
+
+    # Not defined on Node, but exist on all Node subclasses.
+    nodeValue: str | None  # non-null for Attr, ProcessingInstruction, Text, Comment, and CDATASection
+    attributes: NamedNodeMap | None  # non-null only for Element
+
     @property
-    def firstChild(self) -> Node | None: ...
+    def firstChild(self) -> _NodesThatAreChildren | None: ...
     @property
-    def lastChild(self) -> Node | None: ...
+    def lastChild(self) -> _NodesThatAreChildren | None: ...
     @property
-    def localName(self) -> str | None: ...
+    def localName(self) -> str | None: ...  # non-null only for Element and Attr
     def __bool__(self) -> Literal[True]: ...
     if sys.version_info >= (3, 9):
         @overload
@@ -95,62 +154,125 @@ class Node(xml.dom.Node):
         ) -> bytes: ...
 
     def hasChildNodes(self) -> bool: ...
-    def insertBefore(self, newChild, refChild): ...
-    def appendChild(self, node: _N) -> _N: ...
-    def replaceChild(self, newChild, oldChild): ...
-    def removeChild(self, oldChild): ...
-    def normalize(self) -> None: ...
-    def cloneNode(self, deep): ...
-    def isSupported(self, feature, version): ...
-    def isSameNode(self, other): ...
-    def getInterface(self, feature): ...
-    def getUserData(self, key): ...
-    def setUserData(self, key, data, handler): ...
-    childNodes: Incomplete
+    def insertBefore(  # type: ignore[misc]
+        self: _NodesWithChildren,  # pyright: ignore[reportGeneralTypeIssues]
+        newChild: _ChildNodePlusFragmentVar,
+        refChild: _NodesThatAreChildren | None,
+    ) -> _ChildNodePlusFragmentVar: ...
+    def appendChild(  # type: ignore[misc]
+        self: _NodesWithChildren, node: _ChildNodePlusFragmentVar  # pyright: ignore[reportGeneralTypeIssues]
+    ) -> _ChildNodePlusFragmentVar: ...
+    @overload
+    def replaceChild(  # type: ignore[misc]
+        self: _NodesWithChildren, newChild: DocumentFragment, oldChild: _ChildNodeVar
+    ) -> _ChildNodeVar | DocumentFragment: ...
+    @overload
+    def replaceChild(  # type: ignore[misc]
+        self: _NodesWithChildren, newChild: _NodesThatAreChildren, oldChild: _ChildNodeVar
+    ) -> _ChildNodeVar | None: ...
+    def removeChild(self: _NodesWithChildren, oldChild: _ChildNodeVar) -> _ChildNodeVar: ...  # type: ignore[misc]  # pyright: ignore[reportGeneralTypeIssues]
+    def normalize(self: _NodesWithChildren) -> None: ...  # type: ignore[misc]  # pyright: ignore[reportGeneralTypeIssues]
+    def cloneNode(self, deep: bool) -> Self | None: ...
+    def isSupported(self, feature: str, version: str | None) -> bool: ...
+    def isSameNode(self, other: Node) -> bool: ...
+    def getInterface(self, feature: str) -> Self | None: ...
+    def getUserData(self, key: str) -> Any | None: ...
+    def setUserData(self, key: str, data: Any, handler: _UserDataHandler) -> Any: ...
     def unlink(self) -> None: ...
     def __enter__(self) -> Self: ...
-    def __exit__(self, et, ev, tb) -> None: ...
+    def __exit__(self, et: type[BaseException] | None, ev: BaseException | None, tb: TracebackType | None) -> None: ...
+
+_DFChildrenVar = TypeVar("_DFChildrenVar", bound=_DocumentFragmentChildren)
+_DFChildrenPlusFragment = TypeVar("_DFChildrenPlusFragment", bound=_DocumentFragmentChildren | DocumentFragment)
 
 class DocumentFragment(Node):
-    nodeType: int
-    nodeName: str
-    nodeValue: Incomplete
-    attributes: Incomplete
-    parentNode: Incomplete
-    childNodes: Incomplete
+    nodeType: ClassVar[Literal[11]]
+    nodeName: Literal["#document-fragment"]
+    nodeValue: None
+    attributes: None
+
+    parentNode: None
+    nextSibling: None
+    previousSibling: None
+    childNodes: NodeList[_DocumentFragmentChildren]
+    @property
+    def firstChild(self) -> _DocumentFragmentChildren | None: ...
+    @property
+    def lastChild(self) -> _DocumentFragmentChildren | None: ...
+
+    namespaceURI: None
+    prefix: None
+    @property
+    def localName(self) -> None: ...
     def __init__(self) -> None: ...
+    def insertBefore(  # type: ignore[override]
+        self, newChild: _DFChildrenPlusFragment, refChild: _DocumentFragmentChildren | None
+    ) -> _DFChildrenPlusFragment: ...
+    def appendChild(self, node: _DFChildrenPlusFragment) -> _DFChildrenPlusFragment: ...  # type: ignore[override]
+    @overload  # type: ignore[override]
+    def replaceChild(self, newChild: DocumentFragment, oldChild: _DFChildrenVar) -> _DFChildrenVar | DocumentFragment: ...
+    @overload
+    def replaceChild(self, newChild: _DocumentFragmentChildren, oldChild: _DFChildrenVar) -> _DFChildrenVar | None: ...  # type: ignore[override]
+    def removeChild(self, oldChild: _DFChildrenVar) -> _DFChildrenVar: ...  # type: ignore[override]
+
+_AttrChildrenVar = TypeVar("_AttrChildrenVar", bound=_AttrChildren)
+_AttrChildrenPlusFragment = TypeVar("_AttrChildrenPlusFragment", bound=_AttrChildren | DocumentFragment)
 
 class Attr(Node):
-    name: str
-    nodeType: int
-    attributes: Incomplete
-    specified: bool
-    ownerElement: Incomplete
+    nodeType: ClassVar[Literal[2]]
+    nodeName: str  # same as Attr.name
+    nodeValue: str  # same as Attr.value
+    attributes: None
+
+    parentNode: None
+    nextSibling: None
+    previousSibling: None
+    childNodes: NodeList[_AttrChildren]
+    @property
+    def firstChild(self) -> _AttrChildren | None: ...
+    @property
+    def lastChild(self) -> _AttrChildren | None: ...
+
     namespaceURI: str | None
-    childNodes: Incomplete
-    nodeName: Incomplete
-    nodeValue: str
+    prefix: str | None
+    @property
+    def localName(self) -> str: ...
+
+    name: str
     value: str
-    prefix: Incomplete
+    specified: bool
+    ownerElement: Element | None
+
     def __init__(
-        self, qName: str, namespaceURI: str | None = None, localName: str | None = None, prefix: Incomplete | None = None
+        self, qName: str, namespaceURI: str | None = None, localName: str | None = None, prefix: str | None = None
     ) -> None: ...
     def unlink(self) -> None: ...
     @property
     def isId(self) -> bool: ...
     @property
-    def schemaType(self): ...
+    def schemaType(self) -> TypeInfo: ...
+    def insertBefore(self, newChild: _AttrChildrenPlusFragment, refChild: _AttrChildren | None) -> _AttrChildrenPlusFragment: ...  # type: ignore[override]
+    def appendChild(self, node: _AttrChildrenPlusFragment) -> _AttrChildrenPlusFragment: ...  # type: ignore[override]
+    @overload  # type: ignore[override]
+    def replaceChild(self, newChild: DocumentFragment, oldChild: _AttrChildrenVar) -> _AttrChildrenVar | DocumentFragment: ...
+    @overload
+    def replaceChild(self, newChild: _AttrChildren, oldChild: _AttrChildrenVar) -> _AttrChildrenVar | None: ...  # type: ignore[override]
+    def removeChild(self, oldChild: _AttrChildrenVar) -> _AttrChildrenVar: ...  # type: ignore[override]
 
+# In the DOM, this interface isn't specific to Attr, but our implementation is
+# because that's the only place we use it.
 class NamedNodeMap:
-    def __init__(self, attrs, attrsNS, ownerElement) -> None: ...
-    def item(self, index): ...
-    def items(self): ...
-    def itemsNS(self): ...
-    def __contains__(self, key): ...
-    def keys(self): ...
-    def keysNS(self): ...
-    def values(self): ...
-    def get(self, name: str, value: Incomplete | None = None): ...
+    def __init__(self, attrs: dict[str, Attr], attrsNS: dict[_NSName, Attr], ownerElement: Element) -> None: ...
+    @property
+    def length(self) -> int: ...
+    def item(self, index: int) -> Node | None: ...
+    def items(self) -> list[tuple[str, str]]: ...
+    def itemsNS(self) -> list[tuple[_NSName, str]]: ...
+    def __contains__(self, key: str | _NSName) -> bool: ...
+    def keys(self) -> dict_keys[str, Attr]: ...
+    def keysNS(self) -> dict_keys[_NSName, Attr]: ...
+    def values(self) -> dict_values[str, Attr]: ...
+    def get(self, name: str, value: Attr | None = None) -> Attr | None: ...
     __hash__: ClassVar[None]  # type: ignore[assignment]
     def __len__(self) -> int: ...
     def __eq__(self, other: object) -> bool: ...
@@ -158,135 +280,227 @@ class NamedNodeMap:
     def __gt__(self, other: NamedNodeMap) -> bool: ...
     def __le__(self, other: NamedNodeMap) -> bool: ...
     def __lt__(self, other: NamedNodeMap) -> bool: ...
-    def __getitem__(self, attname_or_tuple: tuple[str, str | None] | str): ...
+    def __getitem__(self, attname_or_tuple: _NSName | str) -> Attr: ...
     def __setitem__(self, attname: str, value: Attr | str) -> None: ...
     def getNamedItem(self, name: str) -> Attr | None: ...
-    def getNamedItemNS(self, namespaceURI: str, localName: str | None) -> Attr | None: ...
+    def getNamedItemNS(self, namespaceURI: str | None, localName: str) -> Attr | None: ...
     def removeNamedItem(self, name: str) -> Attr: ...
-    def removeNamedItemNS(self, namespaceURI: str, localName: str | None): ...
-    def setNamedItem(self, node: Attr) -> Attr: ...
-    def setNamedItemNS(self, node: Attr) -> Attr: ...
-    def __delitem__(self, attname_or_tuple: tuple[str, str | None] | str) -> None: ...
-    @property
-    def length(self) -> int: ...
+    def removeNamedItemNS(self, namespaceURI: str | None, localName: str) -> Attr: ...
+    def setNamedItem(self, node: Attr) -> Attr | None: ...
+    def setNamedItemNS(self, node: Attr) -> Attr | None: ...
+    def __delitem__(self, attname_or_tuple: _NSName | str) -> None: ...
 
 AttributeList = NamedNodeMap
 
 class TypeInfo:
-    namespace: Incomplete | None
-    name: str
-    def __init__(self, namespace: Incomplete | None, name: str) -> None: ...
+    namespace: str | None
+    name: str | None
+    def __init__(self, namespace: Incomplete | None, name: str | None) -> None: ...
+
+_ElementChildrenVar = TypeVar("_ElementChildrenVar", bound=_ElementChildren)
+_ElementChildrenPlusFragment = TypeVar("_ElementChildrenPlusFragment", bound=_ElementChildren | DocumentFragment)
 
 class Element(Node):
-    nodeType: int
-    nodeValue: Incomplete
-    schemaType: Incomplete
-    parentNode: Incomplete
-    tagName: str
-    nodeName: str
-    prefix: Incomplete
+    nodeType: ClassVar[Literal[1]]
+    nodeName: str  # same as Element.tagName
+    nodeValue: None
+    @property
+    def attributes(self) -> NamedNodeMap: ...  # type: ignore[override]
+
+    parentNode: Document | Element | DocumentFragment | None
+    nextSibling: _DocumentChildren | _ElementChildren | _DocumentFragmentChildren | None
+    previousSibling: _DocumentChildren | _ElementChildren | _DocumentFragmentChildren | None
+    childNodes: NodeList[_ElementChildren]
+    @property
+    def firstChild(self) -> _ElementChildren | None: ...
+    @property
+    def lastChild(self) -> _ElementChildren | None: ...
+
     namespaceURI: str | None
-    childNodes: Incomplete
-    nextSibling: Incomplete
+    prefix: str | None
+    @property
+    def localName(self) -> str: ...
+
+    schemaType: TypeInfo
+    tagName: str
+
     def __init__(
-        self, tagName, namespaceURI: str | None = None, prefix: Incomplete | None = None, localName: Incomplete | None = None
+        self, tagName: str, namespaceURI: str | None = None, prefix: str | None = None, localName: str | None = None
     ) -> None: ...
     def unlink(self) -> None: ...
     def getAttribute(self, attname: str) -> str: ...
-    def getAttributeNS(self, namespaceURI: str, localName): ...
+    def getAttributeNS(self, namespaceURI: str | None, localName: str) -> str: ...
     def setAttribute(self, attname: str, value: str) -> None: ...
-    def setAttributeNS(self, namespaceURI: str, qualifiedName: str, value) -> None: ...
-    def getAttributeNode(self, attrname: str): ...
-    def getAttributeNodeNS(self, namespaceURI: str, localName): ...
-    def setAttributeNode(self, attr): ...
-    setAttributeNodeNS: Incomplete
+    def setAttributeNS(self, namespaceURI: str | None, qualifiedName: str, value: str) -> None: ...
+    def getAttributeNode(self, attrname: str) -> Attr | None: ...
+    def getAttributeNodeNS(self, namespaceURI: str | None, localName: str) -> Attr | None: ...
+    def setAttributeNode(self, attr: Attr) -> Attr | None: ...
+    setAttributeNodeNS = setAttributeNode
     def removeAttribute(self, name: str) -> None: ...
-    def removeAttributeNS(self, namespaceURI: str, localName) -> None: ...
-    def removeAttributeNode(self, node): ...
-    removeAttributeNodeNS: Incomplete
+    def removeAttributeNS(self, namespaceURI: str | None, localName: str) -> None: ...
+    def removeAttributeNode(self, node: Attr) -> Attr: ...
+    removeAttributeNodeNS = removeAttributeNode
     def hasAttribute(self, name: str) -> bool: ...
-    def hasAttributeNS(self, namespaceURI: str, localName) -> bool: ...
+    def hasAttributeNS(self, namespaceURI: str | None, localName: str) -> bool: ...
     def getElementsByTagName(self, name: str) -> NodeList[Element]: ...
-    def getElementsByTagNameNS(self, namespaceURI: str, localName: str) -> NodeList[Element]: ...
+    def getElementsByTagNameNS(self, namespaceURI: str | None, localName: str) -> NodeList[Element]: ...
     def writexml(self, writer: SupportsWrite[str], indent: str = "", addindent: str = "", newl: str = "") -> None: ...
     def hasAttributes(self) -> bool: ...
-    def setIdAttribute(self, name) -> None: ...
-    def setIdAttributeNS(self, namespaceURI: str, localName) -> None: ...
-    def setIdAttributeNode(self, idAttr) -> None: ...
-    @property
-    def attributes(self) -> NamedNodeMap: ...
+    def setIdAttribute(self, name: str) -> None: ...
+    def setIdAttributeNS(self, namespaceURI: str | None, localName: str) -> None: ...
+    def setIdAttributeNode(self, idAttr: Attr) -> None: ...
+    def insertBefore(  # type: ignore[override]
+        self, newChild: _ElementChildrenPlusFragment, refChild: _ElementChildren | None
+    ) -> _ElementChildrenPlusFragment: ...
+    def appendChild(self, node: _ElementChildrenPlusFragment) -> _ElementChildrenPlusFragment: ...  # type: ignore[override]
+    @overload  # type: ignore[override]
+    def replaceChild(
+        self, newChild: DocumentFragment, oldChild: _ElementChildrenVar
+    ) -> _ElementChildrenVar | DocumentFragment: ...
+    @overload
+    def replaceChild(self, newChild: _ElementChildren, oldChild: _ElementChildrenVar) -> _ElementChildrenVar | None: ...  # type: ignore[override]
+    def removeChild(self, oldChild: _ElementChildrenVar) -> _ElementChildrenVar: ...  # type: ignore[override]
 
 class Childless:
-    attributes: Incomplete
-    childNodes: Incomplete
-    firstChild: Incomplete
-    lastChild: Incomplete
-    def appendChild(self, node) -> NoReturn: ...
-    def hasChildNodes(self) -> bool: ...
-    def insertBefore(self, newChild, refChild) -> NoReturn: ...
-    def removeChild(self, oldChild) -> NoReturn: ...
+    attributes: None
+    childNodes: EmptyNodeList
+    @property
+    def firstChild(self) -> None: ...
+    @property
+    def lastChild(self) -> None: ...
+    def appendChild(self, node: _NodesThatAreChildren | DocumentFragment) -> NoReturn: ...
+    def hasChildNodes(self) -> Literal[False]: ...
+    def insertBefore(
+        self, newChild: _NodesThatAreChildren | DocumentFragment, refChild: _NodesThatAreChildren | None
+    ) -> NoReturn: ...
+    def removeChild(self, oldChild: _NodesThatAreChildren) -> NoReturn: ...
     def normalize(self) -> None: ...
-    def replaceChild(self, newChild, oldChild) -> NoReturn: ...
+    def replaceChild(self, newChild: _NodesThatAreChildren | DocumentFragment, oldChild: _NodesThatAreChildren) -> NoReturn: ...
 
 class ProcessingInstruction(Childless, Node):
-    nodeType: int
-    target: Incomplete
-    data: Incomplete
-    def __init__(self, target, data) -> None: ...
-    nodeValue: Incomplete
-    nodeName: Incomplete
+    nodeType: ClassVar[Literal[7]]
+    nodeName: str  # same as ProcessingInstruction.target
+    nodeValue: str  # same as ProcessingInstruction.data
+    attributes: None
+
+    parentNode: Document | Element | DocumentFragment | None
+    nextSibling: _DocumentChildren | _ElementChildren | _DocumentFragmentChildren | None
+    previousSibling: _DocumentChildren | _ElementChildren | _DocumentFragmentChildren | None
+    childNodes: EmptyNodeList
+    @property
+    def firstChild(self) -> None: ...
+    @property
+    def lastChild(self) -> None: ...
+
+    namespaceURI: None
+    prefix: None
+    @property
+    def localName(self) -> None: ...
+
+    target: str
+    data: str
+
+    def __init__(self, target: str, data: str) -> None: ...
     def writexml(self, writer: SupportsWrite[str], indent: str = "", addindent: str = "", newl: str = "") -> None: ...
 
 class CharacterData(Childless, Node):
-    ownerDocument: Incomplete
-    previousSibling: Incomplete
+    nodeValue: str
+    attributes: None
+
+    childNodes: EmptyNodeList
+    nextSibling: _NodesThatAreChildren | None
+    previousSibling: _NodesThatAreChildren | None
+
+    @property
+    def localName(self) -> None: ...
+
+    ownerDocument: Document | None
+    data: str
+
     def __init__(self) -> None: ...
+    @property
+    def length(self) -> int: ...
     def __len__(self) -> int: ...
-    data: str
-    nodeValue: Incomplete
     def substringData(self, offset: int, count: int) -> str: ...
     def appendData(self, arg: str) -> None: ...
     def insertData(self, offset: int, arg: str) -> None: ...
     def deleteData(self, offset: int, count: int) -> None: ...
     def replaceData(self, offset: int, count: int, arg: str) -> None: ...
-    @property
-    def length(self) -> int: ...
 
 class Text(CharacterData):
-    nodeType: int
-    nodeName: str
-    attributes: Incomplete
-    data: Incomplete
+    nodeType: ClassVar[Literal[3]]
+    nodeName: Literal["#text"]
+    nodeValue: str  # same as CharacterData.data, the content of the text node
+    attributes: None
+
+    parentNode: Attr | Element | DocumentFragment | None
+    nextSibling: _DocumentFragmentChildren | _ElementChildren | _AttrChildren | None
+    previousSibling: _DocumentFragmentChildren | _ElementChildren | _AttrChildren | None
+    childNodes: EmptyNodeList
+    @property
+    def firstChild(self) -> None: ...
+    @property
+    def lastChild(self) -> None: ...
+
+    namespaceURI: None
+    prefix: None
+    @property
+    def localName(self) -> None: ...
+
+    data: str
     def splitText(self, offset: int) -> Self: ...
     def writexml(self, writer: SupportsWrite[str], indent: str = "", addindent: str = "", newl: str = "") -> None: ...
-    def replaceWholeText(self, content) -> Self | None: ...
+    def replaceWholeText(self, content: str) -> Self | None: ...
     @property
     def isWhitespaceInElementContent(self) -> bool: ...
     @property
     def wholeText(self) -> str: ...
 
 class Comment(CharacterData):
-    nodeType: int
-    nodeName: str
-    def __init__(self, data) -> None: ...
+    nodeType: ClassVar[Literal[8]]
+    nodeName: Literal["#comment"]
+    nodeValue: str  # same as CharacterData.data, the content of the comment
+    attributes: None
+
+    parentNode: Document | Element | DocumentFragment | None
+    nextSibling: _DocumentChildren | _ElementChildren | _DocumentFragmentChildren | None
+    previousSibling: _DocumentChildren | _ElementChildren | _DocumentFragmentChildren | None
+    childNodes: EmptyNodeList
+    @property
+    def firstChild(self) -> None: ...
+    @property
+    def lastChild(self) -> None: ...
+
+    namespaceURI: None
+    prefix: None
+    @property
+    def localName(self) -> None: ...
+    def __init__(self, data: str) -> None: ...
     def writexml(self, writer: SupportsWrite[str], indent: str = "", addindent: str = "", newl: str = "") -> None: ...
 
 class CDATASection(Text):
-    nodeType: int
-    nodeName: str
+    nodeType: ClassVar[Literal[4]]  # type: ignore[assignment]
+    nodeName: Literal["#cdata-section"]  # type: ignore[assignment]
+    nodeValue: str  # same as CharacterData.data, the content of the CDATA Section
+    attributes: None
+
+    parentNode: Element | DocumentFragment | None
+    nextSibling: _DocumentFragmentChildren | _ElementChildren | None
+    previousSibling: _DocumentFragmentChildren | _ElementChildren | None
+
     def writexml(self, writer: SupportsWrite[str], indent: str = "", addindent: str = "", newl: str = "") -> None: ...
 
-class ReadOnlySequentialNamedNodeMap:
-    def __init__(self, seq=()) -> None: ...
+class ReadOnlySequentialNamedNodeMap(Generic[_N]):
+    def __init__(self, seq: Sequence[_N] = ()) -> None: ...
     def __len__(self) -> int: ...
-    def getNamedItem(self, name): ...
-    def getNamedItemNS(self, namespaceURI: str, localName): ...
-    def __getitem__(self, name_or_tuple): ...
-    def item(self, index): ...
-    def removeNamedItem(self, name) -> None: ...
-    def removeNamedItemNS(self, namespaceURI: str, localName) -> None: ...
-    def setNamedItem(self, node) -> None: ...
-    def setNamedItemNS(self, node) -> None: ...
+    def getNamedItem(self, name: str) -> _N | None: ...
+    def getNamedItemNS(self, namespaceURI: str | None, localName: str) -> _N | None: ...
+    def __getitem__(self, name_or_tuple: str | _NSName) -> _N | None: ...
+    def item(self, index: int) -> _N | None: ...
+    def removeNamedItem(self, name: str) -> NoReturn: ...
+    def removeNamedItemNS(self, namespaceURI: str | None, localName: str) -> NoReturn: ...
+    def setNamedItem(self, node: Node) -> NoReturn: ...
+    def setNamedItemNS(self, node: Node) -> NoReturn: ...
     @property
     def length(self) -> int: ...
 
@@ -295,38 +509,85 @@ class Identified:
     systemId: str | None
 
 class DocumentType(Identified, Childless, Node):
-    nodeType: int
-    nodeValue: Incomplete
-    name: Incomplete
-    internalSubset: Incomplete
-    entities: Incomplete
-    notations: Incomplete
-    nodeName: Incomplete
-    def __init__(self, qualifiedName: str) -> None: ...
-    def cloneNode(self, deep): ...
+    nodeType: ClassVar[Literal[10]]
+    nodeName: str | None  # same as DocumentType.name
+    nodeValue: None
+    attributes: None
+
+    parentNode: Document | None
+    nextSibling: _DocumentChildren | None
+    previousSibling: _DocumentChildren | None
+    childNodes: EmptyNodeList
+    @property
+    def firstChild(self) -> None: ...
+    @property
+    def lastChild(self) -> None: ...
+
+    namespaceURI: None
+    prefix: None
+    @property
+    def localName(self) -> None: ...
+
+    name: str | None
+    internalSubset: str | None
+    entities: ReadOnlySequentialNamedNodeMap[Entity]
+    notations: ReadOnlySequentialNamedNodeMap[Notation]
+
+    def __init__(self, qualifiedName: str | None) -> None: ...
+    def cloneNode(self, deep: bool) -> DocumentType | None: ...
     def writexml(self, writer: SupportsWrite[str], indent: str = "", addindent: str = "", newl: str = "") -> None: ...
 
 class Entity(Identified, Node):
-    attributes: Incomplete
-    nodeType: int
-    nodeValue: Incomplete
-    actualEncoding: Incomplete
-    encoding: Incomplete
-    version: Incomplete
-    nodeName: Incomplete
-    notationName: Incomplete
-    childNodes: Incomplete
-    def __init__(self, name, publicId, systemId, notation) -> None: ...
-    def appendChild(self, newChild) -> NoReturn: ...
-    def insertBefore(self, newChild, refChild) -> NoReturn: ...
-    def removeChild(self, oldChild) -> NoReturn: ...
-    def replaceChild(self, newChild, oldChild) -> NoReturn: ...
+    nodeType: ClassVar[Literal[6]]
+    nodeName: str  # entity name
+    nodeValue: None
+    attributes: None
+
+    parentNode: None
+    nextSibling: None
+    previousSibling: None
+    childNodes: NodeList[_EntityChildren]
+    @property
+    def firstChild(self) -> _EntityChildren | None: ...
+    @property
+    def lastChild(self) -> _EntityChildren | None: ...
+
+    namespaceURI: None
+    prefix: None
+    @property
+    def localName(self) -> None: ...
+
+    actualEncoding: str | None
+    encoding: str | None
+    version: str | None
+    notationName: str | None
+
+    def __init__(self, name: str, publicId: str | None, systemId: str | None, notation: str | None) -> None: ...
+    def appendChild(self, newChild: _EntityChildren) -> NoReturn: ...  # type: ignore[override]
+    def insertBefore(self, newChild: _EntityChildren, refChild: _EntityChildren | None) -> NoReturn: ...  # type: ignore[override]
+    def removeChild(self, oldChild: _EntityChildren) -> NoReturn: ...  # type: ignore[override]
+    def replaceChild(self, newChild: _EntityChildren, oldChild: _EntityChildren) -> NoReturn: ...  # type: ignore[override]
 
 class Notation(Identified, Childless, Node):
-    nodeType: int
-    nodeValue: Incomplete
-    nodeName: Incomplete
-    def __init__(self, name, publicId, systemId) -> None: ...
+    nodeType: ClassVar[Literal[12]]
+    nodeName: str  # notation name
+    nodeValue: None
+    attributes: None
+
+    parentNode: DocumentFragment | None
+    nextSibling: _DocumentFragmentChildren | None
+    previousSibling: _DocumentFragmentChildren | None
+    childNodes: EmptyNodeList
+    @property
+    def firstChild(self) -> None: ...
+    @property
+    def lastChild(self) -> None: ...
+
+    namespaceURI: None
+    prefix: None
+    @property
+    def localName(self) -> None: ...
+    def __init__(self, name: str, publicId: str | None, systemId: str | None) -> None: ...
 
 class DOMImplementation(DOMImplementationLS):
     def hasFeature(self, feature: str, version: str | None) -> bool: ...
@@ -335,53 +596,67 @@ class DOMImplementation(DOMImplementatio
     def getInterface(self, feature: str) -> Self | None: ...
 
 class ElementInfo:
-    tagName: Incomplete
-    def __init__(self, name) -> None: ...
-    def getAttributeType(self, aname): ...
-    def getAttributeTypeNS(self, namespaceURI: str, localName): ...
-    def isElementContent(self): ...
-    def isEmpty(self): ...
-    def isId(self, aname): ...
-    def isIdNS(self, namespaceURI: str, localName): ...
+    tagName: str
+    def __init__(self, name: str) -> None: ...
+    def getAttributeType(self, aname: str) -> TypeInfo: ...
+    def getAttributeTypeNS(self, namespaceURI: str | None, localName: str) -> TypeInfo: ...
+    def isElementContent(self) -> bool: ...
+    def isEmpty(self) -> bool: ...
+    def isId(self, aname: str) -> bool: ...
+    def isIdNS(self, namespaceURI: str | None, localName: str) -> bool: ...
+
+_DocumentChildrenPlusFragment = TypeVar("_DocumentChildrenPlusFragment", bound=_DocumentChildren | DocumentFragment)
 
 class Document(Node, DocumentLS):
-    implementation: Incomplete
-    nodeType: int
-    nodeName: str
-    nodeValue: Incomplete
-    attributes: Incomplete
-    parentNode: Incomplete
-    previousSibling: Incomplete
-    nextSibling: Incomplete
-    actualEncoding: Incomplete
+    nodeType: ClassVar[Literal[9]]
+    nodeName: Literal["#document"]
+    nodeValue: None
+    attributes: None
+
+    parentNode: None
+    previousSibling: None
+    nextSibling: None
+    childNodes: NodeList[_DocumentChildren]
+    @property
+    def firstChild(self) -> _DocumentChildren | None: ...
+    @property
+    def lastChild(self) -> _DocumentChildren | None: ...
+
+    namespaceURI: None
+    prefix: None
+    @property
+    def localName(self) -> None: ...
+
+    implementation: DOMImplementation
+    actualEncoding: str | None
     encoding: str | None
     standalone: bool | None
-    version: Incomplete
+    version: str | None
     strictErrorChecking: bool
-    errorHandler: Incomplete
-    documentURI: Incomplete
+    errorHandler: _DOMErrorHandler | None
+    documentURI: str | None
     doctype: DocumentType | None
-    childNodes: Incomplete
+    documentElement: Element | None
+
     def __init__(self) -> None: ...
-    def appendChild(self, node: _N) -> _N: ...
-    documentElement: Incomplete
-    def removeChild(self, oldChild): ...
+    def appendChild(self, node: _DocumentChildrenVar) -> _DocumentChildrenVar: ...  # type: ignore[override]
+    def removeChild(self, oldChild: _DocumentChildrenVar) -> _DocumentChildrenVar: ...  # type: ignore[override]
     def unlink(self) -> None: ...
-    def cloneNode(self, deep): ...
+    def cloneNode(self, deep: bool) -> Document | None: ...
     def createDocumentFragment(self) -> DocumentFragment: ...
     def createElement(self, tagName: str) -> Element: ...
     def createTextNode(self, data: str) -> Text: ...
     def createCDATASection(self, data: str) -> CDATASection: ...
     def createComment(self, data: str) -> Comment: ...
-    def createProcessingInstruction(self, target, data): ...
-    def createAttribute(self, qName) -> Attr: ...
-    def createElementNS(self, namespaceURI: str, qualifiedName: str): ...
-    def createAttributeNS(self, namespaceURI: str, qualifiedName: str) -> Attr: ...
+    def createProcessingInstruction(self, target: str, data: str) -> ProcessingInstruction: ...
+    def createAttribute(self, qName: str) -> Attr: ...
+    def createElementNS(self, namespaceURI: str | None, qualifiedName: str) -> Element: ...
+    def createAttributeNS(self, namespaceURI: str | None, qualifiedName: str) -> Attr: ...
     def getElementById(self, id: str) -> Element | None: ...
     def getElementsByTagName(self, name: str) -> NodeList[Element]: ...
-    def getElementsByTagNameNS(self, namespaceURI: str, localName: str) -> NodeList[Element]: ...
+    def getElementsByTagNameNS(self, namespaceURI: str | None, localName: str) -> NodeList[Element]: ...
     def isSupported(self, feature: str, version: str | None) -> bool: ...
-    def importNode(self, node, deep): ...
+    def importNode(self, node: _ImportableNodeVar, deep: bool) -> _ImportableNodeVar: ...
     if sys.version_info >= (3, 9):
         def writexml(
             self,
@@ -402,4 +677,18 @@ class Document(Node, DocumentLS):
             encoding: Incomplete | None = None,
         ) -> None: ...
 
-    def renameNode(self, n, namespaceURI: str, name): ...
+    @overload
+    def renameNode(self, n: Element, namespaceURI: str, name: str) -> Element: ...
+    @overload
+    def renameNode(self, n: Attr, namespaceURI: str, name: str) -> Attr: ...
+    @overload
+    def renameNode(self, n: Element | Attr, namespaceURI: str, name: str) -> Element | Attr: ...
+    def insertBefore(
+        self, newChild: _DocumentChildrenPlusFragment, refChild: _DocumentChildren | None  # type: ignore[override]
+    ) -> _DocumentChildrenPlusFragment: ...
+    @overload  # type: ignore[override]
+    def replaceChild(
+        self, newChild: DocumentFragment, oldChild: _DocumentChildrenVar
+    ) -> _DocumentChildrenVar | DocumentFragment: ...
+    @overload
+    def replaceChild(self, newChild: _DocumentChildren, oldChild: _DocumentChildrenVar) -> _DocumentChildrenVar | None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/dom/pulldom.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/pulldom.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/dom/pulldom.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/pulldom.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,11 +1,12 @@
 import sys
-from _typeshed import Incomplete, SupportsRead
-from collections.abc import Sequence
-from typing import Final, Literal
-from typing_extensions import TypeAlias
-from xml.dom.minidom import Document, DOMImplementation, Element, Text
+from _typeshed import Incomplete, Unused
+from collections.abc import MutableSequence, Sequence
+from typing import Final, Literal, NoReturn
+from typing_extensions import Self, TypeAlias
+from xml.dom.minidom import Comment, Document, DOMImplementation, Element, ProcessingInstruction, Text
+from xml.sax import _SupportsReadClose
 from xml.sax.handler import ContentHandler
-from xml.sax.xmlreader import XMLReader
+from xml.sax.xmlreader import AttributesImpl, AttributesNSImpl, Locator, XMLReader
 
 START_ELEMENT: Final = "START_ELEMENT"
 END_ELEMENT: Final = "END_ELEMENT"
@@ -16,79 +17,93 @@ PROCESSING_INSTRUCTION: Final = "PROCESS
 IGNORABLE_WHITESPACE: Final = "IGNORABLE_WHITESPACE"
 CHARACTERS: Final = "CHARACTERS"
 
+_NSName: TypeAlias = tuple[str | None, str]
 _DocumentFactory: TypeAlias = DOMImplementation | None
-_Node: TypeAlias = Document | Element | Text
 
-_Event: TypeAlias = tuple[
-    Literal[
-        Literal["START_ELEMENT"],
-        Literal["END_ELEMENT"],
-        Literal["COMMENT"],
-        Literal["START_DOCUMENT"],
-        Literal["END_DOCUMENT"],
-        Literal["PROCESSING_INSTRUCTION"],
-        Literal["IGNORABLE_WHITESPACE"],
-        Literal["CHARACTERS"],
-    ],
-    _Node,
-]
+_Event: TypeAlias = (
+    tuple[Literal["START_ELEMENT"], Element]
+    | tuple[Literal["END_ELEMENT"], Element]
+    | tuple[Literal["COMMENT"], Comment]
+    | tuple[Literal["START_DOCUMENT"], Document]
+    | tuple[Literal["END_DOCUMENT"], Document]
+    | tuple[Literal["PROCESSING_INSTRUCTION"], ProcessingInstruction]
+    | tuple[Literal["IGNORABLE_WHITESPACE"], Text]
+    | tuple[Literal["CHARACTERS"], Text]
+)
 
 class PullDOM(ContentHandler):
     document: Document | None
     documentFactory: _DocumentFactory
-    firstEvent: Incomplete
-    lastEvent: Incomplete
-    elementStack: Sequence[Incomplete]
-    pending_events: Sequence[Incomplete]
+
+    # firstEvent is a list of length 2
+    # firstEvent[0] is always None
+    # firstEvent[1] is None prior to any events, after which it's a
+    # list of length 2, where the first item is of type _Event
+    # and the second item is None.
+    firstEvent: list[Incomplete]
+
+    # lastEvent is also a list of length 2. The second item is always None,
+    # and the first item is of type _Event
+    # This is a slight lie: The second item is sometimes temporarily what was just
+    # described for the type of lastEvent, after which lastEvent is always updated
+    # with `self.lastEvent = self.lastEvent[1]`.
+    lastEvent: list[Incomplete]
+
+    elementStack: MutableSequence[Element | Document]
+    pending_events: (
+        list[Sequence[tuple[Literal["COMMENT"], str] | tuple[Literal["PROCESSING_INSTRUCTION"], str, str] | None]] | None
+    )
     def __init__(self, documentFactory: _DocumentFactory = None) -> None: ...
-    def pop(self) -> Element: ...
-    def setDocumentLocator(self, locator) -> None: ...
-    def startPrefixMapping(self, prefix, uri) -> None: ...
-    def endPrefixMapping(self, prefix) -> None: ...
-    def startElementNS(self, name, tagName, attrs) -> None: ...
-    def endElementNS(self, name, tagName) -> None: ...
-    def startElement(self, name, attrs) -> None: ...
-    def endElement(self, name) -> None: ...
-    def comment(self, s) -> None: ...
-    def processingInstruction(self, target, data) -> None: ...
-    def ignorableWhitespace(self, chars) -> None: ...
-    def characters(self, chars) -> None: ...
+    def pop(self) -> Element | Document: ...
+    def setDocumentLocator(self, locator: Locator) -> None: ...
+    def startPrefixMapping(self, prefix: str | None, uri: str) -> None: ...
+    def endPrefixMapping(self, prefix: str | None) -> None: ...
+    def startElementNS(self, name: _NSName, tagName: str | None, attrs: AttributesNSImpl) -> None: ...
+    def endElementNS(self, name: _NSName, tagName: str | None) -> None: ...
+    def startElement(self, name: str, attrs: AttributesImpl) -> None: ...
+    def endElement(self, name: str) -> None: ...
+    def comment(self, s: str) -> None: ...
+    def processingInstruction(self, target: str, data: str) -> None: ...
+    def ignorableWhitespace(self, chars: str) -> None: ...
+    def characters(self, chars: str) -> None: ...
     def startDocument(self) -> None: ...
-    def buildDocument(self, uri, tagname): ...
+    def buildDocument(self, uri: str | None, tagname: str | None) -> Element: ...
     def endDocument(self) -> None: ...
     def clear(self) -> None: ...
 
 class ErrorHandler:
-    def warning(self, exception) -> None: ...
-    def error(self, exception) -> None: ...
-    def fatalError(self, exception) -> None: ...
+    def warning(self, exception: BaseException) -> None: ...
+    def error(self, exception: BaseException) -> NoReturn: ...
+    def fatalError(self, exception: BaseException) -> NoReturn: ...
 
 class DOMEventStream:
-    stream: SupportsRead[bytes] | SupportsRead[str]
-    parser: XMLReader
+    stream: _SupportsReadClose[bytes] | _SupportsReadClose[str]
+    parser: XMLReader  # Set to none after .clear() is called
     bufsize: int
-    def __init__(self, stream: SupportsRead[bytes] | SupportsRead[str], parser: XMLReader, bufsize: int) -> None: ...
-    pulldom: Incomplete
+    pulldom: PullDOM
+    def __init__(self, stream: _SupportsReadClose[bytes] | _SupportsReadClose[str], parser: XMLReader, bufsize: int) -> None: ...
     if sys.version_info < (3, 11):
-        def __getitem__(self, pos): ...
+        def __getitem__(self, pos: Unused) -> _Event: ...
 
-    def __next__(self): ...
-    def __iter__(self): ...
-    def getEvent(self) -> _Event: ...
-    def expandNode(self, node: _Node) -> None: ...
+    def __next__(self) -> _Event: ...
+    def __iter__(self) -> Self: ...
+    def getEvent(self) -> _Event | None: ...
+    def expandNode(self, node: Document) -> None: ...
     def reset(self) -> None: ...
     def clear(self) -> None: ...
 
 class SAX2DOM(PullDOM):
-    def startElementNS(self, name, tagName, attrs) -> None: ...
-    def startElement(self, name, attrs) -> None: ...
-    def processingInstruction(self, target, data) -> None: ...
-    def ignorableWhitespace(self, chars) -> None: ...
-    def characters(self, chars) -> None: ...
+    def startElementNS(self, name: _NSName, tagName: str | None, attrs: AttributesNSImpl) -> None: ...
+    def startElement(self, name: str, attrs: AttributesImpl) -> None: ...
+    def processingInstruction(self, target: str, data: str) -> None: ...
+    def ignorableWhitespace(self, chars: str) -> None: ...
+    def characters(self, chars: str) -> None: ...
 
 default_bufsize: int
 
 def parse(
-    stream_or_string: str | SupportsRead[bytes] | SupportsRead[str], parser: XMLReader | None = None, bufsize: int | None = None
+    stream_or_string: str | _SupportsReadClose[bytes] | _SupportsReadClose[str],
+    parser: XMLReader | None = None,
+    bufsize: int | None = None,
 ) -> DOMEventStream: ...
 def parseString(string: str, parser: XMLReader | None = None) -> DOMEventStream: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/dom/xmlbuilder.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/xmlbuilder.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/dom/xmlbuilder.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/dom/xmlbuilder.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,32 +1,9 @@
-from _typeshed import Incomplete, Unused
+from _typeshed import SupportsRead
 from typing import Any, Literal, NoReturn
-from typing_extensions import TypeAlias
-from urllib.request import OpenerDirector
-from xml.dom.expatbuilder import ExpatBuilder, ExpatBuilderNS
-from xml.dom.minidom import Node
+from xml.dom.minidom import Document, Node, _DOMErrorHandler
 
 __all__ = ["DOMBuilder", "DOMEntityResolver", "DOMInputSource"]
 
-# UNKNOWN TYPES:
-# - `Options.errorHandler`.
-#       The same as `_DOMBuilderErrorHandlerType`?
-#       Maybe `xml.sax.handler.ErrorHandler`?
-# - Return type of DOMBuilder.getFeature().
-#       We could get rid of the `Incomplete` if we knew more
-#       about `Options.errorHandler`.
-
-# ALIASES REPRESENTING MORE UNKNOWN TYPES:
-
-# probably the same as `Options.errorHandler`?
-# Maybe `xml.sax.handler.ErrorHandler`?
-_DOMBuilderErrorHandlerType: TypeAlias = Incomplete | None
-# probably some kind of IO...
-_DOMInputSourceCharacterStreamType: TypeAlias = Incomplete | None
-# probably a string??
-_DOMInputSourceStringDataType: TypeAlias = Incomplete | None
-# probably a string??
-_DOMInputSourceEncodingType: TypeAlias = Incomplete | None
-
 class Options:
     namespaces: int
     namespace_declarations: bool
@@ -45,37 +22,35 @@ class Options:
     charset_overrides_xml_encoding: bool
     infoset: bool
     supported_mediatypes_only: bool
-    errorHandler: Any | None
-    filter: DOMBuilderFilter | None  # a guess, but seems likely
+    errorHandler: _DOMErrorHandler | None
+    filter: DOMBuilderFilter | None
 
 class DOMBuilder:
-    entityResolver: DOMEntityResolver | None  # a guess, but seems likely
-    errorHandler: _DOMBuilderErrorHandlerType
-    filter: DOMBuilderFilter | None  # a guess, but seems likely
+    entityResolver: DOMEntityResolver | None
+    errorHandler: _DOMErrorHandler | None
+    filter: DOMBuilderFilter | None
     ACTION_REPLACE: Literal[1]
     ACTION_APPEND_AS_CHILDREN: Literal[2]
     ACTION_INSERT_AFTER: Literal[3]
     ACTION_INSERT_BEFORE: Literal[4]
+    def __init__(self) -> None: ...
     def setFeature(self, name: str, state: int) -> None: ...
     def supportsFeature(self, name: str) -> bool: ...
-    def canSetFeature(self, name: str, state: int) -> bool: ...
+    def canSetFeature(self, name: str, state: Literal[1, 0]) -> bool: ...
     # getFeature could return any attribute from an instance of `Options`
     def getFeature(self, name: str) -> Any: ...
-    def parseURI(self, uri: str) -> ExpatBuilder | ExpatBuilderNS: ...
-    def parse(self, input: DOMInputSource) -> ExpatBuilder | ExpatBuilderNS: ...
-    # `input` and `cnode` argtypes for `parseWithContext` are unknowable
-    # as the function does nothing with them, and always raises an exception.
-    # But `input` is *probably* `DOMInputSource`?
-    def parseWithContext(self, input: Unused, cnode: Unused, action: Literal[1, 2, 3, 4]) -> NoReturn: ...
+    def parseURI(self, uri: str) -> Document: ...
+    def parse(self, input: DOMInputSource) -> Document: ...
+    def parseWithContext(self, input: DOMInputSource, cnode: Node, action: Literal[1, 2, 3, 4]) -> NoReturn: ...
 
 class DOMEntityResolver:
     def resolveEntity(self, publicId: str | None, systemId: str) -> DOMInputSource: ...
 
 class DOMInputSource:
-    byteStream: OpenerDirector | None
-    characterStream: _DOMInputSourceCharacterStreamType
-    stringData: _DOMInputSourceStringDataType
-    encoding: _DOMInputSourceEncodingType
+    byteStream: SupportsRead[bytes] | None
+    characterStream: SupportsRead[str] | None
+    stringData: str | None
+    encoding: str | None
     publicId: str | None
     systemId: str | None
     baseURI: str | None
@@ -86,18 +61,14 @@ class DOMBuilderFilter:
     FILTER_SKIP: Literal[3]
     FILTER_INTERRUPT: Literal[4]
     whatToShow: int
-    def acceptNode(self, element: Unused) -> Literal[1]: ...
-    def startContainer(self, element: Unused) -> Literal[1]: ...
+    def acceptNode(self, element: Node) -> Literal[1, 2, 3, 4]: ...
+    def startContainer(self, element: Node) -> Literal[1, 2, 3, 4]: ...
 
 class DocumentLS:
     async_: bool
     def abort(self) -> NoReturn: ...
-    # `load()` and `loadXML()` always raise exceptions
-    # so the argtypes of `uri` and `source` are unknowable.
-    # `source` is *probably* `DOMInputSource`?
-    # `uri` is *probably* a str? (see DOMBuilder.parseURI())
-    def load(self, uri: Unused) -> NoReturn: ...
-    def loadXML(self, source: Unused) -> NoReturn: ...
+    def load(self, uri: str) -> NoReturn: ...
+    def loadXML(self, source: str) -> NoReturn: ...
     def saveXML(self, snode: Node | None) -> str: ...
 
 class DOMImplementationLS:
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/etree/ElementInclude.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/etree/ElementInclude.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/etree/ElementInclude.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/etree/ElementInclude.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,9 +1,14 @@
 import sys
 from _typeshed import FileDescriptorOrPath
-from collections.abc import Callable
-from typing import Final
+from typing import Final, Literal, Protocol, overload
 from xml.etree.ElementTree import Element
 
+class _Loader(Protocol):
+    @overload
+    def __call__(self, href: FileDescriptorOrPath, parse: Literal["xml"], encoding: str | None = None) -> Element: ...
+    @overload
+    def __call__(self, href: FileDescriptorOrPath, parse: Literal["text"], encoding: str | None = None) -> str: ...
+
 XINCLUDE: Final[str]
 XINCLUDE_INCLUDE: Final[str]
 XINCLUDE_FALLBACK: Final[str]
@@ -13,17 +18,15 @@ if sys.version_info >= (3, 9):
 
 class FatalIncludeError(SyntaxError): ...
 
-def default_loader(href: FileDescriptorOrPath, parse: str, encoding: str | None = None) -> str | Element: ...
+@overload
+def default_loader(href: FileDescriptorOrPath, parse: Literal["xml"], encoding: str | None = None) -> Element: ...
+@overload
+def default_loader(href: FileDescriptorOrPath, parse: Literal["text"], encoding: str | None = None) -> str: ...
 
-# TODO: loader is of type default_loader ie it takes a callable that has the
-# same signature as default_loader. But default_loader has a keyword argument
-# Which can't be represented using Callable...
 if sys.version_info >= (3, 9):
-    def include(
-        elem: Element, loader: Callable[..., str | Element] | None = None, base_url: str | None = None, max_depth: int | None = 6
-    ) -> None: ...
+    def include(elem: Element, loader: _Loader | None = None, base_url: str | None = None, max_depth: int | None = 6) -> None: ...
 
     class LimitedRecursiveIncludeError(FatalIncludeError): ...
 
 else:
-    def include(elem: Element, loader: Callable[..., str | Element] | None = None) -> None: ...
+    def include(elem: Element, loader: _Loader | None = None) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/etree/ElementPath.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/etree/ElementPath.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/etree/ElementPath.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/etree/ElementPath.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,6 +1,6 @@
-from collections.abc import Callable, Generator
+from collections.abc import Callable, Generator, Iterable
 from re import Pattern
-from typing import TypeVar
+from typing import Any, Literal, TypeVar, overload
 from typing_extensions import TypeAlias
 from xml.etree.ElementTree import Element
 
@@ -8,27 +8,34 @@ xpath_tokenizer_re: Pattern[str]
 
 _Token: TypeAlias = tuple[str, str]
 _Next: TypeAlias = Callable[[], _Token]
-_Callback: TypeAlias = Callable[[_SelectorContext, list[Element]], Generator[Element, None, None]]
+_Callback: TypeAlias = Callable[[_SelectorContext, Iterable[Element]], Generator[Element, None, None]]
+_T = TypeVar("_T")
 
 def xpath_tokenizer(pattern: str, namespaces: dict[str, str] | None = None) -> Generator[_Token, None, None]: ...
 def get_parent_map(context: _SelectorContext) -> dict[Element, Element]: ...
 def prepare_child(next: _Next, token: _Token) -> _Callback: ...
 def prepare_star(next: _Next, token: _Token) -> _Callback: ...
 def prepare_self(next: _Next, token: _Token) -> _Callback: ...
-def prepare_descendant(next: _Next, token: _Token) -> _Callback: ...
+def prepare_descendant(next: _Next, token: _Token) -> _Callback | None: ...
 def prepare_parent(next: _Next, token: _Token) -> _Callback: ...
-def prepare_predicate(next: _Next, token: _Token) -> _Callback: ...
+def prepare_predicate(next: _Next, token: _Token) -> _Callback | None: ...
 
-ops: dict[str, Callable[[_Next, _Token], _Callback]]
+ops: dict[str, Callable[[_Next, _Token], _Callback | None]]
 
 class _SelectorContext:
     parent_map: dict[Element, Element] | None
     root: Element
     def __init__(self, root: Element) -> None: ...
 
-_T = TypeVar("_T")
-
-def iterfind(elem: Element, path: str, namespaces: dict[str, str] | None = None) -> Generator[Element, None, None]: ...
-def find(elem: Element, path: str, namespaces: dict[str, str] | None = None) -> Element | None: ...
-def findall(elem: Element, path: str, namespaces: dict[str, str] | None = None) -> list[Element]: ...
-def findtext(elem: Element, path: str, default: _T | None = None, namespaces: dict[str, str] | None = None) -> _T | str: ...
+@overload
+def iterfind(  # type: ignore[overload-overlap]
+    elem: Element[Any], path: Literal[""], namespaces: dict[str, str] | None = None
+) -> None: ...
+@overload
+def iterfind(elem: Element[Any], path: str, namespaces: dict[str, str] | None = None) -> Generator[Element, None, None]: ...
+def find(elem: Element[Any], path: str, namespaces: dict[str, str] | None = None) -> Element | None: ...
+def findall(elem: Element[Any], path: str, namespaces: dict[str, str] | None = None) -> list[Element]: ...
+@overload
+def findtext(elem: Element[Any], path: str, default: None = None, namespaces: dict[str, str] | None = None) -> str | None: ...
+@overload
+def findtext(elem: Element[Any], path: str, default: _T, namespaces: dict[str, str] | None = None) -> _T | str: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/etree/ElementTree.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/etree/ElementTree.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/etree/ElementTree.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/etree/ElementTree.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -2,8 +2,9 @@ import sys
 from _collections_abc import dict_keys
 from _typeshed import FileDescriptorOrPath, ReadableBuffer, SupportsRead, SupportsWrite
 from collections.abc import Callable, Generator, ItemsView, Iterable, Iterator, Mapping, Sequence
-from typing import Any, Final, Literal, SupportsIndex, TypeVar, overload
+from typing import Any, Final, Generic, Literal, Protocol, SupportsIndex, TypeVar, overload, type_check_only
 from typing_extensions import TypeAlias, TypeGuard, deprecated
+from xml.parsers.expat import XMLParserType
 
 __all__ = [
     "C14NWriterTarget",
@@ -78,13 +79,22 @@ def canonicalize(
     exclude_tags: Iterable[str] | None = None,
 ) -> None: ...
 
-class Element:
-    tag: str
+# The tag for Element can be set to the Comment or ProcessingInstruction
+# functions defined in this module. _ElementCallable could be a recursive
+# type, but defining it that way uncovered a bug in pytype.
+_ElementCallable: TypeAlias = Callable[..., Element[Any]]
+_CallableElement: TypeAlias = Element[_ElementCallable]
+
+_Tag = TypeVar("_Tag", default=str, bound=str | _ElementCallable)
+_OtherTag = TypeVar("_OtherTag", default=str, bound=str | _ElementCallable)
+
+class Element(Generic[_Tag]):
+    tag: _Tag
     attrib: dict[str, str]
     text: str | None
     tail: str | None
-    def __init__(self, tag: str, attrib: dict[str, str] = ..., **extra: str) -> None: ...
-    def append(self, subelement: Element, /) -> None: ...
+    def __init__(self, tag: _Tag, attrib: dict[str, str] = {}, **extra: str) -> None: ...
+    def append(self, subelement: Element[Any], /) -> None: ...
     def clear(self) -> None: ...
     def extend(self, elements: Iterable[Element], /) -> None: ...
     def find(self, path: str, namespaces: dict[str, str] | None = None) -> Element | None: ...
@@ -100,14 +110,17 @@ class Element:
     def insert(self, index: int, subelement: Element, /) -> None: ...
     def items(self) -> ItemsView[str, str]: ...
     def iter(self, tag: str | None = None) -> Generator[Element, None, None]: ...
+    @overload
+    def iterfind(self, path: Literal[""], namespaces: dict[str, str] | None = None) -> None: ...  # type: ignore[overload-overlap]
+    @overload
     def iterfind(self, path: str, namespaces: dict[str, str] | None = None) -> Generator[Element, None, None]: ...
     def itertext(self) -> Generator[str, None, None]: ...
     def keys(self) -> dict_keys[str, str]: ...
     # makeelement returns the type of self in Python impl, but not in C impl
-    def makeelement(self, tag: str, attrib: dict[str, str], /) -> Element: ...
+    def makeelement(self, tag: _OtherTag, attrib: dict[str, str], /) -> Element[_OtherTag]: ...
     def remove(self, subelement: Element, /) -> None: ...
     def set(self, key: str, value: str, /) -> None: ...
-    def __copy__(self) -> Element: ...  # returns the type of self in Python impl, but not in C impl
+    def __copy__(self) -> Element[_Tag]: ...  # returns the type of self in Python impl, but not in C impl
     def __deepcopy__(self, memo: Any, /) -> Element: ...  # Only exists in C impl
     def __delitem__(self, key: SupportsIndex | slice, /) -> None: ...
     @overload
@@ -130,8 +143,8 @@ class Element:
         def getiterator(self, tag: str | None = None) -> list[Element]: ...
 
 def SubElement(parent: Element, tag: str, attrib: dict[str, str] = ..., **extra: str) -> Element: ...
-def Comment(text: str | None = None) -> Element: ...
-def ProcessingInstruction(target: str, text: str | None = None) -> Element: ...
+def Comment(text: str | None = None) -> _CallableElement: ...
+def ProcessingInstruction(target: str, text: str | None = None) -> _CallableElement: ...
 
 PI = ProcessingInstruction
 
@@ -145,9 +158,11 @@ class QName:
     def __eq__(self, other: object) -> bool: ...
     def __hash__(self) -> int: ...
 
-class ElementTree:
+_Root = TypeVar("_Root", Element, Element | None, default=Element | None)
+
+class ElementTree(Generic[_Root]):
     def __init__(self, element: Element | None = None, file: _FileRead | None = None) -> None: ...
-    def getroot(self) -> Element | Any: ...
+    def getroot(self) -> _Root: ...
     def parse(self, source: _FileRead, parser: XMLParser | None = None) -> Element: ...
     def iter(self, tag: str | None = None) -> Generator[Element, None, None]: ...
     if sys.version_info < (3, 9):
@@ -159,6 +174,9 @@ class ElementTree:
     @overload
     def findtext(self, path: str, default: _T, namespaces: dict[str, str] | None = None) -> _T | str: ...
     def findall(self, path: str, namespaces: dict[str, str] | None = None) -> list[Element]: ...
+    @overload
+    def iterfind(self, path: Literal[""], namespaces: dict[str, str] | None = None) -> None: ...  # type: ignore[overload-overlap]
+    @overload
     def iterfind(self, path: str, namespaces: dict[str, str] | None = None) -> Generator[Element, None, None]: ...
     def write(
         self,
@@ -166,18 +184,20 @@ class ElementTree:
         encoding: str | None = None,
         xml_declaration: bool | None = None,
         default_namespace: str | None = None,
-        method: str | None = None,
+        method: Literal["xml", "html", "text", "c14n"] | None = None,
         *,
         short_empty_elements: bool = True,
     ) -> None: ...
     def write_c14n(self, file: _FileWriteC14N) -> None: ...
 
+HTML_EMPTY: set[str]
+
 def register_namespace(prefix: str, uri: str) -> None: ...
 @overload
 def tostring(
     element: Element,
     encoding: None = None,
-    method: str | None = None,
+    method: Literal["xml", "html", "text", "c14n"] | None = None,
     *,
     xml_declaration: bool | None = None,
     default_namespace: str | None = None,
@@ -187,7 +207,7 @@ def tostring(
 def tostring(
     element: Element,
     encoding: Literal["unicode"],
-    method: str | None = None,
+    method: Literal["xml", "html", "text", "c14n"] | None = None,
     *,
     xml_declaration: bool | None = None,
     default_namespace: str | None = None,
@@ -197,7 +217,7 @@ def tostring(
 def tostring(
     element: Element,
     encoding: str,
-    method: str | None = None,
+    method: Literal["xml", "html", "text", "c14n"] | None = None,
     *,
     xml_declaration: bool | None = None,
     default_namespace: str | None = None,
@@ -207,7 +227,7 @@ def tostring(
 def tostringlist(
     element: Element,
     encoding: None = None,
-    method: str | None = None,
+    method: Literal["xml", "html", "text", "c14n"] | None = None,
     *,
     xml_declaration: bool | None = None,
     default_namespace: str | None = None,
@@ -217,7 +237,7 @@ def tostringlist(
 def tostringlist(
     element: Element,
     encoding: Literal["unicode"],
-    method: str | None = None,
+    method: Literal["xml", "html", "text", "c14n"] | None = None,
     *,
     xml_declaration: bool | None = None,
     default_namespace: str | None = None,
@@ -227,21 +247,23 @@ def tostringlist(
 def tostringlist(
     element: Element,
     encoding: str,
-    method: str | None = None,
+    method: Literal["xml", "html", "text", "c14n"] | None = None,
     *,
     xml_declaration: bool | None = None,
     default_namespace: str | None = None,
     short_empty_elements: bool = True,
 ) -> list[Any]: ...
-def dump(elem: Element) -> None: ...
+def dump(elem: Element | ElementTree[Any]) -> None: ...
 
 if sys.version_info >= (3, 9):
-    def indent(tree: Element | ElementTree, space: str = "  ", level: int = 0) -> None: ...
+    def indent(tree: Element | ElementTree[Any], space: str = "  ", level: int = 0) -> None: ...
 
-def parse(source: _FileRead, parser: XMLParser | None = None) -> ElementTree: ...
+def parse(source: _FileRead, parser: XMLParser[Any] | None = None) -> ElementTree[Element]: ...
 
-class _IterParseIterator(Iterator[tuple[str, Any]]):
-    def __next__(self) -> tuple[str, Any]: ...
+# This class is defined inside the body of iterparse
+@type_check_only
+class _IterParseIterator(Iterator[tuple[str, Element]], Protocol):
+    def __next__(self) -> tuple[str, Element]: ...
     if sys.version_info >= (3, 13):
         def close(self) -> None: ...
     if sys.version_info >= (3, 11):
@@ -249,13 +271,13 @@ class _IterParseIterator(Iterator[tuple[
 
 def iterparse(source: _FileRead, events: Sequence[str] | None = None, parser: XMLParser | None = None) -> _IterParseIterator: ...
 
-class XMLPullParser:
-    def __init__(self, events: Sequence[str] | None = None, *, _parser: XMLParser | None = None) -> None: ...
+_EventQueue: TypeAlias = tuple[str] | tuple[str, tuple[str, str]] | tuple[str, None]
+
+class XMLPullParser(Generic[_E]):
+    def __init__(self, events: Sequence[str] | None = None, *, _parser: XMLParser[_E] | None = None) -> None: ...
     def feed(self, data: str | ReadableBuffer) -> None: ...
     def close(self) -> None: ...
-    # Second element in the tuple could be `Element`, `tuple[str, str]` or `None`.
-    # Use `Any` to avoid false-positive errors.
-    def read_events(self) -> Iterator[tuple[str, Any]]: ...
+    def read_events(self) -> Iterator[_EventQueue | tuple[str, _E]]: ...
     def flush(self) -> None: ...
 
 def XML(text: str | ReadableBuffer, parser: XMLParser | None = None) -> Element: ...
@@ -281,12 +303,12 @@ class TreeBuilder:
     # comment_factory can take None because passing None to Comment is not an error
     def __init__(
         self,
-        element_factory: _ElementFactory | None = ...,
+        element_factory: _ElementFactory | None = None,
         *,
-        comment_factory: Callable[[str | None], Element] | None = ...,
-        pi_factory: Callable[[str, str | None], Element] | None = ...,
-        insert_comments: bool = ...,
-        insert_pis: bool = ...,
+        comment_factory: Callable[[str | None], Element[Any]] | None = None,
+        pi_factory: Callable[[str, str | None], Element[Any]] | None = None,
+        insert_comments: bool = False,
+        insert_pis: bool = False,
     ) -> None: ...
     insert_comments: bool
     insert_pis: bool
@@ -298,8 +320,8 @@ class TreeBuilder:
     def start(self, tag: Any, attrs: dict[Any, Any], /) -> Element: ...
     def end(self, tag: str, /) -> Element: ...
     # These two methods have pos-only parameters in the C implementation
-    def comment(self, text: str | None, /) -> Element: ...
-    def pi(self, target: str, text: str | None = None, /) -> Element: ...
+    def comment(self, text: str | None, /) -> Element[Any]: ...
+    def pi(self, target: str, text: str | None = None, /) -> Element[Any]: ...
 
 class C14NWriterTarget:
     def __init__(
@@ -321,13 +343,33 @@ class C14NWriterTarget:
     def comment(self, text: str) -> None: ...
     def pi(self, target: str, data: str) -> None: ...
 
-class XMLParser:
-    parser: Any
-    target: Any
+# The target type is tricky, because the implementation doesn't
+# require any particular attribute to be present. This documents the attributes
+# that can be present, but uncommenting any of them would require them.
+class _Target(Protocol):
+    # start: Callable[str, dict[str, str], Any] | None
+    # end: Callable[[str], Any] | None
+    # start_ns: Callable[[str, str], Any] | None
+    # end_ns: Callable[[str], Any] | None
+    # data: Callable[[str], Any] | None
+    # comment: Callable[[str], Any]
+    # pi: Callable[[str, str], Any] | None
+    # close: Callable[[], Any] | None
+    ...
+
+_E = TypeVar("_E", default=Element)
+
+# This is generic because the return type of close() depends on the target.
+# The default target is TreeBuilder, which returns Element.
+# C14NWriterTarget does not implement a close method, so using it results
+# in a type of XMLParser[None].
+class XMLParser(Generic[_E]):
+    parser: XMLParserType
+    target: _Target
     # TODO-what is entity used for???
-    entity: Any
+    entity: dict[str, str]
     version: str
-    def __init__(self, *, target: Any = ..., encoding: str | None = ...) -> None: ...
-    def close(self) -> Any: ...
+    def __init__(self, *, target: _Target | None = None, encoding: str | None = None) -> None: ...
+    def close(self) -> _E: ...
     def feed(self, data: str | ReadableBuffer, /) -> None: ...
     def flush(self) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/sax/_exceptions.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/sax/_exceptions.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/sax/_exceptions.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/sax/_exceptions.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -4,15 +4,15 @@ from xml.sax.xmlreader import Locator
 class SAXException(Exception):
     def __init__(self, msg: str, exception: Exception | None = None) -> None: ...
     def getMessage(self) -> str: ...
-    def getException(self) -> Exception: ...
+    def getException(self) -> Exception | None: ...
     def __getitem__(self, ix: object) -> NoReturn: ...
 
 class SAXParseException(SAXException):
     def __init__(self, msg: str, exception: Exception | None, locator: Locator) -> None: ...
-    def getColumnNumber(self) -> int: ...
-    def getLineNumber(self) -> int: ...
-    def getPublicId(self): ...
-    def getSystemId(self): ...
+    def getColumnNumber(self) -> int | None: ...
+    def getLineNumber(self) -> int | None: ...
+    def getPublicId(self) -> str | None: ...
+    def getSystemId(self) -> str | None: ...
 
 class SAXNotRecognizedException(SAXException): ...
 class SAXNotSupportedException(SAXException): ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/sax/expatreader.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/sax/expatreader.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/sax/expatreader.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/sax/expatreader.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,53 +1,82 @@
 import sys
-from _typeshed import Unused
-from xml.sax import xmlreader
+from _typeshed import ReadableBuffer
+from collections.abc import Mapping
+from typing import Any, Literal, overload
+from typing_extensions import TypeAlias
+from xml.sax import _Source, xmlreader
+from xml.sax.handler import _ContentHandlerProtocol
+
+if sys.version_info >= (3, 10):
+    from xml.sax.handler import LexicalHandler
+
+_BoolType: TypeAlias = Literal[0, 1] | bool
 
 version: str
 AttributesImpl = xmlreader.AttributesImpl
 AttributesNSImpl = xmlreader.AttributesNSImpl
 
-class _ClosedParser: ...
+class _ClosedParser:
+    ErrorColumnNumber: int
+    ErrorLineNumber: int
 
 class ExpatLocator(xmlreader.Locator):
     def __init__(self, parser: ExpatParser) -> None: ...
-    def getColumnNumber(self) -> int: ...
+    def getColumnNumber(self) -> int | None: ...
     def getLineNumber(self) -> int: ...
-    def getPublicId(self): ...
-    def getSystemId(self): ...
+    def getPublicId(self) -> str | None: ...
+    def getSystemId(self) -> str | None: ...
 
 class ExpatParser(xmlreader.IncrementalParser, xmlreader.Locator):
-    def __init__(self, namespaceHandling: int = 0, bufsize: int = 65516) -> None: ...
-    def parse(self, source) -> None: ...
-    def prepareParser(self, source) -> None: ...
-    def setContentHandler(self, handler) -> None: ...
-    def getFeature(self, name: str): ...
-    def setFeature(self, name: str, state) -> None: ...
-    def getProperty(self, name: str): ...
-    def setProperty(self, name: str, value) -> None: ...
+    def __init__(self, namespaceHandling: _BoolType = 0, bufsize: int = 65516) -> None: ...
+    def parse(self, source: xmlreader.InputSource | _Source) -> None: ...
+    def prepareParser(self, source: xmlreader.InputSource) -> None: ...
+    def setContentHandler(self, handler: _ContentHandlerProtocol) -> None: ...
+    def getFeature(self, name: str) -> _BoolType: ...
+    def setFeature(self, name: str, state: _BoolType) -> None: ...
+    if sys.version_info >= (3, 10):
+        @overload
+        def getProperty(self, name: Literal["http://xml.org/sax/properties/lexical-handler"]) -> LexicalHandler | None: ...
+
+    @overload
+    def getProperty(self, name: Literal["http://www.python.org/sax/properties/interning-dict"]) -> dict[str, Any] | None: ...
+    @overload
+    def getProperty(self, name: Literal["http://xml.org/sax/properties/xml-string"]) -> bytes | None: ...
+    @overload
+    def getProperty(self, name: str) -> object: ...
+    if sys.version_info >= (3, 10):
+        @overload
+        def setProperty(self, name: Literal["http://xml.org/sax/properties/lexical-handler"], value: LexicalHandler) -> None: ...
+
+    @overload
+    def setProperty(
+        self, name: Literal["http://www.python.org/sax/properties/interning-dict"], value: dict[str, Any]
+    ) -> None: ...
+    @overload
+    def setProperty(self, name: str, value: object) -> None: ...
     if sys.version_info >= (3, 9):
-        def feed(self, data, isFinal: bool = False) -> None: ...
+        def feed(self, data: str | ReadableBuffer, isFinal: bool = False) -> None: ...
     else:
-        def feed(self, data, isFinal: int = 0) -> None: ...
+        def feed(self, data: str | ReadableBuffer, isFinal: _BoolType = 0) -> None: ...
 
     def flush(self) -> None: ...
     def close(self) -> None: ...
     def reset(self) -> None: ...
     def getColumnNumber(self) -> int | None: ...
     def getLineNumber(self) -> int: ...
-    def getPublicId(self): ...
-    def getSystemId(self): ...
-    def start_element(self, name: str, attrs: xmlreader.AttributesImpl) -> None: ...
+    def getPublicId(self) -> str | None: ...
+    def getSystemId(self) -> str | None: ...
+    def start_element(self, name: str, attrs: Mapping[str, str]) -> None: ...
     def end_element(self, name: str) -> None: ...
-    def start_element_ns(self, name: str, attrs) -> None: ...
+    def start_element_ns(self, name: str, attrs: Mapping[str, str]) -> None: ...
     def end_element_ns(self, name: str) -> None: ...
     def processing_instruction(self, target: str, data: str) -> None: ...
     def character_data(self, data: str) -> None: ...
     def start_namespace_decl(self, prefix: str | None, uri: str) -> None: ...
     def end_namespace_decl(self, prefix: str | None) -> None: ...
-    def start_doctype_decl(self, name: str, sysid: str | None, pubid: str | None, has_internal_subset: Unused) -> None: ...
-    def unparsed_entity_decl(self, name, base, sysid, pubid, notation_name) -> None: ...
-    def notation_decl(self, name, base, sysid, pubid) -> None: ...
-    def external_entity_ref(self, context, base, sysid, pubid): ...
+    def start_doctype_decl(self, name: str, sysid: str | None, pubid: str | None, has_internal_subset: bool) -> None: ...
+    def unparsed_entity_decl(self, name: str, base: str | None, sysid: str, pubid: str | None, notation_name: str) -> None: ...
+    def notation_decl(self, name: str, base: str | None, sysid: str, pubid: str | None) -> None: ...
+    def external_entity_ref(self, context: str, base: str | None, sysid: str, pubid: str | None) -> int: ...
     def skipped_entity_handler(self, name: str, is_pe: bool) -> None: ...
 
 def create_parser(namespaceHandling: int = 0, bufsize: int = 65516) -> ExpatParser: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/sax/handler.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/sax/handler.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/sax/handler.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/sax/handler.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,14 +1,36 @@
 import sys
-from typing import NoReturn
+from typing import Literal, NoReturn, Protocol, type_check_only
 from xml.sax import xmlreader
 
 version: str
 
+@type_check_only
+class _ErrorHandlerProtocol(Protocol):  # noqa: Y046  # Protocol is not used
+    def error(self, exception: BaseException) -> NoReturn: ...
+    def fatalError(self, exception: BaseException) -> NoReturn: ...
+    def warning(self, exception: BaseException) -> None: ...
+
 class ErrorHandler:
     def error(self, exception: BaseException) -> NoReturn: ...
     def fatalError(self, exception: BaseException) -> NoReturn: ...
     def warning(self, exception: BaseException) -> None: ...
 
+@type_check_only
+class _ContentHandlerProtocol(Protocol):  # noqa: Y046  # Protocol is not used
+    def setDocumentLocator(self, locator: xmlreader.Locator) -> None: ...
+    def startDocument(self) -> None: ...
+    def endDocument(self) -> None: ...
+    def startPrefixMapping(self, prefix: str | None, uri: str) -> None: ...
+    def endPrefixMapping(self, prefix: str | None) -> None: ...
+    def startElement(self, name: str, attrs: xmlreader.AttributesImpl) -> None: ...
+    def endElement(self, name: str) -> None: ...
+    def startElementNS(self, name: tuple[str | None, str], qname: str | None, attrs: xmlreader.AttributesNSImpl) -> None: ...
+    def endElementNS(self, name: tuple[str | None, str], qname: str | None) -> None: ...
+    def characters(self, content: str) -> None: ...
+    def ignorableWhitespace(self, whitespace: str) -> None: ...
+    def processingInstruction(self, target: str, data: str) -> None: ...
+    def skippedEntity(self, name: str) -> None: ...
+
 class ContentHandler:
     def setDocumentLocator(self, locator: xmlreader.Locator) -> None: ...
     def startDocument(self) -> None: ...
@@ -17,19 +39,28 @@ class ContentHandler:
     def endPrefixMapping(self, prefix: str | None) -> None: ...
     def startElement(self, name: str, attrs: xmlreader.AttributesImpl) -> None: ...
     def endElement(self, name: str) -> None: ...
-    def startElementNS(self, name: tuple[str, str], qname: str, attrs: xmlreader.AttributesNSImpl) -> None: ...
-    def endElementNS(self, name: tuple[str, str], qname: str) -> None: ...
+    def startElementNS(self, name: tuple[str | None, str], qname: str | None, attrs: xmlreader.AttributesNSImpl) -> None: ...
+    def endElementNS(self, name: tuple[str | None, str], qname: str | None) -> None: ...
     def characters(self, content: str) -> None: ...
     def ignorableWhitespace(self, whitespace: str) -> None: ...
     def processingInstruction(self, target: str, data: str) -> None: ...
     def skippedEntity(self, name: str) -> None: ...
 
+@type_check_only
+class _DTDHandlerProtocol(Protocol):  # noqa: Y046  # Protocol is not used
+    def notationDecl(self, name: str, publicId: str | None, systemId: str) -> None: ...
+    def unparsedEntityDecl(self, name: str, publicId: str | None, systemId: str, ndata: str) -> None: ...
+
 class DTDHandler:
-    def notationDecl(self, name, publicId, systemId): ...
-    def unparsedEntityDecl(self, name, publicId, systemId, ndata): ...
+    def notationDecl(self, name: str, publicId: str | None, systemId: str) -> None: ...
+    def unparsedEntityDecl(self, name: str, publicId: str | None, systemId: str, ndata: str) -> None: ...
+
+@type_check_only
+class _EntityResolverProtocol(Protocol):  # noqa: Y046  # Protocol is not used
+    def resolveEntity(self, publicId: str | None, systemId: str) -> str: ...
 
 class EntityResolver:
-    def resolveEntity(self, publicId, systemId): ...
+    def resolveEntity(self, publicId: str | None, systemId: str) -> str: ...
 
 feature_namespaces: str
 feature_namespace_prefixes: str
@@ -38,18 +69,18 @@ feature_validation: str
 feature_external_ges: str
 feature_external_pes: str
 all_features: list[str]
-property_lexical_handler: str
-property_declaration_handler: str
-property_dom_node: str
-property_xml_string: str
-property_encoding: str
-property_interning_dict: str
+property_lexical_handler: Literal["http://xml.org/sax/properties/lexical-handler"]
+property_declaration_handler: Literal["http://xml.org/sax/properties/declaration-handler"]
+property_dom_node: Literal["http://xml.org/sax/properties/dom-node"]
+property_xml_string: Literal["http://xml.org/sax/properties/xml-string"]
+property_encoding: Literal["http://www.python.org/sax/properties/encoding"]
+property_interning_dict: Literal["http://www.python.org/sax/properties/interning-dict"]
 all_properties: list[str]
 
 if sys.version_info >= (3, 10):
     class LexicalHandler:
-        def comment(self, content: str) -> object: ...
-        def startDTD(self, name: str, public_id: str | None, system_id: str | None) -> object: ...
-        def endDTD(self) -> object: ...
-        def startCDATA(self) -> object: ...
-        def endCDATA(self) -> object: ...
+        def comment(self, content: str) -> None: ...
+        def startDTD(self, name: str, public_id: str | None, system_id: str | None) -> None: ...
+        def endDTD(self) -> None: ...
+        def startCDATA(self) -> None: ...
+        def endCDATA(self) -> None: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/sax/saxutils.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/sax/saxutils.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/sax/saxutils.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/sax/saxutils.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -2,6 +2,7 @@ from _typeshed import SupportsWrite
 from codecs import StreamReaderWriter, StreamWriter
 from collections.abc import Mapping
 from io import RawIOBase, TextIOBase
+from typing import Literal, NoReturn
 from xml.sax import _Source, handler, xmlreader
 
 def escape(data: str, entities: Mapping[str, str] = {}) -> str: ...
@@ -15,23 +16,26 @@ class XMLGenerator(handler.ContentHandle
         encoding: str = "iso-8859-1",
         short_empty_elements: bool = False,
     ) -> None: ...
+    def _qname(self, name: tuple[str | None, str]) -> str: ...
     def startDocument(self) -> None: ...
     def endDocument(self) -> None: ...
     def startPrefixMapping(self, prefix: str | None, uri: str) -> None: ...
     def endPrefixMapping(self, prefix: str | None) -> None: ...
     def startElement(self, name: str, attrs: xmlreader.AttributesImpl) -> None: ...
     def endElement(self, name: str) -> None: ...
-    def startElementNS(self, name: tuple[str, str], qname: str, attrs: xmlreader.AttributesNSImpl) -> None: ...
-    def endElementNS(self, name: tuple[str, str], qname: str) -> None: ...
+    def startElementNS(self, name: tuple[str | None, str], qname: str | None, attrs: xmlreader.AttributesNSImpl) -> None: ...
+    def endElementNS(self, name: tuple[str | None, str], qname: str | None) -> None: ...
     def characters(self, content: str) -> None: ...
     def ignorableWhitespace(self, content: str) -> None: ...
     def processingInstruction(self, target: str, data: str) -> None: ...
 
 class XMLFilterBase(xmlreader.XMLReader):
     def __init__(self, parent: xmlreader.XMLReader | None = None) -> None: ...
-    def error(self, exception): ...
-    def fatalError(self, exception): ...
-    def warning(self, exception): ...
+    # ErrorHandler methods
+    def error(self, exception: BaseException) -> NoReturn: ...
+    def fatalError(self, exception: BaseException) -> NoReturn: ...
+    def warning(self, exception: BaseException) -> None: ...
+    # ContentHandler methods
     def setDocumentLocator(self, locator: xmlreader.Locator) -> None: ...
     def startDocument(self) -> None: ...
     def endDocument(self) -> None: ...
@@ -39,22 +43,26 @@ class XMLFilterBase(xmlreader.XMLReader)
     def endPrefixMapping(self, prefix: str | None) -> None: ...
     def startElement(self, name: str, attrs: xmlreader.AttributesImpl) -> None: ...
     def endElement(self, name: str) -> None: ...
-    def startElementNS(self, name: tuple[str, str], qname: str, attrs: xmlreader.AttributesNSImpl) -> None: ...
-    def endElementNS(self, name: tuple[str, str], qname: str) -> None: ...
+    def startElementNS(self, name: tuple[str | None, str], qname: str | None, attrs: xmlreader.AttributesNSImpl) -> None: ...
+    def endElementNS(self, name: tuple[str | None, str], qname: str | None) -> None: ...
     def characters(self, content: str) -> None: ...
     def ignorableWhitespace(self, chars: str) -> None: ...
     def processingInstruction(self, target: str, data: str) -> None: ...
     def skippedEntity(self, name: str) -> None: ...
-    def notationDecl(self, name, publicId, systemId): ...
-    def unparsedEntityDecl(self, name, publicId, systemId, ndata): ...
-    def resolveEntity(self, publicId, systemId): ...
-    def parse(self, source: _Source) -> None: ...
-    def setLocale(self, locale): ...
-    def getFeature(self, name: str) -> object: ...
-    def setFeature(self, name: str, state: object) -> None: ...
+    # DTDHandler methods
+    def notationDecl(self, name: str, publicId: str | None, systemId: str) -> None: ...
+    def unparsedEntityDecl(self, name: str, publicId: str | None, systemId: str, ndata: str) -> None: ...
+    # EntityResolver methods
+    def resolveEntity(self, publicId: str | None, systemId: str) -> str: ...
+    # XMLReader methods
+    def parse(self, source: xmlreader.InputSource | _Source) -> None: ...
+    def setLocale(self, locale: str) -> None: ...
+    def getFeature(self, name: str) -> Literal[1, 0] | bool: ...
+    def setFeature(self, name: str, state: Literal[1, 0] | bool) -> None: ...
     def getProperty(self, name: str) -> object: ...
     def setProperty(self, name: str, value: object) -> None: ...
-    def getParent(self) -> xmlreader.XMLReader: ...
+    # XMLFilter methods
+    def getParent(self) -> xmlreader.XMLReader | None: ...
     def setParent(self, parent: xmlreader.XMLReader) -> None: ...
 
-def prepare_input_source(source, base=""): ...
+def prepare_input_source(source: xmlreader.InputSource | _Source, base: str = "") -> xmlreader.InputSource: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/xml/sax/xmlreader.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/sax/xmlreader.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/xml/sax/xmlreader.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/xml/sax/xmlreader.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -1,87 +1,90 @@
+from _typeshed import ReadableBuffer
 from collections.abc import Mapping
-from typing import overload
+from typing import Generic, Literal, TypeVar, overload
 from typing_extensions import Self, TypeAlias
-from xml.sax.handler import ContentHandler, DTDHandler, EntityResolver, ErrorHandler
+from xml.sax import _Source, _SupportsReadClose
+from xml.sax.handler import _ContentHandlerProtocol, _DTDHandlerProtocol, _EntityResolverProtocol, _ErrorHandlerProtocol
 
 class XMLReader:
-    def parse(self, source): ...
-    def getContentHandler(self) -> ContentHandler: ...
-    def setContentHandler(self, handler: ContentHandler) -> None: ...
-    def getDTDHandler(self) -> DTDHandler: ...
-    def setDTDHandler(self, handler: DTDHandler) -> None: ...
-    def getEntityResolver(self) -> EntityResolver: ...
-    def setEntityResolver(self, resolver: EntityResolver) -> None: ...
-    def getErrorHandler(self) -> ErrorHandler: ...
-    def setErrorHandler(self, handler: ErrorHandler) -> None: ...
-    def setLocale(self, locale): ...
-    def getFeature(self, name: str) -> object: ...
-    def setFeature(self, name: str, state: object) -> None: ...
+    def parse(self, source: InputSource | _Source) -> None: ...
+    def getContentHandler(self) -> _ContentHandlerProtocol: ...
+    def setContentHandler(self, handler: _ContentHandlerProtocol) -> None: ...
+    def getDTDHandler(self) -> _DTDHandlerProtocol: ...
+    def setDTDHandler(self, handler: _DTDHandlerProtocol) -> None: ...
+    def getEntityResolver(self) -> _EntityResolverProtocol: ...
+    def setEntityResolver(self, resolver: _EntityResolverProtocol) -> None: ...
+    def getErrorHandler(self) -> _ErrorHandlerProtocol: ...
+    def setErrorHandler(self, handler: _ErrorHandlerProtocol) -> None: ...
+    def setLocale(self, locale: str) -> None: ...
+    def getFeature(self, name: str) -> Literal[0, 1] | bool: ...
+    def setFeature(self, name: str, state: Literal[0, 1] | bool) -> None: ...
     def getProperty(self, name: str) -> object: ...
     def setProperty(self, name: str, value: object) -> None: ...
 
 class IncrementalParser(XMLReader):
     def __init__(self, bufsize: int = 65536) -> None: ...
-    def parse(self, source): ...
-    def feed(self, data): ...
-    def prepareParser(self, source): ...
-    def close(self): ...
-    def reset(self): ...
+    def parse(self, source: InputSource | _Source) -> None: ...
+    def feed(self, data: str | ReadableBuffer) -> None: ...
+    def prepareParser(self, source: InputSource) -> None: ...
+    def close(self) -> None: ...
+    def reset(self) -> None: ...
 
 class Locator:
-    def getColumnNumber(self): ...
-    def getLineNumber(self): ...
-    def getPublicId(self): ...
-    def getSystemId(self): ...
+    def getColumnNumber(self) -> int | None: ...
+    def getLineNumber(self) -> int | None: ...
+    def getPublicId(self) -> str | None: ...
+    def getSystemId(self) -> str | None: ...
 
 class InputSource:
     def __init__(self, system_id: str | None = None) -> None: ...
-    def setPublicId(self, public_id): ...
-    def getPublicId(self): ...
-    def setSystemId(self, system_id): ...
-    def getSystemId(self): ...
-    def setEncoding(self, encoding): ...
-    def getEncoding(self): ...
-    def setByteStream(self, bytefile): ...
-    def getByteStream(self): ...
-    def setCharacterStream(self, charfile): ...
-    def getCharacterStream(self): ...
+    def setPublicId(self, public_id: str | None) -> None: ...
+    def getPublicId(self) -> str | None: ...
+    def setSystemId(self, system_id: str | None) -> None: ...
+    def getSystemId(self) -> str | None: ...
+    def setEncoding(self, encoding: str | None) -> None: ...
+    def getEncoding(self) -> str | None: ...
+    def setByteStream(self, bytefile: _SupportsReadClose[bytes] | None) -> None: ...
+    def getByteStream(self) -> _SupportsReadClose[bytes] | None: ...
+    def setCharacterStream(self, charfile: _SupportsReadClose[str] | None) -> None: ...
+    def getCharacterStream(self) -> _SupportsReadClose[str] | None: ...
 
-class AttributesImpl:
-    def __init__(self, attrs: Mapping[str, str]) -> None: ...
+_AttrKey = TypeVar("_AttrKey", default=str)
+
+class AttributesImpl(Generic[_AttrKey]):
+    def __init__(self, attrs: Mapping[_AttrKey, str]) -> None: ...
     def getLength(self) -> int: ...
     def getType(self, name: str) -> str: ...
-    def getValue(self, name: str) -> str: ...
+    def getValue(self, name: _AttrKey) -> str: ...
     def getValueByQName(self, name: str) -> str: ...
-    def getNameByQName(self, name: str) -> str: ...
-    def getQNameByName(self, name: str) -> str: ...
-    def getNames(self) -> list[str]: ...
+    def getNameByQName(self, name: str) -> _AttrKey: ...
+    def getQNameByName(self, name: _AttrKey) -> str: ...
+    def getNames(self) -> list[_AttrKey]: ...
     def getQNames(self) -> list[str]: ...
     def __len__(self) -> int: ...
-    def __getitem__(self, name: str) -> str: ...
-    def keys(self) -> list[str]: ...
-    def __contains__(self, name: str) -> bool: ...
+    def __getitem__(self, name: _AttrKey) -> str: ...
+    def keys(self) -> list[_AttrKey]: ...
+    def __contains__(self, name: _AttrKey) -> bool: ...
     @overload
-    def get(self, name: str, alternative: None = None) -> str | None: ...
+    def get(self, name: _AttrKey, alternative: None = None) -> str | None: ...
     @overload
-    def get(self, name: str, alternative: str) -> str: ...
+    def get(self, name: _AttrKey, alternative: str) -> str: ...
     def copy(self) -> Self: ...
-    def items(self) -> list[tuple[str, str]]: ...
+    def items(self) -> list[tuple[_AttrKey, str]]: ...
     def values(self) -> list[str]: ...
 
 _NSName: TypeAlias = tuple[str | None, str]
 
-class AttributesNSImpl(AttributesImpl):
+class AttributesNSImpl(AttributesImpl[_NSName]):
     def __init__(self, attrs: Mapping[_NSName, str], qnames: Mapping[_NSName, str]) -> None: ...
-    def getType(self, name: _NSName) -> str: ...  # type: ignore[override]
-    def getValue(self, name: _NSName) -> str: ...  # type: ignore[override]
-    def getNameByQName(self, name: str) -> _NSName: ...  # type: ignore[override]
-    def getQNameByName(self, name: _NSName) -> str: ...  # type: ignore[override]
-    def getNames(self) -> list[_NSName]: ...  # type: ignore[override]
-    def __getitem__(self, name: _NSName) -> str: ...  # type: ignore[override]
-    def keys(self) -> list[_NSName]: ...  # type: ignore[override]
-    def __contains__(self, name: _NSName) -> bool: ...  # type: ignore[override]
-    @overload  # type: ignore[override]
+    def getValue(self, name: _NSName) -> str: ...
+    def getNameByQName(self, name: str) -> _NSName: ...
+    def getQNameByName(self, name: _NSName) -> str: ...
+    def getNames(self) -> list[_NSName]: ...
+    def __getitem__(self, name: _NSName) -> str: ...
+    def keys(self) -> list[_NSName]: ...
+    def __contains__(self, name: _NSName) -> bool: ...
+    @overload
     def get(self, name: _NSName, alternative: None = None) -> str | None: ...
     @overload
     def get(self, name: _NSName, alternative: str) -> str: ...
-    def items(self) -> list[tuple[_NSName, str]]: ...  # type: ignore[override]
+    def items(self) -> list[tuple[_NSName, str]]: ...
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/zipfile/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/zipfile/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/zipfile/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/zipfile/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -362,14 +362,6 @@ else:
             def joinpath(self, *other: StrPath) -> Path: ...
         else:
             def joinpath(self, add: StrPath) -> Path: ...  # undocumented
-        if sys.version_info >= (3, 12):
-            def glob(self, pattern: str) -> Iterator[Self]: ...
-            def rglob(self, pattern: str) -> Iterator[Self]: ...
-            def is_symlink(self) -> Literal[False]: ...
-            def relative_to(self, other: Path, *extra: StrPath) -> str: ...
-            def match(self, path_pattern: str) -> bool: ...
-            def __eq__(self, other: object) -> bool: ...
-            def __hash__(self) -> int: ...
 
         def __truediv__(self, add: StrPath) -> Path: ...
 
diff -pruN 1.15.0-5/mypy/typeshed/stdlib/zipfile/_path/__init__.pyi 1.16~rc0.1-1/mypy/typeshed/stdlib/zipfile/_path/__init__.pyi
--- 1.15.0-5/mypy/typeshed/stdlib/zipfile/_path/__init__.pyi	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stdlib/zipfile/_path/__init__.pyi	2025-05-27 17:21:15.000000000 +0000
@@ -4,11 +4,9 @@ from collections.abc import Iterator, Se
 from io import TextIOWrapper
 from os import PathLike
 from typing import IO, Literal, TypeVar, overload
-from typing_extensions import Self, TypeAlias
+from typing_extensions import Self
 from zipfile import ZipFile
 
-_ReadWriteBinaryMode: TypeAlias = Literal["r", "w", "rb", "wb"]
-
 _ZF = TypeVar("_ZF", bound=ZipFile)
 
 if sys.version_info >= (3, 12):
@@ -39,42 +37,29 @@ if sys.version_info >= (3, 12):
         def name(self) -> str: ...
         @property
         def parent(self) -> PathLike[str]: ...  # undocumented
-        if sys.version_info >= (3, 10):
-            @property
-            def filename(self) -> PathLike[str]: ...  # undocumented
-        if sys.version_info >= (3, 11):
-            @property
-            def suffix(self) -> str: ...
-            @property
-            def suffixes(self) -> list[str]: ...
-            @property
-            def stem(self) -> str: ...
-
-        if sys.version_info >= (3, 9):
-            @overload
-            def open(
-                self,
-                mode: Literal["r", "w"] = "r",
-                encoding: str | None = None,
-                errors: str | None = None,
-                newline: str | None = None,
-                line_buffering: bool = ...,
-                write_through: bool = ...,
-                *,
-                pwd: bytes | None = None,
-            ) -> TextIOWrapper: ...
-            @overload
-            def open(self, mode: Literal["rb", "wb"], *, pwd: bytes | None = None) -> IO[bytes]: ...
-        else:
-            def open(
-                self, mode: _ReadWriteBinaryMode = "r", pwd: bytes | None = None, *, force_zip64: bool = False
-            ) -> IO[bytes]: ...
-
-        if sys.version_info >= (3, 10):
-            def iterdir(self) -> Iterator[Self]: ...
-        else:
-            def iterdir(self) -> Iterator[Path]: ...
-
+        @property
+        def filename(self) -> PathLike[str]: ...  # undocumented
+        @property
+        def suffix(self) -> str: ...
+        @property
+        def suffixes(self) -> list[str]: ...
+        @property
+        def stem(self) -> str: ...
+        @overload
+        def open(
+            self,
+            mode: Literal["r", "w"] = "r",
+            encoding: str | None = None,
+            errors: str | None = None,
+            newline: str | None = None,
+            line_buffering: bool = ...,
+            write_through: bool = ...,
+            *,
+            pwd: bytes | None = None,
+        ) -> TextIOWrapper: ...
+        @overload
+        def open(self, mode: Literal["rb", "wb"], *, pwd: bytes | None = None) -> IO[bytes]: ...
+        def iterdir(self) -> Iterator[Self]: ...
         def is_dir(self) -> bool: ...
         def is_file(self) -> bool: ...
         def exists(self) -> bool: ...
@@ -87,17 +72,12 @@ if sys.version_info >= (3, 12):
             write_through: bool = ...,
         ) -> str: ...
         def read_bytes(self) -> bytes: ...
-        if sys.version_info >= (3, 10):
-            def joinpath(self, *other: StrPath) -> Path: ...
-        else:
-            def joinpath(self, add: StrPath) -> Path: ...  # undocumented
-        if sys.version_info >= (3, 12):
-            def glob(self, pattern: str) -> Iterator[Self]: ...
-            def rglob(self, pattern: str) -> Iterator[Self]: ...
-            def is_symlink(self) -> Literal[False]: ...
-            def relative_to(self, other: Path, *extra: StrPath) -> str: ...
-            def match(self, path_pattern: str) -> bool: ...
-            def __eq__(self, other: object) -> bool: ...
-            def __hash__(self) -> int: ...
-
+        def joinpath(self, *other: StrPath) -> Path: ...
+        def glob(self, pattern: str) -> Iterator[Self]: ...
+        def rglob(self, pattern: str) -> Iterator[Self]: ...
+        def is_symlink(self) -> Literal[False]: ...
+        def relative_to(self, other: Path, *extra: StrPath) -> str: ...
+        def match(self, path_pattern: str) -> bool: ...
+        def __eq__(self, other: object) -> bool: ...
+        def __hash__(self) -> int: ...
         def __truediv__(self, add: StrPath) -> Path: ...
diff -pruN 1.15.0-5/mypy/typeshed/stubs/mypy-extensions/@tests/stubtest_allowlist.txt 1.16~rc0.1-1/mypy/typeshed/stubs/mypy-extensions/@tests/stubtest_allowlist.txt
--- 1.15.0-5/mypy/typeshed/stubs/mypy-extensions/@tests/stubtest_allowlist.txt	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stubs/mypy-extensions/@tests/stubtest_allowlist.txt	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,2 @@
+mypy_extensions.FlexibleAlias
+mypy_extensions.TypedDict
diff -pruN 1.15.0-5/mypy/typeshed/stubs/mypy-extensions/METADATA.toml 1.16~rc0.1-1/mypy/typeshed/stubs/mypy-extensions/METADATA.toml
--- 1.15.0-5/mypy/typeshed/stubs/mypy-extensions/METADATA.toml	1970-01-01 00:00:00.000000000 +0000
+++ 1.16~rc0.1-1/mypy/typeshed/stubs/mypy-extensions/METADATA.toml	2025-05-27 17:21:15.000000000 +0000
@@ -0,0 +1,4 @@
+version = "1.0.*"
+
+[tool.stubtest]
+ignore_missing_stub = false
diff -pruN 1.15.0-5/mypy/util.py 1.16~rc0.1-1/mypy/util.py
--- 1.15.0-5/mypy/util.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/util.py	2025-05-27 17:21:15.000000000 +0000
@@ -571,8 +571,7 @@ def hash_digest(data: bytes) -> str:
 
 def parse_gray_color(cup: bytes) -> str:
     """Reproduce a gray color in ANSI escape sequence"""
-    if sys.platform == "win32":
-        assert False, "curses is not available on Windows"
+    assert sys.platform != "win32", "curses is not available on Windows"
     set_color = "".join([cup[:-1].decode(), "m"])
     gray = curses.tparm(set_color.encode("utf-8"), 1, 9).decode()
     return gray
@@ -639,8 +638,7 @@ class FancyFormatter:
         # Windows ANSI escape sequences are only supported on Threshold 2 and above.
         # we check with an assert at runtime and an if check for mypy, as asserts do not
         # yet narrow platform
-        assert sys.platform == "win32"
-        if sys.platform == "win32":
+        if sys.platform == "win32":  # needed to find win specific sys apis
             winver = sys.getwindowsversion()
             if (
                 winver.major < MINIMUM_WINDOWS_MAJOR_VT100
@@ -662,11 +660,12 @@ class FancyFormatter:
             )
             self.initialize_vt100_colors()
             return True
-        return False
+        assert False, "Running not on Windows"
 
     def initialize_unix_colors(self) -> bool:
         """Return True if initialization was successful and we can use colors, False otherwise"""
-        if sys.platform == "win32" or not CURSES_ENABLED:
+        is_win = sys.platform == "win32"
+        if is_win or not CURSES_ENABLED:
             return False
         try:
             # setupterm wants a fd to potentially write an "initialization sequence".
diff -pruN 1.15.0-5/mypy/version.py 1.16~rc0.1-1/mypy/version.py
--- 1.15.0-5/mypy/version.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/version.py	2025-05-27 17:21:15.000000000 +0000
@@ -8,7 +8,7 @@ from mypy import git
 # - Release versions have the form "1.2.3".
 # - Dev versions have the form "1.2.3+dev" (PLUS sign to conform to PEP 440).
 # - Before 1.0 we had the form "0.NNN".
-__version__ = "1.15.0"
+__version__ = "1.16.0+dev"
 base_version = __version__
 
 mypy_dir = os.path.abspath(os.path.dirname(os.path.dirname(__file__)))
diff -pruN 1.15.0-5/mypy/visitor.py 1.16~rc0.1-1/mypy/visitor.py
--- 1.15.0-5/mypy/visitor.py	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy/visitor.py	2025-05-27 17:21:15.000000000 +0000
@@ -356,273 +356,270 @@ class NodeVisitor(Generic[T], Expression
     """Empty base class for parse tree node visitors.
 
     The T type argument specifies the return type of the visit
-    methods. As all methods defined here return None by default,
+    methods. As all methods defined here raise by default,
     subclasses do not always need to override all the methods.
-
-    TODO: make the default return value explicit, then turn on
-          empty body checking in mypy_self_check.ini.
     """
 
     # Not in superclasses:
 
     def visit_mypy_file(self, o: mypy.nodes.MypyFile, /) -> T:
-        pass
+        raise NotImplementedError()
 
     # TODO: We have a visit_var method, but no visit_typeinfo or any
     # other non-Statement SymbolNode (accepting those will raise a
     # runtime error). Maybe this should be resolved in some direction.
     def visit_var(self, o: mypy.nodes.Var, /) -> T:
-        pass
+        raise NotImplementedError()
 
     # Module structure
 
     def visit_import(self, o: mypy.nodes.Import, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_import_from(self, o: mypy.nodes.ImportFrom, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_import_all(self, o: mypy.nodes.ImportAll, /) -> T:
-        pass
+        raise NotImplementedError()
 
     # Definitions
 
     def visit_func_def(self, o: mypy.nodes.FuncDef, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_overloaded_func_def(self, o: mypy.nodes.OverloadedFuncDef, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_class_def(self, o: mypy.nodes.ClassDef, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_global_decl(self, o: mypy.nodes.GlobalDecl, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_nonlocal_decl(self, o: mypy.nodes.NonlocalDecl, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_decorator(self, o: mypy.nodes.Decorator, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_type_alias(self, o: mypy.nodes.TypeAlias, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_placeholder_node(self, o: mypy.nodes.PlaceholderNode, /) -> T:
-        pass
+        raise NotImplementedError()
 
     # Statements
 
     def visit_block(self, o: mypy.nodes.Block, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_expression_stmt(self, o: mypy.nodes.ExpressionStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_assignment_stmt(self, o: mypy.nodes.AssignmentStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_operator_assignment_stmt(self, o: mypy.nodes.OperatorAssignmentStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_while_stmt(self, o: mypy.nodes.WhileStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_for_stmt(self, o: mypy.nodes.ForStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_return_stmt(self, o: mypy.nodes.ReturnStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_assert_stmt(self, o: mypy.nodes.AssertStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_del_stmt(self, o: mypy.nodes.DelStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_if_stmt(self, o: mypy.nodes.IfStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_break_stmt(self, o: mypy.nodes.BreakStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_continue_stmt(self, o: mypy.nodes.ContinueStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_pass_stmt(self, o: mypy.nodes.PassStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_raise_stmt(self, o: mypy.nodes.RaiseStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_try_stmt(self, o: mypy.nodes.TryStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_with_stmt(self, o: mypy.nodes.WithStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_match_stmt(self, o: mypy.nodes.MatchStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_type_alias_stmt(self, o: mypy.nodes.TypeAliasStmt, /) -> T:
-        pass
+        raise NotImplementedError()
 
     # Expressions (default no-op implementation)
 
     def visit_int_expr(self, o: mypy.nodes.IntExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_str_expr(self, o: mypy.nodes.StrExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_bytes_expr(self, o: mypy.nodes.BytesExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_float_expr(self, o: mypy.nodes.FloatExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_complex_expr(self, o: mypy.nodes.ComplexExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_ellipsis(self, o: mypy.nodes.EllipsisExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_star_expr(self, o: mypy.nodes.StarExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_name_expr(self, o: mypy.nodes.NameExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_member_expr(self, o: mypy.nodes.MemberExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_yield_from_expr(self, o: mypy.nodes.YieldFromExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_yield_expr(self, o: mypy.nodes.YieldExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_call_expr(self, o: mypy.nodes.CallExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_op_expr(self, o: mypy.nodes.OpExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_comparison_expr(self, o: mypy.nodes.ComparisonExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_cast_expr(self, o: mypy.nodes.CastExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_assert_type_expr(self, o: mypy.nodes.AssertTypeExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_reveal_expr(self, o: mypy.nodes.RevealExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_super_expr(self, o: mypy.nodes.SuperExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_assignment_expr(self, o: mypy.nodes.AssignmentExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_unary_expr(self, o: mypy.nodes.UnaryExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_list_expr(self, o: mypy.nodes.ListExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_dict_expr(self, o: mypy.nodes.DictExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_tuple_expr(self, o: mypy.nodes.TupleExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_set_expr(self, o: mypy.nodes.SetExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_index_expr(self, o: mypy.nodes.IndexExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_type_application(self, o: mypy.nodes.TypeApplication, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_lambda_expr(self, o: mypy.nodes.LambdaExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_list_comprehension(self, o: mypy.nodes.ListComprehension, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_set_comprehension(self, o: mypy.nodes.SetComprehension, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_dictionary_comprehension(self, o: mypy.nodes.DictionaryComprehension, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_generator_expr(self, o: mypy.nodes.GeneratorExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_slice_expr(self, o: mypy.nodes.SliceExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_conditional_expr(self, o: mypy.nodes.ConditionalExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_type_var_expr(self, o: mypy.nodes.TypeVarExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_paramspec_expr(self, o: mypy.nodes.ParamSpecExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_type_var_tuple_expr(self, o: mypy.nodes.TypeVarTupleExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_type_alias_expr(self, o: mypy.nodes.TypeAliasExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_namedtuple_expr(self, o: mypy.nodes.NamedTupleExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_enum_call_expr(self, o: mypy.nodes.EnumCallExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_typeddict_expr(self, o: mypy.nodes.TypedDictExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_newtype_expr(self, o: mypy.nodes.NewTypeExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit__promote_expr(self, o: mypy.nodes.PromoteExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_await_expr(self, o: mypy.nodes.AwaitExpr, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_temp_node(self, o: mypy.nodes.TempNode, /) -> T:
-        pass
+        raise NotImplementedError()
 
     # Patterns
 
     def visit_as_pattern(self, o: mypy.patterns.AsPattern, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_or_pattern(self, o: mypy.patterns.OrPattern, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_value_pattern(self, o: mypy.patterns.ValuePattern, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_singleton_pattern(self, o: mypy.patterns.SingletonPattern, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_sequence_pattern(self, o: mypy.patterns.SequencePattern, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_starred_pattern(self, o: mypy.patterns.StarredPattern, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_mapping_pattern(self, o: mypy.patterns.MappingPattern, /) -> T:
-        pass
+        raise NotImplementedError()
 
     def visit_class_pattern(self, o: mypy.patterns.ClassPattern, /) -> T:
-        pass
+        raise NotImplementedError()
diff -pruN 1.15.0-5/mypy-requirements.txt 1.16~rc0.1-1/mypy-requirements.txt
--- 1.15.0-5/mypy-requirements.txt	2025-02-05 00:53:37.000000000 +0000
+++ 1.16~rc0.1-1/mypy-requirements.txt	2025-05-27 17:21:15.000000000 +0000
@@ -2,4 +2,5 @@
 # and the pins in setup.py
 typing_extensions>=4.6.0
 mypy_extensions>=1.0.0
+pathspec>=0.9.0
 tomli>=1.1.0; python_version<'3.11'
diff -pruN 1.15.0-5/mypy.egg-info/PKG-INFO 1.16~rc0.1-1/mypy.egg-info/PKG-INFO
--- 1.15.0-5/mypy.egg-info/PKG-INFO	2025-02-05 00:53:52.000000000 +0000
+++ 1.16~rc0.1-1/mypy.egg-info/PKG-INFO	1970-01-01 00:00:00.000000000 +0000
@@ -1,50 +0,0 @@
-Metadata-Version: 2.2
-Name: mypy
-Version: 1.15.0
-Summary: Optional static typing for Python
-Author-email: Jukka Lehtosalo <jukka.lehtosalo@iki.fi>
-License: MIT
-Project-URL: Homepage, https://www.mypy-lang.org/
-Project-URL: Documentation, https://mypy.readthedocs.io/en/stable/index.html
-Project-URL: Repository, https://github.com/python/mypy
-Project-URL: Changelog, https://github.com/python/mypy/blob/master/CHANGELOG.md
-Project-URL: Issues, https://github.com/python/mypy/issues
-Classifier: Development Status :: 5 - Production/Stable
-Classifier: Environment :: Console
-Classifier: Intended Audience :: Developers
-Classifier: License :: OSI Approved :: MIT License
-Classifier: Programming Language :: Python :: 3
-Classifier: Programming Language :: Python :: 3.9
-Classifier: Programming Language :: Python :: 3.10
-Classifier: Programming Language :: Python :: 3.11
-Classifier: Programming Language :: Python :: 3.12
-Classifier: Programming Language :: Python :: 3.13
-Classifier: Topic :: Software Development
-Classifier: Typing :: Typed
-Requires-Python: >=3.9
-Description-Content-Type: text/x-rst
-License-File: LICENSE
-Requires-Dist: typing_extensions>=4.6.0
-Requires-Dist: mypy_extensions>=1.0.0
-Requires-Dist: tomli>=1.1.0; python_version < "3.11"
-Provides-Extra: dmypy
-Requires-Dist: psutil>=4.0; extra == "dmypy"
-Provides-Extra: mypyc
-Requires-Dist: setuptools>=50; extra == "mypyc"
-Provides-Extra: python2
-Provides-Extra: reports
-Requires-Dist: lxml; extra == "reports"
-Provides-Extra: install-types
-Requires-Dist: pip; extra == "install-types"
-Provides-Extra: faster-cache
-Requires-Dist: orjson; extra == "faster-cache"
-
-Mypy -- Optional Static Typing for Python
-=========================================
-
-Add type annotations to your Python programs, and use mypy to type
-check them.  Mypy is essentially a Python linter on steroids, and it
-can catch many programming errors by analyzing your program, without
-actually having to run it.  Mypy has a powerful type system with
-features such as type inference, gradual typing, generics and union
-types.
diff -pruN 1.15.0-5/mypy.egg-info/SOURCES.txt 1.16~rc0.1-1/mypy.egg-info/SOURCES.txt
--- 1.15.0-5/mypy.egg-info/SOURCES.txt	2025-02-05 00:53:52.000000000 +0000
+++ 1.16~rc0.1-1/mypy.egg-info/SOURCES.txt	1970-01-01 00:00:00.000000000 +0000
@@ -1,1603 +0,0 @@
-CHANGELOG.md
-LICENSE
-MANIFEST.in
-README.md
-build-requirements.txt
-conftest.py
-mypy-requirements.txt
-mypy_bootstrap.ini
-mypy_self_check.ini
-pyproject.toml
-runtests.py
-setup.py
-test-requirements.in
-test-requirements.txt
-tox.ini
-docs/Makefile
-docs/README.md
-docs/make.bat
-docs/requirements-docs.txt
-docs/source/additional_features.rst
-docs/source/builtin_types.rst
-docs/source/changelog.md
-docs/source/cheat_sheet_py3.rst
-docs/source/class_basics.rst
-docs/source/command_line.rst
-docs/source/common_issues.rst
-docs/source/conf.py
-docs/source/config_file.rst
-docs/source/duck_type_compatibility.rst
-docs/source/dynamic_typing.rst
-docs/source/error_code_list.rst
-docs/source/error_code_list2.rst
-docs/source/error_codes.rst
-docs/source/existing_code.rst
-docs/source/extending_mypy.rst
-docs/source/faq.rst
-docs/source/final_attrs.rst
-docs/source/generics.rst
-docs/source/getting_started.rst
-docs/source/html_builder.py
-docs/source/index.rst
-docs/source/inline_config.rst
-docs/source/installed_packages.rst
-docs/source/kinds_of_types.rst
-docs/source/literal_types.rst
-docs/source/metaclasses.rst
-docs/source/more_types.rst
-docs/source/mypy_daemon.rst
-docs/source/mypy_light.svg
-docs/source/protocols.rst
-docs/source/running_mypy.rst
-docs/source/runtime_troubles.rst
-docs/source/stubgen.rst
-docs/source/stubs.rst
-docs/source/stubtest.rst
-docs/source/supported_python_features.rst
-docs/source/type_inference_and_annotations.rst
-docs/source/type_narrowing.rst
-docs/source/typed_dict.rst
-mypy/__init__.py
-mypy/__main__.py
-mypy/api.py
-mypy/applytype.py
-mypy/argmap.py
-mypy/binder.py
-mypy/bogus_type.py
-mypy/build.py
-mypy/checker.py
-mypy/checkexpr.py
-mypy/checkmember.py
-mypy/checkpattern.py
-mypy/checkstrformat.py
-mypy/config_parser.py
-mypy/constant_fold.py
-mypy/constraints.py
-mypy/copytype.py
-mypy/defaults.py
-mypy/dmypy_os.py
-mypy/dmypy_server.py
-mypy/dmypy_util.py
-mypy/erasetype.py
-mypy/error_formatter.py
-mypy/errorcodes.py
-mypy/errors.py
-mypy/evalexpr.py
-mypy/expandtype.py
-mypy/exprtotype.py
-mypy/fastparse.py
-mypy/find_sources.py
-mypy/fixup.py
-mypy/freetree.py
-mypy/fscache.py
-mypy/fswatcher.py
-mypy/gclogger.py
-mypy/git.py
-mypy/graph_utils.py
-mypy/indirection.py
-mypy/infer.py
-mypy/inspections.py
-mypy/ipc.py
-mypy/join.py
-mypy/literals.py
-mypy/lookup.py
-mypy/main.py
-mypy/maptype.py
-mypy/meet.py
-mypy/memprofile.py
-mypy/message_registry.py
-mypy/messages.py
-mypy/metastore.py
-mypy/mixedtraverser.py
-mypy/modulefinder.py
-mypy/moduleinspect.py
-mypy/mro.py
-mypy/nodes.py
-mypy/operators.py
-mypy/options.py
-mypy/parse.py
-mypy/partially_defined.py
-mypy/patterns.py
-mypy/plugin.py
-mypy/py.typed
-mypy/pyinfo.py
-mypy/reachability.py
-mypy/refinfo.py
-mypy/renaming.py
-mypy/report.py
-mypy/scope.py
-mypy/semanal.py
-mypy/semanal_classprop.py
-mypy/semanal_enum.py
-mypy/semanal_infer.py
-mypy/semanal_main.py
-mypy/semanal_namedtuple.py
-mypy/semanal_newtype.py
-mypy/semanal_pass1.py
-mypy/semanal_shared.py
-mypy/semanal_typeargs.py
-mypy/semanal_typeddict.py
-mypy/sharedparse.py
-mypy/solve.py
-mypy/split_namespace.py
-mypy/state.py
-mypy/stats.py
-mypy/strconv.py
-mypy/stubdoc.py
-mypy/stubgen.py
-mypy/stubgenc.py
-mypy/stubinfo.py
-mypy/stubtest.py
-mypy/stubutil.py
-mypy/subtypes.py
-mypy/suggestions.py
-mypy/traverser.py
-mypy/treetransform.py
-mypy/tvar_scope.py
-mypy/type_visitor.py
-mypy/typeanal.py
-mypy/typeops.py
-mypy/types.py
-mypy/types_utils.py
-mypy/typestate.py
-mypy/typetraverser.py
-mypy/typevars.py
-mypy/typevartuples.py
-mypy/util.py
-mypy/version.py
-mypy/visitor.py
-mypy.egg-info/PKG-INFO
-mypy.egg-info/SOURCES.txt
-mypy.egg-info/dependency_links.txt
-mypy.egg-info/entry_points.txt
-mypy.egg-info/requires.txt
-mypy.egg-info/top_level.txt
-mypy/dmypy/__init__.py
-mypy/dmypy/__main__.py
-mypy/dmypy/client.py
-mypy/plugins/__init__.py
-mypy/plugins/attrs.py
-mypy/plugins/common.py
-mypy/plugins/ctypes.py
-mypy/plugins/dataclasses.py
-mypy/plugins/default.py
-mypy/plugins/enums.py
-mypy/plugins/functools.py
-mypy/plugins/proper_plugin.py
-mypy/plugins/singledispatch.py
-mypy/server/__init__.py
-mypy/server/astdiff.py
-mypy/server/astmerge.py
-mypy/server/aststrip.py
-mypy/server/deps.py
-mypy/server/mergecheck.py
-mypy/server/objgraph.py
-mypy/server/subexpr.py
-mypy/server/target.py
-mypy/server/trigger.py
-mypy/server/update.py
-mypy/test/__init__.py
-mypy/test/config.py
-mypy/test/data.py
-mypy/test/helpers.py
-mypy/test/test_config_parser.py
-mypy/test/test_find_sources.py
-mypy/test/test_ref_info.py
-mypy/test/testapi.py
-mypy/test/testargs.py
-mypy/test/testcheck.py
-mypy/test/testcmdline.py
-mypy/test/testconstraints.py
-mypy/test/testdaemon.py
-mypy/test/testdeps.py
-mypy/test/testdiff.py
-mypy/test/testerrorstream.py
-mypy/test/testfinegrained.py
-mypy/test/testfinegrainedcache.py
-mypy/test/testformatter.py
-mypy/test/testfscache.py
-mypy/test/testgraph.py
-mypy/test/testinfer.py
-mypy/test/testipc.py
-mypy/test/testmerge.py
-mypy/test/testmodulefinder.py
-mypy/test/testmypyc.py
-mypy/test/testoutput.py
-mypy/test/testparse.py
-mypy/test/testpep561.py
-mypy/test/testpythoneval.py
-mypy/test/testreports.py
-mypy/test/testsemanal.py
-mypy/test/testsolve.py
-mypy/test/teststubgen.py
-mypy/test/teststubinfo.py
-mypy/test/teststubtest.py
-mypy/test/testsubtypes.py
-mypy/test/testtransform.py
-mypy/test/testtypegen.py
-mypy/test/testtypes.py
-mypy/test/testutil.py
-mypy/test/typefixture.py
-mypy/test/update_data.py
-mypy/test/visitors.py
-mypy/test/meta/__init__.py
-mypy/test/meta/_pytest.py
-mypy/test/meta/test_diff_helper.py
-mypy/test/meta/test_parse_data.py
-mypy/test/meta/test_update_data.py
-mypy/typeshed/LICENSE
-mypy/typeshed/stdlib/VERSIONS
-mypy/typeshed/stdlib/__future__.pyi
-mypy/typeshed/stdlib/__main__.pyi
-mypy/typeshed/stdlib/_ast.pyi
-mypy/typeshed/stdlib/_asyncio.pyi
-mypy/typeshed/stdlib/_bisect.pyi
-mypy/typeshed/stdlib/_blake2.pyi
-mypy/typeshed/stdlib/_bootlocale.pyi
-mypy/typeshed/stdlib/_bz2.pyi
-mypy/typeshed/stdlib/_codecs.pyi
-mypy/typeshed/stdlib/_collections_abc.pyi
-mypy/typeshed/stdlib/_compat_pickle.pyi
-mypy/typeshed/stdlib/_compression.pyi
-mypy/typeshed/stdlib/_contextvars.pyi
-mypy/typeshed/stdlib/_csv.pyi
-mypy/typeshed/stdlib/_ctypes.pyi
-mypy/typeshed/stdlib/_curses.pyi
-mypy/typeshed/stdlib/_curses_panel.pyi
-mypy/typeshed/stdlib/_dbm.pyi
-mypy/typeshed/stdlib/_decimal.pyi
-mypy/typeshed/stdlib/_dummy_thread.pyi
-mypy/typeshed/stdlib/_dummy_threading.pyi
-mypy/typeshed/stdlib/_frozen_importlib.pyi
-mypy/typeshed/stdlib/_frozen_importlib_external.pyi
-mypy/typeshed/stdlib/_gdbm.pyi
-mypy/typeshed/stdlib/_hashlib.pyi
-mypy/typeshed/stdlib/_heapq.pyi
-mypy/typeshed/stdlib/_imp.pyi
-mypy/typeshed/stdlib/_interpchannels.pyi
-mypy/typeshed/stdlib/_interpqueues.pyi
-mypy/typeshed/stdlib/_interpreters.pyi
-mypy/typeshed/stdlib/_io.pyi
-mypy/typeshed/stdlib/_json.pyi
-mypy/typeshed/stdlib/_locale.pyi
-mypy/typeshed/stdlib/_lsprof.pyi
-mypy/typeshed/stdlib/_lzma.pyi
-mypy/typeshed/stdlib/_markupbase.pyi
-mypy/typeshed/stdlib/_msi.pyi
-mypy/typeshed/stdlib/_multibytecodec.pyi
-mypy/typeshed/stdlib/_operator.pyi
-mypy/typeshed/stdlib/_osx_support.pyi
-mypy/typeshed/stdlib/_pickle.pyi
-mypy/typeshed/stdlib/_posixsubprocess.pyi
-mypy/typeshed/stdlib/_py_abc.pyi
-mypy/typeshed/stdlib/_pydecimal.pyi
-mypy/typeshed/stdlib/_queue.pyi
-mypy/typeshed/stdlib/_random.pyi
-mypy/typeshed/stdlib/_sitebuiltins.pyi
-mypy/typeshed/stdlib/_socket.pyi
-mypy/typeshed/stdlib/_sqlite3.pyi
-mypy/typeshed/stdlib/_ssl.pyi
-mypy/typeshed/stdlib/_stat.pyi
-mypy/typeshed/stdlib/_struct.pyi
-mypy/typeshed/stdlib/_thread.pyi
-mypy/typeshed/stdlib/_threading_local.pyi
-mypy/typeshed/stdlib/_tkinter.pyi
-mypy/typeshed/stdlib/_tracemalloc.pyi
-mypy/typeshed/stdlib/_warnings.pyi
-mypy/typeshed/stdlib/_weakref.pyi
-mypy/typeshed/stdlib/_weakrefset.pyi
-mypy/typeshed/stdlib/_winapi.pyi
-mypy/typeshed/stdlib/abc.pyi
-mypy/typeshed/stdlib/aifc.pyi
-mypy/typeshed/stdlib/antigravity.pyi
-mypy/typeshed/stdlib/argparse.pyi
-mypy/typeshed/stdlib/array.pyi
-mypy/typeshed/stdlib/ast.pyi
-mypy/typeshed/stdlib/asynchat.pyi
-mypy/typeshed/stdlib/asyncore.pyi
-mypy/typeshed/stdlib/atexit.pyi
-mypy/typeshed/stdlib/audioop.pyi
-mypy/typeshed/stdlib/base64.pyi
-mypy/typeshed/stdlib/bdb.pyi
-mypy/typeshed/stdlib/binascii.pyi
-mypy/typeshed/stdlib/binhex.pyi
-mypy/typeshed/stdlib/bisect.pyi
-mypy/typeshed/stdlib/builtins.pyi
-mypy/typeshed/stdlib/bz2.pyi
-mypy/typeshed/stdlib/cProfile.pyi
-mypy/typeshed/stdlib/calendar.pyi
-mypy/typeshed/stdlib/cgi.pyi
-mypy/typeshed/stdlib/cgitb.pyi
-mypy/typeshed/stdlib/chunk.pyi
-mypy/typeshed/stdlib/cmath.pyi
-mypy/typeshed/stdlib/cmd.pyi
-mypy/typeshed/stdlib/code.pyi
-mypy/typeshed/stdlib/codecs.pyi
-mypy/typeshed/stdlib/codeop.pyi
-mypy/typeshed/stdlib/colorsys.pyi
-mypy/typeshed/stdlib/compileall.pyi
-mypy/typeshed/stdlib/configparser.pyi
-mypy/typeshed/stdlib/contextlib.pyi
-mypy/typeshed/stdlib/contextvars.pyi
-mypy/typeshed/stdlib/copy.pyi
-mypy/typeshed/stdlib/copyreg.pyi
-mypy/typeshed/stdlib/crypt.pyi
-mypy/typeshed/stdlib/csv.pyi
-mypy/typeshed/stdlib/dataclasses.pyi
-mypy/typeshed/stdlib/datetime.pyi
-mypy/typeshed/stdlib/decimal.pyi
-mypy/typeshed/stdlib/difflib.pyi
-mypy/typeshed/stdlib/dis.pyi
-mypy/typeshed/stdlib/doctest.pyi
-mypy/typeshed/stdlib/dummy_threading.pyi
-mypy/typeshed/stdlib/enum.pyi
-mypy/typeshed/stdlib/errno.pyi
-mypy/typeshed/stdlib/faulthandler.pyi
-mypy/typeshed/stdlib/fcntl.pyi
-mypy/typeshed/stdlib/filecmp.pyi
-mypy/typeshed/stdlib/fileinput.pyi
-mypy/typeshed/stdlib/fnmatch.pyi
-mypy/typeshed/stdlib/formatter.pyi
-mypy/typeshed/stdlib/fractions.pyi
-mypy/typeshed/stdlib/ftplib.pyi
-mypy/typeshed/stdlib/functools.pyi
-mypy/typeshed/stdlib/gc.pyi
-mypy/typeshed/stdlib/genericpath.pyi
-mypy/typeshed/stdlib/getopt.pyi
-mypy/typeshed/stdlib/getpass.pyi
-mypy/typeshed/stdlib/gettext.pyi
-mypy/typeshed/stdlib/glob.pyi
-mypy/typeshed/stdlib/graphlib.pyi
-mypy/typeshed/stdlib/grp.pyi
-mypy/typeshed/stdlib/gzip.pyi
-mypy/typeshed/stdlib/hashlib.pyi
-mypy/typeshed/stdlib/heapq.pyi
-mypy/typeshed/stdlib/hmac.pyi
-mypy/typeshed/stdlib/imaplib.pyi
-mypy/typeshed/stdlib/imghdr.pyi
-mypy/typeshed/stdlib/imp.pyi
-mypy/typeshed/stdlib/inspect.pyi
-mypy/typeshed/stdlib/io.pyi
-mypy/typeshed/stdlib/ipaddress.pyi
-mypy/typeshed/stdlib/itertools.pyi
-mypy/typeshed/stdlib/keyword.pyi
-mypy/typeshed/stdlib/linecache.pyi
-mypy/typeshed/stdlib/locale.pyi
-mypy/typeshed/stdlib/lzma.pyi
-mypy/typeshed/stdlib/mailbox.pyi
-mypy/typeshed/stdlib/mailcap.pyi
-mypy/typeshed/stdlib/marshal.pyi
-mypy/typeshed/stdlib/math.pyi
-mypy/typeshed/stdlib/mimetypes.pyi
-mypy/typeshed/stdlib/mmap.pyi
-mypy/typeshed/stdlib/modulefinder.pyi
-mypy/typeshed/stdlib/msvcrt.pyi
-mypy/typeshed/stdlib/netrc.pyi
-mypy/typeshed/stdlib/nis.pyi
-mypy/typeshed/stdlib/nntplib.pyi
-mypy/typeshed/stdlib/nt.pyi
-mypy/typeshed/stdlib/ntpath.pyi
-mypy/typeshed/stdlib/nturl2path.pyi
-mypy/typeshed/stdlib/numbers.pyi
-mypy/typeshed/stdlib/opcode.pyi
-mypy/typeshed/stdlib/operator.pyi
-mypy/typeshed/stdlib/optparse.pyi
-mypy/typeshed/stdlib/ossaudiodev.pyi
-mypy/typeshed/stdlib/parser.pyi
-mypy/typeshed/stdlib/pathlib.pyi
-mypy/typeshed/stdlib/pdb.pyi
-mypy/typeshed/stdlib/pickle.pyi
-mypy/typeshed/stdlib/pickletools.pyi
-mypy/typeshed/stdlib/pipes.pyi
-mypy/typeshed/stdlib/pkgutil.pyi
-mypy/typeshed/stdlib/platform.pyi
-mypy/typeshed/stdlib/plistlib.pyi
-mypy/typeshed/stdlib/poplib.pyi
-mypy/typeshed/stdlib/posix.pyi
-mypy/typeshed/stdlib/posixpath.pyi
-mypy/typeshed/stdlib/pprint.pyi
-mypy/typeshed/stdlib/profile.pyi
-mypy/typeshed/stdlib/pstats.pyi
-mypy/typeshed/stdlib/pty.pyi
-mypy/typeshed/stdlib/pwd.pyi
-mypy/typeshed/stdlib/py_compile.pyi
-mypy/typeshed/stdlib/pyclbr.pyi
-mypy/typeshed/stdlib/pydoc.pyi
-mypy/typeshed/stdlib/queue.pyi
-mypy/typeshed/stdlib/quopri.pyi
-mypy/typeshed/stdlib/random.pyi
-mypy/typeshed/stdlib/re.pyi
-mypy/typeshed/stdlib/readline.pyi
-mypy/typeshed/stdlib/reprlib.pyi
-mypy/typeshed/stdlib/resource.pyi
-mypy/typeshed/stdlib/rlcompleter.pyi
-mypy/typeshed/stdlib/runpy.pyi
-mypy/typeshed/stdlib/sched.pyi
-mypy/typeshed/stdlib/secrets.pyi
-mypy/typeshed/stdlib/select.pyi
-mypy/typeshed/stdlib/selectors.pyi
-mypy/typeshed/stdlib/shelve.pyi
-mypy/typeshed/stdlib/shlex.pyi
-mypy/typeshed/stdlib/shutil.pyi
-mypy/typeshed/stdlib/signal.pyi
-mypy/typeshed/stdlib/site.pyi
-mypy/typeshed/stdlib/smtpd.pyi
-mypy/typeshed/stdlib/smtplib.pyi
-mypy/typeshed/stdlib/sndhdr.pyi
-mypy/typeshed/stdlib/socket.pyi
-mypy/typeshed/stdlib/socketserver.pyi
-mypy/typeshed/stdlib/spwd.pyi
-mypy/typeshed/stdlib/sre_compile.pyi
-mypy/typeshed/stdlib/sre_constants.pyi
-mypy/typeshed/stdlib/sre_parse.pyi
-mypy/typeshed/stdlib/ssl.pyi
-mypy/typeshed/stdlib/stat.pyi
-mypy/typeshed/stdlib/statistics.pyi
-mypy/typeshed/stdlib/string.pyi
-mypy/typeshed/stdlib/stringprep.pyi
-mypy/typeshed/stdlib/struct.pyi
-mypy/typeshed/stdlib/subprocess.pyi
-mypy/typeshed/stdlib/sunau.pyi
-mypy/typeshed/stdlib/symbol.pyi
-mypy/typeshed/stdlib/symtable.pyi
-mypy/typeshed/stdlib/sysconfig.pyi
-mypy/typeshed/stdlib/syslog.pyi
-mypy/typeshed/stdlib/tabnanny.pyi
-mypy/typeshed/stdlib/tarfile.pyi
-mypy/typeshed/stdlib/telnetlib.pyi
-mypy/typeshed/stdlib/tempfile.pyi
-mypy/typeshed/stdlib/termios.pyi
-mypy/typeshed/stdlib/textwrap.pyi
-mypy/typeshed/stdlib/this.pyi
-mypy/typeshed/stdlib/threading.pyi
-mypy/typeshed/stdlib/time.pyi
-mypy/typeshed/stdlib/timeit.pyi
-mypy/typeshed/stdlib/token.pyi
-mypy/typeshed/stdlib/tokenize.pyi
-mypy/typeshed/stdlib/tomllib.pyi
-mypy/typeshed/stdlib/trace.pyi
-mypy/typeshed/stdlib/traceback.pyi
-mypy/typeshed/stdlib/tracemalloc.pyi
-mypy/typeshed/stdlib/tty.pyi
-mypy/typeshed/stdlib/turtle.pyi
-mypy/typeshed/stdlib/types.pyi
-mypy/typeshed/stdlib/typing.pyi
-mypy/typeshed/stdlib/typing_extensions.pyi
-mypy/typeshed/stdlib/unicodedata.pyi
-mypy/typeshed/stdlib/uu.pyi
-mypy/typeshed/stdlib/uuid.pyi
-mypy/typeshed/stdlib/warnings.pyi
-mypy/typeshed/stdlib/wave.pyi
-mypy/typeshed/stdlib/weakref.pyi
-mypy/typeshed/stdlib/webbrowser.pyi
-mypy/typeshed/stdlib/winreg.pyi
-mypy/typeshed/stdlib/winsound.pyi
-mypy/typeshed/stdlib/xdrlib.pyi
-mypy/typeshed/stdlib/xxlimited.pyi
-mypy/typeshed/stdlib/zipapp.pyi
-mypy/typeshed/stdlib/zipimport.pyi
-mypy/typeshed/stdlib/zlib.pyi
-mypy/typeshed/stdlib/_typeshed/__init__.pyi
-mypy/typeshed/stdlib/_typeshed/dbapi.pyi
-mypy/typeshed/stdlib/_typeshed/importlib.pyi
-mypy/typeshed/stdlib/_typeshed/wsgi.pyi
-mypy/typeshed/stdlib/_typeshed/xml.pyi
-mypy/typeshed/stdlib/asyncio/__init__.pyi
-mypy/typeshed/stdlib/asyncio/base_events.pyi
-mypy/typeshed/stdlib/asyncio/base_futures.pyi
-mypy/typeshed/stdlib/asyncio/base_subprocess.pyi
-mypy/typeshed/stdlib/asyncio/base_tasks.pyi
-mypy/typeshed/stdlib/asyncio/constants.pyi
-mypy/typeshed/stdlib/asyncio/coroutines.pyi
-mypy/typeshed/stdlib/asyncio/events.pyi
-mypy/typeshed/stdlib/asyncio/exceptions.pyi
-mypy/typeshed/stdlib/asyncio/format_helpers.pyi
-mypy/typeshed/stdlib/asyncio/futures.pyi
-mypy/typeshed/stdlib/asyncio/locks.pyi
-mypy/typeshed/stdlib/asyncio/log.pyi
-mypy/typeshed/stdlib/asyncio/mixins.pyi
-mypy/typeshed/stdlib/asyncio/proactor_events.pyi
-mypy/typeshed/stdlib/asyncio/protocols.pyi
-mypy/typeshed/stdlib/asyncio/queues.pyi
-mypy/typeshed/stdlib/asyncio/runners.pyi
-mypy/typeshed/stdlib/asyncio/selector_events.pyi
-mypy/typeshed/stdlib/asyncio/sslproto.pyi
-mypy/typeshed/stdlib/asyncio/staggered.pyi
-mypy/typeshed/stdlib/asyncio/streams.pyi
-mypy/typeshed/stdlib/asyncio/subprocess.pyi
-mypy/typeshed/stdlib/asyncio/taskgroups.pyi
-mypy/typeshed/stdlib/asyncio/tasks.pyi
-mypy/typeshed/stdlib/asyncio/threads.pyi
-mypy/typeshed/stdlib/asyncio/timeouts.pyi
-mypy/typeshed/stdlib/asyncio/transports.pyi
-mypy/typeshed/stdlib/asyncio/trsock.pyi
-mypy/typeshed/stdlib/asyncio/unix_events.pyi
-mypy/typeshed/stdlib/asyncio/windows_events.pyi
-mypy/typeshed/stdlib/asyncio/windows_utils.pyi
-mypy/typeshed/stdlib/collections/__init__.pyi
-mypy/typeshed/stdlib/collections/abc.pyi
-mypy/typeshed/stdlib/concurrent/__init__.pyi
-mypy/typeshed/stdlib/concurrent/futures/__init__.pyi
-mypy/typeshed/stdlib/concurrent/futures/_base.pyi
-mypy/typeshed/stdlib/concurrent/futures/process.pyi
-mypy/typeshed/stdlib/concurrent/futures/thread.pyi
-mypy/typeshed/stdlib/ctypes/__init__.pyi
-mypy/typeshed/stdlib/ctypes/_endian.pyi
-mypy/typeshed/stdlib/ctypes/util.pyi
-mypy/typeshed/stdlib/ctypes/wintypes.pyi
-mypy/typeshed/stdlib/ctypes/macholib/__init__.pyi
-mypy/typeshed/stdlib/ctypes/macholib/dyld.pyi
-mypy/typeshed/stdlib/ctypes/macholib/dylib.pyi
-mypy/typeshed/stdlib/ctypes/macholib/framework.pyi
-mypy/typeshed/stdlib/curses/__init__.pyi
-mypy/typeshed/stdlib/curses/ascii.pyi
-mypy/typeshed/stdlib/curses/has_key.pyi
-mypy/typeshed/stdlib/curses/panel.pyi
-mypy/typeshed/stdlib/curses/textpad.pyi
-mypy/typeshed/stdlib/dbm/__init__.pyi
-mypy/typeshed/stdlib/dbm/dumb.pyi
-mypy/typeshed/stdlib/dbm/gnu.pyi
-mypy/typeshed/stdlib/dbm/ndbm.pyi
-mypy/typeshed/stdlib/dbm/sqlite3.pyi
-mypy/typeshed/stdlib/distutils/__init__.pyi
-mypy/typeshed/stdlib/distutils/_msvccompiler.pyi
-mypy/typeshed/stdlib/distutils/archive_util.pyi
-mypy/typeshed/stdlib/distutils/bcppcompiler.pyi
-mypy/typeshed/stdlib/distutils/ccompiler.pyi
-mypy/typeshed/stdlib/distutils/cmd.pyi
-mypy/typeshed/stdlib/distutils/config.pyi
-mypy/typeshed/stdlib/distutils/core.pyi
-mypy/typeshed/stdlib/distutils/cygwinccompiler.pyi
-mypy/typeshed/stdlib/distutils/debug.pyi
-mypy/typeshed/stdlib/distutils/dep_util.pyi
-mypy/typeshed/stdlib/distutils/dir_util.pyi
-mypy/typeshed/stdlib/distutils/dist.pyi
-mypy/typeshed/stdlib/distutils/errors.pyi
-mypy/typeshed/stdlib/distutils/extension.pyi
-mypy/typeshed/stdlib/distutils/fancy_getopt.pyi
-mypy/typeshed/stdlib/distutils/file_util.pyi
-mypy/typeshed/stdlib/distutils/filelist.pyi
-mypy/typeshed/stdlib/distutils/log.pyi
-mypy/typeshed/stdlib/distutils/msvccompiler.pyi
-mypy/typeshed/stdlib/distutils/spawn.pyi
-mypy/typeshed/stdlib/distutils/sysconfig.pyi
-mypy/typeshed/stdlib/distutils/text_file.pyi
-mypy/typeshed/stdlib/distutils/unixccompiler.pyi
-mypy/typeshed/stdlib/distutils/util.pyi
-mypy/typeshed/stdlib/distutils/version.pyi
-mypy/typeshed/stdlib/distutils/command/__init__.pyi
-mypy/typeshed/stdlib/distutils/command/bdist.pyi
-mypy/typeshed/stdlib/distutils/command/bdist_dumb.pyi
-mypy/typeshed/stdlib/distutils/command/bdist_msi.pyi
-mypy/typeshed/stdlib/distutils/command/bdist_packager.pyi
-mypy/typeshed/stdlib/distutils/command/bdist_rpm.pyi
-mypy/typeshed/stdlib/distutils/command/bdist_wininst.pyi
-mypy/typeshed/stdlib/distutils/command/build.pyi
-mypy/typeshed/stdlib/distutils/command/build_clib.pyi
-mypy/typeshed/stdlib/distutils/command/build_ext.pyi
-mypy/typeshed/stdlib/distutils/command/build_py.pyi
-mypy/typeshed/stdlib/distutils/command/build_scripts.pyi
-mypy/typeshed/stdlib/distutils/command/check.pyi
-mypy/typeshed/stdlib/distutils/command/clean.pyi
-mypy/typeshed/stdlib/distutils/command/config.pyi
-mypy/typeshed/stdlib/distutils/command/install.pyi
-mypy/typeshed/stdlib/distutils/command/install_data.pyi
-mypy/typeshed/stdlib/distutils/command/install_egg_info.pyi
-mypy/typeshed/stdlib/distutils/command/install_headers.pyi
-mypy/typeshed/stdlib/distutils/command/install_lib.pyi
-mypy/typeshed/stdlib/distutils/command/install_scripts.pyi
-mypy/typeshed/stdlib/distutils/command/register.pyi
-mypy/typeshed/stdlib/distutils/command/sdist.pyi
-mypy/typeshed/stdlib/distutils/command/upload.pyi
-mypy/typeshed/stdlib/email/__init__.pyi
-mypy/typeshed/stdlib/email/_header_value_parser.pyi
-mypy/typeshed/stdlib/email/_policybase.pyi
-mypy/typeshed/stdlib/email/base64mime.pyi
-mypy/typeshed/stdlib/email/charset.pyi
-mypy/typeshed/stdlib/email/contentmanager.pyi
-mypy/typeshed/stdlib/email/encoders.pyi
-mypy/typeshed/stdlib/email/errors.pyi
-mypy/typeshed/stdlib/email/feedparser.pyi
-mypy/typeshed/stdlib/email/generator.pyi
-mypy/typeshed/stdlib/email/header.pyi
-mypy/typeshed/stdlib/email/headerregistry.pyi
-mypy/typeshed/stdlib/email/iterators.pyi
-mypy/typeshed/stdlib/email/message.pyi
-mypy/typeshed/stdlib/email/parser.pyi
-mypy/typeshed/stdlib/email/policy.pyi
-mypy/typeshed/stdlib/email/quoprimime.pyi
-mypy/typeshed/stdlib/email/utils.pyi
-mypy/typeshed/stdlib/email/mime/__init__.pyi
-mypy/typeshed/stdlib/email/mime/application.pyi
-mypy/typeshed/stdlib/email/mime/audio.pyi
-mypy/typeshed/stdlib/email/mime/base.pyi
-mypy/typeshed/stdlib/email/mime/image.pyi
-mypy/typeshed/stdlib/email/mime/message.pyi
-mypy/typeshed/stdlib/email/mime/multipart.pyi
-mypy/typeshed/stdlib/email/mime/nonmultipart.pyi
-mypy/typeshed/stdlib/email/mime/text.pyi
-mypy/typeshed/stdlib/encodings/__init__.pyi
-mypy/typeshed/stdlib/encodings/aliases.pyi
-mypy/typeshed/stdlib/encodings/ascii.pyi
-mypy/typeshed/stdlib/encodings/base64_codec.pyi
-mypy/typeshed/stdlib/encodings/big5.pyi
-mypy/typeshed/stdlib/encodings/big5hkscs.pyi
-mypy/typeshed/stdlib/encodings/bz2_codec.pyi
-mypy/typeshed/stdlib/encodings/charmap.pyi
-mypy/typeshed/stdlib/encodings/cp037.pyi
-mypy/typeshed/stdlib/encodings/cp1006.pyi
-mypy/typeshed/stdlib/encodings/cp1026.pyi
-mypy/typeshed/stdlib/encodings/cp1125.pyi
-mypy/typeshed/stdlib/encodings/cp1140.pyi
-mypy/typeshed/stdlib/encodings/cp1250.pyi
-mypy/typeshed/stdlib/encodings/cp1251.pyi
-mypy/typeshed/stdlib/encodings/cp1252.pyi
-mypy/typeshed/stdlib/encodings/cp1253.pyi
-mypy/typeshed/stdlib/encodings/cp1254.pyi
-mypy/typeshed/stdlib/encodings/cp1255.pyi
-mypy/typeshed/stdlib/encodings/cp1256.pyi
-mypy/typeshed/stdlib/encodings/cp1257.pyi
-mypy/typeshed/stdlib/encodings/cp1258.pyi
-mypy/typeshed/stdlib/encodings/cp273.pyi
-mypy/typeshed/stdlib/encodings/cp424.pyi
-mypy/typeshed/stdlib/encodings/cp437.pyi
-mypy/typeshed/stdlib/encodings/cp500.pyi
-mypy/typeshed/stdlib/encodings/cp720.pyi
-mypy/typeshed/stdlib/encodings/cp737.pyi
-mypy/typeshed/stdlib/encodings/cp775.pyi
-mypy/typeshed/stdlib/encodings/cp850.pyi
-mypy/typeshed/stdlib/encodings/cp852.pyi
-mypy/typeshed/stdlib/encodings/cp855.pyi
-mypy/typeshed/stdlib/encodings/cp856.pyi
-mypy/typeshed/stdlib/encodings/cp857.pyi
-mypy/typeshed/stdlib/encodings/cp858.pyi
-mypy/typeshed/stdlib/encodings/cp860.pyi
-mypy/typeshed/stdlib/encodings/cp861.pyi
-mypy/typeshed/stdlib/encodings/cp862.pyi
-mypy/typeshed/stdlib/encodings/cp863.pyi
-mypy/typeshed/stdlib/encodings/cp864.pyi
-mypy/typeshed/stdlib/encodings/cp865.pyi
-mypy/typeshed/stdlib/encodings/cp866.pyi
-mypy/typeshed/stdlib/encodings/cp869.pyi
-mypy/typeshed/stdlib/encodings/cp874.pyi
-mypy/typeshed/stdlib/encodings/cp875.pyi
-mypy/typeshed/stdlib/encodings/cp932.pyi
-mypy/typeshed/stdlib/encodings/cp949.pyi
-mypy/typeshed/stdlib/encodings/cp950.pyi
-mypy/typeshed/stdlib/encodings/euc_jis_2004.pyi
-mypy/typeshed/stdlib/encodings/euc_jisx0213.pyi
-mypy/typeshed/stdlib/encodings/euc_jp.pyi
-mypy/typeshed/stdlib/encodings/euc_kr.pyi
-mypy/typeshed/stdlib/encodings/gb18030.pyi
-mypy/typeshed/stdlib/encodings/gb2312.pyi
-mypy/typeshed/stdlib/encodings/gbk.pyi
-mypy/typeshed/stdlib/encodings/hex_codec.pyi
-mypy/typeshed/stdlib/encodings/hp_roman8.pyi
-mypy/typeshed/stdlib/encodings/hz.pyi
-mypy/typeshed/stdlib/encodings/idna.pyi
-mypy/typeshed/stdlib/encodings/iso2022_jp.pyi
-mypy/typeshed/stdlib/encodings/iso2022_jp_1.pyi
-mypy/typeshed/stdlib/encodings/iso2022_jp_2.pyi
-mypy/typeshed/stdlib/encodings/iso2022_jp_2004.pyi
-mypy/typeshed/stdlib/encodings/iso2022_jp_3.pyi
-mypy/typeshed/stdlib/encodings/iso2022_jp_ext.pyi
-mypy/typeshed/stdlib/encodings/iso2022_kr.pyi
-mypy/typeshed/stdlib/encodings/iso8859_1.pyi
-mypy/typeshed/stdlib/encodings/iso8859_10.pyi
-mypy/typeshed/stdlib/encodings/iso8859_11.pyi
-mypy/typeshed/stdlib/encodings/iso8859_13.pyi
-mypy/typeshed/stdlib/encodings/iso8859_14.pyi
-mypy/typeshed/stdlib/encodings/iso8859_15.pyi
-mypy/typeshed/stdlib/encodings/iso8859_16.pyi
-mypy/typeshed/stdlib/encodings/iso8859_2.pyi
-mypy/typeshed/stdlib/encodings/iso8859_3.pyi
-mypy/typeshed/stdlib/encodings/iso8859_4.pyi
-mypy/typeshed/stdlib/encodings/iso8859_5.pyi
-mypy/typeshed/stdlib/encodings/iso8859_6.pyi
-mypy/typeshed/stdlib/encodings/iso8859_7.pyi
-mypy/typeshed/stdlib/encodings/iso8859_8.pyi
-mypy/typeshed/stdlib/encodings/iso8859_9.pyi
-mypy/typeshed/stdlib/encodings/johab.pyi
-mypy/typeshed/stdlib/encodings/koi8_r.pyi
-mypy/typeshed/stdlib/encodings/koi8_t.pyi
-mypy/typeshed/stdlib/encodings/koi8_u.pyi
-mypy/typeshed/stdlib/encodings/kz1048.pyi
-mypy/typeshed/stdlib/encodings/latin_1.pyi
-mypy/typeshed/stdlib/encodings/mac_arabic.pyi
-mypy/typeshed/stdlib/encodings/mac_centeuro.pyi
-mypy/typeshed/stdlib/encodings/mac_croatian.pyi
-mypy/typeshed/stdlib/encodings/mac_cyrillic.pyi
-mypy/typeshed/stdlib/encodings/mac_farsi.pyi
-mypy/typeshed/stdlib/encodings/mac_greek.pyi
-mypy/typeshed/stdlib/encodings/mac_iceland.pyi
-mypy/typeshed/stdlib/encodings/mac_latin2.pyi
-mypy/typeshed/stdlib/encodings/mac_roman.pyi
-mypy/typeshed/stdlib/encodings/mac_romanian.pyi
-mypy/typeshed/stdlib/encodings/mac_turkish.pyi
-mypy/typeshed/stdlib/encodings/mbcs.pyi
-mypy/typeshed/stdlib/encodings/oem.pyi
-mypy/typeshed/stdlib/encodings/palmos.pyi
-mypy/typeshed/stdlib/encodings/ptcp154.pyi
-mypy/typeshed/stdlib/encodings/punycode.pyi
-mypy/typeshed/stdlib/encodings/quopri_codec.pyi
-mypy/typeshed/stdlib/encodings/raw_unicode_escape.pyi
-mypy/typeshed/stdlib/encodings/rot_13.pyi
-mypy/typeshed/stdlib/encodings/shift_jis.pyi
-mypy/typeshed/stdlib/encodings/shift_jis_2004.pyi
-mypy/typeshed/stdlib/encodings/shift_jisx0213.pyi
-mypy/typeshed/stdlib/encodings/tis_620.pyi
-mypy/typeshed/stdlib/encodings/undefined.pyi
-mypy/typeshed/stdlib/encodings/unicode_escape.pyi
-mypy/typeshed/stdlib/encodings/utf_16.pyi
-mypy/typeshed/stdlib/encodings/utf_16_be.pyi
-mypy/typeshed/stdlib/encodings/utf_16_le.pyi
-mypy/typeshed/stdlib/encodings/utf_32.pyi
-mypy/typeshed/stdlib/encodings/utf_32_be.pyi
-mypy/typeshed/stdlib/encodings/utf_32_le.pyi
-mypy/typeshed/stdlib/encodings/utf_7.pyi
-mypy/typeshed/stdlib/encodings/utf_8.pyi
-mypy/typeshed/stdlib/encodings/utf_8_sig.pyi
-mypy/typeshed/stdlib/encodings/uu_codec.pyi
-mypy/typeshed/stdlib/encodings/zlib_codec.pyi
-mypy/typeshed/stdlib/ensurepip/__init__.pyi
-mypy/typeshed/stdlib/html/__init__.pyi
-mypy/typeshed/stdlib/html/entities.pyi
-mypy/typeshed/stdlib/html/parser.pyi
-mypy/typeshed/stdlib/http/__init__.pyi
-mypy/typeshed/stdlib/http/client.pyi
-mypy/typeshed/stdlib/http/cookiejar.pyi
-mypy/typeshed/stdlib/http/cookies.pyi
-mypy/typeshed/stdlib/http/server.pyi
-mypy/typeshed/stdlib/importlib/__init__.pyi
-mypy/typeshed/stdlib/importlib/_abc.pyi
-mypy/typeshed/stdlib/importlib/_bootstrap.pyi
-mypy/typeshed/stdlib/importlib/_bootstrap_external.pyi
-mypy/typeshed/stdlib/importlib/abc.pyi
-mypy/typeshed/stdlib/importlib/machinery.pyi
-mypy/typeshed/stdlib/importlib/readers.pyi
-mypy/typeshed/stdlib/importlib/simple.pyi
-mypy/typeshed/stdlib/importlib/util.pyi
-mypy/typeshed/stdlib/importlib/metadata/__init__.pyi
-mypy/typeshed/stdlib/importlib/metadata/_meta.pyi
-mypy/typeshed/stdlib/importlib/metadata/diagnose.pyi
-mypy/typeshed/stdlib/importlib/resources/__init__.pyi
-mypy/typeshed/stdlib/importlib/resources/_common.pyi
-mypy/typeshed/stdlib/importlib/resources/_functional.pyi
-mypy/typeshed/stdlib/importlib/resources/abc.pyi
-mypy/typeshed/stdlib/importlib/resources/readers.pyi
-mypy/typeshed/stdlib/importlib/resources/simple.pyi
-mypy/typeshed/stdlib/json/__init__.pyi
-mypy/typeshed/stdlib/json/decoder.pyi
-mypy/typeshed/stdlib/json/encoder.pyi
-mypy/typeshed/stdlib/json/scanner.pyi
-mypy/typeshed/stdlib/json/tool.pyi
-mypy/typeshed/stdlib/lib2to3/__init__.pyi
-mypy/typeshed/stdlib/lib2to3/btm_matcher.pyi
-mypy/typeshed/stdlib/lib2to3/fixer_base.pyi
-mypy/typeshed/stdlib/lib2to3/main.pyi
-mypy/typeshed/stdlib/lib2to3/pygram.pyi
-mypy/typeshed/stdlib/lib2to3/pytree.pyi
-mypy/typeshed/stdlib/lib2to3/refactor.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/__init__.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_apply.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_asserts.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_basestring.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_buffer.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_dict.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_except.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_exec.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_execfile.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_exitfunc.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_filter.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_funcattrs.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_future.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_getcwdu.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_has_key.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_idioms.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_import.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_imports.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_imports2.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_input.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_intern.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_isinstance.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_itertools.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_itertools_imports.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_long.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_map.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_metaclass.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_methodattrs.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_ne.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_next.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_nonzero.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_numliterals.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_operator.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_paren.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_print.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_raise.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_raw_input.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_reduce.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_reload.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_renames.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_repr.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_set_literal.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_standarderror.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_sys_exc.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_throw.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_tuple_params.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_types.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_unicode.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_urllib.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_ws_comma.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_xrange.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_xreadlines.pyi
-mypy/typeshed/stdlib/lib2to3/fixes/fix_zip.pyi
-mypy/typeshed/stdlib/lib2to3/pgen2/__init__.pyi
-mypy/typeshed/stdlib/lib2to3/pgen2/driver.pyi
-mypy/typeshed/stdlib/lib2to3/pgen2/grammar.pyi
-mypy/typeshed/stdlib/lib2to3/pgen2/literals.pyi
-mypy/typeshed/stdlib/lib2to3/pgen2/parse.pyi
-mypy/typeshed/stdlib/lib2to3/pgen2/pgen.pyi
-mypy/typeshed/stdlib/lib2to3/pgen2/token.pyi
-mypy/typeshed/stdlib/lib2to3/pgen2/tokenize.pyi
-mypy/typeshed/stdlib/logging/__init__.pyi
-mypy/typeshed/stdlib/logging/config.pyi
-mypy/typeshed/stdlib/logging/handlers.pyi
-mypy/typeshed/stdlib/msilib/__init__.pyi
-mypy/typeshed/stdlib/msilib/schema.pyi
-mypy/typeshed/stdlib/msilib/sequence.pyi
-mypy/typeshed/stdlib/msilib/text.pyi
-mypy/typeshed/stdlib/multiprocessing/__init__.pyi
-mypy/typeshed/stdlib/multiprocessing/connection.pyi
-mypy/typeshed/stdlib/multiprocessing/context.pyi
-mypy/typeshed/stdlib/multiprocessing/forkserver.pyi
-mypy/typeshed/stdlib/multiprocessing/heap.pyi
-mypy/typeshed/stdlib/multiprocessing/managers.pyi
-mypy/typeshed/stdlib/multiprocessing/pool.pyi
-mypy/typeshed/stdlib/multiprocessing/popen_fork.pyi
-mypy/typeshed/stdlib/multiprocessing/popen_forkserver.pyi
-mypy/typeshed/stdlib/multiprocessing/popen_spawn_posix.pyi
-mypy/typeshed/stdlib/multiprocessing/popen_spawn_win32.pyi
-mypy/typeshed/stdlib/multiprocessing/process.pyi
-mypy/typeshed/stdlib/multiprocessing/queues.pyi
-mypy/typeshed/stdlib/multiprocessing/reduction.pyi
-mypy/typeshed/stdlib/multiprocessing/resource_sharer.pyi
-mypy/typeshed/stdlib/multiprocessing/resource_tracker.pyi
-mypy/typeshed/stdlib/multiprocessing/shared_memory.pyi
-mypy/typeshed/stdlib/multiprocessing/sharedctypes.pyi
-mypy/typeshed/stdlib/multiprocessing/spawn.pyi
-mypy/typeshed/stdlib/multiprocessing/synchronize.pyi
-mypy/typeshed/stdlib/multiprocessing/util.pyi
-mypy/typeshed/stdlib/multiprocessing/dummy/__init__.pyi
-mypy/typeshed/stdlib/multiprocessing/dummy/connection.pyi
-mypy/typeshed/stdlib/os/__init__.pyi
-mypy/typeshed/stdlib/os/path.pyi
-mypy/typeshed/stdlib/pydoc_data/__init__.pyi
-mypy/typeshed/stdlib/pydoc_data/topics.pyi
-mypy/typeshed/stdlib/pyexpat/__init__.pyi
-mypy/typeshed/stdlib/pyexpat/errors.pyi
-mypy/typeshed/stdlib/pyexpat/model.pyi
-mypy/typeshed/stdlib/sqlite3/__init__.pyi
-mypy/typeshed/stdlib/sqlite3/dbapi2.pyi
-mypy/typeshed/stdlib/sqlite3/dump.pyi
-mypy/typeshed/stdlib/sys/__init__.pyi
-mypy/typeshed/stdlib/sys/_monitoring.pyi
-mypy/typeshed/stdlib/tkinter/__init__.pyi
-mypy/typeshed/stdlib/tkinter/colorchooser.pyi
-mypy/typeshed/stdlib/tkinter/commondialog.pyi
-mypy/typeshed/stdlib/tkinter/constants.pyi
-mypy/typeshed/stdlib/tkinter/dialog.pyi
-mypy/typeshed/stdlib/tkinter/dnd.pyi
-mypy/typeshed/stdlib/tkinter/filedialog.pyi
-mypy/typeshed/stdlib/tkinter/font.pyi
-mypy/typeshed/stdlib/tkinter/messagebox.pyi
-mypy/typeshed/stdlib/tkinter/scrolledtext.pyi
-mypy/typeshed/stdlib/tkinter/simpledialog.pyi
-mypy/typeshed/stdlib/tkinter/tix.pyi
-mypy/typeshed/stdlib/tkinter/ttk.pyi
-mypy/typeshed/stdlib/unittest/__init__.pyi
-mypy/typeshed/stdlib/unittest/_log.pyi
-mypy/typeshed/stdlib/unittest/async_case.pyi
-mypy/typeshed/stdlib/unittest/case.pyi
-mypy/typeshed/stdlib/unittest/loader.pyi
-mypy/typeshed/stdlib/unittest/main.pyi
-mypy/typeshed/stdlib/unittest/mock.pyi
-mypy/typeshed/stdlib/unittest/result.pyi
-mypy/typeshed/stdlib/unittest/runner.pyi
-mypy/typeshed/stdlib/unittest/signals.pyi
-mypy/typeshed/stdlib/unittest/suite.pyi
-mypy/typeshed/stdlib/unittest/util.pyi
-mypy/typeshed/stdlib/urllib/__init__.pyi
-mypy/typeshed/stdlib/urllib/error.pyi
-mypy/typeshed/stdlib/urllib/parse.pyi
-mypy/typeshed/stdlib/urllib/request.pyi
-mypy/typeshed/stdlib/urllib/response.pyi
-mypy/typeshed/stdlib/urllib/robotparser.pyi
-mypy/typeshed/stdlib/venv/__init__.pyi
-mypy/typeshed/stdlib/wsgiref/__init__.pyi
-mypy/typeshed/stdlib/wsgiref/handlers.pyi
-mypy/typeshed/stdlib/wsgiref/headers.pyi
-mypy/typeshed/stdlib/wsgiref/simple_server.pyi
-mypy/typeshed/stdlib/wsgiref/types.pyi
-mypy/typeshed/stdlib/wsgiref/util.pyi
-mypy/typeshed/stdlib/wsgiref/validate.pyi
-mypy/typeshed/stdlib/xml/__init__.pyi
-mypy/typeshed/stdlib/xml/dom/NodeFilter.pyi
-mypy/typeshed/stdlib/xml/dom/__init__.pyi
-mypy/typeshed/stdlib/xml/dom/domreg.pyi
-mypy/typeshed/stdlib/xml/dom/expatbuilder.pyi
-mypy/typeshed/stdlib/xml/dom/minicompat.pyi
-mypy/typeshed/stdlib/xml/dom/minidom.pyi
-mypy/typeshed/stdlib/xml/dom/pulldom.pyi
-mypy/typeshed/stdlib/xml/dom/xmlbuilder.pyi
-mypy/typeshed/stdlib/xml/etree/ElementInclude.pyi
-mypy/typeshed/stdlib/xml/etree/ElementPath.pyi
-mypy/typeshed/stdlib/xml/etree/ElementTree.pyi
-mypy/typeshed/stdlib/xml/etree/__init__.pyi
-mypy/typeshed/stdlib/xml/etree/cElementTree.pyi
-mypy/typeshed/stdlib/xml/parsers/__init__.pyi
-mypy/typeshed/stdlib/xml/parsers/expat/__init__.pyi
-mypy/typeshed/stdlib/xml/parsers/expat/errors.pyi
-mypy/typeshed/stdlib/xml/parsers/expat/model.pyi
-mypy/typeshed/stdlib/xml/sax/__init__.pyi
-mypy/typeshed/stdlib/xml/sax/_exceptions.pyi
-mypy/typeshed/stdlib/xml/sax/expatreader.pyi
-mypy/typeshed/stdlib/xml/sax/handler.pyi
-mypy/typeshed/stdlib/xml/sax/saxutils.pyi
-mypy/typeshed/stdlib/xml/sax/xmlreader.pyi
-mypy/typeshed/stdlib/xmlrpc/__init__.pyi
-mypy/typeshed/stdlib/xmlrpc/client.pyi
-mypy/typeshed/stdlib/xmlrpc/server.pyi
-mypy/typeshed/stdlib/zipfile/__init__.pyi
-mypy/typeshed/stdlib/zipfile/_path/__init__.pyi
-mypy/typeshed/stdlib/zipfile/_path/glob.pyi
-mypy/typeshed/stdlib/zoneinfo/__init__.pyi
-mypy/typeshed/stdlib/zoneinfo/_common.pyi
-mypy/typeshed/stdlib/zoneinfo/_tzpath.pyi
-mypy/typeshed/stubs/mypy-extensions/mypy_extensions.pyi
-mypy/xml/mypy-html.css
-mypy/xml/mypy-html.xslt
-mypy/xml/mypy-txt.xslt
-mypy/xml/mypy.xsd
-mypyc/README.md
-mypyc/__init__.py
-mypyc/__main__.py
-mypyc/build.py
-mypyc/common.py
-mypyc/crash.py
-mypyc/errors.py
-mypyc/namegen.py
-mypyc/options.py
-mypyc/py.typed
-mypyc/rt_subtype.py
-mypyc/sametype.py
-mypyc/subtype.py
-mypyc/analysis/__init__.py
-mypyc/analysis/attrdefined.py
-mypyc/analysis/blockfreq.py
-mypyc/analysis/dataflow.py
-mypyc/analysis/ircheck.py
-mypyc/analysis/selfleaks.py
-mypyc/codegen/__init__.py
-mypyc/codegen/cstring.py
-mypyc/codegen/emit.py
-mypyc/codegen/emitclass.py
-mypyc/codegen/emitfunc.py
-mypyc/codegen/emitmodule.py
-mypyc/codegen/emitwrapper.py
-mypyc/codegen/literals.py
-mypyc/doc/Makefile
-mypyc/doc/bool_operations.rst
-mypyc/doc/bytes_operations.rst
-mypyc/doc/compilation_units.rst
-mypyc/doc/conf.py
-mypyc/doc/cpython-timings.md
-mypyc/doc/dev-intro.md
-mypyc/doc/dict_operations.rst
-mypyc/doc/differences_from_python.rst
-mypyc/doc/float_operations.rst
-mypyc/doc/future.md
-mypyc/doc/getting_started.rst
-mypyc/doc/index.rst
-mypyc/doc/int_operations.rst
-mypyc/doc/introduction.rst
-mypyc/doc/list_operations.rst
-mypyc/doc/make.bat
-mypyc/doc/native_classes.rst
-mypyc/doc/native_operations.rst
-mypyc/doc/performance_tips_and_tricks.rst
-mypyc/doc/set_operations.rst
-mypyc/doc/str_operations.rst
-mypyc/doc/tuple_operations.rst
-mypyc/doc/using_type_annotations.rst
-mypyc/external/googletest/LICENSE
-mypyc/external/googletest/README.md
-mypyc/external/googletest/include/gtest/gtest-death-test.h
-mypyc/external/googletest/include/gtest/gtest-message.h
-mypyc/external/googletest/include/gtest/gtest-param-test.h
-mypyc/external/googletest/include/gtest/gtest-param-test.h.pump
-mypyc/external/googletest/include/gtest/gtest-printers.h
-mypyc/external/googletest/include/gtest/gtest-spi.h
-mypyc/external/googletest/include/gtest/gtest-test-part.h
-mypyc/external/googletest/include/gtest/gtest-typed-test.h
-mypyc/external/googletest/include/gtest/gtest.h
-mypyc/external/googletest/include/gtest/gtest_pred_impl.h
-mypyc/external/googletest/include/gtest/gtest_prod.h
-mypyc/external/googletest/include/gtest/internal/gtest-death-test-internal.h
-mypyc/external/googletest/include/gtest/internal/gtest-filepath.h
-mypyc/external/googletest/include/gtest/internal/gtest-internal.h
-mypyc/external/googletest/include/gtest/internal/gtest-linked_ptr.h
-mypyc/external/googletest/include/gtest/internal/gtest-param-util-generated.h
-mypyc/external/googletest/include/gtest/internal/gtest-param-util-generated.h.pump
-mypyc/external/googletest/include/gtest/internal/gtest-param-util.h
-mypyc/external/googletest/include/gtest/internal/gtest-port-arch.h
-mypyc/external/googletest/include/gtest/internal/gtest-port.h
-mypyc/external/googletest/include/gtest/internal/gtest-string.h
-mypyc/external/googletest/include/gtest/internal/gtest-tuple.h
-mypyc/external/googletest/include/gtest/internal/gtest-tuple.h.pump
-mypyc/external/googletest/include/gtest/internal/gtest-type-util.h
-mypyc/external/googletest/include/gtest/internal/gtest-type-util.h.pump
-mypyc/external/googletest/include/gtest/internal/custom/gtest-port.h
-mypyc/external/googletest/include/gtest/internal/custom/gtest-printers.h
-mypyc/external/googletest/include/gtest/internal/custom/gtest.h
-mypyc/external/googletest/make/Makefile
-mypyc/external/googletest/src/gtest-all.cc
-mypyc/external/googletest/src/gtest-death-test.cc
-mypyc/external/googletest/src/gtest-filepath.cc
-mypyc/external/googletest/src/gtest-internal-inl.h
-mypyc/external/googletest/src/gtest-port.cc
-mypyc/external/googletest/src/gtest-printers.cc
-mypyc/external/googletest/src/gtest-test-part.cc
-mypyc/external/googletest/src/gtest-typed-test.cc
-mypyc/external/googletest/src/gtest.cc
-mypyc/external/googletest/src/gtest_main.cc
-mypyc/ir/__init__.py
-mypyc/ir/class_ir.py
-mypyc/ir/func_ir.py
-mypyc/ir/module_ir.py
-mypyc/ir/ops.py
-mypyc/ir/pprint.py
-mypyc/ir/rtypes.py
-mypyc/irbuild/__init__.py
-mypyc/irbuild/ast_helpers.py
-mypyc/irbuild/builder.py
-mypyc/irbuild/callable_class.py
-mypyc/irbuild/classdef.py
-mypyc/irbuil