diff -pruN 1.4.1-1/.copier-answers.yml 1.4.2-1/.copier-answers.yml
--- 1.4.1-1/.copier-answers.yml	2025-03-08 13:34:43.000000000 +0000
+++ 1.4.2-1/.copier-answers.yml	2025-05-20 13:07:56.000000000 +0000
@@ -1,5 +1,5 @@
 # Changes here will be overwritten by Copier.
-_commit: 1.7.1
+_commit: 1.8.4
 _src_path: gh:pawamoy/copier-uv
 author_email: dev@pawamoy.fr
 author_fullname: Timothée Mazzucotelli
diff -pruN 1.4.1-1/CHANGELOG.md 1.4.2-1/CHANGELOG.md
--- 1.4.1-1/CHANGELOG.md	2025-03-08 13:34:43.000000000 +0000
+++ 1.4.2-1/CHANGELOG.md	2025-05-20 13:07:56.000000000 +0000
@@ -5,6 +5,14 @@ The format is based on [Keep a Changelog
 and this project adheres to [Semantic Versioning](http://semver.org/spec/v2.0.0.html).
 
 <!-- insertion marker -->
+## [1.4.2](https://github.com/mkdocstrings/autorefs/releases/tag/1.4.2) - 2025-05-20
+
+<small>[Compare with 1.4.1](https://github.com/mkdocstrings/autorefs/compare/1.4.1...1.4.2)</small>
+
+### Build
+
+- Exclude mypy cache from dists ([5e77f7f](https://github.com/mkdocstrings/autorefs/commit/5e77f7fdbd79d4aca6473e9224270752ed9b9165) by Timothée Mazzucotelli). [Issue-71](https://github.com/mkdocstrings/autorefs/issues/71)
+
 ## [1.4.1](https://github.com/mkdocstrings/autorefs/releases/tag/1.4.1) - 2025-03-08
 
 <small>[Compare with 1.4.0](https://github.com/mkdocstrings/autorefs/compare/1.4.0...1.4.1)</small>
diff -pruN 1.4.1-1/debian/changelog 1.4.2-1/debian/changelog
--- 1.4.1-1/debian/changelog	2025-03-23 05:35:59.000000000 +0000
+++ 1.4.2-1/debian/changelog	2025-05-25 07:39:04.000000000 +0000
@@ -1,3 +1,9 @@
+mkdocs-autorefs (1.4.2-1) unstable; urgency=medium
+
+  * [be0b61d] New upstream version 1.4.2
+
+ -- Carsten Schoenert <c.schoenert@t-online.de>  Sun, 25 May 2025 09:39:04 +0200
+
 mkdocs-autorefs (1.4.1-1) unstable; urgency=medium
 
   * [04b1c64] New upstream version 1.4.1
diff -pruN 1.4.1-1/docs/css/mkdocstrings.css 1.4.2-1/docs/css/mkdocstrings.css
--- 1.4.1-1/docs/css/mkdocstrings.css	2025-03-08 13:34:43.000000000 +0000
+++ 1.4.2-1/docs/css/mkdocstrings.css	2025-05-20 13:07:56.000000000 +0000
@@ -24,4 +24,49 @@ a.autorefs-external::after {
 a.external:hover::after,
 a.autorefs-external:hover::after {
   background-color: var(--md-accent-fg-color);
-}
\ No newline at end of file
+}
+
+/* Tree-like output for backlinks. */
+.doc-backlink-list {
+  --tree-clr: var(--md-default-fg-color);
+  --tree-font-size: 1rem;
+  --tree-item-height: 1;
+  --tree-offset: 1rem;
+  --tree-thickness: 1px;
+  --tree-style: solid;
+  display: grid;
+  list-style: none !important;
+}
+
+.doc-backlink-list li > span:first-child {
+  text-indent: .3rem;
+}
+.doc-backlink-list li {
+  padding-inline-start: var(--tree-offset);
+  border-left: var(--tree-thickness) var(--tree-style) var(--tree-clr);
+  position: relative;
+  margin-left: 0 !important;
+
+  &:last-child {
+    border-color: transparent;
+  }
+  &::before{
+    content: '';
+    position: absolute;
+    top: calc(var(--tree-item-height) / 2 * -1 * var(--tree-font-size) + var(--tree-thickness));
+    left: calc(var(--tree-thickness) * -1);
+    width: calc(var(--tree-offset) + var(--tree-thickness) * 2);
+    height: calc(var(--tree-item-height)  * var(--tree-font-size));
+    border-left: var(--tree-thickness) var(--tree-style) var(--tree-clr);
+    border-bottom: var(--tree-thickness) var(--tree-style) var(--tree-clr);
+  }
+  &::after{
+    content: '';
+    position: absolute;
+    border-radius: 50%;
+    background-color: var(--tree-clr);
+    top: calc(var(--tree-item-height) / 2 * 1rem);
+    left: var(--tree-offset) ;
+    translate: calc(var(--tree-thickness) * -1) calc(var(--tree-thickness) * -1);
+  }
+}
diff -pruN 1.4.1-1/docs/reference/api.md 1.4.2-1/docs/reference/api.md
--- 1.4.1-1/docs/reference/api.md	1970-01-01 00:00:00.000000000 +0000
+++ 1.4.2-1/docs/reference/api.md	2025-05-20 13:07:56.000000000 +0000
@@ -0,0 +1,7 @@
+---
+title: API reference
+hide:
+- navigation
+---
+
+# ::: mkdocs_autorefs
diff -pruN 1.4.1-1/docs/reference/mkdocs_autorefs.md 1.4.2-1/docs/reference/mkdocs_autorefs.md
--- 1.4.1-1/docs/reference/mkdocs_autorefs.md	2025-03-08 13:34:43.000000000 +0000
+++ 1.4.2-1/docs/reference/mkdocs_autorefs.md	1970-01-01 00:00:00.000000000 +0000
@@ -1,12 +0,0 @@
----
-title: mkdocs-autorefs API reference
-hide:
-- navigation
----
-
-# ::: mkdocs_autorefs
-    options:
-        summary:
-            classes: true
-            functions: true
-            attributes: true
diff -pruN 1.4.1-1/mkdocs.yml 1.4.2-1/mkdocs.yml
--- 1.4.1-1/mkdocs.yml	2025-03-08 13:34:43.000000000 +0000
+++ 1.4.2-1/mkdocs.yml	2025-05-20 13:07:56.000000000 +0000
@@ -19,7 +19,7 @@ nav:
   - Changelog: changelog.md
   - Credits: credits.md
   - License: license.md
-- API reference: reference/mkdocs_autorefs.md
+- API reference: reference/api.md
 - Development:
   - Contributing: contributing.md
   - Code of Conduct: code_of_conduct.md
@@ -97,9 +97,10 @@ markdown_extensions:
     permalink: "¤"
 
 plugins:
-- autorefs
 - search
+- autorefs
 - markdown-exec
+- section-index
 - coverage
 - mkdocstrings:
     handlers:
@@ -110,6 +111,7 @@ plugins:
         - https://python-markdown.github.io/objects.inv
         paths: [src]
         options:
+          backlinks: tree
           docstring_options:
             ignore_init_summary: true
           docstring_section_style: list
@@ -127,11 +129,12 @@ plugins:
           signature_crossrefs: true
           summary: true
 - llmstxt:
-    files:
-    - output: llms-full.txt
-      inputs:
+    full_output: llms-full.txt
+    sections:
+      Usage:
       - index.md
-      - reference/**.md
+      API:
+      - reference/api.md
 - git-revision-date-localized:
     enabled: !ENV [DEPLOY, false]
     enable_creation_date: true
diff -pruN 1.4.1-1/pyproject.toml 1.4.2-1/pyproject.toml
--- 1.4.1-1/pyproject.toml	2025-03-08 13:34:43.000000000 +0000
+++ 1.4.2-1/pyproject.toml	2025-05-20 13:07:56.000000000 +0000
@@ -57,7 +57,7 @@ getter = "scripts.get_version:get_versio
 
 [tool.pdm.build]
 # Include as much as possible in the source distribution, to help redistributors.
-excludes = ["**/.pytest_cache"]
+excludes = ["**/.pytest_cache", "**/.mypy_cache"]
 source-includes = [
     "config",
     "docs",
@@ -103,10 +103,11 @@ ci = [
     "mkdocs>=1.6",
     "mkdocs-coverage>=1.0",
     "mkdocs-git-revision-date-localized-plugin>=1.2",
-    "mkdocs-llmstxt>=0.1",
+    "mkdocs-llmstxt>=0.2",
     "mkdocs-material>=9.5",
     "mkdocs-minify-plugin>=0.8",
-    "mkdocstrings[python]>=0.25",
+    "mkdocs-section-index>=0.3",
+    "mkdocstrings[python]>=0.29",
     # YORE: EOL 3.10: Remove line.
     "tomli>=2.0; python_version < '3.11'",
 ]
diff -pruN 1.4.1-1/src/mkdocs_autorefs/_internal/references.py 1.4.2-1/src/mkdocs_autorefs/_internal/references.py
--- 1.4.1-1/src/mkdocs_autorefs/_internal/references.py	2025-03-08 13:34:43.000000000 +0000
+++ 1.4.2-1/src/mkdocs_autorefs/_internal/references.py	2025-05-20 13:07:56.000000000 +0000
@@ -190,7 +190,7 @@ class AutorefsInlineProcessor(ReferenceI
                     if match := HTML_PLACEHOLDER_RE.fullmatch(identifier):
                         stash_index = int(match.group(1))
                         html = self.md.htmlStash.rawHtmlBlocks[stash_index]
-                        identifier = Markup(html).striptags()
+                        identifier = Markup(html).striptags()  # noqa: S704
                         self.md.htmlStash.rawHtmlBlocks[stash_index] = escape(identifier)
 
             # In any other case, unstash the title and slugify it.
diff -pruN 1.4.1-1/tests/test_api.py 1.4.2-1/tests/test_api.py
--- 1.4.1-1/tests/test_api.py	2025-03-08 13:34:43.000000000 +0000
+++ 1.4.2-1/tests/test_api.py	2025-05-20 13:07:56.000000000 +0000
@@ -8,7 +8,7 @@ from typing import TYPE_CHECKING
 
 import griffe
 import pytest
-from mkdocstrings.inventory import Inventory
+from mkdocstrings import Inventory
 
 import mkdocs_autorefs
 
@@ -154,7 +154,11 @@ def test_inventory_matches_api(
     public_api_paths.add("mkdocs_autorefs")
     ignore = {"mkdocs_autorefs.plugin", "mkdocs_autorefs.references"}
     for item in inventory.values():
-        if item.domain == "py" and "(" not in item.name:
+        if (
+            item.domain == "py"
+            and "(" not in item.name
+            and (item.name == "mkdocs_autorefs" or item.name.startswith("mkdocs_autorefs."))
+        ):
             obj = loader.modules_collection[item.name]
             if (
                 obj.path not in ignore
