diff -pruN 1.31.1-1/.github/workflows/RunIssueSentinel.yml 1.32.0-1/.github/workflows/RunIssueSentinel.yml
--- 1.31.1-1/.github/workflows/RunIssueSentinel.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.32.0-1/.github/workflows/RunIssueSentinel.yml	2025-03-11 22:49:30.000000000 +0000
@@ -0,0 +1,17 @@
+name: Run issue sentinel
+on:
+  issues:
+    types: [opened, edited, closed]
+
+jobs:
+  Issue:
+    permissions:
+        issues: write
+    runs-on: ubuntu-latest
+    steps:
+      - name: Run Issue Sentinel
+        uses: Azure/issue-sentinel@v1
+        with:
+          password: ${{secrets.ISSUE_SENTINEL_PASSWORD}}
+          enable-similar-issues-scanning: true # Scan for similar issues
+          enable-security-issues-scanning: true # Scan for security issues
\ No newline at end of file
diff -pruN 1.31.1-1/.github/workflows/python-package.yml 1.32.0-1/.github/workflows/python-package.yml
--- 1.31.1-1/.github/workflows/python-package.yml	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/.github/workflows/python-package.yml	2025-03-11 22:49:30.000000000 +0000
@@ -25,10 +25,10 @@ jobs:
       LAB_OBO_PUBLIC_CLIENT_ID: ${{ secrets.LAB_OBO_PUBLIC_CLIENT_ID }}
 
     # Derived from https://docs.github.com/en/actions/guides/building-and-testing-python#starting-with-the-python-workflow-template
-    runs-on: ubuntu-latest  # It switched to 22.04 shortly after 2022-Nov-8
+    runs-on: ubuntu-22.04
     strategy:
       matrix:
-        python-version: [3.7, 3.8, 3.9, "3.10", "3.11", "3.12"]
+        python-version: ['3.7', '3.8', '3.9', '3.10', '3.11', '3.12', '3.13']
 
     steps:
     - uses: actions/checkout@v4
diff -pruN 1.31.1-1/.gitignore 1.32.0-1/.gitignore
--- 1.31.1-1/.gitignore	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/.gitignore	2025-03-11 22:49:30.000000000 +0000
@@ -57,6 +57,8 @@ docs/_build/
 # The test configuration file(s) could potentially contain credentials
 tests/config.json
 
+# Token Cache files
+msal_cache.bin
 
 .env
 .perf.baseline
diff -pruN 1.31.1-1/.travis.yml 1.32.0-1/.travis.yml
--- 1.31.1-1/.travis.yml	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/.travis.yml	1970-01-01 00:00:00.000000000 +0000
@@ -1,46 +0,0 @@
-sudo: false
-language: python
-python:
-  - "2.7"
-  - "3.5"
-  - "3.6"
-# Borrowed from https://github.com/travis-ci/travis-ci/issues/9815
-# Enable 3.7 without globally enabling sudo and dist: xenial for other build jobs
-matrix:
-  include:
-    - python: 3.7
-      dist: xenial
-      sudo: true
-    - python: 3.8
-      dist: xenial
-      sudo: true
-
-install:
-  - pip install -r requirements.txt
-script:
-  - python -m unittest discover -s tests
-
-deploy:
-  - # test pypi
-    provider: pypi
-    distributions: "sdist bdist_wheel"
-    server: https://test.pypi.org/legacy/
-    user: "nugetaad"
-    password:
-      secure: KkjKySJujYxx31B15mlAZr2Jo4P99LcrMj3uON/X/WMXAqYVcVsYJ6JSzUvpNnCAgk+1hc24Qp6nibQHV824yiK+eG4qV+lpzkEEedkRx6NOW/h09OkT+pOSVMs0kcIhz7FzqChpl+jf6ZZpb13yJpQg2LoZIA4g8UdYHHFidWt4m5u1FZ9LPCqQ0OT3gnKK4qb0HIDaECfz5GYzrelLLces0PPwj1+X5eb38xUVtbkA1UJKLGKI882D8Rq5eBdbnDGsfDnF6oU+EBnGZ7o6HVQLdBgagDoVdx7yoXyntULeNxTENMTOZJEJbncQwxRgeEqJWXTTEW57O6Jo5uiHEpJA9lAePlRbS+z6BPDlnQogqOdTsYS0XMfOpYE0/r3cbtPUjETOmGYQxjQzfrFBfM7jaWnUquymZRYqCQ66VDo3I/ykNOCoM9qTmWt5L/MFfOZyoxLHnDThZBdJ3GXHfbivg+v+vOfY1gG8e2H2lQY+/LIMIJibF+MS4lJgrB81dcNdBzyxMNByuWQjSL1TY7un0QzcRcZz2NLrFGg8+9d67LQq4mK5ySimc6zdgnanuROU02vGr1EApT6D/qUItiulFgWqInNKrFXE9q74UP/WSooZPoLa3Du8y5s4eKerYYHQy5eSfIC8xKKDU8MSgoZhwQhCUP46G9Nsty0PYQc=
-    on:
-      branch: master
-      tags: false
-      condition: $TRAVIS_PYTHON_VERSION = "2.7"
-
-  - # production pypi
-    provider: pypi
-    distributions: "sdist bdist_wheel"
-    user: "nugetaad"
-    password:
-      secure: KkjKySJujYxx31B15mlAZr2Jo4P99LcrMj3uON/X/WMXAqYVcVsYJ6JSzUvpNnCAgk+1hc24Qp6nibQHV824yiK+eG4qV+lpzkEEedkRx6NOW/h09OkT+pOSVMs0kcIhz7FzqChpl+jf6ZZpb13yJpQg2LoZIA4g8UdYHHFidWt4m5u1FZ9LPCqQ0OT3gnKK4qb0HIDaECfz5GYzrelLLces0PPwj1+X5eb38xUVtbkA1UJKLGKI882D8Rq5eBdbnDGsfDnF6oU+EBnGZ7o6HVQLdBgagDoVdx7yoXyntULeNxTENMTOZJEJbncQwxRgeEqJWXTTEW57O6Jo5uiHEpJA9lAePlRbS+z6BPDlnQogqOdTsYS0XMfOpYE0/r3cbtPUjETOmGYQxjQzfrFBfM7jaWnUquymZRYqCQ66VDo3I/ykNOCoM9qTmWt5L/MFfOZyoxLHnDThZBdJ3GXHfbivg+v+vOfY1gG8e2H2lQY+/LIMIJibF+MS4lJgrB81dcNdBzyxMNByuWQjSL1TY7un0QzcRcZz2NLrFGg8+9d67LQq4mK5ySimc6zdgnanuROU02vGr1EApT6D/qUItiulFgWqInNKrFXE9q74UP/WSooZPoLa3Du8y5s4eKerYYHQy5eSfIC8xKKDU8MSgoZhwQhCUP46G9Nsty0PYQc=
-    on:
-      branch: master
-      tags: true
-      condition: $TRAVIS_PYTHON_VERSION = "2.7"
-
diff -pruN 1.31.1-1/azure-pipelines.yml 1.32.0-1/azure-pipelines.yml
--- 1.31.1-1/azure-pipelines.yml	1970-01-01 00:00:00.000000000 +0000
+++ 1.32.0-1/azure-pipelines.yml	2025-03-11 22:49:30.000000000 +0000
@@ -0,0 +1,37 @@
+# Derived from the default YAML generated by Azure DevOps for a Python package
+# Create and test a Python package on multiple Python versions.
+# Add steps that analyze code, save the dist with the build record, publish to a PyPI-compatible index, and more:
+# https://docs.microsoft.com/azure/devops/pipelines/languages/python
+
+trigger:
+- dev
+- azure-pipelines
+
+pool:
+  vmImage: ubuntu-latest
+strategy:
+  matrix:
+    Python39:
+      python.version: '3.9'
+    Python310:
+      python.version: '3.10'
+    Python311:
+      python.version: '3.11'
+    Python312:
+      python.version: '3.12'
+
+steps:
+- task: UsePythonVersion@0
+  inputs:
+    versionSpec: '$(python.version)'
+  displayName: 'Use Python $(python.version)'
+
+- script: |
+    python -m pip install --upgrade pip
+    pip install -r requirements.txt
+  displayName: 'Install dependencies'
+
+- script: |
+    pip install pytest pytest-azurepipelines
+    pytest
+  displayName: 'pytest'
diff -pruN 1.31.1-1/debian/changelog 1.32.0-1/debian/changelog
--- 1.31.1-1/debian/changelog	2024-11-21 23:22:27.000000000 +0000
+++ 1.32.0-1/debian/changelog	2025-03-14 10:28:48.000000000 +0000
@@ -1,3 +1,10 @@
+microsoft-authentication-library-for-python (1.32.0-1) unstable; urgency=medium
+
+  * Update upstream source from tag 'upstream/1.32.0'
+  * d/control: bump Standards-Version to 4.7.2, no changes
+
+ -- Luca Boccassi <bluca@debian.org>  Fri, 14 Mar 2025 10:28:48 +0000
+
 microsoft-authentication-library-for-python (1.31.1-1) unstable; urgency=medium
 
   * Update upstream source from tag 'upstream/1.31.1'
diff -pruN 1.31.1-1/debian/control 1.32.0-1/debian/control
--- 1.31.1-1/debian/control	2024-06-17 21:24:52.000000000 +0000
+++ 1.32.0-1/debian/control	2025-03-14 10:28:30.000000000 +0000
@@ -8,7 +8,7 @@ Build-Depends: debhelper-compat (= 13),
                python3-setuptools,
                python3-sphinx <!nodoc>,
                python3-sphinx-paramlinks <!nodoc>,
-Standards-Version: 4.7.0
+Standards-Version: 4.7.2
 Section: python
 Priority: optional
 Rules-Requires-Root: no
diff -pruN 1.31.1-1/docker_run.sh 1.32.0-1/docker_run.sh
--- 1.31.1-1/docker_run.sh	1970-01-01 00:00:00.000000000 +0000
+++ 1.32.0-1/docker_run.sh	2025-03-11 22:49:30.000000000 +0000
@@ -0,0 +1,24 @@
+#!/usr/bin/bash
+
+# Error out if there is less than 1 argument
+if [ "$#" -lt 1 ]; then
+    echo "Usage: $0 <Python_image> [command]"
+    echo "Example: $0 python:3.14.0a2-slim bash"
+    exit 1
+fi
+
+# We will get a standard Python image from the input,
+# so that we don't need to hard code one in a Dockerfile
+IMAGE_NAME=$1
+
+echo "=== Starting $IMAGE_NAME (especially those which have no AppImage yet) ==="
+echo "After seeing the bash prompt, run the following to test:"
+echo "    apt update && apt install -y gcc libffi-dev  # Needed in Python 3.14.0a2-slim"
+echo "    pip install -e ."
+echo "    pytest --capture=no -s tests/chosen_test_file.py"
+docker run --rm -it \
+    --privileged \
+    -w /home -v $PWD:/home \
+    $IMAGE_NAME \
+    $2
+
diff -pruN 1.31.1-1/msal/__init__.py 1.32.0-1/msal/__init__.py
--- 1.31.1-1/msal/__init__.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/msal/__init__.py	2025-03-11 22:49:30.000000000 +0000
@@ -26,12 +26,12 @@
 #------------------------------------------------------------------------------
 
 from .application import (
-    __version__,
     ClientApplication,
     ConfidentialClientApplication,
     PublicClientApplication,
     )
 from .oauth2cli.oidc import Prompt, IdTokenError
+from .sku import __version__
 from .token_cache import TokenCache, SerializableTokenCache
 from .auth_scheme import PopAuthScheme
 from .managed_identity import (
diff -pruN 1.31.1-1/msal/application.py 1.32.0-1/msal/application.py
--- 1.31.1-1/msal/application.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/msal/application.py	2025-03-11 22:49:30.000000000 +0000
@@ -5,6 +5,8 @@ import logging
 import sys
 import warnings
 from threading import Lock
+from typing import Optional  # Needed in Python 3.7 & 3.8
+from urllib.parse import urlparse
 import os
 
 from .oauth2cli import Client, JwtAssertionCreator
@@ -18,10 +20,9 @@ import msal.telemetry
 from .region import _detect_region
 from .throttled_http_client import ThrottledHttpClient
 from .cloudshell import _is_running_in_cloud_shell
+from .sku import SKU, __version__
 
 
-# The __init__.py will import this. Not the other way around.
-__version__ = "1.31.1"  # When releasing, also check and bump our dependencies's versions if needed
 
 logger = logging.getLogger(__name__)
 _AUTHORITY_TYPE_CLOUDSHELL = "CLOUDSHELL"
@@ -194,6 +195,21 @@ class _ClientWithCcsRoutingInfo(Client):
             username, password, headers=headers, **kwargs)
 
 
+def _msal_extension_check():
+    # Can't run this in module or class level otherwise you'll get circular import error
+    try:
+        from msal_extensions import __version__ as v
+        major, minor, _ = v.split(".", maxsplit=3)
+        if not (int(major) >= 1 and int(minor) >= 2):
+            warnings.warn(
+                "Please upgrade msal-extensions. "
+                "Only msal-extensions 1.2+ can work with msal 1.30+")
+    except ImportError:
+        pass  # The optional msal_extensions is not installed. Business as usual.
+    except ValueError:
+        logger.exception(f"msal_extensions version {v} not in major.minor.patch format")
+
+
 class ClientApplication(object):
     """You do not usually directly use this class. Use its subclasses instead:
     :class:`PublicClientApplication` and :class:`ConfidentialClientApplication`.
@@ -210,6 +226,7 @@ class ClientApplication(object):
     REMOVE_ACCOUNT_ID = "903"
 
     ATTEMPT_REGION_DISCOVERY = True  # "TryAutoDetect"
+    DISABLE_MSAL_FORCE_REGION = False  # Used in azure_region to disable MSAL_FORCE_REGION behavior
     _TOKEN_SOURCE = "token_source"
     _TOKEN_SOURCE_IDP = "identity_provider"
     _TOKEN_SOURCE_CACHE = "cache"
@@ -433,11 +450,14 @@ class ClientApplication(object):
             Instructs MSAL to use the Entra regional token service. This legacy feature is only available to
             first-party applications. Only ``acquire_token_for_client()`` is supported.
 
-            Supports 3 values:
+            Supports 4 values:
 
-              ``azure_region=None`` - meaning no region is used. This is the default value.
-              ``azure_region="some_region"`` - meaning the specified region is used.
-              ``azure_region=True`` - meaning MSAL will try to auto-detect the region. This is not recommended.
+            1. ``azure_region=None`` - This default value means no region is configured.
+               MSAL will use the region defined in env var ``MSAL_FORCE_REGION``.
+            2. ``azure_region="some_region"`` - meaning the specified region is used.
+            3. ``azure_region=True`` - meaning
+               MSAL will try to auto-detect the region. This is not recommended.
+            4. ``azure_region=False`` - meaning MSAL will use no region.
 
             .. note::
                 Region auto-discovery has been tested on VMs and on Azure Functions. It is unreliable.
@@ -603,6 +623,9 @@ class ClientApplication(object):
         # Here the self.authority will not be the same type as authority in input
         if oidc_authority and authority:
             raise ValueError("You can not provide both authority and oidc_authority")
+        if isinstance(authority, str) and urlparse(authority).path.startswith(
+            "/dstsv2"):  # dSTS authority's path always starts with "/dstsv2"
+            oidc_authority = authority  # So we treat it as if an oidc_authority
         try:
             authority_to_use = authority or "https://{}/common/".format(WORLD_WIDE)
             self.authority = Authority(
@@ -615,7 +638,10 @@ class ClientApplication(object):
         except ValueError:  # Those are explicit authority validation errors
             raise
         except Exception:  # The rest are typically connection errors
-            if validate_authority and azure_region and not oidc_authority:
+            if validate_authority and not oidc_authority and (
+                azure_region  # Opted in to use region
+                or (azure_region is None and os.getenv("MSAL_FORCE_REGION"))  # Will use region
+            ):
                 # Since caller opts in to use region, here we tolerate connection
                 # errors happened during authority validation at non-region endpoint
                 self.authority = Authority(
@@ -635,6 +661,8 @@ class ClientApplication(object):
         self.authority_groups = None
         self._telemetry_buffer = {}
         self._telemetry_lock = Lock()
+        _msal_extension_check()
+
 
     def _decide_broker(self, allow_broker, enable_pii_log):
         is_confidential_app = self.client_credential or isinstance(
@@ -647,7 +675,8 @@ class ClientApplication(object):
                 "allow_broker is deprecated. "
                 "Please use PublicClientApplication(..., "
                 "enable_broker_on_windows=True, "
-                "enable_broker_on_mac=...)",
+                # No need to mention non-Windows platforms, because allow_broker is only for Windows
+                "...)",
                 DeprecationWarning)
         opted_in_for_broker = (
             self._enable_broker  # True means Opted-in from PCA
@@ -669,7 +698,7 @@ class ClientApplication(object):
                 _init_broker(enable_pii_log)
             except RuntimeError:
                 self._enable_broker = False
-                logger.exception(
+                logger.warning(  # It is common on Mac and Linux where broker is not built-in
                     "Broker is unavailable on this platform. "
                     "We will fallback to non-broker.")
         logger.debug("Broker enabled? %s", self._enable_broker)
@@ -707,9 +736,11 @@ The reserved list: {}""".format(list(sco
             self._telemetry_buffer, self._telemetry_lock, api_id,
             correlation_id=correlation_id, refresh_reason=refresh_reason)
 
-    def _get_regional_authority(self, central_authority):
-        if not self._region_configured:  # User did not opt-in to ESTS-R
+    def _get_regional_authority(self, central_authority) -> Optional[Authority]:
+        if self._region_configured is False:  # User opts out of ESTS-R
             return None  # Short circuit to completely bypass region detection
+        if self._region_configured is None:  # User did not make an ESTS-R choice
+            self._region_configured = os.getenv("MSAL_FORCE_REGION") or None
         self._region_detected = self._region_detected or _detect_region(
             self.http_client if self._region_configured is not None else None)
         if (self._region_configured != self.ATTEMPT_REGION_DISCOVERY
@@ -743,7 +774,7 @@ The reserved list: {}""".format(list(sco
         client_assertion = None
         client_assertion_type = None
         default_headers = {
-            "x-client-sku": "MSAL.Python", "x-client-ver": __version__,
+            "x-client-sku": SKU, "x-client-ver": __version__,
             "x-client-os": sys.platform,
             "x-ms-lib-capability": "retry-after, h429",
         }
@@ -1888,7 +1919,12 @@ class PublicClientApplication(ClientAppl
     DEVICE_FLOW_CORRELATION_ID = "_correlation_id"
     CONSOLE_WINDOW_HANDLE = object()
 
-    def __init__(self, client_id, client_credential=None, **kwargs):
+    def __init__(
+        self, client_id, client_credential=None,
+        *,
+        enable_broker_on_windows=None,
+        enable_broker_on_mac=None,
+        **kwargs):
         """Same as :func:`ClientApplication.__init__`,
         except that ``client_credential`` parameter shall remain ``None``.
 
@@ -1965,9 +2001,6 @@ class PublicClientApplication(ClientAppl
         """
         if client_credential is not None:
             raise ValueError("Public Client should not possess credentials")
-        # Using kwargs notation for now. We will switch to keyword-only arguments.
-        enable_broker_on_windows = kwargs.pop("enable_broker_on_windows", False)
-        enable_broker_on_mac = kwargs.pop("enable_broker_on_mac", False)
         self._enable_broker = bool(
             enable_broker_on_windows and sys.platform == "win32"
             or enable_broker_on_mac and sys.platform == "darwin")
@@ -2211,7 +2244,8 @@ class PublicClientApplication(ClientAppl
                 # _signin_silently() only gets tokens for default account,
                 # but this seems to have been fixed in PyMsalRuntime 0.11.2
                 "access_token" in response and login_hint
-                and response.get("id_token_claims", {}) != login_hint)
+                and login_hint != response.get(
+                    "id_token_claims", {}).get("preferred_username"))
             wrong_account_error_message = (
                 'prompt="none" will not work for login_hint="non-default-user"')
             if is_wrong_account:
diff -pruN 1.31.1-1/msal/broker.py 1.32.0-1/msal/broker.py
--- 1.31.1-1/msal/broker.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/msal/broker.py	2025-03-11 22:49:30.000000000 +0000
@@ -7,6 +7,7 @@ import sys
 import time
 import uuid
 
+from .sku import __version__, SKU
 
 logger = logging.getLogger(__name__)
 try:
@@ -23,7 +24,15 @@ try:
 except (ImportError, AttributeError):  # AttributeError happens when a prior pymsalruntime uninstallation somehow leaved an empty folder behind
     # PyMsalRuntime currently supports these Windows versions, listed in this MSFT internal link
     # https://github.com/AzureAD/microsoft-authentication-library-for-cpp/pull/2406/files
-    raise ImportError('You need to install dependency by: pip install "msal[broker]>=1.20,<2"')
+    min_ver = {
+        "win32": "1.20",
+        "darwin": "1.31",
+    }.get(sys.platform)
+    if min_ver:
+        raise ImportError(
+            f'You must install dependency by: pip install "msal[broker]>={min_ver},<2"')
+    else:  # Unsupported platform
+        raise ImportError("Dependency pymsalruntime unavailable on current platform")
 # It could throw RuntimeError when running on ancient versions of Windows
 
 
@@ -127,13 +136,18 @@ def _get_new_correlation_id():
 def _enable_msa_pt(params):
     params.set_additional_parameter("msal_request_type", "consumer_passthrough")  # PyMsalRuntime 0.8+
 
+def _build_msal_runtime_auth_params(client_id, authority):
+    params = pymsalruntime.MSALRuntimeAuthParameters(client_id, authority)
+    params.set_additional_parameter("msal_client_sku", SKU)
+    params.set_additional_parameter("msal_client_ver", __version__)
+    return params
 
 def _signin_silently(
         authority, client_id, scopes, correlation_id=None, claims=None,
         enable_msa_pt=False,
         auth_scheme=None,
         **kwargs):
-    params = pymsalruntime.MSALRuntimeAuthParameters(client_id, authority)
+    params = _build_msal_runtime_auth_params(client_id, authority)
     params.set_requested_scopes(scopes)
     if claims:
         params.set_decoded_claims(claims)
@@ -166,7 +180,7 @@ def _signin_interactively(
         enable_msa_pt=False,
         auth_scheme=None,
         **kwargs):
-    params = pymsalruntime.MSALRuntimeAuthParameters(client_id, authority)
+    params = _build_msal_runtime_auth_params(client_id, authority)
     params.set_requested_scopes(scopes)
     params.set_redirect_uri(
         _redirect_uri_on_mac if sys.platform == "darwin" else
@@ -222,7 +236,7 @@ def _acquire_token_silently(
     account = _read_account_by_id(account_id, correlation_id)
     if account is None:
         return
-    params = pymsalruntime.MSALRuntimeAuthParameters(client_id, authority)
+    params = _build_msal_runtime_auth_params(client_id, authority)
     params.set_requested_scopes(scopes)
     if claims:
         params.set_decoded_claims(claims)
diff -pruN 1.31.1-1/msal/cloudshell.py 1.32.0-1/msal/cloudshell.py
--- 1.31.1-1/msal/cloudshell.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/msal/cloudshell.py	2025-03-11 22:49:30.000000000 +0000
@@ -32,8 +32,12 @@ def _scope_to_resource(scope):  # This i
         if scope.startswith(a):
             return a
     u = urlparse(scope)
+    if not u.scheme and not u.netloc:  # Typically the "GUID/scope" case
+        return u.path.split("/")[0]
     if u.scheme:
-        return "{}://{}".format(u.scheme, u.netloc)
+        trailer = (  # https://learn.microsoft.com/en-us/entra/identity-platform/scopes-oidc#trailing-slash-and-default
+            "/" if u.path.startswith("//") else "")
+        return "{}://{}{}".format(u.scheme, u.netloc, trailer)
     return scope  # There is no much else we can do here
 
 
diff -pruN 1.31.1-1/msal/managed_identity.py 1.32.0-1/msal/managed_identity.py
--- 1.31.1-1/msal/managed_identity.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/msal/managed_identity.py	2025-03-11 22:49:30.000000000 +0000
@@ -154,7 +154,7 @@ class ManagedIdentityClient(object):
         self,
         managed_identity: Union[
             dict,
-            ManagedIdentity,  # Could use Type[ManagedIdentity] but it is deprecatred in Python 3.9+
+            ManagedIdentity,  # Could use Type[ManagedIdentity] but it is deprecated in Python 3.9+
             SystemAssignedManagedIdentity,
             UserAssignedManagedIdentity,
             ],
@@ -206,7 +206,7 @@ class ManagedIdentityClient(object):
         you may use an environment variable (such as MY_MANAGED_IDENTITY_CONFIG)
         to store a json blob like
         ``{"ManagedIdentityIdType": "ClientId", "Id": "foo"}`` or
-        ``{"ManagedIdentityIdType": "SystemAssignedManagedIdentity", "Id": null})``.
+        ``{"ManagedIdentityIdType": "SystemAssigned", "Id": null}``.
         The following app can load managed identity configuration dynamically::
 
             import json, os, msal, requests
@@ -448,7 +448,9 @@ def _obtain_token_on_azure_vm(http_clien
         }
     _adjust_param(params, managed_identity)
     resp = http_client.get(
-        "http://169.254.169.254/metadata/identity/oauth2/token",
+        os.getenv(
+            "AZURE_POD_IDENTITY_AUTHORITY_HOST", "http://169.254.169.254"
+            ).strip("/") + "/metadata/identity/oauth2/token",
         params=params,
         headers={"Metadata": "true"},
         )
@@ -648,4 +650,3 @@ def _obtain_token_on_arc(http_client, en
         "error": "invalid_request",
         "error_description": response.text,
         }
-
diff -pruN 1.31.1-1/msal/sku.py 1.32.0-1/msal/sku.py
--- 1.31.1-1/msal/sku.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.32.0-1/msal/sku.py	2025-03-11 22:49:30.000000000 +0000
@@ -0,0 +1,6 @@
+"""This module is from where we recieve the client sku name and version.
+"""
+
+# The __init__.py will import this. Not the other way around.
+__version__ = "1.32.0"
+SKU = "MSAL.Python"
diff -pruN 1.31.1-1/msal/token_cache.py 1.32.0-1/msal/token_cache.py
--- 1.31.1-1/msal/token_cache.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/msal/token_cache.py	2025-03-11 22:49:30.000000000 +0000
@@ -43,6 +43,8 @@ class TokenCache(object):
         self._lock = threading.RLock()
         self._cache = {}
         self.key_makers = {
+            # Note: We have changed token key format before when ordering scopes;
+            #       changing token key won't result in cache miss.
             self.CredentialType.REFRESH_TOKEN:
                 lambda home_account_id=None, environment=None, client_id=None,
                         target=None, **ignored_payload_from_a_real_token:
@@ -56,14 +58,18 @@ class TokenCache(object):
                         ]).lower(),
             self.CredentialType.ACCESS_TOKEN:
                 lambda home_account_id=None, environment=None, client_id=None,
-                        realm=None, target=None, **ignored_payload_from_a_real_token:
-                    "-".join([
+                        realm=None, target=None,
+                        # Note: New field(s) can be added here
+                        #key_id=None,
+                        **ignored_payload_from_a_real_token:
+                    "-".join([  # Note: Could use a hash here to shorten key length
                         home_account_id or "",
                         environment or "",
                         self.CredentialType.ACCESS_TOKEN,
                         client_id or "",
                         realm or "",
                         target or "",
+                        #key_id or "",  # So ATs of different key_id can coexist
                         ]).lower(),
             self.CredentialType.ID_TOKEN:
                 lambda home_account_id=None, environment=None, client_id=None,
@@ -124,7 +130,7 @@ class TokenCache(object):
             target_set <= set(entry.get("target", "").split())
             if target_set else True)
 
-    def search(self, credential_type, target=None, query=None):  # O(n) generator
+    def search(self, credential_type, target=None, query=None, *, now=None):  # O(n) generator
         """Returns a generator of matching entries.
 
         It is O(1) for AT hits, and O(n) for other types.
@@ -150,21 +156,33 @@ class TokenCache(object):
 
         target_set = set(target)
         with self._lock:
-            # Since the target inside token cache key is (per schema) unsorted,
-            # there is no point to attempt an O(1) key-value search here.
-            # So we always do an O(n) in-memory search.
+            # O(n) search. The key is NOT used in search.
+            now = int(time.time() if now is None else now)
+            expired_access_tokens = [
+                # Especially when/if we key ATs by ephemeral fields such as key_id,
+                # stale ATs keyed by an old key_id would stay forever.
+                # Here we collect them for their removal.
+            ]
             for entry in self._cache.get(credential_type, {}).values():
+                if (  # Automatically delete expired access tokens
+                    credential_type == self.CredentialType.ACCESS_TOKEN
+                    and int(entry["expires_on"]) < now
+                ):
+                    expired_access_tokens.append(entry)  # Can't delete them within current for-loop
+                    continue
                 if (entry != preferred_result  # Avoid yielding the same entry twice
                     and self._is_matching(entry, query, target_set=target_set)
                 ):
                     yield entry
+            for at in expired_access_tokens:
+                self.remove_at(at)
 
-    def find(self, credential_type, target=None, query=None):
+    def find(self, credential_type, target=None, query=None, *, now=None):
         """Equivalent to list(search(...))."""
         warnings.warn(
             "Use list(search(...)) instead to explicitly get a list.",
             DeprecationWarning)
-        return list(self.search(credential_type, target=target, query=query))
+        return list(self.search(credential_type, target=target, query=query, now=now))
 
     def add(self, event, now=None):
         """Handle a token obtaining event, and add tokens into cache."""
@@ -249,8 +267,11 @@ class TokenCache(object):
                     "expires_on": str(now + expires_in),  # Same here
                     "extended_expires_on": str(now + ext_expires_in)  # Same here
                     }
-                if data.get("key_id"):  # It happens in SSH-cert or POP scenario
-                    at["key_id"] = data.get("key_id")
+                at.update({k: data[k] for k in data if k in {
+                    # Also store extra data which we explicitly allow
+                    # So that we won't accidentally store a user's password etc.
+                    "key_id",  # It happens in SSH-cert or POP scenario
+                }})
                 if "refresh_in" in response:
                     refresh_in = response["refresh_in"]  # It is an integer
                     at["refresh_on"] = str(now + refresh_in)  # Schema wants a string
diff -pruN 1.31.1-1/setup.cfg 1.32.0-1/setup.cfg
--- 1.31.1-1/setup.cfg	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/setup.cfg	2025-03-11 22:49:30.000000000 +0000
@@ -52,7 +52,7 @@ install_requires =
     # And we will use the cryptography (X+3).0.0 as the upper bound,
     # based on their latest deprecation policy
     # https://cryptography.io/en/latest/api-stability/#deprecation
-    cryptography>=2.5,<46
+    cryptography>=2.5,<47
 
 
 [options.extras_require]
diff -pruN 1.31.1-1/tests/broker_util.py 1.32.0-1/tests/broker_util.py
--- 1.31.1-1/tests/broker_util.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.32.0-1/tests/broker_util.py	2025-03-11 22:49:30.000000000 +0000
@@ -0,0 +1,21 @@
+import logging
+
+
+logger = logging.getLogger(__name__)
+
+
+def is_pymsalruntime_installed() -> bool:
+    try:
+        import pymsalruntime
+        logger.info("PyMsalRuntime installed and initialized")
+        return True
+    except ImportError:
+        logger.info("PyMsalRuntime not installed")
+        return False
+    except RuntimeError:
+        logger.warning(
+            "PyMsalRuntime installed but failed to initialize the real broker. "
+            "This may happen on Mac and Linux where broker is not built-in. "
+            "Test cases shall attempt broker and test its fallback behavior."
+        )
+        return True
diff -pruN 1.31.1-1/tests/test_account_source.py 1.32.0-1/tests/test_account_source.py
--- 1.31.1-1/tests/test_account_source.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/tests/test_account_source.py	2025-03-11 22:49:30.000000000 +0000
@@ -3,15 +3,11 @@ try:
     from unittest.mock import patch
 except:
     from mock import patch
-try:
-    import pymsalruntime
-    broker_available = True
-except ImportError:
-    broker_available = False
 import msal
 from tests import unittest
 from tests.test_token_cache import build_response
 from tests.http_client import MinimalResponse
+from tests.broker_util import is_pymsalruntime_installed
 
 
 SCOPE = "scope_foo"
@@ -24,54 +20,62 @@ TOKEN_RESPONSE = build_response(
 def _mock_post(url, headers=None, *args, **kwargs):
     return MinimalResponse(status_code=200, text=json.dumps(TOKEN_RESPONSE))
 
-@unittest.skipUnless(broker_available, "These test cases need pip install msal[broker]")
+@unittest.skipUnless(is_pymsalruntime_installed(), "These test cases need pip install msal[broker]")
 @patch("msal.broker._acquire_token_silently", return_value=dict(
-    TOKEN_RESPONSE, _account_id="placeholder"))
+   TOKEN_RESPONSE, _account_id="placeholder"))
 @patch.object(msal.authority, "tenant_discovery", return_value={
     "authorization_endpoint": "https://contoso.com/placeholder",
     "token_endpoint": "https://contoso.com/placeholder",
 })  # Otherwise it would fail on OIDC discovery
 class TestAccountSourceBehavior(unittest.TestCase):
 
+    def setUp(self):
+        self.app = msal.PublicClientApplication(
+            "client_id",
+            enable_broker_on_windows=True,
+            )
+        if not self.app._enable_broker:
+            self.skipTest(
+                "These test cases require patching msal.broker which is only possible "
+                "when broker enabled successfully i.e. no RuntimeError")
+        return super().setUp()
+
     def test_device_flow_and_its_silent_call_should_bypass_broker(self, _, mocked_broker_ats):
-        app = msal.PublicClientApplication("client_id", enable_broker_on_windows=True)
-        result = app.acquire_token_by_device_flow({"device_code": "123"}, post=_mock_post)
+        result = self.app.acquire_token_by_device_flow({"device_code": "123"}, post=_mock_post)
         self.assertEqual(result["token_source"], "identity_provider")
 
-        account = app.get_accounts()[0]
+        account = self.app.get_accounts()[0]
         self.assertEqual(account["account_source"], "urn:ietf:params:oauth:grant-type:device_code")
 
-        result = app.acquire_token_silent_with_error(
+        result = self.app.acquire_token_silent_with_error(
             [SCOPE], account, force_refresh=True, post=_mock_post)
         mocked_broker_ats.assert_not_called()
         self.assertEqual(result["token_source"], "identity_provider")
 
     def test_ropc_flow_and_its_silent_call_should_invoke_broker(self, _, mocked_broker_ats):
-        app = msal.PublicClientApplication("client_id", enable_broker_on_windows=True)
         with patch("msal.broker._signin_silently", return_value=dict(TOKEN_RESPONSE, _account_id="placeholder")):
-            result = app.acquire_token_by_username_password(
+            result = self.app.acquire_token_by_username_password(
                 "username", "placeholder", [SCOPE], post=_mock_post)
         self.assertEqual(result["token_source"], "broker")
 
-        account = app.get_accounts()[0]
+        account = self.app.get_accounts()[0]
         self.assertEqual(account["account_source"], "broker")
 
-        result = app.acquire_token_silent_with_error(
+        result = self.app.acquire_token_silent_with_error(
             [SCOPE], account, force_refresh=True, post=_mock_post)
         self.assertEqual(result["token_source"], "broker")
 
     def test_interactive_flow_and_its_silent_call_should_invoke_broker(self, _, mocked_broker_ats):
-        app = msal.PublicClientApplication("client_id", enable_broker_on_windows=True)
-        with patch.object(app, "_acquire_token_interactive_via_broker", return_value=dict(
+        with patch.object(self.app, "_acquire_token_interactive_via_broker", return_value=dict(
                 TOKEN_RESPONSE, _account_id="placeholder")):
-            result = app.acquire_token_interactive(
-                [SCOPE], parent_window_handle=app.CONSOLE_WINDOW_HANDLE)
+            result = self.app.acquire_token_interactive(
+                [SCOPE], parent_window_handle=self.app.CONSOLE_WINDOW_HANDLE)
         self.assertEqual(result["token_source"], "broker")
 
-        account = app.get_accounts()[0]
+        account = self.app.get_accounts()[0]
         self.assertEqual(account["account_source"], "broker")
 
-        result = app.acquire_token_silent_with_error(
+        result = self.app.acquire_token_silent_with_error(
             [SCOPE], account, force_refresh=True, post=_mock_post)
         mocked_broker_ats.assert_called_once()
         self.assertEqual(result["token_source"], "broker")
diff -pruN 1.31.1-1/tests/test_application.py 1.32.0-1/tests/test_application.py
--- 1.31.1-1/tests/test_application.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/tests/test_application.py	2025-03-11 22:49:30.000000000 +0000
@@ -20,6 +20,12 @@ from msal.telemetry import CLIENT_CURREN
 logger = logging.getLogger(__name__)
 logging.basicConfig(level=logging.DEBUG)
 
+_OIDC_DISCOVERY = "msal.authority.tenant_discovery"
+_OIDC_DISCOVERY_MOCK = Mock(return_value={
+    "authorization_endpoint": "https://contoso.com/placeholder",
+    "token_endpoint": "https://contoso.com/placeholder",
+})
+
 
 class TestHelperExtractCerts(unittest.TestCase):  # It is used by SNI scenario
 
@@ -58,10 +64,9 @@ class TestBytesConversion(unittest.TestC
 
 class TestClientApplicationAcquireTokenSilentErrorBehaviors(unittest.TestCase):
 
+    @patch(_OIDC_DISCOVERY, new=_OIDC_DISCOVERY_MOCK)
     def setUp(self):
         self.authority_url = "https://login.microsoftonline.com/common"
-        self.authority = msal.authority.Authority(
-            self.authority_url, MinimalHttpClient())
         self.scopes = ["s1", "s2"]
         self.uid = "my_uid"
         self.utid = "my_utid"
@@ -116,12 +121,11 @@ class TestClientApplicationAcquireTokenS
         self.assertEqual("", result.get("classification"))
 
 
+@patch(_OIDC_DISCOVERY, new=_OIDC_DISCOVERY_MOCK)
 class TestClientApplicationAcquireTokenSilentFociBehaviors(unittest.TestCase):
 
     def setUp(self):
         self.authority_url = "https://login.microsoftonline.com/common"
-        self.authority = msal.authority.Authority(
-            self.authority_url, MinimalHttpClient())
         self.scopes = ["s1", "s2"]
         self.uid = "my_uid"
         self.utid = "my_utid"
@@ -148,7 +152,7 @@ class TestClientApplicationAcquireTokenS
             self.assertEqual(self.frt, data.get("refresh_token"), "Should attempt the FRT")
             return MinimalResponse(status_code=400, text=error_response)
         app._acquire_token_silent_by_finding_rt_belongs_to_me_or_my_family(
-            self.authority, self.scopes, self.account, post=tester)
+            app.authority, self.scopes, self.account, post=tester)
         self.assertNotEqual([], app.token_cache.find(
             msal.TokenCache.CredentialType.REFRESH_TOKEN, query={"secret": self.frt}),
             "The FRT should not be removed from the cache")
@@ -168,7 +172,7 @@ class TestClientApplicationAcquireTokenS
             self.assertEqual(rt, data.get("refresh_token"), "Should attempt the RT")
             return MinimalResponse(status_code=200, text='{}')
         app._acquire_token_silent_by_finding_rt_belongs_to_me_or_my_family(
-            self.authority, self.scopes, self.account, post=tester)
+            app.authority, self.scopes, self.account, post=tester)
 
     def test_unknown_family_app_will_attempt_frt_and_join_family(self):
         def tester(url, data=None, **kwargs):
@@ -180,7 +184,7 @@ class TestClientApplicationAcquireTokenS
         app = ClientApplication(
             "unknown_family_app", authority=self.authority_url, token_cache=self.cache)
         at = app._acquire_token_silent_by_finding_rt_belongs_to_me_or_my_family(
-            self.authority, self.scopes, self.account, post=tester)
+            app.authority, self.scopes, self.account, post=tester)
         logger.debug("%s.cache = %s", self.id(), self.cache.serialize())
         self.assertEqual("at", at.get("access_token"), "New app should get a new AT")
         app_metadata = app.token_cache.find(
@@ -202,7 +206,7 @@ class TestClientApplicationAcquireTokenS
         app = ClientApplication(
             "preexisting_family_app", authority=self.authority_url, token_cache=self.cache)
         resp = app._acquire_token_silent_by_finding_rt_belongs_to_me_or_my_family(
-            self.authority, self.scopes, self.account, post=tester)
+            app.authority, self.scopes, self.account, post=tester)
         logger.debug("%s.cache = %s", self.id(), self.cache.serialize())
         self.assertEqual(json.loads(error_response), resp, "Error raised will be returned")
 
@@ -237,7 +241,7 @@ class TestClientApplicationAcquireTokenS
 
 class TestClientApplicationForAuthorityMigration(unittest.TestCase):
 
-    @classmethod
+    # Chose to not mock oidc discovery, because AuthorityMigration might rely on real data
     def setUp(self):
         self.environment_in_cache = "sts.windows.net"
         self.authority_url_in_app = "https://login.microsoftonline.com/common"
@@ -340,6 +344,7 @@ class TestApplicationForRefreshInBehavio
     account = {"home_account_id": "{}.{}".format(uid, utid)}
     rt = "this is a rt"
     client_id = "my_app"
+    soon = 60  # application.py considers tokens within 5 minutes as expired
 
     @classmethod
     def setUpClass(cls):  # Initialization at runtime, not interpret-time
@@ -414,7 +419,8 @@ class TestApplicationForRefreshInBehavio
 
     def test_expired_token_and_unavailable_aad_should_return_error(self):
         # a.k.a. Attempt refresh expired token when AAD unavailable
-        self.populate_cache(access_token="expired at", expires_in=-1, refresh_in=-900)
+        self.populate_cache(
+            access_token="expired at", expires_in=self.soon, refresh_in=-900)
         error = "something went wrong"
         def mock_post(url, headers=None, *args, **kwargs):
             self.assertEqual("4|84,3|", (headers or {}).get(CLIENT_CURRENT_TELEMETRY))
@@ -425,7 +431,8 @@ class TestApplicationForRefreshInBehavio
 
     def test_expired_token_and_available_aad_should_return_new_token(self):
         # a.k.a. Attempt refresh expired token when AAD available
-        self.populate_cache(access_token="expired at", expires_in=-1, refresh_in=-900)
+        self.populate_cache(
+            access_token="expired at", expires_in=self.soon, refresh_in=-900)
         new_access_token = "new AT"
         new_refresh_in = 123
         def mock_post(url, headers=None, *args, **kwargs):
@@ -441,6 +448,7 @@ class TestApplicationForRefreshInBehavio
         self.assertRefreshOn(result, new_refresh_in)
 
 
+# TODO Patching oidc discovery ends up failing. But we plan to remove offline telemetry anyway.
 class TestTelemetryMaintainingOfflineState(unittest.TestCase):
     authority_url = "https://login.microsoftonline.com/common"
     scopes = ["s1", "s2"]
@@ -521,6 +529,7 @@ class TestTelemetryMaintainingOfflineSta
 
 class TestTelemetryOnClientApplication(unittest.TestCase):
     @classmethod
+    @patch(_OIDC_DISCOVERY, new=_OIDC_DISCOVERY_MOCK)
     def setUpClass(cls):  # Initialization at runtime, not interpret-time
         cls.app = ClientApplication(
             "client_id", authority="https://login.microsoftonline.com/common")
@@ -549,6 +558,7 @@ class TestTelemetryOnClientApplication(u
 
 class TestTelemetryOnPublicClientApplication(unittest.TestCase):
     @classmethod
+    @patch(_OIDC_DISCOVERY, new=_OIDC_DISCOVERY_MOCK)
     def setUpClass(cls):  # Initialization at runtime, not interpret-time
         cls.app = PublicClientApplication(
             "client_id", authority="https://login.microsoftonline.com/common")
@@ -578,6 +588,7 @@ class TestTelemetryOnPublicClientApplica
 
 class TestTelemetryOnConfidentialClientApplication(unittest.TestCase):
     @classmethod
+    @patch(_OIDC_DISCOVERY, new=_OIDC_DISCOVERY_MOCK)
     def setUpClass(cls):  # Initialization at runtime, not interpret-time
         cls.app = ConfidentialClientApplication(
             "client_id", client_credential="secret",
@@ -623,6 +634,7 @@ class TestTelemetryOnConfidentialClientA
         self.assertEqual(at, result.get("access_token"))
 
 
+@patch(_OIDC_DISCOVERY, new=_OIDC_DISCOVERY_MOCK)
 class TestClientApplicationWillGroupAccounts(unittest.TestCase):
     def test_get_accounts(self):
         client_id = "my_app"
@@ -675,15 +687,24 @@ class TestClientCredentialGrant(unittest
         with self.assertWarns(DeprecationWarning):
             app.acquire_token_for_client(["scope"], post=mock_post)
 
+    @patch(_OIDC_DISCOVERY, new=Mock(return_value={
+        "authorization_endpoint": "https://contoso.com/common",
+        "token_endpoint": "https://contoso.com/common",
+        }))
     def test_common_authority_should_emit_warning(self):
         self._test_certain_authority_should_emit_warning(
             authority="https://login.microsoftonline.com/common")
 
+    @patch(_OIDC_DISCOVERY, new=Mock(return_value={
+        "authorization_endpoint": "https://contoso.com/organizations",
+        "token_endpoint": "https://contoso.com/organizations",
+        }))
     def test_organizations_authority_should_emit_warning(self):
         self._test_certain_authority_should_emit_warning(
             authority="https://login.microsoftonline.com/organizations")
 
 
+@patch(_OIDC_DISCOVERY, new=_OIDC_DISCOVERY_MOCK)
 class TestRemoveTokensForClient(unittest.TestCase):
     def test_remove_tokens_for_client_should_remove_client_tokens_only(self):
         at_for_user = "AT for user"
@@ -713,6 +734,7 @@ class TestRemoveTokensForClient(unittest
         self.assertEqual(at_for_user, remaining_tokens[0].get("secret"))
 
 
+@patch(_OIDC_DISCOVERY, new=_OIDC_DISCOVERY_MOCK)
 class TestScopeDecoration(unittest.TestCase):
     def _test_client_id_should_be_a_valid_scope(self, client_id, other_scopes):
         # B2C needs this https://learn.microsoft.com/en-us/azure/active-directory-b2c/access-tokens#openid-connect-scopes
@@ -733,8 +755,49 @@ class TestScopeDecoration(unittest.TestC
     "authorization_endpoint": "https://contoso.com/placeholder",
     "token_endpoint": "https://contoso.com/placeholder",
     }))
-@patch("msal.application._init_broker", new=Mock())  # Allow testing without pymsalruntime
-class TestBrokerFallback(unittest.TestCase):
+class TestMsalBehaviorWithoutPyMsalRuntimeOrBroker(unittest.TestCase):
+
+    @patch("msal.application._init_broker", new=Mock(side_effect=ImportError(
+        "PyMsalRuntime not installed"
+    )))
+    def test_broker_should_be_disabled_by_default(self):
+        app = msal.PublicClientApplication(
+            "client_id",
+            authority="https://login.microsoftonline.com/common",
+            )
+        self.assertFalse(app._enable_broker)
+
+    @patch("msal.application._init_broker", new=Mock(side_effect=ImportError(
+        "PyMsalRuntime not installed"
+    )))
+    def test_opt_in_should_error_out_when_pymsalruntime_not_installed(self):
+        """Because it is actionable to app developer to add dependency declaration"""
+        with self.assertRaises(ImportError):
+            app = msal.PublicClientApplication(
+                "client_id",
+                authority="https://login.microsoftonline.com/common",
+                enable_broker_on_mac=True,
+                )
+
+    @patch("msal.application._init_broker", new=Mock(side_effect=RuntimeError(
+        "PyMsalRuntime raises RuntimeError when broker initialization failed"
+    )))
+    def test_should_fallback_when_pymsalruntime_failed_to_initialize_broker(self):
+        app = msal.PublicClientApplication(
+            "client_id",
+            authority="https://login.microsoftonline.com/common",
+            enable_broker_on_mac=True,
+            )
+        self.assertFalse(app._enable_broker)
+
+
+@patch("sys.platform", new="darwin")  # Pretend running on Mac.
+@patch("msal.authority.tenant_discovery", new=Mock(return_value={
+    "authorization_endpoint": "https://contoso.com/placeholder",
+    "token_endpoint": "https://contoso.com/placeholder",
+    }))
+@patch("msal.application._init_broker", new=Mock())  # Pretend pymsalruntime installed and working
+class TestBrokerFallbackWithDifferentAuthorities(unittest.TestCase):
 
     def test_broker_should_be_disabled_by_default(self):
         app = msal.PublicClientApplication(
@@ -787,3 +850,27 @@ class TestBrokerFallback(unittest.TestCa
             )
         self.assertFalse(app._enable_broker)
 
+    def test_app_did_not_register_redirect_uri_should_error_out(self):
+        """Because it is actionable to app developer to add redirect URI"""
+        app = msal.PublicClientApplication(
+            "client_id",
+            authority="https://login.microsoftonline.com/common",
+            enable_broker_on_mac=True,
+            )
+        self.assertTrue(app._enable_broker)
+        with patch.object(
+            # Note: We tried @patch("msal.broker.foo", ...) but it ended up with
+            # "module msal does not have attribute broker"
+            app, "_acquire_token_interactive_via_broker", return_value={
+                "error": "broker_error",
+                "error_description":
+                    "(pii).  "  # pymsalruntime no longer surfaces AADSTS error,
+                                # So MSAL Python can't raise RedirectUriError.
+                    "Status: Response_Status.Status_ApiContractViolation, "
+                    "Error code: 3399614473, Tag 557973642",
+            }):
+            result = app.acquire_token_interactive(
+                ["scope"],
+                parent_window_handle=app.CONSOLE_WINDOW_HANDLE,
+                )
+            self.assertEqual(result.get("error"), "broker_error")
diff -pruN 1.31.1-1/tests/test_authority.py 1.32.0-1/tests/test_authority.py
--- 1.31.1-1/tests/test_authority.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/tests/test_authority.py	2025-03-11 22:49:30.000000000 +0000
@@ -104,32 +104,63 @@ class TestCiamAuthority(unittest.TestCas
     "authorization_endpoint": "https://contoso.com/authorize",
     "token_endpoint": "https://contoso.com/token",
     })
-class TestOidcAuthority(unittest.TestCase):
+class OidcAuthorityTestCase(unittest.TestCase):
+    authority = "https://contoso.com/tenant"
+
+    def setUp(self):
+        # setUp() gives subclass a dynamic setup based on their authority
+        self.oidc_discovery_endpoint = (
+            # MSAL Python always does OIDC Discovery,
+            # not to be confused with Instance Discovery
+            # Here the test is to confirm the OIDC endpoint contains no "/v2.0"
+            self.authority + "/.well-known/openid-configuration")
+
     def test_authority_obj_should_do_oidc_discovery_and_skip_instance_discovery(
             self, oidc_discovery, instance_discovery):
         c = MinimalHttpClient()
-        a = Authority(None, c, oidc_authority_url="https://contoso.com/tenant")
+        a = Authority(None, c, oidc_authority_url=self.authority)
         instance_discovery.assert_not_called()
-        oidc_discovery.assert_called_once_with(
-            "https://contoso.com/tenant/.well-known/openid-configuration", c)
+        oidc_discovery.assert_called_once_with(self.oidc_discovery_endpoint, c)
         self.assertEqual(a.authorization_endpoint, 'https://contoso.com/authorize')
         self.assertEqual(a.token_endpoint, 'https://contoso.com/token')
 
     def test_application_obj_should_do_oidc_discovery_and_skip_instance_discovery(
             self, oidc_discovery, instance_discovery):
         app = msal.ClientApplication(
-            "id",
-            authority=None,
-            oidc_authority="https://contoso.com/tenant",
-            )
+            "id", authority=None, oidc_authority=self.authority)
         instance_discovery.assert_not_called()
         oidc_discovery.assert_called_once_with(
-            "https://contoso.com/tenant/.well-known/openid-configuration",
-            app.http_client)
+            self.oidc_discovery_endpoint, app.http_client)
         self.assertEqual(
             app.authority.authorization_endpoint, 'https://contoso.com/authorize')
         self.assertEqual(app.authority.token_endpoint, 'https://contoso.com/token')
 
+
+class DstsAuthorityTestCase(OidcAuthorityTestCase):
+    # Inherits OidcAuthority's test cases and run them with a dSTS authority
+    authority = (  # dSTS is single tenanted with a tenant placeholder
+        'https://test-instance1-dsts.dsts.core.azure-test.net/dstsv2/common')
+    authorization_endpoint = (
+        "https://some.url.dsts.core.azure-test.net/dstsv2/common/oauth2/authorize")
+    token_endpoint = (
+        "https://some.url.dsts.core.azure-test.net/dstsv2/common/oauth2/token")
+
+    @patch("msal.authority._instance_discovery")
+    @patch("msal.authority.tenant_discovery", return_value={
+        "authorization_endpoint": authorization_endpoint,
+        "token_endpoint": token_endpoint,
+    })  # We need to create new patches (i.e. mocks) for non-inherited test cases
+    def test_application_obj_should_accept_dsts_url_as_an_authority(
+            self, oidc_discovery, instance_discovery):
+        app = msal.ClientApplication("id", authority=self.authority)
+        instance_discovery.assert_not_called()
+        oidc_discovery.assert_called_once_with(
+            self.oidc_discovery_endpoint, app.http_client)
+        self.assertEqual(
+            app.authority.authorization_endpoint, self.authorization_endpoint)
+        self.assertEqual(app.authority.token_endpoint, self.token_endpoint)
+
+
 class TestAuthorityInternalHelperCanonicalize(unittest.TestCase):
 
     def test_canonicalize_tenant_followed_by_extra_paths(self):
diff -pruN 1.31.1-1/tests/test_cloudshell.py 1.32.0-1/tests/test_cloudshell.py
--- 1.31.1-1/tests/test_cloudshell.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.32.0-1/tests/test_cloudshell.py	2025-03-11 22:49:30.000000000 +0000
@@ -0,0 +1,23 @@
+import unittest
+from msal.cloudshell import _scope_to_resource
+
+class TestScopeToResource(unittest.TestCase):
+
+    def test_expected_behaviors(self):
+        for scope, expected_resource in {
+            "https://analysis.windows.net/powerbi/api/foo":
+                "https://analysis.windows.net/powerbi/api",  # A special case
+            "https://pas.windows.net/CheckMyAccess/Linux/.default":
+                "https://pas.windows.net/CheckMyAccess/Linux/.default",  # Special case
+            "https://double-slash.com//scope": "https://double-slash.com/",
+            "https://single-slash.com/scope": "https://single-slash.com",
+            "guid/some/scope": "guid",
+            "6dae42f8-4368-4678-94ff-3960e28e3630/.default":
+                # The real guid of AKS resource
+                # https://learn.microsoft.com/en-us/azure/aks/kubelogin-authentication#how-to-use-kubelogin-with-aks
+                "6dae42f8-4368-4678-94ff-3960e28e3630",
+        }.items():
+            self.assertEqual(_scope_to_resource(scope), expected_resource)
+
+if __name__ == '__main__':
+    unittest.main()
diff -pruN 1.31.1-1/tests/test_e2e.py 1.32.0-1/tests/test_e2e.py
--- 1.31.1-1/tests/test_e2e.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/tests/test_e2e.py	2025-03-11 22:49:30.000000000 +0000
@@ -29,12 +29,9 @@ import msal
 from tests.http_client import MinimalHttpClient, MinimalResponse
 from msal.oauth2cli import AuthCodeReceiver
 from msal.oauth2cli.oidc import decode_part
+from tests.broker_util import is_pymsalruntime_installed
+
 
-try:
-    import pymsalruntime
-    broker_available = True
-except ImportError:
-    broker_available = False
 logger = logging.getLogger(__name__)
 logging.basicConfig(level=logging.DEBUG if "-v" in sys.argv else logging.INFO)
 
@@ -44,6 +41,7 @@ try:
 except ImportError:
     logger.warn("Run pip install -r requirements.txt for optional dependency")
 
+_PYMSALRUNTIME_INSTALLED = is_pymsalruntime_installed()
 _AZURE_CLI = "04b07795-8ddb-461a-bbee-02f9e1bf7b46"
 
 def _get_app_and_auth_code(
@@ -187,19 +185,14 @@ class E2eTestCase(unittest.TestCase):
                 http_client=http_client or MinimalHttpClient(),
             )
         else:
-            # Reuse same test cases, by run them with and without broker
-            try:
-                import pymsalruntime
-                broker_available = True
-            except ImportError:
-                broker_available = False
+            # Reuse same test cases, by running them with and without PyMsalRuntime installed
             return msal.PublicClientApplication(
                 client_id,
                 authority=authority,
                 oidc_authority=oidc_authority,
                 http_client=http_client or MinimalHttpClient(),
-                enable_broker_on_windows=broker_available,
-                enable_broker_on_mac=broker_available,
+                enable_broker_on_windows=_PYMSALRUNTIME_INSTALLED,
+                enable_broker_on_mac=_PYMSALRUNTIME_INSTALLED,
                 )
 
     def _test_username_password(self,
@@ -317,8 +310,13 @@ class E2eTestCase(unittest.TestCase):
     msal.application._is_running_in_cloud_shell(),
     "Manually run this test case from inside Cloud Shell")
 class CloudShellTestCase(E2eTestCase):
-    app = msal.PublicClientApplication("client_id")
     scope_that_requires_no_managed_device = "https://management.core.windows.net/"  # Scopes came from https://msazure.visualstudio.com/One/_git/compute-CloudShell?path=/src/images/agent/env/envconfig.PROD.json&version=GBmaster&_a=contents
+
+    def setUpClass(cls):
+        # Doing it here instead of as a class member,
+        # otherwise its overhead incurs even when running other cases
+        cls.app = msal.PublicClientApplication("client_id")
+
     def test_access_token_should_be_obtained_for_a_supported_scope(self):
         result = self.app.acquire_token_interactive(
             [self.scope_that_requires_no_managed_device], prompt="none")
@@ -476,9 +474,10 @@ def get_lab_app(
     if os.getenv(env_client_id) and os.getenv(env_client_cert_path):
         # id came from https://docs.msidlab.com/accounts/confidentialclient.html
         client_id = os.getenv(env_client_id)
-        # Cert came from https://ms.portal.azure.com/#@microsoft.onmicrosoft.com/asset/Microsoft_Azure_KeyVault/Certificate/https://msidlabs.vault.azure.net/certificates/LabVaultAccessCert
         client_credential = {
-            "private_key_pfx_path": os.getenv(env_client_cert_path),
+            "private_key_pfx_path":
+                # Cert came from https://ms.portal.azure.com/#@microsoft.onmicrosoft.com/asset/Microsoft_Azure_KeyVault/Certificate/https://msidlabs.vault.azure.net/certificates/LabAuth
+                os.getenv(env_client_cert_path),
             "public_certificate": True,  # Opt in for SNI
             }
     elif os.getenv(env_client_id) and os.getenv(env_name2):
@@ -648,19 +647,27 @@ class LabBasedTestCase(E2eTestCase):
                 # Here we just test regional apps won't adversely break OBO
             http_client=None,
             ):
-        # 1. An app obtains a token representing a user, for our mid-tier service
-        pca = msal.PublicClientApplication(
-            config_pca["client_id"], authority=config_pca["authority"],
-            azure_region=azure_region,
-            http_client=http_client or MinimalHttpClient())
-        pca_result = pca.acquire_token_by_username_password(
-            config_pca["username"],
-            config_pca["password"],
-            scopes=config_pca["scope"],
-            )
-        self.assertIsNotNone(
-            pca_result.get("access_token"),
-            "PCA failed to get AT because %s" % json.dumps(pca_result, indent=2))
+        if "client_secret" not in config_pca:
+            # 1.a An app obtains a token representing a user, for our mid-tier service
+            result = msal.PublicClientApplication(
+                config_pca["client_id"], authority=config_pca["authority"],
+                azure_region=azure_region,
+                http_client=http_client or MinimalHttpClient(),
+                ).acquire_token_by_username_password(
+                    config_pca["username"], config_pca["password"],
+                    scopes=config_pca["scope"],
+                )
+        else:  # We repurpose the config_pca to contain client_secret for cca app 1
+            # 1.b An app obtains a token representing itself, for our mid-tier service
+            result = msal.ConfidentialClientApplication(
+                config_pca["client_id"], authority=config_pca["authority"],
+                client_credential=config_pca["client_secret"],
+                azure_region=azure_region,
+                http_client=http_client or MinimalHttpClient(),
+                ).acquire_token_for_client(scopes=config_pca["scope"])
+        assertion = result.get("access_token")
+        self.assertIsNotNone(assertion, "First app failed to get AT. {}".format(
+            json.dumps(result, indent=2)))
 
         # 2. Our mid-tier service uses OBO to obtain a token for downstream service
         cca = msal.ConfidentialClientApplication(
@@ -673,9 +680,9 @@ class LabBasedTestCase(E2eTestCase):
                 # That's fine if OBO app uses short-lived msal instance per session.
                 # Otherwise, the OBO app need to implement a one-cache-per-user setup.
             )
-        cca_result = cca.acquire_token_on_behalf_of(
-            pca_result['access_token'], config_cca["scope"])
-        self.assertNotEqual(None, cca_result.get("access_token"), str(cca_result))
+        cca_result = cca.acquire_token_on_behalf_of(assertion, config_cca["scope"])
+        self.assertIsNotNone(cca_result.get("access_token"), "OBO call failed: {}".format(
+            json.dumps(cca_result, indent=2)))
 
         # 3. Now the OBO app can simply store downstream token(s) in same session.
         #    Alternatively, if you want to persist the downstream AT, and possibly
@@ -684,13 +691,27 @@ class LabBasedTestCase(E2eTestCase):
         #    Assuming you already did that (which is not shown in this test case),
         #    the following part shows one of the ways to obtain an AT from cache.
         username = cca_result.get("id_token_claims", {}).get("preferred_username")
-        if username:  # It means CCA have requested an IDT w/ "profile" scope
-            self.assertEqual(config_cca["username"], username)
         accounts = cca.get_accounts(username=username)
-        assert len(accounts) == 1, "App is expected to partition token cache per user"
-        account = accounts[0]
+        if username is not None:  # It means CCA have requested an IDT w/ "profile" scope
+            assert config_cca["username"] == username, "Incorrect test case configuration"
+            self.assertEqual(1, len(accounts), "App is supposed to partition token cache per user")
+        account = accounts[0]  # Alternatively, cca app could just loop through each account
         result = cca.acquire_token_silent(config_cca["scope"], account)
-        self.assertEqual(cca_result["access_token"], result["access_token"])
+        self.assertTrue(
+            result and result.get("access_token") == cca_result["access_token"],
+            "CCA should hit an access token from cache: {}".format(
+                json.dumps(cca.token_cache._cache, indent=2)))
+        if "refresh_token" in cca_result:
+            result = cca.acquire_token_silent(
+                config_cca["scope"], account=account, force_refresh=True)
+            self.assertTrue(
+                result and "access_token" in result,
+                "CCA should get an AT silently, but we got this instead: {}".format(result))
+            self.assertNotEqual(
+                result["access_token"], cca_result["access_token"],
+                "CCA should get a new AT")
+        else:
+            logger.info("AAD did not issue a RT for OBO flow")
 
     def _test_acquire_token_by_client_secret(
             self, client_id=None, client_secret=None, authority=None, scope=None,
@@ -829,11 +850,13 @@ class WorldWideTestCase(LabBasedTestCase
         config["password"] = self.get_lab_user_secret(config["lab_name"])
         self._test_username_password(**config)
 
+    @unittest.skip("ADFSv3 is decommissioned in our test environment")
     def test_adfs3_fed_user(self):
         config = self.get_lab_user(usertype="federated", federationProvider="ADFSv3")
         config["password"] = self.get_lab_user_secret(config["lab_name"])
         self._test_username_password(**config)
 
+    @unittest.skip("ADFSv2 is decommissioned in our test environment")
     def test_adfs2_fed_user(self):
         config = self.get_lab_user(usertype="federated", federationProvider="ADFSv2")
         config["password"] = self.get_lab_user_secret(config["lab_name"])
@@ -932,6 +955,31 @@ class WorldWideTestCase(LabBasedTestCase
 
         self._test_acquire_token_obo(config_pca, config_cca)
 
+    @unittest.skipUnless(
+        os.path.exists("tests/sp_obo.pem"),
+        "Need a 'tests/sp_obo.pem' private to run OBO for SP test")
+    def test_acquire_token_obo_for_sp(self):
+        authority = "https://login.windows-ppe.net/f686d426-8d16-42db-81b7-ab578e110ccd"
+        with open("tests/sp_obo.pem") as pem:
+            client_secret = {
+                "private_key": pem.read(),
+                "thumbprint": "378938210C976692D7F523B8C4FFBB645D17CE92",
+                }
+        midtier_app = {
+            "authority": authority,
+            "client_id": "c84e9c32-0bc9-4a73-af05-9efe9982a322",
+            "client_secret": client_secret,
+            "scope": ["23d08a1e-1249-4f7c-b5a5-cb11f29b6923/.default"],
+            #"username": "OBO-Client-PPE",  # We do NOT attempt locating initial_app by name
+            }
+        initial_app = {
+            "authority": authority,
+            "client_id": "9793041b-9078-4942-b1d2-babdc472cc0c",
+            "client_secret": client_secret,
+            "scope": [midtier_app["client_id"] + "/.default"],
+            }
+        self._test_acquire_token_obo(initial_app, midtier_app)
+
     def test_acquire_token_by_client_secret(self):
         # Vastly different than ArlingtonCloudTestCase.test_acquire_token_by_client_secret()
         _app = self.get_lab_app_object(
@@ -1130,11 +1178,23 @@ class WorldWideRegionalEndpointTestCase(
     def test_acquire_token_for_client_should_hit_global_endpoint_by_default(self):
         self._test_acquire_token_for_client(None, None)
 
-    def test_acquire_token_for_client_should_ignore_env_var_by_default(self):
+    def test_acquire_token_for_client_should_ignore_env_var_region_name_by_default(self):
         os.environ["REGION_NAME"] = "eastus"
         self._test_acquire_token_for_client(None, None)
         del os.environ["REGION_NAME"]
 
+    @patch.dict(os.environ, {"MSAL_FORCE_REGION": "eastus"})
+    def test_acquire_token_for_client_should_use_env_var_msal_force_region_by_default(self):
+        self._test_acquire_token_for_client(None, "eastus")
+
+    @patch.dict(os.environ, {"MSAL_FORCE_REGION": "eastus"})
+    def test_acquire_token_for_client_should_prefer_the_explicit_region(self):
+        self._test_acquire_token_for_client("westus", "westus")
+
+    @patch.dict(os.environ, {"MSAL_FORCE_REGION": "eastus"})
+    def test_acquire_token_for_client_should_allow_opt_out_env_var_msal_force_region(self):
+        self._test_acquire_token_for_client(False, None)
+
     def test_acquire_token_for_client_should_use_a_specified_region(self):
         self._test_acquire_token_for_client("westus", "westus")
 
@@ -1247,7 +1307,7 @@ class ArlingtonCloudTestCase(LabBasedTes
         #       it means MSAL Python is not affected by that.
 
 
-@unittest.skipUnless(broker_available, "AT POP feature is only supported by using broker")
+@unittest.skipUnless(_PYMSALRUNTIME_INSTALLED, "AT POP feature is only supported by using broker")
 class PopTestCase(LabBasedTestCase):
     def test_at_pop_should_contain_pop_scheme_content(self):
         auth_scheme = msal.PopAuthScheme(
@@ -1309,8 +1369,19 @@ class PopTestCase(LabBasedTestCase):
         # and then fallback to bearer token code path.
         # We skip it here because this test case has not yet initialize self.app
         # assert self.app.is_pop_supported()
+
         api_endpoint = "https://20.190.132.47/beta/me"
-        resp = requests.get(api_endpoint, verify=False)
+        verify = True  # Hopefully this will make CodeQL happy
+        if verify:
+            self.skipTest("""
+            The api_endpoint is for test only and has no proper SSL certificate,
+            so you would have to disable SSL certificate checks and run this test case manually.
+            We tried suppressing the CodeQL warning by adding this in the proper places
+                @suppress py/bandit/requests-ssl-verify-disabled
+            but it did not work.
+            """)
+        # @suppress py/bandit/requests-ssl-verify-disabled
+        resp = requests.get(api_endpoint, verify=verify)  # CodeQL [SM03157]
         self.assertEqual(resp.status_code, 401, "Initial call should end with an http 401 error")
         result = self._get_shr_pop(**dict(
             self.get_lab_user(usertype="cloud"),  # This is generally not the current laptop's default AAD account
@@ -1321,7 +1392,11 @@ class PopTestCase(LabBasedTestCase):
                 nonce=self._extract_pop_nonce(resp.headers.get("WWW-Authenticate")),
                 ),
             ))
-        resp = requests.get(api_endpoint, verify=False, headers={
+        resp = requests.get(
+            api_endpoint,
+            # CodeQL [SM03157]
+            verify=verify,  # @suppress py/bandit/requests-ssl-verify-disabled
+            headers={
             "Authorization": "pop {}".format(result["access_token"]),
             })
         self.assertEqual(resp.status_code, 200, "POP resource should be accessible")
diff -pruN 1.31.1-1/tests/test_mi.py 1.32.0-1/tests/test_mi.py
--- 1.31.1-1/tests/test_mi.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/tests/test_mi.py	2025-03-11 22:49:30.000000000 +0000
@@ -121,13 +121,29 @@ class ClientTestCase(unittest.TestCase):
 
 class VmTestCase(ClientTestCase):
 
-    def test_happy_path(self):
+    def _test_happy_path(self) -> callable:
         expires_in = 7890  # We test a bigger than 7200 value here
         with patch.object(self.app._http_client, "get", return_value=MinimalResponse(
             status_code=200,
             text='{"access_token": "AT", "expires_in": "%s", "resource": "R"}' % expires_in,
         )) as mocked_method:
-            self._test_happy_path(self.app, mocked_method, expires_in)
+            super(VmTestCase, self)._test_happy_path(self.app, mocked_method, expires_in)
+            return mocked_method
+
+    def test_happy_path_of_vm(self):
+        self._test_happy_path().assert_called_with(
+            'http://169.254.169.254/metadata/identity/oauth2/token',
+            params={'api-version': '2018-02-01', 'resource': 'R'},
+            headers={'Metadata': 'true'},
+            )
+
+    @patch.dict(os.environ, {"AZURE_POD_IDENTITY_AUTHORITY_HOST": "http://localhost:1234//"})
+    def test_happy_path_of_pod_identity(self):
+        self._test_happy_path().assert_called_with(
+            'http://localhost:1234/metadata/identity/oauth2/token',
+            params={'api-version': '2018-02-01', 'resource': 'R'},
+            headers={'Metadata': 'true'},
+            )
 
     def test_vm_error_should_be_returned_as_is(self):
         raw_error = '{"raw": "error format is undefined"}'
diff -pruN 1.31.1-1/tests/test_token_cache.py 1.32.0-1/tests/test_token_cache.py
--- 1.31.1-1/tests/test_token_cache.py	2024-11-01 04:01:25.000000000 +0000
+++ 1.32.0-1/tests/test_token_cache.py	2025-03-11 22:49:30.000000000 +0000
@@ -3,7 +3,7 @@ import base64
 import json
 import time
 
-from msal.token_cache import *
+from msal.token_cache import TokenCache, SerializableTokenCache
 from tests import unittest
 
 
@@ -51,11 +51,14 @@ class TokenCacheTestCase(unittest.TestCa
 
     def setUp(self):
         self.cache = TokenCache()
+        self.at_key_maker = self.cache.key_makers[
+            TokenCache.CredentialType.ACCESS_TOKEN]
 
     def testAddByAad(self):
         client_id = "my_client_id"
         id_token = build_id_token(
             oid="object1234", preferred_username="John Doe", aud=client_id)
+        now = 1000
         self.cache.add({
             "client_id": client_id,
             "scope": ["s2", "s1", "s3"],  # Not in particular order
@@ -64,7 +67,7 @@ class TokenCacheTestCase(unittest.TestCa
                 uid="uid", utid="utid",  # client_info
                 expires_in=3600, access_token="an access token",
                 id_token=id_token, refresh_token="a refresh token"),
-            }, now=1000)
+            }, now=now)
         access_token_entry = {
                 'cached_at': "1000",
                 'client_id': 'my_client_id',
@@ -78,14 +81,11 @@ class TokenCacheTestCase(unittest.TestCa
                 'target': 's1 s2 s3',  # Sorted
                 'token_type': 'some type',
             }
-        self.assertEqual(
-            access_token_entry,
-            self.cache._cache["AccessToken"].get(
-                'uid.utid-login.example.com-accesstoken-my_client_id-contoso-s1 s2 s3')
-            )
+        self.assertEqual(access_token_entry, self.cache._cache["AccessToken"].get(
+            self.at_key_maker(**access_token_entry)))
         self.assertIn(
             access_token_entry,
-            self.cache.find(self.cache.CredentialType.ACCESS_TOKEN),
+            self.cache.find(self.cache.CredentialType.ACCESS_TOKEN, now=now),
             "find(..., query=None) should not crash, even though MSAL does not use it")
         self.assertEqual(
             {
@@ -144,8 +144,7 @@ class TokenCacheTestCase(unittest.TestCa
                 expires_in=3600, access_token="an access token",
                 id_token=id_token, refresh_token="a refresh token"),
             }, now=1000)
-        self.assertEqual(
-            {
+        access_token_entry = {
                 'cached_at': "1000",
                 'client_id': 'my_client_id',
                 'credential_type': 'AccessToken',
@@ -157,10 +156,9 @@ class TokenCacheTestCase(unittest.TestCa
                 'secret': 'an access token',
                 'target': 's1 s2 s3',  # Sorted
                 'token_type': 'some type',
-            },
-            self.cache._cache["AccessToken"].get(
-                'subject-fs.msidlab8.com-accesstoken-my_client_id-adfs-s1 s2 s3')
-            )
+            }
+        self.assertEqual(access_token_entry, self.cache._cache["AccessToken"].get(
+            self.at_key_maker(**access_token_entry)))
         self.assertEqual(
             {
                 'client_id': 'my_client_id',
@@ -206,37 +204,67 @@ class TokenCacheTestCase(unittest.TestCa
                 "appmetadata-fs.msidlab8.com-my_client_id")
             )
 
-    def test_key_id_is_also_recorded(self):
-        my_key_id = "some_key_id_123"
+    def assertFoundAccessToken(self, *, scopes, query, data=None, now=None):
+        cached_at = None
+        for cached_at in self.cache.search(
+                TokenCache.CredentialType.ACCESS_TOKEN,
+                target=scopes, query=query, now=now,
+        ):
+            for k, v in (data or {}).items():  # The extra data, if any
+                self.assertEqual(cached_at.get(k), v, f"AT should contain {k}={v}")
+        self.assertTrue(cached_at, "AT should be cached and searchable")
+        return cached_at
+
+    def _test_data_should_be_saved_and_searchable_in_access_token(self, data):
+        scopes = ["s2", "s1", "s3"]  # Not in particular order
+        now = 1000
         self.cache.add({
-            "data": {"key_id": my_key_id},
+            "data": data,
             "client_id": "my_client_id",
-            "scope": ["s2", "s1", "s3"],  # Not in particular order
+            "scope": scopes,
             "token_endpoint": "https://login.example.com/contoso/v2/token",
             "response": build_response(
                 uid="uid", utid="utid",  # client_info
                 expires_in=3600, access_token="an access token",
                 refresh_token="a refresh token"),
-            }, now=1000)
-        cached_key_id = self.cache._cache["AccessToken"].get(
-            'uid.utid-login.example.com-accesstoken-my_client_id-contoso-s1 s2 s3',
-            {}).get("key_id")
-        self.assertEqual(my_key_id, cached_key_id, "AT should be bound to the key")
+            }, now=now)
+        self.assertFoundAccessToken(scopes=scopes, data=data, now=now, query=dict(
+            data,  # Also use the extra data as a query criteria
+            client_id="my_client_id",
+            environment="login.example.com",
+            realm="contoso",
+            home_account_id="uid.utid",
+        ))
+
+    def test_extra_data_should_also_be_recorded_and_searchable_in_access_token(self):
+        self._test_data_should_be_saved_and_searchable_in_access_token({"key_id": "1"})
+
+    def test_access_tokens_with_different_key_id(self):
+        self._test_data_should_be_saved_and_searchable_in_access_token({"key_id": "1"})
+        self._test_data_should_be_saved_and_searchable_in_access_token({"key_id": "2"})
+        self.assertEqual(
+            len(self.cache._cache["AccessToken"]),
+            1, """Historically, tokens are not keyed by key_id,
+so a new token overwrites the old one, and we would end up with 1 token in cache""")
 
     def test_refresh_in_should_be_recorded_as_refresh_on(self):  # Sounds weird. Yep.
+        scopes = ["s2", "s1", "s3"]  # Not in particular order
         self.cache.add({
             "client_id": "my_client_id",
-            "scope": ["s2", "s1", "s3"],  # Not in particular order
+            "scope": scopes,
             "token_endpoint": "https://login.example.com/contoso/v2/token",
             "response": build_response(
                 uid="uid", utid="utid",  # client_info
                 expires_in=3600, refresh_in=1800, access_token="an access token",
                 ),  #refresh_token="a refresh token"),
             }, now=1000)
-        refresh_on = self.cache._cache["AccessToken"].get(
-            'uid.utid-login.example.com-accesstoken-my_client_id-contoso-s1 s2 s3',
-            {}).get("refresh_on")
-        self.assertEqual("2800", refresh_on, "Should save refresh_on")
+        at = self.assertFoundAccessToken(scopes=scopes, query=dict(
+            client_id="my_client_id",
+            environment="login.example.com",
+            realm="contoso",
+            home_account_id="uid.utid",
+        ))
+        self.assertEqual("2800", at.get("refresh_on"), "Should save refresh_on")
 
     def test_old_rt_data_with_wrong_key_should_still_be_salvaged_into_new_rt(self):
         sample = {
@@ -258,7 +286,7 @@ class TokenCacheTestCase(unittest.TestCa
             )
 
 
-class SerializableTokenCacheTestCase(TokenCacheTestCase):
+class SerializableTokenCacheTestCase(unittest.TestCase):
     # Run all inherited test methods, and have extra check in tearDown()
 
     def setUp(self):
