diff -pruN 1.31.0-1/debian/changelog 1.31.1-1/debian/changelog
--- 1.31.0-1/debian/changelog	2024-09-10 10:22:28.000000000 +0000
+++ 1.31.1-1/debian/changelog	2024-11-21 23:22:27.000000000 +0000
@@ -1,3 +1,10 @@
+microsoft-authentication-library-for-python (1.31.1-1) unstable; urgency=medium
+
+  * Update upstream source from tag 'upstream/1.31.1'
+  * Use d/clean instead of manual rm
+
+ -- Luca Boccassi <bluca@debian.org>  Thu, 21 Nov 2024 23:22:27 +0000
+
 microsoft-authentication-library-for-python (1.31.0-1) unstable; urgency=medium
 
   * Update upstream source from tag 'upstream/1.31.0'
diff -pruN 1.31.0-1/debian/clean 1.31.1-1/debian/clean
--- 1.31.0-1/debian/clean	1970-01-01 00:00:00.000000000 +0000
+++ 1.31.1-1/debian/clean	2024-11-21 23:21:49.000000000 +0000
@@ -0,0 +1,3 @@
+docs/_build
+docs/api
+msal.egg-info
diff -pruN 1.31.0-1/debian/rules 1.31.1-1/debian/rules
--- 1.31.0-1/debian/rules	2023-06-14 00:09:26.000000000 +0000
+++ 1.31.1-1/debian/rules	2024-11-21 23:21:54.000000000 +0000
@@ -1,7 +1,5 @@
 #!/usr/bin/make -f
 
-export PYBUILD_AFTER_CLEAN=rm -rf msal.egg-info docs/_build docs/api
-
 %:
 	dh $@ --buildsystem=pybuild
 
diff -pruN 1.31.0-1/msal/application.py 1.31.1-1/msal/application.py
--- 1.31.0-1/msal/application.py	2024-09-06 15:51:45.000000000 +0000
+++ 1.31.1-1/msal/application.py	2024-11-01 04:01:25.000000000 +0000
@@ -21,7 +21,7 @@ from .cloudshell import _is_running_in_c
 
 
 # The __init__.py will import this. Not the other way around.
-__version__ = "1.31.0"  # When releasing, also check and bump our dependencies's versions if needed
+__version__ = "1.31.1"  # When releasing, also check and bump our dependencies's versions if needed
 
 logger = logging.getLogger(__name__)
 _AUTHORITY_TYPE_CLOUDSHELL = "CLOUDSHELL"
diff -pruN 1.31.0-1/msal/managed_identity.py 1.31.1-1/msal/managed_identity.py
--- 1.31.0-1/msal/managed_identity.py	2024-09-06 15:51:45.000000000 +0000
+++ 1.31.1-1/msal/managed_identity.py	2024-11-01 04:01:25.000000000 +0000
@@ -346,10 +346,12 @@ def _scope_to_resource(scope):  # This i
 def _get_arc_endpoint():
     if "IDENTITY_ENDPOINT" in os.environ and "IMDS_ENDPOINT" in os.environ:
         return os.environ["IDENTITY_ENDPOINT"]
-    if (  # Defined in https://msazure.visualstudio.com/One/_wiki/wikis/One.wiki/233012/VM-Extension-Authoring-for-Arc?anchor=determining-which-endpoint-to-use
-        sys.platform == "linux" and os.path.exists("/var/opt/azcmagent/bin/himds")
+    if (  # Defined in https://eng.ms/docs/cloud-ai-platform/azure-core/azure-management-and-platforms/control-plane-bburns/hybrid-resource-provider/azure-arc-for-servers/specs/extension_authoring
+        sys.platform == "linux" and os.path.exists("/opt/azcmagent/bin/himds")
         or sys.platform == "win32" and os.path.exists(os.path.expandvars(
-            r"%ProgramFiles%\AzureConnectedMachineAgent\himds.exe"))
+            # Avoid Windows-only "%EnvVar%" syntax so that tests can be run on Linux
+            r"${ProgramFiles}\AzureConnectedMachineAgent\himds.exe"
+        ))
     ):
         return "http://localhost:40342/metadata/identity/oauth2/token"
 
diff -pruN 1.31.0-1/tests/test_mi.py 1.31.1-1/tests/test_mi.py
--- 1.31.0-1/tests/test_mi.py	2024-09-06 15:51:45.000000000 +0000
+++ 1.31.1-1/tests/test_mi.py	2024-11-01 04:01:25.000000000 +0000
@@ -347,9 +347,23 @@ class GetManagedIdentitySourceTestCase(u
         "IDENTITY_ENDPOINT": "http://localhost",
         "IMDS_ENDPOINT": "http://localhost",
     })
-    def test_arc(self):
+    def test_arc_by_env_var(self):
         self.assertEqual(get_managed_identity_source(), AZURE_ARC)
 
+    @patch("msal.managed_identity.os.path.exists", return_value=True)
+    @patch("msal.managed_identity.sys.platform", new="linux")
+    def test_arc_by_file_existence_on_linux(self, mocked_exists):
+        self.assertEqual(get_managed_identity_source(), AZURE_ARC)
+        mocked_exists.assert_called_with("/opt/azcmagent/bin/himds")
+
+    @patch("msal.managed_identity.os.path.exists", return_value=True)
+    @patch("msal.managed_identity.sys.platform", new="win32")
+    @patch.dict(os.environ, {"ProgramFiles": "C:\Program Files"})
+    def test_arc_by_file_existence_on_windows(self, mocked_exists):
+        self.assertEqual(get_managed_identity_source(), AZURE_ARC)
+        mocked_exists.assert_called_with(
+            r"C:\Program Files\AzureConnectedMachineAgent\himds.exe")
+
     @patch.dict(os.environ, {
         "AZUREPS_HOST_ENVIRONMENT": "cloud-shell-foo",
     })
