diff -pruN 1.2.0-1/.github/workflows/python-package.yml 1.3.1-1/.github/workflows/python-package.yml
--- 1.2.0-1/.github/workflows/python-package.yml	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/.github/workflows/python-package.yml	2025-03-14 23:39:03.000000000 +0000
@@ -17,19 +17,9 @@ jobs:
     strategy:
       fail-fast: false
       matrix:
-        python-version: [3.7, 3.8, 3.9, "3.10", 3.11, 3.12]
+        python-version: [3.9, "3.10", 3.11, 3.12, "3.13"]
         os: [ubuntu-latest, windows-latest, macos-latest]
-        exclude:  # https://github.com/actions/runner-images/issues/9770#issuecomment-2085623315
-          # Apple Silicon ARM64 does not support Python < v3.8
-          - python-version: "3.7"
-            os: macos-latest
         include:  # https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions#using-environment-variables-in-a-matrix
-          - # Run those legacy versions on macos13 runner which uses Intel CPUs
-            python-version: 3.7
-            toxenv: "py37"
-            os: macos-13
-          - python-version: 3.8
-            toxenv: "py38"
           - python-version: 3.9
             toxenv: "py39"
           - python-version: "3.10"
@@ -38,6 +28,8 @@ jobs:
             toxenv: "py311"
           - python-version: 3.12
             toxenv: "py312"
+          - python-version: "3.13"
+            toxenv: "py313"
           - python-version: 3.9
             os: ubuntu-latest
             lint: "true"
@@ -48,16 +40,16 @@ jobs:
       with:
         python-version: ${{ matrix.python-version }}
         cache: 'pip'
-    - name: Install Linux dependencies for Python 2
-      if: ${{ matrix.os == 'ubuntu-latest' && matrix.python-version == '2.7' }}
-      run: |
-        sudo apt update
-        sudo apt install python-dev libgirepository1.0-dev libcairo2-dev gir1.2-secret-1 gnome-keyring
     - name: Install Linux dependencies for Python 3
-      if: ${{ matrix.os == 'ubuntu-latest' && matrix.python-version != '2.7' }}
+      if: ${{ matrix.os == 'ubuntu-latest' }}
       run: |
         sudo apt update
-        sudo apt install python3-dev libgirepository1.0-dev libcairo2-dev gir1.2-secret-1 gnome-keyring
+        # girepository-2.0 becomes necessary since PyGobject 3.51 https://pygobject.gnome.org/changelog.html#pre-release
+        sudo apt install -y python3-dev libgirepository-2.0-dev libcairo2-dev gir1.2-secret-1 gnome-keyring
+        # The line above is different than the PyGObject install instructions:
+        #   https://pygobject.gnome.org/getting_started.html#ubuntu-logo-ubuntu-debian-logo-debian
+        # because we chose to specify the exact dependencies (secret and keyring)
+        # rather than using the much larger gtk.
     - name: Install Python dependencies
       run: |
         python -m pip install --upgrade pip
diff -pruN 1.2.0-1/.gitignore 1.3.1-1/.gitignore
--- 1.2.0-1/.gitignore	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/.gitignore	2025-03-14 23:39:03.000000000 +0000
@@ -334,3 +334,5 @@ ASALocalRun/
 .mfractor/
 
 .eggs/
+.env
+Session.vim
diff -pruN 1.2.0-1/Dockerfile 1.3.1-1/Dockerfile
--- 1.2.0-1/Dockerfile	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/Dockerfile	2025-03-14 23:39:03.000000000 +0000
@@ -1,6 +1,7 @@
 # TODO: Can this Dockerfile use multi-stage build?
+# https://testdriven.io/tips/6da2d9c9-8849-4386-b7f9-13b28514ded8/
 # Final size 690MB. (It would be 1.16 GB if started with python:3 as base)
-FROM python:3.12-slim
+FROM python:3.13-slim
 
 # Install Generic PyGObject (sans GTK)
 #The following somehow won't work:
@@ -9,7 +10,6 @@ RUN apt-get update && apt-get install -y
   libcairo2-dev \
   libgirepository1.0-dev \
   python3-dev
-RUN pip install "pygobject>=3,<4"
 
 # Install MSAL Extensions dependencies
 # Don't know how to get container talk to dbus on host,
@@ -19,10 +19,10 @@ RUN apt-get install -y \
   gnome-keyring
 
 # Not strictly necessary, but we include a pytest (which is only 3MB) to facilitate testing.
-RUN pip install "pytest>=6,<7"
+RUN pip install "pygobject>=3,<4" "pytest>=6,<7"
 
 # Install MSAL Extensions. Upgrade the pinned version number to trigger a new image build.
-RUN pip install "msal-extensions==1.1"
+RUN pip install "msal-extensions==1.2"
 
 # This setup is inspired from https://github.com/jaraco/keyring#using-keyring-on-headless-linux-systems-in-a-docker-container
 ENTRYPOINT ["dbus-run-session", "--"]
diff -pruN 1.2.0-1/README.md 1.3.1-1/README.md
--- 1.2.0-1/README.md	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/README.md	2025-03-14 23:39:03.000000000 +0000
@@ -3,7 +3,7 @@
 
 The Microsoft Authentication Extensions for Python offers secure mechanisms for client applications to perform cross-platform token cache serialization and persistence. It gives additional support to the [Microsoft Authentication Library for Python (MSAL)](https://github.com/AzureAD/microsoft-authentication-library-for-python).
 
-MSAL Python supports an in-memory cache by default and provides the [SerializableTokenCache](https://msal-python.readthedocs.io/en/latest/#msal.SerializableTokenCache) to perform cache serialization. You can read more about this in the MSAL Python [documentation](https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-python-token-cache-serialization). Developers are required to implement their own cache persistance across multiple platforms and Microsoft Authentication Extensions makes this simpler.
+MSAL Python supports an in-memory cache by default and provides the [SerializableTokenCache](https://msal-python.readthedocs.io/en/latest/#msal.SerializableTokenCache) to perform cache serialization. You can read more about this in the MSAL Python [documentation](https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-python-token-cache-serialization). Developers are required to implement their own cache persistence across multiple platforms and Microsoft Authentication Extensions makes this simpler.
 
 The supported platforms are Windows, Mac and Linux.
 - Windows - [DPAPI](https://docs.microsoft.com/en-us/dotnet/standard/security/how-to-use-data-protection) is used for encryption.
diff -pruN 1.2.0-1/debian/changelog 1.3.1-1/debian/changelog
--- 1.2.0-1/debian/changelog	2024-08-07 12:05:43.000000000 +0000
+++ 1.3.1-1/debian/changelog	2025-03-15 11:37:53.000000000 +0000
@@ -1,3 +1,11 @@
+microsoft-authentication-extensions-for-python (1.3.1-1) unstable; urgency=medium
+
+  * Update upstream source from tag 'upstream/1.3.1'
+  * d/control: bump Standards-Version to 4.7.2, no changes
+  * Skip new failing test due to network access
+
+ -- Luca Boccassi <bluca@debian.org>  Sat, 15 Mar 2025 11:37:53 +0000
+
 microsoft-authentication-extensions-for-python (1.2.0-1) unstable; urgency=medium
 
   * d/watch: use uversionmangle to sort x.ybz as x.y~bz for beta releases
diff -pruN 1.2.0-1/debian/control 1.3.1-1/debian/control
--- 1.2.0-1/debian/control	2024-08-07 12:05:34.000000000 +0000
+++ 1.3.1-1/debian/control	2025-03-15 11:37:23.000000000 +0000
@@ -12,7 +12,7 @@ Build-Depends: debhelper-compat (= 13),
                python3-portalocker,
                python3-pytest <!nocheck>,
                python3-setuptools,
-Standards-Version: 4.7.0
+Standards-Version: 4.7.2
 Section: python
 Priority: optional
 Rules-Requires-Root: no
diff -pruN 1.2.0-1/debian/rules 1.3.1-1/debian/rules
--- 1.2.0-1/debian/rules	2024-08-07 12:05:43.000000000 +0000
+++ 1.3.1-1/debian/rules	2025-03-15 11:37:53.000000000 +0000
@@ -2,6 +2,7 @@
 
 export PYBUILD_TEST_ARGS=-v --deselect=.pybuild/cpython3_{version}/build/tests/test_persistence.py::test_libsecret_persistence \
 	--deselect=.pybuild/cpython3_{version}/build/tests/test_agnostic_backend.py::test_current_platform_cache_roundtrip_with_persistence_builder \
+	--deselect=.pybuild/cpython3_{version}/build/tests/test_agnostic_backend.py::test_token_cache_roundtrip_with_file_persistence \
 	--deselect=.pybuild/cpython3_{version}/build/tests/test_agnostic_backend.py::test_token_cache_roundtrip_with_persistence_builder \
 	--deselect=.pybuild/cpython3_{version}/build/tests/test_persistence.py::test_nonexistent_libsecret_persistence
 
diff -pruN 1.2.0-1/debian/tests/python3-tests 1.3.1-1/debian/tests/python3-tests
--- 1.2.0-1/debian/tests/python3-tests	2024-08-07 12:05:43.000000000 +0000
+++ 1.3.1-1/debian/tests/python3-tests	2025-03-15 11:37:53.000000000 +0000
@@ -10,6 +10,7 @@ cd "${AUTOPKGTEST_TMP}"
 for p in $(py3versions -s); do
     "${p}" -m pytest -v --deselect=tests/test_persistence.py::test_libsecret_persistence \
         --deselect=tests/test_agnostic_backend.py::test_current_platform_cache_roundtrip_with_persistence_builder \
+        --deselect=tests/test_agnostic_backend.py::test_token_cache_roundtrip_with_file_persistence \
         --deselect=tests/test_agnostic_backend.py::test_token_cache_roundtrip_with_persistence_builder \
         --deselect=tests/test_persistence.py::test_nonexistent_libsecret_persistence
 done
diff -pruN 1.2.0-1/docker_run.sh 1.3.1-1/docker_run.sh
--- 1.2.0-1/docker_run.sh	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/docker_run.sh	2025-03-14 23:39:03.000000000 +0000
@@ -6,11 +6,10 @@ docker build -t $IMAGE_NAME - < Dockerfi
 echo "==== Integration Test for Persistence on Linux (libsecret) ===="
 echo "After seeing the bash prompt, run the following to test encryption on Linux:"
 echo "    pip install -e ."
-echo "    pytest -s tests/chosen_test_file.py"
-echo "Note that you probably need to set up ENV VAR for the test cases to run"
+echo "    pytest --capture=no -s tests/chosen_test_file.py"
+echo "Note: It will test portalocker-based lock when portalocker is installed, or test file-based lock otherwise."
 docker run --rm -it \
     --privileged \
-    --env-file .env \
     -w /home -v $PWD:/home \
     $IMAGE_NAME \
     $1
diff -pruN 1.2.0-1/msal_extensions/__init__.py 1.3.1-1/msal_extensions/__init__.py
--- 1.2.0-1/msal_extensions/__init__.py	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/msal_extensions/__init__.py	2025-03-14 23:39:03.000000000 +0000
@@ -1,5 +1,5 @@
 """Provides auxiliary functionality to the `msal` package."""
-__version__ = "1.2.0"  # Note: During/after release, copy this number to Dockerfile
+__version__ = "1.3.1"  # Note: During/after release, copy this number to Dockerfile
 
 from .persistence import (
     FilePersistence,
@@ -8,6 +8,5 @@ from .persistence import (
     KeychainPersistence,
     LibsecretPersistence,
     )
-from .cache_lock import CrossPlatLock
-from .token_cache import PersistedTokenCache
+from .token_cache import PersistedTokenCache, CrossPlatLock, LockError
 
diff -pruN 1.2.0-1/msal_extensions/cache_lock.py 1.3.1-1/msal_extensions/cache_lock.py
--- 1.2.0-1/msal_extensions/cache_lock.py	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/msal_extensions/cache_lock.py	2025-03-14 23:39:03.000000000 +0000
@@ -5,12 +5,15 @@ import errno
 import time
 import logging
 
-import portalocker
+import portalocker  # pylint: disable=import-error
 
 
 logger = logging.getLogger(__name__)
 
 
+LockError = portalocker.exceptions.LockException
+
+
 class CrossPlatLock(object):
     """Offers a mechanism for waiting until another process is finished interacting with a shared
     resource. This is specifically written to interact with a class of the same name in the .NET
diff -pruN 1.2.0-1/msal_extensions/filelock.py 1.3.1-1/msal_extensions/filelock.py
--- 1.2.0-1/msal_extensions/filelock.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.3.1-1/msal_extensions/filelock.py	2025-03-14 23:39:03.000000000 +0000
@@ -0,0 +1,62 @@
+"""A cross-process lock based on exclusive creation of a given file name"""
+import os
+import sys
+import errno
+import time
+import logging
+
+
+logger = logging.getLogger(__name__)
+
+
+class LockError(RuntimeError):
+    """It will be raised when unable to obtain a lock"""
+
+
+class CrossPlatLock(object):
+    """This implementation relies only on ``open(..., 'x')``"""
+    def __init__(self, lockfile_path):
+        self._lockpath = lockfile_path
+
+    def __enter__(self):
+        self._create_lock_file('{} {}'.format(
+            os.getpid(),
+            sys.argv[0],
+            ).encode('utf-8'))  # pylint: disable=consider-using-f-string
+        return self
+
+    def _create_lock_file(self, content):
+        timeout = 5
+        check_interval = 0.25
+        current_time = getattr(time, "monotonic", time.time)
+        timeout_end = current_time() + timeout
+        while timeout_end > current_time():
+            try:
+                with open(self._lockpath, 'xb') as lock_file:  # pylint: disable=unspecified-encoding
+                    lock_file.write(content)
+                return None  # Happy path
+            except ValueError:  # This needs to be the first clause, for Python 2 to hit it
+                raise LockError("Python 2 does not support atomic creation of file")
+            except FileExistsError:  # Only Python 3 will reach this clause
+                logger.debug(
+                    "Process %d found existing lock file, will retry after %f second",
+                    os.getpid(), check_interval)
+                time.sleep(check_interval)
+        raise LockError(
+            "Unable to obtain lock, despite trying for {} second(s). "
+            "You may want to manually remove the stale lock file {}".format(
+                timeout,
+                self._lockpath,
+            ))
+
+    def __exit__(self, *args):
+        try:
+            os.remove(self._lockpath)
+        except OSError as ex:  # pylint: disable=invalid-name
+            if ex.errno in (errno.ENOENT, errno.EACCES):
+                # Probably another process has raced this one
+                # and ended up clearing or locking the file for itself.
+                logger.debug("Unable to remove lock file")
+            else:
+                raise
+
diff -pruN 1.2.0-1/msal_extensions/libsecret.py 1.3.1-1/msal_extensions/libsecret.py
--- 1.2.0-1/msal_extensions/libsecret.py	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/msal_extensions/libsecret.py	2025-03-14 23:39:03.000000000 +0000
@@ -40,7 +40,7 @@ except (ValueError, ImportError) as ex:
 class LibSecretAgent(object):
     """A loader/saver built on top of low-level libsecret"""
     # Inspired by https://developer.gnome.org/libsecret/unstable/py-examples.html
-    def __init__(  # pylint: disable=too-many-arguments
+    def __init__(  # pylint: disable=too-many-arguments,too-many-positional-arguments
             self,
             schema_name,
             attributes,  # {"name": "value", ...}
diff -pruN 1.2.0-1/msal_extensions/token_cache.py 1.3.1-1/msal_extensions/token_cache.py
--- 1.2.0-1/msal_extensions/token_cache.py	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/msal_extensions/token_cache.py	2025-03-14 23:39:03.000000000 +0000
@@ -5,7 +5,13 @@ import logging
 
 import msal
 
-from .cache_lock import CrossPlatLock
+try:  # It needs portalocker
+    from .cache_lock import (  # pylint: disable=unused-import
+        CrossPlatLock,
+        LockError,  # We don't use LockError in this file, but __init__.py uses it.
+        )
+except ImportError:  # Falls back to file-based lock
+    from .filelock import CrossPlatLock, LockError  # pylint: disable=unused-import
 from .persistence import _mkdir_p, PersistenceNotFound
 
 
diff -pruN 1.2.0-1/setup.py 1.3.1-1/setup.py
--- 1.2.0-1/setup.py	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/setup.py	2025-03-14 23:39:03.000000000 +0000
@@ -13,17 +13,21 @@ long_description = open('README.md').rea
 setup(
     name='msal-extensions',
     version=__version__,
-    packages=find_packages(),
+    packages=find_packages(exclude=["tests"]),
     long_description=long_description,
     long_description_content_type="text/markdown",
     package_data={'': ['LICENSE']},
-    python_requires=">=3.7",
+    python_requires=">=3.9",
     install_requires=[
         'msal>=1.29,<2',  # Use TokenCache.search() from MSAL Python 1.29+
-        'portalocker<3,>=1.4',
 
         ## We choose to NOT define a hard dependency on this.
         # "pygobject>=3,<4;platform_system=='Linux'",
     ],
+    extras_require={
+        "portalocker": [
+            'portalocker<4,>=1.4',
+        ],
+    },
     tests_require=['pytest'],
 )
diff -pruN 1.2.0-1/tests/cache_file_generator.py 1.3.1-1/tests/cache_file_generator.py
--- 1.2.0-1/tests/cache_file_generator.py	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/tests/cache_file_generator.py	2025-03-14 23:39:03.000000000 +0000
@@ -14,9 +14,10 @@ import os
 import sys
 import time
 
-from portalocker import exceptions
+from msal_extensions import FilePersistence, CrossPlatLock, LockError
 
-from msal_extensions import FilePersistence, CrossPlatLock
+
+print("Testing with {}".format(CrossPlatLock))
 
 
 def _acquire_lock_and_write_to_cache(cache_location, sleep_interval):
@@ -31,7 +32,7 @@ def _acquire_lock_and_write_to_cache(cac
             time.sleep(sleep_interval)
             data += "> " + str(os.getpid()) + "\n"
             cache_accessor.save(data)
-    except exceptions.LockException as e:
+    except LockError as e:
         logging.warning("Unable to acquire lock %s", e)
 
 
diff -pruN 1.2.0-1/tests/http_client.py 1.3.1-1/tests/http_client.py
--- 1.2.0-1/tests/http_client.py	1970-01-01 00:00:00.000000000 +0000
+++ 1.3.1-1/tests/http_client.py	2025-03-14 23:39:03.000000000 +0000
@@ -0,0 +1,12 @@
+class MinimalResponse(object):  # Not for production use
+    def __init__(self, requests_resp=None, status_code=None, text=None, headers=None):
+        self.status_code = status_code or requests_resp.status_code
+        self.text = text if text is not None else requests_resp.text
+        self.headers = {} if headers is None else headers
+        self._raw_resp = requests_resp
+
+    def raise_for_status(self):
+        if self._raw_resp is not None:  # Turns out `if requests.response` won't work
+                                        # cause it would be True when 200<=status<400
+            self._raw_resp.raise_for_status()
+
diff -pruN 1.2.0-1/tests/test_agnostic_backend.py 1.3.1-1/tests/test_agnostic_backend.py
--- 1.2.0-1/tests/test_agnostic_backend.py	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/tests/test_agnostic_backend.py	2025-03-14 23:39:03.000000000 +0000
@@ -1,12 +1,15 @@
+import json
 import os
 import shutil
 import tempfile
+from unittest.mock import patch
 import sys
 
 import msal
 import pytest
 
 from msal_extensions import *
+from .http_client import MinimalResponse
 
 
 @pytest.fixture
@@ -16,18 +19,19 @@ def temp_location():
     shutil.rmtree(test_folder, ignore_errors=True)
 
 def _test_token_cache_roundtrip(persistence):
-    client_id = os.getenv('AZURE_CLIENT_ID')
-    client_secret = os.getenv('AZURE_CLIENT_SECRET')
-    if not (client_id and client_secret):
-        pytest.skip('no credentials present to test TokenCache round-trip with.')
-
     desired_scopes = ['https://graph.microsoft.com/.default']
     apps = [  # Multiple apps sharing same persistence
         msal.ConfidentialClientApplication(
-        client_id, client_credential=client_secret,
+        "fake_client_id", client_credential="fake_client_secret",
         token_cache=PersistedTokenCache(persistence)) for i in range(2)]
-    token1 = apps[0].acquire_token_for_client(scopes=desired_scopes)
-    assert token1["token_source"] == "identity_provider", "Initial token should come from IdP"
+    with patch.object(apps[0].http_client, "post", return_value=MinimalResponse(
+        status_code=200, text=json.dumps({
+            "token_type": "Bearer",
+            "access_token": "app token",
+            "expires_in": 3600,
+    }))) as mocked_post:
+        token1 = apps[0].acquire_token_for_client(scopes=desired_scopes)
+        assert token1["token_source"] == "identity_provider", "Initial token should come from IdP"
     token2 = apps[1].acquire_token_for_client(scopes=desired_scopes)  # Hit token cache in MSAL 1.23+
     assert token2["token_source"] == "cache", "App2 should hit cache written by app1"
     assert token1['access_token'] == token2['access_token'], "Cache should hit"
diff -pruN 1.2.0-1/tests/test_cache_lock_file_perf.py 1.3.1-1/tests/test_cache_lock_file_perf.py
--- 1.2.0-1/tests/test_cache_lock_file_perf.py	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/tests/test_cache_lock_file_perf.py	2025-03-14 23:39:03.000000000 +0000
@@ -5,7 +5,7 @@ import tempfile
 
 import pytest
 
-from cache_file_generator import _acquire_lock_and_write_to_cache
+from .cache_file_generator import _acquire_lock_and_write_to_cache
 
 
 @pytest.fixture
diff -pruN 1.2.0-1/tests/test_crossplatlock.py 1.3.1-1/tests/test_crossplatlock.py
--- 1.2.0-1/tests/test_crossplatlock.py	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/tests/test_crossplatlock.py	2025-03-14 23:39:03.000000000 +0000
@@ -1,5 +1,5 @@
 import pytest
-from msal_extensions.cache_lock import CrossPlatLock
+from msal_extensions import CrossPlatLock
 
 
 def test_ensure_file_deleted():
@@ -10,6 +10,7 @@ def test_ensure_file_deleted():
     except NameError:
         FileNotFoundError = IOError
 
+    print("Testing with {}".format(CrossPlatLock))
     with CrossPlatLock(lockfile):
         pass
 
diff -pruN 1.2.0-1/tox.ini 1.3.1-1/tox.ini
--- 1.2.0-1/tox.ini	2024-06-23 01:50:29.000000000 +0000
+++ 1.3.1-1/tox.ini	2025-03-14 23:39:03.000000000 +0000
@@ -7,4 +7,11 @@ passenv =
     GITHUB_ACTIONS
 
 commands =
-    pytest
+    {posargs:pytest --color=yes}
+
+[testenv:lint]
+deps =
+    pylint
+commands =
+    pylint msal_extensions
+
