diff -pruN 2.12.7+dfsg+really2.9.14-0.4/debian/changelog 2.12.7+dfsg+really2.9.14-1/debian/changelog
--- 2.12.7+dfsg+really2.9.14-0.4/debian/changelog	2025-03-27 10:54:17.000000000 +0000
+++ 2.12.7+dfsg+really2.9.14-1/debian/changelog	2025-05-15 07:34:25.000000000 +0000
@@ -1,3 +1,20 @@
+libxml2 (2.12.7+dfsg+really2.9.14-1) unstable; urgency=medium
+
+  * Acknowledge previous NMUs.
+  * Security fixes:
+    - CVE-2023-39615: out-of-bounds read via the xmlSAX2StartElement()
+      (Closes: #1051230)
+    - CVE-2023-45322: use-after-free in xmlUnlinkNode()
+      (Closes: #1053629)
+    - CVE-2024-25062: use-after-free in xmlValidatePopElement()
+      (Closes: #1063234)
+    - CVE-2025-32414: out-of-bounds read in Python bindings
+      (Closes: #1102521)
+    - CVE-2025-32415: heap-based buffer under-read via
+      xmlSchemaIDCFillNodeTables() (Closes: #1103511)
+
+ -- Aron Xu <aron@debian.org>  Thu, 15 May 2025 15:34:25 +0800
+
 libxml2 (2.12.7+dfsg+really2.9.14-0.4) unstable; urgency=medium
 
   * Non-maintainer upload.
diff -pruN 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2023-39615_1.patch 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2023-39615_1.patch
--- 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2023-39615_1.patch	1970-01-01 00:00:00.000000000 +0000
+++ 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2023-39615_1.patch	2025-05-15 06:33:35.000000000 +0000
@@ -0,0 +1,29 @@
+From d0c3f01e110d54415611c5fa0040cdf4a56053f9 Mon Sep 17 00:00:00 2001
+From: Nick Wellnhofer <wellnhofer@aevum.de>
+Date: Sat, 6 May 2023 17:47:37 +0200
+Subject: [PATCH] parser: Fix old SAX1 parser with custom callbacks
+
+For some reason, xmlCtxtUseOptionsInternal set the start and end element
+SAX handlers to the internal DOM builder functions when XML_PARSE_SAX1
+was specified. This means that custom SAX handlers could never work with
+that flag because these functions would receive the wrong user data
+argument and crash immediately.
+
+Fixes #535.
+---
+ parser.c | 2 --
+ 1 file changed, 2 deletions(-)
+
+Index: libxml2-2.12.7+dfsg+really2.9.14/parser.c
+===================================================================
+--- libxml2-2.12.7+dfsg+really2.9.14.orig/parser.c
++++ libxml2-2.12.7+dfsg+really2.9.14/parser.c
+@@ -15071,8 +15071,6 @@ xmlCtxtUseOptionsInternal(xmlParserCtxtP
+     }
+ #ifdef LIBXML_SAX1_ENABLED
+     if (options & XML_PARSE_SAX1) {
+-        ctxt->sax->startElement = xmlSAX2StartElement;
+-        ctxt->sax->endElement = xmlSAX2EndElement;
+         ctxt->sax->startElementNs = NULL;
+         ctxt->sax->endElementNs = NULL;
+         ctxt->sax->initialized = 1;
diff -pruN 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2023-39615_2.patch 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2023-39615_2.patch
--- 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2023-39615_2.patch	1970-01-01 00:00:00.000000000 +0000
+++ 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2023-39615_2.patch	2025-05-15 06:34:17.000000000 +0000
@@ -0,0 +1,64 @@
+From 235b15a590eecf97b09e87bdb7e4f8333e9de129 Mon Sep 17 00:00:00 2001
+From: Nick Wellnhofer <wellnhofer@aevum.de>
+Date: Mon, 8 May 2023 17:58:02 +0200
+Subject: [PATCH] SAX: Always initialize SAX1 element handlers
+
+Follow-up to commit d0c3f01e. A parser context will be initialized to
+SAX version 2, but this can be overridden with XML_PARSE_SAX1 later,
+so we must initialize the SAX1 element handlers as well.
+
+Change the check in xmlDetectSAX2 to only look for XML_SAX2_MAGIC, so
+we don't switch to SAX1 if the SAX2 element handlers are NULL.
+---
+ SAX2.c   | 11 +++++++----
+ parser.c |  5 +----
+ 2 files changed, 8 insertions(+), 8 deletions(-)
+
+Index: libxml2-2.12.7+dfsg+really2.9.14/SAX2.c
+===================================================================
+--- libxml2-2.12.7+dfsg+really2.9.14.orig/SAX2.c
++++ libxml2-2.12.7+dfsg+really2.9.14/SAX2.c
+@@ -2842,20 +2842,23 @@ xmlSAXVersion(xmlSAXHandler *hdlr, int v
+ {
+     if (hdlr == NULL) return(-1);
+     if (version == 2) {
+-	hdlr->startElement = NULL;
+-	hdlr->endElement = NULL;
+ 	hdlr->startElementNs = xmlSAX2StartElementNs;
+ 	hdlr->endElementNs = xmlSAX2EndElementNs;
+ 	hdlr->serror = NULL;
+ 	hdlr->initialized = XML_SAX2_MAGIC;
+ #ifdef LIBXML_SAX1_ENABLED
+     } else if (version == 1) {
+-	hdlr->startElement = xmlSAX2StartElement;
+-	hdlr->endElement = xmlSAX2EndElement;
+ 	hdlr->initialized = 1;
+ #endif /* LIBXML_SAX1_ENABLED */
+     } else
+         return(-1);
++#ifdef LIBXML_SAX1_ENABLED
++    hdlr->startElement = xmlSAX2StartElement;
++    hdlr->endElement = xmlSAX2EndElement;
++#else
++    hdlr->startElement = NULL;
++    hdlr->endElement = NULL;
++#endif /* LIBXML_SAX1_ENABLED */
+     hdlr->internalSubset = xmlSAX2InternalSubset;
+     hdlr->externalSubset = xmlSAX2ExternalSubset;
+     hdlr->isStandalone = xmlSAX2IsStandalone;
+Index: libxml2-2.12.7+dfsg+really2.9.14/parser.c
+===================================================================
+--- libxml2-2.12.7+dfsg+really2.9.14.orig/parser.c
++++ libxml2-2.12.7+dfsg+really2.9.14/parser.c
+@@ -1109,10 +1109,7 @@ xmlDetectSAX2(xmlParserCtxtPtr ctxt) {
+     if (ctxt == NULL) return;
+     sax = ctxt->sax;
+ #ifdef LIBXML_SAX1_ENABLED
+-    if ((sax) &&  (sax->initialized == XML_SAX2_MAGIC) &&
+-        ((sax->startElementNs != NULL) ||
+-         (sax->endElementNs != NULL) ||
+-         ((sax->startElement == NULL) && (sax->endElement == NULL))))
++    if ((sax) && (sax->initialized == XML_SAX2_MAGIC))
+         ctxt->sax2 = 1;
+ #else
+     ctxt->sax2 = 1;
diff -pruN 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2023-45322.patch 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2023-45322.patch
--- 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2023-45322.patch	1970-01-01 00:00:00.000000000 +0000
+++ 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2023-45322.patch	2025-05-15 07:33:51.000000000 +0000
@@ -0,0 +1,49 @@
+Reviewed-by: Aron Xu <aron@debian.org>
+
+From 30d7660ba87c8487b26582ccc050f4d2880ccb3c Mon Sep 17 00:00:00 2001
+From: Nick Wellnhofer <wellnhofer@aevum.de>
+Date: Tue, 28 Nov 2023 13:27:25 +0100
+Subject: [PATCH] tree: Fix #583 again
+
+Only set doc->intSubset after successful copy to avoid dangling pointers
+in error case.
+---
+ tree.c | 7 +++++--
+ 1 file changed, 5 insertions(+), 2 deletions(-)
+
+Index: libxml2-2.12.7+dfsg+really2.9.14/tree.c
+===================================================================
+--- libxml2-2.12.7+dfsg+really2.9.14.orig/tree.c
++++ libxml2-2.12.7+dfsg+really2.9.14/tree.c
+@@ -4370,6 +4370,7 @@ static xmlNodePtr
+ xmlStaticCopyNodeList(xmlNodePtr node, xmlDocPtr doc, xmlNodePtr parent) {
+     xmlNodePtr ret = NULL;
+     xmlNodePtr p = NULL,q;
++    xmlDtdPtr newSubset = NULL;
+ 
+     while (node != NULL) {
+ #ifdef LIBXML_TREE_ENABLED
+@@ -4378,12 +4379,12 @@ xmlStaticCopyNodeList(xmlNodePtr node, x
+ 		node = node->next;
+ 		continue;
+ 	    }
+-	    if (doc->intSubset == NULL) {
++	    if ((doc->intSubset == NULL) && (newSubset == NULL)) {
+ 		q = (xmlNodePtr) xmlCopyDtd( (xmlDtdPtr) node );
+ 		if (q == NULL) return(NULL);
+ 		q->doc = doc;
+ 		q->parent = parent;
+-		doc->intSubset = (xmlDtdPtr) q;
++		newSubset = (xmlDtdPtr) q;
+ 		xmlAddChild(parent, q);
+ 	    } else {
+ 		q = (xmlNodePtr) doc->intSubset;
+@@ -4404,6 +4405,8 @@ xmlStaticCopyNodeList(xmlNodePtr node, x
+ 	}
+ 	node = node->next;
+     }
++    if ((doc != NULL) && (newSubset != NULL))
++        doc->intSubset = newSubset;
+     return(ret);
+ }
+ 
diff -pruN 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2024-25062.patch 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2024-25062.patch
--- 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2024-25062.patch	1970-01-01 00:00:00.000000000 +0000
+++ 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2024-25062.patch	2025-05-15 07:22:27.000000000 +0000
@@ -0,0 +1,26 @@
+From 2b0aac140d739905c7848a42efc60bfe783a39b7 Mon Sep 17 00:00:00 2001
+From: Nick Wellnhofer <wellnhofer@aevum.de>
+Date: Sat, 14 Oct 2023 22:45:54 +0200
+Subject: [PATCH] [CVE-2024-25062] xmlreader: Don't expand XIncludes when
+ backtracking
+
+Fixes a use-after-free if XML Reader if used with DTD validation and
+XInclude expansion.
+
+Fixes #604.
+---
+ xmlreader.c | 1 +
+ 1 file changed, 1 insertion(+)
+
+Index: libxml2-2.12.7+dfsg+really2.9.14/xmlreader.c
+===================================================================
+--- libxml2-2.12.7+dfsg+really2.9.14.orig/xmlreader.c
++++ libxml2-2.12.7+dfsg+really2.9.14/xmlreader.c
+@@ -1586,6 +1586,7 @@ node_found:
+      * Handle XInclude if asked for
+      */
+     if ((reader->xinclude) && (reader->in_xinclude == 0) &&
++        (reader->state != XML_TEXTREADER_BACKTRACK) &&
+         (reader->node != NULL) &&
+ 	(reader->node->type == XML_ELEMENT_NODE) &&
+ 	(reader->node->ns != NULL) &&
diff -pruN 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2025-32414-bug-889-v2.10.4-and-below.patch 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2025-32414-bug-889-v2.10.4-and-below.patch
--- 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2025-32414-bug-889-v2.10.4-and-below.patch	1970-01-01 00:00:00.000000000 +0000
+++ 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2025-32414-bug-889-v2.10.4-and-below.patch	2025-05-15 07:34:08.000000000 +0000
@@ -0,0 +1,60 @@
+Index: libxml2-2.12.7+dfsg+really2.9.14/python/libxml.c
+===================================================================
+--- libxml2-2.12.7+dfsg+really2.9.14.orig/python/libxml.c
++++ libxml2-2.12.7+dfsg+really2.9.14/python/libxml.c
+@@ -287,7 +287,9 @@ xmlPythonFileReadRaw (void * context, ch
+ #endif
+     file = (PyObject *) context;
+     if (file == NULL) return(-1);
+-    ret = PyObject_CallMethod(file, (char *) "read", (char *) "(i)", len);
++    /* When read() returns a string, the length is in characters not bytes, so
++       request at most len / 4 characters to leave space for UTF-8 encoding. */
++    ret = PyObject_CallMethod(file, (char *) "read", (char *) "(i)", len / 4);
+     if (ret == NULL) {
+ 	printf("xmlPythonFileReadRaw: result is NULL\n");
+ 	return(-1);
+@@ -322,10 +324,12 @@ xmlPythonFileReadRaw (void * context, ch
+ 	Py_DECREF(ret);
+ 	return(-1);
+     }
+-    if (lenread > len)
+-	memcpy(buffer, data, len);
+-    else
+-	memcpy(buffer, data, lenread);
++    if (lenread < 0 || lenread > len) {
++	printf("xmlPythonFileReadRaw: invalid lenread\n");
++	Py_DECREF(ret);
++	return(-1);
++    }
++    memcpy(buffer, data, lenread);
+     Py_DECREF(ret);
+     return(lenread);
+ }
+@@ -352,7 +356,9 @@ xmlPythonFileRead (void * context, char
+ #endif
+     file = (PyObject *) context;
+     if (file == NULL) return(-1);
+-    ret = PyObject_CallMethod(file, (char *) "io_read", (char *) "(i)", len);
++    /* When read() returns a string, the length is in characters not bytes, so
++       request at most len / 4 characters to leave space for UTF-8 encoding. */
++    ret = PyObject_CallMethod(file, (char *) "io_read", (char *) "(i)", len / 4);
+     if (ret == NULL) {
+ 	printf("xmlPythonFileRead: result is NULL\n");
+ 	return(-1);
+@@ -387,10 +393,12 @@ xmlPythonFileRead (void * context, char
+ 	Py_DECREF(ret);
+ 	return(-1);
+     }
+-    if (lenread > len)
+-	memcpy(buffer, data, len);
+-    else
+-	memcpy(buffer, data, lenread);
++    if (lenread < 0 || lenread > len) {
++	printf("xmlPythonFileRead: invalid lenread\n");
++	Py_DECREF(ret);
++	return(-1);
++    }
++    memcpy(buffer, data, lenread);
+     Py_DECREF(ret);
+     return(lenread);
+ }
diff -pruN 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2025-32414.patch 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2025-32414.patch
--- 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2025-32414.patch	1970-01-01 00:00:00.000000000 +0000
+++ 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2025-32414.patch	2025-05-15 07:33:20.000000000 +0000
@@ -0,0 +1,68 @@
+Reviewed-by: Aron Xu <aron@debian.org>
+
+From: Maks Verver <maks@verver.ch>
+Date: Tue, 8 Apr 2025 13:13:55 +0200
+Subject: [PATCH 2/2] [CVE-2025-32414] python: Read at most len/4 characters.
+
+Fixes #889 by reserving space in the buffer for UTF-8 encoding of text.
+
+Index: libxml2-2.12.7+dfsg+really2.9.14/python/libxml.c
+===================================================================
+--- libxml2-2.12.7+dfsg+really2.9.14.orig/python/libxml.c
++++ libxml2-2.12.7+dfsg+really2.9.14/python/libxml.c
+@@ -287,7 +287,9 @@ xmlPythonFileReadRaw (void * context, ch
+ #endif
+     file = (PyObject *) context;
+     if (file == NULL) return(-1);
+-    ret = PyObject_CallMethod(file, (char *) "read", (char *) "(i)", len);
++    /* When read() returns a string, the length is in characters not bytes, so
++       request at most len / 4 characters to leave space for UTF-8 encoding. */
++    ret = PyObject_CallMethod(file, (char *) "read", (char *) "(i)", len / 4);
+     if (ret == NULL) {
+ 	printf("xmlPythonFileReadRaw: result is NULL\n");
+ 	return(-1);
+@@ -322,10 +324,12 @@ xmlPythonFileReadRaw (void * context, ch
+ 	Py_DECREF(ret);
+ 	return(-1);
+     }
+-    if (lenread > len)
+-	memcpy(buffer, data, len);
+-    else
+-	memcpy(buffer, data, lenread);
++    if (lenread < 0 || lenread > len) {
++	printf("xmlPythonFileReadRaw: invalid lenread\n");
++	Py_DECREF(ret);
++	return(-1);
++    }
++    memcpy(buffer, data, lenread);
+     Py_DECREF(ret);
+     return(lenread);
+ }
+@@ -352,7 +356,9 @@ xmlPythonFileRead (void * context, char
+ #endif
+     file = (PyObject *) context;
+     if (file == NULL) return(-1);
+-    ret = PyObject_CallMethod(file, (char *) "io_read", (char *) "(i)", len);
++    /* When read() returns a string, the length is in characters not bytes, so
++       request at most len / 4 characters to leave space for UTF-8 encoding. */
++    ret = PyObject_CallMethod(file, (char *) "io_read", (char *) "(i)", len / 4);
+     if (ret == NULL) {
+ 	printf("xmlPythonFileRead: result is NULL\n");
+ 	return(-1);
+@@ -387,10 +393,12 @@ xmlPythonFileRead (void * context, char
+ 	Py_DECREF(ret);
+ 	return(-1);
+     }
+-    if (lenread > len)
+-	memcpy(buffer, data, len);
+-    else
+-	memcpy(buffer, data, lenread);
++    if (lenread < 0 || lenread > len) {
++	printf("xmlPythonFileRead: invalid lenread\n");
++	Py_DECREF(ret);
++	return(-1);
++    }
++    memcpy(buffer, data, lenread);
+     Py_DECREF(ret);
+     return(lenread);
+ }
diff -pruN 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2025-32415.patch 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2025-32415.patch
--- 2.12.7+dfsg+really2.9.14-0.4/debian/patches/CVE-2025-32415.patch	1970-01-01 00:00:00.000000000 +0000
+++ 2.12.7+dfsg+really2.9.14-1/debian/patches/CVE-2025-32415.patch	2025-05-15 07:32:26.000000000 +0000
@@ -0,0 +1,35 @@
+From 384cc7c182fc00c6d5e2ab4b5e3671b2e3f93c84 Mon Sep 17 00:00:00 2001
+From: Nick Wellnhofer <wellnhofer@aevum.de>
+Date: Sun, 6 Apr 2025 12:41:11 +0200
+Subject: [PATCH] [CVE-2025-32415] schemas: Fix heap buffer overflow in
+ xmlSchemaIDCFillNodeTables
+
+Don't use local variable which could contain a stale value.
+
+Fixes #890.
+---
+ xmlschemas.c | 4 ++--
+ 1 file changed, 2 insertions(+), 2 deletions(-)
+
+Index: libxml2-2.12.7+dfsg+really2.9.14/xmlschemas.c
+===================================================================
+--- libxml2-2.12.7+dfsg+really2.9.14.orig/xmlschemas.c
++++ libxml2-2.12.7+dfsg+really2.9.14/xmlschemas.c
+@@ -23618,7 +23618,7 @@ xmlSchemaIDCFillNodeTables(xmlSchemaVali
+ 			j++;
+ 		    } while (j < nbDupls);
+ 		}
+-		if (nbNodeTable) {
++		if (bind->nbNodes) {
+ 		    j = 0;
+ 		    do {
+ 			if (nbFields == 1) {
+@@ -23669,7 +23669,7 @@ xmlSchemaIDCFillNodeTables(xmlSchemaVali
+ 
+ next_node_table_entry:
+ 			j++;
+-		    } while (j < nbNodeTable);
++		    } while (j < bind->nbNodes);
+ 		}
+ 		/*
+ 		* If everything is fine, then add the IDC target-node to
diff -pruN 2.12.7+dfsg+really2.9.14-0.4/debian/patches/series 2.12.7+dfsg+really2.9.14-1/debian/patches/series
--- 2.12.7+dfsg+really2.9.14-0.4/debian/patches/series	2025-03-27 10:54:17.000000000 +0000
+++ 2.12.7+dfsg+really2.9.14-1/debian/patches/series	2025-05-15 07:28:27.000000000 +0000
@@ -15,3 +15,9 @@ CVE-2024-56171.patch
 CVE-2025-24928-pre1.patch
 CVE-2025-24928.patch
 CVE-2025-27113.patch
+CVE-2023-39615_1.patch
+CVE-2023-39615_2.patch
+CVE-2023-45322.patch
+CVE-2024-25062.patch
+CVE-2025-32414-bug-889-v2.10.4-and-below.patch
+CVE-2025-32415.patch
