diff -pruN 0.803-1/Changes 0.804-1/Changes
--- 0.803-1/Changes	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/Changes	2025-04-22 16:38:04.000000000 +0000
@@ -1,5 +1,12 @@
 Revision history for IO-Async
 
+0.804   2025-04-22
+        [CHANGES]
+         * Add extra LoopTests tests for IO and timer operation after a
+           ->post_fork call, in order to help test RT152635
+         * Remove duplicate `use VERSION` declaration from helper package in
+           TimeQueue.pm
+
 0.803   2024-01-29
         [CHANGES]
          * Module style updates:
diff -pruN 0.803-1/LICENSE 0.804-1/LICENSE
--- 0.803-1/LICENSE	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/LICENSE	2025-04-22 16:38:04.000000000 +0000
@@ -1,4 +1,4 @@
-This software is copyright (c) 2024 by Paul Evans <leonerd@leonerd.org.uk>.
+This software is copyright (c) 2025 by Paul Evans <leonerd@leonerd.org.uk>.
 
 This is free software; you can redistribute it and/or modify it under
 the same terms as the Perl 5 programming language system itself.
@@ -12,7 +12,7 @@ b) the "Artistic License"
 
 --- The GNU General Public License, Version 1, February 1989 ---
 
-This software is Copyright (c) 2024 by Paul Evans <leonerd@leonerd.org.uk>.
+This software is Copyright (c) 2025 by Paul Evans <leonerd@leonerd.org.uk>.
 
 This is free software, licensed under:
 
@@ -272,7 +272,7 @@ That's all there is to it!
 
 --- The Perl Artistic License 1.0 ---
 
-This software is Copyright (c) 2024 by Paul Evans <leonerd@leonerd.org.uk>.
+This software is Copyright (c) 2025 by Paul Evans <leonerd@leonerd.org.uk>.
 
 This is free software, licensed under:
 
diff -pruN 0.803-1/META.json 0.804-1/META.json
--- 0.803-1/META.json	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/META.json	2025-04-22 16:38:04.000000000 +0000
@@ -49,151 +49,151 @@
    "provides" : {
       "Future::IO::Impl::IOAsync" : {
          "file" : "lib/Future/IO/Impl/IOAsync.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async" : {
          "file" : "lib/IO/Async.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Channel" : {
          "file" : "lib/IO/Async/Channel.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Debug" : {
          "file" : "lib/IO/Async/Debug.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::File" : {
          "file" : "lib/IO/Async/File.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::FileStream" : {
          "file" : "lib/IO/Async/FileStream.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Function" : {
          "file" : "lib/IO/Async/Function.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Future" : {
          "file" : "lib/IO/Async/Future.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Handle" : {
          "file" : "lib/IO/Async/Handle.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Internals::ChildManager" : {
          "file" : "lib/IO/Async/Internals/ChildManager.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Internals::FunctionWorker" : {
          "file" : "lib/IO/Async/Internals/FunctionWorker.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Listener" : {
          "file" : "lib/IO/Async/Listener.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Loop" : {
          "file" : "lib/IO/Async/Loop.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Loop::Poll" : {
          "file" : "lib/IO/Async/Loop/Poll.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Loop::Select" : {
          "file" : "lib/IO/Async/Loop/Select.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::LoopTests" : {
          "file" : "lib/IO/Async/LoopTests.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Metrics" : {
          "file" : "lib/IO/Async/Metrics.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Notifier" : {
          "file" : "lib/IO/Async/Notifier.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::OS" : {
          "file" : "lib/IO/Async/OS.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::OS::MSWin32" : {
          "file" : "lib/IO/Async/OS/MSWin32.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::OS::cygwin" : {
          "file" : "lib/IO/Async/OS/cygwin.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::OS::linux" : {
          "file" : "lib/IO/Async/OS/linux.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::PID" : {
          "file" : "lib/IO/Async/PID.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Process" : {
          "file" : "lib/IO/Async/Process.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Protocol" : {
          "file" : "lib/IO/Async/Protocol.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Protocol::LineStream" : {
          "file" : "lib/IO/Async/Protocol/LineStream.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Protocol::Stream" : {
          "file" : "lib/IO/Async/Protocol/Stream.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Resolver" : {
          "file" : "lib/IO/Async/Resolver.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Routine" : {
          "file" : "lib/IO/Async/Routine.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Signal" : {
          "file" : "lib/IO/Async/Signal.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Socket" : {
          "file" : "lib/IO/Async/Socket.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Stream" : {
          "file" : "lib/IO/Async/Stream.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Test" : {
          "file" : "lib/IO/Async/Test.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Timer" : {
          "file" : "lib/IO/Async/Timer.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Timer::Absolute" : {
          "file" : "lib/IO/Async/Timer/Absolute.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Timer::Countdown" : {
          "file" : "lib/IO/Async/Timer/Countdown.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       },
       "IO::Async::Timer::Periodic" : {
          "file" : "lib/IO/Async/Timer/Periodic.pm",
-         "version" : "0.803"
+         "version" : "0.804"
       }
    },
    "release_status" : "stable",
@@ -203,6 +203,6 @@
       ],
       "x_IRC" : "irc://irc.perl.org/#io-async"
    },
-   "version" : "0.803",
+   "version" : "0.804",
    "x_serialization_backend" : "JSON::PP version 4.16"
 }
diff -pruN 0.803-1/META.yml 0.804-1/META.yml
--- 0.803-1/META.yml	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/META.yml	2025-04-22 16:38:04.000000000 +0000
@@ -19,115 +19,115 @@ name: IO-Async
 provides:
   Future::IO::Impl::IOAsync:
     file: lib/Future/IO/Impl/IOAsync.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async:
     file: lib/IO/Async.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Channel:
     file: lib/IO/Async/Channel.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Debug:
     file: lib/IO/Async/Debug.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::File:
     file: lib/IO/Async/File.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::FileStream:
     file: lib/IO/Async/FileStream.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Function:
     file: lib/IO/Async/Function.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Future:
     file: lib/IO/Async/Future.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Handle:
     file: lib/IO/Async/Handle.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Internals::ChildManager:
     file: lib/IO/Async/Internals/ChildManager.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Internals::FunctionWorker:
     file: lib/IO/Async/Internals/FunctionWorker.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Listener:
     file: lib/IO/Async/Listener.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Loop:
     file: lib/IO/Async/Loop.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Loop::Poll:
     file: lib/IO/Async/Loop/Poll.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Loop::Select:
     file: lib/IO/Async/Loop/Select.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::LoopTests:
     file: lib/IO/Async/LoopTests.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Metrics:
     file: lib/IO/Async/Metrics.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Notifier:
     file: lib/IO/Async/Notifier.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::OS:
     file: lib/IO/Async/OS.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::OS::MSWin32:
     file: lib/IO/Async/OS/MSWin32.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::OS::cygwin:
     file: lib/IO/Async/OS/cygwin.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::OS::linux:
     file: lib/IO/Async/OS/linux.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::PID:
     file: lib/IO/Async/PID.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Process:
     file: lib/IO/Async/Process.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Protocol:
     file: lib/IO/Async/Protocol.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Protocol::LineStream:
     file: lib/IO/Async/Protocol/LineStream.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Protocol::Stream:
     file: lib/IO/Async/Protocol/Stream.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Resolver:
     file: lib/IO/Async/Resolver.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Routine:
     file: lib/IO/Async/Routine.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Signal:
     file: lib/IO/Async/Signal.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Socket:
     file: lib/IO/Async/Socket.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Stream:
     file: lib/IO/Async/Stream.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Test:
     file: lib/IO/Async/Test.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Timer:
     file: lib/IO/Async/Timer.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Timer::Absolute:
     file: lib/IO/Async/Timer/Absolute.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Timer::Countdown:
     file: lib/IO/Async/Timer/Countdown.pm
-    version: '0.803'
+    version: '0.804'
   IO::Async::Timer::Periodic:
     file: lib/IO/Async/Timer/Periodic.pm
-    version: '0.803'
+    version: '0.804'
 recommends:
   IO::Socket::IP: '0'
 requires:
@@ -145,5 +145,5 @@ requires:
 resources:
   IRC: irc://irc.perl.org/#io-async
   license: http://dev.perl.org/licenses/
-version: '0.803'
+version: '0.804'
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
diff -pruN 0.803-1/debian/changelog 0.804-1/debian/changelog
--- 0.803-1/debian/changelog	2024-02-04 03:49:36.000000000 +0000
+++ 0.804-1/debian/changelog	2025-05-16 14:32:44.000000000 +0000
@@ -1,3 +1,11 @@
+libio-async-perl (0.804-1) unstable; urgency=medium
+
+  * Import upstream version 0.804.
+  * Update years of upstream and packaging copyright.
+  * Declare compliance with Debian Policy 4.7.2.
+
+ -- gregor herrmann <gregoa@debian.org>  Fri, 16 May 2025 16:32:44 +0200
+
 libio-async-perl (0.803-1) unstable; urgency=medium
 
   * Import upstream version 0.803.
diff -pruN 0.803-1/debian/control 0.804-1/debian/control
--- 0.803-1/debian/control	2024-02-04 03:49:36.000000000 +0000
+++ 0.804-1/debian/control	2025-05-16 14:32:44.000000000 +0000
@@ -20,7 +20,7 @@ Build-Depends-Indep: libfuture-io-perl <
                      libtest-pod-perl <!nocheck>,
                      libtest2-suite-perl (>= 0.000149) <!nocheck>,
                      netbase <!nocheck>
-Standards-Version: 4.6.2
+Standards-Version: 4.7.2
 Vcs-Browser: https://salsa.debian.org/perl-team/modules/packages/libio-async-perl
 Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libio-async-perl.git
 Homepage: https://metacpan.org/release/IO-Async
diff -pruN 0.803-1/debian/copyright 0.804-1/debian/copyright
--- 0.803-1/debian/copyright	2024-02-04 03:49:36.000000000 +0000
+++ 0.804-1/debian/copyright	2025-05-16 14:32:44.000000000 +0000
@@ -4,14 +4,14 @@ Upstream-Contact: Paul Evans <leonerd@le
 Source: https://metacpan.org/release/IO-Async
 
 Files: *
-Copyright: 2006-2024, Paul Evans <leonerd@leonerd.org.uk>
+Copyright: 2006-2025, Paul Evans <leonerd@leonerd.org.uk>
 License: Artistic or GPL-1+
 
 Files: debian/*
 Copyright:
  2009-2011, Jonathan Yu <jawnsy@cpan.org>
  2010-2011, Nicholas Bamber <nicholas@periapt.co.uk>
- 2010-2024, gregor herrmann <gregoa@debian.org>
+ 2010-2025, gregor herrmann <gregoa@debian.org>
  2013-2021, Florian Schlichting <fsfs@debian.org>
  2015, Lucas Kanashiro <kanashiro.duarte@gmail.com>
 License: Artistic or GPL-1+
diff -pruN 0.803-1/lib/Future/IO/Impl/IOAsync.pm 0.804-1/lib/Future/IO/Impl/IOAsync.pm
--- 0.803-1/lib/Future/IO/Impl/IOAsync.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/Future/IO/Impl/IOAsync.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2019-2024 -- leonerd@leonerd.org.uk
 
-package Future::IO::Impl::IOAsync 0.803;
+package Future::IO::Impl::IOAsync 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Channel.pm 0.804-1/lib/IO/Async/Channel.pm
--- 0.803-1/lib/IO/Async/Channel.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Channel.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2011-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Channel 0.803;
+package IO::Async::Channel 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Debug.pm 0.804-1/lib/IO/Async/Debug.pm
--- 0.803-1/lib/IO/Async/Debug.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Debug.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2015-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Debug 0.803;
+package IO::Async::Debug 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/File.pm 0.804-1/lib/IO/Async/File.pm
--- 0.803-1/lib/IO/Async/File.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/File.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2012-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::File 0.803;
+package IO::Async::File 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/FileStream.pm 0.804-1/lib/IO/Async/FileStream.pm
--- 0.803-1/lib/IO/Async/FileStream.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/FileStream.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2011-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::FileStream 0.803;
+package IO::Async::FileStream 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Function.pm 0.804-1/lib/IO/Async/Function.pm
--- 0.803-1/lib/IO/Async/Function.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Function.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2011-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Function 0.803;
+package IO::Async::Function 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Future.pm 0.804-1/lib/IO/Async/Future.pm
--- 0.803-1/lib/IO/Async/Future.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Future.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2013-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Future 0.803;
+package IO::Async::Future 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Handle.pm 0.804-1/lib/IO/Async/Handle.pm
--- 0.803-1/lib/IO/Async/Handle.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Handle.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2006-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Handle 0.803;
+package IO::Async::Handle 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Internals/ChildManager.pm 0.804-1/lib/IO/Async/Internals/ChildManager.pm
--- 0.803-1/lib/IO/Async/Internals/ChildManager.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Internals/ChildManager.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2007-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Internals::ChildManager 0.803;
+package IO::Async::Internals::ChildManager 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Internals/FunctionWorker.pm 0.804-1/lib/IO/Async/Internals/FunctionWorker.pm
--- 0.803-1/lib/IO/Async/Internals/FunctionWorker.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Internals/FunctionWorker.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2011-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Internals::FunctionWorker 0.803;
+package IO::Async::Internals::FunctionWorker 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Internals/TimeQueue.pm 0.804-1/lib/IO/Async/Internals/TimeQueue.pm
--- 0.803-1/lib/IO/Async/Internals/TimeQueue.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Internals/TimeQueue.pm	2025-04-22 16:38:04.000000000 +0000
@@ -163,7 +163,6 @@ sub HEAP__fire
 package # hide from CPAN
   IO::Async::Internals::TimeQueue::Elem;
 
-use v5.14;
 our @ISA = qw( Heap::Elem );
 
 sub new
diff -pruN 0.803-1/lib/IO/Async/Listener.pm 0.804-1/lib/IO/Async/Listener.pm
--- 0.803-1/lib/IO/Async/Listener.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Listener.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2008-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Listener 0.803;
+package IO::Async::Listener 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Loop/Poll.pm 0.804-1/lib/IO/Async/Loop/Poll.pm
--- 0.803-1/lib/IO/Async/Loop/Poll.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Loop/Poll.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2007-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Loop::Poll 0.803;
+package IO::Async::Loop::Poll 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Loop/Select.pm 0.804-1/lib/IO/Async/Loop/Select.pm
--- 0.803-1/lib/IO/Async/Loop/Select.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Loop/Select.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2007-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Loop::Select 0.803;
+package IO::Async::Loop::Select 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Loop.pm 0.804-1/lib/IO/Async/Loop.pm
--- 0.803-1/lib/IO/Async/Loop.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Loop.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2007-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Loop 0.803;
+package IO::Async::Loop 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/LoopTests.pm 0.804-1/lib/IO/Async/LoopTests.pm
--- 0.803-1/lib/IO/Async/LoopTests.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/LoopTests.pm	2025-04-22 16:38:04.000000000 +0000
@@ -1,9 +1,9 @@
 #  You may distribute under the terms of either the GNU General Public License
 #  or the Artistic License (the same terms as Perl itself)
 #
-#  (C) Paul Evans, 2009-2024 -- leonerd@leonerd.org.uk
+#  (C) Paul Evans, 2009-2025 -- leonerd@leonerd.org.uk
 
-package IO::Async::LoopTests 0.803;
+package IO::Async::LoopTests 0.804;
 
 use v5.14;
 use warnings;
@@ -416,6 +416,25 @@ sub run_tests_io
          on_write_ready => 1,
       );
    }
+
+   {
+      my ( $S1, $S2 ) = IO::Async::OS->socketpair or die "Cannot create AF_INET/SOCK_DGRAM connected pair - $!";
+      $_->blocking( 0 ) for $S1, $S2;
+
+      my $readready = 0;
+      $loop->watch_io(
+         handle => $S1,
+         on_read_ready => sub { $readready = 1 },
+      );
+
+      $loop->post_fork;
+
+      $S2->syswrite( "Boo!" );
+
+      $loop->loop_once( 0.1 );
+
+      is( $readready, 1, 'socket invokes on_read_ready' );
+   }
 }
 
 =head2 timer
@@ -528,6 +547,25 @@ sub run_tests_timer
          is( $count, 1, "One ->loop_once(1) sufficient for a single $delay second timer" );
       }
    }
+
+   # ->watch_time after post_fork
+   {
+      my $done;
+      $loop->watch_time( after => 2 * AUT, code => sub { $done = 1; } );
+      $loop->post_fork;
+
+      time_between {
+         my $now = time;
+         $loop->loop_once( 5 * AUT );
+
+         # poll might have returned just a little early, such that the TimerQueue
+         # doesn't think anything is ready yet. We need to handle that case.
+         while( !$done ) {
+            die "It should have been ready by now" if( time - $now > 5 * AUT );
+            $loop->loop_once( 0.1 * AUT );
+         }
+      } 1.5, 2.5, 'loop_once(5) while waiting for watch_time after';
+   }
 }
 
 =head2 signal
diff -pruN 0.803-1/lib/IO/Async/Metrics.pm 0.804-1/lib/IO/Async/Metrics.pm
--- 0.803-1/lib/IO/Async/Metrics.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Metrics.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2020-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Metrics 0.803;
+package IO::Async::Metrics 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Notifier.pm 0.804-1/lib/IO/Async/Notifier.pm
--- 0.803-1/lib/IO/Async/Notifier.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Notifier.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2006-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Notifier 0.803;
+package IO::Async::Notifier 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/OS/MSWin32.pm 0.804-1/lib/IO/Async/OS/MSWin32.pm
--- 0.803-1/lib/IO/Async/OS/MSWin32.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/OS/MSWin32.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2012-2013 -- leonerd@leonerd.org.uk
 
-package IO::Async::OS::MSWin32 0.803;
+package IO::Async::OS::MSWin32 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/OS/cygwin.pm 0.804-1/lib/IO/Async/OS/cygwin.pm
--- 0.803-1/lib/IO/Async/OS/cygwin.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/OS/cygwin.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2013-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::OS::cygwin 0.803;
+package IO::Async::OS::cygwin 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/OS/linux.pm 0.804-1/lib/IO/Async/OS/linux.pm
--- 0.803-1/lib/IO/Async/OS/linux.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/OS/linux.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2014-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::OS::linux 0.803;
+package IO::Async::OS::linux 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/OS.pm 0.804-1/lib/IO/Async/OS.pm
--- 0.803-1/lib/IO/Async/OS.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/OS.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2012-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::OS 0.803;
+package IO::Async::OS 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/PID.pm 0.804-1/lib/IO/Async/PID.pm
--- 0.803-1/lib/IO/Async/PID.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/PID.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2010-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::PID 0.803;
+package IO::Async::PID 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Process.pm 0.804-1/lib/IO/Async/Process.pm
--- 0.803-1/lib/IO/Async/Process.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Process.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2011-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Process 0.803;
+package IO::Async::Process 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Protocol/LineStream.pm 0.804-1/lib/IO/Async/Protocol/LineStream.pm
--- 0.803-1/lib/IO/Async/Protocol/LineStream.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Protocol/LineStream.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2010-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Protocol::LineStream 0.803;
+package IO::Async::Protocol::LineStream 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Protocol/Stream.pm 0.804-1/lib/IO/Async/Protocol/Stream.pm
--- 0.803-1/lib/IO/Async/Protocol/Stream.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Protocol/Stream.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2010-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Protocol::Stream 0.803;
+package IO::Async::Protocol::Stream 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Protocol.pm 0.804-1/lib/IO/Async/Protocol.pm
--- 0.803-1/lib/IO/Async/Protocol.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Protocol.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2011-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Protocol 0.803;
+package IO::Async::Protocol 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Resolver.pm 0.804-1/lib/IO/Async/Resolver.pm
--- 0.803-1/lib/IO/Async/Resolver.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Resolver.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2007-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Resolver 0.803;
+package IO::Async::Resolver 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Routine.pm 0.804-1/lib/IO/Async/Routine.pm
--- 0.803-1/lib/IO/Async/Routine.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Routine.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2012-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Routine 0.803;
+package IO::Async::Routine 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Signal.pm 0.804-1/lib/IO/Async/Signal.pm
--- 0.803-1/lib/IO/Async/Signal.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Signal.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2009-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Signal 0.803;
+package IO::Async::Signal 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Socket.pm 0.804-1/lib/IO/Async/Socket.pm
--- 0.803-1/lib/IO/Async/Socket.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Socket.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2011-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Socket 0.803;
+package IO::Async::Socket 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Stream.pm 0.804-1/lib/IO/Async/Stream.pm
--- 0.803-1/lib/IO/Async/Stream.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Stream.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2006-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Stream 0.803;
+package IO::Async::Stream 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Test.pm 0.804-1/lib/IO/Async/Test.pm
--- 0.803-1/lib/IO/Async/Test.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Test.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2007-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Test 0.803;
+package IO::Async::Test 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Timer/Absolute.pm 0.804-1/lib/IO/Async/Timer/Absolute.pm
--- 0.803-1/lib/IO/Async/Timer/Absolute.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Timer/Absolute.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2010-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Timer::Absolute 0.803;
+package IO::Async::Timer::Absolute 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Timer/Countdown.pm 0.804-1/lib/IO/Async/Timer/Countdown.pm
--- 0.803-1/lib/IO/Async/Timer/Countdown.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Timer/Countdown.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2009-2012 -- leonerd@leonerd.org.uk
 
-package IO::Async::Timer::Countdown 0.803;
+package IO::Async::Timer::Countdown 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Timer/Periodic.pm 0.804-1/lib/IO/Async/Timer/Periodic.pm
--- 0.803-1/lib/IO/Async/Timer/Periodic.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Timer/Periodic.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2009-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Timer::Periodic 0.803;
+package IO::Async::Timer::Periodic 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async/Timer.pm 0.804-1/lib/IO/Async/Timer.pm
--- 0.803-1/lib/IO/Async/Timer.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async/Timer.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2009-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async::Timer 0.803;
+package IO::Async::Timer 0.804;
 
 use v5.14;
 use warnings;
diff -pruN 0.803-1/lib/IO/Async.pm 0.804-1/lib/IO/Async.pm
--- 0.803-1/lib/IO/Async.pm	2024-01-29 20:40:48.000000000 +0000
+++ 0.804-1/lib/IO/Async.pm	2025-04-22 16:38:04.000000000 +0000
@@ -3,7 +3,7 @@
 #
 #  (C) Paul Evans, 2008-2024 -- leonerd@leonerd.org.uk
 
-package IO::Async 0.803;
+package IO::Async 0.804;
 
 use v5.14;
 use warnings;
