diff -pruN 0.05-3/Changes 0.06-1/Changes
--- 0.05-3/Changes	2012-10-22 22:13:42.000000000 +0000
+++ 0.06-1/Changes	2024-11-12 19:03:44.000000000 +0000
@@ -1,5 +1,12 @@
 Revision history for HTML-RewriteAttributes
 
+0.06    Fri Nov  12 2024
+        Pass more args to callback to support adding attributes.
+        Improve documentation for other features.
+        Add dot ('.') to Makefile.PL to find Module::Install in newer perls. Reported by Kent Fredric, RT 121446.
+        Remove unneeded shebang line in lib files. Reported by Laurent Baillet, RT 126906.
+        Fix spelling error in docs. Reported by x.guimard, RT 126964.
+
 0.05    Mon Oct 22 2012
         Resources: Preserve the media attribute when inlining CSS
         Resources: Avoid uninitialized warnings by checking the attributes we expect
diff -pruN 0.05-3/MANIFEST 0.06-1/MANIFEST
--- 0.05-3/MANIFEST	2012-10-22 22:14:16.000000000 +0000
+++ 0.06-1/MANIFEST	2024-11-12 19:02:49.000000000 +0000
@@ -27,4 +27,3 @@ t/020-inline-css.t
 t/021-import.t
 t/022-import-off.t
 t/023-import-comment.t
-SIGNATURE                                Public-key signature (added by MakeMaker)
diff -pruN 0.05-3/META.yml 0.06-1/META.yml
--- 0.05-3/META.yml	2012-10-22 22:14:11.000000000 +0000
+++ 0.06-1/META.yml	2024-11-12 19:03:48.000000000 +0000
@@ -1,14 +1,14 @@
 ---
 abstract: 'concise attribute rewriting'
 author:
-  - 'Shawn M Moore, C<< <sartak@bestpractical.com> >>'
+  - 'Best Practical Solutions, LLC <modules@bestpractical.com>'
 build_requires:
   ExtUtils::MakeMaker: 6.36
 configure_requires:
   ExtUtils::MakeMaker: 6.36
 distribution_type: module
 dynamic_config: 1
-generated_by: 'Module::Install version 1.06'
+generated_by: 'Module::Install version 1.21'
 license: perl
 meta-spec:
   url: http://module-build.sourceforge.net/META-spec-v1.4.html
@@ -25,4 +25,4 @@ requires:
   URI: 0
 resources:
   license: http://dev.perl.org/licenses/
-version: 0.05
+version: '0.06'
diff -pruN 0.05-3/Makefile.PL 0.06-1/Makefile.PL
--- 0.05-3/Makefile.PL	2012-10-22 21:56:56.000000000 +0000
+++ 0.06-1/Makefile.PL	2024-11-12 19:03:44.000000000 +0000
@@ -1,3 +1,4 @@
+use lib '.';
 use inc::Module::Install;
 
 # Define metadata
diff -pruN 0.05-3/README 0.06-1/README
--- 0.05-3/README	2012-10-22 22:14:10.000000000 +0000
+++ 0.06-1/README	2024-11-12 19:03:48.000000000 +0000
@@ -2,6 +2,11 @@ NAME
     HTML::RewriteAttributes - concise attribute rewriting
 
 SYNOPSIS
+    Locate a tag in a provided block of HTML and delete, add, or rewrite the
+    attributes associated with that tag. The updated HTML is returned.
+
+    Delete an attribute by returning undef.
+
         $html = HTML::RewriteAttributes->rewrite($html, sub {
             my ($tag, $attr, $value) = @_;
 
@@ -12,8 +17,21 @@ SYNOPSIS
             return $value;
         });
 
+    Add an attribute by appending it to the $attr_list arrayref and adding
+    the value to the $attrs hashref. For example, you could add
+    "loading="lazy"" to all "img" tags.
+
+        $html = HTML::RewriteAttributes->rewrite($html, sub {
+            my ( $tag, $attr, $value, $attrs, $attr_list ) = @_;
+            return $value unless $tag eq 'img' && !$attrs->{loading};
+            $attrs->{loading} = 'lazy';
+            push @$attr_list, 'loading';
+            return $value;
+        });
+
+    Modify an existing attribute by returning the new value. The example
+    below would be a "src" attribute for an "img" in an email.
 
-        # writing some HTML email I see..
         $html = HTML::RewriteAttributes::Resources->rewrite($html, sub {
             my $uri = shift;
             my $content = render_template($uri);
@@ -22,11 +40,16 @@ SYNOPSIS
             return "cid:$cid";
         });
 
+    Passing a URL, HTML::RewriteAttributes::Links can update resources like
+    "href"s or "img"s to include the base URL, changing "<img
+    src="/bar.gif">" to "<img src="https://search.cpan.org/bar.gif">". See
+    also HTML::ResolveLink.
 
-        # up for some HTML::ResolveLink?
-        $html = HTML::RewriteAttributes::Links->rewrite($html, "http://search.cpan.org");
+        $html = HTML::RewriteAttributes::Links->rewrite($html, "https://search.cpan.org");
+
+        # Passing a subroutine reference, L<HTML::RewriteAttributes::Links> can
+        # extract all links, similar to L<HTML::LinkExtor>.
 
-        # or perhaps HTML::LinkExtor?
         HTML::RewriteAttributes::Links->rewrite($html, sub {
             my ($tag, $attr, $value) = @_;
             push @links, $value;
@@ -41,7 +64,10 @@ DESCRIPTION
     rest for you.
 
     This module is designed to be subclassable to make handling special
-    cases eaiser. See the source for methods you can override.
+    cases easier. See the source for methods you can override.
+
+    See the SYNOPSIS above and included tests in the "t" directory for more
+    examples.
 
 METHODS
   "new"
@@ -53,10 +79,20 @@ METHODS
     callback, the callback is invoked potentially many times, and you get
     back some similar HTML.
 
-    The callback receives as arguments the tag name, the attribute name, and
-    the attribute value (though subclasses may override this --
-    HTML::RewriteAttributes::Resources does). Return "undef" to remove the
-    attribute, or any other value to set the value of the attribute.
+    As "rewrite" parses the HTML block, it calls the provided callback,
+    passing as arguments the current tag name, the attribute name, and the
+    attribute value (though subclasses may override this --
+    HTML::RewriteAttributes::Resources does). The callback can then use the
+    arguments to determine if you want to change the current tag or
+    attribute, or skip it by returning the current value unchanged. If you
+    find the tag and attribute you want to change, return "undef" to remove
+    the attribute, or any other value to set the value of the attribute.
+
+    The callback also is passed a hashref $attrs which has keys for
+    attributes and values with the current values. Finally $attr_list is
+    passed as an arrayref contain all attributes for the current tag. To add
+    a new attribute, add the attribute name to the $attr_list arrayref, and
+    add the new value to $attrs.
 
 SEE ALSO
     HTML::Parser, HTML::ResolveLink, Email::MIME::CreateHTML,
@@ -67,10 +103,10 @@ THANKS
     HTML::ResolveLink.
 
 AUTHOR
-    Shawn M Moore, "<sartak@bestpractical.com>"
+    Best Practical Solutions, LLC <modules@bestpractical.com>
 
 LICENSE
-    Copyright 2008-2010 Best Practical Solutions, LLC.
+    Copyright 2008-2024 Best Practical Solutions, LLC.
     HTML::RewriteAttributes is distributed under the same terms as Perl
     itself.
 
diff -pruN 0.05-3/SIGNATURE 0.06-1/SIGNATURE
--- 0.05-3/SIGNATURE	2012-10-22 22:14:16.000000000 +0000
+++ 0.06-1/SIGNATURE	1970-01-01 00:00:00.000000000 +0000
@@ -1,52 +0,0 @@
-This file contains message digests of all files listed in MANIFEST,
-signed via the Module::Signature module, version 0.68.
-
-To verify the content in this distribution, first make sure you have
-Module::Signature installed, then type:
-
-    % cpansign -v
-
-It will check each file's integrity, as well as the signature's
-validity.  If "==> Signature verified OK! <==" is not displayed,
-the distribution may already have been compromised, and you should
-not run its Makefile.PL or Build.PL.
-
------BEGIN PGP SIGNED MESSAGE-----
-Hash: SHA1
-
-SHA1 d0e286477b95832aa494f325113e7e320b44e73e Changes
-SHA1 944e15e3414d90d1e4fdb456b1c4a7efa0a7c8ca MANIFEST
-SHA1 45c5a75eda6089e9e23fad201b41f63b8c9bb504 MANIFEST.SKIP
-SHA1 bbd2da5709def05d6b55e4d829072610cdd3651a META.yml
-SHA1 710580665bac8a12510c1a1db12aa6f84e0a611f Makefile.PL
-SHA1 b79b7618ecea16ce2d48091efffd69d16f42005d README
-SHA1 8a924add836b60fb23b25c8506d45945e02f42f4 inc/Module/Install.pm
-SHA1 2d0fad3bf255f8c1e7e1e34eafccc4f595603ddc inc/Module/Install/Base.pm
-SHA1 f0e01fff7d73cd145fbf22331579918d4628ddb0 inc/Module/Install/Can.pm
-SHA1 7328966e4fda0c8451a6d3850704da0b84ac1540 inc/Module/Install/Fetch.pm
-SHA1 b62ca5e2d58fa66766ccf4d64574f9e1a2250b34 inc/Module/Install/Makefile.pm
-SHA1 1aa925be410bb3bfcd84a16985921f66073cc1d2 inc/Module/Install/Metadata.pm
-SHA1 a3cff7ab08b95ee312b7e9381eb72f42e309c842 inc/Module/Install/ReadmeFromPod.pm
-SHA1 e4196994fa75e98bdfa2be0bdeeffef66de88171 inc/Module/Install/Win32.pm
-SHA1 c3a6d0d5b84feb3280622e9599e86247d58b0d18 inc/Module/Install/WriteAll.pm
-SHA1 f3bae457e4bbec8afcf6abefea8161427308c1ce lib/HTML/RewriteAttributes.pm
-SHA1 50b0d8f9eaf6a40fd1e34bc2744d41d8a1b3a477 lib/HTML/RewriteAttributes/Links.pm
-SHA1 ba9643a4435368494357328454e4bb2a185d55a0 lib/HTML/RewriteAttributes/Resources.pm
-SHA1 5d97ad6516b8aea70d9979934492c8cbe7e88409 t/000-synopsis.t
-SHA1 ee0edb567e91ef5fc3df0e1c0771776b229e2aa2 t/001-basic.t
-SHA1 7fb822373f163cdb0fb54bd2a9f55dabe36e025f t/002-resources.t
-SHA1 3c749328abb70da542ca0e42602fb6456a9d9780 t/003-links.t
-SHA1 301b59c6176775286333388dc539d524f3ee1635 t/004-misc.t
-SHA1 3269dcbb500cb5d4905ed442c030fedac40bea34 t/005-links-code.t
-SHA1 c511d1917a9ea1e486e643193c8ca99e8522f11e t/010-resolvelink.t
-SHA1 a451823d4e5961b24202618b99cac7c79e641b05 t/020-inline-css.t
-SHA1 a901c2673f095455484bf8fe493768fe292e68fa t/021-import.t
-SHA1 33065c367ab56b3a7bcdd55afb920828f52086c3 t/022-import-off.t
-SHA1 5df911d7ef2cfb8566628153cd565c4da1aa723d t/023-import-comment.t
------BEGIN PGP SIGNATURE-----
-Version: GnuPG v1.4.11 (GNU/Linux)
-
-iD8DBQFQhcU4Hdv9ZfNcOAcRAgBmAJ9GyWI/6iOU7ONziG7rSq9NxUdCDQCfZFAO
-XXl0MHJLJLNol1vjzNI7o94=
-=ID9F
------END PGP SIGNATURE-----
diff -pruN 0.05-3/debian/changelog 0.06-1/debian/changelog
--- 0.05-3/debian/changelog	2022-12-10 22:59:30.000000000 +0000
+++ 0.06-1/debian/changelog	2024-11-15 23:55:28.000000000 +0000
@@ -1,3 +1,15 @@
+libhtml-rewriteattributes-perl (0.06-1) unstable; urgency=medium
+
+  * Team upload.
+  * Import upstream version 0.06.
+  * Update years of upstream copyright.
+  * Drop patches, both applied upstream.
+  * Declare compliance with Debian Policy 4.7.0.
+  * Set Rules-Requires-Root: no.
+  * Annotate test-only build dependencies with <!nocheck>.
+
+ -- gregor herrmann <gregoa@debian.org>  Sat, 16 Nov 2024 00:55:28 +0100
+
 libhtml-rewriteattributes-perl (0.05-3) unstable; urgency=medium
 
   [ Xavier Guimard ]
diff -pruN 0.05-3/debian/control 0.06-1/debian/control
--- 0.05-3/debian/control	2022-12-10 22:59:30.000000000 +0000
+++ 0.06-1/debian/control	2024-11-15 23:55:28.000000000 +0000
@@ -6,15 +6,17 @@ Uploaders: Niko Tyni <ntyni@debian.org>,
 Section: perl
 Testsuite: autopkgtest-pkg-perl
 Priority: optional
-Build-Depends: debhelper-compat (= 13), libmodule-install-perl
-Build-Depends-Indep: libhtml-parser-perl,
-                     libhtml-tagset-perl,
-                     liburi-perl,
+Build-Depends: debhelper-compat (= 13),
+               libmodule-install-perl
+Build-Depends-Indep: libhtml-parser-perl <!nocheck>,
+                     libhtml-tagset-perl <!nocheck>,
+                     liburi-perl <!nocheck>,
                      perl
-Standards-Version: 4.2.1
+Standards-Version: 4.7.0
 Vcs-Browser: https://salsa.debian.org/perl-team/modules/packages/libhtml-rewriteattributes-perl
 Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libhtml-rewriteattributes-perl.git
 Homepage: https://metacpan.org/release/HTML-RewriteAttributes
+Rules-Requires-Root: no
 
 Package: libhtml-rewriteattributes-perl
 Architecture: all
diff -pruN 0.05-3/debian/copyright 0.06-1/debian/copyright
--- 0.05-3/debian/copyright	2022-12-10 22:59:30.000000000 +0000
+++ 0.06-1/debian/copyright	2024-11-15 23:55:28.000000000 +0000
@@ -4,7 +4,7 @@ Upstream-Contact: Thomas Sibley <tsibley
 Source: https://metacpan.org/release/HTML-RewriteAttributes
 
 Files: *
-Copyright: 2008-2010, Best Practical Solutions, LLC.
+Copyright: 2008-2024, Best Practical Solutions, LLC.
 License: Artistic or GPL-1+
 
 Files: inc/Module/*
diff -pruN 0.05-3/debian/patches/remove-useless-interpreter.patch 0.06-1/debian/patches/remove-useless-interpreter.patch
--- 0.05-3/debian/patches/remove-useless-interpreter.patch	2022-12-10 22:59:30.000000000 +0000
+++ 0.06-1/debian/patches/remove-useless-interpreter.patch	1970-01-01 00:00:00.000000000 +0000
@@ -1,27 +0,0 @@
-Description: remove useless interpreter
- Just to avoid Lintian warning
-Author: Xavier Guimard <x.guimard@free.fr>
-Forwarded: not-needed
-Last-Update: 2018-08-27
-
---- a/lib/HTML/RewriteAttributes.pm
-+++ b/lib/HTML/RewriteAttributes.pm
-@@ -1,4 +1,3 @@
--#!/usr/bin/env perl
- package HTML::RewriteAttributes;
- use strict;
- use warnings;
---- a/lib/HTML/RewriteAttributes/Links.pm
-+++ b/lib/HTML/RewriteAttributes/Links.pm
-@@ -1,4 +1,3 @@
--#!/usr/bin/env perl
- package HTML::RewriteAttributes::Links;
- use strict;
- use warnings;
---- a/lib/HTML/RewriteAttributes/Resources.pm
-+++ b/lib/HTML/RewriteAttributes/Resources.pm
-@@ -1,4 +1,3 @@
--#!/usr/bin/env perl
- package HTML::RewriteAttributes::Resources;
- use strict;
- use warnings;
diff -pruN 0.05-3/debian/patches/series 0.06-1/debian/patches/series
--- 0.05-3/debian/patches/series	2022-12-10 22:59:30.000000000 +0000
+++ 0.06-1/debian/patches/series	1970-01-01 00:00:00.000000000 +0000
@@ -1,2 +0,0 @@
-spelling-errors.patch
-remove-useless-interpreter.patch
diff -pruN 0.05-3/debian/patches/spelling-errors.patch 0.06-1/debian/patches/spelling-errors.patch
--- 0.05-3/debian/patches/spelling-errors.patch	2022-12-10 22:59:30.000000000 +0000
+++ 0.06-1/debian/patches/spelling-errors.patch	1970-01-01 00:00:00.000000000 +0000
@@ -1,16 +0,0 @@
-Description: spelling error
-Author: Xavier Guimard <x.guimard@free.fr>
-Forwarded: https://rt.cpan.org/Ticket/Display.html?id=126964
-Last-Update: 2018-08-27
-
---- a/lib/HTML/RewriteAttributes.pm
-+++ b/lib/HTML/RewriteAttributes.pm
-@@ -142,7 +142,7 @@
- for you.
- 
- This module is designed to be subclassable to make handling special cases
--eaiser. See the source for methods you can override.
-+easier. See the source for methods you can override.
- 
- =head1 METHODS
- 
diff -pruN 0.05-3/inc/Module/Install/Base.pm 0.06-1/inc/Module/Install/Base.pm
--- 0.05-3/inc/Module/Install/Base.pm	2012-10-22 22:14:10.000000000 +0000
+++ 0.06-1/inc/Module/Install/Base.pm	2024-11-12 19:03:48.000000000 +0000
@@ -4,7 +4,7 @@ package Module::Install::Base;
 use strict 'vars';
 use vars qw{$VERSION};
 BEGIN {
-	$VERSION = '1.06';
+	$VERSION = '1.21';
 }
 
 # Suspend handler for "redefined" warnings
diff -pruN 0.05-3/inc/Module/Install/Can.pm 0.06-1/inc/Module/Install/Can.pm
--- 0.05-3/inc/Module/Install/Can.pm	2012-10-22 22:14:10.000000000 +0000
+++ 0.06-1/inc/Module/Install/Can.pm	2024-11-12 19:03:48.000000000 +0000
@@ -8,7 +8,7 @@ use Module::Install::Base ();
 
 use vars qw{$VERSION @ISA $ISCORE};
 BEGIN {
-	$VERSION = '1.06';
+	$VERSION = '1.21';
 	@ISA     = 'Module::Install::Base';
 	$ISCORE  = 1;
 }
@@ -121,6 +121,15 @@ END_C
 # Can we locate a (the) C compiler
 sub can_cc {
 	my $self   = shift;
+
+	if ($^O eq 'VMS') {
+		require ExtUtils::CBuilder;
+		my $builder = ExtUtils::CBuilder->new(
+		quiet => 1,
+		);
+		return $builder->have_compiler;
+	}
+
 	my @chunks = split(/ /, $Config::Config{cc}) or return;
 
 	# $Config{cc} may contain args; try to find out the program part
@@ -151,4 +160,4 @@ if ( $^O eq 'cygwin' ) {
 
 __END__
 
-#line 236
+#line 245
diff -pruN 0.05-3/inc/Module/Install/Fetch.pm 0.06-1/inc/Module/Install/Fetch.pm
--- 0.05-3/inc/Module/Install/Fetch.pm	2012-10-22 22:14:10.000000000 +0000
+++ 0.06-1/inc/Module/Install/Fetch.pm	2024-11-12 19:03:48.000000000 +0000
@@ -6,7 +6,7 @@ use Module::Install::Base ();
 
 use vars qw{$VERSION @ISA $ISCORE};
 BEGIN {
-	$VERSION = '1.06';
+	$VERSION = '1.21';
 	@ISA     = 'Module::Install::Base';
 	$ISCORE  = 1;
 }
diff -pruN 0.05-3/inc/Module/Install/Makefile.pm 0.06-1/inc/Module/Install/Makefile.pm
--- 0.05-3/inc/Module/Install/Makefile.pm	2012-10-22 22:14:10.000000000 +0000
+++ 0.06-1/inc/Module/Install/Makefile.pm	2024-11-12 19:03:48.000000000 +0000
@@ -8,7 +8,7 @@ use Fcntl qw/:flock :seek/;
 
 use vars qw{$VERSION @ISA $ISCORE};
 BEGIN {
-	$VERSION = '1.06';
+	$VERSION = '1.21';
 	@ISA     = 'Module::Install::Base';
 	$ISCORE  = 1;
 }
@@ -133,7 +133,7 @@ sub makemaker_args {
 	return $args;
 }
 
-# For mm args that take multiple space-seperated args,
+# For mm args that take multiple space-separated args,
 # append an argument to the current list.
 sub makemaker_append {
 	my $self = shift;
diff -pruN 0.05-3/inc/Module/Install/Metadata.pm 0.06-1/inc/Module/Install/Metadata.pm
--- 0.05-3/inc/Module/Install/Metadata.pm	2012-10-22 22:14:10.000000000 +0000
+++ 0.06-1/inc/Module/Install/Metadata.pm	2024-11-12 19:03:48.000000000 +0000
@@ -6,7 +6,7 @@ use Module::Install::Base ();
 
 use vars qw{$VERSION @ISA $ISCORE};
 BEGIN {
-	$VERSION = '1.06';
+	$VERSION = '1.21';
 	@ISA     = 'Module::Install::Base';
 	$ISCORE  = 1;
 }
@@ -347,7 +347,7 @@ sub name_from {
 		^ \s*
 		package \s*
 		([\w:]+)
-		\s* ;
+		[\s|;]*
 		/ixms
 	) {
 		my ($name, $module_name) = ($1, $1);
@@ -455,12 +455,8 @@ sub author_from {
 my %license_urls = (
     perl         => 'http://dev.perl.org/licenses/',
     apache       => 'http://apache.org/licenses/LICENSE-2.0',
-    apache_1_1   => 'http://apache.org/licenses/LICENSE-1.1',
     artistic     => 'http://opensource.org/licenses/artistic-license.php',
-    artistic_2   => 'http://opensource.org/licenses/artistic-license-2.0.php',
     lgpl         => 'http://opensource.org/licenses/lgpl-license.php',
-    lgpl2        => 'http://opensource.org/licenses/lgpl-2.1.php',
-    lgpl3        => 'http://opensource.org/licenses/lgpl-3.0.html',
     bsd          => 'http://opensource.org/licenses/bsd-license.php',
     gpl          => 'http://opensource.org/licenses/gpl-license.php',
     gpl2         => 'http://opensource.org/licenses/gpl-2.0.php',
@@ -471,6 +467,12 @@ my %license_urls = (
     unrestricted => undef,
     restrictive  => undef,
     unknown      => undef,
+
+    # these are not actually allowed in meta-spec v1.4 but are left here for compatibility:
+    apache_1_1   => 'http://apache.org/licenses/LICENSE-1.1',
+    artistic_2   => 'http://opensource.org/licenses/artistic-license-2.0.php',
+    lgpl2        => 'http://opensource.org/licenses/lgpl-2.1.php',
+    lgpl3        => 'http://opensource.org/licenses/lgpl-3.0.html',
 );
 
 sub license {
@@ -705,7 +707,7 @@ sub _write_mymeta_data {
 	my @yaml = Parse::CPAN::Meta::LoadFile('META.yml');
 	my $meta = $yaml[0];
 
-	# Overwrite the non-configure dependency hashs
+	# Overwrite the non-configure dependency hashes
 	delete $meta->{requires};
 	delete $meta->{build_requires};
 	delete $meta->{recommends};
diff -pruN 0.05-3/inc/Module/Install/ReadmeFromPod.pm 0.06-1/inc/Module/Install/ReadmeFromPod.pm
--- 0.05-3/inc/Module/Install/ReadmeFromPod.pm	2012-10-22 22:14:10.000000000 +0000
+++ 0.06-1/inc/Module/Install/ReadmeFromPod.pm	2024-11-12 19:03:48.000000000 +0000
@@ -7,12 +7,41 @@ use warnings;
 use base qw(Module::Install::Base);
 use vars qw($VERSION);
 
-$VERSION = '0.18';
+$VERSION = '0.30';
+
+{
+
+    # these aren't defined until after _require_admin is run, so
+    # define them so prototypes are available during compilation.
+    sub io;
+    sub capture(&;@);
+
+#line 28
+
+    my $done = 0;
+
+    sub _require_admin {
+
+	# do this once to avoid redefinition warnings from IO::All
+	return if $done;
+
+	require IO::All;
+	IO::All->import( '-binary' );
+
+	require Capture::Tiny;
+	Capture::Tiny->import ( 'capture' );
+
+	return;
+    }
+
+}
 
 sub readme_from {
   my $self = shift;
   return unless $self->is_admin;
 
+  _require_admin;
+
   # Input file
   my $in_file  = shift || $self->_all_from
     or die "Can't determine file to make readme_from";
@@ -50,6 +79,8 @@ sub readme_from {
     $out_file = $self->_readme_htm($in_file, $out_file, $options);
   } elsif ($format eq 'man') {
     $out_file = $self->_readme_man($in_file, $out_file, $options);
+  } elsif ($format eq 'md') {
+    $out_file = $self->_readme_md($in_file, $out_file, $options);
   } elsif ($format eq 'pdf') {
     $out_file = $self->_readme_pdf($in_file, $out_file, $options);
   }
@@ -67,10 +98,10 @@ sub _readme_txt {
   $out_file ||= 'README';
   require Pod::Text;
   my $parser = Pod::Text->new( @$options );
-  open my $out_fh, '>', $out_file or die "Could not write file $out_file:\n$!\n";
+  my $io = io->file($out_file)->open(">");
+  my $out_fh = $io->io_handle;
   $parser->output_fh( *$out_fh );
   $parser->parse_file( $in_file );
-  close $out_fh;
   return $out_file;
 }
 
@@ -79,11 +110,14 @@ sub _readme_htm {
   my ($self, $in_file, $out_file, $options) = @_;
   $out_file ||= 'README.htm';
   require Pod::Html;
-  Pod::Html::pod2html(
-    "--infile=$in_file",
-    "--outfile=$out_file",
-    @$options,
-  );
+  my ($o) = capture {
+    Pod::Html::pod2html(
+      "--infile=$in_file",
+      "--outfile=-",
+      @$options,
+    );
+  };
+  io->file($out_file)->print($o);
   # Remove temporary files if needed
   for my $file ('pod2htmd.tmp', 'pod2htmi.tmp') {
     if (-e $file) {
@@ -99,7 +133,10 @@ sub _readme_man {
   $out_file ||= 'README.1';
   require Pod::Man;
   my $parser = Pod::Man->new( @$options );
-  $parser->parse_from_file($in_file, $out_file);
+  my $io = io->file($out_file)->open(">");
+  my $out_fh = $io->io_handle;
+  $parser->output_fh( *$out_fh );
+  $parser->parse_file( $in_file );
   return $out_file;
 }
 
@@ -111,11 +148,20 @@ sub _readme_pdf {
     or die "Could not generate $out_file because pod2pdf could not be found\n";
   my $parser = App::pod2pdf->new( @$options );
   $parser->parse_from_file($in_file);
-  open my $out_fh, '>', $out_file or die "Could not write file $out_file:\n$!\n";
-  select $out_fh;
-  $parser->output;
-  select STDOUT;
-  close $out_fh;
+  my ($o) = capture { $parser->output };
+  io->file($out_file)->print($o);
+  return $out_file;
+}
+
+sub _readme_md {
+  my ($self, $in_file, $out_file, $options) = @_;
+  $out_file ||= 'README.md';
+  require Pod::Markdown;
+  my $parser = Pod::Markdown->new( @$options );
+  my $io = io->file($out_file)->open(">");
+  my $out_fh = $io->io_handle;
+  $parser->output_fh( *$out_fh );
+  $parser->parse_file( $in_file );
   return $out_file;
 }
 
@@ -134,5 +180,5 @@ sub _all_from {
 
 __END__
 
-#line 254
+#line 316
 
diff -pruN 0.05-3/inc/Module/Install/Win32.pm 0.06-1/inc/Module/Install/Win32.pm
--- 0.05-3/inc/Module/Install/Win32.pm	2012-10-22 22:14:10.000000000 +0000
+++ 0.06-1/inc/Module/Install/Win32.pm	2024-11-12 19:03:48.000000000 +0000
@@ -6,7 +6,7 @@ use Module::Install::Base ();
 
 use vars qw{$VERSION @ISA $ISCORE};
 BEGIN {
-	$VERSION = '1.06';
+	$VERSION = '1.21';
 	@ISA     = 'Module::Install::Base';
 	$ISCORE  = 1;
 }
diff -pruN 0.05-3/inc/Module/Install/WriteAll.pm 0.06-1/inc/Module/Install/WriteAll.pm
--- 0.05-3/inc/Module/Install/WriteAll.pm	2012-10-22 22:14:10.000000000 +0000
+++ 0.06-1/inc/Module/Install/WriteAll.pm	2024-11-12 19:03:48.000000000 +0000
@@ -6,7 +6,7 @@ use Module::Install::Base ();
 
 use vars qw{$VERSION @ISA $ISCORE};
 BEGIN {
-	$VERSION = '1.06';
+	$VERSION = '1.21';
 	@ISA     = qw{Module::Install::Base};
 	$ISCORE  = 1;
 }
diff -pruN 0.05-3/inc/Module/Install.pm 0.06-1/inc/Module/Install.pm
--- 0.05-3/inc/Module/Install.pm	2012-10-22 22:14:10.000000000 +0000
+++ 0.06-1/inc/Module/Install.pm	2024-11-12 19:03:48.000000000 +0000
@@ -17,7 +17,7 @@ package Module::Install;
 #     3. The ./inc/ version of Module::Install loads
 # }
 
-use 5.005;
+use 5.006;
 use strict 'vars';
 use Cwd        ();
 use File::Find ();
@@ -31,7 +31,7 @@ BEGIN {
 	# This is not enforced yet, but will be some time in the next few
 	# releases once we can make sure it won't clash with custom
 	# Module::Install extensions.
-	$VERSION = '1.06';
+	$VERSION = '1.21';
 
 	# Storage for the pseudo-singleton
 	$MAIN    = undef;
@@ -156,10 +156,10 @@ END_DIE
 sub autoload {
 	my $self = shift;
 	my $who  = $self->_caller;
-	my $cwd  = Cwd::cwd();
+	my $cwd  = Cwd::getcwd();
 	my $sym  = "${who}::AUTOLOAD";
 	$sym->{$cwd} = sub {
-		my $pwd = Cwd::cwd();
+		my $pwd = Cwd::getcwd();
 		if ( my $code = $sym->{$pwd} ) {
 			# Delegate back to parent dirs
 			goto &$code unless $cwd eq $pwd;
@@ -239,11 +239,13 @@ sub new {
 
 	# ignore the prefix on extension modules built from top level.
 	my $base_path = Cwd::abs_path($FindBin::Bin);
-	unless ( Cwd::abs_path(Cwd::cwd()) eq $base_path ) {
+	unless ( Cwd::abs_path(Cwd::getcwd()) eq $base_path ) {
 		delete $args{prefix};
 	}
 	return $args{_self} if $args{_self};
 
+	$base_path = VMS::Filespec::unixify($base_path) if $^O eq 'VMS';
+
 	$args{dispatch} ||= 'Admin';
 	$args{prefix}   ||= 'inc';
 	$args{author}   ||= ($^O eq 'VMS' ? '_author' : '.author');
@@ -322,7 +324,7 @@ sub find_extensions {
 	my ($self, $path) = @_;
 
 	my @found;
-	File::Find::find( sub {
+	File::Find::find( {no_chdir => 1, wanted => sub {
 		my $file = $File::Find::name;
 		return unless $file =~ m!^\Q$path\E/(.+)\.pm\Z!is;
 		my $subpath = $1;
@@ -336,9 +338,9 @@ sub find_extensions {
 		# correctly.  Otherwise, root through the file to locate the case-preserved
 		# version of the package name.
 		if ( $subpath eq lc($subpath) || $subpath eq uc($subpath) ) {
-			my $content = Module::Install::_read($subpath . '.pm');
+			my $content = Module::Install::_read($File::Find::name);
 			my $in_pod  = 0;
-			foreach ( split //, $content ) {
+			foreach ( split /\n/, $content ) {
 				$in_pod = 1 if /^=\w/;
 				$in_pod = 0 if /^=cut/;
 				next if ($in_pod || /^=cut/);  # skip pod text
@@ -351,7 +353,7 @@ sub find_extensions {
 		}
 
 		push @found, [ $file, $pkg ];
-	}, $path ) if -d $path;
+	}}, $path ) if -d $path;
 
 	@found;
 }
@@ -373,24 +375,14 @@ sub _caller {
 	return $call;
 }
 
-# Done in evals to avoid confusing Perl::MinimumVersion
-eval( $] >= 5.006 ? <<'END_NEW' : <<'END_OLD' ); die $@ if $@;
 sub _read {
 	local *FH;
 	open( FH, '<', $_[0] ) or die "open($_[0]): $!";
+	binmode FH;
 	my $string = do { local $/; <FH> };
 	close FH or die "close($_[0]): $!";
 	return $string;
 }
-END_NEW
-sub _read {
-	local *FH;
-	open( FH, "< $_[0]"  ) or die "open($_[0]): $!";
-	my $string = do { local $/; <FH> };
-	close FH or die "close($_[0]): $!";
-	return $string;
-}
-END_OLD
 
 sub _readperl {
 	my $string = Module::Install::_read($_[0]);
@@ -411,30 +403,19 @@ sub _readpod {
 	return $string;
 }
 
-# Done in evals to avoid confusing Perl::MinimumVersion
-eval( $] >= 5.006 ? <<'END_NEW' : <<'END_OLD' ); die $@ if $@;
 sub _write {
 	local *FH;
 	open( FH, '>', $_[0] ) or die "open($_[0]): $!";
+	binmode FH;
 	foreach ( 1 .. $#_ ) {
 		print FH $_[$_] or die "print($_[0]): $!";
 	}
 	close FH or die "close($_[0]): $!";
 }
-END_NEW
-sub _write {
-	local *FH;
-	open( FH, "> $_[0]"  ) or die "open($_[0]): $!";
-	foreach ( 1 .. $#_ ) {
-		print FH $_[$_] or die "print($_[0]): $!";
-	}
-	close FH or die "close($_[0]): $!";
-}
-END_OLD
 
 # _version is for processing module versions (eg, 1.03_05) not
 # Perl versions (eg, 5.8.1).
-sub _version ($) {
+sub _version {
 	my $s = shift || 0;
 	my $d =()= $s =~ /(\.)/g;
 	if ( $d >= 2 ) {
@@ -450,12 +431,12 @@ sub _version ($) {
 	return $l + 0;
 }
 
-sub _cmp ($$) {
+sub _cmp {
 	_version($_[1]) <=> _version($_[2]);
 }
 
 # Cloned from Params::Util::_CLASS
-sub _CLASS ($) {
+sub _CLASS {
 	(
 		defined $_[0]
 		and
diff -pruN 0.05-3/lib/HTML/RewriteAttributes/Links.pm 0.06-1/lib/HTML/RewriteAttributes/Links.pm
--- 0.05-3/lib/HTML/RewriteAttributes/Links.pm	2010-11-24 15:57:51.000000000 +0000
+++ 0.06-1/lib/HTML/RewriteAttributes/Links.pm	2024-11-12 19:03:44.000000000 +0000
@@ -1,4 +1,3 @@
-#!/usr/bin/env perl
 package HTML::RewriteAttributes::Links;
 use strict;
 use warnings;
@@ -103,11 +102,11 @@ L<HTML::RewriteAttributes>, L<HTML::Pars
 
 =head1 AUTHOR
 
-Shawn M Moore, C<< <sartak@bestpractical.com> >>
+Best Practical Solutions, LLC <modules@bestpractical.com>
 
 =head1 LICENSE
 
-Copyright 2008-2010 Best Practical Solutions, LLC.
+Copyright 2008-2024 Best Practical Solutions, LLC.
 HTML::RewriteAttributes::Links is distributed under the same terms as Perl itself.
 
 =cut
diff -pruN 0.05-3/lib/HTML/RewriteAttributes/Resources.pm 0.06-1/lib/HTML/RewriteAttributes/Resources.pm
--- 0.05-3/lib/HTML/RewriteAttributes/Resources.pm	2012-10-22 21:46:17.000000000 +0000
+++ 0.06-1/lib/HTML/RewriteAttributes/Resources.pm	2024-11-12 19:03:44.000000000 +0000
@@ -1,4 +1,3 @@
-#!/usr/bin/env perl
 package HTML::RewriteAttributes::Resources;
 use strict;
 use warnings;
@@ -39,9 +38,10 @@ sub _should_rewrite {
 
 sub _invoke_callback {
     my $self = shift;
-    my ($tag, $attr, $value) = @_;
+    my ($tag, $attr, $value, $attrs, $attr_list) = @_;
 
-    return $self->{rewrite_callback}->($value, tag => $tag, attr => $attr, rewriter => $self);
+    return $self->{rewrite_callback}
+        ->( $value, tag => $tag, attr => $attr, rewriter => $self, attrs => $attrs, attr_list => $attr_list );
 }
 
 sub _start_tag {
@@ -203,11 +203,11 @@ L<HTML::RewriteAttributes>, L<HTML::Pars
 
 =head1 AUTHOR
 
-Shawn M Moore, C<< <sartak@bestpractical.com> >>
+Best Practical Solutions, LLC <modules@bestpractical.com>
 
 =head1 LICENSE
 
-Copyright 2008-2010 Best Practical Solutions, LLC.
+Copyright 2008-2024 Best Practical Solutions, LLC.
 HTML::RewriteAttributes::Resources is distributed under the same terms as Perl itself.
 
 =cut
diff -pruN 0.05-3/lib/HTML/RewriteAttributes.pm 0.06-1/lib/HTML/RewriteAttributes.pm
--- 0.05-3/lib/HTML/RewriteAttributes.pm	2012-10-22 22:13:42.000000000 +0000
+++ 0.06-1/lib/HTML/RewriteAttributes.pm	2024-11-12 19:03:44.000000000 +0000
@@ -1,4 +1,3 @@
-#!/usr/bin/env perl
 package HTML::RewriteAttributes;
 use strict;
 use warnings;
@@ -6,7 +5,7 @@ use base 'HTML::Parser';
 use Carp 'croak';
 use HTML::Entities 'encode_entities';
 
-our $VERSION = '0.05';
+our $VERSION = '0.06';
 
 sub new {
     my $class = shift;
@@ -63,17 +62,20 @@ sub _start_tag {
 
     $self->{rewrite_html} .= "<$tag";
 
+    my @attr_list;
     for my $attr (@$attrseq) {
         next if $attr eq '/';
 
         if ($self->_should_rewrite($tag, $attr)) {
-            $attrs->{$attr} = $self->_invoke_callback($tag, $attr, $attrs->{$attr});
+            $attrs->{$attr} = $self->_invoke_callback($tag, $attr, $attrs->{$attr}, $attrs, \@attr_list);
             next if !defined($attrs->{$attr});
         }
 
-        $self->{rewrite_html} .= sprintf ' %s="%s"',
-                                    $attr,
-                                    encode_entities($attrs->{$attr});
+        push @attr_list, $attr;
+    }
+
+    for my $attr (@attr_list) {
+        $self->{rewrite_html} .= sprintf ' %s="%s"', $attr, encode_entities( $attrs->{$attr} );
     }
 
     $self->{rewrite_html} .= ' /' if $attrs->{'/'};
@@ -87,9 +89,7 @@ sub _default {
 
 sub _invoke_callback {
     my $self = shift;
-    my ($tag, $attr, $value) = @_;
-
-    return $self->{rewrite_callback}->($tag, $attr, $value);
+    return $self->{rewrite_callback}->(@_);
 }
 
 1;
@@ -102,6 +102,12 @@ HTML::RewriteAttributes - concise attrib
 
 =head1 SYNOPSIS
 
+Locate a tag in a provided block of HTML and delete, add, or
+rewrite the attributes associated with that tag. The updated
+HTML is returned.
+
+Delete an attribute by returning undef.
+
     $html = HTML::RewriteAttributes->rewrite($html, sub {
         my ($tag, $attr, $value) = @_;
 
@@ -112,8 +118,22 @@ HTML::RewriteAttributes - concise attrib
         return $value;
     });
 
+Add an attribute by appending it to the C<$attr_list> arrayref
+and adding the value to the C<$attrs> hashref. For example,
+you could add C<loading="lazy"> to all C<img> tags.
+
+    $html = HTML::RewriteAttributes->rewrite($html, sub {
+        my ( $tag, $attr, $value, $attrs, $attr_list ) = @_;
+        return $value unless $tag eq 'img' && !$attrs->{loading};
+        $attrs->{loading} = 'lazy';
+        push @$attr_list, 'loading';
+        return $value;
+    });
+
+Modify an existing attribute by returning the new value.
+The example below would be a C<src> attribute for an C<img>
+in an email.
 
-    # writing some HTML email I see..
     $html = HTML::RewriteAttributes::Resources->rewrite($html, sub {
         my $uri = shift;
         my $content = render_template($uri);
@@ -122,11 +142,16 @@ HTML::RewriteAttributes - concise attrib
         return "cid:$cid";
     });
 
+Passing a URL, L<HTML::RewriteAttributes::Links> can update resources
+like C<href>s or C<img>s to include the base URL, changing
+C<E<lt>img src="/bar.gif"E<gt>> to C<E<lt>img src="https://search.cpan.org/bar.gif"E<gt>>.
+See also L<HTML::ResolveLink>.
+
+    $html = HTML::RewriteAttributes::Links->rewrite($html, "https://search.cpan.org");
 
-    # up for some HTML::ResolveLink?
-    $html = HTML::RewriteAttributes::Links->rewrite($html, "http://search.cpan.org");
+    # Passing a subroutine reference, L<HTML::RewriteAttributes::Links> can
+    # extract all links, similar to L<HTML::LinkExtor>.
 
-    # or perhaps HTML::LinkExtor?
     HTML::RewriteAttributes::Links->rewrite($html, sub {
         my ($tag, $attr, $value) = @_;
         push @links, $value;
@@ -142,7 +167,10 @@ You simply specify a callback to run for
 for you.
 
 This module is designed to be subclassable to make handling special cases
-eaiser. See the source for methods you can override.
+easier. See the source for methods you can override.
+
+See the SYNOPSIS above and included tests in the C<t> directory for more
+examples.
 
 =head1 METHODS
 
@@ -157,10 +185,20 @@ This is the main interface of the module
 the callback is invoked potentially many times, and you get back some similar
 HTML.
 
-The callback receives as arguments the tag name, the attribute name, and the
+As C<rewrite> parses the HTML block, it calls the provided callback,
+passing as arguments the current tag name, the attribute name, and the
 attribute value (though subclasses may override this --
-L<HTML::RewriteAttributes::Resources> does). Return C<undef> to remove the
-attribute, or any other value to set the value of the attribute.
+L<HTML::RewriteAttributes::Resources> does). The callback can then use the
+arguments to determine if you want to change the current tag or attribute,
+or skip it by returning the current value unchanged. If you find the tag
+and attribute you want to change, return C<undef> to remove the attribute,
+or any other value to set the value of the attribute.
+
+The callback also is passed a hashref C<$attrs> which has keys for attributes
+and values with the current values. Finally C<$attr_list> is passed as an
+arrayref contain all attributes for the current tag. To add a new attribute,
+add the attribute name to the C<$attr_list> arrayref, and add the new value
+to C<$attrs>.
 
 =head1 SEE ALSO
 
@@ -174,11 +212,11 @@ L<HTML::ResolveLink>.
 
 =head1 AUTHOR
 
-Shawn M Moore, C<< <sartak@bestpractical.com> >>
+Best Practical Solutions, LLC <modules@bestpractical.com>
 
 =head1 LICENSE
 
-Copyright 2008-2010 Best Practical Solutions, LLC.
+Copyright 2008-2024 Best Practical Solutions, LLC.
 HTML::RewriteAttributes is distributed under the same terms as Perl itself.
 
 =cut
diff -pruN 0.05-3/t/000-synopsis.t 0.06-1/t/000-synopsis.t
--- 0.05-3/t/000-synopsis.t	2010-11-24 15:57:51.000000000 +0000
+++ 0.06-1/t/000-synopsis.t	2024-11-12 19:03:44.000000000 +0000
@@ -1,7 +1,7 @@
 #!/usr/bin/env perl
 use strict;
 use warnings;
-use Test::More tests => 4;
+use Test::More tests => 5;
 
 # RewriteAttributes {{{
 my $html = << "END";
@@ -117,3 +117,35 @@ is($html, << "END", "rewrote the html co
 END
 # }}}
 
+diag 'Add an attribute';
+$html = << "END";
+<html>
+    <body background="baroque.jpg">
+        <a href="http://en.wikipedia.org/wiki/COBOL">COBOL</a><br />
+        <a href="http://en.wikipedia.org/wiki/FORTRAN">FORTRAN</a><br />
+
+        <img src="http://example.com/img/COBOL.bmp" title="COBOL rocks" />
+        <img src="http://example.com/img/FORTRAN.bmp" title="FORTRAN rocks" />
+    </body>
+</html>
+END
+
+$html = HTML::RewriteAttributes->rewrite($html, sub {
+    my ( $tag, $attr, $value, $attrs, $attr_list ) = @_;
+    return $value unless $tag eq 'img' && !$attrs->{loading};
+    $attrs->{loading} = 'lazy';
+    push @$attr_list, 'loading';
+    return $value;
+});
+
+is($html, << "END", "rewrote the html correctly");
+<html>
+    <body background="baroque.jpg">
+        <a href="http://en.wikipedia.org/wiki/COBOL">COBOL</a><br />
+        <a href="http://en.wikipedia.org/wiki/FORTRAN">FORTRAN</a><br />
+
+        <img loading="lazy" src="http://example.com/img/COBOL.bmp" title="COBOL rocks" />
+        <img loading="lazy" src="http://example.com/img/FORTRAN.bmp" title="FORTRAN rocks" />
+    </body>
+</html>
+END
