diff -pruN 0.92-1/Build.PL 0.93-1/Build.PL
--- 0.92-1/Build.PL	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/Build.PL	2025-04-28 23:22:53.000000000 +0000
@@ -7,7 +7,7 @@ use strict;
 use lib 'inc';
 require Module::Build::HiPi;
 
-our $VERSION ='0.81';
+our $VERSION ='0.93';
 
 my $requires = {
         'Try::Tiny'             => '0',
@@ -36,9 +36,6 @@ my $build = Module::Build::HiPi->new(
         'perl'          => '5.14.0',
 	    'Module::Build' => '0',
 	},
-    build_requires  => {
-        'File::Copy::Recursive' => '0'
-    },
     requires            => $requires,
 	add_to_cleanup => [
         '*.o',
diff -pruN 0.92-1/Changes 0.93-1/Changes
--- 0.92-1/Changes	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/Changes	2025-04-28 23:22:53.000000000 +0000
@@ -1,5 +1,11 @@
+Version 0.93  - 29 April 2024
+                Updated for 16GB Raspberry Pi 5
+                HiPi::Device::GPIO ( sysfs gpio interface )
+                fixed for latest gpiochip handling
+
 Version 0.92  - 28 March 2024
                 Build failures in 0.91 distribution
+
 Version 0.91  - 25 February 2024
                 Updated for latest Raspberry Pi OS
 
diff -pruN 0.92-1/META.json 0.93-1/META.json
--- 0.92-1/META.json	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/META.json	2025-04-28 23:22:53.000000000 +0000
@@ -21,11 +21,6 @@
       ]
    },
    "prereqs" : {
-      "build" : {
-         "requires" : {
-            "File::Copy::Recursive" : "0"
-         }
-      },
       "configure" : {
          "requires" : {
             "Module::Build" : "0",
@@ -52,7 +47,7 @@
    "provides" : {
       "HiPi" : {
          "file" : "lib/HiPi.pm",
-         "version" : "0.92"
+         "version" : "0.93"
       },
       "HiPi::Class" : {
          "file" : "lib/HiPi/Class.pm",
@@ -68,15 +63,15 @@
       },
       "HiPi::Device::GPIO" : {
          "file" : "lib/HiPi/Device/GPIO.pm",
-         "version" : "0.90"
+         "version" : "0.93"
       },
       "HiPi::Device::GPIO::Pin" : {
          "file" : "lib/HiPi/Device/GPIO/Pin.pm",
-         "version" : "0.90"
+         "version" : "0.93"
       },
       "HiPi::Device::I2C" : {
          "file" : "lib/HiPi/Device/I2C.pm",
-         "version" : "0.92"
+         "version" : "0.93"
       },
       "HiPi::Device::OneWire" : {
          "file" : "lib/HiPi/Device/OneWire.pm",
@@ -84,7 +79,7 @@
       },
       "HiPi::Device::SPI" : {
          "file" : "lib/HiPi/Device/SPI.pm",
-         "version" : "0.92"
+         "version" : "0.93"
       },
       "HiPi::Device::SerialPort" : {
          "file" : "lib/HiPi/Device/SerialPort.pm",
@@ -108,7 +103,7 @@
       },
       "HiPi::GPIO" : {
          "file" : "lib/HiPi/GPIO.pm",
-         "version" : "0.92"
+         "version" : "0.93"
       },
       "HiPi::GPIO::Pin" : {
          "file" : "lib/HiPi/GPIO/Pin.pm",
@@ -677,11 +672,11 @@
       },
       "HiPi::RaspberryPi" : {
          "file" : "lib/HiPi/RaspberryPi.pm",
-         "version" : "0.91"
+         "version" : "0.93"
       },
       "HiPi::Utils" : {
          "file" : "lib/HiPi/Utils.pm",
-         "version" : "0.92"
+         "version" : "0.93"
       },
       "HiPi::Utils::BitBuffer" : {
          "file" : "lib/HiPi/Utils/BitBuffer.pm",
@@ -693,7 +688,7 @@
       },
       "HiPi::Utils::Exec" : {
          "file" : "lib/HiPi/Utils/Exec.pm",
-         "version" : "0.92"
+         "version" : "0.93"
       },
       "HiPi::Utils::OLEDFont" : {
          "file" : "lib/HiPi/Utils/OLEDFont.pm",
@@ -707,6 +702,6 @@
          "http://dev.perl.org/licenses/"
       ]
    },
-   "version" : "0.92",
+   "version" : "0.93",
    "x_serialization_backend" : "JSON::PP version 4.07"
 }
diff -pruN 0.92-1/META.yml 0.93-1/META.yml
--- 0.92-1/META.yml	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/META.yml	2025-04-28 23:22:53.000000000 +0000
@@ -2,8 +2,7 @@
 abstract: 'Raspberry Pi GPIO Perl Modules'
 author:
   - 'Mark Dootson <mdootson@cpan.org>'
-build_requires:
-  File::Copy::Recursive: '0'
+build_requires: {}
 configure_requires:
   Module::Build: '0'
   perl: v5.14.0
@@ -22,7 +21,7 @@ no_index:
 provides:
   HiPi:
     file: lib/HiPi.pm
-    version: '0.92'
+    version: '0.93'
   HiPi::Class:
     file: lib/HiPi/Class.pm
     version: '0.81'
@@ -34,19 +33,19 @@ provides:
     version: '0.81'
   HiPi::Device::GPIO:
     file: lib/HiPi/Device/GPIO.pm
-    version: '0.90'
+    version: '0.93'
   HiPi::Device::GPIO::Pin:
     file: lib/HiPi/Device/GPIO/Pin.pm
-    version: '0.90'
+    version: '0.93'
   HiPi::Device::I2C:
     file: lib/HiPi/Device/I2C.pm
-    version: '0.92'
+    version: '0.93'
   HiPi::Device::OneWire:
     file: lib/HiPi/Device/OneWire.pm
     version: '0.91'
   HiPi::Device::SPI:
     file: lib/HiPi/Device/SPI.pm
-    version: '0.92'
+    version: '0.93'
   HiPi::Device::SerialPort:
     file: lib/HiPi/Device/SerialPort.pm
     version: '0.81'
@@ -64,7 +63,7 @@ provides:
     version: '0.89'
   HiPi::GPIO:
     file: lib/HiPi/GPIO.pm
-    version: '0.92'
+    version: '0.93'
   HiPi::GPIO::Pin:
     file: lib/HiPi/GPIO/Pin.pm
     version: '0.81'
@@ -490,10 +489,10 @@ provides:
     file: lib/HiPi/RF/OpenThings/Message.pm
   HiPi::RaspberryPi:
     file: lib/HiPi/RaspberryPi.pm
-    version: '0.91'
+    version: '0.93'
   HiPi::Utils:
     file: lib/HiPi/Utils.pm
-    version: '0.92'
+    version: '0.93'
   HiPi::Utils::BitBuffer:
     file: lib/HiPi/Utils/BitBuffer.pm
     version: '0.82'
@@ -502,7 +501,7 @@ provides:
     version: '0.81'
   HiPi::Utils::Exec:
     file: lib/HiPi/Utils/Exec.pm
-    version: '0.92'
+    version: '0.93'
   HiPi::Utils::OLEDFont:
     file: lib/HiPi/Utils/OLEDFont.pm
     version: '0.81'
@@ -522,5 +521,5 @@ requires:
 resources:
   homepage: http://raspberry.znix.com/
   license: http://dev.perl.org/licenses/
-version: '0.92'
+version: '0.93'
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
diff -pruN 0.92-1/debian/changelog 0.93-1/debian/changelog
--- 0.92-1/debian/changelog	2024-03-30 23:15:40.000000000 +0000
+++ 0.93-1/debian/changelog	2025-05-11 16:42:54.000000000 +0000
@@ -1,3 +1,13 @@
+libhipi-perl (0.93-1) unstable; urgency=medium
+
+  * Import upstream version 0.93.
+  * Update years of upstream and packaging copyright.
+  * Update test dependencies.
+  * Update documentation URL in package description.
+  * Declare compliance with Debian Policy 4.7.2.
+
+ -- gregor herrmann <gregoa@debian.org>  Sun, 11 May 2025 18:42:54 +0200
+
 libhipi-perl (0.92-1) unstable; urgency=medium
 
   * Import upstream version 0.92.
diff -pruN 0.92-1/debian/control 0.93-1/debian/control
--- 0.92-1/debian/control	2024-03-30 23:15:40.000000000 +0000
+++ 0.93-1/debian/control	2025-05-11 16:42:54.000000000 +0000
@@ -8,7 +8,6 @@ Build-Depends: debhelper-compat (= 13),
                libbit-vector-perl <!nocheck>,
                libdevice-serialport-perl <!nocheck>,
                libdigest-sha-perl <!nocheck>,
-               libfile-copy-recursive-perl <!nocheck>,
                libfile-slurp-perl <!nocheck>,
                libi2c-dev,
                libimage-imlib2-perl <!nocheck>,
@@ -21,7 +20,7 @@ Build-Depends: debhelper-compat (= 13),
                perl-xs-dev,
                perl:native,
                zlib1g-dev
-Standards-Version: 4.6.2
+Standards-Version: 4.7.2
 Vcs-Browser: https://salsa.debian.org/perl-team/modules/packages/libhipi-perl
 Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libhipi-perl.git
 Homepage: https://metacpan.org/release/HiPi
@@ -46,4 +45,4 @@ Description: Raspberry Pi GPIO Perl Modu
  HiPi provides interfaces to the Raspberry Pi GPIO together with
  wrappers for some common libraries and peripherals.
  .
- Documentation and details are available at https://raspberry.znix.com .
+ Documentation and details are available at <https://www.hipiperl.com>.
diff -pruN 0.92-1/debian/copyright 0.93-1/debian/copyright
--- 0.92-1/debian/copyright	2024-03-30 23:15:40.000000000 +0000
+++ 0.93-1/debian/copyright	2025-05-11 16:42:54.000000000 +0000
@@ -4,7 +4,7 @@ Upstream-Contact: Mark Dootson <mdootson
 Source: https://metacpan.org/release/HiPi
 
 Files: *
-Copyright: 2013-2024, Mark Dootson <mdootson@cpan.org>
+Copyright: 2013-2025, Mark Dootson <mdootson@cpan.org>
 License: Artistic or GPL-1+
 
 Files: mylib/include/ppport.h
@@ -54,7 +54,7 @@ Comment: from the source of this module:
   */
 
 Files: debian/*
-Copyright: 2021-2024, gregor herrmann <gregoa@debian.org>
+Copyright: 2021-2025, gregor herrmann <gregoa@debian.org>
 License: Artistic or GPL-1+
 
 License: Artistic
diff -pruN 0.92-1/inc/Module/Build/HiPi.pm 0.93-1/inc/Module/Build/HiPi.pm
--- 0.92-1/inc/Module/Build/HiPi.pm	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/inc/Module/Build/HiPi.pm	2025-04-28 23:22:53.000000000 +0000
@@ -10,7 +10,7 @@ use Cwd;
 use File::Path;
 our @ISA = qw( Module::Build );
 
-our $VERSION ='0.92';
+our $VERSION ='0.93';
 
 sub process_xs_files {
 	my $self = shift;
@@ -165,10 +165,4 @@ sub hipi_build_xs {
     }
 }
 
-sub hipi_build_data {
-    my $self = shift;
-    require File::Copy::Recursive;
-    File::Copy::Recursive::dircopy('mylib/auto/share','blib/lib/auto/share');
-}
-
 1;
diff -pruN 0.92-1/lib/HiPi/Device/GPIO/Pin.pm 0.93-1/lib/HiPi/Device/GPIO/Pin.pm
--- 0.92-1/lib/HiPi/Device/GPIO/Pin.pm	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/lib/HiPi/Device/GPIO/Pin.pm	2025-04-28 23:22:53.000000000 +0000
@@ -2,7 +2,7 @@
 # Package        HiPi::Device::GPIO::Pin
 # Description:   Pin
 # Created        Wed Feb 20 04:37:38 2013
-# Copyright    : Copyright (c) 2013-2013 Mark Dootson
+# Copyright    : Copyright (c) 2013-2025 Mark Dootson
 # License      : This is free software; you can redistribute it and/or modify it under
 #                the same terms as the Perl 5 programming language system itself.
 #########################################################################################
@@ -18,12 +18,16 @@ use Fcntl;
 use HiPi qw( :rpi );
 use HiPi::RaspberryPi;
 
-my $pinoffset = ( HiPi::RaspberryPi::has_rp1() ) ? 399 : 0;
+my $pinoffset = _calculate_sysfs_pin_offset();
 
-our $VERSION ='0.90';
+our $VERSION ='0.93';
 
 __PACKAGE__->create_accessors();
 
+sub get_pin_offset {
+    return $pinoffset;
+}
+
 sub _open {
     my ($class, %params) = @_;
     defined($params{pinid}) or croak q(pinid not defined in parameters);
@@ -117,6 +121,17 @@ sub _do_activelow {
     }
     
     return $result;
-} 
+}
+
+sub _calculate_sysfs_pin_offset {
+    my $offset = 0;
+    {
+        my $result = qx(cat /sys/kernel/debug/gpio 2>&1 | grep 'ID_SDA');
+        if ( $result && $result =~ /gpio-([0-9]+)/ ) {
+            $offset = $1;
+        }
+    }
+    return $offset;
+}
 
 1;
diff -pruN 0.92-1/lib/HiPi/Device/GPIO.pm 0.93-1/lib/HiPi/Device/GPIO.pm
--- 0.92-1/lib/HiPi/Device/GPIO.pm	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/lib/HiPi/Device/GPIO.pm	2025-04-28 23:22:53.000000000 +0000
@@ -1,7 +1,7 @@
 #########################################################################################
 # Package        HiPi::Device::GPIO
 # Description:   Wrapper for GPIO
-# Copyright    : Copyright (c) 2013-2023 Mark Dootson
+# Copyright    : Copyright (c) 2013-2025 Mark Dootson
 # License      : This is free software; you can redistribute it and/or modify it under
 #                the same terms as the Perl 5 programming language system itself.
 #########################################################################################
@@ -18,11 +18,11 @@ use HiPi::RaspberryPi;
 use HiPi::Device::GPIO::Pin;
 use Fcntl;
 
-our $VERSION ='0.90';
+our $VERSION ='0.93';
 
 my $sysroot = '/sys/class/gpio';
 
-my $pinoffset = ( HiPi::RaspberryPi::has_rp1() ) ? 399 : 0;
+my $pinoffset = HiPi::Device::GPIO::Pin::get_pin_offset();
 
 sub new {
     my ($class, %userparams) = @_;
@@ -234,6 +234,10 @@ sub get_pin_slew {
     return undef;
 }
 
+sub get_pin_offset {
+    return $pinoffset;
+}
+
 sub _do_export {
     my ($class, $pinno ) = @_;
     my $syspin = $pinno + $pinoffset;
diff -pruN 0.92-1/lib/HiPi/Device/I2C.pm 0.93-1/lib/HiPi/Device/I2C.pm
--- 0.92-1/lib/HiPi/Device/I2C.pm	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/lib/HiPi/Device/I2C.pm	2025-04-28 23:22:53.000000000 +0000
@@ -26,7 +26,7 @@ use constant {
     I2C_RP1     => 3
 };
 
-our $VERSION ='0.92';
+our $VERSION ='0.93';
 
 __PACKAGE__->create_accessors( qw ( fh fno address busmode readmode ) );
 
diff -pruN 0.92-1/lib/HiPi/Device/SPI.pm 0.93-1/lib/HiPi/Device/SPI.pm
--- 0.92-1/lib/HiPi/Device/SPI.pm	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/lib/HiPi/Device/SPI.pm	2025-04-28 23:22:53.000000000 +0000
@@ -19,7 +19,7 @@ use XSLoader;
 use Carp;
 use HiPi qw( :rpi :spi );
 
-our $VERSION ='0.92';
+our $VERSION ='0.93';
 
 __PACKAGE__->create_accessors( qw ( fh fno delay speed bitsperword ) );
 
diff -pruN 0.92-1/lib/HiPi/GPIO.pm 0.93-1/lib/HiPi/GPIO.pm
--- 0.92-1/lib/HiPi/GPIO.pm	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/lib/HiPi/GPIO.pm	2025-04-28 23:22:53.000000000 +0000
@@ -19,7 +19,7 @@ use HiPi 0.80;
 use HiPi qw( :rpi );
 use HiPi::RaspberryPi;
 
-our $VERSION ='0.92';
+our $VERSION ='0.93';
 
 __PACKAGE__->create_accessors( );
 
diff -pruN 0.92-1/lib/HiPi/RaspberryPi.pm 0.93-1/lib/HiPi/RaspberryPi.pm
--- 0.92-1/lib/HiPi/RaspberryPi.pm	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/lib/HiPi/RaspberryPi.pm	2025-04-28 23:22:53.000000000 +0000
@@ -2,7 +2,7 @@
 # Distribution : HiPi Modules for Raspberry Pi
 # File         : lib/HiPi/RaspberryPi.pm
 # Description  : Information about host Raspberry Pi
-# Copyright    : Copyright (c) 2013-2023 Mark Dootson
+# Copyright    : Copyright (c) 2013-2024 Mark Dootson
 # License      : This is free software; you can redistribute it and/or modify it under
 #                the same terms as the Perl 5 programming language system itself.
 #########################################################################################
@@ -14,7 +14,7 @@ use strict;
 use warnings;
 use Carp;
 
-our $VERSION ='0.91';
+our $VERSION ='0.93';
 
 my ( $btype1, $btype2, $btype3, $btype4) = ( 1, 2, 3, 4 );
 
@@ -254,6 +254,7 @@ my %_revinfostash = (
         '3' => 2048,
         '4' => 4096,
         '5' => 8192,
+        '6' => 16284,
     },
     manufacturer => {
         '0' => 'Sony UK',
@@ -338,7 +339,10 @@ my %_revinfostash = (
         '20' => 'Raspberry Pi Compute Module 4',        # 14
         '21' => 'Raspberry Pi Compute Module 4S',       # 15
         '22' => 'UNKOWN Rasberry Pi Model 22',          # 16
-        '23' => 'Rasberry Pi 5',                        # 17
+        '23' => 'Rasberry Pi 5 Model B',                # 17
+        '24' => 'Rasberry Pi Compute Module 5',         # 18
+        '25' => 'Rasberry Pi Model 500',                # 19
+        '26' => 'Rasberry Pi Compute Module 5 Lite',    # 1A
     },
     board_type => {
         '0'  => $btype2,
@@ -365,6 +369,9 @@ my %_revinfostash = (
         '21' => $btype4,
         '22' => $btype3,
         '23' => $btype3,
+        '24' => $btype4,
+        '25' => $btype3,
+        '26' => $btype4,
     },
     release => {
         '0'  => 'Q1 2013',
@@ -391,6 +398,9 @@ my %_revinfostash = (
         '21' => 'Q4 2020',
         '22' => 'unknown',
         '23' => 'Q4 2023',
+        '24' => 'Q3 2024',
+        '25' => 'Q4 2024',
+        '26' => 'Q3 2024',
     },
     extended_release => {
         'a03111' => 'Q2 2019', #	4B	1.1	1GB	Sony UK
@@ -401,18 +411,31 @@ my %_revinfostash = (
         'b03114' => 'Q3 2020', #	4B	1.4	2GB	Sony UK
         'b03115' => 'Q1 2022', #	4B	1.5	2GB	Sony UK
         
+        'b04170' => 'Q3 2024', #    5B  1.0 2GB Sony UK
+        'b04171' => 'Q4 2024', #    5B  1.1 2GB Sony UK
+        
         'c03111' => 'Q2 2019', # 	4B	1.1	4GB	Sony UK
         'c03112' => 'Q1 2020', #	4B	1.2	4GB	Sony UK
         'c03114' => 'Q2 2020', #	4B	1.4	4GB	Sony UK
         'c03115' => 'Q1 2022', #	4B	1.5	4GB	Sony UK
         
+        'c03130' => 'Q3 2020', #    400 1.0 4GB Sony UK
+        
         'c04170' => 'Q4 2023', #	5B	1.0	4GB	Sony UK
+        'c04171' => 'Q4 2023', #	5B	1.1	4GB	Sony UK
         
         'd03114' => 'Q2 2020', #	4B	1.4	8GB	Sony UK
         'd03115' => 'Q1 2022', #	4B	1.5	8GB	Sony UK
         
         'd04170' => 'Q4 2023', #	5B	1.0	8GB	Sony UK
+        'd04171' => 'Q4 2024', #	5B	1.1	8GB	Sony UK
+        
+        
+        'd04190' => 'Q4 2024', #    500 1.0 8GB Sony UK
+        
+        'e04171' => 'Q1 2025', #    5B  1.1 16GB Sony UK
     },
+        
 );
 
 my $_config = $_revstash{unknownex};
@@ -628,7 +651,7 @@ sub _configure {
             $_config->{processor} = 'BCM2835';
             $_config->{revisionnumber} = 0;
             $_config->{processor_info} = $_revinfostash{processor_info}->{'BCM2835'};
-            $israspberry = exists($_revstash{$rev}) ? 1 : 0;
+            $israspberry1 = $israspberry = exists($_revstash{$rev}) ? 1 : 0;
         }
         
     }    
diff -pruN 0.92-1/lib/HiPi/Utils/Exec.pm 0.93-1/lib/HiPi/Utils/Exec.pm
--- 0.92-1/lib/HiPi/Utils/Exec.pm	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/lib/HiPi/Utils/Exec.pm	2025-04-28 23:22:53.000000000 +0000
@@ -23,7 +23,7 @@ use HiPi;
 
 __PACKAGE__->create_accessors( qw( workingdir sourceperl outputexec ) );
 
-our $VERSION ='0.92';
+our $VERSION ='0.93';
 
 XSLoader::load('HiPi::Utils::Exec', $VERSION) if HiPi::is_raspberry_pi();
 
diff -pruN 0.92-1/lib/HiPi/Utils.pm 0.93-1/lib/HiPi/Utils.pm
--- 0.92-1/lib/HiPi/Utils.pm	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/lib/HiPi/Utils.pm	2025-04-28 23:22:53.000000000 +0000
@@ -21,7 +21,7 @@ use XSLoader;
 use HiPi qw( :rpi );
 use HiPi::RaspberryPi;
 
-our $VERSION ='0.92';
+our $VERSION ='0.93';
 
 our $defaultuser = 'pi';
 
@@ -38,8 +38,11 @@ our @EXPORT_OK = qw(
     is_unix
     is_raspberry
     is_mac
+    is_raspberry_1
     is_raspberry_2
     is_raspberry_3
+    is_raspberry_4
+    is_raspberry_5
     uses_device_tree
     system_type
 );
@@ -47,8 +50,11 @@ our @EXPORT_OK = qw(
 our %EXPORT_TAGS = ( all => \@EXPORT_OK );
 
 sub is_raspberry { HiPi::RaspberryPi::is_raspberry; }
-sub is_raspberry_2 { HiPi::RaspberryPi::is_raspberry; }
-sub is_raspberry_3 { HiPi::RaspberryPi::is_raspberry_2; }
+sub is_raspberry_1 { HiPi::RaspberryPi::is_raspberry_1; }
+sub is_raspberry_2 { HiPi::RaspberryPi::is_raspberry_2; }
+sub is_raspberry_3 { HiPi::RaspberryPi::is_raspberry_3; }
+sub is_raspberry_4 { HiPi::RaspberryPi::is_raspberry_4; }
+sub is_raspberry_5 { HiPi::RaspberryPi::is_raspberry_5; }
 sub uses_device_tree { HiPi::RaspberryPi::has_device_tree; }
 sub is_windows { HiPi::RaspberryPi::os_is_windows; }
 sub is_mac { HiPi::RaspberryPi::os_is_osx; }
diff -pruN 0.92-1/lib/HiPi.pm 0.93-1/lib/HiPi.pm
--- 0.92-1/lib/HiPi.pm	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/lib/HiPi.pm	2025-04-28 23:22:53.000000000 +0000
@@ -2,7 +2,7 @@
 # Distribution : HiPi Modules for Raspberry Pi
 # File         : lib/HiPi.pm
 # Description  : Pepi module for Raspberry Pi
-# Copyright    : Copyright (c) 2013-2023 Mark Dootson
+# Copyright    : Copyright (c) 2013-2025 Mark Dootson
 # License      : This is free software; you can redistribute it and/or modify it under
 #                the same terms as the Perl 5 programming language system itself.
 #########################################################################################
@@ -19,7 +19,7 @@ use constant hipi_export_constants();
 use Scalar::Util qw( weaken isweak refaddr );
 use Carp;
 
-our $VERSION ='0.92';
+our $VERSION ='0.93';
 
 our @EXPORT_OK = hipi_export_ok();
 our %EXPORT_TAGS = hipi_export_tags();
@@ -204,7 +204,7 @@ peripherals.
 
 Documentation and details are available at
 
-L<https://raspberry.znix.com>
+L<https://www.hipiperl.com>
 
 =head1 AUTHOR
 
@@ -212,7 +212,7 @@ Mark Dootson, C<< mdootson@cpan.org >>.
 
 =head1 COPYRIGHT
 
-Copyright (c) 2013 - 2023 Mark Dootson
+Copyright (c) 2013 - 2024 Mark Dootson
 
 =cut
 
diff -pruN 0.92-1/t/040-sysfs.t 0.93-1/t/040-sysfs.t
--- 0.92-1/t/040-sysfs.t	2024-03-28 19:36:08.000000000 +0000
+++ 0.93-1/t/040-sysfs.t	2025-04-28 23:22:53.000000000 +0000
@@ -9,14 +9,17 @@ my $sleepwait = 5000;
 
 SKIP: {
       skip 'not in dist testing', 45 unless ( $ENV{HIPI_MODULES_DIST_TEST_SYSFS} );
-
-my $syspin36 = HiPi::RaspberryPi::has_rp1() ? RPI_PIN_36 + 399 : RPI_PIN_36;
-my $syspin37 = HiPi::RaspberryPi::has_rp1() ? RPI_PIN_37 + 399 : RPI_PIN_37;
       
 diag('DEVICE GPIO (sysfs) tests are running');
 
 use_ok( 'HiPi::Device::GPIO' );
 
+my $syspin36 = RPI_PIN_36 + HiPi::Device::GPIO::get_pin_offset();
+my $syspin37 = RPI_PIN_37 + HiPi::Device::GPIO::get_pin_offset();
+
+diag('SYSPIN 36 IS ' . $syspin36);
+diag('SYSPIN 37 IS ' . $syspin37);
+
 my $gpio = HiPi::Device::GPIO->new;
 
 $gpio->unexport_all;
