diff -pruN 1.23-1/Changes 1.24-1/Changes
--- 1.23-1/Changes	2022-08-18 12:02:23.000000000 +0000
+++ 1.24-1/Changes	2025-05-21 09:31:31.000000000 +0000
@@ -1,5 +1,9 @@
 Revision history for Business::Tax::VAT::Validation
 
+1.24  21/05/2025
+    - Belgian numbers can start with 0 or 1 (@pottenmak, @jonmz, PR #14, GH #18)
+    - Fix VIES FAQ / Companies House API links (thanks @robrwo)
+
 1.23  18/08/2022
     - Further updates because of API changes - expect name & address elements
       to be namespaced too (thanks to Thomas Glase)
diff -pruN 1.23-1/META.json 1.24-1/META.json
--- 1.23-1/META.json	2022-08-18 12:03:00.000000000 +0000
+++ 1.24-1/META.json	2025-05-21 09:34:38.000000000 +0000
@@ -49,6 +49,6 @@
          "url" : "https://github.com/bigpresh/Business-Tax-VAT-Validation"
       }
    },
-   "version" : "1.23",
+   "version" : "1.24",
    "x_serialization_backend" : "JSON::PP version 4.04"
 }
diff -pruN 1.23-1/META.yml 1.24-1/META.yml
--- 1.23-1/META.yml	2022-08-18 12:03:00.000000000 +0000
+++ 1.24-1/META.yml	2025-05-21 09:34:38.000000000 +0000
@@ -26,5 +26,5 @@ resources:
   bugtracker: https://github.com/bigpresh/Business-Tax-VAT-Validation/issues
   homepage: https://github.com/bigpresh/Business-Tax-VAT-Validation/
   repository: https://github.com/bigpresh/Business-Tax-VAT-Validation
-version: '1.23'
+version: '1.24'
 x_serialization_backend: 'CPAN::Meta::YAML version 0.018'
diff -pruN 1.23-1/debian/changelog 1.24-1/debian/changelog
--- 1.23-1/debian/changelog	2022-08-21 14:30:12.000000000 +0000
+++ 1.24-1/debian/changelog	2025-05-25 15:38:41.000000000 +0000
@@ -1,3 +1,15 @@
+libbusiness-tax-vat-validation-perl (1.24-1) unstable; urgency=medium
+
+  [ Debian Janitor ]
+  * Update standards version to 4.6.2, no changes needed.
+
+  [ gregor herrmann ]
+  * Import upstream version 1.24.
+  * Update years of packaging copyright.
+  * Declare compliance with Debian Policy 4.7.2.
+
+ -- gregor herrmann <gregoa@debian.org>  Sun, 25 May 2025 17:38:41 +0200
+
 libbusiness-tax-vat-validation-perl (1.23-1) unstable; urgency=medium
 
   * Import upstream version 1.23.
diff -pruN 1.23-1/debian/control 1.24-1/debian/control
--- 1.23-1/debian/control	2022-08-21 14:30:12.000000000 +0000
+++ 1.24-1/debian/control	2025-05-25 15:38:41.000000000 +0000
@@ -13,7 +13,7 @@ Build-Depends-Indep: libhttp-message-per
                      libtest-pod-perl <!nocheck>,
                      libwww-perl <!nocheck>,
                      perl
-Standards-Version: 4.6.1
+Standards-Version: 4.7.2
 Vcs-Browser: https://salsa.debian.org/perl-team/modules/packages/libbusiness-tax-vat-validation-perl
 Vcs-Git: https://salsa.debian.org/perl-team/modules/packages/libbusiness-tax-vat-validation-perl.git
 Homepage: https://metacpan.org/release/Business-Tax-VAT-Validation
diff -pruN 1.23-1/debian/copyright 1.24-1/debian/copyright
--- 1.23-1/debian/copyright	2022-08-21 14:30:12.000000000 +0000
+++ 1.24-1/debian/copyright	2025-05-25 15:38:41.000000000 +0000
@@ -10,7 +10,7 @@ License: GPL-3+
 
 Files: debian/*
 Copyright: 2009, Ernesto Hernández-Novich (USB) <emhn@usb.ve>
- 2011-2022, gregor herrmann <gregoa@debian.org>
+ 2011-2025, gregor herrmann <gregoa@debian.org>
  2012, Fabrizio Regalli <fabreg@fabreg.it>
  2013, Xavier Guimard <yadd@debian.org>
 License: GPL-3+
diff -pruN 1.23-1/lib/Business/Tax/VAT/Validation.pm 1.24-1/lib/Business/Tax/VAT/Validation.pm
--- 1.23-1/lib/Business/Tax/VAT/Validation.pm	2022-08-18 12:02:34.000000000 +0000
+++ 1.24-1/lib/Business/Tax/VAT/Validation.pm	2025-05-21 09:29:41.000000000 +0000
@@ -29,7 +29,7 @@ package Business::Tax::VAT::Validation;
 use strict;
 use warnings;
 
-our $VERSION = '1.23';
+our $VERSION = '1.24';
 
 use HTTP::Request::Common qw(POST);
 use LWP::UserAgent;
@@ -93,7 +93,7 @@ sub new {
         re           => {
             ### t/01_localcheck.t tests if these regexps accepts all regular VAT numbers, according to VIES FAQ
             AT => 'U[0-9]{8}',
-            BE => '0[0-9]{9}',
+            BE => '[01][0-9]{9}',
             BG => '[0-9]{9,10}',
             CY => '[0-9]{8}[A-Za-z]',
             CZ => '[0-9]{8,10}',
@@ -488,10 +488,9 @@ sub _set_error {
 
 LWP::UserAgent
 
-L<http://ec.europa.eu/taxation_customs/vies/faqvies.do> for the FAQs related to the VIES service.
+L<https://ec.europa.eu/taxation_customs/vies/#/faq> for the FAQs related to the VIES service.
 
-L<https://developer.service.hmrc.gov.uk/api-documentation/docs/api/service/vat-registered-companies-api/1.0>
-for details of the service provided by the UK's HMRC.
+L<https://www.api.gov.uk/ch/companies-house> for details of the service provided by the UK's HMRC.
 
 =head1 FEEDBACK
 
diff -pruN 1.23-1/t/02_local_check_nok.t 1.24-1/t/02_local_check_nok.t
--- 1.23-1/t/02_local_check_nok.t	2008-01-03 13:26:04.000000000 +0000
+++ 1.24-1/t/02_local_check_nok.t	2025-05-21 09:33:34.000000000 +0000
@@ -4,7 +4,7 @@ use Test;
 
 my %local_checks = (
     AT      =>  ['V12345678', '123456789', 'U1234567', 'U123456789'],
-    BE      =>  ['1234567890', '012345678', '123456789', '012345678L'],
+    BE      =>  ['2234567890', '012345678', '123456789', '012345678L'],
     BG      =>  ['12345678', '12345678901', '012345678L'],
     CY      =>  ['12345678', '1234567A', '123456789A'],
     CZ	    =>  ['1234567', '12345678901', '123456A890'],
