diff -pruN 0.15.6-1/CHANGELOG.rst 0.15.8-1/CHANGELOG.rst
--- 0.15.6-1/CHANGELOG.rst	2024-03-23 20:31:09.000000000 +0000
+++ 0.15.8-1/CHANGELOG.rst	2024-07-29 19:00:11.000000000 +0000
@@ -1,6 +1,18 @@
 django-python3-ldap changelog
 =============================
 
+0.15.8
+------
+
+- Added ``LDAP_AUTH_TLS_CIPHERS``, ``LDAP_AUTH_TLS_ARGS``, ``LDAP_AUTH_CONNECT_USE_SSL`` and ``LDAP_AUTH_CONNECT_ARGS`` settings (@Freddo3000).
+
+
+0.15.7
+------
+
+- Added ``LDAP_AUTH_POOL_ACTIVE`` setting (@borislaviv).
+
+
 0.15.6
 ------
 
diff -pruN 0.15.6-1/PKG-INFO 0.15.8-1/PKG-INFO
--- 0.15.6-1/PKG-INFO	2024-03-23 20:31:18.205101700 +0000
+++ 0.15.8-1/PKG-INFO	2024-07-29 19:00:20.407733000 +0000
@@ -1,6 +1,6 @@
 Metadata-Version: 2.1
 Name: django-python3-ldap
-Version: 0.15.6
+Version: 0.15.8
 Summary: Django LDAP user authentication backend for Python 3.
 Home-page: https://github.com/etianen/django-python3-ldap
 Author: Dave Hall
@@ -64,6 +64,12 @@ Available settings
     import ssl
     LDAP_AUTH_TLS_VERSION = ssl.PROTOCOL_TLSv1_2
 
+    # Specify which TLS ciphers to use.
+    LDAP_AUTH_TLS_CIPHERS = "ALL"
+
+    # Unspecified TLS keyword arguments applied to the connection on the underlying `ldap3` library.
+    LDAP_AUTH_TLS_ARGS = {}
+
     # The LDAP search base for looking up users.
     LDAP_AUTH_SEARCH_BASE = "ou=people,dc=example,dc=com"
 
@@ -113,10 +119,18 @@ Available settings
     LDAP_AUTH_CONNECTION_USERNAME = None
     LDAP_AUTH_CONNECTION_PASSWORD = None
 
+    # Use SSL on the connection.
+    LDAP_AUTH_CONNECT_USE_SSL = False
+
     # Set connection/receive timeouts (in seconds) on the underlying `ldap3` library.
     LDAP_AUTH_CONNECT_TIMEOUT = None
     LDAP_AUTH_RECEIVE_TIMEOUT = None
 
+    # Unspecified keyword arguments to apply to the connection in the underlying `ldap3` library.
+    LDAP_AUTH_CONNECT_ARGS = {}
+
+    # Set connection pool `active` parameter on the underlying `ldap3` library.
+    LDAP_AUTH_POOL_ACTIVE = True
 
 Microsoft Active Directory support
 ----------------------------------
diff -pruN 0.15.6-1/README.rst 0.15.8-1/README.rst
--- 0.15.6-1/README.rst	2024-03-23 20:31:09.000000000 +0000
+++ 0.15.8-1/README.rst	2024-07-29 19:00:11.000000000 +0000
@@ -41,6 +41,12 @@ Available settings
     import ssl
     LDAP_AUTH_TLS_VERSION = ssl.PROTOCOL_TLSv1_2
 
+    # Specify which TLS ciphers to use.
+    LDAP_AUTH_TLS_CIPHERS = "ALL"
+
+    # Unspecified TLS keyword arguments applied to the connection on the underlying `ldap3` library.
+    LDAP_AUTH_TLS_ARGS = {}
+
     # The LDAP search base for looking up users.
     LDAP_AUTH_SEARCH_BASE = "ou=people,dc=example,dc=com"
 
@@ -90,10 +96,18 @@ Available settings
     LDAP_AUTH_CONNECTION_USERNAME = None
     LDAP_AUTH_CONNECTION_PASSWORD = None
 
+    # Use SSL on the connection.
+    LDAP_AUTH_CONNECT_USE_SSL = False
+
     # Set connection/receive timeouts (in seconds) on the underlying `ldap3` library.
     LDAP_AUTH_CONNECT_TIMEOUT = None
     LDAP_AUTH_RECEIVE_TIMEOUT = None
 
+    # Unspecified keyword arguments to apply to the connection in the underlying `ldap3` library.
+    LDAP_AUTH_CONNECT_ARGS = {}
+
+    # Set connection pool `active` parameter on the underlying `ldap3` library.
+    LDAP_AUTH_POOL_ACTIVE = True
 
 Microsoft Active Directory support
 ----------------------------------
diff -pruN 0.15.6-1/debian/changelog 0.15.8-1/debian/changelog
--- 0.15.6-1/debian/changelog	2024-07-20 20:34:03.000000000 +0000
+++ 0.15.8-1/debian/changelog	2024-12-21 20:03:14.000000000 +0000
@@ -1,3 +1,11 @@
+django-python3-ldap (0.15.8-1) unstable; urgency=medium
+
+  * Team Upload
+  * Fix d/watch for new PyPi archive naming policy
+  * New upstream version 0.15.8
+
+ -- Alexandre Detiste <tchet@debian.org>  Sat, 21 Dec 2024 21:03:14 +0100
+
 django-python3-ldap (0.15.6-1) unstable; urgency=low
 
   [ Debian Janitor ]
diff -pruN 0.15.6-1/debian/rules 0.15.8-1/debian/rules
--- 0.15.6-1/debian/rules	2024-07-20 20:34:03.000000000 +0000
+++ 0.15.8-1/debian/rules	2024-12-21 19:20:01.000000000 +0000
@@ -7,4 +7,4 @@ export PYBUILD_NAME=django-python3-ldap
 export PYBUILD_DISABLE=test
 
 %:
-	dh $@ --with python3 --buildsystem=pybuild
+	dh $@ --buildsystem=pybuild
diff -pruN 0.15.6-1/debian/watch 0.15.8-1/debian/watch
--- 0.15.6-1/debian/watch	2024-07-20 20:34:03.000000000 +0000
+++ 0.15.8-1/debian/watch	2024-12-21 19:20:46.000000000 +0000
@@ -1,3 +1,3 @@
 version=4
 opts=uversionmangle=s/(rc|a|b|c)/~$1/ \
-https://pypi.debian.net/django-python3-ldap/django-python3-ldap-(.+)\.(?:zip|tgz|tbz|txz|(?:tar\.(?:gz|bz2|xz)))
+https://pypi.debian.net/django-python3-ldap/django_python3_ldap-(.+)\.(?:zip|tgz|tbz|txz|(?:tar\.(?:gz|bz2|xz)))
diff -pruN 0.15.6-1/django_python3_ldap/__init__.py 0.15.8-1/django_python3_ldap/__init__.py
--- 0.15.6-1/django_python3_ldap/__init__.py	2024-03-23 20:31:09.000000000 +0000
+++ 0.15.8-1/django_python3_ldap/__init__.py	2024-07-29 19:00:11.000000000 +0000
@@ -2,5 +2,4 @@
 Django LDAP user authentication backend for Python 3.
 """
 
-
-__version__ = (0, 15, 6)
+__version__ = (0, 15, 8)
diff -pruN 0.15.6-1/django_python3_ldap/conf.py 0.15.8-1/django_python3_ldap/conf.py
--- 0.15.6-1/django_python3_ldap/conf.py	2024-03-23 20:31:09.000000000 +0000
+++ 0.15.8-1/django_python3_ldap/conf.py	2024-07-29 19:00:11.000000000 +0000
@@ -44,11 +44,21 @@ class LazySettings(object):
         default=False,
     )
 
+    LDAP_AUTH_TLS_CIPHERS = LazySetting(
+        name="LDAP_AUTH_TLS_CIPHERS",
+        default="ALL",
+    )
+
     LDAP_AUTH_TLS_VERSION = LazySetting(
         name="LDAP_AUTH_TLS_VERSION",
         default=PROTOCOL_TLS,
     )
 
+    LDAP_AUTH_TLS_ARGS = LazySetting(
+        name="LDAP_AUTH_TLS_ARGS",
+        default={},
+    )
+
     LDAP_AUTH_SEARCH_BASE = LazySetting(
         name="LDAP_AUTH_SEARCH_BASE",
         default="ou=people,dc=example,dc=com",
@@ -126,6 +136,16 @@ class LazySettings(object):
         default=None,
     )
 
+    LDAP_AUTH_CONNECT_ARGS = LazySetting(
+        name="LDAP_AUTH_CONNECT_ARGS",
+        default={},
+    )
+
+    LDAP_AUTH_CONNECT_USE_SSL = LazySetting(
+        name="LDAP_AUTH_CONNECT_USE_SSL",
+        default=False,
+    )
+
     LDAP_AUTH_CONNECT_TIMEOUT = LazySetting(
         name="LDAP_AUTH_CONNECT_TIMEOUT",
         default=None
@@ -136,5 +156,10 @@ class LazySettings(object):
         default=None
     )
 
+    LDAP_AUTH_POOL_ACTIVE = LazySetting(
+        name="LDAP_AUTH_POOL_ACTIVE",
+        default=True
+    )
+
 
 settings = LazySettings(settings)
diff -pruN 0.15.6-1/django_python3_ldap/ldap.py 0.15.8-1/django_python3_ldap/ldap.py
--- 0.15.6-1/django_python3_ldap/ldap.py	2024-03-23 20:31:09.000000000 +0000
+++ 0.15.8-1/django_python3_ldap/ldap.py	2024-07-29 19:00:11.000000000 +0000
@@ -162,7 +162,11 @@ def connection(**kwargs):
         password = kwargs.pop("password")
         username = format_username(kwargs)
     # Build server pool
-    server_pool = ldap3.ServerPool(None, ldap3.RANDOM, active=True, exhaust=5)
+    server_pool = ldap3.ServerPool(
+        None, ldap3.RANDOM,
+        active=settings.LDAP_AUTH_POOL_ACTIVE,
+        exhaust=5
+    )
     auth_url = settings.LDAP_AUTH_URL
     if not isinstance(auth_url, list):
         auth_url = [auth_url]
@@ -172,11 +176,14 @@ def connection(**kwargs):
             "allowed_referral_hosts": [("*", True)],
             "get_info": ldap3.NONE,
             "connect_timeout": settings.LDAP_AUTH_CONNECT_TIMEOUT,
+            "use_ssl": settings.LDAP_AUTH_CONNECT_USE_SSL,
+            **settings.LDAP_AUTH_CONNECT_ARGS
         }
         if settings.LDAP_AUTH_USE_TLS:
             server_args["tls"] = ldap3.Tls(
-                ciphers="ALL",
+                ciphers=settings.LDAP_AUTH_TLS_CIPHERS,
                 version=settings.LDAP_AUTH_TLS_VERSION,
+                **settings.LDAP_AUTH_TLS_ARGS
             )
         server_pool.add(
             ldap3.Server(
diff -pruN 0.15.6-1/django_python3_ldap/tests.py 0.15.8-1/django_python3_ldap/tests.py
--- 0.15.6-1/django_python3_ldap/tests.py	2024-03-23 20:31:09.000000000 +0000
+++ 0.15.8-1/django_python3_ldap/tests.py	2024-07-29 19:00:11.000000000 +0000
@@ -149,6 +149,18 @@ class TestLdap(TestCase):
             )
             self.assertIs(user, None)
 
+    def testAuthenticateWithLimitedRetries(self):
+        # simulate offline server
+        with self.settings(
+            LDAP_AUTH_URL=["ldap://example.com:389"],
+            LDAP_AUTH_POOL_ACTIVE=1,
+        ):
+            user = authenticate(
+                username=settings.LDAP_AUTH_TEST_USER_USERNAME,
+                password=settings.LDAP_AUTH_TEST_USER_PASSWORD,
+            )
+        self.assertEqual(user, None)
+
     # User synchronisation.
 
     def testSyncUsersCreatesUsers(self):
diff -pruN 0.15.6-1/django_python3_ldap.egg-info/PKG-INFO 0.15.8-1/django_python3_ldap.egg-info/PKG-INFO
--- 0.15.6-1/django_python3_ldap.egg-info/PKG-INFO	2024-03-23 20:31:18.000000000 +0000
+++ 0.15.8-1/django_python3_ldap.egg-info/PKG-INFO	2024-07-29 19:00:20.000000000 +0000
@@ -1,6 +1,6 @@
 Metadata-Version: 2.1
 Name: django-python3-ldap
-Version: 0.15.6
+Version: 0.15.8
 Summary: Django LDAP user authentication backend for Python 3.
 Home-page: https://github.com/etianen/django-python3-ldap
 Author: Dave Hall
@@ -64,6 +64,12 @@ Available settings
     import ssl
     LDAP_AUTH_TLS_VERSION = ssl.PROTOCOL_TLSv1_2
 
+    # Specify which TLS ciphers to use.
+    LDAP_AUTH_TLS_CIPHERS = "ALL"
+
+    # Unspecified TLS keyword arguments applied to the connection on the underlying `ldap3` library.
+    LDAP_AUTH_TLS_ARGS = {}
+
     # The LDAP search base for looking up users.
     LDAP_AUTH_SEARCH_BASE = "ou=people,dc=example,dc=com"
 
@@ -113,10 +119,18 @@ Available settings
     LDAP_AUTH_CONNECTION_USERNAME = None
     LDAP_AUTH_CONNECTION_PASSWORD = None
 
+    # Use SSL on the connection.
+    LDAP_AUTH_CONNECT_USE_SSL = False
+
     # Set connection/receive timeouts (in seconds) on the underlying `ldap3` library.
     LDAP_AUTH_CONNECT_TIMEOUT = None
     LDAP_AUTH_RECEIVE_TIMEOUT = None
 
+    # Unspecified keyword arguments to apply to the connection in the underlying `ldap3` library.
+    LDAP_AUTH_CONNECT_ARGS = {}
+
+    # Set connection pool `active` parameter on the underlying `ldap3` library.
+    LDAP_AUTH_POOL_ACTIVE = True
 
 Microsoft Active Directory support
 ----------------------------------
