diff -pruN 5.3.5+dfsg-1/debian/changelog 5.3.5+dfsg-4/debian/changelog
--- 5.3.5+dfsg-1/debian/changelog	2025-04-06 08:11:09.000000000 +0000
+++ 5.3.5+dfsg-4/debian/changelog	2025-05-04 19:36:43.000000000 +0000
@@ -1,3 +1,29 @@
+bootstrap-html (5.3.5+dfsg-4) sid; urgency=medium
+
+  * Also building bootstrap-utilities.css.
+  * Switching from sassc to esbuild to minify css.
+  * Stripping internal sourcemap in css files (sassc always includes
+    internal sourcemaps eventhough external sourcemaps are generated
+    alongside, resulting in uneeded size-increased files).
+
+ -- Daniel Baumann <daniel@debian.org>  Sun, 04 May 2025 21:36:43 +0200
+
+bootstrap-html (5.3.5+dfsg-3) sid; urgency=medium
+
+  * Wrap and sorting debian files.
+  * Regrouping rules for better readability.
+  * Switching from terser to esbuild to minify javascript.
+  * Building bootstrap esm versions (Closes: #1104445).
+  * Removing breaks/replaces against interim version, not needed anymore.
+
+ -- Daniel Baumann <daniel@debian.org>  Sun, 04 May 2025 20:11:47 +0200
+
+bootstrap-html (5.3.5+dfsg-2) sid; urgency=medium
+
+  * Simplifying watch file.
+
+ -- Daniel Baumann <daniel@debian.org>  Fri, 02 May 2025 13:06:20 +0200
+
 bootstrap-html (5.3.5+dfsg-1) sid; urgency=medium
 
   * Merging upstream version 5.3.5+dfsg.
diff -pruN 5.3.5+dfsg-1/debian/control 5.3.5+dfsg-4/debian/control
--- 5.3.5+dfsg-1/debian/control	2025-04-06 07:55:23.000000000 +0000
+++ 5.3.5+dfsg-4/debian/control	2025-05-04 18:11:04.000000000 +0000
@@ -5,6 +5,7 @@ Maintainer: Daniel Baumann <daniel@debia
 Build-Depends:
  debhelper-compat (= 13),
  dh-sequence-nodejs,
+ esbuild,
  node-autoprefixer,
  node-babel7,
  node-less,
@@ -16,7 +17,6 @@ Build-Depends:
  node-source-map,
  rollup,
  sassc,
- terser,
 Rules-Requires-Root: no
 Standards-Version: 4.7.2
 Homepage: https://getbootstrap.com
@@ -60,10 +60,8 @@ Depends:
  libjs-bootstrap5 (= ${source:Version}),
  ${misc:Depends},
 Breaks:
- libjs-bootstrap5 (<< 5.2.3+dfsg-8~),
  libjs-bootstrap4,
 Replaces:
- libjs-bootstrap5 (<< 5.2.3+dfsg-8~),
  libjs-bootstrap4,
 Provides:
  sass-stylesheets-bootstrap,
diff -pruN 5.3.5+dfsg-1/debian/rules 5.3.5+dfsg-4/debian/rules
--- 5.3.5+dfsg-1/debian/rules	2025-04-06 07:55:23.000000000 +0000
+++ 5.3.5+dfsg-4/debian/rules	2025-05-04 19:36:38.000000000 +0000
@@ -9,29 +9,46 @@ execute_after_dh_auto_clean:
 	rm -rf dist js/dist
 
 override_dh_auto_build:
-	mkdir -p dist/css dist/js dist/tmp
+	# bootstrap.css
+	mkdir -p dist/css dist/tmp
 
 	sassc --sourcemap=auto scss/bootstrap.scss dist/tmp/bootstrap.css
 	sassc --sourcemap=auto scss/bootstrap-grid.scss dist/tmp/bootstrap-grid.css
 	sassc --sourcemap=auto scss/bootstrap-reboot.scss dist/tmp/bootstrap-reboot.css
+	sassc --sourcemap=auto scss/bootstrap-utilities.scss dist/tmp/bootstrap-utilities.css
 
 	postcss --config build/postcss.config.js --replace 'dist/tmp/*.css' '!dist/tmp/*.min.css'
 
+	for FILE in dist/tmp/*.css; \
+	do \
+		sed -i -e "s|\(sourceMappingURL\)=data.*|\1=$$(basename $${FILE}).map \*/|" $${FILE}; \
+	done
+
 	cp -v dist/tmp/*.css dist/css/
 	cp -v dist/tmp/*.css.map dist/css/
 
-	sassc --sourcemap=auto --style compressed dist/tmp/bootstrap.css dist/css/bootstrap.min.css
-	sassc --sourcemap=auto --style compressed dist/tmp/bootstrap-grid.css dist/css/bootstrap-grid.min.css
-	sassc --sourcemap=auto --style compressed dist/tmp/bootstrap-reboot.css dist/css/bootstrap-reboot.min.css
+	esbuild dist/css/bootstrap.css --sourcemap --outfile=dist/css/bootstrap.min.css --minify
+	esbuild dist/css/bootstrap-grid.css --sourcemap --outfile=dist/css/bootstrap-grid.min.css --minify
+	esbuild dist/css/bootstrap-reboot.css --sourcemap --outfile=dist/css/bootstrap-reboot.min.css --minify
+	esbuild dist/css/bootstrap-utilities.css --sourcemap --outfile=dist/css/bootstrap-utilities.min.css --minify
 
 	rm -rf dist/tmp
 
+	# bootstrap plugins
+	mkdir -p dist/js
 	NODE_PATH=node_modules node build/build-plugins.mjs
-	NODE_PATH=node_modules rollup --sourcemap --environment BUNDLE:true --config build/rollup.config.mjs
+
+	# bootstrap.js
 	NODE_PATH=node_modules rollup --sourcemap --environment BUNDLE:false --config build/rollup.config.mjs
+	esbuild dist/js/bootstrap.js --sourcemap --outfile=dist/js/bootstrap.min.js --minify
+
+	# bootstrap.bundle.js
+	NODE_PATH=node_modules rollup --sourcemap --environment BUNDLE:true --config build/rollup.config.mjs
+	esbuild dist/js/bootstrap.bundle.js --sourcemap --outfile=dist/js/bootstrap.bundle.min.js --minify
 
-	cd dist/js && terser --compress --mangle --comments "/^!" --source-map content=bootstrap.bundle.js.map,includeSources,url=bootstrap.bundle.min.js.map -o bootstrap.bundle.min.js bootstrap.bundle.js
-	cd dist/js && terser --compress --mangle --comments "/^!" --source-map content=bootstrap.js.map,includeSources,url=bootstrap.min.js.map -o bootstrap.min.js bootstrap.js
+	# bootstrap.esm.js
+	esbuild js/index.esm.js --bundle --sourcemap --outfile=dist/js/bootstrap.esm.js
+	esbuild dist/js/bootstrap.esm.js --sourcemap --outfile=dist/js/bootstrap.esm.min.js --minify
 
 override_dh_auto_install:
 	# disabled
diff -pruN 5.3.5+dfsg-1/debian/watch 5.3.5+dfsg-4/debian/watch
--- 5.3.5+dfsg-1/debian/watch	2025-04-06 07:55:23.000000000 +0000
+++ 5.3.5+dfsg-4/debian/watch	2025-04-23 06:20:33.000000000 +0000
@@ -1,5 +1,3 @@
 version=4
-opts="filenamemangle=s/.+\/v?(\d\S+)\.tar\.gz/bootstrap-$1\.tar\.gz/, \
- uversionmangle=s/(\d)\-?((alpha|beta)\d*)$/$1~$2/, \
- dversionmangle=s/\+dfsg//" \
-https://github.com/twbs/bootstrap/tags .*/v?(\d\S+)\.tar\.gz
+opts="dversionmangle=s/\+dfsg//, uversionmangle=s/(\d)\-?((alpha|beta)\d*)$/$1~$2/" \
+https://github.com/twbs/bootstrap/tags .*/v?(\d.*)@ARCHIVE_EXT@
